<?php
require_once("check.php");
require_once("config.php");
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="viewport" content="width=device-width,initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no,minimal-ui"/>
<meta name="apple-mobile-web-app-capable" content="yes"/>
<meta name="apple-touch-fullscreen" content="yes"/>     
<meta name="apple-mobile-web-app-title" content=""/>
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
<meta name="format-detection" content="telephone=no"/>
<meta name="format-detection" content="address=no"/>
<meta name="screen-orientation" content="portrait"/>
<meta name="full-screen" content="yes"/>
<meta name="browsermode" content="application"/>
<meta name="x5-orientation" content="portrait"/>
<meta name="x5-fullscreen" content="true"/>
<meta name="x5-page-mode" content="app"/>
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/manage.js"></script>
<script src="js/city/picker.min.js"></script>
<script src="js/city/city.js"></script>
<style>
html{font-size: 35%;}
body{
    font-size:35%;
    margin:0;
    padding:0;
    margin-left:auto;
    margin-right:auto;
    text-align:center;
    background-color: #FFFFFF;
    background-size:cover;
}
a{
    text-decoration:none;
    color: #8A8A8A;
}
#head{
    width:10rem;
    height:1rem;
    margin-left:auto;
    margin-right:auto;
}
#header{
    position: fixed;
    top:0;
    left:50%;
    margin:0 0 0 -5rem;
    text-align:left;
    display:table;
    width:10rem;
    height:1rem;
    line-height:1rem;

    font-size:0.32rem;
    color: #4C4C4C;
    letter-spacing: 1px;
    background: #F1F1F1;
    border-bottom:2px solid #D8D8D8;


}
#header .title{
    text-align:center;
    float:left;
    width:2.5rem;
    height:1rem;
    font-size:0.32rem;
    line-height:1rem;
    color: #4C4C4C;
}
#header .headback{
    text-align:center;
    float:right;
    width:1.8rem;
    height:1rem;
    font-size:0.32rem;
    line-height:1rem;
    color: #4C4C4C;
}

#dlalert{
    display: none;
    position: fixed;
    width:6rem;
    height:1.2rem;
    line-height:1.2rem;
    background: #3E3E3E;
    left:50%;
    top:50%;
    margin-left: -3rem;
    margin-top:-0.6rem;
    border-radius:5px;
    font-size:0.36rem;
    color:#FFFFFF;
}
#go{
    margin-top:0.2rem;
    width:9.5rem;
    height:1.2rem;
    line-height:1.2rem;
    margin-left:auto;
    margin-right:auto;
    font-size:0.36rem;
    color:#FFFFFF;
    background: #FF3333;

}
.title{
    width:9.5rem;
    line-height:1.2rem;
    height:1rem;
    margin-left:auto;
    margin-right:auto;
    font-size:0.38rem;
    color: #313131;
    text-align:left;
}
.box{
    width:9.5rem;
    line-height:1.2rem;
    height:1.2rem;
    margin-left:auto;
    margin-right:auto;
    text-align:left;
    color: #484848;
}
.box input.text{
    width:9.5rem;
    height:1rem;
    line-height:1rem;
    color: #494949;
    border:1px solid #ACACAC;
    font-size:0.36rem;
}
.box input.checkbox{
    margin-top:0.35rem;
    width:0.5rem;
    height:0.5rem;
    position: absolute;
}
.box .txt{
    margin-left:0.8rem;
    color: #484848;
    font-size:0.34rem;
}
</style>
</head>
<body>
<title>新增收货地址</title>
<div id="head"></div>
<div id="header"><div class="title">新增收货地址</div><div class="headback" url="address.php">返回</div></div>

<div class="title">姓名</div>
<div class="box"><input type="text" class="text" id="username" placeholder="输入收件人姓名" /></div>

<div class="title">电话</div>
<div class="box"><input type="text" class="text" id="tel" placeholder="输入11位手机号码" maxlength="11" onkeyup="value=value.replace(/[^\d]/g,'')" /></div>

<div class="title">选择地区</div>
<div class="box"><input id="u_city" class="text" type="text" readonly="" placeholder="选择所在地区"  value=""/><input id="u_city_id" type="hidden" value="19,5,4"/></div>


<div class="title">详细地址</div>
<div class="box"><input type="text" class="text" id="u_city_address" maxlength="50" placeholder="详细地址" /></div>
<div class="box"><input type="checkbox" checked="checked"class="checkbox" id="index" /><div class="txt">设为默认收货地址</div></div>

<div id="go" lock="0">保存</div>
<div id="dlalert"></div>


<script>
$(function(){
    function dlalert(txt,time,url){
        $("#dlalert").text(txt);
        $("#dlalert").show();
        setTimeout(function(){
        $("#dlalert").hide();
        if(url!=0){
            location.href=url;
        }
        },time);
    }
    
   $("#go").on("click",function(){
    var lock = $(this).attr("lock");
    if(lock=="1"){
        return false;
    }
    
    
    var username = $("#username").val();
    var tel = $("#tel").val();
    var u_city = $("#u_city").val();
    var u_city_address = $("#u_city_address").val();
    var indexs = $("#index").prop("checked");
    var u_city_id = $("#u_city_id").val();
    var index = null;
    if(indexs==true){
        var index = 1;
    }else{
        var index = 0;
    }

    
    if(username.length<=1){
        dlalert('请输入正确的姓名!',1300,0);
        return false;
    }
    if(tel.length!=11){
        dlalert('请输入正确的手机号码!',1300,0);
        return false;
    }
    if(u_city.length<4){
        dlalert('请选择地区!',1300,0);
        return false;
    }
    if(u_city_address.length<3){
        dlalert('地址过短,请检查修改!',1300,0);
        return false;
    }
    if(u_city_address.length>50){
        dlalert('地址过长,请检查修改!',1300,0);
        return false;
    }
    
    
    $(this).attr("lock","1");
    $(this).css("background","#6E6E6E");
    $(this).text('提交保存中');
    
    $.post("core/address_in.php",{
        index:index,
        username:username,
        tel:tel,
        u_city:u_city,
        u_city_address:u_city_address,
        u_city_id:u_city_id
    },function(ok){

        if(ok=="ok"){
            dlalert('新地址保存成功!',1300,'address.php');
            return false;
        }
    });
    
   });
    
});
</script>
<script>
$(function(){

var nameEl = document.getElementById('u_city');
var city_id = document.getElementById('u_city_id');

var first = []; /* 省，直辖市 */
var second = []; /* 市 */
var third = []; /* 镇 */

var selectedIndex = [19,5,4]; /* 默认选中的地区 */

var checked = [19,5,4]; /* 已选选项 */

function creatList(obj, list){
  obj.forEach(function(item, index, arr){
  var temp = new Object();
  temp.text = item.name;
  temp.value = index;
  list.push(temp);
  })
}

creatList(city, first);

if (city[selectedIndex[0]].hasOwnProperty('sub')) {
  creatList(city[selectedIndex[0]].sub, second);
} else {
  second = [{text: '', value: 0}];
}

if (city[selectedIndex[0]].sub[selectedIndex[1]].hasOwnProperty('sub')) {
  creatList(city[selectedIndex[0]].sub[selectedIndex[1]].sub, third);
} else {
  third = [{text: '', value: 0}];
}

var picker = new Picker({
    data: [first, second, third],
  selectedIndex: selectedIndex,
    title: '地址选择'
});

picker.on('picker.select', function (selectedVal, selectedIndex) {
  var text1 = first[selectedIndex[0]].text;
  var text2 = second[selectedIndex[1]].text;
  var text3 = third[selectedIndex[2]] ? third[selectedIndex[2]].text : '';


    
    nameEl.value = text1 + text2  + text3;
    city_id.value = selectedIndex[0] +','+ selectedIndex[1] + ',' +selectedIndex[2];
});

picker.on('picker.change', function (index, selectedIndex) {
  if (index === 0){
    firstChange();
  } else if (index === 1) {
    secondChange();
  }

  function firstChange() {
    second = [];
    third = [];
    checked[0] = selectedIndex;
    var firstCity = city[selectedIndex];
    if (firstCity.hasOwnProperty('sub')) {
      creatList(firstCity.sub, second);

      var secondCity = city[selectedIndex].sub[0]
      if (secondCity.hasOwnProperty('sub')) {
        creatList(secondCity.sub, third);
      } else {
        third = [{text: '', value: 0}];
        checked[2] = 0;
      }
    } else {
      second = [{text: '', value: 0}];
      third = [{text: '', value: 0}];
      checked[1] = 0;
      checked[2] = 0;
    }

    picker.refillColumn(1, second);
    picker.refillColumn(2, third);
    picker.scrollColumn(1, 0)
    picker.scrollColumn(2, 0)
  }

  function secondChange() {
    third = [];
    checked[1] = selectedIndex;
    var first_index = checked[0];
    if (city[first_index].sub[selectedIndex].hasOwnProperty('sub')) {
      var secondCity = city[first_index].sub[selectedIndex];
      creatList(secondCity.sub, third);
      picker.refillColumn(2, third);
      picker.scrollColumn(2, 0)
    } else {
      third = [{text: '', value: 0}];
      checked[2] = 0;
      picker.refillColumn(2, third);
      picker.scrollColumn(2, 0)
    }
  }

});

picker.on('picker.valuechange', function (selectedVal, selectedIndex) {
  console.log(selectedVal);
  console.log(selectedIndex);
});

nameEl.addEventListener('click', function () {
    picker.show();
});



});
</script>
</body>
</html>