<?php
require_once("check.php");
require_once("../config.php");
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/head.js"></script>
<link href="css/head.css" rel="stylesheet" type="text/css" />
<title>后台管理系统</title>
</head>
<body>
<style>
#bg{
    display: none;
    width:100%;
    height:100%;
    position: fixed;
    left:0;
    top:0;
    background: #5E5E5E;
    opacity: 0.8;
}
.menu{
    width:15rem;
    height:0.6rem;
    line-height:0.6rem;
    background: #F5F5F5;
    margin-left:auto;
    margin-right:auto;
    color: #4F4F4F;
    text-align:left;
    font-size:0.24rem;
    border-bottom:1px solid #C8C8C8;
    font-family: Microsoft Yahei;
    margin-bottom:0.15rem;
}

#user{
    width:15rem;
    height:auto;
    display:table;
    margin-left:auto;
    margin-right:auto;
    color: #676767;
    text-align:left;
}

#user .admin{
    float:right;
    margin-top:0.1rem;
    width:1rem;
    height:0.4rem;
    line-height:0.4rem;
    color:#FFFFFF;
    background: #009EEA;
    background: -webkit-linear-gradient(0deg, #009EEA, #820082); /* Safari 5.1 - 6.0 */
    background: -o-linear-gradient(0deg, #009EEA, #820082); /* Opera 11.1 - 12.0 */
    background: -moz-linear-gradient(0deg, #009EEA, #820082); /* Firefox 3.6 - 15 */
    background: linear-gradient(0deg, #009EEA, #820082); /* 标准的语法（必须放在最后） */
    border-radius:5px;
    text-align:center;
}

#user .box{
    width:15rem;
    min-height:2.7rem;
    
    background: #FFFFFF;
}

#user .box .title{
    width:15rem;
    height:0.5rem;
    line-height:0.5rem;
    background: #008ED2;
    font-size:0.2rem;
    color: #FFFFFF;
}
#user .title .a{
    width:7rem;
    height:0.5rem;
    float:left;
    margin-left:0.2rem;
}
#user .title .b{
    width:7rem;
    height:0.5rem;
    float:right;
    text-align:right;
    margin-right:0.2rem;
}

#user .box .info{
    width:15rem;
    height:2rem;
}

#user .info .img{
    width:2rem;
    height:2rem;
    float:left;
}
#user .info .img img{
    margin-top:0.2rem;
    margin-left: 0.2rem;
    width:1.6rem;
    height:1.6rem;
    border-radius:0.1rem;
}
#user .info .text{
    float:left;
    width:12.75rem;
    height: 2rem;
    margin-left:0.2rem;
}
#user .info .tr{
    width:12.7rem;
    height:0.5rem;
    text-align:left;
    line-height:0.5rem;
    font-size:0.18rem;
    color: #575757;
}
#user .info .zt{
    font-size:0.2rem;
    font-weight:bold;
    color: #EA3F0D;
}
#user .info .td1{
    width:1rem;
    float:left;
    text-align:left;
    overflow: hidden;
}
#user .info .td2{
    width:2rem;
    float:left;
    text-align:left;
}
#user .info .tc{
    width:8rem;
    float:left;
    text-align:left;
}
#user .info .ip{
    float:right;
    width:0.5rem;
    height:0.5rem;
    text-align:center;
    font-size:0.25rem;
    color: #C6C6C6;
}
#user .info .shoptitle{
    font-size:0.2rem;
    font-weight:bold;
    color:#575757;
}
#user .box .add{
    height:0.7rem;
    width:15rem;
    background: #EAEAEA;
}
#user .box .add .addtit{
    width:2rem;
    height:0.7rem;
    line-height:0.7rem;
    font-size:0.2rem;
    text-align:center;
    float:left;
    color: #6D6D6D;
}
#user .box .add .address{
    overflow: hidden;
    margin-left:0.2rem;
    width:12.5rem;
    height:0.7rem;
    line-height:0.7rem;
    font-size:0.2rem;
    float:left;
    color: #313131;
}
#user .box .adminbox{
    display: none;
    margin-top:0.01rem;
    margin-bottom:0.15rem;
    width:15rem;
    height:0.5rem;
    line-height:0.5rem;
}
input.piaoshu{
    width:1rem;
    height:0.35rem;
    background:none;
    border:0;
    color: #E30000;
}
</style>

<script>
$(function(){
function rand(minNum,maxNum){ 
    switch(arguments.length){ 
        case 1: 
            return parseInt(Math.random()*minNum+1); 
        break; 
        case 2: 
            return parseInt(Math.random()*(maxNum-minNum+1)+minNum); 
        break; 
        default: 
            return 0; 
        break; 
    }
}

function dlalert(text,time){
    $("#dlalert").text(text);
    $("#dlalert").show();
    if(time!=0){
    setTimeout(function(){
        $("#dlalert").hide();
    },time);
    }
}

look = 0;//定义0，防止多次触发
$(window).scroll(function(){
　　var scrollTop = $(this).scrollTop();
　　var scrollHeight = $(document).height();
　　var windowHeight = $(this).height();
　　if(scrollTop + windowHeight == scrollHeight){
    look++;
    if(look>1){
        return false;
    }
    dlalert('加载中',1500);
    var listnum = parseInt($('#user').children('.box').length);//计算当前有几条，发送给服务器，提供后面的列表
    if(look=1){
    $.post("php/baoming_ajax.php",{
    listnum:listnum,
    lx:'zz'
    },function(list){
    if(list=="no"){
    dlalert('到底线了',1500);
    look = 100;
    return false;
    }else{
    $("#user").append(list);
    look = 0;
    }
    });
    }
    }
        });


$("#user").on("blur",".piaoshu",function(){
    var orderid = $(this).attr("orderid");
    var vals = $(this).val();

    $.post("php/up_piaoshu.php",{
        orderid:orderid,
        vals:vals
    },function(ok){
       dlalert('修改完成',800);
       return false;
    });    

});


    });
</script>
<div id="bg"></div>
<div id="dlalert"></div>
<div class="menu">报名人员列表</div>
<?php
$numsql = "select count(id) as num from dunling_toupiao";
$numery = mysqli_query($config,$numsql);
$numery = mysqli_fetch_array($numery);
$zongjilushu = $numery['num'];//总记录数
if($zongjilushu=="0"){
    echo '当前没有任何报名人员';
    exit;
}
?>
<div id="user">
<?php
$articlesql = "select * from dunling_toupiao order by id desc limit 0,5";
$arery = mysqli_query($config,$articlesql);
while($list = mysqli_fetch_array($arery)){
?>
<div class="box" boxopenid="<?php echo $list['number_id'];?>">
<div class="title">
<div class="a"><?php echo $list['title'];?></div>
<div class="b">报名时间:&nbsp;<?php echo date("Y-m-d H:i:s",$list['baoming_time']);?></div>
</div>
<div class="info">
<div class="img"><img src="../<?php echo $list['imgurls'];?>" /></div>
<div class="text">


<div class="tr">
<div class="td1">报名人员:</div><div class="td2"><?php echo $list['nickname'];?></div>
<div class="td1">商家名称:</div><div class="td2"><?php echo $list['username'];?></div>
<div class="td1">联系电话:</div><div class="td2"><?php echo $list['tel'];?></div>

</div>
<div class="tr">
<div class="td1">投票编号:</div><div class="td2"><?php echo $list['number_id'];?></div>
<div class="td1">开始时间:</div><div class="td2"><?php echo date("y-m-d H:i",$list['starttime']);?></div>
<div class="td1">结束时间:</div><div class="td2"><?php echo date("y-m-d H:i",$list['endtime']);?></div>
</div>

<div class="tr"><div style="float: left;">备注信息:&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $list['content'];?></div></div>
<div class="tr">
<div class="td1">每票金币:</div><div class="td2"><?php echo $list['jinbi'];?></div>
<div class="td1">当前票数:</div><div class="td2"><input type="text" class="piaoshu" orderid="<?php echo $list['orderid'];?>"   value="<?php echo $list['piaoshu'];?>" /></div>
</div>
</div>
</div>
</div>
<?php
}
?>
</div>
</body>