<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id 2 2008-08-24 17:08 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

//会员卡
function query_cards($callid,$params) {
    global $db, $dbpre, $_config, $_modules;

    if(!$params) return array();
    extract($params, EXTR_OVERWRITE);

    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(file_exists($cachefile) && check_cache($cachefile, $cachetime)) {
        return read_cache($cachefile);
    }

    $result = $where = array();

    $where[] = "c.available=1";
    $where[] = "s.status IN (1,3,4,5)";
    $panelcode = isset($panelcode) ? (preg_match("/^[0-9]{2}$/",$panelcode) ? $panelcode : '') : '';
    if($panelcode) {
        $panelcode && $where[] = "s.classcode BETWEEN '{$panelcode}00' AND '{$panelcode}9999'";
    }
    $where = implode(" AND ", $where);
    $from = "{$dbpre}carddiscounts c LEFT JOIN {$dbpre}shops s ON(c.shopid=s.sid)";
    $select = "c.*,s.shopname,s.subname,s.areacode,s.classcode,s.address,s.thumb,s.mappoint";
    $order = strip_order($order);
    $orderby = $order ? "ORDER BY $order" : '';
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';

    $query = $db->query("SELECT $select FROM $from WHERE $where $orderby $limit");
    if(!function_exists('itemToArray')) {
        require_once(MUDDER_ROOT.$_modules['shop']['directory'].'/fun_item.php');
    }
    while($row = $db->fetch_array($query)) {
        $result[] = itemToArray($row);
    }
    $db->free_result($query);

    if($cachetime > 0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }

   return $result;
}
?>