<?php
/**
* UCenter Feed 推送
* @author moufer<moufer@163.com>
* @package 
* @copyright wa666.cn
* @version $Id feed_uc.class.php 1 2008-4-21 21:14 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

class Feed_UC {

    function add_review($reviewid,$shopname,$message) {
        global $user, $_config, $_modules;
        if(!$_config['uc_feed']) return;
        $feed = array();
        $feed['icon'] = 'debate';
        $feed['title_template'] = '<b>{username}在{sitename}对{shopname}进行了点评</b>';
        $feed['title_data'] = array (
            'username' => $user->username,
            'sitename' => $_config['sitename'],
            'shopname' => $shopname,
            );
        $feed['body_template'] = '<b>{subject}</b><br>{message}';
        $feed['body_data'] = array(
            'subject' => "<a href=\"{$_modules['shop']['url']}viewreview.php?reviewid=$reviewid\">{$user->username}的点评</a>",
            'message' => trimmed_title(strip_tags(preg_replace("/\[.+?\]/is", '', $message)), 150)
        );
        uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], '', '', array());
    }

    function add_newshop($shopid, $shopname) {
        global $user, $_config, $_modules;
        if(!$_config['uc_feed']) return;
        $feed = array();
        $feed['icon'] = 'debate';
        $feed['title_template'] = '<b>{username}在{sitename}里登记了一家商铺{shopname}</b>';
        $feed['title_data'] = array (
            'username' => $user->username,
            'sitename' => $_config['sitename'],
            'shopname' => $shopname,
            );
        $feed['body_template'] = '<b>{subject}</b><br>{message}';
        $feed['body_data'] = array(
            'subject' => "<a href=\"{$_modules['shop']['url']}shop.php?shopid=$shopid\">商铺: {$shopname}</a>",
            'message' => trimmed_title(strip_tags(preg_replace("/\[.+?\]/is", '', $shopname)), 150)
        );
        uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], '', '', array());
    }

    function add_respond($reviewid,$respond_content) {
        global $user, $_config, $db,$dbpre, $_modules;
        if(!$_config['uc_feed']) return;
        $reviewuname = $db->get_value("SELECT a.username FROM {$dbpre}reviews a LEFT JOIN {$dbpre}members b ON(a.uid=b.uid) WHERE rid='$reviewid'");
        $feed = array();
        $feed['icon'] = 'comment';
        $feed['title_template'] = '<b>{username}在{sitename}回应了{reviewuname}的点评</b>';
        $feed['title_data'] = array (
            'username' => $user->username,
            'sitename' => $_config['sitename'],
            'reviewuname' => $reviewuname,
            );
        $feed['body_template'] = '<b>{subject}</b><br>{message}';
        $feed['body_data'] = array(
            'subject' => "<a href=\"{$_modules['shop']['url']}viewreview.php?reviewid=$reviewid\">回应的内容</a>",
            'message' => trimmed_title(strip_tags(preg_replace("/\[.+?\]/is", '', $respond_content)), 150)
        );
        uc_feed_add($feed['icon'], $user->uid, $user->username, $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], '', '', array());
    }
}
?>