<?php
/**
* 安装向导
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id: install.php 3 2007-12-25 10:30$
*/
error_reporting(7);

define('CHARSET', 'utf-8');
define('PRODUCT', 'Modoer');

require_once('common.inc.php');

header('Content-type: text/html; charset='.CHARSET);

$lockfile = MUDDER_ROOT.'./data/install.lock';
file_exists($lockfile) && exit(PRODUCT.'系统已安装，如需重新安装，请删除 ./data/install.lock 文件，同时清空缓存文件。');

$sqlfile = MUDDER_ROOT.'./install/install.sql';
!is_readable($sqlfile) &&exit('数据库文件不存在或者读取失败');

empty($step) && $step = 'license';

if($step == 'license') {

    $license = @include 'license.php';

} elseif($step == 1) {

    require_once 'accessfiles.php';
    foreach($accessfiles as $key => $access) {
        $checkfile = MUDDER_ROOT.'./'.$access['name'];
        if(!file_exists($checkfile)) {
            $next_enable = ' disabled';
            $access['currently'] = '<span class="font_1">不存在</span>';
        } elseif(!is_readable($checkfile) && $access['access'] == 'read') {
            $next_enable = ' disabled';
            $access['currently'] = '<span class="font_1">不可读</span>';
        } elseif(!is_writable($checkfile) && $access['access'] == 'write') {
            $next_enable = ' disabled';
            $access['currently'] = '<span class="font_1">不可写</span>';
        } else {
            if(is_readable($checkfile) && $access['access'] == 'read') {
                $access['currently'] = '<span class="font_3">可读</span>';
            }
            if(is_writable($checkfile)) {
                $access['currently'] .= $access['currently'] ? ', 可写' : '<span class="font_3">可写</span>';
            }
        }
        $accessfiles[$key] = $access;
    }

} elseif($step == 2) {

    $cookiepre = random(5).'_';

} elseif($step == 3) {

    $authkey = random(12);
    $siteurl = get_url();

    if(!$system_exists_confirm) {

        $dbhost = trim($dbhost);
        $dbuser = trim(stripslashes($dbuser));
        $dbpw = trim($dbpw);
        $dbname = trim($dbname);
        $dbpre = trim($dbpre);
        $cookiepre = trim($cookiepre);

        if(!$dbhost) {
            $error = '未填写数据库服务器地址.<br />';
        }
        if(!$dbname) {
            $error = '未填写数据库名.<br />';
        }
        if(!$dbuser) {
            $error .= '未填写数据库用户名.<br />';
        }
        if(!$dbpre) {
            $error .= '未填写数据表前缀.';
        }
        if(!$cookiepre) {
            $error .= '未输入Cookie前缀.<br />';
        } elseif(strlen($cookiepre) < 3) {
            $error .= 'Cookie前缀不能小于3个字符.<br />';
        }
        if(!$error) {
            include MUDDER_ROOT.'./include/mysql.class.php';
            $db = new Db_class($dbhost, $dbuser, $dbpw, $dbname);

            $curr_os = PHP_OS;
            $curr_php_version = PHP_VERSION;
            if($curr_php_version < '4.3.0') {
                $error .= "您的PHP版本低于4.3.0, 无法安装使用 ".PRODUCT."<br />";
            }

            $curr_mysql_version = $db->version();
            if($curr_mysql_version < '3.23') {
                $error .= "您的MySQL版本低于3.23, 由于程序没有经过此平台的测试, 建议您换 MySQL4 的数据库服务器.<br />";
            }

            if(strstr($dbpre, '.')) {
                $error .= "您指定的数据表前缀包含点字符，请返回修改.<br />";
            }

            if(!$error) {

                $configfile = MUDDER_ROOT.'./config.inc.php';

                if($fp = @fopen($configfile, 'r')) {
                    $filecontent = @fread($fp, @filesize($configfile));
                    @fclose($fp);
                } else {
                    echo '读取配置文件失败,请检查文件和目录权限.';
                    exit();
                }

                $filecontent = preg_replace("/[$]dbhost\s*\=\s*[\"'].*?[\"']/is", "\$dbhost = '$dbhost'", $filecontent);
                $filecontent = preg_replace("/[$]dbuser\s*\=\s*[\"'].*?[\"']/is", "\$dbuser = '$dbuser'", $filecontent);
                $filecontent = preg_replace("/[$]dbpw\s*\=\s*[\"'].*?[\"']/is", "\$dbpw = '$dbpw'", $filecontent);
                $filecontent = preg_replace("/[$]dbname\s*\=\s*[\"'].*?[\"']/is", "\$dbname = '$dbname'", $filecontent);
                $filecontent = preg_replace("/[$]dbpre\s*\=\s*[\"'].*?[\"']/is", "\$dbpre = '$dbpre'", $filecontent);
                $filecontent = preg_replace("/[$]cookiepre\s*\=\s*[\"'].*?[\"']/is", "\$cookiepre = '$cookiepre'", $filecontent);

                if($fp = @fopen($configfile, 'w')) {
                    @fwrite($fp, trim($filecontent));
                    @fclose($fp);
                } else {
                    echo '写入配置文件失败,请检查文件和目录权限.';
                    exit();
                }

                $db->query("SELECT COUNT(*) as count FROM {$dbpre}config", 'SILENT');
                $system_exists = !$db->errno() > 0;

                unset($dbhost, $dbuser, $dbpw, $dbname, $dbpre, $cookiepre);
            }
        }

        if($error) $step = 2;
    }

} elseif($step == 4) {

    $username = trim(stripslashes($username));
    $email = html_special_chars_ex($email);
    $password = trim($password);
    $authkey = trim($authkey);
    $siteurl = trim($siteurl);

    $name_key = array("\\",'&',' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'#','$','(',')','%','@','+','?',';','^');

    if(!$username) {
        $error = '未填写用户名.<br />';
    } elseif(strlen($username) < 2 || strlen($username) > 16) {
        $error = '用户名不能小于2个字符或者大于16个字符.<br />';
    } elseif($username != addslashes($username)) {
        $error = '用户名包含了敏感字符.<br />';
    } else {
        foreach($name_key as $value){
            if (strpos($username, $value) !== false){ 
                $error = "<p>用户名包含了敏感字符.</p>";
            }
        }
    }
    if(!$email) {
        $error .= '未填写电子邮件地址.<br />';
    } elseif(strlen($email) < 6 || strlen($email) > 60) {
        $error .= '电子邮件不能小于6个字符或者大于60个字符.<br />';
    } elseif(!isemail($email)) {
        $error .= '电子邮件格式不正确.<br />';
    }
    if(!$password) {
        $error .= '未填写管理员密码.<br />';
    }
    if($password != stripslashes($password)) {
        $error .= '密码包含了敏感字符.<br />';
    }
    if($password != $password2) {
        $error .= '2次输入的密码不一致.<br />';
    }
    if(!$authkey) {
        $error .= '未输入网站加密码.<br />';
    } elseif(strlen($authkey) < 10) {
        $error .= '网站加密码不能小于10个字符.<br />';
    } elseif(empty($siteurl)) {
        $error .= '未填写 Modoer 所在路径.';
    }

    if($error) {
        $step = 3;
    } else {
        $md5pw = md5($password);

        include MUDDER_ROOT.'./config.inc.php';
        include MUDDER_ROOT.'./include/mysql.class.php';

        $fp = fopen($sqlfile, 'rb');
        $sql = fread($fp, 2048000);
        fclose($fp);

        $db = new Db_class($dbhost, $dbuser, $dbpw, $dbname);

        $tablenum = 0;
        $create_text = '';

        runquery($sql);

        $db->query("REPLACE INTO {$dbpre}config (variable,value) VALUES('authkey','$authkey')");
        $db->query("REPLACE INTO {$dbpre}config (variable,value) VALUES('siteurl','$siteurl')");

        $db->query("INSERT INTO {$dbpre}admin (adminname,email,password,admintype,is_founder,logintime,loginip,logincount) VALUES ('$username','$email','$md5pw','1','Y','0','','0')");

        unset($authkey, $sql);

        $fp = fopen($lockfile, 'x+');
        fclose($fp);
    }

}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET?>" />
<title><?php echo PRODUCT?> 程序安装</title>
<link href="install.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="main">
<form method="post" action="<?php echo $php_self?>">
<h1 id="subject"><span id="title"><?php echo PRODUCT.' '.$_VERSION['version']. ' Build '.$_VERSION['build']?></span>
<span id="copyright">Copyright &copy; 2007-2008 <a href="http://www.modoer.com/" target="_blank">Moufer Studio</a></span><div style="clear:both;"></div></h1>
<?php if($step == 'license') { ?>
<div id="step"><b>安装使用授权协议</b></div>
<table>
    <tr><td><div class="licenseblock"><div class="license"><?php echo $license?></div></div></td></tr>
</table>
<div style="text-align:center;margin: 10px;">
    <input type="hidden" name="step" value="1" />
    <button type="submit" name="name"<?php echo $next_enable?>>同意本协议</button>
</div>
<?php } elseif($step == 1) { ?>
<div id="step">第一步:检测文件及目录状态</div>
<div>
<table>
    <tr id="tbth">
        <td width="60%">目录文件名称</td>
        <td width="20%" align="center">所需状态</td>
        <td width="20%" align="center">当前状态</td>
    </tr>
    <?php foreach($accessfiles as $accessfile) { ?>
    <tr><td><?php echo $accessfile['name']?></td><td align="center"><?php echo $accessfile['access']?></td><td align="center"><?php echo $accessfile['currently']?></td></tr>
    <?php } ?>
</table>
<div id="comment">如果您无法确认以上的配置信息，请与您的服务商联系。</div>
<input type="hidden" name="step" value="2" />
</div>
<?php } elseif($step == 2) { ?>
<div id="step">第二步:配置数据库信息</div>
<?php if($error) {?><div id="error"><?php echo $error?></div><?php } ?>
<table>
    <tr id="tbth"><td width="200">设置项</td><td width="260">值</td><td width="*">说明</td></tr>
    <tr><td>服务器地址:</td><td><input type="text" name="dbhost" value="localhost" /></td><td>一般是 localhost</td></tr>
    <tr><td>数据库名:</td><td><input type="text" name="dbname" /></td><td></td></tr>
    <tr><td>数据库用户名:</td><td><input type="text" name="dbuser" /></td><td></td></tr>
    <tr><td>数据库用户密码:</td><td><input type="password" name="dbpw" /></td><td></td></tr>
    <tr><td>数据表前缀:</td><td><input type="text" name="dbpre" value="modoer_" /></td><td>同一数据库安装多个 <?php echo PRODUCT?> 时可改变默认</td></tr>
    <tr><td>Cookie前缀:</td><td><input type="text" name="cookiepre" value="<?php echo $cookiepre?>" /></td><td>3-8个字符</td></tr>
</table>
<div id="comment">如果您无法确认以上的配置信息，请与您的服务商联系。</div>
<input type="hidden" name="step" value="3" />
<?php } elseif($step == 3) { ?>
<?php if($system_exists) { ?>
<div id="error">数据库中已经安装过 <?php echo PRODUCT?>，继续安装会清空原有数据.<br />继续安装会清空全部原有数据，您确定要继续吗？</div>
<input type="hidden" name="system_exists_confirm" value="true" />
<input type="hidden" name="step" value="3" />
<?php } else { ?>
<div id="step">第三步:设置管理员账号</div>
<div id="msg">成功链接数据库.<br />您的服务器可以安装和使用 <?php echo PRODUCT?>，请设置管理员帐号。</div>
<?php if($error) { ?><div id="error"><?php echo $error?></div><?php } ?>
<table>
    <tr id="tbth"><td width="200">设置项</td><td width="260">值</td><td width="*">说明</td></tr>
    <tr><td >用户名:</td><td><input type="text" name="username" value="admin" /></td><td>限2-15个字符</td></tr>
    <tr><td>电子邮件:</td><td><input type="text" name="email" /></td><td></td></tr>
    <tr><td>管理员密码:</td><td><input type="password" name="password" /></td><td>不宜过短</td></tr>
    <tr><td>确认密码:</td><td><input type="password" name="password2" /></td><td></td></tr>
    <tr><td>网站加密码:</td><td><input type="text" name="authkey" value="<?php echo $authkey?>" /></td><td>10个及以上字符</td></tr>
    <tr><td>Modoer所在路径:</td><td><input type="text" name="siteurl" value="<?php echo $siteurl?>" /></td><td>最后不要加“/”</td></tr>
</table>
<div id="comment">请认真确认以上信息，下一步将建立数据表，完成安装。</div>
<input type="hidden" name="step" value="4" />
<?php } ?>
<?php } elseif($step == 4) { ?>
<div id="step">第4步:导入数据</div>
<div id="progress"><?php echo $create_text?></div>
<div id="msg">共创建了 <span class="font_2"><?php echo $tablenum?></span> 个数据表.<br />安装程序已经顺利执行完毕，请尽快删除 <span class="font_1">install.php</span> 和 <span class="font_1">install</span> 目录，以免被他人恶意利用。<br />感谢您使用 <?php echo PRODUCT?> 点评系统。</div>
<div id="control">管理员帐号: <?php echo $username?><br />管理员密码: <?php echo $password?><br /><br /><a href="../admincp.php">点击进入 <?php echo PRODUCT?> 点评系统 后台管理</a><br /><a href="http://www.modoer.com/">Moufer Studio</a></div>
<?php } ?>
<?php if(is_numeric($step)) { ?>
<div id="next">
    <?php if($step >= 1) { ?><button type="button" name="name" onclick="history.go(-1);">上一步</button>&nbsp;<?php } ?>
    <?php if($step >=1 && $step < 4) { ?><button type="submit" name="name"<?php echo $next_enable?>>下一步</button><?php } ?>
</div>
<?php } ?>
</form>
</div>