DROP TABLE IF EXISTS modoer_activity;
CREATE TABLE modoer_activity (
  aid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) NOT NULL default '0',
  username varchar(16) NOT NULL default '',
  year smallint(4) unsigned NOT NULL default '0',
  month smallint(2) unsigned NOT NULL default '0',
  reviews int(5) unsigned NOT NULL default '0',
  fristreviews int(5) unsigned NOT NULL default '0',
  flowers int(5) unsigned NOT NULL default '0',
  addshops int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY uid (uid),
  KEY datetime (year,month),
  KEY stat (reviews,fristreviews,flowers),
  KEY username (username)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_admin;
CREATE TABLE modoer_admin (
  id mediumint(8) unsigned NOT NULL auto_increment,
  adminname varchar(24) NOT NULL default '',
  password varchar(32) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  admintype tinyint(3) NOT NULL default '0',
  is_founder char(1) NOT NULL default 'N',
  logintime int(10) NOT NULL default '0',
  loginip varchar(20) NOT NULL default '',
  logincount int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY adminname (adminname)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_adminsessions;
CREATE TABLE modoer_adminsessions (
  adminid mediumint(8) unsigned NOT NULL default '0',
  ip char(16) NOT NULL default '',
  dateline int(10) NOT NULL default '0',
  errorcount tinyint(1) NOT NULL default '0'
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_ads;
CREATE TABLE modoer_ads (
  adid smallint(5) NOT NULL auto_increment,
  callid smallint(5) unsigned NOT NULL default '0',
  subject varchar(60) NOT NULL default '',
  adtype tinyint(3) unsigned NOT NULL default '1',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content mediumtext NOT NULL,
  code mediumtext NOT NULL,
  isclosed tinyint(1) NOT NULL default '0',
  attr varchar(10) NOT NULL default '',
  PRIMARY KEY  (adid)
) TYPE=MyISAM;

INSERT INTO modoer_ads VALUES ('1','28','各页侧边广告','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:348:\"<script type=\\\"text/javascript\\\">\r\ngoogle_ad_client = \\\"pub-8359185413963124\\\";\r\ngoogle_language = \\\'zh-CN\\\'; \r\n/* 234x60, 创建于 08-10-17 */\r\ngoogle_ad_slot = \\\"7130063547\\\";\r\ngoogle_ad_width = 234;\r\ngoogle_ad_height = 60;\r\n</script>\r\n<script type=\\\"text/javascript\\\"\r\nsrc=\\\"http://pagead2.googlesyndication.com/pagead/show_ads.js\\\">\r\n</script>\";}','<script type=\"text/javascript\">\r\ngoogle_ad_client = \"pub-8359185413963124\";\r\ngoogle_language = \'zh-CN\'; \r\n/* 234x60, 创建于 08-10-17 */\r\ngoogle_ad_slot = \"7130063547\";\r\ngoogle_ad_width = 234;\r\ngoogle_ad_height = 60;\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','0','1');
INSERT INTO modoer_ads VALUES ('2','29','新闻内容页广告','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:359:\"<script type=\\\"text/javascript\\\"><!--\r\ngoogle_ad_client = \\\"pub-8359185413963124\\\";\r\ngoogle_language = \\\'zh-CN\\\'; \r\n/* 468x60, 创建于 08-10-21 */\r\ngoogle_ad_slot = \\\"0495261940\\\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type=\\\"text/javascript\\\"\r\nsrc=\\\"http://pagead2.googlesyndication.com/pagead/show_ads.js\\\">\r\n</script>\";}','<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-8359185413963124\";\r\ngoogle_language = \'zh-CN\'; \r\n/* 468x60, 创建于 08-10-21 */\r\ngoogle_ad_slot = \"0495261940\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','0','1');
INSERT INTO modoer_ads VALUES ('3','30','首页中上468x60','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:359:\"<script type=\\\"text/javascript\\\"><!--\r\ngoogle_ad_client = \\\"pub-8359185413963124\\\";\r\ngoogle_language = \\\'zh-CN\\\'; \r\n/* 468x60, 创建于 08-10-17 */\r\ngoogle_ad_slot = \\\"6053443059\\\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type=\\\"text/javascript\\\"\r\nsrc=\\\"http://pagead2.googlesyndication.com/pagead/show_ads.js\\\">\r\n</script>\";}','<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-8359185413963124\";\r\ngoogle_language = \'zh-CN\'; \r\n/* 468x60, 创建于 08-10-17 */\r\ngoogle_ad_slot = \"6053443059\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','0','1');

DROP TABLE IF EXISTS modoer_announcements;
CREATE TABLE modoer_announcements (
  id mediumint(8) unsigned NOT NULL auto_increment,
  title varchar(200) NOT NULL default '',
  orders smallint(5) NOT NULL default '0',
  content mediumtext NOT NULL,
  author varchar(50) NOT NULL default '',
  pageview int(10) NOT NULL default '0',
  dateline int(10) NOT NULL default '0',
  available tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_announcements VALUES ('1','Modoer点评系统介绍','0','<style>\r\n.explain {margin-bottom:15px; padding: 10px; border: 1px solid #DFEFEF; background: #FAFCFC; text-indent: 25px; line-height: 18px;}\r\n.content{line-height: 18px;}\r\n.content h3{margin: 0px; padding-left:12px; background: url(images/arrow.gif) no-repeat 2px center; color: #330000; font-size: 12px;}\r\n.content ul{list-style:decimal;margin-top: 2px; margin-bottom: 5px;}\r\n</style>\r\n<div class=\"explain\">Modoer(Mudder)是一款以本地分享，多功能开源免费的点评网站管理系统，采用PHP+MYSQL开发设计。网站模板与程序分离，通过模板设计便可实现个性化网站。</div>\r\n<div class=\"content\">\r\n<h3>商铺功能</h3>\r\n<ul>\r\n<li>可建立多板块的点评，例如（餐饮，旅游，购物，娱乐，服务等）</li>\r\n<li>每个板块可以分类，并按类别输出信息（如餐饮板块可以建立火锅，海鲜等，出行/旅游板块可以建立汽车，旅行社等）</li>\r\n<li>商铺可以设置，商铺名称，分店名称，主营菜系，地址，电话，手机，店铺标签(Tag)，并可增加分店</li>\r\n<li>会员可补充商铺信息</li>\r\n<li>已有商铺可增加分店</li>\r\n<li>商铺可以根据环境，产品或者其他补充图片集展示，图片支持缩略图，水印功能</li>\r\n<li>可自定义设置商铺封面</li>\r\n<li>所有会员的提交信息可自动提交和后台管理审核</li>\r\n<li>自定义城市区域，可以精确到街道</li>\r\n<li>万能整合API，可与任何PHP系统进行整合</li>\r\n</ul>\r\n<h3>点评功能</h3>\r\n<ul>\r\n<li>商铺可以针对各个板块可以自定义点评项名称和评分项数量），喜欢程度，人均消费，消费感受，适合类型进行点评，会员并可推荐产品以及设置店铺Tag，其他会员可以对点评进行献花和回应，反馈，举报点评</li>\r\n<li>会员并可推荐产品以及设置店铺 Tag</li>\r\n<li>其他会员可以对点评进行献花和回应，反馈</li>\r\n<li>举报点评</li>\r\n</ul>\r\n<h3>会员卡功能</h3>\r\n<ul>\r\n<li>可自定义设置会员卡名称</li>\r\n<li>可设置会员卡在商铺的折扣或者优惠活动和备注说明</li>\r\n<li>可设置推荐加盟商家</li>\r\n</ul>\r\n<h3>兑奖中心功能</h3>\r\n<ul>\r\n<li>会员可通过点评，登记，回应等一系列互动操作得到金币积分，利用这些积分可对话相应积分的奖品\r\n<li>后台可添加和设置奖品以及奖品说明\r\n</ul>\r\n<h3>排行榜功能</h3>\r\n<ul>\r\n<li>餐厅排行（最佳餐厅、口味最佳、环境最佳、服务最佳）</li>\r\n<li>最新餐厅（近一周加入、近一月加入、近三月加入）</li>\r\n</ul>\r\n<h3>会员功能</h3>\r\n<ul>\r\n<li>会员短信功能</li>\r\n<li>个人主页功能（可以设置、更改个人主页名称和风格）</li>\r\n<li>好友设置功能</li>\r\n<li>个人留言版功能</li>\r\n<li>会员积分功能</li>\r\n<li>会员鲜花功能</li>\r\n<li>收藏夹功能</li>\r\n<li>积分等级</li>\r\n</ul>\r\n</div>','moufer','94','1210556677','1');

DROP TABLE IF EXISTS modoer_areacode;
CREATE TABLE modoer_areacode (
  aid mediumint(8) unsigned NOT NULL auto_increment,
  areaname varchar(16) NOT NULL default '',
  default_mappoint varchar(50) NOT NULL default '',
  areacode varchar(8) NOT NULL default '',
  areasort tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (aid),
  UNIQUE KEY areacode (areacode,areasort)
) TYPE=MyISAM AUTO_INCREMENT=9;

INSERT INTO modoer_areacode VALUES ('1','宁波市','12156014,2987257','10','1');
INSERT INTO modoer_areacode VALUES ('2','海曙区','12152302,2987251','1001','2');
INSERT INTO modoer_areacode VALUES ('3','天一广场','','100101','3');
INSERT INTO modoer_areacode VALUES ('4','江东区','12156519,2986894','1002','2');
INSERT INTO modoer_areacode VALUES ('5','江北区','','1003','2');
INSERT INTO modoer_areacode VALUES ('6','天伦广场','','100201','3');
INSERT INTO modoer_areacode VALUES ('7','老外滩','','100301','3');
INSERT INTO modoer_areacode VALUES ('8','鄞州区','12159505,2982459','1004','2');

DROP TABLE IF EXISTS modoer_articleclass;
CREATE TABLE modoer_articleclass (
  classid smallint(5) unsigned NOT NULL auto_increment,
  classname varchar(20) NOT NULL default '',
  displayorder smallint(5) NOT NULL default '0',
  articlenum mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (classid)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_articleclass VALUES ('1','默认分类','1','2');

DROP TABLE IF EXISTS modoer_articledata;
CREATE TABLE modoer_articledata (
  articleid mediumint(8) unsigned NOT NULL default '0',
  content longtext NOT NULL,
  PRIMARY KEY  (articleid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_articles;
CREATE TABLE modoer_articles (
  articleid mediumint(8) unsigned NOT NULL auto_increment,
  classid smallint(5) unsigned NOT NULL default '0',
  shopid mediumint(8) NOT NULL default '0',
  dateline int(10) NOT NULL default '0',
  att tinyint(1) NOT NULL default '0',
  author varchar(20) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  keywords varchar(100) NOT NULL default '',
  pageview mediumint(8) unsigned NOT NULL default '0',
  digg mediumint(8) NOT NULL default '0',
  copyfrom varchar(200) NOT NULL default '',
  introduce mediumtext NOT NULL,
  status tinyint(1) NOT NULL default '1',
  checker varchar(30) NOT NULL default '',
  PRIMARY KEY  (articleid),
  KEY classid (classid),
  KEY shopid (shopid),
  KEY dateline (dateline),
  KEY digg (digg)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_bcastr;
CREATE TABLE modoer_bcastr (
  bcastr_id smallint(3) unsigned NOT NULL auto_increment,
  available tinyint(1) NOT NULL default '1',
  itemtitle varchar(100) NOT NULL default '',
  link varchar(255) NOT NULL default '',
  item_url varchar(255) NOT NULL default '',
  orders smallint(3) NOT NULL default '0',
  PRIMARY KEY  (bcastr_id)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_bcastr VALUES ('1','1','Modoer点评系统','http://www.modoer.com/','/uploads/bcastr/1.jpg','1');

DROP TABLE IF EXISTS modoer_carddiscounts;
CREATE TABLE modoer_carddiscounts (
  shopid mediumint(8) unsigned NOT NULL auto_increment,
  cardsort enum('both','largess','discount') NOT NULL default 'discount',
  discount decimal(4,1) NOT NULL default '0.0',
  largess varchar(100) NOT NULL default '',
  exception varchar(255) NOT NULL default '',
  addtime int(10) unsigned NOT NULL default '0',
  available tinyint(1) NOT NULL default '1',
  finer tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (shopid),
  KEY shopid (available,cardsort,discount,addtime),
  KEY discount (discount,available),
  KEY finer (finer,available)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_classcode;
CREATE TABLE modoer_classcode (
  cid mediumint(8) unsigned NOT NULL auto_increment,
  classname varchar(16) NOT NULL default '',
  classcode varchar(4) NOT NULL default '',
  classsort tinyint(1) NOT NULL default '0',
  total int(10) unsigned NOT NULL default '0',
  config text NOT NULL,
  classorder smallint(2) NOT NULL default '0',
  PRIMARY KEY  (cid),
  UNIQUE KEY classcode (classcode)
) TYPE=MyISAM AUTO_INCREMENT=3;

INSERT INTO modoer_classcode VALUES ('1','美食餐馆','10','1','0','a:12:{s:6:\"review\";a:1:{s:5:\"sort1\";s:6:\"Review\";}s:7:\"mapmark\";i:1;s:9:\"itemapply\";i:1;s:12:\"tplname_list\";s:9:\"shop_cate\";s:14:\"tplname_detail\";s:10:\"shop_index\";s:13:\"avgprice_need\";i:0;s:16:\"suitplace_enable\";i:0;s:10:\"suitplaces\";s:0:\"\";s:9:\"scoretype\";i:100;s:12:\"decimalpoint\";i:0;s:13:\"meta_keywords\";s:6:\"modoer\";s:16:\"meta_description\";s:6:\"modoer\";}','0');
INSERT INTO modoer_classcode VALUES ('2','海鲜','1001','2','0','','2');

DROP TABLE IF EXISTS modoer_config;
CREATE TABLE modoer_config (
  variable varchar(32) NOT NULL default '',
  value text NOT NULL,
  PRIMARY KEY  (variable)
) TYPE=MyISAM;

INSERT INTO modoer_config VALUES ('adminipaccess','');
INSERT INTO modoer_config VALUES ('auditing','a:5:{s:7:\"addshop\";s:1:\"0\";s:9:\"addreview\";s:1:\"0\";s:10:\"addrespond\";s:1:\"0\";s:13:\"uploadpicture\";s:1:\"0\";s:8:\"auditing\";i:0;}');
INSERT INTO modoer_config VALUES ('cache','a:9:{s:9:\"statshops\";i:1000;s:11:\"statmembers\";i:320;s:10:\"newreviews\";i:300;s:11:\"newpictures\";i:2000;s:4:\"tags\";i:600;s:6:\"panels\";i:600;s:6:\"search\";i:600;s:5:\"space\";i:6000;s:8:\"exchange\";i:400;}');
INSERT INTO modoer_config VALUES ('censoruser','*版主*\r\n*管理员*\r\nadmin*');
INSERT INTO modoer_config VALUES ('closenote','网站升级中...请稍后...');
INSERT INTO modoer_config VALUES ('closereg','0');
INSERT INTO modoer_config VALUES ('debug','1');
INSERT INTO modoer_config VALUES ('default_city','10');
INSERT INTO modoer_config VALUES ('dpdetail_reviewnumber','5');
INSERT INTO modoer_config VALUES ('dpnewreviewnumber','');
INSERT INTO modoer_config VALUES ('dpreviewnumber','10');
INSERT INTO modoer_config VALUES ('dpreview_respondnumber','10');
INSERT INTO modoer_config VALUES ('dpshopnumber','10');
INSERT INTO modoer_config VALUES ('existsemailreg','0');
INSERT INTO modoer_config VALUES ('expleve','a:10:{s:3:\"reg\";a:2:{s:5:\"point\";i:1;s:4:\"coin\";i:2;}s:7:\"addshop\";a:2:{s:5:\"point\";i:20;s:4:\"coin\";i:5;}s:10:\"updateshop\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:2;}s:9:\"addreview\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:3;}s:10:\"addrespond\";a:2:{s:5:\"point\";i:3;s:4:\"coin\";i:0;}s:10:\"addpicture\";a:2:{s:5:\"point\";i:8;s:4:\"coin\";i:2;}s:10:\"deleteshop\";a:2:{s:5:\"point\";i:20;s:4:\"coin\";i:5;}s:12:\"deletereview\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:2;}s:13:\"deleterespond\";a:2:{s:5:\"point\";i:3;s:4:\"coin\";i:0;}s:13:\"deletepicture\";a:2:{s:5:\"point\";i:8;s:4:\"coin\";i:2;}}');
INSERT INTO modoer_config VALUES ('gzipcompress','0');
INSERT INTO modoer_config VALUES ('headhtml','');
INSERT INTO modoer_config VALUES ('icpno','');
INSERT INTO modoer_config VALUES ('meta_description','php开源多功能点评系统');
INSERT INTO modoer_config VALUES ('meta_keywords','php,mudder,点评系统');
INSERT INTO modoer_config VALUES ('newreview_classcode','10');
INSERT INTO modoer_config VALUES ('picture_thumb','a:2:{s:5:\"small\";a:2:{s:5:\"width\";i:88;s:6:\"height\";i:67;}s:3:\"big\";a:2:{s:5:\"width\";i:124;s:6:\"height\";i:94;}}');
INSERT INTO modoer_config VALUES ('picture_upload_size','600');
INSERT INTO modoer_config VALUES ('salutatory','0');
INSERT INTO modoer_config VALUES ('siteclose','0');
INSERT INTO modoer_config VALUES ('sitename','Modoer点评系统');
INSERT INTO modoer_config VALUES ('space','a:8:{s:11:\"recordguest\";i:1;s:9:\"spacename\";s:0:\"\";s:13:\"spacedescribe\";s:0:\"\";s:13:\"index_reviews\";i:5;s:12:\"index_gbooks\";i:5;s:7:\"reviews\";i:10;s:6:\"gbooks\";i:10;s:7:\"friends\";i:10;}');
INSERT INTO modoer_config VALUES ('subname','PHP多功能点评系统');
INSERT INTO modoer_config VALUES ('templateid','1');
INSERT INTO modoer_config VALUES ('templatemenu','1');
INSERT INTO modoer_config VALUES ('useripaccess','');
INSERT INTO modoer_config VALUES ('watermark','1');
INSERT INTO modoer_config VALUES ('seccode','a:5:{s:5:\"login\";i:0;s:8:\"registry\";i:0;s:9:\"newreview\";i:0;s:7:\"newshop\";i:0;s:10:\"adminlogin\";i:0;}');
INSERT INTO modoer_config VALUES ('mspaceid','1');
INSERT INTO modoer_config VALUES ('space_styleid','0');
INSERT INTO modoer_config VALUES ('jstransfer','a:3:{s:6:\"enable\";i:1;s:9:\"cachelife\";i:3600;s:6:\"access\";s:15:\"www.nbchifan.cn\";}');
INSERT INTO modoer_config VALUES ('default_panel','10');
INSERT INTO modoer_config VALUES ('inputlimit','a:2:{s:6:\"review\";a:2:{s:3:\"min\";i:20;s:3:\"max\";i:1000;}s:7:\"respond\";a:2:{s:3:\"min\";i:5;s:3:\"max\";i:300;}}');
INSERT INTO modoer_config VALUES ('search','a:4:{s:5:\"limit\";i:0;s:6:\"maxspm\";i:0;s:10:\"maxresults\";i:5000;s:9:\"cachelife\";i:3600;}');
INSERT INTO modoer_config VALUES ('exchange','a:6:{s:6:\"enable\";i:1;s:11:\"thumb_width\";s:3:\"124\";s:12:\"thumb_height\";s:2:\"94\";s:7:\"seccode\";i:1;s:7:\"display\";i:1;s:4:\"icon\";s:18:\"panel_exchange.gif\";}');
INSERT INTO modoer_config VALUES ('membercard','a:4:{s:6:\"enable\";i:1;s:4:\"name\";s:4:\"Card\";s:7:\"display\";i:1;s:4:\"icon\";s:14:\"panel_card.gif\";}');
INSERT INTO modoer_config VALUES ('shopthumb','1');
INSERT INTO modoer_config VALUES ('rewrite','N;');
INSERT INTO modoer_config VALUES ('classorder','total');
INSERT INTO modoer_config VALUES ('thumbdisplay','fixed');
INSERT INTO modoer_config VALUES ('video','a:2:{s:5:\"width\";i:258;s:6:\"height\";i:200;}');
INSERT INTO modoer_config VALUES ('googlesearch','a:2:{s:6:\"enable\";i:1;s:7:\"website\";s:10:\"modoer.com\";}');
INSERT INTO modoer_config VALUES ('detail_allthumb_enable','1');
INSERT INTO modoer_config VALUES ('detail_allthumb_sort','big');
INSERT INTO modoer_config VALUES ('ucenter_enable','0');
INSERT INTO modoer_config VALUES ('salutatory_msg','你好！$username：\r\n\r\n非常高兴您来到Modoer点评系统演示站！\r\n\r\nModoer开发团队\r\n$time');
INSERT INTO modoer_config VALUES ('coupon','a:8:{s:6:\"enable\";s:1:\"1\";s:5:\"check\";s:1:\"0\";s:9:\"watermark\";s:1:\"0\";s:11:\"thumb_width\";s:2:\"72\";s:12:\"thumb_height\";s:2:\"47\";s:7:\"seccode\";s:1:\"1\";s:7:\"display\";s:1:\"1\";s:4:\"icon\";s:18:\"panel_exchange.gif\";}');
INSERT INTO modoer_config VALUES ('item_styleid','0');
INSERT INTO modoer_config VALUES ('tplext','.htm');
INSERT INTO modoer_config VALUES ('authkey','Rd8JZTLF83Zq');
INSERT INTO modoer_config VALUES ('siteurl','http://www.m11.com');
INSERT INTO modoer_config VALUES ('uc_exange','0');
INSERT INTO modoer_config VALUES ('uc_feed','0');
INSERT INTO modoer_config VALUES ('uc_uch','0');
INSERT INTO modoer_config VALUES ('uc_uch_url','');
INSERT INTO modoer_config VALUES ('showregrule','0');
INSERT INTO modoer_config VALUES ('regrule','');
INSERT INTO modoer_config VALUES ('ban_ip','');

DROP TABLE IF EXISTS modoer_coupons;
CREATE TABLE modoer_coupons (
  couponid mediumint(8) unsigned NOT NULL auto_increment,
  shopid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  thumb varchar(255) NOT NULL default '',
  picture varchar(255) NOT NULL default '',
  starttime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  subject varchar(100) NOT NULL default '',
  des varchar(50) NOT NULL default '',
  content text NOT NULL,
  effect1 mediumint(8) unsigned NOT NULL default '0',
  flag tinyint(1) unsigned NOT NULL default '1',
  dateline int(10) unsigned NOT NULL default '0',
  pageview int(10) NOT NULL default '0',
  PRIMARY KEY  (couponid),
  KEY shopid (shopid),
  KEY uid (uid),
  KEY dateline (dateline)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_datacall;
CREATE TABLE modoer_datacall (
  callid smallint(5) unsigned NOT NULL auto_increment,
  module varchar(60) NOT NULL default '',
  calltype varchar(60) NOT NULL default '',
  name varchar(50) NOT NULL default '',
  fun varchar(60) NOT NULL default '',
  var varchar(60) NOT NULL default '',
  expression text NOT NULL,
  tplname varchar(200) NOT NULL default '',
  empty_tplname varchar(200) NOT NULL default '',
  closed tinyint(1) unsigned NOT NULL default '0',
  hash varchar(32) NOT NULL default '',
  PRIMARY KEY  (callid)
) TYPE=MyISAM AUTO_INCREMENT=56;

INSERT INTO modoer_datacall VALUES ('1','shop','fun','首页_最新点评','reviews','review','a:4:{s:9:\"cachetime\";s:3:\"600\";s:3:\"row\";s:1:\"3\";s:5:\"order\";s:13:\"posttime DESC\";s:8:\"showitem\";s:1:\"1\";}','index_reviews','empty_li','0','fae7b7b9');
INSERT INTO modoer_datacall VALUES ('2','coupon','fun','优惠券_热门优惠券','coupon','coupon_hot','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.effect1 DESC\";s:0:\"\";s:0:\"\";}','coupon_hot_li','empty_li','0','185ee4fd');
INSERT INTO modoer_datacall VALUES ('3','coupon','fun','优惠券_最新发布','coupon','coupon_new','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:15:\"c.dateline DESC\";s:0:\"\";s:0:\"\";}','coupon_new_li','empty_li','0','a06ee56a');
INSERT INTO modoer_datacall VALUES ('4','coupon','fun','优惠券_其他热门','coupon','coupon_other_hot','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.effect1 DESC\";s:0:\"\";s:0:\"\";}','coupon_other_li','empty_li','0','185ee4fd');
INSERT INTO modoer_datacall VALUES ('5','article','fun','首页_新闻资讯_推荐','article','articles','a:4:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','index_article_li','empty_li','0','f22c72d6');
INSERT INTO modoer_datacall VALUES ('6','article','fun','首页_新闻资讯_关注','article','articles','a:4:{s:9:\"cachetime\";s:4:\"3100\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:9:\"digg DESC\";s:4:\"digg\";s:1:\"1\";}','index_article_li','empty_li','0','3033649c');
INSERT INTO modoer_datacall VALUES ('7','article','fun','首页_新闻资讯_最新','article','articles','a:4:{s:9:\"cachetime\";s:4:\"1200\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:0:\"\";N;}','index_article_li','empty_li','0','2e2240c3');
INSERT INTO modoer_datacall VALUES ('8','shop','fun','首页_热门商铺','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:12:\"reviews DESC\";s:0:\"\";N;}','index_item_li','empty_li','0','4f98bd7e');
INSERT INTO modoer_datacall VALUES ('9','shop','fun','首页_最新商铺','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:12:\"addtime DESC\";s:0:\"\";N;}','index_item_li','empty_li','0','317c307b');
INSERT INTO modoer_datacall VALUES ('10','shop','fun','首页_推荐商铺','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:10:\"finer DESC\";s:5:\"finer\";s:1:\"1\";}','index_item_finer_li','empty_li','0','f7c7d9d5');
INSERT INTO modoer_datacall VALUES ('11','card','fun','首页_会员卡','cards','cards','a:4:{s:9:\"cachetime\";s:4:\"2000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.addtime DESC\";s:0:\"\";N;}','index_item_card_li','empty_li','0','1c7b3994');
INSERT INTO modoer_datacall VALUES ('12','member','fun','会员排行_专家','members','members','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:10:\"point DESC\";s:7:\"groupid\";s:2:\"10\";}','member_face_li','empty_li','0','bc1f5d37');
INSERT INTO modoer_datacall VALUES ('13','member','fun','会员排行_最新加入','members','members','a:4:{s:9:\"cachetime\";s:3:\"800\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:12:\"regdate DESC\";s:7:\"groupid\";s:2:\"10\";}','member_face_li','empty_li','0','2f8ddd92');
INSERT INTO modoer_datacall VALUES ('14','member','fun','会员排行_活跃会员','members','members','a:5:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:14:\"m.reviews DESC\";s:5:\"group\";s:2:\"10\";s:6:\"active\";s:1:\"1\";}','member_face_li','empty_li','0','8113d184');
INSERT INTO modoer_datacall VALUES ('15','member','fun','会员排行_财富榜','members','members','a:4:{s:9:\"cachetime\";s:4:\"2000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:9:\"coin DESC\";s:7:\"groupid\";s:2:\"10\";}','member_smallface_li','empty_li','0','8f6034fd');
INSERT INTO modoer_datacall VALUES ('16','space','sql','首页_个人空间','sql','spaces','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:13:\"{dbpre}spaces\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:12:\"pageview>\'0\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:13:\"pageview DESC\";s:5:\"limit\";s:4:\"0,10\";}','index_space_li','empty_li','0','0539c971');
INSERT INTO modoer_datacall VALUES ('17','exchange','sql','首页_兑换奖品','sql','gifts','a:7:{s:9:\"cachetime\";s:4:\"3000\";s:4:\"from\";s:12:\"{dbpre}gifts\";s:6:\"select\";s:38:\"giftid,name,price,num,thumb,salevolume\";s:5:\"where\";s:11:\"available=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"displayorder\";s:5:\"limit\";s:3:\"0,3\";}','index_gitf_div','empty_li','0','2a6486d6');
INSERT INTO modoer_datacall VALUES ('18','exchange','sql','兑奖中心_最新兑换_聚合','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"6000\";s:4:\"from\";s:15:\"{dbpre}exchange\";s:6:\"select\";s:30:\"exchangeid,uid,giftid,giftname\";s:5:\"where\";s:17:\"status IN (1,2,3)\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:17:\"exchangetime DESC\";s:5:\"limit\";s:4:\"0,10\";}','exchange_new_li','empty_li','0','f0298c38');
INSERT INTO modoer_datacall VALUES ('19','exchange','sql','兑奖中心_热门兑换_聚合','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"8000\";s:4:\"from\";s:12:\"{dbpre}gifts\";s:6:\"select\";s:28:\"giftid,name,salevolume,thumb\";s:5:\"where\";s:28:\"salevolume>0 AND available=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:15:\"salevolume DESC\";s:5:\"limit\";s:4:\"0,10\";}','exchange_hot_li','empty_li','0','ad0c6c32');
INSERT INTO modoer_datacall VALUES ('20','shop','sql','首页_热门标签','sql','tags','a:7:{s:9:\"cachetime\";s:5:\"10000\";s:4:\"from\";s:11:\"{dbpre}tags\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:20:\"closed=0 AND total>0\";s:5:\"other\";s:16:\"GROUP BY tagname\";s:7:\"orderby\";s:10:\"total DESC\";s:5:\"limit\";s:4:\"0,20\";}','index_tag_li','empty_li','0','a51f8e9f');
INSERT INTO modoer_datacall VALUES ('21','shop','sql','头部_热门搜索','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"7200\";s:4:\"from\";s:18:\"{dbpre}searchindex\";s:6:\"select\";s:34:\"max(searchid) as searchid, keyword\";s:5:\"where\";s:7:\"total>0\";s:5:\"other\";s:16:\"GROUP BY keyword\";s:7:\"orderby\";s:8:\"searchid\";s:5:\"limit\";s:3:\"0,5\";}','header_hotsearch','empty','0','50af0baf');
INSERT INTO modoer_datacall VALUES ('40','shop','fun','cate页热门商铺','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"pageviews DESC\";s:9:\"panelcode\";s:5:\"{$cd}\";}','shop_cate_hotshop_li','empty_li','0','a7773092');
INSERT INTO modoer_datacall VALUES ('41','shop','fun','详细页_补充信息的会员列表','uplog','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"posttime DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','shop_detail_uplog_li','empty','0','93cf3f08');
INSERT INTO modoer_datacall VALUES ('39','shop','sql','cate页热门分类','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"8000\";s:4:\"from\";s:16:\"{dbpre}classcode\";s:6:\"select\";s:29:\"cid,classname,classcode,total\";s:5:\"where\";s:57:\"(classcode BETWEEN \'{$pcd}00\' AND \'{$pcd}99\') AND total>0\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:10:\"total DESC\";s:5:\"limit\";s:4:\"0,10\";}','shop_cate_hotclass_li','empty_li','0','4b3821cc');
INSERT INTO modoer_datacall VALUES ('28','ads','sql','各页侧边广告','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'1\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','327f5b96');
INSERT INTO modoer_datacall VALUES ('29','ads','sql','新闻内容页广告','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'2\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','5349a93f');
INSERT INTO modoer_datacall VALUES ('30','ads','sql','首页中上468x60','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'3\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','a492875a');
INSERT INTO modoer_datacall VALUES ('46','article','fun','新闻列表_本栏目推荐新闻','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_list_li','empty_li','0','f6e3dd49');
INSERT INTO modoer_datacall VALUES ('47','links','fun','新闻列表_本栏目最新发布','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:7:\"classid\";s:10:\"{$classid}\";}','article_list_li','empty_li','0','e5b715f5');
INSERT INTO modoer_datacall VALUES ('45','article','fun','详细页_商铺资讯','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"4000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','shop_cate_article_li','empty_li','0','a6172bec');
INSERT INTO modoer_datacall VALUES ('44','shop','fun','详细页_附近热铺','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:1:\"5\";s:5:\"order\";s:12:\"reviews DESC\";s:10:\"streetcode\";s:13:\"{$streetcode}\";}','shop_detail_shop_li','empty_li','0','8b97a09b');
INSERT INTO modoer_datacall VALUES ('42','shop','fun','详细页_全部分店列表','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"50\";s:5:\"order\";s:12:\"reviews DESC\";s:8:\"shopname\";s:11:\"{$shopname}\";}','shop_detail_shop_li','empty_li','0','63163f44');
INSERT INTO modoer_datacall VALUES ('43','shop','fun','详细页_同类型热铺','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8500\";s:3:\"row\";s:1:\"5\";s:5:\"order\";s:12:\"reviews DESC\";s:9:\"panelcode\";s:14:\"$sameclasscode\";}','shop_detail_shop_li','empty_li','0','8fb15040');
INSERT INTO modoer_datacall VALUES ('48','article','fun','新闻列表_本栏目周热门新闻','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"6000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:7:\"classid\";s:10:\"{$classid}\";}','article_list_li','empty_li','0','4598f822');
INSERT INTO modoer_datacall VALUES ('49','article','fun','新闻列表_推荐新闻','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_list_li','empty_li','0','f6e3dd49');
INSERT INTO modoer_datacall VALUES ('50','article','fun','新闻列表_最新发布','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"4000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:0:\"\";s:0:\"\";}','article_list_li','empty_li','0','e18b9f4b');
INSERT INTO modoer_datacall VALUES ('51','article','fun','新闻列表_周热门新闻','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:0:\"\";s:0:\"\";}','article_list_li','empty_li','0','6473141e');
INSERT INTO modoer_datacall VALUES ('52','article','fun','新闻内容_推荐资讯','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"6000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_detail_list_li','empty_li','0','db09f991');
INSERT INTO modoer_datacall VALUES ('53','article','fun','新闻内容_资讯排行','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:0:\"\";s:0:\"\";}','article_detail_list_li','empty_li','0','f94d2a2f');
INSERT INTO modoer_datacall VALUES ('54','article','fun','商铺资讯_本周热门新闻','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','article_list_li','empty_li','0','0dc2d6d2');
INSERT INTO modoer_datacall VALUES ('55','article','fun','商铺资讯_本商铺资讯','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"7000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','article_detail_list_li','empty_li','0','92854581');
INSERT INTO modoer_datacall VALUES ('56','shop','sql','首页_最新上传','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:15:\"{dbpre}pictures\";s:6:\"select\";s:40:\"pid,shopid,title,folder,filename,addtime\";s:5:\"where\";s:8:\"status=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"addtime DESC\";s:5:\"limit\";s:3:\"0,5\";}','index_item_newpic','empty','0','758f50ca');

DROP TABLE IF EXISTS modoer_exchange;
CREATE TABLE modoer_exchange (
  exchangeid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  giftid mediumint(8) unsigned NOT NULL default '0',
  giftname varchar(200) NOT NULL default '',
  price int(10) unsigned NOT NULL default '0',
  number int(10) unsigned NOT NULL default '1',
  status tinyint(1) NOT NULL default '1',
  status_extra varchar(255) NOT NULL default '',
  exchangetime int(10) NOT NULL default '0',
  contact mediumtext NOT NULL,
  checker varchar(20) NOT NULL default '',
  PRIMARY KEY  (exchangeid),
  KEY uid (uid,status),
  KEY giftid (giftid,giftname,status),
  KEY status (status,exchangetime),
  KEY number (number,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_favorites;
CREATE TABLE modoer_favorites (
  fid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  shopid mediumint(8) unsigned NOT NULL default '0',
  addtime int(10) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY shopid (shopid),
  KEY addtime (addtime),
  KEY uid (uid,addtime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_flowers;
CREATE TABLE modoer_flowers (
  fid mediumint(8) unsigned NOT NULL auto_increment,
  reviewid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(16) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY reviewid (reviewid),
  KEY uid (uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_friends;
CREATE TABLE modoer_friends (
  fid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  fuid mediumint(8) unsigned NOT NULL default '0',
  fusername varchar(16) NOT NULL default '',
  addtime int(10) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY addtime (addtime,uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_gbooks;
CREATE TABLE modoer_gbooks (
  gid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  gbuid mediumint(8) unsigned NOT NULL default '0',
  gbusername varchar(16) NOT NULL default '',
  content text NOT NULL,
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (gid),
  KEY uid (uid,posttime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_getpassword;
CREATE TABLE modoer_getpassword (
  getpwid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  secode varchar(8) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  status tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (getpwid),
  KEY secode (secode,status)
) TYPE=MyISAM;


DROP TABLE IF EXISTS modoer_gifts;
CREATE TABLE modoer_gifts (
  giftid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(200) NOT NULL default '',
  available tinyint(1) NOT NULL default '0',
  displayorder tinyint(3) NOT NULL default '0',
  description text NOT NULL,
  price int(10) unsigned NOT NULL default '0',
  num int(10) unsigned NOT NULL default '0',
  thumb varchar(255) NOT NULL default '',
  picture varchar(255) NOT NULL default '',
  salevolume int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (giftid),
  KEY available (available)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_itemapply;
CREATE TABLE modoer_itemapply (
  applyid mediumint(8) unsigned NOT NULL auto_increment,
  shopid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  status tinyint(1) unsigned NOT NULL default '2',
  applyname varchar(100) NOT NULL default '',
  contact varchar(255) NOT NULL default '',
  pic varchar(255) NOT NULL default '',
  content mediumtext NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  checker varchar(30) NOT NULL default '',
  returned text NOT NULL,
  PRIMARY KEY  (applyid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_membereffect;
CREATE TABLE modoer_membereffect (
  id mediumint(8) unsigned NOT NULL default '0',
  idtype varchar(15) NOT NULL default '',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  dateline int(10) NOT NULL default '0',
  effect1 tinyint(1) unsigned NOT NULL default '0',
  effect2 tinyint(1) unsigned NOT NULL default '0',
  KEY id (id,idtype)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_members;
CREATE TABLE modoer_members (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  email varchar(60) NOT NULL default '',
  password varchar(32) NOT NULL default '',
  username varchar(16) NOT NULL default '',
  face varchar(32) NOT NULL default 'noface.gif',
  point int(10) NOT NULL default '0',
  coin int(10) NOT NULL default '0',
  newmsg smallint(5) unsigned NOT NULL default '0',
  regdate int(10) unsigned NOT NULL default '0',
  logintime int(10) unsigned NOT NULL default '0',
  loginip varchar(16) NOT NULL default '',
  logincount mediumint(8) unsigned NOT NULL default '0',
  groupid smallint(2) NOT NULL default '1',
  addshops int(10) unsigned NOT NULL default '0',
  reviews int(10) unsigned NOT NULL default '0',
  responds int(10) unsigned NOT NULL default '0',
  flowers int(10) unsigned NOT NULL default '0',
  pictures int(10) unsigned NOT NULL default '0',
  favorites int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (uid),
  UNIQUE KEY username (username),
  KEY email (email),
  KEY groupid (groupid),
  KEY point (point),
  KEY coin (coin)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_menus;
CREATE TABLE modoer_menus (
  menuid smallint(5) unsigned NOT NULL auto_increment,
  isclosed tinyint(1) NOT NULL default '0',
  flag varchar(60) NOT NULL default '',
  isfolder tinyint(1) unsigned NOT NULL default '0',
  clicks int(10) unsigned NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  scriptnav varchar(60) NOT NULL default '',
  mkey varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  icon varchar(60) NOT NULL default '',
  listorder smallint(5) NOT NULL default '0',
  PRIMARY KEY  (menuid)
) TYPE=MyISAM AUTO_INCREMENT=8;

INSERT INTO modoer_menus VALUES ('1','0','website','0','0','首页','index','','{SITE}','','1');
INSERT INTO modoer_menus VALUES ('2','0','website','0','0','{article-name}','article','','{article-url}','','2');
INSERT INTO modoer_menus VALUES ('3','0','website','0','0','美食餐馆','shop-cate-10','','{shop-url}cate.php?cd=10','','3');
INSERT INTO modoer_menus VALUES ('4','0','website','0','0','{card-name}','card','','{card-url}','','6');
INSERT INTO modoer_menus VALUES ('5','0','website','0','0','{coupon-name}','coupon','','{coupon-url}','','7');
INSERT INTO modoer_menus VALUES ('6','0','website','0','0','{exchange-name}','exchange','','{exchange-url}','','8');
INSERT INTO modoer_menus VALUES ('7','0','website','0','0','Modoer点评系统','','','http://bbs.modoer.com/','','9');

DROP TABLE IF EXISTS modoer_modules;
CREATE TABLE modoer_modules (
  moduleid smallint(5) unsigned NOT NULL auto_increment,
  flag varchar(30) NOT NULL default '',
  iscore tinyint(1) NOT NULL default '0',
  name varchar(60) NOT NULL default '',
  directory varchar(100) NOT NULL default '',
  disable tinyint(1) unsigned NOT NULL default '0',
  config text NOT NULL,
  version varchar(60) NOT NULL default '',
  releasetime date NOT NULL default '0000-00-00',
  reliant varchar(255) NOT NULL default '',
  author varchar(255) NOT NULL default '',
  introduce text NOT NULL,
  siteurl varchar(255) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  copyright varchar(255) NOT NULL default '',
  checkurl varchar(255) NOT NULL default '',
  PRIMARY KEY  (moduleid)
) TYPE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=gbk AUTO_INCREMENT=15;

INSERT INTO modoer_modules VALUES ('3','member','1','会员','member','0',' ','1.1','2008-09-30','','Moufer Studio',' ','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('4','shop','1','商铺点评','shop','0',' ','1.1','2008-09-30','','Moufer Studio',' ','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('5','space','1','个人空间','space','0',' ','1.1','2008-09-30','','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('6','card','1','会员卡','card','0',' ','1.0','2008-09-01','shop','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('7','exchange','1','兑奖中心','exchange','0','a:3:{s:11:\"thumb_width\";s:3:\"124\";s:12:\"thumb_height\";s:2:\"94\";s:7:\"seccode\";i:1;}','1.0','2008-09-01','','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('8','coupon','1','优惠券','coupon','0','a:5:{s:5:\"check\";s:1:\"0\";s:9:\"watermark\";s:1:\"0\";s:11:\"thumb_width\";s:2:\"72\";s:12:\"thumb_height\";s:2:\"47\";s:7:\"seccode\";s:1:\"1\";}','1.0','2008-10-03','shop','moufer','商铺优惠券模块','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/coupon.php');
INSERT INTO modoer_modules VALUES ('9','article','0','新闻咨询','article','0','a:3:{s:9:\"ownernews\";s:1:\"1\";s:17:\"ownernews_classid\";s:1:\"1\";s:15:\"ownernews_check\";s:1:\"0\";}','1.0','2008-09-18','','moufer','本地新闻发布，产品/商铺信息发布','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/article.php');
INSERT INTO modoer_modules VALUES ('10','links','0','友情链接','links','0','a:3:{s:8:\"num_logo\";i:10;s:8:\"num_char\";i:20;s:10:\"open_apply\";i:1;}','1.0','2008-09-18','','moufer','友情链接模块','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/links.php');
INSERT INTO modoer_modules VALUES ('11','ads','0','广告','ads','0','','1.0','2008-10-12','','moufer','网站广告管理','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/ads.php');

DROP TABLE IF EXISTS modoer_mylinks;
CREATE TABLE modoer_mylinks (
  linkid mediumint(8) unsigned NOT NULL auto_increment,
  title varchar(40) NOT NULL default '',
  link varchar(100) NOT NULL default '',
  logo varchar(100) NOT NULL default '',
  des varchar(255) NOT NULL default '',
  displayorder int(8) NOT NULL default '0',
  ischeck tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (linkid)
) TYPE=MyISAM AUTO_INCREMENT=4;

INSERT INTO modoer_mylinks VALUES ('1','Modoer点评系统','http://www.modoer.com','','Modoer 是一款点评网站管理系统，采用 PHP+MYSQL 设计，开放全部源码','0','1');
INSERT INTO modoer_mylinks VALUES ('2','毛豆志','http://www.modoer.cn','','Modoer点评系统开发日志','0','1');
INSERT INTO modoer_mylinks VALUES ('3','陌风软件','http://www.moufer.cn','http://www.moufer.cn/images/logo_88_31.gif','桌面Win程序开发，Flash屏保DIY，网络搜索先锋等','0','1');

DROP TABLE IF EXISTS modoer_pictures;
CREATE TABLE modoer_pictures (
  pid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(16) NOT NULL default '',
  shopid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  folder varchar(16) NOT NULL default '',
  filename varchar(20) NOT NULL default '',
  width smallint(5) unsigned NOT NULL default '0',
  height smallint(5) unsigned NOT NULL default '0',
  size int(10) unsigned NOT NULL default '0',
  comments varchar(60) NOT NULL default '',
  sort tinyint(1) NOT NULL default '0',
  browse int(10) NOT NULL default '0',
  tags varchar(60) NOT NULL default '',
  addtime int(10) NOT NULL default '0',
  status tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (pid),
  KEY uid (uid),
  KEY shopid (shopid),
  KEY title (title)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_plugins;
CREATE TABLE modoer_plugins (
  plugin_id smallint(5) unsigned NOT NULL auto_increment,
  module varchar(30) NOT NULL default '',
  available tinyint(1) NOT NULL default '1',
  orders smallint(5) NOT NULL default '0',
  directory varchar(60) NOT NULL default '',
  name varchar(100) NOT NULL default '',
  menu text NOT NULL,
  actionlist text NOT NULL,
  config text NOT NULL,
  tablenames text NOT NULL,
  version varchar(15) NOT NULL default '',
  author varchar(100) NOT NULL default '',
  copyright varchar(200) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  PRIMARY KEY  (plugin_id)
) TYPE=MyISAM AUTO_INCREMENT=3;

INSERT INTO modoer_plugins VALUES ('1','bcastr','1','0','bcastr/','图片轮换','a:2:{s:12:\"bcastrconfig\";s:8:\"参数配置\";s:12:\"bcastrmanage\";s:8:\"图片管理\";}','N;','a:1:{s:6:\"config\";s:54:\"0xFF0000|1|0xFAFAFA|65|0xFFFFFF|0xFF8040||6|2|1|_blank\";}','bcastr','1.0','moufer','Moufer Studio','一个图片轮换工具');
INSERT INTO modoer_plugins VALUES ('2','announcement','1','0','announcement/','网站公告','a:1:{s:19:\"announcement_manage\";s:8:\"公告管理\";}','a:2:{s:5:\"index\";a:2:{s:9:\"needlogin\";b:0;s:5:\"admin\";b:0;}s:4:\"list\";a:2:{s:9:\"needlogin\";b:0;s:5:\"admin\";b:0;}}','N;','announcements','1.0','moufer','Moufer Studio','简单的网站公告');

DROP TABLE IF EXISTS modoer_pmsgs;
CREATE TABLE modoer_pmsgs (
  pmid mediumint(8) unsigned NOT NULL auto_increment,
  senduid mediumint(8) unsigned NOT NULL default '0',
  recvuid mediumint(8) unsigned NOT NULL default '0',
  content text NOT NULL,
  subject varchar(60) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  new tinyint(1) NOT NULL default '1',
  delflag tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (pmid),
  KEY senduid (senduid,posttime),
  KEY recvuid (recvuid,posttime),
  KEY new (new)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_reports;
CREATE TABLE modoer_reports (
  reportid mediumint(8) unsigned NOT NULL auto_increment,
  reviewid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(16) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  sort tinyint(1) NOT NULL default '0',
  reportcontent text NOT NULL,
  disposal tinyint(1) NOT NULL default '2',
  posttime int(10) NOT NULL default '0',
  disposaltime int(10) NOT NULL default '0',
  reportremark text NOT NULL,
  PRIMARY KEY  (reportid),
  KEY uid (uid,username,email),
  KEY posttime (posttime),
  KEY reviewid (reviewid,sort)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_responds;
CREATE TABLE modoer_responds (
  rid mediumint(8) unsigned NOT NULL auto_increment,
  reviewid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  content text NOT NULL,
  posttime int(10) NOT NULL default '0',
  status tinyint(1) NOT NULL default '1',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY uid (uid,status),
  KEY reviewid (reviewid,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_reviews;
CREATE TABLE modoer_reviews (
  rid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  shopid mediumint(8) unsigned NOT NULL default '0',
  sort1 tinyint(1) unsigned NOT NULL default '0',
  sort2 tinyint(1) unsigned NOT NULL default '0',
  sort3 tinyint(1) unsigned NOT NULL default '0',
  sort4 tinyint(1) unsigned NOT NULL default '0',
  sort5 tinyint(1) unsigned NOT NULL default '0',
  sort6 tinyint(1) unsigned NOT NULL default '0',
  sort7 tinyint(1) unsigned NOT NULL default '0',
  sort8 tinyint(1) unsigned NOT NULL default '0',
  sumsort smallint(2) unsigned NOT NULL default '0',
  avgprice int(10) unsigned NOT NULL default '0',
  enjoy tinyint(1) unsigned NOT NULL default '0',
  content text NOT NULL,
  posttime int(10) NOT NULL default '0',
  isupdate tinyint(1) NOT NULL default '0',
  flower int(8) unsigned NOT NULL default '0',
  respond int(8) unsigned NOT NULL default '0',
  shoptags varchar(60) NOT NULL default '',
  producttags varchar(60) NOT NULL default '',
  suitplacetags varchar(60) NOT NULL default '',
  status tinyint(1) NOT NULL default '1',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY posttime (posttime,status),
  KEY uid (uid,status,posttime),
  KEY flower (flower,status),
  KEY respond (respond,status),
  KEY shopid (shopid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_searchindex;
CREATE TABLE modoer_searchindex (
  searchid mediumint(8) unsigned NOT NULL auto_increment,
  keyword varchar(200) NOT NULL default '',
  searchstring text NOT NULL,
  useip varchar(15) NOT NULL default '',
  uid mediumint(8) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  expiration int(10) unsigned NOT NULL default '0',
  total int(10) unsigned NOT NULL default '0',
  ids text NOT NULL,
  PRIMARY KEY  (searchid),
  KEY keyword (keyword)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shops;
CREATE TABLE modoer_shops (
  sid mediumint(8) unsigned NOT NULL auto_increment,
  shopname varchar(40) NOT NULL default '',
  subname varchar(40) NOT NULL default '',
  templateid smallint(5) unsigned NOT NULL default '0',
  classcode varchar(10) NOT NULL default '',
  areacode varchar(4) NOT NULL default '',
  streetcode varchar(6) NOT NULL default '',
  sumreview int(10) unsigned NOT NULL default '0',
  sumsort1 int(10) unsigned NOT NULL default '0',
  sumsort2 int(10) unsigned NOT NULL default '0',
  sumsort3 int(10) unsigned NOT NULL default '0',
  sumsort4 int(10) unsigned NOT NULL default '0',
  sumsort5 int(10) unsigned NOT NULL default '0',
  sumsort6 int(10) unsigned NOT NULL default '0',
  sumsort7 int(10) unsigned NOT NULL default '0',
  sumsort8 int(10) unsigned NOT NULL default '0',
  avgprice int(10) unsigned NOT NULL default '0',
  sumenjoy int(10) unsigned NOT NULL default '0',
  reviews int(10) unsigned NOT NULL default '0',
  pictures int(10) unsigned NOT NULL default '0',
  pageviews int(10) unsigned NOT NULL default '1',
  ownerid mediumint(8) unsigned NOT NULL default '0',
  owner varchar(20) NOT NULL default '',
  adduid mediumint(8) unsigned NOT NULL default '0',
  addname varchar(20) NOT NULL default '',
  addtime int(10) NOT NULL default '0',
  firstuid mediumint(8) unsigned NOT NULL default '0',
  firstname varchar(20) NOT NULL default '',
  finer tinyint(1) NOT NULL default '0',
  coupons int(10) NOT NULL default '0',
  effect1 mediumint(8) NOT NULL default '0',
  effect2 mediumint(8) NOT NULL default '0',
  mappoint varchar(60) NOT NULL default '',
  video varchar(255) NOT NULL default '',
  website varchar(200) NOT NULL default '',
  thumb varchar(100) NOT NULL default '',
  address varchar(60) NOT NULL default '',
  status tinyint(1) NOT NULL default '1',
  tel1 varchar(15) NOT NULL default '',
  tel2 varchar(15) NOT NULL default '',
  mobile varchar(15) NOT NULL default '',
  content text NOT NULL,
  PRIMARY KEY  (sid),
  KEY finer (finer),
  KEY cate (classcode,areacode,status),
  KEY adduid (adduid,status,addtime),
  KEY firstuid (firstuid,status,addtime),
  KEY ownerid (ownerid,status,addtime),
  KEY addtime (addtime,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shoptags;
CREATE TABLE modoer_shoptags (
  tagname varchar(20) NOT NULL default '',
  shopid mediumint(8) unsigned NOT NULL default '0',
  reviewid mediumint(8) unsigned NOT NULL default '0',
  tagsort enum('shop','product','suitplace') NOT NULL default 'shop',
  KEY reviewid (reviewid),
  KEY shopid (shopid,tagsort),
  KEY tagname (tagname,tagsort)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_spaces;
CREATE TABLE modoer_spaces (
  uid mediumint(8) unsigned NOT NULL default '0',
  space_styleid smallint(3) NOT NULL default '0',
  spacename varchar(30) NOT NULL default '',
  spacedescribe varchar(50) NOT NULL default '',
  pageview int(10) NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY pageviews (pageview)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_tags;
CREATE TABLE modoer_tags (
  tagid mediumint(8) unsigned NOT NULL auto_increment,
  tagname varchar(20) NOT NULL default '',
  closed tinyint(1) NOT NULL default '0',
  total int(10) unsigned NOT NULL default '0',
  panelcode varchar(2) NOT NULL default '',
  PRIMARY KEY  (tagid),
  KEY total (total,panelcode),
  KEY closed (closed,panelcode),
  KEY tagname (tagname,panelcode)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_templates;
CREATE TABLE modoer_templates (
  templateid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(20) NOT NULL default '',
  directory varchar(100) NOT NULL default '',
  copyright varchar(45) NOT NULL default '',
  tpltype varchar(15) NOT NULL default '',
  bind tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (templateid)
) TYPE=MyISAM AUTO_INCREMENT=3;

INSERT INTO modoer_templates VALUES ('1','默认模板','./templates/main/default','Moufer Studio','main','1');
INSERT INTO modoer_templates VALUES ('2','768.cc','./templates/item/yifei','768.cc','item','0');

DROP TABLE IF EXISTS modoer_travelers;
CREATE TABLE modoer_travelers (
  tid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  tuid mediumint(8) unsigned NOT NULL default '0',
  tusername varchar(16) NOT NULL default '',
  addtime int(10) NOT NULL default '0',
  PRIMARY KEY  (tid),
  KEY uid (uid,addtime),
  KEY tuid (tuid,addtime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_upshops;
CREATE TABLE modoer_upshops (
  upid mediumint(8) unsigned NOT NULL auto_increment,
  shopid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(16) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  upcontent text NOT NULL,
  disposal tinyint(1) NOT NULL default '2',
  posttime int(10) NOT NULL default '0',
  upremark text NOT NULL,
  disposaltime int(10) NOT NULL default '0',
  PRIMARY KEY  (upid),
  KEY shopid (shopid,posttime),
  KEY uid (uid,username,email,posttime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_usergroups;
CREATE TABLE modoer_usergroups (
  groupid smallint(6) NOT NULL auto_increment,
  grouptype enum('member','special','system') default 'member',
  groupname char(16) default NULL,
  PRIMARY KEY  (groupid)
) TYPE=MyISAM AUTO_INCREMENT=11;

INSERT INTO modoer_usergroups VALUES ('1','system','游客');
INSERT INTO modoer_usergroups VALUES ('2','system','禁止访问');
INSERT INTO modoer_usergroups VALUES ('3','system','禁止点评');
INSERT INTO modoer_usergroups VALUES ('10','member','注册会员');

DROP TABLE IF EXISTS modoer_userranks;
CREATE TABLE modoer_userranks (
  rankid smallint(6) NOT NULL auto_increment,
  rankname char(24) NOT NULL default '',
  point mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (rankid)
) TYPE=MyISAM AUTO_INCREMENT=4;

INSERT INTO modoer_userranks VALUES ('1','初级评客','0');
INSERT INTO modoer_userranks VALUES ('2','中级评客','200');
INSERT INTO modoer_userranks VALUES ('3','高级评客','500');

DROP TABLE IF EXISTS modoer_words;
CREATE TABLE modoer_words (
  id smallint(5) unsigned NOT NULL auto_increment,
  keyword varchar(255) NOT NULL default '',
  expression varchar(255) NOT NULL default '',
  admin varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;