<?php

error_reporting(E_ALL ^ E_NOTICE);

include 'user_info.php';
include 'dn2img.php';
include 'function.php';


/* Start user session or output an error */
session_name('DomainList');
if (!session_start()) {
    error('Cannot start a new PHP session. Please contact server administrator or webmaster!');
}

/* If no action parameter is set let's force visitor to login */
if (empty($_REQUEST['action'])) {
    if (isset($_SESSION['logged']) && $_SESSION['logged'] == $settings['user']) {
        dn_session_regenerate_id();
        add_domain_page();
    } else {
        login();
    }
} else {
    $action=htmlspecialchars($_REQUEST['action']);
}

/* Do the action that is set in $action variable */
if ($action == 'login') {
    checkpassword();
    $_SESSION['logged']=$_REQUEST['user'];
    dn_session_regenerate_id();
    manage_domain_page();
} 
elseif ($action == 'addDomain') {
    checklogin();
    add_domain_page();
}
elseif ($action == 'doAdd') {
    checklogin();
    doAdd();
}
elseif ($action == 'manageDomain') {
    checklogin();
    manage_domain_page();
}
elseif ($action == 'manageLink') {
    checklogin();
    manage_link_page();
}
elseif ($action == 'safeCenter') {
    checklogin();
    safe_center_page();
}
elseif ($action == 'editDomain') {
    checklogin();
    edit_domain_page();
}
elseif ($action == 'doEdit') {
    checklogin();
    doEdit();
}
elseif ($action == 'delDomain') {
    checklogin();
    delDomain();
}
elseif ($action == 'alert') {
    checklogin();
    expire_domain_alert();
}
elseif ($action == 'renewDomain') {
    checklogin();
    renewDomain();
}
elseif ($action == 'globalSetting') {
    checklogin();
    global_setting_page();
}

elseif ($action == 'logout') {
    logout();
} 
else {
    checklogin();
    manage_domain_page();
}
exit();
function changepassword(){
printHeader();
?>

<?php
printFooter();
exit();
}

function checklogin() {
	global $settings;
    if (isset($_SESSION['logged']) && $_SESSION['logged'] == $settings['user'])
    {
        return true;
    }
    else
    {
        error('您没有足够的权限查看此页面！');
    }
} // END checklogin

function checkpassword() {
global $settings;
if(empty($_POST['user'])){
	error('请输入用户名！');
	}
if($settings['user'] != $_POST['user']){
	error('用户: '.$_POST['user'].' 不存在！');
	}
    if(empty($_POST['pass']))
    {
        error('请输入您的密码！');
    }
    else
    {
        $pass=md5($_POST['pass']);
    }

    if ($pass != $settings['pass'])
    {
        error('密码不正确！');
    }

} // END checkpassword

function logout() {
session_unset();
session_destroy();
global $user,$pass;
printHeader();
?>

<div style="width:990px;height:auto;margin: 0 auto;background:#f4f4f4;border:#e4e4e4 1px solid;color:#333333;font-size: 14px;font-family: Arial, Helvetica, sans-serif; padding-bottom:10px;">
<p>&nbsp;</p>
<p style="text-align:center;"><b>成功登出系统！</b></p>
<p style="text-align:center;"><a href="?">点击此处重新登陆</a></p>
<p>&nbsp;</p>
</div>
<?php
printFooter();
exit();
} // END logout


?>

<?php
function error($myproblem) {
global $settings;
printHeader();
?>

<div style="width:990px;height:auto;margin: 0 auto;background:#f4f4f4;border:#e4e4e4 1px solid;color:#333333;font-size: 14px;font-family: Arial, Helvetica, sans-serif; padding-bottom:10px;">
<p>&nbsp;</p>
<p style="text-align:center;"><b>操作错误:</b></p>
<p style="text-align:center;"><?php echo($myproblem); ?></p>
<p style="text-align:center;"><a href="?">点击此处返回</a></p>
<p>&nbsp;</p>
</div>
<?php
printFooter();
exit();
} // END error

function dn_session_regenerate_id() {

    if (version_compare(phpversion(),"4.3.3",">=")) {
       session_regenerate_id();
    } else {
        $randlen = 32;
        $randval = '0123456789abcdefghijklmnopqrstuvwxyz';
        $random = '';
        $randval_len = 35;
        for ($i = 1; $i <= $randlen; $i++) {
            $random .= substr($randval, rand(0,$randval_len), 1);
        }

        if (session_id($random)) {
            setcookie(
                session_name('DomainList'),
                $random,
                ini_get("session.cookie_lifetime"),
                "/"
            );
            return true;
        } else {
            return false;
        }
    }

}

?>
