<?php
class Payment_Adapter_Custom extends Payment_AdapterAbstract
{
    public function init()
    {
        
    }

    public static function getConfig()
    {
        return array(
            'supports_one_time_payments'   =>  true,
            'supports_subscriptions'       =>  true,
            'description'     =>  'Custom payment gateway allows you to give instructions how can your client pay invoice. All system, client, order and invoice details can be printed. HTML and JavaScript code is supported.',
            'form'  => array(
                'single' => array('textarea', array(
                            'label' => 'Enter your text for single payment information',
                    ),
                 ),
                'recurrent' => array('textarea', array(
                            'label' => 'Enter your text for subscription information',
                    ),
                 ),
            ),
        );
    }

    /**
     * Return payment gateway type
     * @return string
     */
    public function getType()
    {
        return Payment_AdapterAbstract::TYPE_HTML;
    }

    /**
     * Return payment gateway call url
     * @return string
     */
    public function getServiceURL()
    {
		return NULL;
    }

    /**
     * Init call to webservice or return form params
     * @param Payment_Invoice $invoice
     */
    public function singlePayment(Payment_Invoice $invoice)
    {
        return $this->_parse('single', $invoice);
    }

    /**
     * Perform recurent payment
     * @param Payment_Invoice $invoice
     */
    public function recurrentPayment(Payment_Invoice $invoice)
    {
        return $this->_parse('recurrent', $invoice);
    }
    
    public function isIpnValid($data, Payment_Invoice $invoice)
    {
        return false;
    }
    
    public function getTransaction($data, Payment_Invoice $invoice)
    {
        $tx = new Payment_Transaction();
        $tx->setStatus(Payment_Transaction::STATUS_COMPLETE);
        $tx->setType(Payment_Transaction::TXTYPE_PAYMENT);
        return $tx;
    }

    private function _parse($param, $invoice)
    {
        $client = $invoice->getBuyer();
        $items  = $invoice->getItems();

        $rep['{{invoice.id}}']              = $invoice->getId();
        $rep['{{invoice.number}}']          = $invoice->getNumber();
        $rep['{{invoice.title}}']           = $invoice->getTitle();
        $rep['{{invoice.subtotal}}']        = $invoice->getTotal();
        $rep['{{invoice.total}}']           = $invoice->getTotalWithTax();
        $rep['{{invoice.tax}}']             = $invoice->getTax();
        $rep['{{invoice.currency}}']        = $invoice->getCurrency();
        
        $rep['{{client.first_name}}']       = $client->getFirstName();
        $rep['{{client.last_name}}']        = $client->getLastName();
        $rep['{{client.email}}']            = $client->getEmail();
        $rep['{{client.address}}']          = $client->getAddress();
        $rep['{{client.state}}']            = $client->getState();
        $rep['{{client.city}}']             = $client->getCity();
        $rep['{{client.country}}']          = $client->getCountry();
        $rep['{{client.zip}}']              = $client->getZip();
        $rep['{{client.phone}}']            = $client->getPhone();

        $text = $this->getParam($param);
        $html = str_replace(Array('%7B', '%7D'), Array('{', '}'), $text);
		$html = strtr($html, $rep);
        return $html;
    }
}
