//pay js
export default{
  data(){
    return {
      userType:'alipay',
      payType:'alipay'
    };
  },
  mounted(){
    //onez.data(this,['items']);
  },
  watch:{
    payType(){
      this.$root.autoResize();
    },
    pagedata(){
      var payType='alipay';
      if(!this.pagedata.is_alipay){
        payType='wxpay';
        if(!this.pagedata.is_wxpay){
          payType='account';
          if(this.pagedata.myuserid==0){
            payType='user';
          }
        }
      }
      this.payType=payType;
    }
  },
  methods:{
    pay(){
      var that=this;
      if(this.pagedata.myuserid==0){
        if(this.$refs.email.value.length<1){
          onez.alert('请正确您的电子邮箱');
          return;
        }
      }
      var postdata={
        ac:'pay',
        paytype:this.payType,
        usertype:this.userType,
      };
      if(this.pagedata.myuserid==0){
        postdata.qq=this.$refs.qq.value;
        postdata.email=this.$refs.email.value;
      }
      onez.loading(true);
      this.post(postdata,(res)=>{
        if(res.tip){
          onez.tip(res.tip);
        }
        if(res.message){
          onez.alert(res.message);
        }
        if(res.error){
          onez.alert(res.error);
        }
        if(res.result){
          if(res.result=='ok'){
            onez.loading(false);
            onez.api(this,'bs.cart:clearCart').then((r)=>{
              this.carts=[];
            });
            if(this.pagedata.myuserid==0){
              layer.closeAll();
              setTimeout(()=>{
                onez.alert('购买成功，请查收您的电子邮件');
              },300);
              return;
            }
            var action='/user/orders.php?orderno='+res.orderno;
            if(res.data.token=='vip'){
              action='/user/vip.php';
            }else if(res.data.token=='renew'){
              action='/user/vip.php';
            }else if(res.data.token=='charge'){
              action='/user/money.php';
            }
            onez.onEvent({
              token:'page',
              action:action,
            },this);
          }else if(res.result=='next'){
            if(onez.is_mobile()){
              location.href=res.url;
            }
            var payResult=false;//是否已返回支付结果
            var timer;
            var img=new Image();
            img.onload=function(){
              onez.loading(false);
              var index=onez.win('<img src="'+res.qrcode+'" style="width:320px;height:320px;margin:5px auto;display:block;" />',{
                width:330,
                height:370,
                shade:1,
                title:res.title||'请扫码支付',
              },{
                $destroy:function(){
                  if(timer){
                    clearInterval(timer);
                  }
                  if(!payResult){
                    onez.tip('支付已取消');
                  }
                }
              },'pay');
              //等待支付结果
              timer=setInterval(()=>{
                var postdata={};
                postdata.ac='check';
                postdata.$purl='bs.pay:/php/pay.php';
                postdata.orderno=res.orderno;
                that.post(postdata,(data2)=>{
                  if(data2.ok){
                    layer.close(index);
                    onez.api(that,'bs.cart:clearCart').then((r)=>{
                      that.carts=[];
                    });
                    if(that.pagedata.myuserid==0){
                      layer.closeAll();
                      setTimeout(()=>{
                        onez.alert('购买成功，请查收您的电子邮件');
                      },300);
                      return;
                    }
                    var action='/user/orders.php?orderno='+res.orderno;
                    if(res.data.token=='vip'){
                      action='/user/vip.php';
                    }else if(res.data.token=='renew'){
                      action='/user/vip.php';
                    }else if(res.data.token=='charge'){
                      action='/user/money.php';
                    }
                    onez.onEvent({
                      token:'page',
                      action:action,
                    },that);
                  }else if(data2.errMsg){
                    layer.close(index);
                    onez.alert(data2.errMsg);
                  }
                });
              },2000);
            };
            img.onerror=function(){
              onez.alert('获取支付信息失败，请重试！');
            };
            img.src=res.qrcode;
          }
        }else{
          onez.loading(false);
        }
      });
    },
    setUserType(type){
      this.userType=type;
    },
    selPayType(item){
      this.payType=item.token;
    }
  }
}
