//form2 js
export default{
  data(){
    return {
      isInit:false,
      lastkey:'',
      calendar_show:false,
      fields:{},
      picker_columns:[],
      picker_show:false
    };
  },
  mounted(){
    this.reset();
  },
  watch:{
    data(){
      this.reset();
    }
  },
  methods:{
    reset(){
      if(this.data && this.data.ready){
        if(this.isInit){
          return;
        }
        this.isInit=true;
        var fields=[];
        var oldFields=JSON.parse(JSON.stringify(this.data.fields));
        oldFields.forEach((item,index)=>{
          item.readonly=false;
          if(item.type=='select'){
            item.readonly=true;
            var keys=[];
            var names=[];
            if(typeof item.options=='object'){
              item.options.forEach((item2)=>{
                keys.push(item2.token);
                names.push(item2.name);
              });
            }
            item.options_keys=keys;
            item.options_names=names;
          }else if(item.type=='number'){
            this.data.data[item.key]=this.data.data[item.key]||0;
          }else if(item.type=='switch'){
            this.data.data[item.key]=this.data.data[item.key]=='1';
          }else if(item.type=='date'){
            item.readonly=true;
          }
          fields.push(item);
        });
        this.fields=fields;
      }
    },
    fieldClick(item){
      if(item.type=='date'){
        this.lastkey=item.key;
        this.calendar_show=true;
      }else if(item.type=='select'){
        this.lastkey=item.key;
        this.picker_show=true;
        this.picker_columns=item.options_names;
      }
    },
    calendar_confirm(date){
      var value=`${date.getFullYear()}-${date.getMonth() + 1}-${date.getDate()}`;
      this.data.data[this.lastkey]=value;
      this.calendar_show=false;
    },
    picker_confirm(value){
      this.data.data[this.lastkey]=value;
      this.picker_show=false;
    },
    afterRead(file){
      file.status = 'uploading';
      file.message = '上传中...';
      file.isImage = true;
      this.toBase64(file.file).then((base64)=>{
        this.post({ac:'upload',base64:base64.split('base64,')[1]},(res)=>{
          if(res.error){
            onez.tip(res.error);
            file.status = 'failed';
            file.message = '上传失败';
          }else{
            file.url=res.url;
            file.status = 'done';
            file.message = '上传成功';
          }
        });
      }).catch(()=>{
        file.status = 'failed';
        file.message = '上传失败';
      });
    },
    toBase64(file){
      return new Promise((resolve, reject) => {
        let reader = new FileReader();
        let fileResult = "";
        reader.readAsDataURL(file);　　　　　//开始转
        reader.onload = function() {
          fileResult = reader.result;
        };　　　　　//转 失败
        reader.onerror = function(error) {
          reject(error);
        };　　　　　//转 结束  咱就 resolve 出去
        reader.onloadend = function() {
          resolve(fileResult);
        };
      });
    },
    submit(data){
      this.fields.forEach((item,index)=>{
        if(item.type=='number'){
          data[item.key]=this.data.data[item.key]||0;
        }else if(item.type=='switch'){
          data[item.key]=this.data.data[item.key]?1:0;
        }else if(item.type=='file'){
          var values=[];
          this.data.data[item.key].forEach((item2)=>{
            if(item2.status!='done'){
              onez.alert('文件中，请稍候提交~');
              return;
            }
            values.push(item2.url);
          });
          data[item.key]=values;
        }
      });
      var postdata={onez:data};
      postdata['action']='data';
      postdata['ac']='submit';
      postdata['$action']=this.$root.action;
      postdata['$file']=this.$root.path;
      onez.post(postdata,(data)=>{
        if(data.error){
          onez.alert(data.error);
          return;
        }
        if(data.message){
          if(data.goto){
            onez.alert(data.message,()=>{
              onez.location(data.goto);
            });
          }else{
            onez.alert(data.message);
          }
        }else{
          if(data.goto){
            onez.location(data.goto);
          }else{
            this.$emit('submit',data,postdata.onez);
          }
        }
      });
    }
  }
}