$(document).ready(function()
{
    $('[name^=objectType]').change(function()
    {
        var objectType = $(this).val();
        var checked    = $(this).prop('checked');
        if(objectType != 'project')
        {
            if(checked)
            {
                $('[name^=objectType]').not(this).not('[value=project]').prop('checked', false).change();
            }
            if(objectType == 'order')
            {
                $('#customer').parents('tr').toggle(checked);
                getOrders($('#customer').val());
            }
            if(objectType == 'contract')
            {
                $('#customer').parents('tr').toggle(checked);
                getContracts($('#customer').val());
            }
        }
        $('#' + objectType).parents('tr').toggle(checked);
    });

    /* show or hide detail. */
    $(document).on('click', '.detail', function()
    {
        if($(this).find('i').hasClass('icon-double-angle-down'))
        {
            $('input[name^=dateList]').val($('#date').val());
            $('select[name^=categoryList]').val($('#category').val()).trigger('chosen:updated');
            $('select[name^=relatedList]').val($('#related').val()).trigger('chosen:updated');
            $('textarea[name^=descList]').val($('#desc').val());

            $('#refund-detail').removeClass('hidden');
            $('#money').prop('readonly', 'readonly');
            $('#invoice').prop('readonly', 'readonly');
            $('#refund-date').addClass('hidden');
            $('#refund-related').addClass('hidden');
            $(this).find('i').removeClass('icon-double-angle-down');
            $(this).find('i').addClass('icon-double-angle-up');
        }
        else
        {
            $('input[name^=moneyList]').val('');
            $('#refund-detail').addClass('hidden');
            $('#money').prop('readonly', '');
            $('#invoice').prop('readonly', '');
            $('#refund-date').removeClass('hidden');
            $('#refund-related').removeClass('hidden');
            $(this).find('i').removeClass('icon-double-angle-up');
            $(this).find('i').addClass('icon-double-angle-down');
        }
        return false;
    });

    /* update money. */
    function updateMoney()
    {
        var money = 0;
        $('input[name^=moneyList]').each(function()
        {
            if($.isNumeric($(this).val()))
            {
                money += parseFloat($(this).val());
            }
        });
        money = Math.round(money * 100) / 100;
        $('#money').val(money);
        return false;
    }

    function updateInvoice()
    {
        var invoice = 0;
        $('input[name^=invoiceList]').each(function()
        {
            if($.isNumeric($(this).val()))
            {
                invoice += parseFloat($(this).val());
            }
        });
        invoice = Math.round(invoice * 100) / 100;
        $('#invoice').val(invoice);
        return false;
    }
  
    $('input[name^=moneyList]').change(updateMoney);
    $('input[name^=invoiceList]').change(updateInvoice);

    /* Add a trade detail item. */
    $(document).on('click', '.table-detail .plus', function()
    {
        var tr = $(this).closest('tr');
        tr.after($('#detailTpl').html().replace(/key/g, v.key));
        tr.next().find('input[name^=dateList]').val($('#date').val()).fixedDate().datetimepicker(
        {
            language:  config.clientLang,
            weekStart: 1,
            todayBtn:  1,
            autoclose: 1,
            todayHighlight: 1,
            startView: 2,
            minView: 2,
            forceParse: 0,
            format: 'yyyy-mm-dd'
        });
        tr.next().find('select[name^=categoryList]').val($('#category').val()).chosen(window.chosenDefaultOptions);
        tr.next().find('select[name^=relatedList]').val($('#related').val()).chosen(window.chosenDefaultOptions);
        tr.next().find('textarea[name^=descList]').val($('#desc').val());
        $('input[name^=moneyList]').change(updateMoney);
        $('input[name^=invoiceList]').change(updateInvoice);
        v.key++;
        return false;
    });

    /* Remove a trade detail item. */
    $(document).on('click', '.table-detail .minus', function()
    {
        if($('#detailBox tr').size() > 1)
        {
            $(this).closest('tr').remove();
        }
        else
        {
            $(this).closest('tr').find('input,select').val('');
        }
        $('input[name^=moneyList]').change();
        $('input[name^=invoiceList]').change();
        return false;
    });
});

function getOrders(customer)
{
    var order = $('#order').val();
    $('#order').load(createLink('crm.order', 'ajaxGetOrders', 'customer=' + customer), function()
    {
        $('#order').val(order).trigger('chosen:updated');
    });
}

function getContracts(customer)
{
    var contract = $('#contract').val();
    $('#contract').load(createLink('crm.contract', 'getOptionMenu', 'customer=' + customer), function()
    {
        $('#contract').val(contract).trigger('chosen:updated');
    });
}
