<?php
/**
 * The mail file of customer module of RanZhi.
 *
 * @copyright   Copyright 2009-2018 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      Chu Jilu <chujilu@cnezsoft.com>
 * @package     customer
 * @version     $Id: sendmail.html.php 867 2010-06-17 09:32:58Z yuren_@126.com $
 * @link        http://www.ranzhi.org
 */
?>
<?php $mailTitle = $lang->refund->common . $lang->refund->review . '#' . $refund->id . ' ' . zget($users, $refund->createdBy) . ' - ' . $refund->name;?>
<?php include '../../../sys/common/view/mail.header.html.php';?>
<tr>
  <td>
    <table cellpadding='0' cellspacing='0' width='700' style='border: none; border-collapse: collapse;'>
      <tr>
        <td style='padding: 10px; background-color: #F8FAFE; border: none; font-size: 14px; font-weight: 500; border-bottom: 1px solid #e5e5e5;'>
          <?php
          $mode = '';
          if($refund->status == 'pass') $mode = 'todo';
          if($refund->status == 'wait' or $refund->status == 'doing') $mode = 'review';

          $param = "id={$refund->id}";
          if($mode) $param .= "&mode={$mode}";
          $refundLink = commonModel::getSysURL() . $this->createLink('oa.refund', 'view', $param);
          ?>
          <?php echo html::a($refundLink, $mailTitle, "style='color: #333; text-decoration: underline;'");?>
        </td>
        <td style='width:50px; background-color: #F8FAFE; border: none; font-size: 14px; border-bottom: 1px solid #e5e5e5;'>
          <?php
          if($mode == 'review') echo html::a($refundLink, $lang->refund->review);
          if($mode == 'todo')   echo html::a($refundLink, $lang->refund->common);
          ?>
        </td>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td style='padding: 10px; border: none;'>
    <fieldset style='border: 1px solid #e5e5e5'>
      <div style='padding:5px;'>
        <table style='font-size: 13px; width: 100%; text-align: left;'>
          <tr>
            <th style='width:80px;'><?php echo $lang->refund->createdBy?></th>
            <td><?php echo zget($users, $refund->createdBy)?></td>
            <th style='width:80px;'><?php echo $lang->refund->money?></th>
            <td><?php echo $refund->money?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->date?></th>
            <td><?php echo formatTime($refund->date, DT_DATE1);?></td>
            <th><?php echo $lang->refund->status?></th>
            <td>
              <span style='color: red'>
                <?php
                if(!empty($refund->secondReviewer))
                {
                    echo zget($users, $refund->firstReviewer) . $lang->refund->statusList['pass'];
                    echo '<br>' . zget($users, $refund->secondReviewer) . zget($lang->refund->statusList, $refund->status);
                }
                elseif(!empty($refund->firstReviewer))
                {
                    echo zget($users, $refund->firstReviewer);
                    $status = $refund->status == 'doing' ? 'pass' : $refund->status;
                    echo zget($lang->refund->reviewStatusList, $status);
                    if($refund->status == 'doing' && !empty($this->config->refund->secondReviewer))
                    {
                        echo '<br>' . sprintf($lang->refund->reviewing, zget($users, $this->config->refund->secondReviewer));
                    }
                }
                else
                {
                    if($refund->status == 'draft') echo $lang->refund->statusList['draft'];
                    if($refund->status == 'wait' && !empty($this->config->refund->firstReviewer)) echo sprintf($lang->refund->reviewing, zget($users, $this->config->refund->firstReviewer));
                }
                ?>
              </span>
            </td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->category?></th>
            <td colspan='3'><?php echo zget($categories, $refund->category, ' ')?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->related?></th>
            <td colspan='3'><?php foreach(explode(',', $refund->related) as $account) echo zget($users, $account) . ' '?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->desc?></th>
            <td colspan='3'><?php echo $refund->desc?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->firstReviewer?></th>
            <td><?php echo $refund->firstReviewerLabel?></td>
            <th><?php echo $lang->refund->firstReviewDate?></th>
            <td><?php echo formatTime($refund->firstReviewDate, DT_DATETIME1)?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->secondReviewer?></th>
            <td><?php echo $refund->secondReviewerLabel?></td>
            <th><?php echo $lang->refund->secondReviewDate?></th>
            <td><?php echo formatTime($refund->secondReviewDate, DT_DATETIME1)?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->refundBy?></th>
            <td><?php echo zget($users, $refund->refundBy)?></td>
            <th><?php echo $lang->refund->refundDate?></th>
            <td><?php echo formatTime($refund->refundDate, DT_DATETIME1)?></td>
          </tr>
          <tr>
            <th><?php echo $lang->refund->reason?></th>
            <td colspan='3'><?php echo $refund->reason?></td>
          </tr>
        </table>
        <?php if(!empty($refund->detail)):?>
        <p><?php echo $lang->refund->detail?></p>
        <table style='font-size: 13px; width: 100%; text-align: left;'>
          <tr>
            <th style='width: 80px'><?php echo $lang->refund->date?></th>
            <th style='width: 100px'><?php echo $lang->refund->category?></th>
            <th style='width: 60px'><?php echo $lang->refund->money?></th>
            <th style='width: 60px'><?php echo $lang->refund->status?></th>
            <th style='width: 80px'><?php echo $lang->refund->related?></th>
            <th style='width: 240px'><?php echo $lang->refund->desc?></th>
          </tr>
          <?php foreach($refund->detail as $detail):?>
          <tr>
            <td><?php echo formatTime($detail->date, DT_DATE1);?></td>
            <?php $category = zget($categories, $detail->category, ' ')?>
            <td title='<?php echo $category;?>'><div style='width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;'><?php echo $category?></div></td>
            <td><?php echo $detail->money?></td>
            <td><?php echo zget($lang->refund->statusList, $detail->status)?></td>
            <?php $related = '';?>
            <?php foreach(explode(',', $detail->related) as $account) $related .= zget($users, $account) . ' '?>
            <td title='<?php echo $related;?>'><div style='width: 80px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;'><?php echo $related;?></div></td>
            <td title='<?php echo $detail->desc;?>'><div style='width: 240px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;'><?php echo $detail->desc?></div></td>
          </tr>
          <?php endforeach;?>
        </table>
        <?php endif;?>
      </div>
    </fieldset>
  </td>
</tr>
<?php include '../../../sys/common/view/mail.footer.html.php';?>
