<?php session_start(); 
include("simple-php-captcha.php");

//////////////  设置  /////////
// insertToTop: 新数据插的位置
// True：新数据插在最前面
// False：新数据插在最后面
$insertToTop = true;

// delimiter: 分隔符号
// 设置数据文件里的分隔符号,默认为 竖线
$delimiter = "|";

//captcha: 验证码开关
$captcha = true;

//////////////////////////////

?>

<!DOCTYPE html>
<html>
<head>
<title>登记账号</title>
<meta name="Author" contect="www.lfhacks.com">
<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta name="Robots" contect= "none">
<meta charset="UTF-8">
<style>
body {direction: ltr;background: #FFFFFF;font-size: 1.0em;font-family: Tahoma, Arial, sans-serif;}
textarea {padding: 2pt;border: 1px solid #000000;width: 50%;font-size:1.2em;}
input[type="submit"]{margin: 6px 0;font-size:1.2em;width:110px;}
.warning, .warning a:hover,.warning a,.warning a:visited{color:red;font-size:1.0em;}
table{border-collapse: collapse;border-spacing: 0;margin:10px;}
td{padding:2px 12px;border: 1px #ccc solid;}
.link, .link a:hover,.link a,.link a:visited{font-size:1em; color:blue;margin:5px;}
@media screen and (max-width: 800px) {
textarea {width: 100%;height: auto;}
.btn{font-size: 1.1em;}
.post {width: 100%;}
.warnpost {width: 100%;}
}
</style>
</head>
<body>
<?php

$filename = "./data.txt";
$header = array("日期","帐号","备注");
file_exists($filename) or file_put_contents($filename, "\xEF\xBB\xBF".implode($delimiter, $header)."\r\n");
if (isset($_POST["account"])){
    $account = $_POST["account"];
    $comment = $_POST["comment"];
    if($account==''){
        show("帐号必填。");
    }elseif($captcha){
        if(strtolower($_SESSION['captcha']['code']) == strtolower($_POST["captcha"])){
            insertShow($delimiter,$account,$comment);
        }else{
            show("验证码错误!");
        }
    }else{
        insertShow($delimiter,$account,$comment);
    }
}else{
    show();
}

function insertShow($delimiter,$account,$comment){
    insertLine(implode($delimiter, array(date("Y.m.d H:i:s"),$account,$comment)));
    show("成功添加。 帐号: $account, 备注: $comment");
}

function show($message=""){
    global $captcha, $delimiter, $insertToTop, $filename;
    echo '<p class="warning"><a href="https://www.lfhacks.com/index.php?s=file_download&id=23">下载最新代码（最新版本 v0.4）</a></p>';
    echo '<p class="warning"><a href="https://www.lfhacks.com/tech/lfhacks-submit">版本历史</a></p>';
    echo '<form method="POST" action="index.php"> ';
    echo '<p>帐号(必填)：<input name="account" size="40"></input></p>';
    echo '<p>备注：<input name="comment" size="40" ></p>';
    if($captcha){
        $_SESSION = array();
        $_SESSION['captcha'] = simple_php_captcha();
        echo '<img src="' . $_SESSION['captcha']['image_src'] . '" alt="CAPTCHA code">';
        echo '<p><input type="text" name="captcha" size="30" placeholder="请输入验证码，不区分大小写"></p>';
    }
    echo '<span class="warning">'.$message.'</span>';      
    echo '<p><div class=btn><input id="submit" name="Btn" type="submit" value="提交"></div></form>';
    echo '<div class="link"><a href="'.$filename.'" download> 下载数据文件 </a><span>(新数据加在最'.($insertToTop?'上':'下').'面,以 '.$delimiter.' 为分隔符)</span></div>';
    echo convertTable(); 
}

function convertTable()
{
    global $delimiter, $filename;
    $result="<table>\n\n";
    $lines = explode("\n", str_replace("\r\n","\n",rtrim(file_get_contents($filename))));
    foreach ($lines as $line) {
        $result.= "<tr>\n";
        $cells = explode($delimiter, $line);
        foreach($cells as $cell){
            $result.= "<td>" . htmlspecialchars($cell) . "</td>";
        }
        $result.= "</tr>\n";
    }
    $result.= "\n</table>";

    return $result;
}   

function insertLine($newline){
    global $insertToTop, $filename;
    if($insertToTop){
        $lines = explode("\n", str_replace("\r\n","\n",rtrim(file_get_contents($filename))));
        array_splice($lines,1,0,$newline);
        file_put_contents($filename, implode("\r\n", $lines)."\r\n"); 
    }else{
        file_put_contents($filename, file_get_contents($filename).$newline."\r\n"); 
    }
}

?>

<div class="link"><p>©<?php echo date("Y");?>&nbsp;<a href="https://www.lfhacks.com">LFhacks.com</a></p></div>
</body>
</html>