<?php 
//create by lingp 2011-07-11

class CBaseSource
{
	var $cfg;
	var $db;
	var $is_eof;
	
	function Init($cfg)
	{
		$this->cfg = $cfg;
	}
	
	function Connect()
	{
		echo "Դ\n";	
	}
	
	function Open()
	{
		echo "Դ";	
	}
	
	function Close()
	{
		echo "رԴ\n";	
	}
	
	function Fetch(&$data)
	{
		echo "ȡ\n";
		return false;
	}
	
	function Eof()
	{
		return false;	
	}
	
	function Append(&$data)
	{
		echo "\n";	
	}
};

class CSourceExcell extends CBaseSource
{
	var $sheets;
	var $row_count;
	var $cell_count;
	var $fetch_row;
	
	function CSourceExcell()
	{
		$this->fetch_row = 0;
	}
	
	function Connect()
	{
		$this->db = new Spreadsheet_Excel_Reader();
		$this->db->setOutputEncoding('CP936');
		$this->db->read($this->cfg->src);
		$this->sheets = $this->db->sheets[$this->cfg->link_id];	
	}
	
	function Open()
	{		
		$this->row_count = $this->sheets['numRows'];
		$this->cell_count = $this->sheets['numCols'];
		if($this->cfg->begin == 0)
			$this->cfg->begin = 1;
		if($this->cfg->end == 0)
			$this->cfg->end = $this->row_count;
		
		$this->fetch_row = $this->cfg->begin;
		$this->is_eof = false;
	}
	
	function Close()
	{
		echo "رExcellԴ\n";	
	}
	
	function Fetch(&$data)
	{
		$data = "";
		if($this->fetch_row >= $this->row_count || $this->fetch_row >= $this->cfg->end)
		{
			$this->is_eof = true;
			return false;
		}
		
		$cell =  $this->sheets['cells'][$this->fetch_row];
		for($i=1; $i<=$this->cell_count; $i++)
			$data[$i-1] = $cell[$i];
		
		$this->fetch_row++; 
		return true;
	}
	
	function Eof()
	{
		return $this->is_eof;	
	}
	
	function Append(&$process)
	{
		for($i=1;$i<sizeof($this->cfg->records); $i++)
		{
				$this->fetch_row++;
				$this->sheets['cells'][$this->fetch_row][$i] = $process[$i-1]->dst_data;
		}
	}
};

class CSourceTable extends CBaseSource
{		
	function Connect()
	{
		if($this->cfg->db_link->link_type == 0) //mysql
			$this->db = new CMysql($this->cfg->db_link->db_host, $this->cfg->db_link->db_user, $this->cfg->db_link->db_pwd, $this->cfg->db_link->db_name);
		else if( $this->cfg->db_link->link_type == 1 ) //sqlite
			$this->db = new CSqlite($this->cfg->db_link->db_host);	
	}
	
	function Open()
	{			
		$sql = "select * from ".$this->cfg->src;
		$this->db->ExeQuerySql($sql);
		
	}
	
	function Close()
	{
		$this->db->FreeResult();
		echo "رݿ\n";	
	}
	
	function Fetch(&$data)
	{
		if(!$this->db->FetchRow())
			return false;
			
		for($i=0; $i<sizeof($this->cfg->record); $i++)
			$data[$i] = $this->db->Get($this->cfg->record[$i]->field_name);
		
		return true;
	}
	
	function Eof()
	{
		return $this->db->IsEof();
	}
	
	function Append(&$process)
	{
		$sql = "insert into ".$this->cfg->src ." ( ";
		for($i=0;$i<sizeof($this->cfg->records); $i++)
		{
			if($i>0) $sql = $sql .",";
			$sql = $sql . $this->cfg->records[$i]->field_name;
		}
		
		$sql = $sql . ") values (";
		for($i=0;$i<sizeof($this->cfg->records);$i++)
		{
			if($i>0) $sql = $sql .",";
			
			if($this->cfg->records[$i]->field_type==3 || $this->cfg->records[$i]->field_type==4)
				$sql = $sql . "'". $process[$i]->dst_data . "'";
			else
				$sql = $sql . $process[$i]->dst_data;
		}
		$sql = $sql . ")";
		
		$this->db->ExeSql($sql); 
	}
};

class CSourceSql extends CBaseSource
{	
	function Connect()
	{
		if($this->cfg->db_link->link_type == 0) //mysql
			$this->db = new CMysql($this->cfg->db_link->db_host, $this->cfg->db_link->db_user, $this->cfg->db_link->db_pwd, $this->cfg->db_link->db_name);
		else if( $this->cfg->db_link->link_type == 1 ) //sqlite
			$this->db = new CSqlite($this->cfg->db_link->db_host);	
	}
	
	function Open()
	{
		$sql = $this->cfg->src;
		$this->db->ExeQuerySql($sql);
	}
	
	function Close()
	{
		$this->db->FreeResult();
		echo "رݿ\n";	
	}
	
	function Fetch(&$data)
	{
		if(!$this->db->FetchRow())
			return false;
		
		for($i=0; $i<sizeof($this->cfg->records); $i++)
		{
			$data[$i] = $this->db->Get($this->cfg->records[$i]->field_name);
		}
		
		return true;
	}
	
	function Eof()
	{
		return $this->db->IsEof();
	}	
};

class CSourceFile extends CBaseSource
{};

?>
