<?php 
//create by lingp 2011-07-11
//error_reporting(E_ALL);
date_default_timezone_set('PRC');

class Cprocess
{
	var $dst_id;
	var $src_id;
	var $dst_data;
	var $src_data;
	var $cond;
	var $plugin;
	var $param;
	
	function Cprocess()
	{
		$this->src_data = array();
	}
	
	function Check(&$data)
	{
		$this->src_data = "";
		for($i=0; $i<sizeof($this->src_id); $i++) 
			$this->src_data[$i] = $data[$this->src_id[$i]]; 
		
		return $this->cond->Check($this->src_data);
	}
	
	function Execute(&$data)
	{
		$this->src_data = "";
		for($i=0; $i<sizeof($this->src_id); $i++) 
		{
			$this->src_data[$i] = $data[$this->src_id[$i]]; 
		}
		
		$this->dst_data = $this->plugin->Execute($this->src_data, $this->param);
	}	
};

class CObserver
{
	var $db_src;
	var $process;
	
	function CObserver()
	{
		$this->process = array();
	}
	
	function Init(&$cfg)
	{
		for($i=0; $i<sizeof($cfg->process); $i++)
		{
			$p = new Cprocess();
			$p->dst_id = $cfg->process[$i]->field_dst;
			$p->src_id = $cfg->process[$i]->field_src;
			$p->cond = $this->CreateCond($cfg->process[$i]);
			$p->plugin = $this->CreatePlugin($cfg->process[$i]);
			$p->param = $cfg->process[$i]->param;
			
			$this->process[sizeof($this->process)] = $p;
		}
		
		return true;
	}
	
	function Update(&$data)
	{
		//
		for($i=0; $i<sizeof($this->process); $i++)
		{
			if(!$this->process[$i]->Check($data))
			{	
				//echo "\n";
				return;
			}
		}
		
		//
		for($i=0; $i<sizeof($this->process); $i++)
			$this->process[$i]->Execute($data);
		
		$this->Out();
	}
	
	function CreateCond($process)
	{
		$cond = "";
		if($process->check == "")
		{
			$cond = new CCond();
			return $cond;
		}
			
		switch($process->check->check_plugin)
		{
			case "eq":		//
				$cond = new CEQCond();
			break;
			case "nq": //
				$cond = new CNQCond();
			break;
			case "lt":	//С
				$cond = new CLTCond();
			break;
			case "rt": //
				$cond = new CRTCond();
			break;
			case "le": //Сڵ
				$cond = new CLECond();
			break;
			case "re": //ڵ
				$cond = new CRECond();
			break;
			case "nil": //
				$cond = new CNILCond();
			break;
			case "nnl": //ǿ
				$cond = new CNNLCond();
			break;
			case "in":	//ڼ
				$cond = new CINCond();
			break;
			case "nin": //ڼ
				$cond = new CNINCond();
			break;
			case "lk": //
				$cond = new CLIKECond();
			break;
			case "nlk": //
				$cond = new CNLIKECond();
			break;
			case "ht": //Ƿ񷢲
				$cond = new CHaveTaskFunc();
			break;
		}
		$cond->Init($process->check->check_param);
		return $cond;
	}	
	
	function CreatePlugin($process)
	{
		$plugin = "";
		switch($process->plugin)
		{
			case 0: //copy
				$plugin = new CPluginCopy();
			break;
			case 1: //fix
				$plugin = new CPluginFix();
			break;
			case 2:	//tran
				$plugin = new CPluginTran();
				$plugin->trans = $process->trans;
			break;
			case 3: //seq
				$plugin = new CPluginSeq();
			break;
			case 4: //systime
				$plugin = new CPluginSystime();
			break;
			case 5: //convert_big
				$plugin = new CPluginConvertBig();
			break;
			case 6: //gb2utf8
				$plugin = new CPluginGb2Utf8();
			break;			
			case 7: //utf82gb
				$plugin = new CPluginGb2Utf8();
			break;			
			case 8://
				$plugin = new CRoundMinute();
				break;
		}
		
		return $plugin;
	}
	
	function Out()
	{
		$this->db_src->Append($this->process);
	}
};

class CSubject
{
	var $o;
	var $db_src;
	var $data;
	
	function CSubject()
	{
		$this->o="";
		$this->db_src = "";
		$this->data = array();
	}
		
	function 	Attach(&$observer)
	{
		$this->o = $observer;
	}
	
	function Detach(&$observer)
	{
		$this->o = "";
	}
	
	function Notify()
	{
		$this->o->Update($this->data);	
	}	
	
	function Open()
	{
		$i=0;
		$this->db_src->Open();
		while(!$this->db_src->Eof())
		{
			if($this->db_src->Fetch($this->data))
				$this->Notify();	
			$i++;
			if($i%100==0)
				echo "Ѵ¼".$i."\r\n";
		}
		$this->db_src->Close();
	}
};

//Ǩƴ
class CExecuter
{
	var $subject;
	var $observer;
	
	function CExecuter()
	{
		$this->subject = new CSubject();
		$this->observer = new CObserver();
		$this->subject->Attach($this->observer);
	}
	
	function Execute(&$cfg)
	{
		if( ($this->subject->db_src = $this->GetDBSource($cfg->src_in)) == "" )
			echo "Ŀʼʧ\n";
		
		if( !$this->observer->Init($cfg) )
			echo "۲߶ʼʧ\n";
		
		if( ($this->observer->db_src = $this->GetDBSource($cfg->src_out)) == "" )
			echo "Ŀʼʧ\n";
				
		$this->subject->Open();
	}
	
	function GetDBSource($cfg_dbsrc)
	{
		$db_src = "";
		
		switch($cfg_dbsrc->src_type)
		{
			case 0: //excell
				$db_src = new CSourceExcell();
			break;
			case 1: //ݱ
				$db_src = new CSourceTable();
			break;
			case 2: //sqlѯ
				$db_src = new CSourceSql();
			break;
			case 3: //ıļ
				$db_src = new CSourceFile();
			break;
		}
		
		if($db_src != "")
			$db_src->Init($cfg_dbsrc);
		
		$db_src->Connect();
				
		return $db_src;
	}
}
?>
