<?php
namespace app\index\controller;

use think\Controller;
use think\Db;
use alipay\Alipaysubmit;
use alipay\Alipaynotify;
/*
支付
*/
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://myucms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 梦雨 <50361804@qq.com>
// +----------------------------------------------------------------------
class Pay extends Controller
{
    protected function _initialize()
    {
        $this->alipay_config['partner'] = set('partner', 2);
        //收款支付宝账号，以2088开头由16位纯数字组成的字符串，一般情况下收款账号就是签约账号
        $this->alipay_config['seller_id'] = $this->alipay_config['partner'];
        // MD5密钥，安全检验码，由数字和字母组成的32位字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm
        $this->alipay_config['key'] = set('key', 2);
        // 页面跳转同步通知页面路径 需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
        $this->alipay_config['return_url'] = 'http://' . $_SERVER['HTTP_HOST'] . getbaseurl() . '/index.php/index/pay/return_url.html';
        //签名方式
        $this->alipay_config['sign_type'] = strtoupper('MD5');
        //字符编码格式 目前支持 gbk 或 utf-8
        $this->alipay_config['input_charset'] = strtolower('utf-8');
        //ca证书路径地址，用于curl中ssl校验
        //请保证cacert.pem文件在当前文件夹目录中
        $this->alipay_config['cacert'] = getcwd() . '\\cacert.pem';
        //访问模式,根据自己的服务器是否支持ssl访问，若支持请选择https；若不支持请选择http
        $this->alipay_config['transport'] = 'http';
        // 支付类型 ，无需修改
        $this->alipay_config['payment_type'] = "1";
        // 产品类型，无需修改
        $this->alipay_config['service'] = "create_direct_pay_by_user";
        //↑↑↑↑↑↑↑↑↑↑请在这里配置您的基本信息↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
        //↓↓↓↓↓↓↓↓↓↓ 请在这里配置防钓鱼信息，如果没开通防钓鱼功能，为空即可 ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
        // 防钓鱼时间戳  若要使用请调用类文件submit中的query_timestamp函数
        $this->alipay_config['anti_phishing_key'] = "";
        // 客户端的IP地址 非局域网的外网IP地址，如：221.0.0.1
        $this->alipay_config['exter_invoke_ip'] = "";
        //↑↑↑↑↑↑↑↑↑↑请在这里配置防钓鱼信息，如果没开通防钓鱼功能，为空即可 ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
        //商户订单号，商户网站订单系统中唯一订单号，必填
    }
    public function return_url()
    {
        $alipayNotify = new AlipayNotify($this->alipay_config);
        $verify_result = $alipayNotify->verifyReturn();
        if ($verify_result) {
            $out_trade_no = $_GET['out_trade_no'];
            $trade_no = $_GET['trade_no'];
            $trade_status = $_GET['trade_status'];
            $map['id'] = $out_trade_no;
            $info = Db::name('dingdan')->where($map)->find();
            if ($_GET['trade_status'] == 'TRADE_FINISHED' || $_GET['trade_status'] == 'TRADE_SUCCESS') {
                if ($info['status'] != 1) {
                    Db::name('dingdan')->where($map)->update(['trade_no' => $trade_no, 'status' => 1]);
                    $c = Db::name('shopDingdan')->where(array('id' => $info['tid']))->find();
                    $s = Db::name('shop')->where(array('id' => $c['tid']))->find();
                    //查询是否是虚拟商品
                    //更新订单
                    //查询是否是虚拟订单
                    if ($s['fs'] == 1) {
                        //是直接提取附件
                        $map['open'] = 4;
                        $map['xn'] = 1;
                    } else {
                        //否代发货状态
                        $map['open'] = 2;
                        $map['xn'] = 0;
                    }
                    $map['times'] = time();
                    Db::name('shop')->where('id', $s['id'])->setInc('xiaoliang', 1);
                    Db::name('shopDingdan')->where(array('id' => $info['tid']))->data($map)->strict(false)->update();
                    point(set('jifen3', 2), session('userid'), '在线支付');
                    //短信通知
                    if (set('pay2') == 1) {
                        //添加发送短信通知站长记录
                        $data['phone'] = set('phone');
                        $data['content'] = '【'.set('dxb_qmpz').'】来自[' . set('title') . ']您还有新的订单，订单号码' . $c['oid'] . '';
                        $data['open'] = 1;
                        $data['uid'] = 1;
                        $data['ip'] = $_SERVER["REMOTE_ADDR"];
                        $data['time'] = time();
                        $data['fl'] = 4;
                        Db::name('yanzhengma')->insert($data);
                        duanxin(set('phone'), '【'.set('dxb_qmpz').'】来自[' . set('title') . ']您还有新的订单，订单号码' . $c['oid'] . '');
                    }
                    $this->success('支付成功,正在跳转', url('index/home/dingdan', array('id' => $map['open'])));
                }
            }
        } else {
            $this->error('支付失败', '/');
        }
    }
    //创建订单
    public function paysubmit()
    {
        $paydata = $this->request->param();
        $out_trade_no = generate_password(16) . time();
        $c = Db::name('shopDingdan')->where(array('id' => input('id')))->find();
        $s = Db::name('shop')->where(array('id' => $c['tid']))->find();
        //查询是否有运费
        if ($s['yunfei'] == 1) {
            //无运费
            if ($s['youhui'] == 1) {
                $yunfei = 0;
                //有优惠
                $rmb = $s['rmb'] * $c['nu'] - $s['rmbs'] * $c['nu'];
            } else {
                //无优惠
                $rmb = $s['rmb'] * $c['nu'];
            }
        } else {
            //有运费
            $yunfei = $s['yunfeis'];
            if ($s['youhui'] == 1) {
                //有优惠
                $rmb = $s['rmb'] * $c['nu'] - $s['rmbs'] * $c['nu'] + $s['yunfeis'];
            } else {
                //无优惠
                $rmb = $s['rmb'] * $c['nu'] + $s['yunfeis'];
            }
        }
        if ($s['jifen'] == 1) {
            $this->error('非法参数');
        }
        //更新订单
        $map['open'] = 1;
        $map['liuyan'] = xss(input('liuyan'));
        $map['dizhi'] = xss(input('dizhi'));
        $map['rmb'] = $rmb;
        $map['yunfei'] = $yunfei;
        $map['pay'] = 1;
        Db::name('shopDingdan')->where(array('id' => input('id')))->data($map)->strict(false)->update();
        $subject = $s['title'];
        $body = $s['title'];
        $data['id'] = $out_trade_no;
        $data['trade_no'] = 0;
        $data['status'] = 0;
        $data['tid'] = $c['id'];
        $data['jiage'] = $rmb;
        $data['uid'] = session('userid');
        $data['add_time'] = time();
        $data['errorcode'] = 0;
        $data['ip'] = $_SERVER['REMOTE_ADDR'];
        $data['score'] = 0;
        Db::name('dingdan')->insert($data);
        //建立请求
        $parameter = array("service" => $this->alipay_config['service'], "partner" => $this->alipay_config['partner'], "seller_id" => $this->alipay_config['seller_id'], "payment_type" => $this->alipay_config['payment_type'], "return_url" => $this->alipay_config['return_url'], "anti_phishing_key" => $this->alipay_config['anti_phishing_key'], "exter_invoke_ip" => $this->alipay_config['exter_invoke_ip'], "out_trade_no" => $out_trade_no, "subject" => $subject, "total_fee" => $rmb, "body" => $body, "_input_charset" => trim(strtolower($this->alipay_config['input_charset'])));
        $alipaySubmit = new AlipaySubmit($this->alipay_config);
        $html_text = $alipaySubmit->buildRequestForm($parameter, "get", "确认");
        $this->success('等待跳转', $html_text);
    }
}