<?php
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author : milkcy <milkcy@foxmail.com>
 * @version : v1.0
 * =======================================================
 */
class controller {

	public $tpl;

	public $control;

	public $action;

	private $c = array ();

	public function __construct() {
		$this->tpl = Smarty::getInstance ();
		$this->initialize ();
		$this->c = array ('URL_MODE' => 1, // 1普通模式, 2 PATH_INFO模式, 3Rewrit模式
'DEFAULT_ACTION' => 'defaultAction' ); // 默认执行的方法
	}

	public function setValue($var, $value) {
		$this->tpl->assign ( $var, $value );
	}

	public function forward($file) {
		$msgObj = new Msg ();
		$fullFilePath = $this->tpl->template_dir . $file;
		if (! file_exists ( $fullFilePath )) {
			$this->tpl->template_dir = ROOT_PATH . "/" . APP_PATH . "/templates/default/";
			if (! file_exists ( $this->tpl->template_dir . $file )) {
				$this->tpl->assign ( "error", $file . Config::lang ( "TEMPLATENOTEXISTS" ) );
				$this->tpl->display ( "error.html" );
				exit ();
			}
		}
		$this->tpl->assign ( "msgObj", $msgObj );
		$this->tpl->display ( $file );
	}

	public function display($file) {
		$msgObj = new Msg ();
		$dir = StringUtil::new_html_special_chars ( $_GET ['dir'] );
		$this->tpl->template_dir = ROOT_PATH . "/plugins/" . $dir . "/templates/";
		$this->tpl->compile_dir = ROOT_PATH . "/" . APP_PATH . "/data/runtime/" . $dir . "/";
		$this->tpl->cache_dir = ROOT_PATH . "/" . APP_PATH . "/data/cache/" . $dir . "/";
		if (! file_exists ( $this->tpl->compile_dir )) {
			FileUtil::createDir ( $this->tpl->compile_dir );
		}
		if (! file_exists ( $this->tpl->cache_dir )) {
			FileUtil::createDir ( $this->tpl->cache_dir );
		}
		$fullFilePath = $this->tpl->template_dir . $file;
		if (! file_exists ( $fullFilePath )) {
			$this->tpl->assign ( "error", $file . Config::lang ( "TEMPLATENOTEXISTS" ) );
			$this->tpl->display ( "error.html" );
			exit ();
		}
		$this->tpl->assign ( "msgObj", $msgObj );
		$this->tpl->display ( $file );
	}

	public function Plugin() {
		$module = StringUtil::new_html_special_chars ( $_GET ['dir'] );
		$controlFile = ROOT_PATH . '/plugins/' . $module . '/Main.class.php';
		if (! file_exists ( $controlFile )) {
			$this->setValue ( "error", '访问异常或者插件未安装' );
			$this->forward ( "error.html" );
			exit ();
		}
		include ($controlFile);
		$instance = new Main ();
		if (! method_exists ( $instance, "Runner" )) {
			$this->setValue ( "error", 'Runner Method Not Find' );
			$this->forward ( "error.html" );
			exit ();
		}
		$configAry = include ROOT_PATH . '/plugins/' . $module . '/Config.php';
		foreach ( $configAry as $key => $value ) {
			$this->setValue ( "p_" . $key, $value );
		}

		if (! empty ( $configAry ["disabled"] )) {
             $msg = Config::lang ( "SOMETHINGISCLOSE", $configAry ["name"] );
             $this->setValue ( "error", $msg );
             $this->forward ( "error.html" );
             exit ();
		}
		$p_dir = Config::get ( "website" ) . '/plugins/' . $module . '/templates/';
		$p_dir2 = 'plugins/' . $module . '/templates/';
		$this->setValue ( "p_dir", $p_dir );
		$this->setValue ( "p_dir2", $p_dir2 );
		$instance->Runner ();
	}

	public function initialize() {
		$langObj = new Config ();
		$urlObj = new Url ();
		$msgObj = new Msg ();
		$this->setValue ( "msgObj", $msgObj );
		$this->setValue ( "urlObj", $urlObj );
		$this->setValue ( "langObj", $langObj );
	}

	public function Run() {
		$this->Analysis ();
		$this->control = $_GET ['c'];
		$this->action = $_GET ['a'];
		if ($_GET ['a'] === "list") {
			$this->action = "listAll";
		}
		$groupDir = GROUP_DIR;
		$controlFile = ROOT_PATH . '/' . APP_PATH . "/" . GROUP_DIR . "/" . $this->control . '.class.php';
		if (! file_exists ( $controlFile )) {
			$this->setValue ( "error", $this->control . Config::lang ( "CONTROLLERNOTEXISTS" ) );
			$this->forward ( "error.html" );
			exit ();
		}
		include ($controlFile);
		if (! class_exists ( $this->control )) {
			$this->setValue ( "error", $this->control . Config::lang ( "CONTROLLERNOTDEFINED" ) );
			$this->forward ( "error.html" );
			exit ();
		}
		$instance = new $this->control ();
		if (! method_exists ( $instance, $this->action )) {
			$this->setValue ( "error", $this->action . Config::lang ( "METHODNOTFIND" ) );
			$this->forward ( "error.html" );
			exit ();
		}
		if (! empty ( $_REQUEST ['token'] ) && ! in_array ( $_REQUEST ['ac'], array ('user_login', 'user_reg', 'user_regOrLoginProtocol', 'user_findPwd', 'user_getCode' ) )) {
			$this->pubCheck ();
		}
		$methodName = $this->action;
		$instance->$methodName ();
	}

	protected function Analysis() {
		$ac = array ();
		$acStr = $_GET ['ac'];
		if (empty ( $acStr )) { // 无ac参数
			$ac [0] = $this->control;
			$ac [1] = $this->action;
		} else if (! strpos ( $acStr, '_' ) && $acStr) { // ac=list
			$ac [0] = $acStr; // empty($this->control) ? self::getDefaultAction() : $this->control;//NULL
			$ac [1] = self::getDefaultAction ();
			$modelClass = $ac [1];
			$controlClass = $ac [0];
		} else { // ac=news_list 支持下划线的控制器
			$acAry = explode ( "_", $acStr );
			if (count ( $acAry ) == 2) {
				$modelClass = $acAry [1];
				$controlClass = $acAry [0];
			}
			if (count ( $acAry ) == 3) {
				$modelClass = $acAry [2];
				$controlClass = $acAry [0] . '_' . $acAry [1];
			}
		}
		if ($this->c ['URL_MODE'] == 1) {
			$this->control = ! empty ( $controlClass ) ? trim ( $controlClass ) : $this->control;
			$this->action = ! empty ( $modelClass ) ? trim ( $modelClass ) : $this->action;
		} else if ($this->c ['URL_MODE'] == 2) {
			if (isset ( $_SERVER ['PATH_INFO'] )) {
				$path = trim ( $_SERVER ['PATH_INFO'], '/' );
				$paths = explode ( '/', $path );
				// index.php/news/show/id/275
				$this->control = array_shift ( $paths ); // news
				$this->action = array_shift ( $paths ); // show
				ParseUrl (); // news/show/id/275 index.php后面的
			}
		} else if ($this->c ['URL_MODE'] == 3) {
			// $_SERVER["QUERY_STRING"]=>
			// string(19) "ac=news_show&id=275"
			// $_SERVER["REQUEST_URI"]=>
			// string(30) "/index.php?ac=news_show&id=275"
			// bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.html
			$path = str_replace ( ".asp", "", $_SERVER ["QUERY_STRING"] ); // news-show-1
			$paths = explode ( '-', $path );
			$this->control = array_shift ( $paths ); // news
			$this->action = array_shift ( $paths ); // show
			$key = $this->action == 'show' ? 'id' : 'page';
			$_GET [$key] = array_shift ( $paths ); // id page classidss
		}
		$_GET ['c'] = ! empty ( $this->control ) ? $this->control : 'index';
		$_GET ['a'] = ! empty ( $this->action ) ? $this->action : self::getDefaultAction ();
		$ac [0] = $_GET ['c'];
		$ac [1] = $_GET ['a'];

		// 只对后台权限进行过滤
		if ($_SESSION ["userId"] != 1 && defined ( 'IN_ADMIN' )) {
			if (! in_array ( $_GET ['a'], array ('newCode', 'login', 'defaultAction', 'loginout', 'install' ) )) {
				$this->checkHaveRight ( $ac ); // 精细权限控制
				if (! Authen::isAdmin ()) {
					if ($_GET ['c'] == 'admin') {
						header ( 'Location:' . Config::get ( 'admin' ) );
						exit ();
					}
					$this->setValue ( "error", Config::lang ( "YOUHAVENOTPERMISSIONTODO" ) );
					$this->forward ( "noRight.html" );
					exit ();
				}
			}
		}
	}
	// 默认是控制器为当前文件名
	public function getDefaultAction() {
		return "defaultAction";
	}

	private function forceAttack() {
		$attack = M ( 'attack' );
		if (Config::get ( "blackcheck" ) == 1 && ! defined ( 'IN_ADMIN' ) && $_GET ['ac'] != 'common_newCode') {
			$canBePass = $attack->checkForbidden ();
			if ($canBePass) {
				$this->setValue ( "error", Config::lang ( "YOUAREPROHIBITED" ) );
				$this->forward ( "error.html" );
				exit ();
			}
		}

		if (! defined ( 'IN_ADMIN' ) && Config::get ( "checkHack" )) {
			$attack->initLogHacker ();
		}
	}

	/* 用户角色区分 */
	private function checkHaveRight($ac) {
		$powerObj = M ( 'power' );
		$userGroupId = $powerObj->getUserGroupId ();
		$ifHaveRight = $powerObj->checkUserRight ( $ac, $userGroupId );
		if (! $ifHaveRight) {
			if ($_GET ["c"] == "admin") {
				StringUtil::msgbox ( "请登录后操作!", Config::get ( 'admin' ), 1 );
				exit ();
			}
			$this->setValue ( "error", Config::lang ( "YOUHAVENOTPERMISSIONTODO" ) );
			$this->forward ( "noRight.html" );
			exit ();
		}
	}

	/**
	 * App 接口认证
	 */
	public function pubCheck() {
		$params = empty ( $_POST ) ? $_GET : $_POST;
		$request_sign = $params ['sign'];
		$request_access_token = $params ['access_token'];
		$sign_method = empty ( $params ['sign_method'] ) ? 'fullmd5' : $params ['sign_method'];
		// 按字典排序参数，得到接口签名
		ksort ( $params );
		$sign_params = $params;
		unset ( $sign_params ['ac'], $sign_params ['a'], $sign_params ['c'], $sign_params ['dir'], $sign_params ['timestamp'], $sign_params ['secret'], $sign_params ['sign_method'], $sign_params ['sign'], $sign_params ['access_token'] );
		$dictionary = '';
		foreach ( $sign_params as $key => $val ) {
			if (is_array ( $val )) {
				foreach ( $val as $key2 => $v ) {
					$dictionary .= $key . "[$key2]" . $v;
				}
			} else {
				$dictionary .= $key . $val;
			}
		}
		$secret = $params ['secret'];
		$sign = $this->$sign_method ( $secret, $dictionary );
		if ($sign != $request_sign) {
			$this->apiCallback ( "SIGN ERROR" );
		}
		$timestamp = $params ['timestamp'];
		$secret = $params ['secret'];
		$sign = $params ['sign'];
		$access_token = md5 ( $timestamp . '_' . $secret . '_' . $sign );
		// access_token 错误
		if ($access_token != $request_access_token) {
			$this->apiCallback ( "ACCESS_TOKEN ERROR" );
		}
		// 时间戳错误
		$time_diff = abs ( $timestamp - time () );
		if ($time_diff > 3600) {
			$this->apiCallback ( "TIMESTAMP ERROR" );
		}
	}

	public function fullmd5($secret, $dictionary) {
		return md5 ( urlencode ( $secret . $dictionary . $secret ) );
	}

	public function leftmd5($secret, $dictionary) {
		return md5 ( urlencode ( $secret . $dictionary ) );
	}

	public function rightmd5($secret, $dictionary) {
		return md5 ( urlencode ( $dictionary . $secret ) );
	}

	public function apiCallback($code = '', $data = array(), $msg = '') {
		echo json_encode ( array ("code" => $code, "data" => $data, "msg" => $msg ) );
		exit ();
	}

	/**
     * Ajax方式返回数据到客户端
     * @access protected
     * @param mixed $data 要返回的数据
     * @param String $type AJAX返回数据格式
     * @param int $json_option 传递给json_encode的option参数
     * @return void
     */
    protected function ajaxReturn($data,$type='',$json_option=0) {
        if(empty($type)) $type  =   'JSON';
        switch (strtoupper($type)){
            case 'JSON' :
                // 返回JSON数据格式到客户端 包含状态信息
                header('Content-Type:application/json; charset=utf-8');
                exit(json_encode($data,$json_option));
            case 'XML'  :
                // 返回xml格式数据
                header('Content-Type:text/xml; charset=utf-8');
                exit(xml_encode($data));
            case 'JSONP':
                // 返回JSON数据格式到客户端 包含状态信息
                header('Content-Type:application/json; charset=utf-8');
                $handler  =   'callback';//'jsonpReturn';
                exit($handler.'('.json_encode($data,$json_option).');');
            case 'EVAL' :
                // 返回可执行的js脚本
                header('Content-Type:text/html; charset=utf-8');
                exit($data);
            default     :
                // 用于扩展其他返回格式数据
                exit('error');
        }
    }
}
