<?php

defined('WODE_CMS') or exit('Access Denied');

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class baseModel {

    public $db;
    public $limit = "1";
    public $field = "*";
    public $where = "";
    public $orderby = "";
    public $pagenav; //分页对象
    public $pageSize = 20; //默认分页
    public $count; //记录总数
    public $data = array(); //数据信息
    public $model;//默认模块
    public $isAdmin = 0;//是否后台,用于分页

    public function __construct() {
        $db = mysql::getInstance();
        $this->db = $db;
        $this->table = TABLEPRE.$this->table;
        $this->model = str_replace(TABLEPRE,"",$this->table);
    }
    //数据库切换
    public function switchDB($mode) {
        $this->db->switchDB($mode);
    }

    public function __get($key) {
        return array_key_exists($key, $this->data) ? $this->data[$key] : null;
    }

    public function __set($key, $value) {
        $this->data[$key] = $value;
    }

    public function __isset($name) {
        return isset($this->data[$name]);
    }

    public function __unset($name) {
        unset($this->data[$name]);
    }
    /**
     * where简单封装
     * @param $newsObj->where('cid = 100 and uid = 5')->find(); 或者连表  $newsObj->where = ' where cid = 100 and uid = 5';
     * @return Object
     */
   /* public function where($where) {
        $this->where = empty($this->where) ? "" : " where " . $this->where;
        //echoln($this->where);
        return $this;
    }*/
	public function where($where) {
        $this->where = empty($this->where) ? " where " . $where : $this->where . $where;
        return $this;
    }
    /**
     * orderby简单封装
     * @param $newsObj->orderby('id desc,hits desc')->find(); 或者连表  $newsObj->orderby = 'id desc,hits desc';
     * @return Object
     */
    public function orderby($orderby) {
        $this->orderby = $orderby;
        $this->orderby = empty($this->orderby) ? "" : " order by " . $this->orderby;
        return $this;
    }
    /**
     * field简单封装
     * @param $newsObj->field('id,title,photo')->find(); 或者连表  $newsObj->field = 'id,title,photo';
     * @return Object
     */
    public function field($field) {
        $this->field = $field;
        $this->field = empty($this->field) ? "" : $this->field;
        return $this;
    }
    /**
     * table简单封装,默认不调用,联表查询并且分页的时候常用
     * @param $newsObj->table('tc_news')->find(); 或者连表  $newsObj->table = 'tc_news as n, user as u';
     * @return Object
     */
    public function table($table) {
    	$this->table = $table;
    	$this->table = empty($this->table) ? "" : $this->table;
    	return $this;
    }
    /**
     * limit简单封装
     * @param $newsObj->limit('10,25')->find(); 或者 $newsObj->limit = '10,25';
     * @return Object
     */
    public function limit($limit) {
        $this->limit = $limit;
        return $this;
    }
    /**
     * 表单和对象属性映射
     * @param  array,表单命名统一 info['字段名']
     * @return Object
     */
    public function create($datas = '') {
        $data = array();
        $data = $datas;
        if (empty($data)) {
            $data = $_POST['info'];
        } elseif (is_object($data)) {
            $data = get_object_vars($data);
        } elseif (!is_array($data)) {
        	$msg = Config::lang("ILLEGALDATA");
            exit($msg);
        }
        if (empty($_POST['info']) && empty($data)) { return false; }
        $fieldsType = $this->types; //字段和默认值
        $fieldsName = $this->fields; //字段和类型
        $formKeyAry = array_keys($data); //post过来的所有$key
        /* @var $key type */
        foreach ($formKeyAry as $key) {
            if (array_key_exists($key, $this->fields)) {
                $val = isset($data[$key]) ? $data[$key] : NULL;
                if (is_scalar($val)) {
                    if (false !== strpos($fieldsType[$key], 'int')) {
                        $val = intval($val);
                    } elseif (false !== strpos($fieldsType[$key], 'float') || false !== strpos($fieldsType[$key], 'double')) {
                        $val = floatval($val);
                    }
                }
                if (!is_null($val)) {
                    $this->$key = $val;
                }
                if (($data[$key] == "" || $data[$key] == NULL || $data[$key] === 0) && $fieldsName[$key] != "") {
                    $this->$key = $fieldsName[$key];
                }

            }
        }
        return $this;
    }

    /**
     * 取一条记录，联合主键不适合
     * @param  举例: $UserObj = M(user);
     * $UserObj = $UserObj->load(1);
     * @return Object
     */
    public function load($objId) {
        $info = $this->db->GetRs($this->table, '*', 'where ' . $this->PRI . " = " . intval($objId));
        if (!$info) {
            return false;
        }
        foreach ($info as $key => $value) {
            $this->$key = $value;
        }
        return $this;
    }
    /**
     * 对象的保存，联合主键不适合
     * @param  举例: $UserObj = M(user);
     * $UserObj->save();
     * @return insert_id
     */
	public function save() {
        $this->db->Add($this->table, $this->data, '');
        $insert_id = $this->db->insert_id();
        $_Obj = $this->load($insert_id);
        if (empty($_Obj)) {$insert_id = 0;}
        return $insert_id;
    }
    /**
     * 对象的更新，联合主键不适合
     * @param  举例: $UserObj = get('user',1);...
     * $UserObj->update();
     * @return insert_id
     */
	public function update() {
        $pKey = $this->PRI;
        $this->db->Set($this->table, $this->data, 'where ' . $this->PRI . " = " . intval($this->$pKey), '');
    	$affected_rows = $this->db->affected_rows();
    	if ($msgObj->hasMsg) {
    		return false;
    	}
        return true;
    }
    /**
     * 对象的更新或保存,自动识别，看主键ID是否为空.联合主键不适合
     * @param  举例: $UserObj = get('user',1);...
     * $UserObj->saveOrUpdate();
     * @return insert_id
     */
	public function saveOrUpdate() {
        $pKey = $this->PRI;
        $sql = "select * from {$this->table} where ". $this->PRI . " = " . intval($this->$pKey);
        $rs = $this->db->query($sql);
        $rows = $this->db->affected_rows();
        $insert = true;
        if (empty($rows)) {$insert = false;}
        if (!empty($this->$pKey) && $insert) { //update
            $this->db->Set($this->table, $this->data, 'where ' . $this->PRI . " = " . intval($this->$pKey), '');
            $id = $this->$pKey;
        } else { //save
            $this->db->Add($this->table, $this->data, '');
            $id = $this->db->insert_id();
        }
        $this->$pKey = $id;
        return $id;
    }

    public function delete($ids='') {
    	$msgObj = new Msg();
    	$msgObj->addMsg('error', '没有删除权限');
    	return false;
    	
        $id = $_GET[$this->PRI];
        $idAry = $_POST[$this->PRI];
        $idStr = count($idAry) == 0 ? intval($id) : implode(",", $idAry);
        $pkey = $this->PRI;
    	if (!empty($ids)) {//带参数的删除 $userObj->delete('1,21');或$userObj->delete('1');
    		$affected_rows = $this->db->Delete($this->table, $this->PRI, $ids);
    	} else if (!empty($this->$pkey) && empty($idStr)) {//对象直接删除 $userObj->delete();
        	$affected_rows = $this->db->Delete($this->table, $this->PRI, $this->$pkey);
        } else if (!empty($idAry[0]) || !empty($id)) {//通过post或get方式删除 表单场景
            $affected_rows = $this->db->Delete($this->table, $this->PRI, $idStr);
        } else {
            $affected_rows = 0;
        }
    	//add error
        if(empty($affected_rows)) {
        	$msgObj->addMsg('error', Config::lang("DELETEFAILMSG")."0");
        } else {
        	$msgObj->addMsg('success', Config::lang("DELETESUCCESSMSG").$affected_rows."!");
        }
        return $affected_rows;
    }
    /**
     * 带分页的查询
     * @param  页面调用方式  $ObjName->pagenav;
     * @return array
     */
    public function getList($count='') {
        $offset = 0;
        $page = intval($_GET['page']);
        $mid  = intval($_GET['mid']);
        $pageSize = $this->pageSize;
        if (!$page) {
            $page = 1;
        }
        $offset = ($page - 1) * $pageSize;
        $sql = "select " . $this->field . " from " . $this->table . " " . $this->where . $this->orderby . " limit $offset,$pageSize";
		$this->sql = $sql;
        $rt = $this->db->query($sql);
        if (empty($count)) {
        	$coun = mysql_query("select count(*) as cou from " . $this->table . "" . $this->where);
        	$arr = mysql_fetch_array($coun);
        	$total = $arr['cou'];
        	$this->count = $total;
        } else {
        	$this->count = $count;
        }
        if (NetUtil::isAjax()) {
        	$this->pagenav = $this->db->pageAjax($total, $pageSize, 1, 1, 0, 5, "", $mid);
        } else {
        	$this->pagenav = $this->db->pageft($total, $pageSize, 1, 1, 0, 5, "", $this->model);
        }
        while ($row = $this->db->fetch_assoc($rt)) {
            $objList[] = $row;
        }
        $this->where = '';
        return $objList;
    }

	public function findAll(){
 		$sql = "select * from " . $this->table;
 		$res = $this->query($sql);
 		return $res;
 	}

    /**
     * 无分页的查询方式
     * @param
     * @return array
     */
    public function find() {
        $sql = "select " . $this->field . " from " . $this->table . " " . $this->where . $this->orderby . " limit " . $this->limit;
        $rt = $this->db->query($sql);
        while ($row = $this->db->fetch_assoc($rt)) {
            $objList[] = $row;
        }
        $this->where = '';
        $this->count = count($objList);
        return $objList;
    }
    /**
     * 通用查询方式
     * @param
     * @return array
     */
    public function query($sql) {
        $rt = $this->db->query($sql);
        while ($row = $this->db->fetch_assoc($rt)) {
            $objList[] = $row;
        }
        $this->count = count($objList);
        return $objList;
    }

    /**
     * 缓存查询,强烈建议公共，频繁查询的调用此使用
     * @param $powerAry = $this->execute($sql,86400,"power");
     * @return array
     */
    public function execute($sql, $cache = 3600, $dir="cache") {
    	$fileDir = ROOT_PATH . "/" . APP_PATH . "/data/".$dir."/";
    	$file = ROOT_PATH . "/" . APP_PATH . "/data/".$dir."/" . md5($sql) . '.db.php';
    	if (!file_exists($fileDir)) {
    		FileUtil::createDir($fileDir);
    	}
    	if ($cache) {
    		if (is_file($file) && time() - filemtime($file) < $cache) {
    			return unserialize(file_get_contents($file));
    		} else {
    			$data = $this->query($sql);
    			file_put_contents($file, serialize($data), LOCK_EX);
    			return $data;
    		}
    	}
    	return $this->query($sql);
    }
    /**
     * 判断数据是否已经存在
     * @param
     * @return boolean
     */
	public function haveDoubleRow($msgObj,$cloum,$errorMsg) {
    	$sql = "select * from " . $this->table . " where ".$cloum." = '".StringUtil::GetSQLValueString($this->$cloum)."'";
    	$pri = $this->PRI;
    	$rowNum = empty($this->$pri) ? 1 : 2;
    	$ifExists = $this->ifExists($sql,$rowNum);
    	if ($ifExists) {
    		$msgObj->addMsg('error', $errorMsg);
    	}
    	return $ifExists;
    }
    /**
     * 判断数据是否已经存在,可选有几条记录
     * @param
     * @return boolean
     */
    public function ifExists($sql,$num) {
        $rt = $this->db->query($sql);
        while ($row = $this->db->fetch_assoc($rt)) {
            $objList[] = $row;
        }
		if(empty($objList)) {
			return false;
		}
        if (empty($num)) {$num = 1;}
        return count($objList) > $num - 1;
    }
    /**
     * 获取主键
     * @param
     * @return boolean
     */
    public function getPrimary() {
        return $this->db->getPrimary($this->table);
    }
    /**
     * 获取记录总数
     * @param
     * @return boolean
     */
    public function getCount() {
    	$sql = "select count(*) as total from " . $this->table . " " . $this->where;
        $rt = $this->query($sql);
        return $rt[0]["total"];
    }
    /**
     * 清空记录
     * @param
     * @return boolean
     */
    public function truncate() {
    	$sql = "truncate " . $this->table;
    	$this->db->query($sql);
    	return true;
    }
    /**
     * 对象复制
     * @param
     * @return boolean
     */
	public function copyData() {
    	$pri = $this->PRI;
    	$v = intval($_GET[$pri]);
	    if (!empty($v)) {
	        $_Obj = $this->load($v);
	        $_Obj->$pri="";
	    } else {
	    	return $this;
	    }
	    return $_Obj;
	}
	/**
	 * 模块记录点击数
	 * @param
	 * @return boolean
	 */
	public function countView($model,$id) {
		$_Obj = get($model,$id);
		$hits = $_Obj->hits + 1;
        $_Obj->hits = $hits;
        $_Obj->update();
	}

    /**
     * 检查表是否存在
     */
    public function tableIsExist($table) {
        $tables = $this->db->list_tables();
        return in_array($table, $tables) ? true : false;
    }

	/**
	 * smarty模板中执行function
	 * @param
	 * @return {$model->exeFuc('autoVer','param1')}
	 */
	public function exeFuc(){
    	//$numargs = func_num_args();
    	$arg_list = func_get_args();
    	$funcName = $arg_list[0];
    	unset($arg_list[0]);
    	$param = is_array($arg_list)?implode(",",$arg_list):'';
    	$funcName($param);
    }

    /**
     * 获取自定义字段的值,主要是select和checkbox,radio的值
     * @param
     * @return {$model->exeFuc('autoVer','param1')}
     */
    public function getFieldValue($field,$value,$model){
        $formStr = "";
        $sql = "select setting from ".TABLEPRE."field where fieldname='".$field."' and mid=".$model;
        $setting = $this->query($sql);
        $settingAry = unserialize($setting[0]["setting"]);
        $contentAry = explode("\n", trim($settingAry["content"]));
        $rsAry = explode(",", trim($value));
        foreach($contentAry as $key=>$value) {
            $cAry = explode("|", trim($value));
            $cAryStr = StringUtil::killAllHtml($cAry[1]);
            if (in_array($cAryStr,$rsAry)) {
                $formStr .= $cAry[0]. '&nbsp;';
            }
        }
        return $formStr;
    }

	/**
	 * 通过ID号删除记录
	 * @param
	 * @return boolean
	 */
	public function deleteById($id) {
		
		$msgObj = new Msg();
    	$msgObj->addMsg('error', '没有删除权限');
    	return false;
    	
        $this->db->Delete($this->table, $this->PRI, $id);
    }

    /**
     * 启动事务
     * @access public
     * @return void
     */
    public function startTrans() {
    	$this->commit();
    	$this->db->startTrans();
    	return ;
    }

    /**
     * 提交事务
     * @access public
     * @return boolean
     */
    public function commit() {
    	return $this->db->commit();
    }

    /**
     * 事务回滚
     * @access public
     * @return boolean
     */
    public function rollback() {
    	return $this->db->rollback();
    }
    
	public function lockById($id) {
        $sql = "update " . $this->table . " set yz = 0 where id = " . $id;
        $this->db->query($sql);
    }

    public function openById($id) {
        $sql = "update " . $this->table . " set yz = 1 where id = " . $id;
        $this->db->query($sql);
    }

    public function setSortId() {
        if (empty($_GET['sortId'])) {
            $_GET['sortId'] =  'asc';
        }
        if ($_GET['sortId'] ==  'desc') {
            $_GET['sortId'] = 'asc';
        } else {
            $_GET['sortId'] = 'desc';
        }
    }
    
	public function getReplyNum($id,$mid) {
        $rt = $this->db->query("select id from ".TABLEPRE."message where mid = {$mid} and aid=".$id);
        $newsNum = $this->db->num_rows($rt);
        return $newsNum;
    }

	public function getTags($mid,$aid) {
    	return $this->query("select * from tc_tags where mid={$mid} and aid={$aid}");
    }

	public function getTimes($TimeTime) {
    	return DateUtil::datetime($TimeTime);
    }
    
	public function getPluginsMenus() {
    	$menuGroupAry =array();
    	$sql = 'SELECT id,name,adminmenu,folder FROM '.TABLEPRE.'plugins where showmenu=1';
    	$menus = $this->query($sql);
    	for ($i=0;$i<count($menus);$i++) {
    		$adminmenuStr = str_replace ( "\n", "", $menus[$i]["adminmenu"]);
    		$adminmenuStr = trim($adminmenuStr);
    		$menuAry = explode("?", $adminmenuStr);
    		$menuGroupAry[$i]["name"] = $menus[$i]["name"];
    		for ($j=0;$j<count($menuAry);$j++) {
    			if (!empty($menuAry[$j])) {
    				$menucAryc = explode("|", $menuAry[$j]);
    				$menuGroupAry[$i]["links"][$j] = $menucAryc;
    			}
    		}
    	}
    	return $menuGroupAry;
    }
    
    public function isActive($val) {
    	$row = $this->execute('SELECT url FROM tc_category WHERE pid= '.$val,86400);
    	if (empty($row)) {
    		return false;
    	}
    	$ac = $_GET['ac'];
    	foreach ($row as $kk=>$vv) {
    		if (stripos($vv['url'], $ac) !== false) {
    			return true;
    		}
    	}
    	return false;
    }

}
