<?php

class ArrayUtil {

    /**
     * 将字符串转换为数组
     *
     * @param	string	$data	字符串
     * @return	array	返回数组格式，如果，data为空，则返回空数组
     */
    public static function string2array($data) {
        if ($data == '')
            return array();
        eval("\$array = $data;");
        return $array;
    }

    /**
     * 将数组转换为字符串
     *
     * @param	array	$data		数组
     * @param	bool	$isformdata	如果为0，则不使用new_stripslashes处理，可选参数，默认为1
     * @return	string	返回字符串，如果，data为空，则返回空
     */
    public static function array2string($data, $isformdata = 1) {
        if ($data == '')
            return '';
        if ($isformdata)
            $data = new_stripslashes($data);
        return addslashes(var_export($data, TRUE));
    }

    //格式化显示数组
    public static function vd($var) {
        echo "<div style=\"border:1px solid #ddd;background:#F7F7F7;padding:5px 10px;\">\r\n";
        echo "<pre style=\"font-family:Arial,Vrinda;font-size:14px;\">\r\n";
        var_dump($var);
        echo "\r\n</pre>\r\n";
        echo "</div>";
    }

    public static function getModules() {
    	$dir = empty($_GET['dir']) ? 'app' : $_GET['dir'];
    	$moduleAry = include ROOT_PATH."/".$dir."/data/module/modules.php";
    	return $moduleAry;
    }

	public static function getTables($module='admin') {
		$dir = empty($_GET['dir']) ? 'app' : $_GET['dir'];
		$module = !empty($_GET["module"]) ? $_GET["module"] : $module;
    	$tableAry = include ROOT_PATH."/".$dir."/data/module/".$module.".php";
    	if (file_exists(ROOT_PATH."/".$dir."/data/module/".$module.".php")) {
    		return $tableAry;
    	}
        $path = ROOT_PATH . "/".$dir."/".$module;
        $class = glob($path . '/*.php');
        $classAry = array();
        foreach ($class as $key => $val) {
        	$class_name = substr(strrchr($val, "/"), 1);
            $class_name = str_replace('.class.php', '', $class_name);
            array_push($classAry,$class_name);
        }
        $cachefile = ROOT_PATH."/".$dir."/data/module/".$module.".php";
        $set = "<?php\ndefined('WODE_CMS') or exit('Access Denied');\n return " . var_export($classAry, true) . ";\n";
		file_put_contents($cachefile, $set);
		@chmod($cachefile, 0777);
		return $classAry;
    }

	public static function setPowers($module) {
		$dir = empty($_GET['dir']) ? 'app' : $_GET['dir'];
		self::getTables($module);
		$module = empty($module) ? "admin" : $module;
        $path = ROOT_PATH . "/".$dir."/".$module;
        $class = glob($path . '/*.php');
        foreach ($class as $key => $val) {
        	$methods = self::file_get_class_methods ($val);
        	$class_name = substr(strrchr($val, "/"), 1);
            $class_name = str_replace('.class.php', '', $class_name);
            foreach ($methods as $k => $v) {
                if ($v != '__construct') {
                    $powerObj = M('power');
                    $powerObj->method = $v;
                    $powerObj->action = $class_name;
                    $powerObj->memo = self::getMethodName($v);
                    $powerObj->module = $module;
                    $powerObj->rank = 0;
                    $powerObj->save();
                }
            }
        }
    }

	public static function setPowersByClass($class) {
		$dir = empty($_GET['dir']) ? 'app' : $_GET['dir'];
		$module = "admin";
        $path = ROOT_PATH . "/".$dir."/".$module."/".$class.".class.php";
		$methods = self::file_get_class_methods ($path);
            foreach ($methods as $k => $v) {
                if ($v != '__construct') {
                    $powerObj = M('power');
                    $powerObj->method = $v;
                    $powerObj->action = $class;
                    $powerObj->memo = self::getMethodName($v);
                    $powerObj->module = $module;
                    $powerObj->rank = 0;
                    $sql = "select * from tc_power where method='{$v}' and action='{$class}'";
                    $info = $powerObj->query($sql);
                    if(empty($info)) {
                    	echoln($sql);
                    	$powerObj->save();
                    }else{
                    	echoln($v."->".$v."已存在");
                    }
                }
            }
    }

	public static function file_get_class_methods ($file){
	    $arr = file($file);
	    foreach ($arr as $line) {
	        if (ereg ('public function ([_A-Za-z0-9]+)', $line, $regs)){
	        	$arr_methods[] = $regs[1];
	        }
	    }
	    return $arr_methods;
	}

    public static function getMethodName($method) {
    	$methodStr = strtolower($method);
        switch ($methodStr) {
            case 'add':
                $str = "增加";
                break;
            case 'edite':
                $str = "编辑";
                break;
            case 'delete':
                $str = "删除";
                break;
            case 'saveorupdate':
                $str = "保存";
                break;
            case 'all':
                $str = "列表";
                break;
            case 'listall':
                $str = "列表";
                break;
            case 'lock':
                $str = "锁定";
                break;
            case 'open':
                $str = "解锁";
                break;
            case 'show':
                $str = "显示";
                break;
            case 'update':
                $str = "更新";
                break;
            case 'save':
                $str = "保存";
                break;
            case 'truncate':
                $str = "清空";
                break;
            default:
                $str = $method;
        }
        return $str;
    }
}
