<?php

class DateUtil {

    //转换时间戳为常用的日期格式
    public static function trans_time($timestamp) {
        if ($timestamp < 1)
            return false;
        else
            return date("Y-m-d H:i:s", $timestamp);
    }

    //转换时间戳为常用的日期格式
    public static function shortTime($timestamp) {
        if ($timestamp < 1)
            echo Config::lang("WRONGUNIXTIME");
        else
            return date("Y-m-d", $timestamp);
    }

    public static function toUnixTime($datetime) {
        return strtotime($datetime);
    }

    //获取微秒时间，常用于计算程序的运行时间
    public static function utime() {
        list ($usec, $sec) = explode(" ", microtime());
        return ((float) $usec + (float) $sec);
    }

	public static function spent($endTime,$startTime) {
		return number_format(($endTime - $startTime), 6);
	}

    //获取内存使用情况，常用于计算程序的内存使用
    public static function getRunM() {
        $mem_usage = memory_get_usage() - SYS_START_MEMORY;
        if ($mem_usage < 1024) {
            return $mem_usage . " B";
        } elseif ($mem_usage < 1048576) {
            return round($mem_usage / 1024, 2) . " KB";
        } else {
            return round($mem_usage / 1048576, 2) . " MB";
        }
    }

	public static function datetime($TimeTime){
		$limit=time()-strtotime($TimeTime);
		if ($limit < 5) { $show_t = "刚刚"; }
		if ($limit >= 5 and $limit < 60) { $show_t = $limit."秒前"; }
		if ($limit >= 60 and $limit < 3600) { $show_t = sprintf("%01.0f", $limit/60)."分钟前"; }
		if ($limit >= 3600 and $limit < 86400) { $show_t = sprintf("%01.0f", $limit/3600)."小时前"; }
		if ($limit >= 86400 and $limit < 2592000) { $show_t = sprintf("%01.0f", $limit/86400)."天前"; }
		if ($limit >= 2592000 and $limit < 31104000) { $show_t = sprintf("%01.0f", $limit/2592000)."个月前"; }
		//if ($limit >= 31104000) { $show_t = "很久前"; }
		if ($limit >= 31104000) { $show_t = $TimeTime; }
	 	return $show_t;
	}

    /**
     * 程序执行时间
     *
     * @return	int	单位ms
     */
    public static function getRunTime() {
        $stime = explode(' ', SYS_START_TIME);
        $etime = explode(' ', microtime());
        return number_format(($etime[1] + $etime[0] - $stime[1] - $stime[0]), 6);
    }
    
    public static function getQqueryTime($queryTime) {
    	$stime = explode(' ', $queryTime);
    	$etime = explode(' ', microtime());
    	return number_format(($etime[1] + $etime[0] - $stime[1] - $stime[0]), 6);
    }

    /**
     * Unix时间转换为距离现在时间的计算
     *
     * @return	int	单位ms
     */
    public static function tranTime($time) {
        $rtime = date("m-d H:i", $time);
        $htime = date("H:i", $time);
        $time = time() - $time;
        if ($time < 60) {
            $str = Config::lang("JUSTNOW");
        } elseif ($time < 60 * 60) {
            $min = floor($time / 60);
            $str = $min . Config::lang("MINIUTEBEFORE");
        } elseif ($time < 60 * 60 * 24) {
            $h = floor($time / (60 * 60));
            $str = $h . Config::lang("HOURBEFORE") . $htime;
        } elseif ($time < 60 * 60 * 24 * 3) {
            $d = floor($time / (60 * 60 * 24));
            if ($d == 1)
                $str = Config::lang("YESTERDAY") . $rtime;
            else
                $str = Config::lang("YESTERDAYTWO") . $rtime;
        } else {
            $str = $rtime;
        }
        return $str;
    }

    public static function ShowDate($flag = 0, $timestr = NULL) {
        // 获取周几
        $warr = array(
            "0" => Config::lang("SUNDAY"),
            "1" => Config::lang("MONDAY"),
            "2" => Config::lang("TUESDAY"),
            "3" => Config::lang("WEDNESDAY"),
            "4" => Config::lang("THURSDAY"),
            "5" => Config::lang("FRIDAY"),
            "6" => Config::lang("SATURDAY")
        );
        $i = date("w", $timeStamp);

        // 设置北京时间并获取时间戳
        date_default_timezone_set('PRC');
        $timeStamp = NULL;
        if ($timestr)
            $timeStamp = strtotime($timestr);
        else
            $timeStamp = time();

        // 设置时间显示格式
        $ret1 = date("Y".Config::lang("YEAR")."m".Config::lang("MONTH")."d".Config::lang("DAY")." H:m:s", $timeStamp) . " " . $warr[$i];
        $ret2 = date("Y-m-d H:m:s", $timeStamp) . " " . $warr[$i];
        $ret3 = date("y/m/d", $timeStamp);
        $ret = $ret1; // 默认返回第一种

        if ($flag == 2)
            $ret = $ret2;
        else
        if ($flag == 3)
            $ret = $ret3;

        return $ret;
    }

    public static function checkDate($date) { //检查日期是否合法日期
        $dateArr = explode("-", $date);
        if (is_numeric($dateArr[0]) && is_numeric($dateArr[1]) && is_numeric($dateArr[2])) {
            return checkdate($dateArr[1], $dateArr[2], $dateArr[0]);
        }
        return false;
    }

    public static function checkTime($time) { //检查时间是否合法时间
        $timeArr = explode(":", $time);
        if (is_numeric($timeArr[0]) && is_numeric($timeArr[1]) && is_numeric($timeArr[2])) {
            if (($timeArr[0] >= 0 && $timeArr[0] <= 23) && ($timeArr[1] >= 0 && $timeArr[1] <= 59) && ($timeArr[2] >= 0 && $timeArr[2] <= 59))
                return true;
            else
                return false;
        }
        return false;
    }

    public static function addDate($date, $int, $unit = "d") { //时间的增加（还可以改进成时分秒都可以增加，有时间再补上）
        $dateArr = explode("-", $date);
        $value[$unit] = $int;
        return date("Y-m-d", mktime(0, 0, 0, $dateArr[1] + $value['m'], $dateArr[2] + $value['d'], $dateArr[0] + $value['y']));
    }

    public static function addDay($ntime, $aday) { //取当前时间后几天，天数增加单位为1
        $dayst = 3600 * 24;
        $oktime = $ntime + ($aday * $dayst);
        return $oktime;
    }

    public static function dateDiff($date1, $date2, $unit = "") { //时间比较函数，返回两个日期相差几秒、几分钟、几小时或几天
        switch ($unit) {
            case 's' :
                $dividend = 1;
                break;
            case 'i' :
                $dividend = 60;
                break;
            case 'h' :
                $dividend = 3600;
                break;
            case 'd' :
                $dividend = 86400;
                break;
            default :
                $dividend = 86400;
        }
        $time1 = strtotime($date1);
        $time2 = strtotime($date2);
        if ($time1 && $time2)
            return (float) ($time1 - $time2) / $dividend;
        return false;
    }

    public static function diffDate($date1,$date2) {
    	if ($date1 && $date2) {
        	$diffDay = (float) ($date1 - $date2) / 86400;
        	return abs($diffDay);
    	}
        return false;
    }

    public static function getWeekDay($date) { //计算出给出的日期是星期几
        $dateArr = explode("-", $date);
        return date("w", mktime(0, 0, 0, $dateArr[1], $dateArr[2], $dateArr[0]));
    }

    public static function getDateTimeMk($mktime) { //取当前时间，格式为2009-10-23 14:20:35
        return MyDate('Y-m-d H:i:s', $mktime);
    }

    public static function getDateMk($mktime) { //取当前时间，格式为2009-10-23
        if ($mktime == "0")
            return Config::lang("NOTHING");
        else
            return MyDate("Y-m-d", $mktime);
    }

    public static function floorTime($seconds) { //让日期显示为:XX天XX年以前
        $times = '';
        $days = floor(($seconds / 86400) % 30);
        $hours = floor(($seconds / 3600) % 24);
        $minutes = floor(($seconds / 60) % 60);
        $seconds = floor($seconds % 60);
        if ($seconds >= 1)
            $times .= $seconds . Config::lang("SECOND");
        if ($minutes >= 1)
            $times = $minutes . Config::lang("MINIUTE") . $times;
        if ($hours >= 1)
            $times = $hours . Config::lang("HOUR") . $times;
        if ($days >= 1)
            $times = $days . Config::lang("DAY");
        if ($days > 30)
            return false;
        $times .= Config::lang("BEFORE");
        return str_replace(" ", '', $times);
    }

    public static function transDateToChs($date) {
        if (empty($date))
            return Config::lang("TODAY");
        $y = _date('Y', strtotime($date));
        $m = _date('m', strtotime($date));
        $d = _date('d', strtotime($date));
        return $y . Config::lang("YEAR") . $m . Config::lang("MONTH") . $d . Config::lang("DAY");
    }

    // 08/31/2004 => 2004-08-31
    public static function TransDateUI($datestr, $type = 'Y-m-d') {
        if ($datestr == Null)
            return Null;
        $target = $datestr;
        $arr_date = preg_split("/\//", $target);
        $monthstr = $arr_date[0];
        $daystr = $arr_date[1];
        $yearstr = $arr_date[2];
        $result = date($type, mktime(0, 0, 0, $monthstr, $daystr, $yearstr));
        return $result;
    }

    // 12/20/2004 10:55 AM => 2004-12-20 10:55:00
    public static function TransDateTimeUI($datestr, $type = 'Y-m-d H:i:s') {
        if ($datestr == Null)
            return Null;
        $target = $datestr;
        $arr_date = preg_split("/\/|\s|:/", $target);
        $monthstr = $arr_date[0];
        $daystr = $arr_date[1];
        $yearstr = $arr_date[2];
        $hourstr = $arr_date[3];
        $minutesstr = $arr_date[4];
        $result = date($type, mktime($hourstr, $minutesstr, 0, $monthstr, $daystr, $yearstr));
        return $result;
    }

    // 2004-08-31 => 08/31/2004
    public static function TransDateDB($datestr, $type = 'm/d/Y') {
        if ($datestr == Null)
            return Null;
        if ($datestr == '0000-00-00')
            return Null;
        $target = $datestr;
        $arr_date = preg_split("/-/", $target);
        $monthstr = $arr_date[1];
        $daystr = $arr_date[2];
        $yearstr = $arr_date[0];
        $result = date($type, mktime(0, 0, 0, $monthstr, $daystr, $yearstr));
        return $result;
    }

    // 2004-08-31 10:55:00 => 12/20/2004 10:55 AM
    public static function TransDateTimeDB($datestr, $type = 'm/d/Y h:i A') {
        if ($datestr == Null)
            return Null;
        $target = $datestr;
        $arr_date = preg_split("/-|\s|:/", $target);
        $monthstr = $arr_date[1];
        $daystr = $arr_date[2];
        $yearstr = $arr_date[0];
        $hourstr = $arr_date[3];
        $minutesstr = $arr_date[4];
        $secondstr = $arr_date[5];
        $result = date($type, mktime($hourstr, $minutesstr, $secondstr, $monthstr, $daystr, $yearstr));
        return $result;
    }

    //2008-3-17 -> 1205683200
    public static function timestamp($timestr) {
        if (empty($timestr))
            return 0;
        $tmp = explode(' ', $timestr);
        list($year, $month, $day) = explode('-', $tmp[0]);
        $tmp = isset($tmp[1]) ? explode(':', $tmp[1]) : '';
        $hours = isset($tmp[0]) ? intval($tmp[0]) : 0;
        $minutes = isset($tmp[1]) ? intval($tmp[1]) : 0;
        $seconds = isset($tmp[2]) ? intval($tmp[2]) : 0;
        $timestamp = mktime($hours, $minutes, $seconds, $month, $day, $year);
        return $timestamp;
    }
    //格式化当前时间DateUtil::dateNow();
	public static function dateNow($format='%Y-%m-%d') {
        return(strftime($format,time()));
    }
    //是否正确的时间DateUtil::isValidDate("12","08","2012");
	public static function isValidDate($day, $month, $year) {
        if ($year < 0 || $year > 9999) {
            return false;
        }
        if (!checkdate($month,$day,$year)) {
            return false;
        }
        return true;
    }
    //是否闰年
	public static function isLeapYear($year='') {
        if (empty($year)) {
            $year = Date_Calc::dateNow('%Y');
        }

        if (preg_match('/\D/',$year)) {
            return false;
        }

        if ($year < 1000) {
            return false;
        }

        if ($year < 1582) {
            // pre Gregorio XIII - 1582
            return ($year % 4 == 0);
        } else {
            // post Gregorio XIII - 1582
            return ( (($year % 4 == 0) and ($year % 100 != 0)) or ($year % 400 == 0) );
        }
    }

    //是否是将来日期
	public static function isFutureDate($day,$month,$year) {
        $this_year = self::dateNow('%Y');
        $this_month = self::dateNow('%m');
        $this_day = self::dateNow('%d');

        if ($year > $this_year) {
            return true;
        } elseif ($year == $this_year) {
            if ($month > $this_month) {
                return true;
            } elseif ($month == $this_month) {
                if ($day > $this_day) {
                    return true;
                }
            }
        }

        return false;
    }
    //是否过去的日期
    public static function isPastDate($day,$month,$year) {
        $this_year = self::dateNow('%Y');
        $this_month = self::dateNow('%m');
        $this_day = self::dateNow('%d');

        if ($year < $this_year) {
            return true;
        } elseif ($year == $this_year) {
            if ($month < $this_month) {
                return true;
            } elseif ($month == $this_month) {
                if ($day < $this_day) {
                    return true;
                }
            }
        }

        return false;
    }

/**
     * Returns day of week for given date, 0=Sunday
     *
     * @param string day in format DD, default is current local day
     * @param string month in format MM, default is current local month
     * @param string year in format CCYY, default is current local year
     *
     * @access public
     *
     * @return int $weekday_number
     */

	public static function dayOfWeek($day='',$month='',$year='') {
        if (empty($year)) {
            $year = self::dateNow('%Y');
        }
        if (empty($month)) {
            $month = self::dateNow('%m');
        }
        if (empty($day)) {
            $day = self::dateNow('%d');
        }

        if ($month > 2) {
            $month -= 2;
        } else {
            $month += 10;
            $year--;
        }

        $day = ( floor((13 * $month - 1) / 5) +
            $day + ($year % 100) +
            floor(($year % 100) / 4) +
            floor(($year / 100) / 4) - 2 *
            floor($year / 100) + 77);

        $weekday_number = (($day - 7 * floor($day / 7)));

        return $weekday_number;
    }

	/**
     * Returns week of the year, first Sunday is first day of first week
     *
     * @param string day in format DD, default is current local day
     * @param string month in format MM, default is current local month
     * @param string year in format CCYY, default is current local year
     *
     * @access public
     *
     * @return integer $week_number
     */

    public  static function weekOfYear($day='',$month='',$year='') {
        if (empty($year)) {
            $year = self::dateNow('%Y');
        }
        if (empty($month)) {
            $month = self::dateNow('%m');
        }
        if (empty($day)) {
            $day = self::dateNow('%d');
        }
        $iso    = self::gregorianToISO($day, $month, $year);
        $parts  = explode('-',$iso);
        $week_number = intval($parts[1]);
        return $week_number;
    }
	/**
     * Converts from Gregorian Year-Month-Day to
     * ISO YearNumber-WeekNumber-WeekDay
     *
     * Uses ISO 8601 definitions.
     * Algorithm from Rick McCarty, 1999 at
     * http://personal.ecu.edu/mccartyr/ISOwdALG.txt
     *
     * @param string day in format DD
     * @param string month in format MM
     * @param string year in format CCYY
     * @return string
     * @access public
     */
    // Transcribed to PHP by Jesus M. Castagnetto (blame him if it is fubared ;-)
    public static function gregorianToISO($day,$month,$year) {
        $mnth = array (0,31,59,90,120,151,181,212,243,273,304,334);
        $y_isleap = self::isLeapYear($year);
        $y_1_isleap = self::isLeapYear($year - 1);
        $day_of_year_number = $day + $mnth[$month - 1];
        if ($y_isleap && $month > 2) {
            $day_of_year_number++;
        }
        // find Jan 1 weekday (monday = 1, sunday = 7)
        $yy = ($year - 1) % 100;
        $c = ($year - 1) - $yy;
        $g = $yy + intval($yy/4);
        $jan1_weekday = 1 + intval((((($c / 100) % 4) * 5) + $g) % 7);
        // Convert Jan 1 weekday to different date format if required (sunday = 1, saturday = 7)
        if (DATE_CALC_BEGIN_WEEKDAY == 0) {
            $jan1_weekday = ($jan1_weekday + 1) % 7;
        }
        // weekday for year-month-day
        $h = $day_of_year_number + ($jan1_weekday - 1);
        $weekday = 1 + intval(($h - 1) % 7);
        // find if Y M D falls in YearNumber Y-1, WeekNumber 52 or
        if ($day_of_year_number <= (8 - $jan1_weekday) && $jan1_weekday > 4){
            $yearnumber = $year - 1;
            if ($jan1_weekday == 5 || ($jan1_weekday == 6 && $y_1_isleap)) {
                $weeknumber = 53;
            } else {
                $weeknumber = 52;
            }
        } else {
            $yearnumber = $year;
        }
        // find if Y M D falls in YearNumber Y+1, WeekNumber 1
        if ($yearnumber == $year) {
            if ($y_isleap) {
                $i = 366;
            } else {
                $i = 365;
            }
            if (($i - $day_of_year_number) < (4 - $weekday)) {
                $yearnumber++;
                $weeknumber = 1;
            }
        }
        // find if Y M D falls in YearNumber Y, WeekNumber 1 through 53
        if ($yearnumber == $year) {
            $j = $day_of_year_number + (7 - $weekday) + ($jan1_weekday - 1);
            $weeknumber = intval($j / 7);
            if ($jan1_weekday > 4) {
                $weeknumber--;
            }
        }
        // put it all together
        if ($weeknumber < 10)
            $weeknumber = '0'.$weeknumber;
        return "{$yearnumber}-{$weeknumber}-{$weekday}";
    }

	/**
    * Determines julian date of the given season
    * Adapted from previous work in Java by James Mark Hamilton, mhamilton@qwest.net
    *
    * @author Robert Butler <rob@maxwellcreek.org>
    *
    * @param string is VERNALEQUINOX, SUMMERSOLSTICE, AUTUMNALEQUINOX, or WINTERSOLSTICE.
    * @param string year in format CCYY, must be a calendar year between -1000BC and 3000AD.
    *
    * @access public
    *
    * @return float $juliandate
    */

    public static function dateSeason ($season, $year = '') {
            if ($year == '') {
                    $year = self::dateNow('%Y');
            }

            if (($year >= -1000) && ($year <= 1000)) {
                    $y = $year / 1000.0;
                    if ($season == 'VERNALEQUINOX') {
                            $juliandate = (((((((-0.00071 * $y) - 0.00111) * $y) + 0.06134) * $y) + 365242.1374) * $y) + 1721139.29189;
                    } else if ($season == 'SUMMERSOLSTICE') {
                            $juliandate = ((((((( 0.00025 * $y) + 0.00907) * $y) - 0.05323) * $y) + 365241.72562) * $y) + 1721233.25401;
                    } else if ($season == 'AUTUMNALEQUINOX') {
                            $juliandate = ((((((( 0.00074 * $y) - 0.00297) * $y) - 0.11677) * $y) + 365242.49558) * $y) + 1721325.70455;
                    } else if ($season == 'WINTERSOLSTICE') {
                            $juliandate = (((((((-0.00006 * $y) - 0.00933) * $y) - 0.00769) * $y) + 365242.88257) * $y) + 1721414.39987;
                    }
            } elseif (($year > 1000) && ($year <= 3000)) {
                    $y = ($year - 2000) / 1000;
                    if ($season == 'VERNALEQUINOX') {
                            $juliandate = (((((((-0.00057 * $y) - 0.00411) * $y) + 0.05169) * $y) + 365242.37404) * $y) + 2451623.80984;
                    } else if ($season == 'SUMMERSOLSTICE') {
                            $juliandate = (((((((-0.0003 * $y) + 0.00888) * $y) + 0.00325) * $y) + 365241.62603) * $y) + 2451716.56767;
                    } else if ($season == 'AUTUMNALEQUINOX') {
                            $juliandate = ((((((( 0.00078 * $y) + 0.00337) * $y) - 0.11575) * $y) + 365242.01767) * $y) + 2451810.21715;
                    } else if ($season == 'WINTERSOLSTICE') {
                            $juliandate = ((((((( 0.00032 * $y) - 0.00823) * $y) - 0.06223) * $y) + 365242.74049) * $y) + 2451900.05952;
                    }
            }

            return ($juliandate);
    }

}