
<?php

class FileUtil {

	//遍历删除目录和目录下所有文件
	public static function del_dir($dir) {
		if (!is_dir($dir)) {
			return false;
		}
		$handle = opendir($dir);
		while (($file = readdir($handle)) !== false) {
			if ($file != "." && $file != "..") {
				is_dir("$dir/$file") ? self::del_dir("$dir/$file") : @ unlink("$dir/$file");
			}
		}
		if (readdir($handle) == false) {
			closedir($handle);
			@ rmdir($dir);
		}
	}

	/**
	 * 取得文件扩展
	 *
	 * @param $filename 文件名
	 * @return 扩展名
	 */
	public static function fileext($filename) {
		return strtolower(trim(substr(strrchr($filename, '.'), 1, 10)));
	}

	/**
	 * 转化 \ 为 /
	 *
	 * @param	string	$path	路径
	 * @return	string	路径
	 */
	public static function dir_path($path) {
		$path = str_replace('\\', '/', $path);
		if (substr($path, -1) != '/')
		$path = $path . '/';
		return $path;
	}

	public static function loadFile($sFilename, $sCharset = 'UTF-8') {
		if (floatval(phpversion()) >= 4.3) {
			$sData = file_get_contents($sFilename);
		} else {
			if (!file_exists($sFilename))
			return -3;
			$rHandle = fopen($sFilename, 'r');
			if (!$rHandle)
			return -2;

			$sData = '';
			while (!feof($rHandle))
			$sData .= fread($rHandle, filesize($sFilename));
			fclose($rHandle);
		}
		if ($sEncoding = mb_detect_encoding($sData, 'auto', true) != $sCharset)
		$sData = mb_convert_encoding($sData, $sCharset, $sEncoding);
		return $sData;
	}

	public static function file_get_contents_code($fn, $code) {
		$opts = array(
            'http' => array(
                'method' => "GET",
                'header' => "Content-Type: text/html; charset='" . $code . "'"
                )
                );

                $context = stream_context_create($opts);
                $result = @file_get_contents($fn, false, $context);
                return $result;
	}

	/**
	 * 创建目录
	 *
	 * @param	string	$path	路径
	 * @param	string	$mode	属性
	 * @return	string	如果已经存在则返回true，否则为flase
	 */
	public static function dir_create($path, $mode = 0777) {
		if (is_dir($path))
		return TRUE;
		$ftp_enable = 0;
		$path = self::dir_path($path);
		$temp = explode('/', $path);
		$cur_dir = '';
		$max = count($temp) - 1;
		for ($i = 0; $i < $max; $i++) {
			$cur_dir .= $temp[$i] . '/';
			if (@ is_dir($cur_dir))
			continue;
			@ mkdir($cur_dir, 0777, true);
			@ chmod($cur_dir, 0777);
		}
		return is_dir($path);
	}


	/**
	 * 检查目标文件夹是否存在，如果不存在则自动创建该目录
	 *
	 * @access      public
	 * @param       string      folder     目录路径。不能使用相对于网站根目录的URL
	 *
	 * @return      bool
	 */
	public static function make_dir($folder){
		$reval = false;

		if (!file_exists($folder))    {
			/* 如果目录不存在则尝试创建该目录 */
			@umask(0);

			/* 将目录路径拆分成数组 */
			preg_match_all('/([^\/]*)\/?/i', $folder, $atmp);

			/* 如果第一个字符为/则当作物理路径处理 */
			$base = ($atmp[0][0] == '/') ? '/' : '';

			/* 遍历包含路径信息的数组 */
			foreach ($atmp[1] AS $val)        {
				if ('' != $val)            {
					$base .= $val;

					if ('..' == $val || '.' == $val)                {
						/* 如果目录为.或者..则直接补/继续下一个循环 */
						$base .= '/';

						continue;
					}
				}            else            {
					continue;
				}

				$base .= '/';

				if (!file_exists($base))            {
					/* 尝试创建目录，如果创建失败则继续循环 */
					if (@mkdir(rtrim($base, '/'), 0777))                {
						@chmod($base, 0777);
						$reval = true;
					}
				}
			}
		}    else    {
			/* 路径已经存在。返回该路径是不是一个目录 */
			$reval = is_dir($folder);
		}

		clearstatcache();

		return $reval;
	}

	//获取文件名称
	public static function getFileName($path) {
		$temp = explode('/', $path);
		$max = count($temp) - 1;
		return $temp[$max];
	}

	/**
	 * 拷贝目录及下面所有文件
	 *
	 * @param	string	$fromdir	原路径
	 * @param	string	$todir		目标路径
	 * @return	string	如果目标路径不存在则返回false，否则为true
	 */
	public static function dir_copy($fromdir, $todir) {
		$fromdir = self::dir_path($fromdir);
		$todir = self::dir_path($todir);
		if (!is_dir($fromdir))
		return FALSE;
		if (!is_dir($todir))
		self::dir_create($todir);
		$list = glob($fromdir . '*');
		if (!empty($list)) {
			foreach ($list as $v) {
				$path = $todir . basename($v);
				if (is_dir($v)) {
					self::dir_copy($v, $path);
				} else {
					copy($v, $path);
					@ chmod($path, 0777);
				}
			}
		}
		return TRUE;
	}

	/**
	 * 转换目录下面的所有文件编码格式
	 *
	 * @param	string	$in_charset		原字符集
	 * @param	string	$out_charset	目标字符集
	 * @param	string	$dir			目录地址
	 * @param	string	$fileexts		转换的文件格式
	 * @return	string	如果原字符集和目标字符集相同则返回false，否则为true
	 */
	public static function dir_iconv($in_charset, $out_charset, $dir, $fileexts = 'php|html|htm|shtml|shtm|js|txt|xml') {
		if ($in_charset == $out_charset)
		return false;
		$list = self::dir_list($dir);
		foreach ($list as $v) {
			if (pathinfo($v, PATHINFO_EXTENSION) == $fileexts && is_file($v)) {
				file_put_contents($v, iconv($in_charset, $out_charset, file_get_contents($v)));
			}
		}
		return true;
	}

	/**
	 * 列出目录下所有文件
	 *
	 * @param	string	$path		路径
	 * @param	string	$exts		扩展名
	 * @param	array	$list		增加的文件列表
	 * @return	array	所有满足条件的文件
	 */
	public static function dir_list($path, $exts = '', $list = array()) {
		$path = self::dir_path($path);
		$files = glob($path . '*');
		foreach ($files as $v) {
			if (!$exts || pathinfo($v, PATHINFO_EXTENSION) == $exts) {
				$list[] = $v;
				if (is_dir($v)) {
					$list = self::dir_list($v, $exts, $list);
				}
			}
		}
		return $list;
	}

	/**
	 * 设置目录下面的所有文件的访问和修改时间
	 *
	 * @param	string	$path		路径
	 * @param	int		$mtime		修改时间
	 * @param	int		$atime		访问时间
	 * @return	array	不是目录时返回false，否则返回 true
	 */
	public static function dir_touch($path, $mtime = TIME, $atime = TIME) {
		if (!is_dir($path))
		return false;
		$path = self::dir_path($path);
		if (!is_dir($path))
		touch($path, $mtime, $atime);
		$files = glob($path . '*');
		foreach ($files as $v) {
			is_dir($v) ? self::dir_touch($v, $mtime, $atime) : touch($v, $mtime, $atime);
		}
		return true;
	}

	/**
	 * 目录列表
	 *
	 * @param	string	$dir		路径
	 * @param	int		$parentid	父id
	 * @param	array	$dirs		传入的目录
	 * @return	array	返回目录列表
	 */
	public static function dir_tree($dir, $parentid = 0, $dirs = array()) {
		global $id;
		if ($parentid == 0)
		$id = 0;
		$list = glob($dir . '*');
		foreach ($list as $v) {
			if (is_dir($v)) {
				$id++;
				$dirs[$id] = array(
                    'id' => $id,
                    'parentid' => $parentid,
                    'name' => basename($v),
                    'dir' => $v . '/'
                    );
                    $dirs = self::dir_tree($v . '/', $id, $dirs);
			}
		}
		return $dirs;
	}

	/**
	 * 删除目录及目录下面的所有文件
	 *
	 * @param	string	$dir		路径
	 * @return	bool	如果成功则返回 TRUE，失败则返回 FALSE
	 */
	public static function dir_delete($dir) {
		$dir = self::dir_path($dir);
		if (!is_dir($dir))
		return FALSE;
		$list = glob($dir . '*');
		foreach ($list as $v) {
			is_dir($v) ? self::dir_delete($v) : @ unlink($v);
		}
		return @ rmdir($dir);
	}

	/*
	 * 功能：循环检测并创建文件夹
	 * 参数：$path 文件夹路径
	 * 返回：
	 */

	public static function createDir($path) {
		if (!file_exists($path)) {
			self::createDir(dirname($path));
			mkdir($path, 0777);
		}
	}

	//获取文件大小
	public static function getFileSize($mem_usage) {
		if ($mem_usage < 1024) {
			return $mem_usage . " B";
		} elseif ($mem_usage < 1048576) {
			return round($mem_usage / 1024, 2) . " KB";
		} else {
			return round($mem_usage / 1048576, 2) . " MB";
		}
	}

	/**
	 * Delete a file or recursively delete a directory
	 *
	 * @param string $str Path to file or directory
	 */
	public static function recursiveDelete($str) {
		if (empty($str)) {
			echo Config::lang("BANONDIRECTACCESS");
			exit;
		}
		if (is_file($str)) {
			return @unlink($str);
		} elseif (is_dir($str)) {
			$scan = glob(rtrim($str, '/') . '/*');
			foreach ($scan as $index => $path) {
				self::recursiveDelete($path);
			}
			return @rmdir($str);
		}
	}

	// 判断是否为图片，仅判断后缀
	public static function is_image($file) {
		return in_array(self::fileext($file),array('gif','jpg','jpeg','png','bmp'));
	}

	// 判断是否为视频，仅判断后缀
	public static function is_vedio($file) {
		return in_array(self::fileext($file),array('swf','flv'));
	}

	// 判断远程文件是否存在
	public static function file_exists_url($url) {
		if(substr($url,0,7)!='http://' && substr($url,0,6)!='ftp://'){
			return file_exists(ROOT_PATH.$url);
		}

		if(extension_loaded('curl')){
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_NOBODY, true);
			curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
			$result = curl_exec($curl);
			$feedback = false;

			if ($result !== false){
				$statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
				if ($statusCode == 200)	{
					$feedback = true;
				}
			}
			curl_close($curl);
			return $feedback;
		}
		else{
			$feedback=@get_headers($url);
			return stripos($feedback[0], '200') ? true : false;
		}
	}

	//获取一段文本内的所有图片地址
	public static function get_images($str) {
		preg_match_all('/<img(.+?)src=[\'\"]?([^\'\"]+)[\'\"]?/i',stripslashes($str),$matches,PREG_PATTERN_ORDER);
		$r=array();
		$t=$matches[2];

		foreach($t as $_t) {
			if(is_image($_t))$r[]=$_t;
		}
		return $r;
	}
	
	/**
	 * 分析文件夹是否存在
	 *
	 * @param string $dir_name 所要操作的文件目录名
	 * @return string
	 */
	protected static function parse_dir($dir_name) {
		if (!is_dir($dir_name)) return false;
		if (substr($dir_name, -1) !== '/' || substr($dir_name, -1) !== '\\') return $dir_name . DIRECTORY_SEPARATOR;
		return $dir_name;
	}
	
	/**
	 * 获取目录内文件
	 *
	 * @param string $dir_name	所要读取内容的目录名
	 * @return string
	 */
	public static function get_file_list($dir_name) {
		$dir    = self::parse_dir($dir_name);
		if (!$dir) return null;
		$handle = opendir($dir);
		$files  = array();
		while (false !== ($file = readdir($handle))) {
			if ($file == '.' || $file == '..' || $file == '.cvs' || $file == '.svn') continue;
			$id = filectime($dir . $file);
			$id && !isset($files[$id]) ? $files[$id] = $file : $files[] = $file;
		}
		closedir($handle);
		asort($files);
		return $files;
	}
	
	/**
	 * 检查文件/目录名称是否规范
	 */
	public static function checkFileName($file) {
		if (strpos($file, '../') !== false || strpos($file, '..\\') !== false) return true;
		return false;
	}

}