<?php

class NetUtil {
	
	public static function isAjax() {
		if (isset ( $_SERVER ['HTTP_X_REQUESTED_WITH'] )) {
			if ('xmlhttprequest' == strtolower ( $_SERVER ['HTTP_X_REQUESTED_WITH'] ))
				return true;
		}
		//如果参数传递的参数中有ajax
		if (! empty ( $_POST ['ajax'] ) || ! empty ( $_GET ['ajax'] )) {
			return true;
		}
		return false;
	}
	
	//获取IP
	public static function getIp() {
		if (getenv ( 'HTTP_CLIENT_IP' ) && strcasecmp ( getenv ( 'HTTP_CLIENT_IP' ), 'unknown' )) {
			$ip = getenv ( 'HTTP_CLIENT_IP' );
		} elseif (getenv ( 'HTTP_X_FORWARDED_FOR' ) && strcasecmp ( getenv ( 'HTTP_X_FORWARDED_FOR' ), 'unknown' )) {
			$ip = getenv ( 'HTTP_X_FORWARDED_FOR' );
		} elseif (getenv ( 'REMOTE_ADDR' ) && strcasecmp ( getenv ( 'REMOTE_ADDR' ), 'unknown' )) {
			$ip = getenv ( 'REMOTE_ADDR' );
		} elseif (isset ( $_SERVER ['REMOTE_ADDR'] ) && $_SERVER ['REMOTE_ADDR'] && strcasecmp ( $_SERVER ['REMOTE_ADDR'], 'unknown' )) {
			$ip = $_SERVER ['REMOTE_ADDR'];
		}
		return preg_match ( "/[\d\.]{7,15}/", $ip, $matches ) ? $matches [0] : 'unknown';
	}
	
	/**
	 * 获取请求客户端IP
	 * @return ip
	 */
	
	public static function httpIp() {
		if (getenv ( 'SERVER_SOFTWARE' ) == 'nginx') {
			if (getenv ( 'REMOTE_ADDR' ) && strcasecmp ( getenv ( 'REMOTE_ADDR' ), 'unknown' )) {
				$ip = getenv ( 'REMOTE_ADDR' );
			} elseif (getenv ( 'HTTP_X_FORWARDED_FOR' ) && strcasecmp ( getenv ( 'HTTP_X_FORWARDED_FOR' ), 'unknown' )) {
				$ip = getenv ( 'HTTP_X_FORWARDED_FOR' );
			} elseif (isset ( $_SERVER ['REMOTE_ADDR'] ) && $_SERVER ['REMOTE_ADDR'] && strcasecmp ( $_SERVER ['REMOTE_ADDR'], 'unknown' )) {
				$ip = $_SERVER ['REMOTE_ADDR'];
			} elseif (getenv ( 'HTTP_CLIENT_IP' ) && strcasecmp ( getenv ( 'HTTP_CLIENT_IP' ), 'unknown' )) {
				$ip = getenv ( 'HTTP_CLIENT_IP' );
			} else {
				$ip = '127.0.0.1';
			}
		} else {
			if (getenv ( 'HTTP_X_FORWARDED_FOR' ) && strcasecmp ( getenv ( 'HTTP_X_FORWARDED_FOR' ), 'unknown' )) {
				$ip = getenv ( 'HTTP_X_FORWARDED_FOR' );
			} elseif (getenv ( 'REMOTE_ADDR' ) && strcasecmp ( getenv ( 'REMOTE_ADDR' ), 'unknown' )) {
				$ip = getenv ( 'REMOTE_ADDR' );
			} elseif (isset ( $_SERVER ['REMOTE_ADDR'] ) && $_SERVER ['REMOTE_ADDR'] && strcasecmp ( $_SERVER ['REMOTE_ADDR'], 'unknown' )) {
				$ip = $_SERVER ['REMOTE_ADDR'];
			} elseif (getenv ( 'HTTP_CLIENT_IP' ) && strcasecmp ( getenv ( 'HTTP_CLIENT_IP' ), 'unknown' )) {
				$ip = getenv ( 'HTTP_CLIENT_IP' );
			} else {
				$ip = '127.0.0.1';
			}
		}
		preg_match ( "/[\d\.]{7,15}/", $ip, $temp );
		$ip = $temp [0] ? $temp [0] : 'unknown';
		unset ( $temp );
		if (isset ( $_SERVER ["HTTP_CDN_SRC_IP"] )) {
			$ip = $_SERVER ["HTTP_CDN_SRC_IP"];
		}
		return $ip;
	}
	
	/**
	 * 获取当前页面完整URL地址
	 */
	public static function get_url() {
		$sys_protocal = isset ( $_SERVER ['SERVER_PORT'] ) && $_SERVER ['SERVER_PORT'] == '443' ? 'https://' : 'http://';
		$php_self = $_SERVER ['PHP_SELF'] ? NetUtil::safe_replace ( $_SERVER ['PHP_SELF'] ) : NetUtil::safe_replace ( $_SERVER ['SCRIPT_NAME'] );
		$path_info = isset ( $_SERVER ['PATH_INFO'] ) ? NetUtil::safe_replace ( $_SERVER ['PATH_INFO'] ) : '';
		$relate_url = isset ( $_SERVER ['REQUEST_URI'] ) ? NetUtil::safe_replace ( $_SERVER ['REQUEST_URI'] ) : $php_self . (isset ( $_SERVER ['QUERY_STRING'] ) ? '?' . NetUtil::safe_replace ( $_SERVER ['QUERY_STRING'] ) : $path_info);
		return $sys_protocal . (isset ( $_SERVER ['HTTP_HOST'] ) ? $_SERVER ['HTTP_HOST'] : '') . $relate_url;
	}
	
	/**
	 * 安全过滤函数
	 *
	 * @param $string
	 * @return string
	 */
	public static function safe_replace($string) {
		$string = str_replace ( '%20', '', $string );
		$string = str_replace ( '%27', '', $string );
		$string = str_replace ( '%2527', '', $string );
		$string = str_replace ( '*', '', $string );
		$string = str_replace ( '"', '&quot;', $string );
		$string = str_replace ( "'", '', $string );
		$string = str_replace ( '"', '', $string );
		$string = str_replace ( ';', '', $string );
		$string = str_replace ( '<', '&lt;', $string );
		$string = str_replace ( '>', '&gt;', $string );
		$string = str_replace ( "{", '', $string );
		$string = str_replace ( '}', '', $string );
		return $string;
	}
	
	public static function getpreurl() {
		return isset ( $_SERVER ['HTTP_REFERER'] ) && $_SERVER ['HTTP_REFERER'] ? mysql_real_escape_string ( strip_tags ( $_SERVER ['HTTP_REFERER'] ) ) : '';
	}
	
	// 根据链接地址获取域名
	public static function getRootDomain($url) {
		$ohurl = $ohip = array ();
		$url = $url . "/";
		preg_match ( "/((\w*):\/\/)?\w*\.?([\w|-]*\.(com.cn|net.cn|gov.cn|org.cn|com|net|cn|org|asia|tel|mobi|me|tv|biz|cc|name|info))\//i", $url, $ohurl );
		if (! isset ( $ohurl [3] ) || $ohurl [3] == '') {
			preg_match ( "/((\d+\.){3}\d+)\//", $url, $ohip );
			return isset ( $ohip [1] ) ? $ohip [1] : '';
		}
		return $ohurl [3];
	}
	
	/**
	 * 调用远程数据
	 */
	public static function getDataByUrl($url) {
		if (substr ( $url, 0, 7 ) != 'http://')
			return file_get_contents ( $url );
		if (ini_get ( 'allow_url_fopen' )) {
			return @file_get_contents ( $url );
		} elseif (function_exists ( 'curl_init' ) && function_exists ( 'curl_exec' )) {
			$ch = curl_init ( $url );
			$data = '';
			curl_setopt ( $ch, CURLOPT_HEADER, 0 );
			curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
			$data = curl_exec ( $ch );
			curl_close ( $ch );
			return $data;
		}
	}
}