<?php

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class Log {
    const ERROR = 30;
    const WARNING = 20;
    const INFO = 10;

    public static function debug($message, $logLevel, $filename="") {
        if (!Config::get("debuglog")) {
            return false;
        }
        $debugObj = M("debuglog");
        $userObj = Authen::getCurrentUser();
        $debugObj->message = $message;
        $debugObj->filename = $filename;
        $debugObj->level = $logLevel;
        $debugObj->username = empty($userObj->username) ? "UnknowUser" : $userObj->username;
        $debugObj->addtime = time();
        $debugObj->save();
    }

    public static function Login($username, $type) {
        $logObj = M("loginlog");
        $logObj->username = empty($username) ? "UnknowUser" : $username;
        $logObj->password = $type;
        $logObj->ip = NetUtil::httpIp();
        $logObj->addtime = time();
        $logObj->save();
    }

    /**
     * logs info message
     *
     * @param string $message
     * @param string $logGroup
     */
    public static function info($message, $filename="") {
        self::debug($message, self::INFO, $filename);
    }

    /**
     * logs warning message
     *
     * @param string $message
     * @param string $logGroup
     */
    public static function warning($message, $filename="") {
        self::debug($message, self::WARNING, $filename);
    }

    /**
     * logs error message
     *
     * @param string $message
     * @param string $logGroup
     */
    public static function error($message, $filename="") {
        self::debug($message, self::ERROR, $filename);
    }
    
    public static function logBot() {
	    $agent1 = $_SERVER["HTTP_USER_AGENT"] ;  
		$agent=strtolower($agent1);
		$Bot ="";
	    if (strpos($agent,"bot")>-1)
		    {$Bot = "其它蜘蛛";}
		if (strpos($agent,"googlebot")>-1)
		    {$Bot = "Google";}           
	    if (strpos($agent,"mediapartners-google")>-1)
		   {$Bot = "Google Adsense";}
		if (strpos($agent,"baiduspider")>-1)
		   {$Bot = "Baidu";}
		if (strpos($agent,"sogou spider")>-1)
		   {$Bot = "Sogou";}
		if (strpos($agent,"yahoo")>-1)
		   {$Bot = "Yahoo!";}
		if (strpos($agent,"msn")>-1)
		   {$Bot = "MSN";}
		if (strpos($agent,"ia_archiver")>-1)
		   {$Bot = "Alexa";}
		if (strpos($agent,"iaarchiver")>-1)
		   {$Bot = "Alexa";}
		if (strpos($agent,"sohu")>-1)
		   {$Bot = "Sohu";}
		if (strpos($agent,"sqworm")>-1) 
		   {$Bot = "AOL";}
		if (strpos($agent,"yodaoBot")>-1)
		   {$Bot = "Yodao";}
		if (strpos($agent,"iaskspider")>-1)
		   {$Bot = "Iask";}
		$botObj = M("bot");
    	if (Authen::checkUserLogin()){
    		$userObj = Authen::getCurrentUser();
    		$Bot = $userObj->username;
    		$botObj->uid = $userObj->id;
    	} else {
    		$botObj->uid = 0;
    	}
		$botObj->bot = empty($Bot) ? "游客" : $Bot;
		$botObj->addtime = time();
		$botObj->url = NetUtil::get_url();
		$botObj->serverip = NetUtil::getIp();
		$botObj->sessionid = session_id();
		$oldUser = $botObj->query("select id,times from tc_bot where sessionid='".session_id()."'");
		if (!defined('IN_ADMIN')) {
			if (empty($oldUser)) {
				$botObj->save();
			} else {
				$botObj->id = $oldUser[0]["id"];
				$botObj->times = $oldUser[0]["times"] + 1;
				$botObj->update();
			}
		}
    }

}
