<?php
/**
 * 接口类
 */
class MInterface {
	private $v = '1.0';
	private $connecttimeout = 30;
	private $timeout = 30;
	private $debug =false;
	private $sign_method = "fullmd5";
	public static $timestamp = NULL;
	public static $time_offset = NULL;
	public static $user_token = NULL;
	public static $exe_count = array ();
	
	// 错误列表
	private static $error_list = array (
			'NO_DATA',
			'REQUIRE_PARAMETER_MISS',
			'SERVER_ERROR',
			'TIMESTAMP_TIMEOUT',
			'TIMESTAMP_OUT_OF_RANGE'
	);
	
	/*
	100	时间戳校验不正确
	101	系统级参数校验不正确
	102	业务层参数校验不正确
	103	请求服务器授权不正确
	104	必要系统参数缺失*/
	

	/**
	 * 初始化接口请求参数
	 */
	public function __construct($server = array()) {
		foreach ( ( array ) $server as $key => $val ) {
			if (! empty ( $val )) {
				$this->{$key} = $val;
			}
		}
		$this->init ();
	}

	/**
	 * 初始化接口参数
	 */
	private function init() {
		$this->params ['v'] = $this->v;
		$this->params ['sign_method'] = $this->sign_method; //"fullmd5";//fullmd5,leftmd5,rightmd5
		//设置时间
		//$this->set_time ();
	}

	/**
	 * 设置时间
	 */
	private function set_time() {
		/* 计算服务器时间与本地时间偏差值 */
		self::$time_offset = $_COOKIE["time_offset"];
		if (self::$time_offset == null || self::$time_offset > 300 || self::$time_offset < - 300) {
			// 获取服务器时间
			$server_time = $_SERVER["REQUEST_TIME"];
			// 兼容正式、测试环境获取服务器时间接口
			if (is_array ( $server_time ) && array_key_exists ( 'time', $server_time )) {
				$server_time = $server_time ['time'];
			}
			// 服务器时间 - 本地时间 = 差值，(接受5min时差)
			if ($server_time) {
				self::$time_offset = $server_time - $_SERVER ['REQUEST_TIME'];
				if (self::$time_offset >= - 300 && self::$time_offset <= 300) {
					if (self::$time_offset == 0) {
						self::$time_offset = 1;
					}
					setcookie ( "time_offset", self::$time_offset, 0, COOKIE_PATH, COOKIE_DOMAIN );
				} else {
					self::$time_offset = 0;
				}
			} else {
				self::$time_offset = 0;
			}
		}
		$this->params ['timestamp'] = $_SERVER ['REQUEST_TIME'] + self::$time_offset;
	}

	/**
	 * 发送http请求
	 *
	 * @param string $url
	 * @param string $method
	 * @param array $postfields
	 * @return string
	 */
	private function http($url, $method, $postfields = NULL) {
		Log::info("Http:".$url);
// 		echoln($url);
		$ci = curl_init ();
		curl_setopt ( $ci, CURLOPT_URL, $url );
		curl_setopt ( $ci, CURLOPT_CONNECTTIMEOUT, $this->connecttimeout ); // 连接超时
		curl_setopt ( $ci, CURLOPT_TIMEOUT, $this->timeout ); // 执行超时
		curl_setopt ( $ci, CURLOPT_RETURNTRANSFER, true ); // 文件流的形式返回，而不是直接输出
		//curl_setopt($ci, CURLOPT_ENCODING, "gzip");
		curl_setopt ( $ci, CURLOPT_HEADER, FALSE );
		if ('POST' == $method) {
			curl_setopt ( $ci, CURLOPT_POST, true ); // post
		}
		if (! empty ( $postfields )) {
			curl_setopt ( $ci, CURLOPT_POSTFIELDS, $postfields ); // post数据 可为数组、连接字串
		}
		$response = curl_exec ( $ci );
		$curl_err = curl_errno ( $ci );
		if ($this->debug) {
			echo "=====post data======\r\n";
			var_dump ( $postfields );

			echo '=====info=====' . "\r\n";
			print_r ( curl_getinfo ( $ci ) );

			echo '=====$response=====' . "\r\n";
			print_r ( $response );
		}
		curl_close ( $ci );
		// curl执行错误日志
		if ($curl_err) {
			// 错误代码
			$error_codes = array (
					1 => 'CURLE_UNSUPPORTED_PROTOCOL',
					2 => 'CURLE_FAILED_INIT',
					3 => 'CURLE_URL_MALFORMAT',
					4 => 'CURLE_URL_MALFORMAT_USER',
					5 => 'CURLE_COULDNT_RESOLVE_PROXY',
					6 => 'CURLE_COULDNT_RESOLVE_HOST',
					7 => 'CURLE_COULDNT_CONNECT',
					8 => 'CURLE_FTP_WEIRD_SERVER_REPLY',
					9 => 'CURLE_REMOTE_ACCESS_DENIED',
					11 => 'CURLE_FTP_WEIRD_PASS_REPLY',
					13 => 'CURLE_FTP_WEIRD_PASV_REPLY',
					14 => 'CURLE_FTP_WEIRD_227_FORMAT',
					15 => 'CURLE_FTP_CANT_GET_HOST',
					17 => 'CURLE_FTP_COULDNT_SET_TYPE',
					18 => 'CURLE_PARTIAL_FILE',
					19 => 'CURLE_FTP_COULDNT_RETR_FILE',
					21 => 'CURLE_QUOTE_ERROR',
					22 => 'CURLE_HTTP_RETURNED_ERROR',
					23 => 'CURLE_WRITE_ERROR',
					25 => 'CURLE_UPLOAD_FAILED',
					26 => 'CURLE_READ_ERROR',
					27 => 'CURLE_OUT_OF_MEMORY',
					28 => 'CURLE_OPERATION_TIMEDOUT',
					30 => 'CURLE_FTP_PORT_FAILED',
					31 => 'CURLE_FTP_COULDNT_USE_REST',
					33 => 'CURLE_RANGE_ERROR',
					34 => 'CURLE_HTTP_POST_ERROR',
					35 => 'CURLE_SSL_CONNECT_ERROR',
					36 => 'CURLE_BAD_DOWNLOAD_RESUME',
					37 => 'CURLE_FILE_COULDNT_READ_FILE',
					38 => 'CURLE_LDAP_CANNOT_BIND',
					39 => 'CURLE_LDAP_SEARCH_FAILED',
					41 => 'CURLE_FUNCTION_NOT_FOUND',
					42 => 'CURLE_ABORTED_BY_CALLBACK',
					43 => 'CURLE_BAD_FUNCTION_ARGUMENT',
					45 => 'CURLE_INTERFACE_FAILED',
					47 => 'CURLE_TOO_MANY_REDIRECTS',
					48 => 'CURLE_UNKNOWN_TELNET_OPTION',
					49 => 'CURLE_TELNET_OPTION_SYNTAX',
					51 => 'CURLE_PEER_FAILED_VERIFICATION',
					52 => 'CURLE_GOT_NOTHING',
					53 => 'CURLE_SSL_ENGINE_NOTFOUND',
					54 => 'CURLE_SSL_ENGINE_SETFAILED',
					55 => 'CURLE_SEND_ERROR',
					56 => 'CURLE_RECV_ERROR',
					58 => 'CURLE_SSL_CERTPROBLEM',
					59 => 'CURLE_SSL_CIPHER',
					60 => 'CURLE_SSL_CACERT',
					61 => 'CURLE_BAD_CONTENT_ENCODING',
					62 => 'CURLE_LDAP_INVALID_URL',
					63 => 'CURLE_FILESIZE_EXCEEDED',
					64 => 'CURLE_USE_SSL_FAILED',
					65 => 'CURLE_SEND_FAIL_REWIND',
					66 => 'CURLE_SSL_ENGINE_INITFAILED',
					67 => 'CURLE_LOGIN_DENIED',
					68 => 'CURLE_TFTP_NOTFOUND',
					69 => 'CURLE_TFTP_PERM',
					70 => 'CURLE_REMOTE_DISK_FULL',
					71 => 'CURLE_TFTP_ILLEGAL',
					72 => 'CURLE_TFTP_UNKNOWNID',
					73 => 'CURLE_REMOTE_FILE_EXISTS',
					74 => 'CURLE_TFTP_NOSUCHUSER',
					75 => 'CURLE_CONV_FAILED',
					76 => 'CURLE_CONV_REQD',
					77 => 'CURLE_SSL_CACERT_BADFILE',
					78 => 'CURLE_REMOTE_FILE_NOT_FOUND',
					79 => 'CURLE_SSH',
					80 => 'CURLE_SSL_SHUTDOWN_FAILED',
					81 => 'CURLE_AGAIN',
					82 => 'CURLE_SSL_CRL_BADFILE',
					83 => 'CURLE_SSL_ISSUER_ERROR',
					84 => 'CURLE_FTP_PRET_FAILED',
					84 => 'CURLE_FTP_PRET_FAILED',
					85 => 'CURLE_RTSP_CSEQ_ERROR',
					86 => 'CURLE_RTSP_SESSION_ERROR',
					87 => 'CURLE_FTP_BAD_FILE_LIST',
					88 => 'CURLE_CHUNK_FAILED'
			);
			$str = date ( 'Y-m-d H:i:s' ) . "\t" . $error_codes [$curl_err] . '(' . $curl_err . ')' . "\r\n";
			Log::error($str);
		}
		/* curl发生错误,但不为超时和接收失败，则使用file_get_contents方法 */
		if ($curl_err && ! in_array ($curl_err, array(28,56))) {
			if ('POST' == $method) {
				$context ['http'] = array (
						'method' => 'POST',
						'content' => $postfields
				);
				$response = file_get_contents ( $url, false, stream_context_create ( $context ) );
			} else {
				$response = file_get_contents ( $url );
			}
		}
		/* 解码返回的json串 */
		$response = trim ($response);
		if (!empty($response) && is_string ($response) && in_array ($response [0], array ('[','{'))) {
			$response = json_decode ($response, true);
		} else if (in_array ($response, self::$error_list)) {
			// 重新获取时间
			if ($response == 'TIMESTAMP_OUT_OF_RANGE' || $response == 'TIMESTAMP_TIMEOUT') {
				setcookie ("time_offset", 0, $this->local_time () - 86400, COOKIE_PATH, COOKIE_DOMAIN);
				$this->set_time ();
			}
			$response = false;
		}
		return $response;
	}

	/**
	 * 执行接口调用
	 *
	 * @param array $params		发送请求需要传递的参数
	 * @param string $method	请求发送方式
	 */
	public function execute($params, $method = 'GET') {
		if (empty ( $params ) || ! is_array ( $params )) {
			return false;
		}
		$params = array_merge ( $params, $this->params );
		//按字典排序参数，得到接口签名
		ksort ( $params );
// 		print_r($params);
// 		echo "<hr>";
		$sign_params	= $params;
		unset($sign_params['timestamp'],$sign_params['secret'],$sign_params['v'],$sign_params['sign_method'],$sign_params['sign'],$sign_params['access_token'] ,$sign_params['url']  ,$sign_params['url'] ,$sign_params['url'] ,$sign_params['url']);
// 		print_r($sign_params);
// 		echo "<hr>";
		$dictionary = '';
		foreach ($sign_params as $key => $val) {
			$dictionary .= $key.$val;
		}
// 		echo $dictionary."<hr>";
		$secret	= $params['secret'];
// 		$dictionary = $secret.$dictionary.$secret;
// 		$params['sign'] = md5($dictionary);
		$sign_method	= $this->sign_method;
		$params['sign'] = $sign_method($secret,$dictionary);
		$timestamp		 = $params['timestamp'];
		$secret			 = $params['secret'];
		$sign			 = $params['sign'];
		$params ['access_token'] = md5($timestamp.'_'.$secret.'_'.$sign);
		$url = empty ( $params ['url'] ) ? $this->b2c_url : $params ['url'];
		unset($params ['url']);
		// 选择请求方式
		switch ($method) {
			case 'GET' :
				$url = $url . '?' . http_build_query ( $params );
				$response = $this->http ( $url, 'GET' );
				break;
			default :
				if (is_array ($params) || is_object ($params)) {
					$body = http_build_query ( $params );
				}
				$response = $this->http ( $url, $method, $body );
		}
		if (isset ($params ['service']) && isset (self::$exe_count [$params ['service']])) {
			self::$exe_count [$params ['service']] += 1;
		} else if (isset ( $params ['service'] )) {
			self::$exe_count [$params ['service']] = 1;
		}
		return $response;
	}
	/**
	 * 本地时间
	 *
	 * @param array $params
	 * @param string $method
	 */
	private function local_time() {
		return self::$time_offset + $_SERVER['REQUEST_TIME'];
	}
	
	
	/**
	 * 用户登录(中间层)
	 */
	public function loginUserBase($login_id, $password, $fields = '') {
		// 中间层
		if (defined ( 'REG_LOG_MESPH' ) && REG_LOG_MESPH == 1) {
			$params ['url'] = $this->mesph_url;
	
			$params ['service'] = "platform.user.login";// "platform.user.login"; //vipshop.user.base.apiLogin
		} else {
			$params ['service'] = "platform.user.login";//platform.user.login"; // b2c接口   vipshop.user.base.login
		}
	
		// 用户名
		if (empty ( $login_id ))
			return false;
		else
			$params ['login_id'] = $login_id;
	
		// 密码
		if (empty ( $password ))
			return false;
		else
			$params ['password'] = $password;
	
		// 返回字段
		if (! empty ( $fields ) && is_string ( $fields ))
			$params ['fields'] = $fields;
		else
			$params ['fields'] = 'user_token,user_secret,user_name';
	
		$response = $this->execute ( $params );
		return $response;
	}
	
// 	public function fullmd5($secret,$dictionary)
// 	{
// 		return md5($secret.$dictionary.$secret);
// 	}
	
// 	public function leftmd5($secret,$dictionary)
// 	{
// 		return md5($secret.$dictionary);
// 	}
	
// 	public function rightmd5($secret,$dictionary)
// 	{
// 		return md5($dictionary.$secret);
// 	}
}


 	function fullmd5($secret,$dictionary)
	{
		return md5($secret.$dictionary.$secret);
	}

	 function leftmd5($secret,$dictionary)
	{
		return md5($secret.$dictionary);
	}

	function rightmd5($secret,$dictionary)
	{
		return md5($dictionary.$secret);
	}