<?php
/* PHP SDK
 * @version 2.0.0
 * @author connect@qq.com
 * @copyright © 2013, Tencent Corporation. All rights reserved.
 */

class Qq{

    const VERSION = "2.0";
    const GET_AUTH_CODE_URL = "https://graph.qq.com/oauth2.0/authorize";
    const GET_ACCESS_TOKEN_URL = "https://graph.qq.com/oauth2.0/token";
    const GET_OPENID_URL = "https://graph.qq.com/oauth2.0/me";
    public $state;
    public $openid;
    public $access_token;
    public $callback; 
    private static $data;

	public function __construct(){
        if(empty($_SESSION['QC_userData'])){
            self::$data = array();
        }else{
            self::$data = $_SESSION['QC_userData'];
        }
    }
    
	function __destruct(){
        $_SESSION['QC_userData'] = self::$data;
    }
    
    public function qq_login(){
        $this->appid = Config::get("QQAppid");
        $this->callback = Config::get("website")."/callback.php";
        $scope = "get_user_info,add_share,list_album,add_album,upload_pic,add_topic,add_one_blog,add_weibo,check_page_fans,add_t,add_pic_t,del_t,get_repost_list,get_info,get_other_info,get_fanslist,get_idolist,add_idol,del_idol,get_tenpay_addr";
        //-------生成唯一随机串防CSRF攻击
        $this->state = md5(uniqid(rand(), TRUE));
        self::$data["state"] = $this->state;
        //-------构造请求参数列表
        $keysArr = array(
            "response_type" => "code",
            "client_id" => $this->appid,
            "redirect_uri" => $this->callback,
            "state" => $this->state,
            "scope" => $scope
        );

        $login_url =  $this->combineURL(self::GET_AUTH_CODE_URL, $keysArr);

        header("Location:$login_url");
    }
    
	/**
     * combineURL
     * 拼接url
     * @param string $baseURL   基于的url
     * @param array  $keysArr   参数列表数组
     * @return string           返回拼接的url
     */
    public function combineURL($baseURL,$keysArr){
        $combined = $baseURL."?";
        $valueArr = array();
        foreach($keysArr as $key => $val){
            $valueArr[] = "$key=$val";
        }
        $keyStr = implode("&",$valueArr);
        $combined .= ($keyStr);
        return $combined;
    }
    
	/**
     * get_contents
     * 服务器通过get请求获得内容
     * @param string $url       请求的url,拼接后的
     * @return string           请求返回的内容
     */
    public function get_contents($url){
        if (ini_get("allow_url_fopen") == "1") {
            $response = file_get_contents($url);
        }else{
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_URL, $url);
            $response =  curl_exec($ch);
            curl_close($ch);
        }
        //-------请求为空
        if(empty($response)){
            exit("<h2>可能是服务器无法请求https协议</h2>可能未开启curl支持,请尝试开启curl支持，重启web服务器，如果问题仍未解决，请联系我们");
        }
        return $response;
    }

    public function qq_callback(){
        $state = self::$data["state"];
        //--------验证state防止CSRF攻击
        if($_GET['state'] != $state){
            exit($state."<h2>The state does not match. You may be a victim of CSRF.</h2>");
        }
        //-------请求参数列表
        $keysArr = array(
            "grant_type" => "authorization_code",
            "client_id" => Config::get("QQAppid"),
            "redirect_uri" => urlencode(Config::get("website")."/callback.php"),
            "client_secret" => Config::get("QQAppkey"),
            "code" => $_GET['code']
        );
        //------构造请求access_token的url
        $token_url = $this->combineURL(self::GET_ACCESS_TOKEN_URL, $keysArr);
        $response = $this->get_contents($token_url);
        if(strpos($response, "callback") !== false){
            $lpos = strpos($response, "(");
            $rpos = strrpos($response, ")");
            $response  = substr($response, $lpos + 1, $rpos - $lpos -1);
            $msg = json_decode($response);
            if(isset($msg->error)){
               exit($msg->error.$msg->error_description);
            }
        }
        $params = array();
        parse_str($response, $params);
        self::$data["access_token"]=$params["access_token"];
        return $params["access_token"];
    }

    public function get_openid(){
        //-------请求参数列表
        $keysArr = array(
            "access_token" => self::$data["access_token"]
        );
        $graph_url = $this->combineURL(self::GET_OPENID_URL, $keysArr);
        $response = $this->get_contents($graph_url);
        //--------检测错误是否发生
        if(strpos($response, "callback") !== false){
            $lpos = strpos($response, "(");
            $rpos = strrpos($response, ")");
            $response = substr($response, $lpos + 1, $rpos - $lpos -1);
        }
        $user = json_decode($response);
        if(isset($user->error)){
            exit($user->error.$user->error_description);
        }
        //------记录openid
        self::$data["openid"] =$user->openid;
        return $user->openid;
    }
}