<?php

defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class Upload {
	
	public $srcimg; //原图片
	public $destimg; //目标图片
	public $width; //原图片的宽度
	public $height; //原图片的高度
	public $type; //原文件的图片类型
	public $tmp; //上传图片的临时地址
	public $error; //错误信息
	public $im; // 创建一个临时的图片句柄
	public $new_name; //上传文件的新名字
	public $font; //水印字体
	public $bName; //完成后大图名称
	public $sName; //完成后小图名称
	public $cut; //是否剪切图片到指定高度
	public $thumb_width; //缩略图的宽度
	public $thumb_height; //缩略图的高度
	public $uploadDir; //上传的路径
	public $w_img; //水印图片路径
	public $w_pos; //水印位置
	public $w_txt; //水印文字
	public $w_font; //字体大小
	public $watermarktype; //0文字 1 图片
	public $watermarkw; //水印宽度
	public $watermarkh; //水印高度
	public $watermarkpct; //水印透明度
	public $watermarkq; //水印质量
	public $w_color; //字体颜色
	public $debug; //是否显示调试信息
	public $ifWater; //是否打水印
	public $randNum; //随机唯一数字
	

	function __construct($srcimg, $tmp, $error) {
		$this->srcimg = $srcimg;
		$this->tmp = $tmp;
		$this->error = $error;
		$this->cut = 1;
		$this->font = ROOT_PATH . "/statics/images/mark/arial.ttf";
		$this->w_img = ROOT_PATH . "/statics/images/mark/mark.png";
		$this->w_font = 18;
		$this->w_color = '#ff0000';
		$this->w_text = 'www.wodecms.com';
		$this->thumb_width = 120;
		$this->thumb_height = 150;
		$this->watermarktype = 1;
		$this->watermarkw = 300;
		$this->watermarkh = 300;
		$this->watermarkq = 100;
		$this->watermarkpct = 80;
		$this->randNum = rand ( 10000, 999999 );
		$this->uploadDir = ROOT_PATH . "/uploadfiles/" . date ( 'Y-m' ) . "/";
		$this->debug = false;
		$this->ifWater = true;
	}
	
	function img_upload() {
		//文件上传的方法
		$this->get_srcimg_type (); //判断源文件的图片类型
		$this->get_new_upload_name (); //上传的文件生成新的名字
		$this->check_error ( $this->error );
		$this->in_type ();
		if (! is_dir ( $this->uploadDir )) {
			mkdir ( $this->uploadDir, 0777 );
		}
		$this->ifWater = empty(Config::get("ifWater")) ? false : true;
		if (is_uploaded_file ( $this->tmp )) {
			if (move_uploaded_file ( $this->tmp, $this->new_name )) {
				if ($this->ifWater) {
					//使用示例
					$markimg = new ImageWatermark ($this->new_name);
					$markimg->markPosType = Config::get("w_pos");
					$markimg->fontSize = Config::get("w_font");
					$markimg->color = Config::get("w_color");
					if (Config::get("watermarktype") == 1) {
						$markimg->appendImageMark ();
					} else {
						$markimg->appendTextMark (Config::get("w_text"));
					}
					$markimg->write ($this->new_name);
					$markimg = null;
				}
				if ($this->debug) {
					echo Config::lang ( "UPLOADSUCCESS" );
				}
				return true;
			} else {
				if ($this->debug) {
					echo Config::lang ( "FILECANNOTMOVEUPLOADFAIL" );
				}
				exit ();
			}
		} else {
			if ($this->debug) {
				echo Config::lang ( "FILEUPLOADATTACK" );
			}
			exit ();
		}
		return true;
	}
	
	public function make_thumbnail() {
		//生成缩略图的方法
		$this->get_dest_imgpath ();
		$this->make_im ();
		$this->width = imagesx ( $this->im );
		$this->height = imagesy ( $this->im );
		$thumb_ratio = $this->thumb_width / $this->thumb_height;
		$ratio = $this->width / $this->height;
		if (Config::get('cut') == 1) { //是否裁剪
			if ($ratio >= $thumb_ratio) {
				$img = imagecreatetruecolor ( $this->thumb_width, $this->thumb_height );
				imagecopyresampled ( $img, $this->im, 0, 0, 0, 0, $this->thumb_width, $this->thumb_height, $this->height * $thumb_ratio, $this->height );
				imagejpeg ( $img, $this->destimg );
			} else {
				$img = imagecreatetruecolor ( $this->thumb_width, $this->thumb_height );
				imagecopyresampled ( $img, $this->im, 0, 0, 0, 0, $this->thumb_width, $this->thumb_height, $this->width, $this->width / $thumb_ratio );
				imagejpeg ( $img, $this->destimg );
			}
		} else {
			if ($ratio >= $thumb_ratio) {
				$img = imagecreatetruecolor ( $this->thumb_height * $thumb_ratio, $this->thumb_height );
				imagecopyresampled ( $img, $this->im, 0, 0, 0, 0, $this->thumb_height * $thumb_ratio, $this->thumb_height, $this->width, $this->height );
				imagejpeg ( $img, $this->destimg );
			} else {
				$img = imagecreatetruecolor ( $this->thumb_width, $this->thumb_width / $thumb_ratio );
				imagecopyresampled ( $img, $this->im, 0, 0, 0, 0, $this->thumb_width, $this->thumb_width / $thumb_ratio, $this->width, $this->height );
				imagejpeg ( $img, $this->destimg );
			}
		}
		imagedestroy ( $this->im );
		imagedestroy ( $img );
	}
	
	public function make_smallpicture() {
		//生成缩略图的方法
		$this->get_dest_imgpath ();
		$this->make_im ();
		$this->width = imagesx ( $this->im );
		$this->height = imagesy ( $this->im );
		$img = imagecreatetruecolor ( $this->width, $this->height );
		imagecopyresampled ( $img, $this->im, 0, 0, 0, 0, $this->width, $this->height, $this->width, $this->height ); //重采样拷贝部分图像并调整大小
		imagejpeg ( $img, $this->destimg, 50 );
		imagedestroy ( $this->im );
		imagedestroy ( $img );
	}
	
	private function check_error($error) {
		//检查文件上传传得错误；
		if ($error > 0) {
			switch ($error) {
				case 1 :
					echo Config::lang ( "FILEBIGGERTHANPHPINISET" );
					break;
				case 2 :
					echo Config::lang ( "FILEBIGGERTHANFORMFILES" );
					break;
				case 3 :
					echo Config::lang ( "JUSTUPLOADPARTOFFILE" );
					break;
				case 4 :
					echo Config::lang ( "NOTFILEBEUPLOAD" );
					break;
				case 6 :
					echo Config::lang ( "FILETEMPDIRUNKNOW" );
					break;
				case 7 :
					echo Config::lang ( "DISKCANBEWRITEUPLOADFAIL" );
					break;
				default :
					echo Config::lang ( "UNKNOWERROR" );
					break;
			}
		}
	}
	
	private function get_srcimg_type() {
		//判断源文件的图片类型
		$this->type = substr ( strrchr ( $this->srcimg, '.' ), '1' );
	}
	
	private function in_type() {
		//检查文件是否符合类型
		$postfix = Config::get ( 'postfix' );
		$postfix = empty($postfix) ? 'gif,jpg,jpeg,png,bmp,swf,doc,docx,xls,xlsx' : $postfix;
		$type_arr = explode ( ",", $postfix );
		$this->type = strtolower($this->type);
		if (! in_array ( $this->type, $type_arr )) {
			if ($this->debug) {
				echo Config::lang ( "JUSTACCEPTPNGGIFJPGTYPETRYAGGIN" );
			}
			exit ();
		}
	}
	
	private function get_new_upload_name() {
		//上传的文件生成新的名字
		$this->new_name = $this->uploadDir . date ( 'YmdHi' ) . $this->randNum . '.' . $this->type;
		$this->bName = date ( 'YmdHi' ) . $this->randNum . '.' . $this->type;
	}
	
	private function make_im() {
		//从原文件新建一幅图像
		switch ($this->type) {
			case 'jpg' :
				$this->im = imagecreatefromjpeg ( $this->new_name );
				break;
			case 'gif' :
				$this->im = imagecreatefromgif ( $this->new_name );
				break;
			case 'png' :
				$this->im = imagecreatefrompng ( $this->new_name );
				break;
		}
	}
	
	private function get_dest_imgpath() {
		//得到缩略图的存储路径
		$len1 = strlen ( $this->new_name ); //39
		$len2 = strlen ( strrchr ( $this->new_name, '.' ) ); //35
		$len3 = $len1 - $len2;
		$this->destimg = substr ( $this->new_name, 0, $len3 ) . '_s.' . $this->type;
		$this->sName = date ( 'YmdHi' ) . $this->randNum . '_s.' . $this->type;
	}
	
	public function ImageCheck($image) {
		return extension_loaded ( 'gd' ) && preg_match ( "/\.(jpg|jpeg|gif|png)/i", $image, $m ) && file_exists ( $image ) && function_exists ( 'imagecreatefrom' . ($m [1] == 'jpg' ? 'jpeg' : $m [1]) );
	}
}
