<?php

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class Url {

    public $urlType = 1;
    private $website;

    public function __construct() {
    	$webUrl = Config::getWebPath();
        $this->urlType = Config::get("urlType");
        $this->website = $webUrl;
    }
    
    //用户中心
    public function getUserhomeHref() {
    	if ($this->urlType == 1) {
    		$url = $this->website . '/index.php?ac=user_home';
    	} else if ($this->urlType == 2) {
    		$url = $this->website . '/html/user/home.html';
    	} else {
    		$url = $this->website . '/home.html';
    	}
    	return $url;
    }
    
    //退出
    public function getLoginoutHref() {
    	if ($this->urlType == 1) {
    		$url = $this->website . '/index.php?ac=user_loginout';
    	} else if ($this->urlType == 2) {
    		$url = $this->website . '/html/user/loginout.html';
    	} else {
    		$url = $this->website . '/loginout.html';
    	}
    	return $url;
    }
    

    //登陆
    public function getLoginHref() {
    	if ($this->urlType == 1) {
    		$url = $this->website . '/index.php?ac=user_login';
    	} else if ($this->urlType == 2) {
    		$url = $this->website . '/html/user/login.html';
    	} else {
    		$url = $this->website . '/login.html';
    	}
    	return $url;
    }
    
    //注册
    public function getRegHref() {
    	if ($this->urlType == 1) {
    		$url = $this->website . '/index.php?ac=user_reg';
    	} else if ($this->urlType == 2) {
    		$url = $this->website . '/html/user/reg.html';
    	} else {
    		$url = $this->website . '/reg.html';
    	}
    	return $url;
    }
    
    public function getNewsUrl($id) {
        $_Obj = get("news", $id);
        $b = "";
        $f = "";
        if ($_Obj->fonttype) {
            $b .= "<b>";
        }
        if (strlen($_Obj->color) > 2) {
            $b .= "<font color = " . $_Obj->color . ">";
        }
        if (strlen($_Obj->color) > 2) {
            $f .= "</font>";
        }
        if ($_Obj->fonttype) {
            $f .= "</b>";
        }
        $title = $b . $_Obj->title . $f;
        if ($this->urlType == 1) {
            $url = '<a href="' . $this->website . '/index.php?ac=news_show&id=' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        } else if ($this->urlType == 2) {
            $url = '<a href="' . $this->website . '/html/news/' . date("Ym", $_Obj->addtime) . '/' . $_Obj->id . '.html" target=_blank>' . $title . '</a>';
        } else {
            $url = '<a href="' . $this->website . '/news/show/' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        }
        return $url;
    }

    public function getNewsHref($id) {
        $_Obj = get("news", $id);
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=news_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/news/' . date("Ym", $_Obj->addtime) . '/' . $id . '.html';
        } else {
            $url = $this->website . '/post/' . $id;
        }
        return $url;
    }

    public function getNewsList($id="", $page="") {
        if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if (!empty($id)) {
            $_Obj = get("news", $id);
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=news_list&classid=' . $id . $pageStr;
            } else if ($this->urlType == 2) {
                $url = $this->website . '/news/list_' . $id . '_' . $page . '.html';
            } else {
                $pageStr = empty($page) ? "0" : '/' . $page;
                $url = $this->website . '/news/list/' . $id . $pageStr;
            }
        } else {
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=news_list' . $pageStr;
            } else if ($this->urlType == 2) {
                $pageStr = empty($page) ? "" : '_' . $page;
                $url = $this->website . '/news/list' . $pageStr . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/p' . $page;
                $idStr = empty($id) ? '0' : $id;
                $url = $this->website . '/news/list/' . $pageStr;
            }
        }
        return $url;
 
    }
    
    public function getSpecialHref($id) {
    	$_Obj = get("news", $id);
    	if ($this->urlType == 1) {
    		$url = $this->website . '/index.php?ac=special_show&id=' . $id;
    	} else if ($this->urlType == 2) {
    		$url = $this->website . '/html/special/' . date("Ym", $_Obj->addtime) . '/' . $id . '.html';
    	} else {
    		$url = $this->website . '/special/' . $id;
    	}
    	return $url;
    }
    
    public function getSpecialList($id="", $page="") {
    	if (defined("IN_ADMIN")) {
    		return $this->getList($id, $page);
    	}
    	if (!empty($id)) {
    		$_Obj = get("news", $id);
    		if ($this->urlType == 1) {
    			$pageStr = empty($page) ? "" : '&page=' . $page;
    			$url = $this->website . '/index.php?ac=special_list&classid=' . $id . $pageStr;
    		} else if ($this->urlType == 2) {
    			$url = $this->website . '/special/list_' . $id . '_' . $page . '.html';
    		} else {
    			$pageStr = empty($page) ? "0" : '/' . $page;
    			$url = $this->website . '/special/list/' . $id . $pageStr;
    		}
    	} else {
    		if ($this->urlType == 1) {
    			$pageStr = empty($page) ? "" : '&page=' . $page;
    			$url = $this->website . '/index.php?ac=special_list' . $pageStr;
    		} else if ($this->urlType == 2) {
    			$pageStr = empty($page) ? "" : '_' . $page;
    			$url = $this->website . '/special/list' . $pageStr . '.html';
    		} else {
    			$pageStr = empty($page) ? "" : '/p' . $page;
    			$idStr = empty($id) ? '0' : $id;
    			$url = $this->website . '/special/list/' . $pageStr;
    		}
    	}
    	return $url;
    
    }

    public function getPictureUrl($id) {
        $_Obj = get("picture", $id);
        $b = "";
        $f = "";
        if ($_Obj->fonttype) {
            $b .= "<b>";
        }
        if (strlen($_Obj->color) > 2) {
            $b .= "<font color = " . $_Obj->color . ">";
        }
        if (strlen($_Obj->color) > 2) {
            $f .= "</font>";
        }
        if ($_Obj->fonttype) {
            $f .= "</b>";
        }
        $title = $b . $_Obj->title . $f;
        if ($this->urlType == 1) {
            $url = '<a href="' . $this->website . '/index.php?ac=picture_show&id=' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        } else if ($this->urlType == 2) {
            $url = '<a href="' . $this->website . '/html/picture/' . date("Ym", $_Obj->addtime) . '/' . $_Obj->id . '.html" target=_blank>' . $title . '</a>';
        } else {
            $url = '<a href="' . $this->website . '/picture/show/' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        }
        return $url;
    }

    public function getPictureHref($id) {
        $_Obj = get("picture", $id);
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=picture_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/picture/' . date("Ym", $_Obj->addtime) . '/' . $id . '.html';
        } else {
            $url = $this->website . '/picture/show/' . $id;
        }
        return $url;
    }

    public function getPictureList($id="", $page="") {
    	if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if (!empty($id)) {
            $_Obj = get("picture", $id);
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=picture_list&classid=' . $id . $pageStr;
            } else if ($this->urlType == 2) {
                $url = $this->website . '/html/picture/list_' . $id . '_' . $page . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/' . $page;
                $url = $this->website . '/picture/list/' . $id . $pageStr;
            }
        } else {
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=picture_list' . $pageStr;
            } else if ($this->urlType == 2) {
                $pageStr = empty($page) ? "" : '_' . $page;
                $url = $this->website . '/html/picture/list' . $pageStr . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/page/' . $page;
                $idStr = empty($id) ? '' : $id;
                $url = $this->website . '/picture/list' . $idStr . $pageStr;
            }
        }
        return $url;
    }

public function getDownloadUrl($id) {
        $_Obj = get("download", $id);
        $b = "";
        $f = "";
        if ($_Obj->fonttype) {
            $b .= "<b>";
        }
        if (strlen($_Obj->color) > 2) {
            $b .= "<font color = " . $_Obj->color . ">";
        }
        if (strlen($_Obj->color) > 2) {
            $f .= "</font>";
        }
        if ($_Obj->fonttype) {
            $f .= "</b>";
        }
        $title = $b . $_Obj->title . $f;
        if ($this->urlType == 1) {
            $url = '<a href="' . $this->website . '/index.php?ac=download_show&id=' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        } else if ($this->urlType == 2) {
            $url = '<a href="' . $this->website . '/html/download/' . date("Ym", $_Obj->addtime) . '/' . $_Obj->id . '.html" target=_blank>' . $title . '</a>';
        } else {
            $url = '<a href="' . $this->website . '/download/show/' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        }
        return $url;
    }

    public function getDownloadHref($id) {
        $_Obj = get("download", $id);
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=download_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/download/' . date("Ym", $_Obj->addtime) . '/' . $id . '.html';
        } else {
            $url = $this->website . '/download/show/' . $id;
        }
        return $url;
    }

    public function getDownloadList($id="", $page="") {
        if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if (!empty($id)) {
            $_Obj = get("download", $id);
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=download_list&classid=' . $id . $pageStr;
            } else if ($this->urlType == 2) {
                $url = $this->website . '/download/list_' . $id . '_' . $page . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/' . $page;
                $url = $this->website . '/download/list/' . $id . $pageStr;
            }
        } else {
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=download_list' . $pageStr;
            } else if ($this->urlType == 2) {
                $pageStr = empty($page) ? "" : '_' . $page;
                $url = $this->website . '/download/list' . $pageStr . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/page/' . $page;
                $idStr = empty($id) ? '' : $id;
                $url = $this->website . '/download/list/' . $idStr . $pageStr;
            }
        }
        return $url;
    }
    
	public function getVideoUrl($id) {
        $_Obj = get("video", $id);
        $b = "";
        $f = "";
        if ($_Obj->fonttype) {
            $b .= "<b>";
        }
        if (strlen($_Obj->color) > 2) {
            $b .= "<font color = " . $_Obj->color . ">";
        }
        if (strlen($_Obj->color) > 2) {
            $f .= "</font>";
        }
        if ($_Obj->fonttype) {
            $f .= "</b>";
        }
        $title = $b . $_Obj->title . $f;
        if ($this->urlType == 1) {
            $url = '<a href="' . $this->website . '/index.php?ac=video_show&id=' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        } else if ($this->urlType == 2) {
            $url = '<a href="' . $this->website . '/html/video/' . date("Ym", $_Obj->addtime) . '/' . $_Obj->id . '.html" target=_blank>' . $title . '</a>';
        } else {
            $url = '<a href="' . $this->website . '/video/show/' . $_Obj->id . '" target=_blank>' . $title . '</a>';
        }
        return $url;
    }

    public function getVideoHref($id) {
        $_Obj = get("video", $id);
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=video_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/video/' . date("Ym", $_Obj->addtime) . '/' . $id . '.html';
        } else {
            $url = $this->website . '/video/show/' . $id;
        }
        return $url;
    }

    public function getVideoList($id="", $page="") {
        if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if (!empty($id)) {
            $_Obj = get("video", $id);
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=video_list&classid=' . $id . $pageStr;
            } else if ($this->urlType == 2) {
                $url = $this->website . '/video/list_' . $id . '_' . $page . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/' . $page;
                $url = $this->website . '/video/list/' . $id . $pageStr;
            }
        } else {
            if ($this->urlType == 1) {
                $pageStr = empty($page) ? "" : '&page=' . $page;
                $url = $this->website . '/index.php?ac=video_list' . $pageStr;
            } else if ($this->urlType == 2) {
                $pageStr = empty($page) ? "" : '_' . $page;
                $url = $this->website . '/video/list' . $pageStr . '.html';
            } else {
                $pageStr = empty($page) ? "" : '/page/' . $page;
                $idStr = empty($id) ? '' : $id;
                $url = $this->website . '/video/list/' . $idStr . $pageStr;
            }
        }
        return $url;
    }
    
    public function getBulletinHref($id) {
        $_Obj = get("bulletin", $id);
        if ($this->urlType == 1) {
            $url = 'index.php?ac=bulletin_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = 'html/bulletin/' . $id . '.html';
        } else {
            $url = 'bulletin/show/' . $id;
        }
        return $url;
    }

    public function getBulletinList($id="", $page="") {
    	if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=bulletin_list';
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/bulletin/List.html';
        } else {
            $url = $this->website . '/bulletin/list';
        }
        return $url;
    }

    public function getAboutHref($id) {
        $_Obj = get("bulletin", $id);
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=about_show&id=' . $id;
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/about/' . $id . '.html';
        } else {
            $url = $this->website . '/about/' . $id;
        }
        return $url;
    }

    public function getAboutList($id="", $page="") {
    	if (defined("IN_ADMIN")) {
            return $this->getList($id, $page);
        }
        if ($this->urlType == 1) {
            $url = $this->website . '/index.php?ac=about_list';
        } else if ($this->urlType == 2) {
            $url = $this->website . '/html/about/List.html';
        } else {
            $url = $this->website . '/about/list';
        }
        return $url;
    }

    public function getSearchList($id="", $page="", $isAdmin="") {
        $pageStr = empty($page) ? "" : '&page=' . $page;
        return $this->website . '/index.php?ac=search' . $pageStr;
    }

    public function getList($id="", $page="") {
		$currentPage = $_GET['page'];
		$url = $_SERVER["REQUEST_URI"];
		$pageStr = empty($page) ? "" : '&page=' . $page;
		$url_query = preg_replace("/(^|&)page=$currentPage/", "", $url);
		return $url_query.$pageStr;
	}

}
