<?php
defined('IN_ADMIN') or exit('Access Denied');
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class admin extends controller {

    /* 后台默认首页转向 */
    public function defaultAction() {
        if (!empty($_COOKIE['__RememberLogin'])) {
        	$userObj = get("user",intval($_SESSION['userId']));
            $this->setValue("username",$userObj->username);
        }
        $pos = strrpos($_SERVER["REQUEST_URI"], "//");
        if ($pos !== false) {// 注意: 三个等号
        	header("Location:".Config::get("website")."/".Config::get('admin'));
        	//StringUtil::msgbox("URL含有两个斜杠,修复后重定向中...", Config::get("website")."/".Config::get('admin'), 1, "warning");
        	exit;
        }
        $this->setValue("background",rand(1,8));
        $this->forward("admin/login.html");
    }

    /* 后台管理员登陆 */
    public function login() {
        $userObj = M('user');
        $this->setValue("background",rand(1,8));
        if (empty($_POST['username']) || empty($_POST['password']) || empty($_POST['code'])) {
            $this->setValue("error", Config::lang("LOGINMSGNOTBEEMPTY"));
            $this->forward("admin/login.html");
            exit;
        }
        //防注入
        $username = trim($_POST['username']);
        $username = StringUtil::safe_replace($username);
		$username = StringUtil::remove_xss($username);
        $password = md5(trim($_POST['password']));
        $isLogin = $userObj->adminLogin($username, $password);
        $codeStr = $_SESSION["teamcencom"];
        unset($_SESSION["teamcencom"]);
        if (strcmp($codeStr, trim(strtolower($_POST['code'])))) {
            $this->setValue("error", Config::lang("CHECKCODEWRONG"));
            $this->forward("admin/login.html");
            exit;
        }
        $this->checkErrorLogin ( $userObj, $username, $password );
        if (!$isLogin) {
            Log::Login($username,Config::lang("USERNAMEORPASSWORDWRONG"));
            $this->setValue("error", Config::lang("USERNAMEORPASSWORDWRONG"));
            $this->forward("admin/login.html");
            exit;
        } else {
            if (!empty($_POST["isRememberUsername"])) {
                setcookie("__RememberLogin", true, time() + 86400, "/", Config::get("cookdomain"));
            }
            $_SESSION['user'] = $isLogin;
            Authen::setUserLogin($_SESSION['user']['id'], $_SESSION['user']['password']);
            $userObj->id = $_SESSION['user']['id'];
            $userObj->lastvist = time();
            $userObj->lastip = NetUtil::getIp();
            $userObj->logintime = $isLogin['logintime'] + 1;
            $userObj->update();
            $this->tpl->clear_all_cache();
            $onlineObj = M("online");
            $onlineObj->id = $_SESSION['user']['id'];
            $onlineObj->intime = time();
            $onlineObj->islogin = 1;
            $onlineObj->saveOrUpdate();
            //
            Log::Login($username,Config::lang("LOGINSUCCESSSECRECY"));
            StringUtil::msgbox(Config::lang("LOGINSUCCESS"), Config::get('admin').'?ac=admin_home', 1);
        }
    }

	private function checkErrorLogin($userObj, $username, $password) {
		$open = Config::get ( "logincheck" );
		if (! empty ( $open )) {
			$row = $userObj->query ( "SELECT id,password,errortime,errorcount FROM tc_user WHERE username='" . $username . "'" );
			if ($row) {
				//是否被锁定
				if ($row [0] ['password'] !=  $password && $row [0] ['errorcount'] == Config::get ( "errorcount" )){
					$lastTimes = (time () - $row [0] ['errortime']) < 60 * Config::get ( "errortime" );
					if ($row [0] ['errorcount'] >= Config::get ( "errorcount" ) && $lastTimes) {
						StringUtil::gourl(Config::get("admin"),Config::lang ( "LOCKLOGINPRESSING"));
						exit ();
					}
				}
				//密码错了
				if ($row [0] ['password'] != $password && $row [0] ['errorcount'] < Config::get ( "errorcount" )) {
					$times = Config::get ( "errorcount" ) - $row [0] ['errorcount'];
					$updateStr = "update tc_user set errorcount = errorcount + 1,errortime= " . time () . " WHERE username='" . $username . "'";
					$userObj->query ( $updateStr );
					StringUtil::gourl(Config::get("admin"),Config::lang ( "WILLLOCKLOGININTIMES", $times ));
					exit ();
				}
				//密码对了
				if ($row [0] ['password'] == $password) {
					$updateStr = "update tc_user set errorcount = 0,errortime= " . time () . " WHERE username='" . $username . "'";
					$userObj->query ( $updateStr );
				}
			}
		}
	}

    /* 后台管理员退出 */
    public function loginout() {
        session_destroy();
        session_unset();
        session_write_close();
        $this->tpl->clear_all_cache();
        //
        $onlineObj = M("online");
        $onlineObj->id = $_SESSION['userId'];
        $onlineObj->outtime = time();
        $onlineObj->islogin = 0;
        $onlineObj->saveOrUpdate();
        //
        setcookie("userId", "", time() - 60 * 60 * 24 * 365, "/", Config::get("cookdomain"));
        setcookie("AuthenId", "", time() - 60 * 60 * 24 * 365, "/", Config::get("cookdomain"));
        setcookie("__RememberLogin", "", time() - 60 * 60 * 24 * 365, "/", Config::get("cookdomain"));
        Log::Login($_SESSION['user']['username'],Config::lang("LOGINOUT"));
        StringUtil::msgbox(Config::lang("LOGINOUTSUCCESS"), Config::get('admin'), 1);
    }

	/* 后台管理主页 */
    public function home() {
		if (!Authen::isAdmin()) {StringUtil::msgbox(Config::lang("NOTRIGHT"), Config::get('admin'), 1);Authen::setUserLoginOut();exit;}
		
		$userObj = M("user");
		$_Obj = M("products");
    	$codeObj = M("code_check");
    	$agentObj = M("agent_check");
    	
    	$codeAry = $codeObj->query("select results,addtime,keyword from tc_code_check order by addtime desc limit 7");
    	$agentAry = $agentObj->query("select results,addtime,keyword from tc_agent_check order by addtime desc limit 7");
        //var_dump($customerAry);

    	//防伪码总数
    	$this->setValue("codenum", $userObj->getcodenum());
    	//最后防伪码时间
    	$this->setValue("codelast", $userObj->getcodelast());
    	//代理商总数
    	$this->setValue("agentnum", $userObj->getagentnum());
    	//最后代理商注册时间
    	$this->setValue("agentlast", $userObj->getagentlast());
    	//统计防伪码查询总数
    	$this->setValue("codechecknum", $userObj->getcodechecknum());
    	//最新添加的一个防伪码查询时间
    	$this->setValue("codechecklast", $userObj->getcodechecklast());
    	//统计代理商查询总数
    	$this->setValue("agentchecknum", $userObj->getagentchecknum());
    	//最新添加的一个代理商查询时间
    	$this->setValue("agentchecklast", $userObj->getagentchecklast());
    	//授权代理商统计
    	$this->setValue("licensechecknum", 0);
    	//最近添加授权统计
    	$this->setValue("licensechecktime", 0);
    	//下载统计
    	$this->setValue("customernum", 0);
    	//最近添加的下载
    	$this->setValue("customertime", time());
    	$this->setValue("customerAry", array());
    	$this->setValue("codeAry", $codeAry);
    	$this->setValue("agentAry", $agentAry);
    	$this->setValue("Obj", $_Obj);
        $this->forward("admin/index.html");
    }

    /* 后台管理中心 */
    public function main() {$userObj = M('user');
        $this->forward("admin/home.html");
    }

    public function center() {
        $this->forward("admin/center.html");
    }

    public function left() {
        $this->forward("admin/left.html");
    }

    public function header() {
        $this->forward("admin/header.html");
    }

    public function footer() {
        $this->forward("admin/footer.html");
    }
}
