<?php
defined ( 'IN_ADMIN' ) or exit ( 'Access Denied' );
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class plugins extends controller {
	public $objName = 'plugins';
	public function add() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$this->getValidAry ( $_Obj );
		$_Obj = $_Obj->copyData ();
		if ($row ["usercategory"] == 1) {
			$this->showCategory ( $_Obj, $row ["id"] );
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	public function listAll() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$_Obj->pageSize = 15;
		$_Obj->orderby ( 'id desc' );
		//搜索字段
		$where = '1=1';
		if (! empty ( $row )) {
			$fieldAry = $fieldObj->getSearchFields ( $row ["id"] );
			foreach ( $fieldAry as $k => $v ) {
				$value = $_GET [$v ["fieldname"]];
				if (! empty ( $value )) {
					if ($v ["formtype"] == 'input' && $v ["type"] == 'VARCHAR') {
						$where .= " and " . $v ["fieldname"] . " like '%$value%'";
					} else {
						$where .= " and " . $v ["fieldname"] . " = '" . $value . "'";
					}
				}
			}
		}
		$_objAry = $_Obj->where ( $where )->getList ();
		//
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		if ($row ["usercategory"] == 1) {
			$this->showCategory ( $_Obj, $row ["id"] );
		}
		//搜索
		$searchStr = $fieldObj->getSearchStr ( $_Obj, $row ["id"] );
		$this->setValue ( "searchStr", $searchStr );
		$this->setValue ( "Obj", $_Obj );
		$this->setValue ( "objAry", $_objAry );
		$this->forward ( "admin/" . $this->objName . "_list.html" );
	}
	
	public function edite() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$_Obj = $_Obj->load ( intval ( $_GET ['id'] ) );
		if ($row ["usercategory"] == 1) {
			$this->showCategory ( $_Obj, $row ["id"] );
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	private function getValidAry($_Obj) {
		$row = $this->getMid ();
		//表单验证字段
		$validAry = $_Obj->query ( "SELECT id,name,fieldname,pattern,errortips,tips FROM tc_field WHERE not_null =1 AND isshow=1 and mid=" . $row ["id"] );
		$this->setValue ( "validAry", $validAry );
		return $validAry;
	}
	
	private function showAreaSelect() {
		//地区
		$areaObj = M ( 'area' );
		$areaAry = $areaObj->getPrentAry ();
		$this->setValue ( "areaAry", $areaAry );
		$this->setValue ( "areaObj", $areaObj );
		//end
	}
	
	private function showCategory($Obj, $mid) {
		$categoryObj = M ( "category" );
		if (! empty ( $Obj->pid )) {
			$categoryObj = get ( "category", $Obj->pid );
			$categoryObj->isSelf = true;
		}
		$pidSelectStr = $categoryObj->getTree ( $categoryObj, $mid, false );
		$this->setValue ( "pidSelectStr", $pidSelectStr );
	}
	
	public function saveOrUpdate() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$msgObj = new Msg ();
		$_Obj->create ();
		
		//checkbox
		$keys = array_keys ( $_Obj->fields );
		foreach ( $_POST as $k => $v ) {
			if (is_array ( $v ) && $k != 'info' && in_array ( $k, $keys )) {
				$rt = implode ( ",", $_POST [$k] );
				$_Obj->$k = $rt;
			}
		}
		//end
		//特殊字段赋值IP地址,用户ID，添加时间
		$fields = $fieldObj->where ( "mid=" . $row ["id"] . " and formtype IN ('ipaddress','userid','addtime')" )->orderby ( "listorder desc" )->limit ( 1000 )->find ();
		if (! empty ( $fields )) {
			foreach ( $fields as $k => $v ) {
				if ($v ["formtype"] == 'userid') {
					$_Obj->$v ["fieldname"] = $_SESSION ["userId"];
				} else if ($v ["formtype"] == 'ipaddress') {
					$_Obj->$v ["fieldname"] = NetUtil::getIp ();
				} else if ($v ["formtype"] == 'addtime') {
					$_Obj->$v ["fieldname"] = time ();
				}
			}
		}
		//end
		//表单验证
		$validAry = $this->getValidAry ( $_Obj );
		foreach ( $validAry as $k => $v ) {
			$fieldname = $v ["fieldname"];
			if (empty ( $_Obj->$fieldname ) && empty ( $v ["pattern"] )) {
				$msgObj->addMsg ( 'error', $v ["name"] . "不能为空!" );
			} else if (! empty ( $v ["pattern"] ) && ! preg_match ( '/' . StringUtil::stripslashes_deep ( $v ["pattern"] ) . "/", $_Obj->$fieldname )) {
				$msgObj->addMsg ( 'error', $v ["errortips"] );
			}
		}
		//end
		if (!$msgObj->hasMsg) {
        	if ($_Obj->saveOrUpdate ()) {
				$errorMsg = empty($_Obj->id) ? Config::lang ( "SAVESUCCESS" ) : Config::lang ( "UPDATESUCCESS" );
				$msgObj->addMsg ( 'success', $errorMsg );
			} else {
				$errorMsg = empty($_Obj->id) ? '添加失败' : '更新失败';
				$msgObj->addMsg ( 'error', $errorMsg );
			}
        }
		if ($row ["usercategory"] == 1) {
			//栏目
			$this->showCategory ( $_Obj, $row ["id"] );
			//
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	public function delete() {
		$_Obj = M ( $this->objName );
		$_Obj->delete ();
		header ( "Location:?ac=plugins_list" );
		exit ();
	}
	
	private function getMid() {
		$_Obj = M ( $this->objName );
		$sql = 'SELECT id,usercategory FROM tc_model WHERE tablename= "' . $_Obj->table . '"';
		$info = $_Obj->query ( $sql );
		return $info [0];
	}
	
	private function haveArea() {
		$_Obj = M ( $this->objName );
		$row = $this->getMid ();
		$sql = "SELECT count(*) as total FROM tc_field WHERE mid= '" . $row ["id"] . "' and formtype = 'linkage'";
		$info = $_Obj->query ( $sql );
		return $info [0] ["total"] > 0;
	}
}

