<?php

defined('WODE_CMS') or exit('Access Denied');

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * @notice :    backup完整目录如果有_v的字符,会导致sql导入失败
 * =======================================================
 */
class DBManage {
	var $db;
	var $database;
	var $sqldir;
	var $record;
	private $ds = "\n";
	public $sqlContent = "";
	public $sqlEnd = ";";
	public $size;
	public $dir;

	function __construct() {
		$this->database = DBNAME;
		$this->size = 2048;
		$this->dir = ROOT_PATH.'/'.APP_PATH.'/data/backup/';
		$this->db = mysql::getInstance();
	}

	/*
	 * ------------------------------------------数据库备份start----------------------------------------------------------
	 */

	/**
	 * 数据库备份
	 * @param $string $this->dir
	 * @param int $this->size
	 * @param $string $tablename
	 */
	function backup($tablename = '') {
		// 只备份某个表
		if (! empty ( $tablename )) {
			$sql = $this->_retrieve ();
			$sql .= $this->_insert_table_structure ( $tablename );
			$data = mysql_query ( "select * from " . $tablename );
			$filename = date ( 'YmdHis' ) . "_" . $tablename;
			$num_fields = mysql_num_fields ( $data );
			$p = 1;
			while ( $record = mysql_fetch_array ( $data ) ) {
				$sql .= $this->_insert_record ( $tablename, $num_fields, $record );
				if (strlen ( $sql ) >= $this->size * 1000) {
					$file = $filename . "_v" . $p . ".sql";
					if ($this->_write_file ( $sql, $file, $this->dir )) {
						$msg =  "Table-" . $tablename . "-Volume-" . $p . "-Data BackUp Finish,Create BackUp File <span style='color:#f00;'>".$this->dir.$filename."</span>";
						Log::info($msg);
					} else {
						$msg = "BackUp Volume-" . $p . "-Fail";
						Log::error($msg);
					}
					$p ++;
					$sql = "";
				}
			}
			if ($sql != "") {
				$filename .= "_v" . $p . ".sql";
				if ($this->_write_file ( $sql, $filename, $this->dir )) {
					$msg = "Table-" . $tablename . "-Volume-" . $p . "-Data BackUp Finish,Create BackUp File <span style='color:#f00;'>".$this->dir.$filename."</span>";
					Log::info($msg);
				} else {
					$msg = "BackUp Volume-" . $p . "-Fail";
					Log::error($msg);
				}
			}
		} else {
			if ($tables = mysql_query ( "show table status from " . $this->database )) {
				$msg = "Read Database Driscript Success!";
				Log::info($msg);
			} else {
				$msg =  "Read Database Driscript Fail!";
				Log::info($msg);
				exit;
			}
			$sql .= $this->_retrieve ();
			$filename = date ( 'YmdHis' ) . "_all";
			$tables = mysql_query ( 'SHOW TABLES' );
			$p = 1;
			while ( $table = mysql_fetch_array ( $tables ) ) {
				$tablename = $table [0];
				$sql .= $this->_insert_table_structure ( $tablename );
				$data = mysql_query ( "select * from " . $tablename );
				$num_fields = mysql_num_fields ( $data );

				while ( $record = mysql_fetch_array ( $data ) ) {
					$sql .= $this->_insert_record ( $tablename, $num_fields, $record );
					if (strlen ( $sql ) >= $this->size * 1000) {
						$file = $filename . "_v" . $p . ".sql";
						if ($this->_write_file ( $sql, $file, $this->dir )) {
							$msg = "-Volume-" . $p . "-Data BackUp Finish,Create BackUp File<span style='color:#f00;'>".$this->dir.$file."</span>";
							Log::info($msg);
						} else {
							$msg = "BackUp Volume-" . $p . "-Fail";
							Log::info($msg);
						}
						$p ++;
						$sql = "";
					}
				}
			}
			if ($sql != "") {
				$filename .= "_v" . $p . ".sql";
				if ($this->_write_file ( $sql, $filename, $this->dir )) {
					$msg = "-Volume-" . $p . "-Data BackUp Finish,Create BackUp File <span style='color:#f00;'>".$this->dir.$filename."";
					Log::info($msg);
				} else {
					$msg = "BackUp Volume-" . $p . "-Fail";
					Log::error($msg);
				}
			}
		}
	}

	/**
	 * 插入数据库备份基础信息
	 *
	 * @return string
	 */
	private function _retrieve() {
		$value = '';
		$value .= '--' . $this->ds;
		$value .= '-- MySQL database dump' . $this->ds;
		$value .= '-- Created by Admin, Power By WODECMS. ' . $this->ds;
		$value .= '-- http://www.wodecms.com ' . $this->ds;
		$value .= '--' . $this->ds;
		$value .= '-- Server: ' . $this->host . $this->ds;
		$value .= '-- CreateDate: ' . date ( 'Y' ) . Config::lang("YEAR") . date ( 'm' ) . ' Config::lang("MONTH") ' . date ( 'd' ) . Config::lang("DAY") . date ( 'H:i' ) . $this->ds;
		$value .= '-- MySQL Version: ' . mysql_get_server_info () . $this->ds;
		$value .= '-- PHP Version: ' . phpversion () . $this->ds;
		$value .= $this->ds;
		$value .= '--' . $this->ds;
		$value .= '-- Database: `' . $this->database . '`' . $this->ds;
		$value .= '--' . $this->ds . $this->ds;
		$value .= '-- -------------------------------------------------------';
		$value .= $this->ds . $this->ds;
		return $value;
	}

	/**
	 * 插入表结构
	 *
	 * @param unknown_type $table
	 * @return string
	 */
	private function _insert_table_structure($table) {
		$sql = '';
		$sql .= "--" . $this->ds;
		$sql .= "-- TABLE DESC" . $table . $this->ds;
		$sql .= "--" . $this->ds . $this->ds;
		$sql .= "DROP TABLE IF EXISTS `" . $table . '`' . $this->sqlEnd . $this->ds;
		$res = mysql_query ( 'SHOW CREATE TABLE `' . $table . '`' );
		$row = mysql_fetch_array ( $res );
		$sql .= $row [1];
		$sql .= $this->sqlEnd . $this->ds;
		$sql .= $this->ds;
		$sql .= "--" . $this->ds;
		$sql .= "-- MOVE DATABASE DATAS " . $table . $this->ds;
		$sql .= "--" . $this->ds;
		$sql .= $this->ds;
		return $sql;
	}

	/**
	 * 插入单条记录
	 *
	 * @param string $table
	 * @param int $num_fields
	 * @param array $record
	 * @return string
	 */
	private function _insert_record($table, $num_fields, $record) {
		$comma = "";
		$insert .= "INSERT INTO `" . $table . "` VALUES(";
		for($i = 0; $i < $num_fields; $i ++) {
			$insert .= ($comma . "'" . mysql_escape_string ( $record [$i] ) . "'");
			$comma = ",";
		}
		$insert .= ");" . $this->ds;
		return $insert;
	}

	/**
	 * 写入文件
	 *
	 * @param string $sql
	 * @param string $filename
	 * @param string $this->dir
	 * @return boolean
	 */
	private function _write_file($sql, $filename) {
		if (! file_exists ( $this->dir )) {
			mkdir ( $this->dir );
		}
		$re = true;
		if (! @$fp = fopen ( $this->dir . $filename, "w+" )) {
			$re = false;
			Log::error(Config::lang("OPENFILEFAIL"));
		}
		if (! @fwrite ( $fp, $sql )) {
			$re = false;
			Log::error(Config::lang("WRITEFILEFAIL"));
		}
		if (! @fclose ( $fp )) {
			$re = false;
			Log::error(Config::lang("CLOSEFILEFAIL"));
		}
		return $re;
	}

	/**
	 * 导入备份数据
	 * 说明：分卷文件格式20120516211738_all_v1.sql
	 * 参数：文件路径(必填)
	 *
	 * @param string $sqlfile
	 */
	function restore($sqlfile) {
		if (! file_exists ( $sqlfile )) {
			Log::info(Config::lang("FILENOTEXISTSPLEASECHECK"));
			exit ();
		}
		$this->lock ( $this->database );
		$sqlpath = pathinfo ( $sqlfile );
		$this->sqldir = $sqlpath ['dirname'];
		$volume = explode ( "_v", $sqlfile );
		$volume_path = $volume [0];
		if (empty ( $volume [1] )) {
			$msg = "Import Sql：<span style='color:#f00;'>" . $sqlfile . '</span>';
			Log::info($msg);
			// 没有分卷
			if ($this->_import ( $sqlfile )) {
				Log::info(Config::lang("IMPORTDATABASESUCCESS"));
			} else {
				Log::error(Config::lang("IMPORTDATABASEFAIL"));
				exit;
			}
		} else {
			$volume_id = explode ( ".sq", $volume [1] );
			$volume_id = intval ( $volume_id [0] );
			while ( $volume_id ) {
				$tmpfile = $volume_path . "_v" . $volume_id . ".sql";
				if (file_exists ( $tmpfile )) {
					$val = $this->db->mysqlRead($tmpfile);
					foreach ($val as $sql) {
						$result = mysql_query($sql);
						if (!$result) {
							$msg = 'Query ' . $sql . ' Fail';
							Log::error($msg);
						}
					}
				} else {
					Log::info(Config::lang("THISDATABASEIMPORTALLSUCCESS"));
					return;
				}
				$volume_id ++;
			}
		}
	}

	/**
	 * 将sql导入到数据库（普通导入）
	 *
	 * @param string $sqlfile
	 * @return boolean
	 */
	private function _import($sqlfile) {
		$sqls = array ();
		$f = fopen ( $sqlfile, "rb" );
		$create = '';
		while ( ! feof ( $f ) ) {
			$line = fgets ( $f );
			if (trim ( $line ) == '' || preg_match ( '/--*?/', $line, $match )) {
				continue;
			}
			if (! preg_match ( '/;/', $line, $match ) || preg_match ( '/ENGINE=/', $line, $match )) {
				$create .= $line;
				if (preg_match ( '/ENGINE=/', $create, $match )) {
					$sqls [] = $create;
					$create = '';
				}
				continue;
			}
			$sqls [] = $line;
		}
		fclose ( $f );
		foreach ( $sqls as $sql ) {
			str_replace ( "\n", "", $sql );
			if (! mysql_query ( trim ( $sql ) )) {
				echo mysql_error ();
				return false;
			}
		}
		return true;
	}

	private function close() {
		mysql_close ( $this->db );
	}

	private function lock($tablename, $op = "WRITE") {
		if (mysql_query ( "lock tables " . $tablename . " " . $op ))
		return true;
		else
		return false;
	}

	private function unlock() {
		if (mysql_query ( "unlock tables" ))
		return true;
		else
		return false;
	}
}
