<?php

defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class attackAction extends attackBase {
	
	// get拦截规则
	private $getfilter = "<[^>]*?=[^>]*?&#[^>]*?>|\\b(alert\\(|confirm\\(|expression\\(|prompt\\()|<[^>]*?\\b(onerror|onmousemove|onload|onclick|onmouseover)\\b[^>]*?>|^\\+\\/v(8|9)|\\b(and|or)\\b\\s*?([\\(\\)'\"\\d]+?=[\\(\\)'\"\\d]+?|[\\(\\)'\"a-zA-Z]+?=[\\(\\)'\"a-zA-Z]+?|>|<|\s+?[\\w]+?\\s+?\\bin\\b\\s*?\(|\\blike\\b\\s+?[\"'])|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
	// post拦截规则
	private $postfilter = "<[^>]*?=[^>]*?&#[^>]*?>|\\b(alert\\(|confirm\\(|expression\\(|prompt\\()|<[^>]*?\\b(onerror|onmousemove|onload|onclick|onmouseover)\\b[^>]*?>|\\b(and|or)\\b\\s*?([\\(\\)'\"\\d]+?=[\\(\\)'\"\\d]+?|[\\(\\)'\"a-zA-Z]+?=[\\(\\)'\"a-zA-Z]+?|>|<|\s+?[\\w]+?\\s+?\\bin\\b\\s*?\(|\\blike\\b\\s+?[\"'])|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
	// cookie拦截规则
	private $cookiefilter = "\\b(and|or)\\b\\s*?([\\(\\)'\"\\d]+?=[\\(\\)'\"\\d]+?|[\\(\\)'\"a-zA-Z]+?=[\\(\\)'\"a-zA-Z]+?|>|<|\s+?[\\w]+?\\s+?\\bin\\b\\s*?\(|\\blike\\b\\s+?[\"'])|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
	
	public function __construct() {
		parent::__construct ();
	}
	
	private function inject_check($sql_str) {
		return preg_match ( '/select|insert|\'|\/\*|\*|\.\.\/|\.\/|union|into|and|or|load_file|outfile/', $sql_str ); // 进行过滤
	}
	
	public function lockById($id) {
		$sql = "update " . $this->table . " set killip = 1 where id = " . $id;
		$this->db->query ( $sql );
	}
	
	public function noLockById($id) {
		$sql = "update " . $this->table . " set killip = 0 where id = " . $id;
		$this->db->query ( $sql );
	}
	
	public function checkForbidden() {
		$ip = NetUtil::getIp ();
		$attackAry = $this->where ( "killip = 1 and ip ='" . $ip . "'" )->find ();
		return count ( $attackAry ) > 0;
	}
	
	/*
	 * post或get,统一小写!
	 * */
	public function initLogHacker() {
		foreach ( $_GET as $key => $value ) {
			$this->StopAttack ( $key, $value, "get", $this->getfilter );
		}
	}
	
	private function StopAttack($StrFiltKey, $StrFiltValue, $method, $ArrFiltReq) {
		$StrFiltValue = strtolower ( $StrFiltValue );
		if (is_array ( $StrFiltValue )) {
			$StrFiltValue = implode ( $StrFiltValue );
		}
		if ($this->inject_check ( $StrFiltValue ) || preg_match ( "/" . $ArrFiltReq . "/is", $StrFiltValue ) == 1) {
			if ($method == 'cookie') {
				$this->logAttack ( $StrFiltValue, $method, $StrFiltKey );
			}
			if ($method == 'get') {
				$this->logAttack ( $StrFiltValue, $method, $StrFiltKey );
			}
			if ($method == 'post') {
				$this->logAttack ( $StrFiltValue, $method, $StrFiltKey );
			}
		}
	}
	
	private function logAttack($StrFiltValue, $method, $action) {
		$attackStr = "<br><br>SubmitIP:" . $_SERVER ["REMOTE_ADDR"] . "<br>SubmitTime:" . strftime ( "%Y-%m-%d %H:%M:%S" ) . "<br>SubmitPage:" . $_SERVER ["REQUEST_URI"] . "<br>SubmitMethod:" . $_SERVER ["REQUEST_METHOD"] . "<br>SubmitParams:" . NetUtil::get_url () . "<br>SubmitData:" . $StrFiltValue;
		$mailObj = new Email ();
		$this->url = NetUtil::get_url ();
		$this->ip = NetUtil::getIp ();
		$this->str = $attackStr;
		$this->killip = 0;
		$this->method = $method;
		$this->addtime = time ();
		$row = $this->query ( "select id from " . TABLEPRE . "attack where ip='" . NetUtil::getIp () . "'" );
		if (count ( $row ) > 5) {
			$this->id = $row [0] ["id"];
			$this->killip = 1;
			$this->update ();
		} else {
			//$this->save ();
		}
		if (Config::get ( 'attackmail' ) == 1) {
			$mailObj->Subject = "WebSite Attack Notice";
			$mailObj->Body = $attackStr;
			//$mailObj->sendMail ();
		}
	}
}
