<?php

defined('WODE_CMS') or exit('Access Denied');

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class userAction extends userBase {

    public function __construct() {
        parent :: __construct();
    }
    
    /**
     * 判断是否以http://开头
     */
    public static function isHttpStart($valueStr)
    {
    	return substr($valueStr, 0, 5) == 'http:';
    }
    
    //通过id或者商城链接
    public function getMallBygid($mallid){
    	if(empty($mallid)){return 0;}
    	$_Obj = get("mall",$mallid);
    	$mallurl = $_Obj->domain;
    	if (self::isHttpStart($mallurl)){
    		return $mallurl;
    	}else{
    		$mallurl = 'http://' . $mallurl;
    		return $mallurl;
    	}
    }
    
    //通过id查询品牌链接
    public function getBrandByid($id){
    	if(empty($id)){return 0;}
    	$_Obj = get("brand",$id);
    	$domain = $_Obj->domain;
    	if (self::isHttpStart($domain)){
    		return $domain;
    	}else{
    		$domain = 'http://' . $domain;
    		return $domain;
    	}
    	 
    }
    
    //通过id获取商城名称
    public function getMallNameBygid($mallid){
    	if(empty($mallid)){return 0;}
    	$_Obj = get("mall",$mallid);
    	$title = $_Obj->title;
    	return $title;
    }

    /*     * ***************************************************************
      -- 函数名：checkaUserLogin($username, $password)
      -- 作  用：前台登陆验证
      -- 参  数：$username, $password
      -- 返回值：boolean
      -- 实  例：无
     * ***************************************************************** */

    public function checkUserLogin($username, $password) {
        $pwd1 = md5(trim($password));
        $sql = "select * from " . $this->table . " where username='".$username."' and password='".$pwd1."' and status=1";
        $sql = str_replace("#", '', $sql);
        $sql = str_replace("-", '', $sql);
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            return false;
        } else {
            return $row;
        }
    }

	public function getpName($pid) {
    	$groupObj = M("project");
    	$groupObj = $groupObj->load($pid);
        return $groupObj->name;
    }

    /*     * ***************************************************************
      -- 函数名：adminLogin($username, $password)
      -- 作  用：管理员后台登陆验证
      -- 参  数：$username, $password
      -- 返回值：boolean
      -- 实  例：无
     * ***************************************************************** */

    public function adminLogin($username, $password) {
        $sql = "select * from " . $this->table . " where username='$username' and password='$password' and isadmin = 1 and status=1";
        $sql = str_replace("#", '', $sql);
        $sql = str_replace("-", '', $sql);
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            return false;
        } else {
            return $row;
        }
    }

    public function adminReLogin($uid) {
        $sql = "select * from " . $this->table . " where id=".$uid;
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            return false;
        } else {
            return $row;
        }
    }

    /*     * ***************************************************************
      -- 函数名：ajaxCheck($username)
      -- 作  用：重名会员登陆验证
      -- 参  数：$username
      -- 返回值：boolean
      -- 实  例：无
     * ***************************************************************** */

    public function ajaxCheck($username) {
        $sql = "select * from " . $this->table . " where username='$username'";
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            echo 0;
        } else {
            echo 1;
        }
    }

    public function ajaxCheckByEmail($email) {
        $sql = "select * from " . $this->table . " where email='$email'";
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            echo 0;
        } else {
            echo 1;
        }
    }

    public function normalCheck($username) {
        $sql = "select * from " . $this->table . " where username='$username'";
        $rt = $this->db->query($sql);
        $row = mysql_fetch_array($rt);
        if (!$row) {
            return 0;
        } else {
            return 1;
        }
    }

    /*     * ****************************************************************
      -- 函数名：getGrade($grade)
      -- 作  用：用户级别转换
      -- 参  数：$grade
      -- 返回值：String
      -- 实  例：无
     * ***************************************************************** */

    public function getGrade($grade) {
    	$groupObj = M("group");
    	$groupObj = $groupObj->load($grade);
        return $groupObj->name;
    }

    /*     * ****************************************************************
      -- 函数名：getStatus($status)
      -- 作  用：用户状态转换
      -- 参  数：$status
      -- 返回值：String
      -- 实  例：无
     * ***************************************************************** */

    public function getStatus($status) {
        switch ($status) {
            case 0 :
                $newStatus = '<font color="blue">'.Config::lang("PENDDING").'</font>';
                break;
            case 1 :
                $newStatus = Config::lang("NORMAL");
                break;
            case 2 :
                $newStatus = '<font color="#ff6600">'.Config::lang("LOCK").'</font>';
                break;
        }
        return $newStatus;
    }


    /*     * ****************************************************************
      -- 函数名：getStatus($status)
      -- 作  用：用户状态转换
      -- 参  数：$status
      -- 返回值：String
      -- 实  例：无
     * ***************************************************************** */

    public function getSex($sex) {
        switch ($sex) {
            case 0 :
                $newSex = '<font color="blue">'.Config::lang("GIRL").'</font>';
                break;
            case 1 :
                $newSex = Config::lang("BOY");
                break;
            case 2 :
                $newSex = '<font color="#ff6600">'.Config::lang("SECRECY").'</font>';
                break;
        }
        return $newSex;
    }

    public function isOnline($uid) {
    	$onlineObj = get('online',$uid);
    	$isExprie = (time() - $onlineObj->intime) > 3600;
    	if ($onlineObj->islogin == 1 && !$isExprie) {
    		return  true;
    	}
    	return false;
    }

    public function getOnlineList() {
    	$sql = 'SELECT u.id,u.username,u.grade,o.intime FROM tc_user AS u,tc_online AS o WHERE o.id=u.id AND o.islogin=1 AND (UNIX_TIMESTAMP() - o.intime) < 3600';
    	return $this->query($sql);
    }

	public function getRank($money) {
    	if ($money > 10000){
    		$rank = 10;
    	} else if ($money < 10000 && $money >= 9000) {
    		$rank = 9;
    	} else if ($money < 9000 && $money >= 8000) {
    		$rank = 8;
    	} else if ($money < 8000 && $money >= 7000) {
    		$rank = 7;
    	} else if ($money < 7000 && $money >= 6000) {
    		$rank = 6;
    	} else if ($money < 6000 && $money >= 5000) {
    		$rank = 5;
    	} else if ($money < 5000 && $money >= 4000) {
    		$rank = 4;
    	} else if ($money < 4000 && $money >= 3000) {
    		$rank = 3;
    	} else if ($money < 3000 && $money >= 2000) {
    		$rank = 2;
    	}  else {
    		$rank = 1;
    	}
        return $rank;
    }

    /*     * ***************************************************************
      -- 函数名：lockUserById($id)
      -- 作  用：锁定用户
      -- 参  数：$id
      -- 返回值：无
      -- 实  例：无
     * ***************************************************************** */

    public function lockUserById($id) {
        $sql = "update " . $this->table . " set status = 2 where id = " . $id;
        $this->db->query($sql);
    }

    public function openUserById($id) {
        $sql = "update " . $this->table . " set status = 1 where id = " . $id;
        $this->db->query($sql);
    }

    /*     * ***************************************************************
      -- 函数名：updateUserById($id)
      -- 作  用：更新用户密码加密
      -- 参  数：$id
      -- 返回值：无
      -- 实  例：无
     * ***************************************************************** */
	//16位转32位
    public function updateUserById($id, $pwd) {
        $sql = "update " . $this->table . " set password = '" . $pwd . "' where id = " . $id;
        $this->db->query($sql);
    }

    public function getName($uid) {
        $_Obj = get("user", $uid);
        return empty($_Obj->truename) ? " - " : $_Obj->truename;
    }
    
    public function getUserName($uid) {
    	$_Obj = get("user", $uid);
    	return $_Obj->username;
    }

    public function getPhoto($uid) {
        $_Obj = get("user", $uid);
        return $_Obj->photo_s;
    }
        
    public function getBigPhoto($uid) {
    	$_Obj = get("user", $uid);
    	return $_Obj->photo;
    }

    public function getCountAry($uid) {
        $rt = $this->db->query("select id from ".TABLEPRE."news where uid = ".$uid);
        $newsNum = $this->db->num_rows($rt);
        $rt = $this->db->query("select id from ".TABLEPRE."picture where uid = ".$uid);
        $pictureNum = $this->db->num_rows($rt);
        $rt = $this->db->query("select id from ".TABLEPRE."bbs_comment where uid = ".$uid);
        $bbsNum = $this->db->num_rows($rt);
        $ary = array("newsNum"=>$newsNum,"pictureNum"=>$pictureNum,"bbsNum"=>$bbsNum);
        return $ary;
    }

    public function setSortId() {
        if (empty($_GET['sortId'])) {
            $_GET['sortId'] =  'asc';
        }
        if ($_GET['sortId'] ==  'desc') {
            $_GET['sortId'] = 'asc';
        } else {
            $_GET['sortId'] = 'desc';
        }
    }

    public function getUserList($parames) {
        $newAry = array();
        $where = "1=1";
        $parames = str_replace(" ", "", $parames);
        $paramsAry = explode(",", $parames);
        $paramsArySize = count($paramsAry);
        for ($i = 0; $i < $paramsArySize; $i++) {
            $newParamsAry = explode("=", $paramsAry[$i]);
            $newAry[$newParamsAry[0]] = $newParamsAry[1];
        }
        if (array_key_exists("limit", $newAry) && $newAry["limit"] > 0) {
            $this->limit($newAry["limit"]);
        }
        if (array_key_exists("orderby", $newAry) && array_key_exists("orderway", $newAry)) {
            $this->orderby($newAry["orderby"] . " " . $newAry["orderway"]);
        }
        $list = $this->where($where)->find();
        return $list;
    }
    
    
      //防伪码
	   public function getcodenum(){
	        $_Obj = M("code");
	        $total = $_Obj->query("select count(1) as total from tc_code");
	        return $total[0]['total'];  
	   }
	   
      
    
	//最后注册终端的时间
	    public function getcodelast(){
	    	$Obj = M("code");
	    	$total = $Obj->query("select expired_time from tc_code order by id desc limit 1");
	    	return $total[0]['expired_time'];
	    }
    
    
     //统计代理商数量
	   public function getagentnum(){
	        $_Obj = M("agent");
	        
	        $total = $_Obj->query("select count(1) as total from tc_agent");
	        return $total[0]['total'];  
	   }
	   
      
    
	//最后注册时间
	    public function getagentlast(){
	    	$Obj = M("agent");
	    	$total = $Obj->query("select addtime from tc_agent order by addtime desc limit 1");
	    	return $total[0]['addtime'];
	    }
	    
    //统计防伪码查询数量
	   public function getcodechecknum(){
	        $_Obj = M("code_check");
	        $total = $_Obj->query("select count(1) as total from tc_code_check");
	        return $total[0]['total'];  
	   }
	   
    //最新添加防伪码查询时间
	   public function getcodechecklast(){
	        $_Obj = M("code_check");
	        $total = $_Obj->query("select addtime from tc_code_check order by addtime desc limit 1");
	        return $total[0]['addtime'];  
	   }
	   
    //统计代理商查询数量
	   public function getagentchecknum(){
	        $_Obj = M("agent_check");
	     
	        $total = $_Obj->query("select count(1) as total from tc_agent_check");
	        return $total[0]['total'];  
	   }
	   
    //最新添加代理商查询时间
	   public function getagentchecklast(){
	        $_Obj = M("agent_check");
	       
	        $total = $_Obj->query("select addtime from tc_agent_check order by addtime desc limit 1");
	        return $total[0]['addtime'];  
	   }


}


