<?php
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
//检测安装情况
if (! file_exists ( ROOT_PATH . "/" . APP_PATH . "/data/install.lock" )) {
	header ( 'Location: install' );exit;
}
//站点配置
require_once ROOT_PATH . "/" . APP_PATH . "/data/mysql.php";
$db = mysql::getInstance ();
$cachefile = ROOT_PATH . "/" . APP_PATH . "/data/config.php";
if (! file_exists ( $cachefile )) {
	$config = $db->GetRs ( "tc_config", "*", "where id=1" );
	$set = "<?php\ndefined('WODE_CMS') or exit('Access Denied');\n return " . var_export ( $config, true ) . ";\n";
	file_put_contents ( $cachefile, $set );
	@chmod ( $cachefile, 0777 );
}
$webConfig = include ROOT_PATH . "/" . APP_PATH . "/data/config.php";
// 定义模板目录
define('THEMES',$webConfig ["t_dir"]);
// 定义表前缀
define('TABLEPRE', "tc_");
/** smarty信息配置 */
$smarty_template_dir = APP_PATH . "/templates/" . THEMES . "/";;
$smarty_compile_dir = APP_PATH . '/data/runtime/';
$smarty_cache_dir = APP_PATH . '/data/cache/';
$smarty_caching = CACHE;
$smarty_delimiter = explode("|", "{|}");
if (!file_exists($smarty_compile_dir)) {
    FileUtil::createDir($smarty_compile_dir);
}
if (!file_exists($smarty_cache_dir)) {
    FileUtil::createDir($smarty_cache_dir);
}
/** 实例化smarty */
$tpl = Smarty::getInstance();
$tpl->template_dir = $smarty_template_dir;
$tpl->compile_dir = $smarty_compile_dir;
$tpl->cache_dir = $smarty_cache_dir;
$tpl->caching = $smarty_caching;
$tpl->left_delimiter = $smarty_delimiter[0];
$tpl->right_delimiter = $smarty_delimiter[1];
//
$webUrl = $webConfig ["website"];
foreach ( $webConfig as $key => $value ) {
	if ($key == 'website') {
		$tpl->assign ( "$key", $webUrl ); //For tags
	} else if (in_array ( $key, array ("css_dir", "js_dir", "images_dir", "upload_dir" ) )) {
		$tpl->assign ( "$key", $webUrl . "/" . $webConfig [$key] ); //For tags
	} else {
		$tpl->assign ( "$key", StringUtil::html_out ( $value ) ); //For tags
	}
}
$templatePath = APP_PATH . "/templates/" . $webConfig ['t_dir'] . "/";
if (Config::get("urlType") > 1) {
	$templatePath = Config::get("website"). "/" . Config::get('webpath') . "/" . APP_PATH . "/templates/" . $webConfig ['t_dir'] . "/";
}
if (defined('IN_ADMIN')){
	$templatePath = Config::get("website"). "/"  . Config::get('webpath') . "/" ."/app/templates/default/";
}
$tpl->assign ( "t_dir", $templatePath );
/** 模板目录标签重置 */
$lang = Config::get("lang") == 'auto' ? clientUtil::getLang() : Config::get("lang");
if (!empty($_SESSION["lang"])) {$lang = $_SESSION["lang"];}
$L = include ROOT_PATH . "/". APP_PATH . "/language/".$lang.".php";
//常用对象初始化
if (Config::get ( "showPower" )) {
	$tpl->assign ( "getRunTime", DateUtil::getRunTime () );
	$tpl->assign ( "getMemory", DateUtil::getRunM () );
}
if (! defined ( 'IN_ADMIN' ) && ! Config::get ( "open" )) {
	$tpl->assign ( "error", Config::lang ( "WEBSITEISCLOSE" ) );
	$tpl->display ( "error.html" );
	exit ();
}
if (empty ( $_SESSION ['userId'] )) {
	$userObj = M ( "user" );
} else {
	$userObj = get ( "user", intval ( $_SESSION ['userId'] ) );
}
$tpl->assign ( "userObj", $userObj );
$tpl->assign ( "charset", CHARSET );
$tpl->assign ( "referer", $_SERVER ['HTTP_REFERER'] );
if (Config::get("bot") == 1) {
	Log::logBot();
}
define('PRODUCT','1');//WODECMS产品序号
define('VERSION','1.0');//版本号
$modelObj = M ( "model" );
$tpl->assign ( "model", $modelObj );
$tpl->assign ( "version", VERSION );
