CREATE TABLE `chengyu_list` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(20) NOT NULL,
  `title` varchar(64) NOT NULL,
  `title_1` varchar(128) NOT NULL,
  `explain` mediumtext NOT NULL,
  `made` mediumtext NOT NULL,
  `examples` mediumtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1, '0:1:0', '春冰虎尾', '\n【 chūn　bīng　hǔ　wěi 】\n			', '\n踩着老虎尾巴，走在春天将解冻的冰上。比喻处境非常危险。\n			', '\n《尚书·君牙》：“心之忧危，若蹈虎尾，涉于春冰。”\n			', '\n延光等深言邪蒿～之戒，欲惊悟上意。（宋·孙光宪《北梦琐言》卷二十）\n			'),
(2, '0:1:0', '寸草春晖', '\n【 cùn　cǎo　chūn　huī 】\n			', '\n寸草：小草；春晖：春天的阳光。小草微薄的心意报答不了春日阳光的深情。比喻父母的恩情，难报万一。\n			', '\n唐·孟郊《游子吟》诗：“谁言寸草心，报得三春晖。”\n			', '\n暂无\n			'),
(3, '0:1:0', '春风和气', '\n【 chūn　fēng　hé　qì 】\n			', '\n春天和煦的春风吹拂着人们。比喻对人态度和蔼可亲。\n			', '\n明·无名氏《四马投唐》第二折：“既唐公不念前分仇，你放些个春风和气将他来待，免得咱一度可喜两度丑。”\n			', '\n暂无\n			'),
(4, '0:1:0', '春风雨露', '\n【 chūn　fēng　yǔ　lù 】\n			', '\n像春天的和风和雨滴露水那样滋润着万物的生长。旧常用以比喻恩泽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(5, '0:1:0', '春光漏泄', '\n【 chūn　guāng　lòu　xiè 】\n			', '\n原指柳枝泛绿，透露了春天将至的信息。比喻秘密或男女的私情被泄漏出来。\n			', '\n唐·杜甫《腊日》：“侵陵雪色还萱草，漏泄春光有柳条。”\n			', '\n呀，这～，怎地开交？（清·洪昇《长生殿·絮阁》）\n			'),
(6, '0:1:0', '春光明媚', '\n【 chūn　guāng　míng　mèi 】\n			', '\n明媚：美好，可爱。形容春天的景物鲜明可爱。\n			', '\n元·宋方壶《斗鹌鹑·踏青》套曲：“时遇着春光明媚，人贺丰年，民乐雍熙。”\n			', '\n行够多少山原，历尽无穷水道，不觉的秋去冬残，又值～。（明·吴承恩《西游记》第七十二回）\n			'),
(7, '0:1:0', '春晖寸草', '\n【 chūn　huī　cùn　cǎo 】\n			', '\n春晖：春天的阳光；比喻父母对儿女的慈爱抚养。寸草：一寸长的小草；比喻子女对父母的养育之恩的无限感戴心情。\n			', '\n唐·孟郊《游子吟》：“谁言寸草心，报得三春晖。”\n			', '\n暂无\n			'),
(8, '0:1:0', '春回大地', '\n【 chūn　huí　dà　dì 】\n			', '\n好象春天又回到大地。形容严寒已过，温暖和生机又来到人间。\n			', '\n宋·周紫芝《太仓稊米集·岁杪雨雪连日闷题二首》：“树头雪过梅犹在，地上春回柳未知。”\n			', '\n暂无\n			'),
(9, '0:1:0', '春华秋实', '\n【 chūn　huá　qiū　shí 】\n			', '\n华：花。春天开花，秋天结果。比喻人的文采和德行。现也比喻学习有成果。\n			', '\n《后汉书》第五十二卷：“春发其华，秋收其实，有始有极，爱登其质。”\n			', '\n～，没有那浩荡的春风，又哪里会有这满野秋色和大好的收成呢？（峻青《秋色赋》）\n			'),
(10, '0:1:0', '春花秋月', '\n【 chūn　huā　qiū　yuè 】\n			', '\n春天的花朵，秋天的月亮。泛指春秋美景。\n			', '\n南唐·李煜《虞美人》词：“春花秋月何时了，往事知多少。”\n			', '\n冬天去了，春天又回来了。吟诵这些诗句，～，一年四季都沉醉在诗的意境里。（于漪《我与〈千家诗〉》）\n			'),
(11, '0:1:0', '春兰秋菊', '\n【 chūn　lán　qiū　jú 】\n			', '\n春天的兰花，秋天的菊花。比喻各有值得称道的地方。\n			', '\n战国·楚·屈原《九歌·礼魂》：“春兰兮秋菊，长无绝兮终古。”\n			', '\n所恨芳林寥落甚，～不同时。（鲁迅《偶成》诗）\n			'),
(12, '0:1:0', '春暖花开', '\n【 chūn　nuǎn　huā　kāi 】\n			', '\n本指春天气候宜人，景物优美。现也比喻大好时机。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(13, '0:1:0', '春暖花香', '\n【 chūn　nuǎn　huā　xiāng 】\n			', '\n形容春天美丽的景色。\n			', '\n明·无名氏《打韩通》头折：“春暖花香，和风淡荡。我则见东郊上，男女成行，处处闲游赏。”\n			', '\n暂无\n			'),
(14, '0:1:0', '春去秋来', '\n【 chūn　qù　qiū　lái 】\n			', '\n春天过去，秋天到来。形容时光流逝。\n			', '\n明·刘基《大堤曲》：“春去秋来年复年，生歌死哭长相守。”\n			', '\n～，他觉得自己真的老了。\n			'),
(15, '0:1:0', '春色撩人', '\n【 chūn　sè　liáo　rén 】\n			', '\n撩：撩拔，挑逗、招惹。春天的景色引起人们的兴致。\n			', '\n宋·陆游《剑南诗稿·山园杂咏五首》：“桃花烂漫杏花稀，春色撩人不忍为。”\n			', '\n暂无\n			'),
(16, '0:1:0', '春色满园', '\n【 chūn　sè　mǎn　yuán 】\n			', '\n园内到处都是春天美丽的景色。比喻欣欣向荣的景象。\n			', '\n唐·吕从庆《丰溪存稿·小园》：“小园春色丽，花发两三株。”  宋·叶绍翁《游小园不值》：“应怜屐齿印苍苔，小扣柴扉久不开。春色满园关不住，一枝红杏出墙来。”\n			', '\n暂无\n			'),
(17, '0:1:0', '春笋怒发', '\n【 chūn　sǔn　mù　fā 】\n			', '\n春天的竹笋迅速茂盛地生长。比喻好事层出不穷地产生。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(18, '0:1:0', '春生秋杀', '\n【 chūn　shēng　qiū　shā 】\n			', '\n春天万物萌生，秋天万物凋零。\n			', '\n唐·白居易《贺杀贼表》：“伏惟文武孝德皇帝陛下：君临八表，子育群生，合天覆地载之德，顺春生秋杀之令。”\n			', '\n暂无\n			'),
(19, '0:1:0', '春山如笑', '\n【 chūn　shān　rú　xiào 】\n			', '\n形容春天的山色明媚。\n			', '\n宋·郭熙《林泉高致·山水训》：“春山澹冶而如笑，夏山苍翠而如滴，秋山明净而如妆，冬山惨淡而如睡。”\n			', '\n暂无\n			'),
(20, '0:1:0', '触手生春', '\n【 chù　shǒu　shēng　chūn 】\n			', '\n一动手就转成了春天，富有生机。形容技术高明神奇。\n			', '\n清·赵翼《瓯北诗话·李青莲诗》；“然以杜韩与之比较，一则用力而不免痕迹，一则不用力而触手生春：此仙与人之别也。”\n			', '\n暂无\n			'),
(21, '0:1:0', '春深似海', '\n【 chūn　shēn　sì　hǎi 】\n			', '\n春天美丽的景色像大海一样深广。形容到处充满了明媚的春光。\n			', '\n<span class="C999">暂无</span>\n			', '\n这屋里那块四乐堂的匾，可算挂定了！不然，这～的屋子，也就难免欲深似海。（清·文康《儿女英雄传》第三十回）\n			'),
(22, '0:1:0', '春生夏长，秋收冬藏', '\n【 chūn　shēng　xià　zhǎng,　qiū　shōu　dōng　 】\n			', '\n春天萌生，夏天滋长，秋天收获，冬天储藏。指农业生产的一般过程。亦比喻事物的发生、发展过程。\n			', '\n《史记·太史公自序》：“夫春生夏长，秋收冬藏，此天道之大经也。弗顺则无以为天下纲纪。”\n			', '\n暂无\n			'),
(23, '0:1:0', '春蛙秋蝉', '\n【 chūn　wā　qiū　chán 】\n			', '\n春天蛙叫，秋天蝉鸣。比喻喧闹夸张、空洞无物的言谈。\n			', '\n晋·杨泉《物理论》：“夫虚无之谈，尚其华藻，此无异于春蛙秋蝉，聒舌而已。”\n			', '\n暂无\n			'),
(24, '0:1:0', '春意盎然', '\n【 chūn　yì　àng　rán 】\n			', '\n春意：春天的气象。盎然：丰满、浓厚的样子。形容春天的气氛很浓。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(25, '0:1:0', '春意阑珊', '\n【 chūn　yì　lán　shān 】\n			', '\n阑珊：将尽，将衰。指春天就要过去了。\n			', '\n南唐·李煜《浪淘沙》：“帘外雨潺潺，春意阑珊。”\n			', '\n柳飞绵花瓢瓣，又一番～。(元·方伯成《端正好·忆别》)\n			'),
(26, '0:1:0', '和风细雨', '\n【 hé　fēng　xì　yǔ 】\n			', '\n和风：指春天的风。温和的风，细小的雨。比喻方式和缓，不粗暴。\n			', '\n南朝·陈·张正见《陪衡阳王游耆阇寺》：“清风吹麦垄，细雨濯梅林。”\n			', '\n暂无\n			'),
(27, '0:1:0', '花明柳暗', '\n【 huā　míng　liǔ　àn 】\n			', '\n垂柳浓密，鲜花夺目。形容柳树成荫，繁花似锦的春天景象。也比喻在困难中遇到转机。\n			', '\n唐·李商隐《夕阳楼》诗：“花明柳暗绕天愁，上尽重城更上楼。”\n			', '\n～绕天愁，赵女乘春上画楼。\n			'),
(28, '0:1:0', '花明柳媚', '\n【 huā　míng　liǔ　mèi 】\n			', '\n形容春天绿柳成荫、繁花似锦的景象。\n			', '\n《儒林外史》第一回：“遇着花明柳媚的时节，把一乘年车载了母亲，他便戴了高帽……在乡村镇上以及湖边，到处玩耍。”\n			', '\n待得～，看雕鞍骏马，又去踏春风。\n			'),
(29, '0:1:0', '红情绿意', '\n【 hóng　qíng　lǜ　yì 】\n			', '\n形容艳丽的春天景色。\n			', '\n宋·文同《约春》诗：“红情绿意知多少，尽入泾川万树花。”\n			', '\n暂无\n			'),
(30, '0:1:0', '虎尾春冰', '\n【 hǔ　wěi　chūn　bīng 】\n			', '\n踩着老虎尾巴，走在春天将解冻的冰上。比喻处境非常危险。\n			', '\n《尚书·君牙》：“心之忧危，若蹈虎尾，涉于春冰。”\n			', '\n暂无\n			'),
(31, '0:1:0', '花香鸟语', '\n【 huā　xiāng　niǎo　yǔ 】\n			', '\n鸟语：鸟鸣如同讲话一般。形容春天动人的景象。\n			', '\n清·李汝珍《镜花缘》第九十八回：“云雾渐淡，日色微明，四面也有人烟来往，各处花香鸟语，颇可盘桓。”\n			', '\n春天一到，公园里～，充满了生机。\n			'),
(32, '0:1:0', '枯木逢春', '\n【 kū　mù　féng　chūn 】\n			', '\n枯干的树遇到了春天，又恢复了活力。比喻垂危的病人或事物重新获得生机。\n			', '\n宋·释道原《景德传灯录》卷二十三：“唐州大乘山和尚问：‘枯树逢春时如何？’师曰：‘世间希有。’”\n			', '\n～，陈花重放，旧作再版，自然是值得高兴的。（峻青《写在百花重放的时候》）\n			'),
(33, '0:1:0', '柳暗花明', '\n【 liǔ　àn　huā　míng 】\n			', '\n垂柳浓密，鲜花夺目。形容柳树成荫，繁花似锦的春天景象。也比喻在困难中遇到转机。\n			', '\n唐·武元衡《摩河池送李侍御之凤翔》：“柳暗花明池上山，高楼歌洒换离颜。”宋·陆游《游山西村》诗：“山重水复疑无路，柳暗花明又一村。”\n			', '\n十二月十三日之晨，我心酸肠断，以为从此要尝些人生失望与悲哀的滋味，谁知眼前有这种～的美景。（冰心《寄小读者·通讯十一》）\n			'),
(34, '0:1:0', '李白桃红', '\n【 lǐ　bái　táo　hóng 】\n			', '\n桃花红，李花白。指春天美好宜人的景色。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(35, '0:1:0', '腊尽春回', '\n【 là　jìn　chūn　huí 】\n			', '\n腊：指腊月，即农历十二月。腊月过去，春天又来了。\n			', '\n唐·孙道绚《菩萨蛮·梅》：“阑干六曲天围碧，松风亭下梅初白。腊尽见春回，寒梢花又开。”\n			', '\n光阴似箭，不久又是～了。（清·吴趼人《痛史》第十八回）\n			'),
(36, '0:1:0', '柳绿花红', '\n【 liǔ　lǜ　huā　hóng 】\n			', '\n形容明媚的春天景象。也形容颜色鲜艳纷繁。\n			', '\n五代蜀·魏承班《生查子》词：“花红柳绿间晴空。”\n			', '\n秋至山寒水冷，春来～。（宋·释普济《五灯会元》卷八）\n			'),
(37, '0:1:0', '漏泄春光', '\n【 lòu　xiè　chūn　guāng 】\n			', '\n原指柳叶首先透露春天到来的信息，后比喻男女私情泄露，或秘密被察觉。\n			', '\n唐·杜甫《腊日》诗：“侵陵雪色还萱草，漏泄春光有柳条。”\n			', '\n暂无\n			'),
(38, '0:1:0', '漏洩春光', '\n【 lòu　xiè　chūn　guāng 】\n			', '\n①透露春天的信息。②指密传消息或泄露男女私情。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(39, '0:1:0', '满园春色', '\n【 mǎn　yuán　chūn　sè 】\n			', '\n整个园子里一片春天的景色。比喻欣欣向荣的景象。\n			', '\n宋·叶绍翁《游小园不值》诗：“春色满园关不住，一枝红杏出墙来。”\n			', '\n暂无\n			'),
(40, '0:1:0', '鸟语花香', '\n【 niǎo　yǔ　huā　xiāng 】\n			', '\n鸟叫得好听，花开得喷香。形容春天的美好景象。\n			', '\n清·李汝珍《镜花缘》第九十八回：“云雾渐淡，日色微明，四面也有人烟来往，各处花香鸟语，颇可盘桓。”\n			', '\n春天一到，公园里～，充满了生机。\n			'),
(41, '0:1:0', '秋月春花', '\n【 qiū　yuè　chūn　huā 】\n			', '\n春天的花朵，秋天的月亮。泛指春秋美景。\n			', '\n南唐·李煜《虞美人》词：“春花秋月何时了，往事知多少。”\n			', '\n～易老，赏心悦事难凭。（明·王世贞《鸣凤记》第一出）\n			'),
(42, '0:1:0', '双柑斗酒', '\n【 shuài　gān　dǒu　jiǔ 】\n			', '\n比喻春天游玩胜景。\n			', '\n唐·冯贽《云仙杂记》卷二引《高隐外书》：“戴颙春携双柑斗酒，人问何之，曰：‘往听黄鹂声。此俗耳针砭，诗肠鼓吹，汝知之乎？’”\n			', '\n明日重来应烂漫，～听黄鹂。（宋·刘泰《春日湖上》诗）\n			'),
(43, '0:1:0', '万古长春', '\n【 wàn　gǔ　cháng　chūn 】\n			', '\n万古：千年万代，永远。永远像春天一样，草木翠绿，生机勃勃。比喻人的精神永远像春天一样毫不衰退或祝愿好事长存。亦作“万古长青”、“万古常青”、“万古常新\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(44, '0:1:0', '寻花问柳', '\n【 xún　huā　wèn　liǔ 】\n			', '\n花、柳：原指春景，旧时亦指娼妓。原指赏玩春天的景色。后旧小说用来指宿娼。\n			', '\n唐·杜甫《严中丞枉驾见过》诗：“元戎小队出郊坰，问柳寻花到野处。”\n			', '\n只等的红雨散，绿云收，我那其间～，重到岳阳楼。（元·谷子敬《城南柳》楔子）\n			'),
(45, '0:1:0', '杏雨梨云', '\n【 xìng　yǔ　lí　yún 】\n			', '\n杏花如雨，梨花似云。形容春天景色美丽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(46, '0:1:0', '莺歌燕舞', '\n【 yīng　gē　yàn　wǔ 】\n			', '\n黄莺在歌唱，小燕子在飞舞。形容春天鸟儿喧闹活跃的景象。现常比喻革命和建设蓬勃兴旺的景象。\n			', '\n宋·苏轼《锦被亭》词：“烟红露绿晓风香，燕舞莺啼春日长。”\n			', '\n千里来寻故地，旧貌变新颜。到处～，更有潺潺流水，高路入云端。（毛泽东《水调歌头·重上井冈山》词）\n			'),
(47, '0:1:0', '莺歌燕语', '\n【 yīng　gē　yàn　yǔ 】\n			', '\n黄鹂歌唱，燕子呢喃。形容春天的美好景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(48, '0:1:0', '雨后春笋', '\n【 yǔ　hòu　chūn　sǔn 】\n			', '\n指春天下雨后，竹笋一下子就长出来很多。比喻事物迅速大量地涌现出来。\n			', '\n宋·张耒《食笋》诗：“荒林春雨足，新笋迸龙雏。”\n			', '\n国内废科举，兴学校，好象～，努力学习西方。（毛泽东《论人民民主专政》）\n			'),
(49, '0:1:0', '有脚阳春', '\n【 yǒu　jiǎo　yáng　chūn 】\n			', '\n承春：指春天。旧时称赞好官的话。\n			', '\n五代·王仁裕《开元天宝遗事·有脚阳春》：“宋璟爱民恤物，朝野归美，时人咸谓璟为有脚阳春，阳春言所至之处，如阳春煦物也。”\n			', '\n暂无\n			'),
(50, '0:1:0', '沂水春风', '\n【 yí　shuǐ　chūn　fēng 】\n			', '\n沂水：河水名，在山东省曲阜县境内，孔子出生地。春风：春天和暖的风，比喻良好的熏陶和教育。来自沂水的春风。比喻深受孔学的教育与熏陶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(51, '0:1:0', '雨丝风片', '\n【 yǔ　sī　fēng　piàn 】\n			', '\n形容春天的微风细雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(52, '0:1:0', '着手成春', '\n【 zhuó　shǒu　chéng　chūn 】\n			', '\n着手：动手。一着手就转成春天。原指诗歌要自然清新。后比喻医术高明，刚一动手病情就好转了。\n			', '\n唐·司空图《诗品·自然》：“俯拾即是，不取诸邻，俱道适往，着手成春。舅逢花开，如瞻岁新。”\n			', '\n暂无\n			'),
(53, '0:1:1', '蝉不知雪', '\n【 chán　bù　zhī　xuě 】\n			', '\n知了夏天生，秋天死，看不到雪。比喻人见闻不广。\n			', '\n汉·桓宽《盐伯论·相刺》：“以所不睹不信人，若蝉之不知雪坚。”\n			', '\n暂无\n			'),
(54, '0:1:1', '春生夏长，秋收冬藏', '\n【 chūn　shēng　xià　zhǎng,　qiū　shōu　dōng　 】\n			', '\n春天萌生，夏天滋长，秋天收获，冬天储藏。指农业生产的一般过程。亦比喻事物的发生、发展过程。\n			', '\n《史记·太史公自序》：“夫春生夏长，秋收冬藏，此天道之大经也。弗顺则无以为天下纲纪。”\n			', '\n暂无\n			'),
(55, '0:1:1', '冬日夏云', '\n【 dōng　rì　xià　yún 】\n			', '\n冬天的太阳，夏天的云层。比喻人态度温和可亲，使人愿意接近。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(56, '0:1:1', '冬温夏凊', '\n【 dōng　wēn　xià　jìng 】\n			', '\n凊：凉。冬天使父母温暖，夏天使父母凉爽。本指人子孝道。现亦泛称冬暖夏凉。\n			', '\n《礼记·曲礼上》：“凡为人子之礼，冬温而夏凊。”\n			', '\n一望琼花争怒放。飞越群山，人喜从天降。宫阙常年观白浪，～真佳况。（陈毅《蝶恋花·访问亚洲三国（一）》词）\n			'),
(57, '0:1:1', '冬温夏清', '\n【 dōng　wēn　xià　qīng 】\n			', '\n冬天使父母温暖，夏天使父母凉爽。指人子孝道。亦泛称冬暖夏凉。\n			', '\n北魏《张猛龙碑》：“冬温夏清，晓夕承奉。”\n			', '\n暂无\n			'),
(58, '0:1:1', '葛屦履霜', '\n【 gě　jù　lǚ　shuāng 】\n			', '\n冬天穿著夏天的鞋子。比喻过分节俭吝啬。\n			', '\n《诗经·魏风·葛屦》：“纠纠葛屦，可以履霜？”《幼学琼林·卷二·衣服类》：“葛屦履霜，诮俭啬之过甚。”\n			', '\n暂无\n			'),
(59, '0:1:1', '火伞高张', '\n【 huǒ　sǎn　gāo　zhāng 】\n			', '\n火伞：比喻夏天太阳酪烈；张：展开。形容夏天烈日当空，十分炎热。\n			', '\n唐·韩愈《游青龙寺赠崔太补阙》诗：“光华闪壁见神鬼，赫赫炎官张火伞。”\n			', '\n暂无\n			'),
(60, '0:1:1', '集萤映雪', '\n【 jí　yíng　yìng　xuě 】\n			', '\n集萤：晋代车胤少时家贫，夏天以练囊装萤火虫照明读书；映雪：晋代孙康冬天常映雪读书。形容家境贫穷，勤学苦读。\n			', '\n南朝·梁·任昉《为萧扬州荐士表》：“既笔耕为养，亦拥书成学，至乃集萤映雪，编蒲辑柳。”\n			', '\n暂无\n			'),
(61, '0:1:1', '暑来寒往', '\n【 shǔ　lái　hán　wǎng 】\n			', '\n夏天过去，冬天到来。泛指时光流逝。\n			', '\n南朝·梁·陆倕《石阙铭》：“暑来寒往，地久天长，神哉华观，永配无疆。”\n			', '\n乍见灵妃含笑往，复闻游女怨歌来。～运洄洑，潭生水落移陵谷。\n			'),
(62, '0:1:1', '无冬无夏', '\n【 wú　dōng　wú　xià 】\n			', '\n无论冬天还是夏天。指一年四季从不间断。\n			', '\n《诗经·陈风·宛丘》：“无冬无夏，值其鹭羽。”\n			', '\n爱情本来是无日无夜，～的，但萧涧秋好象没有爱情。（柔石《二月》五）\n			'),
(63, '0:1:1', '温凊定省', '\n【 wēn　qǐng　dìng　shěng 】\n			', '\n冬温夏凊、昏定晨省的省称。谓冬天温被，夏天扇席，晚上侍候睡定，早晨前往请安。表示侍奉父母无微不至。\n			', '\n语出《礼记·曲礼上》：“凡为人子之礼，冬温而夏凊，昏定而晨省。”\n			', '\n暂无\n			'),
(64, '0:1:1', '夏虫不可以语冰', '\n【 xià　chóng　bù　kě　yǐ　yǔ　bīng 】\n			', '\n不能和生长在夏天的虫谈论冰。比喻时间局限人的见识。也比喻人的见识短浅。\n			', '\n《庄子·秋水》：“夏虫不可以语于冰者，笃于时也。”\n			', '\n郎如此眼光浅，真是～。（明·凌濛初《二刻拍案惊奇》卷三十七）\n			'),
(65, '0:1:1', '夏炉冬扇', '\n【 xià　lú　dōng　shàn 】\n			', '\n夏天生火炉，冬天扇扇子。比喻做事不符合当时的需要，费了力气而得不到好处。\n			', '\n汉·王充《论衡·逢遇》：“今则不然，作无益之能，纳无补之说，以夏进炉，以冬奏扇，为所不欲得之事，献所不欲闻之语，其不遇祸，幸矣。”\n			', '\n暂无\n			'),
(66, '0:1:1', '夏日可畏', '\n【 xià　rì　kě　wèi 】\n			', '\n象夏天酷热的太阳那样使人可怕。比喻为人严厉，令人畏惧。\n			', '\n《左传·文公七年》：“鄷舒问于贾季曰：‘赵衰、赵盾孰贤？’对曰：‘赵衰，冬日之日也。赵盾，夏日之日也。’”杜预注：“冬日可爱，夏日可畏。”\n			', '\n暂无\n			'),
(67, '0:1:1', '夏雨雨人', '\n【 xià　yǔ　yǔ　rén 】\n			', '\n雨：前一个“雨”，名词，雨水；后一个“雨”，动词，下雨。有如夏天的雨落在人身上。比喻及时给人帮助和教育。\n			', '\n汉·刘向《说苑·贵德》：“吾不能春风风人，吾不能以夏雨雨人，吾穷必矣。”\n			', '\n暂无\n			'),
(68, '0:1:1', '燕雁代飞', '\n【 yàn　yàn　dài　fēi 】\n			', '\n燕夏天来温带，冬天归南方；雁冬天来温带，夏天归南方。比喻各自一方，不能相见。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(69, '0:1:2', '暗送秋波', '\n【 àn　sòng　qiū　bō 】\n			', '\n旧时比喻美女的眼睛象秋天明净的水波一样。指暗中眉目传情。\n			', '\n宋·苏轼《百步洪》诗之二：“佳人未肯回秋波，幼舆欲语防飞梭。”\n			', '\n对张（作霖）则～，对曹（锟）尤密切勾结。（蔡东藩、许廑父《民国通俗演义》第一二四回）\n			'),
(70, '0:1:2', '蝉不知雪', '\n【 chán　bù　zhī　xuě 】\n			', '\n知了夏天生，秋天死，看不到雪。比喻人见闻不广。\n			', '\n汉·桓宽《盐伯论·相刺》：“以所不睹不信人，若蝉之不知雪坚。”\n			', '\n暂无\n			'),
(71, '0:1:2', '橙黄桔绿', '\n【 chéng　huáng　jú　lǜ 】\n			', '\n橙子黄熟，桔子还绿。指秋天宜人的景色。\n			', '\n宋·苏轼《赠刘景文》诗：“一年好景君须记，最是橙黄桔绿时。”\n			', '\n到了～的时候，到处都是丰收的景象。\n			'),
(72, '0:1:2', '春华秋实', '\n【 chūn　huá　qiū　shí 】\n			', '\n华：花。春天开花，秋天结果。比喻人的文采和德行。现也比喻学习有成果。\n			', '\n《后汉书》第五十二卷：“春发其华，秋收其实，有始有极，爱登其质。”\n			', '\n～，没有那浩荡的春风，又哪里会有这满野秋色和大好的收成呢？（峻青《秋色赋》）\n			'),
(73, '0:1:2', '春花秋月', '\n【 chūn　huā　qiū　yuè 】\n			', '\n春天的花朵，秋天的月亮。泛指春秋美景。\n			', '\n南唐·李煜《虞美人》词：“春花秋月何时了，往事知多少。”\n			', '\n冬天去了，春天又回来了。吟诵这些诗句，～，一年四季都沉醉在诗的意境里。（于漪《我与〈千家诗〉》）\n			'),
(74, '0:1:2', '春兰秋菊', '\n【 chūn　lán　qiū　jú 】\n			', '\n春天的兰花，秋天的菊花。比喻各有值得称道的地方。\n			', '\n战国·楚·屈原《九歌·礼魂》：“春兰兮秋菊，长无绝兮终古。”\n			', '\n所恨芳林寥落甚，～不同时。（鲁迅《偶成》诗）\n			'),
(75, '0:1:2', '春去秋来', '\n【 chūn　qù　qiū　lái 】\n			', '\n春天过去，秋天到来。形容时光流逝。\n			', '\n明·刘基《大堤曲》：“春去秋来年复年，生歌死哭长相守。”\n			', '\n～，他觉得自己真的老了。\n			'),
(76, '0:1:2', '春生秋杀', '\n【 chūn　shēng　qiū　shā 】\n			', '\n春天万物萌生，秋天万物凋零。\n			', '\n唐·白居易《贺杀贼表》：“伏惟文武孝德皇帝陛下：君临八表，子育群生，合天覆地载之德，顺春生秋杀之令。”\n			', '\n暂无\n			'),
(77, '0:1:2', '春生夏长，秋收冬藏', '\n【 chūn　shēng　xià　zhǎng,　qiū　shōu　dōng　 】\n			', '\n春天萌生，夏天滋长，秋天收获，冬天储藏。指农业生产的一般过程。亦比喻事物的发生、发展过程。\n			', '\n《史记·太史公自序》：“夫春生夏长，秋收冬藏，此天道之大经也。弗顺则无以为天下纲纪。”\n			', '\n暂无\n			'),
(78, '0:1:2', '春蛙秋蝉', '\n【 chūn　wā　qiū　chán 】\n			', '\n春天蛙叫，秋天蝉鸣。比喻喧闹夸张、空洞无物的言谈。\n			', '\n晋·杨泉《物理论》：“夫虚无之谈，尚其华藻，此无异于春蛙秋蝉，聒舌而已。”\n			', '\n暂无\n			'),
(79, '0:1:2', '洞察秋毫', '\n【 dòng　chá　qiū　háo 】\n			', '\n洞察：看得很清楚；秋毫：鸟兽秋天身上新生的细毛，比喻极其细小的事物。形容人目光敏锐，任何细小的事物都能看得很清楚。\n			', '\n《孟子·梁惠王上》：“明足以察秋毫之末，而不见舆薪，则王许之乎？”\n			', '\n暂无\n			'),
(80, '0:1:2', '金风送爽', '\n【 jīn　fēng　sòng　shuǎng 】\n			', '\n金风：指秋天的风。古时以阴阳五行解释季节，秋为金。秋风带来了凉意。\n			', '\n<span class="C999">暂无</span>\n			', '\n～，凉露惊秋。（鲁迅《述香港恭祝圣诞》）\n			'),
(81, '0:1:2', '金风玉露', '\n【 jīn　fēng　yù　lù 】\n			', '\n泛指秋天的景物。\n			', '\n唐·李商隐《辛未七夕》诗：“由来碧浪银河畔，可要金风玉露时。”\n			', '\n暂无\n			'),
(82, '0:1:2', '临去秋波', '\n【 lín　qù　qiū　bō 】\n			', '\n秋波：秋天的水波，比喻眼睛明澈。临走时的回眸一盼。形容别情依依。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(83, '0:1:2', '落叶知秋', '\n【 luò　yè　zhī　qiū 】\n			', '\n指见到落地的黄叶，知道已经是秋天快到了。\n			', '\n宋·释普济《五灯会元》卷二十：“叶落知秋，举一明三。”《续灯传录》：“弦动别曲，叶落知秋。”\n			', '\n暂无\n			'),
(84, '0:1:2', '明察秋毫', '\n【 míng　chá　qiū　háo 】\n			', '\n明察：看清；秋毫：秋天鸟兽身上新长的细毛。原形容人目光敏锐，任何细小的事物都能看得很清楚。后多形容人能洞察事理。\n			', '\n《孟子·梁惠王上》：“明足以察秋毫之末，而不见舆薪，则王许之乎？”\n			', '\n余忆童稚时，能张目对日，～，见藐小微物，必细察其纹理。（清·沈复《浮生六记·闲情记趣》）\n			'),
(85, '0:1:2', '蒲柳之质', '\n【 pú　liǔ　zhī　zhì 】\n			', '\n蒲柳：水杨，秋天凋谢早。多用来比喻身体衰弱或未老先衰。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(86, '0:1:2', '秋风扫落叶', '\n【 qiū　fēng　sǎo　luò　yè 】\n			', '\n秋天的大风把落叶一扫而光。比喻强大的力量迅速而轻易地把腐朽衰败的事物扫除光。\n			', '\n《三国志·魏志·辛毗传》：“以明公之威，应困穷之敌，击疲弊之寇，无异迅风之振秋叶矣。”\n			', '\n对等敌人，要像～一样残酷无情。\n			'),
(87, '0:1:2', '秋毫不犯', '\n【 qiū　háo　bù　fàn 】\n			', '\n秋毫：鸟兽秋天新换的绒毛，比喻极细微的东西；犯：侵犯。指军纪严明，丝毫不侵犯人民的利益。\n			', '\n《史记·项羽本纪》：“吾入关，秋毫不敢有所近，籍吏民，封府库，而待将军。”《后汉书·岑彭传》：“持军整齐，秋毫无犯。”\n			', '\n～三吴悦，春日遥看五色光。\n			'),
(88, '0:1:2', '秋毫无犯', '\n【 qiū　háo　wú　fàn 】\n			', '\n秋毫：鸟兽秋天新换的绒毛，比喻极细微的东西；犯：侵犯。指军纪严明，丝毫不侵犯人民的利益。\n			', '\n《史记·项羽本纪》：“吾入关，秋毫不敢有所近，籍吏民，封府库，而待将军。”《后汉书·岑彭传》：“持军整齐，秋毫无犯。”\n			', '\n老夫一生公廉正直，与人～。（元·岳伯川《铁拐李》第二折）\n			'),
(89, '0:1:2', '秋毫之末', '\n【 qiū　háo　zhī　mò 】\n			', '\n鸟兽在秋天新长的细毛的尖端。比喻极微小的东西或极细微的地方。\n			', '\n《孟子·梁惠王上》：“明足以察秋毫之末，而不见舆薪。”\n			', '\n暂无\n			'),
(90, '0:1:2', '秋荼密网', '\n【 qiū　tú　mì　wǎng 】\n			', '\n荼：茅草上的白花。秋天繁茂的茅草白花，网眼细密的鱼网。比喻刑罚繁苛。\n			', '\n汉·桓宽《盐铁论·刑德》：“昔秦法每于秋荼，而网密于凝脂。”\n			', '\n暂无\n			'),
(91, '0:1:2', '秋月春花', '\n【 qiū　yuè　chūn　huā 】\n			', '\n春天的花朵，秋天的月亮。泛指春秋美景。\n			', '\n南唐·李煜《虞美人》词：“春花秋月何时了，往事知多少。”\n			', '\n～易老，赏心悦事难凭。（明·王世贞《鸣凤记》第一出）\n			'),
(92, '0:1:2', '望秋先零', '\n【 wàng　qiū　xiān　líng 】\n			', '\n零：凋零。望见秋天将到就先凋零了。比喻体质弱，经不起风霜。也比喻未老先衰。\n			', '\n南朝宋·刘义庆《世说新语·语言》：“松柏之姿，经霜犹茂。臣蒲柳之质，望秋先零，受命之异也。”\n			', '\n暂无\n			'),
(93, '0:1:2', '梧桐一叶落', '\n【 wú　tóng　yī　yè　luò 】\n			', '\n梧桐落叶最早，故以之表示秋天来临。后亦以比喻事物衰落的征兆。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(94, '0:1:2', '西风残照', '\n【 xī　fēng　cán　zhào 】\n			', '\n秋天的风，落日的光。比喻衰败没落的景象。多用来衬托国家的残破和心境的凄凉。”\n			', '\n唐·李白《忆秦娥》词：“乐游原上清秋节，咸阳古道音尘绝。音尘绝，西风残照，汉家陵阙。”\n			', '\n～旧山河，故国遗台忆独过。\n			'),
(95, '0:1:2', '西风落叶', '\n【 xī　fēng　luò　yè 】\n			', '\n形容秋天的景象。多比喻人或事物已趋衰落。\n			', '\n唐·贾岛《忆江上吴处士》：“秋风吹渭水，落叶满长安。”\n			', '\n蚂蚁缘槐夸大国，蚍蜉撼树谈何易。正～下长安，飞鸣镝。\n			'),
(96, '0:1:2', '叶落知秋', '\n【 yè　luò　zhī　qiū 】\n			', '\n看到树叶落，便知秋天到来。比喻从细微的变化可以推测事物的发展趋向。\n			', '\n宋·释普济《五灯会元》卷二十：“叶落知秋，举一明三。”《续灯传录》：“弦动别曲，叶落知秋。”\n			', '\n暂无\n			'),
(97, '0:1:2', '一叶落知天下秋', '\n【 yī　yè　luò　zhī　tiān　xià　qiū 】\n			', '\n从一片树叶的凋落，知道秋天的到来。比喻通过个别的细微的迹象，可以看到整个形势的发展趋向与结果。\n			', '\n《淮南子·说山训》：“见一叶落而知岁之将暮。”宋·唐庚《文录》引唐人诗：“山僧不解数甲子，一叶落知天下秋。”\n			', '\n暂无\n			'),
(98, '0:1:2', '盈盈秋水', '\n【 yíng　yíng　shuǐ　qiū 】\n			', '\n秋水：比喻美女的眼睛象秋天明净的水波一样。形容女子眼神饱含感情。\n			', '\n元·王实甫《西厢记》第三本第二折：“望穿他盈盈秋水，蹙损他淡淡春山。”\n			', '\n一般情况，几回断肠，只落得～泪汪汪。\n			'),
(99, '0:1:2', '一叶知秋', '\n【 yī　yè　zhī　qiū 】\n			', '\n从一片树叶的凋落，知道秋天的到来。比喻通过个别的细微的迹象，可以看到整个形势的发展趋向与结果。\n			', '\n《淮南子·说山训》：“见一叶落而知岁之将暮。”宋·唐庚《文录》引唐人诗：“山僧不解数甲子，一叶落知天下秋。”\n			', '\n暂无\n			'),
(100, '0:1:3', '春生夏长，秋收冬藏', '\n【 chūn　shēng　xià　zhǎng,　qiū　shōu　dōng　 】\n			', '\n春天萌生，夏天滋长，秋天收获，冬天储藏。指农业生产的一般过程。亦比喻事物的发生、发展过程。\n			', '\n《史记·太史公自序》：“夫春生夏长，秋收冬藏，此天道之大经也。弗顺则无以为天下纲纪。”\n			', '\n暂无\n			'),
(101, '0:1:3', '冬日可爱', '\n【 dōng　rì　kě　ài 】\n			', '\n如同冬天里的太阳那样使人感到温暖、亲切。比喻人态度温和慈爱，使人愿意接近。\n			', '\n《左传·文公七年》：“赵衰，冬日之日也；赵盾，夏日之日也。”杜预注“冬日可爱，夏日可畏。”\n			', '\n暂无\n			'),
(102, '0:1:3', '冬日夏云', '\n【 dōng　rì　xià　yún 】\n			', '\n冬天的太阳，夏天的云层。比喻人态度温和可亲，使人愿意接近。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(103, '0:1:3', '冬温夏凊', '\n【 dōng　wēn　xià　jìng 】\n			', '\n凊：凉。冬天使父母温暖，夏天使父母凉爽。本指人子孝道。现亦泛称冬暖夏凉。\n			', '\n《礼记·曲礼上》：“凡为人子之礼，冬温而夏凊。”\n			', '\n一望琼花争怒放。飞越群山，人喜从天降。宫阙常年观白浪，～真佳况。（陈毅《蝶恋花·访问亚洲三国（一）》词）\n			'),
(104, '0:1:3', '冬温夏清', '\n【 dōng　wēn　xià　qīng 】\n			', '\n冬天使父母温暖，夏天使父母凉爽。指人子孝道。亦泛称冬暖夏凉。\n			', '\n北魏《张猛龙碑》：“冬温夏清，晓夕承奉。”\n			', '\n暂无\n			'),
(105, '0:1:3', '葛屦履霜', '\n【 gě　jù　lǚ　shuāng 】\n			', '\n冬天穿著夏天的鞋子。比喻过分节俭吝啬。\n			', '\n《诗经·魏风·葛屦》：“纠纠葛屦，可以履霜？”《幼学琼林·卷二·衣服类》：“葛屦履霜，诮俭啬之过甚。”\n			', '\n暂无\n			'),
(106, '0:1:3', '黄绵袄子', '\n【 huáng　mián　ǎo　zǐ 】\n			', '\n比喻冬天的太阳。\n			', '\n宋·罗大经《鹤林玉露》卷一：“壬寅正月，雨雪连旬，忽尔开霁。闾里翁媪相呼贺曰：‘黄绵袄子出矣。’”\n			', '\n暂无\n			'),
(107, '0:1:3', '集萤映雪', '\n【 jí　yíng　yìng　xuě 】\n			', '\n集萤：晋代车胤少时家贫，夏天以练囊装萤火虫照明读书；映雪：晋代孙康冬天常映雪读书。形容家境贫穷，勤学苦读。\n			', '\n南朝·梁·任昉《为萧扬州荐士表》：“既笔耕为养，亦拥书成学，至乃集萤映雪，编蒲辑柳。”\n			', '\n暂无\n			'),
(108, '0:1:3', '山寒水冷', '\n【 shān　hán　shuǐ　lěng 】\n			', '\n冷冷清清。形容冬天的景象。\n			', '\n宋·释普济《五灯会元》卷八：“秋至山寒水冷，春来柳绿花红。”\n			', '\n暂无\n			'),
(109, '0:1:3', '暑来寒往', '\n【 shǔ　lái　hán　wǎng 】\n			', '\n夏天过去，冬天到来。泛指时光流逝。\n			', '\n南朝·梁·陆倕《石阙铭》：“暑来寒往，地久天长，神哉华观，永配无疆。”\n			', '\n乍见灵妃含笑往，复闻游女怨歌来。～运洄洑，潭生水落移陵谷。\n			'),
(110, '0:1:3', '天凝地闭', '\n【 tiān　níng　dì　bì 】\n			', '\n形容冬天非常寒冷的情景。\n			', '\n《晋书·张协传》：“天凝地闭，风厉霜飞。”\n			', '\n暂无\n			'),
(111, '0:1:3', '无冬无夏', '\n【 wú　dōng　wú　xià 】\n			', '\n无论冬天还是夏天。指一年四季从不间断。\n			', '\n《诗经·陈风·宛丘》：“无冬无夏，值其鹭羽。”\n			', '\n爱情本来是无日无夜，～的，但萧涧秋好象没有爱情。（柔石《二月》五）\n			'),
(112, '0:1:3', '温凊定省', '\n【 wēn　qǐng　dìng　shěng 】\n			', '\n冬温夏凊、昏定晨省的省称。谓冬天温被，夏天扇席，晚上侍候睡定，早晨前往请安。表示侍奉父母无微不至。\n			', '\n语出《礼记·曲礼上》：“凡为人子之礼，冬温而夏凊，昏定而晨省。”\n			', '\n暂无\n			'),
(113, '0:1:3', '夏虫朝菌', '\n【 xià　chóng　zhāo　jūn 】\n			', '\n意为夏虫活不到冬天，菌类朝生暮死。比喻极短的生命。\n			', '\n语出《庄子·秋水》：“夏虫不可以语于冰。”又《逍遥游》：“朝菌不知晦朔。”\n			', '\n谛而念之，亦无以笑彼～也。\n			'),
(114, '0:1:3', '夏炉冬扇', '\n【 xià　lú　dōng　shàn 】\n			', '\n夏天生火炉，冬天扇扇子。比喻做事不符合当时的需要，费了力气而得不到好处。\n			', '\n汉·王充《论衡·逢遇》：“今则不然，作无益之能，纳无补之说，以夏进炉，以冬奏扇，为所不欲得之事，献所不欲闻之语，其不遇祸，幸矣。”\n			', '\n暂无\n			'),
(115, '0:1:3', '雪兆丰年', '\n【 xuě　zhào　fēng　nián 】\n			', '\n指冬天大雪是来年丰收的预兆。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(116, '0:1:3', '燕雁代飞', '\n【 yàn　yàn　dài　fēi 】\n			', '\n燕夏天来温带，冬天归南方；雁冬天来温带，夏天归南方。比喻各自一方，不能相见。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(117, '0:1:4', '春诵夏弦', '\n【 chūn　sòng　xià　xián 】\n			', '\n诵、弦：古代学校里读诗，只口诵的叫“诵”，用乐器配合的叫“弦”。原指应根据季节采取不同的学习方式。后泛指读书、学习。\n			', '\n《礼记·文王世子》：“春诵夏弦，大师诏之。”\n			', '\n入于门墙，如造阙里。～，载飏淑声。（唐·刘禹锡《许州文宣王新庙碑》）\n			'),
(118, '0:1:4', '斗转星移', '\n【 dǒu　zhuǎn　xīng　yí 】\n			', '\n星斗变动位置。指季节或时间的变化。\n			', '\n元·马致远《陈抟高卧》第三折：“直睡的陵迁谷变，石烂松枯，斗转星移。”\n			', '\n暂无\n			'),
(119, '0:1:4', '逢时遇节', '\n【 féng　shí　yù　jié 】\n			', '\n时：季节；节：节气。遇到四季节令。指过年过节的时候。\n			', '\n<span class="C999">暂无</span>\n			', '\n方才老爹说的，他是个告命夫人，到家请会画的替他追个像，把凤冠补服画起来，～，供在家里。（清·吴敬梓《儒林外史》第二十回）\n			'),
(120, '0:1:4', '金风送爽', '\n【 jīn　fēng　sòng　shuǎng 】\n			', '\n金风：指秋天的风。古时以阴阳五行解释季节，秋为金。秋风带来了凉意。\n			', '\n<span class="C999">暂无</span>\n			', '\n～，凉露惊秋。（鲁迅《述香港恭祝圣诞》）\n			'),
(121, '0:1:4', '秋高马肥', '\n【 qiū　gāo　mǎ　féi 】\n			', '\n秋高气爽，马匹肥壮。古常以指西北外族活动的季节。\n			', '\n宋·李纲《靖康传信录》卷三：“臣恐秋高马肥，虏必再至，以责前约。”\n			', '\n其外市，则西至安集延、伊犁、哈密、喀尔喀，东至黑龙江，～，被罽捆货而至。\n			'),
(122, '0:1:4', '秋收冬藏', '\n【 qiū　shōu　dōng　cáng 】\n			', '\n秋天收获，冬天存储。泛指常规的农事活动。\n			', '\n《荀子·王制》：“春耕夏耘，秋收冬藏。”\n			', '\n这力田呵，春耕夏耨，～，无饥无忧，何为不乐。\n			'),
(123, '0:1:4', '十冬腊月', '\n【 shí　dōng　là　yuè 】\n			', '\n指阴历十月、十一、十二月天气寒冷的季节。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(124, '0:1:4', '社燕秋鸿', '\n【 shè　yàn　qiū　hóng 】\n			', '\n燕子和大雁都是候鸟，但在同一季节里飞的方向不同。比喻刚见面又离别。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(125, '0:1:4', '天行时气', '\n【 tiān　xíng　shí　qì 】\n			', '\n行：流行；时：季节，气候；气：疫气，疾病。因气候不正常而引起的流行病。\n			', '\n《千金方》：“凡冬月，忽有大热之时；夏月，忽有大凉之时，皆勿受之，有患天行时气者，皆由犯此也。”\n			', '\n又过半年，忽然刘二感～，头疼发热。（明·洪楩《清平山堂话本·合同文字记》）\n			'),
(126, '0:1:4', '田月桑时', '\n【 tián　yuè　sāng　shí 】\n			', '\n泛指农忙季节。\n			', '\n南朝齐·萧子良《谏射雉启》：“且田月向登，桑时告至。”\n			', '\n暂无\n			'),
(127, '0:1:4', '星移斗转', '\n【 xīng　yí　dǒu　zhuǎn 】\n			', '\n斗：北斗星。星斗变动位置。指季节或时间的变化。\n			', '\n元·马致远《陈抟高卧》第三折：“直睡的陵迁谷变，石烂松枯，斗转星移。”\n			', '\n抬头观看，～，正是三更时分。（明·冯梦龙《醒世恒言·吕洞宾飞剑斩黄龙》）\n			'),
(128, '0:2:0', '冰天雪窖', '\n【 bīng　tiān　xuě　jiào 】\n			', '\n形容极为寒冷。\n			', '\n清·陈康祺《郎潜纪闻》卷四：“公子编修汝舟随侍，劝以节劳暂息。公慨然曰：‘二万里冰天雪窖，只身荷戈，未尝言苦，时反惮劳乎？’”\n			', '\n暂无\n			'),
(129, '0:2:0', '冰雪严寒', '\n【 bīng　xuě　yán　hán 】\n			', '\n严寒：极度寒冷。冰天雪地，天气寒冷。\n			', '\n吴伯箫《菜园小记》“虽然按照时令季节，各种蔬菜种得有早有晚，有时收了这种菜才种那种菜；但是除了冰雪严寒的冬天，一年里春夏秋三季，菜园里总是经常有几种蔬菜在竞肥争绿的。”\n			', '\n暂无\n			'),
(130, '0:2:0', '春寒料峭', '\n【 chūn　hán　liào　qiào 】\n			', '\n料峭：微寒。形容初春的寒冷。\n			', '\n宋·释普济《五灯会元》卷十九：“春寒料峭，冻杀年少。”\n			', '\n那是一个阴冷的漆黑之夜。～，风雨凄凄。（何为《春夜的沉思和回忆》）\n			'),
(131, '0:2:0', '唇亡齿寒', '\n【 chún　wáng　chǐ　hán 】\n			', '\n嘴唇没有了，牙齿就会感到寒冷。比喻利益密切相关。\n			', '\n《左传·僖公五年》：“谚所谓‘辅车相依，唇亡齿寒’者，其虞、虢之谓也。”\n			', '\n这两家公司有着多种业务关系，正所谓是～。\n			'),
(132, '0:2:0', '滴水成冰', '\n【 dī　shuǐ　chéng　bīng 】\n			', '\n水滴下去就结成冰。形容天气十分寒冷。\n			', '\n宋·钱易《南部新书》：“严冬冱寒，滴水成冰。”\n			', '\n北方的冬天，十分寒冷，～。\n			'),
(133, '0:2:0', '风刀霜剑', '\n【 fēng　dāo　shuāng　jiàn 】\n			', '\n寒风象刀，严霜象剑。形容气候寒冷，刺人肌肤。也比喻恶劣的环境。\n			', '\n清·曹雪芹《红楼梦》第十七回中林黛玉的《葬花辞》：“一年三百六十日，风刀霜剑严相逼。”\n			', '\n暂无\n			'),
(134, '0:2:0', '风雨凄凄', '\n【 fēng　yǔ　qī　qī 】\n			', '\n凄凄：寒冷。风雨交加，清冷凄凉。\n			', '\n《诗经·郑风·风雨》：“风雨凄凄，鸡鸣喈喈。”\n			', '\n歌台暧响，春光融融。舞殿冷袖，～。（唐·杜牧《阿房宫赋》）\n			'),
(135, '0:2:0', '寒冬腊月', '\n【 hán　dōng　là　yuè 】\n			', '\n腊月：农历十二月。指冬季最寒冷的腊月天。\n			', '\n汉·无名氏《别诗（骨肉缘枝叶）》：“征夫怀远路，游子恋故乡。寒冬十二月，晨起践严霜。”\n			', '\n～大雪纷飞，漫山遍野一片白色。\n			'),
(136, '0:2:0', '寒风侵肌', '\n【 hán　fēng　qīn　jī 】\n			', '\n形容天气寒冷。\n			', '\n<span class="C999">暂无</span>\n			', '\n冷锋过境，～，人们尽量不出门，致使娱乐场所生意清淡。\n			'),
(137, '0:2:0', '号寒啼饥', '\n【 háo　hán　tí　jī 】\n			', '\n因为饥饿寒冷而哭叫。形容挨饿受冻的悲惨生活。\n			', '\n唐·韩愈《进学解》：“冬暖而儿号哭寒，年丰而凄啼饥。\n			', '\n暂无\n			'),
(138, '0:2:0', '饥冻交切', '\n【 jī　dòng　jiāo　qiē 】\n			', '\n饥饿与寒冷一齐逼来。形容无衣无食，生活极其贫困。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(139, '0:2:0', '饥寒交切', '\n【 jī　hán　jiāo　qiē 】\n			', '\n饥饿与寒冷一齐逼来。形容无衣无食，生活极其贫困。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(140, '0:2:0', '林寒洞肃', '\n【 lín　hán　dòng　sù 】\n			', '\n寒：寒冷；肃：肃杀。形容秋冬时林木萧疏，溪涧浅落的景象。\n			', '\n北朝后魏·郦道元《水经注·江水》：“每晴初霜旦，林寒涧肃，常有高猿长啸，属引凄异。”\n			', '\n暂无\n			'),
(141, '0:2:0', '料峭春寒', '\n【 liào　qiào　chūn　hán 】\n			', '\n料峭：微寒。形容初春的寒冷。\n			', '\n宋·释普济《五灯会元》卷十九：“春寒料峭，冻杀年少。”\n			', '\n～中酒，交加晓梦啼莺。（宋·吴文英《风入松》词）\n			'),
(142, '0:2:0', '凄风苦雨', '\n【 qī　fēng　kǔ　yǔ 】\n			', '\n凄风：寒冷的风；苦雨：久下成灾的雨。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n暂无\n			'),
(143, '0:2:0', '欺霜傲雪', '\n【 qī　shuāng　ào　xuě 】\n			', '\n形容不畏霜雪严寒，外界条件越艰苦越有精神。比喻经过长期磨练，面对冷酷迫害或打击毫不示弱、无所畏惧。傲，傲慢、蔑视。\n			', '\n宋·杨无咎《柳梢青》：“傲雪凌霜，平欺寒力，搀借春光。”\n			', '\n俺端的～志清高，看岩前斗巧，不比蓬蒿。\n			'),
(144, '0:2:0', '十冬腊月', '\n【 shí　dōng　là　yuè 】\n			', '\n指阴历十月、十一、十二月天气寒冷的季节。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(145, '0:2:0', '岁暮天寒', '\n【 suì　mù　tiān　hán 】\n			', '\n指年底时候的寒冷景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(146, '0:2:0', '缩手缩脚', '\n【 suō　shǒu　suō　jiǎo 】\n			', '\n由于寒冷而四肢不能舒展的样子。也形容做事胆小，顾虑多，不敢放手。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(147, '0:2:0', '天寒地冻', '\n【 tiān　hán　dì　dòng 】\n			', '\n形容天气极为寒冷。\n			', '\n明·施耐庵《水浒全传》第六十五回：“目今天寒地冻，军马难以久住，权且回山。”\n			', '\n暂无\n			'),
(148, '0:2:0', '啼饥号寒', '\n【 tí　jī　háo　hán 】\n			', '\n啼：哭；号：叫。因为饥饿寒冷而哭叫。形容挨饿受冻的悲惨生活。\n			', '\n唐·韩愈《进学解》：“冬暖而儿号寒，年丰而妻啼饥。”\n			', '\n值岁凶，～。（清·王晫《今世说·贤媛》）\n			'),
(149, '0:2:0', '天凝地闭', '\n【 tiān　níng　dì　bì 】\n			', '\n形容冬天非常寒冷的情景。\n			', '\n《晋书·张协传》：“天凝地闭，风厉霜飞。”\n			', '\n暂无\n			'),
(150, '0:2:0', '嘘寒问暖', '\n【 xū　hán　wèn　nuǎn 】\n			', '\n嘘寒：呵出热气使寒冷的人感到温暖；问暖：指问寒问暖。形容对人的生活十分关切。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(151, '0:2:0', '雪窖冰天', '\n【 xuě　jiào　bīng　tiān 】\n			', '\n窖：收藏东西的地洞。到处是冰和雪。形容天气寒冷，也指严寒地区。\n			', '\n《宋史·朱弁传》：“叹马角之未生，魂销雪窖；攀龙髯而莫逮，泪洒冰天。”\n			', '\n今日荷戈边塞去，可堪雪窖复冰天。（清·黄遵宪《归过日本志感》诗）\n			'),
(152, '0:2:0', '雪虐风饕', '\n【 xuě　nüè　fēng　tāo 】\n			', '\n虐：暴虐；饕：贪残。又是刮风，又是下雪。形容天气非常寒冷。\n			', '\n唐·韩愈《祭河南张员外文》：“岁弊寒凶，雪虐风饕。”\n			', '\n幽香淡淡影疏疏，～亦自如。（宋·陆游《雪中寻梅》诗）\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(153, '0:2:0', '折胶堕指', '\n【 zhé　jiāo　duò　zhǐ 】\n			', '\n极言天气寒冷。\n			', '\n宋·苏轼《磨衲赞》：“折胶堕指，此衲不寒，烁石流金，此衲不热。”宋·周密《齐东野语·曝日》：“《冬日初出铭》曰：‘折胶堕指，梦想负背。’”\n			', '\n暂无\n			'),
(154, '0:2:1', '春回大地', '\n【 chūn　huí　dà　dì 】\n			', '\n好象春天又回到大地。形容严寒已过，温暖和生机又来到人间。\n			', '\n宋·周紫芝《太仓稊米集·岁杪雨雪连日闷题二首》：“树头雪过梅犹在，地上春回柳未知。”\n			', '\n暂无\n			'),
(155, '0:2:1', '冬日可爱', '\n【 dōng　rì　kě　ài 】\n			', '\n如同冬天里的太阳那样使人感到温暖、亲切。比喻人态度温和慈爱，使人愿意接近。\n			', '\n《左传·文公七年》：“赵衰，冬日之日也；赵盾，夏日之日也。”杜预注“冬日可爱，夏日可畏。”\n			', '\n暂无\n			'),
(156, '0:2:1', '冬温夏凊', '\n【 dōng　wēn　xià　jìng 】\n			', '\n凊：凉。冬天使父母温暖，夏天使父母凉爽。本指人子孝道。现亦泛称冬暖夏凉。\n			', '\n《礼记·曲礼上》：“凡为人子之礼，冬温而夏凊。”\n			', '\n一望琼花争怒放。飞越群山，人喜从天降。宫阙常年观白浪，～真佳况。（陈毅《蝶恋花·访问亚洲三国（一）》词）\n			'),
(157, '0:2:1', '冬温夏清', '\n【 dōng　wēn　xià　qīng 】\n			', '\n冬天使父母温暖，夏天使父母凉爽。指人子孝道。亦泛称冬暖夏凉。\n			', '\n北魏《张猛龙碑》：“冬温夏清，晓夕承奉。”\n			', '\n暂无\n			'),
(158, '0:2:1', '风和日暄', '\n【 fēng　hé　rì　xuān 】\n			', '\n微风和畅，阳光温暖。见“风和日暖”。\n			', '\n明·汪廷讷《狮吼记·赏春》：“风和日暄，燕交飞触碎胭脂片。”\n			', '\n暂无\n			'),
(159, '0:2:1', '惠风和畅', '\n【 huì　fēng　hé　chàng 】\n			', '\n惠：柔和；和：温和；畅：舒畅。柔和的风，使人感到温暖、舒适。\n			', '\n晋·王羲之《兰亭集序》：“是日也，天朗气清，惠风和畅。”\n			', '\n暂无\n			'),
(160, '0:2:1', '和风丽日', '\n【 hé　fēng　lì　rì 】\n			', '\n指天气温暖而晴朗。\n			', '\n宋·柳永《西平乐》词：“正是和风丽日，几许繁红嫩绿，雅称嬉游去。”\n			', '\n那时节～满东园。\n			'),
(161, '0:2:1', '嘘寒问暖', '\n【 xū　hán　wèn　nuǎn 】\n			', '\n嘘寒：呵出热气使寒冷的人感到温暖；问暖：指问寒问暖。形容对人的生活十分关切。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(162, '0:2:2', '东冲西决', '\n【 dōng　chōng　xī　jué 】\n			', '\n形容洪水四处冲决泛滥。\n			', '\n清·江藩《汉学师承记·胡渭》：“近日治河，乃遏之使不得北，而南入于淮，以便运耳。南行非河之本性，东冲西决，率无宁岁。”\n			', '\n暂无\n			'),
(163, '0:2:2', '洪水横流', '\n【 hóng　shuǐ　héng　liú 】\n			', '\n横流：不循河道而流。洪水泛滥。比喻邪道横行。\n			', '\n《孟子·滕文公上》：“当尧之时，天下犹未平，洪水横流，氾滥于天下。\n			', '\n臣闻～，帝思俾乂；旁求四方，以招贤俊。（明·罗贯中《三国演义》第二十三回）\n			'),
(164, '0:2:2', '怀山襄陵', '\n【 huái　shān　xiāng　líng 】\n			', '\n指洪水汹涌奔腾溢上山陵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(165, '0:2:2', '水落归槽', '\n【 shuǐ　luò　guī　cáo 】\n			', '\n四溢的洪水流入了河槽。比喻一心惦记着的事有了着落。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(166, '0:2:2', '汹涌澎湃', '\n【 xiōng　yǒng　péng　pài 】\n			', '\n汹涌：洪水猛烈上涌的样子；澎湃：波浪互相撞击。形容声势浩大，不可阻挡。\n			', '\n汉·司马相如《上林赋》：“沸乎暴怒，汹涌澎湃。”\n			', '\n两洋的潮水交织一起，形成一派～的大浪，这就是横扫亚非两洲的反殖民主义的浪潮。（杨朔《两洋潮水》）\n			'),
(167, '0:2:2', '以邻为壑', '\n【 yǐ　lín　wéi　hè 】\n			', '\n拿邻国当做大水坑，把本国的洪水排泄到那里去。比喻只图自己一方的利益，把困难或祸害转嫁给别人。\n			', '\n《孟子·告子下》：“是故禹以四海为壑。今吾子以邻国为壑。”\n			', '\n有些自私自利的人，做事从来不为别人着想，甚至～。\n			'),
(168, '0:2:3', '狂风暴雨', '\n【 kuáng　fēng　bào　yǔ 】\n			', '\n指大风大雨。亦比喻猛烈的声势或处境险恶。\n			', '\n元·杨显之《潇湘雨》第四折：“我沉吟罢仔细听来。原来是唤醒人狂风暴雨。”\n			', '\n却遇了一阵～。（清·吴趼人《二十年目睹之怪现状》）\n			'),
(169, '0:2:3', '狂风骤雨', '\n【 kuáng　fēng　zhòu　yǔ 】\n			', '\n原形容大风大雨。后也比喻处境险恶或声势猛烈。\n			', '\n《老子》第二十三章：“故飘风不终朝，骤雨不终日。”\n			', '\n我沉吟罢仔细听来，原来是唤醒人～。（元·杨显之《潇湘雨》第四折）\n			'),
(170, '0:2:3', '瓢泼大雨', '\n【 piáo　pō　dà　yǔ 】\n			', '\n像用瓢泼水那样的大雨。形容雨下得非常大的样子。\n			', '\n周立波《暴风骤雨》第一部十二：“西北悬天起了乌黑的云朵，不大一会，瓢泼大雨到来了，夹着炸雷和闪电，因为三天两头地下雨，道上黑泥总是不干的，出门的人们都是光着脚丫子，顺着道沿走。”\n			', '\n暂无\n			'),
(171, '0:2:3', '滂沱大雨', '\n【 páng　tuó　dà　yǔ 】\n			', '\n滂沱：大雨的样子。形容雨下得很大。\n			', '\n《诗·小雅·渐渐之石》：“月离于毕，俾滂沱矣。”\n			', '\n只见～，一似瓢泼盆倾，下有半个时辰。（明·许仲琳《封神演义》第十回）\n			'),
(172, '0:2:3', '蚁封穴雨', '\n【 yǐ　fēng　xué　yǔ 】\n			', '\n蚂蚁聚土洞口，是要下大雨的征兆。\n			', '\n汉·焦延寿《易林》卷十三：“蚁封户穴，大雨将集。”\n			', '\n暂无\n			'),
(173, '0:2:4', '报冰公事', '\n【 bào　bīng　gōng　shì 】\n			', '\n旧时官场指清苦的差使。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(174, '0:2:4', '抱冰公事', '\n【 bào　bīng　gōng　shì 】\n			', '\n公事：公务。指旧时官场中清苦的差使。\n			', '\n宋·陶穀《清异录·官志》：“当其役者曰：‘又管抱冰公事也。’”\n			', '\n暂无\n			'),
(175, '0:2:4', '冰冻三尺，非一日之寒', '\n【 bīng　dòng　sān　chǐ，fēi　yī　rì　zhī　h 】\n			', '\n比喻一种情况的形成，是经过长时间的积累、酝酿的。\n			', '\n<span class="C999">暂无</span>\n			', '\n～，大局坏到如此，也不是一个人，两个人的错。（高阳《胭脂井》）\n			'),
(176, '0:2:4', '冰壶秋月', '\n【 bīng　hú　qiū　yuè 】\n			', '\n冰壶：盛水的玉壶，比喻洁白。比喻洁白明净。多指人的品格。\n			', '\n宋·苏轼《赠潘谷》诗：“布衫漆黑手如龟，未害冰壶贮秋月。”\n			', '\n愿中如～，莹彻无瑕，非吾曹所及。（《宋史·李侗传》）\n			'),
(177, '0:2:4', '冰魂素魄', '\n【 bīng　hún　sù　pò 】\n			', '\n形容清白纯洁的品质。\n			', '\n元·吴昌龄《张天师》第四折：“俺本是广寒宫冰魂素魄，怎比那阎浮世浊骨凡胎。”\n			', '\n暂无\n			'),
(178, '0:2:4', '冰魂雪魄', '\n【 bīng　hún　xuě　pò 】\n			', '\n冰、雪：如冰的透明，雪的洁白。比喻人品质高尚纯洁。\n			', '\n五代·王定保《唐摭言》卷十：“忍苦为诗身到此，冰魂雪魄已难招。”宋·陆游《北坡梅》诗：“广寒宫里长生药，医得冰魂雪魄回。”\n			', '\n暂无\n			'),
(179, '0:2:4', '冰寒于水', '\n【 bīng　hán　yú　shuǐ 】\n			', '\n冰比水冷。比喻学生胜过老师。\n			', '\n荀子《劝学》：“冰，水为之，而寒于水。”唐·张彦远《历代名画记·七·南齐》：“蘧（道愍）始师章（继伯），冰寒于水。”\n			', '\n暂无\n			'),
(180, '0:2:4', '冰解的破', '\n【 bīng　jiě　dì　pò 】\n			', '\n冰冻融解，箭靶射中。比喻问题解决，障碍消除。\n			', '\n清·曾国藩《\n			', '\n暂无\n			'),
(181, '0:2:4', '冰解冻释', '\n【 bīng　jiě　dòng　shì 】\n			', '\n如同冰冻融化一般。比喻困难或障碍消除。\n			', '\n《庄子·庚桑楚》：“是乃所谓冰释冻释者能乎？”\n			', '\n复取程氏书虚心平气而读之，未乃数行，～。（《朱子全书·中庸》）\n			'),
(182, '0:2:4', '冰解壤分', '\n【 bīng　jiě　rǎng　fēn 】\n			', '\n冰冻消融，土壤分解。比喻障碍消除。\n			', '\n章炳麟《正名杂义》：“高邮王氏，以其绝学释姬汉古书，冰解壤分，无所凝滞，信哉千五百年未有其人也。”\n			', '\n暂无\n			'),
(183, '0:2:4', '冰肌雪肠', '\n【 bīng　jī　xuě　cháng 】\n			', '\n比喻身心洁白，没有污点。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(184, '0:2:4', '冰肌玉骨', '\n【 bīng　jī　yù　gǔ 】\n			', '\n冰：晶莹。肌骨如同冰玉一般。形容女子肌肤莹洁光滑。\n			', '\n宋·苏轼《洞仙歌》词：“冰肌玉骨，自清凉无汗。”\n			', '\n换却～胎，丹心吐出异香来。（元·张寿卿《红梨花》第二折）\n			'),
(185, '0:2:4', '冰洁玉清', '\n【 bīng　jié　yù　qīng 】\n			', '\n比喻德行高洁。\n			', '\n《初学记》卷宗十七引《吴先贤传·故扬州别驾从事戴矫传赞》：“猗猗茂才，执节云停，志励秋霜，冰洁玉清。”\n			', '\n暂无\n			'),
(186, '0:2:4', '冰洁渊清', '\n【 bīng　jié　yuān　qīng 】\n			', '\n犹冰清玉洁。\n			', '\n汉·孔融《卫尉张俭碑》：“君禀乾纲之正性，蹈高世之殊轨，冰洁渊清，介然特立。”\n			', '\n太中大夫管宁，应二仪之中和，总九德之纯懿，含章素质，～。\n			'),
(187, '0:2:4', '冰解云散', '\n【 bīng　jiě　yún　sàn 】\n			', '\n比喻事物消失瓦解。\n			', '\n宋·叶適《纪纲三》：“虽分四总管以固捍御，委长安、建康之守以募勤王，天下冰解云散，一城之地，劫制于虏，而号令不能及矣。”\n			', '\n暂无\n			'),
(188, '0:2:4', '冰壸秋月', '\n【 bīng　kǔn　qiū　yuè 】\n			', '\n比喻人品德清白廉洁。\n			', '\n宋·苏轼《赠潘谷》诗：“布衫漆黑手如龟，未害冰壶贮秋月。”\n			', '\n愿中如～，莹彻无瑕，非吾曹所及。\n			'),
(189, '0:2:4', '冰清水冷', '\n【 bīng　qīng　shuǐ　lěng 】\n			', '\n指冷冷清清。\n			', '\n《何典》第四回：“初时还有些和尚道士，有家中闹弗清楚，到也不甚觉着。及至断了七，出过棺材，诸事停当，弄得家里冰清水冷。”\n			', '\n暂无\n			'),
(190, '0:2:4', '冰清玉粹', '\n【 bīng　qīng　yù　cuì 】\n			', '\n比喻德行高洁。\n			', '\n《初学记》卷十七引晋孙绰《原宪赞》：“原宪玄默，冰清玉粹。志逸九霄，身安陋术。”\n			', '\n暂无\n			'),
(191, '0:2:4', '冰清玉洁', '\n【 bīng　qīng　yù　jié 】\n			', '\n象冰那样清澈透明，象玉那样洁白无瑕。比喻人的操行清白（多用于女子）。\n			', '\n汉·司马迁《与挚伯陵书》：“伏唯伯陵材能绝人，高尚其志，以善厥身，冰清玉洁，不以细行。”\n			', '\n他～，从不随波逐流。\n			'),
(192, '0:2:4', '冰清玉润', '\n【 bīng　qīng　yù　rùn 】\n			', '\n象冰一样晶莹，如玉一般润泽。原指晋乐广卫玠翁婿俩操行洁白。后常比喻人的品格高洁。\n			', '\n南朝宋·刘义庆《世说新语·言语》刘孝标注引《卫玠别传》：“裴叔道曰：“妻父有冰清之姿，婿有璧润之望。”\n			', '\n他是～，怎便肯随波逐尘。（明·高濂《玉簪记》第三十出）\n			'),
(193, '0:2:4', '冰山难靠', '\n【 bīng　shān　nán　kào 】\n			', '\n比喻不能长久的权势，难于依靠。\n			', '\n《资治通鉴·唐纪玄宗天宝十一年》：“或劝陕郡进士张彖谒国忠，曰：‘见之，富贵立可图。’彖曰：‘君辈倚杨右相如泰山，吾以为冰山耳！若皎日既出，君辈得无失所恃乎？’”\n			', '\n暂无\n			'),
(194, '0:2:4', '冰散瓦解', '\n【 bīng　sàn　wǎ　jiě 】\n			', '\n比喻完全消失或彻底崩溃。\n			', '\n《三国志魏志傅嘏传》“嘏对曰”裴松之注引晋司马彪《战略》：“比及三年，左提右挈，虏必冰散瓦解，安受其弊，可坐算而得也。”\n			', '\n暂无\n			'),
(195, '0:2:4', '冰山易倒', '\n【 bīng　shān　yì　dǎo 】\n			', '\n冰山遇到太阳就消溶，容易倒塌。比喻不能长久依赖的靠山。\n			', '\n《蝴蝶媒》第十三回：“那越公虽待我不薄，奈他年寿无多，冰山易倒，未可久留。”\n			', '\n人们纷纷投靠宰相杨国忠，张彖却认为～，决不依附权贵。\n			'),
(196, '0:2:4', '冰炭不言，冷热自明', '\n【 bīng　tàn　bù　yán,　lěng　rè　zì　míng 】\n			', '\n比喻内心的诚意不用表白，必然表现在行动上。\n			', '\n《晋书·王沈传》：“尧、舜、周公所以能致忠谏者，以其款诚之心者也，冰炭不言，而冷热之质自明者，以其有实也。”\n			', '\n暂无\n			'),
(197, '0:2:4', '冰炭不同器', '\n【 bīng　tàn　bù　tóng　qì 】\n			', '\n冰和炭火不能放在同一个器具里。比喻性质不同的事物彼此排斥，不能相容。\n			', '\n《韩非子·显学》：“夫冰炭不同器而久，寒暑不兼时而至。杂反之学不两立而治。”\n			', '\n岂不闻～，也似咱愚不并居。（《元曲选·渔樵记》一折）\n			'),
(198, '0:2:4', '冰炭不投', '\n【 bīng　tàn　bù　tóu 】\n			', '\n比喻彼此合不来。\n			', '\n《韩非子·显学》：“夫冰炭不同器而久，寒暑不兼时而至。杂反之学不两立而治。”\n			', '\n今日见面，原想得一知己，岂知谈了半天，竟有些～。（清·曹雪芹《红楼梦》第一一五回）\n			'),
(199, '0:2:4', '冰炭不同炉', '\n【 bīng　tàn　bù　tóng　lú 】\n			', '\n比喻两种对立的事物不能同处。\n			', '\n元·关汉卿《鲁斋郎》第三折：“休把我衣服扯住，情知咱冰炭不同炉。”\n			', '\n你深思虑，因何难共处？岂不闻～。\n			'),
(200, '0:2:4', '冰炭不相容', '\n【 bīng　tàn　bù　xiāng　róng 】\n			', '\n冰：冰块；炭：炭火。比喻两种对立的事物不能并存。\n			', '\n宋·陆游《寄题李季章侍郎石林堂》诗：“君不见，牛奇章与李卫公，一生冰炭不相容。”\n			', '\n有一派人说：革命和文学是～的，这两个东西根本不能并立。\n			'),
(201, '0:2:4', '冰天雪地', '\n【 bīng　tiān　xuě　dì 】\n			', '\n形容冰雪漫天盖地。\n			', '\n清·蒋士铨《鸡毛房》：“冰天雪地风如虎，裸而泣者无栖所。”\n			', '\n你就在这儿吧，～的上哪儿去？（老舍《骆驼祥子》十二）\n			'),
(202, '0:2:4', '冰天雪窑', '\n【 bīng　tiān　xuě　jiào 】\n			', '\n到处是冰和雪。指严寒地区。\n			', '\n《宋史·朱弁传》：“叹马角之未生，魂消雪窑；攀龙髯而莫逮，泪洒冰天。”\n			', '\n暂无\n			'),
(203, '0:2:4', '冰天雪窖', '\n【 bīng　tiān　xuě　jiào 】\n			', '\n形容极为寒冷。\n			', '\n清·陈康祺《郎潜纪闻》卷四：“公子编修汝舟随侍，劝以节劳暂息。公慨然曰：‘二万里冰天雪窖，只身荷戈，未尝言苦，时反惮劳乎？’”\n			', '\n暂无\n			'),
(204, '0:2:4', '冰雪聪明', '\n【 bīng　xuě　cōng　míng 】\n			', '\n比喻人聪明非凡。\n			', '\n唐·杜甫《送樊二十三侍御赴汉中判官》诗：“冰雪净聪明，雷霆走精锐。”\n			', '\n以～的文章，写雷霆精锐的思想，这种议论，就容易动人听闻了。（清·曾朴《孽海花》第十回）\n			'),
(205, '0:2:4', '冰消冻解', '\n【 bīng　xiāo　dòng　jiě 】\n			', '\n比喻完全消失或彻底崩溃。\n			', '\n《朱子全书》卷四：“见得大处分明，这许多小小病痛，都是冰消冻解，无有痕迹矣。”\n			', '\n昨见公，令我两个月心事顿然～也。乃知向之劝我者，只为我添油炽薪耳。\n			'),
(206, '0:2:4', '冰消瓦解', '\n【 bīng　xiāo　wǎ　jiě 】\n			', '\n比喻完全消失或彻底崩溃。\n			', '\n晋·成公绥《云赋》：“于是玄气仰散，归云四聚；冰消瓦解，奕奕翩翩。”\n			', '\n公以深谋，出其不意，雾廓云除，～。（《隋书·杨素传》）\n			'),
(207, '0:2:4', '冰消雾散', '\n【 bīng　xiāo　wù　sàn 】\n			', '\n比喻事物消失瓦解。\n			', '\n北周·庚信《周大将军琅邪定公司马裔墓志铭》：“都督始州诸军事，蛮夷恃险，狼顾鸱张，高山寻云，深谷无景，九地纵横，三门起伏，危峰马束，水险桥飞。遂得谷静山空，冰消雾散。”\n			', '\n暂无\n			'),
(208, '0:2:4', '冰销雾散', '\n【 bīng　xiāo　wù　sàn 】\n			', '\n比喻事物消失瓦解。\n			', '\n唐·康骈《剧谈录·郭鄩见穷鬼》：“鄩复问云：‘彼之聚敛丰盈，何以遽令散去？’云：‘先得计于安品子，其余冰销雾散。’”\n			', '\n暂无\n			'),
(209, '0:2:4', '冰消雪释', '\n【 bīng　xiāo　xuě　shì 】\n			', '\n比喻事物消失瓦解。\n			', '\n靳以《被煎熬的心》：“父亲已经在楼梯口那里等她，好像原想申斥她几句，看到她便什么都冰消雪释的样子，只在急急地问她是不是医院出了什么事。”\n			', '\n至此，我们已经获得了充分的谅解，并从心底深处感到在一起谈一谈是件很愉快的事。最初的对立早已～了。\n			'),
(210, '0:2:4', '冰雪严寒', '\n【 bīng　xuě　yán　hán 】\n			', '\n严寒：极度寒冷。冰天雪地，天气寒冷。\n			', '\n吴伯箫《菜园小记》“虽然按照时令季节，各种蔬菜种得有早有晚，有时收了这种菜才种那种菜；但是除了冰雪严寒的冬天，一年里春夏秋三季，菜园里总是经常有几种蔬菜在竞肥争绿的。”\n			', '\n暂无\n			'),
(211, '0:2:4', '冰心一片', '\n【 bīng　xīn　yī　piàn 】\n			', '\n冰心：清洁的心。形容性情淡泊，不求名利。\n			', '\n唐·王昌龄《芙蓉楼送辛渐》诗：“洛阳亲友如相问，一片冰心在玉壶。”\n			', '\n钓鱼钓晴还钓雪，～已忘机。\n			'),
(212, '0:2:4', '冰消云散', '\n【 bīng　xiāo　yún　sàn 】\n			', '\n比喻事物消失瓦解。\n			', '\n续范亭《三年不言之言》：“我看当时的情况，好像阎长官满肚子的勇气，被郭宗汾的这一席话，说得冰消云散了。”\n			', '\n暂无\n			'),
(213, '0:2:4', '冰销叶散', '\n【 bīng　xiāo　yè　sàn 】\n			', '\n比喻事物消失瓦解。\n			', '\n《隋书·越王侗传》：“若王师一临，旧章暂睹，自应解甲倒戈，冰销叶散。”\n			', '\n暂无\n			'),
(214, '0:2:4', '春冰虎尾', '\n【 chūn　bīng　hǔ　wěi 】\n			', '\n踩着老虎尾巴，走在春天将解冻的冰上。比喻处境非常危险。\n			', '\n《尚书·君牙》：“心之忧危，若蹈虎尾，涉于春冰。”\n			', '\n延光等深言邪蒿～之戒，欲惊悟上意。（宋·孙光宪《北梦琐言》卷二十）\n			'),
(215, '0:2:4', '炊沙镂冰', '\n【 chuī　shā　lòu　bīng 】\n			', '\n炊沙不能成饭，刻冰不能作器。比喻徒劳无功。\n			', '\n宋·张淏《云谷杂记》卷首：“绝编坏简徒自苦，炊沙镂冰初何功？”\n			', '\n暂无\n			'),
(216, '0:2:4', '冬寒抱冰，夏热握火', '\n【 dōng　hán　bào　bīng，xià　rè　wò　huǒ 】\n			', '\n形容刻苦自勉。\n			', '\n《吴越春秋·勾践归国外传》：“越王念复吴，仇非上旦也。苦身劳心，夜以继日。……冬常抱冰，夏还握火。”\n			', '\n暂无\n			'),
(217, '0:2:4', '冻解冰释', '\n【 dòng　jiě　bīng　shì 】\n			', '\n如同冰冻融化一般。比喻困难或障碍消除。\n			', '\n《庄子·庚桑楚》：“是乃所谓冰释冻释者能乎？”\n			', '\n则复取程氏书虚心平气而徐读之，未及数行，～。（《朱子全书·中庸》）\n			'),
(218, '0:2:4', '滴水成冰', '\n【 dī　shuǐ　chéng　bīng 】\n			', '\n水滴下去就结成冰。形容天气十分寒冷。\n			', '\n宋·钱易《南部新书》：“严冬冱寒，滴水成冰。”\n			', '\n北方的冬天，十分寒冷，～。\n			'),
(219, '0:2:4', '戴霜履冰', '\n【 dài　shuāng　lǚ　bīng 】\n			', '\n形容不怕严寒，奔波于外。\n			', '\n晋·葛洪《抱朴子·勖学》：“于是莫不蒙尘触雨，戴霜履冰，怀黄握白，提清絜肥，以赴邪径之近易，规朝种而暮获矣！”\n			', '\n暂无\n			'),
(220, '0:2:4', '伐冰之家', '\n【 fá　bīng　zhī　jiā 】\n			', '\n伐冰，凿取冰塊。古代唯有卿大夫以上的贵族丧祭得以用冰，用以称达官贵族。\n			', '\n《礼记·大学》：“伐冰之家，不畜牛羊。”郑玄注：“卿大夫以上丧祭用冰。”\n			', '\n珍羞百品，同～。\n			'),
(221, '0:2:4', '含冰茹檗', '\n【 hán　bīng　rú　bò 】\n			', '\n檗，黄檗。形容生活清苦，为人清白。同“饮冰食檗”。\n			', '\n清·李枢《〈精忠传弹词〉序》：“太夫人舍生不遂，乃奉君姑并携六月孤儿，伴榇回浙，赁居于海宁桐木村旧戚马氏之见远山楼。自此含冰茹檗之中，惟曲尽其事长抚雏之责矣。”\n			', '\n暂无\n			'),
(222, '0:2:4', '涣尔冰开', '\n【 huàn　ěr　bīng　kāi 】\n			', '\n犹言涣然冰释。形容疑虑、误会、隔阂等完全消除。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(223, '0:2:4', '涣然冰释', '\n【 huàn　rán　bīng　shì 】\n			', '\n涣然：流散的样子；释：消散。像冰遇热消融一般。形容疑虑、误会、隔阂等完全消除。\n			', '\n《老子》第十五章：“涣兮若冰之将释。”\n			', '\n误解和偏见并不能随着时间的推移而～。\n			'),
(224, '0:2:4', '涣如冰释', '\n【 huàn　rú　bīng　shì 】\n			', '\n犹言涣然冰释。形容疑虑、误会、隔阂等完全消除。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(225, '0:2:4', '涣若冰释', '\n【 huàn　ruò　bīng　shì 】\n			', '\n犹言涣然冰释。形容疑虑、误会、隔阂等完全消除。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(226, '0:2:4', '涣若冰消', '\n【 huàn　ruò　bīng　xiāo 】\n			', '\n犹言涣然冰释。象冰遇热消融一般。形容疑虑、误会、隔阂等完全消除。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(227, '0:2:4', '画水镂冰', '\n【 huà　shuǐ　lòu　bīng 】\n			', '\n在水上作画，在冰上雕刻。比喻劳而无功。\n			', '\n汉·桓谭《新论》：“画水镂冰，与时消释。”\n			', '\n暂无\n			'),
(228, '0:2:4', '火上弄冰', '\n【 huǒ　shàng　nòng　bīng 】\n			', '\n比喻一下子消失净尽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(229, '0:2:4', '虎尾春冰', '\n【 hǔ　wěi　chūn　bīng 】\n			', '\n踩着老虎尾巴，走在春天将解冻的冰上。比喻处境非常危险。\n			', '\n《尚书·君牙》：“心之忧危，若蹈虎尾，涉于春冰。”\n			', '\n暂无\n			'),
(230, '0:2:4', '画脂镂冰', '\n【 huà　zhī　lòu　bīng 】\n			', '\n镂：雕刻。在没脂上绘画，在冰上雕刻。比喻劳而无功。\n			', '\n汉·桓宽《盐铁论·殊路》：“故内无其质，而外学其文，虽有贤师良友，若画脂镂冰，费日损功。”\n			', '\n暂无\n			'),
(231, '0:2:4', '煎水作冰', '\n【 jiān　shuǐ　zuò　bīng 】\n			', '\n比喻不可能的事。\n			', '\n《三国志·魏志·高堂隆传》：“以若所为，求若所致，犹缘木求鱼，煎水作冰，其不可得，明矣。”\n			', '\n暂无\n			'),
(232, '0:2:4', '戛玉敲冰', '\n【 jiá　yù　qiāo　bīng 】\n			', '\n戛：敲击。敲打玉器和冰块。形容声调有节奏而响亮好听。也形容人气节凛然。\n			', '\n唐·白居易《听田顺儿歌》：“戛玉敲冰声未停，嫌云不遏入青冥。”\n			', '\n暂无\n			'),
(233, '0:2:4', '镂冰炊砾', '\n【 lòu　bīng　chuī　lì 】\n			', '\n比喻徒劳无益。\n			', '\n语出宋·黄庭坚《送王郎》诗：“炊沙作糜终不饱，镂冰文字费工巧。”\n			', '\n楮叶工夫，辛苦似，～。\n			'),
(234, '0:2:4', '镂冰雕琼', '\n【 lòu　bīng　diāo　qióng 】\n			', '\n琼：美玉。比喻作品风格明洁或构思新颖精巧。\n			', '\n明·杨慎《升庵诗话·孙器之评诗》：“刘梦得如镂冰雕琼，流光自照。”\n			', '\n子安刻意摹拟，词俊而格超，可谓～，心手双绝。\n			'),
(235, '0:2:4', '镂冰雕朽', '\n【 lòu　bīng　diāo　xiǔ 】\n			', '\n镂、雕：雕刻。雕刻冰块和朽木。比喻劳而无功。\n			', '\n《北史·儒林传序》：“镂冰雕朽，迄用无成。”\n			', '\n暂无\n			'),
(236, '0:2:4', '镂冰劚雪', '\n【 lòu　bīng　diāo　xuě 】\n			', '\n比喻构思新颖精巧。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(237, '0:2:4', '冷若冰霜', '\n【 lěng　ruò　bīng　shuāng 】\n			', '\n冷得象冰霜一样。比喻待人接物毫无感情，象冰霜一样冷。也比喻态度严正，不可接近。\n			', '\n元·王实甫《西厢记》第一本第二折：“俺老夫人治家严肃，凛若冰霜。”\n			', '\n笑起来一双眼又秀又媚，却是不笑起来又～。（清·刘鹗《老残游记·续集》第二回）\n			'),
(238, '0:2:4', '凛若冰霜', '\n【 lǐn　ruò　bīng　shuāng 】\n			', '\n冷得象冰霜一样。比喻待人接物毫无感情，象冰霜一样冷。也比喻态度严正，不可接近。\n			', '\n元·王实甫《西厢记》第一本第二折：“俺老夫人治家严肃，凛若冰霜。”\n			', '\n暂无\n			'),
(239, '0:2:4', '履霜坚冰', '\n【 lǚ　shuāng　jiān　bīng 】\n			', '\n履：踩，踏。踩着霜，就想到结冰的日子就要到来。比喻看到事物的苗头，就对它的发展有所警戒。\n			', '\n《易·坤》：“履霜坚冰至。”\n			', '\n～，阴始凝也。驯致其道，至坚冰也。（《二程全书·伊川易传一》）\n			'),
(240, '0:2:4', '履霜知冰', '\n【 lǚ　shuāng　zhī　bīng 】\n			', '\n比喻见事物的征兆可预知其严重后果。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(241, '0:2:4', '冷语冰人', '\n【 lěng　yǔ　bīng　rén 】\n			', '\n用冷酷的话伤人。\n			', '\n宋·曾造《类说·〈外史梼杌〉》：“潘柱迎，孟蜀时，以财结权要，或戒之，乃日：‘非是求愿，不欲以冷语冰人耳。’”\n			', '\n暂无\n			'),
(242, '0:2:4', '镂玉裁冰', '\n【 lòu　yù　cái　bīng 】\n			', '\n比喻构思新颖精美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(243, '0:2:4', '敲冰戛玉', '\n【 qiāo　bīng　jiá　yù 】\n			', '\n比喻乐声清润动听。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(244, '0:2:4', '敲冰求火', '\n【 qiāo　bīng　qiú　huǒ 】\n			', '\n敲开冰找火。比喻不可能实现的事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(245, '0:2:4', '敲冰索火', '\n【 qiāo　bīng　suǒ　huǒ 】\n			', '\n比喻行动和目的相反，一定不会成功。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(246, '0:2:4', '敲冰玉屑', '\n【 qiāo　bīng　yù　xiè 】\n			', '\n泛指精美的纸张。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(247, '0:2:4', '青蓝冰水', '\n【 qīng　lán　bīng　shuǐ 】\n			', '\n“青出于蓝，冰寒于水”的略语。比喻学生超过老师或后人胜过前人。\n			', '\n清·陈康祺《燕下乡脞录》卷四：“桐城派古文，望谿开之，海峰继之，至惜抱而其传始大，此天下之公言也。惜抱出于刘门，世几有青蓝冰水之喻。”\n			', '\n暂无\n			'),
(248, '0:2:4', '如履薄冰', '\n【 rú　lǚ　bó　bīng 】\n			', '\n履：践、踩在上面。像走在薄冰上一样。比喻行事极为谨慎，存有戒心。\n			', '\n《诗·小雅·小旻》：“战战兢兢，如临深渊，如履薄冰。”\n			', '\n暂无\n			'),
(249, '0:2:4', '若涉渊冰', '\n【 ruò　shè　yuān　bīng 】\n			', '\n比喻处境艰险。同“若涉渊水”。\n			', '\n宋·陈亮《论励臣之道》：“朕承太上皇亮付托之重，念国家之深耻，志在复雠，八年于兹，若涉渊冰，未知攸济。”\n			', '\n暂无\n			'),
(250, '0:2:4', '枘凿冰炭', '\n【 ruì　záo　bīng　tàn 】\n			', '\n比喻事物尖锐对立，互不相容。参见“枘凿方圆”。\n			', '\n清王鸣盛《十七史商榷·南史合宋齐梁陈书十二·顾欢论道佛二家》：“愚谓欢所引道经颇确，老子子即佛，本是一人，故无二法……惟与吾儒，则如枘凿冰炭之不相合耳。”\n			', '\n暂无\n			'),
(251, '0:2:4', '水洁冰清', '\n【 shuǐ　jié　bīng　qīng 】\n			', '\n洁：洁白。清：清净。指像冰和水一样洁白清净。形容人的品格高洁或文笔雅致。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(252, '0:2:4', '瓦解冰泮', '\n【 wǎ　jiě　bīng　pàn 】\n			', '\n瓦器破碎，冰块融解。比喻失败、崩溃或消失。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(253, '0:2:4', '瓦解冰消', '\n【 wǎ　jiě　bīng　xiāo 】\n			', '\n比喻完全消逝或彻底崩溃。\n			', '\n晋·成公绥《云赋》：“于是玄气仰散，归云四聚；冰消瓦解，奕奕翩翩。”\n			', '\n你们的一场闹剧，给我一席话，弄得～。（清·吴趼人《二十年目睹之怪现状》第十一回）\n			'),
(254, '0:2:4', '瓦解冰销', '\n【 wǎ　jiě　bīng　xiāo 】\n			', '\n比喻失败、崩溃或消失。同“瓦解冰泮”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(255, '0:2:4', '雾释冰融', '\n【 wù　shì　bīng　róng 】\n			', '\n雾气消散冰块融化。比喻疑难消除尽净。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(256, '0:2:4', '王祥卧冰', '\n【 wáng　xiáng　wò　bīng 】\n			', '\n王祥卧冰求鱼以奉母。比喻子女孝顺父母。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(257, '0:2:4', '夏虫不可以语冰', '\n【 xià　chóng　bù　kě　yǐ　yǔ　bīng 】\n			', '\n不能和生长在夏天的虫谈论冰。比喻时间局限人的见识。也比喻人的见识短浅。\n			', '\n《庄子·秋水》：“夏虫不可以语于冰者，笃于时也。”\n			', '\n郎如此眼光浅，真是～。（明·凌濛初《二刻拍案惊奇》卷三十七）\n			'),
(258, '0:2:4', '雪操冰心', '\n【 xuě　cāo　bīng　xīn 】\n			', '\n志行品德高尚纯洁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(259, '0:2:4', '夏虫疑冰', '\n【 xià　chóng　yí　bīng 】\n			', '\n比喻人囿于见闻，知识短浅。\n			', '\n语出《庄子·秋水》：“井蛙不可以语于海者，拘于虚也；夏虫不可以语于冰者，笃于时也。”\n			', '\n哂夏虫之疑冰，整轻翮而思矫。\n			'),
(260, '0:2:4', '夏虫语冰', '\n【 xià　chóng　yǔ　bīng 】\n			', '\n比喻人囿于见闻，知识短浅。\n			', '\n语出《庄子·秋水》：“井蛙不可以语于海者，拘于虚也；夏虫不可以语于冰者，笃于时也。”\n			', '\n不审倚伏之机，不明顺逆之故，是犹醯鸡处瓮，别有一天，～，莫知其候也。\n			'),
(261, '0:2:4', '衔胆栖冰', '\n【 xián　dǎn　qī　bīng 】\n			', '\n衔：嘴含；胆：苦胆；栖：栖息。嘴里含着苦胆，居住在冰上。形容刻苦自励。\n			', '\n《晋书·刘元海载记》：“但以大耻未雪，社稷无主，衔胆栖冰，勉从群议。”\n			', '\n暂无\n			'),
(262, '0:2:4', '雪窖冰天', '\n【 xuě　jiào　bīng　tiān 】\n			', '\n窖：收藏东西的地洞。到处是冰和雪。形容天气寒冷，也指严寒地区。\n			', '\n《宋史·朱弁传》：“叹马角之未生，魂销雪窖；攀龙髯而莫逮，泪洒冰天。”\n			', '\n今日荷戈边塞去，可堪雪窖复冰天。（清·黄遵宪《归过日本志感》诗）\n			'),
(263, '0:2:4', '雪窑冰天', '\n【 xuě　jiào　bīng　tiān 】\n			', '\n到处是冰和雪。指严寒地区。\n			', '\n《宋史·朱弁传》：“叹马角之未生，魂销支窑；攀龙髯而莫逮，泪洒冰天。”\n			', '\n暂无\n			'),
(264, '0:2:4', '雪碗冰瓯', '\n【 xuě　wǎn　bīng　ōu 】\n			', '\n瓯：盆碗之类的器皿。形容碗、盆器皿洁白干净。也比喻诗文清雅。\n			', '\n宋·范成大《次韵甄云卿晚登浮丘亭》诗：“葛中羽扇吾方健，雪碗冰瓯子句清。”\n			', '\n暂无\n			'),
(265, '0:2:4', '饮冰内热', '\n【 yǐn　bīng　nèi　rè 】\n			', '\n形容十分惶恐焦灼。\n			', '\n《庄子·人间世》：“今吾朝受命而夕饮冰，我其内热与？”\n			', '\n暂无\n			'),
(266, '0:2:4', '饮冰茹檗', '\n【 yǐn　bīng　rú　bò 】\n			', '\n茹：吃；檗：俗称黄柏，味苦。喝冷水，吃苦味的东西。比喻处境困苦，心情抑郁。也形容生活清苦。\n			', '\n唐·白居易《三年为刺史》诗：“三年为刺史，饮冰复食檗。”\n			', '\n节妇非素有定志，必不能～。（清·纪昀《阅微草堂笔记》卷十三）\n			'),
(267, '0:2:4', '饮冰茹蘖', '\n【 yǐn　bīng　rú　bò 】\n			', '\n指生活清苦，为人清白。同“饮冰食蘖”。\n			', '\n清·纪昀《阅微草堂笔记·槐西杂志三》：“节妇非素有定志，必不能饮冰茹檗数十年。”\n			', '\n暂无\n			'),
(268, '0:2:4', '饮冰食檗', '\n【 yǐn　bīng　shí　bò 】\n			', '\n喝冷水，吃苦味的东西。形容生活清苦，为人清白。\n			', '\n唐·白居易《三年为刺史》诗：“三年为刺史，饮冰复食檗。唯向天竺山，取得两片石。”\n			', '\n暂无\n			'),
(269, '0:2:4', '饮冰食蘖', '\n【 yǐn　bīng　shí　bò 】\n			', '\n指生活清苦，为人清白。亦作“饮冰吞檗”、“饮冰茹蘖”。\n			', '\n语出唐·白居易《三年为刺史》诗之二：“三年为刺史，饮冰复食檗。唯向天竺山，取得两片石。此抵有千金，无乃伤清白。”\n			', '\n伏以尚书万顷包含，千寻峭拔，膺岳峻河清之数，切～，之诚。\n			'),
(270, '0:2:4', '饮冰吞檗', '\n【 yǐn　bīng　tūn　bò 】\n			', '\n指生活清苦，为人清白。同“饮冰食蘖”。\n			', '\n明·袁宗道《杂说》：“务此大事，不怙小解，惟求实知，卧薪尝胆，饮冰吞檗。”\n			', '\n暂无\n			'),
(271, '0:2:4', '以冰致蝇', '\n【 yǐ　bīng　zhì　yíng 】\n			', '\n致：招引。用冰块引苍蝇。比喻事情必难实现。\n			', '\n《吕氏春秋·功名》：“以狸致鼠，以冰致蝇，虽工不能。”\n			', '\n暂无\n			'),
(272, '0:2:4', '玉骨冰肌', '\n【 yù　gǔ　bīng　jī 】\n			', '\n形容女子苗条的身段和洁白光润的肌肤。\n			', '\n宋·杨无咎《柳梢青》词：“玉骨冰肌，为谁偏好，特地相宜，一段风流。”\n			', '\n生成～态，长就兰襟蕙质心。\n			'),
(273, '0:2:4', '玉洁冰清', '\n【 yù　jié　bīng　qīng 】\n			', '\n象玉那样洁白，象冰那样清净。形容人心地纯洁，品行端正。\n			', '\n汉·桓谭《新论·妄瑕》：“伯夷叔齐，冰清玉洁，以义不为孤竹之嗣，不食周粟，饿死首阳。”\n			', '\n若辈一经用了手脚，随你三贞九烈，～，亦不能跳出圈外。（清·李汝珍《镜花缘》第十二回）\n			'),
(274, '0:2:4', '以狸致鼠，以冰致绳', '\n【 yǐ　lí　zhì　shǔ、yǐ　bīng　zhì　shéng 】\n			', '\n用猫招引老鼠，用冰作绳索。比喻事情不能成功。\n			', '\n《吕氏春秋·功名》：“以狸致鼠、以冰致绳，虽工不能。”\n			', '\n暂无\n			'),
(275, '0:2:4', '阴凝冰坚', '\n【 yīn　níng　bīng　jiān 】\n			', '\n阴气始凝结而为霜，渐积聚乃成坚冰。比喻小人渐渐得势，地位渐趋稳固。\n			', '\n《周易·坤》：“履霜坚冰，阴始凝也。”\n			', '\n～，极于似道。\n			'),
(276, '0:2:4', '阴凝坚冰', '\n【 yīn　níng　jiān　bīng 】\n			', '\n阴气始凝结而为霜，渐积聚乃成坚冰。比喻小人渐渐得势，地位渐趋稳固。\n			', '\n《易·坤》：“履霜坚冰，阴始凝也。”\n			', '\n暂无\n			'),
(277, '0:2:4', '一片冰心', '\n【 yī　piàn　bīng　xīn 】\n			', '\n冰心：清洁的心。形容性情淡泊，不求名利。\n			', '\n唐·王昌龄《芙蓉楼送辛渐》诗：“洛阳亲友如相问，一片冰心在玉壶。”\n			', '\n暂无\n			'),
(278, '0:2:4', '玉清冰洁', '\n【 yù　qīng　bīng　jié 】\n			', '\n犹玉洁冰清。\n			', '\n宋·高观国《花心动·梅意》词：“碧藓封枝，点寒英、疏疏玉清冰洁。”\n			', '\n暂无\n			'),
(279, '0:2:4', '迎刃冰解', '\n【 yíng　rèn　bīng　jiě 】\n			', '\n比喻处理事情、解决问题很顺利。同“迎刃而解”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(280, '0:2:4', '玉润冰清', '\n【 yù　rùn　bīng　qīng 】\n			', '\n像玉一样润泽，像冰一样清纯。常喻人或物形神之美。\n			', '\n宋·曾巩《荔支》诗之二：“玉润冰清不受尘，仙衣裁剪绛纱新。”\n			', '\n暂时想见意冲冲，～迥不回。\n			'),
(281, '0:2:4', '艳如桃李，冷若冰霜', '\n【 yàn　ruò　táo　lǐ，lěng　ruò　bīng　shuāng 】\n			', '\n形容女子容貌艳丽而态度严肃。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(282, '0:2:4', '钻冰取火', '\n【 zuàn　bīng　qǔ　huǒ 】\n			', '\n比喻徒劳无功。\n			', '\n《全元散曲·普天乐·嘲风情》：“姐姐每钻冰取火，婆婆每指山卖磨。”\n			', '\n暂无\n			'),
(283, '0:2:4', '钻冰求火', '\n【 zuān　bīng　qiú　huǒ 】\n			', '\n比喻徒劳无功。\n			', '\n宋·张君房《云笈七签》第102卷：“影离响绝，云销雾除，钻冰求火，探巢捕鱼，不足言其无也。”\n			', '\n暂无\n			'),
(284, '0:2:4', '钻冰求酥', '\n【 zuān　bīng　qiú　sū 】\n			', '\n酥：酥油，牛羊奶制成的食品。比喻想要的东西一定得不到。\n			', '\n《菩萨本缘经》卷下：“譬如钻冰求酥，是实难得。”\n			', '\n暂无\n			'),
(285, '0:2:4', '炙冰使燥', '\n【 zhì　bīng　shǐ　zào 】\n			', '\n炙：烤。用火烤冰，想使它干燥。比喻事情办不到。\n			', '\n《抱朴子·刺骄》：“欲望萧雍济济，后生有武，是犹炙冰使燥，积灰令炽矣。”\n			', '\n暂无\n			'),
(286, '0:2:4', '钻火得冰', '\n【 zuān　huǒ　dé　bīng 】\n			', '\n比喻不可能实现的事情。\n			', '\n唐·释道世《法苑珠林》：“未见钻火得冰，种豆得麦。”\n			', '\n暂无\n			'),
(287, '0:2:4', '走花溜冰', '\n【 zǒu　huā　liū　bīng 】\n			', '\n比喻吹牛，说大话。\n			', '\n明·吴承恩《西游记》第七十四回：“你莫象才来的那个和尚，走花溜冰的胡缠。”\n			', '\n暂无\n			'),
(288, '0:2:4', '铸木镂冰', '\n【 zhù　mù　lòu　bīng 】\n			', '\n指约束树木（使其按人为的形态生长），刻镂冰塊（使其成某种精致的工艺品）。比喻经办毫无成效的事情。\n			', '\n宋·叶廷珪《海录碎事·人事中》：“卖浆贩麦，利辄失时，铸木镂冰，初无成日。”\n			', '\n暂无\n			'),
(289, '0:2:5', '不冷不热', '\n【 bù　lěng　bù　rè 】\n			', '\n指温度不高不低，冷热适中。亦比喻对人态度一般。\n			', '\n清·文康《儿女英雄传》第三十五回：“便见他一只手高高儿的举了一碗熬得透、得到不冷不热、温凉适中、可口儿的普洱茶来。”巴金《寒夜》三：“这一天是这个山城里少有的不冷不热的好天。”\n			', '\n他采取～的态度，和她保持若即若离的关系。\n			'),
(290, '0:2:5', '冰炭不言，冷热自明', '\n【 bīng　tàn　bù　yán,　lěng　rè　zì　míng 】\n			', '\n比喻内心的诚意不用表白，必然表现在行动上。\n			', '\n《晋书·王沈传》：“尧、舜、周公所以能致忠谏者，以其款诚之心者也，冰炭不言，而冷热之质自明者，以其有实也。”\n			', '\n暂无\n			'),
(291, '0:2:5', '不因人热', '\n【 bù　yīn　rén　rè 】\n			', '\n因：依靠。汉时梁鸿不趁他人热灶烧火煮饭。比喻为人孤僻高傲。也比喻不依赖别人。\n			', '\n《东观汉记·梁鸿传》：“比舍先炊已，呼鸿及热釜炊。鸿曰：‘童子鸿不因人热者也。’灭灶更燃火。”\n			', '\n皆能独来独往，～。（清·谭嗣同《论艺》）\n			'),
(292, '0:2:5', '不着疼热', '\n【 bù　zhuó　téng　rè 】\n			', '\n犹言无关痛痒。指不体贴爱护。\n			', '\n元·关汉卿《蝴蝶梦》第二折：“这一个小厮，必是你乞养来的螟蛉之子，不着疼热，所以着他偿命。”\n			', '\n我想这大的个小厮必然是你乞养过房螟蛉之子，～。\n			'),
(293, '0:2:5', '趁热打铁', '\n【 chèn　rè　dǎ　tiě 】\n			', '\n铁要趁烧红的时候打。比喻要抓紧有利的时机和条件去做。\n			', '\n<span class="C999">暂无</span>\n			', '\n他觉得老大实在有可爱的地方，于是，他决定～，把话都说净。（老舍《四世同堂》十九）\n			'),
(294, '0:2:5', '乘热打铁', '\n【 chéng　rè　dǎ　tiě 】\n			', '\n比喻做事抓紧时机，加速进行。\n			', '\n老舍《四世同堂》十九：“他觉得老大实在有可爱的地方；于是，他决定乘热打铁，把话都说净。”\n			', '\n暂无\n			'),
(295, '0:2:5', '打得火热', '\n【 dǎ　dé　huǒ　rè 】\n			', '\n形容十分亲密。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(296, '0:2:5', '冬寒抱冰，夏热握火', '\n【 dōng　hán　bào　bīng，xià　rè　wò　huǒ 】\n			', '\n形容刻苦自勉。\n			', '\n《吴越春秋·勾践归国外传》：“越王念复吴，仇非上旦也。苦身劳心，夜以继日。……冬常抱冰，夏还握火。”\n			', '\n暂无\n			'),
(297, '0:2:5', '打铁趁热', '\n【 dǎ　tiě　chèn　rè 】\n			', '\n比喻做事要抓紧时机，加速进行。\n			', '\n<span class="C999">暂无</span>\n			', '\n～，放火趁风，你们不等这时万人一心的功夫，调动他们还等什么！（骆宾基《胶东的暴民》）\n			'),
(298, '0:2:5', '腹热肠荒', '\n【 fù　rè　cháng　huāng 】\n			', '\n元曲俗语。形容焦急、慌乱。同“腹热肠慌”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(299, '0:2:5', '腹热肠慌', '\n【 fù　rè　cháng　huāng 】\n			', '\n元曲俗语。形容焦急、慌乱。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(300, '0:2:5', '腹热心煎', '\n【 fù　rè　xīn　jiān 】\n			', '\n形容心中焦急。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(301, '0:2:5', '附炎趋热', '\n【 fù　yán　qū　rè 】\n			', '\n比喻趋附时贵权势。\n			', '\n明·王錂《春芜忘·宴赏》：“下官楚大夫登徒履便是，附炎趋热，色厉内茬。”\n			', '\n暂无\n			'),
(302, '0:2:5', '古道热肠', '\n【 gǔ　dào　rè　cháng 】\n			', '\n指待人真诚、热情。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(303, '0:2:5', '寒耕热耘', '\n【 hán　gēng　rè　yùn 】\n			', '\n泛指农作辛苦。\n			', '\n《孔子家语·屈节解》：“民寒耕热耘，曾不得食。”\n			', '\n暂无\n			'),
(304, '0:2:5', '忽冷忽热', '\n【 hū　lěng　hū　rè 】\n			', '\n指时而冷静，时而感情冲动，情绪不稳定。\n			', '\n鲁迅《而已集·读书杂谈》：“研究是要用理智，要冷静的，而创作须情感，至少总得发点热，于是忽冷忽热，弄得头昏。”\n			', '\n暂无\n			'),
(305, '0:2:5', '火热水深', '\n【 huǒ　rè　shuǐ　shēn 】\n			', '\n①犹水深火热。比喻十分困苦的处境。②形容严酷；厉害。\n			', '\n清·魏秀仁《花月痕》第五十回：“我算什么，明相国不动声色，却出斯民于火热水深，措天下于泰山磐石。”\n			', '\n法兰西革命之时，上自王家，下至贵族僧侣，蹂躏平民，无所弗至，其法之力，可谓～矣。\n			'),
(306, '0:2:5', '酒酣耳热', '\n【 jiǔ　hān　ěr　rè 】\n			', '\n形容喝酒喝得正高兴的时候。\n			', '\n三国魏·曹丕《与吴质书》：“每至觞酌流行，丝竹并奏，酒酣耳热，仰而赋诗，当此之时，忽然不自知乐也。”\n			', '\n～，攘袂持杯。（清·张潮《虞初新志·王翠翘传》）\n			'),
(307, '0:2:5', '焦心热中', '\n【 jiāo　xīn　rè　zhōng 】\n			', '\n费尽心思，万分忧虑。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(308, '0:2:5', '冷嘲热讽', '\n【 lěng　cháo　rè　fěng 】\n			', '\n用尖刻辛辣的语言进行讥笑和讽刺。\n			', '\n<span class="C999">暂无</span>\n			', '\n见了老徐，说了几句～的话儿。（蔡东藩、许廑父《民国通俗演义》第一一六回）\n			'),
(309, '0:2:5', '冷嘲热骂', '\n【 lěng　cháo　rè　mà 】\n			', '\n尖刻的嘲笑和谩骂。\n			', '\n郭沫若《反正前后》第一篇：“他一进一出要受学生们的冷嘲热骂，然而也不能不忍耐着装聋卖哑。”\n			', '\n暂无\n			'),
(310, '0:2:5', '脸红耳热', '\n【 liǎn　hóng　ěr　rè 】\n			', '\n形容感情激动或害羞的样子。同“脸红耳赤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(311, '0:2:5', '冷言热语', '\n【 lěng　yán　rè　yǔ 】\n			', '\n犹冷言冷语。带讥讽意味的冷冰冰的话。\n			', '\n明·冯梦龙《警世通言》第二十四卷：“三官说：‘欲待回家，难见父母兄嫂；待不去，又受不得亡八冷言热语。’”\n			', '\n妇人心肠褊窄浅露，便把晋王好，太子歹，一齐搬将出来。杨素又加上些～。\n			'),
(312, '0:2:5', '面红耳热', '\n【 miàn　hóng　ěr　rè 】\n			', '\n形容因紧张、急躁、害羞等而脸上发红的样子。\n			', '\n明·凌濛初《初刻拍案惊奇》卷二十：“可怜裴兰孙是个娇滴滴的闺中处子，见了一个陌生人，也要面红耳热的。”\n			', '\n想到这里，不免～起来，也就讪讪的进房梳洗去了。\n			'),
(313, '0:2:5', '满腔热枕', '\n【 mǎn　qiāng　rè　chén 】\n			', '\n心里充满热烈真挚的感情。\n			', '\n<span class="C999">暂无</span>\n			', '\n他总是～地帮助别人。\n			'),
(314, '0:2:5', '满腔热忱', '\n【 mǎn　qiāng　rè　chén 】\n			', '\n形容心里充满着热烈诚挚的感情。\n			', '\n<span class="C999">暂无</span>\n			', '\n庞教授总是不厌其烦、～地回答学生所提出的问题。\n			'),
(315, '0:2:5', '攀炎附热', '\n【 pān　yán　fù　rè 】\n			', '\n犹言趋炎附势。奉承和依附有权有势的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(316, '0:2:5', '趋炎附热', '\n【 qū　yán　fù　rè 】\n			', '\n趋：奔走；热：比喻权势。奉承和依附有权有势的人。\n			', '\n《宋史·李垂传》：“今已老大，见大臣不公，常欲面折之。焉能趋炎附热，看人眉睫，以冀推挽乎？”\n			', '\n止有白长吉一味～，说妹子是穷骨头，要跟恁样饿莩，坏他体面。\n			'),
(317, '0:2:5', '热熬翻饼', '\n【 rě　áo　fān　bǐng 】\n			', '\n比喻事情极容易做到。\n			', '\n《唐宋遗史》：“取幽蓟如热熬翻饼尔。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(318, '0:2:5', '热肠古道', '\n【 rè　cháng　gǔ　dào 】\n			', '\n热肠：热心肠；古道：上古时代的风俗习惯，形容厚道。指待人真诚、热情。\n			', '\n<span class="C999">暂无</span>\n			', '\n老哥～，我们是一向钦佩的。（清·吴趼人《糊涂世界》）\n			'),
(319, '0:2:5', '热锅上蝼蚁', '\n【 rè　guō　shàng　lóu　yǐ 】\n			', '\n形容心里烦躁、焦急，坐立不安的样子。同“热锅上蚂蚁”。\n			', '\n《隋唐演义》第十九回：“这壁厢太子与杨素，是热锅上蝼蚁，盼不到一个消息。”\n			', '\n暂无\n			'),
(320, '0:2:5', '热锅上蚂蚁', '\n【 rè　guō　shàng　mǎ　yǐ 】\n			', '\n比喻处境艰困、惶急不安的人。\n			', '\n清·李宝嘉《官场现形记》第十一回：“一霎时犹如热锅上蚂蚁一般，茶饭无心，坐立不定，好生难过，一直等到旁黑，跟班的又出去打听，不多一刻，只见垂头丧气而回。”\n			', '\n女人们还在越在越聚越多，像～，有些跑回了家又跑了出去，在田原里跑着，喃喃着。\n			'),
(321, '0:2:5', '热锅上的蚂蚁', '\n【 rè　guō　shàng　de　mǎ　yǐ 】\n			', '\n形容心里烦躁、焦急，坐立不安的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(322, '0:2:5', '热火朝天', '\n【 rè　huǒ　cháo　tiān 】\n			', '\n形容群众性的活动情绪热烈，气氛高涨，就象炽热的火焰照天燃烧一样。\n			', '\n<span class="C999">暂无</span>\n			', '\n但这几天～的参军运动，也冲击着他们的身心。（冯德英《迎春花》第九章）\n			'),
(323, '0:2:5', '热可炙手', '\n【 rè　kě　zhì　shǒu 】\n			', '\n火热可以灼手。比喻权势显赫。同“炙手可热”。\n			', '\n唐·郑棨《开天传信记》：“安乐公主，上之季妹也。附会韦氏，热可炙手，道路惧焉。”\n			', '\n暂无\n			'),
(324, '0:2:5', '热泪盈眶', '\n【 rè　lèi　yíng　kuàng 】\n			', '\n盈：充满；眶：眼眶。因感情激动而使眼泪充满了眼眶，形容感动至极或非常悲伤。\n			', '\n<span class="C999">暂无</span>\n			', '\n往往讲到孤女患难，或义妇含冤的凄惨的情形，她两人便都～，泪珠尽往颊上涌流着。（邹韬奋《我的母亲》）\n			'),
(325, '0:2:5', '热气腾腾', '\n【 rè　qì　téng　téng 】\n			', '\n热气蒸腾的样子。形容气氛热烈或情绪高涨。\n			', '\n清·李宝嘉《中国现在记》第十一回：“只见小和用一个小托盘托了几碗盖碗茶，热气腾腾的端过来。”\n			', '\n中国是处在大革命中，全中国～。\n			'),
(326, '0:2:5', '热情洋溢', '\n【 rè　qíng　yáng　yì 】\n			', '\n热烈的感情充分地流露出来。\n			', '\n曹靖华《罗汉岭前吊秋白》：“对全世界来说，这些热情洋溢的报导，正是拨云雾而见青天啊！”\n			', '\n暂无\n			'),
(327, '0:2:5', '热血沸腾', '\n【 rè　xuè　fèi　téng 】\n			', '\n比喻激情高涨。\n			', '\n<span class="C999">暂无</span>\n			', '\n中国的天空在燃烧、大地在流血。不甘心作亡国奴隶的亿万人民满腔怒火，～。（刘白羽《红太阳颂》）\n			'),
(328, '0:2:5', '热心快肠', '\n【 rè　xīn　kuài　cháng 】\n			', '\n形容热情直爽。\n			', '\n柯岩《奇异的书简·东方的明珠三》：“也许因为是她热心快肠，群众有事爱找她拿主意，帮个忙。”\n			', '\n暂无\n			'),
(329, '0:2:5', '热心苦口', '\n【 rè　xīn　kǔ　kǒu 】\n			', '\n形容热心恳切地再三劝告。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(330, '0:2:5', '说亲道热', '\n【 shuō　qīn　dào　rè 】\n			', '\n说亲切热情的话。用来形容只在口头上亲热。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(331, '0:2:5', '水深火热', '\n【 shuǐ　shēn　huǒ　rè 】\n			', '\n老百姓所受的灾难，像水那样越来越深，像火那样越来越热。比喻人民生活极端痛苦。\n			', '\n《孟子·梁惠王下》：“如水益深，如火益热，亦运而已矣。”\n			', '\n只要能把国家从～里救出来，他就是至高无上的英雄。（梁斌《红旗谱》四二）\n			'),
(332, '0:2:5', '汤烧火热', '\n【 tāng　shāo　huǒ　rè 】\n			', '\n指生病发高烧。\n			', '\n清·曹雪芹《红楼梦》第二十回：“又见他汤烧火热，自己守着他，歪在旁边劝他：‘只养病，别想着些没要紧的事。’”\n			', '\n暂无\n			'),
(333, '0:2:5', '头痛额热', '\n【 tóu　tòng　é　rè 】\n			', '\n泛指一般的小病或小灾小难。同“头疼脑热”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(334, '0:2:5', '头疼脑热', '\n【 tóu　téng　nǎo　rè 】\n			', '\n泛指一般的小病。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(335, '0:2:5', '头痛脑热', '\n【 tóu　tòng　nǎo　rè 】\n			', '\n泛指一般的小病或小灾小难。同“头疼脑热”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(336, '0:2:5', '饮冰内热', '\n【 yǐn　bīng　nèi　rè 】\n			', '\n形容十分惶恐焦灼。\n			', '\n《庄子·人间世》：“今吾朝受命而夕饮冰，我其内热与？”\n			', '\n暂无\n			'),
(337, '0:2:5', '眼花耳热', '\n【 yǎn　huā　ěr　rè 】\n			', '\n两眼昏眩，双耳燥热。形容饮酒微醉时的感觉。\n			', '\n唐·李白《侠客行》诗：“眼花耳热后，意气素霓生。”\n			', '\n～言语多，霍然已醒如过烧。\n			'),
(338, '0:2:5', '眼饧耳热', '\n【 yǎn　xíng　ěr　rè 】\n			', '\n两眼半睁半闭，朦胧而视，双耳燥热。形容饮酒微醉时的感觉。\n			', '\n清·曹雪芹《红楼梦》第二十一回：“至晚饭后，宝玉因吃了两杯酒，眼饧耳热之际，若往日则有袭人等大家喜笑有兴，今日却冷清清的一人对灯，好没兴趣。”\n			', '\n暂无\n			'),
(339, '0:2:5', '炙手可热', '\n【 zhì　shǒu　kě　rè 】\n			', '\n手摸上去感到热得烫人。比喻权势大，气焰盛，使人不敢接近。\n			', '\n唐·杜甫《丽人行》：“炙手可热势绝伦，慎莫近前丞相嗔。”\n			', '\n～握大权，待郎充犬吠篱边。（清·陈忱《水浒后传》第一回）\n			'),
(340, '0:2:5', '知疼着热', '\n【 zhī　téng　zháo　rè 】\n			', '\n形容对人十分关心爱护（多指亲人）。\n			', '\n<span class="C999">暂无</span>\n			', '\n无奈二姐儿倒是个多情人，以为贾琏是终身之主了，凡事倒还～。（清·曹雪芹《红楼梦》第六十五回）\n			'),
(341, '0:2:6', '傍观冷眼', '\n【 bàng　guān　lěng　yǎn 】\n			', '\n傍：通“旁”。用冷眼或冷淡的态度在一旁瞧着。\n			', '\n《脂砚斋评红楼梦》第二回：“诗云：‘一局输赢料不真，香销茶尽尚逡巡。欲知目下兴衰兆，顺问傍观冷眼人。’”\n			', '\n暂无\n			'),
(342, '0:2:6', '不冷不热', '\n【 bù　lěng　bù　rè 】\n			', '\n指温度不高不低，冷热适中。亦比喻对人态度一般。\n			', '\n清·文康《儿女英雄传》第三十五回：“便见他一只手高高儿的举了一碗熬得透、得到不冷不热、温凉适中、可口儿的普洱茶来。”巴金《寒夜》三：“这一天是这个山城里少有的不冷不热的好天。”\n			', '\n他采取～的态度，和她保持若即若离的关系。\n			'),
(343, '0:2:6', '冰清水冷', '\n【 bīng　qīng　shuǐ　lěng 】\n			', '\n指冷冷清清。\n			', '\n《何典》第四回：“初时还有些和尚道士，有家中闹弗清楚，到也不甚觉着。及至断了七，出过棺材，诸事停当，弄得家里冰清水冷。”\n			', '\n暂无\n			'),
(344, '0:2:6', '冰炭不言，冷热自明', '\n【 bīng　tàn　bù　yán,　lěng　rè　zì　míng 】\n			', '\n比喻内心的诚意不用表白，必然表现在行动上。\n			', '\n《晋书·王沈传》：“尧、舜、周公所以能致忠谏者，以其款诚之心者也，冰炭不言，而冷热之质自明者，以其有实也。”\n			', '\n暂无\n			'),
(345, '0:2:6', '不择生冷', '\n【 bù　zé　shēng　lěng 】\n			', '\n犹言不择手段。\n			', '\n沙汀《淘金记》九：“我们这场上的事情，你晓得的，有些人一点不择生冷！一天就想方设法，拖人下水。”\n			', '\n暂无\n			'),
(346, '0:2:6', '残杯冷炙', '\n【 cán　bēi　lěng　zhì 】\n			', '\n残：剩余；杯：指酒；炙：烤肉。指吃剩的饭菜。也比喻别人施舍的东西。\n			', '\n北齐·颜之推《颜氏家训·杂艺》：“不可令有称誉，见役勋贵，处之下坐，以取残杯冷炙之辱。”\n			', '\n做人不可攀结权贵，靠人施舍，以受～之辱。\n			'),
(347, '0:2:6', '残羹冷饭', '\n【 cán　gēng　lěng　fàn 】\n			', '\n指吃剩的饭菜。也比喻别人施舍的东西。\n			', '\n明·刘基《孤儿行》：“清晨采薪日入归，残羹冷饭难充饥。”\n			', '\n暂无\n			'),
(348, '0:2:6', '残羹冷炙', '\n【 cán　gēng　lěng　zhì 】\n			', '\n指吃剩的饭菜。也比喻别人施舍的东西。\n			', '\n唐·杜甫《奉赠韦左丞丈》：“残杯与冷炙，到处潜悲辛。”\n			', '\n做人不可攀结权贵，靠人施舍，以受～之辱。\n			'),
(349, '0:2:6', '打入冷宫', '\n【 dǎ　rù　lěng　gōng 】\n			', '\n打：与某些动词结合成为一个词，表示进行的意思；冷宫：古代皇帝把失宠的后妃软禁于冷僻宫内。比喻人不被重视或把事情搁置一边。\n			', '\n<span class="C999">暂无</span>\n			', '\n她已经被打入冷宫。\n			'),
(350, '0:2:6', '放冷箭', '\n【 fàng　lěng　jiàn 】\n			', '\n乘人不备，放箭伤人。比喻暗中伤人。冷箭：暗箭。\n			', '\n鲁迅《无花的蔷薇》：“我对于‘放冷箭’的解释，颇有些和他们一流不同，是说有人受伤，而不知这箭从什么地方射出。”\n			', '\n暂无\n			'),
(351, '0:2:6', '龟冷支床', '\n【 guī　lěng　zhī　chuáng 】\n			', '\n比喻壮志未酬，蛰居待时。\n			', '\n《史记·龟策列传褚少孙论》：“南方老人用龟支床足，行二十余岁，老人死，移床，龟尚生不死。”\n			', '\n暂无\n			'),
(352, '0:2:6', '龟冷搘床', '\n【 guī　lěng　zhī　chuáng 】\n			', '\n比喻壮志未酬，蛰居待时。\n			', '\n西汉·司马迁《史记·龟策列传褚少孙论》：“南方老人用龟支床足，行二十余岁，老人死，移床，龟尚生不死。”\n			', '\n骥衰伏枥心千里，～寿百年。\n			'),
(353, '0:2:6', '火尽灰冷', '\n【 huǒ　jìn　huī　lěng 】\n			', '\n比喻权势消失。\n			', '\n五代·王仁裕《开元天宝遗事·向火乞儿》：“今时之朝彦，皆是向火乞儿，一日火尽灰冷，暖气何在？当冻尸裂体、弃骨沟睿中，祸不远矣。”\n			', '\n暂无\n			'),
(354, '0:2:6', '忽冷忽热', '\n【 hū　lěng　hū　rè 】\n			', '\n指时而冷静，时而感情冲动，情绪不稳定。\n			', '\n鲁迅《而已集·读书杂谈》：“研究是要用理智，要冷静的，而创作须情感，至少总得发点热，于是忽冷忽热，弄得头昏。”\n			', '\n暂无\n			'),
(355, '0:2:6', '横眉冷目', '\n【 héng　méi　lěng　mù 】\n			', '\n愤怒、轻蔑的样子。同“横眉冷眼”。\n			', '\n郭澄清《大刀记》第十三章：“现在他又横眉冷目地喝了一声‘走’，更把个张温吓没了真魂。”\n			', '\n暂无\n			'),
(356, '0:2:6', '横眉冷眼', '\n【 héng　méi　lěng　yǎn 】\n			', '\n愤怒、轻蔑的样子。\n			', '\n李季《周总理啊，大庆儿女想念你》诗：“横眉冷眼不怕鬼，心红胆壮看咱们谁怕谁？”\n			', '\n暂无\n			'),
(357, '0:2:6', '尖言冷语', '\n【 jiān　yán　lěng　yǔ 】\n			', '\n指言语尖刻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(358, '0:2:6', '坑灰未冷', '\n【 kēng　huī　wèi　lěng 】\n			', '\n比喻时间极为短暂、匆促。\n			', '\n唐·章碣·《焚书坑》诗：“坑灰未冷山东乱，刘、项原来不读书。”\n			', '\n暂无\n			'),
(359, '0:2:6', '冷窗冻壁', '\n【 lěng　chuāng　dòng　bì 】\n			', '\n形容贫寒。\n			', '\n宋·陈师道《谢赵使君送乌薪》诗：“老身曲直不足言，冷窗冻壁作春温。”宋·杨万里《除夕前一日归舟夜泊曲涡市宿治平寺》诗：“冷窗冻壁更成眠？也腾疏蓬仰见天！”\n			', '\n暂无\n			'),
(360, '0:2:6', '冷嘲热讽', '\n【 lěng　cháo　rè　fěng 】\n			', '\n用尖刻辛辣的语言进行讥笑和讽刺。\n			', '\n<span class="C999">暂无</span>\n			', '\n见了老徐，说了几句～的话儿。（蔡东藩、许廑父《民国通俗演义》第一一六回）\n			'),
(361, '0:2:6', '冷嘲热骂', '\n【 lěng　cháo　rè　mà 】\n			', '\n尖刻的嘲笑和谩骂。\n			', '\n郭沫若《反正前后》第一篇：“他一进一出要受学生们的冷嘲热骂，然而也不能不忍耐着装聋卖哑。”\n			', '\n暂无\n			'),
(362, '0:2:6', '冷锅里爆豆', '\n【 lěng　guō　lǐ　bào　dòu 】\n			', '\n比喻本已平息的纠纷，口舌等忽然又发作起来。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(363, '0:2:6', '冷灰爆豆', '\n【 lěng　huī　bào　dòu 】\n			', '\n在冷灰中爆豆。比喻方法不对，白费力气。或比喻事情凭空突然发生。亦作“冷锅中豆爆”。\n			', '\n宋·黄庭坚《翠岩真禅师语录序》：“各梦同床，不妨殊调；冷灰爆豆，聊为解嘲云耳。”\n			', '\n暂无\n			'),
(364, '0:2:6', '冷酷无情', '\n【 lěng　kù　wú　qíng 】\n			', '\n冷漠苛刻，没有感情。\n			', '\n老舍《一封家信》：“看明白了大部分的字，都是责难他的！她的形影与一切都消逝了，他眼前只是那张死板板的字，与一些冷酷无情的字！”\n			', '\n斤澜反映现实生活，有时像不是用笔，而是用解剖刀。在给人以深刻感的同时，也带来一些～的压抑感。\n			'),
(365, '0:2:6', '冷面寒铁', '\n【 lěng　miàn　hán　tiě 】\n			', '\n比喻公正廉洁，不怕权贵的官员。\n			', '\n《明史·周新传》：“敢言词多所弹颏，贵戚震惧，目为冷面寒铁。”\n			', '\n暂无\n			'),
(366, '0:2:6', '冷暖自知', '\n【 lěng　nuǎn　zì　zhī 】\n			', '\n水的冷暖，饮者自知。佛教禅宗用以比喻自己证悟的境界。也比喻学习心得深浅，只有自己知道。\n			', '\n唐·善无畏《大日经疏》卷十二：“如饮水者，冷热自知。”\n			', '\n今蒙指授入处，如人饮水，～。今行者即是某人师也。（宋·释道原《景德传灯录》卷四）\n			'),
(367, '0:2:6', '冷若冰霜', '\n【 lěng　ruò　bīng　shuāng 】\n			', '\n冷得象冰霜一样。比喻待人接物毫无感情，象冰霜一样冷。也比喻态度严正，不可接近。\n			', '\n元·王实甫《西厢记》第一本第二折：“俺老夫人治家严肃，凛若冰霜。”\n			', '\n笑起来一双眼又秀又媚，却是不笑起来又～。（清·刘鹗《老残游记·续集》第二回）\n			'),
(368, '0:2:6', '令人齿冷', '\n【 lìng　rén　chǐ　lěng 】\n			', '\n齿冷：耻笑。比喻使人瞧不起。\n			', '\n《南史·乐预传》：“人笑禇公，至今齿冷。”\n			', '\n本朝人演本朝事，而颠倒纰缪至此，殊～。（鲁迅《小说旧闻钞·杂说》）\n			'),
(369, '0:2:6', '冷水浇背', '\n【 lěng　shuǐ　jiāo　bèi 】\n			', '\n冷水从背上浇下来。比喻因突然遭受意外的打击或刺激，思想为之一震或希望为之幻灭。亦作“冷水浇头”。\n			', '\n清·吴趼人《二十年目睹之怪现状》第六十五回：“红玉听了，总如冷水浇背一般，唇也青了，面也白了，做声不得。”\n			', '\n自辰入见，及戌始退，～，当头一棒，一旦尽失其故垒，惘惘然不知所从事，且惊且喜，且怨且艾，且疑且惧，与通甫联床竟夕不能寐。\n			'),
(370, '0:2:6', '冷水浇头', '\n【 lěng　shuǐ　jiāo　tóu 】\n			', '\n冷水从背上浇下来。比喻因突然遭受意外的打击或刺激，思想为之一震或希望为之幻灭。同“冷水浇背”。\n			', '\n清·丁耀亢《续金瓶梅》第四十三回：“忽然听得说太太来了，好一似——天雷霹雳，冷水浇头。”\n			', '\n他一看，像一瓢～，不禁浑身一颤，颓然靠在椅背上。\n			'),
(371, '0:2:6', '冷血动物', '\n【 lěng　xuè　dòng　wù 】\n			', '\n体温随环境温度的改变而变化的动物。比喻缺乏感情、对人对事冷漠的人。\n			', '\n钱钟书《围城》：“李先生本来像冬蛰的冷血动物，给顾先生当众恭维得春气入身，蠕蠕欲活。”\n			', '\n暂无\n			'),
(372, '0:2:6', '冷心冷面', '\n【 lěng　xīn　lěng　miàn 】\n			', '\n态度冷淡，对人没有感情。\n			', '\n清·曹雪芹《红楼梦》第六十六回：“妾痴情待君五年，不期君果‘冷心冷面’，妾以死报此痴情。”\n			', '\n况且听他那番～，早同枯木死灰，把生死关头看破，这大事已完，还有甚的依恋？\n			'),
(373, '0:2:6', '冷语冰人', '\n【 lěng　yǔ　bīng　rén 】\n			', '\n用冷酷的话伤人。\n			', '\n宋·曾造《类说·〈外史梼杌〉》：“潘柱迎，孟蜀时，以财结权要，或戒之，乃日：‘非是求愿，不欲以冷语冰人耳。’”\n			', '\n暂无\n			'),
(374, '0:2:6', '冷眼静看', '\n【 lěng　yǎn　jìng　kàn 】\n			', '\n形容从旁冷静而仔细地观察。\n			', '\n唐·徐夤《上卢三拾遗以言见黜》：“疾危必厌神明药，心惑多嫌正直言，冷眼静看真可笑，倾怀与说却为冤。”\n			', '\n暂无\n			'),
(375, '0:2:6', '冷言冷语', '\n【 lěng　yán　lěng　yǔ 】\n			', '\n带讥讽的冷冰冰的话。\n			', '\n《宝林禅师语录》：“山门疏：关着门，尽是自家屋里，何须冷言冷语，暗地敲人？”明·冯梦龙《醒世恒言》卷三十七：“只这冷言冷语，带讥带讪的，教人怎么当得！”\n			', '\n朱老忠一问，严志和又火呛起来，～说：“那谁又知道呢？”（梁斌《红旗谱》三十六）\n			'),
(376, '0:2:6', '冷眼旁观', '\n【 lěng　yǎn　páng　guān 】\n			', '\n指不参与其事，站在一旁看事情的发展。\n			', '\n宋·朱嘉《朱文公文集续集·一·答黄直卿》：“故其后复申炎所陈，荐举之说，乃是首尾专为王地，冷眼旁观，手足俱露，甚可笑也。”\n			', '\n诗云：“一局输赢料不真，香销茶尽尚逡巡。欲知目下兴衰兆，顺问傍观冷眼人。”（《脂砚斋评红楼梦》第二回）\n			'),
(377, '0:2:6', '冷言热语', '\n【 lěng　yán　rè　yǔ 】\n			', '\n犹冷言冷语。带讥讽意味的冷冰冰的话。\n			', '\n明·冯梦龙《警世通言》第二十四卷：“三官说：‘欲待回家，难见父母兄嫂；待不去，又受不得亡八冷言热语。’”\n			', '\n妇人心肠褊窄浅露，便把晋王好，太子歹，一齐搬将出来。杨素又加上些～。\n			'),
(378, '0:2:6', '冷眼相待', '\n【 lěng　yǎn　xiāng　dài 】\n			', '\n用冷淡的态度接待。比喻不欢迎或看不起。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(379, '0:2:6', '泼冷水', '\n【 pō　lěng　shuǐ 】\n			', '\n比喻挫伤别人的热情或兴致。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(380, '0:2:6', '凄风冷雨', '\n【 qī　fēng　lěng　yǔ 】\n			', '\n凄风：寒冷的风；冷雨：冰冷的雨。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n时遇秋天，怎当那～，过雁吟虫，眼前景物，无一件不是牵愁触闷的。\n			'),
(381, '0:2:6', '清锅冷灶', '\n【 qīng　guō　lěng　zào 】\n			', '\n没吃没喝。常用以形容贫困冷清的景象。同“清灰冷灶”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(382, '0:2:6', '清灰冷火', '\n【 qīng　huī　lěng　huǒ 】\n			', '\n没吃没喝。常用以形容贫困冷清的景象。同“清灰冷灶”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(383, '0:2:6', '清灰冷灶', '\n【 qīng　huī　lěng　zào 】\n			', '\n没吃没喝。常用以形容贫困冷清的景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(384, '0:2:6', '衾寒枕冷', '\n【 qīn　hán　zhěn　lěng 】\n			', '\n衾：被子。被枕俱冷。形容独眠的孤寂凄凉。\n			', '\n宋·柳永《爪茉莉（秋夜）》：“衾寒枕冷，夜迢迢、更无寐。”明·高明《琵琶记》第五出：“［旦］奴不虑衾寒枕冷；奴只虑公婆没主一旦冷清清。”\n			', '\n却说唐长老师徒四人，歇在陈家。将近天晓，师徒们～。\n			'),
(385, '0:2:6', '人情冷暖', '\n【 rén　qíng　lěng　nuǎn 】\n			', '\n人情：指社会上的人情世故；冷：冷淡；暖：亲热。泛指人情的变化。指在别人得势时就奉承巴结，失势时就不理不睬。\n			', '\n唐·白居易《迁叟》诗：“冷暖俗情谙世路，是非闲论任交亲。”\n			', '\n节物后先南北异，～古今同。（宋·周密《齐东野语》卷十一）\n			'),
(386, '0:2:6', '如人饮水，冷暖自知', '\n【 rú　rén　yǐn　shuǐ，lěng　nuǎn　zì　zhī 】\n			', '\n泛指自己经历的事，自己知道甘苦。\n			', '\n宋·释道原《景德传灯录》：“某甲虽在黄梅随众，实未省自己面目。今蒙指受入处，如人饮水，冷暖自知，行者即是某甲师也。”\n			', '\n暂无\n			'),
(387, '0:2:6', '如鱼饮水，冷暖自知', '\n【 rú　yú　yǐn　shuǐ，lěng　nuǎn　zì　zhī 】\n			', '\n泛指自己经历的事，自己知道甘苦。同“如人饮水，冷暖自知”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(388, '0:2:6', '山寒水冷', '\n【 shān　hán　shuǐ　lěng 】\n			', '\n冷冷清清。形容冬天的景象。\n			', '\n宋·释普济《五灯会元》卷八：“秋至山寒水冷，春来柳绿花红。”\n			', '\n暂无\n			'),
(389, '0:2:6', '闲曹冷局', '\n【 xián　cáo　lěng　jú 】\n			', '\n无足轻重的清闲的官署。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(390, '0:2:6', '玄辞冷语', '\n【 xuán　cí　lěng　yǔ 】\n			', '\n玄妙冷隽的言辞。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(391, '0:2:6', '心灰意冷', '\n【 xīn　huī　yì　lěng 】\n			', '\n灰心失望，意志消沉。\n			', '\n明·吴承恩《西游记》第四十回：“因此上怪他每每不听我说，故我意懒心灰，说各人散了。”\n			', '\nL先生大为～，法西斯的气概顿然消失，披发入山去做和尚去了。（邹韬奋《患难余生记·流亡》）\n			'),
(392, '0:2:6', '闲言冷语', '\n【 xián　yán　lěng　yǔ 】\n			', '\n没有根据的讥刺他人的话。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(393, '0:2:6', '余杯冷炙', '\n【 yú　bēi　lěng　zhì 】\n			', '\n指吃剩下来的酒食。\n			', '\n明·汤显祖《牡丹亭·寻梦》：“受用余杯冷炙，胜如剩粉残膏。”\n			', '\n暂无\n			'),
(394, '0:2:6', '艳如桃李，冷若冰霜', '\n【 yàn　ruò　táo　lǐ，lěng　ruò　bīng　shuāng 】\n			', '\n形容女子容貌艳丽而态度严肃。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(395, '0:2:6', '坐冷板凳', '\n【 zuò　lěng　bǎn　dèng 】\n			', '\n比喻因不受重视而担任清闲的职务。也比喻长期等候工作或长久地等待接见。\n			', '\n<span class="C999">暂无</span>\n			', '\n昨天慈圣召见，特别提到，说“只要我一天管事，决不会让李某人～。”（高阳《胭脂井》）\n			'),
(396, '0:2:6', '枕冷衾寒', '\n【 zhěn　lěng　qīn　hán 】\n			', '\n枕被俱冷。形容独眠的孤寂凄凉。\n			', '\n元·王实甫《西厢记》第四本第四折：“便枕冷衾寒，凤只鸾孤，月圆云遮，寻思来有甚伤嗟。”\n			', '\n我敢一上青山便化身，从今年内后～，索自温存。\n			'),
(397, '0:2:7', '熬油费火', '\n【 áo　yóu　fèi　huǒ 】\n			', '\n指耗费灯油。多指日夜忙碌。\n			', '\n《红楼梦》第二五回：“此时贾赦、贾政又恐哭坏了贾母，日夜熬油费火，闹得上下不安。”\n			', '\n暂无\n			'),
(398, '0:2:7', '不避水火', '\n【 bù　bì　shuǐ　huǒ 】\n			', '\n指不畏凶险。\n			', '\n《水浒传》第五八回：“贤弟心中有何危厄不决之难，但请尽说不妨，便当不避水火，力为解救，与汝相助。”\n			', '\n暂无\n			'),
(399, '0:2:7', '鼻端出火', '\n【 bí　duān　chū　huǒ 】\n			', '\n形容意气风发；情绪激昂。\n			', '\n见“鼻头出火”。\n			', '\n写少时豪侠，有～之概。\n			'),
(400, '0:2:7', '鼻端生火', '\n【 bí　duān　shēng　huǒ 】\n			', '\n以之形容马行疾速。\n			', '\n语出《南史·曹景宗传》：“我昔在乡里，骑快马如龙……觉耳后生风，鼻头出火。”\n			', '\n西家骁骑绕如龙，～耳生风。\n			'),
(401, '0:2:7', '抱火厝薪', '\n【 bào　huǒ　cuò　xīn 】\n			', '\n厝：同“措”，置放。薪：柴火。把火放在柴草底下。比喻危机即将出现。\n			', '\n语出《汉书·贾谊传》：“夫抱火厝之积薪之下而寝其上，火未及燃，因谓之安，方今之势，何以异此？”\n			', '\n汉文之世，九州晏然，贾谊独以为如抱火厝于积薪之下而寝其上。\n			'),
(402, '0:2:7', '抱火寝薪', '\n【 bào　huǒ　qǐn　xīn 】\n			', '\n抱火：捧着火种；寝薪：睡在柴草堆上。比喻危机潜伏，人安于险境而不自知。也比喻危机即将出现。\n			', '\n汉·贾谊《上陈政事疏》：“夫抱火厝之积薪之下，而寝其上，火未及燃，因谓之安。”\n			', '\n暂无\n			'),
(403, '0:2:7', '炳如观火', '\n【 bǐng　rú　guān　huǒ 】\n			', '\n炳：光明、明亮、显著。形容看得清楚明白。\n			', '\n鲁迅《坟·文化偏至论》：“其词秩然有条，各分大义，炳如观火。”\n			', '\n暂无\n			'),
(404, '0:2:7', '炳若观火', '\n【 bǐng　ruò　guān　huǒ 】\n			', '\n形容看得清楚明白。\n			', '\n梁启超《欧洲地埋大势论》：“人民之职业物产之制造，种种殊异之处，则如网在纲，炳若观火。”\n			', '\n暂无\n			'),
(405, '0:2:7', '不食烟火', '\n【 bù　shí　yān　huǒ 】\n			', '\n①指不吃熟食。道家修炼主张绝粒却谷，不吃世间烟火物。②指诗文立意高超，言词清丽，不同凡俗。\n			', '\n《终有报》第一回：“人都道他不食烟火，体气欲仙。”\n			', '\n此诗不独敏捷异常，且字字清新俊逸，饶有别致，似～者，大与平日不同。\n			'),
(406, '0:2:7', '鼻头出火', '\n【 bí　tóu　chū　huǒ 】\n			', '\n形容意气风发；情绪激昂。\n			', '\n《南史·曹景宗传》：“我昔在乡里，骑快马如龙，与年少辈数十骑，拓弓弦作礔砺声，箭如饿鸱叫，平泽中逐獐，数肋射之，渴饮其血，饥食其脯，甜如甘露浆，觉耳后生风，鼻头出火，此乐使人忘死。”\n			', '\n暂无\n			'),
(407, '0:2:7', '传风扇火', '\n【 chuán　fēng　shān　huǒ 】\n			', '\n犹扇风点火。比喻鼓动别人做某种事。多用于贬义。\n			', '\n康濯《春种秋收·故事》：“这么传风扇火，直扇得玉翠她爹都受了传染——天天替女儿着急，时时埋怨女儿眼皮太高。”\n			', '\n暂无\n			'),
(408, '0:2:7', '传风搧火', '\n【 chuán　fēng　yǒu　huǒ 】\n			', '\n犹煽风点火。搧，同“扇”。比喻煽动别人闹事。多用于贬义。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(409, '0:2:7', '春风野火', '\n【 chūn　fēng　yě　huǒ 】\n			', '\n比喻迅猛之势。\n			', '\n左齐《南泥湾屯垦》；“劳动竞赛的热潮，像春风野火一样，迅速遍及整个工地。”\n			', '\n暂无\n			'),
(410, '0:2:7', '厝火燎原', '\n【 cuò　huǒ　liǎo　yuán 】\n			', '\n放火燎原，比喻小乱子酿成大祸患。\n			', '\n明·沈德符《野获编·兵部·西南诸捷》：“惟近日东北用兵，聚三大帅娄十万众，尽没辽水，坐成厝火燎原之势，差为不竞耳。”\n			', '\n暂无\n			'),
(411, '0:2:7', '大动肝火', '\n【 dà　dòng　gān　huǒ 】\n			', '\n指大怒。\n			', '\n<span class="C999">暂无</span>\n			', '\n见到不务正业的他，父亲一定大动肝火。\n			'),
(412, '0:2:7', '蹈赴汤火', '\n【 dǎo　fù　tāng　huǒ 】\n			', '\n比喻不避艰险。同“蹈汤赴火”。\n			', '\n唐·孙揆《灵应传》：“君子杀身以成仁，殉其毅烈，蹈赴汤火，旁雪不平，乃宝之志也。”\n			', '\n犬马之报，惟力是视，虽～所不辞。\n			'),
(413, '0:2:7', '刀耕火耘', '\n【 dāo　gēng　huǒ　yún 】\n			', '\n犹刀耕火种。\n			', '\n宋·苏轼《王公仪夔州路转运使程高夔州路判官制》：“三峡之民，刀耕火耘，与鹿豕杂居。”\n			', '\n暂无\n			'),
(414, '0:2:7', '蹈火赴汤', '\n【 dǎo　huǒ　fù　tāng 】\n			', '\n比喻不避艰险。\n			', '\n李瑛《深夜里发生的故事》诗：“五里远的山路，真正似蹈火赴汤。”\n			', '\n暂无\n			'),
(415, '0:2:7', '蹈火探汤', '\n【 dǎo　huǒ　tàn　tāng 】\n			', '\n比喻不避艰险。同“蹈汤赴火”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(416, '0:2:7', '灯火万家', '\n【 dēng　huǒ　wàn　jiā 】\n			', '\n家家都点上灯。指天黑上灯的时候。亦形容城镇夜晚的景象。\n			', '\n唐·白居易《江楼夕望招客》：“灯火万家城四畔，星河一道水中央。”\n			', '\n暂无\n			'),
(417, '0:2:7', '洞如观火', '\n【 dòng　rú　guān　huǒ 】\n			', '\n形容观察事物非常清楚，好象看火一样。同“洞若观火”。\n			', '\n清·刘献廷《广阳杂记》卷二：“得悉其山川险要部落游牧，暨其强弱多寡离合之情，皆洞如观火矣。”\n			', '\n暂无\n			'),
(418, '0:2:7', '蹈汤赴火', '\n【 dǎo　tāng　fù　huǒ 】\n			', '\n比喻不避艰险。\n			', '\n唐·赵元一《奉天录》卷三：“且须散金帛，犒师旅，使闻鼓而蹈汤赴火，闻金而星布云合。”\n			', '\n他张迪，官家的这条忠实走狗，～，也要去竭力办到。\n			'),
(419, '0:2:7', '反风灭火', '\n【 fǎn　fēng　miè　huǒ 】\n			', '\n比喻施行德政。\n			', '\n《后汉书·儒林传上·刘昆》：“诏问昆曰：‘前在江陵，反风灭火，后守弘农，虎北渡河，行何德政而致是事？’昆对曰：‘偶然耳。’左右皆笑其质讷。帝叹曰：‘此乃长者之言也。’”\n			', '\n但知私财不入，公事夙办，便云我能治民，不知诚己刑物，执辔如组，～，化鸱为凤之术也。\n			'),
(420, '0:2:7', '烽火连年', '\n【 fēng　huò　lián　nián 】\n			', '\n烽火：古时边防报警的烟火。比喻战火或战争。指战火连年不断。\n			', '\n元·戴良《九灵山房集·二四·登大牢山》：“那堪回首东南地，烽火连年警报闻。”\n			', '\n暂无\n			'),
(421, '0:2:7', '烽火四起', '\n【 fēng　huǒ　sì　qǐ 】\n			', '\n战争的火焰从四面八方燃烧起来。形容边防不安宁，四处有敌人进犯。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(422, '0:2:7', '烽火相连', '\n【 fēng　huǒ　xiāng　lián 】\n			', '\n烽火：古代边防报警的烟火。指边防常抓不懈，比喻战火不断。\n			', '\n汉·荀悦《汉纪·宣帝纪三》：“部曲相保，堑垒木樵，便兵饰弩，烽火相连。”\n			', '\n临歧分别，一旦恩情成断裂；～，雁帖鱼书谁与传。\n			'),
(423, '0:2:7', '忿火中烧', '\n【 fèn　huǒ　zhōng　shāo 】\n			', '\n犹言怒火中烧。\n			', '\n清·蒲松龄《聊斋志异·张鸿渐》：“甲词益狎逼。张忿火中烧，反刀直出，剁甲中颅。”\n			', '\n暂无\n			'),
(424, '0:2:7', '风雷火炮', '\n【 fēng　léi　huǒ　pào 】\n			', '\n形容十分急躁。\n			', '\n清·吴研人《二十年目睹之怪现状》第五十二回：“上前天我们才到上海，货还没有起完，到了半夜里，忽然宪太太来了，风雷火炮的一阵，马上就要开船，脸上很带点怒色。”\n			', '\n暂无\n			'),
(425, '0:2:7', '赴汤蹈火', '\n【 fù　tāng　dǎo　huǒ 】\n			', '\n赴：走往；汤：热水；蹈：踩。沸水敢蹚，烈火敢踏。比喻不避艰险，奋勇向前。\n			', '\n《汉书·晁错传》：“故能使其众，蒙矢石，赴汤火。”晋·稽康《与山巨源绝交书》：“长而见羁，则狂顾顿缨，赴汤蹈火。”\n			', '\n有三个人，义胆包身，武艺出众，敢～，同死同生。（明·施耐庵《水浒全传》第十五回）\n			'),
(426, '0:2:7', '负薪救火', '\n【 fù　xīn　jiù　huǒ 】\n			', '\n背着柴草去救火。比喻用错误的方法去消除灾祸，结果使灾祸反而扩大。\n			', '\n《韩非子·有度》：“其国乱弱矣，又皆释国法而私其外，则是负薪而救火也，乱弱甚矣。”《史记·魏世家》：“譬犹抱薪救火，薪不尽，火不灭。”\n			', '\n若听诸葛亮之言，妄动甲兵，此所谓～也。（明·罗贯中《三国演义》第四十三回）\n			'),
(427, '0:2:7', '隔岸观火', '\n【 gé　àn　guān　huǒ 】\n			', '\n隔着河看人家着火。比喻对别人的危难不去求助，在一旁看热闹。\n			', '\n唐·乾康《投谒齐已》：“隔岸红尘忙似火，当轩青嶂冷如冰。”\n			', '\n他原是在～呀。（郭沫若《南冠草》第二幕）\n			'),
(428, '0:2:7', '干柴烈火', '\n【 gān　chái　liè　huǒ 】\n			', '\n形容男女之间强烈情欲要求，多用于不正当的男女关系。也形容情绪高涨。\n			', '\n明·周楫《西湖二集·侠女散财殉节》：“这烈火干柴怎得瞒。”\n			', '\n真是一对烈火干柴，如胶如漆，燕尔新婚，连日那里拆得开。（清·曹雪芹《红楼梦》第六十九回）\n			'),
(429, '0:2:7', '篝火狐鸣', '\n【 gōu　huǒ　hú　míng 】\n			', '\n夜里把火放在笼里，使隐隐约约象磷火，同时又学狐叫。这是陈涉、吴广假托狐鬼之事以发动群众起义的故事。后用来比喻策划起义。\n			', '\n《史记·陈涉世家》：“又间令吴广之次所旁丛祠中，夜篝火，狐鸣呼曰：‘大楚兴，陈胜王。’”\n			', '\n暂无\n			'),
(430, '0:2:7', '膏火之费', '\n【 gāo　huǒ　zhī　fèi 】\n			', '\n膏：点灯的油；膏火：灯火。借指求学的费用。\n			', '\n清·霁园主人《夜谭随录》：“欲登第须理旧业读书，欲读书须膏火之费，吾视君皆未易办也。”\n			', '\n暂无\n			'),
(431, '0:2:7', '黑灯瞎火', '\n【 hēi　dēng　xiā　huǒ 】\n			', '\n形容黑暗没有灯光。\n			', '\n<span class="C999">暂无</span>\n			', '\n老二，这是怎么回事，～的把我找来。（老舍《神拳》第二幕）\n			'),
(432, '0:2:7', '黑灯下火', '\n【 hēi　dēng　xià　huǒ 】\n			', '\n形容黑暗没有灯光的情景。\n			', '\n老舍《骆驼样子》十二：“你始终也没进去。黑灯下火的教鞭教我和太太瞎抓。”\n			', '\n下地做话，～走回来，一进门，有饭吃，一拎壶，有水渴。\n			'),
(433, '0:2:7', '火耕水耨', '\n【 huǒ　gēng　shuǐ　nòu 】\n			', '\n耨：除草。古代一种原始耕种方式。\n			', '\n《史记·平淮书》：“江南火耕水耨，令饥民得流就食江淮间，欲留，留处。”\n			', '\n诸欲修水田者，皆以～为便。（《晋书·食货志》）\n			'),
(434, '0:2:7', '火耕水种', '\n【 huǒ　gēng　shuǐ　zhòng 】\n			', '\n耨：除草。古代一种原始耕种方式。\n			', '\n《史记·平准书》：“江南火耕水耨，令饥民得流就食江淮间，欲留，留处。”晋·陆云《答车茂安书》：“遏长川以为陂，燔茂草以为田，火耕水种，不烦人力。”\n			', '\n暂无\n			'),
(435, '0:2:7', '火光烛天', '\n【 huǒ　guāng　zhú　tiān 】\n			', '\n火光把天都照亮了。形容火势极大（多指火灾）。\n			', '\n明·张岱《海志》：“火光烛天，海水如沸，此来得见海战，尤奇。”\n			', '\n城里到处～，枪炮齐响，有钱的人纷纷逃难，穷若的人民水断粮绝。（老舍《吐了一口气》）\n			'),
(436, '0:2:7', '火海刀山', '\n【 huǒ　hǎi　dāo　shān 】\n			', '\n比喻极其危险和困难的地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n～无所惧，艰难困苦炼英雄。\n			'),
(437, '0:2:7', '火急火燎', '\n【 huǒ　jí　huǒ　liǎo 】\n			', '\n犹火烧火燎。\n			', '\n《人民文学》1977年4期：“整个发电厂都火急火燎地动员起来。”\n			', '\n暂无\n			'),
(438, '0:2:7', '火尽灰冷', '\n【 huǒ　jìn　huī　lěng 】\n			', '\n比喻权势消失。\n			', '\n五代·王仁裕《开元天宝遗事·向火乞儿》：“今时之朝彦，皆是向火乞儿，一日火尽灰冷，暖气何在？当冻尸裂体、弃骨沟睿中，祸不远矣。”\n			', '\n暂无\n			'),
(439, '0:2:7', '火尽薪传', '\n【 huǒ　jìn　xīn　chuán 】\n			', '\n火虽烧完，柴却留传下来。比喻思想、学术、技艺等世代相传。\n			', '\n明·寓山居士《鱼儿佛》第四出：“仗猛力精心，斩断牵缠，若不是粉碎虚空，终似那痴拳太软，总火尽薪传也。”\n			', '\n暂无\n			'),
(440, '0:2:7', '火龙黼黻', '\n【 huǒ　lóng　fǔ　fú 】\n			', '\n原指火形和龙形的文彩，后用以比喻作文只知雕章琢句，犹如补缀百家之衣。\n			', '\n《左传·桓公二年》：“火龙黼黻，昭其文也。”\n			', '\n文章最忌百家衣，～世不知。\n			'),
(441, '0:2:7', '狐鸣篝火', '\n【 hú　míng　gōu　huǒ 】\n			', '\n指起事者动员群众的措施。同“狐鸣鱼书”。\n			', '\n黄葆桢《扬哲商烈士悼歌》：“军储潜遣五丁运，狐鸣篝火期相从。”\n			', '\n暂无\n			'),
(442, '0:2:7', '火冒三尺', '\n【 huǒ　mào　sān　chǐ 】\n			', '\n形容愤怒到极点。同“火冒三丈”。\n			', '\n姚雪垠《李自成 》第一卷第十五章：“当自成在路上才得到报告时，他不禁火冒三尺，恨恨地骂了一声：‘该死！’”\n			', '\n却说孙定邦在大雨里寻找史更新，找了多半宿也没见个影子，急得他真是～，手脚无措。\n			'),
(443, '0:2:7', '火冒三丈', '\n【 huǒ　mào　sān　zhàng 】\n			', '\n形容愤怒到极点。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(444, '0:2:7', '火灭烟消', '\n【 huǒ　miè　yān　xiāo 】\n			', '\n火苗熄灭，烟云消散。比喻事物消失净尽，不留一点痕迹。亦作“烟消火灭”。\n			', '\n晋·傅玄《四言杂诗》：“忽然长逝，火灭烟消。”\n			', '\n暂无\n			'),
(445, '0:2:7', '火耨刀耕', '\n【 huǒ　nòu　dāo　gēng 】\n			', '\n犹火耕。多指比较原始的耕作方法。\n			', '\n唐·罗隱《别池阳所居》诗：“黄尘初起此留连，火耨刀耕六七年。”\n			', '\n暂无\n			'),
(446, '0:2:7', '火妻灰子', '\n【 huǒ　qī　huī　zǐ 】\n			', '\n焚妻灭子。指毁弃家室。\n			', '\n汉·杨雄《法言·渊骞》：“离（要离）也，火妻灰子，以求反于庆忌，实蛛蝥之劘也，焉可谓之义也？”李轨注：“离，山平人，而焚烧妻子，诈为吴雠，求信于庆忌，反而刺之。”\n			', '\n暂无\n			'),
(447, '0:2:7', '火然泉达', '\n【 huǒ　rán　quán　dá 】\n			', '\n比喻形势发展迅猛。\n			', '\n《孟子·公孙丑上》：“凡有四端于我者，知皆扩而充之矣，若火之始然，泉之始达。”\n			', '\n暂无\n			'),
(448, '0:2:7', '火热水深', '\n【 huǒ　rè　shuǐ　shēn 】\n			', '\n①犹水深火热。比喻十分困苦的处境。②形容严酷；厉害。\n			', '\n清·魏秀仁《花月痕》第五十回：“我算什么，明相国不动声色，却出斯民于火热水深，措天下于泰山磐石。”\n			', '\n法兰西革命之时，上自王家，下至贵族僧侣，蹂躏平民，无所弗至，其法之力，可谓～矣。\n			'),
(449, '0:2:7', '火伞高张', '\n【 huǒ　sǎn　gāo　zhāng 】\n			', '\n火伞：比喻夏天太阳酪烈；张：展开。形容夏天烈日当空，十分炎热。\n			', '\n唐·韩愈《游青龙寺赠崔太补阙》诗：“光华闪壁见神鬼，赫赫炎官张火伞。”\n			', '\n暂无\n			'),
(450, '0:2:7', '火上浇油', '\n【 huǒ　shàng　jiāo　yóu 】\n			', '\n往火上倒油。比喻使人更加愤怒或使情况更加严重。\n			', '\n元·关汉卿《金线池》第二折：“我见了他扑邓邓火上浇油。”\n			', '\n这么一来，大家的情绪就象～似的。\n			'),
(451, '0:2:7', '火上加油', '\n【 huǒ　shàng　jiā　yóu 】\n			', '\n在一旁助威增加他人的愤怒或助长事态的发展。\n			', '\n清·李宝嘉《官场现形记》第五回：“三荷包也不睬他，把他气得越发火上加油了。”\n			', '\n这是一个重要的西洋古典，主上不懂得运用，而公开的说出‘自由民治’的真面目，那就一定要～的更激起匪徒的暴乱的。\n			'),
(452, '0:2:7', '火烧眉毛', '\n【 huǒ　shāo　méi　máo 】\n			', '\n火烧到眉毛。比喻事到眼前，非常急迫。\n			', '\n宋·释普济《五灯会元》卷十六：“问：‘如何是急切一句？’诗曰：‘火烧眉毛。’”\n			', '\n～，且顾眼前。（清·李汝珍《镜花缘》第三十五回）\n			'),
(453, '0:2:7', '火上弄冰', '\n【 huǒ　shàng　nòng　bīng 】\n			', '\n比喻一下子消失净尽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(454, '0:2:7', '火树琪花', '\n【 huǒ　shù　qí　huā 】\n			', '\n比喻灿烂的灯火或焰火。\n			', '\n清·曹雪芹《红楼梦》第十七回：“于是进入行宫，只见庭燎绕空，香屑布地，火树琪花，金窗玉槛。”\n			', '\n暂无\n			'),
(455, '0:2:7', '火山汤海', '\n【 huǒ　shān　tāng　hǎi 】\n			', '\n比喻艰难危险。\n			', '\n《晋书·张骏传》：“虽有火山汤海，无所辞难，岂寒暑之足避哉！”\n			', '\n暂无\n			'),
(456, '0:2:7', '火上添油', '\n【 huǒ　shàng　tiān　yóu 】\n			', '\n比喻使人更加愤怒或使情况更加严重。同“火上浇油”。\n			', '\n清·李宝嘉《官场现形记》第二十三回：“贾臬台见他顶嘴，如火上添油，那气格外来的大。”\n			', '\n他放下笔，头疲倦地倒在枕上。炎热增加他的痛苦。喧哗更象在～。\n			'),
(457, '0:2:7', '火树银花', '\n【 huǒ　shù　yín　huā 】\n			', '\n火树：火红的树，指树上挂满灯彩；银花：银白色的花，指灯光雪亮。形容张灯结彩或大放焰火的灿烂夜景。\n			', '\n唐·苏味道《正月十五夜》诗：“火树银花合，尽桥铁锁开。”\n			', '\n～不夜天，弟兄姐妹舞翩跹，歌声唱彻月儿圆。（柳亚子《浣溪沙》词）\n			'),
(458, '0:2:7', '火眼金睛', '\n【 huǒ　yǎn　jīn　jīng 】\n			', '\n原指《西游记》中孙悟空能识别妖魔鬼怪的眼睛。后用以形容人的眼光锐利，能够识别真伪。\n			', '\n元·杨景贤《西游记杂剧》第三本第九出：“这厮瞒神唬鬼，铜筋铁骨，火眼金睛。”\n			', '\n只是风搅得烟来，把一双眼炒红了，弄做个老害眼病，故唤作～。（明·吴承恩《西游记》第七回）\n			'),
(459, '0:2:7', '火中取栗', '\n【 huǒ　zhōng　qǔ　lì 】\n			', '\n比喻受人利用，冒险出力却一无所得。\n			', '\n十七世纪法国寓言诗人拉·封丹的寓言《猴子与猫》载：猴子骗猫取火中栗子，栗子让猴子吃了，猫却把脚上的毛烧掉了。\n			', '\n我们目前自顾不暇，郑成功不来就是天主保佑了，我们还好去惹他么。我们不能为别人～。（郭沫若《郑成功》第五章）\n			'),
(460, '0:2:7', '火烛小心', '\n【 huǒ　zhú　xiǎo　xīn 】\n			', '\n火烛：泛指能起火的东西。原指谨防失火。亦泛指处事小心谨慎。\n			', '\n清·邗上蒙人《风月梦》第十回：“你点火把送贾老爷回府，你就家去罢。家中门户火烛小心。”\n			', '\n你悄悄跟老张去说，叫他去找‘主顾’，要有钱人家的子弟，肚子里‘～’而急于想中举的；每一个六千银子，另加两成小费。\n			'),
(461, '0:2:7', '火烛银花', '\n【 huǒ　zhú　yín　huā 】\n			', '\n犹火树银花。形容张灯结彩或大放焰火的灿烂夜景。\n			', '\n宋·朱淑真《元夜》诗之三：“火烛银花触目红，揭天鼓吹闹东风。”\n			', '\n暂无\n			'),
(462, '0:2:7', '饥火烧肠', '\n【 jī　huǒ　shāo　cháng 】\n			', '\n形容饥饿难忍。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(463, '0:2:7', '救火投薪', '\n【 jiù　huò　tóu　xīn 】\n			', '\n为了扑灭火焰而将木柴扔进火中。比喻采取错误的办法，不但解决不了问题，反而会使问题变得更加严重。\n			', '\n《邓析子·无厚篇》：“不治其本而务其末，譬如拯溺而硾之以石，救火而投之以薪。”\n			', '\n暂无\n			'),
(464, '0:2:7', '近火先焦', '\n【 jìn　huǒ　xiān　jiāo 】\n			', '\n比喻跟祸事最接近的人首先遭殃。\n			', '\n明·施耐庵《水浒全传》第四十九回：“常言道：‘近火先焦。’伯伯便替我们吃官司坐牢，那时又没人送饭来救你。”\n			', '\n暂无\n			'),
(465, '0:2:7', '救火扬沸', '\n【 jiù　huǒ　yáng　fèi 】\n			', '\n沸：开水。比喻不从根本上解决问题。也形容情况危急。\n			', '\n《史记·酷吏列传》：“当是之时，吏治若救火扬沸。”\n			', '\n暂无\n			'),
(466, '0:2:7', '救火拯溺', '\n【 jiù　huǒ　zhěng　nì 】\n			', '\n形容紧急救助陷于困境中的人。同“救焚拯溺”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(467, '0:2:7', '交梨火枣', '\n【 jiāo　lí　huǒ　zǎo 】\n			', '\n道教经书中所说的“仙果”。\n			', '\n《真诰·运象二》：“玉醴金浆，交梨火枣，此则腾飞之药，不比于金丹也。”\n			', '\n暂无\n			'),
(468, '0:2:7', '救民于水火', '\n【 jiù　mín　yú　shuǐ　huǒ 】\n			', '\n把人民从深重的灾难中拯救出来。\n			', '\n《孟子·滕文公下》： “救民于水火之中，取其残而已矣。”\n			', '\n暂无\n			'),
(469, '0:2:7', '急如风火', '\n【 jí　rú　fēng　huǒ 】\n			', '\n急得像疾风烈火一样。形容十分急迫。\n			', '\n《西游补》第九回：“你要图成和议，急如风火，却如何等得这三日过呢？”\n			', '\n暂无\n			'),
(470, '0:2:7', '急如星火', '\n【 jí　rú　xīng　huǒ 】\n			', '\n星火：流星。象流星的光从空中急闪而过。形容非常急促紧迫。\n			', '\n晋·李密《陈情表》：“州司临门，急于星火。”\n			', '\n闺臣心内虽～，偏偏婉如同田凤翾的哥哥田廷结了婚姻。（清·李汝珍《镜花缘》第九十四回）\n			'),
(471, '0:2:7', '积薪厝火', '\n【 jī　xīn　cuò　huǒ 】\n			', '\n薪：柴草；厝：同：“措”，放置。把火放在柴堆下面。比喻隐藏着很大的危险，后患无穷。\n			', '\n《汉书·贾谊传》：“夫抱火厝之积薪之下而寝其上，火未及燃，因谓之安，方今之势，何以异此。”\n			', '\n暂无\n			'),
(472, '0:2:7', '绝薪止火', '\n【 jué　xīn　zhǐ　huǒ 】\n			', '\n绝：断绝；薪：柴草。断绝柴草，使火停止燃烧。比喻从根本上彻底解决问题。\n			', '\n《吕氏春秋·尽数》：“扬汤止沸，沸愈不止，去火则止矣。” 汉·枚乘《上书谏吴书》：“一人饮之，百人扬之，无益也，不如绝薪止火而已。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(473, '0:2:7', '解衣包火', '\n【 jiě　yī　bāo　huǒ 】\n			', '\n比喻不解决问题，只招致危险。\n			', '\n《资治通鉴·晋安帝义熙十三年》：“关中华戎杂错，风俗劲悍；裕欲以荆扬之化，施之函秦，此无异解衣包火，张罗捕虎。”\n			', '\n暂无\n			'),
(474, '0:2:7', '解衣抱火', '\n【 jiě　yī　bào　huǒ 】\n			', '\n比喻不解决问题，只招致危险。同“解衣包火”。\n			', '\n《资治通鉴·晋安帝义熙十三年》：“关中华戎杂错，风俗劲悍；裕欲以荆扬之化，施之函秦，此无异解衣包火，张罗捕虎。”清·唐训方《里语征实》卷下引作“解衣抱火”。\n			', '\n暂无\n			'),
(475, '0:2:7', '皎阳似火', '\n【 jiǎo　yáng　shì　huǒ 】\n			', '\n皎：白而亮。太阳像火一样燃烧。多形容夏日的炎热。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(476, '0:2:7', '急于星火', '\n【 jí　yú　xīng　huǒ 】\n			', '\n星火：流星。象流星的光从空中急闪而过。形容非常急促紧迫。\n			', '\n晋·李密《陈情表》：“州司临门，急于星火。”\n			', '\n暂无\n			'),
(477, '0:2:7', '井中求火', '\n【 jǐng　zhōng　qiú　huǒ 】\n			', '\n在水井里去寻求火。比喻方法或方向不对，根本达不到目的。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(478, '0:2:7', '烈火辨日', '\n【 liè　huǒ　biàn　rì 】\n			', '\n在烈火中能辨别玉的好坏。比喻在关键时刻能看出一个人的节操。\n			', '\n守朝叶廷圭《海录碎事·人事》：“烈火辨玉，疾风知草。”\n			', '\n暂无\n			'),
(479, '0:2:7', '炉火纯青', '\n【 lú　huǒ　chún　qīng 】\n			', '\n道士炼丹，认为炼到炉里发出纯青色的火焰就算成功了。后用来比喻功夫达到了纯熟完美的境界。\n			', '\n清·曾朴《孽海花》第二十五回：“到了现在，可已到了炉火纯青的气候，正是弟兄们各显身手的时期。”\n			', '\n他的棋艺精深，可以说已达到～的地步。\n			'),
(480, '0:2:7', '烈火轰雷', '\n【 liè　huǒ　hōng　léi 】\n			', '\n形容性情暴躁，爱发脾气。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(481, '0:2:7', '烈火见真金', '\n【 liè　huǒ　jiàn　zhēn　jīn 】\n			', '\n真金是不怕烈火烧的，所以只有在烈火中才能鉴别出是不是真金。比喻在关键时刻最能考验人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(482, '0:2:7', '撩火加油', '\n【 liáo　huǒ　jiā　yóu 】\n			', '\n犹言火上加油。在一旁助威增加他人的愤怒或助长事态的发展。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(483, '0:2:7', '烈火烹油', '\n【 liè　huǒ　pēng　yóu 】\n			', '\n比喻声势气焰很盛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(484, '0:2:7', '燎若观火', '\n【 liáo　ruò　guān　huǒ 】\n			', '\n指事理清楚明白，如看火一般。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(485, '0:2:7', '履汤蹈火', '\n【 lǚ　tāng　dǎo　huǒ 】\n			', '\n身入汤火。比喻处苦难之境。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(486, '0:2:7', '连天烽火', '\n【 lián　tiān　fēng　huǒ 】\n			', '\n烽火：古时边防报警的烟火，比喻战火或战争。形容战火烧遍各地。\n			', '\n汉·蔡邕《蔡中郎集·外纪上·汉书十志疏》：“其时鲜卑连犯云中五原，一月之中烽火不绝，埃尘连天。”\n			', '\n无限伤心劫后话，～独思君。（李大钊《南天动乱·适将去国，忆天问军中诗》）\n			'),
(487, '0:2:7', '燎原烈火', '\n【 liáo　yuán　liè　huǒ 】\n			', '\n好象大火在原野上燃烧，使人无法接近。比喻不断壮大，不可抗拒的革命力量。\n			', '\n《书·盘庚上》：“若火之燎于原，不可向迩。”\n			', '\n改革开放的洪流，似～，不可阻挡。\n			'),
(488, '0:2:7', '明火持杖', '\n【 míng　huǒ　chí　zhàng 】\n			', '\n形容公开抢劫或肆无忌惮地干坏事。同“明火执仗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(489, '0:2:7', '明若观火', '\n【 míng　ruò　guān　huǒ 】\n			', '\n象看火那样清楚。形容看事物十分明晰。\n			', '\n《书·盘庚上》：“予若观火。”\n			', '\n暂无\n			'),
(490, '0:2:7', '怒火冲天', '\n【 nù　huǒ　chōng　tiān 】\n			', '\n形容愤怒之极，无法抑制。\n			', '\n老舍《龙须沟》第一幕：“［程娘子］怒火冲天，不顾一切地冲向狗子拚命，却被狗子一把抓住。”\n			', '\n他登时～，霍地立起身来……一阵猛扫，把四五个敌人都打倒了。\n			'),
(491, '0:2:7', '怒火中烧', '\n【 nù　huǒ　zhōng　shāo 】\n			', '\n怒气象火一样在心中燃烧。形容怀着极大的愤怒。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(492, '0:2:7', '炮火连天', '\n【 pào　huǒ　lián　tiān 】\n			', '\n形容炮火非常猛烈。\n			', '\n清·吴趼人《二十年目睹之怪现状》第十六回：“这不过演放两三响已经这样了，何况炮火连天，亲临大敌呢，自然也要逃走了。”\n			', '\n暂无\n			'),
(493, '0:2:7', '披麻救火', '\n【 pī　má　jiù　huǒ 】\n			', '\n披着麻去救火。比喻惹火烧身，自招灾祸。\n			', '\n元·无名氏《赚蒯通》第三折：“则落你好似披麻救火，蒯彻也不似那般人随风倒舵。”\n			', '\n若强动兵甲，正犹～，必致自焚也。（明·罗贯中《三国演义》第一百二十回）\n			'),
(494, '0:2:7', '判若水火', '\n【 pàn　ruò　shuǐ　huǒ 】\n			', '\n判：区别。比喻两者显然相反，互不相容。\n			', '\n清·钱泳《履园丛话·谭诗·总论》：“沈归愚宗伯与袁简斋太史论诗，判若水火。”\n			', '\n若各存意见，则依附之小人，遂至妄为揣摩，群相附和，渐至～。\n			'),
(495, '0:2:7', '泼油救火', '\n【 pō　yóu　jiù　huǒ 】\n			', '\n救火时用油浇洒。比喻事情处理不得法，反而使事态更严重。\n			', '\n明·罗贯中《三国演义》第七十四回：“今使他为先锋，是泼油浇火也。”\n			', '\n暂无\n			'),
(496, '0:2:7', '敲冰求火', '\n【 qiāo　bīng　qiú　huǒ 】\n			', '\n敲开冰找火。比喻不可能实现的事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(497, '0:2:7', '敲冰索火', '\n【 qiāo　bīng　suǒ　huǒ 】\n			', '\n比喻行动和目的相反，一定不会成功。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(498, '0:2:7', '清灰冷火', '\n【 qīng　huī　lěng　huǒ 】\n			', '\n没吃没喝。常用以形容贫困冷清的景象。同“清灰冷灶”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(499, '0:2:7', '七窍冒火', '\n【 qī　qiào　mào　huǒ 】\n			', '\n形容气愤到极点。同“七窍生烟”。\n			', '\n《老残游记续集遗稿》第三回：“一天两天还好受，等到第三天，真受不得了！怎么还没有信呢？俗语说的好，真是七窍冒火，五脏里生烟。”\n			', '\n见此情不由我～，你这般对付我却待如何？\n			'),
(500, '0:2:7', '如蹈水火', '\n【 rú　dǎo　shuǐ　huǒ 】\n			', '\n比喻处境艰难。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(501, '0:2:7', '如蹈汤火', '\n【 rú　dǎo　tāng　huǒ 】\n			', '\n蹈：踩；汤：滚水。如同在滚水、烈火中行走一样。比喻处境艰险。\n			', '\n汉·韩婴《韩诗外传》卷一：“命入朝廷，如赴汤火。”\n			', '\n入入公门，～。（清·蒲松龄《聊斋志异·冤狱》）\n			'),
(502, '0:2:7', '热火朝天', '\n【 rè　huǒ　cháo　tiān 】\n			', '\n形容群众性的活动情绪热烈，气氛高涨，就象炽热的火焰照天燃烧一样。\n			', '\n<span class="C999">暂无</span>\n			', '\n但这几天～的参军运动，也冲击着他们的身心。（冯德英《迎春花》第九章）\n			'),
(503, '0:2:7', '入火赴汤', '\n【 rù　huǒ　fù　tāng 】\n			', '\n比喻不避艰险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(504, '0:2:7', '如火燎原', '\n【 rú　huǒ　liáo　yuán 】\n			', '\n燎：烧；原：原野。如火在原野燃烧。比喻声势很大，难于阻抑。\n			', '\n《尚书·盘庚上》：“若火之燎于原，不可向迩。”\n			', '\n到期不能“剿灭”，反而～，他们有些做封疆大吏的，轻则降级、削职，重则下狱、砍头。（姚雪垠《李自成》第二卷第三十六章）\n			'),
(505, '0:2:7', '如火如荼', '\n【 rú　huǒ　rú　tú 】\n			', '\n荼：茅草的白花。象火那样红，象荼那样白。原比喻军容之盛。现用来形容大规模的行动气势旺盛，气氛热烈。\n			', '\n《国语·吴语》：“万人以为方阵，皆白裳，白旗，素甲，白羽之缯，望之如荼。……左军亦如之，皆赤裳，赤?，丹甲，朱羽之缯，望之如火。”\n			', '\n过了两年“五四运动”发生了。报纸上的～的记载唤醒了他的被忘却了的青春。（巴金《家》六）\n			'),
(506, '0:2:7', '惹火烧身', '\n【 rě　huǒ　shāo　shēn 】\n			', '\n惹：引；身：本身。引火烧自己。比喻自找麻烦或自找苦吃。\n			', '\n明·东鲁古狂生《醉醒石》第三回：“庄上人见典史亲来捉获，不知一件什么天大的事，生怕惹火烧身，连忙把余琳并冯氏，都送将出来。”\n			', '\n暂无\n			'),
(507, '0:2:7', '顺风吹火', '\n【 shǔn　fēng　chuī　huǒ 】\n			', '\n比喻乘便行事，并不费力。\n			', '\n《景德传灯录》：“因风吹火，用力不多。”\n			', '\n暂无\n			'),
(508, '0:2:7', '煽风点火', '\n【 shān　fēng　diǎn　huǒ 】\n			', '\n比喻煽动别人闹事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(509, '0:2:7', '扇风点火', '\n【 shàn　fēng　diǎn　huǒ 】\n			', '\n指进行鼓动或煽动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(510, '0:2:7', '舌锋如火', '\n【 shé　fēng　rú　huǒ 】\n			', '\n比喻话说得十分尖锐。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(511, '0:2:7', '水火不避', '\n【 shuǐ　huǒ　bù　bì 】\n			', '\n指不避艰险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(512, '0:2:7', '水火兵虫', '\n【 shuǐ　huǒ　bīng　chóng 】\n			', '\n指使古书遭受损毁的四种灾害：水灾、火灾、战乱和书蠹。也泛指各种天灾人祸。\n			', '\n<span class="C999">暂无</span>\n			', '\n今人标点古书而古书亡，因为他们乱点一通，佛头着粪：这是古书的～以外的三大厄。（鲁迅《且介亭杂文·病后杂谈之余》）\n			'),
(513, '0:2:7', '水火不辞', '\n【 shuǐ　huǒ　bù　cí 】\n			', '\n指不避艰险。同“水火不避”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(514, '0:2:7', '水火不相容', '\n【 shuǐ　huǒ　bù　xiāng　róng 】\n			', '\n容：容纳。比喻二者对立，绝不相容。\n			', '\n汉·王符《潜夫论·慎微》：“且夫邪之与正，犹水与火，不同原，不得并盛。”《汉书·郊祀志下》：“《易》有八卦，乾坤六子，水火不相逮，雷风不相悖，山泽通气，然后能变化，既成万物也。”\n			', '\n太太！求道不求医，求医不求道，医者治病靠药力，道者治病靠神力，医道两门，～。（曲波《林海雪原》一一）\n			'),
(515, '0:2:7', '水火不兼容', '\n【 shuǐ　huǒ　bù　xiāng　róng 】\n			', '\n容：容纳。比喻二者对立，绝不兼容。\n			', '\n《周易·说卦》：“故水火不相逮。”\n			', '\n他们闹得～。\n			'),
(516, '0:2:7', '石火电光', '\n【 shí　huǒ　diàn　guāng 】\n			', '\n形容事物象闪电和石火一样一瞬间就消逝。\n			', '\n宋·释道原《景德传灯录》卷二十四：“僧问：‘如何是佛法大意？’……师曰：‘石火电光，已经尘劫。’”\n			', '\n暂无\n			'),
(517, '0:2:7', '石火风灯', '\n【 shí　huǒ　fēng　dēng 】\n			', '\n比喻为时短暂。\n			', '\n《万善同归集》卷五：“无常迅速，念念迁移，石火风灯，逝波残照，露华电影，不足为喻。”\n			', '\n暂无\n			'),
(518, '0:2:7', '石火风烛', '\n【 shí　huǒ　fēng　zhú 】\n			', '\n比喻为时短暂。\n			', '\n唐·黄滔《祭宋员外》：“石火风烛，惊波逝水，诚修短之无改矣，奈痛伤之有等焉。”\n			', '\n暂无\n			'),
(519, '0:2:7', '石火光阴', '\n【 shí　huǒ　guāng　yīn 】\n			', '\n表示光阴之迅速，一眨眼就要过去。\n			', '\n<span class="C999">暂无</span>\n			', '\n青春时光，有如～，我们应把握时间多加学习。\n			'),
(520, '0:2:7', '水火无交', '\n【 shuǐ　huǒ　wú　jiāo 】\n			', '\n没有财物牵涉。形容为官清正廉洁。\n			', '\n《隋书·循吏传·赵轨》：“别驾在官，水火不与百姓交，是以不敢以壶酒相送。”\n			', '\n暂无\n			'),
(521, '0:2:7', '水火无情', '\n【 shuǐ　huǒ　wú　qíng 】\n			', '\n指水和火是不讲情面的，如疏忽大意，容易造成灾祸。\n			', '\n元·杨梓《豫让吞炭》第二折：“俺城中把金鼓鸣，正是外合里应，教智伯才知水火无情。”\n			', '\n水火无情，我们都应该提高防范意识。\n			'),
(522, '0:2:7', '水火相济，盐梅相成', '\n【 shuǐ　huǒ　xiāng　jì，yán　méi　xiāng　ché 】\n			', '\n烹饪赖水火而成，调味兼盐梅而用。喻人之才性虽各异，而可以和衷共济。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(523, '0:2:7', '扇火止沸', '\n【 shàn　huǒ　zhǐ　fèi 】\n			', '\n沸：沸腾，指水滚开。用扇风助长火势的办法来停止水沸腾。比喻采取的办法与希望达到的目的正好相反。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(524, '0:2:7', '事火咒龙', '\n【 shì　huǒ　zhòu　lóng 】\n			', '\n比喻荒诞不经之事。事火，指祀火为神；咒龙，指咒龙请雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(525, '0:2:7', '水火之中', '\n【 shuǐ　huǒ　zhī　zhōng 】\n			', '\n水火：比喻灾难。灾难困苦之中。\n			', '\n《孟子·梁惠王下》：“今燕虐其民，王往而证之，民以为将拯己于水火之中也。”\n			', '\n今百姓如在～。（明·许仲琳《封神演义》第二十八回）\n			'),
(526, '0:2:7', '水流湿，火就燥', '\n【 shuǐ　liú　shī，huǒ　jiù　zào 】\n			', '\n水向湿处流，火往干处烧。指物之气质类似必相感应。后用以比喻事物发展的必然规律。\n			', '\n《易·乾》：“水流湿，火就燥，云从龙，风从虎……各从其类也。”孔颖达疏：“此二者以形象相感。水流於地，先就湿处；火焚其薪，先就燥处。”\n			', '\n暂无\n			'),
(527, '0:2:7', '杀人放火', '\n【 shā　rén　fàng　huǒ 】\n			', '\n指无法无天的强暴行为。\n			', '\n元·无名氏《黄花峪》第二折：“听的道杀人放火偏精细，显出我些英雄神威。”清·钱彩《说岳全传》第五十五回：“他本是杀人放火为生的主儿，被杨元帅收伏在麾下。”\n			', '\n也有钻穴逾垣在那里偷窃的，也有～在那里抢劫的。\n			'),
(528, '0:2:7', '势如水火', '\n【 shì　rú　shuǐ　huǒ 】\n			', '\n形容双方就像水火一样互相对立，不能相容。\n			', '\n《三国志·蜀志·魏延传》：“惟杨仪不假借延，延以为至忿，有如水火。”\n			', '\n暂无\n			'),
(529, '0:2:7', '水深火热', '\n【 shuǐ　shēn　huǒ　rè 】\n			', '\n老百姓所受的灾难，像水那样越来越深，像火那样越来越热。比喻人民生活极端痛苦。\n			', '\n《孟子·梁惠王下》：“如水益深，如火益热，亦运而已矣。”\n			', '\n只要能把国家从～里救出来，他就是至高无上的英雄。（梁斌《红旗谱》四二）\n			'),
(530, '0:2:7', '十万火急', '\n【 shí　wàn　huǒ　jí 】\n			', '\n形容事情紧急到了极点（多用于公文、电报等）。\n			', '\n<span class="C999">暂无</span>\n			', '\n启奏陛下！鸡鹿寨～，羽书传到长安，请圣裁。（曹禺《王昭君》第二幕）\n			'),
(531, '0:2:7', '十万火速', '\n【 shí　wàn　huǒ　sù 】\n			', '\n形容在紧急情况下动作极快地行事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(532, '0:2:7', '烧犀观火', '\n【 shāo　xī　guān　huǒ 】\n			', '\n比喻洞察事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(533, '0:2:7', '束缊举火', '\n【 shù　yūn　jǔ　huǒ 】\n			', '\n比喻求助于人。也比喻为人排难解纷。同“束缊请火”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(534, '0:2:7', '束缊请火', '\n【 shù　yùn　qǐng　huǒ 】\n			', '\n束缊：束一扎可烧的大麻为火把；请火：借火。搓麻为引火绳，向邻家讨火。比喻求助于人。也比喻为人排难解纷。\n			', '\n《汉书·蒯通传》：“即束缊请火于亡肉家。”\n			', '\n暂无\n			'),
(535, '0:2:7', '束蕴乞火', '\n【 shù　yùn　qǐ　huǒ 】\n			', '\n比喻求助于人。也比喻为人排难解纷。同“束缊请火”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(536, '0:2:7', '束蕴请火', '\n【 shù　yùn　qǐng　huǒ 】\n			', '\n比喻求助于人。也比喻为人排难解纷。同“束缊请火”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(537, '0:2:7', '吞刀吐火', '\n【 tūn　dāo　tǔ　huǒ 】\n			', '\n古杂剧之一，泛称魔术。\n			', '\n汉·张衡《西京赋》：“吞刀吐火，云雾杳冥。”\n			', '\n丹、珠乃拔马破舌，～。（《晋书·夏统传》）\n			'),
(538, '0:2:7', '投膏止火', '\n【 tóu　gāo　zhǐ　huǒ 】\n			', '\n用油去浇灭火，火反而烧得更旺。比喻举措失当，适得其反。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(539, '0:2:7', '汤烧火热', '\n【 tāng　shāo　huǒ　rè 】\n			', '\n指生病发高烧。\n			', '\n清·曹雪芹《红楼梦》第二十回：“又见他汤烧火热，自己守着他，歪在旁边劝他：‘只养病，别想着些没要紧的事。’”\n			', '\n暂无\n			'),
(540, '0:2:7', '探汤蹈火', '\n【 tàn　tāng　dǎo　huǒ 】\n			', '\n犹言赴汤蹈火。比喻不怕任何艰险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(541, '0:2:7', '窝火憋气', '\n【 wō　huǒ　biē　qì 】\n			', '\n把屈辱或恼怒强压在心底，不敢或不能发泄。\n			', '\n周立波《暴风骤雨》第一部五：“李青山有些胆怯，他退到门边，嘴头咕噜着：‘滚就滚吧！’扭转身子，窝火憋气地迈出门去了。”\n			', '\n怎么受压？嘿，说起来叫人～呗！\n			'),
(542, '0:2:7', '玩火自焚', '\n【 wán　huǒ　zì　fén 】\n			', '\n玩：玩弄；焚：烧。玩火的必定会烧了自己。比喻干冒险或害人的勾当，最后受害的还是自己。\n			', '\n《左传·隐公四年》：“夫兵，犹火也，弗戢，将自焚也。”\n			', '\n暂无\n			'),
(543, '0:2:7', '万家灯火', '\n【 wàn　jiā　dēng　huǒ 】\n			', '\n家家点上了灯。指天黑上灯的时候。也形容城市夜晚的景象。\n			', '\n清·曾朴《孽海花》第八回：“万家灯火吹箫路，五夜星辰赌酒天。”\n			', '\n签后当日送出，我回家时已经～了。（邹韬奋《抗战以来·临行的一封信》）\n			'),
(544, '0:2:7', '无名火气', '\n【 wú　míng　huǒ　qì 】\n			', '\n说不出来由的火气。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(545, '0:2:7', '无名孽火', '\n【 wú　míng　niè　huǒ 】\n			', '\n名：称呼；孽：邪。说不出的邪火。指极大的怒气。\n			', '\n清·文康《儿女英雄传》第十五回：“那里我一把无名孽火，从脚跟下直透顶门，只得碍着众亲友不好动粗。”\n			', '\n暂无\n			'),
(546, '0:2:7', '无明业火', '\n【 wú　míng　yè　huǒ 】\n			', '\n指怒火。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(547, '0:2:7', '雪窗萤火', '\n【 xuě　chuāng　yíng　huǒ 】\n			', '\n比喻勤学苦读。同“雪窗萤几”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(548, '0:2:7', '香火不绝', '\n【 xiāng　huǒ　bù　jué 】\n			', '\n指信神者所供养的香烛不断绝。亦作“香火不断”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(549, '0:2:7', '星火燎原', '\n【 xīng　huǒ　liáo　yuán 】\n			', '\n一点儿小火星可以把整个原野烧起来。常比喻新生事物开始时力量虽然很小，但有旺盛的生命力，前途无限。\n			', '\n《书·盘庚上》：“若火之燎于原，不可向迩。”\n			', '\n暂无\n			'),
(550, '0:2:7', '向火乞儿', '\n【 xiàng　huǒ　qǐ　ér 】\n			', '\n向火：烤火；乞儿：乞丐。近火取暖的气丐。比喻趋炎附势的人。\n			', '\n五代·王仁裕《开元天宝遗事·向火乞儿》：“今时之朝彦皆是向火乞儿，一旦火尽灰冷，暖气何在？”\n			', '\n暂无\n			'),
(551, '0:2:7', '悬河泻火', '\n【 xuán　hé　xiè　huǒ 】\n			', '\n比喻以强大力量去消灭敌方。同“悬河注火”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(552, '0:2:7', '香火因缘', '\n【 xiāng　huǒ　yīn　yuán 】\n			', '\n香火：供佛敬神时燃点的香和灯火。香和灯火都是供佛的，因此佛教称彼此意志相投为“香火因缘”。指彼此契合。\n			', '\n《北史·陆法和传》：“法和是求佛之人，尚不希释梵天王坐处，岂规王位？但于空王佛所，与主上有香火因缘，且主上应有报至，故救援耳。”\n			', '\n～久愿同。（唐·白居易《喜照密闲实四上人见过》诗）\n			'),
(553, '0:2:7', '香火姻缘', '\n【 xiāng　huǒ　yīn　yuán 】\n			', '\n香和灯火都用于供佛，因此佛教用来比喻彼此意志相投。\n			', '\n《北史·陆法和传》：“法和是求佛之人，尚不希释梵天王坐处，岂规王位？但于空王佛所，与主上有香火因缘，且主上应有报至，故救援耳。”\n			', '\n暂无\n			'),
(554, '0:2:7', '悬河注火', '\n【 xuán　hé　zhù　huǒ 】\n			', '\n指以河水倾泻于火。比喻以强大力量去消灭敌方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(555, '0:2:7', '薪尽火传', '\n【 xīn　jìn　huǒ　chuán 】\n			', '\n薪：柴。柴虽烧尽，火种仍留传。比喻师父传业于弟子，一代代地传下去。\n			', '\n《庄子·养生主》：“指穷于为薪，火传也，不知其尽也。”\n			', '\n风流云散，贤豪才色总成空；～，工匠市廛都有韵。（清·吴敬梓《儒林外史》第五十四回）\n			'),
(556, '0:2:7', '心急火燎', '\n【 xīn　jí　huǒ　liǎo 】\n			', '\n心里急得象着了火一样。形容非常着急。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(557, '0:2:7', '心焦火燎', '\n【 xīn　jiāo　huǒ　liáo 】\n			', '\n心里急得像火烧着一样。形容十分焦急。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(558, '0:2:7', '心急如火', '\n【 xīn　jí　rú　huǒ 】\n			', '\n心里急得象着了火一样。形容非常着急。\n			', '\n元·王实甫《西厢记》第一本第四折：“要看个十分饱。”金圣叹批：“心急如火，更不能待。”\n			', '\n暂无\n			'),
(559, '0:2:7', '心焦如火', '\n【 xīn　jiāo　rú　huǒ 】\n			', '\n内心焦躁得如着火一般。形容焦灼难忍的心情，亦作“心焦如焚”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(560, '0:2:7', '性烈如火', '\n【 xìng　liè　rú　huǒ 】\n			', '\n性：性情，脾气。形容性情暴躁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(561, '0:2:7', '心如火焚', '\n【 xīn　rú　huǒ　fén 】\n			', '\n心中好像火烧一样。形容焦急万分。\n			', '\n清·吴趼人《二十年目睹之怪现状》：“我托他打听几时有船，他查了一查，说道：‘要等三四天呢。’我越发觉得心急如焚，然而也是没法的事，成日里犹如坐在针毡上一般。”\n			', '\n暂无\n			'),
(562, '0:2:7', '星星之火', '\n【 xīng　xīng　zhī　huǒ 】\n			', '\n一点点小火星。比喻开始时策小，但有远大发展前途的新事物。\n			', '\n《书·盘庚上》：“若火之燎于原，不可向迩。”\n			', '\n～，可以燎原。\n			'),
(563, '0:2:7', '烟不出火不进', '\n【 yān　bù　chū　huǒ　bù　jìn 】\n			', '\n形容人慢性子，不爱说话。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(564, '0:2:7', '烟断火绝', '\n【 yān　duàn　huǒ　jué 】\n			', '\n指人烟灭绝。\n			', '\n《文选·江淹〈恨赋〉》：“若乃骑叠迹，车屯轨，黄尘匝地，歌吹四起，无不烟断火绝，闭骨泉里。”李善注：“烟断火绝，喻人之死也。”\n			', '\n暂无\n			'),
(565, '0:2:7', '因风吹火', '\n【 yīn　fēng　chuī　huǒ 】\n			', '\n因：顺着。顺着风势吹火，比喻乘便行事，并不费力。常用作谦词。\n			', '\n宋·释道原《景德传灯录》卷十三：“因风吹火，用力不多。”\n			', '\n十娘钟情所欢，不以贫窭易心，此乃女中豪杰。仆～，谅区区何足挂齿。（明·冯梦龙《警世通言》卷三十二）\n			'),
(566, '0:2:7', '引风吹火', '\n【 yǐn　fēng　chuī　huǒ 】\n			', '\n利用风来吹火，使火越烧越旺。比喻从中煽动，挑起事端。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(567, '0:2:7', '油干火尽', '\n【 yóu　gān　huǒ　jìn 】\n			', '\n形容罄尽。\n			', '\n《二刻拍案惊奇》卷八：“[丁生]直赢得两人油干火尽，两人也怕起来。只得忍着性子住了，垂头丧气而别。”\n			', '\n暂无\n			'),
(568, '0:2:7', '银花火树', '\n【 yín　huā　huǒ　shù 】\n			', '\n比喻灿烂的焰火或灯火。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(569, '0:2:7', '以火救火', '\n【 yǐ　huǒ　jiù　huǒ 】\n			', '\n用火来救火灾。比喻工作方法不对头，不但无益，反而有害。\n			', '\n《庄子·人世间》：“是以火救火，以水救水，名之曰益多。”\n			', '\n暂无\n			'),
(570, '0:2:7', '拥篲救火', '\n【 yōng　huǐ　jiù　huǒ 】\n			', '\n指方法不当，事必不成。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(571, '0:2:7', '以火去蛾', '\n【 yǐ　huǒ　qù　é 】\n			', '\n娥喜投火，用火驱赶飞蛾，蛾越多。比喻行为和目的自相矛盾，只能得到相反的结果。\n			', '\n《太平御史》卷九四四引《韩子》：“以火去蛾蛾愈多，以鱼殴蝇蝇愈至。”\n			', '\n暂无\n			'),
(572, '0:2:7', '引火烧身', '\n【 yǐn　huǒ　shāo　shēn 】\n			', '\n原比喻自讨苦吃或自取灭亡。现多比喻主动暴露自己的缺点错误，以争取大家的批评帮助。\n			', '\n<span class="C999">暂无</span>\n			', '\n谁胆敢发动战争，必定会～。\n			'),
(573, '0:2:7', '以火止沸', '\n【 yǐ　huǒ　zhǐ　fèi 】\n			', '\n比喻处理方法不对，不但不能制止，反而助长已成的气势。同“以汤止沸”。\n			', '\n汉·桓宽《盐铁论·错币》：“汉初乘弊而不改易，畜利变币，欲以反本，是犹以煎止燔，以火止沸也。”\n			', '\n暂无\n			'),
(574, '0:2:7', '油煎火燎', '\n【 yóu　jiān　huǒ　liáo 】\n			', '\n形容痛苦或焦灼。\n			', '\n郭澄清《大刀记》第十章：“他觉着，像有个什么东西，在胸口上剧烈地涌动，闹得血管里的血，也加快了流速。继而，心里又油煎火燎，阵阵剧疼。”\n			', '\n当时我心里急得～，只怕他说个不成。\n			'),
(575, '0:2:7', '油浇火燎', '\n【 yóu　jiāo　huǒ　liáo 】\n			', '\n形容焦急。\n			', '\n向春《煤城怒火》第二一章：“齐标虽认为有理，却油浇火燎地问：‘依你说该咋办？’”\n			', '\n暂无\n			'),
(576, '0:2:7', '一家一火', '\n【 yī　jiā　yī　huǒ 】\n			', '\n指所有家当什物。\n			', '\n明·冯梦龙《古今小说》第五卷：“王媪嫁了马周，把自己一家一火，都搬到马家来了。”\n			', '\n暂无\n			'),
(577, '0:2:7', '远水不救近火', '\n【 yuǎn　shuǐ　bù　jiù　jìn　huǒ 】\n			', '\n远处的水救不了近处的火。比喻慢的办法救不了急。\n			', '\n《韩非子·说林上》：“失火而取水于海，海水虽多，火必不灭矣，远水不救近火也。”\n			', '\n为今之计，到临安取救是～。（清·吴趼人《痛史》第三回）\n			'),
(578, '0:2:7', '远水救不得近火', '\n【 yuǎn　shuǐ　jiù　bù　dé　jìn　huǒ 】\n			', '\n比喻缓慢的救助不能解决眼前的急难。\n			', '\n明·凌濛初《二刻拍案惊奇》卷三：“只是远水救不得近火，小兄其实等不得那从容的事了。”\n			', '\n如今～，就是我们再帮点忙，至多再凑了几百银子，也无济于事。\n			'),
(579, '0:2:7', '烟消火灭', '\n【 yān　xiāo　huǒ　miè 】\n			', '\n比喻事物消灭干净。\n			', '\n清·张春帆《宦海》第十七回：“若是这位武弁老爷，当时认个不是，赔个笑脸，这件事儿也就烟消火灭的了。”\n			', '\n暂无\n			'),
(580, '0:2:7', '钻冰求火', '\n【 zuān　bīng　qiú　huǒ 】\n			', '\n比喻徒劳无功。\n			', '\n宋·张君房《云笈七签》第102卷：“影离响绝，云销雾除，钻冰求火，探巢捕鱼，不足言其无也。”\n			', '\n暂无\n			'),
(581, '0:2:7', '招风揽火', '\n【 zhāo　fēng　lǎn　huǒ 】\n			', '\n比喻招惹是非。\n			', '\n<span class="C999">暂无</span>\n			', '\n地方轻薄子弟不少，你又生得美貌，莫在门前窥瞰，～。（明·冯梦龙《古今小说》第一卷）\n			'),
(582, '0:2:7', '只许州官放火，不许百姓点灯', '\n【 zhǐxǔzhōu　guān　fàng　huǒ，bùxǔbǎi　xìn 】\n			', '\n指反动统治者自己可以胡作非为，老百姓却连正当活动也要受到限制。\n			', '\n宋·陆游《老学庵笔记》卷五：“田登作郡，自讳其名，触者必怒，吏卒多被榜笞。于是举州皆谓灯为火。上元放灯许人入州治游观，吏人遂书榜揭于市曰：‘本州依例放火三日。’”\n			', '\n可是你“～”。我们偶说一句妨碍的话，你就说不吉利。（清·曹雪芹《红楼梦》第七十七回）\n			'),
(583, '0:2:7', '战火纷飞', '\n【 zhàn　huǒ　fēn　fēi 】\n			', '\n形容战斗频仍、激烈。\n			', '\n浩然《艳阳天》第一二一章：“经过了这场灾祸的考验，好像当年跟着担架队闯了一趟战火纷飞的疆场回来。”\n			', '\n这种友谊来自～的年代。\n			'),
(584, '0:2:7', '真金不怕火炼', '\n【 zhēn　jīn　bù　pà　huǒ　liàn 】\n			', '\n比喻品质好、意志坚强的人经得起任何考验。\n			', '\n<span class="C999">暂无</span>\n			', '\n～，中国人民解放军战士经过血与火的考验，更加英勇无畏了。\n			'),
(585, '0:2:7', '真金不怕火', '\n【 zhēn　jīn　bù　pà　huǒ 】\n			', '\n比喻正确的事物经得住考验。\n			', '\n高晓声《大好人江坤大》：“姓刘的说要调查，你就陪他去，真金不怕火，查好了！”\n			', '\n暂无\n			'),
(586, '0:2:7', '真金烈火', '\n【 zhēn　jīn　liè　huǒ 】\n			', '\n比喻经过严重考验而品质不变。\n			', '\n明·徐渭《雌木兰》第二出：“非自奖真金烈火，傥好比浊水红莲。”\n			', '\n暂无\n			'),
(587, '0:2:7', '众人拾柴火焰高', '\n【 zhòng　rén　shí　chái　huǒ　yàn　gāo 】\n			', '\n比喻人多力量大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(588, '0:2:7', '自相水火', '\n【 zì　xiāng　shuǐ　huǒ 】\n			', '\n自己人互相像水火那样不能相容。\n			', '\n《东周列国志》第九十六回：“今大王所恃重臣二人，而使自相水火，非社稷之福也。”\n			', '\n暂无\n			'),
(589, '0:2:8', '不避水火', '\n【 bù　bì　shuǐ　huǒ 】\n			', '\n指不畏凶险。\n			', '\n《水浒传》第五八回：“贤弟心中有何危厄不决之难，但请尽说不妨，便当不避水火，力为解救，与汝相助。”\n			', '\n暂无\n			'),
(590, '0:2:8', '不便水土', '\n【 bù　biàn　shuǐ　tǔ 】\n			', '\n不能适应移居地方的气候和饮食习惯。同“不服水土”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(591, '0:2:8', '不習水土', '\n【 bù　xí　shuǐ　tǔ 】\n			', '\n不能适应某个地方的气侯、饮食等。\n			', '\n《通俗编·地理引南史·王融传》：“上以魏所送马不称，使融问之，宋弁答曰：当是不習水土。”\n			', '\n暂无\n			'),
(592, '0:2:8', '餐风宿水', '\n【 cān　fēng　sù　shuǐ 】\n			', '\n形容旅途的辛苦。\n			', '\n明·冯梦龙《挂枝儿·送别》：“纵经营千倍利，不如家里安闲。餐风宿水，容颜易变。”\n			', '\n且说天瑞带了妻子，一路～，无非是逢桥下马，遇渡登舟。\n			'),
(593, '0:2:8', '乘高决水', '\n【 chéng　gāo　jué　shuǐ 】\n			', '\n凭借地势居高临下，决口放水。比喻费力小，收效大。\n			', '\n宋·司马光《言为治所先上殿札子》：“陛下诚能行此二者……后日之政，如顺风吹毛，乘高决水，可以不劳而成功者。”\n			', '\n暂无\n			'),
(594, '0:2:8', '盛水不漏', '\n【 chéng　shuǐ　bù　lòu 】\n			', '\n比喻说理严密。\n			', '\n郭沫若《盲肠炎·穷汉的穷谈》：“我觉得他这句话说得真好，真正是盛水不漏，真正把共产主义运动说穿了。”\n			', '\n暂无\n			'),
(595, '0:2:8', '尺山寸水', '\n【 chǐ　shān　cùn　shuǐ 】\n			', '\n指每一小块山水。\n			', '\n清·张问陶《青神舟中饮酒排闷》诗：“丹稜彭君古豪杰，对予常笑峨嵋劣；曾向华严顶上来，尺山寸水皆能说。”\n			', '\n暂无\n			'),
(596, '0:2:8', '重山复水', '\n【 chóng　shān　fù　shuǐ 】\n			', '\n指山峦重叠，水流盘曲。\n			', '\n宋·林逋《风水洞》诗：“平昔常闻风水洞，重山复水去无穷。”\n			', '\n此日一帆凭顾盼，～是江南。\n			'),
(597, '0:2:8', '乘顺水船', '\n【 chéng　shùn　shuǐ　chuán 】\n			', '\n比喻顺势行事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(598, '0:2:8', '楚水吴山', '\n【 chǔ　shuǐ　wú　shān 】\n			', '\n楚地的水，吴地的山。指古时吴、楚两国所属地域。后用以指长江中下游一带。\n			', '\n唐·白居易《江南送北客因凭寄徐州兄牙书》：“故园望断欲何如，楚水吴山万里余。”\n			', '\n寄怀～外，得意唐诗恶帖中。\n			'),
(599, '0:2:8', '撮盐入水', '\n【 cuō　yán　rù　shuǐ 】\n			', '\n①形容立刻消灭干净。②形容大而化之，什么都不在乎。\n			', '\n元·关汉卿《窦娥冤》第四折：“[张驴儿做怕科云]有鬼有鬼，撮盐入水，太上老君，急急如律令，敕。”\n			', '\n谁不知老汉是不怕鬼的张撇古，俺的性儿～。\n			'),
(600, '0:2:8', '点水不漏', '\n【 diǎn　shuǐ　bù　lòu 】\n			', '\n形容十分周到、严密，毫无差失漏洞。\n			', '\n《隋唐演义》第四九回：“罗成见线娘这枝方天戟，使得神出鬼没，点水不漏。”\n			', '\n暂无\n			'),
(601, '0:2:8', '大水冲了龙王庙', '\n【 dà　shuǐ　chōng　le　lóng　wáng　miào 】\n			', '\n比喻本是自己人，因不相识而相互发生了冲突争端。\n			', '\n清·文康《儿女英雄传》七回：“大水冲了龙王庙，一家人不认识一家人咧！”\n			', '\n暂无\n			'),
(602, '0:2:8', '斗水活鳞', '\n【 dòu　shuǐ　huó　lín 】\n			', '\n比喻得到微薄的资助而解救眼前的危急。\n			', '\n语出《庄子·外物》：“周昨来，有中道而呼者。周顾视车辙中，有鲋鱼焉。周问之曰：‘鲋鱼来！子何为者邪？’对曰：‘我，东海之波臣也。君岂有斗升之水而活我哉？’”\n			', '\n闻说道卢家广施，我挈儿女从乡来至，但只愿～，敢指望千金布地。\n			'),
(603, '0:2:8', '淡水交情', '\n【 dàn　shuǐ　jiāo　qíng 】\n			', '\n友情像水一样清澈。指不以势利为基础的朋友。\n			', '\n《庄子·山木》：“且君子之交淡若水，小人之交甘若醴；君子淡以亲，小人甘以绝。”\n			', '\n暂无\n			'),
(604, '0:2:8', '登山涉水', '\n【 dēng　shān　shè　shuǐ 】\n			', '\n爬山过水。比喻历尽艰难。\n			', '\n明·施耐庵《水浒传》第二十二回：“［宋江兄弟］两个商量了，径望沧州路上来。途中免不得登山涉水，过府冲州。”\n			', '\n我因归正释门，秉诚僧教，这一向～，把我那幼时的朋友也都疏失，未及拜访，少识尊颜。\n			'),
(605, '0:2:8', '带水拖泥', '\n【 dài　shuǐ　tuō　ní 】\n			', '\n①形容泥泞难行。②比喻不顺利或不干脆。现多作“拖泥带水”。\n			', '\n宋·叶適《修路疏》：“南来北往，何忧带水拖泥；朝去暮来，不到撞头磕脑。”\n			', '\n一甲子、～，今岁谢君恩，放还山去。\n			'),
(606, '0:2:8', '风门水口', '\n【 fēng　mén　shuǐ　kǒu 】\n			', '\n指要冲。\n			', '\n明·施耐庵《水浒传》第一百十一回：“如今听得朝廷起大军来，与方腊厮杀，我这里正是风门水口。有些人家都搬了别处去躲。只留下老身，在这里看屋。”\n			', '\n暂无\n			'),
(607, '0:2:8', '芙蓉出水', '\n【 fú　róng　chū　shuǐ 】\n			', '\n芙蓉：荷花。刚开放的荷花。比喻诗文清新不俗。也形容天然艳丽的女子。\n			', '\n南朝·梁·钟嵘《诗品》卷中：“谢诗如芙蓉出水，颜如错彩镂金。”\n			', '\n暂无\n			'),
(608, '0:2:8', '饭蔬饮水', '\n【 fàn　shū　yǐn　shuǐ 】\n			', '\n形容清心寡欲、安贫乐道的生活。\n			', '\n《论语·述而》：“子曰：‘饭疏食饮水，曲肱而枕之，乐亦在其中矣。不义而富且贵，於我如浮云。’”\n			', '\n～，客莫嘲吾拙。高处看浮云，一丘壑，中间甚乐。\n			'),
(609, '0:2:8', '滚瓜流水', '\n【 gǔn　guā　liú　shuǐ 】\n			', '\n形容说话极其熟练、流利。\n			', '\n茅盾《霜叶红似二月花》五：“他得意地哈了一声就滚瓜流水地一口气说道：‘说是男女在那件事上也该平等。’”\n			', '\n暂无\n			'),
(610, '0:2:8', '观山玩水', '\n【 guān　shān　wán　shuǐ 】\n			', '\n犹言游山玩水。\n			', '\n《五灯会元·法眼宗·宝塔绍岩禅师》：“诸仁者还明心也未？莫不是语言谭笑时……观山玩水时，耳目绝对时，是汝心否？”\n			', '\n暂无\n			'),
(611, '0:2:8', '黄尘清水', '\n【 huáng　chén　qīng　shuǐ 】\n			', '\n比喻变化迅速。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(612, '0:2:8', '涸鲋得水', '\n【 hé　fù　dé　shuǐ 】\n			', '\n比喻绝处逢生，有所凭借。同“涸鱼得水”。\n			', '\n梁启超《意大利建国三杰传》第六节：“虽然，以当时久困地狱，渴望天日之意大利人，骤闻此语，殆如涸鲋得水，笼鸟脱樊，且距且跃，且汗且喘。”\n			', '\n暂无\n			'),
(613, '0:2:8', '火耕水种', '\n【 huǒ　gēng　shuǐ　zhòng 】\n			', '\n耨：除草。古代一种原始耕种方式。\n			', '\n《史记·平准书》：“江南火耕水耨，令饥民得流就食江淮间，欲留，留处。”晋·陆云《答车茂安书》：“遏长川以为陂，燔茂草以为田，火耕水种，不烦人力。”\n			', '\n暂无\n			'),
(614, '0:2:8', '火热水深', '\n【 huǒ　rè　shuǐ　shēn 】\n			', '\n①犹水深火热。比喻十分困苦的处境。②形容严酷；厉害。\n			', '\n清·魏秀仁《花月痕》第五十回：“我算什么，明相国不动声色，却出斯民于火热水深，措天下于泰山磐石。”\n			', '\n法兰西革命之时，上自王家，下至贵族僧侣，蹂躏平民，无所弗至，其法之力，可谓～矣。\n			'),
(615, '0:2:8', '河水不犯井水', '\n【 hé　shuǐ　bù　fàn　jǐng　shuǐ 】\n			', '\n比喻互不干犯。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(616, '0:2:8', '画水镂冰', '\n【 huà　shuǐ　lòu　bīng 】\n			', '\n在水上作画，在冰上雕刻。比喻劳而无功。\n			', '\n汉·桓谭《新论》：“画水镂冰，与时消释。”\n			', '\n暂无\n			'),
(617, '0:2:8', '混水捞鱼', '\n【 hùn　shuǐ　lāo　yú 】\n			', '\n比喻乘混乱的时候从中捞取利益。同“混水摸鱼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(618, '0:2:8', '海水难量', '\n【 hǎi　shuǐ　nán　liáng 】\n			', '\n海水是不可以去量的。比喻不可根据某人的现状就低估他的未来。\n			', '\n《淮南子·泰族训》：“太山不可丈尺也，江海不可斗斛也。”\n			', '\n看从来～也，任你纷纷白眼多。\n			'),
(619, '0:2:8', '海水桑田', '\n【 hǎi　shuǐ　sāng　tián 】\n			', '\n犹沧海变桑田。比喻世事变迁很大。\n			', '\n唐·韦应物《汉武帝杂歌》之一：“海水桑田几翻覆，中间此桃四五熟。”\n			', '\n～几变迁，桃花依旧郡城边。\n			'),
(620, '0:2:8', '黄汤淡水', '\n【 huáng　tāng　dàn　shuǐ 】\n			', '\n泛指饮食。同“黄汤辣水”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(621, '0:2:8', '黄汤辣水', '\n【 huáng　tāng　là　shuǐ 】\n			', '\n泛指饮食。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(622, '0:2:8', '河同水密', '\n【 hé　tóng　shuǐ　mì 】\n			', '\n比喻彼此关系密切。\n			', '\n《警世通言·况太守断死孩儿》：“邵氏故意欲责秀姑，却教秀姑引得贵以塞其口。彼此河同水密，各不相瞒。”\n			', '\n暂无\n			'),
(623, '0:2:8', '涸鱼得水', '\n【 hé　yú　dé　shuǐ 】\n			', '\n涸辙之鱼得到水。比喻绝处逢生，有所凭借。\n			', '\n《新唐书·契苾何力传》：“何力被执也，或谗之帝曰：‘何力入延陀，如涸鱼得水，其脱必遽。’帝曰：‘不然。若人心如铁石，殆不背我。’”\n			', '\n暂无\n			'),
(624, '0:2:8', '兼葭秋水', '\n【 jiān　jiā　qiū　shuǐ 】\n			', '\n比喻思慕的人。兼，同“蒹”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(625, '0:2:8', '蛟龙戏水', '\n【 jiāo　lóng　xì　shuǐ 】\n			', '\n比喻刀枪棍棒等武器使得轻松自如，灵活多变。形容武艺精湛纯熟。\n			', '\n明·吴承恩《西游记》第五十一回：“饿虎扑食最伤人，蛟龙戏水能凶恶。”\n			', '\n暂无\n			'),
(626, '0:2:8', '江水不犯河水', '\n【 jiāng　shuǐ　bù　fàn　hé　shuǐ 】\n			', '\n比喻彼此互不相干，没有关系。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(627, '0:2:8', '浆水不交', '\n【 jiāng　shuǐ　bù　jiāo 】\n			', '\n浆水不沾。指为官清廉，无取于民。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(628, '0:2:8', '借水推船', '\n【 jiè　shuǐ　tuī　chuán 】\n			', '\n指趁势行事。亦作“借水行舟”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(629, '0:2:8', '借水行舟', '\n【 jiè　shuǐ　xíng　zhōu 】\n			', '\n指趁势行事。同“借水推船”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(630, '0:2:8', '煎水作冰', '\n【 jiān　shuǐ　zuò　bīng 】\n			', '\n比喻不可能的事。\n			', '\n《三国志·魏志·高堂隆传》：“以若所为，求若所致，犹缘木求鱼，煎水作冰，其不可得，明矣。”\n			', '\n暂无\n			'),
(631, '0:2:8', '乐山爱水', '\n【 lè　shān　ài　shuǐ 】\n			', '\n爱好山水风光。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(632, '0:2:8', '流水不腐，户枢不蝼', '\n【 liú　shuǐ　bù　fǔ，hù　shū　bù　lóu 】\n			', '\n比喻经常运动的东西不易受侵蚀。同“流水不腐，户枢不蠹”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(633, '0:2:8', '临水登山', '\n【 lín　shuǐ　dēng　shān 】\n			', '\n临：到，靠近。原意是到达水边又登上高山，写送别的情景。现也泛指游览山水名胜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(634, '0:2:8', '露水夫妻', '\n【 lù　shuǐ　fū　qī 】\n			', '\n指暂时结合的非正式夫妻；亦指不正当的男女关系。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(635, '0:2:8', '流水高山', '\n【 liú　shuǐ　gāo　shān 】\n			', '\n比喻知己或知音。也比喻乐曲高妙。\n			', '\n《列子·汤问》：“伯牙鼓琴，志在登高山，钟子期曰：‘善哉，峨峨兮若泰山。’志在流水，曰：‘善哉，洋洋兮若江河。’”\n			', '\n金垆焚宝烟，瑶琴鸣素弦，无非是～调，和那堆风积雪篇。\n			'),
(636, '0:2:8', '冷水浇背', '\n【 lěng　shuǐ　jiāo　bèi 】\n			', '\n冷水从背上浇下来。比喻因突然遭受意外的打击或刺激，思想为之一震或希望为之幻灭。亦作“冷水浇头”。\n			', '\n清·吴趼人《二十年目睹之怪现状》第六十五回：“红玉听了，总如冷水浇背一般，唇也青了，面也白了，做声不得。”\n			', '\n自辰入见，及戌始退，～，当头一棒，一旦尽失其故垒，惘惘然不知所从事，且惊且喜，且怨且艾，且疑且惧，与通甫联床竟夕不能寐。\n			'),
(637, '0:2:8', '冷水浇头', '\n【 lěng　shuǐ　jiāo　tóu 】\n			', '\n冷水从背上浇下来。比喻因突然遭受意外的打击或刺激，思想为之一震或希望为之幻灭。同“冷水浇背”。\n			', '\n清·丁耀亢《续金瓶梅》第四十三回：“忽然听得说太太来了，好一似——天雷霹雳，冷水浇头。”\n			', '\n他一看，像一瓢～，不禁浑身一颤，颓然靠在椅背上。\n			'),
(638, '0:2:8', '流水行云', '\n【 liú　shuǐ　xíng　yún 】\n			', '\n形容文章自然不受约束，就象漂浮着的云和流动着的水一样。\n			', '\n宋·洪咨夔《朝中措·寿章君举》：“流水行云才思，光风霁月精神。”\n			', '\n容止则光风霁月，应对则～。\n			'),
(639, '0:2:8', '流水游龙', '\n【 liú　shuǐ　yóu　lóng 】\n			', '\n比喻川流不息的车马。\n			', '\n语出《后汉书·皇后纪上·明德马皇后》：“前过濯龙门上，见外家问起居者，车如流水，马如游龙，仓头衣绿褠，领袖正白，顾视御者，不及远矣。”\n			', '\n～日夜弛，品题素竹与哀丝。\n			'),
(640, '0:2:8', '连汤带水', '\n【 lián　tāng　dài　shuǐ 】\n			', '\n比喻全部，无遗留。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(641, '0:2:8', '陆詟水栗', '\n【 lù　zhé　shuǐ　lì 】\n			', '\n指声威远播，四方畏服。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(642, '0:2:8', '买臣覆水', '\n【 mǎi　chén　fù　shuǐ 】\n			', '\n覆：泼。比喻事成定局，无法挽回。\n			', '\n相传汉代朱买臣贫贱时，其妻出走，显达后，其妻又回来，朱买臣泼水于地，令妻收回。\n			', '\n今日无意忽逢，虽不能有相如解渴之情，却怅然有～之悲。\n			'),
(643, '0:2:8', '马如流水', '\n【 mǎ　rú　liú　shuǐ 】\n			', '\n形容人马熙攘。\n			', '\n元·揭傒斯《居庸行》：“关门两向当天开，马如流水车如雷。”\n			', '\n暂无\n			'),
(644, '0:2:8', '马水车龙', '\n【 mǎ　shuǐ　chē　lóng 】\n			', '\n犹言车水马龙。形容来往车马很多，连续不断的热闹情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(645, '0:2:8', '模山范水', '\n【 mó　shān　fàn　shuǐ 】\n			', '\n用文字或图画描绘山水景物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(646, '0:2:8', '名山胜水', '\n【 míng　shān　shèng　shuǐ 】\n			', '\n风景优美的著名河山。同“名山胜川”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(647, '0:2:8', '鸥水相依', '\n【 ōu　shuǐ　xiāng　yī 】\n			', '\n比喻离不开赖以生存的环境。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(648, '0:2:8', '盘水加剑', '\n【 pan　shui　jia　jian 】\n			', '\n汉代大臣自杀处死的一种表示。加剑：自杀。\n			', '\n《汉书·贾谊传》：“故其在大谴大何之域者，闻谴何则白冠氂缨，盘水加剑，造请室而请罪耳，上不执缚系引而行也。”\n			', '\n太祖常与侍臣论待大臣之礼，太史令刘基曰：‘古者公卿有罪，～，诣请室自裁，未尝轻折辱之，所以存大臣之体。’\n			'),
(649, '0:2:8', '泼水难收', '\n【 pō　shuǐ　nán　shōu 】\n			', '\n相传汉朱买臣因家贫，其妻离去，后买臣富贵，妻又求合。买臣取水泼洒于地，令妻收回，以示夫妻既已离异就不能再合。后用以比喻不可挽回的局面。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(650, '0:2:8', '爬山涉水', '\n【 pá　shān　shè　shuǐ 】\n			', '\n形容路途艰辛。\n			', '\n范金标《怀念敬爱的周总理》：“在作战频繁的长征路上，一年多的时间里周副主席白天和我们一样爬山涉水，栉风沐雨。”\n			', '\n暂无\n			'),
(651, '0:2:8', '歠菽饮水', '\n【 pá　shū　yǐn　shuǐ 】\n			', '\n喝豆粥饮白水。比喻生活清苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(652, '0:2:8', '青蓝冰水', '\n【 qīng　lán　bīng　shuǐ 】\n			', '\n“青出于蓝，冰寒于水”的略语。比喻学生超过老师或后人胜过前人。\n			', '\n清·陈康祺《燕下乡脞录》卷四：“桐城派古文，望谿开之，海峰继之，至惜抱而其传始大，此天下之公言也。惜抱出于刘门，世几有青蓝冰水之喻。”\n			', '\n暂无\n			'),
(653, '0:2:8', '清水无大鱼', '\n【 qīng　shuǐ　wú　dà　yú 】\n			', '\n指待人处事不能求全责备。\n			', '\n语出《汉书·东方朔传》：“水至清则无鱼，人至察则无徒。”\n			', '\n暂无\n			'),
(654, '0:2:8', '千水万山', '\n【 qiān　shuǐ　wàn　shān 】\n			', '\n形容路途艰难遥远。同“千山万水”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(655, '0:2:8', '清水衙门', '\n【 qīng　shuǐ　yá　mén 】\n			', '\n比喻没有油水的机构或地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(656, '0:2:8', '秋水盈盈', '\n【 qiū　shuǐ　yíng　yíng 】\n			', '\n形容眼神饱含感情。同“秋波盈盈”。\n			', '\n秦牧《艺海拾贝·神速的剪影》；“通过这二十几个字，一个雪肤花貎、十指纤纤、唇红齿白、云鬓蛾眉、秋水盈盈、嫣然含笑的古代美女的形象，就呈现在人们眼前了。”\n			', '\n暂无\n			'),
(657, '0:2:8', '如蹈水火', '\n【 rú　dǎo　shuǐ　huǒ 】\n			', '\n比喻处境艰难。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(658, '0:2:8', '如石投水', '\n【 rú　shí　tóu　shuǐ 】\n			', '\n象石头投入水里就沉没一样。比喻互相合得来。\n			', '\n《列子·说符》：“白公问曰：‘若以石投水，何如？’孔子曰：‘吴之善没者能取之。’”三国·魏·李萧远《运命论》：“及其遭汉祖，其言也，如以石投水，莫之逆也。”\n			', '\n是以揣人情，究物理，决胜则若火燎原，发言则～。\n			'),
(659, '0:2:8', '若涉渊水', '\n【 ruò　shè　yuān　shuǐ 】\n			', '\n比喻处境艰险。\n			', '\n《书·大诰》：“予惟小子，若涉渊水，予惟往求腾攸济。”\n			', '\n永思厥艰，～，非君攸济，朕无任焉。\n			'),
(660, '0:2:8', '如鱼似水', '\n【 rú　yú　sì　shuǐ 】\n			', '\n比喻关系融洽、亲密。\n			', '\n明·冯梦龙《警世通言》第二卷：“那田氏比先前二妻，更有姿色。肌肤若冰雪，绰约似神仙。庄生不是好色之徒，却也十分相敬，真个如鱼似水。”\n			', '\n暂无\n			'),
(661, '0:2:8', '如鱼饮水，冷暖自知', '\n【 rú　yú　yǐn　shuǐ，lěng　nuǎn　zì　zhī 】\n			', '\n泛指自己经历的事，自己知道甘苦。同“如人饮水，冷暖自知”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(662, '0:2:8', '山崩水竭', '\n【 shān　bēng　shuǐ　jié 】\n			', '\n山岳崩塌，河川干枯。古代认为是重大事变或其征兆。同“山崩川竭”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(663, '0:2:8', '水碧山青', '\n【 shuǐ　bì　shān　qīng 】\n			', '\n碧：青绿色。形容景色很美，艳丽如画。亦作“水绿山青”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(664, '0:2:8', '水菜不交', '\n【 shuǐ　cài　bù　jiāo 】\n			', '\n比喻彼此经济上没有往来。旧时指官吏清廉。同“水米无干”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(665, '0:2:8', '山长水阔', '\n【 shān　cháng　shuǐ　kuò 】\n			', '\n比喻道路遥远艰险。指见“山长水远”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(666, '0:2:8', '水调歌头', '\n【 shuǐ　diào　gē　tóu 】\n			', '\n词牌名。\n			', '\n相传隋炀帝开汴河时曾制《水调歌》，唐人演为大曲。大曲有散序、中序、入破三部分，“歌头”当为中序的第一章。双调九十四字至九十七字，前后片各四平韵。宋人于前后片中的各两个六字句，多夹叶仄韵。也有平仄互叶几乎句句押韵的。共八体。\n			', '\n暂无\n			'),
(667, '0:2:8', '水底捞月', '\n【 shuǐ　dǐ　lāo　yuè 】\n			', '\n比喻去做根本做不到的事情，只能白费力气。同“水中捞月”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(668, '0:2:8', '水底摸月', '\n【 shuǐ　dǐ　mō　yuè 】\n			', '\n比喻去做根本做不到的事情，只能白费力气。同“水中捞月”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(669, '0:2:8', '水底纳瓜', '\n【 shuǐ　dǐ　nà　guā 】\n			', '\n形容不能容纳。\n			', '\n元·张国宾《合汗衫》第二折：“好家私水底纳瓜，亲子父在拳中的这掿沙。”\n			', '\n我劝他似～，他觑我似镜里观花。\n			'),
(670, '0:2:8', '水到渠成', '\n【 shuǐ　dào　qú　chéng 】\n			', '\n渠：水道。水流到的地方自然形成一条水道。比喻条件成熟，事情自然会成功。\n			', '\n宋·苏轼《答秦太虚书》：“至时别作经画，水到渠成，不须预虑。”\n			', '\n须要自然而然，～，非由车戽，最忌无因而至，突如其来。（清·李渔《闲情偶寄·大收煞》）\n			'),
(671, '0:2:8', '水到鱼行', '\n【 shuǐ　dào　yú　xíng 】\n			', '\n比喻条件具备，事情就可办成。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(672, '0:2:8', '山肤水豢', '\n【 shān　fū　shuǐ　huàn 】\n			', '\n本指山上水中出产的美味食物。后泛称美味。\n			', '\n《乐府诗集·燕射歌辞三·隋元会大飨歌》：“道高物备食多方，山肤既善水豢良。”\n			', '\n暂无\n			'),
(673, '0:2:8', '水光山色', '\n【 shuǐ　guāng　shān　sè 】\n			', '\n泛指山水景色。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(674, '0:2:8', '山高水险', '\n【 shān　gāo　shuǐ　xiǎn 】\n			', '\n比喻前进路上的种种艰难险阻。\n			', '\n明·吴承恩《西游记》：“上西天拜佛走一遭，怕什么山高路险，水阔波狂。”\n			', '\n暂无\n			'),
(675, '0:2:8', '水火不避', '\n【 shuǐ　huǒ　bù　bì 】\n			', '\n指不避艰险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(676, '0:2:8', '水火不辞', '\n【 shuǐ　huǒ　bù　cí 】\n			', '\n指不避艰险。同“水火不避”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(677, '0:2:8', '水火不兼容', '\n【 shuǐ　huǒ　bù　xiāng　róng 】\n			', '\n容：容纳。比喻二者对立，绝不兼容。\n			', '\n《周易·说卦》：“故水火不相逮。”\n			', '\n他们闹得～。\n			'),
(678, '0:2:8', '山寒水冷', '\n【 shān　hán　shuǐ　lěng 】\n			', '\n冷冷清清。形容冬天的景象。\n			', '\n宋·释普济《五灯会元》卷八：“秋至山寒水冷，春来柳绿花红。”\n			', '\n暂无\n			'),
(679, '0:2:8', '水火无情', '\n【 shuǐ　huǒ　wú　qíng 】\n			', '\n指水和火是不讲情面的，如疏忽大意，容易造成灾祸。\n			', '\n元·杨梓《豫让吞炭》第二折：“俺城中把金鼓鸣，正是外合里应，教智伯才知水火无情。”\n			', '\n水火无情，我们都应该提高防范意识。\n			'),
(680, '0:2:8', '水洁冰清', '\n【 shuǐ　jié　bīng　qīng 】\n			', '\n洁：洁白。清：清净。指像冰和水一样洁白清净。形容人的品格高洁或文笔雅致。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(681, '0:2:8', '水净鹅飞', '\n【 shuǐ　jìng　é　fēi 】\n			', '\n比喻人财两失，一无所有。亦比喻民穷财尽。\n			', '\n元·无名氏《云窗梦》第四折：“我则道地北天南，锦营花阵，偎红倚翠，今日个水净鹅飞。”\n			', '\n眼见的吹翻了这家，吹伤了那家，只吹的～罢！\n			'),
(682, '0:2:8', '水尽山穷', '\n【 shuǐ　jìn　shān　qióng 】\n			', '\n穷：尽。山和水都到了尽头。比喻无路可走陷入绝境。\n			', '\n北周·庾信《宇文常神道碑》：“山穷水断，马束桥飞。”\n			', '\n论做官的道理呢，原该追究个～；然既已如此，先让他把这个供画了。\n			'),
(683, '0:2:8', '山砠水厓', '\n【 shān　jū　shuǐ　zhì 】\n			', '\n石山和水滨。泛指荒僻的处所。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(684, '0:2:8', '水激则旱，矢激则远', '\n【 shuǐ　jī　zé　hàn，shǐ　jī　zé　yuǎn 】\n			', '\n水流矢飞，受阻则劲悍而去远。旱，通“悍”。比喻因祸致福。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(685, '0:2:8', '水阔山高', '\n【 shuǐ　kuò　shān　gāo 】\n			', '\n阔：宽，广阔，指有广阔的水面和高大的山脉隔着，不得相通。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(686, '0:2:8', '水枯石烂', '\n【 shuǐ　kū　shí　làn 】\n			', '\n极言历时长久。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(687, '0:2:8', '水落归漕', '\n【 shuǐ　luò　guī　cáo 】\n			', '\n汛期过后，水位下降，河水流入了河槽。\n			', '\n清·曹雪芹《红楼梦》第96回：“今日听了这些话，心里方才水落归漕，倒也喜欢。”\n			', '\n暂无\n			'),
(688, '0:2:8', '水流花落', '\n【 shuǐ　liú　huā　luò 】\n			', '\n①比喻飘泊不定或踪迹无常。②比喻时过境迁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(689, '0:2:8', '水流花谢', '\n【 shuǐ　liú　huā　xiè 】\n			', '\n谢：脱落。指河水流逝，花儿也凋谢了。形容景色凋零残败，用来比喻局面残破，好景已不存在，无法挽回。亦作“花谢水流”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(690, '0:2:8', '水里纳瓜', '\n【 shuǐ　lǐ　nà　guā 】\n			', '\n比喻格格不入，不能相容。\n			', '\n元·乔孟符《两世姻缘》第三折：“我劝谏他似水里纳瓜，他看觑咱如镜里观花。”\n			', '\n暂无\n			'),
(691, '0:2:8', '水流湿，火就燥', '\n【 shuǐ　liú　shī，huǒ　jiù　zào 】\n			', '\n水向湿处流，火往干处烧。指物之气质类似必相感应。后用以比喻事物发展的必然规律。\n			', '\n《易·乾》：“水流湿，火就燥，云从龙，风从虎……各从其类也。”孔颖达疏：“此二者以形象相感。水流於地，先就湿处；火焚其薪，先就燥处。”\n			', '\n暂无\n			'),
(692, '0:2:8', '水流云散', '\n【 shuǐ　liú　yún　sàn 】\n			', '\n比喻时过境迁，人各一方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(693, '0:2:8', '水陆杂陈', '\n【 shuǐ　lù　zái　chén 】\n			', '\n形容菜肴丰富。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(694, '0:2:8', '水满金山', '\n【 shuǐ　mǎn　jīn　shān 】\n			', '\n神话故事。金山，在江苏省镇江市。同“水漫金山”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(695, '0:2:8', '水漫金山', '\n【 shuǐ　màn　jīn　shān 】\n			', '\n神话故事。金山，在江苏省镇江市。\n			', '\n《白雪遗音·马头调·雷峰塔》：“金山寺里法海一见许仙，面带妖色，不放下山。怒恼白蛇，忙唤青儿，带领着虾兵蟹将，这才水漫金山。”\n			', '\n暂无\n			'),
(696, '0:2:8', '水母目虾', '\n【 shuǐ　mǔ　mù　xiā 】\n			', '\n比喻人没有主见，人云亦云。\n			', '\n《文选·郭璞〈江赋〉》：“璅蛣腹蟹，水母目虾。”李善注引《南越志》：“扞水母呴无耳目，故不知避人。常有虾依随之。虾见人则惊，此物亦随之而没。”\n			', '\n暂无\n			'),
(697, '0:2:8', '水明山秀', '\n【 shuǐ　míng　shān　xiù 】\n			', '\n形容风景优美。同“水秀山明”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(698, '0:2:8', '山眉水眼', '\n【 shān　méi　shuǐ　yǎn 】\n			', '\n形容女子眉目清秀水灵。亦作“水眼山眉”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(699, '0:2:8', '水米无干', '\n【 shuǐ　mǐ　wú　gàn 】\n			', '\n比喻彼此经济上没有往来。旧时指官吏清廉。同“水米无交”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(700, '0:2:8', '水佩风裳', '\n【 shuǐ　pèi　fēng　shang 】\n			', '\n以水作佩饰，以风为衣裳。本写美人的妆饰。后用以形容荷叶荷花之状貌。\n			', '\n语出唐·李贺《苏小小墓》诗：“风为裳，水为佩”。\n			', '\n暂无\n			'),
(701, '0:2:8', '山穷水断', '\n【 shān　qióng　shuǐ　duàn 】\n			', '\n比喻无路可走陷入绝境。同“山穷水尽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(702, '0:2:8', '山穷水绝', '\n【 shān　qióng　shuǐ　jué 】\n			', '\n比喻无路可走陷入绝境。见“山穷水尽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(703, '0:2:8', '水穷山尽', '\n【 shuǐ　qióng　shān　jìn 】\n			', '\n水和山都到了尽头，前面无路可走。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(704, '0:2:8', '势如水火', '\n【 shì　rú　shuǐ　huǒ 】\n			', '\n形容双方就像水火一样互相对立，不能相容。\n			', '\n《三国志·蜀志·魏延传》：“惟杨仪不假借延，延以为至忿，有如水火。”\n			', '\n暂无\n			'),
(705, '0:2:8', '菽水承欢', '\n【 shū　shuǐ　chéng　huān 】\n			', '\n菽水：豆和水，指普通饮食；承欢：侍奉父母使其欢喜。指奉养父母，使父母欢乐。\n			', '\n《礼记·檀弓下》：“啜菽饮水尽其欢，斯之谓孝。”\n			', '\n暂无\n			'),
(706, '0:2:8', '剩山残水', '\n【 shèng　shān　cán　shuǐ 】\n			', '\n残破的山河。多形容亡国后的或经过变乱后的土地景物。也比喻未被消除而剩下来的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(707, '0:2:8', '顺水放船', '\n【 shùn　shuǐ　fàng　chuán 】\n			', '\n比喻顺应当时的情势，采取相应的行动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(708, '0:2:8', '水石清华', '\n【 shuǐ　shí　qīng　huá 】\n			', '\n指园林景色清朗秀丽。同“水木清华”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(709, '0:2:8', '似水如鱼', '\n【 sì　shuǐ　rú　yú 】\n			', '\n像鱼和水一样不能离开。形容关系密切，不可分离。多指男女情人。\n			', '\n元·王实甫《西厢记》第五本第四折：“若不是大恩人拔刀相助，怎能勾好夫妻似水如鱼。”明·张凤翼《红拂记·传奇大意》：“李靖人豪，张姬女侠，相逢似水如鱼。”\n			', '\n[正旦唱]这厮只因饱暖生淫欲……[正旦唱]便休想～。\n			'),
(710, '0:2:8', '水剩山残', '\n【 shuǐ　shèng　shān　cán 】\n			', '\n多指亡国或经过变乱后国土分裂、山河残破的景象。\n			', '\n唐·杜甫《陪郑广文游何将军山林》诗之五：“剩水沧江破，残山碣石开”。\n			', '\n暂无\n			'),
(711, '0:2:8', '顺水顺风', '\n【 shùn　shuǐ　shùn　fēng 】\n			', '\n比喻运气好，做事顺利，没有阻碍。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(712, '0:2:8', '顺水推船', '\n【 shùn　shuǐ　tuī　chuán 】\n			', '\n比喻顺应情势说话行事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(713, '0:2:8', '溯水行舟', '\n【 sù　shuǐ　xíng　zhōu 】\n			', '\n指逆水行船。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(714, '0:2:8', '顺水行舟', '\n【 shùn　shuǐ　xíng　zhōu 】\n			', '\n顺着水流的方向行船。比喻顺应情势说话行事。\n			', '\n清·曹雪芹《红楼梦》第四回：“小的闻得老爷补升此任，亦系贾府王府之力，此薛蟠即贾府之亲，老爷何不顺水行舟，作个整人情，将此案了结，日后也好去见贾府王府。”\n			', '\n这男女二家，便～，不费推移之力。\n			'),
(715, '0:2:8', '勺水一脔', '\n【 sháo　shuǐ　yī　luán 】\n			', '\n一勺水，一块肉。比喻量少。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(716, '0:2:8', '水泄不漏', '\n【 shuǐ　xiè　bù　lòu 】\n			', '\n犹言滴水不漏。形容说话慎密。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(717, '0:2:8', '水楔不通', '\n【 shuǐ　xiē　bù　tōng 】\n			', '\n形容拥挤或包围的非常严密。同“水泄不通”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(718, '0:2:8', '水泄不透', '\n【 shuǐ　xiè　bù　tòu 】\n			', '\n形容拥挤或包围的非常严密。同“水泄不通”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(719, '0:2:8', '水洩不通', '\n【 shuǐ　xiè　bù　tōng 】\n			', '\n汇：排泄。象是连水也流不出去。形容拥挤或包围的非常严密。同“水泄不通”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(720, '0:2:8', '水宿风餐', '\n【 shuǐ　xiǔ　fēng　cān 】\n			', '\n水上住宿，临风野餐。形容旅途生活艰苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(721, '0:2:8', '水宿山行', '\n【 shuǐ　xiǔ　shān　xíng 】\n			', '\n夜宿于水，日行于山。形容长途跋涉。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(722, '0:2:8', '水月观音', '\n【 shuǐ　yuè　guān　yīn 】\n			', '\n佛经谓观音菩萨有三十三个不同形象的法身，画作观水中月影状的称水月观音。见《法华经·普门品》。后用以喻人物仪容清。\n			', '\n元·王实甫《西厢记》第一本第一折：“兰麝香仍在，佩环声渐远。东风摇曳垂杨线，游丝牵惹桃花片，珠帘掩映芙蓉面。你道是河中开府相公家，我道是南海水月观音现。”\n			', '\n吴宫西子不如，楚国南威难赛。若比～，一样烧香礼拜。\n			'),
(723, '0:2:8', '水月镜花', '\n【 shuǐ　yuè　jìng　huā 】\n			', '\n水中月，镜中花。比喻虚幻景象。\n			', '\n明·谢榛《四溟诗话》卷一：“诗有可解，不可解，不必解，若水月镜花，勿泥其迹可也。”\n			', '\n～空好看，不过是，今生如此算收梢。\n			'),
(724, '0:2:8', '水远山长', '\n【 shuǐ　yuǎn　shān　cháng 】\n			', '\n①指路程遥远。同“水远山遥”。②指山河辽阔。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(725, '0:2:8', '山遥水远', '\n【 shān　yáo　shuǐ　yuǎn 】\n			', '\n指道路遥远。\n			', '\n宋·杨无咎《玉抱肚》词：“见也浑闲，堪嗟处、山遥水远，音书也无个。” 元·高明《琵琶记·南浦嘱别》：“［生］娘子，莫不是虑着山遥水远么？［旦］奴不虑山遥水远。”\n			', '\n久闻将军大名，争耐～，无由拜见威颜。\n			'),
(726, '0:2:8', '水远山遥', '\n【 shuǐ　yuǎn　shān　yáo 】\n			', '\n指路程遥远。\n			', '\n宋·汪元量《忆秦娥》词之七：“心如焦。彩笺难寄，水远山遥。”元·关汉卿《哭存孝》第四折：“我避不得水远山遥，须有一个日头走到。”\n			', '\n淅零零洒琼瑶，乱纷纷剪鹅毛。越映的江阔天低，～。\n			'),
(727, '0:2:8', '水长船高', '\n【 shuǐ　zhǎng　chuán　gāo 】\n			', '\n比喻事物随着所凭借的基础的提高而提高。\n			', '\n宋·释普济《五灯会元·芭蕉清禅师法嗣·芭蕉继彻禅师》：“水长船高，泥多佛大。”\n			', '\n长姐儿更不想到此时～，不曾吃尽苦中苦，早得修成人上人，一时好不兴致，连忙又给太太磕了个头。\n			'),
(728, '0:2:8', '山重水复', '\n【 shān　zhòng　shuǐ　fù 】\n			', '\n指山峦重迭，水流盘曲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(729, '0:2:8', '水中捉月', '\n【 shui　zhong　zhuo　yue 】\n			', '\n比喻空虚幻想，不能实现。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(730, '0:2:8', '水中著盐', '\n【 shuǐ　zhōng　zhuó　yán 】\n			', '\n比喻不着痕迹。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(731, '0:2:8', '水则载舟，水则覆舟', '\n【 shuǐ　zé　zài　zhōu，shuǐ　zé　fù　zhōu 】\n			', '\n水能载舟，也能覆舟。比喻民可拥护君主，也能推翻君主。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(732, '0:2:8', '听风听水', '\n【 tīng　fēng　tīng　shuǐ 】\n			', '\n形容善于赏玩自然景色。\n			', '\n相传龟兹国王与乐人于大山间倾听风和水声，感兴而制乐。唐·王建《霓裳辞》之一：“弟子部中留一色，听风听水作《霓裳》。”\n			', '\n《霓裳曲》，前世传记论说颇详，不知～为何事也。白乐天有《霓裳歌》甚详，亦无风水之说，第记之，或有遗亡者尔。\n			'),
(733, '0:2:8', '桃花流水', '\n【 táo　huā　liú　shuǐ 】\n			', '\n形容春日美景。也比喻男女爱情。\n			', '\n唐·李白《山中问答》诗：“桃花流水窅然去，别有天地非人间。”\n			', '\n～，不出人间。\n			'),
(734, '0:2:8', '拖人落水', '\n【 tuō　rén　luò　shuǐ 】\n			', '\n犹言拖人下水。比喻勉强人一道做他不愿做的事（多指坏事）。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(735, '0:2:8', '无根之木，无源之水', '\n【 wú　gēn　zhī　mù，wú　yuán　zhī　shuǐ 】\n			', '\n比喻没有根据的事物。\n			', '\n语出《左传·昭公九年》：“我在伯父，犹衣服之有冠冕，木水之有本原。”\n			', '\n暂无\n			'),
(736, '0:2:8', '无源之水，无本之木', '\n【 wú　yuán　zhī　shuǐ，wú　běn　zhī　mù 】\n			', '\n源：水源；本：树根。没有源头的水，没有根的树。比喻没有基础的事物。\n			', '\n《左传·昭公九年》：“我在伯父，犹衣服之有冠冕，木水之有本原。”\n			', '\n理性的东西所以靠得住，正是由于它来源于感性，否则理性的东西就成了～。（毛泽东《实践论》）\n			'),
(737, '0:2:8', '无源之水，无本之末', '\n【 wú　yuán　zhī　shuǐ，wú　běn　zhī　mò 】\n			', '\n没有源头的水，没有根的树。比喻没有基础的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(738, '0:2:8', '悬河注水', '\n【 xuán　hé　zhù　shuǐ 】\n			', '\n比喻以强大力量去消灭敌方。同“悬河泻水”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(739, '0:2:8', '心如止水', '\n【 xīn　rú　zhǐ　shuǐ 】\n			', '\n形容心境平静，毫无杂念。\n			', '\n唐·白居易《祭李侍郎文》：“浩浩世途，是非同轨；齿牙相轧，波澜四起。公独何人，心如止水；风雨如晦，鸡鸣不已。”\n			', '\n屡遭情变之后，她已然～，古井无波。\n			'),
(740, '0:2:8', '心同止水', '\n【 xīn　rú　zhǐ　shuǐ 】\n			', '\n形容心境平静，毫无杂念。同“心如止水”。\n			', '\n唐·白居易《答元八郎中、杨十二博士》诗：“身觉浮云无所著，心同止水有何情。但知潇洒疏朝市, 不要崎岖隐姓名。”\n			', '\n骨将槁木齐，～净。笔头指金波，座上横玉柄。\n			'),
(741, '0:2:8', '宿水飡风', '\n【 xiǔ　shuǐ　cān　fēng 】\n			', '\n形容旅途或野外生活的艰苦。同“宿水餐风”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(742, '0:2:8', '宿水餐风', '\n【 xiǔ　shuǐ　cān　fēng 】\n			', '\n形容旅途或野外生活的艰苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(743, '0:2:8', '显山露水', '\n【 xiǎn　shān　lù　shuǐ 】\n			', '\n比喻出名，显露才能。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(744, '0:2:8', '秀水明山', '\n【 xiù　shuǐ　míng　shān 】\n			', '\n山光明媚，水色秀丽。形容风景优美。\n			', '\n宋·黄庭坚《蓦山溪·赠衡阳陈湘》：“眉黛敛秋波，尽湖南，山明水秀。”\n			', '\n～抱复回，风流文采胜蓬莱。\n			'),
(745, '0:2:8', '一尺水翻腾做百丈波', '\n【 yī　chǐ　shuǐ　fān　téng　zuò　bǎi　zhàng 】\n			', '\n比喻说话夸大之极。同“一尺水翻腾做一丈波”。\n			', '\n元·王晔《桃花女》第二折：“你将那半句话搬调做十分事，一尺水翻腾做百丈波。”\n			', '\n暂无\n			'),
(746, '0:2:8', '一尺水翻腾做一丈波', '\n【 yī　chǐ　shuǐ　fān　téng　zuò　yī　zhàng　 】\n			', '\n比喻说话夸大之极。\n			', '\n元·无名氏《争报恩》第三折：“那妮子一尺水翻腾做一丈波，怎当他只留支剌信口开合。”\n			', '\n暂无\n			'),
(747, '0:2:8', '油光水滑', '\n【 yóu　guāng　shuǐ　huá 】\n			', '\n①形容光滑润泽。②形容人的圆滑、狡诈。\n			', '\n《儿女英雄传》第七回：“原来这顶柜子里面，中腰不安抽屉，下面也没榻板；那后面的背板一扇到底抹的油光水滑，像是常有人出入的样子。”\n			', '\n这东昌巡道衙门住扎临清；因临清是马头所在，有那班～的光棍，真是‘天高皇帝远’晓得怕些什么。\n			'),
(748, '0:2:8', '杨花水性', '\n【 yáng　hu　huǐ　xìng 】\n			', '\n柳絮飘扬，水性流动，因以“杨花水性”比喻轻薄女子等用情不专。\n			', '\n清·李宝嘉《官场现形记》第四十三回：“不过瞿耐庵惧内得很，一直不敢接他上任。那爱珠又是堂子里出身，杨花水性。”\n			', '\n暂无\n			'),
(749, '0:2:8', '一廉如水', '\n【 yī　lián　rú　shuǐ 】\n			', '\n为官廉洁，如流水一样清洁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(750, '0:2:8', '远水不救近火', '\n【 yuǎn　shuǐ　bù　jiù　jìn　huǒ 】\n			', '\n远处的水救不了近处的火。比喻慢的办法救不了急。\n			', '\n《韩非子·说林上》：“失火而取水于海，海水虽多，火必不灭矣，远水不救近火也。”\n			', '\n为今之计，到临安取救是～。（清·吴趼人《痛史》第三回）\n			'),
(751, '0:2:8', '远水不解近渴', '\n【 yuǎn　shuǐ　bù　jiě　jìn　kě 】\n			', '\n比喻慢的办法救不了急。\n			', '\n《韩非子·说林上》：“失火而取水于海，海水虽多，火必不灭矣，远水不救近火也。”\n			', '\n暂无\n			'),
(752, '0:2:8', '依山傍水', '\n【 yī　shān　bàng　shuǐ 】\n			', '\n指地理位置靠近山岭和水流。\n			', '\n宋·叶適《安集两淮申省状》：“奔迸渡江求活者几二十万家，而依山傍水相保聚以自固者亦几二十万家。”\n			', '\n维曰：陈仓城池坚固，郝昭守御甚密，又得王双相助，实不可取。不若令一大将，～，下寨固守。\n			'),
(753, '0:2:8', '饮水辨源', '\n【 yǐn　shuǐ　biàn　yuán 】\n			', '\n比喻明白事物的本源。同“饮水知源”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(754, '0:2:8', '沂水春风', '\n【 yí　shuǐ　chūn　fēng 】\n			', '\n沂水：河水名，在山东省曲阜县境内，孔子出生地。春风：春天和暖的风，比喻良好的熏陶和教育。来自沂水的春风。比喻深受孔学的教育与熏陶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(755, '0:2:8', '遇水迭桥', '\n【 yù　shuǐ　dié　qiáo 】\n			', '\n遇水阻拦，就架桥通过。形容不怕阻力，奋勇前进。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(756, '0:2:8', '遇水叠桥', '\n【 yù　shuǐ　dié　qiáo 】\n			', '\n遇水阻拦，就架桥通过。形容不怕阻力，奋勇前进。\n			', '\n元·无名氏《衣袄车》第二折：“也不用排军校，你端的逢山开道，遇水叠桥。”明·吴承恩《西游记》第四十八回：“老施主见得最是，但我还有三个小徒，逢山开路，遇水叠桥，保护贫僧，方得到此。”\n			', '\n军旅逢山开路，～，岂有泥泞不堪行之理！\n			'),
(757, '0:2:8', '鱼水和谐', '\n【 yú　shuǐ　hé　xié 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n元·王子一《误人桃源》第四折：“今日也鱼水和谐，燕莺成对，琴瑟相调。”\n			', '\n记得当初花正开，遇乔才，在阳台，～呀鱼水和谐。\n			'),
(758, '0:2:8', '远水解不了近渴', '\n【 yuǎn　shuǐ　jiě　bù　liǎo　jìn　kě 】\n			', '\n比喻慢的办法救不了急。\n			', '\n清·曹雪芹《红楼梦》：“这也容易，只是‘远水解不得近渴’。”\n			', '\n离咱们这儿远得很呢！～呀！\n			'),
(759, '0:2:8', '远水救不得近火', '\n【 yuǎn　shuǐ　jiù　bù　dé　jìn　huǒ 】\n			', '\n比喻缓慢的救助不能解决眼前的急难。\n			', '\n明·凌濛初《二刻拍案惊奇》卷三：“只是远水救不得近火，小兄其实等不得那从容的事了。”\n			', '\n如今～，就是我们再帮点忙，至多再凑了几百银子，也无济于事。\n			'),
(760, '0:2:8', '遇水架桥', '\n【 yù　shuǐ　jià　qiáo 】\n			', '\n遇水阻拦，就架桥通过。形容不怕阻力，奋勇前进。\n			', '\n康濯《太阳初升的时候·竞赛》：“他们的劲头都鼓的当当响，真是逢山开路，遇水架桥，一气儿跑步向前。”\n			', '\n暂无\n			'),
(761, '0:2:8', '以水济水', '\n【 yǐ　shuǐ　jǐ　shuǐ 】\n			', '\n用水来给水增味。比喻随声附和，对事情没有好处。\n			', '\n《左传·昭公二十年》：“君所谓可，据亦曰可，君所谓否，据亦曰否。若以水济水，谁能食之？”\n			', '\n有可而无否，其弊必至于～之喻。（宋·杨万里《驳配向不当议》）\n			'),
(762, '0:2:8', '以水救水', '\n【 yǐ　shuǐ　jiù　shuǐ 】\n			', '\n引水来救水灾，水势越盛。比喻不仅不加以制止，相反更助长其势。\n			', '\n《庄子·人世间》：“是以火救火，以水救水，名之曰‘益多’。”\n			', '\n暂无\n			'),
(763, '0:2:8', '饮水栖衡', '\n【 yǐn　shuǐ　qī　héng 】\n			', '\n喝水充饥，住简陋房屋。形容生活清苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(764, '0:2:8', '引水入墙', '\n【 yǐn　shuǐ　rù　qiáng 】\n			', '\n比喻自招灾祸。\n			', '\n清·文康《儿女英雄传》第四回：“这不是我自己引水入墙，开门揖盗么。”\n			', '\n暂无\n			'),
(765, '0:2:8', '鱼水深情', '\n【 yú　shuǐ　shēn　qíng 】\n			', '\n象鱼儿离不开水那样，关系密切，感情深厚。\n			', '\n明·赵弼《蓬莱先生传》：“鱼水之情，极其娱乐。”\n			', '\n暂无\n			'),
(766, '0:2:8', '饮水食菽', '\n【 yǐn　shuǐ　shí　shū 】\n			', '\n形容生活清苦。同“饮水啜菽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(767, '0:2:8', '饮水思源', '\n【 yǐn　shuǐ　sī　yuán 】\n			', '\n喝水的时候想起水是从哪儿来的。比喻不忘本。\n			', '\n北周·庾信《徵调曲》：“落其实者思其树，饮其流者怀其源。”\n			', '\n这也是他～的意思。（清·吴趼人《二十年目睹之怪现状》第七十八回）\n			'),
(768, '0:2:8', '以水投水', '\n【 yǐ　shuǐ　tóu　shuǐ 】\n			', '\n把一条河里的水倒到另一条河里。比喻事物相似，很难辨别。\n			', '\n《列子·说符》：“白公问曰：‘若石水投水，何如？’孔子曰：‘吴之善没者能取之。’曰：‘若以水投水，何如？’孔子曰：‘淄渑之合，易牙尝而知之。’”\n			', '\n暂无\n			'),
(769, '0:2:8', '以水投石', '\n【 yǐ　shuǐ　tóu　shí 】\n			', '\n比喻意见相左，不能为对方所接受。\n			', '\n三国·魏·李康《运命论》：“其言也。如以水投石，莫之受也。”\n			', '\n暂无\n			'),
(770, '0:2:8', '沂水舞雩', '\n【 yí　shuǐ　wǔ　yú 】\n			', '\n指知时处世，逍遥游乐。\n			', '\n语出《论语·先进》：“浴乎沂，风乎舞雩。”\n			', '\n亮今甚贫，疑此景之可致，故以为可只作富贵者之事业。而来谕便谓‘做～意思不得，亦不是抱膝长啸底气象’。如此则咳嗽亦不可矣。\n			'),
(771, '0:2:8', '沂水弦歌', '\n【 yí　shuǐ　xián　gē 】\n			', '\n指知时处世，逍遥游乐。\n			', '\n语出《论语·先进》：“[曾点]曰：‘莫春者，春服既成，冠者五六人，童子六七人，浴乎沂，风乎舞雩，咏而归。’”\n			', '\n～重曾点，菑川故旧识平津。\n			'),
(772, '0:2:8', '鱼水相欢', '\n【 yú　shuǐ　xiāng　huān 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n明·沈仕《新水令·闺情》套曲：“着甚来由，晓夜无休，又不是鱼水相欢，胶漆相投。”\n			', '\n暂无\n			'),
(773, '0:2:8', '鱼水相投', '\n【 yú　shuǐ　xiāng　tóu 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n明·袁凫公《八声甘州·代周非月赋别阿蝉》套曲：“冤家聚首，似漆胶相和，鱼水相投。”\n			', '\n暂无\n			'),
(774, '0:2:8', '以水洗血', '\n【 yǐ　shuǐ　xǐ　xuè 】\n			', '\n指消除冤仇，以求和好。\n			', '\n《旧唐书·源休传》：“吾今以水洗血，不亦善乎！”\n			', '\n暂无\n			'),
(775, '0:2:8', '饮水知源', '\n【 yǐn　shuǐ　zhī　yuán 】\n			', '\n比喻明白事物的本源。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(776, '0:2:8', '云心水性', '\n【 yún　xīn　shuǐ　xìng 】\n			', '\n指女子作风轻浮，爱情不专一。\n			', '\n明·叶宪祖《鸾鎞记·喜谐》：“若是云心水性情分寡，怎供出梦蝶寻花。”\n			', '\n暂无\n			'),
(777, '0:2:8', '盈盈秋水', '\n【 yíng　yíng　shuǐ　qiū 】\n			', '\n秋水：比喻美女的眼睛象秋天明净的水波一样。形容女子眼神饱含感情。\n			', '\n元·王实甫《西厢记》第三本第二折：“望穿他盈盈秋水，蹙损他淡淡春山。”\n			', '\n一般情况，几回断肠，只落得～泪汪汪。\n			'),
(778, '0:2:8', '盈盈一水', '\n【 yíng　yíng　yī　shuǐ 】\n			', '\n比喻相隔不远。\n			', '\n《古诗十九首》之十：“盈盈一水间，脉脉不得语。”\n			', '\n暂无\n			'),
(779, '0:2:8', '沾泥带水', '\n【 zhān　ní　dài　shuǐ 】\n			', '\n比喻说话、写文章不简洁或办事不干脆。\n			', '\n清·李渔《闲情偶寄·演习·授曲》：“一有字迹，则沾泥带水，有不如无矣。”\n			', '\n暂无\n			'),
(780, '0:2:8', '舟水之喻', '\n【 zhōu　shuǐ　zhī　yù 】\n			', '\n舟：船。对船和水的比喻，即水可以载舟，也可覆舟。老百姓可以帮助君王建立朝廷，也可以起来反抗推翻朝廷。\n			', '\n《三国志·魏志·王基传》：“愿陛下深察东野之弊，留意舟水之喻，息奔驷于未尽，节力役于未困。”\n			', '\n暂无\n			'),
(781, '0:2:8', '酌水知源', '\n【 zhuó　shuǐ　zhī　yuán 】\n			', '\n饮水要明白它的来源。比喻不忘本。\n			', '\n明·张居正《答上师相徐存斋书》之二六：“谬膺重任，得免愆尤，实老师教庇所及，酌水知源，敢忘衔结。”\n			', '\n暂无\n			'),
(782, '0:2:8', '自相水火', '\n【 zì　xiāng　shuǐ　huǒ 】\n			', '\n自己人互相像水火那样不能相容。\n			', '\n《东周列国志》第九十六回：“今大王所恃重臣二人，而使自相水火，非社稷之福也。”\n			', '\n暂无\n			'),
(783, '0:2:9', '笔底春风', '\n【 bǐ　dǐ　chūn　fēng 】\n			', '\n形容绘画、诗文生动，如春风来到笔下。\n			', '\n元·黄溍《瑶池春宴图》诗：“西飞青雀几时还，贝阙琳宫缥缈间，笔底春风殊未老，蟠桃积核已如山。”\n			', '\n暂无\n			'),
(784, '0:2:9', '毕雨箕风', '\n【 bì　yǔ　jī　fēng 】\n			', '\n原指民性如星，星好风雨，比喻庶民喜好人主的恩泽。后为颂扬统治者普施仁政之词。\n			', '\n《书·洪范》：“庶民惟星，星有好风，星有好雨。”孔传：“箕星好风，毕星好雨，亦民所好。”\n			', '\n使雷车电椅，扫荡四方；～，稣舒品物。\n			'),
(785, '0:2:9', '趁风使柁', '\n【 chèn　fēng　shǐ　duò 】\n			', '\n犹看风使舵。比喻随机应变或迎合别人行事。\n			', '\n明·冯梦龙《万事足·筵中治妒》：“那没廉耻的，假哭佯啼；你呵卵脬的，不要趁风使柁。”\n			', '\n暂无\n			'),
(786, '0:2:9', '传风扇火', '\n【 chuán　fēng　shān　huǒ 】\n			', '\n犹扇风点火。比喻鼓动别人做某种事。多用于贬义。\n			', '\n康濯《春种秋收·故事》：“这么传风扇火，直扇得玉翠她爹都受了传染——天天替女儿着急，时时埋怨女儿眼皮太高。”\n			', '\n暂无\n			'),
(787, '0:2:9', '当耳旁风', '\n【 dāng　ěr　páng　fēng 】\n			', '\n见“当耳边风”。当做耳边吹过的风。比喻对所听的话不放在心上。\n			', '\n语出汉·赵晔《吴越春秋·吴王寿梦传》：“富贵之於我，如秋风之过耳。”\n			', '\n袭人道：‘一百年还记着呢！比不得你，拿着我的话～，夜里说了，早起就忘了。’\n			'),
(788, '0:2:9', '东风射马耳', '\n【 dōng　fēng　shè　mǎ　ěr 】\n			', '\n射：射出。比喻把别人的话当作耳边风，充耳不闻，无动于衷。\n			', '\n唐·李白《答王十二寒夜独酌有怀》诗：“世人闻此皆掉头，有如东风射马耳。”\n			', '\n我的话对你来说还不是～了。\n			'),
(789, '0:2:9', '耳旁风', '\n【 ěr　páng　fēng 】\n			', '\n同“耳边风”。在耳边吹过的风。比喻听了不放在心上的话。\n			', '\n清·曹雪芹《红楼梦》第二十一回：“又听袭人叹道：‘姊妹们和气，也有个分寸礼节，也没个黑家白日闹的！凭人怎么劝，都是耳旁风。”\n			', '\n暂无\n			'),
(790, '0:2:9', '风驰草靡', '\n【 fēng　chí　cǎo　mǐ 】\n			', '\n比喻强大的势力能制服一切。同“风行草靡”。\n			', '\n唐·温大雅《大唐创业起居注》卷二：“敦煌公至盩厔，所过诸县及诸贼界，莫不风驰草靡，裹粮卷甲，唯命是从。”\n			', '\n暂无\n			'),
(791, '0:2:9', '风驰电骋', '\n【 fēng　chí　diàn　chěng 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n汉·严遵《道德指归论·至柔》：“故字曰至柔，名曰无形，是以无形之物不以坚，坚不以壮。壮，故能敝天地，销铜铁，风驰电骋，经极日月，周流上下。”\n			', '\n暂无\n			'),
(792, '0:2:9', '风驰电赴', '\n【 fēng　chí　diàn　fù 】\n			', '\n形容迅速赶赴。\n			', '\n《晋书·孙绰传》：“如其迷逆不化，复欲送死者，南北诸军风驰电赴，若身手之救痛痒，率然之应首尾，山陵既固，中夏小康。”\n			', '\n暂无\n			'),
(793, '0:2:9', '风驰电击', '\n【 fēng　chí　diàn　jī 】\n			', '\n形容迅速出击。\n			', '\n《六韬·龙韬·王翼》：“奋威四人，主择材力，论兵革，风驰电击，不知所由。”\n			', '\n王师北伐如宣王，～复土疆。\n			'),
(794, '0:2:9', '风驰电卷', '\n【 fēng　chí　diàn　juǎn 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n唐·温大雅《大唐创业起居注》卷一：“突厥所长，惟恃骑射，见利即前，知难便走，风驰电卷，不恒其陈。”\n			', '\n马夫拉动缰绳，一会儿～，把一个青年会会员陈千秋，不知赶到哪里去了。\n			'),
(795, '0:2:9', '风驰电逝', '\n【 fēng　chí　diàn　shì 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n三国·魏·嵇康《赠秀才入军》：“风驰电逝，蹑景追风；凌历中原，顾盼生姿。”\n			', '\n柏夭导车，造父为右，～三千里。\n			'),
(796, '0:2:9', '风吹日晒', '\n【 fēng　chuī　rì　shài 】\n			', '\n狂风吹，烈日晒。形容无所遮挡。\n			', '\n梁斌《红旗谱》二十七：“你风吹日晒地辛苦一年，连个痛快年也过不上。”\n			', '\n过去被忘却了的煤堆，～，现在忽然大家争着去把他团成煤球收藏起来。\n			'),
(797, '0:2:9', '风驰霆击', '\n【 fēng　chí　tíng　jī 】\n			', '\n形容迅速出击。同“风驰电击”。\n			', '\n陈炽《庸书·议院》：“华盛顿以编户之细民，苦英人之虐政，风驰霆击，崛起美洲。”\n			', '\n暂无\n			'),
(798, '0:2:9', '风驰云卷', '\n【 fēng　chí　yún　juǎn 】\n			', '\n形容迅速席卷。\n			', '\n邹鲁《中国同盟会》：“西北则张乐行等风驰云卷，天下已非满洲所有，其督师大臣赛尚阿、和春一败涂地，事无可为。”\n			', '\n暂无\n			'),
(799, '0:2:9', '风驰雨骤', '\n【 fēng　chí　yǔ　zhòu 】\n			', '\n形容像风雨一样迅捷猛烈。\n			', '\n《旧五代史·梁书·谢彦章传》：“每敦阵整旅，左旋右抽，虽风驰雨骤，亦无以喻其迅捷也，故当时骑士咸乐为用。”\n			', '\n任大老爷亲自骑着快马，带着八十名亲兵小队，～的在后赶来。\n			'),
(800, '0:2:9', '风驰云走', '\n【 fēng　chí　yún　zǒu 】\n			', '\n形容奔驰疾速。\n			', '\n唐·牛僧孺《玄怪录·岑顺》：“三奏金革，四门出兵，连旗万计，风驰云走，两皆列阵。”\n			', '\n骋骅骝，～，防他重伤未死，一息尚弥留。\n			'),
(801, '0:2:9', '风尘之会', '\n【 fēng　chén　zhī　huì 】\n			', '\n风尘：比喻战乱；会：时机。指战乱发生之际。\n			', '\n东汉·班固《答宾戏》：“彼皆蹑风尘之会，履颠沛之势。”\n			', '\n遇～，必有陵霄之志。\n			'),
(802, '0:2:9', '风风韵韵', '\n【 fēng　fēng　yùn　yùn 】\n			', '\n①形容韵致、意态美好。②声音悠长婉转的样子。\n			', '\n金·董解元《西厢记诸宫调》卷三：“好风风韵韵，捻捻腻腻，济济楚楚。”\n			', '\n月下金觥，膝上瑶筝，口口声声，～。\n			'),
(803, '0:2:9', '风和日美', '\n【 fēng　hé　rì　měi 】\n			', '\n微风和畅，阳光明丽。同“风和日丽”。\n			', '\n清·黄宗羲《敬槐诸君墓志铭》：“风和日美，余掉短胕，老母揭女孙泛汝仇湖。”\n			', '\n暂无\n			'),
(804, '0:2:9', '风和日暄', '\n【 fēng　hé　rì　xuān 】\n			', '\n微风和畅，阳光温暖。见“风和日暖”。\n			', '\n明·汪廷讷《狮吼记·赏春》：“风和日暄，燕交飞触碎胭脂片。”\n			', '\n暂无\n			'),
(805, '0:2:9', '风激电飞', '\n【 fēng　jī　diàn　fēi 】\n			', '\n形容势猛。\n			', '\n《三国志·蜀志·郤正传》：“云合雾集，风激电飞，量时揆宜，用取世资。”\n			', '\n暂无\n			'),
(806, '0:2:9', '风激电骇', '\n【 fēng　jī　diàn　hài 】\n			', '\n形容势猛。同“风激电飞”。\n			', '\n《南史·梁纪上·武帝》：“凭险作守，兵食兼资，风激电骇，莫不震叠。”\n			', '\n暂无\n			'),
(807, '0:2:9', '风举云飞', '\n【 fēng　jǔ　yún　fēi 】\n			', '\n凭借风云飞腾而上。同“风举云摇”。\n			', '\n《宋史·乐志七 》：“神驾来思，风举云飞。”\n			', '\n暂无\n			'),
(808, '0:2:9', '风举云摇', '\n【 fēng　jǔ　yún　yáo 】\n			', '\n凭借风云飞腾而上。亦比喻飞黄腾达。\n			', '\n汉·班固《西都赋》：“遂乃风举云摇，浮游溥览。”唐·王勃《九成宫颂》：“风举云摇，历神都而一憩。”\n			', '\n赐金分帛奉恩辉，～人紫微。\n			'),
(809, '0:2:9', '风雷火炮', '\n【 fēng　léi　huǒ　pào 】\n			', '\n形容十分急躁。\n			', '\n清·吴研人《二十年目睹之怪现状》第五十二回：“上前天我们才到上海，货还没有起完，到了半夜里，忽然宪太太来了，风雷火炮的一阵，马上就要开船，脸上很带点怒色。”\n			', '\n暂无\n			'),
(810, '0:2:9', '风雷之变', '\n【 fēng　léi　zhī　biàn 】\n			', '\n指上天示警的灾异现象。\n			', '\n据《书·金縢》载：周武王死后，周公摄政，镇压了武王的弟弟管叔、蔡叔等的叛乱。武王子成王因受流言影响，怀疑周公的忠诚，于是“天大雷电以风，禾尽偃，大木斯拔，邦人大恐。”\n			', '\n夏四月，京师地震。癸巳司空陈褒以灾异免。于是犹有～，有司复以追咎三公。\n			'),
(811, '0:2:9', '风马不接', '\n【 fēng　mǎ　bù　jiē 】\n			', '\n犹言风马牛不相及。\n			', '\n《宋书·隐逸传·王弘之》：“凡祖离送别，必在有情，下官与殷风马不接，无缘扈从。”\n			', '\n暂无\n			'),
(812, '0:2:9', '风马牛', '\n【 fēng　mǎ　niú 】\n			', '\n风：放逸，走失。指齐楚两地相离甚远，马牛不会走失至对方地界。后用以比喻事物之间毫不相干。同“风马牛不相及”。\n			', '\n唐·段成式《酉阳杂俎·盗侠》：“唐责之：‘某与公风马牛耳，不意盱眙相遇，实慕君子，何至驺卒不若也。’”\n			', '\n至于释迦牟尼，可更与文艺界～了。\n			'),
(813, '0:2:9', '风门水口', '\n【 fēng　mén　shuǐ　kǒu 】\n			', '\n指要冲。\n			', '\n明·施耐庵《水浒传》第一百十一回：“如今听得朝廷起大军来，与方腊厮杀，我这里正是风门水口。有些人家都搬了别处去躲。只留下老身，在这里看屋。”\n			', '\n暂无\n			'),
(814, '0:2:9', '风马云车', '\n【 fēng　mǎ　yún　chē 】\n			', '\n指神灵的车马。\n			', '\n唐·柳宗元《雷塘祷雨文》：“风马云车，肃焉徘徊。”\n			', '\n～历历，见桂葆乍迎娇如雪。\n			'),
(815, '0:2:9', '风牛马不相及', '\n【 fēng　niú　mǎ　bù　xiāng　jí 】\n			', '\n比喻事物彼此毫不相干。同“风马牛不相及”。\n			', '\n梁启超《天演学初祖达尔文之学说及其传略》：“夫孰知兰之生产，与彼风牛马不相及之猫，有此若大关系乎？”\n			', '\n暂无\n			'),
(816, '0:2:9', '风驱电击', '\n【 fēng　qū　diàn　jī 】\n			', '\n形容迅速出击。同“风驰电击”。\n			', '\n《宋书·谢晦传》：“散骑常侍、骁骑将军段宏铁马二千，风驱电击，步自竟陵，直至鄢郢。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(817, '0:2:9', '风驱电扫', '\n【 fēng　qū　diàn　sǎo 】\n			', '\n形容像刮风、闪电那样迅速驰赴和扫除。\n			', '\n《南齐书·裴叔业崔慧景等传论》：“征虏将军投袂以先国急，束马旅师，横江竞济，风驱电扫，制胜转丸。”\n			', '\n平生闻谭公胸中数万甲兵，所至～，今治蜀顾如此，乃知宏才不器，无适非宜，哲士达权，随时善变也。\n			'),
(818, '0:2:9', '风清月白', '\n【 fēng　qīng　yuè　bái 】\n			', '\n微风清凉，月色皎洁。形容夜景幽美宜人。同“风清月皎”。\n			', '\n宋·欧阳修《采桑子》词：“风清月白偏宜夜，一片琼田。”\n			', '\n后～之夕，每见其魂在墓前松柏下，摇首独步。\n			'),
(819, '0:2:9', '风轻云净', '\n【 fēng　qīng　yún　jìng 】\n			', '\n微风轻拂，浮云淡薄。形容天气晴好。同“风轻云淡”。\n			', '\n《群英类选〈分钗记·春游遇妓〉》：“风轻云净，绝胜蓬莱佳境。”\n			', '\n暂无\n			'),
(820, '0:2:9', '风清月明', '\n【 fēng　qīng　yuè　míng 】\n			', '\n微风清凉，月光明朗。形容夜景美好。同“风清月朗”。\n			', '\n明·刘基《横碧楼记》：“又闻柯亭有美竹，可为笛，风清月明，登楼一吹，可以来凤凰，惊蛰龙，真奇事也。”\n			', '\n暂无\n			'),
(821, '0:2:9', '风情月意', '\n【 fēng　qíng　yuè　yì 】\n			', '\n指男女相互爱恋的情思。同“风情月思”。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第九回：“眉似初春柳叶，常含着雨恨云愁；脸如三月桃花，暗带着风情月意。”\n			', '\n暂无\n			'),
(822, '0:2:9', '毁风败俗', '\n【 huǐ　fēng　bài　sú 】\n			', '\n败坏良好的风俗。同“伤风败俗”。\n			', '\n《晋书·刘毅传》：“毁风败俗，无益于化；古今之失，莫大于此。”\n			', '\n暂无\n			'),
(823, '0:2:9', '黄风雾罩', '\n【 huáng　fēng　wù　zhào 】\n			', '\n犹言不守本分，胡乱行事。\n			', '\n柳青《创业史》第一部第十七章：“他决不容让生宝这样黄风雾罩地闹腾。”\n			', '\n暂无\n			'),
(824, '0:2:9', '疾恶如风', '\n【 jí　è　rú　fēng 】\n			', '\n痛恨坏人坏事就像狂风猛扫一样。\n			', '\n《后汉书·陈蕃传》：“震（朱震）字伯厚，初为州从事，奏济阴太守单匡臧罪，并连匡兄中常侍车骑将军超。桓帝收匡下廷尉，以谴超，超诣狱谢。三府谚曰：‘车如鸡栖马如狗，疾恶如风朱伯厚。’”\n			', '\n～最不平，天涯何处有荆卿。\n			'),
(825, '0:2:9', '疾风甚雨', '\n【 jí　fēng　shèn　yǔ 】\n			', '\n指大风急雨。\n			', '\n语出《礼记·玉藻》：“君子之居恒当户，寝恒东首，若有疾风、迅雷、甚雨，则必变，虽夜必兴，衣服冠而坐。”\n			', '\n去冬节一百五日，即有～，谓之寒食。\n			'),
(826, '0:2:9', '疾风彰劲草', '\n【 jí　fēng　zhāng　jìn　cǎo 】\n			', '\n比喻只有经过严峻的考验，才知道谁真正坚强。同“疾风知劲草”。\n			', '\n《晋书·宗室传论》：“洎高贵薨殂，则枕尸流恸；陈留就国，则拜辞陨涕。语曰‘疾风彰劲草’，献王其有焉。”\n			', '\n暂无\n			'),
(827, '0:2:9', '急如风火', '\n【 jí　rú　fēng　huǒ 】\n			', '\n急得像疾风烈火一样。形容十分急迫。\n			', '\n《西游补》第九回：“你要图成和议，急如风火，却如何等得这三日过呢？”\n			', '\n暂无\n			'),
(828, '0:2:9', '箕山之风', '\n【 jī　shān　zhī　fēng 】\n			', '\n指隐士的风范。\n			', '\n清·王晫《今世说·雅量》：“[丁药园]谪居五载，略无迁谪状，躬耕自乐，洒然有箕山之风。”\n			', '\n暂无\n			'),
(829, '0:2:9', '疾雨暴风', '\n【 jí　yǔ　bào　fēng 】\n			', '\n指来势急遽而猛烈的风雨。同“暴风疾雨”。\n			', '\n晋·干宝《搜神记》卷四：“是日果有疾雨暴风，从太公邑外而过。”\n			', '\n暂无\n			'),
(830, '0:2:9', '流风余俗', '\n【 liú　fēng　yú　sú 】\n			', '\n指遗留的风气、习俗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(831, '0:2:9', '满袖春风', '\n【 mǎn　xiù　chūn　fēng 】\n			', '\n衣袖飘曳生风。形容十分得意。\n			', '\n元·张可久《水仙子》曲：“翰林风月进多才，满袖春风下玉阶。”\n			', '\n暂无\n			'),
(832, '0:2:9', '拏风跃云', '\n【 ná　fēng　yuè　yún 】\n			', '\n比喻气概雄伟。\n			', '\n明·宋濂《凤阳陈方氏赠二代碑铭》：“当时元夫志士，无不拏风跃云，吐阳嘘阴，致身于九霄之上。”\n			', '\n暂无\n			'),
(833, '0:2:9', '翩翩风度', '\n【 piān　piān　fēng　dù 】\n			', '\n翩翩：形容举止潇洒超脱。风度：美好的举止姿态。形容人的举止言谈超逸洒脱。\n			', '\n清·文康《儿女英雄传》第三十八回：“早有那般世谊同年，见他翩翩丰度，蔼然可亲，都愿和他亲近进来了。”\n			', '\n周恩来这样惊人的酒量，偶尔也有喝醉的时候。不过，他再醉也不会有伤大雅，始终保持着他那与生俱来的～。\n			'),
(834, '0:2:9', '秋风扫叶', '\n【 qiū　fēng　sǎo　yè 】\n			', '\n比喻威力大、气势猛。\n			', '\n明·冯梦龙《醒世恒言》第十九卷：“［程万里］每日间见元兵所过，残灭如秋风扫叶，心中暗暗悲痛，正是：宁为太平犬，莫作离乱人。”\n			', '\n暂无\n			'),
(835, '0:2:9', '骑驴风雪中', '\n【 qí　lǘ　fēng　xuě　zhōng 】\n			', '\n用为苦吟的典故。同“骑驴索句”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(836, '0:2:9', '任凭风浪起，稳坐钓鱼船', '\n【 rèn　píng　fēng　làng　qǐ，wěn　zuò　diào 】\n			', '\n比喻随便遇到什么险恶的情况，都信心十足，毫不动摇。\n			', '\n毛泽东《在中国共产党第八届中央委员会第二次全体会议上的讲话》四：“我们有在不同革命时期经过考验的这样一套干部，就可以‘任凭风浪起，稳坐钓鱼船’。要有这个信心。”\n			', '\n暂无\n			'),
(837, '0:2:9', '随风而靡', '\n【 suí　fēng　ér　mǐ 】\n			', '\n靡：倒下。顺风倒下。比喻没有主见。\n			', '\n南朝·梁·萧统《文选·杨恽〈报孙会宗书〉》：“虽雅知恽者，犹随风而靡，尚何称誉之有？”\n			', '\n暂无\n			'),
(838, '0:2:9', '树欲静而风不宁', '\n【 shù　yù　jìng　ér　fēng　bù　níng 】\n			', '\n原比喻事情不能如人的心愿。现也比喻阶级斗争不以人们的意志为转移。同“树欲静而风不止”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(839, '0:2:9', '树欲静而风不停', '\n【 shù　yù　jìng　ér　fēng　bù　tíng 】\n			', '\n原比喻事情不能如人的心愿。现也比喻阶级斗争不以人们的意志为转移。同“树欲静而风不止”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(840, '0:2:9', '树欲息而风不停', '\n【 shù　yù　xī　ér　fēng　bù　tíng 】\n			', '\n原比喻事情不能如人的心愿。现也比喻阶级斗争不以人们的意志为转移。同“树欲静而风不止”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(841, '0:2:9', '听风听水', '\n【 tīng　fēng　tīng　shuǐ 】\n			', '\n形容善于赏玩自然景色。\n			', '\n相传龟兹国王与乐人于大山间倾听风和水声，感兴而制乐。唐·王建《霓裳辞》之一：“弟子部中留一色，听风听水作《霓裳》。”\n			', '\n《霓裳曲》，前世传记论说颇详，不知～为何事也。白乐天有《霓裳歌》甚详，亦无风水之说，第记之，或有遗亡者尔。\n			'),
(842, '0:2:9', '听见风就是雨', '\n【 tīng　jiàn　fēng　jiù　shì　yǔ 】\n			', '\n刚听到一点儿风声，就当要下雨了。形容听到一点风声就竭力附和渲染。\n			', '\n清·李宝嘉《官场现形记》第二十五回：“他们做都老爷的，听见风就是雨，皇上原许他风闻奏事，说错了又没有不是的。”\n			', '\n暂无\n			'),
(843, '0:2:9', '吴带当风', '\n【 wú　dài　dāng　fēng 】\n			', '\n唐画家吴道子善画佛像，笔势圆转，所画衣带如被风吹拂。后人以之称美其高超画技与飘逸的风格。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(844, '0:2:9', '握风捕影', '\n【 wò　fēng　bǔ　yǐng 】\n			', '\n犹言捕风捉影。比喻说话做事丝毫没有事实根据。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(845, '0:2:9', '无风生浪', '\n【 wú　fēng　shēng　làng 】\n			', '\n比喻平白无故地生出事来。有故意制造事端的意思。同“无风起浪”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(846, '0:2:9', '无风扬波', '\n【 wú　fēng　yáng　bō 】\n			', '\n犹言无风起浪。比喻无端生事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(847, '0:2:9', '无风作浪', '\n【 wú　fēng　zuò　làng 】\n			', '\n比喻平白无故地生出事来。有故意制造事端的意思。同“无风起浪”。\n			', '\n鲁迅《集外集·咬嚼未始“乏味”》：“原文云：却于‘她’字没有讽过。答曰：那是译 She 的，并非无风作浪。”\n			', '\n暂无\n			'),
(848, '0:2:9', '笑傲风月', '\n【 xiào　ào　fēng　yuè 】\n			', '\n犹言吟风弄月。形容心情悠闲自在。\n			', '\n明·罗贯中《三国演义》第四十三回：“在草庐之中，但笑傲风月，抱膝危坐。”\n			', '\n暂无\n			'),
(849, '0:2:9', '啸傲风月', '\n【 xiào　ào　fēng　yuè 】\n			', '\n啸傲：随意长啸吟咏游乐。在江湖山野中自由自在地吟咏游赏。\n			', '\n茅盾《夜读偶记》五：“他们都是些逃避现实的无病呻吟的梦想家，或者是啸傲风月的隐士。”\n			', '\n暂无\n			'),
(850, '0:2:9', '系风捕景', '\n【 xì　fēng　bǔ　jǐng 】\n			', '\n①比喻不可能做到的事。②比喻不露形迹。亦作“系风捕影”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(851, '0:2:9', '西风残照', '\n【 xī　fēng　cán　zhào 】\n			', '\n秋天的风，落日的光。比喻衰败没落的景象。多用来衬托国家的残破和心境的凄凉。”\n			', '\n唐·李白《忆秦娥》词：“乐游原上清秋节，咸阳古道音尘绝。音尘绝，西风残照，汉家陵阙。”\n			', '\n～旧山河，故国遗台忆独过。\n			'),
(852, '0:2:9', '仙风道格', '\n【 xiān　fēng　dào　gé 】\n			', '\n犹言仙风道骨。仙人的风度，道长的气概。形容人的风骨神采与众不同。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(853, '0:2:9', '仙风道气', '\n【 xiān　fēng　dào　qì 】\n			', '\n犹仙风道骨。仙人的风度，道长的气概。形容人的风骨神采与众不同。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(854, '0:2:9', '熏风解愠', '\n【 xūn　fēng　jiě　yùn 】\n			', '\n熏风：和风；愠：恼怒怨恨。温和的风可以消除心中的烦恼，使人心情舒畅。\n			', '\n三国·魏·王肃《孔子家语·辩乐》：“昔日舜弹五弦之琴，造《南风》之诗，其诗曰：‘南风之熏兮，可以解吾民之愠兮。’”\n			', '\n～，昼景清和，新霁时候。\n			'),
(855, '0:2:9', '西风落叶', '\n【 xī　fēng　luò　yè 】\n			', '\n形容秋天的景象。多比喻人或事物已趋衰落。\n			', '\n唐·贾岛《忆江上吴处士》：“秋风吹渭水，落叶满长安。”\n			', '\n蚂蚁缘槐夸大国，蚍蜉撼树谈何易。正～下长安，飞鸣镝。\n			'),
(856, '0:2:9', '向风慕义', '\n【 xiàng　fēng　mù　yì 】\n			', '\n指向往其教化，仰慕其礼义。或指向往其风度，仰慕其义行。\n			', '\n明·张居正《番夷求贡疏》：“因而连合西僧，向风慕义，交臂请贡，献琛来王。”\n			', '\n参加的有社友，也有～来的非社友，共有一百有九人之多。\n			'),
(857, '0:2:9', '血风肉雨', '\n【 xuè　fēng　ròu　yǔ 】\n			', '\n形容剧烈残酷的屠杀或性格刚强。\n			', '\n清·梁启超《论权利思想》：“试一读欧美诸国法律发达史，如立宪政，废奴隶……等诸大法律，何一不自血风肉雨中熏沐而来。”\n			', '\n虽说～的精神，断无惜香怜玉的心绪。\n			'),
(858, '0:2:9', '祥风时雨', '\n【 xiáng　fēng　shí　yǔ 】\n			', '\n形容风调雨顺。多比喻恩德。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(859, '0:2:9', '斜风细雨', '\n【 xié　fēng　xì　yǔ 】\n			', '\n斜风：旁侧吹来的小风；细雨：小雨。形容小的风雨。\n			', '\n唐·张志和《渔父》：“青箬笠，绿蓑衣，斜风细雨不须归。”\n			', '\n暂无\n			'),
(860, '0:2:9', '腥风醎雨', '\n【 xīng　fēng　xián　yǔ 】\n			', '\n犹腥风血雨。形容疯狂杀戮的凶险气氛或环境。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(861, '0:2:9', '寻风捉影', '\n【 xún　fēng　zhuō　yǐng 】\n			', '\n比喻说话做事毫无根据。\n			', '\n明·李诩《戒庵老人漫笔·女辩继母诬陷疏》：“又不曾经获某人，乃以数句之诗，寻风捉影，陷臣死罪。”\n			', '\n暂无\n			'),
(862, '0:2:9', '迅雷风烈', '\n【 xùn　léi　fēng　liè 】\n			', '\n犹言迅雷烈风。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(863, '0:2:9', '宿水飡风', '\n【 xiǔ　shuǐ　cān　fēng 】\n			', '\n形容旅途或野外生活的艰苦。同“宿水餐风”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(864, '0:2:9', '宿水餐风', '\n【 xiǔ　shuǐ　cān　fēng 】\n			', '\n形容旅途或野外生活的艰苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(865, '0:2:9', '相帅成风', '\n【 xiāng　shuài　chéng　fēng 】\n			', '\n层层影响成为风气。帅，同“率”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(866, '0:2:9', '潇洒风流', '\n【 xiāo　sǎ　fēng　liú 】\n			', '\n气度超脱，风度大方。亦作“风流潇洒”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(867, '0:2:9', '想望风褱', '\n【 xiǎng　wàng　fēng　shèng 】\n			', '\n犹言想望风采。非常仰慕其人，渴望一见。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(868, '0:2:9', '相习成风', '\n【 xiāng　xí　chéng　fēng 】\n			', '\n习：习惯。指都习惯于某种做法或看法，而成为一种风习。\n			', '\n宋·高登《高东溪集·蔽主下》：“各挟所能以媒进，阿谀软熟，相习成风。”\n			', '\n永乐以还，崇台阁体，诸大老倡之，众人应之，～，靡然不觉。\n			'),
(869, '0:2:9', '宿雨餐风', '\n【 xiǔ　yǔ　cān　fēng 】\n			', '\n形容旅途辛劳。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(870, '0:2:9', '雪月风花', '\n【 xuě　yuè　fēng　huā 】\n			', '\n①代指四时景色。②比喻男女情事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(871, '0:2:9', '啸吒风云', '\n【 xiào　zhà　fēng　yún 】\n			', '\n形容威力极大。同“叱咤风云”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(872, '0:2:9', '啸咤风云', '\n【 xiào　zhà　fēng　yún 】\n			', '\n形容威力极大。同“叱咤风云”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(873, '0:2:9', '雨鬓风鬟', '\n【 yǔ　bìn　fēng　huán 】\n			', '\n妇女发髻散乱的样子。\n			', '\n清·陈维崧《潇湘逢故人慢·题余氏女子绣柳毅传书图为阮亭赋》词：“正洞庭归客，憔悴思还。牧羊龙女，恰相逢、雨鬓风鬟。”\n			', '\n暂无\n			'),
(874, '0:2:9', '咏嘲风月', '\n【 yǒng　cháo　fēng　yuè 】\n			', '\n指描写风云月露等景象而思想内容贫乏的写作。同“咏月嘲风”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(875, '0:2:9', '雨僝风僽', '\n【 yǔ　chán　fēng　zhòu 】\n			', '\n指风雨交相摧折。\n			', '\n宋·辛弃疾《粉蝶儿·和晋臣赋落花》词：“昨日春如，十三女儿学绣。一枝枝、不教花瘦。甚无情，便下得，雨僝风僽。向园林、铺作地衣红绉。”\n			', '\n暂无\n			'),
(876, '0:2:9', '一代风流', '\n【 yī　dài　fēng　liú 】\n			', '\n指创立风尚、为当时景仰的人物。\n			', '\n宋·陈师道《后山诗注·丞相温公挽词》：“一代风流尽，三师礼数崇。”\n			', '\n暂无\n			'),
(877, '0:2:9', '雨栋风帘', '\n【 yǔ　dòng　fēng　lián 】\n			', '\n形容高敞华美的楼阁。\n			', '\n唐·王勃《滕王阁》诗：“昼栋朝飞南浦云，朱帘暮卷西山雨。”\n			', '\n贝阙珠宫开水府，～岂来处。\n			'),
(878, '0:2:9', '云淡风轻', '\n【 yún　dàn　fēng　qīng 】\n			', '\n微风轻拂，浮云淡薄。形容天气晴好。亦作“风轻云淡”。\n			', '\n宋·程灏《春日偶成》：“云淡风轻近午天，傍花随柳过前川。”\n			', '\n暂无\n			'),
(879, '0:2:9', '扬风扢雅', '\n【 yáng　fēng　bào　yǎ 】\n			', '\n品评诗文。\n			', '\n清·赵翼《廿二史札记》卷三十：“诸人尝寓其家，流连觞咏，声光映蔽江表。此皆林下之人扬《风》扢《雅》，而声气所届，希风附响者，如恐不及。”\n			', '\n暂无\n			'),
(880, '0:2:9', '引风吹火', '\n【 yǐn　fēng　chuī　huǒ 】\n			', '\n利用风来吹火，使火越烧越旺。比喻从中煽动，挑起事端。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(881, '0:2:9', '移风崇教', '\n【 yí　fēng　chóng　jiào 】\n			', '\n移转风气，崇尚教化。\n			', '\n《韩诗外传》卷八：“移风崇教，生而不杀，布惠施恩，仁不偏与。”\n			', '\n暂无\n			'),
(882, '0:2:9', '移风改俗', '\n【 yí　fēng　gǎi　sú 】\n			', '\n改变旧的风俗习惯。同“移风易俗”。\n			', '\n《宋书·乐志一》：“移风改俗，致和乐之极。”\n			', '\n公闲邪纳正，～。\n			'),
(883, '0:2:9', '移风革俗', '\n【 yí　fēng　gé　sú 】\n			', '\n改变旧的风俗习惯。同“移风易俗”。\n			', '\n《魏书·高闾传》：“移风革俗，天保载定。”\n			', '\n故威行于下则坏法犯贵之风移矣，礼适其中则破产伤生之俗革矣，～其在兹乎！\n			'),
(884, '0:2:9', '遗风旧俗', '\n【 yí　fēng　jiù　sú 】\n			', '\n前代遗留下来的风俗习惯。\n			', '\n元·揭傒斯《彭州学记》：“土著之姓十亡七八，五方之俗更为宾主，治者狃闻习见，以遗风旧俗为可鄙，前言往行为可鄙。”\n			', '\n暂无\n			'),
(885, '0:2:9', '英风亮节', '\n【 yīng　fēng　liàng　jié 】\n			', '\n高尚的风格和节操。\n			', '\n毛錡《悼念周恩来总理》诗：“可钦可敬的周总理，英风亮节堪师表。”\n			', '\n暂无\n			'),
(886, '0:2:9', '迎风冒雪', '\n【 yíng　fēng　mào　xuě 】\n			', '\n迎：对着，冲着。顶着寒风，冒着大雪。常形容旅途艰辛。\n			', '\n明·吴承恩《西游记》第四十四回：“真个是迎风冒雪，戴月披星，行彀多时，又值早春天气，但见三阳转运，万物生辉。”\n			', '\n暂无\n			'),
(887, '0:2:9', '移风平俗', '\n【 yí　fēng　píng　sú 】\n			', '\n转变风气，改变习俗。\n			', '\n《吕氏春秋·侈乐》：“凡音乐通乎政，而移风平俗者也。”\n			', '\n暂无\n			'),
(888, '0:2:9', '一帆顺风', '\n【 yī　fān　shùn　fēng 】\n			', '\n比喻非常顺利，没有任何阻碍。同“一帆风顺”。\n			', '\n明·施耐庵《水浒传》第四十一回：“三只大船载了许多人马头领，却投穆太公庄上行，一帆顺风，早到岸边埠头。”\n			', '\n暂无\n			'),
(889, '0:2:9', '遗风逸尘', '\n【 yí　fēng　yì　chén 】\n			', '\n前代遗留下来的风教和超逸的事迹。\n			', '\n元·俞希鲁《至顺镇江志·人材》：“至于高蹈物表，远引方外，亦皆清隽卓绝志士，是其遗风逸尘，霑被无极。”\n			', '\n暂无\n			'),
(890, '0:2:9', '遗风余采', '\n【 yí　fēng　yú　cǎi 】\n			', '\n前代遗留下来的风度文采。\n			', '\n南朝·梁·刘勰《文心雕龙·时序》：“应对固无方，篇章亦不匮，遗风余采，莫与比盛。”\n			', '\n暂无\n			'),
(891, '0:2:9', '有风有化', '\n【 yǒu　fēng　yǒu　huà 】\n			', '\n指有教育意义。\n			', '\n明·汤显祖《牡丹亭·闺塾》：“论《六经》，《诗经》最葩，闺门内许多风雅……有风有化，宜室宜家。”\n			', '\n暂无\n			'),
(892, '0:2:9', '遗风余教', '\n【 yí　fēng　yú　jiào 】\n			', '\n前代遗留下来的风尚教化。\n			', '\n宋·叶適《金坛县重建学记》：“京口常为江南必争之地，其人以智诈勇力擅名于时，而古人遗风余教无闻焉，何也？”\n			', '\n暂无\n			'),
(893, '0:2:9', '遗风余烈', '\n【 yí　fēng　yú　liè 】\n			', '\n前人留传的风教和业迹。\n			', '\n《汉书·礼乐志》：“夫乐本情性，浃肌肤而臧骨髓，虽经乎千载，其遗风余烈尚犹不绝。”《晋书·刘颂传》：“如或当身之政，遗风余烈不及后嗣。”\n			', '\n尝试与子登孤山而望吴越，歌山中之乐而饮此水，则公之～，亦或见於斯泉也。\n			'),
(894, '0:2:9', '移风易尚', '\n【 yí　fēng　yì　shàng 】\n			', '\n改变旧的风俗习惯。同“移风易俗”。\n			', '\n明·刘基《〈苏平仲文集〉序》：“移风易尚之机，实肇于此。”\n			', '\n暂无\n			'),
(895, '0:2:9', '遗风余思', '\n【 yí　fēng　yú　sī 】\n			', '\n前代遗留下来的风尚情思。\n			', '\n唐·樊宗师《绛守居园池记》：“绛即东雍，为守理所，禀参实沉分，气蓄两河润，有陶唐冀遗风余思。”\n			', '\n夫人之有一能，而使后人尚之如此，况仁人庄士之～，被于来世者如何哉！★宋·曾巩《墨池记》\n			'),
(896, '0:2:9', '遗风余俗', '\n【 yí　fēng　yú　sú 】\n			', '\n前代遗留下来的风俗。\n			', '\n汉·贾谊《治安策》：“曩之为秦者，今转而为汉矣，然其遗风余俗，犹尚未改。”\n			', '\n暂无\n			'),
(897, '0:2:9', '余风遗文', '\n【 yú　fēng　yí　wén 】\n			', '\n传留下来的习气和文章。余，通“馀”。\n			', '\n南朝·梁·刘勰《文心雕龙·时序》：“而乐松之徒，招集浅陋，故杨赐号为驩兜，蔡邕比之俳优，其馀风遗文，盖蔑如也。”\n			', '\n暂无\n			'),
(898, '0:2:9', '遗风余习', '\n【 yí　fēng　yú　xí 】\n			', '\n前代遗留下来的风俗。同“遗风余俗”。\n			', '\n《宣和书谱·卫恒》：“学家相传，四世不坠，盛哉，遂与王谢家遗风余习相季孟也。”\n			', '\n暂无\n			'),
(899, '0:2:9', '遗风余象', '\n【 yí　fēng　yú　xiàng 】\n			', '\n前代遗留下来的风俗和法式。\n			', '\n宋·司马光《投壶新格》：“古者壶矢之制，揖让之容，今虽阙焉，然其遗风余象犹仿佛也。”\n			', '\n暂无\n			'),
(900, '0:2:9', '遗风余韵', '\n【 yí　fēng　yú　yùn 】\n			', '\n前人遗留下来的风教和韵致。\n			', '\n《朱子全书·治道一》：“此古之君子，所以成尊主庇民之功于一时，而其遗风余韵，犹有称思于后世者也。”\n			', '\n在过去齐国、鲁国的都城，和一些戴着高高的帽子，宽大的衣袖的学者们，商讨学问，反复辩论，观察孔子的～。\n			'),
(901, '0:2:9', '遗风余泽', '\n【 yí　fēng　yú　zé 】\n			', '\n前人遗留下来的风教和德泽。\n			', '\n《宣和书谱·张彦远》：“此其遗风余泽，沾馥后人者特非一日。”\n			', '\n暂无\n			'),
(902, '0:2:9', '佯风诈冒', '\n【 yáng　fēng　zhà　mào 】\n			', '\n犹言装疯卖傻。故意装成疯疯癫癫，傻里傻气。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(903, '0:2:9', '移风振俗', '\n【 yí　fēng　zhèn　sú 】\n			', '\n改变风气，振兴习俗。\n			', '\n《新唐书·刘祥道传》：“以去就之官，临苟且之民，欲移风振俗，乌可得乎？”\n			', '\n暂无\n			'),
(904, '0:2:9', '友风子雨', '\n【 yǒu　fēng　zǐ　yǔ 】\n			', '\n指云。云以风为友，以雨为子。盖风与云并行，雨因云而生。\n			', '\n《荀子·赋》：“托地而游宇，友风而子雨。”\n			', '\n暂无\n			'),
(905, '0:2:9', '烟花风月', '\n【 yān　huā　fēng　yuè 】\n			', '\n指男女情爱之事。\n			', '\n吴梅《风洞山·游湖》：“咳！弘光啊！都是些烟花风月担误了你也！”\n			', '\n暂无\n			'),
(906, '0:2:9', '雨巾风帽', '\n【 yǔ　jīn　fēng　mào 】\n			', '\n遮蔽风雨的头巾和帽子。常借指浪游之客。\n			', '\n宋·朱敦儒《感皇恩·游□□园感旧》词：“主人好事，坐客雨巾风帽。”宋·陈三聘《梦玉人引》词：“雨巾风帽，昔追游、谁念旧踪迹。”\n			', '\n暂无\n			'),
(907, '0:2:9', '运斤如风', '\n【 yùn　jīn　rú　fēng 】\n			', '\n指挥斧成风声。形容技术的高妙。\n			', '\n金·元好问《续夷坚志·贾叟刻木》：“平阳贾叟，无目而能刻神像……僧说贾初立木胎，先摸索之，意有所会，运斤如风。”\n			', '\n暂无\n			'),
(908, '0:2:9', '饮露餐风', '\n【 yǐn　lù　cān　fēng 】\n			', '\n喝的是露水，吃的是风。形容超凡脱俗的生活。亦作“饮风餐露”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(909, '0:2:9', '一路风尘', '\n【 yī　lù　fēng　chén 】\n			', '\n形容旅途辛苦。\n			', '\n清·曹雪芹《红楼梦》第十六回：“国舅老爷大喜！国舅老爷一路风尘辛苦。小的听见昨日的头起报马来报，说今日大驾归府，略预备了一杯水酒掸尘，不知赐光谬领否？”\n			', '\n［安老爷］见舅太太在廊下候着，便忙着上前彼此问过好，谈了两句～的话。\n			'),
(910, '0:2:9', '议论风发', '\n【 yì　lùn　fēng　fā 】\n			', '\n形容谈论广泛、生动而又风趣。\n			', '\n元戴良《申屠先生墓志铭》序：“平居议论风发，品藻古今人物，亹亹不能休，座客闻之，率为之夺气。”\n			', '\n群居酒次，贻上～，而先生独恂恂不妄措一词。\n			'),
(911, '0:2:9', '一路风清', '\n【 yī　lù　fēng　qīng 】\n			', '\n形容安定升平的景象。\n			', '\n明·沈德符《野获编·吏部·用违其才》：“沈里孝清直名臣，使其建牙内地，将见一路风清，乃使作陕西巡抚，助讨宁夏。”\n			', '\n暂无\n			'),
(912, '0:2:9', '月朗风清', '\n【 yuè　lǎng　fēng　qīng 】\n			', '\n月光明朗，微风清爽。形容宁静美好的月夜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(913, '0:2:9', '言论风生', '\n【 yán　lùn　fēng　shēng 】\n			', '\n形容言谈议论时兴致很高，气氛活跃。\n			', '\n清·袁枚《新齐谐·赵李二生》：“[书生]邀入坐，言论风生。”\n			', '\n暂无\n			'),
(914, '0:2:9', '议论风生', '\n【 yì　lùn　fēng　shēng 】\n			', '\n形容谈论广泛、生动而又风趣。\n			', '\n宋王暐《道山清话》：“韩持国为人凝严方重，每兄弟聚话，玉汝、子华议论风生，持国未尝有一言。”\n			', '\n伊和女伴商量装饰，～，足以使大家心折。\n			'),
(915, '0:2:9', '雨霾风障', '\n【 yǔ　mái　fēng　zhàng 】\n			', '\n指狂恶的风雨。\n			', '\n宋·吴潜《满江红·九日郊行》词：“尽敛却、雨霾风障，雾沈云暝。远岫四呈青欲滴，长空一抹明于镜。”\n			', '\n暂无\n			'),
(916, '0:2:9', '旖旎风光', '\n【 yǐ　nǐ　fēng　guāng 】\n			', '\n旖旎：柔和美丽。柔和而美丽的韵致风采或自然风景。\n			', '\n清·李宝嘉《官场现形记》：“一霎时局已到齐，真正是翠绕珠围，金迷纸醉，说不尽温柔景象，旖旎风光。”\n			', '\n暂无\n			'),
(917, '0:2:9', '沂水春风', '\n【 yí　shuǐ　chūn　fēng 】\n			', '\n沂水：河水名，在山东省曲阜县境内，孔子出生地。春风：春天和暖的风，比喻良好的熏陶和教育。来自沂水的春风。比喻深受孔学的教育与熏陶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(918, '0:2:9', '雨宿风餐', '\n【 yǔ　sù　fēng　cān 】\n			', '\n意指风口处吃饭，雨地里住宿。形容生活飘泊不定。\n			', '\n宋·范成大《四明人董峄久居岳市乞诗》：“祝融峰下两逢春，雨宿风餐老病身。莫笑五湖萍梗客，海边亦有未归人。”\n			', '\n暂无\n			'),
(919, '0:2:9', '雨散风流', '\n【 yǔ　sàn　fēng　liú 】\n			', '\n比喻离散。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(920, '0:2:9', '雨蓑风笠', '\n【 yǔ　suō　fēng　lì 】\n			', '\n防雨用的蓑衣笠帽，为渔夫的衣饰。亦借指渔夫。\n			', '\n宋·李曾伯《沁园春·丙辰归里和八窗叔韵》词：“天教狂虏灰飞。更莫问儿郎存血衣。把雪裘霜帽，绝交楚徼，雨蓑风笠，投老吴矶。”\n			', '\n暂无\n			'),
(921, '0:2:9', '雨顺风调', '\n【 yǔ　shùn　fēng　tiáo 】\n			', '\n调：调和；顺：和协。风雨及时适宜。形容风雨适合农时。\n			', '\n《六韬》：“既而克殷，风凋雨顺。”\n			', '\n我愿天公怜赤子，莫生尤物为疮痏。～百谷登，民不饥寒为上瑞。\n			'),
(922, '0:2:9', '玉树临风', '\n【 yù　shù　lín　fēng 】\n			', '\n形容人风度潇洒，秀美多姿。亦作“临风玉树”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(923, '0:2:9', '遇事生风', '\n【 yù　shì　shēng　fēng 】\n			', '\n原形容处事果断而迅速。后指一有机会就挑拔是非，引起事端。\n			', '\n《汉书·赵广汉传》：“见事风生，无所回避。”\n			', '\n我想他们着实和民党作对，～，或者知道了老兄到来，便要拿办，也未可定。（清·岭南羽衣女士《东欧女豪杰》第三回）\n			'),
(924, '0:2:9', '易俗移风', '\n【 yì　sú　yí　fēng 】\n			', '\n改变习俗，转移风气。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(925, '0:2:9', '遗训余风', '\n【 yí　xùn　yú　fēng 】\n			', '\n前代遗留下来的风尚教化。\n			', '\n《宋书·明帝纪论》：“圣人立法垂制，所以必称先王，盖由遗训余风，足以贻之来世也。”\n			', '\n暂无\n			'),
(926, '0:2:9', '泱泱大风', '\n【 yāng　yāng　dà　fēng 】\n			', '\n泱泱：宏大的样子。指气魄宏大的大国风度。\n			', '\n《左传·襄公二十九年》：“为之歌《齐》，曰：‘美哉，泱泱乎，大风也哉！表东海者，其大公乎！国未可量也。’”\n			', '\n明孝陵道上的石人石马，虽然残缺零乱，还可见～。（朱自清《南京》）\n			'),
(927, '0:2:9', '月晕而风，础润而雨', '\n【 yuè　yūn　ér　fēng，chǔ　rùn　ér　yǔ 】\n			', '\n月晕出现，将要刮风；础石湿润，就要下雨。比喻从某些征兆可以推知将会发生的事情。\n			', '\n宋·苏洵《辨奸论》：“事有必至，理有固然，惟天下之静者，乃能见微而知著。月晕而风，础润而雨，人人知之。”\n			', '\n燥湿为天地自然之气，～，人以此测于几先者，固古今一致也。\n			'),
(928, '0:2:9', '云涌风飞', '\n【 yún　yǒng　fēng　fēi 】\n			', '\n云阵奔涌，狂风发作。形容文章气势磅礴。\n			', '\n清·陈廷焯《白雨斋词话》卷七：“其年《瑞龙吟·春夜见壁间三弦子是云郎旧物感而填词》后半云：‘记得蛇皮弦子，当时妆就……’游丝落絮之情，云涌风飞之笔，亦一时之雄也。”\n			', '\n暂无\n			'),
(929, '0:2:9', '渊涌风厉', '\n【 yuān　yǒng　fēng　lì 】\n			', '\n如水之涌，如风之疾。比喻谈吐滔滔不绝。\n			', '\n晋·葛洪《抱朴子·行品》：“士有机变清锐，巧言绮粲，揽引譬喻，渊涌风厉。然而口之所谈，身不能行。”\n			', '\n暂无\n			'),
(930, '0:2:9', '余韵流风', '\n【 yú　yùn　liú　fēng 】\n			', '\n传留后世的韵致风度。\n			', '\n《群音类选·\n			', '\n文达抚浙，创诂经精舍，督粤，创学海堂，提唱隽流，扇扬雅道，～，到今未沫。\n			'),
(931, '0:2:9', '月晕知风，础润知雨', '\n【 yuè　yūn　zhī　fēng，chǔ　rùn　zhī　yǔ 】\n			', '\n月晕出现，将要刮风；础石湿润，就要下雨。比喻从某些征兆可以推知将会发生的事情。\n			', '\n长舆《论莱阳民变事》：“月晕知风，础润知雨，窃恐踵莱阳而起者，祸变相寻而来未有已也。”\n			', '\n暂无\n			'),
(932, '0:2:9', '雨僽风僝', '\n【 yǔ　zhòu　fēng　chán 】\n			', '\n指风雨交相摧折。\n			', '\n元·柯丹邱《荆钗记·庆诞》：“椿老萱衰，只恐雨僽风僝。”\n			', '\n暂无\n			'),
(933, '0:2:9', '颐指风使', '\n【 yí　zhǐ　fēng　shǐ 】\n			', '\n以下巴的动向和脸色来指挥人。常以形容指挥别人时的傲慢态度。\n			', '\n《元典章·户部二·使臣》：“累年以来，朝廷使臣以致中书省枢密院御史台内外诸衙门一切出使臣人等，每到外路，挟恃威势，颐指风使，外路官司抑曲将迎，恐咈其意。”\n			', '\n暂无\n			'),
(934, '0:2:9', '逐电追风', '\n【 zhú　diàn　zhuī　fēng 】\n			', '\n追赶闪电和迅风。形容速度非常快。\n			', '\n《说唐》第十回：“叔宝（秦叔宝）拜辞，连夜起身，出庄上马，纵辔加鞭，如逐电追风，十分迅速。”\n			', '\n衣不解带，纵辔加鞭，如～，十分迅捷。\n			'),
(935, '0:2:9', '骤风暴雨', '\n【 zhòu　fēng　bào　yǔ 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n柳青《铜墙铁壁》第八章：“众人都担心这时正是下雷雨的节令，猛不防来一阵骤风暴雨，人们藏在地洞里难免遭水淹。”\n			', '\n暂无\n			'),
(936, '0:2:9', '捉风捕影', '\n【 zhuō　fēng　bǔ　yǐng 】\n			', '\n比喻虚幻无实或无根据地臆测。\n			', '\n清·纪昀《阅微草堂笔记》卷十：“是事如捉风捕影，杳无实证，又不可刑求。断离断合，皆难保不误。”\n			', '\n暂无\n			'),
(937, '0:2:9', '捉风捕月', '\n【 zhuō　fēng　bǔ　yuè 】\n			', '\n比喻虚幻无实或无根据地臆测。\n			', '\n清·钮琇《觚剩续编·律例》：“自风雅之道衰，即愚若胡生，亦必捉风捕月，自诩五言之城。”\n			', '\n暂无\n			'),
(938, '0:2:9', '追风掣电', '\n【 zhuī　fēng　chè　diàn 】\n			', '\n形容速度极快。多指马飞速奔驰。同“追风逐电”。\n			', '\n宋·张淏《云谷杂记·侍郎徐公帖》：“愿得侧翅附鸿鹄，追风掣电凌太空。”\n			', '\n暂无\n			'),
(939, '0:2:9', '骤风急雨', '\n【 zhòu　fēng　jí　yǔ 】\n			', '\n来势急遽而猛烈的风雨。同“骤雨狂风”。\n			', '\n宋·郭熙淳《林泉高致·画诀》：“夏山雨过，浓云欲雨，骤风急雨，又曰飘风急雨。”\n			', '\n我看，虏骑行军甚疾，常如～，恐怕你们想助我一臂之力已经来不及了。\n			'),
(940, '0:2:9', '贞风亮节', '\n【 zhēn　fēng　liàng　jié 】\n			', '\n犹言高风亮节。\n			', '\n南朝宋傅亮《故安成太守傅府君铭》：“高明远德，系轨于时；贞风亮节，流声累叶。”\n			', '\n暂无\n			'),
(941, '0:2:9', '追风蹑景', '\n【 zhuī　fēng　niè　jǐng 】\n			', '\n形容速度极快。\n			', '\n《抱朴子·内篇序》：“奋翅则能凌厉玄霄，骋足则能追风蹑景。”\n			', '\n暂无\n			'),
(942, '0:2:9', '追风摄景', '\n【 zhuī　fēng　niè　jǐng 】\n			', '\n形容马行疾速。蹑，一本作“摄”。同“追风蹑景”。\n			', '\n晋·葛洪《抱朴子·内篇序》：“假令奋翅则能凌厉玄霄，骋足则能追风蹑景。”\n			', '\n暂无\n			'),
(943, '0:2:9', '追风蹑影', '\n【 zhuī　fēng　niè　yǐng 】\n			', '\n形容马行疾速。同“追风蹑景”。\n			', '\n明·梅鼎祚《玉合记·赠处》：“是好马，那竹批双耳，镜夹方瞳，灭没权奇，追风蹑影，小生虽乏鸿章，敢扬骏骑。”\n			', '\n暂无\n			'),
(944, '0:2:9', '沾风惹草', '\n【 zhān　fēng　rě　cǎo 】\n			', '\n比喻卖弄风流，挑逗、勾引异性。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第一回：“左右街坊，有几个奸诈浮浪子弟，晙见了武大这个老婆，打扮油样，沾风惹草，被这干人在街上，撒谜语，往来嘲戏。”\n			', '\n暂无\n			'),
(945, '0:2:9', '招风惹雨', '\n【 zhāo　fēng　rě　yǔ 】\n			', '\n比喻惹是生非，引出事端。\n			', '\n清·西周生《醒世姻缘传》第四十二回：“这监生不惟遮不得风，避不得雨，且还要招风惹雨。”\n			', '\n暂无\n			'),
(946, '0:2:9', '占风使帆', '\n【 zhān　fēng　shǐ　fān 】\n			', '\n比喻随机应变，看风头办事。\n			', '\n《醒世姻缘传》第八回：“看人眉来眼去，占风使帆。”\n			', '\n暂无\n			'),
(947, '0:2:9', '栉风酾雨', '\n【 zhì　fēng　shī　yǔ 】\n			', '\n风梳发，雨洗头。形容奔波劳苦。同“栉风沐雨”。\n			', '\n清·陈康祺《郎潜纪闻》卷一：“都兴阿诸公，忠贞朴劲，屡摧狂寇，栉风酾雨，始终戎幕。”\n			', '\n暂无\n			'),
(948, '0:2:9', '占风望气', '\n【 zhān　fēng　wàng　qì 】\n			', '\n察看风向云气。亦比喻看风使舵，随机应变。\n			', '\n明沈德符《野获编·言事·言官一言之失》：“壬辰以外察原任去官，四君者……真实可惜；其他占风望气，詈夷为跖，自弃名教者，固不可胜数矣。”\n			', '\n其初亦有一二魁杰之士，出一奇，运一策，世竞传之；而～之徒，争相附和，群然国士自命矣。\n			'),
(949, '0:2:9', '逐风追电', '\n【 zhú　fēng　zhuī　diàn 】\n			', '\n追赶迅风和闪电。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(950, '0:2:9', '追风逐电', '\n【 zhuī　fēng　zhú　diàn 】\n			', '\n形容速度极快。多指马飞速奔驰。\n			', '\n北齐·刘昼《新论·知人》：“故孔方諲之相马也，虽未追风逐电，绝尘灭影，而迅足之势固已见矣。”\n			', '\n山风忽起，那狮子～似的，追那些虎狼去了。\n			'),
(951, '0:2:9', '纵风止燎', '\n【 zòng　fēng　zhǐ　liáo 】\n			', '\n用鼓风的方法灭火。比喻本欲消弭其事，却反而助长其声势。\n			', '\n隋·王通《中说·问易》：“真君、建德之事，适足推波助澜，纵风止燎尔。”\n			', '\n幽平而后，有如宣王者出，则礼乐征伐不自诸侯，而《雅》《颂》未可知也。奈何推波助澜，～乎！\n			'),
(952, '0:2:9', '追风逐日', '\n【 zhuī　fēng　zhú　rì 】\n			', '\n形容速度极快。多指马飞速奔驰。同“追风逐电”。\n			', '\n唐·杨炯《后周明威将军梁公神道碑》：“励衔策而追风逐日，加剪拂则绝电奔星。”\n			', '\n暂无\n			'),
(953, '0:2:9', '魆风骤雨', '\n【 zhuō　fēng　zhòu　yǔ 】\n			', '\n犹暴风骤雨。比喻声势浩大，发展急速而猛烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(954, '0:2:9', '追风逐影', '\n【 zhuī　fēng　zhú　yǐng 】\n			', '\n形容马行疾速。同“追风蹑景”。\n			', '\n明·陈子龙《献马行》：“追风逐影古来有，大宛渥洼君知否？”\n			', '\n暂无\n			'),
(955, '0:2:9', '作浪兴风', '\n【 zuò　làng　xīng　fēng 】\n			', '\n掀起风浪。比喻制造事端。\n			', '\n《再生缘》第七十四回：“［郡主］心中本有些须醋，被江妈，作浪兴风煽惑他。”\n			', '\n暂无\n			'),
(956, '0:2:9', '栉沐风雨', '\n【 zhì　mù　fēng　yǔ 】\n			', '\n风梳发，雨洗头。形容奔波劳苦。同“栉风沐雨”。\n			', '\n后晋·沈昫《旧唐书·宣宗纪》：“况将士等栉沐风雨，暴露郊原，披荆棘而刁斗夜严，逐豺狼而穹庐晓破。 ”\n			', '\n方今晋王亲当矢石，～，王殚供军之租赋，为不急之游盘，世道未夷，人心多梗，久虚府第，远出游从，如乐祸之徒，翻然起变，拒门不纳，则王欲何归！\n			'),
(957, '0:2:9', '长他人志气，灭自己威风', '【 zhǎng　tā　rén　zhì　qì，miè　zì　jǐ　wēi 】', '指一味助长别人的声势，而看不起自己的力量。', '明·吴承恩《西游记》第三十三回：“众怪上前道：‘大王，怎么长他人志气，灭自己威风 ？''”明·施耐庵《水浒传》第二回：“你两个闭了鸟嘴！长别人志气，灭自己威风。” ', '倒塔鬼爆跳如雷道：“你只～。”'),
(958, '0:2:9', '骤雨暴风', '\n【 zhòu　yǔ　bào　fēng 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n清·张德彝《随使法国记·归途记》：“初六日壬辰，阴晴不定……入夜骤雨暴风一阵。”\n			', '\n暂无\n			'),
(959, '0:2:9', '捉影捕风', '\n【 zhuō　yǐng　bǔ　fēng 】\n			', '\n比喻虚幻无实或无根据地臆测。\n			', '\n明·吴承恩《西游记》第二十五回：“这泼猴枉自也拿他不住；就拿住他，也似抟沙弄汞，捉影捕风。”\n			', '\n暂无\n			'),
(960, '0:2:9', '骤雨狂风', '\n【 zhòu　yǔ　kuáng　fēng 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n《宣和书谱·释怀素》：“自谓得草书三昧……当时名流如李白、戴叔伦、窦臯、钱起之徒皆有诗美之。状其势以谓若惊蛇走虺，骤雨狂风。”\n			', '\n～随地卷，奔雷掣电走天神。\n			'),
(961, '0:2:10', '饱经风雨', '\n【 bǎo　jīng　fēng　yǔ 】\n			', '\n指经历过许多艰难困苦。同“饱经风霜”。\n			', '\n孙犁《秀露集·文学和生活的路》：“我们的道路总算走得很长了吧，是坎坷不平的，也是饱经风雨的，终于走到现在。”\n			', '\n暂无\n			'),
(962, '0:2:10', '毕雨箕风', '\n【 bì　yǔ　jī　fēng 】\n			', '\n原指民性如星，星好风雨，比喻庶民喜好人主的恩泽。后为颂扬统治者普施仁政之词。\n			', '\n《书·洪范》：“庶民惟星，星有好风，星有好雨。”孔传：“箕星好风，毕星好雨，亦民所好。”\n			', '\n使雷车电椅，扫荡四方；～，稣舒品物。\n			'),
(963, '0:2:10', '拨雨撩云', '\n【 bō　yǔ　liáo　yún 】\n			', '\n指挑逗、试探对方的情意。泛指调情。\n			', '\n明·李日华《南西厢记·猜诗雪案》：“你用心拨雨撩云，我好意与你传书递缄。小姐呵，不肯搜自己狂为，待要寻人破绽。”\n			', '\n妆聋做哑，担惊受怕，无端～，成就了鸾孤凤寡。\n			'),
(964, '0:2:10', '驰风骋雨', '\n【 chí　fēng　chěng　yǔ 】\n			', '\n犹言乘风驾雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(965, '0:2:10', '冲风冒雨', '\n【 chōng　fēng　mào　yǔ 】\n			', '\n指不避风雨之苦。\n			', '\n周立波《暴风骤雨》第一部九：“‘头年给你干一整年活，冲风冒雨，起早贪黑的。’郭全海说，气急眼了。”\n			', '\n暂无\n			'),
(966, '0:2:10', '餐风宿雨', '\n【 cān　fēng　sù　yǔ 】\n			', '\n形容旅途或野外生活的艰苦。\n			', '\n清·许思湄《谢清苑县李贺母寿并请追失银》：“别后餐风宿雨，儿歌行路之难。而芳草斜阳，又来孤馆，自叹春光九十，不属劳人也。”\n			', '\n唐宋以后，我先人以一往无前之概，航海而南，～，辟有蛮荒。\n			'),
(967, '0:2:10', '春风雨露', '\n【 chūn　fēng　yǔ　lù 】\n			', '\n像春天的和风和雨滴露水那样滋润着万物的生长。旧常用以比喻恩泽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(968, '0:2:10', '楚梦云雨', '\n【 chǔ　mèng　yún　yǔ 】\n			', '\n楚王梦，云雨情。后比喻男女亲昵。\n			', '\n战国·楚·宋玉《高唐赋序》：“……王因幸之，去而辞曰：‘妾在巫山之阳，高丘之阴，旦为朝云，暮为行雨，朝朝暮暮，阳台之下。’”\n			', '\n院院宫妆金翠镜，朝朝～床。（清·孔尚任《桃花扇·余韵》）\n			'),
(969, '0:2:10', '础泣而雨', '\n【 chǔ　qì　ér　yǔ 】\n			', '\n柱子的基石泣湿了，就是要下雨的征候。比喻见到一点迹象，就能知道它的发展方向。\n			', '\n宋·苏洵《辨奸论》：“月晕而风，础润而雨。”\n			', '\n暂无\n			'),
(970, '0:2:10', '惨雨酸风', '\n【 cǎn　yǔ　suān　fēng 】\n			', '\n犹言凄风苦雨。指令人伤感的天气。亦以喻不安定的局势。\n			', '\n《三元里人民抗英斗争史料·英夷就抚》：“军门传箭夜缒城，郦生寸舌能销兵。抽红换白须臾事，惨雨酸风顷刻平。”\n			', '\n暂无\n			'),
(971, '0:2:10', '楚雨巫云', '\n【 chǔ　yǔ　wū　yún 】\n			', '\n楚地巫峡的云和雨。多比喻男女幽情。\n			', '\n元·孙周卿《沉醉东风·宫词》曲：“眼底情，心间恨，到多如楚雨巫云。”\n			', '\n虽然是，锦衣玉食身安吉，却倒是，～意挂心。\n			'),
(972, '0:2:10', '楚云湘雨', '\n【 chǔ　yún　xiāng　yǔ 】\n			', '\n比喻男女幽情。\n			', '\n荆干臣《全元散曲》：“玉鞭杨柳春风陌，绣毂梨花夜月街，楚云湘雨梦阳台。休分外，花柳暗尘埃。”\n			', '\n暂无\n			'),
(973, '0:2:10', '对床风雨', '\n【 duì　chuáng　fēng　yǔ 】\n			', '\n指亲友或兄弟久别重逢，在一起亲切交谈。同“对床夜雨”。\n			', '\n苏曼殊《致刘三书》：“回忆秣陵半载，对床风雨，受教无量，而今安可得耶？”\n			', '\n暂无\n			'),
(974, '0:2:10', '断雨残云', '\n【 duàn　yǔ　cán　yún 】\n			', '\n比喻男女恩爱中绝，欢情未能持续。\n			', '\n清·洪昇《长生殿·献发》：“想春游春，从晓和昏，岂知有断雨残云。”\n			', '\n暂无\n			'),
(975, '0:2:10', '大雨滂沱', '\n【 dà　yǔ　páng　tuó 】\n			', '\n滂沱：雨大而多的样子。形容雨下得很大。\n			', '\n明·罗贯中《三国演义》第二十八回：“行了数日，忽值大雨滂沱。”\n			', '\n暂无\n			'),
(976, '0:2:10', '弹雨枪林', '\n【 dàn　yǔ　qiāng　lín 】\n			', '\n弹下如雨，枪立如林。形容战斗剧烈。\n			', '\n清·孙雨林《皖江血·拒敌》：“且划策，弹雨枪林，木坏山隤，江城付动灰。”\n			', '\n无论两军对垒，～，而观战之侦探队，须履险如夷，电传消息。\n			'),
(977, '0:2:10', '大雨倾盆', '\n【 dà　yǔ　qīng　pén 】\n			', '\n雨大得像盆里的水直往下倒。形容雨大势急。\n			', '\n唐·杜甫《白帝》诗：“白帝城中云出门，白帝城下雨翻盆。”\n			', '\n暂无\n			'),
(978, '0:2:10', '大雨如注', '\n【 dà　yǔ　rú　zhù 】\n			', '\n注：灌入。形容雨下得很大，雨水像往下灌似的。\n			', '\n明·冯梦龙《警世通言·俞伯牙摔琴谢知音》：“偶然风狂浪涌，大雨如注，舟楫不能前进，泊于山崖之下。”\n			', '\n又三日，率众诅龙潭，以激神怒，～。\n			'),
(979, '0:2:10', '风车雨马', '\n【 fēng　chē　yǔ　mǎ 】\n			', '\n指神灵的车马。亦用以比喻迅疾、快速。\n			', '\n唐·李商隐《燕台诗·冬》之四：“风车雨马不持去，蜡独啼红怨天曙。”\n			', '\n暂无\n			'),
(980, '0:2:10', '风驰雨骤', '\n【 fēng　chí　yǔ　zhòu 】\n			', '\n形容像风雨一样迅捷猛烈。\n			', '\n《旧五代史·梁书·谢彦章传》：“每敦阵整旅，左旋右抽，虽风驰雨骤，亦无以喻其迅捷也，故当时骑士咸乐为用。”\n			', '\n任大老爷亲自骑着快马，带着八十名亲兵小队，～的在后赶来。\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(981, '0:2:10', '翻手云覆手雨', '\n【 fān　shǒu　yún　fù　shǒu　yǔ 】\n			', '\n比喻反覆无常或玩弄手段。\n			', '\n语出唐杜甫《贫交行》：“翻手作云覆手雨，纷纷轻薄何须数。”\n			', '\n他～，没定止性儿难据。\n			'),
(982, '0:2:10', '风霜雨雪', '\n【 fēng　shuāng　yǔ　xuě 】\n			', '\n比喻经历了种种艰难困苦。\n			', '\n元·马致远《黄梁梦》第四折：“一梦中十八年，见了酒色财气，人我是非，贪嗔痴爱，风霜雨雪。”\n			', '\n暂无\n			'),
(983, '0:2:10', '风行雨散', '\n【 fēng　xíng　yǔ　sàn 】\n			', '\n比喻在一起的人分散到四面八方。同“风流云散”。\n			', '\n南朝·陈徐陵《与杨仆射书》：“又闻本朝王公，都人士女，风行雨散，东播西流。”\n			', '\n暂无\n			'),
(984, '0:2:10', '风雨共舟', '\n【 fēng　yǔ　gòng　zhōu 】\n			', '\n比喻共同经历患难。\n			', '\n<span class="C999">暂无</span>\n			', '\n他俩平日相处虽不甚和睦，但在面临共同危难之时，还是～，患难与共。\n			'),
(985, '0:2:10', '风雨晦冥', '\n【 fēng　yǔ　huì　míng 】\n			', '\n指风雨交加，天色昏暗犹如黑夜。同“风雨晦暝”。\n			', '\n《元史·世祖纪一》：“乙巳迟明，至江岸，风雨晦冥，诸将皆以为未可渡，帝不从。”\n			', '\n暂无\n			'),
(986, '0:2:10', '风雨晦暝', '\n【 fēng　yǔ　huì　míng 】\n			', '\n指风雨交加，天色昏暗犹如黑夜。\n			', '\n唐·王度《古镜记》：“遂起视之，则风雨晦暝，缠绕此树，电光晃耀，忽上忽下。”\n			', '\n暂无\n			'),
(987, '0:2:10', '风雨连床', '\n【 fēng　yǔ　lián　chuáng 】\n			', '\n指兄弟或亲友久别后重逢，共处一室倾心交谈的欢乐之情。同“风雨对床”。\n			', '\n清·秋瑾《挽故人陈阕生》诗序：“回忆省垣聚首，风雨连床，曾几何时？谁怜一别，竟无会面之期。”\n			', '\n暂无\n			'),
(988, '0:2:10', '风雨飘零', '\n【 fēng　yǔ　piāo　líng 】\n			', '\n受风雨吹打而飘失零落。\n			', '\n叶圣陶《倪焕之》十二：“风雨飘零，心神不宁，骨节疼痛，都足以引起他们剧列的忿怒。”\n			', '\n暂无\n			'),
(989, '0:2:10', '风雨漂摇', '\n【 fēng　yǔ　piāo　yáo 】\n			', '\n比喻局势动荡不安，很不稳定。同“风雨飘摇”。\n			', '\n唐·李华《二孝赞》：“风雨漂摇，支体鳞皴。”\n			', '\n释晨错温清之忧，而怀～之惧。\n			'),
(990, '0:2:10', '风雨飘飖', '\n【 fēng　yǔ　piāo　yáo 】\n			', '\n比喻局势动荡不安，很不稳定。同“风雨飘摇”。\n			', '\n清·珠泉居士《续板桥杂记·丽品》：“壬寅仲冬，便道过访虽座上客满，不异曩时，而风雨飘飖，渐觉朱颜非昔矣。”\n			', '\n暂无\n			'),
(991, '0:2:10', '风雨如盘', '\n【 fēng　yǔ　rú　pán 】\n			', '\n盘：大石头。形容风雨极大。\n			', '\n宋·孙光宪《兆北琐言·逸文·丁秀才奇术致物》：“诗僧贯休《侠客》诗云：‘黄昏风雨黑如盘，别我不知何处去？’”\n			', '\n愁病之躯，斗室独坐，林莽深绕，～，豪客狂临而欲呼救，声嘶力竭，谁则听闻。\n			'),
(992, '0:2:10', '风雨时若', '\n【 fēng　yǔ　shí　ruò 】\n			', '\n指风调雨顺。\n			', '\n《书·洪范》：“曰肃，时雨若……曰圣，时风若。”孔传：“君行敬，则时雨顺之。”\n			', '\n亭无枹鼓之警，里有室家之乐。士气始奋，而人和始洽。至于～，田出自倍。\n			'),
(993, '0:2:10', '风雨摇摆', '\n【 fēng　yǔ　yáo　bǎi 】\n			', '\n在风雨中飘荡不安，比喻局势动荡不安。\n			', '\n<span class="C999">暂无</span>\n			', '\n该国经过接二连三的大罢工和游行示威的冲击，内阁已在～之中，随时可能被迫辞职。\n			'),
(994, '0:2:10', '怪雨盲风', '\n【 guài　yǔ　máng　fēng 】\n			', '\n犹疾风暴雨。形容风雨来势猛。比喻迅猛激烈的斗争。\n			', '\n宋·刘克庄《满江红·和王实之韵送伯昌》词：“怪雨盲风，留不住江边行色。”\n			', '\n黄昏蜃气忽成楼，～引客舟。\n			'),
(995, '0:2:10', '汗如雨下', '\n【 hàn　rú　yǔ　xià 】\n			', '\n汗珠象下雨似的往下掉。形容出汗很多。\n			', '\n宋·释普济《五灯会元》卷四十七：“三冬汗如雨。”\n			', '\n不防一块石头绊了一跤，犹如梦醒一般，浑身～。\n			'),
(996, '0:2:10', '疾风暴雨', '\n【 jí　fēng　bào　yǔ 】\n			', '\n疾：又快又猛；暴：突然而猛烈。形容风雨来势猛。比喻迅猛激烈的斗争。\n			', '\n《淮南子·兵略训》：“何谓隐之天？大寒甚暑，疾风暴雨，大雾冥晦，因此而为变者也。”\n			', '\n斧照伯当上三路，如飘泼盆倾，～，砍剁下来。\n			'),
(997, '0:2:10', '疾风甚雨', '\n【 jí　fēng　shèn　yǔ 】\n			', '\n指大风急雨。\n			', '\n语出《礼记·玉藻》：“君子之居恒当户，寝恒东首，若有疾风、迅雷、甚雨，则必变，虽夜必兴，衣服冠而坐。”\n			', '\n去冬节一百五日，即有～，谓之寒食。\n			'),
(998, '0:2:10', '急风骤雨', '\n【 jí　fēng　zhòu　yǔ 】\n			', '\n急剧的风雨。常用以形容声势浩大而迅猛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(999, '0:2:10', '疾风骤雨', '\n【 jí　fēng　zhòu　yǔ 】\n			', '\n疾：又快又猛；骤：突然而猛烈。形容风雨来势猛。比喻迅猛激烈的斗争。\n			', '\n《淮南子·兵略训》：“何谓隐之天？大寒甚暑，疾风暴雨，大雾冥晦，因此而为变者也。”\n			', '\n十来个妇人，一个个粗脚大手，祼臂揎拳，如～而来。\n			'),
(1000, '0:2:10', '疾雨暴风', '\n【 jí　yǔ　bào　fēng 】\n			', '\n指来势急遽而猛烈的风雨。同“暴风疾雨”。\n			', '\n晋·干宝《搜神记》卷四：“是日果有疾雨暴风，从太公邑外而过。”\n			', '\n暂无\n			'),
(1001, '0:2:10', '今雨新知', '\n【 jīn　yǔ　xīn　zhī 】\n			', '\n比喻新近结交的朋友。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1002, '0:2:10', '旧雨新知', '\n【 jiù　yǔ　xīn　zhī 】\n			', '\n旧相识和新朋友。\n			', '\n<span class="C999">暂无</span>\n			', '\n在这次国际会议上，～济济一堂，热闹非凡。\n			'),
(1003, '0:2:10', '阑风伏雨', '\n【 lán　fēng　fú　yǔ 】\n			', '\n指夏秋之际的风雨。后亦泛指风雨不已。同“阑风长雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1004, '0:2:10', '列风淫雨', '\n【 liè　fēng　yín　yǔ 】\n			', '\n列：烈；淫：过量。本指狂风暴雨。后比喻错别字连篇。\n			', '\n南朝梁·刘勰《文心雕龙·练字》：“《尚书大传》有‘别风淮雨’，《帝王世纪》云‘列风淫雨’；‘别’、‘列’、‘淮’、‘淫’，字似潜移；‘淫’‘列’义当而不奇，‘淮’‘别’理乖而新异。\n			', '\n暂无\n			'),
(1005, '0:2:10', '泪如雨下', '\n【 lèi　rú　quán　yǒng 】\n			', '\n眼泪象雨水似的直往下流。形容悲痛或害怕之极。\n			', '\n明·施耐庵《水浒全传》第八回：“林冲见说，泪如雨下，便道：‘上下，我与你二位往日无仇，近日无冤，你二位如何救得小人，生死不忘。’”\n			', '\n暂无\n			'),
(1006, '0:2:10', '雷声大，雨点小', '\n【 léi　shēng　dà，yǔ　diǎn　xiǎo 】\n			', '\n比喻做起事来声势造得很大，实际行动却很少。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1007, '0:2:10', '栎阳雨金', '\n【 lì　yáng　yǔ　jīn 】\n			', '\n比喻意外的恩赐。栎阳，地名，在中国陕西省。\n			', '\n《史记·秦本纪》：“扞献公呴十八年，雨金栎阳。”张守节正义：“言雨金于秦国都，明金瑞见也。”\n			', '\n暂无\n			'),
(1008, '0:2:10', '满城风雨', '\n【 mǎn　chéng　fēng　yǔ 】\n			', '\n城里到处刮风下雨。原形容重阳节前的雨景。后比喻某一事件传播很广，到处议论纷纷。\n			', '\n宋·潘大林《题壁》诗：“满城风雨近重阳。”\n			', '\n为什么倒弄得闹闹攘攘，～的呢？（鲁迅《花边文学·零食》）\n			'),
(1009, '0:2:10', '谋臣如雨', '\n【 móu　chén　rú　yǔ 】\n			', '\n形容智谋之士极多。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1010, '0:2:10', '盲风妒雨', '\n【 máng　fēng　dù　yǔ 】\n			', '\n指非常急骤凶猛的风雨。同“盲风怪雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1011, '0:2:10', '盲风怪雨', '\n【 máng　fēng　guài　yǔ 】\n			', '\n指非常急骤凶猛的风雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1012, '0:2:10', '盲风晦雨', '\n【 máng　fēng　huì　yǔ 】\n			', '\n指非常急骤凶猛的风雨。比喻困境。同“盲风怪雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1013, '0:2:10', '盲风涩雨', '\n【 máng　fēng　sè　yǔ 】\n			', '\n犹盲风怪雨。比喻晦涩的诗风。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1014, '0:2:10', '密云不雨', '\n【 mì　yún　bù　yǔ 】\n			', '\n满天乌云不下雨。比喻事物正在酝酿，一时还没有发作。\n			', '\n《易·小畜》：“密云不雨，自我西郊。”\n			', '\n～，尚往也；自我西郊，施未行也。（《二程全书·伊川易传一》）\n			'),
(1015, '0:2:10', '袂云汗雨', '\n【 mèi　yún　hàn　yǔ 】\n			', '\n形容行人之多。\n			', '\n《晏子春秋·杂下九》：“张袂成阴，挥汗成雨。”\n			', '\n暂无\n			'),
(1016, '0:2:10', '沐雨经霜', '\n【 mù　yǔ　jīng　shuāng 】\n			', '\n指承受雨淋霜打。形容历尽辛苦。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1017, '0:2:10', '沐雨梳风', '\n【 mù　yǔ　shū　fēng 】\n			', '\n形容人经常在外面不避风雨地辛苦奔波。同“沐雨栉风”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1018, '0:2:10', '沐雨栉风', '\n【 mù　yǔ　zhì　fēng 】\n			', '\n风梳发，雨洗头。形容人经常在外面不避风雨地辛苦奔波。\n			', '\n《庄子·天下》：“沐甚雨，栉疾风。”\n			', '\n暂无\n			'),
(1019, '0:2:10', '蛮烟瘴雨', '\n【 mán　yān　zhàng　yǔ 】\n			', '\n指南方有瘴气的烟雨。也泛指十分荒凉的地方。\n			', '\n宋·辛弃疾《满江红》词：“瘴雨蛮烟，十年梦，樽前休说。”\n			', '\n暂无\n			'),
(1020, '0:2:10', '暮雨朝云', '\n【 mù　yǔ　zhāo　yún 】\n			', '\n指男女间的情爱与欢会。\n			', '\n战国·楚·宋玉《高唐赋》：“妾在巫山之阳，高丘之阻，旦为朝云，暮为行雨。朝朝暮暮，阳台之下。”\n			', '\n暮雨迎，朝云送，～去无踪。\n			'),
(1021, '0:2:10', '欧风美雨', '\n【 ōu　fēng　měi　yǔ 】\n			', '\n①比喻欧美的政治、经济和文化。②比喻欧美的侵略。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1022, '0:2:10', '飘风急雨', '\n【 piāo　fēng　jí　yǔ 】\n			', '\n来势急遽而猛烈的风雨。同“飘风暴雨”。\n			', '\n宋·王安石《祭欧阳文忠公文》：“其清音幽韵，凄如飘风急雨之骤至。”宋·郭熙淳《林泉高致·画诀》：“夏山雨过，浓云欲雨，骤风急雨，又曰飘风急雨。”\n			', '\n暂无\n			'),
(1023, '0:2:10', '飘风苦雨', '\n【 piāo　fēng　kǔ　yǔ 】\n			', '\n形容天气恶劣。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1024, '0:2:10', '怕风怯雨', '\n【 pà　fēng　qiè　yǔ 】\n			', '\n怯：害怕。形容人害怕艰难困苦，娇气十足。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1025, '0:2:10', '飘风骤雨', '\n【 piāo　fēng　zhòu　yǔ 】\n			', '\n飘风：疾风。骤：迅疾，猛快。来势急遽而猛烈的风雨。\n			', '\n《老子》第二十三章：“故飘风不终朝，骤雨不终日。”\n			', '\n～惊飒飒，落花飞雪何茫茫。\n			'),
(1026, '0:2:10', '瓢泼大雨', '\n【 piáo　pō　dà　yǔ 】\n			', '\n像用瓢泼水那样的大雨。形容雨下得非常大的样子。\n			', '\n周立波《暴风骤雨》第一部十二：“西北悬天起了乌黑的云朵，不大一会，瓢泼大雨到来了，夹着炸雷和闪电，因为三天两头地下雨，道上黑泥总是不干的，出门的人们都是光着脚丫子，顺着道沿走。”\n			', '\n暂无\n			'),
(1027, '0:2:10', '滂沱大雨', '\n【 páng　tuó　dà　yǔ 】\n			', '\n滂沱：大雨的样子。形容雨下得很大。\n			', '\n《诗·小雅·渐渐之石》：“月离于毕，俾滂沱矣。”\n			', '\n只见～，一似瓢泼盆倾，下有半个时辰。（明·许仲琳《封神演义》第十回）\n			'),
(1028, '0:2:10', '沛雨甘霖', '\n【 pèi　yǔ　gān　lín 】\n			', '\n充足而甘美的雨水。比喻恩泽深厚。\n			', '\n明·无名氏《四贤记》第二十八出：“情浓意长，情浓意长，沛雨甘霖，憔悴生香。”\n			', '\n暂无\n			'),
(1029, '0:2:10', '喷雨嘘云', '\n【 pēn　yǔ　xū　yún 】\n			', '\n形容浪花水气的飞溅散逸。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1030, '0:2:10', '凄风楚雨', '\n【 qī　fēng　chǔ　yǔ 】\n			', '\n形容天气恶劣，或比喻境况的凄凉悲惨。同“凄风苦雨”。\n			', '\n清·程麟《此中人语·田螺妖》：“［女］每于凄风楚雨之时，常思归去。”\n			', '\n暂无\n			'),
(1031, '0:2:10', '凄风寒雨', '\n【 qī　fēng　hán　yǔ 】\n			', '\n形容天气恶劣，或比喻境况的凄凉悲惨。同“凄风苦雨”。\n			', '\n清·葆光子《物妖志·木类·柳》：“方其凄风寒雨，杏褪桃残，山路萧条，愁云千里，苔荒藓败，情扬魂销，不可谓无忧也。”\n			', '\n暂无\n			'),
(1032, '0:2:10', '凄风苦雨', '\n【 qī　fēng　kǔ　yǔ 】\n			', '\n凄风：寒冷的风；苦雨：久下成灾的雨。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n暂无\n			'),
(1033, '0:2:10', '凄风冷雨', '\n【 qī　fēng　lěng　yǔ 】\n			', '\n凄风：寒冷的风；冷雨：冰冷的雨。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n时遇秋天，怎当那～，过雁吟虫，眼前景物，无一件不是牵愁触闷的。\n			'),
(1034, '0:2:10', '栖风宿雨', '\n【 qī　fēng　xiǔ　yǔ 】\n			', '\n在风雨中止息。形容奔波辛劳。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1035, '0:2:10', '枪林弹雨', '\n【 qiāng　lín　dàn　yǔ 】\n			', '\n枪杆象树林，子弹象下雨。形容战斗激烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n～战火纷飞的日子，江水山觉得还是才开始，却一晃就过去了四年多。（冯德英《迎春花》第二章）\n			'),
(1036, '0:2:10', '倾盆大雨', '\n【 qīng　pén　dà　yǔ 】\n			', '\n雨大得象盆里的水直往下倒。形容雨大势急。\n			', '\n唐·杜甫《白帝》诗：“白帝城中云出门，白帝城下雨翻盆。”\n			', '\n烟拥层峦云拥腰，～定明朝。（宋·苏轼《雨意》诗）\n			'),
(1037, '0:2:10', '泣涕如雨', '\n【 qì　tì　rú　yǔ 】\n			', '\n泣：低声哭；涕：鼻涕。眼泪像雨一样。形容极度悲伤。\n			', '\n《诗经·邶风·燕燕》：“瞻泪弗及，泣涕如雨。”\n			', '\n暂无\n			'),
(1038, '0:2:10', '泣下如雨', '\n【 qǐ　xià　rú　yǔ 】\n			', '\n眼泪象雨一样。形容伤心到极点。\n			', '\n《诗·邶风·燕燕》：“瞻望弗及，泣涕如雨。”\n			', '\n十一娘困述病源，封～。（清·蒲松龄《聊斋志异·封三娘》）\n			'),
(1039, '0:2:10', '枪烟炮雨', '\n【 qiāng　yān　pào　yǔ 】\n			', '\n形容激烈的争战。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1040, '0:2:10', '枪烟砲雨', '\n【 qiāng　yān　pào　yǔ 】\n			', '\n形容激烈的争战。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1041, '0:2:10', '随车甘雨', '\n【 suí　chē　gān　yǔ 】\n			', '\n比喻官吏施行仁政及时为民解忧。同“随车致雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1042, '0:2:10', '随车夏雨', '\n【 suí　chē　xià　yǔ 】\n			', '\n比喻官吏施行仁政及时为民解忧。同“随车致雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1043, '0:2:10', '随车致雨', '\n【 suí　chē　zhì　yǔ 】\n			', '\n指时雨跟着车子而降。比喻官吏施行仁政及时为民解忧。\n			', '\n《后汉书·郑弘传》：“政有仁惠，民称苏息”李贤注引三国·吴·谢承《后汉书》：“弘消息繇赋，政不烦苛。行春天旱，随车致雨。”\n			', '\n暂无\n			'),
(1044, '0:2:10', '十风五雨', '\n【 shí　fēng　wǔ　yǔ 】\n			', '\n十天一刮风，五天一下雨。形容风调雨顺，气候适宜。\n			', '\n汉·王充《论衡·是应》：“风不鸣条，雨不破块，五日一风，十日一雨。”\n			', '\n斗酒只鸡人笑乐，～岁丰穰。（宋·陆游《村居初夏》诗）\n			'),
(1045, '0:2:10', '上雨旁风', '\n【 shàng　yǔ　páng　fēng 】\n			', '\n形容家里贫穷，房屋破旧。\n			', '\n唐·韩愈《面海神庙碑》：“上雨旁风，无所盖障。”\n			', '\n暂无\n			'),
(1046, '0:2:10', '暑雨祁寒', '\n【 shǔ　yǔ　qí　hán 】\n			', '\n夏大雨，冬大寒。后以之为怨嗟生计艰难之典。\n			', '\n《书·君牙》：“夏暑雨，小民惟曰怨咨，冬祁寒，小民亦惟曰怨咨，厥惟艰哉！”蔡沉集传：“祁，大也。暑雨祁寒，小民怨咨，自伤其生之艰难也。”\n			', '\n暂无\n			'),
(1047, '0:2:10', '十雨五风', '\n【 shí　yǔ　wǔ　fēng 】\n			', '\n十天下一场雨，五天刮一次风。谓风调雨顺。\n			', '\n前蜀·杜光庭《画五岳诸神醮词》：“上扶邦国，傍祐黎元。调十雨五风以登稼穑，普九州六合以致雍熙。”\n			', '\n南丰诗将驻灵江。下明光。惹天香。～，连岁致丰穰。\n			'),
(1048, '0:2:10', '山雨欲来风满楼', '\n【 shān　yǔ　yù　lái　fēng　mǎn　lóu 】\n			', '\n欲：将要。比喻局势将有重大变化前夕的迹象和气氛。\n			', '\n唐·许浑《咸阳城东楼》诗“溪云初起日沉阁，山雨欲来风满楼。”\n			', '\n国际政治形势处于～的时刻，我们一定要提高警惕，不可掉以轻心。\n			'),
(1049, '0:2:10', '粜风卖雨', '\n【 tiào　fēng　mài　yǔ 】\n			', '\n比喻招摇撞骗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1050, '0:2:10', '吞风饮雨', '\n【 tūn　fēng　yǐn　yǔ 】\n			', '\n犹言餐风宿露。形容四处奔波，生活艰辛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1051, '0:2:10', '听见风就是雨', '\n【 tīng　jiàn　fēng　jiù　shì　yǔ 】\n			', '\n刚听到一点儿风声，就当要下雨了。形容听到一点风声就竭力附和渲染。\n			', '\n清·李宝嘉《官场现形记》第二十五回：“他们做都老爷的，听见风就是雨，皇上原许他风闻奏事，说错了又没有不是的。”\n			', '\n暂无\n			'),
(1052, '0:2:10', '涕零如雨', '\n【 tì　líng　rú　yǔ 】\n			', '\n涕零：流泪。眼泪象雨水一样往下淌。形容思念的感情极深。\n			', '\n《诗经·小雅·小明》：“念彼共人，涕零如雨。”\n			', '\n暂无\n			'),
(1053, '0:2:10', '殢雨尤云', '\n【 tì　yǔ　yóu　yún 】\n			', '\n比喻男女之间的缠绵欢爱。同“殢云尤雨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1054, '0:2:10', '殢云尤雨', '\n【 tì　yún　yóu　yǔ 】\n			', '\n比喻男女之间的缠绵欢爱。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1055, '0:2:10', '五风十雨', '\n【 wǔ　fēng　shí　yǔ 】\n			', '\n五天刮一次风，十天下一场雨。形容风调雨顺。\n			', '\n汉·王充《论衡·是应》：“风不鸣条，雨不破块，五日一风，十日一雨。”\n			', '\n～天时好，又见西郊稻秫肥。（宋·王炎《双溪诗钞·丰年谣（一）》）\n			'),
(1056, '0:2:10', '未风先雨', '\n【 wèi　fēng　xiān　yǔ 】\n			', '\n比喻未见事实先下结论。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1057, '0:2:10', '巫山云雨', '\n【 wū　shān　yún　yǔ 】\n			', '\n原指古代神话传说巫山神女兴云降雨的事。后称男女欢合。\n			', '\n战国楚·宋玉《高唐赋序》：“妾在巫山之阳，高丘之阻。旦为朝云，暮为行雨，朝朝暮暮，阳台之下。”\n			', '\n暂无\n			'),
(1058, '0:2:10', '未雨绸缪', '\n【 wèi　yǔ　chóu　móu 】\n			', '\n绸缪：紧密缠缚。天还没有下雨，先把门窗绑牢。比喻事先做好准备工作。\n			', '\n《诗经·豳风·鸱号》：“迨天之未阴雨，彻彼桑土，绸缪牖户。”\n			', '\n那是不关我教习的事，在乎你们自己～的。（清·无名氏《官场维新记》第四回）\n			'),
(1059, '0:2:10', '巫云楚雨', '\n【 wū　yún　chǔ　yǔ 】\n			', '\n犹巫山云雨。原指古代神话传说巫山神女兴云降雨的事。后称男女欢合。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1060, '0:2:10', '握雨携云', '\n【 wò　yǔ　xié　yún 】\n			', '\n指男女欢合。\n			', '\n战国楚宋玉《高唐赋》：“昔者先王尝游高唐，怠而昼寝，梦见一妇人，曰：‘妾巫山之女也，为高唐之客。闻君游高唐，原荐枕席。’王因幸之。去而辞曰：‘妾在巫山之阳，高丘之阻，旦为朝云，暮为行雨，朝朝暮暮，阳台之下。’”\n			', '\n暂无\n			'),
(1061, '0:2:10', '咸风蛋雨', '\n【 xián　fēng　dàn　yǔ 】\n			', '\n指海上风雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1062, '0:2:10', '血风肉雨', '\n【 xuè　fēng　ròu　yǔ 】\n			', '\n形容剧烈残酷的屠杀或性格刚强。\n			', '\n清·梁启超《论权利思想》：“试一读欧美诸国法律发达史，如立宪政，废奴隶……等诸大法律，何一不自血风肉雨中熏沐而来。”\n			', '\n虽说～的精神，断无惜香怜玉的心绪。\n			'),
(1063, '0:2:10', '祥风时雨', '\n【 xiáng　fēng　shí　yǔ 】\n			', '\n形容风调雨顺。多比喻恩德。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1064, '0:2:10', '腥风血雨', '\n【 xīng　fēng　xuè　yǔ 】\n			', '\n风里夹着腥味，雨点带着鲜血。形容疯狂杀戮的凶险气氛或环境。\n			', '\n明·施耐庵《水浒传》第二十三回：“腥风血雨满松林，散乱毛发坠山奄。”\n			', '\n暂无\n			'),
(1065, '0:2:10', '斜风细雨', '\n【 xié　fēng　xì　yǔ 】\n			', '\n斜风：旁侧吹来的小风；细雨：小雨。形容小的风雨。\n			', '\n唐·张志和《渔父》：“青箬笠，绿蓑衣，斜风细雨不须归。”\n			', '\n暂无\n			'),
(1066, '0:2:10', '腥风醎雨', '\n【 xīng　fēng　xián　yǔ 】\n			', '\n犹腥风血雨。形容疯狂杀戮的凶险气氛或环境。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1067, '0:2:10', '杏花春雨', '\n【 xìng　huā　chūn　yǔ 】\n			', '\n初春杏花遍地、细雨润泽的景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1068, '0:2:10', '星离雨散', '\n【 xīng　lí　yǔ　sàn 】\n			', '\n比喻在一起的人纷纷别离了。\n			', '\n唐·李白《忆旧游寄谯郡元参军》诗：“当筵意气凌九宵，星离雨散不终朝。”\n			', '\n暂无\n			'),
(1069, '0:2:10', '宿雨餐风', '\n【 xiǔ　yǔ　cān　fēng 】\n			', '\n形容旅途辛劳。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1070, '0:2:10', '硝云弹雨', '\n【 xiāo　yún　dàn　yǔ 】\n			', '\n硝烟如云，子弹像雨。形容激烈的战斗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1071, '0:2:10', '杏雨梨云', '\n【 xìng　yǔ　lí　yún 】\n			', '\n杏花如雨，梨花似云。形容春天景色美丽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1072, '0:2:10', '携云握雨', '\n【 xié　yún　wò　yǔ 】\n			', '\n指男女欢合。\n			', '\n元·王实甫《西厢记》第三本第四折：“因今宵传言送语，看明日携云握雨。”\n			', '\n暂无\n			'),
(1073, '0:2:10', '血雨腥风', '\n【 xuè　yǔ　xīng　fēng 】\n			', '\n风里夹着腥味，雨点带着鲜血。形容疯狂杀戮的凶险气氛或环境。\n			', '\n明·施耐庵《水浒传》第二十三回：“腥风血雨满松林，散乱毛发坠山奄。”\n			', '\n投身革命即为家，～应有涯。取义成仁今日事，人间遍种自由花。（陈毅《梅岭三章》诗）\n			'),
(1074, '0:2:10', '夏雨雨人', '\n【 xià　yǔ　yǔ　rén 】\n			', '\n雨：前一个“雨”，名词，雨水；后一个“雨”，动词，下雨。有如夏天的雨落在人身上。比喻及时给人帮助和教育。\n			', '\n汉·刘向《说苑·贵德》：“吾不能春风风人，吾不能以夏雨雨人，吾穷必矣。”\n			', '\n暂无\n			'),
(1075, '0:2:10', '兴云致雨', '\n【 xīng　yún　zhì　yǔ 】\n			', '\n兴云：布下云彩。致雨：使下雨。神话传说，神龙有布云作雨的能力。借喻乐曲诗文，声势雄壮，不同凡响。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1076, '0:2:10', '雨鬓风鬟', '\n【 yǔ　bìn　fēng　huán 】\n			', '\n妇女发髻散乱的样子。\n			', '\n清·陈维崧《潇湘逢故人慢·题余氏女子绣柳毅传书图为阮亭赋》词：“正洞庭归客，憔悴思还。牧羊龙女，恰相逢、雨鬓风鬟。”\n			', '\n暂无\n			'),
(1077, '0:2:10', '云布雨润', '\n【 yún　bù　yǔ　rùn 】\n			', '\n比喻教化远播。\n			', '\n《宋书·夷蛮传·诃罗驼国》：“敷演正法，云布雨润。”\n			', '\n暂无\n			'),
(1078, '0:2:10', '云布雨施', '\n【 yún　bù　yǔ　shī 】\n			', '\n比喻遍布。\n			', '\n汉·司马相如《上林赋》：“缘陵流泽，云布雨施。”北周·庾信《三月三日华林园马射赋》：“上则云布雨施，下则山藏海纳。”\n			', '\n暂无\n			'),
(1079, '0:2:10', '雨僝风僽', '\n【 yǔ　chán　fēng　zhòu 】\n			', '\n指风雨交相摧折。\n			', '\n宋·辛弃疾《粉蝶儿·和晋臣赋落花》词：“昨日春如，十三女儿学绣。一枝枝、不教花瘦。甚无情，便下得，雨僝风僽。向园林、铺作地衣红绉。”\n			', '\n暂无\n			'),
(1080, '0:2:10', '雨愁烟恨', '\n【 yǔ　chóu　yān　hèn 】\n			', '\n烟雨所引起的人的惆怅哀愁。\n			', '\n宋·史达祖《隔浦莲·荷花》词：“西湖游子，惯识雨愁烟恨。只恐吴娃暗折赠。耿耿。柔丝容易萦损。”\n			', '\n暂无\n			'),
(1081, '0:2:10', '雨凑云集', '\n【 yǔ　còu　yún　jí 】\n			', '\n比喻众多的人或事物聚集一处。\n			', '\n《宋书·袁淑传》：“汴泗秀士，星流电烛；徐阜严兵，雨凑云集。”\n			', '\n暂无\n			'),
(1082, '0:2:10', '云愁雨怨', '\n【 yún　chóu　yǔ　yuàn 】\n			', '\n喻指离情别愁。\n			', '\n宋·孙光宪《何满子》词：“歌袖半遮眉黛惨，泪珠旋滴衣襟。惆怅云愁雨怨，断魂何处相寻。”\n			', '\n暂无\n			'),
(1083, '0:2:10', '雨僝云僽', '\n【 yǔ　chán　yún　zhòu 】\n			', '\n指不好的天气把人折磨。\n			', '\n宋·陈亮《点绛唇·咏梅月》词：“清人梦魂，千里人长久，君知否？雨僝云僽，格调还依旧。”\n			', '\n暂无\n			'),
(1084, '0:2:10', '雨打风吹', '\n【 yǔ　dǎ　fēng　chuī 】\n			', '\n原指花木遭受风雨摧残。比喻恶势力对弱小者的迫害。也比喻严峻的考验。\n			', '\n唐·杜甫《三绝句》：“不如醉里风吹尽，可忍醒时雨打稀。”\n			', '\n舞榭歌台，风流总被～去。（宋·辛弃疾《永遇乐·京口北固亭怀古》词）\n			'),
(1085, '0:2:10', '雨栋风帘', '\n【 yǔ　dòng　fēng　lián 】\n			', '\n形容高敞华美的楼阁。\n			', '\n唐·王勃《滕王阁》诗：“昼栋朝飞南浦云，朱帘暮卷西山雨。”\n			', '\n贝阙珠宫开水府，～岂来处。\n			'),
(1086, '0:2:10', '雨断云销', '\n【 yǔ　duàn　yún　xiāo 】\n			', '\n比喻男女恩情断绝。\n			', '\n宋·石孝友《醉落魄》词：“归期莫负青笺约。雨断云销，总是初情薄。”\n			', '\n暂无\n			'),
(1087, '0:2:10', '蚁封穴雨', '\n【 yǐ　fēng　xué　yǔ 】\n			', '\n蚂蚁聚土洞口，是要下大雨的征兆。\n			', '\n汉·焦延寿《易林》卷十三：“蚁封户穴，大雨将集。”\n			', '\n暂无\n			'),
(1088, '0:2:10', '雨覆云翻', '\n【 yǔ　fù　yún　fān 】\n			', '\n比喻变化无常。\n			', '\n明·陶宗仪《念奴娇·九日有感》词：“黄花白发，又匆匆佳节，感今怀昔。雨覆云翻无限态，故国寒烟榛棘。”\n			', '\n暂无\n			'),
(1089, '0:2:10', '云翻雨覆', '\n【 yún　fān　yǔ　fù 】\n			', '\n比喻人情世态反复无常。\n			', '\n唐·杜甫《贫交行》：“翻手作云覆手雨，纷纷轻薄何须数。”\n			', '\n今我国民，轻弃信义，权谋诡诈，～，苛刻凉薄驯至尽人皆机心，举国皆荆棘者，曰惟小说之故。\n			'),
(1090, '0:2:10', '烟霏雨散', '\n【 yān　fēi　yǔ　sàn 】\n			', '\n形容众多。\n			', '\n《文选·刘孝标〈广绝交论〉》：“络绎纵横，烟霏雨散。”李善注：“烟霏雨散，众多也。”\n			', '\n暂无\n			'),
(1091, '0:2:10', '云飞雨散', '\n【 yún　fēi　yǔ　sàn 】\n			', '\n比喻原先的事物不复存在。\n			', '\n隋·张公礼《龙藏寺碑》：“金编宝字，玉牒纶言，满封盈函，云飞雨散。”前蜀·贯休《行路难》诗之二：“云飞雨散今如此，绣闼雕甍作荒谷。”\n			', '\n暂无\n			'),
(1092, '0:2:10', '友风子雨', '\n【 yǒu　fēng　zǐ　yǔ 】\n			', '\n指云。云以风为友，以雨为子。盖风与云并行，雨因云而生。\n			', '\n《荀子·赋》：“托地而游宇，友风而子雨。”\n			', '\n暂无\n			'),
(1093, '0:2:10', '雨过天青', '\n【 yǔ　guò　tiān　qīng 】\n			', '\n雨后转晴。也比喻政治上由黑暗到光明。\n			', '\n明·谢肇涮《文海披沙记》：“御批云：‘雨过天青云破处，这般颜色做将来。’”\n			', '\n那个软烟罗只有四样颜色：一样～，一样秋色香，一样松绿的，一样就是银红的。（清·曹雪芹《红楼梦》第四十回）\n			'),
(1094, '0:2:10', '雨过天晴', '\n【 yǔ　guò　tiān　qíng 】\n			', '\n雨后转晴。也比喻政治上由黑暗到光明。\n			', '\n明·谢肇涮《文海披沙记》：“御批云：‘雨过天青云破处，这般颜色做将来。’”\n			', '\n～的早晨，空气清新极了。\n			'),
(1095, '0:2:10', '雨膏烟腻', '\n【 yǔ　gāo　yān　nì 】\n			', '\n指花草树木在烟雨中显得肥腴润泽。\n			', '\n宋·柳永《剔银灯》词：“艳杏夭桃，垂杨芳草，各斗雨膏烟腻。”\n			', '\n暂无\n			'),
(1096, '0:2:10', '雨后春笋', '\n【 yǔ　hòu　chūn　sǔn 】\n			', '\n指春天下雨后，竹笋一下子就长出来很多。比喻事物迅速大量地涌现出来。\n			', '\n宋·张耒《食笋》诗：“荒林春雨足，新笋迸龙雏。”\n			', '\n国内废科举，兴学校，好象～，努力学习西方。（毛泽东《论人民民主专政》）\n			'),
(1097, '0:2:10', '雨后送伞', '\n【 yǔ　hòu　sòng　sǎn 】\n			', '\n比喻事后献殷勤。也比喻帮助不及时。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1098, '0:2:10', '雨恨云愁', '\n【 yǔ　hèn　yún　chóu 】\n			', '\n①感觉上以为可以惹人愁怨的云和雨。②喻男女间离别之情。\n			', '\n宋·王禹偁《点绛唇·感兴》词：“雨恨云愁，江南依旧称佳丽。水村渔市，一缕孤烟细。”宋·柳永《曲玉管》词：“暗想当初，有多少、幽欢佳会，忌知聚散难期，翻成雨恨云愁。”\n			', '\n暂无\n			'),
(1099, '0:2:10', '雨巾风帽', '\n【 yǔ　jīn　fēng　mào 】\n			', '\n遮蔽风雨的头巾和帽子。常借指浪游之客。\n			', '\n宋·朱敦儒《感皇恩·游□□园感旧》词：“主人好事，坐客雨巾风帽。”宋·陈三聘《梦玉人引》词：“雨巾风帽，昔追游、谁念旧踪迹。”\n			', '\n暂无\n			'),
(1100, '0:2:10', '云交雨合', '\n【 yún　jiāo　yǔ　hé 】\n			', '\n指相会，重逢。\n			', '\n唐·李益《古别离》诗：“江回汉转两不见，云交雨合知何年。”\n			', '\n暂无\n			'),
(1101, '0:2:10', '雨井烟垣', '\n【 yǔ　jǐng　yān　yuán 】\n			', '\n比喻荒凉、冷落的景象。\n			', '\n清·孔尚任《桃花扇·题画》：“明放着花楼酒榭，丢做个雨井烟垣。”\n			', '\n暂无\n			'),
(1102, '0:2:10', '雨迹云踪', '\n【 yǔ　jì　yún　zōng 】\n			', '\n比喻往事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1103, '0:2:10', '雨淋日晒', '\n【 yǔ　lín　rì　shài 】\n			', '\n雨水淋浇，太阳曝晒。亦形容露天劳作或旅途的辛苦。\n			', '\n杨朔《三千里江山》第一段：“［姚长庚］多少年来，雨淋日晒，脸比石头还粗。”\n			', '\n暂无\n			'),
(1104, '0:2:10', '雨淋日炙', '\n【 yǔ　lín　rì　zhì 】\n			', '\n炙：烤。雨里淋，太阳晒。形容旅途或野外工作的辛苦。\n			', '\n唐·韩愈《石鼓歌》：“雨淋日炙野火燎，鬼物守护烦撝呵。”\n			', '\n暂无\n			'),
(1105, '0:2:10', '雨鬣霜蹄', '\n【 yǔ　liè　shuāng　tí 】\n			', '\n形容骏马奔驰时马鬃耸起，状如飘雨，四蹄飞翻，色白如霜。\n			', '\n元·吴澄《八骏图》诗：“阴山铁骑千千匹，雨鬣霜蹄神鬼出。”\n			', '\n暂无\n			'),
(1106, '0:2:10', '雨零星乱', '\n【 yǔ　líng　xīng　luàn 】\n			', '\n残败零落貌。常用以比喻溃败。\n			', '\n明·施耐庵《水浒传》第五十七回：“王矮虎、一丈青赶了一直，赶不上，呼延灼自投东北上去了。杀的大败亏输，雨零星乱。”\n			', '\n暂无\n			'),
(1107, '0:2:10', '雨零星散', '\n【 yǔ　líng　xīng　sàn 】\n			', '\n残败零落貌。常用以比喻溃败。\n			', '\n明·施耐庵《水浒传》第一百九回：“［张清、王英］杀散左哨军兵，如摧枯拉朽的直冲进来，杀得贼兵四分五裂，七断八续，雨零星散，乱窜奔逃。”\n			', '\n暂无\n			'),
(1108, '0:2:10', '雨帘云栋', '\n【 yǔ　lián　yún　dòng 】\n			', '\n形容高敞华美的楼阁。\n			', '\n唐·王勃《滕王阁》诗：“昼栋朝飞南浦云，朱帘暮卷西山雨。”宋·杨无咎《青玉案》词：“傍湖开径，雨帘云栋，平地居仙子。”\n			', '\n～深窈，歌笑霭春生。\n			'),
(1109, '0:2:10', '雨笠烟蓑', '\n【 yǔ　lì　yān　suō 】\n			', '\n防雨用的蓑衣笠帽，为渔夫的衣饰。亦借指渔夫。\n			', '\n宋·刘过《沁园春·咏别》词：“念丹霞秋冷，风巾雾屦，五湖春暖，雨笠烟蓑。”\n			', '\n从今稳作城东客，～不用将。\n			'),
(1110, '0:2:10', '雨露之恩', '\n【 yǔ　lù　zhī　ēn 】\n			', '\n滋生万物的雨露的恩情。比喻恩泽、恩情。\n			', '\n唐·刘禹锡《苏州谢上表》：“江海远地，孤危小臣。虽雨露之恩，幽遐必被；而犬马之恋，亲近为荣。”明·程登吉《幼学琼林·天文》：“望切者，若云霓之望；思深者，如雨露之恩。”\n			', '\n圣德之君，泽及枯骨，何况我等人民，不沾～。\n			'),
(1111, '0:2:10', '雨沐风餐', '\n【 yǔ　mù　fēng　cān 】\n			', '\n形容在外奔走劳苦，生活不得安定。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1112, '0:2:10', '雨霾风障', '\n【 yǔ　mái　fēng　zhàng 】\n			', '\n指狂恶的风雨。\n			', '\n宋·吴潜《满江红·九日郊行》词：“尽敛却、雨霾风障，雾沈云暝。远岫四呈青欲滴，长空一抹明于镜。”\n			', '\n暂无\n			'),
(1113, '0:2:10', '雨泣云愁', '\n【 yǔ　qì　yún　chóu 】\n			', '\n泪下如雨，愁多如云。形容忧愁深重。\n			', '\n元·杨显之《潇湘雨》第一折：“虽然道姻缘不偶，我可一言难就，有多少雨泣云愁。”\n			', '\n暂无\n			'),
(1114, '0:2:10', '云期雨信', '\n【 yún　qī　yǔ　xìn 】\n			', '\n指男女约定幽会的日期。\n			', '\n宋·欧阳修《品令》词：“懊恼人人薄幸。负云期雨信。”\n			', '\n暂无\n			'),
(1115, '0:2:10', '云期雨约', '\n【 yún　qī　yǔ　yuē 】\n			', '\n指男女约定幽会的日期。\n			', '\n元·石子章《竹坞听琴》第四折“但则要捉对儿云期雨约，便是俺师徒每全真了道。”\n			', '\n暂无\n			'),
(1116, '0:2:10', '云情雨意', '\n【 yún　qíng　yǔ　yì 】\n			', '\n①云和雨的状态。②指男女欢会之情。\n			', '\n宋·袁去华《浣溪沙》词：“一夕高唐梦里狂，云情雨意两茫茫。袖间依约去年香。”\n			', '\n季玉，年十一，～，小而了了。\n			'),
(1117, '0:2:10', '雨宿风餐', '\n【 yǔ　sù　fēng　cān 】\n			', '\n意指风口处吃饭，雨地里住宿。形容生活飘泊不定。\n			', '\n宋·范成大《四明人董峄久居岳市乞诗》：“祝融峰下两逢春，雨宿风餐老病身。莫笑五湖萍梗客，海边亦有未归人。”\n			', '\n暂无\n			'),
(1118, '0:2:10', '雨散风流', '\n【 yǔ　sàn　fēng　liú 】\n			', '\n比喻离散。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1119, '0:2:10', '雨蓑风笠', '\n【 yǔ　suō　fēng　lì 】\n			', '\n防雨用的蓑衣笠帽，为渔夫的衣饰。亦借指渔夫。\n			', '\n宋·李曾伯《沁园春·丙辰归里和八窗叔韵》词：“天教狂虏灰飞。更莫问儿郎存血衣。把雪裘霜帽，绝交楚徼，雨蓑风笠，投老吴矶。”\n			', '\n暂无\n			'),
(1120, '0:2:10', '雨丝风片', '\n【 yǔ　sī　fēng　piàn 】\n			', '\n形容春天的微风细雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1121, '0:2:10', '雨顺风调', '\n【 yǔ　shùn　fēng　tiáo 】\n			', '\n调：调和；顺：和协。风雨及时适宜。形容风雨适合农时。\n			', '\n《六韬》：“既而克殷，风凋雨顺。”\n			', '\n我愿天公怜赤子，莫生尤物为疮痏。～百谷登，民不饥寒为上瑞。\n			'),
(1122, '0:2:10', '雨散云飞', '\n【 yǔ　sàn　yún　fēi 】\n			', '\n比喻离散。\n			', '\n唐·白居易《五年秋病后独宿香山寺三绝句》之二：“饮徒歌伴今何在，雨散云飞尽不回。”唐·司空图《游仙诗》之二：“刘郎相约事难谐，雨散云飞自此乖。”\n			', '\n暂无\n			'),
(1123, '0:2:10', '烟蓑雨笠', '\n【 yān　suō　yǔ　lì 】\n			', '\n①指蓑衣斗笠两种雨具。②借指隐者的服装或隐者优游自适的生活。\n			', '\n宋·苏轼《书晁说之〈考牧图〉后》诗：“烟蓑雨笠长林下，老去而今空见画。”\n			', '\n扫空紫陌红尘梦，收得～身。\n			'),
(1124, '0:2:10', '雨蓑烟笠', '\n【 yǔ　suō　yān　lì 】\n			', '\n防雨用的蓑衣笠帽，为渔夫的衣饰。亦借指渔夫。\n			', '\n唐·翁洮《渔者》诗：“一叶飘然任浪吹，雨蓑烟笠肯忘机。”\n			', '\n～傍渔矶，应不是、封侯相。\n			'),
(1125, '0:2:10', '雨散云收', '\n【 yǔ　sàn　yún　shōu 】\n			', '\n①比喻亲朋离散。②\n			', '\n唐·温庭筠《送崔郎中赴幕》诗：“心游目送三千里，雨散云收二十年。”唐·慎氏《感夫诗》：“当时心事已相关，雨散云收一饷间，便是孤帆从此去，不堪重上望夫山。”\n			', '\n不多时候，忽然～，推出一轮红日，顷刻黄河解冻。\n			'),
(1126, '0:2:10', '雨收云散', '\n【 yǔ　shōu　yún　sàn 】\n			', '\n比喻某种现象已经消失。\n			', '\n宋·陆游《水龙吟·春日游摩诃池》词：“惆怅年华暗换。黯销魂、雨收云散。”\n			', '\n刚待～后，凶徒恶党又依然。\n			'),
(1127, '0:2:10', '云收雨散', '\n【 yún　shōu　yǔ　sàn 】\n			', '\n喻欢会结束，彼此分离。\n			', '\n宋·周邦彦《烛影摇红》词：“当时谁会唱《阳关》。离恨天涯远。争奈云收雨散。凭阑干、东风泪满。”\n			', '\n誓世世生生休抛撇。不提防，惨凄凄，月坠花折；悄冥冥，～；恨茫茫，只落得死断生绝。\n			'),
(1128, '0:2:10', '云屯雨集', '\n【 yún　tún　yǔ　jí 】\n			', '\n形容众多的人聚集在一起。\n			', '\n明·罗贯中《三国演义》第九回：“贼兵云屯雨集，围定城池，布军与战不利。”\n			', '\n暂无\n			'),
(1129, '0:2:10', '雨条烟叶', '\n【 yǔ　tiáo　yān　yè 】\n			', '\n雨中的柳条，烟雾中的柳叶。形容凄迷的景色。亦比喻情意的缠绵。\n			', '\n宋·晏殊《浣溪沙》词：“只有醉吟宽别恨，不须朝暮促归程。雨条烟叶系人情。”宋·晏几道《浪淘沙·丽曲醉思仙》词：“秾蛾叠柳脸红莲。多少雨条烟叶恨，红泪离筵。”\n			', '\n暂无\n			'),
(1130, '0:2:10', '雨卧风餐', '\n【 yǔ　wò　fēng　cān 】\n			', '\n风口处吃饭，雨地里住宿。形容生活飘泊不定。\n			', '\n唐·杜甫《舟中》诗：“风餐江柳下，雨卧驿楼边。”\n			', '\n暂无\n			'),
(1131, '0:2:10', '云行雨洽', '\n【 yún　xíng　yǔ　qià 】\n			', '\n比喻广施恩泽。\n			', '\n《乐府诗集·舞曲歌辞一·北齐文武舞歌》：“云行雨洽，天临地持。”\n			', '\n暂无\n			'),
(1132, '0:2:10', '云消雨散', '\n【 yún　xiāo　yǔ　sàn 】\n			', '\n比喻一切都成了过去。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1133, '0:2:10', '云行雨施', '\n【 yún　xíng　yǔ　shī 】\n			', '\n施：施布。比喻广泛施行恩泽。\n			', '\n《周易·乾》：“云行雨施，天下平也。”\n			', '\n曰：“如何是君臣之道？”师曰：“～，月皎星辉。”（宋·释普济《五灯会元》卷十四）\n			'),
(1134, '0:2:10', '雨消云散', '\n【 yǔ　xiāo　yún　sàn 】\n			', '\n比喻消失得一干二净。\n			', '\n瞿秋白《赤都心史》八：“情爱呢？，可知，这甜情蜜意，禁不起——理性一闪，迟早是——雨消云散。”\n			', '\n暂无\n			'),
(1135, '0:2:10', '雨歇云收', '\n【 yǔ　xiē　yún　shōu 】\n			', '\n比喻男女离散。\n			', '\n元·关汉卿《金线池》第二折：“明知道雨歇云收，还指望待天长地久。”元·无名氏《百花亭》第二折：“止望待天长地久，谁承望雨歇云收。”\n			', '\n暂无\n			'),
(1136, '0:2:10', '夜雨对床', '\n【 yè　yǔ　duì　chuáng 】\n			', '\n指亲友或兄弟久别重逢，在一起亲切交谈。\n			', '\n唐·白居易《雨中招张司业宿》诗：“能来同宿否，听雨对床眠。”\n			', '\n暂无\n			'),
(1137, '0:2:10', '月晕而风，础润而雨', '\n【 yuè　yūn　ér　fēng，chǔ　rùn　ér　yǔ 】\n			', '\n月晕出现，将要刮风；础石湿润，就要下雨。比喻从某些征兆可以推知将会发生的事情。\n			', '\n宋·苏洵《辨奸论》：“事有必至，理有固然，惟天下之静者，乃能见微而知著。月晕而风，础润而雨，人人知之。”\n			', '\n燥湿为天地自然之气，～，人以此测于几先者，固古今一致也。\n			'),
(1138, '0:2:10', '雨旸时若', '\n【 yǔ　yáng　shí　ruò 】\n			', '\n指晴雨适时，气候调和。\n			', '\n语本《书·洪范》：“曰肃，时雨若；曰乂，时旸若。”元·马致远《荐福碑》第二折：“雨旸时若在仁君，鼎鼐调和有大臣。”\n			', '\n暂无\n			'),
(1139, '0:2:10', '云雨巫山', '\n【 yún　yǔ　wū　shān 】\n			', '\n原指古代神话传说巫山神女兴云降雨的事。后称男女欢合。\n			', '\n战国楚·宋玉《高唐赋序》：“妾在巫山之阳，高丘之阻。旦为朝云，暮为行雨，朝朝暮暮，阳台之下。”\n			', '\n一枝红艳露凝香，～枉断肠。（唐·李白《清平调》）\n			'),
(1140, '0:2:10', '雨约云期', '\n【 yǔ　yuē　yún　qī 】\n			', '\n指男女约会。\n			', '\n元·关汉卿《望江亭》第一折：“我呵，怕什么天翻地覆，就顺着他雨约云期。”\n			', '\n～，楚台巫峡。\n			'),
(1141, '0:2:10', '云尤雨殢', '\n【 yún　yóu　yǔ　tì 】\n			', '\n形容男女间情意缠绵。\n			', '\n明·单本《蕉帕记·覸婚》：“我鸟啼花落自支吾，他云尤雨殢相怜护。我凄凉无绪，他绸缪有余。”\n			', '\n暂无\n			'),
(1142, '0:2:10', '月晕知风，础润知雨', '\n【 yuè　yūn　zhī　fēng，chǔ　rùn　zhī　yǔ 】\n			', '\n月晕出现，将要刮风；础石湿润，就要下雨。比喻从某些征兆可以推知将会发生的事情。\n			', '\n长舆《论莱阳民变事》：“月晕知风，础润知雨，窃恐踵莱阳而起者，祸变相寻而来未有已也。”\n			', '\n暂无\n			'),
(1143, '0:2:10', '尤云殢雨', '\n【 yóu　yún　zhì　yǔ 】\n			', '\n比喻缠绵于男女欢爱。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1144, '0:2:10', '雨僽风僝', '\n【 yǔ　zhòu　fēng　chán 】\n			', '\n指风雨交相摧折。\n			', '\n元·柯丹邱《荆钗记·庆诞》：“椿老萱衰，只恐雨僽风僝。”\n			', '\n暂无\n			'),
(1145, '0:2:10', '雨踪云迹', '\n【 yǔ　zōng　yún　jì 】\n			', '\n比喻男女情好的往事。\n			', '\n宋·曾觌《清商怨》词：“清宵寂，香闺隔。好梦难寻，雨踪云迹。忆忆忆。”\n			', '\n暂无\n			'),
(1146, '0:2:10', '云朝雨暮', '\n【 yún　zhāo　yǔ　mù 】\n			', '\n指男女欢会之时。\n			', '\n宋·贺铸《断湘弦·淑质柔情》词：“不间云朝雨暮，向西楼、南馆留连。”宋·叶阊《摸鱼儿·倚薰风》词：“红裙溅水鸳鸯湿，几度云朝雨暮。”\n			', '\n暂无\n			'),
(1147, '0:2:10', '雨沾云惹', '\n【 yǔ　zhān　yún　rě 】\n			', '\n指男女情爱。\n			', '\n战国·楚·宋玉《高唐赋》：“昔者先王尝游高唐，怠而昼寝，梦见一妇人，曰：‘妾，巫山之女也，为高唐之客，闻君游高唐，原荐枕席。’王因幸之。去而辞曰：‘妾在巫山之阳，高丘之阻，旦为朝云，暮为行雨，朝朝暮暮，阳台之下。’”\n			', '\n弋槛营中夜未央，～侍襄王。\n			'),
(1148, '0:2:10', '骤风暴雨', '\n【 zhòu　fēng　bào　yǔ 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n柳青《铜墙铁壁》第八章：“众人都担心这时正是下雷雨的节令，猛不防来一阵骤风暴雨，人们藏在地洞里难免遭水淹。”\n			', '\n暂无\n			'),
(1149, '0:2:10', '骤风急雨', '\n【 zhòu　fēng　jí　yǔ 】\n			', '\n来势急遽而猛烈的风雨。同“骤雨狂风”。\n			', '\n宋·郭熙淳《林泉高致·画诀》：“夏山雨过，浓云欲雨，骤风急雨，又曰飘风急雨。”\n			', '\n我看，虏骑行军甚疾，常如～，恐怕你们想助我一臂之力已经来不及了。\n			'),
(1150, '0:2:10', '栉风沐雨', '\n【 zhì　fēng　mù　yǔ 】\n			', '\n栉：梳头发；沐：洗头发。风梳发，雨洗头。形容人经常在外面不顾风雨地辛苦奔波。\n			', '\n《庄子·天下》：“沐甚雨，栉疾风。”\n			', '\n～三十余年，扫荡群凶，与百姓除害，使汉室复存。（明·罗贯中《三国演义》第六十一回）\n			'),
(1151, '0:2:10', '招风惹雨', '\n【 zhāo　fēng　rě　yǔ 】\n			', '\n比喻惹是生非，引出事端。\n			', '\n清·西周生《醒世姻缘传》第四十二回：“这监生不惟遮不得风，避不得雨，且还要招风惹雨。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1152, '0:2:10', '栉风酾雨', '\n【 zhì　fēng　shī　yǔ 】\n			', '\n风梳发，雨洗头。形容奔波劳苦。同“栉风沐雨”。\n			', '\n清·陈康祺《郎潜纪闻》卷一：“都兴阿诸公，忠贞朴劲，屡摧狂寇，栉风酾雨，始终戎幕。”\n			', '\n暂无\n			'),
(1153, '0:2:10', '魆风骤雨', '\n【 zhuō　fēng　zhòu　yǔ 】\n			', '\n犹暴风骤雨。比喻声势浩大，发展急速而猛烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1154, '0:2:10', '栉沐风雨', '\n【 zhì　mù　fēng　yǔ 】\n			', '\n风梳发，雨洗头。形容奔波劳苦。同“栉风沐雨”。\n			', '\n后晋·沈昫《旧唐书·宣宗纪》：“况将士等栉沐风雨，暴露郊原，披荆棘而刁斗夜严，逐豺狼而穹庐晓破。 ”\n			', '\n方今晋王亲当矢石，～，王殚供军之租赋，为不急之游盘，世道未夷，人心多梗，久虚府第，远出游从，如乐祸之徒，翻然起变，拒门不纳，则王欲何归！\n			'),
(1155, '0:2:10', '骤雨暴风', '\n【 zhòu　yǔ　bào　fēng 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n清·张德彝《随使法国记·归途记》：“初六日壬辰，阴晴不定……入夜骤雨暴风一阵。”\n			', '\n暂无\n			'),
(1156, '0:2:10', '骤雨狂风', '\n【 zhòu　yǔ　kuáng　fēng 】\n			', '\n来势急遽而猛烈的风雨。\n			', '\n《宣和书谱·释怀素》：“自谓得草书三昧……当时名流如李白、戴叔伦、窦臯、钱起之徒皆有诗美之。状其势以谓若惊蛇走虺，骤雨狂风。”\n			', '\n～随地卷，奔雷掣电走天神。\n			'),
(1157, '0:2:10', '瘴雨蛮烟', '\n【 zhàng　yǔ　mán　yān 】\n			', '\n指南方有瘴气的烟雨。也泛指十分荒凉的地方。\n			', '\n宋·辛弃疾《满江红》词：“瘴雨蛮烟，十年梦，尊前休说。”\n			', '\n暂无\n			'),
(1158, '0:2:11', '飙发电举', '\n【 biāo　fā　diàn　jù 】\n			', '\n形容声势迅猛。\n			', '\n《明史·戚继光传》：“大猷老将务持重，继光则飙发电举，屡摧大寇，名更出大猷上。”\n			', '\n德参赞～，而额经略节制山立，谋勇相资，卒戡大难。\n			'),
(1159, '0:2:11', '飙举电至', '\n【 biāo　jǔ　diàn　zhì 】\n			', '\n飙：疾风、暴风。风起云涌闪电到。形容声势猛烈。\n			', '\n汉·桓宽《盐铁论·世务》：“匈奴贪狼，因时而动，乘可而发，飙举电至。”\n			', '\n暂无\n			'),
(1160, '0:2:11', '尺波电谢', '\n【 chǐ　bō　diàn　xiè 】\n			', '\n波，水波。指人世短促，如波逝电闪。\n			', '\n《文选·刘孝标\n			', '\n～，今昔同悲；嗟我吉人，而止于斯。\n			'),
(1161, '0:2:11', '潮鸣电掣', '\n【 cháo　míng　diàn　chè 】\n			', '\n极言气势大、速度炔。\n			', '\n鲁迅《集外集·斯巴达之魂》：“惟见如火如荼之敌军先锋队，挟三倍之势，潮鸣电掣以阵于斯巴达军后。”\n			', '\n暂无\n			'),
(1162, '0:2:11', '潮鸣电挚', '\n【 cháo　míng　diàn　chè 】\n			', '\n极言气势大、速度快。\n			', '\n鲁迅《集外集·斯巴达之魂》：“惟见如火如荼之敌军先锋队，挟三倍之势，潮鸣电掣以阵于斯巴达军后。”\n			', '\n暂无\n			'),
(1163, '0:2:11', '电掣风驰', '\n【 diàn　chè　fēng　chí 】\n			', '\n形容像闪电刮风一样迅速。\n			', '\n清·百一居士《壶天录》卷下：“龙腾虎啸，不足比其雄；电掣风驰，不足喻其疾。”\n			', '\n这里……没有什么～、左冲右撞的一切车子。\n			'),
(1164, '0:2:11', '电掣星驰', '\n【 diàn　chè　xīng　chí 】\n			', '\n如闪电和流星似的掠过。比喻迅疾。\n			', '\n《儿女英雄传》第十回：“[十三妹]回头向大家说声请了，霎时间电掣星驰，不见踪影。”\n			', '\n暂无\n			'),
(1165, '0:2:11', '电光石火', '\n【 diàn　guāng　shí　huǒ 】\n			', '\n闪电的光，燧石的火。原为佛家语，比喻事物瞬息即逝。现多形容事物象闪电和石火一样一瞬间就消逝。\n			', '\n宋·释普济《五灯会元》：“此事如击石火，似闪电光。”\n			', '\n但看还没有十分看明，又如～一样飞也似地过去了。（郭沫若《学生时代·孤山的梅花》）\n			'),
(1166, '0:2:11', '电光朝露', '\n【 diàn　guāng　zhāo　lù 】\n			', '\n一闪而过的电光，日出以前的露水。比喻存在不久的事物。\n			', '\n《金刚经》：“一切有为法，如梦幻泡影，如露亦如电，应作如是观。”\n			', '\n暂无\n			'),
(1167, '0:2:11', '电流星散', '\n【 diàn　liú　xīng　sàn 】\n			', '\n比喻迅速消散。\n			', '\n清·沈起凤《谐铎·獭祭》：“鹯曰：‘君善捕鱼，我善捕雀，而雀之见我者，往往晓音骇翼，电流星散，以至十不获一。’”\n			', '\n暂无\n			'),
(1168, '0:2:11', '电闪雷鸣', '\n【 diàn　shǎn　léi　míng 】\n			', '\n闪电飞光，雷声轰鸣。比喻快速有力。也比喻轰轰烈烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n我们的总理，回答得最为铿锵有力；不用语言，而用电闪雷鸣般的一生的经历。（郭小川《痛悼敬爱的周总理》诗）\n			'),
(1169, '0:2:11', '电照风行', '\n【 diàn　zhào　fēng　xíng 】\n			', '\n如电光之照耀，如风之流动。比喻影响甚大。\n			', '\n南朝·梁·刘孝标《辩命论》：“电照风行，声驰海外。”\n			', '\n暂无\n			'),
(1170, '0:2:11', '风驰电掣', '\n【 fēng　chí　diàn　chè 】\n			', '\n驰：奔跑；掣：闪过。形容非常迅速，象风吹电闪一样。\n			', '\n《六韬·龙韬·王翼》：“奋威四人，主择材力，论兵革，风驰电掣，不知所由。”\n			', '\n黄飞虎枪法如～，往来如飞。（明·许仲琳《封神演义》第六十回）\n			'),
(1171, '0:2:11', '风驰电骋', '\n【 fēng　chí　diàn　chěng 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n汉·严遵《道德指归论·至柔》：“故字曰至柔，名曰无形，是以无形之物不以坚，坚不以壮。壮，故能敝天地，销铜铁，风驰电骋，经极日月，周流上下。”\n			', '\n暂无\n			'),
(1172, '0:2:11', '风驰电赴', '\n【 fēng　chí　diàn　fù 】\n			', '\n形容迅速赶赴。\n			', '\n《晋书·孙绰传》：“如其迷逆不化，复欲送死者，南北诸军风驰电赴，若身手之救痛痒，率然之应首尾，山陵既固，中夏小康。”\n			', '\n暂无\n			'),
(1173, '0:2:11', '风驰电击', '\n【 fēng　chí　diàn　jī 】\n			', '\n形容迅速出击。\n			', '\n《六韬·龙韬·王翼》：“奋威四人，主择材力，论兵革，风驰电击，不知所由。”\n			', '\n王师北伐如宣王，～复土疆。\n			'),
(1174, '0:2:11', '风驰电卷', '\n【 fēng　chí　diàn　juǎn 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n唐·温大雅《大唐创业起居注》卷一：“突厥所长，惟恃骑射，见利即前，知难便走，风驰电卷，不恒其陈。”\n			', '\n马夫拉动缰绳，一会儿～，把一个青年会会员陈千秋，不知赶到哪里去了。\n			'),
(1175, '0:2:11', '风驰电逝', '\n【 fēng　chí　diàn　shì 】\n			', '\n形容像刮风和闪电那样迅速。同“风驰电掣”。\n			', '\n三国·魏·嵇康《赠秀才入军》：“风驰电逝，蹑景追风；凌历中原，顾盼生姿。”\n			', '\n柏夭导车，造父为右，～三千里。\n			'),
(1176, '0:2:11', '风回电激', '\n【 fēng　huí　diàn　jī 】\n			', '\n形容像风那样回旋，像闪电那样迅速。\n			', '\n唐·封演《封氏闻见记·打球》：“玄宗东西驱突，风回电激，所向无前。”\n			', '\n暂无\n			'),
(1177, '0:2:11', '风激电飞', '\n【 fēng　jī　diàn　fēi 】\n			', '\n形容势猛。\n			', '\n《三国志·蜀志·郤正传》：“云合雾集，风激电飞，量时揆宜，用取世资。”\n			', '\n暂无\n			'),
(1178, '0:2:11', '风激电骇', '\n【 fēng　jī　diàn　hài 】\n			', '\n形容势猛。同“风激电飞”。\n			', '\n《南史·梁纪上·武帝》：“凭险作守，兵食兼资，风激电骇，莫不震叠。”\n			', '\n暂无\n			'),
(1179, '0:2:11', '风驱电击', '\n【 fēng　qū　diàn　jī 】\n			', '\n形容迅速出击。同“风驰电击”。\n			', '\n《宋书·谢晦传》：“散骑常侍、骁骑将军段宏铁马二千，风驱电击，步自竟陵，直至鄢郢。”\n			', '\n暂无\n			'),
(1180, '0:2:11', '风驱电扫', '\n【 fēng　qū　diàn　sǎo 】\n			', '\n形容像刮风、闪电那样迅速驰赴和扫除。\n			', '\n《南齐书·裴叔业崔慧景等传论》：“征虏将军投袂以先国急，束马旅师，横江竞济，风驱电扫，制胜转丸。”\n			', '\n平生闻谭公胸中数万甲兵，所至～，今治蜀顾如此，乃知宏才不器，无适非宜，哲士达权，随时善变也。\n			'),
(1181, '0:2:11', '风旋电掣', '\n【 fēng　xuán　diàn　chè 】\n			', '\n掣：闪过；旋：奔跑。你风一样飞驰而过，像闪电一样一角即逝。形容非常迅速。\n			', '\n《六韬·王翼》：“奋威四人，主择材力，论兵革，风驰电掣，扫除妖魅。”\n			', '\n乃一手挥刀格斗，一手掷妇于床，如～，已无踪。（清·纪昀《阅微草堂笔记·如是我闻二》）\n			'),
(1182, '0:2:11', '风行电掣', '\n【 fēng　xíng　diàn　chè 】\n			', '\n掣：闪过。像风一样飞驰而过，像闪电一样一闪即逝。形容非常迅速。\n			', '\n清·姜承烈《\n			', '\n暂无\n			'),
(1183, '0:2:11', '风行电击', '\n【 fēng　xíng　diàn　jī 】\n			', '\n形容气势迅猛。\n			', '\n《隋书·扬谅传》：“文安请为前锋，王以大军继后，风行电击，顿于霸上，咸阳以东可指麾而定。”\n			', '\n清河公房彦藻，近秉戎律，略地东南，师之所临，～。\n			'),
(1184, '0:2:11', '风行电扫', '\n【 fēng　xíng　diàn　sǎo 】\n			', '\n形容气势迅猛。同“风行电击”。\n			', '\n《隋书·韦洸传》：“公鸿勋大业，名高望重，率将戎旅，抚慰彼方，风行电扫，咸应稽服。”\n			', '\n暂无\n			'),
(1185, '0:2:11', '风行电照', '\n【 fēng　xíng　diàn　zhào 】\n			', '\n形容迅速威猛。\n			', '\n《后汉书·臧宫传》：“将军向者经虏城下，震扬威灵，风行电照。然穷冠难量，还营愿从它道矣。”\n			', '\n暂无\n			'),
(1186, '0:2:11', '飞云掣电', '\n【 fēi　yún　chè　diàn 】\n			', '\n掣：闪过。像流云飞和闪电一样。形容非常迅速。\n			', '\n明·许仲琳《封神演义》第二十一回：“不说追兵随后飞云掣电而来。”\n			', '\n暂无\n			'),
(1187, '0:2:11', '鬼出电入', '\n【 guǐ　chū　diàn　rù 】\n			', '\n比喻变化巧妙迅速，不易捉摸。\n			', '\n《淮南子·原道训》：“鬼出电入，龙兴鸾集。”\n			', '\n～，不可端倪。（清·纪昀《阅微草堂笔记·槐西杂志》）\n			'),
(1188, '0:2:11', '轰雷掣电', '\n【 hōng　léi　chè　diàn 】\n			', '\n雷声隆隆，电光闪闪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1189, '0:2:11', '驹窗电逝', '\n【 jū　chuāng　diàn　shì 】\n			', '\n比喻光阴消逝得很快。\n			', '\n前蜀·杜光庭《封李真人告词》：“振衣世表，抗迹云间，悁驹窗电逝之劳，得鳌岭云行之趣。”\n			', '\n暂无\n			'),
(1190, '0:2:11', '击电奔星', '\n【 jī　diàn　bēn　xīng 】\n			', '\n形容快速。\n			', '\n《敦煌变文集·伍子胥变文》：“天兵有限，不可久停，马乃击电奔星，行至子胥妻舍。拟迎妇归吴国。”\n			', '\n暂无\n			'),
(1191, '0:2:11', '疾如雷电', '\n【 jí　rú　léi　diàn 】\n			', '\n快提就像雷鸣闪电。形容形势发展很迅速。\n			', '\n汉·荀悦《汉纪·高祖纪》：“项羽用兵疾如雷电。”\n			', '\n暂无\n			'),
(1192, '0:2:11', '雷嗔电怒', '\n【 léi　chēn　diàn　nù 】\n			', '\n暴怒的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1193, '0:2:11', '雷电交加', '\n【 léi　diàn　jiāo　jiā 】\n			', '\n又是打雷，又是闪电。交加：一起袭来。两种事物同时或错杂出现。\n			', '\n明·凌濛初《二刻拍案惊奇》卷三十八：“忽然阴云四合，空中雷电交加，李三身上枷钮尽行脱落。”\n			', '\n是夜二更，风雨大作，～，喊杀之声，闻数十里。\n			'),
(1194, '0:2:11', '雷惊电绕', '\n【 léi　jīng　diàn　rào 】\n			', '\n雷鸣电闪。比喻落笔如飞的笔画。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1195, '0:2:11', '流星掣电', '\n【 liú　xīng　chè　diàn 】\n			', '\n比喻迅疾。同“流星飞电”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1196, '0:2:11', '流星飞电', '\n【 liú　xīng　fēi　diàn 】\n			', '\n比喻迅疾。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1197, '0:2:11', '驱雷策电', '\n【 qū　léi　cè　diàn 】\n			', '\n比喻神通广大。同“驱雷掣电”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1198, '0:2:11', '驱雷掣电', '\n【 qū　léi　chè　diàn 】\n			', '\n比喻神通广大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1199, '0:2:11', '驱霆策电', '\n【 qū　tíng　cè　diàn 】\n			', '\n比喻迅速奔驰。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1200, '0:2:11', '神抶电击', '\n【 shén　chì　diàn　jī 】\n			', '\n指如神电之笞击。比喻进击疾速。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1201, '0:2:11', '石火电光', '\n【 shí　huǒ　diàn　guāng 】\n			', '\n形容事物象闪电和石火一样一瞬间就消逝。\n			', '\n宋·释道原《景德传灯录》卷二十四：“僧问：‘如何是佛法大意？’……师曰：‘石火电光，已经尘劫。’”\n			', '\n暂无\n			'),
(1202, '0:2:11', '投壶电笑', '\n【 tóu　hú　diàn　xiào 】\n			', '\n后为闪电不雨之典。\n			', '\n《神异经·东荒经》：“东荒山中有大石室，东王公居焉……恒与一玉女投壶，每投千二百矫，设有入不出者，……矫出而脱悮不接者，天为之笑。”张华注：“言笑者，天口流火照灼，今天不下雨而有电光是天笑也。”\n			', '\n暂无\n			'),
(1203, '0:2:11', '星驰电掣', '\n【 xīng　chí　diàn　chè 】\n			', '\n驰：奔驰。象星疾驰，如电急闪。形容极其迅速。\n			', '\n《周书·段永传》：“若星驰电发，出其不虞，精骑五百，自足平殄。”\n			', '\n好容易才把贵廷拉出旅馆，拖上火车，～的赶到前方。\n			'),
(1204, '0:2:11', '星驰电发', '\n【 xīng　chí　diàn　fā 】\n			', '\n指迅速如流星闪电。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1205, '0:2:11', '星驰电走', '\n【 xīng　chí　diàn　zǒu 】\n			', '\n驰：奔驰；走：跑。象星疾驰，如电急闪。形容极其迅速。\n			', '\n元·杨显之《潇湘雨》楔子：“腿上无毛嘴有髭，星驰电走不违时，沿河两岸长巡哨，以此加为排岸司。”\n			', '\n好容易才把贵廷拉出旅馆，拖上火车，星驰电掣的赶到前方。（蔡东藩、许廑父《民国通俗演义》第一二三回）\n			'),
(1206, '0:2:11', '迅电流光', '\n【 xùn　diàn　liú　guāng 】\n			', '\n比喻光阴像电光迅速地消逝。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1207, '0:2:11', '星飞电急', '\n【 xīng　fēi　diàn　jí 】\n			', '\n如流星飞落，如闪电急驰。形容十分急速或事情非常紧急。\n			', '\n元·施惠《拜月亭·奉命和番》：“合火速便驰驿，等回音，星飞电急。”\n			', '\n暂无\n			'),
(1208, '0:2:11', '星流电击', '\n【 xīng　liú　diàn　jī 】\n			', '\n形容迅猛异常。同“星流霆击”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1209, '0:2:11', '星旗电戟', '\n【 xīng　qí　diàn　jǐ 】\n			', '\n军旗象繁星，剑戟如闪电。比喻军容之盛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1210, '0:2:11', '星行电征', '\n【 xīng　xíng　diàn　zhēng 】\n			', '\n象流星闪电。比喻奔驰迅速。\n			', '\n汉·应劭《风俗通·十反》：“望自劾去，星行电征，数日归，趋诣府。”\n			', '\n暂无\n			'),
(1211, '0:2:11', '逐电追风', '\n【 zhú　diàn　zhuī　fēng 】\n			', '\n追赶闪电和迅风。形容速度非常快。\n			', '\n《说唐》第十回：“叔宝（秦叔宝）拜辞，连夜起身，出庄上马，纵辔加鞭，如逐电追风，十分迅速。”\n			', '\n衣不解带，纵辔加鞭，如～，十分迅捷。\n			'),
(1212, '0:2:11', '追风掣电', '\n【 zhuī　fēng　chè　diàn 】\n			', '\n形容速度极快。多指马飞速奔驰。同“追风逐电”。\n			', '\n宋·张淏《云谷杂记·侍郎徐公帖》：“愿得侧翅附鸿鹄，追风掣电凌太空。”\n			', '\n暂无\n			'),
(1213, '0:2:11', '逐风追电', '\n【 zhú　fēng　zhuī　diàn 】\n			', '\n追赶迅风和闪电。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1214, '0:2:11', '追风逐电', '\n【 zhuī　fēng　zhú　diàn 】\n			', '\n形容速度极快。多指马飞速奔驰。\n			', '\n北齐·刘昼《新论·知人》：“故孔方諲之相马也，虽未追风逐电，绝尘灭影，而迅足之势固已见矣。”\n			', '\n山风忽起，那狮子～似的，追那些虎狼去了。\n			'),
(1215, '0:2:11', '追云逐电', '\n【 zhuī　yún　zhú　diàn 】\n			', '\n极言迅疾。\n			', '\n任光椿《戊戌喋血记》第三章十四：“毕竟是张力人精选的好马，果然是四足生风，追云逐电。”\n			', '\n暂无\n			'),
(1216, '0:2:12', '布鼓雷门', '\n【 bù　gǔ　léi　mén 】\n			', '\n布鼓：布蒙的鼓；雷门：古代浙江会稽的城门名。在雷门前击布鼓。比喻在能手面前卖弄本领。\n			', '\n《汉书·王尊传》：“毋持布鼓过雷门。”\n			', '\n暂无\n			'),
(1217, '0:2:12', '不敢越雷池一步', '\n【 bù　gǎn　yuè　léi　chí　yī　bù 】\n			', '\n越：跨过；雷池：湖名，在安徽省望江县南。原指不要越过雷池。后比喻不敢超越一定的范围和界限。\n			', '\n晋·庾亮《报温峤书》：“吾忧西陲，过于历阳，足下无过雷池一步也。”\n			', '\n是用来批评那些已经学习了很多却“～”、在艺术手法上陈陈相因的人们的。（秦牧《独创一格》）\n			'),
(1218, '0:2:12', '暴跳如雷', '\n【 bào　tiào　rú　léi 】\n			', '\n急怒叫跳，象打雷一样猛烈。形容又急又怒，大发脾气的样子。\n			', '\n清·吴敬梓《儒林外史》第六回：“严贡生越发恼得暴跳如雷。”\n			', '\n他脾气很坏，一遇不顺心的事，就～。\n			'),
(1219, '0:2:12', '爆跳如雷', '\n【 bào　tiào　rú　léi 】\n			', '\n指盛怒的样子。\n			', '\n《何典》第十回：“倒塔鬼爆跳如雷道：‘你只长他人志气，灭自己威风。’”\n			', '\n暂无\n			'),
(1220, '0:2:12', '鼻息如雷', '\n【 bí　xī　rú　léi 】\n			', '\n鼻息：鼾声。打呼噜的声音就象打雷一样响。形容熟睡时鼾声大作。\n			', '\n宋·沈括《梦溪笔谈·人事》：“上使人微觇准所为，而准方酣寝于中书，鼻息如雷。”\n			', '\n暂无\n			'),
(1221, '0:2:12', '不越雷池', '\n【 bù　yuè　léi　shi 】\n			', '\n比喻不敢超越一定的范围和界限。同“不敢越雷池一步”。\n			', '\n晋·庾亮《报温峤书》：“吾忧西陲，过于历阳，足下无过雷池一步也。”\n			', '\n暂无\n			'),
(1222, '0:2:12', '暴躁如雷', '\n【 bào　zào　rú　léi 】\n			', '\n暴：暴烈，急躁。急怒叫跳，象打雷一样猛烈。形容又急又怒，大发脾气的样子。\n			', '\n《古诗为焦仲卿妻作》：“我有亲父兄，性行暴如雷。”\n			', '\n严贡生越发恼得～。\n			'),
(1223, '0:2:12', '蝉喘雷干', '\n【 chán　chuǎn　léi　gān 】\n			', '\n蝉：昆虫名，知了；干：空。蝉喘息，雷声净。形容酷热干旱。\n			', '\n前蜀·贯休《苦热寄赤松道者》：“蝉喘雷干冰井融，些子清风有何益。”\n			', '\n暂无\n			'),
(1224, '0:2:12', '大发雷霆', '\n【 dà　fā　léi　tíng 】\n			', '\n霆：呼雷，喻震怒。比喻大发脾气，大声斥责。\n			', '\n《三国志·吴书·陆逊传》：“今不忍小忿而发雷霆之怒。”\n			', '\n不知说了一句甚么话，符老爷登时～起来，把那独脚桌子一掀。(清·吴趼人《二十年目睹之怪现状》第七十四回)\n			'),
(1225, '0:2:12', '电闪雷鸣', '\n【 diàn　shǎn　léi　míng 】\n			', '\n闪电飞光，雷声轰鸣。比喻快速有力。也比喻轰轰烈烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n我们的总理，回答得最为铿锵有力；不用语言，而用电闪雷鸣般的一生的经历。（郭小川《痛悼敬爱的周总理》诗）\n			'),
(1226, '0:2:12', '风掣雷行', '\n【 fēng　chè　léi　xíng 】\n			', '\n掣：闪过。风闪雷鸣。形容像刮风和响雷那样迅速。\n			', '\n<span class="C999">暂无</span>\n			', '\n洋场马路，纵横井井，虽不及上海之平坦，而马车洋车往来络绎，～（清·无名氏《游越南记》）\n			'),
(1227, '0:2:12', '风雷火炮', '\n【 fēng　léi　huǒ　pào 】\n			', '\n形容十分急躁。\n			', '\n清·吴研人《二十年目睹之怪现状》第五十二回：“上前天我们才到上海，货还没有起完，到了半夜里，忽然宪太太来了，风雷火炮的一阵，马上就要开船，脸上很带点怒色。”\n			', '\n暂无\n			'),
(1228, '0:2:12', '风雷之变', '\n【 fēng　léi　zhī　biàn 】\n			', '\n指上天示警的灾异现象。\n			', '\n据《书·金縢》载：周武王死后，周公摄政，镇压了武王的弟弟管叔、蔡叔等的叛乱。武王子成王因受流言影响，怀疑周公的忠诚，于是“天大雷电以风，禾尽偃，大木斯拔，邦人大恐。”\n			', '\n夏四月，京师地震。癸巳司空陈褒以灾异免。于是犹有～，有司复以追咎三公。\n			'),
(1229, '0:2:12', '风行雷厉', '\n【 fēng　xíng　léi　lì 】\n			', '\n形容气势的迅疾猛烈。后多比喻执行政事法令等的迅速严格。\n			', '\n明·许自昌《水浒记·纵骑》：“官差紧者，为黄巾钩党严厉莫停者，怕鼠窜掉头者，东溪望忙行边。”\n			', '\n戒严令～。不准集会，也不准罢课。\n			'),
(1230, '0:2:12', '鬼工雷斧', '\n【 guǐ　gōng　léi　fǔ 】\n			', '\n形容艺术技巧高超，不是人力所能达到的。同“鬼斧神工”。\n			', '\n明·宋濂《滩哥石砚歌》：“鬼工雷斧琢削古，天光电影生新容。”\n			', '\n暂无\n			'),
(1231, '0:2:12', '轰雷掣电', '\n【 hōng　léi　chè　diàn 】\n			', '\n雷声隆隆，电光闪闪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1232, '0:2:12', '轰雷贯耳', '\n【 hōng　léi　guàn　ěr 】\n			', '\n打雷的声音贯满耳边。形容人的声名很大。\n			', '\n元·郑光祖《王粲登楼》第一折：“久闻贤士大名，如轰雷贯耳。”\n			', '\n暂无\n			'),
(1233, '0:2:12', '欢声雷动', '\n【 huān　shēng　léi　dòng 】\n			', '\n欢笑的声音象雷一样响着。形容热烈欢乎的动人场面。\n			', '\n唐·令狐楚《贺敕表》：“欢声雷动，喜气云腾。”\n			', '\n这里众位也有坐轿的，也有走的，见两边百姓，扶老携幼，挨挤着来看，～。（清·吴敬梓《儒林外史》第三十七回）\n			'),
(1234, '0:2:12', '鼾声如雷', '\n【 hān　shēng　rú　léi 】\n			', '\n鼾声：熟睡时发出的鼻息声。形容睡得很深，鼾声很大。\n			', '\n宋·沈括《梦溪笔谈》第九章：“上使人微觇准所为，而准方酣寝于中书，鼻息如雷。”\n			', '\n暂无\n			'),
(1235, '0:2:12', '黄钟毁弃，瓦釜雷鸣', '\n【 huáng　zhōng　huǐ　qì,　wǎ　fǔ　léi　míng 】\n			', '\n黄钟被砸烂并被抛置一边，而把泥制的锅敲得很响。比喻有才德的人被弃置不用，而无才德的平庸之辈却居于高位。\n			', '\n战国·楚·屈原《楚辞·卜居》：“世溷浊而不清，蝉翼为重，千钧为轻；黄钟毁弃，瓦釜雷鸣；谗人高张，贤士无名。”\n			', '\n暂无\n			'),
(1236, '0:2:12', '疾风迅雷', '\n【 jí　fēng　xùn　léi 】\n			', '\n形容事情的发生和发展，象暴风急雷那样猛烈而迅速。\n			', '\n《礼记·玉藻》：“君子之居恒当户，寝恒东首，若有疾风、迅雷、甚雨，则必变，虽夜必兴，衣服冠而坐。”\n			', '\n暂无\n			'),
(1237, '0:2:12', '疾雷不及掩耳', '\n【 jí　léi　bù　jí　yǎn　ěr 】\n			', '\n突然响起雷声，使人来不及掩耳。比喻事情或动作来得突然，使人来不及防备。\n			', '\n《六韬·龙韬·军势》：“疾雷不及掩耳，迅电不及瞑目。”\n			', '\n他们或者未必起身，给他们个疾雷不及掩耳，拿了就走，必不使一名漏网。（清·李宝嘉《文明小史》第七回）\n			'),
(1238, '0:2:12', '捷雷不及掩耳', '\n【 jié　léi　bù　jí　yǎn　ěr 】\n			', '\n犹迅雷不及掩耳。比喻事起突然，不及防备。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1239, '0:2:12', '疾雷不暇掩耳', '\n【 jí　léi　bù　xiá　yǎn　ěr 】\n			', '\n比喻事情或动作来得突然，使人来不及防备。同“疾雷不及掩耳”。\n			', '\n晋·傅玄《傅子·阙题》：“我欲战而彼不欲战者，我鼓而进之若山崩河溢，当其冲者摧，值其锋者破，所谓疾雷不暇掩耳，则又谁御之。”\n			', '\n暂无\n			'),
(1240, '0:2:12', '疾雷不及塞耳', '\n【 jí　léi bù　jí sāi　ěr 】\n			', '\n比喻事情或动作来得突然，使人来不及防备。同“疾雷不及掩耳”。\n			', '\n《淮南子·兵略训》：“故善用兵者，见敌之虚，乘而勿假也，追而勿舍也，迫而勿去也，击其犹犹，陵其与与，疾雷不及塞耳，疾霆不暇掩目。”\n			', '\n暂无\n			'),
(1241, '0:2:12', '疾如雷电', '\n【 jí　rú　léi　diàn 】\n			', '\n快提就像雷鸣闪电。形容形势发展很迅速。\n			', '\n汉·荀悦《汉纪·高祖纪》：“项羽用兵疾如雷电。”\n			', '\n暂无\n			'),
(1242, '0:2:12', '聚蚊成雷', '\n【 jù　wén　chéng　léi 】\n			', '\n许多蚊子聚到一起，声音会象雷声那样大。比喻说坏话的人多了，会使人受到很大的损害。\n			', '\n《汉书·中山靖王传》：“夫众煦漂山，聚蚊成雷。”\n			', '\n～，封狐千里。（《南史·武陵王纪传》）\n			'),
(1243, '0:2:12', '雷奔云谲', '\n【 léi　bēn　yún　jué 】\n			', '\n如雷奔行，如云翻卷。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1244, '0:2:12', '雷嗔电怒', '\n【 léi　chēn　diàn　nù 】\n			', '\n暴怒的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1245, '0:2:12', '雷打不动', '\n【 léi　dǎ　bù　dòng 】\n			', '\n形容态度坚定，不可动摇。也形容严格遵守规定，决不变更。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1246, '0:2:12', '雷动风行', '\n【 léi　dòng　fēng　xíng 】\n			', '\n①指万物运动变化迅速。②比喻推行政令的严厉迅猛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1247, '0:2:12', '雷电交加', '\n【 léi　diàn　jiāo　jiā 】\n			', '\n又是打雷，又是闪电。交加：一起袭来。两种事物同时或错杂出现。\n			', '\n明·凌濛初《二刻拍案惊奇》卷三十八：“忽然阴云四合，空中雷电交加，李三身上枷钮尽行脱落。”\n			', '\n是夜二更，风雨大作，～，喊杀之声，闻数十里。\n			'),
(1248, '0:2:12', '烈火轰雷', '\n【 liè　huǒ　hōng　léi 】\n			', '\n形容性情暴躁，爱发脾气。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1249, '0:2:12', '雷惊电绕', '\n【 léi　jīng　diàn　rào 】\n			', '\n雷鸣电闪。比喻落笔如飞的笔画。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1250, '0:2:12', '雷厉风飞', '\n【 léi　lì　fēng　fēi 】\n			', '\n①象雷那样猛烈，象风那样快。同“雷厉风行”。②严厉威猛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1251, '0:2:12', '雷厉风行', '\n【 léi　lì　fēng　xíng 】\n			', '\n象雷那样猛烈，象风那样快。比喻执行政策法令严厉迅速。也形容办事声势猛烈，行动迅速。\n			', '\n唐·韩愈《潮州刺史谢上表》：“陛下即位以来，躬亲听断，旋乾转坤；关机阖开，雷厉风行。”\n			', '\n今天调卷，明天提人，颇觉～。（清·李宝嘉《官场现形记》第三十三回）\n			'),
(1252, '0:2:12', '雷令风行', '\n【 léi　lìng　fēng　xíng 】\n			', '\n犹言雷厉风行。象雷那样猛烈，象风那样快。比喻执行政策法令严厉迅速。也形容办事声势猛烈，行动迅速。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1253, '0:2:12', '雷鸣瓦釜', '\n【 léi　míng　wǎ　fǔ 】\n			', '\n釜：锅。锅发出雷一般的响声。比喻无德无才的人占据高位，声势烜赫。\n			', '\n《楚辞·卜居》：“黄钟毁弃，瓦釜雷鸣。谗人高张，贤士无名。”\n			', '\n暂无\n			'),
(1254, '0:2:12', '雷声大，雨点小', '\n【 léi　shēng　dà，yǔ　diǎn　xiǎo 】\n			', '\n比喻做起事来声势造得很大，实际行动却很少。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1255, '0:2:12', '雷霆万钧', '\n【 léi　tíng　wàn　jūn 】\n			', '\n霆：急雷；钧：古代重量单位，三十斤为一钧。形容威力极大，无法阻挡。\n			', '\n汉·贾山《至言》：“雷霆之所击，无不摧折者；万钧之所压，无不糜灭者。”\n			', '\n唯独共产主义的思想体系和社会制度正以排山倒海之势，～之力，磅礴于全世界，……（毛泽东《新民主主义论》）\n			'),
(1256, '0:2:12', '雷霆之怒', '\n【 léi　tíng　wàn　j 】\n			', '\n雷霆：霹雳。象霹雳一样的盛怒。形容愤怒到了极点。\n			', '\n《三国志·吴志·陆逊传》：“今不忍小忿，而发雷霆之怒，违垂堂之戒，轻万乘之重，此臣之所惑也。”\n			', '\n主公暂息～，这牛皋是一员勇将，乃是岳飞的结义兄弟也。\n			'),
(1257, '0:2:12', '平地风雷', '\n【 píng　dì　fēng　léi 】\n			', '\n犹言平地一声雷。比喻突然发生的重大变动。也比喻名声或地位突然升高。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1258, '0:2:12', '平地起雷', '\n【 píng　dì　qǐ　léi 】\n			', '\n犹言平地一声雷。比喻突然发生的重大变动。也比喻名声或地位突然升高。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1259, '0:2:12', '平地一声雷', '\n【 píng　dì　yī　shēng　léi 】\n			', '\n比喻突然发生的重大变动。也比喻名声或地位突然升高。\n			', '\n五代·前蜀·韦庄《喜迁莺》：“凤衔金榜出门来，平地一声雷。”\n			', '\n虽然是运不齐，他可也志不灰。只等待桃花浪暖蛰龙飞，～。（元·无名氏《举案齐眉》第三折）\n			'),
(1260, '0:2:12', '咆哮如雷', '\n【 páo　xiāo　rú　léi 】\n			', '\n形容人暴怒喊叫的神态。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1261, '0:2:12', '驱雷策电', '\n【 qū　léi　cè　diàn 】\n			', '\n比喻神通广大。同“驱雷掣电”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1262, '0:2:12', '驱雷掣电', '\n【 qū　léi　chè　diàn 】\n			', '\n比喻神通广大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1263, '0:2:12', '如雷贯耳', '\n【 rú　léi　guàn　ěr 】\n			', '\n贯：贯穿，进入。响亮得象雷声传进耳朵里。形容人的名声大。\n			', '\n元·无名氏《冻苏秦》第一折：“久闻先生大名，如雷贯耳。”\n			', '\n暂无\n			'),
(1264, '0:2:12', '如雷灌耳', '\n【 rú　léi　guàn　ěr 】\n			', '\n①形容声音大（多指语音）。②形容人的名声很大。\n			', '\n《三国志平话》卷中：“‘吾乃燕人张翼德，谁敢共吾决死？’叫声如雷灌耳，桥梁皆断。”\n			', '\n季苇萧道：‘先生大名，～。小弟献丑，真是弄斧班门了。’\n			'),
(1265, '0:2:12', '天打雷劈', '\n【 tiān　dǎ　léi　pī 】\n			', '\n比喻不得好死。常用作骂人或赌咒的话。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1266, '0:2:12', '瓦釜雷鸣', '\n【 wǎ　fǔ　léi　míng 】\n			', '\n瓦釜：沙锅，比喻庸才。声音低沉的沙锅发出雷鸣般的响声。比喻无德无才的人占据高位，威风一时。\n			', '\n《楚辞·卜居》：“黄钟毁弃，瓦釜雷鸣。谗人高张，贤士无名。”\n			', '\n暂无\n			'),
(1267, '0:2:12', '闻雷失箸', '\n【 wén　léi　shī　zhù 】\n			', '\n比喻借别的事情掩饰自己的真实情况。\n			', '\n《三国志·蜀书·先主传》：“是时曹公从容谓先主曰：‘今天下英雄，唯使君与操耳。本初之徒，不足数也。’先主方食，失匕箸。”\n			', '\n暂无\n			'),
(1268, '0:2:12', '迅雷不及掩耳', '\n【 xùn　léi　bù　jí　yǎn　ěr 】\n			', '\n雷声来得非常快，连捂耳朵都来不及。比喻来势凶猛，使人来不及防备。\n			', '\n《六韬·龙韬·军势》：“疾雷不及掩耳，迅电不及瞑目。”\n			', '\n因此我给他个～的突然袭击，一口把他吃掉，是完全有可能的。（曲波《林海雪原》二九）\n			'),
(1269, '0:2:12', '迅雷风烈', '\n【 xùn　léi　fēng　liè 】\n			', '\n犹言迅雷烈风。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1270, '0:2:12', '一雷二闪', '\n【 yī　léi　èr　shǎn 】\n			', '\n形容躲避迅速。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1271, '0:2:13', '碧空如洗', '\n【 bì　kōng　rú　xǐ 】\n			', '\n碧空：浅蓝色的天空。蓝色的天空明净得像洗过一样。形容天气晴朗。\n			', '\n宋·张元干《水调歌头》词：“万里碧空如洗，寒浸十分明月，帘卷玉波流。”\n			', '\n其时～，有一群大雁鹅正排成人字从高空中飞过。\n			'),
(1272, '0:2:13', '碧空万里', '\n【 bì　kōng　wàn　lǐ 】\n			', '\n万里：指面积大，距离长。形容天气晴朗。\n			', '\n权延赤《走下圣坛的周恩来·休息与娱乐》：“冰峰林立，白云徜徉其间；碧空万里，与皑皑白雪上下辉映，幻化流转着七彩光芒。”\n			', '\n二百万年前的一天，～无云，太阳炙烤着大地。\n			'),
(1273, '0:2:13', '薄暮冥冥', '\n【 bó　mù　míng　míng 】\n			', '\n傍晚时天气昏暗。\n			', '\n宋·范仲淹《岳阳楼记》：“薄暮冥冥，虎啸猿啼。”\n			', '\n暂无\n			'),
(1274, '0:2:13', '冰雪严寒', '\n【 bīng　xuě　yán　hán 】\n			', '\n严寒：极度寒冷。冰天雪地，天气寒冷。\n			', '\n吴伯箫《菜园小记》“虽然按照时令季节，各种蔬菜种得有早有晚，有时收了这种菜才种那种菜；但是除了冰雪严寒的冬天，一年里春夏秋三季，菜园里总是经常有几种蔬菜在竞肥争绿的。”\n			', '\n暂无\n			'),
(1275, '0:2:13', '春暖花开', '\n【 chūn　nuǎn　huā　kāi 】\n			', '\n本指春天气候宜人，景物优美。现也比喻大好时机。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1276, '0:2:13', '惨雨酸风', '\n【 cǎn　yǔ　suān　fēng 】\n			', '\n犹言凄风苦雨。指令人伤感的天气。亦以喻不安定的局势。\n			', '\n《三元里人民抗英斗争史料·英夷就抚》：“军门传箭夜缒城，郦生寸舌能销兵。抽红换白须臾事，惨雨酸风顷刻平。”\n			', '\n暂无\n			'),
(1277, '0:2:13', '滴水成冰', '\n【 dī　shuǐ　chéng　bīng 】\n			', '\n水滴下去就结成冰。形容天气十分寒冷。\n			', '\n宋·钱易《南部新书》：“严冬冱寒，滴水成冰。”\n			', '\n北方的冬天，十分寒冷，～。\n			'),
(1278, '0:2:13', '风和日丽', '\n【 fēng　hé　rì　lì 】\n			', '\n和风习习，阳光灿烂。形容晴朗暖和的天气。\n			', '\n清·吴趼人《痛史》：“是日风和日丽，众多官员，都来祭奠。”\n			', '\n是时～，遍地金黄，青衫红袖，越阡度陌，蝶蜂乱飞，令人不饮自醉。（清·沈复《浮生六记》卷二）\n			'),
(1279, '0:2:13', '风轻云淡', '\n【 fēng　qīng　yún　dàn 】\n			', '\n微风轻拂，浮云淡薄。形容天气晴好。同“风轻云净”、“云淡风轻”。\n			', '\n元·杨暹《西游记》第四本第十三出：“元定下的夫妻怎断，咱茶浓酒酣，趁着风轻云淡，省得着我倚门终日盼停骖。”\n			', '\n寒食春归御柳条，～日轮高。\n			'),
(1280, '0:2:13', '风轻云净', '\n【 fēng　qīng　yún　jìng 】\n			', '\n微风轻拂，浮云淡薄。形容天气晴好。同“风轻云淡”。\n			', '\n《群英类选〈分钗记·春游遇妓〉》：“风轻云净，绝胜蓬莱佳境。”\n			', '\n暂无\n			'),
(1281, '0:2:13', '风雨交加', '\n【 fēng　yǔ　jiāo　jiā 】\n			', '\n又是刮风，又是下雨。比喻几种灾难同时袭来。\n			', '\n<span class="C999">暂无</span>\n			', '\n难以想象，他是怎样渡过那～的日子的。\n			'),
(1282, '0:2:13', '和风丽日', '\n【 hé　fēng　lì　rì 】\n			', '\n指天气温暖而晴朗。\n			', '\n宋·柳永《西平乐》词：“正是和风丽日，几许繁红嫩绿，雅称嬉游去。”\n			', '\n那时节～满东园。\n			'),
(1283, '0:2:13', '寒风侵肌', '\n【 hán　fēng　qīn　jī 】\n			', '\n形容天气寒冷。\n			', '\n<span class="C999">暂无</span>\n			', '\n冷锋过境，～，人们尽量不出门，致使娱乐场所生意清淡。\n			'),
(1284, '0:2:13', '虹销雨霁', '\n【 hóng　xiāo　yǔ　jì 】\n			', '\n虹：彩虹；销：同“消”，消失；霁：本指雨止，也引申为天气放睛。彩虹消失，雨后天睛。\n			', '\n唐·王勃《滕王阁序》：“虹销雨霁，彩彻云衢，落霞与孤鹜齐飞，秋水共长天一色。”\n			', '\n暂无\n			'),
(1285, '0:2:13', '皓月千里', '\n【 hào　yuè　qiān　lǐ 】\n			', '\n范围极为广阔的千山万水都处于皎洁的月光照射之下。形容月光皎洁，天气暗和。\n			', '\n宋·范仲淹《岳阳楼记》：“长烟一空，皓月千里，浮光耀金，静影沉璧。”\n			', '\n暂无\n			'),
(1286, '0:2:13', '焦金流石', '\n【 jiāo　jīn　liú　shí 】\n			', '\n将金属、石头烧焦、熔化。形容天气极度干旱、炎热。\n			', '\n南朝·刘孝标《辩命论》：“放勋之世，浩浩襄陵；天乙之时，焦金流石。”\n			', '\n暂无\n			'),
(1287, '0:2:13', '焦金烁石', '\n【 jiāo　jīn　shuò　shí 】\n			', '\n使金石熔化枯焦。形容天气酷热。\n			', '\n北齐·刘昼《刘子新论·大质》：“大热煊赫，焦金烁石。”\n			', '\n暂无\n			'),
(1288, '0:2:13', '焦沙烂石', '\n【 jiāo　shā　shí　làn 】\n			', '\n将沙烧焦，石烧烂。形容天气非常酷热。\n			', '\n汉·董仲舒《春秋繁露·循天之道》：“为寒则疑冰裂地，为热则焦沙烂石。”\n			', '\n暂无\n			'),
(1289, '0:2:13', '苦雨凄风', '\n【 kǔ　yǔ　qī　fēng 】\n			', '\n苦雨：久下成灾的雨；凄风：寒冷的风。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n黄昏长夜，捱了多少～；春昼秋霄，受了多少魂惊目断。\n			'),
(1290, '0:2:13', '流金铄石', '\n【 liú　jīn　shuò　shí 】\n			', '\n铄、流：熔化。形容天气酷热，好象金石都要熔化。\n			', '\n《淮南子·铨言训》：“大热铄石流金，火弗为益其烈。”战国楚·宋玉《招魂》：“十日代出，流金铄石些。”\n			', '\n季月烦暑，～，聚蚊成雪，封狐千里。（《南史·梁武帝诸子传》）\n			'),
(1291, '0:2:13', '飘风苦雨', '\n【 piāo　fēng　kǔ　yǔ 】\n			', '\n形容天气恶劣。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1292, '0:2:13', '凄风苦雨', '\n【 qī　fēng　kǔ　yǔ 】\n			', '\n凄风：寒冷的风；苦雨：久下成灾的雨。形容天气恶劣。后用来比喻境遇悲惨凄凉。\n			', '\n《左传·昭公四年》：“春无凄风，秋无苦雨。”\n			', '\n暂无\n			'),
(1293, '0:2:13', '秋高气和', '\n【 qiū　gāo　qì　hé 】\n			', '\n形容秋空高朗、天气晴和。\n			', '\n清·曾朴《孽海花》第十九回：“却说小燕便服轻车，叫车夫径到城南保安寺街而来，那时秋高气和，尘软蹄轻，不一会已到了门口，把车停在门前两棵大榆树荫下。”\n			', '\n暂无\n			'),
(1294, '0:2:13', '秋高气爽', '\n【 qiū　gāo　qì　shuǎng 】\n			', '\n形容秋季晴空万里，天气清爽。\n			', '\n唐·杜甫《崔氏东山草堂》诗：“爱汝玉山草堂静，高秋爽气相鲜新。”\n			', '\n方拟～，遣将西征。（清·梁晋竹《两般秋雨盦随笔·史阁部书》）\n			'),
(1295, '0:2:13', '人间重晚晴', '\n【 rén　jiān　zhòng　wǎn　qíng 】\n			', '\n原指人们珍视晚晴天气，后多用以比喻社会上尊重德高望重的老前辈。\n			', '\n唐·李商隐《晚晴》诗：“天意怜幽草，人间重晚晴。”\n			', '\n暂无\n			'),
(1296, '0:2:13', '日丽风和', '\n【 rì　lì　fēng　hé 】\n			', '\n和风习习，阳光灿烂。形容晴朗暖和的天气。\n			', '\n元·李爱山《集贤宾·春日伤别》：“那时节和风丽日满东园，花共柳红娇绿软。”\n			', '\n这日正是清明佳节，～。\n			'),
(1297, '0:2:13', '日丽风清', '\n【 rì　lì　fēng　qīng 】\n			', '\n阳光明丽，清风送爽。形容天气晴和。\n			', '\n魏巍《东方》第五部第十五章：“外面日丽风清，蓝天如洗，是一个典型的明净的秋日。”\n			', '\n暂无\n			'),
(1298, '0:2:13', '十冬腊月', '\n【 shí　dōng　là　yuè 】\n			', '\n指阴历十月、十一、十二月天气寒冷的季节。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1299, '0:2:13', '铄石流金', '\n【 shuò　shí　liú　jīn 】\n			', '\n铄、流：熔化。石头被熔化，金属变成了水。形容天气很热。\n			', '\n《淮南子·铨言训》：“大热铄石流金，火弗为益其烈。”战国楚·宋玉《招魂》：“十日代出，流金铄石些。”\n			', '\n暂无\n			'),
(1300, '0:2:13', '天寒地冻', '\n【 tiān　hán　dì　dòng 】\n			', '\n形容天气极为寒冷。\n			', '\n明·施耐庵《水浒全传》第六十五回：“目今天寒地冻，军马难以久住，权且回山。”\n			', '\n暂无\n			'),
(1301, '0:2:13', '五黄六月', '\n【 wǔ　huáng　liù　yuè 】\n			', '\n指阴历五、六月间天气最炎热的时候。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1302, '0:2:13', '万里无云', '\n【 wàn　lǐ　wú　yún 】\n			', '\n湛湛蓝天，没有一丝云彩。形容天气晴朗。\n			', '\n元·王实甫《西厢记》第三本第二折：“碧天万里无云，空劳倦客身心。”\n			', '\n～贺六龙，千林不放鸟飞空。地燃石裂江湖沸，不见南来一点风。\n			'),
(1303, '0:2:13', '雪窖冰天', '\n【 xuě　jiào　bīng　tiān 】\n			', '\n窖：收藏东西的地洞。到处是冰和雪。形容天气寒冷，也指严寒地区。\n			', '\n《宋史·朱弁传》：“叹马角之未生，魂销雪窖；攀龙髯而莫逮，泪洒冰天。”\n			', '\n今日荷戈边塞去，可堪雪窖复冰天。（清·黄遵宪《归过日本志感》诗）\n			'),
(1304, '0:2:13', '雪虐风饕', '\n【 xuě　nüè　fēng　tāo 】\n			', '\n虐：暴虐；饕：贪残。又是刮风，又是下雪。形容天气非常寒冷。\n			', '\n唐·韩愈《祭河南张员外文》：“岁弊寒凶，雪虐风饕。”\n			', '\n幽香淡淡影疏疏，～亦自如。（宋·陆游《雪中寻梅》诗）\n			'),
(1305, '0:2:13', '雨僝云僽', '\n【 yǔ　chán　yún　zhòu 】\n			', '\n指不好的天气把人折磨。\n			', '\n宋·陈亮《点绛唇·咏梅月》词：“清人梦魂，千里人长久，君知否？雨僝云僽，格调还依旧。”\n			', '\n暂无\n			'),
(1306, '0:2:13', '云淡风轻', '\n【 yún　dàn　fēng　qīng 】\n			', '\n微风轻拂，浮云淡薄。形容天气晴好。亦作“风轻云淡”。\n			', '\n宋·程灏《春日偶成》：“云淡风轻近午天，傍花随柳过前川。”\n			', '\n暂无\n			'),
(1307, '0:2:13', '云迷雾锁', '\n【 yún　mí　wù　suǒ 】\n			', '\n形容天气昏暗，气氛阴森。\n			', '\n元·无名氏《朱砂担》第二折：“巴的到绿杨渡口，早则是云迷雾锁黄昏后。”\n			', '\n暂无\n			'),
(1308, '0:2:13', '知地知天', '\n【 zhī　dì　zhī　tiān 】\n			', '\n地：地形：天：天气。了解地形，了解气候。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1309, '0:2:13', '折胶堕指', '\n【 zhé　jiāo　duò　zhǐ 】\n			', '\n极言天气寒冷。\n			', '\n宋·苏轼《磨衲赞》：“折胶堕指，此衲不寒，烁石流金，此衲不热。”宋·周密《齐东野语·曝日》：“《冬日初出铭》曰：‘折胶堕指，梦想负背。’”\n			', '\n暂无\n			'),
(1310, '0:3:0', '抱头鼠窜', '\n【 bào　tóu　shǔ　cuàn 】\n			', '\n抱着头，象老鼠那样惊慌逃跑。形容受到打击后狼狈逃跑。\n			', '\n《汉书·蒯通传》：“始常山王、成安君故相与为刎颈之交，及争张黡、陈释之事，常山王奉头鼠窜，以归汉王。”\n			', '\n夫陆贾天下之辨士，吾前日遣之，智穷辞屈，～，颠狈而归。（宋·苏轼《拟侯公说项羽辞》）\n			'),
(1311, '0:3:0', '虫臂鼠肝', '\n【 chóng　bì　shǔ　gān 】\n			', '\n比喻极微小而无价值的东西。\n			', '\n《庄子·大宗师》：“以汝为汝肝乎？以汝为虫臂乎？”\n			', '\n鼠肝虫臂万化途，神奇腐朽相推迁。（金·元好问《食榆荚》诗）\n			'),
(1312, '0:3:0', '城狐社鼠', '\n【 chéng　hú　shè　shǔ 】\n			', '\n社：土地庙。城墙上的狐狸，社庙里的老鼠。比喻依仗权势作恶，一时难以驱除的小人。\n			', '\n《晏子春秋·内篇问上》：“夫社，束木而涂之，鼠因而托焉，薰之则恐烧其木，灌之则恐败其涂。此鼠所以不可得杀者，以社故也。”《晋书·谢鲲传》：“隗诚始祸，然城狐社鼠也。”\n			', '\n以事论，则现在的教育界中实无豺虎，但有些～之流，那是当然不能免的。（鲁迅《华盖集·“公理”的把戏》）\n			'),
(1313, '0:3:0', '鸱鸦嗜鼠', '\n【 chī　yā　shì　shǔ 】\n			', '\n比喻嗜好各不相同。\n			', '\n《庄子·齐物论》：“民食刍豢，麋鹿食荐，  且甘带，鸱鸦嗜鼠，四者孰知正味。”\n			', '\n暂无\n			'),
(1314, '0:3:0', '鸱张鼠伏', '\n【 chī　zhāng　shǔ　fú 】\n			', '\n比喻时而嚣张，时而隐蔽。\n			', '\n《明史·贵州土司传序》：“蛮人鸱张鼠伏，自其常态。”\n			', '\n暂无\n			'),
(1315, '0:3:0', '掉头鼠窜', '\n【 diào　tóu　shǔ　cuàn 】\n			', '\n转过头来像老鼠一样逃窜。形容狼狈逃窜。\n			', '\n明·许自昌《水浒记·纵骑》：“他怎肯网开三面漫相遮，教我掉头鼠窜无宁贴。”\n			', '\n暂无\n			'),
(1316, '0:3:0', '胆小如鼠', '\n【 dǎn　xiǎo　rú　shǔ 】\n			', '\n胆子小得象老鼠。形容非常胆小。\n			', '\n《魏书·汝阴王天赐传》：“言同百舌，胆若鼷鼠。”\n			', '\n他们样子往往很凶，其实～。（郭小川《文学工作不能跃进》）\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1317, '0:3:0', '奉头鼠窜', '\n【 fèng　tóu　shǔ　cuàn 】\n			', '\n奉：捧。抱着头，象老鼠那样惊慌逃跑。形容受到打击后狼狈逃跑。\n			', '\n《汉书·蒯通传》：“始常山王、成安君故相与为刎颈之交，及争张黡、陈释之事，常山王奉头鼠窜，以归汉王。”\n			', '\n身为国家重臣，不能以身排患难，但要～，将何原则上见天下士乎？（《大宋宣和遗事·利集》）\n			'),
(1318, '0:3:0', '孤雏腐鼠', '\n【 gū　chú　fǔ　shǔ 】\n			', '\n孤独的鸟雏，腐烂的老鼠。比喻微贱而不值得一说的人或事物。\n			', '\n《庄子·秋水》：“于是鸱得腐鼠，剜鹐过之，仰而视之，曰：‘吓！’”《后汉书·窦宪传》：“国家弃宪，如孤雏腐鼠耳。”\n			', '\n女子当以四十以前死，人犹悼惜，青裙白发，作～，吾不愿也。（清·纪昀《阅微草堂笔记》卷十二）\n			'),
(1319, '0:3:0', '官仓老鼠', '\n【 guān　cāng　láo　shǔ 】\n			', '\n官仓：放公粮的地方。比喻有所依恃的恶人。\n			', '\n唐·曹邺《官仓鼠》：“官仓老鼠大如斗，见人开仓也不走。”\n			', '\n暂无\n			'),
(1320, '0:3:0', '狗逮老鼠', '\n【 gǒu　dǎi　lǎo　shǔ 】\n			', '\n比喻做外行事或多管闲事。同“狗拿耗子”。\n			', '\n柳青《狠透铁》五：“你狗逮老鼠多管那闲事做啥？”\n			', '\n暂无\n			'),
(1321, '0:3:0', '狗盗鼠窃', '\n【 gǒu　dào　shǔ　qiè 】\n			', '\n像鼠狗那样的盗贼。比喻成不了气候的反叛者。\n			', '\n汉·荀悦《汉纪·惠帝纪》：“今明主在于上，法令具于下，安得有反贼乎？此真狗盗鼠窃耳！”\n			', '\n暂无\n			'),
(1322, '0:3:0', '过街老鼠', '\n【 guò　jiē　lǎo　shǔ 】\n			', '\n比喻人人痛恨的坏人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1323, '0:3:0', '孤豚腐鼠', '\n【 gū　tún　fǔ　shǔ 】\n			', '\n比喻微贱而不值得一说的人或事物。同“孤雏腐鼠”。\n			', '\n清·钱谦益《春秋论二》：“成济，奴隶小人，昭视之，孤豚腐鼠耳。”\n			', '\n暂无\n			'),
(1324, '0:3:0', '狗头鼠脑', '\n【 gǒu　tóu　shǔ　nǎo 】\n			', '\n比喻奴才相。\n			', '\n《黑籍冤魂》第六回：“要说这林则徐，却不像那些狗头鼠脑的官员，要算我们中国的杰出人物。”\n			', '\n暂无\n			'),
(1325, '0:3:0', '狗偷鼠窃', '\n【 gǒu　tōu　shǔ　qiè 】\n			', '\n像鼠狗那样的盗贼。比喻成不了气候的反叛者。同“狗盗鼠窃”。\n			', '\n明·刘基《郁离子·千里马》：“君之门下，无非狗偷鼠窃、无赖之人也。”\n			', '\n今复遣数舟，～。\n			'),
(1326, '0:3:0', '狐奔鼠窜', '\n【 hú　bēn　shǔ　cuàn 】\n			', '\n比喻非常狼狈的逃窜。\n			', '\n宋书·《索虏传》：“或有狐奔鼠窜，逃首北境，而辄便苞纳，待之若旧，资其粮仗，纵为寇贼。”《英烈传》第二十一回：“诸部士卒，俱各狐奔鼠窜退去。”\n			', '\n暂无\n			'),
(1327, '0:3:0', '狐凭鼠伏', '\n【 hú　píng　shǔ　fú 】\n			', '\n象狐狸、老鼠那样潜伏在里面。\n			', '\n《广东军务记·三元里平夷录》：“逆夷务狐凭鼠伏，潜避两炮台中，不敢出入。”\n			', '\n暂无\n			'),
(1328, '0:3:0', '狐潜鼠伏', '\n【 hú　qián　shǔ　fú 】\n			', '\n像狐狸和老鼠一样潜伏、藏匿。形容胆怯躲藏的样子。\n			', '\n明·张景《飞丸记·公馆言情》：“山居草宿，狐潜鼠伏，将略胜孙吴，军势振颇牧。”\n			', '\n暂无\n			'),
(1329, '0:3:0', '狐鼠之徒', '\n【 hú　shǔ　zhī　tú 】\n			', '\n比喻品质低下的人。\n			', '\n清·褚人获《隋唐演义》第七十三回：“朝廷之纪纲法律尚在，但可恨这班狐鼠之徒耳。”\n			', '\n暂无\n			'),
(1330, '0:3:0', '稷蜂社鼠', '\n【 jì　fēng　shè　shǔ 】\n			', '\n谷神庙里的马蜂，土地庙里的老鼠。比喻倚势作恶手的人。\n			', '\n《韩诗外传》卷八：“稷蜂不攻而社鼠不熏，非以稷蜂社鼠之神，其所托者善。”\n			', '\n暂无\n			'),
(1331, '0:3:0', '掘室求鼠', '\n【 jué　shì　qiú　shǔ 】\n			', '\n挖坏房子捉老鼠。比喻因小失大。\n			', '\n《淮南子·说山训》：“坏塘以取龟，发屋而求狸，掘室而求鼠，割唇而治龋，桀跖之徒，君子不与。”\n			', '\n暂无\n			'),
(1332, '0:3:0', '奸同鬼蜮，行若狐鼠', '\n【 jiān　tóng　guǐ　yù，xíng　ruò　hú　shǔ 】\n			', '\n奸诈象鬼蜮，狡猾象狐鼠。比喻人恶劣到极点。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1333, '0:3:0', '进退首鼠', '\n【 jìn　tuì　shǒu　shǔ 】\n			', '\n进退不定；犹豫不决。首鼠，踌躇。\n			', '\n宋·陈亮《与应仲实书》：“又思此别相见定何时，进退首鼠，卒以其所欲求正于仲实者而寓之书。”\n			', '\n暂无\n			'),
(1334, '0:3:0', '狼奔鼠窜', '\n【 láng　bēn　shǔ　cuàn 】\n			', '\n狼群鼠辈到处流窜。形容人四处奔跑逃窜。\n			', '\n明·沈鲸《双珠记》第十四出：“忽闻访察怕如雷，狼奔鼠窜，无由忏悔。”\n			', '\n暂无\n			'),
(1335, '0:3:0', '狼奔鼠偷', '\n【 láng　bēn　shǔ　tōu 】\n			', '\n形容坏人到处扰乱。\n			', '\n清·梅曾亮《朝议大夫台湾府盖君墓志铭》：“公在商州六年，贼出入陕西久，无所掠利，锐欲窥河南甚，狼奔鼠偷，情状捷出。”\n			', '\n暂无\n			'),
(1336, '0:3:0', '罗雀掘鼠', '\n【 luó　què　jué　shǔ 】\n			', '\n原指张网捉麻雀、挖洞捉老鼠来充饥的窘困情况，后比喻想尽办法筹措财物。\n			', '\n《新唐书·张巡传》：“至罗雀掘鼠，煮铠弩以食。”\n			', '\n快饿死者，～，粮食罄尽，转为沟瘠是也。（严复《有如三保》）\n			'),
(1337, '0:3:0', '两鼠斗穴', '\n【 liǎng　shǔ　dòu　xué 】\n			', '\n比喻敌对双方在地势险狭的地方相遇，只有勇往直前的才能获胜。\n			', '\n《史记·廉颇蔺相如列传》：“其道远险狭，譬之犹两鼠斗于穴中，将勇者胜。”\n			', '\n暂无\n			'),
(1338, '0:3:0', '老鼠过街，人人喊打', '\n【 lǎo　shǔ　guò　jiē，rén　rén　hǎn　dǎ 】\n			', '\n比喻害人的东西，大家一致痛恨。\n			', '\n<span class="C999">暂无</span>\n			', '\n犯罪分子必须悬崖勒马，否则将变成～。\n			'),
(1339, '0:3:0', '老鼠过街', '\n【 lǎo　shǔ　guò　jiē 】\n			', '\n比喻害人的东西，人人痛恨。亦作“老鼠过街，人人喊打”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1340, '0:3:0', '狼贪鼠窃', '\n【 láng　tān　shǔ　qiè 】\n			', '\n如狼那样贪狠；似鼠那样惯窃。常形容敌人贪狠卑鄙。\n			', '\n明·于谦《出塞》诗：“瓦刺穷胡真犬豕，敢向边疆挠赤子。狼贪鼠窃去复来，不解偷生求速死。”\n			', '\n暂无\n			'),
(1341, '0:3:0', '狼眼鼠眉', '\n【 láng　yǎn　shǔ　méi 】\n			', '\n形容人相貌凶恶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1342, '0:3:0', '目光如鼠', '\n【 mù　guāng　rú　shǔ 】\n			', '\n形容人眼神奸滑。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1343, '0:3:0', '猫哭老鼠', '\n【 māo　kū　lǎo　shǔ 】\n			', '\n比喻假慈悲。\n			', '\n清·翟灏《通俗编·俚语对句》：“鸭见砻糠空欢喜，猫哭老鼠假慈悲。”\n			', '\n暂无\n			'),
(1344, '0:3:0', '猫鼠同处', '\n【 māo　shǔ　tóng　chǔ 】\n			', '\n比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。同“猫鼠同眠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1345, '0:3:0', '猫鼠同眠', '\n【 māo　shǔ　tóng　mián 】\n			', '\n猫同老鼠睡在一起。比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。\n			', '\n《新唐书·五行志》：“龙朔元年十一月，洛州猫鼠同处。鼠隐伏，象盗窃；猫职捕啮，而反与鼠同，象司盗者废职容奸。”\n			', '\n都是谗言佞言，一个个～。（明·李开先《林冲宝剑记》第六出）\n			'),
(1346, '0:3:0', '猫鼠同乳', '\n【 māo　shǔ　tóng　rǔ 】\n			', '\n比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。同“猫鼠同眠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1347, '0:3:0', '貊乡鼠壤', '\n【 mò　xiāng　shǔ　rǎng 】\n			', '\n旧指民风浇薄、宵小横行的地区。同“貊乡鼠攘”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1348, '0:3:0', '貊乡鼠攘', '\n【 mò　xiāng　shǔ　rǎng 】\n			', '\n旧指民风浇薄、宵小横行的地区。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1349, '0:3:0', '马捉老鼠', '\n【 mǎ　zhuō　lǎo　shǔ 】\n			', '\n比喻瞎忙乱。\n			', '\n明·田艺蘅《留青日札·马捉老鼠》：“方言‘马捉老鼠’，盖讥人粗撞不了事也。”\n			', '\n暂无\n			'),
(1350, '0:3:0', '鸟骇鼠窜', '\n【 niǎo　hài　shǔ　cuàn 】\n			', '\n形容惊恐逃窜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1351, '0:3:0', '鸟惊鼠窜', '\n【 niǎo　jīng　shǔ　cuàn 】\n			', '\n形容惊恐逃窜。同“鸟骇鼠窜”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1352, '0:3:0', '捧头鼠窜', '\n【 pěng　tóu　shǔ　cuàn 】\n			', '\n抱着脑袋，象老鼠似地逃窜。形容仓皇逃跑的狼狈相。\n			', '\n《汉书·蒯通传》：“常山王奉（捧）头鼠窜，以归汉王。”\n			', '\n暂无\n			'),
(1353, '0:3:0', '雀角鼠牙', '\n【 què　jiǎo　shǔ　yá 】\n			', '\n雀、鼠：比喻强暴者。原意是因为强暴者的欺凌而引起争讼。后比喻打官司的事。\n			', '\n《诗经·召南·行露》：“谁谓雀无角，何以穿我屋？……谁谓鼠无牙，何以穿我墉？”\n			', '\n去害马以安驯良，泯～之衅，绝狼吞虎噬之端，不惊不扰，民得宽然，各尽地力。（清·魏秀仁《花月痕》第五十回）\n			'),
(1354, '0:3:0', '雀目鼠步', '\n【 què　mù　shǔ　bù 】\n			', '\n比喻惶恐之极。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1355, '0:3:0', '穷鼠啮狸', '\n【 qióng　shǔ　niè　lí 】\n			', '\n啮：咬；狸：狸猫。无路可逃的老鼠也会咬猫。比喻受人欺压，虽然敌不过，也会拼死抵抗。\n			', '\n汉·桓宽《盐铁论·诏圣》：“死不再生，穷鼠啮狸。”\n			', '\n暂无\n			'),
(1356, '0:3:0', '雀鼠之争', '\n【 què　shǔ　zhī　zhēng 】\n			', '\n指强暴侵凌引起的争讼。\n			', '\n《诗·召南·行露》：“谁谓雀无角，何以穿我屋？……谁谓鼠无牙，何以穿我墉。”\n			', '\n暂无\n			'),
(1357, '0:3:0', '鼠臂虮肝', '\n【 shǔ　bì　jǐ　gān 】\n			', '\n犹言鼠肝虫臂。指或为鼠臂或为虮肝，指人世变化无常。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1358, '0:3:0', '鼠窜蜂逝', '\n【 shǔ　cuàn　fēng　shì 】\n			', '\n形容纷纷跑散。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1359, '0:3:0', '鼠窜狗盗', '\n【 shǔ　cuàn　gǒu　dào 】\n			', '\n像鼠狗那样奔窜偷盗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1360, '0:3:0', '鼠窜狼奔', '\n【 shǔ　cuàn　láng　bēn 】\n			', '\n形容狼狈逃跑的情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1361, '0:3:0', '鼠盗狗窃', '\n【 shǔ　dào　gǒu　qiè 】\n			', '\n像鼠狗那样奔窜偷盗。同“鼠窃狗盗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1362, '0:3:0', '鼠肚鸡肠', '\n【 shǔ　dù　jī　cháng 】\n			', '\n比喻气量狭小，只考虑小事，不顾大体。\n			', '\n明·烟霞散人《斩鬼传》：“鼠肚鸡肠，一包粪也存不住，要你何用。”\n			', '\n暂无\n			'),
(1363, '0:3:0', '鼠腹鸡肠', '\n【 shǔ　fù　jī　cháng 】\n			', '\n比喻气量狭小，只考虑小事，不顾大体。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1364, '0:3:0', '鼠腹蜗肠', '\n【 shǔ　fù　wō　cháng 】\n			', '\n鼹鼠的肚子，蜗牛的肠子。比喻所求有限或气量狭小。\n			', '\n《庄子·逍遥游》：“鹪鹩巢于深林，不过一枝；偃鼠饮河，不过满腹。”\n			', '\n大圣啊，只说你是个宽洪海量之仙，谁知是个～之辈。（明·吴承恩《西游记》第七十六回）\n			'),
(1365, '0:3:0', '鼠肝虫臂', '\n【 shǔ　gān　chóng　bì 】\n			', '\n比喻极微小而无价值的东西。\n			', '\n《庄子·大宗师》：“以汝为汝肝乎？以汝为虫臂乎？”\n			', '\n暂无\n			'),
(1366, '0:3:0', '鼠迹狐踪', '\n【 shǔ　jì　hú　zōng 】\n			', '\n比喻人行踪鬼祟。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1367, '0:3:0', '鼠目寸光', '\n【 shǔ　mù　cùn　guāng 】\n			', '\n形容目光短浅，没有远见。\n			', '\n<span class="C999">暂无</span>\n			', '\n我们从小就应树立远大理想，努力学习科学知识，决不做～的庸人。\n			'),
(1368, '0:3:0', '鼠目獐头', '\n【 shǔ　mù　zhāng　tóu 】\n			', '\n眼睛像老鼠那样又小又圆，脑袋象獐子那样又小又尖。形容人相貌丑陋，神情狡猾。\n			', '\n《旧唐书·李揆传》：“龙章凤姿之士不见用，獐头鼠目之子乃求官。”\n			', '\n我～，强似他面如傅粉。\n			'),
(1369, '0:3:0', '鼠目麞头', '\n【 shǔ　mù　zhāng　tóu 】\n			', '\n麞，同“獐”。形容人相貌丑陋，神情狡滑。同“鼠目獐头”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1370, '0:3:0', '鼠啮虫穿', '\n【 shǔ　niè　chóng　chuān 】\n			', '\n指鼠咬虫蛀。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1371, '0:3:0', '鼠齧虫穿', '\n【 shǔ　niè　chóng　chuān 】\n			', '\n指鼠咬虫蛀。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1372, '0:3:0', '鼠啮蠹蚀', '\n【 shǔ　niè　dù　shí 】\n			', '\n指鼠咬虫蛀。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1373, '0:3:0', '鼠齧蠹蚀', '\n【 shǔ　niè　dù　shí 】\n			', '\n指鼠咬虫蛀。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1374, '0:3:0', '鼠凭社贵', '\n【 shǔ　píng　shè　guì 】\n			', '\n老鼠把窝做在土地庙下面，使人不敢去挖掘。比喻坏人仗势欺人。\n			', '\n南朝梁·沈约《恩悻传论》：“鼠凭社贵，狐藉虎威。”\n			', '\n暂无\n			'),
(1375, '0:3:0', '鼠窃狗盗', '\n【 shǔ　qiè　gǒu　dào 】\n			', '\n象老鼠少量窃取，象狗钻油偷盗。指小偷小摸。\n			', '\n《史记·刘敬书孙通列传》：“此特群盗鼠窃狗盗尔，何足置之齿牙间。”\n			', '\n暂无\n			'),
(1376, '0:3:0', '鼠窃狗偷', '\n【 shǔ　qiè　gǒu　tōu 】\n			', '\n象老鼠少量窃取，象狗钻油偷盗。指小偷小摸。\n			', '\n《史记·刘敬书孙通列传》：“此特群盗鼠窃狗盗尔，何足置之齿牙间。”\n			', '\n～之徒，何足虑哉。（明·施耐庵《水浒全传》第七十五回）\n			'),
(1377, '0:3:0', '鼠雀之辈', '\n【 shǔ　què　zhī　bèi 】\n			', '\n蔑视他人之词。指鄙陋卑微之徒。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1378, '0:3:0', '鼠雀之牙', '\n【 shǔ　què　zhī　yá 】\n			', '\n指争讼之事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1379, '0:3:0', '鼠入牛角', '\n【 shǔ　rù　niú　jiǎo 】\n			', '\n比喻势力愈来愈小。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1380, '0:3:0', '社鼠城狐', '\n【 shè　shǔ　chéng　hú 】\n			', '\n社：土地庙。城墙上的狐狸，社庙里的老鼠。比喻依仗权势做恶，一时难以驱除的小人。\n			', '\n《晏子春秋·内篇问上》：“夫社，束木而涂之，鼠因而托焉，薰之则恐烧其木，灌之则恐败其涂。此鼠所以不可得杀者，以社故也。”《晋书·谢鲲传》：“隗诚始祸，然城狐社鼠也。”\n			', '\n暂无\n			'),
(1381, '0:3:0', '鼠首偾事', '\n【 shǔ　shǒu　fèn　shì 】\n			', '\n坏了事情。比喻人办事没决断，就象胆小的老鼠，在出洞时头在洞口伸伸缩缩一样。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1382, '0:3:0', '首鼠两端', '\n【 shǒu　shǔ　liǎng　duān 】\n			', '\n形容迟疑不决，动摇不定。亦作首施两端。\n			', '\n《史记·魏其武安侯列传》：“武安已罢朝，出止车门，召韩御史大夫载，怒曰：‘与长孺共一老秃翁，何为首鼠两端。’”\n			', '\n何得～，坐待灭亡。（清·陈忱《水浒后传》第十二回）\n			'),
(1383, '0:3:0', '三蛇七鼠', '\n【 sān　shé　qī　shǔ 】\n			', '\n比喻为害的东西多。\n			', '\n清·翟灏《通俗编·禽鱼》：“一亩之地，三蛇七鼠。”\n			', '\n暂无\n			'),
(1384, '0:3:0', '十鼠同穴', '\n【 shí　shǔ　tóng　xué 】\n			', '\n比喻使集中在一起，一网打尽。\n			', '\n《三国志·魏书·鲍勋传》：“勋无活分，而汝等敢纵之！收三官已下付刺奸，当令十鼠同穴。”\n			', '\n暂无\n			'),
(1385, '0:3:0', '鼠屎汙羹', '\n【 shǔ　shǐ　wū　gēng 】\n			', '\n比喻加进了不好的东西，从而破坏了原来美的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1386, '0:3:0', '鼠屎污羹', '\n【 shǔ　shǐ　wū　gēng 】\n			', '\n比喻加进了不好的东西，从而破坏了原来美的事物。\n			', '\n宋·孙觌《跋吴省元真赞》：“吴公前辈盛德，予宿昔所敬慕，制一偈自赞，皆佛菩萨语，启诵三过，欲下一句而家有识真者，恐得鼠屎污羹之诮。”\n			', '\n暂无\n			'),
(1387, '0:3:0', '鼠偷狗盗', '\n【 shǔ　tōu　gǒu　dào 】\n			', '\n像鼠狗那样奔窜偷盗。同“鼠窃狗盗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1388, '0:3:0', '蛇头鼠眼', '\n【 shé　tóu　shǔ　yǎn 】\n			', '\n形容人的面相丑恶，心术不正。亦作“蛇眉鼠眼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1389, '0:3:0', '鼠心狼肺', '\n【 shǔ　xīn　láng　fèi 】\n			', '\n形容心肠阴险狠毒。\n			', '\n清·郑燮《后孤儿行》：“丈丈翁，得钱归，鼠心狼肺，侧目吞肥，千谋万算伏危机。”\n			', '\n暂无\n			'),
(1390, '0:3:0', '鼠穴寻羊', '\n【 shǔ　xué　xún　yáng 】\n			', '\n比喻没有功效的做法。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1391, '0:3:0', '鼠牙雀角', '\n【 shǔ　yá　què　jiǎo 】\n			', '\n鼠、雀：比喻强暴者。原意是因为强暴者的欺凌而引起争讼。后比喻打官司的事。\n			', '\n《诗经·召南·行露》：“谁谓雀无角，何以穿我屋？……谁谓鼠无牙，何以穿我墉？”\n			', '\n暂无\n			'),
(1392, '0:3:0', '投鼠忌器', '\n【 tóu　shǔ　jì　qì 】\n			', '\n投：用东西去掷；忌：怕，有所顾虑。想用东西打老鼠，又怕打坏了近旁的器物。比喻做事有顾忌，不敢放手干。\n			', '\n《汉书·贾谊传》：“里谚曰：‘欲投鼠而忌器’，此善谕也。”\n			', '\n～宝玉瞒赃，判冤决狱平儿行权。（清·曹雪芹《红楼梦》第六十一回）\n			'),
(1393, '0:3:0', '投鼠之忌', '\n【 tóu　shǔ　zhī　jì 】\n			', '\n比喻做事有顾忌，不敢放手干。同“投鼠忌器”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1394, '0:3:0', '梧鼠技穷', '\n【 wú　shǔ　jì　qióng 】\n			', '\n梧鼠：即“鼯鼠”，为鼣鼠之误。比喻才能有限。\n			', '\n《荀子·劝学》：“腾蛇无足而飞，梧鼠五技而穷。”\n			', '\n暂无\n			'),
(1395, '0:3:0', '梧鼠五技', '\n【 wú　shǔ　wǔ　jì 】\n			', '\n梧鼠：即“鼯鼠”，为鼣鼠之误；五技：据说鼫鼠有五种技能。比喻技能多而不精，于事无益。\n			', '\n《荀子·劝学》：“腾蛇无足而飞，梧鼠五技而穷。”\n			', '\n暂无\n			'),
(1396, '0:3:0', '梧鼠之技', '\n【 wú　shǔ　zhī　jì 】\n			', '\n比喻技能多而不精，于事无益。同“梧鼠五技”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1397, '0:3:0', '鼷鼠饮河', '\n【 xī　shǔ　yǐn　hé 】\n			', '\n比喻欲望有限。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1398, '0:3:0', '相鼠有皮', '\n【 xiàng　shǔ　yǒu　pí 】\n			', '\n相：视。看看老鼠尚且还有皮。旧指人须知廉耻，要讲礼义。\n			', '\n《诗经·鄘风·相鼠》：“相鼠有皮，人而无仪（通“义”）；人而无仪，不死何为！”\n			', '\n暂无\n			'),
(1399, '0:3:0', '饮河鼹鼠', '\n【 yǐn　hé　yǎn　shǔ 】\n			', '\n比喻指所需求或所得极有限的人。\n			', '\n语出《庄子·逍遥游》：“偃鼠饮河，不过满腹。”明·李昌祺《剪灯余话·洞天花烛记》：“饮河鼹鼠愧盈腹，止鲁鶢鶋惭厚享。”\n			', '\n每一个人在人类智慧的长河旁边，都不过像一只饮河的鼹鼠。\n			'),
(1400, '0:3:0', '蚁溃鼠骇', '\n【 yǐ　kuì　shǔ　hài 】\n			', '\n形容敌军惊骇溃逃。\n			', '\n唐·柳宗元《剑门铭序》：“左师出于剑门，大攘顽嚚，谕引劫胁，蚁溃鼠骇，险无以固，收夺利地，以须王师。”\n			', '\n暂无\n			'),
(1401, '0:3:0', '以狸饵鼠', '\n【 yǐ　lǐ　ěr　shǔ 】\n			', '\n狸：猫；饵：诱。捉老鼠用猫作诱饵。比喻事情不能成功。\n			', '\n《商君书·农战》：“我不以货事上而求迁者，则如以狸饵鼠尔，必不冀矣。”\n			', '\n暂无\n			'),
(1402, '0:3:0', '以狸至鼠', '\n【 yǐ　lí　zhì　shǔ 】\n			', '\n比喻事情不能成功。同“以狸饵鼠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1403, '0:3:0', '以狸致鼠', '\n【 yǐ　lǐ　zhì　shǔ 】\n			', '\n狸：猫。捉老鼠用猫作诱饵。比喻事情不能成功。\n			', '\n《吕氏春秋·功名》：“以狸致鼠，以冰致绳，虽工不能。”\n			', '\n暂无\n			'),
(1404, '0:3:0', '以狸致鼠，以冰致绳', '\n【 yǐ　lí　zhì　shǔ、yǐ　bīng　zhì　shéng 】\n			', '\n用猫招引老鼠，用冰作绳索。比喻事情不能成功。\n			', '\n《吕氏春秋·功名》：“以狸致鼠、以冰致绳，虽工不能。”\n			', '\n暂无\n			'),
(1405, '0:3:0', '以貍至鼠', '\n【 yǐ　lí　zhì　shǔ 】\n			', '\n比喻事情不能成功。同“以貍饵鼠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1406, '0:3:0', '偃鼠饮河', '\n【 yǎn　shǔ　yǐn　hé 】\n			', '\n比喻所需极有限。\n			', '\n《庄子·逍遥游》：“偃鼠饮河，不过满腹。”\n			', '\n暂无\n			'),
(1407, '0:3:0', '蝇营鼠窥', '\n【 yíng　yíng　shǔ　kuī 】\n			', '\n像蝇一样营营往来，像鼠一样四下窥伺。比喻到处钻营，贪婪无耻。\n			', '\n明·吴承恩《贺学博未齐陶师膺奖序》：“手谈眼语，譸张万端，蝇营鼠窥，射利如蜮，吾见驵侩之于市井也，而今布之学校矣。”\n			', '\n暂无\n			'),
(1408, '0:3:0', '雉伏鼠窜', '\n【 zhì　fú　shǔ　cuàn 】\n			', '\n指恐惧地躲藏，惊慌地逃窜。\n			', '\n明·李东阳《西北备边事宜状》：“朝廷命将出师，天威所至，雉伏鼠窜，无有遗者。”\n			', '\n暂无\n			'),
(1409, '0:3:0', '鸮鸣鼠暴', '\n【 zhāng　míng　shǔ　bào 】\n			', '\n鸮鸟鸣叫，老鼠肆暴。比喻恶人气焰嚣张。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1410, '0:3:0', '贼眉鼠眼', '\n【 zéi　méi　shǔ　yǎn 】\n			', '\n形容神情鬼鬼祟祟。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1411, '0:3:0', '掷鼠忌器', '\n【 zhì　shǔ　jì　qì 】\n			', '\n犹言投鼠忌器。\n			', '\n《三国志·魏书·袁绍传》：“卓遣执金吾胡母班、将作大匠吴修赍诏书喻绍，绍使河内太守王匡杀之”裴松之注引三国吴·谢承《后汉书》：“班与匡书云：‘《刘向传》曰：掷鼠忌器。器犹忌之，况卓今处宫阙之内，以天子为藩屏……”\n			', '\n～空持疑，喂虎割肉有尽时。\n			'),
(1412, '0:3:0', '捉鼠拿猫', '\n【 zhuō　shǔ　ná　māo 】\n			', '\n拿：抓住。捉住老鼠和猫。比喻能制服敌手。\n			', '\n元·无名氏《射柳捶丸》第一折：“若论我腹中的兵书，委的有神鬼不测之机，有捉鼠拿猫之法。”\n			', '\n暂无\n			'),
(1413, '0:3:0', '獐头鼠目', '\n【 zhāng　tóu　shǔ　mù 】\n			', '\n像袋象獐子那样又小又尖，眼睛像老鼠那样又小又圆。形容人相貌丑陋，神情狡滑。\n			', '\n《旧唐书·李揆传》：“龙章凤姿之士不见用，獐头鼠目之子乃求官。”\n			', '\n见那些童生纷纷进来，也有小的，也有老的，仪表端庄的，～的，衣冠齐楚的，蓝缕破烂的。（清·吴敬梓《儒林外史》第三回）\n			'),
(1414, '0:3:0', '贼头鼠脑', '\n【 zéi　tóu　shǔ　nǎo 】\n			', '\n偷偷摸摸、鬼鬼祟祟的样子。\n			', '\n明·吴承恩《西游记》第三十一回：“八戒道:‘哥啊，我晓得。你贼头鼠脑的，一定又变作个甚么东西儿跟着我听的。’”\n			', '\n妇人道:‘我这屋里再有谁来？敢是你～，偷了我这只鞋去了？’\n			'),
(1415, '0:3:1', '搏牛之虻', '\n【 bó　niú　zhī　méng 】\n			', '\n原意是说主要目标应像击杀牛背上的虻虫一样去灭掉秦国，而不是像消除虮虱那样去与别人打败。后来比喻其志在大而不在小。\n			', '\n《史记·项羽本纪》：“夫搏牛之（虻），不可以破虮虱。”\n			', '\n暂无\n			'),
(1416, '0:3:1', '版筑饭牛', '\n【 bǎn　zhù　fàn　niú 】\n			', '\n版筑，造土墙；饭牛，喂牛。后以之为贤臣出身微贱之典。\n			', '\n《书·说命上》载：相传商代贤者傅说筑于傅岩，武丁用以为相。《吕氏春秋·举难》载：春秋时卫国贤者宁戚饭牛车下，扣牛角而歌，桓公异之，拜为上卿。\n			', '\n古今相望，落落然如骑星辰，与夫起～者异矣。\n			'),
(1417, '0:3:1', '充栋汗牛', '\n【 chōng　dòng　hàn　niú 】\n			', '\n指书籍堆得高及栋梁，多至牛马运得出汗。形容藏书或著述之富。\n			', '\n语出唐·柳宗元《陆文通先生墓表》：“其为书，处则充栋宇，出则汗牛马。”\n			', '\n在最后的不到百年间则作者几超出十倍，作品更为～，不可胜计。\n			'),
(1418, '0:3:1', '椎牛发冢', '\n【 chuí　niú　fā　zhǒng 】\n			', '\n杀牛盗墓。谓为盗无所不为，穷凶极恶。\n			', '\n宋·苏轼《策别》十七：“小者呼鸡逐狗，大者椎牛发冢，无所不至。”\n			', '\n或至犯科作奸，～，聚为博弈，出为盗贼。\n			'),
(1419, '0:3:1', '吹牛拍马', '\n【 chuī　niú　pāi　mǎ 】\n			', '\n吹牛：吹牛皮；拍马：拍马屁。指爱说大话，喜欢自我吹嘘和一味逢迎巴结别人的行为。\n			', '\n鲁迅《伪自由书·后记》：“我想假如曾某能把那种吹牛拍马的精力……用到求实学一点上，所得不是要更多些吗？”\n			', '\n简直是一帮～的坏蛋。\n			'),
(1420, '0:3:1', '槌牛酾酒', '\n【 chuí　niú　shāi　jiǔ 】\n			', '\n杀牛滤酒。指备肴酒以燕享。\n			', '\n元·萨都刺《酬江月·过淮阴》词：“槌牛酾酒，英雄千古谁吊。”\n			', '\n暂无\n			'),
(1421, '0:3:1', '椎牛歃血', '\n【 chuí　niú　shà　xuè 】\n			', '\n古时聚众盟誓，杀牛取其血含于口中或以血涂嘴唇，表示诚意。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1422, '0:3:1', '椎牛飨士', '\n【 chuí　niú　xiǎng　shì 】\n			', '\n椎牛：杀牛；飨士：犒劳军士。指慰劳作战的官兵。\n			', '\n《后汉书·吴汉传》：“汉将轻骑迎与之战，不利，堕马伤膝，还营。……诸将谓汉曰：‘大敌在前，而公伤卧，众心惧矣。’汉乃勃然裹伤而起，椎牛飨士……于是军士激怒，人倍其气。”\n			', '\n如今西凉平定，军中旧例，合该～，做出庆赏的筵席。（元·无名氏《百花亭》第四折）\n			'),
(1423, '0:3:1', '初生牛犊不怕虎', '\n【 chū　shēng　niú　dú　bù　pà　hǔ 】\n			', '\n比喻青年人思想上很少顾虑，敢作敢为。\n			', '\n《庄子·知北游》：“德将为汝美，道将为汝居，汝瞳焉如新出之犊，而无求其故。”\n			', '\n这些小伙子无论什么事说干就干，真可谓～。\n			'),
(1424, '0:3:1', '床下牛斗', '\n【 chuáng　xià　niú　dòu 】\n			', '\n听到床下蚂蚁动，误以为牛在相斗。形容体衰耳聪，极度过敏。\n			', '\n《晋书·殷仲堪传》：“仲堪父尝患耳聪，闻床下蚁动，谓之牛斗。”\n			', '\n暂无\n			'),
(1425, '0:3:1', '喘月吴牛', '\n【 chuǎn　yuè　wú　niú 】\n			', '\n比喻因受某事物之苦而畏惧其类似者。\n			', '\n五代·谭用之《寄王侍御》诗：“喘月吴牛知夜至，嘶风胡马识秋来。”\n			', '\n吠尧桀犬浑多事，～苦问天。\n			'),
(1426, '0:3:1', '对牛鼓簧', '\n【 duì　niú　gǔ　huáng 】\n			', '\n比喻对不懂事理的人讲理或言事。常含有徒劳无功或讽刺对方愚蠢之意。同“对牛弹琴”。\n			', '\n《庄子·齐物论》“彼非所明而明之，故以坚白之昧终”晋·郭象注：“是犹对牛鼓簧耳，彼竟不明，故己之道术终于昧然也。”\n			', '\n暂无\n			'),
(1427, '0:3:1', '带牛佩犊', '\n【 dài　niú　pèi　dú 】\n			', '\n原指汉宣帝时渤海太守龚遂诱使持刀剑起义的农民放弃武装斗争而从事耕种。后比喻改业归农。\n			', '\n《汉书·龚遂传》：“民有带持刀剑者，使卖剑买牛，卖刀买犊，曰：‘何为带牛佩犊。’”\n			', '\n暂无\n			'),
(1428, '0:3:1', '对牛弹琴', '\n【 duì　niú　tán　qín 】\n			', '\n讥笑听话的人不懂对方说得是什么。用以讥笑说话的人不看对象。\n			', '\n汉·牟融《理惑论》：“公明仪为牛弹清角之操，伏食如枚。非牛不闻，不合其耳矣。”\n			', '\n～，牛不入耳，骂得很好，咱们一总再算账！（清·李当珍《镜花缘》第九十回）\n			'),
(1429, '0:3:1', '多如牛毛', '\n【 duō　rú　niú　máo 】\n			', '\n象牛身上的的毛那样多。形容极多。\n			', '\n《北史·文苑列传序》：“学者如牛毛，成者如麟角。”\n			', '\n老百姓痛恨官府催粮催捐，苛捐杂派～，逼得老百姓活不下去。（姚雪垠《李自成》第二卷第二十八章）\n			'),
(1430, '0:3:1', '风马牛不相及', '\n【 fēng　mǎ　niú　bù　xiāng　jí 】\n			', '\n风：走失；及：到。本指齐楚相去很远，即使马牛走失，也不会跑到对方境内。比喻事物彼此毫不相干。\n			', '\n《左传·僖公四年》：“君处北海，寡人处南海，唯是风马牛不相及也。”\n			', '\n咱们彼此其实没有丝毫关联，望帝和杜鹃也～。（郭沫若《百花齐放·杜鹃花》）\n			'),
(1431, '0:3:1', '风马牛', '\n【 fēng　mǎ　niú 】\n			', '\n风：放逸，走失。指齐楚两地相离甚远，马牛不会走失至对方地界。后用以比喻事物之间毫不相干。同“风马牛不相及”。\n			', '\n唐·段成式《酉阳杂俎·盗侠》：“唐责之：‘某与公风马牛耳，不意盱眙相遇，实慕君子，何至驺卒不若也。’”\n			', '\n至于释迦牟尼，可更与文艺界～了。\n			'),
(1432, '0:3:1', '服牛乘马', '\n【 fú　niú　chéng　mǎ 】\n			', '\n役使牛马驾车。\n			', '\n《周易·系辞下》：“服牛乘马，引重致远，以利天下。”\n			', '\n自轩辕以来，～，今辇以人负，则人代畜。\n			'),
(1433, '0:3:1', '放牛归马', '\n【 fàng　niú　guī　mǎ 】\n			', '\n把作战用的牛马牧放。比喻战争结束，不再用兵。\n			', '\n《尚书·武成》：“乃偃武修文，归马于华山之阳，放牛于桃林之野，示天下弗服。”\n			', '\n暂无\n			'),
(1434, '0:3:1', '风牛马不相及', '\n【 fēng　niú　mǎ　bù　xiāng　jí 】\n			', '\n比喻事物彼此毫不相干。同“风马牛不相及”。\n			', '\n梁启超《天演学初祖达尔文之学说及其传略》：“夫孰知兰之生产，与彼风牛马不相及之猫，有此若大关系乎？”\n			', '\n暂无\n			'),
(1435, '0:3:1', '饭牛屠狗', '\n【 fàn　niú　tú　gǒu 】\n			', '\n①喻指从事低贱之事。②指从事贱业者。\n			', '\n明·陈子龙《酬吴次尾》诗：“别来落魄吴楚间，饭牛屠狗俱无颜。”\n			', '\n黄金浪掷唱呼鹰，～皆知己。\n			'),
(1436, '0:3:1', '割鸡焉用牛刀', '\n【 gē　jī　yān　yòng　niú　dāo 】\n			', '\n杀只鸡何必用宰牛的刀。比喻办小事情用不着花大气力。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n“～”？不劳温侯亲往，吾斩众诸侯首级，如探囊取物耳。（明·罗贯中《三国演义》第五回）\n			'),
(1437, '0:3:1', '归马放牛', '\n【 guī　mǎ　fàng　niú 】\n			', '\n把作战用的牛马牧放。比喻战争结束，不再用兵。\n			', '\n《尚书·武成》：“乃偃武修文，归马于华山之阳，放牛于桃林之野，示天下弗服。”\n			', '\n那些王侯将相何尝得一日的安闲？好容易海晏河清，～。（清·文康《儿女英雄传》第二十一回）\n			'),
(1438, '0:3:1', '隔山买老牛', '\n【 gé　shān　mǎi　lǎo　niú 】\n			', '\n比喻人办事冒失，没有弄清情况，就轻易决定。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1439, '0:3:1', '汗牛充栋', '\n【 hàn　niú　chōng　dòng 】\n			', '\n栋：栋宇，屋子。书运输时牛累得出汗，存放时可堆至屋顶。形容藏书非常多。\n			', '\n唐·柳宗元《陆文通墓表》：“其为书，处则充栋宇，出则汗牛马。”\n			', '\n世传养生术，～，行而效者谁也？（清·蒲松龄《聊斋志异·封三娘》）\n			'),
(1440, '0:3:1', '汗牛充屋', '\n【 hàn　niú　chōng　wū 】\n			', '\n形容藏书非常多。同“汗牛充栋”。\n			', '\n清·方东树《〈切问斋文抄〉书后》：“非要非玄，而冗长并录，是《书》不止百篇，《诗》不止三百。非惟汗牛充屋，不能尽载，且适以罔道迷人。”\n			', '\n暂无\n			'),
(1441, '0:3:1', '呼牛呼马', '\n【 hū　niú　hū　mǎ 】\n			', '\n呼：称呼。称我牛也好，称我马也好。比喻别人骂也好，称赞也好，决不计较。\n			', '\n《庄子·天道》：“昔者子呼我牛也，而谓之牛，呼我马也，而谓之马。”\n			', '\n～，无关轻重也。（清·俞樾《七侠五义序》）\n			'),
(1442, '0:3:1', '汗牛塞栋', '\n【 hàn　niú　sāi　dòng 】\n			', '\n形容藏书非常多。同“汗牛充栋”。\n			', '\n明·唐顺之《胡贸棺记》：“余不自揆，尝取《左氏》、历代诸史及诸大家文字所谓汗牛塞栋者，稍删次之以从简约。”\n			', '\n暂无\n			'),
(1443, '0:3:1', '呼牛作马', '\n【 hū　niú　zuò　mǎ 】\n			', '\n比喻别人骂也好，称赞也好，决不计较。同“呼牛呼马”。\n			', '\n《庄子·天道》：“昔者子呼我牛也，而谓之牛，呼我马也，而谓之马。”\n			', '\n时不偶，且躬操敝帚，任他人～，只低头。\n			'),
(1444, '0:3:1', '襟裾马牛', '\n【 jīn　jú　mǎ　niú 】\n			', '\n像马牛穿上人的衣服。比喻没有头脑和无知。\n			', '\n语出唐·韩愈《符读书城南》诗：“人不通古今，马牛而襟裾。”\n			', '\n厌～，笑衣冠沐猴。\n			'),
(1445, '0:3:1', '鸡口牛后', '\n【 jī　kǒu　niú　hòu 】\n			', '\n宁愿做小而洁的鸡嘴，而不愿做大而臭的牛肛门。比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’”\n			', '\n暂无\n			'),
(1446, '0:3:1', '裾马襟牛', '\n【 jū　mǎ　jīn　niú 】\n			', '\n像马牛穿上人的衣服。比喻没有头脑和无知。亦作“襟裾马牛”。\n			', '\n唐韩愈《符读书城南》诗：“人不通古今，马牛而襟裾。”\n			', '\n我若做浪蝶游蜂，老天呵，须教是～。\n			'),
(1447, '0:3:1', '九牛二虎之力', '\n【 jiǔ　niú　èr　hǔ　zhī　lì 】\n			', '\n比喻很大的力气。常用于很费力才做成一件事的场合。\n			', '\n元·郑德辉《三战吕布》楔子：“兄弟，你不知他靴尖点地，有九牛二虎之力，休要放他小歇。”\n			', '\n费了～，把这件事弄妥了，未曾涉讼。（清·吴趼人《二十年目睹之怪现状》第七十七回）\n			'),
(1448, '0:3:1', '瘠牛羸豚', '\n【 jí　niú　léi　tún 】\n			', '\n瘠：瘠瘦；羸：病弱的。瘦弱的牛和猪。比喻弱小的民族或国家。\n			', '\n清·梁启超《匈加利爱国者噶苏士传》：“杜兰斯哇人，撒逊人等，亦随其所敌视之马哥耶族，同成灰烬。瘠牛羸豚，坐待割。”\n			', '\n暂无\n			'),
(1449, '0:3:1', '九牛拉不转', '\n【 jiǔ　niú　lā　bù　zhuàn 】\n			', '\n形容态度十分坚决。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1450, '0:3:1', '九牛一毫', '\n【 jiǔ　niú　yī　háo 】\n			', '\n九条牛身上的一根毛。比喻极大数量中极微小的数量，微不足道。\n			', '\n汉·司马迁《报任少卿书》：“假令仆伏法受诛，若九牛亡一毛，与蝼蚁何以异？”\n			', '\n～莫自夸，骄傲自满必翻车。\n			'),
(1451, '0:3:1', '九牛一毛', '\n【 jiǔ　niú　yī　máo 】\n			', '\n九条牛身上的一根毛。比喻极大数量中极微小的数量，微不足道。\n			', '\n汉·司马迁《报任少卿书》：“假令仆伏法受诛，若九牛亡一毛，与蝼蚁何以异？”\n			', '\n九牛一毫莫自夸，骄傲自满必翻车。（陈毅《感事书怀·七古·手莫伸》诗）\n			'),
(1452, '0:3:1', '鸡尸牛从', '\n【 jī　shī　niú　cóng 】\n			', '\n比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’”\n			', '\n暂无\n			'),
(1453, '0:3:1', '茧丝牛毛', '\n【 jiǎn　sī　niú　máo 】\n			', '\n形容功夫细密。\n			', '\n清朝黄宗羲《答万充宗质疑书》：“吾兄经术，茧丝牛毛，用心如此，不仅当今无与绝尘，即在先儒亦岂易得哉？”\n			', '\n暂无\n			'),
(1454, '0:3:1', '鲸吸牛饮', '\n【 jīng　xī　niú　yǐn 】\n			', '\n鲸吸：像鲸鱼吸水一样。如鲸吸百川，似牛饮池水。比喻放量狂饮。\n			', '\n汉·韩婴《韩诗外传》第四卷：“桀为酒池，可以运舟，糟丘足以道望十里，一鼓而牛饮者三千人。” 唐·杜甫《饮中八仙歌》：“饮如长鲸吸百川。：\n			', '\n暂无\n			'),
(1455, '0:3:1', '犁牛骍角', '\n【 lí　niú　mài　jiǎo 】\n			', '\n比喻劣父生贤明的儿女。同“犁生骍角”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1456, '0:3:1', '老牛破车', '\n【 lǎo　niú　pò　chē 】\n			', '\n老牛拉破车。比喻做事慢吞吞，一点不利落。也比喻才能低。\n			', '\n<span class="C999">暂无</span>\n			', '\n要想完成这顶任务，就不能像～似的，要雷厉风行，说干就干。\n			'),
(1457, '0:3:1', '老牛舐犊', '\n【 lǎo　niú　shì　dú 】\n			', '\n老牛舔小牛。比喻父母疼爱子女。\n			', '\n《后汉书·杨彪传》：“愧无日磾先见之明，犹怀老牛舐犊之爱。”\n			', '\n～，情所难禁。（清·李绿园《歧路灯》第七十七回）\n			'),
(1458, '0:3:1', '犁牛之子', '\n【 lí　niú　zhī　zǐ 】\n			', '\n比喻父虽不善却无损于其子的贤明。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1459, '0:3:1', '马勃牛溲', '\n【 mǎ　bó　niú　sōu 】\n			', '\n马勃：马屁菌；牛溲：车前草。借指不值钱的东西。\n			', '\n清·褚人获《坚瓠十集·遗臭文词》：“马勃牛溲君受用，何须开口出而哇。”\n			', '\n鼠肝虫臂唯天命，～称异才。\n			'),
(1460, '0:3:1', '马浡牛溲', '\n【 mǎ　bó　niú　sōu 】\n			', '\n借指不值钱的东西。同“马勃牛溲”\n			', '\n明·王世懋《艺圃撷馀》：“杜子美出，而百家稗官都作雅音，马浡牛溲咸成郁致，于是诗之变极矣。”\n			', '\n暂无\n			'),
(1461, '0:3:1', '猕猴骑土牛', '\n【 mí　hóu　qí　tǔ　niú 】\n			', '\n比喻职位提升很慢。\n			', '\n《三国志·魏书·邓艾传》引《世语》：“君，名公之子，少有文采，故守吏职；猕猴骑土牛，又何迟也。”\n			', '\n暂无\n			'),
(1462, '0:3:1', '卖剑买牛', '\n【 mài　jiàn　mǎi　niú 】\n			', '\n原指放下武器，从事耕种。后比喻改业务农或坏人改恶从善。\n			', '\n《汉书·龚遂传》：“民有持刀剑者，使卖剑买牛，卖刀买椟。”\n			', '\n惟有躬耕差可为，～悔不早。（宋·陆游《贫甚作短歌排闷》诗）\n			'),
(1463, '0:3:1', '马面牛头', '\n【 mǎ　miàn　niú　tóu 】\n			', '\n比喻各种各样凶恶的人。\n			', '\n《西湖二集·文昌司怜才慢注禄籍》：“没慈心的马面牛头，两股叉，两条鞭，恶恶狠狠。”\n			', '\n两边站立的，活像是一群～。\n			'),
(1464, '0:3:1', '马牛襟裾', '\n【 mǎ　niú　jīn　jū 】\n			', '\n襟、裾：泛指人的衣服。马、牛穿着人衣。比喻人不懂得礼节。也比喻衣冠禽兽。\n			', '\n唐·韩愈《符读书城南》诗：“潢潦无根源，朝满夕已除。人不通古今，马牛而襟裾。行身陷不义，况望多名誉。”\n			', '\n闻孝氏孝友之风而无兴起之志。诚～者也。（明·赵弼《赵氏伯仲友义传》）\n			'),
(1465, '0:3:1', '买牛卖剑', '\n【 mǎi　niú　mài　jiàn 】\n			', '\n原指放下武器，从事耕种。后比喻改业务农或坏人改恶从善。同“买犁卖剑”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1466, '0:3:1', '马牛其风', '\n【 mǎ　niú　qí　fēng 】\n			', '\n指马、牛奔逸。后用以表示互不相干。\n			', '\n《书·费誓》：“马牛其风，臣妾逋逃，勿敢越逐。”孔颖达疏：“僖四年《左传》云：‘唯是风马牛不相及也。’贾逵云：‘风，放也，牝牡相诱谓之风。’然则马牛风佚，因牝牡相逐，而逐至放佚远去也。”\n			', '\n我却不信你们两个通是～，不言而喻呢。\n			'),
(1467, '0:3:1', '目牛无全', '\n【 mù　niú　wú　quán 】\n			', '\n比喻技艺纯熟或谋划高明。\n			', '\n《庄子·养生主》：“始臣之解牛之时，所见无非牛者；三年之后，未尝见全牛也。”\n			', '\n害马已去，世事都捐；投刃皆虚，～。\n			'),
(1468, '0:3:1', '买牛息戈', '\n【 mǎi　niú　xī　gē 】\n			', '\n犹言卖剑买牛。原指放下武器，从事耕种。后比喻改业务农或坏人改恶从善。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1469, '0:3:1', '目无全牛', '\n【 mù　wú　quán　niú 】\n			', '\n全牛：整个一头牛。眼中没有完整的牛，只有牛的筋骨结构。比喻技术熟练到了得心应手的境地。\n			', '\n《庄子·养生说》：“始臣之解牛之时，所见无非牛者；三年之后，未尝见全牛也。”\n			', '\n暂无\n			'),
(1470, '0:3:1', '牛不喝水强按头', '\n【 niú　bù　hē　shuǐ　qiǎng　àn　tóu 】\n			', '\n比喻用强迫手段使人就范。\n			', '\n清·曹雪芹《红楼梦》第四十六回：“鸳鸯道：‘家生女儿怎么样？“牛不吃水强按头”吗？我不愿意，难道杀我的老子娘不成！’”\n			', '\n那一年通州的男女洋学生下乡大扫茬，遇见没有剪辫子的男人便～，咔嚓一声铰掉后脑勺的猪尾巴。 ◎刘绍棠《水边人的哀乐故事》一\n			'),
(1471, '0:3:1', '牛刀割鸡', '\n【 niú　dāo　gē　jī 】\n			', '\n杀只鸡用宰牛的刀。比喻大材小用。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n暂无\n			'),
(1472, '0:3:1', '牛鼎烹鸡', '\n【 niú　dǐng　pēng　jī 】\n			', '\n用煮一头牛的大锅煮一只鸡。比喻大材小用。\n			', '\n《后汉书·边让传》：“函牛之鼎以烹鸡，多汁则淡而不可食，少汁则熬而不可熟。”\n			', '\n暂无\n			'),
(1473, '0:3:1', '牛刀小试', '\n【 niú　dāo　xiǎo　shì 】\n			', '\n牛刀：宰牛的刀；小试：稍微用一下，初显身手。比喻有大本领的人，先在小事情上略展才能。也比喻有能力的人刚开始工作就表现出才\n			', '\n宋·苏轼《送欧阳主簿赴官韦城》诗：“读遍牙签三万轴，欲来小邑试牛刀。”\n			', '\n暂无\n			'),
(1474, '0:3:1', '牛高马大', '\n【 niú　gāo　mǎ　dà 】\n			', '\n比喻人长得高大强壮。\n			', '\n《小说月报》1981年第1期：“东宁县县委书记刘番成长得浓眉大眼，牛高马大。”\n			', '\n三人中那位五十来岁，～、脸色黧黑的壮年人，抬头看见方爱华的小轿车。\n			'),
(1475, '0:3:1', '牛鬼蛇神', '\n【 niú　guǐ　shé　shén 】\n			', '\n牛头的鬼，蛇身的神。原形容虚幻怪诞。后比喻社会上形形色色的坏人。\n			', '\n唐·李贺《李贺集序》：“鲸吸鳌掷，牛鬼蛇神，不足为其虚荒诞幻也。”\n			', '\n暂无\n			'),
(1476, '0:3:1', '牛黄狗宝', '\n【 niú　huáng　gǒu　bǎo 】\n			', '\n牛黄，牛胆囊中的结石；狗宝，狗脏器中的凝结物。两者都是内脏病变的产物，因以喻坏透了的心肠。\n			', '\n清·曹雪芹《红楼梦》第六十五回：“若大家好取和便罢，倘若有一点叫人过不去， 我有本事先把你两个的牛黄狗宝掏了出来，再和那泼妇拼了这命，也不算是尤三姑奶奶！”\n			', '\n暂无\n			'),
(1477, '0:3:1', '牛骥共牢', '\n【 niú　jì　gòng　láo 】\n			', '\n骥：好马。牛跟马同槽。比喻不好的人与贤人共处。\n			', '\n《晋书·张载传》：“及其无事也，则牛骥共牢，利钝齐列，而无长涂犀革以决之，此离朱与瞽者同眼之说也。”\n			', '\n暂无\n			'),
(1478, '0:3:1', '牛角挂书', '\n【 niú　jiǎo　guà　shū 】\n			', '\n比喻读书勤奋。\n			', '\n《新唐书·李密传》：“闻包恺在缑山，往从之。以蒲鞯乘牛，挂《汉书》一帙角上，行且读。”\n			', '\n暂无\n			'),
(1479, '0:3:1', '牛角书生', '\n【 niú　jiǎo　shū　shēng 】\n			', '\n比喻勤奋读书的人。\n			', '\n《新唐书·李密传》：“以蒲鞯乘牛，挂《汉书》一帙角上，行且读。”\n			', '\n～，虬髯豪客，谈笑皆堪折简招。\n			'),
(1480, '0:3:1', '牛骥同槽', '\n【 niú　jì　tóng　cáo 】\n			', '\n指牛与千里马同槽而食。比喻贤愚不分。同“牛骥同皂”。\n			', '\n汉·焦赣《易林·升之小畜》：“牛骥同槽，郭氏以亡。”\n			', '\n暂无\n			'),
(1481, '0:3:1', '牛骥同皁', '\n【 niú　jì　tóng　wěn 】\n			', '\n指牛与千里马同槽而食。比喻贤愚不分。亦作“牛骥同槽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1482, '0:3:1', '牛骥同皂', '\n【 niú　jì　tóng　zào 】\n			', '\n皂：牲口槽。牛跟马同槽。比喻不好的人与贤人同处。\n			', '\n汉·邹阳《狱中上梁王书》：“使不羁之士与牛同皂，此鲍焦所以愤于世而不留富贵之乐也。”\n			', '\n牛骥同一皂，鸡栖凤凰食。（宋·文天祥《正气歌》）\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1483, '0:3:1', '牛角之歌', '\n【 niú　jiǎo　zhī　gē 】\n			', '\n后为穷士自求用世的典故。\n			', '\n春秋时，宁戚很穷，想见齐桓公而出仕，一天，乘桓公出城迎客的机会，在车下喂牛，“扣牛角疾歌”。桓公闻而赞其为“非常人”，命后车载之，拜为上卿。见《吕氏春秋·举难》、《晏子春秋·问下二》。汉·刘向《说苑·尊贤》亦载此事。\n			', '\n夫～，辞鄙而义拙；堂下之言，不书于传记。\n			'),
(1484, '0:3:1', '牛口之下', '\n【 niú　kǒu　zhī　xià 】\n			', '\n借指卑下的地位。\n			', '\n《史记·商君列传》：“夫五羖大夫，荆之鄙人也。闻秦缪公之贤而原望见，行而无资，自粥于秦客，被褐食牛。期年，缪公知之，举之牛口之下，而加之百姓之上，秦国莫敢望焉。”《吕氏春秋·举难》等又载有宁戚饭牛得到齐桓公赏识的事。\n			', '\n故明君勤于招贤……或举于～，而加之于群僚之上；或拔于桎梏之中，而任以社稷之重。\n			'),
(1485, '0:3:1', '牛郎织女', '\n【 niú　láng　zhī　nǚ 】\n			', '\n牛郎织女为神话人物，从牵牛星、织女星的星名衍化而来。比喻分居两地的夫妻。也泛指一对恋人。\n			', '\n《古诗十九首》：“迢迢牵牛星，皎皎河汉女。纤纤擢素手，札札弄机杼。终日不成章，泣涕零如雨。河汉清且浅，相去复几许？盈盈一水间，脉脉不得语。”\n			', '\n尝笔唐人《七夕》诗，咏～，皆作会别可怜之语，殊失命名本旨。\n			'),
(1486, '0:3:1', '牛马襟裾', '\n【 niú　mǎ　jīn　jú 】\n			', '\n犹言衣冠禽兽。\n			', '\n元·石德玉《秋胡戏妻》第三折：“我骂你个沐猴冠冕，牛马襟裾。”元·无名氏《举案齐眉》第一折：“教人道这乔男女，则是些牛马襟裾。”\n			', '\n暂无\n			'),
(1487, '0:3:1', '牛毛细雨', '\n【 niú　máo　xì　yǔ 】\n			', '\n指细而密的小雨。\n			', '\n清·梁绍壬《两般秋雨庵随笔》卷五：“牛毛细雨送斜阳。”\n			', '\n可是连天～，迷迷蒙蒙，不见一丝阳光。\n			'),
(1488, '0:3:1', '牛农对泣', '\n【 niú　nóng　duì　qì 】\n			', '\n睡在牛衣里，相对哭泣。形容夫妻共同过着穷困的生活。\n			', '\n《汉书·王章传》：“初，章为渚生学长安，独与妻居。章疾病，无被，卧牛衣中；与妻决，涕泣。”\n			', '\n翁家乏食，借贷无门，典质已尽，搔首踟蹰，～而已。\n			'),
(1489, '0:3:1', '泥牛入海', '\n【 ní　niú　rù　hǎi 】\n			', '\n泥塑的牛掉到海里。比喻一去不再回来。\n			', '\n宋·释道原《景德传灯录》卷八：“我见两个泥牛斗入海，直至如今无消息。”\n			', '\n那两个钱庄干事的人，等了好久，只等得一个～，永无消息。（清·吴趼人《二十年目睹之怪现状》第七回）\n			'),
(1490, '0:3:1', '牛溲马勃', '\n【 niú　sōu　mǎ　bó 】\n			', '\n牛溲：牛尿，一说车前草，利小便；马勃：可治疮。比喻一般人认为无用的东西，在懂得其性能的人手里可成为有用的物品。\n			', '\n唐·韩愈《进学解》：“玉札丹砂，赤箭青芝，牛溲马勃，则鼓之皮，俱收并蓄，待用无遗者，医师之良也。”\n			', '\n暂无\n			'),
(1491, '0:3:1', '牛溲马渤', '\n【 niú　sōu　mǎ　bó 】\n			', '\n牛溲，即牛遗，车前草的别名。马勃，一名马牷，一名屎菰，生于湿地及腐木的菌类。均可入药。比喻虽然微贱但是有用的东西。渤，通勃。\n			', '\n清·李渔《闲情偶寄·居室·房舍》：“收牛溲马渤入药笼，用之得宜，其价值反在参苓之上。”\n			', '\n暂无\n			'),
(1492, '0:3:1', '牛头不对马面', '\n【 niú　tóu　bù　duì　mǎ　miàn 】\n			', '\n比喻答非所问或对不上号。\n			', '\n清·李宝嘉《文明小史》第二十四回：“尽其所有写上，都是牛头不对马面。”\n			', '\n暂无\n			'),
(1493, '0:3:1', '牛头不对马嘴', '\n【 niú　tóu　bù　duì　mǎ　zuǐ 】\n			', '\n比喻答非所问或两下不相合。\n			', '\n<span class="C999">暂无</span>\n			', '\n老师提出的问题他由于精神分散而没听清楚，回答得～。\n			'),
(1494, '0:3:1', '牛头马面', '\n【 niú　tóu　mǎ　miàn 】\n			', '\n迷信传说中的两个鬼卒，一个头象牛，一个头象马。比喻各种丑恶的人。\n			', '\n宋·释道原《景德传灯录》卷十一：“释迦是牛头狱卒，祖师是马面阿婆。”\n			', '\n只是近来常常在梦中，或是在将醒未醒之顷，一阵悚然，从前所怕的～，都积压了来，都聚围了来。（冰心《山中杂记—遥寄小朋友》）\n			'),
(1495, '0:3:1', '牛童马走', '\n【 niú　tóng　mǎ　zǒu 】\n			', '\n旧时泛指地位卑下的人。牛童，牧童；马走，犹仆役。\n			', '\n唐·元稹《〈白氏长庆集〉序》：“然而二十年间，禁省、观寺、邮候墙壁之上无不书，王公妾妇、牛童马走之口无不道。”\n			', '\n其大节岳岳磊磊，在人耳目，虽耕夫贩妇，～，共能称道者。\n			'),
(1496, '0:3:1', '牛听弹琴', '\n【 niú　tīng　tán　qín 】\n			', '\n比喻听不懂。\n			', '\n瞿秋白《乱弹》：“现在，‘治于人的小人’，要想在无线电的播音里去听清楚昆曲的平上去入，自然是牛听弹琴，一窍不通了。”\n			', '\n暂无\n			'),
(1497, '0:3:1', '牛蹄之涔', '\n【 niú　tí　zhī　cén 】\n			', '\n涔：雨水。牛蹄印中的积水。形容水量极少。也比喻处在不能有所作为的境地。\n			', '\n《淮南子·汜论训》：“夫牛蹄之涔，不能生鳣鲔。”《淮南子·俶真》：“牛蹄之涔，无尺之鲤。”北周·庾信《为杞公让宗师表》：“况复一枝倦曲，终危九层之台；一股涔蹄，必伤千里之驾。”\n			', '\n暂无\n			'),
(1498, '0:3:1', '牛蹄之鱼', '\n【 niú　tí　zhī　yú 】\n			', '\n牛蹄印坑里的鱼。比喻死期迫近。同“牛蹄中鱼”。\n			', '\n《孔丛子·连丛子下》：“且今已乏矣，而方须租人，是犹古人欲决江海以救牛蹄之鱼之类也。”\n			', '\n暂无\n			'),
(1499, '0:3:1', '牛蹄中鱼', '\n【 niú　tí　zhōng　yú 】\n			', '\n牛蹄：是指牛蹄印里的积水。牛蹄印坑里的鱼。比喻死期迫近。\n			', '\n三国（魏）·应璩《与韦仲将书》：“诚恐将为牛蹄中鱼，卒鲍氏之肆矣。”\n			', '\n暂无\n			'),
(1500, '0:3:1', '宁为鸡口，不为牛后', '\n【 nìng　wéi　jī　kǒu，bù　wéi　niú　hòu 】\n			', '\n牛后：牛的肛门。宁愿做小而洁的鸡嘴，而不愿做大而臭的牛肛门。比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策一》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’今大王西面交臂而臣事秦，何以异于牛后乎？”\n			', '\n俗谚云：“～”，以大王之贤，挟强韩之兵，而有“牛后”之名，臣窃羞之。（明·冯梦龙《东周列国志》第九十回）\n			'),
(1501, '0:3:1', '宁为鸡口，无为牛后', '\n【 nìng　wéi　jī　kǒu，wú　wéi　niú　hòu 】\n			', '\n比喻宁居小者之首，不为大者之后。\n			', '\n西汉·刘向《战国策·韩策一》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’今大王西面交臂而臣事秦，何以异于牛后？”\n			', '\n自古道，～，你忍得这气也。\n			'),
(1502, '0:3:1', '宁为鸡口，毋为牛后', '\n【 nìng　wéi　jī　kǒu，wú　wéi　niú　hòu 】\n			', '\n比喻宁居小者之首，不为大者之后。同“宁为鸡口，无为牛后”。\n			', '\n章炳麟《社会通诠商兑》：“宁为鸡口，毋为牛后，与使他人啖我而饱也，宁自啖而不足。”\n			', '\n暂无\n			'),
(1503, '0:3:1', '牛星织女', '\n【 niú　xīng　zhī　nǚ 】\n			', '\n即牛郎织女。\n			', '\n汉·无名氏《古诗十九首》诗之十：“迢迢牵牛星，皎皎河汉女。”\n			', '\n～年年别，分明不及人间物。\n			'),
(1504, '0:3:1', '牛衣病卧', '\n【 niú　yī　bìng　wò 】\n			', '\n形容贫病交迫。\n			', '\n宋·刘克庄《沁园春·再和林卿韵》词：“便羊裘归去，难留严子；牛衣病卧，肯泣王章？”\n			', '\n暂无\n			'),
(1505, '0:3:1', '牛衣对泣', '\n【 niú　yī　duì　qì 】\n			', '\n睡在牛衣里，相对哭泣。形容夫妻共同过着穷困的生活。\n			', '\n《汉书·王章传》：“初，章为渚生学长安，独与妻居。章疾病，无被，卧牛衣中；与妻决，涕泣。”\n			', '\n翁家乏食，借贷无门，典质已尽，搔首踟蹰，～而已。（清·宣鼎《夜雨秋灯录·义猫》）\n			'),
(1506, '0:3:1', '牛衣岁月', '\n【 niú　yī　suì　yuè 】\n			', '\n指贫困的生活。\n			', '\n清·曾国藩《送妹夫王五归》诗之四：“织屦辟纑终古事，牛衣岁月即羲皇。”\n			', '\n暂无\n			'),
(1507, '0:3:1', '牛羊勿践', '\n【 niú　yáng　wù　jiàn 】\n			', '\n勿使牛羊践踏。比喻爱护。\n			', '\n语出《诗·大雅·行苇》：“敦彼行苇，牛羊勿践履，方苞方体，维叶泥泥。”郑玄笺：“草木方茂盛，以其终将为人用，故周之先王为此爱之，况于人乎？”\n			', '\n况于有德有造，成人之材，～，遂物之性，可望其仿佛乎？\n			'),
(1508, '0:3:1', '牛衣夜哭', '\n【 niú　yī　yè　kū 】\n			', '\n形容夫妻共同过着穷困的生活。同“牛衣对泣”。\n			', '\n唐·温庭筠《上裴舍人启》：“今则阮路兴悲，商歌结恨；牛衣夜哭，马柱晨吟。”\n			', '\n暂无\n			'),
(1509, '0:3:1', '牛之一毛', '\n【 niú　zhī　yī　máo 】\n			', '\n牛身上一根毛。比喻微不足道。亦作“九牛一毛”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1510, '0:3:1', '庖丁解牛', '\n【 páo　dīng　jiě　niú 】\n			', '\n庖丁：厨工；解：肢解分割。比喻经过反复实践，掌握了事物的客观规律，做事得心应手，运用自如。\n			', '\n《庄子·养生主》：“庖丁为文惠君解牛，手之所触，肩之所倚，足之所履，膝之所踦，砉然响然，奏刀騞然，莫不中音。”\n			', '\n暂无\n			'),
(1511, '0:3:1', '气冲斗牛', '\n【 qì　chōng　dǒu　niú 】\n			', '\n气：气势；牛、斗：即牵牛星和北斗星，指天空。形容怒气冲天或气势很盛。\n			', '\n唐·崔融《咏宝剑》：“匣气冲牛斗，山形转辘轳。”宋·岳飞《题青泥赤壁》诗：“雄气堂堂贯斗牛，誓将真节报君仇。”\n			', '\n兴见马忠是害父仇人，～，举青龙刀望忠便砍。\n			'),
(1512, '0:3:1', '气冲牛斗', '\n【 qì　chōng　niú　dǒu 】\n			', '\n气：气势；牛、斗：即牵牛星和北斗星，指天空。形容怒气冲天或气势很盛。\n			', '\n宋·岳飞《题青泥赤壁》诗：“雄气堂堂贯牛斗，誓将真节报君仇。”\n			', '\n兴见马忠是害父仇人，～，举青龙刀望忠便砍。（明·罗贯中《三国演义》第八十三回）\n			'),
(1513, '0:3:1', '气喘如牛', '\n【 qì　chuǎn　rú　niú 】\n			', '\n形容大声喘气的模样。\n			', '\n清·文康《儿女英雄传》第三十九回：“脸是喝了个漆紫，连乐带忙，一头说着，只张着嘴，气喘如牛的拿了条大手巾擦那脑门子上的汗。”\n			', '\n那总办～的说道：‘那贱人我不要了！’\n			'),
(1514, '0:3:1', '气克斗牛', '\n【 qì　kè　dǒu　niú 】\n			', '\n斗：北斗星。牛：牵牛星。斗牛泛指星空。形容气魄很大。同“气吞牛斗”。\n			', '\n明·胡文焕《群音类选〈千金记·受辱胯下〉》：“俺自有翅排云，气克斗牛，怎肯与他年少成仇。”\n			', '\n暂无\n			'),
(1515, '0:3:1', '骑牛读汉书', '\n【 qí　niú　dú　hàn　shū 】\n			', '\n形容刻苦攻读。\n			', '\n《新唐书·李密传》：“（李密）闻包恺的缑山，往从之。以蒲韀乘牛，挂《汉书》一帙角上，行且读。”\n			', '\n暂无\n			'),
(1516, '0:3:1', '骑牛觅牛', '\n【 qí　niú　mì　niú 】\n			', '\n原比喻一面占着一个位置，一面去另找更称心的工作。现多比喻东西就在自己这里，还到处去找。同“骑驴觅驴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1517, '0:3:1', '牵牛下井', '\n【 qiān　niú　xià　jǐng 】\n			', '\n比喻事情棘手，很难办到。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1518, '0:3:1', '敲牛宰马', '\n【 qiāo　niú　zǎi　mǎ 】\n			', '\n指宰杀牲畜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1519, '0:3:1', '牵牛织女', '\n【 qiān　niú　zhī　nǚ 】\n			', '\n指牵牛星、织女星。亦指古代神话中的牛郎、织女。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1520, '0:3:1', '气吞牛斗', '\n【 qì　tūn　niú　dǒu 】\n			', '\n牛：牵牛星。斗：北斗星。牛斗泛指星空。形容气魄很大。\n			', '\n明·胡文焕《群音类选〈蟠桃记·诞孙相庆〉》：“看兰孙，气吞牛斗，知不是等闲人。”\n			', '\n暂无\n			'),
(1521, '0:3:1', '齐王舍牛', '\n【 qí　wáng　shě　niú 】\n			', '\n比喻帝王对臣民怀有恻隐之心。\n			', '\n《孟子·梁惠王上》：“王（齐宣王）坐于堂上，有牵牛而过堂下者，王见之，曰：‘牛何之？’对曰：‘将以衅钟。’王曰：‘舍之。吾不忍其觳觫，若无罪而就死地。’对曰：‘然则废衅钟与？’曰：‘何可废也？以羊易之。’”\n			', '\n联祇膺灵命，抚遂群生，言念亭育，无忘鉴眛。殷帝去网，庶踵前修；～，实符本志。\n			'),
(1522, '0:3:1', '气壮如牛', '\n【 qì　zhuàng　rú　niú 】\n			', '\n气很盛，但使人觉得笨拙。\n			', '\n<span class="C999">暂无</span>\n			', '\n他那气壮如牛的样子，简直像要吃人。\n			'),
(1523, '0:3:1', '如牛负重', '\n【 rú　niú　fù　zhòng 】\n			', '\n象牛背着学生的东西一样。比喻生活负担极重。\n			', '\n<span class="C999">暂无</span>\n			', '\n荒时暴月，向亲友乞哀告怜，借得几斗几升，敷衍三日五日，债务丛集，～。（毛泽东《中国社会各阶级的分析》）\n			'),
(1524, '0:3:1', '杀鸡焉用牛刀', '\n【 shā　jī　yān　yòng　niú　dāo 】\n			', '\n杀只鸡何必用宰牛的刀。比喻办小事情用不着花大气力。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n“～”？不劳温侯亲往，吾斩众诸侯首级，如探囊取物耳。（明·罗贯中《三国演义》第五回）\n			'),
(1525, '0:3:1', '司马牛之叹', '\n【 sī　mǎ　niú　zhī　tàn 】\n			', '\n比喻对孑然一身、孤立无援的感叹。\n			', '\n《论语·颜渊》：“司马牛忧曰：‘人皆有兄弟，我独亡。’”\n			', '\n暂无\n			'),
(1526, '0:3:1', '散马休牛', '\n【 sàn　mǎ　xiū　niú 】\n			', '\n指不兴战事。\n			', '\n《书·武成》：“归马于华山之阳，放牛于桃林之野，示天下弗服”。蔡沈集传引《乐记》：“武王胜商，渡河而西，马散之华山之阳而弗复乘，牛放之桃林之野而弗复服”。\n			', '\n暂无\n			'),
(1527, '0:3:1', '鼠入牛角', '\n【 shǔ　rù　niú　jiǎo 】\n			', '\n比喻势力愈来愈小。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1528, '0:3:1', '兔角牛翼', '\n【 tù　jiǎo　niú　yì 】\n			', '\n兔不生角，牛不长翼，故以之比喻不合情理之事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1529, '0:3:1', '童牛角马', '\n【 tóng　niú　jiǎo　mǎ 】\n			', '\n童牛：没有角的牛；角马：长角的马。比喻不伦不类的东西。也比喻违反常理，不可能存在的事物。\n			', '\n汉·扬雄《太玄经·更》：“童牛角马，不今不古。”\n			', '\n暂无\n			'),
(1530, '0:3:1', '土牛木马', '\n【 tǔ　niú　mù　mǎ 】\n			', '\n泥塑的牛，木做的马。比喻没有实用的东西。\n			', '\n《关尹子·八筹》：“知物之伪者，不必去物，譬如见土牛木马，虽情存牛马之名，而心忘牛马之实。”\n			', '\n若门资之中而得愚瞽，是则～，形似而用非，不可以涉道也。（《北史·苏绰传》）\n			'),
(1531, '0:3:1', '屠所牛羊', '\n【 tú　suǒ　niú　yáng 】\n			', '\n比喻临近死亡的人。\n			', '\n《大涅磐经·迦叶品》：“如囚趋市，步步近死，如牵牛羊诣于屠所。”\n			', '\n暂无\n			'),
(1532, '0:3:1', '吴牛喘月', '\n【 wú　niú　chuǎn　yuè 】\n			', '\n吴牛：指产于江淮间的水牛。吴地水牛见月疑是日，因惧怕酷热而不断喘气。比喻因疑心而害怕。\n			', '\n南朝宋·刘义庆《世说新语·言语》：“臣犹见牛，见月而喘。”《太平御览》卷四引《风俗通》：“吴牛望见月则喘，彼之苦于日，见月怖喘矣。”\n			', '\n～时，拖船一何苦。（唐·李白《丁都护歌》）\n			'),
(1533, '0:3:1', '问牛知马', '\n【 wèn　niú　zhī　mǎ 】\n			', '\n比喻从旁推究，弄清楚事情真相。\n			', '\n《汉书·赵广汉传》：“钩距者，设欲知马贾（价），则先问狗，已问羊，又问牛，然后及马，参伍其贾，以类相准，则知马之贵贱，不失实矣。”\n			', '\n暂无\n			'),
(1534, '0:3:1', '蜗行牛步', '\n【 wō　xíng　niú　bù 】\n			', '\n蜗牛爬行，老牛慢走。比喻行动或进展极慢。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1535, '0:3:1', '亡羊得牛', '\n【 wáng　yáng　dé　niú 】\n			', '\n丢掉羊，得到牛。比喻损失小而收获大。\n			', '\n《淮南子·说山训》：“亡羊而得牛，则莫不利失也。”\n			', '\n暂无\n			'),
(1536, '0:3:1', '休牛归马', '\n【 xiū　niú　guī　mǎ 】\n			', '\n放归军用的牛马，表示停止战事。\n			', '\n语出《书·武成》：“乃偃武修文，归马于华山之阳，放牛于桃林之野，示天下书弗服。”《隋书·薛道衡传》：“于是八荒无外，九服大同，四海为家，万里为宅。乃休牛散马，偃武修文。”\n			', '\n岂直～，但美于偃兵，保大定功，空歌于成德者哉！\n			'),
(1537, '0:3:1', '休牛散马', '\n【 xiū　niú　sàn　mǎ 】\n			', '\n放归军用的牛马，表示停止战事。\n			', '\n唐·魏徵寿《隋书·薛道衡传》：“于是八荒无外，九服大同，四海为家，万里为宅。乃休牛散马，偃武修文。”\n			', '\n暂无\n			'),
(1538, '0:3:1', '犀牛望月', '\n【 xī　niú　wàng　yuè 】\n			', '\n比喻见到的不全面。\n			', '\n《关尹子·五鉴》：“譬如犀牛望月。月形入角，特因识生，始有月形，而彼真月初不在角。”\n			', '\n暂无\n			'),
(1539, '0:3:1', '蹊田夺牛', '\n【 xī　tián　duó　niú 】\n			', '\n蹊：践踏；夺：强取。因牛践踏了田，抢走人家的牛。比喻罪轻罚重。\n			', '\n《左传·宣公十一年》：“‘牵牛以蹊人之田，而夺之牛。’牵牛以蹊者，信有罪矣；而夺之牛，罚已重矣。”\n			', '\n暂无\n			'),
(1540, '0:3:1', '羞以牛后', '\n【 xiū　yǐ　niú　hòu 】\n			', '\n牛后：牛的肛门，比喻从属的地位。指不愿处在从属地位，为人牵制。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1541, '0:3:1', '犀照牛渚', '\n【 xī　zhào　niú　zhǔ 】\n			', '\n比喻洞察幽微。\n			', '\n《晋书·温峤传》：“扞温峤呴至牛渚矶，水深不可测，世云其下多怪物，峤遂燬犀角而照之。”\n			', '\n高攀天根探月窟，～万怪呈。\n			'),
(1542, '0:3:1', '一牛吼地', '\n【 yī　niú　hǒu　dì 】\n			', '\n指牛鸣声可及之地。比喻距离较近。\n			', '\n《翻译名义集·数量》：“拘卢舍，此云五百弓，亦云一牛吼地，谓大牛鸣声所极闻。或云一鼓声。《俱舍》云二里，《杂宝藏》云五里。”\n			', '\n五马渡江开国处，～作庵人。\n			'),
(1543, '0:3:1', '一牛九锁', '\n【 yī　niú　jiǔ　suǒ 】\n			', '\n比喻无法解脱。\n			', '\n汉·焦延寿《易林》卷十：“一牛九锁，更相牵挛，案明如市，不得东西，请谳得报，日中被刑。”\n			', '\n暂无\n			'),
(1544, '0:3:1', '一牛鸣地', '\n【 yī　niú　míng　dì 】\n			', '\n指牛鸣声可及之地。比喻距离较近。同“一牛吼地”。\n			', '\n清·钱谦益《山庄八景诗·锦峰晴晓》序：“其旁有锦峰书院，去山庄一牛鸣地。”\n			', '\n～时相见，双树影堂还结缘。\n			'),
(1545, '0:3:1', '一牛鸣', '\n【 yī　niú　míng 】\n			', '\n指牛鸣声可及之地。比喻距离较近。同“一牛吼地”。\n			', '\n唐·王维《与苏卢二员外游方丈寺》诗：“回看双凤阙，相去一牛鸣。”\n			', '\n四壁晚钟齐接应，分明不隔～。\n			'),
(1546, '0:3:1', '以羊易牛', '\n【 yǐ　yáng　yì　niú 】\n			', '\n易：更换。用羊来替换牛。比喻用这个代替另一个。\n			', '\n《孟子·梁惠王上》：“王坐于堂上，有牵牛而过堂下者。……曰：‘何可废也，以羊易之。’”\n			', '\n东床已招佳选，何知～；西邻纵有责言，终难指鹿为马。（明·冯梦龙《醒世恒言》卷七）\n			'),
(1547, '0:3:1', '争猫丢牛', '\n【 zhēng　māo　diū　niú 】\n			', '\n比喻贪小失大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1548, '0:3:1', '执牛耳', '\n【 zhí　niú　ěr 】\n			', '\n古代诸侯订立盟约，要割牛耳歃血，由主盟国的代表拿着盛牛耳朵的盘子。故称主盟国为执牛耳。后泛指在某一方面居最有权威的地位。\n			', '\n《左传·哀公十七年》：“诸侯盟，谁执牛耳？”\n			', '\n暂无\n			'),
(1549, '0:3:1', '钻牛角尖', '\n【 zuān　niú　jiǎo　jiān 】\n			', '\n比喻费力研究不值得研究或无法解决的问题。也指思想方法狭窄。\n			', '\n<span class="C999">暂无</span>\n			', '\n凡事都要留有余地，别死～。（老舍《神拳》第三幕）\n			'),
(1550, '0:3:1', '壮气吞牛', '\n【 zhuàng　qì　tūn　niú 】\n			', '\n形容气势雄壮远大。\n			', '\n明·孙梅锡《琴心记》第二十出：“男儿汉壮气吞牛，丈夫志岂困荒丘？”\n			', '\n暂无\n			'),
(1551, '0:3:2', '杯弓市虎', '\n【 bēi　gōng　shì　hǔ 】\n			', '\n指捕风捉影，疑虑重重，自相惊扰。参见“杯弓蛇影”、“三人成虎”。\n			', '\n詧盦《学界风潮记·天津商学界之活动》：“同时传来上海有罢市之说，以致杯弓市虎，危机伺伏，人心恐惶，险状万分。”\n			', '\n暂无\n			'),
(1552, '0:3:2', '不入虎穴，不得虎子', '\n【 bù　rù　hǔ　xué，bù　dé　hǔ　zǐ 】\n			', '\n不进老虎洞，就不能捉到小老虎。比喻不担风险就不可能取得成果。\n			', '\n南朝·宋·范晔《后汉书·班超传》：“超曰：‘不入虎穴，不得虎子。当今之计，独有因夜以火攻虏，使彼不知我多少，必大震怖，可殄尽也。’”\n			', '\n暂无\n			'),
(1553, '0:3:2', '垂饵虎口', '\n【 chuí　ěr　hǔ　kǒu 】\n			', '\n往虎口送食。比喻置身险地。\n			', '\n《文选·司马迁\n			', '\n暂无\n			'),
(1554, '0:3:2', '刺虎持鹬', '\n【 cì　hǔ　chí　yù 】\n			', '\n比喻待机行事，一举两得。\n			', '\n《战国策·秦策二》及《史记·张仪列传》载：刺虎，战国时，陈畛说秦惠王，引卞庄子刺虎为喻，先待齐楚交战，乘其两败俱伤时进兵。持鹬，用“鹬蚌相持”之典。\n			', '\n臣是以反复于前代以蛮攻蛮之成效，而知～，功在乘时。固不在勤天之力以求之也。\n			'),
(1555, '0:3:2', '豺虎肆虐', '\n【 chái　hǔ　sì　nüè 】\n			', '\n豺、虎：两种凶残的野兽。比喻坏人像凶残的野兽般横行不法。\n			', '\n汉·张衡《南都赋》：“帝乱其政，豺虎肆虐，真人革命之秋也。”\n			', '\n中常待同郡侯览，专权王命，～，威震天下。\n			'),
(1556, '0:3:2', '除狼得虎', '\n【 chú　láng　dé　hǔ 】\n			', '\n比喻除去一害又来一害。\n			', '\n《金史·陈规传》：“近虽遗官谦察，治其奸滥，易其疲软，然代者亦非选择，所谓除狼得虎也。”\n			', '\n孙坚乃东猛虎；若打破洛阳，杀了董卓，正是除狼而得虎也。\n			'),
(1557, '0:3:2', '豺狼虎豹', '\n【 chái　láng　hǔ　bào 】\n			', '\n泛指危害人畜的各种猛兽。也比喻凶残的恶人。\n			', '\n清·刘鹗《老残游记》第八回：“实在可怕的是豺狼虎豹。天晚了，倘若出来个把，我们就坏了。”\n			', '\n暂无\n			'),
(1558, '0:3:2', '鸱视虎顾', '\n【 chī　shì　hǔ　gù 】\n			', '\n如鸱鸟举首而视，如虎反顾。\n			', '\n《淮南子·精神训》：“真人之所游，若吹呴呼吸，吐故纳新，凫浴猿躩，熊经鸟伸，鸱视虎顾，是养形之人也，不以滑心。”\n			', '\n暂无\n			'),
(1559, '0:3:2', '初生之犊不惧虎', '\n【 chū　shēng　zhī　dú　bù　jù　hǔ 】\n			', '\n比喻阅世不深的青年人敢说敢干，无所畏惧。\n			', '\n《三国演义》第七四回：“俗云：‘初生之犊不惧虎。’父亲纵然斩了此人，只是西羌一小卒耳；倘有疏虞，非所以重伯父之托也。”\n			', '\n真是～，我刘国栋就是一只虎，哼，连虎也得惧我三分的！\n			'),
(1560, '0:3:2', '初生之犊不畏虎', '\n【 chū　shēng　zhī　dú　bù　wèi　hǔ 】\n			', '\n比喻阅世不深的青年人敢说敢干，无所畏惧。\n			', '\n姚雪垠《李自成》第一卷第十四章：“刚吃过早饭，人马全都汇齐，有些人震于闯王和李过的威名，不免惊惶，但有些人好像初生之犊不畏虎，磨拳擦掌地等待厮杀。”\n			', '\n我看你二人，也真是～！\n			'),
(1561, '0:3:2', '雕虎焦原', '\n【 diāo　hǔ　jiāo　yuán 】\n			', '\n指壮士履险。\n			', '\n《尸子》：“中黄伯曰：余左执太行之獶而右搏雕虎。”又：“莒国有石焦原者，广寻，长五十步，临百仞之谿，莒国莫敢近也。有以勇见莒子者，独却行剂踵焉。”\n			', '\n甬有耆旧，居仁由义，河山虽改，诗书不废。～，不异平地，深松茂柏，永无憔悴。\n			'),
(1562, '0:3:2', '打虎牢龙', '\n【 dǎ　hǔ　láo　lóng 】\n			', '\n犹言打凤牢龙。比喻安排圈套使强有力的对手中计。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1563, '0:3:2', '断蛟刺虎', '\n【 duàn　jiāo　cì　hǔ 】\n			', '\n指武艺高强，行为侠义。\n			', '\n南朝·宋·刘义庆《世说新语·自新》载：相传晋周处曾射蛟杀虎，为民除害。\n			', '\n～好身手，碧瞳如水涵清秋。\n			'),
(1564, '0:3:2', '打死虎', '\n【 dǎ　sǐ　hǔ 】\n			', '\n比喻抨击已失威势的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1565, '0:3:2', '饿虎擒羊', '\n【 è　hǔ　qín　yáng 】\n			', '\n像饥饿的老虎捕食羔羊一样。比喻迅猛贪婪。\n			', '\n清·钱彩《说岳全传》第七回：“兄听得索郎郎的叉盘声响，使个‘饿虎擒羊’势，叫道：‘你敢来么？’”\n			', '\n他做出一个～的动作让大家哄堂大笑。\n			'),
(1566, '0:3:2', '冯河暴虎', '\n【 féng　hé　bào　hǔ 】\n			', '\n犹言暴虎冯河。比喻有勇无谋，鲁莽冒险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1567, '0:3:2', '放虎遗患', '\n【 fàng　hǔ　yí　huàn 】\n			', '\n放掉老虎，留下后患。\n			', '\n唐·陈子昂《上西蕃边州安危事》之一：“夫蕃戎之性，人面兽心，亲之则顺，疑之则乱……今阻其善，逆其欢心，古人所谓放虎遗患，不可不察。”\n			', '\n暂无\n			'),
(1568, '0:3:2', '凤叹虎视', '\n【 fèng　tàn　hǔ　shì 】\n			', '\n形容谈吐文雅，器宇轩昂。\n			', '\n《文选·曹植〈与吴季重书〉》：“足下鹰扬其体，凤叹虎视，谓萧曹不足俦，卫霍不足侔也。”李善注：“凤以喻文也，虎以喻武也。叹犹歌也。取美壮之意。”\n			', '\n暂无\n			'),
(1569, '0:3:2', '甘冒虎口', '\n【 gān　mào　hǔ　kǒu 】\n			', '\n指甘愿冒着生命危险。\n			', '\n《三国志·魏志·袁绍传》“吾不用田丰言，果为所笑”裴松之注引晋·孙盛曰：“丰知绍将败，败则己必死，甘冒虎口以尽忠规，烈士之于所事，虑不存己。”\n			', '\n暂无\n			'),
(1570, '0:3:2', '割肉饲虎', '\n【 gē　ròu　sì　hǔ 】\n			', '\n饲：喂。割下身上的肉喂老虎。比喻既舍弃生命也无法满足对方的贪欲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1571, '0:3:2', '虎步龙行', '\n【 hǔ　bù　lóng　xíng 】\n			', '\n原形容帝王的仪态不同一般。后也形容将军的英武姿态。\n			', '\n《宋书·武帝纪上》：“刘裕龙行虎步，视瞻不凡，恐不为人下，宜早为其所。”\n			', '\n只见那人生得面如冠玉，唇若涂朱，眉清目秀，～。\n			'),
(1572, '0:3:2', '虎变龙蒸', '\n【 hǔ　biàn　lóng　zhēng 】\n			', '\n指乘时变化而飞黄腾达。\n			', '\n明·汤显祖《紫钗记·节镇还朝》：“君侯膺归衮之期，贱子附迁莺着役。风期未远，存问非遥。虎变龙蒸，风云自爱。”\n			', '\n暂无\n			'),
(1573, '0:3:2', '虎超龙骧', '\n【 hǔ　chāo　lóng　xiāng 】\n			', '\n比喻群雄奋起，互相角逐。\n			', '\n三国·魏·曹植《汉二祖优劣论》：“当此时也，九州鼎沸，四海渊涌。言帝者二三，称王者四五。鸱视狼顾，虎超龙骧。”\n			', '\n暂无\n			'),
(1574, '0:3:2', '虎党狐侪', '\n【 hǔ　dǎng　hú　chái 】\n			', '\n比喻凶恶狡黠之辈。\n			', '\n明·康海《中山狼》第二折：“谁曾见这锦囊诗袋，却遮藏的虎党狐侪，只您这眉前眼后谁瞒过。道不的露尾藏头，怎撒乖，没处安排。”\n			', '\n暂无\n			'),
(1575, '0:3:2', '虎荡羊群', '\n【 hǔ　dàng　yáng　qún 】\n			', '\n老虎冲进羊群中。比喻以强凌弱，为所欲为。同“虎入羊群”。\n			', '\n清·石玉昆《三侠五义》第九十二回：“那知小侠指东打西，窜南跃北，犹如虎荡羊群，不大的工夫，打了个落花流水。”\n			', '\n暂无\n			'),
(1576, '0:3:2', '虎而冠', '\n【 hǔ　ér　guàn 】\n			', '\n冠：把帽子戴在头上。比喻生性残虐的人。\n			', '\n《史记·酷吏列传》：“其爪牙吏，虎而冠。”\n			', '\n暂无\n			'),
(1577, '0:3:2', '画虎不成反类犬', '\n【 huà　hǔ　bù　chéng　fǎn　lèi　quǎn 】\n			', '\n比喻模仿不到家，反而不伦不类。同“画虎不成反类狗”。\n			', '\n唐·刘知幾《史通·六家》：“如君懋《隋书》，虽欲祖述商周，宪章虞夏，观其所述乃似《孔子家语》、临川《世说》，可谓画虎不成反类犬也。”\n			', '\n暂无\n			'),
(1578, '0:3:2', '画虎刻鹄', '\n【 huà　hǔ　kè　hú 】\n			', '\n①比喻好高鹜远，终无成就。②比喻好事做不成，反变了坏事。\n			', '\n《东观汉记·马援传》：“与兄子严敦书曰：‘学龙伯高不就，犹为谨饬之士，所谓刻鹄不成尚类鹜者。效杜季良而不成，陷为天下轻薄子，所谓画虎不成反类狗也。’”\n			', '\n那怪既神通广大，变得与你相同……我徒弟有手段，决不敢轻动干戈。倘被多官拿住，说我们欺邦灭国，问一款大逆之罪，困陷城中，却不是～也？\n			'),
(1579, '0:3:2', '狐藉虎威', '\n【 hú　jiè　hǔ　wēi 】\n			', '\n比喻仰仗别人威势或倚仗别人的势力欺压人。同“狐假虎威”。\n			', '\n《宋书·恩幸传序》：“曾不知鼠凭社贵，狐藉虎威，外无逼主之嫌，内有专用之功。”\n			', '\n暂无\n			'),
(1580, '0:3:2', '虎踞鲸吞', '\n【 hǔ　jù　jīng　tūn 】\n			', '\n比喻豪强割据和相互兼并。\n			', '\n明·罗贯中《三国演义》第四十九回：“诸将皆来动问，尽皆愕然相顾曰：‘江北百万之众，虎踞鲸吞。不争都督如此，倘曹兵一至，如之奈何？’”\n			', '\n暂无\n			'),
(1581, '0:3:2', '虎据龙蟠', '\n【 hǔ　jù　lóng　pán 】\n			', '\n形容地势雄伟险要。同“虎踞龙盘”。\n			', '\n北周·庚信《哀江南赋》：“昔之虎据龙蟠，加以黄旗紫气；莫不随狐兔而窟穴，与风尘而殄悴。”\n			', '\n暂无\n			'),
(1582, '0:3:2', '虎踞龙蟠', '\n【 hǔ　jù　lóng　pán 】\n			', '\n形容地势雄伟险要。同“虎踞龙盘”。\n			', '\n宋·辛弃疾《念奴娇·登建康赏心亭呈史留守致道》词：“虎踞龙蟠何处是？只有兴亡满目。”\n			', '\n暂无\n			'),
(1583, '0:3:2', '虎窟龙潭', '\n【 hǔ　kū　lóng　tán 】\n			', '\n窟：洞穴；潭：深水池。龙居住的深水潭，虎栖身的巢穴。比喻极其凶险的地方。\n			', '\n元·汪元亨《沉醉东风·归田》：“怕筑成传说墙，愁扳折朱云槛，急跳出虎窟龙潭。”\n			', '\n暂无\n			'),
(1584, '0:3:2', '虎略龙韬', '\n【 hǔ　lüè　lóng　tāo 】\n			', '\n略：指传说中黄石公所撰的《三略》。韬：指《六韬》。《三略》、《六韬》是古代兵书。泛指兵书、兵法，也指兵家权谋。\n			', '\n明·刘基《悲杭城》诗：“一朝奔迸各西东，玉斝金杯散蓬荜。清都太微天听高，虎略龙韬缄石室。”\n			', '\n雄图壮志千秋罕，～万众从。\n			'),
(1585, '0:3:2', '虎狼之势', '\n【 hǔ　láng　zhī　shì 】\n			', '\n形容极凶猛的声势。\n			', '\n《淮南子·要略》：“孝公欲以虎狼之势而吞诸侯。”\n			', '\n暂无\n			'),
(1586, '0:3:2', '虎兕出柙', '\n【 hǔ　sì　chū　xiá 】\n			', '\n兕：犀牛一类的野兽。柙：关兽的木笼。虎、兕从木笼中逃出。比喻恶人逃脱或作事不尽责，主管者应负责任。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1587, '0:3:2', '虎视眈眈', '\n【 hǔ　shì　dān　dān 】\n			', '\n眈眈：注视的样子。象老虎那样凶狠地盯着。形容心怀不善，伺机攫取。\n			', '\n《周易·颐》：“虎视耽耽，其欲逐逐。”\n			', '\n你看这里这些人，因见老太太多疼了宝玉和凤姐姐两个，他们尚～，背地里言三语四的，何况于我？（清·曹雪芹《红楼梦》第四十回）\n			'),
(1588, '0:3:2', '虎穴狼巢', '\n【 hǔ　xué　láng　cháo 】\n			', '\n虎和狼的窝巢。比喻极其危险的地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1589, '0:3:2', '虎掷龙拿', '\n【 hǔ　zhì　lóng　ná 】\n			', '\n掷：挣扎跳跃。指龙虎互相争斗。比喻激烈的搏斗。\n			', '\n金·元好问《楚汉战处》诗：“虎掷龙拿不两存，当年曾此赌乾坤。”\n			', '\n暂无\n			'),
(1590, '0:3:2', '骏波虎浪', '\n【 jùn　bō　hǔ　làng 】\n			', '\n形容迅猛汹涌的波浪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1591, '0:3:2', '九关虎豹', '\n【 jiǔ　guān　hǔ　bào 】\n			', '\n比喻凶残的权臣。\n			', '\n语出《楚辞·招魂》：“虎豹九关，啄害下人些。”宋·赵癯斋《买陂塘（闻掀髯）》词：“功名事，不信朝鳞暮羽。九关虎豹如许。”\n			', '\n不见～虓且噬，浮云遮日孰为怯？\n			'),
(1592, '0:3:2', '九阍虎豹', '\n【 jiǔ　hūn　hǔ　bào 】\n			', '\n比喻凶残的权臣。同“九关虎豹”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1593, '0:3:2', '酒虎诗龙', '\n【 jiǔ　hǔ　shī　lóng 】\n			', '\n比喻嗜酒善饮、才高能诗的人。\n			', '\n清·丘逢甲《东山酒楼次柳汀韵》：“狂饮且共楼头醉，酒虎诗龙各自豪。”\n			', '\n暂无\n			'),
(1594, '0:3:2', '假虎张威', '\n【 jiǎ　hǔ　zhāng　wēi 】\n			', '\n犹言狐假虎威。比喻依仗别人的势力欺压人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1595, '0:3:2', '拒狼进虎', '\n【 jù　láng　jìn　hǔ 】\n			', '\n比喻一害刚去，又来一害。同“拒虎进狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1596, '0:3:2', '酒龙诗虎', '\n【 jiǔ　lóng　shī　hǔ 】\n			', '\n比喻嗜酒善饮、才高能诗的人。\n			', '\n清·丘逢甲《饮镇平都司署赏菊为题宋人所画报捷图》诗：“粤水闽山文武会，酒龙诗虎主宾才。”\n			', '\n暂无\n			'),
(1597, '0:3:2', '鲸吞虎噬', '\n【 jīng　tūn　hǔ　shì 】\n			', '\n像鲸鱼和老虎一样吞食。多比喻吞并土地财物。\n			', '\n宋·范仲淹《上执政书》：“前代乱离，鲸吞虎噬，无卜世卜年之意，故斯道久缺，反为不急之务。”\n			', '\n他谋多中伤，威权明仗，～，谁敢拦挡？\n			'),
(1598, '0:3:2', '开柙出虎', '\n【 kāi　xiá　chū　hǔ 】\n			', '\n柙：关猛兽的木笼。原指负责看管的人未尽责任。后多比喻放纵坏人。\n			', '\n《论语·季氏》：“孔子曰：‘……虎兕出于柙，龟玉毁于椟中，是谁之过与？’”\n			', '\n～，孔宣父不责他人；当路斩蛇，孙叔敖盖非利己。（明·凌濛初《初刻拍案惊奇》卷二十二）\n			'),
(1599, '0:3:2', '狼虫虎豹', '\n【 láng　chóng　hǔ　bào 】\n			', '\n①泛指凶猛的动物。②比喻恶人歹徒。\n			', '\n明·贾仲名《对玉梳》第三折：“转过这山坡，一簇榆林，黑洞洞的，不知里面藏着什么狼虫虎豹。”\n			', '\n县长财主，～。\n			'),
(1600, '0:3:2', '狼飡虎食', '\n【 láng　cān　hǔ　shí 】\n			', '\n形容吃东西又猛又急。同“狼餐虎咽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1601, '0:3:2', '狼餐虎噬', '\n【 láng　cān　hǔ　shì 】\n			', '\n①形容吃东西又猛又急。同“狼餐虎咽”。②比喻残酷剥削搜括。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1602, '0:3:2', '狼飡虎咽', '\n【 láng　cān　hǔ　yān 】\n			', '\n形容吃东西又猛又急。同“狼餐虎咽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1603, '0:3:2', '狼餐虎咽', '\n【 láng　cān　hǔ　yàn 】\n			', '\n形容吃东西又猛又急。\n			', '\n明·吴承恩《西游记》第五十二回：“［行者］迎着里面灯光，仔细观看。只见那大小群妖，一个个狼餐虎咽，正都吃东西哩。”\n			', '\n老军道：“忒过分了！”父子二人正在饥馁之时，拿起饭来，～，尽情一饱。\n			'),
(1604, '0:3:2', '龙驰虎骤', '\n【 lóng　chí　hǔ　zhòu 】\n			', '\n指群雄逐鹿。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1605, '0:3:2', '龙蹲虎踞', '\n【 lóng　dūn　hǔ　jù 】\n			', '\n犹言龙盘虎踞。好像盘绕的龙，蹲伏的虎。特指南京。亦形容地势雄伟险要。\n			', '\n宋·丁开《建业》诗：“龙蹲虎踞江山大，马去牛来社稷空。”\n			', '\n暂无\n			'),
(1606, '0:3:2', '拉大旗作虎皮', '\n【 lā　dà　qí　zuò　hǔ　pí 】\n			', '\n比喻打着革命的旗号来吓唬人、蒙骗人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1607, '0:3:2', '龙幡虎纛', '\n【 lóng　fān　hǔ　dào 】\n			', '\n指将帅之旗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1608, '0:3:2', '龙飞虎跳', '\n【 lóng　fēi　hǔ　tiào 】\n			', '\n比喻笔势遒劲奔放。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1609, '0:3:2', '狼顾虎视', '\n【 láng　gù　hǔ　shì 】\n			', '\n如狼虎视物。形容威严而凶狠。\n			', '\n《三国志·蜀志·杨戏传》“亮南征，留邵为治中从事，是岁卒”裴松之注引晋·常璩《华阳国志》：“亮身仗强兵，狼顾虎视，五大不在边，臣常危之。”\n			', '\n暂无\n			'),
(1610, '0:3:2', '龙虎风云', '\n【 lóng　hǔ　fēng　yún 】\n			', '\n①比喻英雄豪杰际遇得时。②指君臣遇合。\n			', '\n《易·干》：“云从龙，风从虎。”\n			', '\n善教他，归厚德，太平时～会。\n			'),
(1611, '0:3:2', '龙化虎变', '\n【 lóng　huà　hǔ　biàn 】\n			', '\n比喻变化莫测。\n			', '\n《易·革》：“大人虎变，其文炳也。”《史记·老子韩非列传》“（孔子）谓弟子曰：‘鸟，吾知其能飞；鱼，吾知其能游；兽，吾知其能走。走者可以为罔，游者可以为纶，飞者可以为矰。至于龙，吾不能知其乘风云而上天。’”\n			', '\n～，可以哸虚空，虚空非无也；可以贯金石，金石非有也。……知此道者形不可得毙，神不可得逝。\n			'),
(1612, '0:3:2', '老虎头上扑苍蝇', '\n【 lǎo　hǔ　tóu　shàng　pū　cāng　yíng 】\n			', '\n比喻自己找死。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1613, '0:3:2', '老虎头上搔痒', '\n【 lǎo　hǔ　tóu　shàng　sāo　yǎng 】\n			', '\n比喻不自量力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1614, '0:3:2', '两虎相斗', '\n【 liǎng　hǔ　xiāng　dòu 】\n			', '\n比喻力量强大的双方相搏斗。\n			', '\n《战国策·秦策二》：“今两虎诤人而斗，小者必死，大者必伤。”《史记·春申君列传》：“天下莫强于秦楚，今闻大王欲伐楚，此犹两虎相与斗。”\n			', '\n今～，必有一伤。须误了我大事。吾与你二人劝解，休得争论。（明·罗贯中《三国演义》第六十二回）\n			'),
(1615, '0:3:2', '捋虎须', '\n【 luō　hǔ　xū 】\n			', '\n捋：抚摩。比喻触犯有权势的人或冒着很大的风险。\n			', '\n明·施耐庵《水浒传》第五回：“太公道：‘好却甚好，只是不要捋虎须。’”\n			', '\n暂无\n			'),
(1616, '0:3:2', '两虎相争', '\n【 liǎng　hǔ　xiāng　zhēng 】\n			', '\n两只老虎相互争斗。比喻力量强大的双方相搏斗。\n			', '\n《战国策·秦策二》：“今两虎诤人而斗，小者必死，大者必伤。”《史记·春申君列传》：“天下莫强于秦楚，今闻大王欲伐楚，此犹两虎相与斗。”\n			', '\n我相公官至下大夫，不知为何，近日只要与上大夫赵正卿争朝，我想～，必有一伤。\n			'),
(1617, '0:3:2', '麟角虎翅', '\n【 lín　jiǎo　hǔ　chì 】\n			', '\n麟之角，虎之翅。比喻世间不可多得的人才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1618, '0:3:2', '龙江虎浪', '\n【 lóng　jiāng　hǔ　làng 】\n			', '\n形容惯于兴风作浪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1619, '0:3:2', '龙精虎猛', '\n【 lóng　jīng　hǔ　měng 】\n			', '\n比喻精力旺盛，斗志昂扬。\n			', '\n陈残云《山谷风烟》第二一章：“大家一夜没睡觉，到如今还是龙精虎猛，表现了兄弟姐妹们对地主的仇恨。”\n			', '\n暂无\n			'),
(1620, '0:3:2', '龙拏虎攫', '\n【 lóng　ná　hǔ　jué 】\n			', '\n犹言龙争虎斗。比喻笔势遒劲、奔放。\n			', '\n清·王晫《今世说·企羡》：“新城王西樵阮亭，每过邮亭夜店，辄题诗壁上，诗既惊人，使笔斗大，龙拏虎攫。”\n			', '\n暂无\n			'),
(1621, '0:3:2', '龙拏虎跳', '\n【 lóng　ná　hǔ　tiào 】\n			', '\n犹言龙争虎斗。\n			', '\n俞锷《醉歌行》：“说霸争王各不让，龙拏虎跳旦复昏。”\n			', '\n我以为这并不比～的战斗场面少些激动人心的力量。\n			'),
(1622, '0:3:2', '龙拏虎掷', '\n【 lóng　ná　hǔ　zhì 】\n			', '\n犹言龙争虎斗。\n			', '\n宋·喻汝砺《八阵图》诗：“笑云此公大肚皮，龙拏虎掷填胸胄。”\n			', '\n自汉迄今，全史之大，部分，皆演于江河间之原野，被～，甲兴乙仆，殆未有出山东、安徽、江苏、河南、湖北数省外者也。\n			'),
(1623, '0:3:2', '龙蟠虎伏', '\n【 lóng　pán　hǔ　fú 】\n			', '\n雄踞的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1624, '0:3:2', '龙盘虎踞', '\n【 lóng　pán　hǔ　jù 】\n			', '\n盘：曲折环绕；踞：蹲、坐。好像盘绕的龙，蹲伏的虎。特指南京。亦形容地势雄伟险要。\n			', '\n晋·吴勃《吴录》：“刘备曾使诸葛亮至京，因睹秣陵山阜，叹曰：‘钟山龙盘，石头虎踞，此帝王之宅。’”唐·李白《永王东巡歌》：“龙蟠虎踞帝王州，帝子金陵访古丘。”\n			', '\n暂无\n			'),
(1625, '0:3:2', '龙蟠虎踞', '\n【 lóng　pán　hǔ　jù 】\n			', '\n象龙盘着，象虎蹲着。形容地势雄伟险要。特指南京。\n			', '\n晋·吴勃《吴录》：“刘备曾使诸葛亮至京，因睹秣陵山阜，叹曰：‘钟山龙盘，石头虎踞，此帝王之宅。’”\n			', '\n暂无\n			'),
(1626, '0:3:2', '龙盘虎拏', '\n【 lóng　pán　hǔ　ná 】\n			', '\n虬曲苍劲的样子。\n			', '\n明·何景明《古松歌》：“龙盘虎拏终有神，白骨苍鳞半枯死。”\n			', '\n暂无\n			'),
(1627, '0:3:2', '龙蟠虎绕', '\n【 lóng　pán　hǔ　rào 】\n			', '\n犹言龙盘虎踞。形容地势雄伟险要。\n			', '\n宋·范成大《水龙吟·寿留寺》词：“物外新闻，凤歌鸾翥，龙蟠虎绕。”\n			', '\n暂无\n			'),
(1628, '0:3:2', '狼前虎后', '\n【 láng　qián　hǔ　hòu 】\n			', '\n前门赶走狼，后门来了虎。比喻坏人接踵而来。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1629, '0:3:2', '龙跧虎卧', '\n【 lóng　quán　hǔ　wò 】\n			', '\n犹言龙蟠虎踞。比喻山势逶迤起伏。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1630, '0:3:2', '离山调虎', '\n【 lí　shān　diào　hǔ 】\n			', '\n比喻用计谋调动对方离开原地。\n			', '\n《白雪遗音·八角鼓·精忠》：“岳老爷得胜不班师，秦桧东窗定巧计，私造金牌传假旨，暗使离山调虎计，风波亭上死的屈。”\n			', '\n暂无\n			'),
(1631, '0:3:2', '狼飧虎咽', '\n【 láng　sūn　hǔ　yàn 】\n			', '\n飧：熟食，饭食。形容吃东西又猛又急。亦作“狼餐虎咽”。\n			', '\n明·凌濛初《初刻拍案惊奇》卷三：“十人自来吃酒，主人安排些鸡、豚、牛、羊肉来做下酒。须臾之间，狼飨虎咽，算来吃勾有六七十斤的肉，倾尽了六七坛的酒。”\n			', '\n见他们一个个蹲在地下，吃了个～，沟满壕平。（清·文康《儿女英雄传》第十四回\n			'),
(1632, '0:3:2', '狼吞虎餐', '\n【 láng　tūn　hǔ　cān 】\n			', '\n形容吃东西又猛又急。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1633, '0:3:2', '龙腾虎蹴', '\n【 lóng　téng　hǔ　cù 】\n			', '\n比喻勇猛冲击，势不可当。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1634, '0:3:2', '龙跳虎伏', '\n【 lóng　tiào　hǔ　fú 】\n			', '\n犹言龙腾虎卧。比喻笔势。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1635, '0:3:2', '龙腾虎踞', '\n【 lóng　téng　hǔ　jù 】\n			', '\n势力强盛，雄据一方。\n			', '\n晋·葛洪《抱朴子·钦士》：“彼虽降高抑满，以贵下贱，终亦并目以远其明，假耳以广其聪，龙腾虎踞，宜其然也。”\n			', '\n暂无\n			'),
(1636, '0:3:2', '龙潭虎窟', '\n【 lóng　tán　hǔ　kū 】\n			', '\n窟：洞穴。潭：深水池。龙居住的深水潭，虎栖身的巢穴。比喻极其凶险的地方。\n			', '\n元·王实甫《丽春堂》第三折：“闲对着绿树青山，消遣我烦心倦目，潜入那水国渔乡，早跳出龙潭虎窟。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1637, '0:3:2', '狼吞虎噬', '\n【 láng　tūn　hǔ　shì 】\n			', '\n像狼虎那样吞食咬嚼。比喻极为贪婪残忍。\n			', '\n明·无名氏《鸣凤记·二相争朝》：“你辟私门，贿赂行，半朝臣，皆从顺。你狼吞虎噬伤残了万民百姓，害得那有功臣百事无成。”\n			', '\n自此以入，司牧之官，必能扫除一切苛政……去害马以驯良，泯雀角鼠牙之衅，绝～之端，不惊不扰，民得宽然，各尽地方。《花月痕》第五十回\n			'),
(1638, '0:3:2', '龙跳虎卧', '\n【 lóng　tiào　hǔ　wò 】\n			', '\n比喻文笔、书法纵逸雄劲。\n			', '\n南朝梁·袁昂《古今书评》：“萧思话书走墨连绵，字势屈强若龙跳天门，虎卧凤阁。”\n			', '\n暂无\n			'),
(1639, '0:3:2', '龙潭虎穴', '\n【 lóng　tán　hǔ　xué 】\n			', '\n龙潜居的深水坑，老虎藏身的巢穴。比喻极险恶的地方。\n			', '\n元·无名氏《昊天塔》第三折：“不甫能撞开了天关地户，跳出这龙潭虎窟。”\n			', '\n暂无\n			'),
(1640, '0:3:2', '龙腾虎啸', '\n【 lóng　téng　hǔ　xiào 】\n			', '\n声势壮盛的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1641, '0:3:2', '狼吞虎咽', '\n【 láng　tūn　hǔ　yàn 】\n			', '\n形容吃东西又猛又急的样子。\n			', '\n明·凌濛初《初刻拍案惊奇·刘东山夸技顺城门》：“十人自来吃酒……须臾之间，狼飧虎咽，算来吃够有六七十斤肉。”\n			', '\n走了这半日，肚中饥饿，～吃了一回。（清·陈忱《水浒后传》第五回）\n			'),
(1642, '0:3:2', '龙腾虎踯', '\n【 lóng　téng　hǔ　zhí 】\n			', '\n比喻勇猛冲击，势不可当。同“龙腾虎蹴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1643, '0:3:2', '龙腾虎掷', '\n【 lóng　téng　hǔ　zhì 】\n			', '\n比喻勇猛冲击，势不可当。同“龙腾虎蹴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1644, '0:3:2', '龙骧虎步', '\n【 lóng　xiāng　hǔ　bù 】\n			', '\n象龙马昂首，如老虎迈步。形容气慨威武雄壮。\n			', '\n三国魏·嵇康《卜疑》：“将如毛公蔺生之龙骧虎步，慕为壮士乎？”《三国志·魏书·陈琳传》：“今将军总皇威，握兵要，龙骧虎步，高下在心。”\n			', '\n公～，啸咤风云。（《宋书·高祖纪》）\n			'),
(1645, '0:3:2', '龙行虎变', '\n【 lóng　xíng　hǔ　biàn 】\n			', '\n比喻帝王革故鼎新，创制建业。\n			', '\n《易·干》：“飞龙在天……云从龙。风从虎，圣人作而万物睹。”又《革》：“大人虎变。”孔颖达疏：“损益前王，创制立法，有文章之美，焕然可观，有似虎变，其文彪炳。”\n			', '\n高祖起于布衣之中，奋剑而取天下，不由唐虞之禅，不阶汤武之王，～，率从风云，征乱伐暴，廓清帝宇。\n			'),
(1646, '0:3:2', '龙骧虎跱', '\n【 lóng　xiāng　hǔ　jià 】\n			', '\n雄踞的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1647, '0:3:2', '龙骧虎视', '\n【 lóng　xiāng　hǔ　shì 】\n			', '\n象龙马高昂着头，象老虎注视着猎物。形容人的气慨威武。也比喻雄才大略。\n			', '\n《三国志·蜀书·诸葛亮传》：“亮之素志，进欲龙骧虎视，苞括四海。”\n			', '\n～安乾坤，万古千秋名不朽。（明·罗贯中《三国演义》第三十八回）\n			'),
(1648, '0:3:2', '龙骧虎啸', '\n【 lóng　xiāng　hǔ　xiào 】\n			', '\n比喻气概威武。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1649, '0:3:2', '龙翔虎跃', '\n【 lóng　xiáng　hǔ　yuè 】\n			', '\n比喻奋发有为。\n			', '\n明·叶蕃《〈写情集〉序》：“其盖世之姿，雄伟之志，用天下国家之心，得不发为千汇万状之奇而龙翔虎跃也。”\n			', '\n暂无\n			'),
(1650, '0:3:2', '鲁鱼帝虎', '\n【 lǔ　yú　dì　hǔ 】\n			', '\n指文字传抄错误。\n			', '\n晋·葛洪《抱朴子》：“谚云：‘书三写，鱼成鲁，帝成虎。’”\n			', '\n暂无\n			'),
(1651, '0:3:2', '龙跃虎踞', '\n【 lóng　yuè　hǔ　jù 】\n			', '\n比喻超逸雄奇。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1652, '0:3:2', '龙吟虎啸', '\n【 lóng　yīn　hǔ　xiào 】\n			', '\n象龙在鸣，虎在啸。比喻相关的事物互相感应。也形容人发迹。\n			', '\n汉·张衡《归田赋》：“尔乃龙吟方泽，虎啸山丘。”\n			', '\n～，鹤唳莺鸣。（明·吴承恩《西游记》第六十回）\n			'),
(1653, '0:3:2', '龙争虎斗', '\n【 lóng　zhēng　hǔ　dòu 】\n			', '\n形容斗争或竞赛很激烈。\n			', '\n汉·班固《答宾戏》：“分裂诸夏，龙战虎争。”\n			', '\n我不信你敢差排吕太后，枉以后～，都是俺鸾交凤友。（元·马致远《汉宫秋》第二折）\n			'),
(1654, '0:3:2', '龙睁虎眼', '\n【 lóng　zhēng　hǔ　yǎn 】\n			', '\n形容蛮横霸道。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1655, '0:3:2', '龙战虎争', '\n【 lóng　zhàn　hǔ　zhēng 】\n			', '\n形容斗争或竞赛很激烈。同“龙争虎斗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1656, '0:3:2', '龙争虎战', '\n【 lóng　zhēng　hǔ　zhàn 】\n			', '\n形容斗争或竞赛很激烈。同“龙争虎斗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1657, '0:3:2', '猛虎出山', '\n【 měng　hǔ　chū　shān 】\n			', '\n像凶猛的老虎出山一样。形容动作勇猛又快速。亦作“猛虎下山”、“猛虎离山”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1658, '0:3:2', '猛虎深山', '\n【 měng　hǔ　shēn　shān 】\n			', '\n比喻勇武而势盛。\n			', '\n语出汉·司马迁《报任安书》：“猛虎在深山，百兽震恐。”\n			', '\n人民军队犹如～，势不可挡。\n			'),
(1659, '0:3:2', '骑虎难下', '\n【 qí　hǔ　nán　xià 】\n			', '\n骑在老虎背上不能下来。比喻做一件事情进行下去有困难，但情况又不允许中途停止，陷于进退两难的境地。\n			', '\n《晋书·温峤传》：“今之事势，义无旋踵，骑猛兽安可中下哉。”唐·李白《留别广陵诸公》诗：“骑虎不敢下，攀龙忽堕天。”\n			', '\n本月三日抛出的一百万公债，都成了～之势，我们只有硬着头皮干到那里是那里了！（茅盾《子夜》十）\n			'),
(1660, '0:3:2', '潜龙伏虎', '\n【 qián　lóng　fú　hǔ 】\n			', '\n潜藏的蛟龙，潜伏的猛虎。比喻人才尚未被擢用。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1661, '0:3:2', '乔龙画虎', '\n【 qiáo　lóng　huà　hǔ 】\n			', '\n形容假心假意地献殷勤。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1662, '0:3:2', '前门拒虎，后门进狼', '\n【 qián　mén　jù　hǔ，hòu　mén　jìn　láng 】\n			', '\n比喻赶走了一个敌人，又来了一个敌人。\n			', '\n明·李贽《史纲评要·周纪》：“‘秦败三晋之师于石门。赐以黼黻之服。’前门拒虎，后门进狼。未知是祸是福。”\n			', '\n暂无\n			'),
(1663, '0:3:2', '前门去虎，后门进狼', '\n【 qián　mén　qù　hǔ，hòu　mén　jìn　láng 】\n			', '\n比喻赶走了一个敌人，又来了一个敌人。同“前门拒虎，后门进狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1664, '0:3:2', '前怕狼，后怕虎', '\n【 qián　pà　láng，hòu　pà　hǔ 】\n			', '\n比喻胆小怕事，顾虑太多。\n			', '\n明·冯惟敏《朝天子·感述》：“磊落英雄，清修人物，前怕狼后怕虎。设谋，使毒，只待把忠良妒。”\n			', '\n他明白，上了年级的人都是～，事事有顾虑。（周立波《暴风骤雨》一）\n			'),
(1665, '0:3:2', '前怕龙，后怕虎', '\n【 qián　pà　lóng，hòu　pà　hǔ 】\n			', '\n比喻胆小怕事，顾虑太多。\n			', '\n明·冯惟敏《朝天子·感述》：“磊落英雄，清修人物，前怕狼后怕虎。设谋，使毒，只待把忠良妒。”\n			', '\n要改革就不能～，要大胆创新，努力实践，才能取得成功。\n			'),
(1666, '0:3:2', '敲山振虎', '\n【 qiāo　shān　zhèn　hǔ 】\n			', '\n指故意示警，使人震动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1667, '0:3:2', '敲山震虎', '\n【 qiāo　shān　zhèn　hǔ 】\n			', '\n指故意示警，使人震动。同“敲山振虎”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1668, '0:3:2', '驱羊攻虎', '\n【 qū　yáng　gōng　hǔ 】\n			', '\n驱：赶。驱赶羊群去进攻老虎。形容以弱敌强，力量悬殊，必遭覆灭。\n			', '\n《史记·张仪列传》：“且夫为从者，无以异于驱群羊而攻猛虎，虎之与羊不格明矣。今王不与猛虎而与群羊，臣窃以为大王之计过也。”\n			', '\n暂无\n			'),
(1669, '0:3:2', '乳犊不怕虎', '\n【 rǔ　dú　bù　pà　hǔ 】\n			', '\n比喻年轻人没有畏惧，敢做敢为。\n			', '\n《庄子·知北游》：“德将为汝美，道将为汝居，汝瞳焉如新出之犊，而无求其故。”\n			', '\n暂无\n			'),
(1670, '0:3:2', '如虎得翼', '\n【 rú　hǔ　dé　yì 】\n			', '\n比喻因增加新助力，强者愈强，恶者愈恶。同“如虎傅翼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1671, '0:3:2', '如虎傅翼', '\n【 rú　hǔ　fù　yì 】\n			', '\n好象老虎生出翅膀。比喻因增加新助力，强者愈强，恶者愈恶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1672, '0:3:2', '如虎生翼', '\n【 rú　hǔ　shēng　yì 】\n			', '\n比喻因增加新助力，强者愈强，恶者愈恶。同“如虎傅翼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1673, '0:3:2', '如虎添翼', '\n【 rú　hǔ　tiān　yì 】\n			', '\n好象老虎长上了翅膀。比喻强有力的人得到帮助变得更加强有力。\n			', '\n三国·蜀·诸葛亮《心书·兵机》：“将能执兵之权，操兵之势，而临群下，臂如猛虎加之羽翼，而翱翔四海。”\n			', '\n因为匪徒们深知，这两件东西一掌握在姜青山手里，就～，再多的人也奈何不了他。（曲波《林海雪原》二七）\n			'),
(1674, '0:3:2', '如狼似虎', '\n【 rú　láng　sì　hǔ 】\n			', '\n象狼和虎一样凶狠。比喻非常凶暴残忍。\n			', '\n《尉缭子·武议》：“一人之兵，如狼似虎，如风如雨，如雷如霆，震震冥冥，天下皆惊。”\n			', '\n只听得高声大语，开门看～。（元·杨显之《潇湘雨》第四折）\n			'),
(1675, '0:3:2', '如狼如虎', '\n【 rú　láng　sì　hǔ 】\n			', '\n形容勇猛、猛烈。\n			', '\n《尉缭子·武议》：“一人之兵，如狼如虎，如风如雨，如雷如霆，震震冥冥，天下皆惊。”\n			', '\n文忠凛然端坐，价前～的将官，排列两行，就如追魂夺魄的一般，甚是畏惧。\n			'),
(1676, '0:3:2', '如龙似虎', '\n【 rú　lóng　sì　hǔ 】\n			', '\n形容勇猛有活力。\n			', '\n明·方汝浩《禅真逸史》第三十九回：“云气变幻无穷，倏忽如龙似虎。人情世态，大率相同。”\n			', '\n马上的将官，纵～，马倒了，都倒栽葱跌将下来。\n			'),
(1677, '0:3:2', '人中龙虎', '\n【 rén　zhōng　lóng　hǔ 】\n			', '\n比喻人中豪杰。\n			', '\n《晋书·宋纤传》：“吾而今而后知先生人中之龙也。”\n			', '\n不枉了女中丈夫，～。\n			'),
(1678, '0:3:2', '势成骑虎', '\n【 shì　chéng　qí　hǔ 】\n			', '\n骑在老虎背上，要下来不能下来。比喻事情中途遇到困难，但迫于形势，想停止也停止不了。\n			', '\n唐·李白《留别广陵诸公》诗：“骑虎不敢下，攀龙忽堕天。”\n			', '\n暂无\n			'),
(1679, '0:3:2', '三夫成市虎', '\n【 sān　fū　chéng　shì　hǔ 】\n			', '\n比喻说的人多了，就能使人们把谣言当事实。同“三人成虎”。\n			', '\n《宋书·乐志三》：“三夫成市虎，慈母投杼趋。”\n			', '\n暂无\n			'),
(1680, '0:3:2', '豕虎传讹', '\n【 shǐ　hǔ　chuán　é 】\n			', '\n指书籍传写或刊印中的文字错误。同“豕亥鱼鲁”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1681, '0:3:2', '身寄虎吻', '\n【 shēn　jì　hǔ　wěn 】\n			', '\n指把身子置于老虎嘴边。比喻处境极其危险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1682, '0:3:2', '生龙活虎', '\n【 shēng　lóng　huó　hǔ 】\n			', '\n形容活泼矫健，富有生气。\n			', '\n清·吴趼人《痛史》第五回：“城外元兵虽多，却被张世杰一马在前，宗仁、宗义在后，如生龙活虎一般，杀入阵去。”\n			', '\n暂无\n			'),
(1683, '0:3:2', '三人成虎', '\n【 sān　rén　chéng　hǔ 】\n			', '\n三个人谎报城市里有老虎，听的人就信以为真。比喻说的人多了，就能使人们把谣言当事实。\n			', '\n《战国策·魏策二》：“夫市之无虎明矣，然而三人言而成虎。”\n			', '\n暂无\n			'),
(1684, '0:3:2', '山上无老虎，猴子称大王', '\n【 shān　shàng　wú　lǎo　hǔ，hóu　zǐ　chēng　 】\n			', '\n俗语，比喻没有能人，普通人物亦充当主要角色。\n			', '\n《晚清文学丛钞·冷眼观》第十四回：“靠著老子做过上海道，在城里面山上无老虎，猴子称大王弄惯了的脾气，陪著朋友来吃台把酒，就像是连四块下脚钱都是冤枉花的。”\n			', '\n暂无\n			'),
(1685, '0:3:2', '三言讹虎', '\n【 sān　yán　é　hǔ 】\n			', '\n犹三人成虎。比喻说的人多了，就能使人们把谣言当事实。\n			', '\n清·秋瑾《致琴文书》：“况三言讹虎，众口铄金；因积毁销骨，致他方糊口。”\n			', '\n暂无\n			'),
(1686, '0:3:2', '投畀豺虎', '\n【 tóu　bì　chái　hǔ 】\n			', '\n畀：给与。原指那种好搬弄是非的人，要把他扔出去喂豺狼虎豹。形容人民群众对坏人的愤恨。\n			', '\n《诗经·小雅·巷伯》：“取彼谮人，投畀豺虎。”\n			', '\n况且，未能将坏人“～”于生前，当然也只好口诛笔伐之于后身。（鲁迅《华盖集续编·有趣的消息》）\n			'),
(1687, '0:3:2', '谈虎色变', '\n【 tán　hǔ　sè　biàn 】\n			', '\n色：脸色。原指被老虎咬过的人才真正知道虎的厉害。后比喻一提到自己害怕的事就情绪紧张起来。\n			', '\n《二程全书·遗书二上》：“真知与常知异。尝见一田夫曾被虎伤，有人说虎伤人，众莫不惊，独田夫色动异于众。”\n			', '\n有光生长穷乡，～，安能默然而已。（明·归有光《论三区赋役水利书》）\n			'),
(1688, '0:3:2', '畏敌如虎', '\n【 wèi　dí　rú　hǔ 】\n			', '\n害怕敌人如同怕虎一般。\n			', '\n<span class="C999">暂无</span>\n			', '\n领导者们～，处处设防，节节抵御。（毛泽东《中国革命战争的战略问题》）\n			'),
(1689, '0:3:2', '卧虎藏龙', '\n【 wò　hǔ　cáng　lóng 】\n			', '\n指隐藏着未被发现的人才，也指隐藏不露的人才。\n			', '\n北周·庾信《同会河阳公新造山地聊得寓目》诗：“暗石疑藏虎，盘根似卧龙。”\n			', '\n这所大学～，人才济济。\n			'),
(1690, '0:3:2', '为虎傅翼', '\n【 wèi　hǔ　fù　yì 】\n			', '\n傅：通“附”；翼：翅膀。替老虎加上翅膀。比喻帮助坏人，增加恶人的势力。\n			', '\n《逸周书·寤敬篇》：“毋为虎傅翼，将飞入邑，择人而食之。”《淮南子·兵略训》：“今乘万民之力而反为残贼，是为虎傅翼，曷为弗除。”《韩非子·难势》：“毋为虎傅翼，将飞入邑，择人而食之\n			', '\n暂无\n			'),
(1691, '0:3:2', '为虎添翼', '\n【 wèi　hǔ　tiān　yì 】\n			', '\n替老虎加上翅膀。比喻帮助坏人，增加恶人的势力。\n			', '\n《逸周书·寤敬篇》：“毋为虎傅翼，将飞入邑，择人而食之。”《淮南子·兵略训》：“今乘万民之力而反为残贼，是为虎傅翼，曷为弗除。”《韩非子·难势》：“毋为虎傅翼，将飞入邑，择人而食之\n			', '\n暂无\n			'),
(1692, '0:3:2', '为虎作伥', '\n【 wèi　hǔ　zuò　chāng 】\n			', '\n伥：伥鬼，古时传说被老虎吃掉的人，死后变成伥鬼，专门引诱人来给老虎吃。替老虎做伥鬼。比喻充当恶人的帮凶。\n			', '\n《太平广记》卷四百三十：“伥鬼，被虎所食之人也，为虎前呵道耳。”宋·孙光宪《北梦琐言逸文》卷四：“凡死于虎，溺于水之鬼号为伥，须得一人代之。”\n			', '\n为着要得虎子而身入虎穴，决不是身入虎穴去～。（郭沫若《〈闻一多全集〉序》）\n			'),
(1693, '0:3:2', '委肉虎蹊', '\n【 wěi　ròu　hǔ　xī 】\n			', '\n委：抛弃；蹊：小路。把肉丢在饿虎经过的路上。比喻处境危险，灾祸即将到来。\n			', '\n《战国策·燕策三》：“是以委肉当饿虎之蹊，祸必不振矣。”\n			', '\n暂无\n			'),
(1694, '0:3:2', '握蛇骑虎', '\n【 wò　shé　qí　hǔ 】\n			', '\n比喻处境极险恶。\n			', '\n《魏书·彭城王传》：“彦和手握蛇骑虎，不觉艰难。”\n			', '\n暂无\n			'),
(1695, '0:3:2', '绣虎雕龙', '\n【 xiù　hǔ　diāo　lóng 】\n			', '\n比喻文章的辞藻华丽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1696, '0:3:2', '柙虎樊熊', '\n【 xiá　hǔ　fán　xióng 】\n			', '\n柙中的虎，樊内的熊。比喻被囚的恶人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1697, '0:3:2', '熊据虎跱', '\n【 xióng　jù　hǔ　shēn 】\n			', '\n比喻群雄割据的形势。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1698, '0:3:2', '笑面虎', '\n【 xiào　miàn　hǔ 】\n			', '\n比喻外表善良，心地凶狠的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1699, '0:3:2', '舄乌虎帝', '\n【 xì　wū　hǔ　dì 】\n			', '\n因“舄”与“乌”、“虎”和“帝”字形相近，同经传抄，容易写错。指文字抄传错误。\n			', '\n《埤雅》：“舄九写而为乌，虎三写而为帝，言书之转易如此。”\n			', '\n暂无\n			'),
(1700, '0:3:2', '熊腰虎背', '\n【 xióng　yāo　hǔ　bèi 】\n			', '\n腰粗壮如熊，背宽厚如虎。形容人身体魁梧健壮。\n			', '\n元·无名氏《飞刀对箭》：“这厮倒是一条好汉，狗背驴腰的，哦，是虎背熊腰。”\n			', '\n视之，身长九尺，面黑睛黄，～。\n			'),
(1701, '0:3:2', '燕额虎头', '\n【 yàn　é　hǔ　tóu 】\n			', '\n形容相貌威武。借指武将、勇士。同“燕颔虎头”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1702, '0:3:2', '一虎不河', '\n【 yī　hǔ　bù　hé 】\n			', '\n原指空手搏虎，徒步渡河，比喻有勇无谋，冒险行事。后在元剧中比喻不顾一切。\n			', '\n《诗·小雅·小旻》：“不敢暴虎，不敢冯河。”《论语·述而》：“暴虎冯河，死而无悔者，吾不与也。必也临事而惧，好谋而成者也。”\n			', '\n暂无\n			'),
(1703, '0:3:2', '燕颔虎颈', '\n【 yàn　hàn　hǔ　jǐng 】\n			', '\n颔：下巴颏。旧时形容王侯的贵相或武将相貌的威武。\n			', '\n《后汉书·班超传》：“超问其状，相者指曰：‘生燕颔虎颈，飞而食肉，此万里侯相也。’”\n			', '\n暂无\n			'),
(1704, '0:3:2', '燕颔虎头', '\n【 yàn　hàn　hǔ　tóu 】\n			', '\n形容相貌威武。借指武将、勇士。\n			', '\n清·褚人获《隋唐演义》第四回：“轩轩云霞气色，凛凛霜雪威棱。熊腰虎背势嶙纈，燕颔虎头雄俊。”\n			', '\n暂无\n			'),
(1705, '0:3:2', '燕颔虎须', '\n【 yàn　hàn　hǔ　xū 】\n			', '\n形容相貌威武。\n			', '\n《三国演义》第一回：“玄德回视其人：身长八尺，豹头环眼，燕颔虎须，声若巨雷，势如奔马。”\n			', '\n那官人生的豹头环眼，～，八尺长短身材，三十四五年纪。\n			'),
(1706, '0:3:2', '引虎拒狼', '\n【 yǐn　hǔ　jù　láng 】\n			', '\n比喻引进另一种恶势力来抗拒原来的恶势力，其祸患将更甚。亦作“引狼拒虎”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1707, '0:3:2', '养虎留患', '\n【 yǎng　hǔ　liú　huàn 】\n			', '\n比喻纵容敌人，自留后患。同“养虎自遗患”。\n			', '\n《东周列国志》第五六回：“今其子乃欲见逐，岂非养虎留患耶？”\n			', '\n暂无\n			'),
(1708, '0:3:2', '与虎谋皮', '\n【 yǔ　hǔ　móu　pí 】\n			', '\n跟老虎商量要它的皮。比喻跟恶人商量要他放弃自己的利益，绝对办不到。\n			', '\n《太平御览》卷二０八引《符子》：“欲为千金之裘而与狐谋其皮，欲具少牢之珍而与羊谋其羞，言未卒，狐相率逃于重丘之下，羊相呼藏于深林之中。”\n			', '\n暂无\n			'),
(1709, '0:3:2', '引虎入室', '\n【 yǐn　hǔ　rù　shì 】\n			', '\n犹言引狼入室。比喻把坏人或敌人引入内部。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1710, '0:3:2', '养虎伤身', '\n【 yǎng　hǔ　shāng　shēn 】\n			', '\n饲养老虎，自伤其身。比喻纵敌留患。\n			', '\n明·沈采《千金记·入关》：“大王，你只宜乘早击之，若迟便有养虎伤身之害矣。”\n			', '\n?柞听了，大叫道：‘罢了，罢了！此乃～也！’\n			'),
(1711, '0:3:2', '与虎添翼', '\n【 yǔ　hǔ　tiān　yì 】\n			', '\n翼：翅膀。替老虎加上翅膀。比喻帮助坏人，增加恶人的势力。\n			', '\n《逸周书·寤敬篇》：“毋为虎傅翼，将飞入邑，择人而食之。”《淮南子·兵略训》：“今乘万民之力而反为残贼，是为虎傅翼，曷为弗除。”\n			', '\n若纵之使之归袁绍，是～也。（明·罗贯中《三国演义》第二十七回）\n			'),
(1712, '0:3:2', '养虎为患', '\n【 yǎng　hǔ　wéi　huàn 】\n			', '\n比喻纵容敌人，留下后患，自己反受其害。\n			', '\n<span class="C999">暂无</span>\n			', '\n这个人很不可靠，你却给与高位，怕会～哩。\n			'),
(1713, '0:3:2', '杨虎围匡', '\n【 yáng　hǔ　wéi　kuāng 】\n			', '\n杨，通“阳”。指因貌似而产生误会。\n			', '\n《史记·孔子世家》：“扞孔子呴将适陈，过匡……匡人闻之，以为鲁之阳虎。阳虎尝暴匡人，匡人于是遂止孔子。孔子状类阳虎，拘焉五日。”\n			', '\n暂无\n			'),
(1714, '0:3:2', '养虎遗患', '\n【 yǎng　hǔ　yí　huàn 】\n			', '\n遗：留下；患：祸患。留着老虎不除掉，就会成为后患。比喻纵容坏人坏事，留下后患。\n			', '\n《史记·项羽本纪》：“楚兵罢食尽，此天亡楚之时也，不如因其机而遂取之。今释弗击，此所谓养虎遗患也。”\n			', '\n他非常恨陕西地方文武大员的糊涂无用，竟敢长期不明“贼情”，～。（姚雪垠《李自成》第一卷第三十二章）\n			'),
(1715, '0:3:2', '养虎贻患', '\n【 yǎng　hǔ　yí　huàn 】\n			', '\n比喻纵容敌人，自留后患。同“养虎自遗患”。\n			', '\n明·张居正《答宣大巡抚计处黄把二虏》：“此所谓引贼入家，养虎贻患，是何等计策乎？”\n			', '\n与其～，还不如——算了。\n			'),
(1716, '0:3:2', '养虎自毙', '\n【 yǎng　hǔ　zì　bì 】\n			', '\n比喻纵容敌人而自受其害。同“养虎自啮”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1717, '0:3:2', '养虎自残', '\n【 yǎng　hǔ　zì　cán 】\n			', '\n比喻纵容敌人而自受其害。同“养虎自啮”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1718, '0:3:2', '养虎自啮', '\n【 yǎng　hǔ　zì　niè 】\n			', '\n啮：咬。养老虎，咬伤自己。比喻纵容敌人而自受其害。\n			', '\n《洛阳伽蓝记·建中寺》：“养虎自啮，长虺成蛇。”\n			', '\n暂无\n			'),
(1719, '0:3:2', '养虎自齧', '\n【 yǎng　hǔ　zì　niè 】\n			', '\n比喻姑息敌人，终致损害自己。齧，同“啮”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1720, '0:3:2', '引虎自卫', '\n【 yǐn　hǔ　zì　wèi 】\n			', '\n引：招引。引来老虎，保卫自己。比喻企图依仗恶人，结果反受其害。\n			', '\n明·罗贯中《三国演义》第六十三回：“严颜在巴郡，闻刘璋法正请玄德入川，拊心而叹曰：‘此所谓独坐穷山，引虎自卫者也！’”\n			', '\n暂无\n			'),
(1721, '0:3:2', '养虎自贻灾', '\n【 yǎng　hǔ　zì　yí　zāi 】\n			', '\n比喻纵容敌人，自留后患。同“养虎自遗患”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1722, '0:3:2', '养虎自遗患', '\n【 yǎng　hǔ　zì　yí　huàn 】\n			', '\n比喻纵容敌人，自留后患。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1723, '0:3:2', '鱼鲁帝虎', '\n【 yú　lǔ　dì　hǔ 】\n			', '\n指将鱼误写作鲁，帝误写作虎。泛指文字错讹。\n			', '\n清·金桌《〈南海百咏〉跋》：“余家向有钞本，承讹踵谬，不无鱼鲁帝虎之失，恨不能一一订正之。”\n			', '\n暂无\n			'),
(1724, '0:3:2', '云龙风虎', '\n【 yún　lóng　fēng　hǔ 】\n			', '\n虎啸生风，龙起生云。指同类的事物相感应。\n			', '\n《周易·乾》：“云从龙，风从虎，圣人作而万物睹。”\n			', '\n暂无\n			'),
(1725, '0:3:2', '鹰瞵虎攫', '\n【 yīng　lín　hǔ　jué 】\n			', '\n形容心怀不善，伺机攫取。同“鹰瞵虎视”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1726, '0:3:2', '羊落虎口', '\n【 yáng　luò　hǔ　kǒu 】\n			', '\n比喻处于险境，有死无生。\n			', '\n元·朱凯《昊天塔》第一折：“俺家姓杨，被番兵陷在虎口交牙峪里。这个叫做羊落虎口，正犯了兵家所忌。”\n			', '\n暂无\n			'),
(1727, '0:3:2', '鹰瞵虎视', '\n【 yīng　lín　hǔ　shì 】\n			', '\n像鹰和虎一样凶狠贪婪地注视着。形容心怀不善，伺机攫取。\n			', '\n梁启超《论私德》二：“俄罗斯政府，以鹰瞵虎视之势，震慑五陆，而其人民称罪恶之府，黑暗无复天日，（日本人有《露西亚亡国论》，穷形尽相。）亦生计沈窘之影响也。”\n			', '\n暂无\n			'),
(1728, '0:3:2', '引狼拒虎', '\n【 yǐn　láng　jù　hǔ 】\n			', '\n比喻引进另一种恶势力来抗拒原来的恶势力，其祸患将更甚。同“引虎拒狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1729, '0:3:2', '以肉啖虎', '\n【 yǐ　ròu　dàn　hǔ 】\n			', '\n比喻白白地送死。同“以肉喂虎”。\n			', '\n明·李贽《史纲评要·周纪·赧王》：“以揽权要秦王，正如以肉啖虎耳。”\n			', '\n暂无\n			'),
(1730, '0:3:2', '羊入虎群', '\n【 yáng　rù　hǔ　qún 】\n			', '\n比喻好人落入坏人的手中，处境极端危险。\n			', '\n清·蒲松龄《聊斋志异·邵九娘》：“窃意羊入虎群，狼藉已不堪矣。”\n			', '\n暂无\n			'),
(1731, '0:3:2', '以肉餧虎', '\n【 yǐ　ròu　sì　hǔ 】\n			', '\n比喻白白地送死。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1732, '0:3:2', '以肉喂虎', '\n【 yǐ　ròu　wèi　hǔ 】\n			', '\n比喻白白地送死。\n			', '\n汉·荀悦《汉纪·高祖纪一》：“今赴秦军，如以肉喂虎，当何益也！”\n			', '\n时当（邓当）职吏以蒙年小轻之，曰：‘彼竖子何能为？此欲～耳！’\n			'),
(1733, '0:3:2', '一山不藏二虎', '\n【 yī　shān　bù　cáng　èr　hǔ 】\n			', '\n比喻两人不能相容。\n			', '\n欧阳山《三家巷》：“他跟展公有点一山不藏二虎的味道，这是他太狂妄。”\n			', '\n暂无\n			'),
(1734, '0:3:2', '鹰视虎步', '\n【 yīng　shì　hǔ　bù 】\n			', '\n象鹰那样看东西，象老虎那样走路。形容为人阴险狠毒。\n			', '\n汉·赵晔《吴越春秋·阖闾内传》：“吾观喜之为人鹰视虎步，专功杀之性，不可亲也。”\n			', '\n暂无\n			'),
(1735, '0:3:2', '鹰扬虎视', '\n【 yīng　yáng　hǔ　shì 】\n			', '\n象鹰那样飞翔，如虎一般雄视。形容十分威武。\n			', '\n《诗经·大雅·大明》：“维师尚父，时维鹰扬。”《周易·颐》：“虎视耽耽，其欲逐逐。”三国魏·应璩《与侍郎曹长思书》：“王肃以宿德显授，何曾以后进见拔，皆鹰扬虎视，有万里之望。”\n			', '\n暂无\n			'),
(1736, '0:3:2', '鹰扬虎噬', '\n【 yīng　yáng　hǔ　shì 】\n			', '\n如鹰飞扬，似虎噬咬。形容耀武扬威，穷凶极恶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1737, '0:3:2', '羊质虎皮', '\n【 yáng　zhì　hǔ　pí 】\n			', '\n质：本性。羊虽然披上虎皮，还是见到草就喜欢，碰到豺狼就怕得发抖，它的本性没有变。比喻外表装作强大而实际上很胆小。\n			', '\n汉·扬雄《法言·吾子》：“羊质而虎皮，见草而悦，见豺而战，忘其皮之虎矣。”\n			', '\n～功不就，凤毛鸡胆事难成。（明·罗贯中《三国演义》第三十二回）\n			'),
(1738, '0:3:2', '纵虎出匣', '\n【 zòng　hǔ　chū　xiá 】\n			', '\n放虎出笼。比喻放走强有力的敌人，贻患无穷。同“纵虎出柙”。\n			', '\n明·唐顺之《咨总督都御史胡牌》：“若乘月黑潮满之夜，驾船冲出港门，及扛船随处下海……是纵虎出匣，祸岂胜言。”\n			', '\n暂无\n			'),
(1739, '0:3:2', '纵虎出柙', '\n【 zòng　hǔ　chū　xiá 】\n			', '\n放虎出笼。比喻放走强有力的敌人，贻患无穷。\n			', '\n《续资治通鉴·元泰定帝泰定元年》：“辽王托克托，乘国有隙，诛屠骨肉……如令归藩，臂之纵虎出柙。”\n			', '\n禄贞武烈过人，倘资之兵使去，是～也，一旦有变，不可复絷矣。\n			'),
(1740, '0:3:2', '纵虎归山', '\n【 zòng　hǔ　guī　shān 】\n			', '\n把老虎放回山去。比喻把坏人放回老巢，留下祸根。\n			', '\n晋·司马彪《零陵先贤传》：“璋遣法正迎刘备，巴谏曰：‘备，雄人也，入必为害，不可内也。’既入，巴复谏曰：‘若使备讨张鲁，是放虎于山林也。’璋不听。”\n			', '\n今刘备釜中之鱼，阱中之虎；若不就此时擒捉，如放鱼入海，～矣。（明·罗贯中《三国演义》第四十二回）\n			'),
(1741, '0:3:2', '捉虎擒蛟', '\n【 zhuō　hǔ　qín　jiāo 】\n			', '\n蛟：蛟龙。能上山捉老虎，下海擒蛟龙。比喻本领大。\n			', '\n明·无名氏《大劫牢》第三折：“捉虎擒蛟真壮士，好汉声名播四方。”\n			', '\n暂无\n			'),
(1742, '0:3:2', '众虎同心', '\n【 zhòng　hǔ　tóng　xīn 】\n			', '\n许多虎一条心做事。比喻众多有本事的人团结一致，力量会更大。\n			', '\n明·施耐庵《水浒传》第五十七回：“三山聚义打青州，众虎同心归水泊。”\n			', '\n暂无\n			'),
(1743, '0:3:2', '照猫画虎', '\n【 zhào　māo　huà　hǔ 】\n			', '\n比喻照着样子模仿。\n			', '\n<span class="C999">暂无</span>\n			', '\n这大相公聪明得很，他是～，一见即会套的人。（《歧路灯》第十一回）\n			'),
(1744, '0:3:2', '坐山观虎斗', '\n【 zuò　shān　guān　hǔ　dòu 】\n			', '\n比喻对双方的斗争采取旁观的态度，等到双方都受到损伤，再从中捞取好处。\n			', '\n《史记·张仪列传》：“两虎方且食牛，食甘必争，斗则大者伤、小者死；从伤而刺之，一举必有双虎之名。”\n			', '\n同学之间发生争执时，我们要耐心劝解，决不能～。\n			'),
(1745, '0:3:3', '白兔赤乌', '\n【 bái　tù　chì　wū 】\n			', '\n月亮和太阳的代称。多借指时间。\n			', '\n唐·白居易《劝酒》诗：“天地迢迢自长久，白兔赤乌相趁走。”\n			', '\n暂无\n			'),
(1746, '0:3:3', '东门逐兔', '\n【 dōng　mén　zhú　tù 】\n			', '\n用以作为为官遭祸，抽身悔迟之典。同“东门黄犬”。\n			', '\n《史记·李斯列传》载：秦二世二年七月，丞相李斯因遭奸人诬陷，论腰斩咸阳市。临刑谓其中子曰：“吾欲与若复牵黄犬俱出上蔡东门逐狡兔，岂可得乎！”\n			', '\n南海骑麟真漫浪，～枉悲酸。\n			'),
(1747, '0:3:3', '动如脱兔', '\n【 dòng　rú　tuō　tù 】\n			', '\n比喻行动敏捷。\n			', '\n《孙子·九地》：“是故始如处女，敌人开户；后如脱兔，敌不及拒。”\n			', '\n暂无\n			'),
(1748, '0:3:3', '待兔守株', '\n【 dài　tù　shǒu　zhū 】\n			', '\n比喻墨守成规不知变通或妄想不劳而获，坐享其成。同“守株待兔”\n			', '\n宋·张君房《\n			', '\n暂无\n			'),
(1749, '0:3:3', '得兔忘蹄', '\n【 dé　tù　wàng　tí 】\n			', '\n犹言得鱼忘荃。蹄，兔罝。\n			', '\n语出《庄子·外物》：“蹄者所以在兔，得兔而忘蹄。”\n			', '\n后之贤者，有如以水投水者乎？有如～者乎？\n			'),
(1750, '0:3:3', '东兔西乌', '\n【 dōng　tù　xī　wū 】\n			', '\n兔、乌：古代神话传说中说，月亮里有玉兔，太阳里有三足金乌，所以用乌、兔代表日月。月亮东升，太阳西落。表示时光不断流逝。\n			', '\n宋·吴潜《瑞鹤仙》：“愁高怅远。身世事，但难准。况禁他，东兔西乌相逐，古古今今不问。”\n			', '\n暂无\n			'),
(1751, '0:3:3', '龟毛兔角', '\n【 guī　máo　tù　jiǎo 】\n			', '\n乌龟身上生毛，兔子头上长角。比喻不可能存在或有名无实的东西。\n			', '\n晋·干宝《搜神记》卷六：“商纣之时，大龟生毛兔生角，兵甲将兴之象也。”\n			', '\n～，岂是有邪？（宋·释普济《五灯会元》卷五）\n			'),
(1752, '0:3:3', '狐死兔泣', '\n【 hú　sǐ　tù　qì 】\n			', '\n比喻因同类的死亡而感到悲伤。\n			', '\n《宋史·李全传》：“狐死兔泣，李氏灭，夏氏宁得独存？”\n			', '\n暂无\n			'),
(1753, '0:3:3', '获兔烹狗', '\n【 huò　tù　pēng　gǒu 】\n			', '\n比喻事成之后排斥以至杀害有功之臣。亦作“狡兔死，良狗烹”。\n			', '\n梁启超《论中国之将强》：“南洋一带，敬微华人，必不有今日。今虽获兔烹狗，得鱼忘筌……然筚路蓝缕之功，在公论者，终不没于天下。\n			', '\n暂无\n			'),
(1754, '0:3:3', '狐兔之悲', '\n【 hú　tù　zhī　bēi 】\n			', '\n狐死则兔悲，兔死则狐亦悲。比喻因同类的死亡而感到痛心悲伤。\n			', '\n明·朱国桢《涌幢小品·黄叔度二诬辨》：“因视国家将倾，诸贤就戮，上之不能如孙登之污埋，次之不能如皇甫规之不与，下之不能兴狐兔之悲，方且沾沾自喜，因同志之死以为名高，是诚何忍哉。”\n			', '\n暂无\n			'),
(1755, '0:3:3', '静如处女，动如脱兔', '\n【 jìng　rú　chǔ　nǚ，dòng　rú　tuō　tù 】\n			', '\n处女：未嫁的女子；脱兔：逃跑的兔子。指军队未行动时象未出嫁的姑娘那样持重；一行动就象飞跑的兔子那样敏捷。\n			', '\n《孙子·九地》：“是故始如处女，敌人开户；后如脱兔，敌不及拒。”\n			', '\n暂无\n			'),
(1756, '0:3:3', '静若处子，动若脱兔', '\n【 jìng　ruò　chǔ　zǐ，dòng　ruò　tuō　tù 】\n			', '\n指军队未行动时就像未出嫁的女子那样沉静，一行动就像逃脱的兔子那样敏捷。\n			', '\n孙武《孙子·九地》：“是故始如处女，敌人开户；后如脱兔，敌不及拒。”\n			', '\n古人说‘～’，也是不动的时候要像大姑娘深藏闺中，动起来像脱网的兔子那么快。\n			'),
(1757, '0:3:3', '见兔放鹰', '\n【 jiàn　tù　fàng　yīng 】\n			', '\n看到野兔，立即放出猎鹰追捕。比喻行动及时，适合需要。\n			', '\n宋·释普济《五灯会元》：“布大教网，漉人天鱼，不如见兔放鹰，遇獐发箭。”\n			', '\n当今世情，何人不趋炎附势，～，谁肯结交穷秀才。（明·天然痴叟《石点头·侯官县烈女歼仇》）\n			'),
(1758, '0:3:3', '见兔顾犬', '\n【 jiàn　tù　gù　quǎn 】\n			', '\n看到了兔子，再回头叫唤猎狗去追捕。比喻动作虽稍迟，但赶紧想办法，还来得及。\n			', '\n《战国策·楚策四》：“见兔而顾犬，未为晚也。”\n			', '\n暂无\n			'),
(1759, '0:3:3', '狡兔死，良狗烹', '\n【 jiǎo　tù　sǐ，liáng　gǒu　pēng 】\n			', '\n烹：烧煮。兔子死了，猎狗就被人烹食。比喻给统治者效劳的人事成后被抛弃或杀掉。\n			', '\n《韩非子·内储说左下》：“狡兔尽则良犬烹，敌国灭则谋臣亡。”《史记·越王勾践世家》：“飞鸟尽，良弓藏；狡兔死，走狗烹。”\n			', '\n暂无\n			'),
(1760, '0:3:3', '狡兔三窟', '\n【 jiǎo　tù　sān　kū 】\n			', '\n狡猾的兔子准备好几个藏身的窝。比喻隐蔽的地方或方法多。\n			', '\n《战国策·齐策四》：“狡兔有三窟，仅得兔其死耳。”\n			', '\n见柴曰：“汝～，何归为？”（清·蒲松龄《聊斋志异·邵九娘》）\n			'),
(1761, '0:3:3', '狡兔死，良犬烹', '\n【 jiǎo　tù　sǐ，liáng　quǎn　pēng 】\n			', '\n比喻给统治者效劳的人事成后被抛弃或杀掉。同“狡兔死，良狗烹”。\n			', '\n《东周列国志》第八三回：“吾闻‘狡兔死而良犬烹’。敌国如灭，谋臣必亡。”\n			', '\n暂无\n			'),
(1762, '0:3:3', '狡兔三穴', '\n【 jiǎo　tù　sān　xué 】\n			', '\n比喻隐蔽的地方或方法多。同“狡兔三窟”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1763, '0:3:3', '惊猿脱兔', '\n【 jīng　yuán　tuō　tù 】\n			', '\n如受惊的猿猴、脱逃的兔子。形容迅速奔逃。\n			', '\n清·吴敬梓《儒林外史》第四十三回：“还亏得苗子的脚底板厚，不怕巉岩荆棘，就如惊猿脱兔，漫山越岭的逃散了。”\n			', '\n暂无\n			'),
(1764, '0:3:3', '狼奔兔脱', '\n【 láng　bēn　tù　tuō 】\n			', '\n形容仓皇逃窜。\n			', '\n《冷眼观》第四回：“远远听见吆喝之声，由远而近……众人手忙脚乱，将桌上杯盘收拾干净，转眼间，狼奔兔脱，如鸟兽散去。”\n			', '\n暂无\n			'),
(1765, '0:3:3', '目兔顾犬', '\n【 mù　tù　gù　quǎn 】\n			', '\n看见兔子而呼猎犬。比喻及时补救。\n			', '\n语出《战国策·楚策四》：“见兔而顾犬，未为晚也。”\n			', '\n暂无\n			'),
(1766, '0:3:3', '犬兔俱毙', '\n【 quān　tù　jǜ　bì 】\n			', '\n比喻双方同归于尽。\n			', '\n《战国策·齐策三》：“韩子卢者，天下之疾犬也；东郭逡者，海内之狡兔也。韩子卢逐东郭逡，环山者三，腾山者五，兔极于前，犬废于后，犬兔俱罢，各死其处。田父见之，无劳倦之苦而擅其功。”\n			', '\n暂无\n			'),
(1767, '0:3:3', '势若脱兔', '\n【 shì　ruò　tuō　tù 】\n			', '\n势：攻势。脱：脱逃。对敌人攻击的速度极快，就像脱逃的兔子奔跑那样。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1768, '0:3:3', '守如处女，出如脱兔', '\n【 shǒu　rú　chǔ　nǚ，chū　rú　tuō　tù 】\n			', '\n处女：未嫁的女子；脱兔：逃跑的兔子。指军队未行动时象未出嫁的姑娘那样持重；一行动就象飞跑的兔子那样敏捷。\n			', '\n《孙子·九地》：“是故始如处女，敌人开户；后如脱兔，敌不及拒。”\n			', '\n这倒不是道家法术，倒是用兵最精的所谓“～”，“出其不备”的妙策。（清·曹雪芹《红楼梦》第七十三回）\n			'),
(1769, '0:3:3', '狮象搏兔，皆用全力', '\n【 shī　xiàng　bó　tù，jiē　yòng　quán　lì 】\n			', '\n比喻对小事情也拿出全部力量认真对付。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1770, '0:3:3', '狮子搏兔，亦用全力', '\n【 shī　zǐ　bó　tù，yì　yòng　quán　lì 】\n			', '\n比喻对小事情也拿出全部力量认真对付。同“狮象搏兔，皆用全力”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1771, '0:3:3', '守株待兔', '\n【 shǒu　zhū　dài　tù 】\n			', '\n株：露出地面的树根。原比喻希图不经过努力而得到成功的侥幸心理。现也比喻死守狭隘经验，不知变通。\n			', '\n《韩非子·五蠹》记载：战国时宋国有一个农民，看见一只兔子撞在树根上死了，便放下锄头在树根旁等待，希望再得到撞死的兔子。\n			', '\n吾料兄必定出身报国，岂是～之辈。（明·许仲琳《封神演义》第九十四回）\n			'),
(1772, '0:3:3', '兔角龟毛', '\n【 tu　jiao　gui　mao 】\n			', '\n兔生角，龟长毛。都是没有的事。比喻有名无实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1773, '0:3:3', '兔角牛翼', '\n【 tù　jiǎo　niú　yì 】\n			', '\n兔不生角，牛不长翼，故以之比喻不合情理之事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1774, '0:3:3', '兔葵燕麦', '\n【 tù　kuí　yàn　mài 】\n			', '\n形容景象荒凉。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1775, '0:3:3', '兔起凫举', '\n【 tǔ　qǐ　fú　jǔ 】\n			', '\n凫：野鸭。象兔敢奔跑，象野鸭急飞。比喻行动迅速。\n			', '\n《吕氏春秋·论威》：“知其不可久处，则知所兔起凫举，死惛之地矣。”\n			', '\n暂无\n			'),
(1776, '0:3:3', '兔起鹘落', '\n【 tù　qǐ　hú　luò 】\n			', '\n鹘：打猎用的鹰一类的猛禽。兔子刚跳起来，鹘就飞扑下去。比喻动作敏捷。也比喻绘画或写文章迅捷流畅。\n			', '\n宋·苏轼《文与可画云当谷偃竹记》：“振笔直遂，以追其所见，如兔起鹘落，少纵即逝矣。”\n			', '\n此事如～，少纵即逝，此媪亦捷疾若神矣。（清·纪昀《阅微草堂笔记》卷十）\n			'),
(1777, '0:3:3', '兔起乌沉', '\n【 tù　qǐ　wū　chén 】\n			', '\n指月出日落。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1778, '0:3:3', '兔缺乌沉', '\n【 tù　quē　wū　chén 】\n			', '\n犹兔走乌飞。形容光阴迅速流逝。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1779, '0:3:3', '兔死凫举', '\n【 tǔ　sǐ　fú　jǔ 】\n			', '\n象兔敢奔跑，象野鸭急飞。比喻行动迅速。\n			', '\n《吕氏春秋·论威》：“知其不可久处，则知所兔起凫举，死 之地矣。”\n			', '\n暂无\n			'),
(1780, '0:3:3', '兔死狗烹', '\n【 tù　sǐ　gǒu　pēng 】\n			', '\n烹：烧煮。兔子死了，猎狗就被人烹食。比喻给统治者效劳的人事成后被抛弃或杀掉。\n			', '\n《史记·越王勾践世家》：“飞鸟尽，良弓藏；狡兔死，走狗烹。”\n			', '\n大凡古来有识见的英雄功成名就，便拂袖而去，免使后来有“鸟尽弓藏，～”之祸。（清·陈忱《水浒后传》第九回）\n			'),
(1781, '0:3:3', '兔死狐悲', '\n【 tù　sǐ　hú　bēi 】\n			', '\n兔子死了，狐狸感到悲伤。比喻因同类的死亡而感到悲伤。\n			', '\n《宋史·李全传》：“狐死兔泣，李氏灭，夏氏宁独存？”元·无名氏《赚蒯通》第四折：“今日油烹蒯彻，正所谓兔死狐悲，芝焚蕙叹。”\n			', '\n鼋鸣而鳖应，兔死则狐悲。（明·田艺蘅《玉笑零音》）\n			'),
(1782, '0:3:3', '兔死犬饥', '\n【 tù　sǐ　quǎn　jī 】\n			', '\n比喻敌人灭亡后，功臣不受重用。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1783, '0:3:3', '兔丝燕麦', '\n【 tù　sī　yàn　mài 】\n			', '\n兔丝：菟丝子。菟丝不是丝，燕麦不是麦。比喻有名无实。\n			', '\n《魏书·李崇传》：“今国子虽有学官之名，而无教授之实，何异兔丝燕麦、南箕北斗哉？”\n			', '\n暂无\n			'),
(1784, '0:3:3', '兔头麞脑', '\n【 tù　tóu　suō　nǎo 】\n			', '\n形容人面貌猥琐。多形容坏人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1785, '0:3:3', '兔走鹘落', '\n【 tù　zǒu　gǔ　luò 】\n			', '\n比喻动作敏捷。也比喻绘画或写文章迅捷流畅。见“兔起鹘落”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1786, '0:3:3', '兔走乌飞', '\n【 tù　zǒu　wū　fēi 】\n			', '\n乌：古代传说日中有三足乌，故称太阳为金乌；兔：古代传说中月中有玉兔，故称月亮为玉兔。形容光阴迅速流逝。\n			', '\n唐·韩琮《春愁》诗：“金乌长飞玉兔走，青鬓长青古无有。”唐·韦庄《秋日早行》诗：“行人自是心如火，兔走乌飞不觉长。”\n			', '\n暂无\n			'),
(1787, '0:3:3', '乌踆兔走', '\n【 wū　cún　tù　zǒu 】\n			', '\n指日月运行。兔，传说中的月中玉兔。借指月亮。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1788, '0:3:3', '乌飞兔走', '\n【 wū　fēi　tù　zǒu 】\n			', '\n乌：古代传说日中有三足乌，故称太阳为金乌；兔：古代传说中月中有玉兔，故称月亮为玉兔。形容光阴迅速流逝。\n			', '\n唐·韩琮《春愁》诗：“金乌长飞玉兔走，青鬓长青古无有。”唐·韦庄《秋日早行》诗：“行人自是心如火，兔走乌飞不觉长。”\n			', '\n～，瞬息光阴，暑往寒来，不觉七载。（明·许仲琳《封神演义》第十二回）\n			'),
(1789, '0:3:3', '一雕双兔', '\n【 yī　diāo　shuāng　tù 】\n			', '\n指三人并列显位，一人势盛而两人受其挟制。\n			', '\n唐李林甫、张九龄、裴耀卿并为相，李抑扬张、裴自得，张裴二人罄折卑逊，时人窃言“一雕挟两兔”。见唐郑处诲《明皇杂录》卷下及《新唐书·李林甫传》。\n			', '\n暂无\n			'),
(1790, '0:3:4', '笔底龙蛇', '\n【 bǐ　dǐ　lóng　shé 】\n			', '\n犹言笔走龙蛇。形容书法生动而有气势。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第三十一回：“闻公博学广记，笔底龙蛇，真才子也。”\n			', '\n暂无\n			'),
(1791, '0:3:4', '乘龙配凤', '\n【 chéng　lóng　pèi　fèng 】\n			', '\n比喻得佳偶，结良缘。\n			', '\n柳琴戏《状元打更》：“沈文素呀！沈文素！你蟾宫折桂，莫大还有乘龙配凤的好运么？”\n			', '\n暂无\n			'),
(1792, '0:3:4', '鼎成龙去', '\n【 dǐng　chéng　lóng　qù 】\n			', '\n指帝王去世。\n			', '\n《史记·封禅书》：“黄帝采首山铜，铸鼎於荆山下。鼎既成，有龙垂胡曈下迎黄帝。黄帝上骑，群臣后宫从上者七十馀人，龙乃上去。”\n			', '\n已被昭阳人妒，更那堪、～。\n			'),
(1793, '0:3:4', '鼎成龙升', '\n【 dǐng　chéng　lóng　shēng 】\n			', '\n指帝王去世。同“鼎成龙去”。\n			', '\n明·郎瑛《七修类稿·国事一·象简龙衣联》：“高庙鼎成龙升之日，建文即位，成祖以燕王来，奔而不朝，盖以叔不拜侄也。”\n			', '\n暂无\n			'),
(1794, '0:3:4', '打凤牢龙', '\n【 dǎ　fèng　láo　lóng 】\n			', '\n比喻安排圈套使强有力的对手中计。\n			', '\n元·关汉卿《单刀会》第三折：“安排下打凤牢龙，准备着天罗地网，也不是待客筵席，则是个杀人、杀人的战场。”\n			', '\n暂无\n			'),
(1795, '0:3:4', '打虎牢龙', '\n【 dǎ　hǔ　láo　lóng 】\n			', '\n犹言打凤牢龙。比喻安排圈套使强有力的对手中计。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1796, '0:3:4', '鼎湖龙去', '\n【 dǐng　hú　lóng　qù 】\n			', '\n指帝王去世。同“鼎成龙去”。\n			', '\n唐·杜甫《骊山》诗：“鼎湖龙去远，银海雁飞深。”\n			', '\n～不复返，只有雁鹜飞茫茫。\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1797, '0:3:4', '大水冲了龙王庙', '\n【 dà　shuǐ　chōng　le　lóng　wáng　miào 】\n			', '\n比喻本是自己人，因不相识而相互发生了冲突争端。\n			', '\n清·文康《儿女英雄传》七回：“大水冲了龙王庙，一家人不认识一家人咧！”\n			', '\n暂无\n			'),
(1798, '0:3:4', '凤附龙攀', '\n【 fèng　fù　lóng　pān 】\n			', '\n指依附帝王权贵建功立业。\n			', '\n汉·扬雄《法言·渊骞》：“攀龙鳞，附凤翼。”\n			', '\n我明载兴，公值其际，～，风飞雷厉。\n			'),
(1799, '0:3:4', '附凤攀龙', '\n【 fù　fèng　pān　lóng 】\n			', '\n指巴结投靠有权势的人以获取富贵。\n			', '\n汉·扬雄《法言·渊骞》：“攀龙鳞，附凤翼。”\n			', '\n暂无\n			'),
(1800, '0:3:4', '凤骨龙姿', '\n【 fèng　gǔ　lóng　zī 】\n			', '\n形容超凡的体格和仪态。\n			', '\n《云笈七签》卷四：“今视子之质，实霄景高焕，圆精重照，凤骨龙姿，脑色宝曜。”\n			', '\n暂无\n			'),
(1801, '0:3:4', '凤狂龙躁', '\n【 fèng　kuáng　lóng　zào 】\n			', '\n形容心情烦躁，精神失常。\n			', '\n唐·韩偓《喜凉》诗：“炉炭烧人百疾生，凤狂龙躁减心情。”\n			', '\n海枯石烂愁仍在，～转多病。\n			'),
(1802, '0:3:4', '飞龙乘云', '\n【 fēi　lóng　chéng　yún 】\n			', '\n龙乘云而上天，比喻英雄豪杰乘时而得势。\n			', '\n战国·韩·韩非《韩非子·难势》：“飞龙乘云，腾蛇游雾……夫有云雾之势而能乘游之者，龙蛇之材美之也。”\n			', '\n这对他来说就像～一样。\n			'),
(1803, '0:3:4', '凤楼龙阙', '\n【 fèng　lóu　lóng　què 】\n			', '\n形容华美的宫阙楼台。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1804, '0:3:4', '飞龙在天', '\n【 fēi　lóng　zài　tiān 】\n			', '\n比喻帝王在位。\n			', '\n《周易·乾》：“九五，飞龙在天，利见大人。”孔颖达疏：“谓有圣德之人得居王位。”\n			', '\n～，方仰君临之德；流虹绕渚，宝开圣作之祥。\n			'),
(1805, '0:3:4', '凤毛龙甲', '\n【 fèng　máo　lóng　jiǎ 】\n			', '\n凤的羽毛，龙的鳞甲。比喻珍贵之物。\n			', '\n明·袁中道《石浦先生传》：“旧有传奇二种，置于笥中，为鼠子嚼坏，凤毛龙甲，竟不存于世。”\n			', '\n暂无\n			'),
(1806, '0:3:4', '凤髓龙肝', '\n【 fèng　suǐ　lóng　gān 】\n			', '\n比喻珍奇美味。\n			', '\n明·孙仁孺《东郭记·吾将瞷良人之所也》：“他故人情蔼，消受他凤髓龙肝；我寸舌应嚼坏，愧没归遗两女子。”\n			', '\n老孙五百年前大闹天宫时，吃老君丹、玉皇酒，王母桃，及～——那样东西我不曾吃过？\n			'),
(1807, '0:3:4', '凤舞龙飞', '\n【 fèng　wǔ　lóng　fēi 】\n			', '\n形容书法笔势有力，灵活舒展。\n			', '\n《儿女英雄传》第十回：“只这书法也写得这等凤舞龙飞，真令人拜服。”\n			', '\n暂无\n			'),
(1808, '0:3:4', '凤舞龙蟠', '\n【 fèng　wǔ　lóng　pán 】\n			', '\n凤凰飞舞，蛟龙盘曲。形容相配得当。\n			', '\n清·文康《儿女英雄传》第二十四回：“不想这一拜，恰恰的合成一个‘名花并蒂’，俨然是金厢玉琢，凤舞龙蟠！”\n			', '\n暂无\n			'),
(1809, '0:3:4', '凤箫龙管', '\n【 fèng　xiāo　lóng　guǎn 】\n			', '\n指笙箫一类管乐的吹奏声。\n			', '\n清·黄永《龙衣舟行》诗：“凤箫龙管穿云去，锦缆牙樯映日月。”\n			', '\n暂无\n			'),
(1810, '0:3:4', '凤臆龙鬐', '\n【 fèng　yì　lóng　qí 】\n			', '\n凤凰的胸脯，龙的颈毛。比喻骏马的雄奇健美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1811, '0:3:4', '凤翥龙蟠', '\n【 fèng　zhù　lóng　pán 】\n			', '\n像凤凰飞舞，蛟龙盘曲。比喻体势的飞扬劲建，回旋多姿。\n			', '\n《晋书·王羲之传论》：“观其点曳之工，裁成之妙，烟霏露结，状若断而还连；凤翥龙蟠，势如斜而反直。”\n			', '\n～势作环，浮青不断太行山。\n			'),
(1812, '0:3:4', '凤子龙孙', '\n【 fèng　zǐ　lóng　sūn 】\n			', '\n帝王或贵族的后代。\n			', '\n《二刻拍案惊奇》卷七：“真个是凤子龙孙，遭着不幸，流落到这个地位。”\n			', '\n暂无\n			'),
(1813, '0:3:4', '凤翥龙骧', '\n【 fèng　zhù　lóng　xiāng 】\n			', '\n形容奋发有为。\n			', '\n明·孙柚《琴心记·牛酒交欢》：“新筑沙堤行宰相，喜今朝凤翥龙骧，燕友逢春，莺朋出谷。”\n			', '\n暂无\n			'),
(1814, '0:3:4', '凤翥龙翔', '\n【 fèng　zhù　lóng　xiáng 】\n			', '\n翥：鸟向上飞；翔：盘旋飞翔。龙飞凤舞，形容气势非凡。\n			', '\n明·张居正《陵寝纪》：“山趋水会，凤翥龙翔，信乾坤之……”\n			', '\n美彼之态度兮，～。\n			'),
(1815, '0:3:4', '贯斗双龙', '\n【 guàn　dòu　shuāng　lóng 】\n			', '\n形容才能拔萃超群。\n			', '\n据《晋书·张华传》载：“晋张华善望气，见斗牛间常有紫气， 固命雷焕为丰城令访之。焕到县，掘狱屋基，得龙泉、太阿两宝剑，华与焕各佩其一。后华死，失剑所在。焕死，焕子持剑行经延平津，剑忽跃出堕水，使人没水取之， [下续示例]\n			', '\n[上接出处]\n			'),
(1816, '0:3:4', '龟龙麟凤', '\n【 guī　lóng　lín　fèng 】\n			', '\n传统上用来象征高寿、尊贵、吉祥的四种动物。比喻身处高位德盖四海的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1817, '0:3:4', '虎步龙行', '\n【 hǔ　bù　lóng　xíng 】\n			', '\n原形容帝王的仪态不同一般。后也形容将军的英武姿态。\n			', '\n《宋书·武帝纪上》：“刘裕龙行虎步，视瞻不凡，恐不为人下，宜早为其所。”\n			', '\n只见那人生得面如冠玉，唇若涂朱，眉清目秀，～。\n			'),
(1818, '0:3:4', '虎变龙蒸', '\n【 hǔ　biàn　lóng　zhēng 】\n			', '\n指乘时变化而飞黄腾达。\n			', '\n明·汤显祖《紫钗记·节镇还朝》：“君侯膺归衮之期，贱子附迁莺着役。风期未远，存问非遥。虎变龙蒸，风云自爱。”\n			', '\n暂无\n			'),
(1819, '0:3:4', '虎超龙骧', '\n【 hǔ　chāo　lóng　xiāng 】\n			', '\n比喻群雄奋起，互相角逐。\n			', '\n三国·魏·曹植《汉二祖优劣论》：“当此时也，九州鼎沸，四海渊涌。言帝者二三，称王者四五。鸱视狼顾，虎超龙骧。”\n			', '\n暂无\n			'),
(1820, '0:3:4', '鹤骨龙筋', '\n【 hè　gǔ　lóng　jīn 】\n			', '\n指瘦挺虬曲的样子。\n			', '\n宋·苏轼《孤山二咏·柏堂》：“道人手种几生前，鹤骨龙筋尚宛然。”\n			', '\n暂无\n			'),
(1821, '0:3:4', '虎据龙蟠', '\n【 hǔ　jù　lóng　pán 】\n			', '\n形容地势雄伟险要。同“虎踞龙盘”。\n			', '\n北周·庚信《哀江南赋》：“昔之虎据龙蟠，加以黄旗紫气；莫不随狐兔而窟穴，与风尘而殄悴。”\n			', '\n暂无\n			'),
(1822, '0:3:4', '虎踞龙蟠', '\n【 hǔ　jù　lóng　pán 】\n			', '\n形容地势雄伟险要。同“虎踞龙盘”。\n			', '\n宋·辛弃疾《念奴娇·登建康赏心亭呈史留守致道》词：“虎踞龙蟠何处是？只有兴亡满目。”\n			', '\n暂无\n			'),
(1823, '0:3:4', '虎窟龙潭', '\n【 hǔ　kū　lóng　tán 】\n			', '\n窟：洞穴；潭：深水池。龙居住的深水潭，虎栖身的巢穴。比喻极其凶险的地方。\n			', '\n元·汪元亨《沉醉东风·归田》：“怕筑成传说墙，愁扳折朱云槛，急跳出虎窟龙潭。”\n			', '\n暂无\n			'),
(1824, '0:3:4', '画龙不成反为狗', '\n【 huà　lóng　bù　chéng　fǎn　wéi　gǒu 】\n			', '\n比喻模仿不到家，反而不伦不类。同“画虎不成反类狗”。\n			', '\n《后汉书·儒林传上·孔僖》：“[僖与崔駰]同游太学，习《春秋》。因读吴王夫差时事，僖废书叹曰：‘若是，所谓画龙不成反为狗者。’”\n			', '\n暂无\n			'),
(1825, '0:3:4', '火龙黼黻', '\n【 huǒ　lóng　fǔ　fú 】\n			', '\n原指火形和龙形的文彩，后用以比喻作文只知雕章琢句，犹如补缀百家之衣。\n			', '\n《左传·桓公二年》：“火龙黼黻，昭其文也。”\n			', '\n文章最忌百家衣，～世不知。\n			'),
(1826, '0:3:4', '画龙刻鹄', '\n【 huà　lóng　kè　hú 】\n			', '\n比喻好高鹜远，终无成就。同“画虎刻鹄”。\n			', '\n清·唐孙华《送吴振西北游》诗：“东箭南金谁国士，画龙刻鹄半虚名。”\n			', '\n暂无\n			'),
(1827, '0:3:4', '虎略龙韬', '\n【 hǔ　lüè　lóng　tāo 】\n			', '\n略：指传说中黄石公所撰的《三略》。韬：指《六韬》。《三略》、《六韬》是古代兵书。泛指兵书、兵法，也指兵家权谋。\n			', '\n明·刘基《悲杭城》诗：“一朝奔迸各西东，玉斝金杯散蓬荜。清都太微天听高，虎略龙韬缄石室。”\n			', '\n雄图壮志千秋罕，～万众从。\n			'),
(1828, '0:3:4', '黄龙痛饮', '\n【 huáng　lóng　tòng　yǐn 】\n			', '\n指彻底击败敌人，欢庆胜利。\n			', '\n宋金交战，岳飞曾说要直捣黄龙府，与人痛饮。龚振黄《青岛潮》第十五章：“是以都门学界，纠合学界同志，连络全国人民，黄龙痛饮，岳武穆之是法；马革裹尸，汉伏波之未死。”\n			', '\n～炮千鸣，好与先生祝寿考。\n			'),
(1829, '0:3:4', '活龙鲜健', '\n【 huó　lóng　xiān　jiàn 】\n			', '\n形容健壮有活力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1830, '0:3:4', '骇龙走蛇', '\n【 hài　lóng　zǒu　shé 】\n			', '\n龙蛇被掠走。形容声势浩大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1831, '0:3:4', '虎掷龙拿', '\n【 hǔ　zhì　lóng　ná 】\n			', '\n掷：挣扎跳跃。指龙虎互相争斗。比喻激烈的搏斗。\n			', '\n金·元好问《楚汉战处》诗：“虎掷龙拿不两存，当年曾此赌乾坤。”\n			', '\n暂无\n			'),
(1832, '0:3:4', '酒虎诗龙', '\n【 jiǔ　hǔ　shī　lóng 】\n			', '\n比喻嗜酒善饮、才高能诗的人。\n			', '\n清·丘逢甲《东山酒楼次柳汀韵》：“狂饮且共楼头醉，酒虎诗龙各自豪。”\n			', '\n暂无\n			'),
(1833, '0:3:4', '酒龙诗虎', '\n【 jiǔ　lóng　shī　hǔ 】\n			', '\n比喻嗜酒善饮、才高能诗的人。\n			', '\n清·丘逢甲《饮镇平都司署赏菊为题宋人所画报捷图》诗：“粤水闽山文武会，酒龙诗虎主宾才。”\n			', '\n暂无\n			'),
(1834, '0:3:4', '蛟龙戏水', '\n【 jiāo　lóng　xì　shuǐ 】\n			', '\n比喻刀枪棍棒等武器使得轻松自如，灵活多变。形容武艺精湛纯熟。\n			', '\n明·吴承恩《西游记》第五十一回：“饿虎扑食最伤人，蛟龙戏水能凶恶。”\n			', '\n暂无\n			'),
(1835, '0:3:4', '矫若游龙', '\n【 jiǎo　ruò　yóu　lóng 】\n			', '\n常用于形容书法笔势刚健，或舞姿婀娜。同“矫若惊龙”。\n			', '\n明·梅鼎祚《玉合记·义姤》：“看他矫若游龙，超逾集乌。……夜月红楼，树下霓裳出月。是好舞也。”\n			', '\n暂无\n			'),
(1836, '0:3:4', '龙雏凤种', '\n【 lóng　chú　fèng　zhǒng 】\n			', '\n指帝王后裔。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1837, '0:3:4', '龙驰虎骤', '\n【 lóng　chí　hǔ　zhòu 】\n			', '\n指群雄逐鹿。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1838, '0:3:4', '龙雕凤咀', '\n【 lóng　diāo　fèng　jǔ 】\n			', '\n比喻辞藻之美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1839, '0:3:4', '龙蹲虎踞', '\n【 lóng　dūn　hǔ　jù 】\n			', '\n犹言龙盘虎踞。好像盘绕的龙，蹲伏的虎。特指南京。亦形容地势雄伟险要。\n			', '\n宋·丁开《建业》诗：“龙蹲虎踞江山大，马去牛来社稷空。”\n			', '\n暂无\n			'),
(1840, '0:3:4', '龙断可登', '\n【 lóng　duàn　kě　dēng 】\n			', '\n指可经营得利。龙，通“垄”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1841, '0:3:4', '龙多乃旱', '\n【 lóng　duō　nǎi　hàn 】\n			', '\n比喻人多互相依赖，反而办不成事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1842, '0:3:4', '龙断之登', '\n【 lóng　duàn　zhī　dēng 】\n			', '\n指谋利求财。龙，通“垄”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1843, '0:3:4', '龙德在田', '\n【 lóng　dé　zài　tián 】\n			', '\n指恩德广被，无所不在。\n			', '\n《易·干》：“‘见龙在田’，德施普也。”\n			', '\n暂无\n			'),
(1844, '0:3:4', '龙飞凤翔', '\n【 lóng　fēi　fèng　xiáng 】\n			', '\n①指帝王的兴起。②比喻仕途得意，飞黄腾达。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1845, '0:3:4', '龙飞凤翥', '\n【 lóng　fēi　fèng　zhù 】\n			', '\n形容笔势雄奇飞动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1846, '0:3:4', '龙幡虎纛', '\n【 lóng　fān　hǔ　dào 】\n			', '\n指将帅之旗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1847, '0:3:4', '龙飞虎跳', '\n【 lóng　fēi　hǔ　tiào 】\n			', '\n比喻笔势遒劲奔放。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1848, '0:3:4', '龙鬼蛇神', '\n【 lóng　guǐ　shé　shén 】\n			', '\n比喻奇诡怪僻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1849, '0:3:4', '龙翰凤雏', '\n【 lóng　hàn　fèng　chú 】\n			', '\n比喻杰出的人才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1850, '0:3:4', '龙翰凤翼', '\n【 lóng　hàn　fèng　yì 】\n			', '\n比喻杰出的人才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1851, '0:3:4', '龙虎风云', '\n【 lóng　hǔ　fēng　yún 】\n			', '\n①比喻英雄豪杰际遇得时。②指君臣遇合。\n			', '\n《易·干》：“云从龙，风从虎。”\n			', '\n善教他，归厚德，太平时～会。\n			'),
(1852, '0:3:4', '龙化虎变', '\n【 lóng　huà　hǔ　biàn 】\n			', '\n比喻变化莫测。\n			', '\n《易·革》：“大人虎变，其文炳也。”《史记·老子韩非列传》“（孔子）谓弟子曰：‘鸟，吾知其能飞；鱼，吾知其能游；兽，吾知其能走。走者可以为罔，游者可以为纶，飞者可以为矰。至于龙，吾不能知其乘风云而上天。’”\n			', '\n～，可以哸虚空，虚空非无也；可以贯金石，金石非有也。……知此道者形不可得毙，神不可得逝。\n			'),
(1853, '0:3:4', '龙荒蛮甸', '\n【 lóng　huāng　mán　diàn 】\n			', '\n指边远蛮荒之地。亦指边远之地的少数民族国家。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1854, '0:3:4', '龙荒朔漠', '\n【 lóng　huāng　shuò　mò 】\n			', '\n北方塞外荒漠之地。亦指在这些地方的少数民族国家。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1855, '0:3:4', '龙胡之痛', '\n【 lóng　hú　zhī　tòng 】\n			', '\n指丧亲之痛。\n			', '\n《汉书·郊祀志上》：“黄帝采首山铜，铸鼎于荆山下。鼎既成，有龙垂胡涘下迎黄帝。黄帝上骑，群臣后宫从上龙七十馀人，龙乃上去……百姓卬望黄帝既上天，乃抱其弓与龙涘号。”\n			', '\n顾此襢编之锡，曾不间于乌鸟之怀；是各簪履之遗，益无解于～。\n			'),
(1856, '0:3:4', '龙江虎浪', '\n【 lóng　jiāng　hǔ　làng 】\n			', '\n形容惯于兴风作浪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1857, '0:3:4', '龙精虎猛', '\n【 lóng　jīng　hǔ　měng 】\n			', '\n比喻精力旺盛，斗志昂扬。\n			', '\n陈残云《山谷风烟》第二一章：“大家一夜没睡觉，到如今还是龙精虎猛，表现了兄弟姐妹们对地主的仇恨。”\n			', '\n暂无\n			'),
(1858, '0:3:4', '龙举云属', '\n【 lóng　jǔ　yún　shǔ 】\n			', '\n比喻王者兴起则必遇贤臣良将。同“龙兴云属”。\n			', '\n《南齐书·高帝纪上》：“麾旆所临，风行草靡，神算所指，龙举云属。”\n			', '\n暂无\n			'),
(1859, '0:3:4', '龙举云兴', '\n【 lóng　jǔ　yún　xīng 】\n			', '\n比喻王者兴起则必遇贤臣良将。同“龙兴云属”。\n			', '\n《东观汉记·光武皇帝纪》：“帝既有仁圣之明，气势形体，天然之姿，固非人之敌，翕然龙举云兴，三雨而济，天下荡荡，人无能名焉。”\n			', '\n暂无\n			'),
(1860, '0:3:4', '龙楼凤城', '\n【 lóng　lóu　fèng　chéng 】\n			', '\n犹言龙楼凤池。指禁省，皇宫。\n			', '\n明·陈汝元《金莲记·偕计》：“论文章围棘堪驰骋，愿藏身龙楼凤城。”\n			', '\n暂无\n			'),
(1861, '0:3:4', '龙楼凤阁', '\n【 lóng　lóu　fèng　gé 】\n			', '\n①帝王的宫殿、楼阁。②喻指封建统治者的巢穴。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1862, '0:3:4', '龙楼凤阙', '\n【 lóng　lóu　fèng　què 】\n			', '\n指帝王宫阙。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1863, '0:3:4', '龙楼凤池', '\n【 lóng　lóu　fèng　shi 】\n			', '\n指禁省，皇宫。\n			', '\n明·梁辰鱼《浣纱记·送钱》：“念生长在香闰绣帏，念出入在龙楼凤池。”\n			', '\n暂无\n			'),
(1864, '0:3:4', '龙眉豹颈', '\n【 lóng　méi　bào　jǐng 】\n			', '\n形容勇士的长相。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1865, '0:3:4', '龙门点额', '\n【 lóng　mén　diǎn　é 】\n			', '\n比喻仕路失意或科场落第。\n			', '\n北魏·郦道元《水经注·河水四》：“《尔雅》曰：‘鳣，?有也。’出巩穴三月，则上渡龙门，得渡为龙矣，否则点额而还。”\n			', '\n俞良八千有馀多路，来到临安，指望一举成名。争奈时运未至，～，金榜无名。\n			'),
(1866, '0:3:4', '龙眉凤目', '\n【 lóng　méi　fèng　mù 】\n			', '\n形容贵人相貌不同寻常。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1867, '0:3:4', '龙拏虎攫', '\n【 lóng　ná　hǔ　jué 】\n			', '\n犹言龙争虎斗。比喻笔势遒劲、奔放。\n			', '\n清·王晫《今世说·企羡》：“新城王西樵阮亭，每过邮亭夜店，辄题诗壁上，诗既惊人，使笔斗大，龙拏虎攫。”\n			', '\n暂无\n			'),
(1868, '0:3:4', '龙拏虎跳', '\n【 lóng　ná　hǔ　tiào 】\n			', '\n犹言龙争虎斗。\n			', '\n俞锷《醉歌行》：“说霸争王各不让，龙拏虎跳旦复昏。”\n			', '\n我以为这并不比～的战斗场面少些激动人心的力量。\n			'),
(1869, '0:3:4', '龙拏虎掷', '\n【 lóng　ná　hǔ　zhì 】\n			', '\n犹言龙争虎斗。\n			', '\n宋·喻汝砺《八阵图》诗：“笑云此公大肚皮，龙拏虎掷填胸胄。”\n			', '\n自汉迄今，全史之大，部分，皆演于江河间之原野，被～，甲兴乙仆，殆未有出山东、安徽、江苏、河南、湖北数省外者也。\n			'),
(1870, '0:3:4', '龙攀凤附', '\n【 lóng　pān　fèng　fù 】\n			', '\n犹言攀龙附凤。指巴结投靠有权势的人以获取富贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1871, '0:3:4', '龙盘凤舞', '\n【 lóng　pán　fèng　wǔ 】\n			', '\n比喻山川雄踞蜿蜒，有王者气象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1872, '0:3:4', '龙盘凤逸', '\n【 lóng　pán　fèng　yì 】\n			', '\n比喻怀才不遇。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1873, '0:3:4', '龙盘凤翥', '\n【 lóng　pán　fèng　zhù 】\n			', '\n比喻山势雄壮蜿蜒。指王者的气象。亦比喻书法笔势飞动。\n			', '\n后晋·沈昫《旧唐书·玄宗纪》：“初，上皇亲拜五陵，至桥陵，见金粟山有龙盘凤翥之势。”\n			', '\n诏二臣共作《艮岳百咏诗》以进……《草圣亭》：落笔纵横走电光，近臣时得赐云章。～皆天纵，渴骥惊蛇不足方。\n			'),
(1874, '0:3:4', '龙蟠凤翥', '\n【 lóng　pán　fèng　zhù 】\n			', '\n指贤者遁世归隐。\n			', '\n宋·苏轼《水龙吟》词：“古来云海茫茫，道山绛阙知何处？人间自有，赤城居士，龙蟠凤翥。清净无为，坐忘遗照，八篇奇语。”\n			', '\n暂无\n			'),
(1875, '0:3:4', '龙蟠虎伏', '\n【 lóng　pán　hǔ　fú 】\n			', '\n雄踞的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1876, '0:3:4', '龙蟠虎踞', '\n【 lóng　pán　hǔ　jù 】\n			', '\n象龙盘着，象虎蹲着。形容地势雄伟险要。特指南京。\n			', '\n晋·吴勃《吴录》：“刘备曾使诸葛亮至京，因睹秣陵山阜，叹曰：‘钟山龙盘，石头虎踞，此帝王之宅。’”\n			', '\n暂无\n			'),
(1877, '0:3:4', '龙盘虎拏', '\n【 lóng　pán　hǔ　ná 】\n			', '\n虬曲苍劲的样子。\n			', '\n明·何景明《古松歌》：“龙盘虎拏终有神，白骨苍鳞半枯死。”\n			', '\n暂无\n			'),
(1878, '0:3:4', '龙蟠虎绕', '\n【 lóng　pán　hǔ　rào 】\n			', '\n犹言龙盘虎踞。形容地势雄伟险要。\n			', '\n宋·范成大《水龙吟·寿留寺》词：“物外新闻，凤歌鸾翥，龙蟠虎绕。”\n			', '\n暂无\n			'),
(1879, '0:3:4', '龙蟠虬结', '\n【 lóng　pán　qiú　jié 】\n			', '\n犹言旋绕纠结。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1880, '0:3:4', '龙去鼎湖', '\n【 lóng　qù　dǐng　hú 】\n			', '\n指帝王去世。\n			', '\n典出《史记·封禅书》：“黄帝采首山铜，铸鼎于荆山下。鼎既成，有龙垂胡涘下迎黄帝。黄帝上骑，群臣后宫从上者七十馀人，龙乃上去。馀小臣不得上，乃悉持龙涘，龙涘拔，堕，堕黄帝之弓。百姓仰望黄帝既上天，乃抱其弓与胡涘号，故后世因名其处曰鼎\n			', '\n暂无\n			'),
(1881, '0:3:4', '龙潜凤采', '\n【 lóng　qián　fèng　cǎi 】\n			', '\n比喻英俊之士才能未展现。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1882, '0:3:4', '龙跧虎卧', '\n【 lóng　quán　hǔ　wò 】\n			', '\n犹言龙蟠虎踞。比喻山势逶迤起伏。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1883, '0:3:4', '龙屈蛇伸', '\n【 lóng　qū　shé　shēn 】\n			', '\n比喻君子受屈而小人得志。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1884, '0:3:4', '龙蛇飞舞', '\n【 lóng　shé　fēi　wǔ 】\n			', '\n形容书法笔势遒劲生动。\n			', '\n清·李汝珍《镜花缘》第八十八回：“闺臣听了，把神凝了一凝，只得打起精神，举起笔来，刷、刷、刷如龙蛇飞舞一般，一连写了几句。”\n			', '\n只记得纸上～，笔势很好看的。（冰心《往事·六一姊》）\n			'),
(1885, '0:3:4', '龙伸蠖屈', '\n【 lóng　shēn　huò　qū 】\n			', '\n形容笔势飞动，书法高超。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1886, '0:3:4', '龙生九子', '\n【 lóng　shēng　jiǔ　zǐ 】\n			', '\n比喻同胞兄弟品质、爱好各不相同。\n			', '\n明·徐应秋《玉芝堂谈荟·龙生九子》：“龙生九子不成龙，各有所好。”\n			', '\n暂无\n			'),
(1887, '0:3:4', '龙生九种', '\n【 lóng　shēng　jiǔ　zhǒng 】\n			', '\n比喻同胞兄弟品质、爱好各不相同。同“龙生九子”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1888, '0:3:4', '龙神马壮', '\n【 lóng　shén　mǎ　zhuàng 】\n			', '\n谓像骏马一样的有精神。\n			', '\n欧阳山《苦斗》四六：“那时候，一个个青年人都是龙神马壮，气吞牛斗，争论起世界国家大事来，都是口若悬河，当当不断，慷慨激昂，谁也不让谁。”\n			', '\n暂无\n			'),
(1889, '0:3:4', '龙首豕足', '\n【 lóng　shǒu　shǐ　zú 】\n			', '\n犹言牛头不对马嘴。指对书义的解释与原旨相去甚远，风马牛不相及。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1890, '0:3:4', '流水游龙', '\n【 liú　shuǐ　yóu　lóng 】\n			', '\n比喻川流不息的车马。\n			', '\n语出《后汉书·皇后纪上·明德马皇后》：“前过濯龙门上，见外家问起居者，车如流水，马如游龙，仓头衣绿褠，领袖正白，顾视御者，不及远矣。”\n			', '\n～日夜弛，品题素竹与哀丝。\n			'),
(1891, '0:3:4', '龙腾豹变', '\n【 lóng　téng　bào　biàn 】\n			', '\n比喻议论风发，能言善辩。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1892, '0:3:4', '龙腾凤集', '\n【 lóng　téng　fèng　jí 】\n			', '\n比喻王业兴盛，英雄会合。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1893, '0:3:4', '龙腾虎蹴', '\n【 lóng　téng　hǔ　cù 】\n			', '\n比喻勇猛冲击，势不可当。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1894, '0:3:4', '龙跳虎伏', '\n【 lóng　tiào　hǔ　fú 】\n			', '\n犹言龙腾虎卧。比喻笔势。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1895, '0:3:4', '龙腾虎踞', '\n【 lóng　téng　hǔ　jù 】\n			', '\n势力强盛，雄据一方。\n			', '\n晋·葛洪《抱朴子·钦士》：“彼虽降高抑满，以贵下贱，终亦并目以远其明，假耳以广其聪，龙腾虎踞，宜其然也。”\n			', '\n暂无\n			'),
(1896, '0:3:4', '龙腾虎啸', '\n【 lóng　téng　hǔ　xiào 】\n			', '\n声势壮盛的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1897, '0:3:4', '龙腾虎踯', '\n【 lóng　téng　hǔ　zhí 】\n			', '\n比喻勇猛冲击，势不可当。同“龙腾虎蹴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1898, '0:3:4', '龙腾虎掷', '\n【 lóng　téng　hǔ　zhì 】\n			', '\n比喻勇猛冲击，势不可当。同“龙腾虎蹴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1899, '0:3:4', '龙头锯角', '\n【 lóng　tóu　jù　jiǎo 】\n			', '\n比喻大胆冒险。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1900, '0:3:4', '龙威虎震', '\n【 lóng　wēi　hǔ　zhèn 】\n			', '\n形容气势奔放雄壮。常形容书法笔势的遒劲有力，灵活舒展。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1901, '0:3:4', '龙威燕颔', '\n【 lóng　wēi　yàn　hàn 】\n			', '\n形容威严雄武的相貌。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1902, '0:3:4', '龙骧豹变', '\n【 lóng　xiāng　bào　biàn 】\n			', '\n比喻书法气势壮盛而善于变化。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1903, '0:3:4', '龙心凤肝', '\n【 lóng　xīn　fèng　gān 】\n			', '\n喻指极珍贵稀有的名菜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1904, '0:3:4', '龙骧凤矫', '\n【 lóng　xiāng　fèng　jiǎo 】\n			', '\n龙腾凤飞。喻指行动迅猛。\n			', '\n《宋书·武帝纪中》：“公龙骧凤矫咫尺八纮，括囊四海，折冲无外。”\n			', '\n暂无\n			'),
(1905, '0:3:4', '龙兴凤举', '\n【 lóng　xīng　fèng　jǔ 】\n			', '\n比喻王者兴起。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1906, '0:3:4', '龙血凤髓', '\n【 lóng　xuè　fèng　suǐ 】\n			', '\n比喻高贵的血统。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1907, '0:3:4', '龙翔凤舞', '\n【 lóng　xiáng　fèng　wǔ 】\n			', '\n犹言龙飞凤舞。原形容山势的蜿蜒雄壮，后也形容书法笔势有力，灵活舒展。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1908, '0:3:4', '龙翔凤跃', '\n【 lóng　xiáng　fèng　yuè 】\n			', '\n原形容山势的蜿蜒雄壮，后也形容书法笔势有力，灵活舒展。同“龙翔凤舞”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1909, '0:3:4', '龙翔凤翥', '\n【 lóng　xiáng　fèng　zhù 】\n			', '\n①比喻瀑布飞泻奔腾。②比喻神采飞扬。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1910, '0:3:4', '龙行虎变', '\n【 lóng　xíng　hǔ　biàn 】\n			', '\n比喻帝王革故鼎新，创制建业。\n			', '\n《易·干》：“飞龙在天……云从龙。风从虎，圣人作而万物睹。”又《革》：“大人虎变。”孔颖达疏：“损益前王，创制立法，有文章之美，焕然可观，有似虎变，其文彪炳。”\n			', '\n高祖起于布衣之中，奋剑而取天下，不由唐虞之禅，不阶汤武之王，～，率从风云，征乱伐暴，廓清帝宇。\n			'),
(1911, '0:3:4', '龙骧虎跱', '\n【 lóng　xiāng　hǔ　jià 】\n			', '\n雄踞的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1912, '0:3:4', '龙骧蠖屈', '\n【 lóng　xiāng　huò　qū 】\n			', '\n比喻随时屈伸、上下。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1913, '0:3:4', '龙骧虎啸', '\n【 lóng　xiāng　hǔ　xiào 】\n			', '\n比喻气概威武。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1914, '0:3:4', '龙翔虎跃', '\n【 lóng　xiáng　hǔ　yuè 】\n			', '\n比喻奋发有为。\n			', '\n明·叶蕃《〈写情集〉序》：“其盖世之姿，雄伟之志，用天下国家之心，得不发为千汇万状之奇而龙翔虎跃也。”\n			', '\n暂无\n			'),
(1915, '0:3:4', '龙骧麟振', '\n【 lóng　xiāng　lín　zhèn 】\n			', '\n龙骧，昂举腾跃的样子。比喻将军恩威兼备。\n			', '\n麟振，语出《诗·周南·麟之趾》：“鳞之趾，振振公子，于嗟麟兮。”毛传：“麟，信而应礼，以足至者也。振振，信厚也。”\n			', '\n[邓艾]受命忘身，～，前无坚敌。\n			'),
(1916, '0:3:4', '龙兴云属', '\n【 lóng　xīng　yún　shǔ 】\n			', '\n比喻王者兴起则必遇贤臣良将。\n			', '\n《易·干》：“云从龙，风从虎。”\n			', '\n夫虎啸风驰，～，故重华立而元凯升，辛受生而飞廉进。\n			'),
(1917, '0:3:4', '龙言凤语', '\n【 lóng　yán　fèng　yǔ 】\n			', '\n比喻轻松悠扬的音乐之声。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1918, '0:3:4', '龙颜凤姿', '\n【 lóng　yán　fèng　zī 】\n			', '\n指帝王之相。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1919, '0:3:4', '龙跃鸿矫', '\n【 lóng　yuè　hóng　jiǎo 】\n			', '\n比喻高举远逝。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1920, '0:3:4', '龙跃虎踞', '\n【 lóng　yuè　hǔ　jù 】\n			', '\n比喻超逸雄奇。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1921, '0:3:4', '龙阳泣鱼', '\n【 lóng　yáng　qì　yú 】\n			', '\n后以之为失宠之典。\n			', '\n《战国策·魏策四》：“魏王与龙阳君共船而钓，龙阳君得十馀鱼而涕下。……王曰：‘然则何为出涕？’曰：‘臣为王之所得鱼也。’王曰：‘何谓也？’对曰：‘臣之始得鱼也，臣甚喜，后得又益大，今臣直欲弃臣前之所得矣。……臣亦将弃矣，臣安能无涕\n			', '\n妾蒙主人恩宠无比，但恐春老花残，主上恩移宠衰，使妾有～之悲，班姬题扇之怨，奈何？\n			'),
(1922, '0:3:4', '龙游曲沼', '\n【 long　you　qu　zhao 】\n			', '\n传说龙耀五彩，所以以游龙为喻。沼：池子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1923, '0:3:4', '龙驭上宾', '\n【 lóng　yù　shàng　bīn 】\n			', '\n此为皇帝之死的讳饰语。意为乘龙升天，为天帝之宾。\n			', '\n《史记·封禅书》：“黄帝采首山铜，铸鼎于荆山下。鼎既成，有龙垂胡涘下迎黄帝。黄帝上骑，群臣后宫从上者七十馀人，龙乃上去。”\n			', '\n盖有意大用，未几而～矣。\n			'),
(1924, '0:3:4', '龙御上宾', '\n【 lóng　yù　shàng　bīn 】\n			', '\n此为皇帝之死的讳饰语。意为乘龙升天，为天帝之宾。同“龙驭上宾”。\n			', '\n《史记·封禅书》：“黄帝采首山铜，铸鼎于荆山下。鼎既成，有龙垂胡涘下迎黄帝。黄帝上骑，群臣后宫从上者七十馀人，龙乃上去。”\n			', '\n尼古拉二世‘～’之后，罗马诺夫氏竟已‘覆宗绝祀’了。\n			'),
(1925, '0:3:4', '龙章凤彩', '\n【 lóng　zhāng　fèng　cǎi 】\n			', '\n不凡的仪表风采。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1926, '0:3:4', '龙姿凤采', '\n【 lóng　zī　fèng　cǎi 】\n			', '\n形容姿态风采非凡。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1927, '0:3:4', '龙章凤函', '\n【 lóng　zhāng　fèng　hán 】\n			', '\n比喻文采炳焕。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1928, '0:3:4', '龙蛰蠖屈', '\n【 lóng　zhé　huò　qū 】\n			', '\n比喻隐居不仕。\n			', '\n语出《易·系辞下》：“尺蠖之屈，以求信也；龙蛇之蛰，以存身也。”\n			', '\n今岁传胪小儿，即少时妄对隐士绝无才者也。公当盛汉之隆，而，不一建立于时，得无为儿曹所诮乎？一笑。\n			'),
(1929, '0:3:4', '龙睁虎眼', '\n【 lóng　zhēng　hǔ　yǎn 】\n			', '\n形容蛮横霸道。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1930, '0:3:4', '龙战虎争', '\n【 lóng　zhàn　hǔ　zhēng 】\n			', '\n形容斗争或竞赛很激烈。同“龙争虎斗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1931, '0:3:4', '龙争虎战', '\n【 lóng　zhēng　hǔ　zhàn 】\n			', '\n形容斗争或竞赛很激烈。同“龙争虎斗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1932, '0:3:4', '龙章麟角', '\n【 lóng　zhāng　lín　jiǎo 】\n			', '\n比喻珍希，不凡。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1933, '0:3:4', '龙章秀骨', '\n【 lóng　zhāng　xiù　gǔ 】\n			', '\n比喻文章秀逸遒劲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1934, '0:3:4', '龙战玄黄', '\n【 lóng　zhàn　xuán　huáng 】\n			', '\n比喻战争激烈，血流成河。同“龙血玄黄”。\n			', '\n茅盾《回忆之类》：“不过，当那一声焦雷打到我们面前时，童稚之心也曾欢喜而鼓舞，也曾睁大了惊异的眼睛，痴望着‘龙战玄黄’的天地，好像这一切本在意中，要来的总归要来，而现在是终于来了而已。”\n			', '\n暂无\n			'),
(1935, '0:3:4', '龙战鱼骇', '\n【 lóng　zhàn　yú　hài 】\n			', '\n比喻战争激烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1936, '0:3:4', '描龙绣凤', '\n【 miáo　lóng　xiù　fèng 】\n			', '\n指精美的手工刺绣。泛指古代女红。亦作“描鸾刺凤”、“描龙刺凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1937, '0:3:4', '马水车龙', '\n【 mǎ　shuǐ　chē　lóng 】\n			', '\n犹言车水马龙。形容来往车马很多，连续不断的热闹情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1938, '0:3:4', '曼衍鱼龙', '\n【 màn　yǎn　yú　lóng 】\n			', '\n曼衍：亦作“漫衍”、“曼延”，巨兽名，古代仿照它排演百戏节目。鱼龙：古代百戏节目。古代演出的杂戏名。比喻事物的离奇变幻。亦作“鱼龙曼衍”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1939, '0:3:4', '马足龙沙', '\n【 mǎ　zú　lóng　shā 】\n			', '\n指驰骋边疆，扬威域外。龙沙，塞北沙漠地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1940, '0:3:4', '砲凤烹龙', '\n【 pào　fèng　pēng　lóng 】\n			', '\n①形容豪奢珍奇的肴馔。②指一种肴馔名。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1941, '0:3:4', '攀龙附骥', '\n【 pān　lóng　fù　jì 】\n			', '\n攀：攀附；骥：好马。比喻攀附圣贤，归附俊杰。\n			', '\n《三国志·吴志·吴主孙权传》：“此言之诚，有如大江。”裴松之注引《魏略·孙权与浩周书》：“当垂宿念，为之先后，使获攀龙附骥，永自固定。其为分惠，岂有量哉！”\n			', '\n暂无\n			'),
(1942, '0:3:4', '炮龙烹凤', '\n【 pào　lóng　pēng　fèng 】\n			', '\n形容豪奢珍奇的肴馔。\n			', '\n明·施耐庵《水浒传》第八十二回：“堂上堂下，皆列位次，大设筵宴，轮番把盏。厅前大吹大擂。虽无炮龙烹凤，端的是肉山酒海。”\n			', '\n暂无\n			'),
(1943, '0:3:4', '砲龙烹凤', '\n【 pào　lóng　pēng　fèng 】\n			', '\n形容豪奢珍奇的肴馔。也指一种肴馔名。同“砲凤烹龙”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1944, '0:3:4', '烹龙庖凤', '\n【 pēng　lóng　páo　fèng 】\n			', '\n比喻烹调珍奇菜肴。亦形容菜肴豪奢珍贵。同“烹龙炮凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1945, '0:3:4', '烹龙砲凤', '\n【 pēng　lóng　pào　fèng 】\n			', '\n①比喻烹调珍奇肴馔。亦形容菜肴豪奢珍贵。②比喻高超的艺术技艺。亦作“烹龙庖凤”。亦作“烹龙煮凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1946, '0:3:4', '攀龙讬凤', '\n【 pān　lóng　xiù　fèng 】\n			', '\n犹言攀龙附凤。指巴结投靠有权势的人以获取富贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1947, '0:3:4', '烹龙煮凤', '\n【 pēng　lóng　zhǔ　fèng 】\n			', '\n比喻烹调珍奇菜肴。亦形容菜肴豪奢珍贵。\n			', '\n明·冯梦龙《喻世明言》第十一卷：“有《鹧鸪天》词为证：城中酒楼高入天，烹龙煮凤味肥鲜。公孙下马闻香醉，一饮不惜费万钱。”\n			', '\n暂无\n			'),
(1948, '0:3:4', '批逆龙鳞', '\n【 pī　nì　lóng　lín 】\n			', '\n传说龙喉下有逆鳞径尺，有触之必怒而杀人。常以喻弱者触怒强者或臣下触犯君主等。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1949, '0:3:4', '强龙不压地头蛇', '\n【 qiáng　lóng　bù　yā　dì　tóu　shé 】\n			', '\n比喻有能耐的人也难对付盘踞当地的恶势力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1950, '0:3:4', '潜龙伏虎', '\n【 qián　lóng　fú　hǔ 】\n			', '\n潜藏的蛟龙，潜伏的猛虎。比喻人才尚未被擢用。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1951, '0:3:4', '青龙金匮', '\n【 qīng　lóng　jīn　kuì 】\n			', '\n指六辰。指良辰吉日。旧时星命家以为，青龙、明堂、金匮、天德、司命等六辰为吉神，六辰值日，诸事皆宜，为黄道吉日。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1952, '0:3:4', '骑龙弄凤', '\n【 qí　lóng　nòng　fèng 】\n			', '\n①比喻成仙。②比喻腾达。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1953, '0:3:4', '雀马鱼龙', '\n【 què　mǎ　yú　lóng 】\n			', '\n泛指珍禽异兽。\n			', '\n语出《汉书·西域传赞》：“自是之后，明珠、文甲、通犀、翠羽之珍盈于后宫，蒲梢、龙文、鱼目、汗血之马充于黄门，钜象、师子、猛犬、大雀之群食于外囿。殊方异物，四面而至。”\n			', '\n暂无\n			'),
(1954, '0:3:4', '前怕龙，后怕虎', '\n【 qián　pà　lóng，hòu　pà　hǔ 】\n			', '\n比喻胆小怕事，顾虑太多。\n			', '\n明·冯惟敏《朝天子·感述》：“磊落英雄，清修人物，前怕狼后怕虎。设谋，使毒，只待把忠良妒。”\n			', '\n要改革就不能～，要大胆创新，努力实践，才能取得成功。\n			'),
(1955, '0:3:4', '日角龙庭', '\n【 rì　jiǎo　lóng　tíng 】\n			', '\n旧时相术家指天庭隆起为龙庭。称之为帝王的贵相。\n			', '\n《旧唐书·唐俭传》：“[高祖]密访时事，俭曰：‘明公日角龙庭，李氏又在图牒，天下属望，非在今朝。’”\n			', '\n暂无\n			'),
(1956, '0:3:4', '日角龙颜', '\n【 rì　jiǎo　lóng　yán 】\n			', '\n旧时相术家指额头隆起为龙颜。称之为为帝王的贵相。日角，额角中央部分隆起，形状如日。\n			', '\n《梁书·元帝纪》：“陛下日角龙颜之姿，表于徇齐之日；彤云素气之瑞，基于应物之初。”\n			', '\n身长七尺五寸，～，垂手过膝。\n			'),
(1957, '0:3:4', '如龙似虎', '\n【 rú　lóng　sì　hǔ 】\n			', '\n形容勇猛有活力。\n			', '\n明·方汝浩《禅真逸史》第三十九回：“云气变幻无穷，倏忽如龙似虎。人情世态，大率相同。”\n			', '\n马上的将官，纵～，马倒了，都倒栽葱跌将下来。\n			'),
(1958, '0:3:4', '人中龙虎', '\n【 rén　zhōng　lóng　hǔ 】\n			', '\n比喻人中豪杰。\n			', '\n《晋书·宋纤传》：“吾而今而后知先生人中之龙也。”\n			', '\n不枉了女中丈夫，～。\n			'),
(1959, '0:3:4', '事火咒龙', '\n【 shì　huǒ　zhòu　lóng 】\n			', '\n比喻荒诞不经之事。事火，指祀火为神；咒龙，指咒龙请雨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1960, '0:3:4', '尸居龙见', '\n【 shī　jū　lóng　xiàn 】\n			', '\n居：静居；见：出现。静如尸而动如龙。\n			', '\n《庄子·在宥》：“故君子苟能无解其五藏，无擢其聪明，尸居而龙见，渊默而雷声。”\n			', '\n暂无\n			'),
(1961, '0:3:4', '神龙见首', '\n【 shén　lóng　jiàn　shǒu 】\n			', '\n指诗文跌宕多姿。\n			', '\n清·赵执信《谈龙录》：“昉思嫉时俗之无章也，曰：‘诗如龙然，首尾爪角鳞鬣，一不具，非龙也。’司寇哂之曰：‘诗如神龙，见其首不见其尾，或云中露一爪一鳞而已，安得全体？’”\n			', '\n暂无\n			'),
(1962, '0:3:4', '神龙马壮', '\n【 shén　lóng　mǎ　zhuàng 】\n			', '\n比喻身体健壮、气宇轩昂。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1963, '0:3:4', '神龙失埶', '\n【 shén　lóng　shī　zhì 】\n			', '\n比喻失去权位。埶，同“势”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1964, '0:3:4', '岁在龙虵', '\n【 suì　zài　lóng　shé 】\n			', '\n后指命数当终。同“岁在龙蛇”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1965, '0:3:4', '岁在龙蛇', '\n【 suì　zài　lóng　shé 】\n			', '\n岁，岁星；龙，指辰；蛇，指巳。后指命数当终。\n			', '\n《后汉书·郑玄传》：“五年春，梦孔子告之曰：‘起，起，今年岁在辰，来年岁在巳。’既寤，以谶合之，知当命终，有顷寝疾。”李贤注：“北齐刘昼《高才不遇传》论玄曰‘辰为龙，巳为蛇，岁至龙蛇。贤人嗟，玄以谶合之’，盖谓此也。”\n			', '\n历险阻之驰驱，风如牛马；慨身宫之偃蹇，～。\n			'),
(1966, '0:3:4', '托凤攀龙', '\n【 tuō　fèng　pān　lóng 】\n			', '\n犹言攀龙附凤。比喻依附帝王、权贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1967, '0:3:4', '土龙沐猴', '\n【 tǔ　lóng　mù　hóu 】\n			', '\n比喻徒有虚名，而无其实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1968, '0:3:4', '屠龙之伎', '\n【 tú　lóng　zhī　jì 】\n			', '\n比喻虽有很高造诣却不切实用的技能。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1969, '0:3:4', '舞凤飞龙', '\n【 wǔ　fèng　fēi　lóng 】\n			', '\n犹龙飞凤舞。气势奔放雄壮的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1970, '0:3:4', '绣虎雕龙', '\n【 xiù　hǔ　diāo　lóng 】\n			', '\n比喻文章的辞藻华丽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1971, '0:3:4', '鱼龙百变', '\n【 yú　lóng　bǎi　biàn 】\n			', '\n像鱼龙那样变化多端。\n			', '\n北周·庾信《谢滕王集序启》：“譬其毫翰，则风雨争飞；论其文采，则鱼龙百变。”\n			', '\n昌黎（韩愈）文无不根据经典，而议论仍未尝袭前人陈言，故下笔如～。\n			'),
(1972, '0:3:4', '鱼龙变化', '\n【 yú　lóng　biàn　huà 】\n			', '\n指鱼变化为龙。比喻世事或人的根本性变化。\n			', '\n宋·刘克庄《水龙吟》词：“任蛙蟆胜负，鱼龙变化，侬方在、华胥国。”\n			', '\n社会现象……又好像长江、大河，滚滚而下，旁流齐汇，泥沙毕集，任你～也逃不出这河流域以外。\n			'),
(1973, '0:3:4', '鱼龙曼羡', '\n【 yú　lóng　màn　xiàn 】\n			', '\n比喻世事变幻。\n			', '\n清·龚自珍《小游仙词》之六：“顽仙一觉浑瞒过，不在鱼龙曼羡中。”\n			', '\n暂无\n			'),
(1974, '0:3:4', '鱼龙曼延', '\n【 yú　lóng　màn　yán 】\n			', '\n①古代百戏杂耍名。由艺人执持制作的珍异动物模型表演，有幻化的情节。鱼龙即所谓猞猁之兽，曼延亦兽名。②喻虚假多变，玩弄权术。亦作“鱼龙漫衍”。亦作“鱼龙\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(1975, '0:3:4', '鱼龙漫衍', '\n【 yú　lóng　màn　yǎn 】\n			', '\n古代百戏杂耍名。由艺人执持制作的珍异动物模型表演，有幻化的情节。鱼龙即所谓猞猁之兽，曼延亦兽名。后多比喻虚假多变，玩弄权术。漫，通“曼”。\n			', '\n《汉书·西域传赞》：“设酒池肉林以飨四夷之客，作巴俞都户、海中砀极、漫衍鱼龙、鱼抵之戏以观视之。”\n			', '\n暗尘浮动，正鱼龙曼衍，戏车交作。\n			'),
(1976, '0:3:4', '一龙一猪', '\n【 yī　lóng　yī　zhū 】\n			', '\n一是龙，一是猪。比喻同时的两个人，高下判别极大。\n			', '\n唐·韩愈《符读书城南》诗：“两家各生子，提孩巧相如。少长聚嬉戏，不殊同队鱼。三十骨骼成，乃一龙一猪。”\n			', '\n暂无\n			'),
(1977, '0:3:4', '云起龙襄', '\n【 yún　qǐ　lóng　xiāng 】\n			', '\n比喻英雄豪杰乘时而起。\n			', '\n《汉书·叙传下》：“云起龙襄，化为侯王。”颜师古注：“襄，举也。”一本作“云起龙骧”。\n			', '\n暂无\n			'),
(1978, '0:3:4', '鱼升龙门', '\n【 yú　shēng　lóng　mén 】\n			', '\n比喻举业成功或地位高升。\n			', '\n语出《辛氏三秦记》：“河津一名龙门，禹凿山开门，阔一里馀，黄河自中流下，而岸不通车马。每逢春之际，有黄鲤鱼逆流而上，得过者便化为龙。”\n			', '\n暂无\n			'),
(1979, '0:3:4', '鱼跃龙门', '\n【 yú　yuè　lóng　mén 】\n			', '\n比喻举业成功或地位高升。\n			', '\n语出《辛氏三秦记》：“河津一名龙门，禹凿山开门，阔一里馀，黄河自中流下，而岸不通车马。每逢春之际，有黄鲤鱼逆流而上，得过者便化为龙。”唐·元弼有《鱼跃龙门赋》。\n			', '\n俗说～，过而为龙，唯鲤或然。\n			'),
(1980, '0:3:4', '云蒸龙变', '\n【 yún　zhēng　lóng　biàn 】\n			', '\n云气兴起，神龙飞动。比喻英雄豪杰遇时奋起。\n			', '\n《史记·魏豹彭越列传论》：“［魏豹、彭越］得摄尺寸之柄，其云蒸龙变，欲有所会其度，以故幽囚而不辞云。”\n			', '\n豪杰之文章，～之气，遇感即发，宁容教深浅，商工拙于其间耶？\n			'),
(1981, '0:3:4', '鱼质龙文', '\n【 yú　zhì　lóng　wén 】\n			', '\n鱼的实质，龙的外表。谓虚有其表。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(1982, '0:3:4', '真龙活现', '\n【 zhēn　lóng　huó　xiàn 】\n			', '\n形容逼真。\n			', '\n蒋光慈《短裤党》二：“他每一次所做的传单，都是说的真龙活现也似的。”\n			', '\n计策的内容和保证是：要求每个前去执行任务的小伙子大胆说谎话，而且谎话要说得有鼻子有眼，～，毫不含糊。\n			'),
(1983, '0:3:4', '真龙天子', '\n【 zhēn　lóng　tiān　zǐ 】\n			', '\n旧时认为皇帝是天上的真龙下凡，因以为皇帝的代称。\n			', '\n姚雪垠《李自成》第一卷第二十八章：“她想，既然人们都说明朝的气数完了，真龙天子已经出世，说不定这真龙天子就是李闯王。”\n			', '\n～一出世，天下也许就太平了。\n			'),
(1984, '0:3:4', '祖龙之虐', '\n【 zǔ　lóng　zhī　nüè 】\n			', '\n指秦始皇焚书坑儒。祖龙，指秦始皇。\n			', '\n清蒲松龄《聊斋志异·书痴》：“异史氏曰：‘天下之物，积则招妒，好则生魔：女之妖，书之魔也。事近怪诞，治之未为不可；而祖龙之虐，不已惨乎！其存心之私，更宜得怨毒之报也。’”\n			', '\n暂无\n			'),
(1985, '0:3:4', '掷杖成龙', '\n【 zhì　zhàng　chéng　lóng 】\n			', '\n后以之为典，借指还乡。\n			', '\n传说东汉费长房见一老翁挂着一把壶卖药，然后就跳进壶里去。第二天，费去拜访他，和他一起入壶，但见房屋华丽，酒菜也很好。费于是向老翁学道，后来骑着老翁所给的竹杖回家，投杖于葛陂，变成一条龙。\n			', '\n偶然～去，又过蓬莱日主祠。\n			'),
(1986, '0:3:5', '笔底龙蛇', '\n【 bǐ　dǐ　lóng　shé 】\n			', '\n犹言笔走龙蛇。形容书法生动而有气势。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第三十一回：“闻公博学广记，笔底龙蛇，真才子也。”\n			', '\n暂无\n			'),
(1987, '0:3:5', '杯弓蛇影', '\n【 bēi　gōng　shé　yǐng 】\n			', '\n将映在酒杯里的弓影误认为蛇。比喻因疑神疑鬼而引起恐惧。\n			', '\n《晋书·乐广传》记载有人作客饮酒，见酒杯里有条蛇，喝后吓得病了。后来知道这蛇原来是屋角上一张弓照在杯里的影子，他的病就好了。\n			', '\n金玦厖凉含隐痛，～负奇冤。（清·黄遵宪《感事》诗）\n			'),
(1988, '0:3:5', '壁间蛇影', '\n【 bì　jiān　shé　yǐng 】\n			', '\n犹“杯弓蛇影”。形容疑神疑鬼，徒自惊扰。\n			', '\n据汉应劭《风俗通·怪神》所记：杜宣饮酒，见杯中似有蛇，酒后胸腹作痛，多方医治不愈；后知为壁上所悬赤弩照于杯，形如蛇，病即愈。《晋书·乐广传》也有类似记述。\n			', '\n若于此处稍参不破，则昔人所谓～，足以生疑而致病。\n			'),
(1989, '0:3:5', '杯蛇鬼车', '\n【 bēi　shé　guǐ　chē 】\n			', '\n指因疑虑、惊惧导致幻觉中产生的怪物。杯蛇，“杯弓蛇影”之省；鬼车，传说中的九头鸟。\n			', '\n《水浒传》第九五回：“况我兵惊恐，凡杯蛇鬼车，风兵草甲，无往非撼志之物。”\n			', '\n暂无\n			'),
(1990, '0:3:5', '杯蛇幻影', '\n【 bēi　shé　huàn　yǐng 】\n			', '\n比喻疑神疑鬼，自相惊扰。同“杯弓蛇影”。\n			', '\n《花月痕》第五回：“杯蛇幻影，鬼蜮含沙。萦愁绪以回肠，蔓牵瓜落；拭泪珠而洗面，藕断丝长。”\n			', '\n暂无\n			'),
(1991, '0:3:5', '杯影蛇弓', '\n【 bēi　yǐng　shé　gōng 】\n			', '\n比喻因疑神疑鬼而引起恐惧。同“杯弓蛇影”。\n			', '\n清·魏秀仁《花月痕》第四十五回：“杯影蛇弓魔人幻，帷灯匣剑鬼生疑。”\n			', '\n暂无\n			'),
(1992, '0:3:5', '笔走龙蛇', '\n【 bǐ　zǒu　lóng　shé 】\n			', '\n形容书法生动而有气势。\n			', '\n唐·李白《草书歌行》：“时时只见龙蛇走，左盘右蹙旭惊电。”\n			', '\n秀才肖王宾胸藏锦绣，～。（明·凌濛初《初刻拍案惊奇》卷二十）\n			'),
(1993, '0:3:5', '杯中蛇影', '\n【 bēi　zhōng　shé　yǐng 】\n			', '\n比喻因疑神疑鬼而引起恐惧。同“杯弓蛇影”。\n			', '\n明·程登吉《幼学琼林·鸟兽》：“杯中蛇影，自起猜疑；塞翁失马，难分祸福。龙驹凤雏，晋闵鸿夸吴中陆士龙之异；伏龙凤雏，司马徽称孔明庞士元之奇。”\n			', '\n～，《世说》以为乐广事，《风俗通》以为主簿杜宣事。\n			'),
(1994, '0:3:5', '长蛇封豕', '\n【 cháng　shé　fēng　shǐ 】\n			', '\n长蛇和大猪。比喻贪暴者。\n			', '\n宋·李纲《召赴文字库祗候引对札子》：“长蛇封豕，蓄锐深谋，待时而发，其意不浅。”\n			', '\n凶岁大兵俨相接，～欲安归。\n			'),
(1995, '0:3:5', '草蛇灰线', '\n【 cǎo　shé　huī　xiàn 】\n			', '\n比喻事物留下隐约可寻的线索和迹象。\n			', '\n《花月痕》第五回回评：“写秋痕，采秋，则更用暗中之明，明中之暗……草蛇灰线，马迹蛛丝，隐于不言，细入无间。”\n			', '\n该处市面，极为恐慌，乱机日深，皆由此等～而来。\n			'),
(1996, '0:3:5', '春蛇秋蚓', '\n【 chūn　shé　qiū　yǐn 】\n			', '\n比喻字写得不好，弯弯曲曲，象蚯蚓和蛇爬行的痕迹。\n			', '\n明·宋濂《\n			', '\n暂无\n			'),
(1997, '0:3:5', '春蚓秋蛇', '\n【 chūn　yǐn　qiū　shé 】\n			', '\n比喻字写得不好，弯弯曲曲，象蚯蚓和蛇爬行的痕迹。\n			', '\n《晋书·王羲之传》：“行之若萦春蚓，字字如绾秋蛇。”\n			', '\n蜂腰鹤膝嘲希逸，～病子云。（宋·苏轼《和孔密州五绝·和流杯石上草书小诗》）\n			'),
(1998, '0:3:5', '打草惊蛇', '\n【 dǎ　cǎo　jīng　shé 】\n			', '\n原比喻惩甲菟乙。后多比喻做法不谨慎，反使对方有所戒备。\n			', '\n明·郎瑛《七修类稿》卷二十四：“打草惊蛇，乃南唐王鲁为当涂令，日营资产，部人诉主簿贪污，鲁曰：‘汝虽打草，吾已惊蛇。’”\n			', '\n空自去“～”，倒吃他做了手脚，却是不好。（明·施耐庵《水浒全传》第二十九回）\n			'),
(1999, '0:3:5', '打草蛇惊', '\n【 dǎ　cǎo　shé　jīng 】\n			', '\n打草惊了草里的蛇。原比喻惩罚了甲而使乙有所警觉。后多比喻做法不谨慎，反使对方有所戒备。同“打草惊蛇”。\n			', '\n《景德传灯录·省念禅师》：“问：‘四众围观，师说何法？’师曰：‘打草蛇惊’”\n			', '\n但恐见黄商伯狼狈后，～，亦不敢放手做事耳。\n			'),
(2000, '0:3:5', '打蛇打七寸', '\n【 dǎ　shé　dǎ　qī　cùn 】\n			', '\n比喻说话做事必须抓住主要环节。\n			', '\n<span class="C999">暂无</span>\n			', '\n但做事也要“～”才妙，你先生请上裁。（清·吴敬梓《儒林外史》第十四回）\n			'),
(2001, '0:3:5', '毒蛇猛兽', '\n【 dú　shé　měng　shòu 】\n			', '\n泛指对人类生命有威胁的动物。比喻贪暴者。\n			', '\n孙中山《民权主义》第一讲：“在人同兽争的时代，因为不知道何时有毒蛇猛兽来犯，所以人类时时刻刻不知生死。”\n			', '\n那地方本来‘人’迹稀少，～横行。\n			'),
(2002, '0:3:5', '斗折蛇行', '\n【 dǒu　zhé　shé　xíng 】\n			', '\n斗折：像北斗星的排列一样曲折。像北斗星一样弯曲，像蛇一样曲折行进。形容道路曲折蜿蜒。\n			', '\n唐·柳宗元《永州八记·小石潭记》：“漂西南而望，斗折蛇行，明灭可见。”\n			', '\n暂无\n			'),
(2003, '0:3:5', '佛口蛇心', '\n【 fó　kǒu　shé　xīn 】\n			', '\n比喻话虽说得好听，心肠却极狠毒。\n			', '\n宋·释普济《五灯会元》卷二十：“诸佛出世，打劫杀人，祖师西来，吹风放火，古今善知识佛口蛇心，天下衲僧自投笼槛。”\n			', '\n我面貌虽丑，心地却是善良，不似你～。（清·钱彩《说岳全传》第七十回）\n			'),
(2004, '0:3:5', '飞鸟惊蛇', '\n【 fēi　niǎo　jīng　shé 】\n			', '\n像飞鸟入林，受惊的蛇窜入草丛一样。形容草书自然流畅。\n			', '\n《法书苑》：“唐时一僧释亚楼善草书，曾自题一联：‘飞鸟入林，惊蛇入草。’”\n			', '\n暂无\n			'),
(2005, '0:3:5', '封豕长蛇', '\n【 fēng　shǐ　cháng　shé 】\n			', '\n封：大；封豕：大猪；长蛇：大蛇。贪婪如大猪，残暴如大蛇。比喻贪暴者、侵略者。\n			', '\n《左传·定公四年》：“吴为封豕长蛇，以荐食上国。”\n			', '\n而今而后，所当有利兵坚盾，环卫其身，毋俾～，荐食上国。（鲁迅《集外集拾遗·破恶声论》）\n			'),
(2006, '0:3:5', '蝮蛇螫手，壮士解腕', '\n【 fù　shé　shì　shǒu，zhuàng　shì　jiě　wàn 】\n			', '\n手腕被腹蛇咬伤，便立即截断，以免毒液延及全身，危及生命。比喻事到紧要关头，必须下决心当机立断。也比喻牺牲局部，照顾全局。\n			', '\n《三国志·魏书·陈泰传》：“古人有言，蝮蛇螯手，壮士解其腕。”\n			', '\n～，英雄作事不顾小名小义，今贪能容之虚名，受诛夷之实祸，还恐噬脐无及。（《隋唐演义》第四十六回）\n			'),
(2007, '0:3:5', '佛心蛇口', '\n【 fó　xīn　shé　kǒu 】\n			', '\n比喻话虽说得好听，心肠却极狠毒。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2008, '0:3:5', '封豨修蛇', '\n【 fēng　xī　yǒu　shé 】\n			', '\n比喻贪暴者、侵略者。同“封豕长蛇”。\n			', '\n《淮南子·修务训》：“吴为封豨修蛇，蚕食上国。”\n			', '\n自无妄兴暴，皇祚寖微，～，行灾中国。\n			'),
(2009, '0:3:5', '弓影杯蛇', '\n【 gōng　yǐng　bēi　shé 】\n			', '\n见“弓影浮杯”。犹言杯弓蛇影。形容疑神疑鬼，自相惊扰。\n			', '\n清·沈复《浮生六记·闺房记乐》：“一灯如豆，罗帐低垂，弓影杯蛇，惊神未定。”\n			', '\n暂无\n			'),
(2010, '0:3:5', '行行蛇蚓', '\n【 háng　háng　shé　yǐn 】\n			', '\n形容字体如蛇蚓盘绕，难以辨认。\n			', '\n《晋书·王羲之传》：“行行若萦春蚓，字字如绾秋蛇。”宋·利登《野农谣》诗：“行行蛇蚓字相续，野农不识何由读？”\n			', '\n暂无\n			'),
(2011, '0:3:5', '骇龙走蛇', '\n【 hài　lóng　zǒu　shé 】\n			', '\n龙蛇被掠走。形容声势浩大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2012, '0:3:5', '画蛇添足', '\n【 huà　shé　tiān　zú 】\n			', '\n画蛇时给蛇添上脚。比喻做了多余的事，非但无益，反而不合适。\n			', '\n《战国策·齐策二》：“蛇固无足，子安能，而外学其文，虽有贤师良友，若画脂镂冰，费日损功。”\n			', '\n将军功绩已成，威声大震，可以止矣。今若前进，倘不如意，正如“～”也。（明·施耐庵《水浒全传》第一百十回）\n			'),
(2013, '0:3:5', '画蛇著足', '\n【 huà　shé　zhuó　zú 】\n			', '\n比喻做了多余的事，非但无益，反而不合适。同“画蛇添足”。\n			', '\n唐·韩愈《感春》诗之四：“画蛇著足无处用，两鬓雪白趋埃尘。”\n			', '\n暂无\n			'),
(2014, '0:3:5', '虎头蛇尾', '\n【 hǔ　tóu　shé　wěi 】\n			', '\n头大如虎，尾细如蛇。比喻开始时声势很大，到后来劲头很小，有始无终。\n			', '\n元·康进之《李逵负棘》第二折：“则为你两头白面搬兴废，转背言词说是非，这厮敢狗行狼心，虎头蛇尾。”\n			', '\n小奇也许会写得好，就是她有一个毛病，“～”。（冰心《陶奇的星期日记》）\n			'),
(2015, '0:3:5', '惊蛇入草', '\n【 jīng　shé　rù　cǎo 】\n			', '\n形容草书写得矫健而活泼。\n			', '\n《宣和书谱·草书七》：“若飞鸟出林，惊蛇入草。”\n			', '\n作一戈如百钧弩，作一点如高峰堕石，作一牵如百岁枯藤，作一放纵，如～。（明·李贽《初潭集·师友四》）\n			'),
(2016, '0:3:5', '鲸吞蛇噬', '\n【 jīng　tūn　shé　shì 】\n			', '\n像鲸鱼和蛇一样吞食。比喻侵吞兼并。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2017, '0:3:5', '龙鬼蛇神', '\n【 lóng　guǐ　shé　shén 】\n			', '\n比喻奇诡怪僻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2018, '0:3:5', '龙屈蛇伸', '\n【 lóng　qū　shé　shēn 】\n			', '\n比喻君子受屈而小人得志。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2019, '0:3:5', '龙蛇飞动', '\n【 lóng　shé　fēi　dòng 】\n			', '\n仿佛龙飞腾，蛇游动。形容书法气势奔放，笔力劲健。\n			', '\n宋·苏轼《西江月·平山堂》词：“十年不见老仙翁，壁上龙蛇飞动。”\n			', '\n道士卷起袍口，磨得墨浓，蘸得笔饱，在照壁上～，挥下碗口大小的二十八字。（清·陈忱《水浒后传》第三十七回）\n			'),
(2020, '0:3:5', '龙蛇飞舞', '\n【 lóng　shé　fēi　wǔ 】\n			', '\n形容书法笔势遒劲生动。\n			', '\n清·李汝珍《镜花缘》第八十八回：“闺臣听了，把神凝了一凝，只得打起精神，举起笔来，刷、刷、刷如龙蛇飞舞一般，一连写了几句。”\n			', '\n只记得纸上～，笔势很好看的。（冰心《往事·六一姊》）\n			'),
(2021, '0:3:5', '龙蛇混杂', '\n【 lóng　shé　hùn　zá 】\n			', '\n比喻好人和坏人混在一起。\n			', '\n《敦煌变文集·伍子胥变文》：“皂帛难分，龙蛇混杂。”宋·释道元《景德传灯录》：“凡圣同居，龙蛇混杂。”\n			', '\n此时～，是非莫辨，安知我辈不是姜尚之所使耳？在将军不得不疑。（明·许仲琳《封神演义》第九十三回）\n			'),
(2022, '0:3:5', '灵蛇之珠', '\n【 líng　shé　zhī　zhū 】\n			', '\n即隋珠。原比喻无价之宝。后也比喻非凡的才能。\n			', '\n《淮南子·说览冥训》：“譬如惰侯之珠，和氏之璧，得之者富，失之者贫。”\n			', '\n当此之时，人人自谓握～，家家自谓抱荆山之玉。（三国魏·曹植《与汤德祖书》）\n			'),
(2023, '0:3:5', '龙头蛇尾', '\n【 lóng　tóu　shé　wěi 】\n			', '\n比喻开头盛大，结尾衰减。\n			', '\n宋·朱熹《朱子语类》第130卷：“如在欧公文集序，先说得许多天来底大，恁地好了，到结束处，却只如此，盖不止龙头蛇尾矣。”\n			', '\n闹了七八年，才～地告了终结。\n			'),
(2024, '0:3:5', '牛鬼蛇神', '\n【 niú　guǐ　shé　shén 】\n			', '\n牛头的鬼，蛇身的神。原形容虚幻怪诞。后比喻社会上形形色色的坏人。\n			', '\n唐·李贺《李贺集序》：“鲸吸鳌掷，牛鬼蛇神，不足为其虚荒诞幻也。”\n			', '\n暂无\n			'),
(2025, '0:3:5', '强龙不压地头蛇', '\n【 qiáng　lóng　bù　yā　dì　tóu　shé 】\n			', '\n比喻有能耐的人也难对付盘踞当地的恶势力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2026, '0:3:5', '人心不足蛇吞象', '\n【 rén　xīn　bù　zú　shé　tūn　xiàng 】\n			', '\n比喻人贪心不足，就象蛇想吞食大象一样。\n			', '\n《山海经·海内南经》：“巴蛇食象，三岁而出其骨。”战国楚·屈原《天问》：“一蛇吞象，厥大何如？”\n			', '\n罗洪宪诗：“～，世事到头螳捕蝉。”（清·翟灏《通俗编·禽鱼》）\n			'),
(2027, '0:3:5', '豕分蛇断', '\n【 shǐ　fēn　shé　duàn 】\n			', '\n比喻支离破碎。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2028, '0:3:5', '蛇化为龙，不变其文', '\n【 shé　huà　wéi　lóng，bù　biàn　qí　wén 】\n			', '\n比喻无论形式上怎样变化，实质还是一样。\n			', '\n《史记·外戚世家》：“蛇化为龙，不变其文；家化为国，不变其姓。”\n			', '\n暂无\n			'),
(2029, '0:3:5', '蛇口蜂针', '\n【 shé　kǒu　fēng　zhēn 】\n			', '\n比喻恶毒的言词和手段。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2030, '0:3:5', '蛇食鲸吞', '\n【 shé　shí　jīng　tūn 】\n			', '\n蛇食：像蛇一样吞食。鲸吞：像鲸一样吞咽。比喻强者逐步并吞弱者。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2031, '0:3:5', '三蛇七鼠', '\n【 sān　shé　qī　shǔ 】\n			', '\n比喻为害的东西多。\n			', '\n清·翟灏《通俗编·禽鱼》：“一亩之地，三蛇七鼠。”\n			', '\n暂无\n			'),
(2032, '0:3:5', '蛇头鼠眼', '\n【 shé　tóu　shǔ　yǎn 】\n			', '\n形容人的面相丑恶，心术不正。亦作“蛇眉鼠眼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2033, '0:3:5', '蛇心佛口', '\n【 shé　xīn　fó　kǒu 】\n			', '\n佛的嘴巴，蛇的心肠。比喻话虽说得好听，心肠却极狠毒。\n			', '\n宋·释普济《五灯会元》卷二十：“诸佛出世，打劫杀人，祖师西来，吹风放火，古今善知识佛口蛇心，天下衲僧自投笼槛。”\n			', '\n王魁你恶狠狠～，我便到黄泉，也须把你这歹魂儿勾，定与我倒断了前番呪。\n			'),
(2034, '0:3:5', '蛇蝎为心', '\n【 shé　xiē　wéi　xīn 】\n			', '\n蝎：一种蜘蛛类的毒虫。形容心肠狠毒。\n			', '\n元·无名氏《抱妆盒》第二折：“便是蛇蝎心肠，不似恁般毒害。”\n			', '\n暂无\n			'),
(2035, '0:3:5', '蛇蝎心肠', '\n【 shé　xiē　xīn　cháng 】\n			', '\n蝎：一种蜘蛛类的毒虫。形容心肠狠毒。\n			', '\n元·无名氏《抱妆盒》第二折：“便是蛇蝎心肠，不似恁般毒害。”\n			', '\n暂无\n			'),
(2036, '0:3:5', '蛇影杯弓', '\n【 shé　yǐng　bēi　gōng 】\n			', '\n把酒杯中的弓影当成了蛇。比喻因疑神疑鬼而自惊自怕。\n			', '\n汉·应劭《风俗通义·世间多有见怪》：“时北壁上有悬赤弩照于杯，形如蛇。宣畏恶之，然不敢不饮。”\n			', '\n人亡物在公子填词，～颦卿绝粒。\n			'),
(2037, '0:3:5', '蛇欲吞象', '\n【 shé　yù　tūn　xiàng 】\n			', '\n蛇想吞下大象。比喻贪欲极大。\n			', '\n《山海经·海内南经》：“巴蛇食象，三岁而出其骨。”战国楚·屈原《天问》：“一蛇吞象，厥大何如？”\n			', '\n暂无\n			'),
(2038, '0:3:5', '岁在龙蛇', '\n【 suì　zài　lóng　shé 】\n			', '\n岁，岁星；龙，指辰；蛇，指巳。后指命数当终。\n			', '\n《后汉书·郑玄传》：“五年春，梦孔子告之曰：‘起，起，今年岁在辰，来年岁在巳。’既寤，以谶合之，知当命终，有顷寝疾。”李贤注：“北齐刘昼《高才不遇传》论玄曰‘辰为龙，巳为蛇，岁至龙蛇。贤人嗟，玄以谶合之’，盖谓此也。”\n			', '\n历险阻之驰驱，风如牛马；慨身宫之偃蹇，～。\n			'),
(2039, '0:3:5', '贪蛇忘尾', '\n【 tān　shé　wàng　wěi 】\n			', '\n比喻只图眼前利益而不考虑后果。\n			', '\n宋·文莹《玉壶清话》：“贪蛇前行，必忘其尾。”\n			', '\n暂无\n			'),
(2040, '0:3:5', '为虺弗摧，为蛇若何', '\n【 wéi　huǐ　fú　cuī，wéi　shé　ruò　hé 】\n			', '\n虺：小蛇；弗：不；摧：消灭。小蛇不打死，大了就难办。比喻不乘胜将敌人歼灭，必有后患。\n			', '\n《国语·吴语》：“夫越王好信以爱民，四方归之；年谷时熟，日长炎炎，及吾犹可以战也。为虺弗摧，为蛇将若何？”\n			', '\n暂无\n			'),
(2041, '0:3:5', '为蛇画足', '\n【 wéi　shé　huà　zú 】\n			', '\n比喻做事节外生枝，不但无益，反而害事。\n			', '\n《战国策·齐策二》：“楚有祠者，赐其舍人卮酒。舍人相谓曰：‘数人饮之不足，一人饮之有余；请画地为蛇，先成者饮酒。’一人蛇先成，引酒且饮之，乃左手持卮，右手画蛇，曰：‘吾能为之足。’未成，一人之蛇成，夺其卮曰：‘蛇固无足，子安能为之\n			', '\n暂无\n			'),
(2042, '0:3:5', '握蛇骑虎', '\n【 wò　shé　qí　hǔ 】\n			', '\n比喻处境极险恶。\n			', '\n《魏书·彭城王传》：“彦和手握蛇骑虎，不觉艰难。”\n			', '\n暂无\n			'),
(2043, '0:3:5', '为蛇添足', '\n【 wéi　shé　tiān　zú 】\n			', '\n比喻做事节外生枝，不但无益，反而害事。同“为蛇画足”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2044, '0:3:5', '枭蛇鬼怪', '\n【 xiāo　shé　guǐ　guài 】\n			', '\n比喻丑恶之徒。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2045, '0:3:5', '膝语蛇行', '\n【 xī　yǔ　shé　xíng 】\n			', '\n跪着说话，伏地而行。极言其畏服。\n			', '\n明·袁宏道《徐文长传》：“是时公督数边兵，威振东南，介胄之事，膝语蛇行，不敢举头。”\n			', '\n暂无\n			'),
(2046, '0:3:5', '虚与委蛇', '\n【 xū　yǔ　wēi　yí 】\n			', '\n虚：假；委蛇：随便应顺。指对人虚情假意，敷衍应酬。\n			', '\n《庄子·应帝王》：“乡吾示之以未始出吾宗，吾与之虚而委蛇。”\n			', '\n他也要同你～了。（闻一多《诗与批评·戏剧的歧途》）\n			'),
(2047, '0:3:5', '养虺成蛇', '\n【 yǎng　huǐ　chéng　shé 】\n			', '\n比喻纵容敌人，听任其强大起来。\n			', '\n《国语·吴语》：“为虺弗摧，为蛇将若何？”\n			', '\n暂无\n			'),
(2048, '0:3:5', '一龙一蛇', '\n【 yī　lóng　yī　shé 】\n			', '\n比喻人的处藏或出或处，或显或隐，随着情况的不同而变更。\n			', '\n《管子·枢言》：“一龙一蛇，一日五化之谓周。”《后汉书·冯衍传》：“一龙一蛇，与道翱翔，与时变化，夫岂守一节哉？”\n			', '\n暂无\n			'),
(2049, '0:3:5', '一年被蛇咬，十年怕井绳', '\n【 yī　nián　bèi　shé　yǎo，shí　nián　pà　j 】\n			', '\n比喻在某件事情上吃过苦头，以后一碰到类似的事情就害怕。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2050, '0:3:5', '一蛇两头', '\n【 yī　shé　liǎng　tóu 】\n			', '\n比喻阴险凶恶的人。\n			', '\n唐·韩愈《永贞行》诗：“一蛇两头见未曾，怪鸟鸣唤令人憎。”\n			', '\n暂无\n			'),
(2051, '0:3:5', '一着被蛇咬，三年怕井绳', '\n【 yī　zhāo　bèi　shé　yǎo，sān　nián　pà　j 】\n			', '\n比喻在某件事情上吃过苦头，以后一碰到类似的事情就害怕。\n			', '\n宋·释普济《五灯会元·龙门远禅师法嗣》：“问：‘狗子还有佛性也无。’赵州道：‘无意者如何？’师曰：‘一度著蛇咬，怕风了断井索。’”\n			', '\n南星摸着头上的大包，颇有点“～”的神气。\n			'),
(2052, '0:3:5', '一字长蛇阵', '\n【 yī　zì　cháng　shé　zhèn 】\n			', '\n排列成一长条的阵势。形容排列成一长条的人或物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2053, '0:3:5', '长虺成蛇', '\n【 zhǎng　huǐ　chéng　shé 】\n			', '\n虺：小蛇，毒蛇。指养奸遗患。比喻纵容敌人，听任其强大起来。而留下后患。\n			', '\n《洛阳伽蓝记·建中寺》：“养虎自啮，长虺成蛇。”\n			', '\n暂无\n			'),
(2054, '0:3:6', '兵马不动，粮草先行', '\n【 bīng　mǎ　bù　dòng，liáng　cǎo　xiān　xíng 】\n			', '\n作战时兵马还没出动，军用粮草的运输要先行一步。后泛指行动前须作好准备工作。\n			', '\n《南皮县志·风土志下·歌谣》：“兵马不动，粮草先行。年年防歉，夜夜防贼。”\n			', '\n暂无\n			'),
(2055, '0:3:6', '班马文章', '\n【 bān　mǎ　wén　zhāng 】\n			', '\n汉代史学家司马迁与班固的并称。泛指可与班固、司马迁相比美的文章。\n			', '\n明·无名氏《鸣凤记·邹林游学》：“夔龙礼乐承先范，班马文章勘墨铅。”\n			', '\n～由夙慧，庾鲍诗句实前缘。\n			'),
(2056, '0:3:6', '车怠马烦', '\n【 chē　dài　mǎ　fán 】\n			', '\n车危且马疲。形容旅途困乏。怠：通“殆”。同“车殆马烦”。\n			', '\n南朝·宋·鲍照《代白紵舞歌词》之一：“车怠马烦客忘归，兰膏明烛承夜辉。”\n			', '\n暂无\n			'),
(2057, '0:3:6', '持戈试马', '\n【 chí　gē　shì　mǎ 】\n			', '\n比喻作好准备，跃跃欲试。\n			', '\n《红楼梦》第七九回：“那金桂见丈夫旗纛渐倒，婆婆良善，也就渐渐的持戈试马。“\n			', '\n暂无\n			'),
(2058, '0:3:6', '窗间过马', '\n【 chuāng　jiān　guò　mǎ 】\n			', '\n形容时间过得很快。\n			', '\n元·吴弘道《醉高歌·叹世》曲：“风尘天外飞沙，日月窗间过马。风俗扫地伤王化，谁正人伦大雅。”\n			', '\n暂无\n			'),
(2059, '0:3:6', '车马辐辏', '\n【 chē　mǎ　fú　còu 】\n			', '\n辐辏：形容人或货物像车轮上的辐条聚集在车毂上一样。指车马集聚拥挤。\n			', '\n清·文康《儿女英雄传》缘起首回：“两旁歧途曲巷中，有无数的车马辐辏，冠盖飞扬，人往人来，十分热闹。”\n			', '\n暂无\n			'),
(2060, '0:3:6', '策马飞舆', '\n【 cè　mǎ　fēi　yú 】\n			', '\n指驾马车疾行。\n			', '\n汉·赵晔《吴越春秋·勾践归国外传》：“车驰人走，越王策马飞舆，遂复宫阙。”\n			', '\n暂无\n			'),
(2061, '0:3:6', '车马骈阗', '\n【 chē　mǎ　pián　tián 】\n			', '\n车马聚集很多。形容非常热闹。\n			', '\n唐·杨炯《晦日药园诗序》：“衣冠杂沓，出城阙面盘游；车马骈阗，俯河滨而帐饮。”\n			', '\n游人尽欢，见～往还。\n			'),
(2062, '0:3:6', '驰马试剑', '\n【 chí　mǎ　shì　jiàn 】\n			', '\n驰马：骑马飞跑；试：用。跑马舞剑。形容人骑马练剑习武。\n			', '\n战国·邹·孟轲《孟子·滕文公上》：“吾他日未尝学问，好驰马试剑。”\n			', '\n因此终日教导琼英～。\n			'),
(2063, '0:3:6', '车马填门', '\n【 chē　mǎ　tián　mén 】\n			', '\n车子充满门庭，比喻宾客很多。同“车马盈门”。\n			', '\n《北史·拓跋深传》：“是故馀人摄选，车马填门；及臣居边，宾游罕至。”\n			', '\n这里接连着亲戚族中的人来来去去，闹闹穰穰，～，貂蝉满座。\n			'),
(2064, '0:3:6', '吹牛拍马', '\n【 chuī　niú　pāi　mǎ 】\n			', '\n吹牛：吹牛皮；拍马：拍马屁。指爱说大话，喜欢自我吹嘘和一味逢迎巴结别人的行为。\n			', '\n鲁迅《伪自由书·后记》：“我想假如曾某能把那种吹牛拍马的精力……用到求实学一点上，所得不是要更多些吗？”\n			', '\n简直是一帮～的坏蛋。\n			'),
(2065, '0:3:6', '车尘马迹', '\n【 chē　zhén　mǎ　jì 】\n			', '\n指车马行过的痕迹。\n			', '\n宋·朱熹《卧龙庵记》：“余既惜其出于荒堙废壤之余，而又幸其深阻敻绝，非车尘马迹之所能到。”\n			', '\n暂无\n			'),
(2066, '0:3:6', '东风马耳', '\n【 dōng　fēng　mǎ　ěr 】\n			', '\n比喻把别人的话当作耳边风。\n			', '\n唐·李白《答王十二寒夜独钓有怀》诗：“世人闻此皆掉头，有如东风射马耳。”\n			', '\n我当初劝谏你多少来，你就当东风吹马耳，反被旁人说我是苛待妾的，今日你可省得了！\n			'),
(2067, '0:3:6', '东风射马耳', '\n【 dōng　fēng　shè　mǎ　ěr 】\n			', '\n射：射出。比喻把别人的话当作耳边风，充耳不闻，无动于衷。\n			', '\n唐·李白《答王十二寒夜独酌有怀》诗：“世人闻此皆掉头，有如东风射马耳。”\n			', '\n我的话对你来说还不是～了。\n			'),
(2068, '0:3:6', '斗鸡走马', '\n【 dòu　jī　zǒu　mǎ 】\n			', '\n斗鸡赛马。古代的赌博游戏。\n			', '\n《汉书·宣帝纪》：“[宣帝]受《诗》于东海澓中翁，高材好学，然亦喜游侠，斗鸡走马。”\n			', '\n鸣鸾佩玉青云间，～红尘里。\n			'),
(2069, '0:3:6', '大马金刀', '\n【 dà　mǎ　jīn　dāo 】\n			', '\n①形容豪爽，气派大。②形容说话直率锋利，不留情面。\n			', '\n《儿女英雄传》第八回：“那姑娘大马金刀的坐在上面，反眉一皱，说：‘你怎么这么俗啊？起来！’”\n			', '\n您再别说甚么野蛮文明，安国堤起这两个字儿，已受了一顿～儿的申斥，不是嘴里会辩，恐怕脑袋儿都靠不住。\n			'),
(2070, '0:3:6', '得马失马', '\n【 dé　mǎ　shī　mǎ 】\n			', '\n指世事多变，得失无常。\n			', '\n典出《淮南子·人间训》。见“得马生灾”。\n			', '\n暂无\n			'),
(2071, '0:3:6', '得马生灾', '\n【 dé　mǎ　shēng　zāi 】\n			', '\n指因福而得祸。\n			', '\n《淮南子·人间训》：“近塞上之人，有善术者，马无故亡而入胡……居数月，其马将胡骏马而归，人皆贺之。其父曰：‘此何遽不能为祸乎？’家富良马，其子好骑，堕而折其髀。”\n			', '\n维鹈受刺因吾过，～念尔冤。\n			'),
(2072, '0:3:6', '得马折足', '\n【 dé　mǎ　shé　zú 】\n			', '\n指因福而得祸。\n			', '\n典出《淮南子·人间训》。见“得马生灾”。\n			', '\n～祸，亡羊多歧悲。\n			'),
(2073, '0:3:6', '代马望北', '\n【 dài　mǎ　wàng　běi 】\n			', '\n比喻人心眷恋故土，不愿老死他乡。\n			', '\n汉·王符《潜夫论·实边》：“且夫人重迁，恋慕坟墓，贤不肖之所同也。……代马望北，狐死首丘，边民谨顿，尢恶内留。”\n			', '\n暂无\n			'),
(2074, '0:3:6', '单枪独马', '\n【 dān　qiāng　dú　mǎ 】\n			', '\n比喻孤身一人或单独行动。\n			', '\n清·蘧园《负曝闲谈》第二回：“他横竖是单枪独马，一无牵挂，当下由杭赴苏，寻找了那位帮带。”\n			', '\n暂无\n			'),
(2075, '0:3:6', '丹书白马', '\n【 dān　shū　bái　mǎ 】\n			', '\n古代帝王赐给功臣享有世袭爵位和免罪等特权的证件时，宰白马歃其血，以示坚守誓约，后人称为“丹书白马”。\n			', '\n《汉书·高惠高后文功臣表》：“申以丹书之信，重以白马之盟。”颜师古注：“白马之盟，谓刑白马歃其血以为盟也。”\n			', '\n开国承家，～。\n			'),
(2076, '0:3:6', '二童一马', '\n【 èr　tóng　yī　mǎ 】\n			', '\n用以指少年时代的好友。\n			', '\n南朝·宋·刘义庆《世说新语·品藻》：“殷侯既废，桓公语诸人曰：‘少时与渊源共骑竹马，我弃去，己辄取之，故当出我下。’”\n			', '\n烦借问，～，几时入尉瞻仪？\n			'),
(2077, '0:3:6', '风吹马耳', '\n【 fēng　chuī　mǎ　ěr 】\n			', '\n比喻对别人的话无动于衷。\n			', '\n克非《春潮急》二五：“我嘴皮都磨起茧巴，他都当成风吹马耳。”\n			', '\n暂无\n			'),
(2078, '0:3:6', '风车雨马', '\n【 fēng　chē　yǔ　mǎ 】\n			', '\n指神灵的车马。亦用以比喻迅疾、快速。\n			', '\n唐·李商隐《燕台诗·冬》之四：“风车雨马不持去，蜡独啼红怨天曙。”\n			', '\n暂无\n			'),
(2079, '0:3:6', '风车云马', '\n【 fēng　chē　yún　mǎ 】\n			', '\n指神灵的车马。亦用以比喻迅疾、快速。同“风车雨马”。\n			', '\n明·陈子龙《与客任城太白酒楼歌》：“古来历落吾辈人，风车云马知何极？”\n			', '\n暂无\n			'),
(2080, '0:3:6', '风马不接', '\n【 fēng　mǎ　bù　jiē 】\n			', '\n犹言风马牛不相及。\n			', '\n《宋书·隐逸传·王弘之》：“凡祖离送别，必在有情，下官与殷风马不接，无缘扈从。”\n			', '\n暂无\n			'),
(2081, '0:3:6', '放马华阳', '\n【 fàng　mǎ　huá　yáng 】\n			', '\n指不再用兵。\n			', '\n北魏·郦道元《水经注·河四》：“武王伐纣，天下既定，王巡岳渎，放马华阳，散牛桃林，即此处也，其中多野马。”\n			', '\n暂无\n			'),
(2082, '0:3:6', '风马牛', '\n【 fēng　mǎ　niú 】\n			', '\n风：放逸，走失。指齐楚两地相离甚远，马牛不会走失至对方地界。后用以比喻事物之间毫不相干。同“风马牛不相及”。\n			', '\n唐·段成式《酉阳杂俎·盗侠》：“唐责之：‘某与公风马牛耳，不意盱眙相遇，实慕君子，何至驺卒不若也。’”\n			', '\n至于释迦牟尼，可更与文艺界～了。\n			'),
(2083, '0:3:6', '风马云车', '\n【 fēng　mǎ　yún　chē 】\n			', '\n指神灵的车马。\n			', '\n唐·柳宗元《雷塘祷雨文》：“风马云车，肃焉徘徊。”\n			', '\n～历历，见桂葆乍迎娇如雪。\n			'),
(2084, '0:3:6', '风牛马不相及', '\n【 fēng　niú　mǎ　bù　xiāng　jí 】\n			', '\n比喻事物彼此毫不相干。同“风马牛不相及”。\n			', '\n梁启超《天演学初祖达尔文之学说及其传略》：“夫孰知兰之生产，与彼风牛马不相及之猫，有此若大关系乎？”\n			', '\n暂无\n			'),
(2085, '0:3:6', '飞鹰走马', '\n【 fēi　yīng　zǒu　mǎ 】\n			', '\n放鹰追捕和骑马追逐鸟兽。指打猎。\n			', '\n宋·欧阳修《乞奖用孙沔札子》：“沔今年虽七十，闻其心力不衰，飞鹰走马尚如平日。”\n			', '\n暂无\n			'),
(2086, '0:3:6', '光车骏马', '\n【 guāng　chē　jùn　mǎ 】\n			', '\n指装饰华丽的车马。\n			', '\n晋·陆机《百年歌》之二：“光车骏马游都城，高谈雅步何盈盈。”\n			', '\n暂无\n			'),
(2087, '0:3:6', '膏车秣马', '\n【 gào　chē　mò　mǎ 】\n			', '\n为车上油，给马喂料。指准备起程。\n			', '\n语出唐·韩愈《送李愿归盘 谷序》：“膏吾车兮秣吾马，从子于盘兮，终吾生以徜徉。”明·屠隆《彩毫记·钦取回朝》：“羡调和鼎鼐，便膏车秣马好归来。”\n			', '\n［刘三白］与某～，后队兴兵呀。\n			'),
(2088, '0:3:6', '谷马砺兵', '\n【 gǔ　mǎ　lì　bīng 】\n			', '\n犹言秣马厉兵。\n			', '\n宋·陈师道《赠张文潜》诗：“秋来待试丞相府，谷马砺兵吾甚武。”\n			', '\n暂无\n			'),
(2089, '0:3:6', '狗马声色', '\n【 gǒu　mǎ　shēng　sè 】\n			', '\n良犬、骏马、音乐、女色。泛指养狗、骑马、听歌、狎妓等剥削阶级行乐的方式。借指穷奢极侈的享乐。\n			', '\n宋·张孝祥《宣州新建御书阁记》：“谓虽极天下之贵，而退朝燕息，从容娱乐者，独在于是，狗马声色技巧之奉，不皇及也。”\n			', '\n为君者日不闻其过，亦自以为四方平治，圣哲若古，而～之欲因以中其心志矣。\n			'),
(2090, '0:3:6', '高头大马', '\n【 gāo　tóu　dà　mǎ 】\n			', '\n指体形高大的马。也比喻人的体形高大。\n			', '\n清·禇人获《隋唐演义》第十一回：“这个人浑身都是新衣服，铺盖齐整，随身有兵器，骑的是高头大马。”\n			', '\n暂无\n			'),
(2091, '0:3:6', '毁车杀马', '\n【 huǐ　chē　shā　mǎ 】\n			', '\n废弃车马。喻归隐意志坚决。\n			', '\n宋·陆游《谢曾侍郎启》：“毁车杀马，逝从此以径归；卖剑买牛，分余生之永已。”宋·陆九渊《与陈倅书》：“元晦虽有毁车杀马之说，然势恐不容不一出也。”\n			', '\n暂无\n			'),
(2092, '0:3:6', '横刀跃马', '\n【 héng　dāo　yuè　mǎ 】\n			', '\n指手持武器，纵马驰骋。指在沙场作战。犹言横戈跃马。\n			', '\n清·吴璿《飞龙全传》第四十八回：“上元帅白从辉横刀跃马，望南阵冲来。樊爱能、何徽抵敌不住，弃战回马而走。”\n			', '\n他[孙传庭]刚刚坐定，这一大群人已经跟了进来，用各种阿谀逢迎的言词称颂他神机妙算……还称颂他如何在战场上～，气吞河山。\n			'),
(2093, '0:3:6', '横戈盘马', '\n【 héng　gē　pán　mǎ 】\n			', '\n犹横戈跃马。形容将士威风凛凛，准备冲杀作战的英勇姿态。\n			', '\n宋·陆游《蝶恋花·离小益作》词：“忽记横戈盘马处，散关清渭应如故。”\n			', '\n暂无\n			'),
(2094, '0:3:6', '汗马之功', '\n【 hàn　mǎ　zhī　gōng 】\n			', '\n指战争中立下的功绩。\n			', '\n宋·王谠《唐语林·补遗一》：“遂良出自草茅，无汗马之功，蒙先帝殊遇，以有今日。”\n			', '\n倘效玄宗幸金牛之道，岂无诸将立～。\n			'),
(2095, '0:3:6', '汗马之劳', '\n【 hàn　mǎ　zhī　láo 】\n			', '\n①指征战的劳苦。亦指战功。②指用马运输的劳累。\n			', '\n《韩非子·五蠹》：“弃私家之事而必汗马之劳，家困而上弗论，则穷矣。”\n			', '\n舫船载卒，一舫载五十人，与三月之粮，下水而浮，一日行三百馀里；里数虽多，不费～。\n			'),
(2096, '0:3:6', '呼牛作马', '\n【 hū　niú　zuò　mǎ 】\n			', '\n比喻别人骂也好，称赞也好，决不计较。同“呼牛呼马”。\n			', '\n《庄子·天道》：“昔者子呼我牛也，而谓之牛，呼我马也，而谓之马。”\n			', '\n时不偶，且躬操敝帚，任他人～，只低头。\n			'),
(2097, '0:3:6', '横枪跃马', '\n【 héng　qiāng　yuè　mǎ 】\n			', '\n指手持武器，纵马驰骋。指在沙场作战。犹横戈跃马。\n			', '\n元·陈以仁《雁门关存孝打虎》：“见一人雄赳赳披袍擐甲，嗔忿忿横枪跃马。”\n			', '\n如果你没有为祖国～，你怎能认识她壮美的山河。\n			'),
(2098, '0:3:6', '讳树数马', '\n【 huì　shù　shù　mǎ 】\n			', '\n表示居官为人忠诚谨慎。\n			', '\n《史记·万石张叔列传》：“建为郎中令，书奏事，事下，建读之，曰：‘误书！“马”者与尾当五，今乃四，不足一。上谴死矣！’……万石君少子庆为太仆，御出，上问车中几马，庆以策数马毕，举手曰：六马。庆于诸子中最为简易矣，然犹如此。”\n			', '\n《汉书·孔光传》：“沐日归休，兄弟妻子燕语，终不及朝省政事。或问光：‘温室省中树皆何木也？’光默不应，更答以它语，其不泄如是。”\n			'),
(2099, '0:3:6', '襟裾马牛', '\n【 jīn　jú　mǎ　niú 】\n			', '\n像马牛穿上人的衣服。比喻没有头脑和无知。\n			', '\n语出唐·韩愈《符读书城南》诗：“人不通古今，马牛而襟裾。”\n			', '\n厌～，笑衣冠沐猴。\n			'),
(2100, '0:3:6', '裾马襟牛', '\n【 jū　mǎ　jīn　niú 】\n			', '\n像马牛穿上人的衣服。比喻没有头脑和无知。亦作“襟裾马牛”。\n			', '\n唐韩愈《符读书城南》诗：“人不通古今，马牛而襟裾。”\n			', '\n我若做浪蝶游蜂，老天呵，须教是～。\n			'),
(2101, '0:3:6', '金马玉堂', '\n【 jīn　mǎ　yù　táng 】\n			', '\n金马：汉代的金马门，是学士待诏的地方；玉堂：玉堂殿，供侍诏学士议事的地方。旧指翰林院或翰林学士。\n			', '\n汉·扬雄《解嘲》：“今吾子幸得遭明盛之世，处不讳之朝，与群贤同行，历金门上玉堂有日矣，曾不能画一奇，出一策，上说人主，下谈公卿。”\n			', '\n暂无\n			'),
(2102, '0:3:6', '尻舆神马', '\n【 kāo　yú　shén　mǎ 】\n			', '\n指以尻为车舆而神游。后为随心所欲遨游自然之典。同“尻轮神马”。\n			', '\n《庄子·大宗师》：“浸假而化予之尻以为轮，以神为马，予因以乘之，岂更驾哉。”成玄英疏：“尻无识而为轮，神有知而作马，因渐渍而变化，乘轮马以遨游，苟随任以安排，亦于何而不适者也。”\n			', '\n果痔木痈除物害，～得天全。\n			'),
(2103, '0:3:6', '历兵秣马', '\n【 lì　bīng　mò　mǎ 】\n			', '\n磨利兵器，喂饱马匹。指作好战斗准备。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2104, '0:3:6', '励兵秣马', '\n【 lì　bīng　mò　mǎ 】\n			', '\n指磨好刀枪，喂饱战马，准备战斗。\n			', '\n语出《左传·僖公三十三年》：“郑穆公使视客馆，则束载、厉兵、秣马。”\n			', '\n镇臣刘云佐与臣言，愿～与敌驰角。\n			'),
(2105, '0:3:6', '历兵粟马', '\n【 lì　bīng　sù　mǎ 】\n			', '\n磨快兵器喂饱马。指准备作战。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2106, '0:3:6', '厉兵粟马', '\n【 lì　bīng　sù　mǎ 】\n			', '\n磨快兵器喂饱马。指准备作战。\n			', '\n《新唐书·刘仁轨传》：“虽孽竖跳梁，士力未完，宜厉兵粟马，乘无备，击不意，百下百全。”\n			', '\n暂无\n			'),
(2107, '0:3:6', '驴唇马觜', '\n【 lǘ　chún　mǎ　zī 】\n			', '\n指胡扯，瞎说。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2108, '0:3:6', '砺戈秣马', '\n【 lì　gē　mò　mǎ 】\n			', '\n磨戈喂马。比喻作好战斗准备。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2109, '0:3:6', '立马万言', '\n【 lì　mǎ　wàn　yán 】\n			', '\n倚靠在马旁，马上写成一篇文章。形容才思敏捷。\n			', '\n宋·王十朋《梅溪王忠文公集·上太守李端明书》：“唐翰林应长庚之梦，世号谪仙人，立马万言，而文章为天下之法。”\n			', '\n暂无\n			'),
(2110, '0:3:6', '驴年马月', '\n【 lǘ　nián　mǎ　yuè 】\n			', '\n不可知的年月。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2111, '0:3:6', '龙神马壮', '\n【 lóng　shén　mǎ　zhuàng 】\n			', '\n谓像骏马一样的有精神。\n			', '\n欧阳山《苦斗》四六：“那时候，一个个青年人都是龙神马壮，气吞牛斗，争论起世界国家大事来，都是口若悬河，当当不断，慷慨激昂，谁也不让谁。”\n			', '\n暂无\n			'),
(2112, '0:3:6', '驴头不对马嘴', '\n【 lǘ　tóu　bù　duì　mǎ　zuǐ 】\n			', '\n比喻答非所问或两下不相合。同“驴唇不对马嘴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2113, '0:3:6', '临崖勒马', '\n【 lín　yá　lè　mǎ 】\n			', '\n走到悬崖边缘勒住了奔马。①比喻到了危险边缘能及时醒悟回头。②比喻运用笔墨，当意境入近高潮时，突然煞住笔锋。亦作“悬崖勒马”、“勒马悬崖”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2114, '0:3:6', '路遥知马力，日久见人心', '\n【 lù　yáo　zhī　mǎ　lì，rì　jiǔ　jiàn　rén 】\n			', '\n路途遥远才能知道马的力气大小，日子长了才能看出人心的好坏。\n			', '\n元·无名氏《争报恩》第一折：“则愿得姐姐长命富贵，若有些儿好歹，我少不得报答姐姐之恩，可不道路遥知马力，日久见人心。”\n			', '\n但是“～”，在长期和残酷的战争中，游击战争将表现其很大的威力，实在是非同小可的事业。（毛泽东《论持久战》）\n			'),
(2115, '0:3:6', '马浡牛溲', '\n【 mǎ　bó　niú　sōu 】\n			', '\n借指不值钱的东西。同“马勃牛溲”\n			', '\n明·王世懋《艺圃撷馀》：“杜子美出，而百家稗官都作雅音，马浡牛溲咸成郁致，于是诗之变极矣。”\n			', '\n暂无\n			'),
(2116, '0:3:6', '马尘不及', '\n【 mǎ　chén　bù　jí 】\n			', '\n比喻赶不上，跟不上。\n			', '\n明·都穆《都公谭纂》卷上：“王行昔望吾舅马尘不及，何先友为？”\n			', '\n暂无\n			'),
(2117, '0:3:6', '马迟枚疾', '\n【 mǎ　chí　méi　jí 】\n			', '\n用于称赞各有长处。同“马工枚速”。\n			', '\n清·陈祖范《寄沈归愚》诗：“鹤怨猿惊怀故地，马迟枚疾斗新篇。”\n			', '\n暂无\n			'),
(2118, '0:3:6', '马齿徒长', '\n【 mǎ　chǐ　tú　zhǎng 】\n			', '\n谦称自己虚度年华，没有成就。\n			', '\n《穀梁传·僖公二年》：“荀息牵马操璧而前曰：‘璧则犹是也，而马齿加长矣。’”\n			', '\n张太经说：‘今日承蒙垂青，得与将军联宗，不胜荣幸。大经碌碌半生，～，怎好僭居兄位！’\n			'),
(2119, '0:3:6', '马到功成', '\n【 mǎ　dào　gōng　chéng 】\n			', '\n形容事情顺利，一开始就取得胜利。\n			', '\n元·郑廷玉《楚昭公》第四折：“只愿你马到功成，奏凯而还。”\n			', '\n向使微臣督剿江、淮、豫、楚间，果能运筹制胜，～，各省抚臣岂易于为力？\n			'),
(2120, '0:3:6', '马耳春风', '\n【 mǎ　ěr　chūn　fēng 】\n			', '\n比喻把别人的话当作耳边风。同“马耳东风”。\n			', '\n金·元好问《谷圣灯》诗：“纷纷世议何足道，尽付马耳春风前。”\n			', '\n暂无\n			'),
(2121, '0:3:6', '马翻人仰', '\n【 mǎ　fān　rén　yǎng 】\n			', '\n人马被打得仰翻在地。形容被打得惨败。也比喻乱得一塌糊涂，不可收拾。\n			', '\n清·曹雪芹《红楼梦》第一百十五回：“贾琏家下无人，请了王仁来在外帮着料理。那巧姐儿是日夜哭母，也是病了。所以荣府中又闹得马仰人翻。”\n			', '\n暂无\n			'),
(2122, '0:3:6', '马腹逃鞭', '\n【 mǎ　fù　táo　biān 】\n			', '\n比喻躲脱惩罚。\n			', '\n《左传·宣公十五年》：“虽鞭之长，不及马腹。”\n			', '\n岂谓～，榻侧容一隅之鼾睡？不知燕巢在幕，釜底得几日之游魂。\n			'),
(2123, '0:3:6', '枚速马工', '\n【 mǎ　gōng　méi　sù 】\n			', '\n工：工巧；速：速度快。原指枚皋文章写得多，司马相如文章写得工。后用于称赞各有长处。\n			', '\n《汉书·枚乘传》：“为文疾，受诏辄成，故所赋者多；司马相如善为文而迟，故所作少而善于皋。”\n			', '\n暂无\n			'),
(2124, '0:3:6', '马革盛尸', '\n【 mǎ　gé　shèng　shī 】\n			', '\n用马皮把尸体裹起来。指英勇牺牲在战场。同“马革裹尸”。\n			', '\n金·何宏中《述怀》诗：“马革盛尸每恨迟，西山饿踣更何辞。”\n			', '\n暂无\n			'),
(2125, '0:3:6', '马毛猬磔', '\n【 mǎ　máo　wèi　zhé 】\n			', '\n形容狂风大作，气候恶劣。\n			', '\n南朝·宋·鲍照《代出自蓟北门行》：“疾风冲塞起，沙砾自飘扬；马毛缩如猬，角弓不可张。”\n			', '\n暂无\n			'),
(2126, '0:3:6', '马毛蝟磔', '\n【 mǎ　máo　wèi　zhé 】\n			', '\n蝟，同“猬”。形容狂风大作，气候恶劣。\n			', '\n南朝·宋·鲍照《代出自蓟北门行》：“疾风冲塞起，沙砾自飘扬；马毛缩如蝟，角弓不可张。”\n			', '\n朔风朴面吹尘沙，～人影斜。\n			'),
(2127, '0:3:6', '买马招兵', '\n【 mǎi　mǎ　zhāo　bīng 】\n			', '\n犹言招兵买马。\n			', '\n《再生缘》第三回：“今中既到山中住，少不得，买马招兵尽壮怀。”\n			', '\n暂无\n			'),
(2128, '0:3:6', '买马招军', '\n【 mǎi　mǎ　zhāo　jūn 】\n			', '\n犹言招兵买马。\n			', '\n明·汤显祖《牡丹亭·牝贼》：“有这等事？恭喜了！借此号令，买马招军。”\n			', '\n暂无\n			'),
(2129, '0:3:6', '马牛其风', '\n【 mǎ　niú　qí　fēng 】\n			', '\n指马、牛奔逸。后用以表示互不相干。\n			', '\n《书·费誓》：“马牛其风，臣妾逋逃，勿敢越逐。”孔颖达疏：“僖四年《左传》云：‘唯是风马牛不相及也。’贾逵云：‘风，放也，牝牡相诱谓之风。’然则马牛风佚，因牝牡相逐，而逐至放佚远去也。”\n			', '\n我却不信你们两个通是～，不言而喻呢。\n			'),
(2130, '0:3:6', '马去马归', '\n【 mǎ　qù　mǎ　guī 】\n			', '\n比喻世事多变，得失无常。\n			', '\n据《淮南子·人间训》载，边塞老翁失马，人以为祸，结果其马领胡人骏马同归，人皆贺之，而其子却因骑马摔伤致残，乡人吊之，不料胡人入塞，边塞丁壮战死者十九，其子却因腿跛而全。\n			', '\n褐衣褐见，莫陈汉戍之便宜；～，敢计塞翁之倚伏。\n			'),
(2131, '0:3:6', '马入华山', '\n【 mǎ　rù　huá　shān 】\n			', '\n表示天下太平，不再打仗。\n			', '\n《书·武成》：“乃偃武修文，归马于华山之阳，放牛于桃林之野，示天下弗服。”\n			', '\n当今鹿台已散，离宫已遣，兵藏武库，～。\n			'),
(2132, '0:3:6', '马如流水', '\n【 mǎ　rú　liú　shuǐ 】\n			', '\n形容人马熙攘。\n			', '\n元·揭傒斯《居庸行》：“关门两向当天开，马如流水车如雷。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2133, '0:3:6', '盲人骑瞎马', '\n【 máng　rén　qí　xiā　mǎ 】\n			', '\n瞎子骑着瞎马。形容乱闯瞎撞，非常危险。\n			', '\n南朝·宋·刘义庆《世说新语·排调》：“桓南郡与殷荆州语次，因共作了语……复作危语。桓曰：‘矛头淅米剑头炊。’殷曰：‘百岁老翁攀枯枝。’顾曰：‘井上辘轳卧婴儿。’殷有一参军在坐云：‘盲人骑瞎马，夜半临深池。’”\n			', '\n但是你们老兄，几几乎入新党的那件事，要果真照你这样说起来，岂不是～，夜半临深池，也算他冒险一次么？\n			'),
(2134, '0:3:6', '瞎马临池', '\n【 xiā　mǎ　lín　chí 】\n			', '\n盲人骑着瞎马。比喻盲目行动，后果十分危险。\n			', '\n南朝宋·刘义庆《世说新语·排调》：“盲人骑瞎马，夜半临深池。”\n			', '\n暂无\n			'),
(2135, '0:3:6', '马如游鱼', '\n【 mǎ　rú　yóu　yú 】\n			', '\n形容人马熙熙攘攘的景象。同“马如游龙”。\n			', '\n《初学记》卷四引汉·刘桢《鲁都赋》：“日暮宴罢，车骑就衢，盖如飞鹤，马如游鱼。”\n			', '\n暂无\n			'),
(2136, '0:3:6', '马水车龙', '\n【 mǎ　shuǐ　chē　lóng 】\n			', '\n犹言车水马龙。形容来往车马很多，连续不断的热闹情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2137, '0:3:6', '马上得天下', '\n【 mǎ　shàng　dé　tiān　xià 】\n			', '\n喻指武功建国。\n			', '\n《史记·郦生陆贾列传》：“陆生时时前说称《诗》《书》。高帝骂之曰：‘乃公居马上而得之，安事《诗》《书》！’陆生曰：‘居马上得之，宁可以马上治之乎？且汤武逆取而以顺守之，文武并用，长久之术也。’”\n			', '\n五年～，富贵乐在归故乡。\n			'),
(2138, '0:3:6', '马首欲东', '【 mǎ　shǒu　yù　dōng 】', '指东归；返回。 ', '语出《左传·襄公十四年》：“栾黡曰：''晋国之命，未是有也。余马首欲东。''乃归。”杨伯峻注：“秦兵在西，东则归矣。” ', '今～，无可相赆，手制粗鞋一双，绫袜一緉，聊表微意。 '),
(2139, '0:3:6', '马咽车阗', '\n【 mǎ　yān　chē　tián 】\n			', '\n形容车马繁多，非常热闹。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2140, '0:3:6', '马足车尘', '\n【 mǎ　zú　chē　chén 】\n			', '\n比喻四处奔波，生活动荡不定。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2141, '0:3:6', '马中关五', '\n【 mǎ　zhōng　guān　wǔ 】\n			', '\n犹言鲁鱼亥豕。指书籍在传写或刻印过程中的文字错误。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2142, '0:3:6', '马足龙沙', '\n【 mǎ　zú　lóng　shā 】\n			', '\n指驰骋边疆，扬威域外。龙沙，塞北沙漠地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2143, '0:3:6', '马壮人强', '\n【 mǎ　zhuàng　rén　qiáng 】\n			', '\n犹言人强马壮。形容军队的战斗力很强或军容很盛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2144, '0:3:6', '泥车瓦马', '\n【 ní　chē　wǎ　mǎ 】\n			', '\n比喻没有实际用处的东西。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2145, '0:3:6', '牛高马大', '\n【 niú　gāo　mǎ　dà 】\n			', '\n比喻人长得高大强壮。\n			', '\n《小说月报》1981年第1期：“东宁县县委书记刘番成长得浓眉大眼，牛高马大。”\n			', '\n三人中那位五十来岁，～、脸色黧黑的壮年人，抬头看见方爱华的小轿车。\n			'),
(2146, '0:3:6', '牛马襟裾', '\n【 niú　mǎ　jīn　jú 】\n			', '\n犹言衣冠禽兽。\n			', '\n元·石德玉《秋胡戏妻》第三折：“我骂你个沐猴冠冕，牛马襟裾。”元·无名氏《举案齐眉》第一折：“教人道这乔男女，则是些牛马襟裾。”\n			', '\n暂无\n			'),
(2147, '0:3:6', '驽马恋栈', '\n【 nú　mǎ　liàn　zhàn 】\n			', '\n驽马：劣马，跑不快的马；栈：指马棚。劣马惦着的只是马棚里的饲料。比喻无能的人只贪图安逸，无远大志向。\n			', '\n《晋书·宣帝纪》：“爽与范内疏而智不及，驽马恋栈豆，必不能用也。”\n			', '\n暂无\n			'),
(2148, '0:3:6', '驽马十舍', '\n【 nú　mǎ　shí　shè 】\n			', '\n用马拉车，一天为一驾，十驾指十天路程。谓驽马奋力拉车，亦可至远。比喻能力低下的人只要奋勉从事，同样能达到目的。\n			', '\n《淮南子·齐俗训》：“夫骐骥千里，一日而通；驽马十舍，旬亦至之。”\n			', '\n暂无\n			'),
(2149, '0:3:6', '牛溲马渤', '\n【 niú　sōu　mǎ　bó 】\n			', '\n牛溲，即牛遗，车前草的别名。马勃，一名马牷，一名屎菰，生于湿地及腐木的菌类。均可入药。比喻虽然微贱但是有用的东西。渤，通勃。\n			', '\n清·李渔《闲情偶寄·居室·房舍》：“收牛溲马渤入药笼，用之得宜，其价值反在参苓之上。”\n			', '\n暂无\n			'),
(2150, '0:3:6', '牛头不对马面', '\n【 niú　tóu　bù　duì　mǎ　miàn 】\n			', '\n比喻答非所问或对不上号。\n			', '\n清·李宝嘉《文明小史》第二十四回：“尽其所有写上，都是牛头不对马面。”\n			', '\n暂无\n			'),
(2151, '0:3:6', '牛童马走', '\n【 niú　tóng　mǎ　zǒu 】\n			', '\n旧时泛指地位卑下的人。牛童，牧童；马走，犹仆役。\n			', '\n唐·元稹《〈白氏长庆集〉序》：“然而二十年间，禁省、观寺、邮候墙壁之上无不书，王公妾妇、牛童马走之口无不道。”\n			', '\n其大节岳岳磊磊，在人耳目，虽耕夫贩妇，～，共能称道者。\n			'),
(2152, '0:3:6', '拿下马来', '\n【 ná　xià　mǎ　lái 】\n			', '\n比喻将人制服。\n			', '\n清·曹雪芹《红楼梦》第二十回：“叫我问谁去？谁不帮着你呢？谁不是袭人拿下马来的？”\n			', '\n暂无\n			'),
(2153, '0:3:6', '跑马观花', '\n【 pǎo　mǎ　guān　huā 】\n			', '\n比喻大略地观看一下。\n			', '\n语出唐·孟郊《登科后》诗：“春风得意马蹄疾，一日看尽长安花。”\n			', '\n他～地把这部诗剧读了一遍，已经是傍晚时分了。\n			'),
(2154, '0:3:6', '拍马溜须', '\n【 pāi　mǎ　liū　xū 】\n			', '\n比喻谄媚奉承。\n			', '\n草明《乘风破浪》六：“新社会拍马溜须根本吃不开。”\n			', '\n暂无\n			'),
(2155, '0:3:6', '匹马一麾', '\n【 pǐ　mǎ　yī　huī 】\n			', '\n一匹马一杆旗。形容勇敢善战。\n			', '\n元·脱脱《辽史》卷五十八：“辽太祖匹马一麾，斥地万里，经营四方，末尝宁居，所至乐从，用此道也。”\n			', '\n暂无\n			'),
(2156, '0:3:6', '千兵万马', '\n【 qiān　bīng　wàn　mǎ 】\n			', '\n犹千军万马。\n			', '\n《南史·陈庆之传》：“先是洛阳谣曰：‘名师大将莫自牢，千兵万马避白袍。’”明·陈继儒《珍珠船》卷四：“李翰言文章，当如千兵万马而无人声。”\n			', '\n不怕将勇兵强，唯这萨头陀妖法，虽有～，也抵当不住。\n			'),
(2157, '0:3:6', '骑曹不记马', '\n【 qí　cáo　bù　jì　mǎ 】\n			', '\n指有名士习气，不理事务。\n			', '\n《晋书·王徽之传》载：“徽之字子猷。性卓荦不羁，为大 司马桓温参军，蓬首散带，不综府事。又为车骑桓冲骑兵参军，冲问：‘卿署何曹？’对曰：‘似是马曹。’又问：‘管几马？’曰：‘不知马，何由如数！’又问：‘马比死多少？’曰：‘未知生，\n			', '\n暂无\n			'),
(2158, '0:3:6', '秋高马肥', '\n【 qiū　gāo　mǎ　féi 】\n			', '\n秋高气爽，马匹肥壮。古常以指西北外族活动的季节。\n			', '\n宋·李纲《靖康传信录》卷三：“臣恐秋高马肥，虏必再至，以责前约。”\n			', '\n其外市，则西至安集延、伊犁、哈密、喀尔喀，东至黑龙江，～，被罽捆货而至。\n			'),
(2159, '0:3:6', '犬马恋主', '\n【 quǎn　mǎ　liàn　zhǔ 】\n			', '\n比喻臣下眷怀君上。\n			', '\n三国·魏·曹植《上责躬应诏诗表》：“踊跃之怀，瞻望反侧，不胜犬马恋主之情。”南朝·宋·鲍照《从临海王上荆初发新渚》诗：“狐涂怀窟志，犬马恋主情。”\n			', '\n暂无\n			'),
(2160, '0:3:6', '裘马轻狂', '\n【 qiú　mǎ　qīng　kuáng 】\n			', '\n指生活富裕，放荡不羁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2161, '0:3:6', '裘马清狂', '\n【 qiú　mǎ　qīng　kuáng 】\n			', '\n指生活富裕，放逸不羁。\n			', '\n唐·杜甫《壮游》诗：“放荡齐赵间，裘马颇清狂。”\n			', '\n当其游吴越，游齐赵，少年快意，～，固尚未困厄。\n			'),
(2162, '0:3:6', '裘马声色', '\n【 qiú　mǎ　shēng　sè 】\n			', '\n衣轻裘，乘肥马，醉心歌舞，迷恋女色。谓贪图享受，生活糜烂。\n			', '\n明·归有光《宋史论赞·诸王总论》：“宋诸王咸以文雅自饬，工笔札，喜《诗》《书》，不专溺于裘马声色之间，盖其风流自上被之也。”\n			', '\n暂无\n			'),
(2163, '0:3:6', '骑马寻马', '\n【 qí　mǎ　xún　mǎ 】\n			', '\n比喻已经有了好处，还要去谋另外的好处。\n			', '\n清·李宝嘉《官场现形记》第二十一回：“如果收了我的实收，他自然照应我。彼时间骑马寻马，只要弄到一笔大大的银款，赚上百十两扣头，就有在里头了。”\n			', '\n暂无\n			'),
(2164, '0:3:6', '雀马鱼龙', '\n【 què　mǎ　yú　lóng 】\n			', '\n泛指珍禽异兽。\n			', '\n语出《汉书·西域传赞》：“自是之后，明珠、文甲、通犀、翠羽之珍盈于后宫，蒲梢、龙文、鱼目、汗血之马充于黄门，钜象、师子、猛犬、大雀之群食于外囿。殊方异物，四面而至。”\n			', '\n暂无\n			'),
(2165, '0:3:6', '求马于唐市', '\n【 qiú　mǎ　yú　táng　shì 】\n			', '\n到空无所有的市集去买马。比喻求非所求，必无所获。同“求马于唐肆”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2166, '0:3:6', '求马于唐肆', '\n【 qiú　mǎ　yú　táng　sì 】\n			', '\n到空无所有的市集去买马。比喻求非所求，必无所获。\n			', '\n庄周《庄子·田子方》：“彼已尽矣，而女求之以为有，是求马于唐肆也。”郭象注：“唐肆，非停马处也。”\n			', '\n（达吐，）西域术语，或神秘之名，即查泰西字书，不啻～。\n			'),
(2167, '0:3:6', '犬马之诚', '\n【 quǎn　mǎ　zhī　chéng 】\n			', '\n比喻诚心实意。一般谦称自己的诚意。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2168, '0:3:6', '犬马之疾', '\n【 quǎn　mǎ　zhī　jí 】\n			', '\n谦称自己的疾病。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2169, '0:3:6', '犬马之决', '\n【 quǎn　mǎ　zhī　jué 】\n			', '\n指臣僚的果敢决断。\n			', '\n《汉书·息夫躬传》：“其有犬马之决者，仰药而伏刃。”\n			', '\n暂无\n			'),
(2170, '0:3:6', '犬马之恋', '\n【 quǎn　mǎ　zhī　liàn 】\n			', '\n比喻臣子眷恋君上。\n			', '\n唐·刘禹锡《苏州谢上表》：“江海远地，孤危小臣。虽雨露之恩，幽遐必被；而犬马之恋，亲近为荣。”\n			', '\n暂无\n			'),
(2171, '0:3:6', '犬马之年', '\n【 quǎn　mǎ　zhī　nián 】\n			', '\n对尊上卑称自己的年龄。\n			', '\n三国·魏·曹植《黄初六年令》：“将以全陛下厚德，究孤犬马之年，此难能也。”\n			', '\n老媳妇～七十有五。\n			'),
(2172, '0:3:6', '敲牛宰马', '\n【 qiāo　niú　zǎi　mǎ 】\n			', '\n指宰杀牲畜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2173, '0:3:6', '青丝白马', '\n【 qīng　sī　bái　mǎ 】\n			', '\n指作乱的人。\n			', '\n南朝·梁·普通年间，“有童谣曰：‘青丝白马寿阳来。’”其后侯景作乱，乘白马以青丝为缰，兵皆青衣，从寿春进军建康。见《梁书·侯景传》、《隋书·五行志上》。\n			', '\n暂无\n			'),
(2174, '0:3:6', '青衫司马', '\n【 qīng　shān　sī　mǎ 】\n			', '\n喻指失意之官吏。\n			', '\n唐·白居易贬官江州司马时，所作《琵琶引》有“座中泣下谁最多，江州司马青衫湿”之句。\n			', '\n看逸韵，自名流，～且江州。\n			'),
(2175, '0:3:6', '拳头上立得人，胳膊上走得马', '\n【 quán　tóu　shàng　lì　dé　rén，gē　bó　sh 】\n			', '\n比喻为人清白，作风正派，过得硬。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2176, '0:3:6', '权移马鹿', '\n【 quán　yí　mǎ　lù 】\n			', '\n指恃权专横跋扈，任意颠倒是非。\n			', '\n语出秦·赵高指鹿为马事。\n			', '\n口变淄素，～，山鬼昼舞，愁魂夜哭，如得其情，片言折狱。\n			'),
(2177, '0:3:6', '人荒马乱', '\n【 rén　huāng　mǎ　luàn 】\n			', '\n形容局势动荡不安。\n			', '\n鲁迅《故事新编·理水》：“现在又是这么的人荒马乱，交通不方便。”\n			', '\n暂无\n			'),
(2178, '0:3:6', '人喊马嘶', '\n【 rén　hǎn　mǎ　sī 】\n			', '\n人喊叫，马嘶鸣。形容纷乱扰攘或热闹欢腾的情景。\n			', '\n唐·卢纶《送韦判官得雨中山》：“人语马嘶听不得，更堪长路在云中。”\n			', '\n只听得外面喧嚷，似有～之声，渐渐近前堂来了。\n			'),
(2179, '0:3:6', '戎马仓皇', '\n【 róng　mǎ　cāng　huáng 】\n			', '\n指战事紧急而忙于应付。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2180, '0:3:6', '戎马劻勷', '\n【 róng　mǎ　dān　xiào 】\n			', '\n指战乱不宁。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2181, '0:3:6', '戎马倥傯', '\n【 róng　mǎ　kǒng　zǒng 】\n			', '\n指在战争中军务紧迫繁忙。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2182, '0:3:6', '戎马生郊', '\n【 róng　mǎ　shēng　jiāo 】\n			', '\n意指国家政治不上轨道，连怀胎的母马也用来作战。后指战乱不断。\n			', '\n《老子》：“天下无道，戎马生于郊。”陈鼓应注：“生于郊，指牝马生驹犊于战地的郊野。”\n			', '\n暂无\n			'),
(2183, '0:3:6', '戎马生涯', '\n【 róng　mǎ　shēng　yá 】\n			', '\n指从事征战的生活、经历。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2184, '0:3:6', '软裘快马', '\n【 ruǎn　qiú　kuài　mǎ 】\n			', '\n轻暖的毛皮衣服和善跑的马，喻生活豪奢。\n			', '\n唐·杜甫《投简咸华两县诸子》诗：“赤县官曹拥才杰，软裘快马当冰雪。”\n			', '\n归逢吏胥狭路边，～行索钱。\n			'),
(2185, '0:3:6', '人语马嘶', '\n【 rén　yǔ　mǎ　sī 】\n			', '\n人叫喊，马嘶鸣。形容纷乱扰攘或热闹欢腾的情景。\n			', '\n唐·卢纶《送韦判官得雨中山》：“人语马嘶听不得，更堪长路在云中。”元·无名氏《五马破曹》第三折：“大小三军，收拾什物，不许人语马嘶。”\n			', '\n却说夏侯渊一军抄过山后，见重雾垂空，又闻～，恐有伏兵，急催人马行动。\n			'),
(2186, '0:3:6', '束兵秣马', '\n【 shù　bīng　mò　mǎ 】\n			', '\n犹厉兵秣马。形容准备战斗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2187, '0:3:6', '神龙马壮', '\n【 shén　lóng　mǎ　zhuàng 】\n			', '\n比喻身体健壮、气宇轩昂。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2188, '0:3:6', '驷马不追', '\n【 sì　mǎ　bù　zhuī 】\n			', '\n指话说出口，就不能再收回，一定要算数。同“驷马难追”。\n			', '\n《邓析子·转辞》：“一言而非，驷马不能追；一言而急，驷马不能及。”《魏书·刑罚志》：“何得非正刑书，施行四海。刑名一失，驷马不追。”\n			', '\n暂无\n			'),
(2189, '0:3:6', '司马称好', '\n【 sī　mǎ　chēng　hǎo 】\n			', '\n喻指老好人是非不分，事理不明。\n			', '\n五代·李瀚《蒙求》诗：“司马称好。”徐子光集注：“（后汉司马徽）口不谈人之短。与人语，莫问好恶，皆言好。有乡人问徽安否，答曰好。有人自陈子死，答曰大好。妻责之曰：人以君有德，故相告，何忽闻人子死，便言好！徽曰：卿言亦大好。”\n			', '\n暂无\n			'),
(2190, '0:3:6', '驷马高盖', '\n【 sì　mǎ　gāo　gài 】\n			', '\n套着四匹马的高盖车。旧时形容有权势的人出行时的阔绰场面。也形容显达富贵。同“驷马高车”。\n			', '\n《汉书·于定国传》：“少高大闾门，令容驷马高盖车。”《南史·隐逸传上·渔父》：“吾黄金白璧，重礼也；驷马高盖，荣势也。”\n			', '\n～之赫奕，呵者肩摩于前，骑者踵接于后，洋洋乎得志于一时。\n			'),
(2191, '0:3:6', '驷马高门', '\n【 sì　mǎ　gāo　mén 】\n			', '\n指门第显赫。\n			', '\n《汉书·于定国传》：“始定国父于公，其闾门坏，父老方共治之。于公谓曰：‘少高大闾门，令容驷马高盖车。我治狱多阴德，未尝有所冤，子孙必有兴者。’至定国为丞相，永为御史大夫，封侯传世云。”\n			', '\n暂无\n			'),
(2192, '0:3:6', '杀马毁车', '\n【 shā　mǎ　huǐ　chē 】\n			', '\n比喻弃官归隐。\n			', '\n《后汉书·周燮传》：“［冯良］年三十，为尉从佐。奉檄迎督邮，即路慨然，耻在厮役，因坏车杀马，毁裂衣冠，乃遁至犍为，从杜抚学。”\n			', '\n～从此逝，子来何处问行藏。\n			'),
(2193, '0:3:6', '食马留肝', '\n【 shí　mǎ　liú　gān 】\n			', '\n后反用其义，比喻未能吸取精华。\n			', '\n《史记·封禅书》：“文成（少翁）食马肝死耳。”司马贞索隐：“案：《论衡》云：‘气热而毒盛，故食走马肝杀人。’”\n			', '\n暂无\n			'),
(2194, '0:3:6', '驷马莫追', '\n【 sì　mǎ　mò　zhuī 】\n			', '\n指话说出口，就不能再收回，一定要算数。同“驷马难追”。\n			', '\n明·方汝浩《禅真逸史》第二十八回：“常泰道：‘大丈夫一言既出，驷马莫追，岂有变更！’”\n			', '\n暂无\n			'),
(2195, '0:3:6', '司马牛之叹', '\n【 sī　mǎ　niú　zhī　tàn 】\n			', '\n比喻对孑然一身、孤立无援的感叹。\n			', '\n《论语·颜渊》：“司马牛忧曰：‘人皆有兄弟，我独亡。’”\n			', '\n暂无\n			'),
(2196, '0:3:6', '善马熟人', '\n【 shàn　mǎ　shú　rén 】\n			', '\n指良马与武艺精熟的勇士。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2197, '0:3:6', '失马塞翁', '\n【 shī　mǎ　sài　wēng 】\n			', '\n比喻因祸得福的人。\n			', '\n《儿女英雄传》第三三回：“我家虽不宽余，也还可以勉强温饱，都因我无端的官兴发作，几乎弄得家破人亡；还仗天祖之灵，才幸而作了个‘失马塞翁’。”\n			', '\n暂无\n			'),
(2198, '0:3:6', '束马县车', '\n【 shù　mǎ　xiàn　chē 】\n			', '\n形容走山路的艰险情况。同“束马悬车”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2199, '0:3:6', '驷马轩车', '\n【 sì　mǎ　xuān　chē 】\n			', '\n套着四匹马的高盖车。旧时形容有权势的人出行时的阔绰场面。也形容显达富贵。同“驷马高车”。\n			', '\n清·方文《为陈俞公五十初度》诗：“驷马轩车易倾覆，何如野老话桑麻。”\n			', '\n暂无\n			'),
(2200, '0:3:6', '散马休牛', '\n【 sàn　mǎ　xiū　niú 】\n			', '\n指不兴战事。\n			', '\n《书·武成》：“归马于华山之阳，放牛于桃林之野，示天下弗服”。蔡沈集传引《乐记》：“武王胜商，渡河而西，马散之华山之阳而弗复乘，牛放之桃林之野而弗复服”。\n			', '\n暂无\n			'),
(2201, '0:3:6', '驷马仰秣', '\n【 sì　mǎ　yǎng　mò 】\n			', '\n驾车的马驻足仰首，谛听琴声。形容音乐美妙动听。\n			', '\n语出《荀子·劝学》：“昔者瓠巴鼓瑟而流鱼出听，伯牙鼓琴而六马仰秣。”杨倞注：“仰首而秣，听其声也。”\n			', '\n暂无\n			'),
(2202, '0:3:6', '司马昭之心', '\n【 sī　mǎ　zhāo　zhī　xīn 】\n			', '\n比喻人所共知的野心。\n			', '\n晋·陈寿《三国志·魏志·高贵乡公传》：“高贵乡公卒”裴松之注引《汉晋春秋》：“司马昭之心，路人所知也。”\n			', '\n岂所谓～，路人皆见者耶？\n			'),
(2203, '0:3:6', '射人先射马', '\n【 shè　rén　xiān　shè　mǎ 】\n			', '\n比喻作事要抓住要害。\n			', '\n唐·杜甫《前出塞》诗之六：“射人先射马，擒贼先擒王。”\n			', '\n刘胜击着手掌说：‘～，擒贼先擒王。知道不知道？记住！碰到骑马的敌人，就是先打马后打人！你的意见很好。’\n			'),
(2204, '0:3:6', '素丝良马', '\n【 sù　sī　liáng　mǎ 】\n			', '\n以之为礼遇贤士之辞。\n			', '\n《诗·鄘风·干旄》：“素丝纰之，良马四之。”郑玄笺：“素丝者以为缕，以缝纰旌旗之旒縿。”朱熹集传：“言卫大夫乘此车马，建此旌旄，以见贤者。”\n			', '\n暂无\n			'),
(2205, '0:3:6', '识途老马', '\n【 shí　tú　lǎo　mǎ 】\n			', '\n老马认识路。比喻对某种事物十分熟悉的人。\n			', '\n《韩非子·说林上》：“管仲、隰朋从于桓公伐孤竹，春往冬反，迷惑失道。管仲曰：‘老马之智可用也。’乃放老马而随之，遂得道。”\n			', '\n你也不用发忧，还有你老子是“～”，慢慢地来指拨你罢！（茅盾《子夜》四）\n			'),
(2206, '0:3:6', '识涂老马', '\n【 shí　tú　lǎo　mǎ 】\n			', '\n老马认识路。比喻对某种事物十分熟悉的人。同“识途老马”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2207, '0:3:6', '塞翁得马', '\n【 sài　wēng　dé　mǎ 】\n			', '\n比喻得失无常，祸福相倚。\n			', '\n明·冯梦龙《警世通言》十五卷：“塞翁得马非为吉，宋子双盲岂是凶。祸福前程如漆暗，但平方寸答天公。”\n			', '\n精神乏，安心要把驴儿跨，又谁知～，塞翁得马。\n			'),
(2208, '0:3:6', '塞翁失马，安知非福', '\n【 sài　wēng　shī　mǎ，ān　zhī　fēi　fú 】\n			', '\n比喻一时虽然受到损失，也许反而因此能得到好处。也指坏事在一定条件下可变为好事。同“塞翁失马”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2209, '0:3:6', '塞翁失马，焉知非福', '\n【 sài　wēng　shī　mǎ，yān　zhī　fēi　fú 】\n			', '\n比喻一时虽然受到损失，也许反而因此能得到好处。也指坏事在一定条件下可变为好事。同“塞翁失马，安知非福”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2210, '0:3:6', '塞翁之马', '\n【 sài　wēng　zhī　mǎ 】\n			', '\n塞马。比喻得失无常，祸福相倚。\n			', '\n清·黄小配《廿载繁华梦》序一：“嗟乎嗟乎！廿年幻梦，如此收场；万里故乡，罔知所适。若论祸福，塞翁之马难知；语到死生，庄子之龟未卜。叹浮生其若梦，为欢几何？抚结局以如斯，前尘已矣。”\n			', '\n暂无\n			'),
(2211, '0:3:6', '铁马金戈', '\n【 tiě　mǎ　jīn　gē 】\n			', '\n①形容威武雄壮的士兵和战马。②谓战事，兵事。\n			', '\n宋·李纲《以旧赐战袍等赠韩少帅》诗之二：“铁马金戈睢水上，碧油红旆海山滨。”元·关汉卿《双赴梦》第三折：“忆当年铁马金戈，自桃园初结义，把尊兄辅佐。”\n			', '\n生长承平听画筝，几闻～声。\n			'),
(2212, '0:3:6', '天粟马角', '\n【 tiān　sù　mǎ　jiǎo 】\n			', '\n天雨粟，马生角。谓不可能实现的事。\n			', '\n《史记·刺客列传论》：“世言荆轲，其称太子丹之命，‘天雨粟，马生角’也，太过。”\n			', '\n燕太子丹，不过礼士慕侠，而一时燕赵慷慨之徒，不平其事，遂有～之谈。\n			'),
(2213, '0:3:6', '铜围铁马', '\n【 tóng　wéi　tiě　mǎ 】\n			', '\n比喻坚固的阵势。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2214, '0:3:6', '舞刀跃马', '\n【 wǔ　dāo　yuè　mǎ 】\n			', '\n挥舞刀枪，纵跃战马。比喻奋勇作战。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2215, '0:3:6', '五花杀马', '\n【 wǔ　huā　shā　mǎ 】\n			', '\n毛色凋落的马。比喻年老体衰。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2216, '0:3:6', '文君司马', '\n【 wén　jūn　sī　mǎ 】\n			', '\n后指相爱的情人或夫妻。\n			', '\n《史记·司马相如列传》载：汉代辞赋家司马相如，在宴席上以琴音挑动临邛富商卓王孙寡居的女儿卓文君；文君夜奔相如，与之结为夫妇。卓王孙不认这门亲事，司马相如与卓文君开了个酒馆，文君当炉卖酒，相如穿着犊鼻裤与奴仆一道洗器皿，卓王孙感到耻\n			', '\n暂无\n			'),
(2217, '0:3:6', '乌头白，马生角', '\n【 wū　tóu　bái，　mǎ　shēng　jiǎo 】\n			', '\n比喻不可能出现的事。\n			', '\n西汉·司马迁《史记·刺客列传》：“乌头白，马生角，乃许耳。”\n			', '\n照你意思，便～，也不能成功！\n			'),
(2218, '0:3:6', '乌头马角', '\n【 wū　tóu　mǎ　jiǎo 】\n			', '\n比喻不能实现之事。同“乌白马角”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2219, '0:3:6', '乌焉成马', '\n【 wū　yān　chéng　mǎ 】\n			', '\n乌、焉、马三字字形相近，几经传抄而写错。指文字因形体相似而传写错误。\n			', '\n《周礼·天官·缝人》“丧，缝棺饰焉”汉郑玄注：“故书焉为马，杜子春云‘当为焉’。”古谚：“书经三写，乌焉成马。”\n			', '\n暂无\n			'),
(2220, '0:3:6', '洗兵牧马', '\n【 xǐ　bīng　mù　mǎ 】\n			', '\n洗擦兵器，喂养战马。指做好作战准备。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2221, '0:3:6', '选兵秣马', '\n【 xuǎn　bīng　mò　mǎ 】\n			', '\n选好兵器喂饱战马。指作好战前准备。\n			', '\n宋欧阳修《准诏言事上书》：“今若敕励诸将选兵秣马，疾入西界，但能痛败昊贼一阵，则吾军威大振而虏汁沮矣。”\n			', '\n暂无\n			'),
(2222, '0:3:6', '悬兵束马', '\n【 xuán　bīng　shù　mǎ 】\n			', '\n形容险阻。同“悬车束马”。\n			', '\n北魏·郦道元《水经注·涪水》：“邓艾自阴平、景谷步道，悬兵束马，入蜀径江油、广汉者也。”\n			', '\n暂无\n			'),
(2223, '0:3:6', '鲜车健马', '\n【 xiān　chē　jiàn　mǎ 】\n			', '\n谓车辆鲜丽，辕马壮健。形容豪富。同“鲜车怒马”。\n			', '\n唐·康骈《剧谈录·曲江》:“彩幄翠帱，匝于堤岸，鲜车健马，比肩击毂。”\n			', '\n暂无\n			'),
(2224, '0:3:6', '悬车束马', '\n【 xuán　chē　shù　mǎ 】\n			', '\n形容险阻。\n			', '\n《国语·齐语》：“悬车束马，逾太行与辟耳之溪拘夏。”韦昭注：“太行、辟耳，山名也。拘夏，辟耳之溪也。三者皆山险溪谷，故悬钩其车，偪束其马以渡。”\n			', '\n公卷甲北塞，～，遂得策预葭萌，勋参绵竹。\n			'),
(2225, '0:3:6', '下马冯妇', '\n【 xià　mǎ　féng　fù 】\n			', '\n以之比喻重操旧业的人。\n			', '\n《孟子·尽心上》：“晋人有冯妇者，善搏虎，卒为善士；则之野，有众逐虎，虎负?禺，莫之敢攖；望见冯妇，趋而迎之，冯妇攘臂下车，众皆悦之，其为士者笑之。”\n			', '\n还仗天祖之灵，才幸而作了个“失马塞公”，如今要再去学那“～”，也就似乎大可不必了！\n			'),
(2226, '0:3:6', '系马埋轮', '\n【 xì　mǎ　mái　lún 】\n			', '\n指敌人进攻时，系住马，埋车轮于地，以示固守不退。\n			', '\n语出《孙子·九地》：“是故方马埋轮，未足恃也。”曹操注：“方，缚马也；埋轮，示不动也。”\n			', '\n孰能被坚执锐，长驱深入，～，奋不顾身，以先士卒者乎？\n			'),
(2227, '0:3:6', '休牛归马', '\n【 xiū　niú　guī　mǎ 】\n			', '\n放归军用的牛马，表示停止战事。\n			', '\n语出《书·武成》：“乃偃武修文，归马于华山之阳，放牛于桃林之野，示天下书弗服。”《隋书·薛道衡传》：“于是八荒无外，九服大同，四海为家，万里为宅。乃休牛散马，偃武修文。”\n			', '\n岂直～，但美于偃兵，保大定功，空歌于成德者哉！\n			'),
(2228, '0:3:6', '休牛散马', '\n【 xiū　niú　sàn　mǎ 】\n			', '\n放归军用的牛马，表示停止战事。\n			', '\n唐·魏徵寿《隋书·薛道衡传》：“于是八荒无外，九服大同，四海为家，万里为宅。乃休牛散马，偃武修文。”\n			', '\n暂无\n			'),
(2229, '0:3:6', '效犬马力', '\n【 xiào　quǎn　mǎ　lì 】\n			', '\n效劳的谦词。意思是效犬马之劳。\n			', '\n《水浒传》第八二回：“臣旧岁统率大军前去征进，非不效犬马力，奈缘暑热，军士不伏水土。”\n			', '\n暂无\n			'),
(2230, '0:3:6', '朽索驭马', '\n【 xiǔ　suǒ　yù　mǎ 】\n			', '\n用腐烂的绳索驾驭奔驰的马。形容倾覆的危险十分严重。多含戒惧之意。亦作“腐索御马。”\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2231, '0:3:6', '鲜衣良马', '\n【 xiān　yī　liáng　mǎ 】\n			', '\n美服壮马。谓服饰豪奢。同“鲜车怒马”。\n			', '\n宋·李昉《太平广记》卷第三一○引唐·载孚《广异记·汝阴人》：“汝阴男子姓许，少孤，为人白皙，有姿调，好鲜衣良马，游骋无度。”\n			', '\n暂无\n			'),
(2232, '0:3:6', '鲜衣怒马', '\n【 xiān　yī　nù　mǎ 】\n			', '\n美服壮马。谓服饰豪奢。\n			', '\n明·沈德符《野获编·刑部·冤狱》：“群盗得志，弥横恣为推埋，鲜衣怒马，以游侠为称，其魁名朱国臣者，初亦宰夫也。”\n			', '\n鸦片洋标束锦装，～浮云队。\n			'),
(2233, '0:3:6', '以渴服马', '\n【 yǐ　kě　fú　mǎ 】\n			', '\n使马忍渴受训，从人驱遣。比喻用苛政治民，不能使人真心顺服。\n			', '\n《韩非子·外储说右下》：“造父为齐王驸驾，以渴服马，百日而服成……王曰：‘效驾于圃驾于圃中。’造父驱车入圃，马见圃池而走，造父不能禁。造父以渴服马久矣，今马见池，馯而走，虽造父不能治……”\n			', '\n暂无\n			'),
(2234, '0:3:6', '以鹿为马', '\n【 yǐ　lù　wéi　mǎ 】\n			', '\n把鹿说成马。比喻故意颠倒是非。\n			', '\n汉·陆贾《新语·辨惑》：“秦二世之时，赵高驾鹿而从行，王曰:‘丞相何为驾鹿？’高曰:‘马也。’王曰:‘丞相误邪，以鹿为马也。’高曰:‘乃马也。陛下以臣之言为不然，愿问群臣。’于是乃问群臣，群臣半言马半言鹿。”\n			', '\n若论不直，其粗至於～，也是不直。\n			'),
(2235, '0:3:6', '饮马长江', '\n【 yǐn　mǎ　cháng　jiāng 】\n			', '\n在长江边给战马喝水。指渡江南下进行征伐。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2236, '0:3:6', '衣马轻肥', '\n【 yì　mǎ　qīng　féi 】\n			', '\n穿着轻暖的皮袍，坐着由肥马驾的车。形容生活的豪华。\n			', '\n语出《论语·雍也》：“乘肥马，衣轻裘。”唐·杜甫《秋兴》诗之三：“同学少年多不贱，五陵衣马自轻肥。”\n			', '\n儿子从宦者，有人来云：贫乏不能存，此是好消息；若闻赀货充足，～，此是恶消息。\n			'),
(2237, '0:3:6', '倚马千言', '\n【 yǐ　mǎ　qiān　yán 】\n			', '\n倚马：靠着战马。倚靠在即将出发的战马前起草文件，千言立就。形容才思敏捷。\n			', '\n南朝宋·刘义庆《世说新语·文学》：“桓宣武［桓温］北征，袁虎时从，被责免官。会须露布文，唤袁［袁宏］倚马前令作。手不掇笔，俄得七纸，殊可观。”\n			', '\n暂无\n			'),
(2238, '0:3:6', '饮马投钱', '\n【 yìn　mǎ　tóu　qián 】\n			', '\n比喻为人廉洁，不损公肥私。\n			', '\n唐·徐坚《初学记》卷六引《三辅决录》：“安陵清者有项仲仙，饮马渭水，每投三钱。”\n			', '\n暂无\n			'),
(2239, '0:3:6', '跃马弯弓', '\n【 yuè　mǎ　wān　gōng 】\n			', '\n驰马盘旋，张弓要射。形容摆开架势，准备作战。后比喻故做惊人的姿态，实际上并不立即行动。\n			', '\n唐·韩愈《雉带箭》诗：“将军欲以巧伏人，盘马弯弓惜不发。”\n			', '\n其来戍者，又岂不能蓄数十辈建儿，～，以自为功名封殖计耶。（清·侯方域《为司徒公赠万将军序》）\n			'),
(2240, '0:3:6', '以毛相马', '\n【 yǐ　máo　xiàng　mǎ 】\n			', '\n根据毛色判断马的优劣。比喻从表面上看问题，其所得认识往往与实际不符。\n			', '\n汉·桓宽《盐铁论·利议》：“故以言举人，若以毛相马，此其所以多不称举。”\n			', '\n暂无\n			'),
(2241, '0:3:6', '一马一鞍', '\n【 yī　mǎ　yī　ān 】\n			', '\n比喻一夫一妻，白头偕老。\n			', '\n清·文康《儿女英雄传》第四十回：“人各有志，不可相强。便是妇人女子的志向，也有个不同：有的讲究个女貌郎才，不辞非鸦非凤的，就有讲究个穿衣吃饭，只图一马一鞍的。”\n			', '\n暂无\n			'),
(2242, '0:3:6', '跃马扬鞭', '\n【 yuè　mǎ　yáng　biān 】\n			', '\n跃：跳。跳上骏马，举起马鞭。形容扬鞭催马急驰而去的样子。也比喻热火朝天地进行建设。\n			', '\n元·王实甫《丽春堂》第一折：“一个个跃马扬鞭，插箭弯弓。”\n			', '\n亲承顾命赈饥荒，～到此方。\n			'),
(2243, '0:3:6', '燕昭好马', '\n【 yān　zhāo　hǎo　mǎ 】\n			', '\n燕昭王喜爱骏马。后作求贤之典。\n			', '\n《旧唐书·薛登传》：“燕昭好马，则骏马来庭；叶公好龙，则真龙入室。”\n			', '\n暂无\n			'),
(2244, '0:3:6', '枕戈汗马', '\n【 zhěn　gē　hàn　mǎ 】\n			', '\n枕着武器，疾驰战马。形容时刻准备杀敌立功。\n			', '\n明·屠隆《昙花记·公子受封》：“念亲恩主德总来难报，须教，枕戈汗马，努力塞云边草，儿时得功成大漠，鹤归华表。”\n			', '\n臣非不知兵凶战危，而～，切齿痛心有日矣。\n			'),
(2245, '0:3:6', '止戈散马', '\n【 zhǐ　gē　sàn　mǎ 】\n			', '\n停用兵戈，放还战马，意指结束战争。\n			', '\n《北齐书·神武帝纪下》：“止戈散马，各事家业。”\n			', '\n暂无\n			'),
(2246, '0:3:6', '招军买马', '\n【 zhāo　jūn　mǎi　mǎ 】\n			', '\n犹招兵买马。\n			', '\n元·无名氏《聚兽牌》第一折：“今有汉三公子刘文叔，在白水村兴兵聚义，招军买马。”\n			', '\n次早平明，唐僧登坐帐中，教军士把～旗儿扯起。\n			'),
(2247, '0:3:6', '走马到任', '\n【 zǒu　mǎ　dào　rèn 】\n			', '\n指新委官员急速到任。后亦泛指接任新职。同“走马上任”。\n			', '\n清·孔尚任《桃花扇·入道》：“今奉上帝之命封为游天使者，走马到任去也。”\n			', '\n我觉得空气很好，财政总长的背后有了银行家帮忙，也就不妨～了。\n			'),
(2248, '0:3:6', '竹马之交', '\n【 zhú　mǎ　zhī　jiāo 】\n			', '\n竹马：小孩当马骑的竹竿。童年时代就要好的朋友。\n			', '\n唐·李白《长干行》：“郎骑竹马来，绕床弄青梅，同居长千里，两小无嫌猜。”\n			', '\n他和蔡文姬是～，他们是太亲密了。\n			'),
(2249, '0:3:7', '爱礼存羊', '\n【 ài　lǐ　cún　yáng 】\n			', '\n由于爱惜古礼，不忍使它废弛，因而保留古礼所需要的祭羊。比喻为维护根本而保留有关仪节。\n			', '\n《论语·八佾》：“子贡欲去告朔之饩羊，子曰：‘赐也，尔爱其羊，我爱其礼。’”\n			', '\n本朝监学之法，虽参以天下之士，而于国子加厚矣。盖～，以有待也。（宋·陈亮《国子》）\n			'),
(2250, '0:3:7', '昌歜羊枣', '\n【 chāng　chù　yáng　zǎo 】\n			', '\n据传周文王嗜昌歜，春秋鲁曾点嗜羊枣。后用以指人所偏好之物。\n			', '\n宋·苏轼《答李端叔书》：“不肖为人所僧，而二子独喜见誉，如人嗜昌歜羊枣，未易诘其所以然者。”\n			', '\n暂无\n			'),
(2251, '0:3:7', '多歧亡羊', '\n【 duō　qí　wáng　yáng 】\n			', '\n因岔路太多无法追寻而丢失了羊。比喻事物复杂多变，没有正确的方向就会误入歧途。也比喻学习的方面多了就不容易精深。\n			', '\n《列子·说符》：“大道以多歧亡羊，学者以多方丧生。”\n			', '\n然尝闻之，大道以～。（明·马中锡《中山狼传》）\n			'),
(2252, '0:3:7', '羝羊触藩', '\n【 dī　yáng　chù　fān 】\n			', '\n羝羊：公羊；触：抵撞；藩：篱笆。公羊的角缠在篱笆上，进退不得。比喻进退两难。\n			', '\n《周易·大壮》：“羝羊触藩，羸其角。”\n			', '\n纣王沉吟不语，心下煎熬，似～，进退两难。（明·许仲琳《封神演义》第七回）\n			'),
(2253, '0:3:7', '饿虎扑羊', '\n【 è　hǔ　pū　yáng 】\n			', '\n象饥饿的老虎扑向食物一样。比喻动作猛烈而迅速。\n			', '\n明·洪楩《清平山堂话本·五戒禅师么红莲记》：“一个初侵女色，由（犹）如饿虎吞羊。”\n			', '\n暂无\n			'),
(2254, '0:3:7', '饿虎擒羊', '\n【 è　hǔ　qín　yáng 】\n			', '\n像饥饿的老虎捕食羔羊一样。比喻迅猛贪婪。\n			', '\n清·钱彩《说岳全传》第七回：“兄听得索郎郎的叉盘声响，使个‘饿虎擒羊’势，叫道：‘你敢来么？’”\n			', '\n他做出一个～的动作让大家哄堂大笑。\n			'),
(2255, '0:3:7', '饿虎吞羊', '\n【 è　hǔ　tūn　yáng 】\n			', '\n饥饿的老虎活吞一只羊羔。比喻迅猛贪婪。\n			', '\n《清平山堂话本·五戒禅师私红莲记》：“一个初侵女色，由如饿虎吞羊。”\n			', '\n暂无\n			'),
(2256, '0:3:7', '告朔饩羊', '\n【 gù　shuò　xì　yáng 】\n			', '\n原指鲁国自文公起不亲到祖庙告祭，只杀一只羊应付一下。后比喻照例应付，敷衍了事。\n			', '\n《论语·八佾》：“子贡欲去告朔之忾羊。”\n			', '\n不过外蒙古一部分，已不啻～，名存实亡了。（蔡东藩、许廑父《民国通俗演义》第三十八回）\n			'),
(2257, '0:3:7', '挂羊头卖狗肉', '\n【 guà　yáng　tóu　mài　gǒu　ròu 】\n			', '\n比喻以好的名义做幌子，实际上名不副实或做坏事。\n			', '\n宋·释惟白《续传灯录》第31卷：“悬羊头，卖狗肉，知它有甚凭据。”\n			', '\n我们的组织决不能叫一些～的反动分子、投机分子所欺骗。\n			'),
(2258, '0:3:7', '挂羊头，卖狗肉', '\n【 guà　yáng　tóu，mài　gǒu　ròu 】\n			', '\n比喻以好的名义做招牌，实际上兜售低劣的货色。\n			', '\n宋·释普济《五灯会元》卷十六：“悬羊头，卖狗肉，坏后进，初几灭。”\n			', '\n中国现在的顽固派，正是这样。他们口里的宪政，不过是“～”。（毛泽东《新民主主义的宪政》）\n			'),
(2259, '0:3:7', '虎荡羊群', '\n【 hǔ　dàng　yáng　qún 】\n			', '\n老虎冲进羊群中。比喻以强凌弱，为所欲为。同“虎入羊群”。\n			', '\n清·石玉昆《三侠五义》第九十二回：“那知小侠指东打西，窜南跃北，犹如虎荡羊群，不大的工夫，打了个落花流水。”\n			', '\n暂无\n			'),
(2260, '0:3:7', '虎入羊群', '\n【 hǔ　rù　yáng　qún 】\n			', '\n老虎跑进羊群。比喻强大者冲入柔弱者中间任意砍杀。\n			', '\n明·罗贯中《三国演义》第十一回：“孔融望见太史慈与关、张赶杀贼众，如虎入羊群，纵横莫当。”\n			', '\n暂无\n			'),
(2261, '0:3:7', '羚羊挂角', '\n【 líng　yáng　guà　jiǎo 】\n			', '\n羚羊夜宿，挂角于树，脚不着地，以避祸患。旧时多比喻诗的意境超脱。\n			', '\n宋·严羽《沧浪诗话·诗辨》：“盛唐诸人唯在兴趣，羚羊挂角，无迹可求。”\n			', '\n暂无\n			'),
(2262, '0:3:7', '狼羊同饲', '\n【 láng　yáng　tóng　sì 】\n			', '\n比喻把坏人同好人一样对待。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2263, '0:3:7', '卖狗悬羊', '\n【 mài　gǒu　xuán　yáng 】\n			', '\n犹言挂羊头卖狗肉。意指名不副实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2264, '0:3:7', '买王得羊', '\n【 mǎi　wáng　dé　yáng 】\n			', '\n①指想买王献之字，却得到了羊欣的字。意为差强人意。②指摹仿名人的字画虽然逼真而终差一等。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2265, '0:3:7', '鸟道羊肠', '\n【 niǎo　dào　yáng　cháng 】\n			', '\n狭险典折的山路。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2266, '0:3:7', '牛羊勿践', '\n【 niú　yáng　wù　jiàn 】\n			', '\n勿使牛羊践踏。比喻爱护。\n			', '\n语出《诗·大雅·行苇》：“敦彼行苇，牛羊勿践履，方苞方体，维叶泥泥。”郑玄笺：“草木方茂盛，以其终将为人用，故周之先王为此爱之，况于人乎？”\n			', '\n况于有德有造，成人之材，～，遂物之性，可望其仿佛乎？\n			'),
(2267, '0:3:7', '歧路亡羊', '\n【 qí　lù　wáng　yáng 】\n			', '\n歧路：岔路；亡：丢失。因岔路太多无法追寻而丢失了羊。比喻事物复杂多变，没有正确的方向就会误入歧途。\n			', '\n《列子·说符》：“大道以多歧亡羊，学者以多方丧生。”\n			', '\n暂无\n			'),
(2268, '0:3:7', '牵羊担酒', '\n【 qiān　yáng　dàn　jiǔ 】\n			', '\n牵着羊，挑着酒。表示向人慰劳或庆贺。\n			', '\n元·无名氏《举案齐眉》第四折：“老夫如今牵羊担酒，与孩儿庆喜。”\n			', '\n愚有一计：并不劳～，纳士献印。（明·罗贯中《三国演义》第四十四回）\n			'),
(2269, '0:3:7', '驱羊攻虎', '\n【 qū　yáng　gōng　hǔ 】\n			', '\n驱：赶。驱赶羊群去进攻老虎。形容以弱敌强，力量悬殊，必遭覆灭。\n			', '\n《史记·张仪列传》：“且夫为从者，无以异于驱群羊而攻猛虎，虎之与羊不格明矣。今王不与猛虎而与群羊，臣窃以为大王之计过也。”\n			', '\n暂无\n			'),
(2270, '0:3:7', '驱羊战狼', '\n【 qū　yáng　zhàn　láng 】\n			', '\n比喻以弱击强。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2271, '0:3:7', '千羊之皮，不如一狐之腋', '\n【 qiān　yáng　zhī　pí，bù　rú　yī　hú　zhī 】\n			', '\n比喻众愚不如一贤。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2272, '0:3:7', '如狼牧羊', '\n【 rú　láng　mù　yáng 】\n			', '\n如同狼放养羊一般。比喻官吏残酷地欺压人民。\n			', '\n《史记·酷吏列传》：“宁成为济南都尉，其治如狼牧羊。”\n			', '\n暂无\n			'),
(2273, '0:3:7', '肉袒牵羊', '\n【 ròu　tǎn　qiān　yáng 】\n			', '\n牵羊：牵着羊，表示犒劳军队。古代战败投降的仪式。\n			', '\n《左传·宣公十二年》：“郑伯肉袒牵羊以逆，曰：‘孤不天，不能事君，使君怀怒以及敝邑，孤之罪也。’”\n			', '\n行至逵路，郑襄公～，以迎楚师。（明·冯梦龙《东周列国志》第五十三回）\n			'),
(2274, '0:3:7', '舍策追羊', '\n【 shě　cè　zhuī　yáng 】\n			', '\n放下手中书本去寻找丢失的羊。比喻发生错误以后，设法补救。\n			', '\n语出《庄子·骈拇》：“臧与榖二人相与牧羊，而俱亡其羊。问臧奚事？则挟筴读书；问榖奚事？则博塞以游。”陆德明释文：“筴，字又作策，初革反。李云：竹简也。古以写书，长二尺四寸。”\n			', '\n暂无\n			'),
(2275, '0:3:7', '素丝羔羊', '\n【 sù　sī　gāo　yáng 】\n			', '\n指正直廉洁的官吏。\n			', '\n《诗·周南·羔羊》：“羔羊之皮，素丝五陀，退食自公，委蛇委蛇。”\n			', '\n暂无\n			'),
(2276, '0:3:7', '顺手牵羊', '\n【 shùn　shǒu　qiān　yáng 】\n			', '\n顺手把人家的羊牵走。比喻趁势将敌手捉住或乘机利用别人。现比喻乘机拿走别人的东西。\n			', '\n《礼记·曲礼上》：“效马效羊者右牵之。”\n			', '\n据说座山雕的部下有个～的老方子，一撮毛可能是想施展这个伎俩。（曲波《林海雪原》十二）\n			'),
(2277, '0:3:7', '鼠穴寻羊', '\n【 shǔ　xué　xún　yáng 】\n			', '\n比喻没有功效的做法。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2278, '0:3:7', '瘦羊博士', '\n【 shòu　yáng　bó　shì 】\n			', '\n指能克己让人的人。\n			', '\n《后汉书甄宇传》：“建武中，[甄宇]为州从事，征拜博士。”李贤注引《东观汉记》：“建武中每腊，诏书赐博士一羊。羊有大小肥瘦。时博士祭酒议，欲杀羊分肉，……宇因先自取其最瘦者，由是不复有争讼。”\n			', '\n多少长安苦吟客，～擅风流。\n			'),
(2279, '0:3:7', '使羊将狼', '\n【 shǐ　yáng　jiàng　láng 】\n			', '\n将：统率，指挥。派羊去指挥狼。比喻不足以统率指挥。也比喻使仁厚的人去驾驭强横而有野心的人，这要坏事。\n			', '\n《史记·留侯世家》：“太子所与俱诸将，皆尝与上定天下枭将也，今使太子将之，此无异使羊将狼也。”\n			', '\n暂无\n			'),
(2280, '0:3:7', '十羊九牧', '\n【 shí　yáng　jiǔ　mù 】\n			', '\n十头羊倒用九个人放牧。比喻官多民少，赋税剥削很重。也比喻使令不一，无所适从。\n			', '\n《隋书·杨尚希传》：“所谓民少官多，十羊九牧。”\n			', '\n暂无\n			'),
(2281, '0:3:7', '屠所牛羊', '\n【 tú　suǒ　niú　yáng 】\n			', '\n比喻临近死亡的人。\n			', '\n《大涅磐经·迦叶品》：“如囚趋市，步步近死，如牵牛羊诣于屠所。”\n			', '\n暂无\n			'),
(2282, '0:3:7', '替罪羊', '\n【 tì　zuì　yáng 】\n			', '\n古代犹太教祭礼是替人承担罪过的羊。比喻代人受过。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2283, '0:3:7', '亡羊补牢', '\n【 wáng　yáng　bǔ　láo 】\n			', '\n亡：逃亡，丢失；牢：关牲口的圈。羊逃跑了再去修补羊圈，还不算晚。比喻出了问题以后想办法补救，可以防止继续受损失。\n			', '\n《战国策·楚策》：“见兔而顾犬，未为晚也；亡羊而补牢，未为迟也。”\n			', '\n张学良始则失地，今幸固守锦州，～，可称晚悟。（章炳麟《与孙思昉论时事书》二）\n			'),
(2284, '0:3:7', '亡羊得牛', '\n【 wáng　yáng　dé　niú 】\n			', '\n丢掉羊，得到牛。比喻损失小而收获大。\n			', '\n《淮南子·说山训》：“亡羊而得牛，则莫不利失也。”\n			', '\n暂无\n			'),
(2285, '0:3:7', '问羊知马', '\n【 wèn　yáng　zhī　mǎ 】\n			', '\n比喻从旁推究，弄清楚事情真相。\n			', '\n《汉书·赵广汉传》：“钩距者，设欲知马贾（价），则先问狗，已问羊，又问牛，然后及马。”\n			', '\n暂无\n			'),
(2286, '0:3:7', '亡羊之叹', '\n【 wáng　yáng　zhī　tàn 】\n			', '\n亡：丢失。叹：叹息。为丢失了羊而叹息。比喻探索学问，徘徊歧路，结果一无所得，空留遗憾。亦作“亡羊歧路”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2287, '0:3:7', '羊触藩篱', '\n【 yáng　chù　fān　lí 】\n			', '\n羊角勾挂在篱笆上。形容既不能进，也不能退。\n			', '\n明·许仲琳《封神演义》第三十一回：“前无所往，退无所归，羊触藩篱，进退两难。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2288, '0:3:7', '羊肠九曲', '\n【 yáng　cháng　jiǔ　qǔ 】\n			', '\n羊肠：像羊肠一样崎岖曲折的小路。九曲：有许多曲折的地方，指河道曲折。形容崎岖曲折的小径和弯弯曲曲的河道。也指道路的艰难。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2289, '0:3:7', '羊肠鸟道', '\n【 yáng　cháng　niǎo　dào 】\n			', '\n形容山路狭窄，曲折而险峻。\n			', '\n唐玄宗《早登太行山中言志》诗：“火龙明鸟道，铁骑绕羊肠。”\n			', '\n千崖万壑供野宿，～笑津迷。（陈毅《乐安宜黄道中闻捷》）\n			'),
(2290, '0:3:7', '羊肠小道', '\n【 yáng　cháng　xiǎo　dào 】\n			', '\n曲折而极窄的路（多指山路）。\n			', '\n唐玄宗《早登太行山中言志》诗：“火龙明鸟道，铁骑绕羊肠。”\n			', '\n前面弯弯曲曲，尽是～，岔路甚多，甚难分辨。（清·李汝珍《镜花缘》第四十九回）\n			'),
(2291, '0:3:7', '羊羔美酒', '\n【 yán　gāo　měi　jiǔ 】\n			', '\n羊羔：酒名，因酿制材料中有羊肉，故名。味儿醇厚的好酒。\n			', '\n宋·无名氏《湘湖近事》：“陶谷学士，尝买得党太尉家故妓……，妓曰：‘彼粗人也，安有此景，但能销金暖帐下，浅斟低唱，饮羊羔美酒耳。’谷愧其言。”\n			', '\n我虽比他尊贵，但绫锦纱罗，也不过裹了我这枯株朽木，～，也不过填了我这粪窟泥沟。\n			'),
(2292, '0:3:7', '羊狠狼贪', '\n【 yáng　hěn　láng　tān 】\n			', '\n狠：凶狠。原指为人凶狠，争夺权势。后比喻贪官污吏的残酷剥削。\n			', '\n《史记·项羽本纪》：“因下令军中曰：‘猛如虎，很如羊，贪如狼，强不可使者，皆斩之。’”\n			', '\n暂无\n			'),
(2293, '0:3:7', '羊落虎口', '\n【 yáng　luò　hǔ　kǒu 】\n			', '\n比喻处于险境，有死无生。\n			', '\n元·朱凯《昊天塔》第一折：“俺家姓杨，被番兵陷在虎口交牙峪里。这个叫做羊落虎口，正犯了兵家所忌。”\n			', '\n暂无\n			'),
(2294, '0:3:7', '羊毛出在羊身上', '\n【 yáng　máo　chū　zài　yáng　shēn　shàng 】\n			', '\n比喻表面上给了人家好处，但实际上这好处已附加在人家付出的代价里。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2295, '0:3:7', '羊入虎群', '\n【 yáng　rù　hǔ　qún 】\n			', '\n比喻好人落入坏人的手中，处境极端危险。\n			', '\n清·蒲松龄《聊斋志异·邵九娘》：“窃意羊入虎群，狼藉已不堪矣。”\n			', '\n暂无\n			'),
(2296, '0:3:7', '羊续悬鱼', '\n【 yáng　xù　xuán　yú 】\n			', '\n羊续，汉时官吏。羊续把生鱼悬于庭。形容为官清廉，拒受贿赂。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2297, '0:3:7', '以羊易牛', '\n【 yǐ　yáng　yì　niú 】\n			', '\n易：更换。用羊来替换牛。比喻用这个代替另一个。\n			', '\n《孟子·梁惠王上》：“王坐于堂上，有牵牛而过堂下者。……曰：‘何可废也，以羊易之。’”\n			', '\n东床已招佳选，何知～；西邻纵有责言，终难指鹿为马。（明·冯梦龙《醒世恒言》卷七）\n			'),
(2298, '0:3:7', '羊质虎皮', '\n【 yáng　zhì　hǔ　pí 】\n			', '\n质：本性。羊虽然披上虎皮，还是见到草就喜欢，碰到豺狼就怕得发抖，它的本性没有变。比喻外表装作强大而实际上很胆小。\n			', '\n汉·扬雄《法言·吾子》：“羊质而虎皮，见草而悦，见豺而战，忘其皮之虎矣。”\n			', '\n～功不就，凤毛鸡胆事难成。（明·罗贯中《三国演义》第三十二回）\n			'),
(2299, '0:3:7', '臧谷亡羊', '\n【 zāng　gǔ　wáng　yáng 】\n			', '\n后因以为典，喻事不同而实则一。\n			', '\n《庄子·骈拇》：“臧、谷二人牧羊，臧挟策读书，谷博塞以游，皆亡其羊。”宋·苏轼《和刘道原〈咏史〉》：“仲尼忧世接舆狂，藏谷虽殊竟两亡。”\n			', '\n暂无\n			'),
(2300, '0:3:7', '臧穀亡羊', '\n【 zāng　gǔ　wáng　yáng 】\n			', '\n《庄子·骈拇》载，臧、穀二人牧羊，臧挟策读书，穀博塞以游，皆亡其羊。后因以为典，喻事不同而实则一。\n			', '\n宋·苏轼《和刘道原〈咏史〉》：“仲尼忧世接舆狂，藏穀虽殊竟两亡。”\n			', '\n暂无\n			'),
(2301, '0:3:7', '争鸡失羊', '\n【 zhēng　jī　shī　yáng 】\n			', '\n比喻贪小失大。\n			', '\n汉·焦延寿《易林》卷八：“争鸡失羊，亡其金囊。”\n			', '\n暂无\n			'),
(2302, '0:3:8', '猴年马月', '\n【 hóu　nián　mǎ　yuè 】\n			', '\n猴、马：十二生肖之一。泛指未来的岁月。\n			', '\n<span class="C999">暂无</span>\n			', '\n你这样下去，猴年马月才能完成。\n			'),
(2303, '0:3:8', '猴头猴脑', '\n【 hóu　tóu　hóu　nǎo 】\n			', '\n像猴子那样好动，形容行动浮躁。\n			', '\n<span class="C999">暂无</span>\n			', '\n这孩子一点规矩也不懂，猴头猴脑的。\n			'),
(2304, '0:3:8', '尖嘴猴腮', '\n【 jiān　zuǐ　hóu　sāi 】\n			', '\n形容人相貌丑陋粗俗。\n			', '\n<span class="C999">暂无</span>\n			', '\n象你这～，也该撒泡尿自己照照！不三不四，就想天鹅屁吃。（清·吴敬梓《儒林外史》第三回）\n			'),
(2305, '0:3:8', '沐猴而冠', '\n【 mù　hóu　ér　guàn 】\n			', '\n沐猴：猕猴；冠：戴帽子。猴子穿衣戴帽，究竟不是真人。比喻虚有其表，形同傀儡。常用来讽刺投靠恶势力窃据权位的人。\n			', '\n《史记·项羽本纪》：“人言楚人沐猴而冠耳，果然。”\n			', '\n暂无\n			'),
(2306, '0:3:8', '猕猴骑土牛', '\n【 mí　hóu　qí　tǔ　niú 】\n			', '\n比喻职位提升很慢。\n			', '\n《三国志·魏书·邓艾传》引《世语》：“君，名公之子，少有文采，故守吏职；猕猴骑土牛，又何迟也。”\n			', '\n暂无\n			'),
(2307, '0:3:8', '沐猴衣冠', '\n【 mù　hóu　yī　guàn 】\n			', '\n比喻虚有其表，形同傀儡。常用来讽刺投靠恶势力窃据权位的人。同“沐猴而冠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2308, '0:3:8', '弄鬼掉猴', '\n【 nòng　guǐ　diào　hóu 】\n			', '\n比喻调皮捣蛋。\n			', '\n清·曹雪芹《红楼梦》第四十六回：“买了来三日两日，又弄鬼掉猴的。”\n			', '\n暂无\n			'),
(2309, '0:3:8', '杀鸡哧猴', '\n【 shā　jī　chī　hóu 】\n			', '\n比喻惩罚一人以恐吓或警戒其他人。同“杀鸡骇猴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2310, '0:3:8', '杀鸡骇猴', '\n【 shā　jī　hài　hóu 】\n			', '\n传说猴子怕见血，驯猴的人便杀鸡放血来恐吓猴子。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n俗语说的好，叫做“～”，拿鸡子宰了，那猴儿自然害怕。（清·李宝嘉《官场现形记》第五十三回）\n			'),
(2311, '0:3:8', '杀鸡儆猴', '\n【 shā　jī　jǐng　hóu 】\n			', '\n杀鸡给猴子看。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2312, '0:3:8', '杀鸡吓猴', '\n【 shā　jī　xià　hóu 】\n			', '\n杀鸡给猴子看。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n猜到皇上有～之意，心中七上八下，半天没有做声。（姚雪垠《李自成》第二卷第二十一章）\n			'),
(2313, '0:3:8', '山上无老虎，猴子称大王', '\n【 shān　shàng　wú　lǎo　hǔ，hóu　zǐ　chēng　 】\n			', '\n俗语，比喻没有能人，普通人物亦充当主要角色。\n			', '\n《晚清文学丛钞·冷眼观》第十四回：“靠著老子做过上海道，在城里面山上无老虎，猴子称大王弄惯了的脾气，陪著朋友来吃台把酒，就像是连四块下脚钱都是冤枉花的。”\n			', '\n暂无\n			'),
(2314, '0:3:8', '土龙沐猴', '\n【 tǔ　lóng　mù　hóu 】\n			', '\n比喻徒有虚名，而无其实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2315, '0:3:8', '轩鹤冠猴', '\n【 xuān　hè　guàn　hóu 】\n			', '\n乘轩之鹤，戴帽之猴。比喻滥厕禄位、虚有其表的人。\n			', '\n明·刘基《驿传杭台消息石末公有诗见寄次韵奉和并寓悲感》之一：“池鱼幕燕依栖浅，轩鹤冠猴宠渥新。”\n			', '\n暂无\n			'),
(2316, '0:3:8', '猿猴取月', '\n【 yuán　hóu　qǔ　yuè 】\n			', '\n比喻愚昧无知。也比喻白费力气。\n			', '\n宋·黄庭坚《沁园春》词：“镜里拈花，水中捉月，觑着无由得近伊。”\n			', '\n暂无\n			'),
(2317, '0:3:8', '宰鸡教猴', '\n【 zǎi　jī　jiào　hóu 】\n			', '\n用杀鸡来警戒猴子。比喻严惩一个以警告其余。\n			', '\n高云览《小城春秋》第三章：“吴七总想抓个奸细来‘宰鸡教猴’一下，吴坚和家剑平反对；怕闹得内部更混乱，又怕有后患。”\n			', '\n暂无\n			'),
(2318, '0:3:9', '阿狗阿猫', '\n【 ā　gǒu　ā　māo 】\n			', '\n旧时人们常用的小名。引申为任何轻贱的，不值得重视的人或著作。\n			', '\n鲁迅《我们要批评家》：“然而新的批评家不开口，类似批评家之流便趁势一笔抹杀：‘阿狗阿猫’。”\n			', '\n暂无\n			'),
(2319, '0:3:9', '阿猫阿狗', '\n【 ā　māo　ā　gǒu 】\n			', '\n旧时人们常用的小名。引申为任何轻贱的，不值得重视的人或著作。\n			', '\n鲁迅《我的第一个师父》：“这和名孩子为阿猫阿狗，完全是一样的意思：容易养大。”\n			', '\n在德国无论～见面，一律互相举手高喊：“希特勒万岁”。\n			'),
(2320, '0:3:9', '帮狗吃食', '\n【 bāng　gǒu　chī　shí 】\n			', '\n比喻帮坏人作坏事。同“帮虎吃食”。\n			', '\n高玉宝《高玉宝》第四章：“这个万瞎子……专给保长溜须拍马，对穷人却是敲诈勒索，最能帮狗吃食。”\n			', '\n暂无\n			'),
(2321, '0:3:9', '白云苍狗', '\n【 bái　yún　cāng　gǒu 】\n			', '\n苍：灰白色。浮云象白衣裳，顷刻又变得象苍狗。比喻事物变化不定。\n			', '\n唐·杜甫《可叹诗》：“天上浮云似白衣，斯须改变如苍狗。”\n			', '\n真是世事～，不禁感慨系之矣！（鲁迅《华盖集后记》）\n			'),
(2322, '0:3:9', '白衣苍狗', '\n【 bái　yī　cāng　gǒu 】\n			', '\n苍：灰白色。浮云象白衣裳，顷刻又变得象苍狗。比喻事物变化不定。\n			', '\n唐·杜甫《可叹诗》：“天上浮云似白衣，斯须改变如苍狗。”\n			', '\n正是～多翻覆，沧海桑田几变更。\n			'),
(2323, '0:3:9', '苍狗白衣', '\n【 cāng　gǒu　bái　yī 】\n			', '\n同白衣苍狗，比喻世事变化无常。\n			', '\n宋·杨万里《送乡人余文明劝之以归》诗：“苍狗白衣俱昨梦，长庚孤月自青天。”\n			', '\n暂无\n			'),
(2324, '0:3:9', '苍狗白云', '\n【 cāng　gǒu　bái　yún 】\n			', '\n比喻事物变幻无常。同“苍狗白衣”。\n			', '\n清·文康《儿女英雄传》第三十八回：“春花秋月销磨尽，苍狗白云变态中，游丝万丈飘无定。”\n			', '\n暂无\n			'),
(2325, '0:3:9', '藏弓烹狗', '\n【 cáng　gōng　pēng　gǒu 】\n			', '\n飞鸟射尽了就把良弓收起，狡兔被捉就把捕兔的猎狗煮了吃肉。旧时比喻统治者得势后，废弃、杀害有功之臣。\n			', '\n《史记·越王勾践世家》：“飞鸟尽，良弓藏，狡兔死，走狗烹。”\n			', '\n暂无\n			'),
(2326, '0:3:9', '椎埋狗窃', '\n【 chuí　mái　gǒu　qiè 】\n			', '\n指抢杀偷盗，不务正业。\n			', '\n宋·赵彦卫《云麓漫钞》卷六：“自绛灌至申屠嘉，皆向时棰埋狗窃之人。”\n			', '\n暂无\n			'),
(2327, '0:3:9', '椎埋屠狗', '\n【 chuí　mái　tú　gǒu 】\n			', '\n杀人宰狗。指为非作歹和从事低贱的职业。\n			', '\n宋·苏洵《权书下·高祖》：“谁谓百岁之后，椎埋屠狗之人见其亲戚乘势为帝王，而不欣然而从之邪！”\n			', '\n击筑悲歌、～之徒，其骨已朽，而燕赵之名，至今学士大夫饫闻而喜称之。\n			'),
(2328, '0:3:9', '貂不足，狗尾续', '\n【 diāo　bù　zú，gǒu　wěi　xù 】\n			', '\n①指授官太滥。②指美中不足或以次充好。\n			', '\n《文选·任昉\n			', '\n散文，在文苑中算是成功的，但试看今年的选本，便是前三名，也即令人有‘～’之感。\n			'),
(2329, '0:3:9', '打狗看主', '\n【 dǎ　gǒu　kàn　zhǔ 】\n			', '\n狗有主人，打不打它，要看给其主人留不留情面。比喻处理坏人下事要顾全其后台的情面。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第七十九回：“不知原来家中大小姐这等暴躁性子，就是打狗也看主人面。”\n			', '\n暂无\n			'),
(2330, '0:3:9', '貂狗相属', '\n【 diāo　gǒu　xiāng　shǔ 】\n			', '\n指真伪或优劣混杂在一起。\n			', '\n唐·崔倬《叙石幢事》：“倬自幼学慕习鲁公书法……惜奇高踪堙没，遂命攻治其伤残，补续其次，虽真赝悬越，貂狗相属，且复瞻仰鲁公遗文，昭示于后矣。”\n			', '\n暂无\n			'),
(2331, '0:3:9', '打鸡骂狗', '\n【 dǎ　jī　mà　gǒu 】\n			', '\n比喻旁敲侧击地漫骂，以发泄对某人的不满。\n			', '\n鲁迅《彷徨·肥皂》：“你今天怎么尽闹脾气，连吃饭时候也是打鸡骂狗的。”\n			', '\n暂无\n			'),
(2332, '0:3:9', '斗鸡养狗', '\n【 dòu　jī　yǎng　gǒu 】\n			', '\n指旧时剥削阶级子弟游手好闲的无聊游戏。同“斗鸡走狗”。\n			', '\n《金瓶梅词话》第九八回：“他兄弟在家开赌场，斗鸡养狗，人不敢惹他。”\n			', '\n暂无\n			'),
(2333, '0:3:9', '斗鸡走狗', '\n【 dòu　jī　zǒu　gǒu 】\n			', '\n使公鸡相斗，使狗赛跑。指旧时剥削阶级子弟游手好闲的无聊游戏。\n			', '\n《史记·袁盎晁错列传》：“盎病免居家，与阊里淝枕，相随行斗鸡走狗。”\n			', '\n虽然应名来上学，亦不过虚掩眼目而已，仍是～，赏花阅柳为事。（清·曹雪芹《红楼梦》第九回）\n			'),
(2334, '0:3:9', '打落水狗', '\n【 dǎ　luò　shuǐ　gǒu 】\n			', '\n比喻继续打击已经失败的坏人。\n			', '\n<span class="C999">暂无</span>\n			', '\n至于“打落水狗”，则并不如此简单，当看狗之怎样，以及如何落水而定。（鲁迅《坟·论“费厄波赖”应该缓行》）\n			'),
(2335, '0:3:9', '打人骂狗', '\n【 dǎ　rén　mà　gǒu 】\n			', '\n对人滥打乱骂，摆尽威风。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2336, '0:3:9', '饭牛屠狗', '\n【 fàn　niú　tú　gǒu 】\n			', '\n①喻指从事低贱之事。②指从事贱业者。\n			', '\n明·陈子龙《酬吴次尾》诗：“别来落魄吴楚间，饭牛屠狗俱无颜。”\n			', '\n黄金浪掷唱呼鹰，～皆知己。\n			'),
(2337, '0:3:9', '飞鹰走狗', '\n【 fēi　yīng　zǒu　gǒu 】\n			', '\n放出鹰狗去追捕野兽。指打猎游荡的生活。\n			', '\n《后汉书·袁术传》：“少以侠气闻，数与诸公子飞鹰走狗。”\n			', '\n暂无\n			'),
(2338, '0:3:9', '狗傍人势', '\n【 gǒu　bàng　rén　shì 】\n			', '\n比喻坏人依靠某种势力欺侮人。同“狗仗人势”。\n			', '\n清·蒋士铨《一片石·访墓》：“我把你这狗傍人势的奴才，我是服张天师管的，你那个老头儿，又不是道纪司，我怕他怎的。”\n			', '\n暂无\n			'),
(2339, '0:3:9', '狗党狐朋', '\n【 gǒu　dǎng　hú　péng 】\n			', '\n泛指一些吃喝玩乐、不务正业的朋友。同“狐朋狗党”。\n			', '\n元·乔吉《金钱记》第一折：“我是个诗坛酒社文章士，不比那狗党狐朋恶少年。”\n			', '\n暂无\n			'),
(2340, '0:3:9', '狗党狐群', '\n【 gǒu　dǎng　hú　qún 】\n			', '\n比喻勾结在一起的坏人。同“狐群狗党”。\n			', '\n明·元心子《金雀记·投崖》：“差杀你狗党狐群，我怎肯丧志污红粉。”\n			', '\n～招集易，呼朋引类便相亲。\n			'),
(2341, '0:3:9', '狗盗鸡鸣', '\n【 gǒu　dào　jī　míng 】\n			', '\n①比喻具有微末技能。②比喻偷偷摸摸。\n			', '\n金·元好问《示怀祖》诗：“狗盗鸡鸣皆有用，鹤长凫短果如何？”\n			', '\n报仇的这桩事，是桩光明磊落、见得天地鬼神的事，何须这等～、遮遮掩掩。\n			'),
(2342, '0:3:9', '狗盗鸡啼', '\n【 gǒu　dào　jī　tí 】\n			', '\n比喻具有微末技能。同“狗盗鸡鸣”。\n			', '\n明·陆采《明珠记·江会》：“函关脱离，又何须狗盗鸡啼？”\n			', '\n暂无\n			'),
(2343, '0:3:9', '狗逮老鼠', '\n【 gǒu　dǎi　lǎo　shǔ 】\n			', '\n比喻做外行事或多管闲事。同“狗拿耗子”。\n			', '\n柳青《狠透铁》五：“你狗逮老鼠多管那闲事做啥？”\n			', '\n暂无\n			'),
(2344, '0:3:9', '狗颠屁股', '\n【 gǒu　diān　pì　gu 】\n			', '\n狗在主人面前摇尾乞怜。形容对人逢迎献媚的丑态。\n			', '\n《红楼梦》第六一回：“春燕说荤的不好，另叫你炒个面筯儿，少搁油才好，你忙着就说自己发昏，赶着洗手炒了，狗颠屁股儿似的，亲自捧了去。”\n			', '\n好容易俺家里出了一个好孩子，你们不～的献些殷勤，反倒作践起来。\n			'),
(2345, '0:3:9', '狗盗鼠窃', '\n【 gǒu　dào　shǔ　qiè 】\n			', '\n像鼠狗那样的盗贼。比喻成不了气候的反叛者。\n			', '\n汉·荀悦《汉纪·惠帝纪》：“今明主在于上，法令具于下，安得有反贼乎？此真狗盗鼠窃耳！”\n			', '\n暂无\n			'),
(2346, '0:3:9', '狗恶酒酸', '\n【 gǒu　è　jiǔ　suān 】\n			', '\n比喻环境险恶，使人裹足不前。\n			', '\n汉·韩婴《韩诗外传》卷七：“人有市酒而甚美者，置表甚长，然至酒酸而不售。问里人其故？里人曰：‘公之狗甚猛，而人有持器而欲往者，狗辄迎而齧之，是以酒酸不售也。’”\n			', '\n暂无\n			'),
(2347, '0:3:9', '狗吠不惊', '\n【 gǒu　fèi　bù　jīng 】\n			', '\n吠：狗叫声。狗偶尔的叫声不会引起惊慌。形容社会太平安定。\n			', '\n《后汉书·岑熙传》：“（熙）迁魏郡太守，……视事二年，舆人歌之曰：‘我有枳棘，岑君伐之；有蟊贼，岑君遏之；狗吠不惊，足下生氂。’”\n			', '\n暂无\n			'),
(2348, '0:3:9', '狗吠非主', '\n【 gǒu　fèi　fēi　zhǔ 】\n			', '\n比喻臣子各忠于自己的君主。\n			', '\n《战国策·齐策六》：“跖之狗吠尧，非贵跖而践尧也，狗固吠其主也。”\n			', '\n暂无\n			'),
(2349, '0:3:9', '狗肺狼心', '\n【 gǒu　fèi　láng　xīn 】\n			', '\n形容心肠象狼和狗一样凶恶狠毒。同“狼心狗肺”。\n			', '\n昆曲《十五贯》第二场：“谋财害命拐女人，狗肺狼心！”\n			', '\n只为一班卖国格中国人，生成狗肺搭狼心，日日夜夜吃穷人，吃得来头错眼暗发热乎。\n			'),
(2350, '0:3:9', '狗吠之警', '\n【 gǒu　fèi　zhī　jǐng 】\n			', '\n比喻轻微的惊动或扰乱。\n			', '\n《汉书·严助传》：“今方内无狗吠之警。”\n			', '\n暂无\n			'),
(2351, '0:3:9', '狗吠之惊', '\n【 gǒu　fèi　zhī　jīng 】\n			', '\n吠：狗叫；惊：惊吓。比喻小的惊吓。\n			', '\n西汉·司马迁《史记·平津侯主父列传》：“今中国无狗吠之惊，而外累于远方之备。”\n			', '\n你不至于被这～所吓倒吧。\n			'),
(2352, '0:3:9', '狗苟蝇营', '\n【 gǒu　gǒu　yíng　yíng 】\n			', '\n比喻为了名利不择手段，象苍蝇一样飞来飞去，象狗一样不知羞耻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2353, '0:3:9', '狗急跳墙', '\n【 gǒu　jí　tiào　qiáng 】\n			', '\n比喻坏人在走投无路时豁出去，不顾一切地捣乱。\n			', '\n《敦煌变文集·燕子赋》：“人急烧香，狗急蓦墙。”\n			', '\n今儿我听了他的短儿，“人急造反，～”，不但生事，而且我还没趣。（清·曹雪芹《红楼梦》第二十二回）\n			'),
(2354, '0:3:9', '狗口里生不出象牙', '\n【 gǒu　kǒu　lǐ　shēng　bù　chū　xiàng　yá 】\n			', '\n比喻坏人说不出好话。同“狗口里吐不出象牙”。\n			', '\n茅盾《霜叶红似二月花续稿》第十五章：“还有些话，牵涉到老弟，咳，反正狗口不出象牙，不说也罢。”\n			', '\n暂无\n			'),
(2355, '0:3:9', '狗口里吐不出象牙', '\n【 gǒu　kǒu　lǐ　tǔ　bù　chū　xiàng　yá 】\n			', '\n比喻坏人说不出好话。\n			', '\n《元曲选·遇上皇》第一折：“父亲和这等东西，有什么好话，讲出什么公理来，狗口里吐不出象牙。”\n			', '\n暂无\n			'),
(2356, '0:3:9', '关门打狗', '\n【 guān　mén　dǎ　gǒu 】\n			', '\n比喻将对方控制在自己势力范围内，然后进行有效打击。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2357, '0:3:9', '狗马声色', '\n【 gǒu　mǎ　shēng　sè 】\n			', '\n良犬、骏马、音乐、女色。泛指养狗、骑马、听歌、狎妓等剥削阶级行乐的方式。借指穷奢极侈的享乐。\n			', '\n宋·张孝祥《宣州新建御书阁记》：“谓虽极天下之贵，而退朝燕息，从容娱乐者，独在于是，狗马声色技巧之奉，不皇及也。”\n			', '\n为君者日不闻其过，亦自以为四方平治，圣哲若古，而～之欲因以中其心志矣。\n			'),
(2358, '0:3:9', '狗拿耗子', '\n【 gǒu　ná　hào　zǐ 】\n			', '\n（歇后语）多管闲事。狗的职责是看守门户，猫是专捉老鼠的，所以狗替猫捉老鼠，就是多管闲事。\n			', '\n清·文康《儿女英雄传》第三十四回：“你这孩子，才叫他娘的狗拿耗子呢！你又懂得几篇儿是几篇儿？”\n			', '\n暂无\n			'),
(2359, '0:3:9', '狗屁不通', '\n【 gǒu　pì　bù　tōng 】\n			', '\n指责别人说话或文章极不通顺。\n			', '\n清·石玉昆《三侠五义》第35回：“柳老赖婚狼心推测，冯生联句狗屁不通。”\n			', '\n你的文章尽管～，有人争先恐后的请你做广告。\n			'),
(2360, '0:3:9', '狗皮膏药', '\n【 gǒu　pí　gāo　yào 】\n			', '\n中医用狗皮膏药消肿止痛。比喻骗人的货色。\n			', '\n刘复《\n			', '\n暂无\n			'),
(2361, '0:3:9', '狗头军师', '\n【 gǒu　tóu　jūn　shī 】\n			', '\n比喻爱给人出主意而主意又不高明的人。也比喻专门出坏主意的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2362, '0:3:9', '狗头鼠脑', '\n【 gǒu　tóu　shǔ　nǎo 】\n			', '\n比喻奴才相。\n			', '\n《黑籍冤魂》第六回：“要说这林则徐，却不像那些狗头鼠脑的官员，要算我们中国的杰出人物。”\n			', '\n暂无\n			'),
(2363, '0:3:9', '狗偷鼠窃', '\n【 gǒu　tōu　shǔ　qiè 】\n			', '\n像鼠狗那样的盗贼。比喻成不了气候的反叛者。同“狗盗鼠窃”。\n			', '\n明·刘基《郁离子·千里马》：“君之门下，无非狗偷鼠窃、无赖之人也。”\n			', '\n今复遣数舟，～。\n			'),
(2364, '0:3:9', '狗尾貂续', '\n【 gǒu　wěi　diāo　xù 】\n			', '\n比喻拿不好的东西补接在好的东西后面，前后两部分非常不相称。同“狗尾续貂”。\n			', '\n清·李渔《闲情偶寄·词曲·词采》：“尚有踊跃于前，懈弛于后，不得已而为狗尾貂续者亦有之。”\n			', '\n暂无\n			'),
(2365, '0:3:9', '狗尾续貂', '\n【 gǒu　wěi　xù　diāo 】\n			', '\n比喻拿不好的东西补接在好的东西后面，前后两部分非常不相称。\n			', '\n《晋书·赵王伦传》：“奴卒厮役亦加以爵位。每朝会，貂蝉盈坐，时人为之谚曰：‘貂不足，狗尾续。’”\n			', '\n暂无\n			'),
(2366, '0:3:9', '狗续貂尾', '\n【 gǒu　xù　diāo　wěi 】\n			', '\n指封官太滥。亦比喻拿不好的东西补接在好的东西后面，前后两部分非常不相称。同“狗尾续貂”。\n			', '\n清·嬴宗季女《六月霜·张罗》：“杀人献媚，情甘狗续貂尾。”\n			', '\n暂无\n			'),
(2367, '0:3:9', '狗心狗行', '\n【 gǒu　xīn　gǒu　xíng 】\n			', '\n比喻歹毒的心肠、行为。\n			', '\n元·无名氏《杀狗劝夫》第三折：“这等人玩的是狗气狗声，这等人使的是狗心狗行。\n			', '\n暂无\n			'),
(2368, '0:3:9', '狗续侯冠', '\n【 gǒu　xù　hòu　guàn 】\n			', '\n犹狗续金貂。比喻滥封的官吏。\n			', '\n清·感惺《断头台·党争》：“琶歌宫布，为后不若为娼；狗续侯冠，畏首还当畏尾。”\n			', '\n暂无\n			'),
(2369, '0:3:9', '狗续金貂', '\n【 gǒu　xù　jīn　diāo 】\n			', '\n比喻滥封的官吏。\n			', '\n清·筱波山人《爱国魂·勤王》：“嗟满座狗续金貂，则索要清海宇谁把狼烟扫？”\n			', '\n暂无\n			'),
(2370, '0:3:9', '狗血淋头', '\n【 gǒu　xuè　lín　tóu 】\n			', '\n旧时迷信说法，谓狗血淋在妖人头上，就可使其妖法失灵。后形容骂得很凶，使被骂者如淋了狗血的妖人一样，无言以对，无计可施。\n			', '\n明·施耐庵《水浒全传》第五十三回：“马知府道：‘必然是个妖人！’教去取些法物来。牢子、节级将李逵捆翻，驱下厅前草地里，一个虞候掇一盆狗血没头一淋。”\n			', '\n暂无\n			'),
(2371, '0:3:9', '狗行狼心', '\n【 gǒu　xíng　láng　xīn 】\n			', '\n比喻行为凶狠，心肠毒辣。\n			', '\n元·白朴《恼煞人》套曲：“恨冯魁，趋恩夺爱，狗行狼心，全然不怕天折挫。”\n			', '\n为你两头白面搬兴废，转背言词说是非。这厮敢狗行狼心，～。\n			'),
(2372, '0:3:9', '狗血喷头', '\n【 gǒu　xuè　pēn　tóu 】\n			', '\n言辞刻毒，大肆辱骂。形容骂得痛快淋漓。\n			', '\n清·吴敬梓《儒林外史》第三回：“范进因没有盘费，走去同丈人商议，被胡屠夫一口啐在脸上，骂了一个狗血喷头。”\n			', '\n暂无\n			'),
(2373, '0:3:9', '狗眼看人', '\n【 gǒu　yǎn　kàn　rén 】\n			', '\n比喻眼光势力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2374, '0:3:9', '狗咬吕洞宾', '\n【 gǒu　yǎo　lǚ　dòng　bīn 】\n			', '\n吕洞宾：传说中的八仙之一。狗见了吕洞宾这样做善事的好人也咬，用来骂人不识好歹。\n			', '\n清·曹雪芹《红楼梦》第25回：“没良心的，狗咬吕洞宾，不识好人心。”\n			', '\n你这是～，把人家的好心当驴肝肺了。\n			'),
(2375, '0:3:9', '挂羊头卖狗肉', '\n【 guà　yáng　tóu　mài　gǒu　ròu 】\n			', '\n比喻以好的名义做幌子，实际上名不副实或做坏事。\n			', '\n宋·释惟白《续传灯录》第31卷：“悬羊头，卖狗肉，知它有甚凭据。”\n			', '\n我们的组织决不能叫一些～的反动分子、投机分子所欺骗。\n			'),
(2376, '0:3:9', '挂羊头，卖狗肉', '\n【 guà　yáng　tóu，mài　gǒu　ròu 】\n			', '\n比喻以好的名义做招牌，实际上兜售低劣的货色。\n			', '\n宋·释普济《五灯会元》卷十六：“悬羊头，卖狗肉，坏后进，初几灭。”\n			', '\n中国现在的顽固派，正是这样。他们口里的宪政，不过是“～”。（毛泽东《新民主主义的宪政》）\n			'),
(2377, '0:3:9', '狗彘不若', '\n【 gǒu　zhì　bù　ruò 】\n			', '\n彘：猪。连猪狗都不如。形容品行卑劣到连猪狗都不如的程度。\n			', '\n《荀子·荣辱》：“人也，忧忘其身，内忘其亲，上忘其君，则是人也，而曾狗彘之不若也。”\n			', '\n你这～的万恶败类。（郭沫若《南冠草》第五幕）\n			'),
(2378, '0:3:9', '狗彘不如', '\n【 gǒu　zhì　bù　rú 】\n			', '\n彘：猪。形容品行卑劣到连猪狗都不如的程度。同“狗彘不若”。\n			', '\n清·吴璿《飞龙全传》第四十八回：“君有难，臣当不顾其身而救之，岂言退耶！直狗彘不如也！”\n			', '\n你这～的万恶败类，你在千秋的青史上是要永远受着万代的唾骂的呵！\n			'),
(2379, '0:3:9', '狗彘不食', '\n【 gǒu　zhì　bù　shí 】\n			', '\n连狗猪都不吃他的肉。形容其人的品行极端恶劣。\n			', '\n东汉·班固《汉书·元后传》：“受人孤寄，乘便利时，夺取其国，不复顾恩义。人如此者，狗猪不食其余。”\n			', '\n汪精卫、陈璧君则作了～、遗臭万年的无耻汉奸。\n			'),
(2380, '0:3:9', '狗猪不食其余', '\n【 gǒu　zhū　bù　shí　qí　yú 】\n			', '\n食：吃。狗猪都不吃他剩下的东西。形容人的品行极其卑鄙龌龊。\n			', '\n东汉·班固《汉书·元后传》：“受人孤寄，乘便利时，夺取其国，不复顾恩义。人如此者，狗猪不食其余。”\n			', '\n暂无\n			'),
(2381, '0:3:9', '狗彘不食其余', '\n【 gǒu　zhì　bù　shí　qí　yú 】\n			', '\n狗猪都不吃他剩下的东西。形容人极其卑鄙龌龊。\n			', '\n《汉书·元后传》：“既无以报，受人孤寄，乘便利时，夺取其国，不复顾恩义，人如此者，狗猪不食其余，天下岂有而兄弟邪！”\n			', '\n士大夫为官爵所钓，用心至是，可谓～。（宋·王明清《玉照新志》第五卷）\n			'),
(2382, '0:3:9', '狗仗官势', '\n【 gǒu　zhàng　guān　shì 】\n			', '\n比喻坏人倚仗官府势力欺压他人。\n			', '\n茅盾《子夜》七：“哼！他妈的实力！不过狗仗官势！”\n			', '\n暂无\n			'),
(2383, '0:3:9', '狗走狐淫', '\n【 gǒu　zǒu　hú　yín 】\n			', '\n比喻卑劣淫乱。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2384, '0:3:9', '狗追耗子', '\n【 gǒu　zhuī　hào　zǐ 】\n			', '\n比喻做外行事或多管闲事。同“狗拿耗子”。\n			', '\n周立波《暴风雨》第一部九：“你狗追耗子，管啥闲事？”\n			', '\n暂无\n			'),
(2385, '0:3:9', '狗嘴里吐不出象牙', '\n【 gǒu　zuǐ　lǐ　tǔ　bù　chū　xiàng　yá 】\n			', '\n比喻坏人嘴里说不出好话来。\n			', '\n<span class="C999">暂无</span>\n			', '\n父亲和这等东西有什么好话，讲出什么公理来，～。（《元曲选·遇上皇》第一折）\n			'),
(2386, '0:3:9', '狗仗人势', '\n【 gǒu　zhàng　rén　shì 】\n			', '\n仗：倚仗、仗势。比喻坏人依靠某种势力欺侮人。\n			', '\n明·李开元《宝剑记》第五出：“（丑白）他怕怎的？（净白）他怕我狗仗人势。”\n			', '\n你就～，天天作耗，在我们跟前逞脸。（清·曹雪芹《红楼梦》第七十四回）\n			'),
(2387, '0:3:9', '画虎不成反类狗', '\n【 huà　hǔ　bù　chéng　fǎn　lèi　gǒu 】\n			', '\n类：象。画老虎不成，却象狗。比喻模仿不到家，反而不伦不类。\n			', '\n《后汉书·马援传》：“效季良不得，陷为天下轻薄子，所谓画虎不成反类狗也。”\n			', '\n教便也容易，只是你等无力量，使不得我们的兵器，恐学之不精，如“～”也。\n			'),
(2388, '0:3:9', '画虎成狗', '\n【 huà　hǔ　chéng　gǒu 】\n			', '\n画老虎不成，却成了狗。比喻模仿不到家，反而不伦不类。\n			', '\n《后汉书·马援传》：“效季良不得，陷为天下轻薄子，所谓画虎不成反类狗也。”\n			', '\n身已许君，复何吝惜，但恐～，致贻污谤。（清·蒲松龄《聊斋志异·胭脂》）\n			'),
(2389, '0:3:9', '画虎类狗', '\n【 huà　hǔ　lèi　gǒu 】\n			', '\n类：象。画老虎不成，却象狗。比喻模仿不到家，反而不伦不类。\n			', '\n《后汉书·马援传》：“效季良不得，陷为天下轻薄子，所谓画虎不成反类狗也。”\n			', '\n抄袭别人的东西，容易文不对题，会闹出～的笑话。\n			'),
(2390, '0:3:9', '画龙不成反为狗', '\n【 huà　lóng　bù　chéng　fǎn　wéi　gǒu 】\n			', '\n比喻模仿不到家，反而不伦不类。同“画虎不成反类狗”。\n			', '\n《后汉书·儒林传上·孔僖》：“[僖与崔駰]同游太学，习《春秋》。因读吴王夫差时事，僖废书叹曰：‘若是，所谓画龙不成反为狗者。’”\n			', '\n暂无\n			'),
(2391, '0:3:9', '狐鸣狗盗', '\n【 hú　míng　gǒu　dào 】\n			', '\n指作恶偷盗之徒。旧时统治者对造反者的贬称。\n			', '\n《旧唐书·郑畋传》：“畋谬领藩垣，荣兼将相，每枕戈而待旦，常泣血以忘餐，誓与义士忠臣，共剪狐鸣狗盗。”\n			', '\n暂无\n			'),
(2392, '0:3:9', '狐朋狗党', '\n【 hú　péng　gǒu　dǎng 】\n			', '\n泛指一些吃喝玩乐、不务正业的朋友。\n			', '\n元·关汉卿《单刀会》第三折：“他那里暗暗的藏，我须索紧紧的防，都是些狐朋狗党。”\n			', '\n暂无\n			'),
(2393, '0:3:9', '狐朋狗友', '\n【 hú　péng　gǒu　yǒu 】\n			', '\n泛指一些吃喝玩乐、不务正业的朋友。\n			', '\n<span class="C999">暂无</span>\n			', '\n恼的是那～，搬弄是非，调三窝四；气的是为他兄弟不学好，不上心念书。（清·曹雪芹《红楼梦》第十回）\n			'),
(2394, '0:3:9', '狐群狗党', '\n【 hú　qún　gǒu　dǎng 】\n			', '\n比喻勾结在一起的坏人。\n			', '\n元·无名氏《气英布》第四折：“咱若不是扶刘锄项，逐着那狐群狗党，兀良怎显得咱这黥面当王！”\n			', '\n在哥哥这几年在外头相与的都是些什么人！连一个正经的都没有，来一起子，都是些～。（清·曹雪芹《红楼梦》第九十回）\n			'),
(2395, '0:3:9', '获兔烹狗', '\n【 huò　tù　pēng　gǒu 】\n			', '\n比喻事成之后排斥以至杀害有功之臣。亦作“狡兔死，良狗烹”。\n			', '\n梁启超《论中国之将强》：“南洋一带，敬微华人，必不有今日。今虽获兔烹狗，得鱼忘筌……然筚路蓝缕之功，在公论者，终不没于天下。\n			', '\n暂无\n			'),
(2396, '0:3:9', '淮王鸡狗', '\n【 huái　wáng　jī　gǒu 】\n			', '\n比喻攀附别人而得势的人。\n			', '\n晋·葛洪《神仙传·刘安》：“时人传八公、安临去时，余药器置在中庭。鸡犬舐啄之，尽得升天。”\n			', '\n神仙侣～，衣冠队楚国猕猴。\n			'),
(2397, '0:3:9', '鸡肠狗肚', '\n【 jī　cháng　gǒu　dù 】\n			', '\n比喻狭窄的度量，狠毒的心肠。\n			', '\n《天雨花》第二回：“据你这淫妇的鸡肠狗肚，容不得人，把儿媳都逼了出门。”\n			', '\n暂无\n			'),
(2398, '0:3:9', '鸡飞狗叫', '\n【 jī　fēi　gǒu　jiào 】\n			', '\n把鸡吓得飞起来，把狗吓得直叫唤。形容乱成一团。\n			', '\n吴运铎《把一切献给党·反“扫荡”》：“忽然，邻庄鸡飞狗叫，老乡们拖着孩子向庄外奔跑。”\n			', '\n暂无\n			'),
(2399, '0:3:9', '鸡飞狗跳', '\n【 jī　fēi　gǒu　tiào 】\n			', '\n把鸡吓得飞起来，把狗吓得到处乱跳。形容惊慌得乱成一团。\n			', '\n茅盾《锻炼》：“然而陈克明却在这里想象，一方面疑神疑鬼，又一方面畏惧怨恨所造成的鸡飞狗跳、人人自危的情形。”\n			', '\n暂无\n			'),
(2400, '0:3:9', '鸡飞狗走', '\n【 jī　fēi　gǒu　zǒu 】\n			', '\n走：跑。鸡乱飞，狗乱跑。形容因极端惊恐而混乱不堪。\n			', '\n清·吴趼人《痛史》第十三回：“你看前两天那种搜索的样子，只就我们歇宿的那一家客寓，已经是闹得鸡飞狗走，鬼哭神号。”\n			', '\n暂无\n			'),
(2401, '0:3:9', '嫁狗随狗', '\n【 jià　gǒu　suí　gǒu 】\n			', '\n比喻女子只能顺从丈夫。\n			', '\n宋·陈造《题六幺后》：“兰摧蕙枯昆玉碎，不如人家嫁狗随狗鸡随鸡。”\n			', '\n暂无\n			'),
(2402, '0:3:9', '嫁狗逐狗', '\n【 jià　gǒu　zhú　gǒu 】\n			', '\n比喻女子只能顺从丈夫。同“嫁狗随狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2403, '0:3:9', '嫁鸡随鸡，嫁狗随狗', '\n【 jià　jī　suí　jī，jià　gǒu　suí　gǒu 】\n			', '\n封建礼教认为，女子出嫁后，不论丈夫好坏，都要永远跟从。\n			', '\n宋·赵汝鐩《古别离》诗：“嫁狗逐狗鸡逐鸡，耿耿不寐展转思。”\n			', '\n你难道没听见人说，“～”，那里个个都象你大姐做娘娘呢？（清·曹雪芹《红楼梦》第八十一回）\n			'),
(2404, '0:3:9', '鸡零狗碎', '\n【 jī　líng　gǒu　suì 】\n			', '\n形容事物零碎细小。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2405, '0:3:9', '鸡鸣狗盗', '\n【 jī　míng　gǒu　dào 】\n			', '\n鸣：叫；盗：偷东西。指微不足道的本领。也指偷偷摸摸的行为。\n			', '\n《史记·孟尝君列传》载：齐孟尝君出使秦被昭王扣留，孟一食客装狗钻入秦营偷出狐白裘献给昭王妾以说情放孟。孟逃至函谷关时昭王又令追捕。另一食客装鸡叫引众鸡齐鸣骗开城门，孟得以逃回齐。\n			', '\n报仇的这桩事，是桩光明磊落，见得天地鬼神的事，何须这等～，遮遮掩掩。（《儿女英雄传》第二七回）\n			'),
(2406, '0:3:9', '鸡鸣狗吠', '\n【 jī　míng　gǒu　fèi 】\n			', '\n鸡啼狗叫彼此都听得到。比喻聚居在一处的人口稠密。\n			', '\n《孟子·公孙丑上》：“鸡鸣狗吠相闻而达乎四境。”\n			', '\n暂无\n			'),
(2407, '0:3:9', '狡兔死，良狗烹', '\n【 jiǎo　tù　sǐ，liáng　gǒu　pēng 】\n			', '\n烹：烧煮。兔子死了，猎狗就被人烹食。比喻给统治者效劳的人事成后被抛弃或杀掉。\n			', '\n《韩非子·内储说左下》：“狡兔尽则良犬烹，敌国灭则谋臣亡。”《史记·越王勾践世家》：“飞鸟尽，良弓藏；狡兔死，走狗烹。”\n			', '\n暂无\n			'),
(2408, '0:3:9', '狼嗥狗叫', '\n【 láng　háo　gǒu　jiào 】\n			', '\n形容恶人狂呼乱叫。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2409, '0:3:9', '驴鸣狗吠', '\n【 lǘ　míng　gǒu　fèi 】\n			', '\n形容文字言语拙劣。同“驴鸣犬吠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2410, '0:3:9', '傫如丧狗', '\n【 lěi　rú　sàng　gǒu 】\n			', '\n形容人失意而精神颓丧。傫，古同“累”。\n			', '\n语本《史记·孔子世家》：“孔子适郑，与弟子相失，孔子独立郭东门……累累若丧家之狗。”裴骃集解引王肃曰：“丧家之狗，主人哀荒，不见饮食，故累然而不得意。孔子生于乱世，道不得行，故累累然不得志之貌也。”\n			', '\n暂无\n			'),
(2411, '0:3:9', '狼心狗肺', '\n【 láng　xīn　gǒu　fèi 】\n			', '\n形容心肠象狼和狗一样凶恶狠毒。\n			', '\n明·冯梦龙《醒世恒言》卷三十：“那知这贼子恁般狼心狗肺，负恩忘义。”\n			', '\n暂无\n			'),
(2412, '0:3:9', '驴心狗肺', '\n【 lǘ　xīn　gǒu　fèi 】\n			', '\n比喻人心凶狠恶毒。\n			', '\n明·凌濛初《二刻拍案惊奇》：“何故苦苦贪私，思量独吃自疴……不知驴心狗肺怎么生的。”\n			', '\n暂无\n			'),
(2413, '0:3:9', '狼心狗行', '\n【 láng　xīn　gǒu　xíng 】\n			', '\n心肠似狼，行为如狗。比喻贪婪凶狠，卑鄙无耻。\n			', '\n明·罗贯中《三国演义》第七回：“昔日以汝为忠义，推为盟主；今之所为，真狼心狗行之徒，有何面目立于世间！”\n			', '\n暂无\n			'),
(2414, '0:3:9', '卖狗悬羊', '\n【 mài　gǒu　xuán　yáng 】\n			', '\n犹言挂羊头卖狗肉。意指名不副实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2415, '0:3:9', '牛黄狗宝', '\n【 niú　huáng　gǒu　bǎo 】\n			', '\n牛黄，牛胆囊中的结石；狗宝，狗脏器中的凝结物。两者都是内脏病变的产物，因以喻坏透了的心肠。\n			', '\n清·曹雪芹《红楼梦》第六十五回：“若大家好取和便罢，倘若有一点叫人过不去， 我有本事先把你两个的牛黄狗宝掏了出来，再和那泼妇拼了这命，也不算是尤三姑奶奶！”\n			', '\n暂无\n			'),
(2416, '0:3:9', '泥猪疥狗', '\n【 ní　zhū　jiè　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2417, '0:3:9', '泥猪癞狗', '\n【 ní　zhū　lài　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。同“泥猪疥狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2418, '0:3:9', '泥猪瓦狗', '\n【 ní　zhū　wǎ　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。同“泥猪疥狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2419, '0:3:9', '烹狗藏弓', '\n【 pēng　gǒu　cáng　gōng 】\n			', '\n比喻事成之后把效劳出力的人抛弃以至杀害。\n			', '\n语出《史记·越王勾践世家》：“范蠡遂去，自齐遗大夫种（文种）书曰：‘蜚鸟尽，良弓藏，狡兔死，走狗烹。’”\n			', '\n～事可哀，看他海蜃结楼台。\n			'),
(2420, '0:3:9', '人面狗心', '\n【 rén　miàn　gǒu　xīn 】\n			', '\n①比喻容貌美好而才学低下的人。②犹言人面兽心。\n			', '\n《晋书·苻朗载记》：“朗曰：‘吏部为谁，非人面而狗心，狗面而人心兄弟者乎？’王忱丑而才慧，国宝美貌而才劣于弟，故朗云然。”\n			', '\n暂无\n			'),
(2421, '0:3:9', '人模狗样', '\n【 rén　mú　gǒu　yàng 】\n			', '\n身分是人，举止形容却像狗。多用于嘲讽。\n			', '\n老舍《骆驼祥子》十四：“祥子在棚里坐着呢，人模狗样的，脸上的疤被灯光照得像块玉石。”又《四世同堂》四九：“他也想象到怎样顺手儿教训教训那些人模狗样的科长科员们。”\n			', '\n暂无\n			'),
(2422, '0:3:9', '鼠窜狗盗', '\n【 shǔ　cuàn　gǒu　dào 】\n			', '\n像鼠狗那样奔窜偷盗。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2423, '0:3:9', '鼠盗狗窃', '\n【 shǔ　dào　gǒu　qiè 】\n			', '\n像鼠狗那样奔窜偷盗。同“鼠窃狗盗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2424, '0:3:9', '丧家之狗', '\n【 sàng　jiā　zhī　gǒu 】\n			', '\n比喻失去依靠、无处投奔或惊慌失措的人。\n			', '\n《史记·孔子世家》：“东门有人，其颡似尧，其项类皋陶，其肩类子产，然自要以下不及禹三寸，累累若丧家之狗。”元·郑廷玉《后庭花》第二折：“他两个忙忙如丧家之狗，急急似漏网之鱼。”\n			', '\n操亲掣宝剑押阵，率众连夜追杀，剿戮极多，降者不计其数。傕、汜望西逃命，忙忙似～。\n			'),
(2425, '0:3:9', '鼠窃狗盗', '\n【 shǔ　qiè　gǒu　dào 】\n			', '\n象老鼠少量窃取，象狗钻油偷盗。指小偷小摸。\n			', '\n《史记·刘敬书孙通列传》：“此特群盗鼠窃狗盗尔，何足置之齿牙间。”\n			', '\n暂无\n			'),
(2426, '0:3:9', '鼠窃狗偷', '\n【 shǔ　qiè　gǒu　tōu 】\n			', '\n象老鼠少量窃取，象狗钻油偷盗。指小偷小摸。\n			', '\n《史记·刘敬书孙通列传》：“此特群盗鼠窃狗盗尔，何足置之齿牙间。”\n			', '\n～之徒，何足虑哉。（明·施耐庵《水浒全传》第七十五回）\n			'),
(2427, '0:3:9', '声色狗马', '\n【 shēng　sè　gǒu　mǎ 】\n			', '\n声：歌舞；色：女色；狗：养狗；马：骑马。形容剥削阶级荒淫无耻的生活。\n			', '\n清·蒲松龄《聊斋志异·续黄梁》：“声色狗马，昼夜荒淫，国计民生，罔存念虑。”\n			', '\n于是童贯朱勔辈复导以～宫室苑囿之乐。（鲁迅《唐宋传奇集·李师师外传》）\n			'),
(2428, '0:3:9', '鼠偷狗盗', '\n【 shǔ　tōu　gǒu　dào 】\n			', '\n像鼠狗那样奔窜偷盗。同“鼠窃狗盗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2429, '0:3:9', '偷狗戏鸡', '\n【 tōu　gǒu　xì　jī 】\n			', '\n比喻不务正业。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2430, '0:3:9', '偷鸡盗狗', '\n【 tōu　jī　dào　gǒu 】\n			', '\n指偷窃的行为。也指不正经的勾当。同“偷鸡摸狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2431, '0:3:9', '偷鸡摸狗', '\n【 tōu　jī　mō　gǒu 】\n			', '\n指偷窃的行为。也指不正经的勾当。\n			', '\n明·施耐庵《水浒全传》第四十六回：“小人如今在此，只做得些偷鸡盗狗的勾当，几时是了；跟随的二位哥哥上山去，却不好？”\n			', '\n成日家～，腥的臭的，都拉了你屋里去！（清·曹雪芹《红楼梦》第四十四回）\n			'),
(2432, '0:3:9', '土鸡瓦狗', '\n【 tǔ　jī　wǎ　gǒu 】\n			', '\n比喻徒有虚名而无实用的东西。同“土鸡瓦犬”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2433, '0:3:9', '土龙刍狗', '\n【 tǔ　lóng　chú　gǒu 】\n			', '\n泥土捏的龙，稻草扎的狗。比喻名不副实。\n			', '\n《三国志·蜀书·杜微传》：“曹丕篡弑，自立为帝，是犹土龙刍狗之有名也。”\n			', '\n暂无\n			'),
(2434, '0:3:9', '兔死狗烹', '\n【 tù　sǐ　gǒu　pēng 】\n			', '\n烹：烧煮。兔子死了，猎狗就被人烹食。比喻给统治者效劳的人事成后被抛弃或杀掉。\n			', '\n《史记·越王勾践世家》：“飞鸟尽，良弓藏；狡兔死，走狗烹。”\n			', '\n大凡古来有识见的英雄功成名就，便拂袖而去，免使后来有“鸟尽弓藏，～”之祸。（清·陈忱《水浒后传》第九回）\n			'),
(2435, '0:3:9', '行若狗彘', '\n【 xíng　ruò　gǒu　zhì 】\n			', '\n指人无耻，行为像猪狗一样。\n			', '\n西汉·贾谊《论治安策》：“故此一豫让也，反君事仇，行若狗彘。”\n			', '\n阳为道学，阴为富贵，被服儒雅，～然也。\n			'),
(2436, '0:3:9', '行同狗豨', '\n【 xíng　tóng　gǒu　xī 】\n			', '\n豨：猪。人的行为丑恶，如同猪狗一样。形容人的行为卑鄙恶劣到了极点。亦作“行如禽兽”、“行若狗彘”、“行同犬彘”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2437, '0:3:9', '行同狗彘', '\n【 xíng　tóng　gǒu　zhì 】\n			', '\n旧时指人无耻，行为和猪狗一样。\n			', '\n汉·贾谊《治安策》：“故此一豫让也，反君事仇，行若狗彘，已而抗节致忠，行出乎列士，人主使然也。”\n			', '\n暂无\n			'),
(2438, '0:3:9', '引狗入寨', '\n【 yǐn　gǒu　rù　zhai 】\n			', '\n犹言引狼入室。比喻把坏人或敌人引入内部。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2439, '0:3:9', '咬人狗儿不露齿', '\n【 yǎo　rén　gǒu　ér　bù　lòu　chǐ 】\n			', '\n比喻真正厉害的人在外表是不显露出来的。\n			', '\n元·张国宾《罗李郎》第三折：“那厮正是咬人狗儿不露齿。”\n			', '\n暂无\n			'),
(2440, '0:3:9', '蝇营狗苟', '\n【 yíng　yíng　gǒu　gǒu 】\n			', '\n比喻为了追逐名利，不择手段，象苍蝇一样飞来飞去，象狗一样的不识羞耻。\n			', '\n唐·韩愈《送穷文》：“蝇营狗苟，驱去复返。”\n			', '\n暂无\n			'),
(2441, '0:3:9', '猪卑狗险', '\n【 zhū　bēi　gǒu　liǎn 】\n			', '\n比喻卑鄙阴险的人。\n			', '\n《南齐书·卡彬传》：“彬又目禽兽云：‘羊性淫而狠，猪性卑而率，鹅性顽而傲，狗性险而出，皆指斥贵势。’”\n			', '\n暂无\n			'),
(2442, '0:3:9', '跖狗吠尧', '\n【 zhí　gǒu　fèi　yáo 】\n			', '\n比喻各为其主。\n			', '\n西汉·刘向《战国策·齐策》：“跖之狗吠尧，非贵跖而贱尧也，狗固吠非其主也。”\n			', '\n且～，吠非其主。\n			'),
(2443, '0:3:9', '蹠狗吠尧', '\n【 zhí　gǒu　fèi　yáo 】\n			', '\n意指各为其主。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2444, '0:3:9', '指鸡骂狗', '\n【 zhǐ　jī　mà　gǒu 】\n			', '\n指着鸡骂狗。比喻表面上骂这个人，实际上是骂那个人。\n			', '\n<span class="C999">暂无</span>\n			', '\n你有话直说好了，用不着～。\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2445, '0:3:9', '捉鸡骂狗', '\n【 zhuō　jī　mà　gǒu 】\n			', '\n犹指桑骂槐。比喻表面上骂这个人，实际上是骂那个人。\n			', '\n明·冯梦龙《醒世恒言》第九卷：“次日，张氏晓得了，反怪媳妇做格，不去勾搭儿子干事，把一团美意，看做不良之心，捉鸡骂狗，言三语四，影射的发作了一场。”\n			', '\n暂无\n			'),
(2446, '0:3:9', '猪朋狗友', '\n【 zhū　péng　gǒu　yǒu 】\n			', '\n比喻好吃懒做、不务正业的坏朋友。\n			', '\n欧阳山《苦斗》四十四：“担心的是咱爷儿俩辛辛苦苦积攒下来的一份家业，将来不够他跟那些猪朋狗友天天去吃醋溜纹银子！”\n			', '\n暂无\n			'),
(2447, '0:3:9', '贼头狗脑', '\n【 zéi　tóu　gǒu　nǎo 】\n			', '\n偷偷摸摸、鬼鬼祟祟的样子。同“贼头鼠脑”。\n			', '\n《再生缘》第一回：“今天楼上家中老少和一班女眷都在看，刘奎璧对着楼上贼头狗脑，以致第三箭失手。”\n			', '\n刘仁兄，我看那押解的官儿～，不是个好人，我们要提防一二。\n			'),
(2448, '0:3:9', '指猪骂狗', '\n【 zhǐ　zhū　mà　gǒu 】\n			', '\n犹指桑骂槐。亦作“指鸡骂狗”。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第十一回：“百般指猪骂狗，欺侮俺娘儿们。”\n			', '\n暂无\n			'),
(2449, '0:3:10', '狗猪不食其余', '\n【 gǒu　zhū　bù　shí　qí　yú 】\n			', '\n食：吃。狗猪都不吃他剩下的东西。形容人的品行极其卑鄙龌龊。\n			', '\n东汉·班固《汉书·元后传》：“受人孤寄，乘便利时，夺取其国，不复顾恩义。人如此者，狗猪不食其余。”\n			', '\n暂无\n			'),
(2450, '0:3:10', '牧猪奴戏', '\n【 mù　zhòu　nú　xì 】\n			', '\n对赌博的鄙称。\n			', '\n《晋书·陶侃传》：“樗蒲者，牧猪奴戏耳！”\n			', '\n暂无\n			'),
(2451, '0:3:10', '泥猪疥狗', '\n【 ní　zhū　jiè　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2452, '0:3:10', '泥猪癞狗', '\n【 ní　zhū　lài　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。同“泥猪疥狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2453, '0:3:10', '泥猪瓦狗', '\n【 ní　zhū　wǎ　gǒu 】\n			', '\n比喻卑贱或粗鄙的人。同“泥猪疥狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2454, '0:3:10', '人怕出名猪怕壮', '\n【 rén　pà　chū　míng　zhū　pà　zhuàng 】\n			', '\n人怕出了名招致麻烦，就象猪长肥了就要被宰杀一样。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2455, '0:3:10', '一龙一猪', '\n【 yī　lóng　yī　zhū 】\n			', '\n一是龙，一是猪。比喻同时的两个人，高下判别极大。\n			', '\n唐·韩愈《符读书城南》诗：“两家各生子，提孩巧相如。少长聚嬉戏，不殊同队鱼。三十骨骼成，乃一龙一猪。”\n			', '\n暂无\n			'),
(2456, '0:3:10', '猪卑狗险', '\n【 zhū　bēi　gǒu　liǎn 】\n			', '\n比喻卑鄙阴险的人。\n			', '\n《南齐书·卡彬传》：“彬又目禽兽云：‘羊性淫而狠，猪性卑而率，鹅性顽而傲，狗性险而出，皆指斥贵势。’”\n			', '\n暂无\n			'),
(2457, '0:3:10', '猪朋狗友', '\n【 zhū　péng　gǒu　yǒu 】\n			', '\n比喻好吃懒做、不务正业的坏朋友。\n			', '\n欧阳山《苦斗》四十四：“担心的是咱爷儿俩辛辛苦苦积攒下来的一份家业，将来不够他跟那些猪朋狗友天天去吃醋溜纹银子！”\n			', '\n暂无\n			'),
(2458, '0:3:10', '猪突豨勇', '\n【 zhū　tū　xī　yǒng 】\n			', '\n豨：野猪。指拼命向前冲，不怕死的人（含贬义）。\n			', '\n《汉书·食货志下》：“匈奴侵寇甚，莽大寡天下囚徒人奴，名曰猪突豨勇。”\n			', '\n暂无\n			'),
(2459, '0:3:10', '指猪骂狗', '\n【 zhǐ　zhū　mà　gǒu 】\n			', '\n犹指桑骂槐。亦作“指鸡骂狗”。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第十一回：“百般指猪骂狗，欺侮俺娘儿们。”\n			', '\n暂无\n			'),
(2460, '0:3:11', '独鹤鸡群', '\n【 dú　hè　jī　qún 】\n			', '\n一只鹤站在鸡群中。比喻一个人的才能或仪表超群出众。\n			', '\n晋·戴逵《竹林七贤论》：“嵇绍入洛，或谓王戎曰：‘昨于稠人中始见嵇绍，昂昂然若野鹤之在鸡群。’”南朝梁·刘义庆《世说新语·容止》：“嵇延祖卓卓如野鹤之在鸡群。”\n			', '\n～自寡俦，三间老屋日西头。（清·钱谦益《客途有怀吴中故人周吏部景文》）\n			'),
(2461, '0:3:11', '打鸡骂狗', '\n【 dǎ　jī　mà　gǒu 】\n			', '\n比喻旁敲侧击地漫骂，以发泄对某人的不满。\n			', '\n鲁迅《彷徨·肥皂》：“你今天怎么尽闹脾气，连吃饭时候也是打鸡骂狗的。”\n			', '\n暂无\n			'),
(2462, '0:3:11', '戴鸡佩豚', '\n【 dài　jī　pèi　tún 】\n			', '\n戴雄鸡形的帽子，佩野猪形的饰物。雄鸡野猪皆好斗，古时以冠带像其形，表示好勇。\n			', '\n《史记·仲弟子列传》：“子路性鄙，好勇力，志伉直，冠雄鸡，佩豭豚。”\n			', '\n世称子路无恒之庸人，未入孔门时，～，勇猛无礼，闻育读之声，摇鸡奋豚，扬唇吻之音，聒贤圣之耳。\n			'),
(2463, '0:3:11', '斗鸡养狗', '\n【 dòu　jī　yǎng　gǒu 】\n			', '\n指旧时剥削阶级子弟游手好闲的无聊游戏。同“斗鸡走狗”。\n			', '\n《金瓶梅词话》第九八回：“他兄弟在家开赌场，斗鸡养狗，人不敢惹他。”\n			', '\n暂无\n			'),
(2464, '0:3:11', '斗鸡走狗', '\n【 dòu　jī　zǒu　gǒu 】\n			', '\n使公鸡相斗，使狗赛跑。指旧时剥削阶级子弟游手好闲的无聊游戏。\n			', '\n《史记·袁盎晁错列传》：“盎病免居家，与阊里淝枕，相随行斗鸡走狗。”\n			', '\n虽然应名来上学，亦不过虚掩眼目而已，仍是～，赏花阅柳为事。（清·曹雪芹《红楼梦》第九回）\n			'),
(2465, '0:3:11', '斗酒只鸡', '\n【 dǒu　jiǔ　zhī　jī 】\n			', '\n斗：酒器。古人祭亡友，携鸡酒到墓前行礼。后作为追悼亡友的话。\n			', '\n汉·曹操《祀故太尉桥玄文》：“殂逝之后，路有经由，不以斗酒只鸡过相沃酹，车过三步，腹痛勿怪。”\n			', '\n既然肯来赴约呵，您兄弟～，等待我的哥哥也。（元·宫大用《范张鸡黍》楔子）\n			'),
(2466, '0:3:11', '斗鸡走马', '\n【 dòu　jī　zǒu　mǎ 】\n			', '\n斗鸡赛马。古代的赌博游戏。\n			', '\n《汉书·宣帝纪》：“[宣帝]受《诗》于东海澓中翁，高材好学，然亦喜游侠，斗鸡走马。”\n			', '\n鸣鸾佩玉青云间，～红尘里。\n			'),
(2467, '0:3:11', '斗鸡走犬', '\n【 dòu　jī　zǒu　quǎn 】\n			', '\n指旧时剥削阶级子弟游手好闲的无聊游戏。同“斗鸡走狗”。\n			', '\n《战国策·齐策一》：“临淄甚富而实，其民无不吹竽鼓瑟、击筑弹琴、斗鸡走犬、六博蹋踘者。”\n			', '\n暂无\n			'),
(2468, '0:3:11', '呆若木鸡', '\n【 dāi　ruò　mù　jī 】\n			', '\n呆：傻，发愣的样子。呆得象木头鸡一样。形容因恐惧或惊异而发愣的样子。\n			', '\n《庄子·达生》：“几矣。鸡虽有鸣者，已无变矣，望之似木鸡矣，其德全矣；异鸡无敢应者，反走矣。”\n			', '\n匪首侯殿坤，在得知这个噩耗之后，特别是知道了老妖道的落网后，当即～。（曲波《林海雪原》二八）\n			'),
(2469, '0:3:11', '呆如木鸡', '\n【 dāi　rú　mù　jī 】\n			', '\n呆得象木头鸡一样。形容因恐惧或惊异而发愣的样子。\n			', '\n《庄子·达生》：“几矣。鸡虽有鸣者，已无变矣，望之似木鸡矣，其德全矣；异鸡无敢应者，反走矣。”\n			', '\n那几个军人和财主，一个个～。\n			'),
(2470, '0:3:11', '呆似木鸡', '\n【 dāi　sì　mù　jī 】\n			', '\n呆得象木头鸡一样。形容因恐惧或惊异而发愣的样子。\n			', '\n《庄子·达生》：“几矣。鸡虽有鸣者，已无变矣，望之似木鸡矣，其德全矣；异鸡无敢应者，反走矣。”\n			', '\n暂无\n			'),
(2471, '0:3:11', '缚鸡之力', '\n【 fù　jī　zhī　lì 】\n			', '\n捆鸡的力量。比喻体弱无力。\n			', '\n元·《赚蒯通》第一折：“那韩信手无缚鸡之力。”\n			', '\n平日只会读书写字，刺绣描花，手无～。（明·天然痴叟《石点头·侯官县烈女歼仇》）\n			'),
(2472, '0:3:11', '凤毛鸡胆', '\n【 fèng　máo　jī　dǎn 】\n			', '\n凤的羽毛，鸡的胆子。比喻外表英武而实际怯弱。\n			', '\n明·罗贯中《三国演义》第三十二回：“羊质虎皮功不就，凤毛鸡胆事难成。”\n			', '\n暂无\n			'),
(2473, '0:3:11', '范张鸡黍', '\n【 fàn　zhāng　jī　shǔ 】\n			', '\n范：范式；张：张劭；鸡：禽类；黍：草本植物，指黍子。范式、张劭一起喝酒食鸡。比喻朋友之间含义与深情。\n			', '\n《后汉书·范式传》载：“范式字巨卿……与汝南张劭为友。劭字元伯。二人并告归乡里。……乃共克期日。后期方至，元伯具以白母，请设馔以候之。”\n			', '\n暂无\n			'),
(2474, '0:3:11', '狗盗鸡鸣', '\n【 gǒu　dào　jī　míng 】\n			', '\n①比喻具有微末技能。②比喻偷偷摸摸。\n			', '\n金·元好问《示怀祖》诗：“狗盗鸡鸣皆有用，鹤长凫短果如何？”\n			', '\n报仇的这桩事，是桩光明磊落、见得天地鬼神的事，何须这等～、遮遮掩掩。\n			'),
(2475, '0:3:11', '狗盗鸡啼', '\n【 gǒu　dào　jī　tí 】\n			', '\n比喻具有微末技能。同“狗盗鸡鸣”。\n			', '\n明·陆采《明珠记·江会》：“函关脱离，又何须狗盗鸡啼？”\n			', '\n暂无\n			'),
(2476, '0:3:11', '割鸡焉用牛刀', '\n【 gē　jī　yān　yòng　niú　dāo 】\n			', '\n杀只鸡何必用宰牛的刀。比喻办小事情用不着花大气力。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n“～”？不劳温侯亲往，吾斩众诸侯首级，如探囊取物耳。（明·罗贯中《三国演义》第五回）\n			'),
(2477, '0:3:11', '鹤处鸡群', '\n【 hè　chǔ　jī　qún 】\n			', '\n比喻一个人的仪表或才能在周围一群人里显得很突出。同“鹤立鸡群”。\n			', '\n《敦煌变文集·维摩诘经讲经文》：“遥望而清风宛在，鹤处鸡群；近观而光彩射人，龙来洞口。”\n			', '\n鲲为鱼队潜鳞困，～病翅低。\n			'),
(2478, '0:3:11', '鹤发鸡皮', '\n【 hè　fà　jī　pí 】\n			', '\n鹤发：白发；鸡皮：形容皮肤有皱纹。皮肤发皱，头发苍白。形容老人年迈的相貌。\n			', '\n北周·庾信《竹杖赋》：“子老矣，鹤发鸡皮，蓬头历齿。”唐玄宗《傀儡吟》：“刻木牵丝作老翁，鸡皮鹤发与真同。”\n			', '\n暂无\n			'),
(2479, '0:3:11', '鹤骨鸡肤', '\n【 hè　gǔ　jī　fū 】\n			', '\n伶仃瘦骨，多皱的皮肤。形容年老。\n			', '\n宋·王炎《病中书怀》诗：“鹤骨鸡肤不耐寒，那堪癣疥更斑烂。”\n			', '\n你看这位～，腰弯背驼，其貎不扬吧，那唱的可是正经的‘杨派’。\n			'),
(2480, '0:3:11', '鹤困鸡群', '\n【 hè　kùn　jī　qún 】\n			', '\n比喻才能出众的人沦落于平庸之辈当中。\n			', '\n清·李渔《闲情偶寄·演习·教白》：“苟得其人，必破优伶之格以待之，不则鹤困鸡群，与侪众无异。”\n			', '\n暂无\n			'),
(2481, '0:3:11', '鹤立鸡群', '\n【 hè　lì　jī　qún 】\n			', '\n象鹤站在鸡群中一样。比喻一个人的仪表或才能在周围一群人里显得很突出。\n			', '\n晋·戴逵《竹林七贤论》：“嵇绍入洛，或谓王戎曰：‘昨于稠人中始见嵇绍，昂昂然若野鹤之在鸡群。’”南朝·宋·刘义庆《世说新语·容止》：“嵇延祖卓卓如野鹤之在鸡群。”\n			', '\n正在谈论，谁知女儿国王忽见林之洋杂在众人中，如～一般。（清·李汝珍《镜花缘》第三十九回）\n			'),
(2482, '0:3:11', '淮南鸡犬', '\n【 huái　nán　jī　quǎn 】\n			', '\n比喻投靠别人而得势的人。\n			', '\n汉·王充《论衡·道虚》：“淮南王刘安坐反而死，天下并闻，当时并见，儒书尚有言其得道仙去，鸡犬升天者。”\n			', '\n暂无\n			'),
(2483, '0:3:11', '淮王鸡狗', '\n【 huái　wáng　jī　gǒu 】\n			', '\n比喻攀附别人而得势的人。\n			', '\n晋·葛洪《神仙传·刘安》：“时人传八公、安临去时，余药器置在中庭。鸡犬舐啄之，尽得升天。”\n			', '\n神仙侣～，衣冠队楚国猕猴。\n			'),
(2484, '0:3:11', '鹤行鸡群', '\n【 hè　xíng　jī　qún 】\n			', '\n比喻一个人的仪表或才能在周围一群人里显得很突出。同“鹤立鸡群”。\n			', '\n宋·苏辙《次韵子瞻感旧见寄》：“君才最高峙，鹤行鸡群中。”\n			', '\n暂无\n			'),
(2485, '0:3:11', '鸡不及凤', '\n【 jī　bù　jí　fèng 】\n			', '\n鸡赶不上凤凰。比喻儿子不如父亲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2486, '0:3:11', '鸡虫得失', '\n【 jī　chóng　dé　shī 】\n			', '\n比喻微小的得失，无关紧要。\n			', '\n唐·杜甫《缚鸡行》诗：“鸡虫得失无了时，注目寒江倚山阁。”\n			', '\n～，蜗角争持，闹得天翻地覆，日月无光。（蔡东藩、许厪父《民国通俗演义》第一百二十五回）\n			'),
(2487, '0:3:11', '鸡虫得丧', '\n【 jī　chóng　dé　sàng 】\n			', '\n比喻微小的得失，无关紧要。同“鸡虫得失”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2488, '0:3:11', '鸡肠狗肚', '\n【 jī　cháng　gǒu　dù 】\n			', '\n比喻狭窄的度量，狠毒的心肠。\n			', '\n《天雨花》第二回：“据你这淫妇的鸡肠狗肚，容不得人，把儿媳都逼了出门。”\n			', '\n暂无\n			'),
(2489, '0:3:11', '鸡蛋里找骨头', '\n【 jī　dàn　lǐ　zhǎo　gǔ　tóu 】\n			', '\n比喻故意挑剔。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2490, '0:3:11', '鸡飞蛋打', '\n【 jī　fēi　dàn　dǎ 】\n			', '\n鸡飞走了，蛋打破了。比喻两头落空，一无所得。\n			', '\n清·蒲松龄《聊斋志异·阿霞》：“人之无良，舍其旧而新是谋，卒之卵覆鸟亦飞，天之所报亦惨矣。”\n			', '\n只要他一进关抄了咱们的后路，那就～，不可收拾了。（周骥良《吉鸿昌》）\n			'),
(2491, '0:3:11', '鸡飞狗叫', '\n【 jī　fēi　gǒu　jiào 】\n			', '\n把鸡吓得飞起来，把狗吓得直叫唤。形容乱成一团。\n			', '\n吴运铎《把一切献给党·反“扫荡”》：“忽然，邻庄鸡飞狗叫，老乡们拖着孩子向庄外奔跑。”\n			', '\n暂无\n			'),
(2492, '0:3:11', '鸡飞狗跳', '\n【 jī　fēi　gǒu　tiào 】\n			', '\n把鸡吓得飞起来，把狗吓得到处乱跳。形容惊慌得乱成一团。\n			', '\n茅盾《锻炼》：“然而陈克明却在这里想象，一方面疑神疑鬼，又一方面畏惧怨恨所造成的鸡飞狗跳、人人自危的情形。”\n			', '\n暂无\n			'),
(2493, '0:3:11', '鸡飞狗走', '\n【 jī　fēi　gǒu　zǒu 】\n			', '\n走：跑。鸡乱飞，狗乱跑。形容因极端惊恐而混乱不堪。\n			', '\n清·吴趼人《痛史》第十三回：“你看前两天那种搜索的样子，只就我们歇宿的那一家客寓，已经是闹得鸡飞狗走，鬼哭神号。”\n			', '\n暂无\n			'),
(2494, '0:3:11', '鸡肤鹤发', '\n【 jī　fū　hè　fā 】\n			', '\n皮肤发皱，头发苍白。指老人。同“鸡皮鹤发”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2495, '0:3:11', '鸡骨支床', '\n【 jī　gǔ　zhī　chuáng 】\n			', '\n原意是因亲丧悲痛过度而消瘦疲惫在床席之上。后用来比喻在父母丧中能尽孝道。也形容十分消瘦。\n			', '\n南朝·宋·刘义庆《世说新语·德行》：“王戎和峤同时遭大丧，俱以孝称，王鸡骨支床，和哭泣备礼。”\n			', '\n积数日，～，较前尤甚。（清·蒲松龄《聊斋志异·寄生》）\n			'),
(2496, '0:3:11', '金鸡独立', '\n【 jīn　jī　dú　lì 】\n			', '\n指独腿站立的一种武术姿势。后也指用一足站立。\n			', '\n清·李汝珍《镜花缘》第七十四回：“我是‘金鸡独立’，要一足微长。”\n			', '\n你站在这桌子上，～，那一条腿不许放下来。（茅盾《子夜》十七）\n			'),
(2497, '0:3:11', '嫁鸡随鸡，嫁狗随狗', '\n【 jià　jī　suí　jī，jià　gǒu　suí　gǒu 】\n			', '\n封建礼教认为，女子出嫁后，不论丈夫好坏，都要永远跟从。\n			', '\n宋·赵汝鐩《古别离》诗：“嫁狗逐狗鸡逐鸡，耿耿不寐展转思。”\n			', '\n你难道没听见人说，“～”，那里个个都象你大姐做娘娘呢？（清·曹雪芹《红楼梦》第八十一回）\n			'),
(2498, '0:3:11', '金鸡消息', '\n【 jīn　jī　xiāo　xī 】\n			', '\n指皇帝下赦令招安的消息。\n			', '\n《新唐书·百官志三》：“赦日，树金鸡于仗南，竿长七丈，有鸡高四尺，黄金饰首，衔绛幡长七尺，承以彩盘，维以绛绳。”\n			', '\n六六雁行连八九，只等～。（明·施耐庵《水浒全传》第七十二回）\n			'),
(2499, '0:3:11', '家鸡野鹜', '\n【 jiā　jī　yě　wù 】\n			', '\n比喻不同的书法风格。也比喻人喜爱新奇，而厌弃平常的事物。\n			', '\n晋·何法盛《晋中兴书》卷七：“小儿辈厌家鸡，爱野雉，皆学逸少书。”\n			', '\n暂无\n			'),
(2500, '0:3:11', '家鸡野雉', '\n【 jiā　jī　yé　zhì 】\n			', '\n雉：野鸡。原意是晋庚翼把自己的书法喻为家鸡，把王羲之的书法喻为野鸡，以示贱近与贵远。亦比喻风格迥异的书法绘画等。\n			', '\n晋·何法盛《晋中兴书》第七卷：“在荆州与都下书云：‘小儿辈贱厌家鸡，爱野雉，皆进逸少书，须吾还，当比之。’”\n			', '\n暂无\n			'),
(2501, '0:3:11', '嫁鸡逐鸡', '\n【 jià　jī　zhú　jī 】\n			', '\n比喻女子出嫁后只能顺从丈夫。\n			', '\n宋·欧阳修《代鸠妇言》：“人言嫁鸡逐鸡飞，安知嫁鸠被鸠逐。”\n			', '\n虽然不好明说丈夫丑陋，只把～的常话劝诲他一番便了。\n			'),
(2502, '0:3:11', '鸡口牛后', '\n【 jī　kǒu　niú　hòu 】\n			', '\n宁愿做小而洁的鸡嘴，而不愿做大而臭的牛肛门。比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’”\n			', '\n暂无\n			'),
(2503, '0:3:11', '鸡零狗碎', '\n【 jī　líng　gǒu　suì 】\n			', '\n形容事物零碎细小。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2504, '0:3:11', '见卵求鸡', '\n【 jiàn　luǎn　qiú　jī 】\n			', '\n看到鸡蛋，就希求蛋化为鸡，而来司晨报晓。比喻言之过早。\n			', '\n《庄子·齐物论》：“女亦大早计，见卵而求时夜，见弹而求鸮炙。”\n			', '\n今徒学语其圣德，而不知圣之所以德，可谓见卵而求时夜，见弹而求鸮炙，何其造次哉。\n			'),
(2505, '0:3:11', '鸡烂嘴巴硬', '\n【 jī　làn　zuǐ　bā　yìng 】\n			', '\n比喻自知理亏，还要强辩。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2506, '0:3:11', '鸡鸣而起', '\n【 jī　míng　ér　qǐ 】\n			', '\n鸡叫时就起床。形容勤奋不怠。\n			', '\n《孟子·尽心上》：“鸡鸣而起，孳孳为善者，舜之徒也。”\n			', '\n～，孜孜焉，亦不为利。（唐·韩愈《上宰相书》）\n			'),
(2507, '0:3:11', '鸡鸣狗盗', '\n【 jī　míng　gǒu　dào 】\n			', '\n鸣：叫；盗：偷东西。指微不足道的本领。也指偷偷摸摸的行为。\n			', '\n《史记·孟尝君列传》载：齐孟尝君出使秦被昭王扣留，孟一食客装狗钻入秦营偷出狐白裘献给昭王妾以说情放孟。孟逃至函谷关时昭王又令追捕。另一食客装鸡叫引众鸡齐鸣骗开城门，孟得以逃回齐。\n			', '\n报仇的这桩事，是桩光明磊落，见得天地鬼神的事，何须这等～，遮遮掩掩。（《儿女英雄传》第二七回）\n			'),
(2508, '0:3:11', '鸡鸣狗吠', '\n【 jī　míng　gǒu　fèi 】\n			', '\n鸡啼狗叫彼此都听得到。比喻聚居在一处的人口稠密。\n			', '\n《孟子·公孙丑上》：“鸡鸣狗吠相闻而达乎四境。”\n			', '\n暂无\n			'),
(2509, '0:3:11', '鸡鸣馌耕', '\n【 jī　míng　gǒu　gēng 】\n			', '\n比喻妇女勤俭治家。\n			', '\n语出《诗·郑风·女曰鸡鸣》：“女曰鸡鸣，士曰昧旦。”又《豳风·七月》：“馌彼南亩，田畯至喜。”\n			', '\n承德公老于场屋，不事生产，朝齑暮盐，黾勉有无，白首相庄，有～之德，此夫人之为妻也。\n			'),
(2510, '0:3:11', '鸡鸣候旦', '\n【 jī　míng　hòu　dàn 】\n			', '\n怕失晓而耽误正事，天没亮就起身。同“鸡鸣戒旦”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2511, '0:3:11', '鸡鸣戒旦', '\n【 jī　míng　jiè　dàn 】\n			', '\n怕失晓而耽误正事，天没亮就起身。\n			', '\n《诗经·齐风·鸡鸣序》：“《鸡鸣》，思贤妃也。哀公荒淫怠慢，故陈贤妃贞女夙夜警戒相成之道焉。”\n			', '\n暂无\n			'),
(2512, '0:3:11', '鸡鸣犬吠', '\n【 jī　míng　quǎn　fèi 】\n			', '\n比喻聚居在一处的人口稠密。同“鸡鸣狗吠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2513, '0:3:11', '鸡鸣起舞', '\n【 jī　míng　qǐ　wǔ 】\n			', '\n指胸怀大志、及时奋发的豪壮气概。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2514, '0:3:11', '鸡毛蒜皮', '\n【 jī　máo　suàn　pí 】\n			', '\n比喻无关紧要的琐碎事情。\n			', '\n<span class="C999">暂无</span>\n			', '\n他们是为了报答你的恩情，才送给你；你倒说是～。（孙犁《石猴——平分杂记》）\n			'),
(2515, '0:3:11', '鸡皮鹤发', '\n【 jī　pí　hè　fà 】\n			', '\n皮肤发皱，头发苍白。指老人。\n			', '\n北周·庾信《竹杖赋》：“子老矣，鹤发鸡皮，蓬头历齿。”\n			', '\n刻木牵丝作老翁，～与真同。（唐玄宗《傀儡吟》）\n			'),
(2516, '0:3:11', '鸡犬不安', '\n【 jī　quǎn　bù　ān 】\n			', '\n形容骚扰得厉害，连鸡狗都不得安宁。同“鸡犬不宁”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2517, '0:3:11', '鸡犬不惊', '\n【 jī　quǎn　bù　jīng 】\n			', '\n形容行军纪律严明，连鸡狗都没有受到惊动。也指平安无事。\n			', '\n宋·彭龟年《止堂集·一八·寿张京尹十首》：“翁见一笑大欢足，鸡犬不惊仁意多。”\n			', '\n文王与子牙放炮起兵。一路上父老相迎，～。（明·许仲琳《封神演义》第二十八回）\n			'),
(2518, '0:3:11', '鸡犬不留', '\n【 jī　quǎn　bù　liú 】\n			', '\n形容屠杀残酷，连鸡狗都不能幸免。\n			', '\n《三国志·荀彧传》：“引军从泗南攻取虑、睢陵、夏丘诸县，皆屠之，鸡犬亦尽，墟邑无复行人。”\n			', '\n这是一笔永远算不清的债！以言杀戮，确是～。（老舍《吐了一口气》）\n			'),
(2519, '0:3:11', '鸡犬不宁', '\n【 jī　quǎn　bù　níng 】\n			', '\n形容骚扰得厉害，连鸡狗都不得安宁。\n			', '\n唐·柳宗元《捕蛇者说》：“哗然而骇者，虽鸡狗不得宁焉。”\n			', '\n你弟兄窝藏强盗，闹了两座军州，自去落草。官府着落地方搜缉，搅得～！（清·陈忱《水浒后传》第十六回）\n			'),
(2520, '0:3:11', '鸡犬不闻', '\n【 jī　quǎn　bù　wén 】\n			', '\n形容极为荒凉冷僻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2521, '0:3:11', '鸡栖凤巢', '\n【 jī　qī　fèng　cháo 】\n			', '\n栖：居住。鸡住在凤凰的窝里。比喻才德卑下的人占据高位。\n			', '\n宋·释道原《景德传灯录》卷十六：“鸡栖凤巢，非其同类出去。”\n			', '\n暂无\n			'),
(2522, '0:3:11', '鸡犬皆仙', '\n【 jī　quǎn　jiē　xiān 】\n			', '\n传说汉朝淮南王刘安修炼成仙后，把剩下的药撒在院子里，鸡和狗吃了，也都升天了。后比喻一个人做了官，和他有关的人也跟着得势。\n			', '\n汉·王充《论衡·道虚》：“淮南王刘安坐反而死，天下并闻，当时并见，儒书尚有言其得道仙去，鸡犬升天者。”\n			', '\n暂无\n			'),
(2523, '0:3:11', '鸡犬桑麻', '\n【 jī　quǎn　sāng　má 】\n			', '\n形容乡村的安静生活。\n			', '\n<span class="C999">暂无</span>\n			', '\n田里种着菜，篱笆里栽着花，大有～光景。（清·李宝嘉《文明小史》第五十三回）\n			'),
(2524, '0:3:11', '鸡犬升天', '\n【 jī　quǎn　shēng　tiān 】\n			', '\n传说汉朝淮南王刘安修炼成仙后，把剩下的药撒在院子里，鸡和狗吃了，也都升天了。后比喻一个人做了官，和他有关的人也跟着得势。\n			', '\n汉·王充《论衡·道虚》：“淮南王刘安坐反而死，天下并闻，当时并见，儒书尚有言其得道仙去，鸡犬升天者。”\n			', '\n暂无\n			'),
(2525, '0:3:11', '鸡犬无惊', '\n【 jī　quǎn　wú　jīng 】\n			', '\n形容行军纪律严明，连鸡狗都没有受到惊动。也指平安无事。同“鸡犬不惊”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2526, '0:3:11', '鸡犬相闻', '\n【 jī　quǎn　xiāng　wén 】\n			', '\n彼此家中的鸡和狗的叫声可以互相听到。表示距离很近，也形容一种和睦的景象。\n			', '\n先秦·李耳《老子》：“甘其食，美其服，安其居，乐其俗。邻国相望，鸡犬之声相闻，民至老死不相往来。”\n			', '\n阡陌交通，～。\n			'),
(2527, '0:3:11', '鸡声鹅斗', '\n【 jī　shēng　é　dòu 】\n			', '\n比喻吵吵闹闹，彼此不和。\n			', '\n<span class="C999">暂无</span>\n			', '\n从今咱们两个撂开手，省得～，叫别人笑话。（清·曹雪芹《红楼梦》第二十一回）\n			'),
(2528, '0:3:11', '鸡尸牛从', '\n【 jī　shī　niú　cóng 】\n			', '\n比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’”\n			', '\n暂无\n			'),
(2529, '0:3:11', '鸡头鱼刺', '\n【 jī　tóu　yú　cì 】\n			', '\n比喻轻微而不被重视的的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2530, '0:3:11', '鸡豚之息', '\n【 jī　tún　zhī　xī 】\n			', '\n比喻微小的收益。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2531, '0:3:11', '井蛙醯鸡', '\n【 jǐng　wā　xī　jī 】\n			', '\n醯鸡：昆虫名，即蠛蠓，常用以形容细小的东西。比喻眼界不广，见识浅薄。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2532, '0:3:11', '鸡鹜相争', '\n【 jī　wù　xiāng　zhēng 】\n			', '\n鸡鹜：比喻平庸的人。旧指小人互争名利。\n			', '\n战国·楚·屈原《卜居》：“宁与黄鹄比翼乎？将与鸡鹜争食乎？”\n			', '\n～，终无了期，虽有文治派之徐世昌，亦奚补乎？（蔡东藩、许廑父《民国通俗演义》第一百零二回）\n			'),
(2533, '0:3:11', '鸡鹜争食', '\n【 jī　wù　zhēng　shí 】\n			', '\n鸡鹜：比喻平庸的人。旧指小人互争名利。\n			', '\n战国·楚·屈原《卜居》：“宁与黄鹄比翼乎？将与鸡鹜争食乎？”\n			', '\n暂无\n			'),
(2534, '0:3:11', '鸡胸龟背', '\n【 jī　xiōng　guī　bèi 】\n			', '\n凸胸驼背。\n			', '\n章炳麟《新方言·释形体》：“《说文》：‘奚，大腹也。’今人谓匈（胸）腹间大者为奚匈，呼如鸡匈，遂有‘鸡胸龟背’之语。”\n			', '\n暂无\n			'),
(2535, '0:3:11', '鸡犬之声相闻，老死不相往来', '\n【 jīquǎnzhīshēng　xiāng　wén，lǎo　sǐbùxiā 】\n			', '\n现在形容彼此不了解，不互通音讯。\n			', '\n《老子》：“邻国相望，鸡犬之声相闻，民至老死不相往来。”\n			', '\n暂无\n			'),
(2536, '0:3:11', '鸡犬之声相闻，老死不相往来', '\n【 jīquǎnzhīshēng　xiāng　wén，lǎo　sǐbùxiā 】\n			', '\n现在形容彼此不了解，不互通音讯。\n			', '\n《老子》：“邻国相望，鸡犬之声相闻，民至老死不相往来。”\n			', '\n暂无\n			'),
(2537, '0:3:11', '鸡争鹅斗', '\n【 jī　zhēng　é　dòu 】\n			', '\n比喻吵吵闹闹，彼此不和。\n			', '\n清·曹雪芹《红楼梦》第二十一回：“从今咱们两个丢开手，省得鸡争鹅斗，叫别人笑。”\n			', '\n暂无\n			'),
(2538, '0:3:11', '菱角磨作鸡头', '\n【 líng　jiǎo　mó　zuò　jī　tóu 】\n			', '\n比喻困难大，波折多。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2539, '0:3:11', '木鸡养到', '\n【 mù　jī　yǎng　dào 】\n			', '\n木鸡：善斗的鸡，看上去象木头一样呆板。形容功夫到家。\n			', '\n《庄子·达生》：“几矣。鸡虽有鸣者，已无变矣，望之似木鸡矣，其德全矣；异鸡无敢应者，反走矣。”\n			', '\n暂无\n			'),
(2540, '0:3:11', '牛刀割鸡', '\n【 niú　dāo　gē　jī 】\n			', '\n杀只鸡用宰牛的刀。比喻大材小用。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n暂无\n			'),
(2541, '0:3:11', '牛鼎烹鸡', '\n【 niú　dǐng　pēng　jī 】\n			', '\n用煮一头牛的大锅煮一只鸡。比喻大材小用。\n			', '\n《后汉书·边让传》：“函牛之鼎以烹鸡，多汁则淡而不可食，少汁则熬而不可熟。”\n			', '\n暂无\n			'),
(2542, '0:3:11', '宁为鸡口，不为牛后', '\n【 nìng　wéi　jī　kǒu，bù　wéi　niú　hòu 】\n			', '\n牛后：牛的肛门。宁愿做小而洁的鸡嘴，而不愿做大而臭的牛肛门。比喻宁在局面小的地方自主，不愿在局面大的地方听人支配。\n			', '\n《战国策·韩策一》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’今大王西面交臂而臣事秦，何以异于牛后乎？”\n			', '\n俗谚云：“～”，以大王之贤，挟强韩之兵，而有“牛后”之名，臣窃羞之。（明·冯梦龙《东周列国志》第九十回）\n			'),
(2543, '0:3:11', '宁为鸡口，无为牛后', '\n【 nìng　wéi　jī　kǒu，wú　wéi　niú　hòu 】\n			', '\n比喻宁居小者之首，不为大者之后。\n			', '\n西汉·刘向《战国策·韩策一》：“臣闻鄙语曰：‘宁为鸡口，无为牛后。’今大王西面交臂而臣事秦，何以异于牛后？”\n			', '\n自古道，～，你忍得这气也。\n			'),
(2544, '0:3:11', '宁为鸡口，毋为牛后', '\n【 nìng　wéi　jī　kǒu，wú　wéi　niú　hòu 】\n			', '\n比喻宁居小者之首，不为大者之后。同“宁为鸡口，无为牛后”。\n			', '\n章炳麟《社会通诠商兑》：“宁为鸡口，毋为牛后，与使他人啖我而饱也，宁自啖而不足。”\n			', '\n暂无\n			'),
(2545, '0:3:11', '牝鸡晨鸣', '\n【 pìn　jī　chén　míng 】\n			', '\n母鸡报晓。旧时比喻妇女窃权乱政。同“牝鸡司晨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2546, '0:3:11', '牝鸡牡鸣', '\n【 pìn　jī　mǔ　míng 】\n			', '\n母鸡报晓。旧时比喻妇女窃权乱政。同“牝鸡司晨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2547, '0:3:11', '牝鸡司晨', '\n【 pìn　jī　sī　chén 】\n			', '\n母鸡报晓。旧时比喻妇女窃权乱政。\n			', '\n《尚书·牧誓》：“牝鸡无晨。牝鸡之晨，惟家之索。”\n			', '\n听谗信佞，残杀忠良，驱逐正士，播弃黎老，昵比匪人，惟以妇言是用，此“～，惟家之索。”（明·许仲琳《封神演义》第七回）\n			'),
(2548, '0:3:11', '牝鸡司旦', '\n【 pìn　jī　sī　dàn 】\n			', '\n母鸡报晓。旧时比喻妇女窃权乱政。同“牝鸡司晨”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2549, '0:3:11', '认鸡作凤', '\n【 rèn　jī　zuò　fèng 】\n			', '\n佛教语。指认凡庸为珍贵。\n			', '\n《万善同归集》卷一：“如楚国愚人认鸡作凤，犹春池小果执石为珠。但任浅近之情，不探深密之旨。”\n			', '\n暂无\n			'),
(2550, '0:3:11', '汝南晨鸡', '\n【 rǔ　nán　chén　jī 】\n			', '\n即汝南鸡。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2551, '0:3:11', '鼠肚鸡肠', '\n【 shǔ　dù　jī　cháng 】\n			', '\n比喻气量狭小，只考虑小事，不顾大体。\n			', '\n明·烟霞散人《斩鬼传》：“鼠肚鸡肠，一包粪也存不住，要你何用。”\n			', '\n暂无\n			'),
(2552, '0:3:11', '鼠腹鸡肠', '\n【 shǔ　fù　jī　cháng 】\n			', '\n比喻气量狭小，只考虑小事，不顾大体。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2553, '0:3:11', '杀鸡哧猴', '\n【 shā　jī　chī　hóu 】\n			', '\n比喻惩罚一人以恐吓或警戒其他人。同“杀鸡骇猴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2554, '0:3:11', '杀鸡骇猴', '\n【 shā　jī　hài　hóu 】\n			', '\n传说猴子怕见血，驯猴的人便杀鸡放血来恐吓猴子。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n俗语说的好，叫做“～”，拿鸡子宰了，那猴儿自然害怕。（清·李宝嘉《官场现形记》第五十三回）\n			'),
(2555, '0:3:11', '杀鸡儆猴', '\n【 shā　jī　jǐng　hóu 】\n			', '\n杀鸡给猴子看。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2556, '0:3:11', '杀鸡抹脖', '\n【 shā　jī　mǒ　bó 】\n			', '\n形容心里着急而无法可想的神态。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2557, '0:3:11', '杀鸡取蛋', '\n【 shā　jī　qǔ　dàn 】\n			', '\n比喻贪图眼前微小的好处而损害长久的利益。亦作“杀鸡取卵”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2558, '0:3:11', '杀鸡取卵', '\n【 shā　jī　qǔ　luǎn 】\n			', '\n卵：蛋。为了要得到鸡蛋，不惜把鸡杀了。比喻贪图眼前的好处而不顾长远利益。\n			', '\n《伊索寓言》\n			', '\n请皇上勿再竭泽而渔，～，为小民留一线生机。（姚雪垠《李自成》第二卷第三十二章）\n			'),
(2559, '0:3:11', '山鸡舞镜', '\n【 shān　jī　wǔ　jìng 】\n			', '\n山鸡对镜起舞。比喻自我欣赏。\n			', '\n南朝宋·刘敬叔《异苑》卷三：“山鸡爱其毛羽，映水则舞。很武时，南方献之，帝欲其鸣舞无由。公子苍舒令置大镜其前，鸡鉴形而舞，不知止。”\n			', '\n丹桂岩～，碧梧岭孔雀开屏。（清·李汝珍《镜花缘》第二十回）\n			'),
(2560, '0:3:11', '杀鸡为黍', '\n【 shā　jī　wéi　shǔ 】\n			', '\n指殷勤款待宾客。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2561, '0:3:11', '杀鸡吓猴', '\n【 shā　jī　xià　hóu 】\n			', '\n杀鸡给猴子看。比喻用惩罚一个人的办法来警告别的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n猜到皇上有～之意，心中七上八下，半天没有做声。（姚雪垠《李自成》第二卷第二十一章）\n			'),
(2562, '0:3:11', '杀鸡焉用牛刀', '\n【 shā　jī　yān　yòng　niú　dāo 】\n			', '\n杀只鸡何必用宰牛的刀。比喻办小事情用不着花大气力。\n			', '\n《论语·阳货》：“子之武城，闻弦歌之声。夫子莞尔而笑，曰：‘割鸡焉用牛刀。’”\n			', '\n“～”？不劳温侯亲往，吾斩众诸侯首级，如探囊取物耳。（明·罗贯中《三国演义》第五回）\n			'),
(2563, '0:3:11', '手无缚鸡之力', '\n【 shǒu　wú　fù　jī　zhī　lì 】\n			', '\n连捆绑鸡的力气都没有。形容身体弱、力气小。\n			', '\n元·《赚蒯通》第一折：“那韩信手无缚鸡之力。”\n			', '\n暂无\n			'),
(2564, '0:3:11', '偷狗戏鸡', '\n【 tōu　gǒu　xì　jī 】\n			', '\n比喻不务正业。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2565, '0:3:11', '偷鸡不着蚀把米', '\n【 tōu　jī　bù　zhe　shí　bǎ　mǐ 】\n			', '\n俗语。鸡没有偷到，反而损失了一把米。比喻本想占便宜反而吃了亏。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2566, '0:3:11', '偷鸡盗狗', '\n【 tōu　jī　dào　gǒu 】\n			', '\n指偷窃的行为。也指不正经的勾当。同“偷鸡摸狗”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2567, '0:3:11', '偷鸡摸狗', '\n【 tōu　jī　mō　gǒu 】\n			', '\n指偷窃的行为。也指不正经的勾当。\n			', '\n明·施耐庵《水浒全传》第四十六回：“小人如今在此，只做得些偷鸡盗狗的勾当，几时是了；跟随的二位哥哥上山去，却不好？”\n			', '\n成日家～，腥的臭的，都拉了你屋里去！（清·曹雪芹《红楼梦》第四十四回）\n			'),
(2568, '0:3:11', '土鸡瓦狗', '\n【 tǔ　jī　wǎ　gǒu 】\n			', '\n比喻徒有虚名而无实用的东西。同“土鸡瓦犬”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2569, '0:3:11', '土鸡瓦犬', '\n【 tǔ　jī　wǎ　quǎn 】\n			', '\n用泥捏的鸡，用瓦做的狗。比喻徒有虚名而无实用的东西。\n			', '\n明·罗贯中《三国演义》第二十五回：“曹操指山下颜良排的阵势，旗帜鲜明，枪刀森布，严整有威，乃谓关公曰：‘河北人马，如此雄壮！’关公曰：‘以吾观之，如土鸡瓦犬耳！’”\n			', '\n暂无\n			'),
(2570, '0:3:11', '陶犬瓦鸡', '\n【 táo　quǎn　wǎ　jī 】\n			', '\n陶土做的狗，泥土塑的鸡。比喻徒具形式而无实用的东西。\n			', '\n南朝梁·萧绎《金缕子》：“陶犬无守夜之警，瓦鸡无司晨之益。”\n			', '\n暂无\n			'),
(2571, '0:3:11', '闻鸡起舞', '\n【 wén　jī　qǐ　wǔ 】\n			', '\n听到鸡叫就起来舞剑。后比喻有志报国的人及时奋起。\n			', '\n《晋书·祖逖传》：“中夜闻荒鸡鸣，蹴琨觉，曰：‘此非恶声也。’因起舞。”\n			', '\n暂无\n			'),
(2572, '0:3:11', '瓮里醯鸡', '\n【 wèng　lǐ　xī　jī 】\n			', '\n比喻见闻狭隘的人。\n			', '\n《列子·天瑞》：“厥昭生乎湿，醯鸡生乎酒。”\n			', '\n暂无\n			'),
(2573, '0:3:11', '味如鸡肋', '\n【 wèi　rú　jī　lèi 】\n			', '\n鸡肋：鸡的肋骨，没有肉，比喻无多大意味而又不忍舍弃的东西。比喻事情不做可惜，做起来没有多大好处。\n			', '\n《三国志·魏志·武帝纪》裴松之注引《九州春秋》曰：“夫鸡肋，弃之如可惜，食之无所得，以比汉中，知王欲还也。”\n			', '\n暂无\n			'),
(2574, '0:3:11', '小肚鸡肠', '\n【 xiǎo　dù　jī　cháng 】\n			', '\n比喻器量狭小，只考虑小事，不照顾大局。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2575, '0:3:11', '雄鸡断尾', '\n【 xióng　jī　duàn　wěi 】\n			', '\n断尾：断去尾巴。本指雄鸡因怕做祭祀的牺牲而自残其身。后比喻人怕被杀而自尽。\n			', '\n《左传·昭公二十二年》：“宾孟适郊，见雄鸡自断其尾。问之，侍者曰：‘自惮其牺也。’”\n			', '\n暂无\n			'),
(2576, '0:3:11', '雄鸡夜鸣', '\n【 xióng　jī　yè　míng 】\n			', '\n古代认为雄鸡夜鸣为异常现象，预兆战事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2577, '0:3:11', '鬻鸡为凤', '\n【 yù　jī　wéi　fèng 】\n			', '\n指以次充好，混淆优劣。\n			', '\n唐·黄滔《谢试官》：“伏念鬻鸡为凤，有识咸惊，投砾参琼，良知足鄙。”\n			', '\n暂无\n			'),
(2578, '0:3:11', '一人得道，鸡犬升天', '\n【 yī　rén　dé　dào，jī　quǎn　shēng　tiān 】\n			', '\n一个人得道面仙，全家连鸡、狗也都随之升天。比喻一个人做了官，和他有关系的人也都跟着得势。\n			', '\n汉·王充《论衡·道虚》：“淮南王学道，招会天下有道之人，倾一国之尊，下道术之士，是以道术之士并会淮南，奇方异术，莫不争出。王遂得道，举家升天，畜产皆仙，犬吠于天上，鸡鸣于云中。”\n			', '\n暂无\n			'),
(2579, '0:3:11', '一人飞升，仙及鸡犬', '\n【 yī　rén　fēi　shēng，xiān　jí　jī　quǎn 】\n			', '\n用以比喻一人得势，与其有关者亦皆随之发迹。多含讽刺意。同“一人得道，鸡犬升天”。\n			', '\n语出汉·淮南王刘安举家升天的传说。清·蒲松龄《聊斋志异·促织》：“天将以酬长厚者，遂使抚臣、令尹、并受促织恩荫。闻之：‘一人飞升，仙及鸡犬。’信夫！”\n			', '\n暂无\n			'),
(2580, '0:3:11', '只鸡斗酒', '\n【 zhī　jī　dǒu　jiǔ 】\n			', '\n斗：酒器。准备好一只鸡，一壶酒。原指对死者的祭奠物品，多用作追悼亡友之辞。后也指招待来客。\n			', '\n汉·曹操《祀故太尉桥玄文》：“殂逝之后，路有经由，不以斗酒只鸡过相沃酹，车过三步，腹痛勿怪。”\n			', '\n暂无\n			'),
(2581, '0:3:11', '宰鸡教猴', '\n【 zǎi　jī　jiào　hóu 】\n			', '\n用杀鸡来警戒猴子。比喻严惩一个以警告其余。\n			', '\n高云览《小城春秋》第三章：“吴七总想抓个奸细来‘宰鸡教猴’一下，吴坚和家剑平反对；怕闹得内部更混乱，又怕有后患。”\n			', '\n暂无\n			'),
(2582, '0:3:11', '指鸡骂狗', '\n【 zhǐ　jī　mà　gǒu 】\n			', '\n指着鸡骂狗。比喻表面上骂这个人，实际上是骂那个人。\n			', '\n<span class="C999">暂无</span>\n			', '\n你有话直说好了，用不着～。\n			'),
(2583, '0:3:11', '捉鸡骂狗', '\n【 zhuō　jī　mà　gǒu 】\n			', '\n犹指桑骂槐。比喻表面上骂这个人，实际上是骂那个人。\n			', '\n明·冯梦龙《醒世恒言》第九卷：“次日，张氏晓得了，反怪媳妇做格，不去勾搭儿子干事，把一团美意，看做不良之心，捉鸡骂狗，言三语四，影射的发作了一场。”\n			', '\n暂无\n			'),
(2584, '0:3:11', '争鸡失羊', '\n【 zhēng　jī　shī　yáng 】\n			', '\n比喻贪小失大。\n			', '\n汉·焦延寿《易林》卷八：“争鸡失羊，亡其金囊。”\n			', '\n暂无\n			'),
(2585, '0:3:11', '只鸡絮酒', '\n【 zhī　jī　xù　jiǔ 】\n			', '\n指悼念故人，祭品菲薄。\n			', '\n《后汉书·徐徲传》：“徲尝为太尉黄琼所辟，不就。及琼卒归葬，徲乃负粮徒步到江夏赴之，设鸡酒薄祭，哭毕而去。不告姓名。”\n			', '\n暂无\n			'),
(2586, '0:3:11', '只鸡樽酒', '\n【 zhī　jī　zūn　jiǔ 】\n			', '\n指简单的酒菜。同“只鸡斗酒”。\n			', '\n宋·叶绍翁《四朝闻见录·胡紘李沐》：“此非人情，只鸡樽酒，山中未为乏也。”\n			', '\n暂无\n			'),
(2587, '0:3:11', '炙鸡渍酒', '\n【 zhì　jī　zì　jiǔ 】\n			', '\n指以棉絮浸酒，晒干后裹烧鸡，携以吊丧。后遂用为不忘恩的典实。\n			', '\n《后汉书·徐穉传》“穉尝为太尉黄琼所辟，不就”李贤注引三国吴谢承《后汉书》：“穉诸公所辟虽不就，有死丧负笈赴吊。常於家豫炙鸡一只，以一两绵絮渍酒中，暴乾以裹鸡，径到所起冢外，……醊酒毕，留谒则去，不见丧主。”\n			', '\n[东汉徐孺子]～，万里赴吊……有忠厚不忘恩之意。\n			'),
(2588, '0:3:11', '卓立鸡群', '\n【 zhuó　lì　jī　qún 】\n			', '\n象鹤站在鸡群中一样。比喻一个人的仪表或才能在周围一群人里显得很突出。\n			', '\n晋·戴逵《竹林七贤论》：“嵇绍入洛，或谓王戎曰：‘昨于稠人中始见嵇绍，昂昂然若野鹤之在鸡群。’”南朝梁·刘义庆《世说新语·容止》：“嵇延祖卓卓如野鹤之在鸡群。”\n			', '\n暂无\n			'),
(2589, '0:4:0', '杯盘狼藉', '\n【 bēi　pán　láng　jí 】\n			', '\n狼藉：象狼窝里的草那样散乱。杯子盘子乱七八糟地放着。形容吃喝以后桌面杂乱的样子。\n			', '\n《史记·滑稽列传》：“日暮酒阑，合尊促坐，男女同席，履舄交错，杯盘狠藉。”\n			', '\n这桌子微醺，那桌子半酣，～，言语喧哗。（清·李绿园《歧路灯》第八十八回）\n			'),
(2590, '0:4:0', '杯盘狼籍', '\n【 bēi　pán　láng　jí 】\n			', '\n杯盘等放得乱七八糟。形容宴饮已毕或将毕时的情景。\n			', '\n见“杯盘狼藉”。\n			', '\n[美娘]醉眼朦胧，看见房中灯烛辉煌，～。\n			'),
(2591, '0:4:0', '豺狼成性', '\n【 chái　láng　chéng　xìng 】\n			', '\n象豺狼一样凶恶残暴成了习性。形容为人残暴\n			', '\n唐·骆宾王《为徐敬业讨武氏檄》：“加以虺蜴为心，豺狼成性。”\n			', '\n此人枭獍为心，～，诚然王法所不容。（明·凌濛初《二刻拍案惊奇》卷四）\n			'),
(2592, '0:4:0', '豺狼当道', '\n【 chái　láng　dāng　dào 】\n			', '\n当道：横在道路中间。比喻坏人当权。\n			', '\n《汉书·孙宝传》：“豺狼横道，不宜复问狐狸。”\n			', '\n男子汉非不以功名为念，那堪～，不如只在家中侍奉尊堂兄弟。（元·宫大用《范张鸡黍》第一折）\n			'),
(2593, '0:4:0', '除狼得虎', '\n【 chú　láng　dé　hǔ 】\n			', '\n比喻除去一害又来一害。\n			', '\n《金史·陈规传》：“近虽遗官谦察，治其奸滥，易其疲软，然代者亦非选择，所谓除狼得虎也。”\n			', '\n孙坚乃东猛虎；若打破洛阳，杀了董卓，正是除狼而得虎也。\n			'),
(2594, '0:4:0', '豺狼当路', '\n【 chái　láng　dāng　lù 】\n			', '\n比喻暴虐奸邪的人掌握国政。\n			', '\n《三国志·魏志·杜袭传》：“方今豺狼当路而狐狸是先，人将谓殿下避强攻弱，进不为勇，退不为仁。”\n			', '\n～，非止一人；鲸鲵不枭，倏焉五载。\n			'),
(2595, '0:4:0', '豺狼当涂', '\n【 chái　láng　dāng　tú 】\n			', '\n比喻暴虐奸邪的人掌握国政。\n			', '\n《晋书·熊远传》：“孝怀皇帝宫未反，豺狼当涂，人神同忿。”\n			', '\n暂无\n			'),
(2596, '0:4:0', '豺狼虎豹', '\n【 chái　láng　hǔ　bào 】\n			', '\n泛指危害人畜的各种猛兽。也比喻凶残的恶人。\n			', '\n清·刘鹗《老残游记》第八回：“实在可怕的是豺狼虎豹。天晚了，倘若出来个把，我们就坏了。”\n			', '\n暂无\n			'),
(2597, '0:4:0', '豺狼横道', '\n【 chái　láng　héng　dào 】\n			', '\n横道：横在道路中间。比喻坏人当权。\n			', '\n《汉书·孙宝传》：“豺狼横道，不宜复问狐狸。”\n			', '\n暂无\n			'),
(2598, '0:4:0', '豺狼野心', '\n【 chái　láng　yě　xīn 】\n			', '\n比喻坏人的狠毒用心。\n			', '\n汉·陈琳《为袁绍檄豫州》：“而操豺狼野心，潜包祸谋。”\n			', '\n寻超宗植性险戾，禀行凶詖，～，久暴遐迩。\n			'),
(2599, '0:4:0', '豺狼之吻', '\n【 chái　láng　zhī　wěn 】\n			', '\n比喻残酷贪婪的官吏。\n			', '\n《三国志·蜀书·诸葛亮传》注：“使百姓困于豺狼之吻，一夫有死，皆亮之罪。”\n			', '\n暂无\n			'),
(2600, '0:4:0', '鸱视狼顾', '\n【 chī　shì　láng　gù 】\n			', '\n如鸱鸟举首而视，如狼反顾。形容人的凶狠贪戾。\n			', '\n《文选·马融\n			', '\n建～，唯利是赖。\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2601, '0:4:0', '狗肺狼心', '\n【 gǒu　fèi　láng　xīn 】\n			', '\n形容心肠象狼和狗一样凶恶狠毒。同“狼心狗肺”。\n			', '\n昆曲《十五贯》第二场：“谋财害命拐女人，狗肺狼心！”\n			', '\n只为一班卖国格中国人，生成狗肺搭狼心，日日夜夜吃穷人，吃得来头错眼暗发热乎。\n			'),
(2602, '0:4:0', '官虎吏狼', '\n【 guān　hǔ　lì　láng 】\n			', '\n官如虎，吏如狼。形容官吏贪暴。\n			', '\n清·蒲松龄《聊斋志异·梦狼》：“窃叹天下之官虎而吏狼者，比比也。”\n			', '\n暂无\n			'),
(2603, '0:4:0', '鬼哭狼嚎', '\n【 guǐ　kū　láng　háo 】\n			', '\n形容大声哭叫，声音凄厉。\n			', '\n元·无名氏《马陵道》第二折：“可怎生神嚎鬼哭，雾惨云昏，白日为幽。”\n			', '\n况且宝玉才好了些，连我们也不敢说话，你反打的人～的！（清·曹雪芹《红楼梦》第五十八回）\n			'),
(2604, '0:4:0', '鬼哭狼嗥', '\n【 guǐ　kū　láng　háo 】\n			', '\n①形容哭叫悲惨凄厉。②形容声音大而杂乱，令人惊恐。\n			', '\n魏巍《东方》第三部第六章：“有的钻到汽车下，有的往坦克的后面涌，鬼哭狼嗥，乱成一片。”\n			', '\n忽然，三架飞机掠过头上，～一般往北山飞去。\n			'),
(2605, '0:4:0', '狗行狼心', '\n【 gǒu　xíng　láng　xīn 】\n			', '\n比喻行为凶狠，心肠毒辣。\n			', '\n元·白朴《恼煞人》套曲：“恨冯魁，趋恩夺爱，狗行狼心，全然不怕天折挫。”\n			', '\n为你两头白面搬兴废，转背言词说是非。这厮敢狗行狼心，～。\n			'),
(2606, '0:4:0', '鬼吒狼嚎', '\n【 guǐ　zhà　láng　háo 】\n			', '\n怪声怪气地呼喊嚎叫。\n			', '\n欧阳山《三家巷》十四：“好吧，我只管去说说看，可你大清早，鬼吒狼嚎嚷什么呢？叫人听了好听！”\n			', '\n暂无\n			'),
(2607, '0:4:0', '鬼咤狼嚎', '\n【 guǐ　zhà　láng　háo 】\n			', '\n怪声怪气地呼喊嚎叫。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2608, '0:4:0', '鬼抓狼嚎', '\n【 guǐ　zhuā　láng　háo 】\n			', '\n形容哭叫悲惨凄厉。同“鬼哭神号”。\n			', '\n欧阳山《高干大》第十九章：“任桂花听见他这么鬼抓狼嚎，心乱得不知怎样才好。”\n			', '\n暂无\n			'),
(2609, '0:4:0', '虎狼之势', '\n【 hǔ　láng　zhī　shì 】\n			', '\n形容极凶猛的声势。\n			', '\n《淮南子·要略》：“孝公欲以虎狼之势而吞诸侯。”\n			', '\n暂无\n			'),
(2610, '0:4:0', '虎穴狼巢', '\n【 hǔ　xué　láng　cháo 】\n			', '\n虎和狼的窝巢。比喻极其危险的地方。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2611, '0:4:0', '拒虎进狼', '\n【 jù　hǔ　jìn　láng 】\n			', '\n比喻一害刚去，又来一害。\n			', '\n明·张煌言《复郎廷佐书》：“乃拒虎进狼，既收渔人之利于河北。”\n			', '\n若名为同心御侮，实乃利吾土地，我则～，彼则翻云覆雨。\n			'),
(2612, '0:4:0', '拒狼进虎', '\n【 jù　láng　jìn　hǔ 】\n			', '\n比喻一害刚去，又来一害。同“拒虎进狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2613, '0:4:0', '进退狼狈', '\n【 jìn　tuì　láng　bèi 】\n			', '\n进退两难；陷于困境。\n			', '\n《三国志·蜀志·马超传》：“阜叙起于卤城，超出攻之不能下；宽衢闭冀城门，超不得入。进退狼狈，乃奔汉中依张鲁。”\n			', '\n晃穆未平，康宁复至，～，势必大危。\n			'),
(2614, '0:4:0', '狼狈不堪', '\n【 láng　bèi　bù　kān 】\n			', '\n困顿、窘迫得不能忍受。形容非常窘迫的样子。\n			', '\n《三国志·蜀志·马超传》：“宽、衢闭冀城门，超不得入。进退狼狈，乃奔汉中依张鲁。”\n			', '\n掌声如翻腾的怒海汹涌的扑向台上去，弄得这些丑类面红耳赤，～。（刘白羽《雷电颂——怀念郭沫若同志》）\n			'),
(2615, '0:4:0', '狼奔鼠窜', '\n【 láng　bēn　shǔ　cuàn 】\n			', '\n狼群鼠辈到处流窜。形容人四处奔跑逃窜。\n			', '\n明·沈鲸《双珠记》第十四出：“忽闻访察怕如雷，狼奔鼠窜，无由忏悔。”\n			', '\n暂无\n			'),
(2616, '0:4:0', '狼奔豕突', '\n【 láng　bēn　shǐ　tū 】\n			', '\n豕：猪；突：猛冲。象狼那样奔跑，象猪那样冲撞。形容成群的坏人乱冲乱撞，到处搔扰。\n			', '\n明·归庄《万古愁》：“有几个狼奔豕突的燕和赵，有几个狗屠驴贩的奴和盗。”\n			', '\n在中国战场它还～，随心所欲。（矛盾《东条的“神符”》）\n			'),
(2617, '0:4:0', '狼奔鼠偷', '\n【 láng　bēn　shǔ　tōu 】\n			', '\n形容坏人到处扰乱。\n			', '\n清·梅曾亮《朝议大夫台湾府盖君墓志铭》：“公在商州六年，贼出入陕西久，无所掠利，锐欲窥河南甚，狼奔鼠偷，情状捷出。”\n			', '\n暂无\n			'),
(2618, '0:4:0', '狼奔兔脱', '\n【 láng　bēn　tù　tuō 】\n			', '\n形容仓皇逃窜。\n			', '\n《冷眼观》第四回：“远远听见吆喝之声，由远而近……众人手忙脚乱，将桌上杯盘收拾干净，转眼间，狼奔兔脱，如鸟兽散去。”\n			', '\n暂无\n			'),
(2619, '0:4:0', '狼狈为奸', '\n【 láng　bèi　wéi　jiān 】\n			', '\n比喻互相勾结干坏事。\n			', '\n<span class="C999">暂无</span>\n			', '\n帝国主义与封建势力永远是互相勾结，～的。（闻一多《谨防汉奸合法化》）\n			'),
(2620, '0:4:0', '狼狈万状', '\n【 láng　bèi　wàn　zhuàng 】\n			', '\n狼狈：窘迫的样子；万状：多种样子。形容极其困顿、窘迫。\n			', '\n《新刊大宋宣和遗事》：“太上因暑热成病，狼狈万状。”\n			', '\n暂无\n			'),
(2621, '0:4:0', '狼狈周章', '\n【 láng　bèi　zhōu　zhāng 】\n			', '\n指仓皇惊恐。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2622, '0:4:0', '狼吃幞头', '\n【 láng　chī　fú　tóu 】\n			', '\n狼衔去人的幞头，吞不下又吐不出。比喻有苦难言，强自忍耐。\n			', '\n元·无名氏《杀狗劝夫》第一折：“你便骂我一千场，便拷我三十顿，我则索狼吃幞头，心儿自忍。”\n			', '\n俺家里也使了他数锭银，不勾二年，银两使尽，剗地赶他出去，他则索～，心儿里自忍。\n			'),
(2623, '0:4:0', '狼虫虎豹', '\n【 láng　chóng　hǔ　bào 】\n			', '\n①泛指凶猛的动物。②比喻恶人歹徒。\n			', '\n明·贾仲名《对玉梳》第三折：“转过这山坡，一簇榆林，黑洞洞的，不知里面藏着什么狼虫虎豹。”\n			', '\n县长财主，～。\n			'),
(2624, '0:4:0', '狼飡虎食', '\n【 láng　cān　hǔ　shí 】\n			', '\n形容吃东西又猛又急。同“狼餐虎咽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2625, '0:4:0', '狼餐虎噬', '\n【 láng　cān　hǔ　shì 】\n			', '\n①形容吃东西又猛又急。同“狼餐虎咽”。②比喻残酷剥削搜括。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2626, '0:4:0', '狼飡虎咽', '\n【 láng　cān　hǔ　yān 】\n			', '\n形容吃东西又猛又急。同“狼餐虎咽”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2627, '0:4:0', '狼餐虎咽', '\n【 láng　cān　hǔ　yàn 】\n			', '\n形容吃东西又猛又急。\n			', '\n明·吴承恩《西游记》第五十二回：“［行者］迎着里面灯光，仔细观看。只见那大小群妖，一个个狼餐虎咽，正都吃东西哩。”\n			', '\n老军道：“忒过分了！”父子二人正在饥馁之时，拿起饭来，～，尽情一饱。\n			'),
(2628, '0:4:0', '狼顾鸱跱', '\n【 láng　gù　chī　yín 】\n			', '\n如狼凶视，如鸱峙立。比喻凶暴者伺机欲动。\n			', '\n《北史·魏纪一论》：“明元承运之初，属廓定之始，于时狼顾鸱跱，犹有窥觎，加以天赐之末，内难尤甚。”\n			', '\n暂无\n			'),
(2629, '0:4:0', '狼顾鸱张', '\n【 láng　gù　chī　zhāng 】\n			', '\n如狼凶视，如鸱张翼。形容凶暴，嚣张。\n			', '\n北魏·杨衒之《洛阳伽蓝记·平等寺》：“故推立长乐王子攸以续绝业……然群飞未宁，横流且及，皆狼顾鸱张，岳立基趾。”\n			', '\n蛮夷恃险，～。\n			'),
(2630, '0:4:0', '狼顾虎视', '\n【 láng　gù　hǔ　shì 】\n			', '\n如狼虎视物。形容威严而凶狠。\n			', '\n《三国志·蜀志·杨戏传》“亮南征，留邵为治中从事，是岁卒”裴松之注引晋·常璩《华阳国志》：“亮身仗强兵，狼顾虎视，五大不在边，臣常危之。”\n			', '\n暂无\n			'),
(2631, '0:4:0', '狼顾狐疑', '\n【 láng　gù　hú　yí 】\n			', '\n指左顾右昐，存有畏惧和犹豫之心。狼顾，狼走路时常常回头看；狐疑，狐狸本性多疑。\n			', '\n孙中山《布告全国同胞书》：“行事或虎头鼠尾，而存心复狼顾狐疑。”\n			', '\n暂无\n			'),
(2632, '0:4:0', '狼顾麕惊', '\n【 láng　gù　qiān　jīng 】\n			', '\n比喻惊恐万状。\n			', '\n《新唐书·岑文本传》：“文本说孝恭曰：‘自隋无道，四海救死，延项以望真主……大王诚纵兵剽系，恐江岭以南，向化心沮，狼顾麕惊。’”\n			', '\n暂无\n			'),
(2633, '0:4:0', '狼顾鸢视', '\n【 láng　gù　yuān　shì 】\n			', '\n如狼鹰视物。形容凶狠而贪婪。\n			', '\n明·方孝孺《周官》一：“六七百年之间，强诸侯狼顾鸢视者莫敢先发陵上之言，必至于周礼尽废而后肆，道之化民也。”\n			', '\n暂无\n			'),
(2634, '0:4:0', '狼嗥狗叫', '\n【 láng　háo　gǒu　jiào 】\n			', '\n形容恶人狂呼乱叫。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2635, '0:4:0', '狼嗥鬼叫', '\n【 láng　háo　guǐ　jiào 】\n			', '\n形容声音凄厉。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2636, '0:4:0', '狼嚎鬼叫', '\n【 láng　háo　guǐ　jiào 】\n			', '\n形容声音凄厉。同“狼嗥鬼叫”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2637, '0:4:0', '狼号鬼哭', '\n【 láng　háo　guǐ　kū 】\n			', '\n形容哭叫的声音凄厉。\n			', '\n清·曹雪芹《红楼梦》第五十八回：“等两日咱们去痛回一回，大家把这威风煞一煞儿才好呢！况且宝玉才好了些，连我们也不敢说话，你反打的人狼号鬼哭的。”\n			', '\n暂无\n			'),
(2638, '0:4:0', '狼艰狈蹶', '\n【 láng　jiān　bèi　juě 】\n			', '\n比喻处境困苦窘迫。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2639, '0:4:0', '狼猛蜂毒', '\n【 láng　měng　fēng　dú 】\n			', '\n形容人凶狠毒辣。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2640, '0:4:0', '粒米狼戾', '\n【 lì　mǐ　láng　lì 】\n			', '\n谷粒撒得满地都是。形容粮食充盈。\n			', '\n先秦·孟轲《孟子·滕文公上》：“乐岁，粒米狼戾。”\n			', '\n今岁再得一稔，想见～。\n			'),
(2641, '0:4:0', '狼前虎后', '\n【 láng　qián　hǔ　hòu 】\n			', '\n前门赶走狼，后门来了虎。比喻坏人接踵而来。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2642, '0:4:0', '狼飧虎咽', '\n【 láng　sūn　hǔ　yàn 】\n			', '\n飧：熟食，饭食。形容吃东西又猛又急。亦作“狼餐虎咽”。\n			', '\n明·凌濛初《初刻拍案惊奇》卷三：“十人自来吃酒，主人安排些鸡、豚、牛、羊肉来做下酒。须臾之间，狼飨虎咽，算来吃勾有六七十斤的肉，倾尽了六七坛的酒。”\n			', '\n见他们一个个蹲在地下，吃了个～，沟满壕平。（清·文康《儿女英雄传》第十四回\n			'),
(2643, '0:4:0', '狼突鸱张', '\n【 láng　tū　chī　zhāng 】\n			', '\n像狼一样奔突，像鹞鹰一样张开翅膀。形容坏人猖狂嚣张到了极点。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2644, '0:4:0', '狼吞虎餐', '\n【 láng　tūn　hǔ　cān 】\n			', '\n形容吃东西又猛又急。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2645, '0:4:0', '狼贪虎视', '\n【 láng　tān　hǔ　shì 】\n			', '\n象狼一样贪婪，象老虎一样睁大眼睛盯着。比喻野心很大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2646, '0:4:0', '狼吞虎噬', '\n【 láng　tūn　hǔ　shì 】\n			', '\n像狼虎那样吞食咬嚼。比喻极为贪婪残忍。\n			', '\n明·无名氏《鸣凤记·二相争朝》：“你辟私门，贿赂行，半朝臣，皆从顺。你狼吞虎噬伤残了万民百姓，害得那有功臣百事无成。”\n			', '\n自此以入，司牧之官，必能扫除一切苛政……去害马以驯良，泯雀角鼠牙之衅，绝～之端，不惊不扰，民得宽然，各尽地方。《花月痕》第五十回\n			'),
(2647, '0:4:0', '狼吞虎咽', '\n【 láng　tūn　hǔ　yàn 】\n			', '\n形容吃东西又猛又急的样子。\n			', '\n明·凌濛初《初刻拍案惊奇·刘东山夸技顺城门》：“十人自来吃酒……须臾之间，狼飧虎咽，算来吃够有六七十斤肉。”\n			', '\n走了这半日，肚中饥饿，～吃了一回。（清·陈忱《水浒后传》第五回）\n			'),
(2648, '0:4:0', '狼突豕窜', '\n【 láng　tū　shǐ　cuàn 】\n			', '\n象狼那样奔跑，象猪那样冲撞。形容成群的坏人乱冲乱撞，到处搔扰。同“狼奔豕突”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2649, '0:4:0', '狼贪鼠窃', '\n【 láng　tān　shǔ　qiè 】\n			', '\n如狼那样贪狠；似鼠那样惯窃。常形容敌人贪狠卑鄙。\n			', '\n明·于谦《出塞》诗：“瓦刺穷胡真犬豕，敢向边疆挠赤子。狼贪鼠窃去复来，不解偷生求速死。”\n			', '\n暂无\n			'),
(2650, '0:4:0', '狼心狗肺', '\n【 láng　xīn　gǒu　fèi 】\n			', '\n形容心肠象狼和狗一样凶恶狠毒。\n			', '\n明·冯梦龙《醒世恒言》卷三十：“那知这贼子恁般狼心狗肺，负恩忘义。”\n			', '\n暂无\n			'),
(2651, '0:4:0', '狼心狗行', '\n【 láng　xīn　gǒu　xíng 】\n			', '\n心肠似狼，行为如狗。比喻贪婪凶狠，卑鄙无耻。\n			', '\n明·罗贯中《三国演义》第七回：“昔日以汝为忠义，推为盟主；今之所为，真狼心狗行之徒，有何面目立于世间！”\n			', '\n暂无\n			'),
(2652, '0:4:0', '狼烟大话', '\n【 láng　yān　dà　huà 】\n			', '\n漫无边际的吹牛话。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2653, '0:4:0', '狼眼鼠眉', '\n【 láng　yǎn　shǔ　méi 】\n			', '\n形容人相貌凶恶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2654, '0:4:0', '狼烟四起', '\n【 láng　yān　sì　qǐ 】\n			', '\n狼烟：古代边防报警时烧狼粪腾起的烟。四处都是报警的烟火，指边疆不平静。\n			', '\n唐·段成式《酉阳杂俎·毛篇》：“狼粪烟直上，烽火用之。”\n			', '\n这火筒节节生枝，能吹得～；实在放他不得。（清·钱彩《说岳全传》第七十回）\n			'),
(2655, '0:4:0', '狼羊同饲', '\n【 láng　yáng　tóng　sì 】\n			', '\n比喻把坏人同好人一样对待。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2656, '0:4:0', '狼子兽心', '\n【 láng　zǐ　shòu　xīn 】\n			', '\n比喻凶暴的人用心残忍，有如野兽。\n			', '\n《晋书·虞预传》：“然狼子兽心，轻薄易动。”\n			', '\n暂无\n			'),
(2657, '0:4:0', '狼子野心', '\n【 láng　zǐ　yě　xīn 】\n			', '\n狼子：狼崽子。狼崽子虽幼，却有凶恶的本性。比喻凶暴的人居心狠毒，习性难改。\n			', '\n《左传·宣公四年》：“谚曰：狼子野心。是乃狼也，其可畜乎？”\n			', '\n哪晓得这班降兵，本来原是游勇出身，～，哪里肯安安顿顿的守著规矩过日子，便渐渐的放肆起来。（清·张春帆《宦海》第八回）\n			'),
(2658, '0:4:0', '前门拒虎，后门进狼', '\n【 qián　mén　jù　hǔ，hòu　mén　jìn　láng 】\n			', '\n比喻赶走了一个敌人，又来了一个敌人。\n			', '\n明·李贽《史纲评要·周纪》：“‘秦败三晋之师于石门。赐以黼黻之服。’前门拒虎，后门进狼。未知是祸是福。”\n			', '\n暂无\n			'),
(2659, '0:4:0', '前门去虎，后门进狼', '\n【 qián　mén　qù　hǔ，hòu　mén　jìn　láng 】\n			', '\n比喻赶走了一个敌人，又来了一个敌人。同“前门拒虎，后门进狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2660, '0:4:0', '前怕狼，后怕虎', '\n【 qián　pà　láng，hòu　pà　hǔ 】\n			', '\n比喻胆小怕事，顾虑太多。\n			', '\n明·冯惟敏《朝天子·感述》：“磊落英雄，清修人物，前怕狼后怕虎。设谋，使毒，只待把忠良妒。”\n			', '\n他明白，上了年级的人都是～，事事有顾虑。（周立波《暴风骤雨》一）\n			'),
(2661, '0:4:0', '驱羊战狼', '\n【 qū　yáng　zhàn　láng 】\n			', '\n比喻以弱击强。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2662, '0:4:0', '如狼牧羊', '\n【 rú　láng　mù　yáng 】\n			', '\n如同狼放养羊一般。比喻官吏残酷地欺压人民。\n			', '\n《史记·酷吏列传》：“宁成为济南都尉，其治如狼牧羊。”\n			', '\n暂无\n			'),
(2663, '0:4:0', '如狼似虎', '\n【 rú　láng　sì　hǔ 】\n			', '\n象狼和虎一样凶狠。比喻非常凶暴残忍。\n			', '\n《尉缭子·武议》：“一人之兵，如狼似虎，如风如雨，如雷如霆，震震冥冥，天下皆惊。”\n			', '\n只听得高声大语，开门看～。（元·杨显之《潇湘雨》第四折）\n			'),
(2664, '0:4:0', '如狼如虎', '\n【 rú　láng　sì　hǔ 】\n			', '\n形容勇猛、猛烈。\n			', '\n《尉缭子·武议》：“一人之兵，如狼如虎，如风如雨，如雷如霆，震震冥冥，天下皆惊。”\n			', '\n文忠凛然端坐，价前～的将官，排列两行，就如追魂夺魄的一般，甚是畏惧。\n			'),
(2665, '0:4:0', '鼠窜狼奔', '\n【 shǔ　cuàn　láng　bēn 】\n			', '\n形容狼狈逃跑的情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2666, '0:4:0', '豕窜狼逋', '\n【 shǐ　cuàn　láng　bū 】\n			', '\n狼狈逃窜的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2667, '0:4:0', '声名狼藉', '\n【 shēng　míng　láng　jí 】\n			', '\n声名：名誉；狼藉：杂乱不堪。名声败坏到了极点。\n			', '\n《史记·蒙恬列传》：“言其恶声狼藉，布于诸国。”\n			', '\n因汪太史平日～，最不见重于官场，日前新督帅参劾劣绅十七名，实以汪某居首。（清·黄小配《廿载繁华梦》第三十三回）\n			'),
(2668, '0:4:0', '豕突狼奔', '\n【 shǐ　tū　láng　bēn 】\n			', '\n豕：猪；突：猛冲。象猪那样冲撞，象狼那样奔跑。形容成群的坏人乱冲乱撞，到处搔扰。\n			', '\n明·归庄《万古愁》：“有几个狼奔豕突的燕和赵，有几个狗屠驴贩的奴和盗。”\n			', '\n暂无\n			'),
(2669, '0:4:0', '鼠心狼肺', '\n【 shǔ　xīn　láng　fèi 】\n			', '\n形容心肠阴险狠毒。\n			', '\n清·郑燮《后孤儿行》：“丈丈翁，得钱归，鼠心狼肺，侧目吞肥，千谋万算伏危机。”\n			', '\n暂无\n			'),
(2670, '0:4:0', '使羊将狼', '\n【 shǐ　yáng　jiàng　láng 】\n			', '\n将：统率，指挥。派羊去指挥狼。比喻不足以统率指挥。也比喻使仁厚的人去驾驭强横而有野心的人，这要坏事。\n			', '\n《史记·留侯世家》：“太子所与俱诸将，皆尝与上定天下枭将也，今使太子将之，此无异使羊将狼也。”\n			', '\n暂无\n			'),
(2671, '0:4:0', '贪污狼藉', '\n【 tān　wū　láng　jí 】\n			', '\n谓贪财纳贿，行为不检，声名败坏。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2672, '0:4:0', '枭视狼顾', '\n【 xiāo　shì　láng　gù 】\n			', '\n如枭盯视，如狼频顾。形容行动警惕，有所畏忌。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2673, '0:4:0', '引虎拒狼', '\n【 yǐn　hǔ　jù　láng 】\n			', '\n比喻引进另一种恶势力来抗拒原来的恶势力，其祸患将更甚。亦作“引狼拒虎”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2674, '0:4:0', '羊狠狼贪', '\n【 yáng　hěn　láng　tān 】\n			', '\n狠：凶狠。原指为人凶狠，争夺权势。后比喻贪官污吏的残酷剥削。\n			', '\n《史记·项羽本纪》：“因下令军中曰：‘猛如虎，很如羊，贪如狼，强不可使者，皆斩之。’”\n			', '\n暂无\n			'),
(2675, '0:4:0', '引狼拒虎', '\n【 yǐn　láng　jù　hǔ 】\n			', '\n比喻引进另一种恶势力来抗拒原来的恶势力，其祸患将更甚。同“引虎拒狼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2676, '0:4:0', '引狼入室', '\n【 yǐn　láng　rù　shì 】\n			', '\n引：招引。把狼招引到室内。比喻把坏人或敌人引入内部。\n			', '\n元·张国宾《罗李郎》第一折：“我不是引的狼来屋里窝，寻的蚰蜒钻耳朵。”\n			', '\n再娶者，皆～耳，况将于野合逃窜中求贤妇哉。（清·蒲松龄《聊斋志异·黎氏》）\n			'),
(2677, '0:4:0', '引狼自卫', '\n【 yǐn　láng　zì　wèi 】\n			', '\n犹言引虎自卫。比喻企图依仗恶人，结果反受其害。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2678, '0:4:0', '鹰视狼步', '\n【 yīng　shì　láng　bù 】\n			', '\n象鹰那样看东西，象狼那样走路。形容为人阴险狠毒。\n			', '\n汉·赵晔《吴越春秋·勾践伐吴外传》：“夫越王为人，长颈鸟喙，鹰视狼步，可以共患难，而不可共处乐，可与履危，不可与安。”\n			', '\n暂无\n			'),
(2679, '0:4:0', '鹰视狼顾', '\n【 yīng　shì　láng　gù 】\n			', '\n形容目光锐利，为人狠戾。\n			', '\n明·罗贯中《三国演义》第九十一回：“司马懿鹰视狼顾，不可付以兵权；久必为国家大祸。”\n			', '\n袁世凯～，久蓄逆谋，故景月汀谓其为仲达第二。\n			'),
(2680, '0:4:0', '鹰睃狼顾', '\n【 yīng　suō　láng　gù 】\n			', '\n形容目光锐利，为人狠戾。同“鹰视狼顾”。\n			', '\n《天雨花》第二一回：“鹰睃狼顾为非善，柳黛蛾眉杀气横。”\n			', '\n暂无\n			'),
(2681, '0:4:0', '鹰挚狼食', '\n【 yīng　zhì　láng　shí 】\n			', '\n比喻凶狠地攫取和吞没。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2682, '0:4:0', '赃贿狼籍', '\n【 zāng　huì　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n宋·司马光《资治通鉴·唐中宗景龙三年》：“中书侍郎兼知吏部侍郎同平章事崔湜、吏部侍郎同平章事郑愔俱掌铨衡，倾附势要，赃贿狼籍，数外留人，授拟不中，逆用三年阙，选法大坏。”\n			', '\n暂无\n			'),
(2683, '0:4:0', '赃贿狼藉', '\n【 zāng　huì　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。亦作“赃贿狼籍”。\n			', '\n《陈书·蔡景历传》：“天嘉之世，赃贿狼藉，圣恩录用，许以更鸣，裂壤崇阶，不远斯复。”\n			', '\n……崔湜、……郑愔俱掌铨衡，倾附势要，赃贿狼籍，数外留人，授拟不足，逆用三年阙，选法大坏。\n			'),
(2684, '0:4:0', '赃秽狼藉', '\n【 zāng　huì　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n《古今小说·沈小霞相会出师表》：“一到京师，看见严家赃秽狼藉，心中甚怒。”\n			', '\n暂无\n			'),
(2685, '0:4:0', '赃货狼藉', '\n【 zāng　huò　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n《宋书·刘穆之传》：“穆之中子式之字延叔，通易好士……在任赃货狼藉，扬州刺史王弘遣从事检校。”\n			', '\n暂无\n			'),
(2686, '0:4:0', '鸷狠狼戾', '\n【 zhì　hěn　láng　lì 】\n			', '\n形容凶狠乖戾。\n			', '\n元·脱脱《金史》卷一百十一：“塔为人鸷狠狼戾，好结小人，不听朝廷节制。”\n			', '\n暂无\n			'),
(2687, '0:4:0', '鸷击狼噬', '\n【 zhì　jī　láng　shì 】\n			', '\n指凶狠地残害人。\n			', '\n《新唐书·王鉷传》：“林甫方兴大狱，撼东宫，诛不附己者，以鉷险刻，可动以利，故倚之，使鸷击狼噬。”\n			', '\n暂无\n			'),
(2688, '0:4:0', '鹯视狼顾', '\n【 zhān　shì　láng　gù 】\n			', '\n指如同鹯狼视物。形容目光贪婪。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2689, '0:4:0', '赃私狼籍', '\n【 zāng　sī　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n《晋书·孙盛传》：“温得盛笺遣从事重案之，赃私狼籍，槛车收盛到州，舍而不罪。”\n			', '\n暂无\n			'),
(2690, '0:4:0', '赃私狼藉', '\n【 zāng　sī　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n《晋书·会稽文孝王道子传》：“[茹千秋]其子寿龄为乐安令，赃私狼藉，畏法奔逃，竟无罪恶罚，傲然还县。”\n			', '\n暂无\n			'),
(2691, '0:4:0', '脏污狼藉', '\n【 zāng　wū　láng　jí 】\n			', '\n贪污、受贿，名声败坏，不可收拾。\n			', '\n《三国志·魏书·武帝纪》：“长吏多阿富贵戚，脏污狼藉。”\n			', '\n暂无\n			'),
(2692, '0:4:0', '赃污狼籍', '\n【 zāng　wū　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n元黄氏《湖广等处行中书省平章故事刘公神道碑》：“要束木之党八人为道州路总管，败政害民，赃污狼籍。”\n			', '\n暂无\n			'),
(2693, '0:4:0', '赃污狼藉', '\n【 zāng　wū　láng　jí 】\n			', '\n指贪污受贿，行为不检，名声败坏。\n			', '\n《三国志·魏志武帝纪》：“长吏多阿附贵戚，赃污狼藉。”\n			', '\n中书舍人于尹躬，其弟皋谟，～。\n			'),
(2694, '0:4:1', '飞熊入梦', '\n【 fēi　xióng　rù　mèng 】\n			', '\n原指周文王梦飞熊而得太公望。后比喻圣主得贤臣的征兆。\n			', '\n《史记·齐太公世家》：“西伯将出猎，卜之，曰‘所获非龙非彲，非虎非罴；所获霸王之辅’。”\n			', '\n昔商高宗曾有～，得傅说于版筑之间。（明·许仲琳《封神演义》第二十三回）\n			'),
(2695, '0:4:1', '虎背熊腰', '\n【 hǔ　bèi　xióng　yāo 】\n			', '\n形容人身体魁梧健壮。\n			', '\n元·无名氏《飞刀对箭》：“这厮倒是一条好汉，狗背驴腰的，哦，是虎背熊腰。”\n			', '\n一个面如重枣，一个脸似黄金，都是～，相貌非凡。（清·李汝珍《镜花缘》第九十五回）\n			'),
(2696, '0:4:1', '画荻丸熊', '\n【 huà　dí　wán　xióng 】\n			', '\n用以称赞母亲教子有方。\n			', '\n宋·欧阳修幼时，母郑氏以荻画地教子读书。唐·柳仲郢幼嗜学，母韩氏用熊胆和制丸子，使郢夜咀咽以提神醒脑。清·章学诚《文史通义·古文十弊》：“抑思善相夫者，何必尽识鹿车鸿案？善教子者，岂皆熟记画荻和丸？”\n			', '\n暂无\n			'),
(2697, '0:4:1', '虎体熊腰', '\n【 hǔ　tǐ　xióng　yāo 】\n			', '\n形容身材魁梧，体格健壮。\n			', '\n明·罗贯中《三国演义》第二回：“为首一将，生得广额阔面，虎体熊腰；吴郡富春人也，姓孙，名坚，字文台，乃孙武子之后。”\n			', '\n暂无\n			'),
(2698, '0:4:1', '梦熊之喜', '\n【 mèng　xióng　zhī　xǐ 】\n			', '\n梦熊：指生男孩。祝贺生男孩之语。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2699, '0:4:1', '柙虎樊熊', '\n【 xiá　hǔ　fán　xióng 】\n			', '\n柙中的虎，樊内的熊。比喻被囚的恶人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2700, '0:4:1', '熊经鸱顾', '\n【 xióng　jīng　chī　gù 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸱之回顾。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2701, '0:4:1', '熊据虎跱', '\n【 xióng　jù　hǔ　shēn 】\n			', '\n比喻群雄割据的形势。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2702, '0:4:1', '熊经鸟申', '\n【 xióng　jīng　niǎo　shēn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2703, '0:4:1', '熊经鸟伸', '\n【 xióng　jīng　niǎo　shēn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2704, '0:4:1', '熊经鸟曳', '\n【 xióng　jīng　niǎo　yè 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2705, '0:4:1', '熊经鸟引', '\n【 xióng　jīng　niǎo　yǐn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2706, '0:4:1', '熊罴百万', '\n【 xióng　pí　bǎi　wàn 】\n			', '\n熊罴：两种猛兽，比喻勇猛的武士。勇猛的武士成千上万。形容军队人多将广，英勇善战。\n			', '\n宋·王迈《观猎行》：“汝不闻去岁淮甸间，熊罴百万临危堞。”\n			', '\n暂无\n			'),
(2707, '0:4:1', '熊罴入梦', '\n【 xióng　pí　rù　mèng 】\n			', '\n旧时用于祝人生子。\n			', '\n《诗经·小雅·斯干》：“维熊维罴，男子之祥。”\n			', '\n已见～，行看老蚌生珠。（明·赵弼《蓬莱先生传》）\n			'),
(2708, '0:4:1', '熊罴之士', '\n【 xióng　pí　zhī　shì 】\n			', '\n比喻勇士。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2709, '0:4:1', '熊韬豹略', '\n【 xióng　tāo　bào　lüè 】\n			', '\n比喻高妙的用兵谋略。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2710, '0:4:1', '熊心豹胆', '\n【 xióng　xīn　bào　dǎn 】\n			', '\n比喻非常胆大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2711, '0:4:1', '熊腰虎背', '\n【 xióng　yāo　hǔ　bèi 】\n			', '\n腰粗壮如熊，背宽厚如虎。形容人身体魁梧健壮。\n			', '\n元·无名氏《飞刀对箭》：“这厮倒是一条好汉，狗背驴腰的，哦，是虎背熊腰。”\n			', '\n视之，身长九尺，面黑睛黄，～。\n			'),
(2712, '0:4:1', '鱼与熊掌', '\n【 yú　yǔ　xióng　zhǎng 】\n			', '\n比喻俱为所欲，难于取舍之物。\n			', '\n语本《孟子·告子上》：“鱼我所欲也，熊掌亦我所欲也；二者不可得兼，舍鱼而取熊掌者也。”\n			', '\n暂无\n			'),
(2713, '0:4:2', '阿狗阿猫', '\n【 ā　gǒu　ā　māo 】\n			', '\n旧时人们常用的小名。引申为任何轻贱的，不值得重视的人或著作。\n			', '\n鲁迅《我们要批评家》：“然而新的批评家不开口，类似批评家之流便趁势一笔抹杀：‘阿狗阿猫’。”\n			', '\n暂无\n			'),
(2714, '0:4:2', '阿猫阿狗', '\n【 ā　māo　ā　gǒu 】\n			', '\n旧时人们常用的小名。引申为任何轻贱的，不值得重视的人或著作。\n			', '\n鲁迅《我的第一个师父》：“这和名孩子为阿猫阿狗，完全是一样的意思：容易养大。”\n			', '\n在德国无论～见面，一律互相举手高喊：“希特勒万岁”。\n			'),
(2715, '0:4:2', '猫哭老鼠', '\n【 māo　kū　lǎo　shǔ 】\n			', '\n比喻假慈悲。\n			', '\n清·翟灏《通俗编·俚语对句》：“鸭见砻糠空欢喜，猫哭老鼠假慈悲。”\n			', '\n暂无\n			'),
(2716, '0:4:2', '猫鼠同处', '\n【 māo　shǔ　tóng　chǔ 】\n			', '\n比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。同“猫鼠同眠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2717, '0:4:2', '猫鼠同眠', '\n【 māo　shǔ　tóng　mián 】\n			', '\n猫同老鼠睡在一起。比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。\n			', '\n《新唐书·五行志》：“龙朔元年十一月，洛州猫鼠同处。鼠隐伏，象盗窃；猫职捕啮，而反与鼠同，象司盗者废职容奸。”\n			', '\n都是谗言佞言，一个个～。（明·李开先《林冲宝剑记》第六出）\n			'),
(2718, '0:4:2', '猫鼠同乳', '\n【 māo　shǔ　tóng　rǔ 】\n			', '\n比喻官吏失职，包庇下属干坏事。也比喻上下狼狈为奸。同“猫鼠同眠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2719, '0:4:2', '猫噬鹦鹉', '\n【 māo　shì　yīng　wǔ 】\n			', '\n比喻排挤好人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2720, '0:4:2', '争猫丢牛', '\n【 zhēng　māo　diū　niú 】\n			', '\n比喻贪小失大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2721, '0:4:2', '照猫画虎', '\n【 zhào　māo　huà　hǔ 】\n			', '\n比喻照着样子模仿。\n			', '\n<span class="C999">暂无</span>\n			', '\n这大相公聪明得很，他是～，一见即会套的人。（《歧路灯》第十一回）\n			'),
(2722, '0:4:2', '捉鼠拿猫', '\n【 zhuō　shǔ　ná　māo 】\n			', '\n拿：抓住。捉住老鼠和猫。比喻能制服敌手。\n			', '\n元·无名氏《射柳捶丸》第一折：“若论我腹中的兵书，委的有神鬼不测之机，有捉鼠拿猫之法。”\n			', '\n暂无\n			'),
(2723, '0:4:3', '标枝野鹿', '\n【 biāo　zhī　yě　lù 】\n			', '\n标枝，树梢之枝，比喻上古之世在上之君恬淡无为；野鹿，比喻在下之民放而自得。后指太古时代。\n			', '\n《庄子·天地》：“至治之世，不尚贤，不使能，上如标枝，民如野鹿。”\n			', '\n况欲以过门不入、日昃不食之世，反诸～，其不为西晋者几希？\n			'),
(2724, '0:4:3', '铤鹿走险', '\n【 dìng　lù　zǒu　xiǎn 】\n			', '\n①指在无路可走的时候采取冒险行动。同“铤而走险”。②指因无路可走而采取冒险行动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2725, '0:4:3', '覆鹿寻蕉', '\n【 fù　lù　xún　jiāo 】\n			', '\n覆：遮盖；蕉：同“樵”，柴。比喻把真事看作梦幻而一再失误。\n			', '\n战国·郑·列御寇《列子·周穆王》：“郑人有薪于野者，……，覆之以蕉，不胜其喜。”\n			', '\n乌轮兔驾迅长空，～恍梦中。\n			'),
(2726, '0:4:3', '共挽鹿车', '\n【 gòng　wǎn　lù　chē 】\n			', '\n挽：拉；鹿车：古时的一种小车。旧时称赞夫妻同心，安贫乐道。\n			', '\n《后汉书·鲍宣妻传》：“妻乃悉归侍御服饰，更著短布裳，与宣共挽鹿车归乡里。”\n			', '\n暂无\n			'),
(2727, '0:4:3', '鸿案鹿车', '\n【 hóng　àn　lù　chē 】\n			', '\n比喻夫妻之间相互尊重，相互体贴，同甘共苦。\n			', '\n鸿案：《后汉书·梁鸿传》载有梁鸿之妻举案齐眉的故事，后用以指夫妻相敬如宾。鹿车：《后汉书·鲍宣妻传》载有鲍宣与妻共驾鹿车归乡的故事。后用以指夫妻同甘共苦。\n			', '\n暂无\n			'),
(2728, '0:4:3', '即鹿无虞', '\n【 jí　lù　wú　yú 】\n			', '\n原意是进山打鹿，没有熟悉地形和鹿性的虞官帮助，那是白费气力。后比喻做事如条件不成熟就草率行事，必定劳而无功。\n			', '\n《周易·屯》：“即鹿无虞，惟入于林中；君子几，不如舍，往吝。”\n			', '\n暂无\n			'),
(2729, '0:4:3', '鹿车共挽', '\n【 lù　chē　gòng　wǎn 】\n			', '\n鹿车：古时的一种小车；挽：拉。旧时称赞夫妻同心，安贫乐道。\n			', '\n《后汉书·鲍宣妻传》：“妻乃悉归侍御服饰，更著短布裳，与宣共挽鹿车归乡里。”\n			', '\n暂无\n			'),
(2730, '0:4:3', '鹿皮苍璧', '\n【 lù　pí　cāng　bì 】\n			', '\n形容本末不相称。\n			', '\n《汉书·食货志下》：“上（汉武帝）与汤（张汤）既造白鹿皮币，问异（颜异）。异曰：‘今王侯朝贺以仓璧，直数千，而其皮荐反四十万，本末不相称。’”\n			', '\n烟薰屋漏装玉轴，～知谁贤。\n			'),
(2731, '0:4:3', '鹿裘不完', '\n【 lù　qiú　bù　wán 】\n			', '\n比喻检朴节俭。\n			', '\n《汉书·虞延传》：“昔晏婴辅齐，鹿裘不完。”\n			', '\n暂无\n			'),
(2732, '0:4:3', '鹿死不择音', '\n【 lù　sǐ　bù　zé　yīn 】\n			', '\n比喻只求能够安身，并不选择地方。\n			', '\n《左传·文公十七年》：“‘鹿死不择音。’小国之事大国也，德，则其人也；不德，则其鹿也。铤而走险，急何能择。”\n			', '\n暂无\n			'),
(2733, '0:4:3', '鹿死不择荫', '\n【 lù　sǐ　bù　zé　yīn 】\n			', '\n比喻只求安身，不择处所。亦比喻情况危急，无法慎重考虑。\n			', '\n见“鹿死不择音”。\n			', '\n不则，职之重命，必且重于官，～，微臣有褫，无以加焉，在台台必有大不忍者。\n			'),
(2734, '0:4:3', '鹿死谁手', '\n【 lù　sǐ　shuí　shǒu 】\n			', '\n原比喻不知政权会落在谁的手里。现在也泛指在竞赛中不知谁会取得最后的胜利。\n			', '\n《晋书·石勒载记下》：“朕若逢高皇，当北面而事之，与韩、彭鞭而争先耳；脱遇光武，当并驱于中原，未知鹿死谁手。”\n			', '\n古人把争天下比做“逐鹿中原”。也只有稳据中原，才能定～。（姚雪垠《李自成》第二卷第四十七章）\n			'),
(2735, '0:4:3', '鹿驯豕暴', '\n【 lù　xùn　shǐ　bào 】\n			', '\n意指一会儿像鹿一样柔驯，一会儿像猪一样凶暴。形容狡诈。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2736, '0:4:3', '鹿走苏台', '\n【 lù　zǒu　sū　tái 】\n			', '\n比喻国家败亡，宫殿荒废。\n			', '\n《汉书·伍被传》：“臣今见麋鹿游姑苏之台也。”\n			', '\n暂无\n			'),
(2737, '0:4:3', '马鹿异形', '\n【 mǎ　lù　yì　xíng 】\n			', '\n用赵高指鹿为马的故事，比喻颠倒是非。\n			', '\n《后汉书·崔琦传》：“反复欲钳塞士口，杜蔽主听。将使玄黄改色，马鹿易形乎？”\n			', '\n暂无\n			'),
(2738, '0:4:3', '马鹿易形', '\n【 mǎ　lù　yì　xíng 】\n			', '\n出自赵高指鹿为马的故事，比喻颠倒是非、混淆黑白。\n			', '\n南朝·宋·范晔《后汉书·文苑传上·崔琦》：“不能结纳贞良，以救祸败，反复欲钳塞士口，杜蔽主听，将欲使玄黄改色，马鹿易形乎？”\n			', '\n暂无\n			'),
(2739, '0:4:3', '秦失其鹿', '\n【 qín　shī　qí　lù 】\n			', '\n鹿：喻指帝位。比喻失去帝位。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2740, '0:4:3', '群雄逐鹿', '\n【 qún　xióng　zhú　lù 】\n			', '\n群雄：旧指许多有军事势力的人。逐鹿：比喻争夺帝王之位。形容各派势力争夺最高统治地位。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2741, '0:4:3', '权移马鹿', '\n【 quán　yí　mǎ　lù 】\n			', '\n指恃权专横跋扈，任意颠倒是非。\n			', '\n语出秦·赵高指鹿为马事。\n			', '\n口变淄素，～，山鬼昼舞，愁魂夜哭，如得其情，片言折狱。\n			'),
(2742, '0:4:3', '挺鹿走险', '\n【 tǐng　lù　zǒu　xiǎn 】\n			', '\n挺而走险。指事急之时，被迫冒险行事。\n			', '\n语出《左传·文公十七年》：“古人有言曰……‘鹿死不择音（荫）’小国之事大国也，德则其人也，不德则其鹿也，铤而走险，急何能择。”\n			', '\n暂无\n			'),
(2743, '0:4:3', '小鹿触心头', '\n【 xiǎo　lù　chù　xīn　tóu 】\n			', '\n形容因为害怕而心脏急剧地跳动。\n			', '\n清·翟灏《通俗编·兽畜》：“为帝迫困于斯，见之汗湿衣襟，若小鹿之触吾心头。”\n			', '\n暂无\n			'),
(2744, '0:4:3', '心头鹿撞', '\n【 xīn　tóu　lù　zhuàng 】\n			', '\n形容惊慌或激动时心跳剧烈。同“心头撞鹿”。\n			', '\n《负曝闲谈》第九回：“不要说是看见了和尚头才担心事，就是看见了天生的禿子，也觉得心头小鹿撞个不住。”\n			', '\n这托名李双双的文弱少年果然是吕四娘！唐晓澜又喜又惊，～，跳个不停！\n			'),
(2745, '0:4:3', '心头撞鹿', '\n【 xīn　tóu　zhuàng　lù 】\n			', '\n心里像有小鹿在撞击。形容惊慌或激动时心跳剧烈。\n			', '\n明·施耐庵《水浒传》第一○一回：“王庆看到好处，不觉心头撞鹿，骨软筋麻，好便似雪狮子向火，霎时间酥了半边。”\n			', '\n暂无\n			'),
(2746, '0:4:3', '以鹿为马', '\n【 yǐ　lù　wéi　mǎ 】\n			', '\n把鹿说成马。比喻故意颠倒是非。\n			', '\n汉·陆贾《新语·辨惑》：“秦二世之时，赵高驾鹿而从行，王曰:‘丞相何为驾鹿？’高曰:‘马也。’王曰:‘丞相误邪，以鹿为马也。’高曰:‘乃马也。陛下以臣之言为不然，愿问群臣。’于是乃问群臣，群臣半言马半言鹿。”\n			', '\n若论不直，其粗至於～，也是不直。\n			'),
(2747, '0:4:3', '獐麇马鹿', '\n【 zhāng　jūn　mǎ　lù 】\n			', '\n比喻举动匆忙慌乱的人。\n			', '\n《西湖志余》卷二十五：“杭州人言举止仓皇者曰獐麇马鹿，盖四物善骇，见人则跳跃自窜。”\n			', '\n暂无\n			'),
(2748, '0:4:3', '指鹿为马', '\n【 zhǐ　lù　wéi　mǎ 】\n			', '\n指着鹿，说是马。比喻故意颠倒黑白，混淆是非。\n			', '\n《史记·秦始皇本纪》：“赵高欲为乱，恐群臣不听，乃先设验，持鹿献于二世，曰：‘马也。’二世笑曰：‘丞相误邪？谓鹿为马。’问左右，左右或默，或言马以阿顺赵高。”\n			', '\n东床已招佳婿，何似以羊易牛；西邻纵有责言，终难～。（明·冯梦龙《醒世恒言》卷七）\n			'),
(2749, '0:4:3', '指鹿作马', '\n【 zhǐ　lù　zuò　mǎ 】\n			', '\n比喻有意颠倒黑白，混淆是非。同“指鹿为马”。\n			', '\n《三国志·魏志·鲍勋传》：“大军还洛阳，曜有罪，勋奏绌遣。而曜密表勋私解邕事。昭曰：‘勋指鹿作马，收付廷尉。’”\n			', '\n暂无\n			'),
(2750, '0:4:3', '逐鹿中原', '\n【 zhú　lù　zhōng　yuán 】\n			', '\n逐：追赶；鹿：指所要围捕的对象，常比喻帝位、政权。指群雄并起，争夺天下。\n			', '\n《史记·淮阴侯列传》：“秦失其鹿，天下共逐之。”\n			', '\n三军在江、淮、河、汉之间布成“品”字形阵势，互为觭角，～，机动歼敌。（刘伯承《千里跃进大别山》）\n			'),
(2751, '0:4:3', '中原逐鹿', '\n【 zhōng　yuán　zhú　lù 】\n			', '\n指群雄并起，争夺天下。\n			', '\n《史记·淮阴侯列传》：“秦失其鹿，天下共逐之。”\n			', '\n暂无\n			'),
(2752, '0:4:4', '白鱼赤乌', '\n【 bái　yú　chì　wū 】\n			', '\n为祥瑞之兆。\n			', '\n《史记·周本纪》：“武王渡河，中流，白鱼跃入王舟中，武王俯取以祭。既渡，有火自上复于下，至于王屋，流为乌，其色赤，其声魄云。”\n			', '\n～之符，黄金紫玉之瑞，事丰奇伟，辞富膏腴，无益经典而有助文章。\n			'),
(2753, '0:4:4', '白鱼登舟', '\n【 bái　yú　dēng　zhōu 】\n			', '\n为殷亡周兴之兆。同“白鱼入舟”。\n			', '\n《汉书·终军传》：“盖六鶂退飞，逆也；白鱼登舟，顺也。”颜师古注引臣瓒曰：“谓武王伐殷而鱼入王舟，象征而必获，故曰顺也。”\n			', '\n暂无\n			'),
(2754, '0:4:4', '鲍鱼之次', '\n【 bào　yú　zhī　cì 】\n			', '\n卖咸鱼的店铺。鱼常腐臭，因以喻恶人之所或小人聚集之地。亦作“鲍鱼之次”。\n			', '\n《大戴礼记·曾子疾病》：“与君子游，苾乎如入兰芷之室，久而不闻，则与之化矣；与小人游，贷乎如入鲍鱼之次，久而不闻，则与之化矣。”王聘珍解诂：“次，若今市亭然。”\n			', '\n暂无\n			'),
(2755, '0:4:4', '城门失火，殃及池鱼', '\n【 chéng　mén　shī　huǒ，yāng　jí　chí　yú 】\n			', '\n城门失火，大家都到护城河取水，水用完了，鱼也死了。比喻因受连累而遭到损失或祸害。\n			', '\n北齐·杜弼《檄梁文》：“但恐楚国亡猿，祸延林木，城门失火，殃及池鱼。”\n			', '\n我是个平凡的人，不幸生在不平凡的时代，“～”，无端惹出许多是非。（柯灵《回看血泪相和流》）\n			'),
(2756, '0:4:4', '城门鱼殃', '\n【 chéng　mén　yú　yāng 】\n			', '\n城门失火，大家都到护城河取水，水用完了，鱼也死了。比喻因受连累而遭到损失或祸害。\n			', '\n明·李东阳《尹公墓志铭》：“城门鱼殃，昆岗玉碎。”\n			', '\n暂无\n			'),
(2757, '0:4:4', '丛雀渊鱼', '\n【 cóng　què　yuān　yú 】\n			', '\n比喻不行善政，等于把老百姓赶到敌人方面去。\n			', '\n语出《孟子·离娄上》：“为渊驱鱼者，獭也；为丛驱爵（雀）者，鹯也；为汤武驱民者，桀与纣也。”\n			', '\n能办交涉之人日益少，忍辱含垢，民气日靡，～，民心渐去。\n			'),
(2758, '0:4:4', '池鱼林木', '\n【 chí　yú　lín　mù 】\n			', '\n比喻无辜而受连累，遭祸害。\n			', '\n《淮南子·说山训》：“楚王亡其猿，而林木为之残；宋君亡其珠，池中鱼为之殚。”\n			', '\n耿藩问罪之师，旦暮即至，～之殃，在所不免。\n			'),
(2759, '0:4:4', '池鱼笼鸟', '\n【 chí　yú　lóng　niǎo 】\n			', '\n池里的鱼，笼里的鸟。比喻受束缚而失去自由的人。\n			', '\n晋·潘岳《秋兴赋》：“譬犹池鱼笼鸟，有江湖山薮之思。”\n			', '\n暂无\n			'),
(2760, '0:4:4', '沉鱼落雁', '\n【 chén　yú　luò　yàn 】\n			', '\n鱼见之沉入水底，雁见之降落沙洲。形容女子容貌美丽。\n			', '\n《庄子·齐物论》：“毛嫱、丽姬，人之所美也；鱼见之深入，鸟见之高飞，麋鹿见之决骤，四者孰知天下之正色哉？”\n			', '\n他二人长的一个是～之容，一个是闭月羞花之貌。（清·李宝嘉《官场现形记》第十二回）\n			'),
(2761, '0:4:4', '池鱼幕燕', '\n【 chí　yú　mù　yàn 】\n			', '\n比喻处境危险极易遭殃的人。\n			', '\n明·刘基《驿传杭台消息石末公有诗见寄次韵奉和并寓悲感》之一：“池鱼幕燕依栖浅，轩鹤冠猴宠渥新。”\n			', '\n暂无\n			'),
(2762, '0:4:4', '池鱼堂燕', '\n【 chí　yú　táng　yàn 】\n			', '\n比喻无辜受祸。\n			', '\n清·孔尚任《桃花扇·归山》：“俺来此携琴访友，并不曾流连夜晓。无端的池鱼堂燕一时烧。”\n			', '\n暂无\n			'),
(2763, '0:4:4', '池鱼之祸', '\n【 chí　yú　zhī　huò 】\n			', '\n比喻受牵连而遭到的祸害。\n			', '\n《二刻拍案惊奇》卷二四：“道士道：‘不出三年，世运变革。地方将有兵戈大乱，不产这光景了。你快择善地而居，免受池鱼之祸。’”\n			', '\n暂无\n			'),
(2764, '0:4:4', '池鱼之虑', '\n【 chí　yú　zhī　lǜ 】\n			', '\n指担忧无端受累遭灾。\n			', '\n《上海小刀会起义史料汇编·罗店镇志》：“讹传丁国恩率大兵会剿罗店，盖以吾镇贼曾踞巢穴，人人抱池鱼之虑，一时惊惶无措，各扶老携幼避匿四乡，半皆露宿。”\n			', '\n暂无\n			'),
(2765, '0:4:4', '虫鱼之学', '\n【 chóng　yù　zhī　xué 】\n			', '\n指繁琐的考据订正。\n			', '\n唐·韩愈《读皇甫湜公安园池诗书其后》诗：“《尔雅》注虫鱼，定非磊落人。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2766, '0:4:4', '鸱张鱼烂', '\n【 chī　zhāng　yú　làn 】\n			', '\n比喻外表嚣张，内则溃烂而自行覆灭。\n			', '\n《旧唐书·僖宗纪》：“初则狐假鸱张，自谓骁雄莫敌；旋则鸟焚鱼烂，无非破败而终。”\n			', '\n是以苗志得气盈，～，不可收拾。\n			'),
(2767, '0:4:4', '弹铗无鱼', '\n【 dàn　jiá　wú　yú 】\n			', '\n铗：剑把。指处境窘困，有求于人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2768, '0:4:4', '登木求鱼', '\n【 déng　mù　qiú　yú 】\n			', '\n登：攀；木：树。爬到树上找鱼。比喻方向、方法不对，无法达到目的。\n			', '\n宋·苏辙《次韵吴厚秀才见录》：“登木求鱼知我掘，循巢觅兔笑君疏。”\n			', '\n暂无\n			'),
(2769, '0:4:4', '冻浦鱼惊', '\n【 dòng　pǔ　yú　jīng 】\n			', '\n指晋王祥卧冰求鲤事。后为孝亲之典。\n			', '\n《晋书·王祥传》：“王祥字休徵，琅邪临沂人……父母有疾，衣不解带，汤药必亲尝。母常欲生鱼，时天寒冰冻，祥解衣将剖冰求之，冰忽自解，双鲤跃出，持之而归。”\n			', '\n温席扇枕，承颜悦膝；～，寒林笋出。\n			'),
(2770, '0:4:4', '鼎鱼幕燕', '\n【 dǐng　yú　mù　yàn 】\n			', '\n宛如鼎中游动的鱼，帷幕上筑巢的燕子。比喻处于极危险境地的人或事物。\n			', '\n南朝·梁·丘迟《与陈伯之书》：“而将军鱼游于沸鼎之中，燕巢于飞幕之上，不亦惑乎。”\n			', '\n～，亡在旦夕。（《元史·外夷传》）\n			'),
(2771, '0:4:4', '得鱼忘筌', '\n【 dé　yú　wàng　quán 】\n			', '\n筌：捕鱼用的竹器。捕到了鱼，忘掉了筌。比喻事情成功以后就忘了本来依靠的东西。\n			', '\n《庄子·外物》：“荃者所以在鱼，得鱼而忘筌。”\n			', '\n暂无\n			'),
(2772, '0:4:4', '得鱼忘荃', '\n【 dé　yú　wàng　quán 】\n			', '\n比喻已达目的，即忘其凭借。“荃”亦作“筌”。\n			', '\n《庄子·外物》：“荃者所以在鱼，得鱼而忘荃。”\n			', '\n我们读书求学的，要在得意而忘言，得鱼而忘荃。\n			'),
(2773, '0:4:4', '多鱼之漏', '\n【 duō　yú　zhī　lòu 】\n			', '\n指泄漏军事机密。\n			', '\n《左传·僖公二年》：“齐寺人貂始漏师於多鱼。”杜预注：“多鱼，地名……《传》言貂於此始擅贵宠，漏洩桓公军事，为齐乱张本。”\n			', '\n约以晦日同时进袭，而汉奸有～，洋人踞城者皆预为准备。\n			'),
(2774, '0:4:4', '鳄鱼眼泪', '\n【 è　yú　yǎn　lèi 】\n			', '\n鳄鱼：一种生性凶残，捕食人、畜的爬行动物。传说鳄鱼在吞食人畜时，边吃边流眼泪。比喻恶人的假慈悲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2775, '0:4:4', '放长线钓大鱼', '\n【 fáng　cháng　xiàn　diào　dà　yú 】\n			', '\n比喻做事从长远打算，虽然不能立刻收效，但将来能得到更大的好处。\n			', '\n<span class="C999">暂无</span>\n			', '\n办这种事，要～。（罗丹《风雨的黎明》）\n			'),
(2776, '0:4:4', '釜底游鱼', '\n【 fǔ　dǐ　yóu　yú 】\n			', '\n在锅里游着的鱼。比喻处在绝境的人。也比喻即将灭亡的事物。\n			', '\n《后汉书·张纲传》：“若鱼游釜中，喘息须臾间耳。”\n			', '\n他们已是飞走路绝，恰似～，或降或死，别无他途。（姚雪垠《李自成》第一卷第十一章）\n			'),
(2777, '0:4:4', '鲂鱼赪尾', '\n【 fáng　yú　chēng　wěi 】\n			', '\n赪：红色。形容人困苦劳累，负担过重。\n			', '\n《诗·周南·汝坟》：“鲂鱼赪尾，王室如燬。”毛传：“赪，赤也；鱼劳则尾赤。”朱熹集传：“鲂尾本白而今赤，则劳甚矣。”\n			', '\n暂无\n			'),
(2778, '0:4:4', '肥鱼大肉', '\n【 féi　yú　dà　ròu 】\n			', '\n指丰盛的鱼肉菜肴。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2779, '0:4:4', '釜鱼幕燕', '\n【 fǔ　yú　mù　yàn 】\n			', '\n生活在锅里的鱼、筑巢在帷幕上的燕。比喻处境极不安全。\n			', '\n语出南朝·梁·丘迟《与陈伯之书》：“今将军鱼游於沸鼎之中，燕巢於飞幕之上，不亦惑乎？”\n			', '\n霎时间，衰草斜阳。只是～，更有何人能居安思危呢？\n			'),
(2780, '0:4:4', '放鱼入海', '\n【 fàng　yú　rù　hǎi 】\n			', '\n比喻放走敌人，留下祸根。\n			', '\n《三国演义》第四二回：“今刘备釜中之鱼，阱中之虎，若不就此时擒捉，如放鱼入海，纵虎归山矣。”\n			', '\n如果捉不住打不死，让他们逃走了，就等于～，纵虎归山。\n			'),
(2781, '0:4:4', '釜鱼甑尘', '\n【 fǔ　yú　zèng　chén 】\n			', '\n釜中生鱼，甑中生尘，比喻生活清贫。\n			', '\n清·黄宗羲《子刘子行状》：“一旦以辎重被讦于监司，夫以巡方而黩货，又何问下吏之操守，釜鱼甑尘之风，空谷于天下矣。”\n			', '\n暂无\n			'),
(2782, '0:4:4', '釜中生鱼', '\n【 fǔ　zhōng　shēng　yú 】\n			', '\n比喻生活困难，断炊已久。\n			', '\n金·元好问《寄西溪相禅师》诗：“门堪罗雀仍未害，釜欲生鱼当奈何。”\n			', '\n暂无\n			'),
(2783, '0:4:4', '釜中游鱼', '\n【 fǔ　zhōng　yóu　yú 】\n			', '\n在锅里游着的鱼。比喻处在绝境中的人。也比喻即将灭亡的事物。\n			', '\n《后汉书·张纲传》：“若鱼游釜中，喘息须臾间耳。”\n			', '\n暂无\n			'),
(2784, '0:4:4', '鳏鱼渴凤', '\n【 guān　yú　kě　fèng 】\n			', '\n比喻独身的男子急于求得配偶。\n			', '\n唐·李商隐《李夫人歌》之三：“清澄有馀幽素香，鳏鱼渴凤真珠房。”\n			', '\n～无如我，奈霎时中热，蓦地偷过。\n			'),
(2785, '0:4:4', '贯鱼之次', '\n【 guàn　yú　zhī　cì 】\n			', '\n宫中的女官依次受到宠爱。\n			', '\n《后汉书·杨赐传》：“慎贯鱼之次，无令丑女有四殆之叹，遐迩有愤怨之声。”\n			', '\n暂无\n			'),
(2786, '0:4:4', '贯鱼之序', '\n【 guàn　yú　zhī　xù 】\n			', '\n宫中的女官依次受到宠爱。同“贯鱼之次”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2787, '0:4:4', '鸿断鱼沉', '\n【 hóng　duàn　yú　chén 】\n			', '\n书信断绝，音讯全无。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2788, '0:4:4', '祸及池鱼', '\n【 huò　jí　shi　yú 】\n			', '\n犹殃及池鱼。比喻无辜波及而受害。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2789, '0:4:4', '祸近池鱼', '\n【 huò　jìn　shi　yú 】\n			', '\n犹言殃及池鱼。比喻无辜而受害。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2790, '0:4:4', '化及豚鱼', '\n【 huà　jí　tún　yú 】\n			', '\n比喻教化普及而深入。\n			', '\n语出《易·中孚》：“中孚，柔在内而刚得中，说而巽，孚，乃化邦也；豚鱼吉，信及豚鱼也。”\n			', '\n退居于洛，四海是仪，～，名闻乳儿。\n			'),
(2791, '0:4:4', '河决鱼烂', '\n【 hé　jué　yú　làn 】\n			', '\n比喻事物坏到极点，不可收拾。\n			', '\n清·王夫之《读通监论·晋武帝》：“孰如近在汾晋之间，使我不轨之士民，教猱伥虎，河决鱼烂于腹心乎？”\n			', '\n近代之文章，～，败坏而不可救者，凡以百年以来学问之缪种淫于世运，熏结于人心，袭习纶轮，酝酿发作，以至于此极也。\n			'),
(2792, '0:4:4', '狐鸣鱼书', '\n【 hú　míng　yú　shū 】\n			', '\n指起事者动员群众的措施。\n			', '\n《史记·陈涉世家》：“乃丹书帛曰‘陈胜王’，置人所罾鱼腹中。卒买鱼烹食，得鱼腹中书，固以怪之矣。又閒令吴广之次所旁丛祠中，夜篝火，狐鸣呼曰‘大楚兴，陈胜王’。”\n			', '\n如～之类，至诈为吉兆以动众。\n			'),
(2793, '0:4:4', '混水捞鱼', '\n【 hùn　shuǐ　lāo　yú 】\n			', '\n比喻乘混乱的时候从中捞取利益。同“混水摸鱼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2794, '0:4:4', '浑水摸鱼', '\n【 hún　shuǐ　mō　yú 】\n			', '\n浑水：不清的水。比喻乘混乱的时候从中捞取利益。\n			', '\n<span class="C999">暂无</span>\n			', '\n这个利欲熏心的人总想～，从中捞一把。\n			'),
(2795, '0:4:4', '涸鱼得水', '\n【 hé　yú　dé　shuǐ 】\n			', '\n涸辙之鱼得到水。比喻绝处逢生，有所凭借。\n			', '\n《新唐书·契苾何力传》：“何力被执也，或谗之帝曰：‘何力入延陀，如涸鱼得水，其脱必遽。’帝曰：‘不然。若人心如铁石，殆不背我。’”\n			', '\n暂无\n			'),
(2796, '0:4:4', '河鱼腹疾', '\n【 hé　yú　fù　jí 】\n			', '\n指腹泻。\n			', '\n《左传·宣公十二年》：“河鱼腹疾，奈何？”\n			', '\n暂无\n			'),
(2797, '0:4:4', '河鱼天雁', '\n【 hé　yú　tiān　yàn 】\n			', '\n古传鱼雁都能传递书信，后即以之借指传送书信者。\n			', '\n《二十年目睹之怪现状》第五回：“意马心猿萦梦寐，河鱼天雁托音书。”\n			', '\n暂无\n			'),
(2798, '0:4:4', '河鱼之疾', '\n【 hé　yú　zhī　jí 】\n			', '\n河鱼：腹疾的隐称，因鱼腐烂是从腹中开始而得名。指腹泻。\n			', '\n《左传·宣公十二年》：“河鱼腹疾，奈何？”\n			', '\n到韶累月，疲于人事，又苦～，少留调理乃行，益远，愈增瞻系也。\n			'),
(2799, '0:4:4', '涸辙枯鱼', '\n【 hé　zhé　kū　yú 】\n			', '\n比喻在困境中急待援救的人。同“涸辙之鲋”。\n			', '\n明·张景《飞丸记·怜儒脱难》：“吹嘘一点灵犀热，涸辙枯鱼沐浩波。”\n			', '\n暂无\n			'),
(2800, '0:4:4', '及宾有鱼', '\n【 jí　bīn　yoǔ　yú 】\n			', '\n用别人的鱼请客。比喻借机培植私人势力。\n			', '\n《周易·姤》：“包有鱼，义不及宾也。”孔颖达疏：“言有他人之物，于义不可及宾也。”\n			', '\n暂无\n			'),
(2801, '0:4:4', '姜太公钓鱼，愿者上钩', '\n【 jiāng　tài　gōng　diào　yú，yuàn　zhě　shà 】\n			', '\n比喻心甘情愿地上当。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2802, '0:4:4', '鸡头鱼刺', '\n【 jī　tóu　yú　cì 】\n			', '\n比喻轻微而不被重视的的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2803, '0:4:4', '枯鱼病鹤', '\n【 kū　yú　bìng　hè 】\n			', '\n比喻处境穷困之士。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2804, '0:4:4', '枯鱼涸辙', '\n【 kū　yú　hé　zhé 】\n			', '\n枯鱼：干鱼；涸辙：干的车辙沟。比喻陷入困境。\n			', '\n《庄子·外物》：“周昨来，有中道而呼者，周顾视车辙中，有鲋鱼焉。”\n			', '\n～暂潜踪，大鹏何日天风送。\n			'),
(2805, '0:4:4', '枯鱼衔索', '\n【 kū　yú　xián　suǒ 】\n			', '\n穿在绳上的干鱼。形容事物存在的日子已经不多。\n			', '\n《韩诗外传》卷一：“枯鱼衔索，几何不蠹？”\n			', '\n暂无\n			'),
(2806, '0:4:4', '枯鱼之肆', '\n【 kū　yú　zhī　sì 】\n			', '\n比喻无法挽救的绝境。\n			', '\n《庄子·外物》：“吾得斗升之水然活耳，君乃此言，曾不如早索我于枯鱼之肆矣。”\n			', '\n暂无\n			'),
(2807, '0:4:4', '笼鸟池鱼', '\n【 lóng　niǎo　shi　yú 】\n			', '\n关在笼里的鸟，养在池中的鱼。比喻受困失去自由的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2808, '0:4:4', '漏网之鱼', '\n【 lòu　wǎng　zhī　yú 】\n			', '\n比喻侥幸逃脱的罪犯或敌人。\n			', '\n《史记·酷吏列传序》：“网漏于吞舟之鱼。”\n			', '\n他两个忙忙如丧家之狗，急急似漏网之鱼。（元·郑廷玉《后庭花》第二折）\n			'),
(2809, '0:4:4', '鲁鱼帝虎', '\n【 lǔ　yú　dì　hǔ 】\n			', '\n指文字传抄错误。\n			', '\n晋·葛洪《抱朴子》：“谚云：‘书三写，鱼成鲁，帝成虎。’”\n			', '\n暂无\n			'),
(2810, '0:4:4', '龙阳泣鱼', '\n【 lóng　yáng　qì　yú 】\n			', '\n后以之为失宠之典。\n			', '\n《战国策·魏策四》：“魏王与龙阳君共船而钓，龙阳君得十馀鱼而涕下。……王曰：‘然则何为出涕？’曰：‘臣为王之所得鱼也。’王曰：‘何谓也？’对曰：‘臣之始得鱼也，臣甚喜，后得又益大，今臣直欲弃臣前之所得矣。……臣亦将弃矣，臣安能无涕\n			', '\n妾蒙主人恩宠无比，但恐春老花残，主上恩移宠衰，使妾有～之悲，班姬题扇之怨，奈何？\n			'),
(2811, '0:4:4', '鲤鱼跳龙门', '\n【 lǐ　yú　tiào　lóng　mén 】\n			', '\n古代传说黄河鲤鱼跳过龙门，就会变化成龙。比喻中举、升官等飞黄腾达之事。也比喻逆流前进，奋发向上。\n			', '\n《埤雅·释鱼》：“俗说鱼跃龙门，过而为龙，唯鲤或然。”\n			', '\n暂无\n			'),
(2812, '0:4:4', '鲁鱼陶阴', '\n【 lǔ　yú　táo　yīn 】\n			', '\n“鲁”和“鱼”、“陶”和“阴”字形相近易混。指传抄刊印中的文字错误。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2813, '0:4:4', '临渊羡鱼', '\n【 lín　yuān　xiàn　yú 】\n			', '\n意思是站在水边想得到鱼，不如回家去结网。比喻只有愿望而没有措施，对事情毫无好处。\n			', '\n《淮南子·说林训》：“临河而羡鱼，不如归家结网。”《汉书·董仲书传》：“临渊羡鱼，不如退而结网。”\n			', '\n古人有言曰：“～，不如退而结网。”（《汉书·董仲书传》）\n			'),
(2814, '0:4:4', '龙战鱼骇', '\n【 lóng　zhàn　yú　hài 】\n			', '\n比喻战争激烈。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2815, '0:4:4', '马如游鱼', '\n【 mǎ　rú　yóu　yú 】\n			', '\n形容人马熙熙攘攘的景象。同“马如游龙”。\n			', '\n《初学记》卷四引汉·刘桢《鲁都赋》：“日暮宴罢，车骑就衢，盖如飞鹤，马如游鱼。”\n			', '\n暂无\n			'),
(2816, '0:4:4', '幕燕鼎鱼', '\n【 mù　yàn　dǐng　yú 】\n			', '\n比喻处境极危，即将覆灭。\n			', '\n南朝·梁·丘迟《与陈伯之书》：“将军鱼游于沸鼎之中，燕巢于飞幕之上，不亦惑乎？”\n			', '\n～，偷活顷克。\n			'),
(2817, '0:4:4', '幕燕釜鱼', '\n【 mù　yàn　fǔ　yú 】\n			', '\n比喻处境极危，即将覆灭。同“幕燕鼎鱼”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2818, '0:4:4', '曼衍鱼龙', '\n【 màn　yǎn　yú　lóng 】\n			', '\n曼衍：亦作“漫衍”、“曼延”，巨兽名，古代仿照它排演百戏节目。鱼龙：古代百戏节目。古代演出的杂戏名。比喻事物的离奇变幻。亦作“鱼龙曼衍”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2819, '0:4:4', '鸟焚鱼烂', '\n【 niǎo　fén　yú　làn 】\n			', '\n指因内乱而覆亡。\n			', '\n《易·旅》：“鸟焚其巢，旅人先笑后号咷。”《公羊传·僖公十九年》：“其言梁亡何？自亡也。其自亡奈何？鱼烂而亡也。”\n			', '\n初则狐假鸱张，自谓骁雄莫敌；旋则～，无非破败而终。\n			'),
(2820, '0:4:4', '鸟惊鱼骇', '\n【 niǎo　jīng　yú　hài 】\n			', '\n像鸟、鱼那种受惊的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2821, '0:4:4', '鸟惊鱼溃', '\n【 niǎo　jīng　yú　kuì 】\n			', '\n溃：溃散。象鸟惊飞，象鱼溃散而逃。形容军队因受惊扰而乱纷纷地四下溃散。\n			', '\n《隋书·杨玄感传论》：“民为凋尽，徭戍无期，率土之心，鸟惊鱼溃。”\n			', '\n暂无\n			'),
(2822, '0:4:4', '鸟惊鱼散', '\n【 niǎo　jīng　yú　sàn 】\n			', '\n形容军队因受惊扰而乱纷纷地四下溃散。同“鸟散鱼溃”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2823, '0:4:4', '鸟散鱼溃', '\n【 niǎo　sàn　yú　kuì 】\n			', '\n溃：溃散。象鸟惊飞，象鱼溃散而逃。形容军队因受惊扰而乱纷纷地四下溃散。\n			', '\n《南史·宋武帝纪》：“番禺之功，俘级万数，左里之捷，鸟散鱼溃。”\n			', '\n暂无\n			'),
(2824, '0:4:4', '牛蹄之鱼', '\n【 niú　tí　zhī　yú 】\n			', '\n牛蹄印坑里的鱼。比喻死期迫近。同“牛蹄中鱼”。\n			', '\n《孔丛子·连丛子下》：“且今已乏矣，而方须租人，是犹古人欲决江海以救牛蹄之鱼之类也。”\n			', '\n暂无\n			'),
(2825, '0:4:4', '牛蹄中鱼', '\n【 niú　tí　zhōng　yú 】\n			', '\n牛蹄：是指牛蹄印里的积水。牛蹄印坑里的鱼。比喻死期迫近。\n			', '\n三国（魏）·应璩《与韦仲将书》：“诚恐将为牛蹄中鱼，卒鲍氏之肆矣。”\n			', '\n暂无\n			'),
(2826, '0:4:4', '鲇鱼上竿', '\n【 nián　yú　shàng　gān 】\n			', '\n比喻上升艰难。同“鲇鱼上竹竿”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2827, '0:4:4', '鲇鱼上竹', '\n【 nián　yú　shàng　zhú 】\n			', '\n比喻本想前进反而后退。\n			', '\n宋·欧阳修《归田录》：“君于仕宦，亦何异鲇鱼上竹竿耶？”\n			', '\n暂无\n			'),
(2828, '0:4:4', '鲇鱼上竹竿', '\n【 nián　yú　shàng　zhú　gān 】\n			', '\n俗说鲇鱼能上竹竿，但鲇鱼黏滑无鳞，爬竿毕竟困难。后以之比喻上升艰难。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2829, '0:4:4', '鲇鱼缘竹竿', '\n【 nián　yú　yuán　zhú　gān 】\n			', '\n比喻上升艰难。同“鮎鱼上竹竿”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2830, '0:4:4', '雀马鱼龙', '\n【 què　mǎ　yú　lóng 】\n			', '\n泛指珍禽异兽。\n			', '\n语出《汉书·西域传赞》：“自是之后，明珠、文甲、通犀、翠羽之珍盈于后宫，蒲梢、龙文、鱼目、汗血之马充于黄门，钜象、师子、猛犬、大雀之群食于外囿。殊方异物，四面而至。”\n			', '\n暂无\n			'),
(2831, '0:4:4', '弃其馀鱼', '\n【 qì　qí　yú　yú 】\n			', '\n比喻节欲知足。\n			', '\n《淮南子·齐俗训》载：惠施为梁相，从车百乘，犹嫌不足。庄子泽边见之，弃其馀鱼，以示讽诫。\n			', '\n暂无\n			'),
(2832, '0:4:4', '清水无大鱼', '\n【 qīng　shuǐ　wú　dà　yú 】\n			', '\n指待人处事不能求全责备。\n			', '\n语出《汉书·东方朔传》：“水至清则无鱼，人至察则无徒。”\n			', '\n暂无\n			'),
(2833, '0:4:4', '前庭悬鱼', '\n【 qián　tíng　xuán　yú 】\n			', '\n比喻不吃请，不受贿。\n			', '\n《后汉书·羊续传》：“续敝衣薄食，车马蠃败，府丞尝献其生鱼，续乃出前所县者，以杜其意。”\n			', '\n暂无\n			'),
(2834, '0:4:4', '任凭风浪起，稳坐钓鱼船', '\n【 rèn　píng　fēng　làng　qǐ，wěn　zuò　diào 】\n			', '\n比喻随便遇到什么险恶的情况，都信心十足，毫不动摇。\n			', '\n毛泽东《在中国共产党第八届中央委员会第二次全体会议上的讲话》四：“我们有在不同革命时期经过考验的这样一套干部，就可以‘任凭风浪起，稳坐钓鱼船’。要有这个信心。”\n			', '\n暂无\n			'),
(2835, '0:4:4', '人为刀俎，我为鱼肉', '\n【 rén　wéi　dāo　zǔ，wǒ　wéi　yú　ròu 】\n			', '\n刀俎：刀和刀砧板，宰割的工具。比喻生杀的权掌握在别人手里，自己处在被宰割的地位。\n			', '\n《史记·项羽本纪》：“如今人方为刀俎，我为鱼肉。”\n			', '\n暂无\n			'),
(2836, '0:4:4', '如鱼得水', '\n【 rú　yú　dé　shuǐ 】\n			', '\n好象鱼得到水一样。比喻有所凭借。也比喻得到跟自己十分投合的人或对自己很合适的环境。\n			', '\n《三国志·蜀书·诸葛亮传》：“孤之有孔明，犹鱼之有水也。”\n			', '\n若使他回来了，我们就应该～，欢喜的了不得，那里还有功夫在这里纳闷呢！（清·岭南羽衣女士《东欧女豪杰》第三回）\n			'),
(2837, '0:4:4', '如鱼似水', '\n【 rú　yú　sì　shuǐ 】\n			', '\n比喻关系融洽、亲密。\n			', '\n明·冯梦龙《警世通言》第二卷：“那田氏比先前二妻，更有姿色。肌肤若冰雪，绰约似神仙。庄生不是好色之徒，却也十分相敬，真个如鱼似水。”\n			', '\n暂无\n			'),
(2838, '0:4:4', '如鱼饮水，冷暖自知', '\n【 rú　yú　yǐn　shuǐ，lěng　nuǎn　zì　zhī 】\n			', '\n泛指自己经历的事，自己知道甘苦。同“如人饮水，冷暖自知”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2839, '0:4:4', '水到鱼行', '\n【 shuǐ　dào　yú　xíng 】\n			', '\n比喻条件具备，事情就可办成。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2840, '0:4:4', '豕亥鱼鲁', '\n【 shǐ　hài　yú　lǔ 】\n			', '\n指书籍传写或刊印中的文字错误。\n			', '\n《吕氏春秋·察传》载有“己亥”误作“三豕”的故事。晋葛洪《抱朴子·遐览》：“书字人知之，犹尚写之多误。故谚曰：书三写，鱼成鲁，虚成虎。此之谓也。”\n			', '\n暂无\n			'),
(2841, '0:4:4', '水清无鱼', '\n【 shuǐ　qīng　wú　yú 】\n			', '\n水太清，鱼就存不住身，对人要求太苛刻，就没有人能当他的伙伴。比喻过分计较人的小缺点，就不能团结人。\n			', '\n《汉书·东方朔传》：“水至清则无鱼，人至察则无徒。”\n			', '\n暂无\n			'),
(2842, '0:4:4', '三日打鱼，两日晒网', '\n【 sān　rì　dǎ　yú，liǎng　rì　shài　wǎng 】\n			', '\n比喻对学习、工作没有恒心，经常中断，不能长期坚持。\n			', '\n清·曹雪芹《红楼梦》第九回：“因此也假说来上学，不过是三日打鱼，两日晒网，白送些束修礼物与贾代儒。”\n			', '\n体育锻炼要每天坚持，不要～。\n			'),
(2843, '0:4:4', '撒水拿鱼', '\n【 sā　shuǐ　ná　yú 】\n			', '\n抽干水捉鱼。比喻事情容易做，不费气力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2844, '0:4:4', '似水如鱼', '\n【 sì　shuǐ　rú　yú 】\n			', '\n像鱼和水一样不能离开。形容关系密切，不可分离。多指男女情人。\n			', '\n元·王实甫《西厢记》第五本第四折：“若不是大恩人拔刀相助，怎能勾好夫妻似水如鱼。”明·张凤翼《红拂记·传奇大意》：“李靖人豪，张姬女侠，相逢似水如鱼。”\n			', '\n[正旦唱]这厮只因饱暖生淫欲……[正旦唱]便休想～。\n			'),
(2845, '0:4:4', '三天打鱼，两天晒网', '\n【 sān　tiān　dǎ　yú，liǎng　tiān　shài　wǎng 】\n			', '\n比喻对学习、工作没有恒心，经常中断，不能长期坚持。\n			', '\n<span class="C999">暂无</span>\n			', '\n体育锻炼要每天坚持，不要～。\n			'),
(2846, '0:4:4', '食鱼遇鲭', '\n【 shí　yú　yù　qīng 】\n			', '\n比喻调换口味，使不单调。鲭，鱼肉合烧的美味。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2847, '0:4:4', '射鱼指天', '\n【 shè　yú　zhǐ　tiān 】\n			', '\n向天射鱼。比喻虽劳而必无所获。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2848, '0:4:4', '水至清则无鱼', '\n【 shuǐ　zhì　qīng　wú　yú 】\n			', '\n水太清，鱼就存不住身，对人要求太苛刻，就没有人能当他的伙伴。比喻过分计较人的小缺点，就不能团结人。\n			', '\n《汉书·东方朔传》：“水至清则无鱼，人至察则无徒。”\n			', '\n暂无\n			'),
(2849, '0:4:4', '土崩鱼烂', '\n【 tǔ　bēng　yú　làn 】\n			', '\n鱼烂：鱼腐烂从内脏起。比喻国家内部发生动乱。\n			', '\n汉·陈琳《为曹洪与魏文帝书》：“若乃距阳平，据石门，摅八陈之列，骋奔牛之权，焉有土崩鱼烂哉。”\n			', '\n暂无\n			'),
(2850, '0:4:4', '太公钓鱼，愿者上钩', '\n【 tài　gōng　diào　yú，yuàn　zhě　shàng　gōu 】\n			', '\n太公：指周初的吕尚，即姜子牙。比喻心甘情愿地上当。\n			', '\n《武王伐纣平话》卷下：“姜尚因命守时，直钩钓：‘负命者上钩来！’”\n			', '\n这有何妨，～。（清·孔尚任《桃花扇》第二十四出）\n			'),
(2851, '0:4:4', '吞舟之鱼', '\n【 tūn　zhōu　zhī　yú 】\n			', '\n能吞舟的大鱼。常以喻人事之大者。\n			', '\n《庄子·庚桑楚》：“吞舟之鱼，砀而失水。”《列子·杨朱》：“吞舟之鱼，不游枝流；鸿鹄高飞，不集污池。”《史记·酷吏列传序》：“网漏于吞舟之鱼，而吏治烝烝，不至于奸，黎民艾安。”\n			', '\n吾顿八纮之网以收之，即或漏～，而已暴腮断鳍，颓然老矣。\n			'),
(2852, '0:4:4', '瓦影之鱼', '\n【 wǎ　yǐng　huā　yú 】\n			', '\n比喻求庇于人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2853, '0:4:4', '为渊驱鱼', '\n【 wèi　yuān　qū　yú 】\n			', '\n原比喻残暴的统治迫使自己一方的百姓投向敌方。现多比喻不会团结人，把一些本来可以团结过来的人赶到敌对方面去。\n			', '\n《孟子·离娄上》：“为渊驱鱼者，獭也。为丛驱爵者，鹯也；为汤武驱民者，桀与纣也。”\n			', '\n暂无\n			'),
(2854, '0:4:4', '为渊驱鱼，为丛驱爵', '\n【 wèi　yuān　qū　yú，wèi　cóng　qū　jué 】\n			', '\n比喻为政不善，人心涣散，使百姓投向敌方。爵，通“雀”。\n			', '\n语出《孟子·离娄上》：“为渊驱鱼者，獭也；为丛驱爵者，鹯也；为汤武驱民者，桀与纣也。”《晋书·段灼传》引作“为川驱鱼，为薮驱雀”。\n			', '\n奸胥劣绅，且得窥见罅以滋扰累，～，甚非计也。\n			'),
(2855, '0:4:4', '为渊驱鱼，为丛驱雀', '\n【 wèi　yuān　qū　yú，wèi　cóng　qū　què 】\n			', '\n比喻为政不善，人心涣散，使百姓投向敌方。同“为渊驱鱼，为丛驱爵”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2856, '0:4:4', '稳坐钓鱼船', '\n【 wěn　zuò　diào　yú　chuán 】\n			', '\n比喻不管发生什么变化，仍然沉着镇静。\n			', '\n俗谚：“任凭风浪起，稳坐钓鱼台。”\n			', '\n暂无\n			'),
(2857, '0:4:4', '悬龟系鱼', '\n【 xuán　guī?jì　yú 】\n			', '\n指任高官显宦。\n			', '\n《新唐书·车服志》：“高宗给五品以上随身鱼袋……天授二年，改佩鱼为?。其后三品以上龟袋饰以金，四品以银，五品以铜。中宗初，罢龟袋，复给以鱼。”\n			', '\n数世之后，将振振绳绳，～，秉钧当轴。\n			'),
(2858, '0:4:4', '信及豚鱼', '\n【 xìn　jí　tún　yú 】\n			', '\n及：达到；豚：小猪。信用及于小猪和鱼那样微贱的东西。比喻信用非常好。\n			', '\n《易·中孚》：“豚鱼吉，信及豚鱼也。”\n			', '\n暂无\n			'),
(2859, '0:4:4', '宵鱼垂化', '\n【 xiāo　yú　chuí　huà 】\n			', '\n用来颂扬地方官善于教化。\n			', '\n据《吕氏春秋·具备》载，春秋时孔子弟子宓子贱治亶父（今山东省单县），体圣人之化，三年，夜间捕鱼的人能将所得小鱼重归水中。\n			', '\n大夫不麛卵，庶人不数罟，行苇作歌，～，所以爱人用也。\n			'),
(2860, '0:4:4', '霄鱼垂化', '\n【 xiāo　yú　chuí　huà 】\n			', '\n以之来称赞官吏的德政。\n			', '\n据《吕氏春秋·具备》载，春秋时孔子弟子宓子贱治亶父（今山东省单县），体圣人之化，三年，夜间捕鱼的人能将所得小鱼重归水中。\n			', '\n暂无\n			'),
(2861, '0:4:4', '瞎子摸鱼', '\n【 xiā　zi　mō　yú 】\n			', '\n比喻做事盲目，缺乏调查研究。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2862, '0:4:4', '鱼帛狐篝', '\n【 yú　bó　hú　gōu 】\n			', '\n指借助鬼神制造舆论，以便起事。\n			', '\n《史记·陈涉世家》：“陈胜吴广喜，念鬼，曰：‘此教我先威众耳。’乃丹书帛曰‘陈胜王’，置人所罾鱼腹中。卒买鱼烹食，得鱼腹中书，固以怪之矣。又閒令吴广之次所旁丛祠中，夜篝火，狐鸣呼曰：‘大楚兴，陈胜王’。卒皆夜惊恐……”\n			', '\n益之民穷变易煽，～竞潜结。\n			'),
(2863, '0:4:4', '鱼帛狐声', '\n【 yú　bó　hú　shēng 】\n			', '\n指借助鬼神制造舆论，以便起事。\n			', '\n《史记·陈涉世家》：“陈胜吴广喜，念鬼，曰：‘此教我先威众耳。’乃丹书帛曰‘陈胜王’，置人所罾鱼腹中。卒买鱼烹食，得鱼腹中书，固以怪之矣。又閒令吴广之次所旁丛祠中，夜篝火，狐鸣呼曰：‘大楚兴，陈胜王’。卒皆夜惊恐……”\n			', '\n暂无\n			'),
(2864, '0:4:4', '鱼传尺素', '\n【 yú　chuán　chǐ　sù 】\n			', '\n尺素：古代用绢帛书写，通常长一尺，因此称书信。指传递书信。\n			', '\n古乐府《饮马长城窟行》：“客从远方来，遗我双鲤鱼。呼儿烹鲤鱼，中有尺素书。”\n			', '\n驿寄梅花，～，砌成此恨无重数。（宋·秦观《踏莎行》词）\n			'),
(2865, '0:4:4', '鱼肠尺素', '\n【 yú　cháng　chǐ　sù 】\n			', '\n指书信。\n			', '\n北周·庾信《谢滕王集序启》：“鱼肠尺素，凤足数行，书此谢辞，终知不尽。”\n			', '\n暂无\n			'),
(2866, '0:4:4', '鱼沉鸿断', '\n【 yú　chén　hóng　duàn 】\n			', '\n比喻书信不通，音信断绝。\n			', '\n明·王玉峰《焚香记·饯别》：“又恐鱼沉鸿断，阻隔云山，衔悲饮泪有万千。”\n			', '\n暂无\n			'),
(2867, '0:4:4', '鱼沉雁静', '\n【 yú　chén　yàn　jìng 】\n			', '\n比喻书信不通，音信断绝。\n			', '\n明·高濂《瓦盆儿·题情》套曲：“未知道自别来他心可至诚，他应恨鱼沉雁静。”\n			', '\n暂无\n			'),
(2868, '0:4:4', '鱼沉雁落', '\n【 yú　chén　yàn　luò 】\n			', '\n形容女子容貌美丽。\n			', '\n《庄子·齐物论》：“毛嫱丽姬，人之所美也，鱼见之深入，鸟见之高飞，麋鹿见之决骤，四者孰知天下之正色哉！”\n			', '\n说甚么如花殿脚多奇妙，那《菱歌》起处，却也～。\n			'),
(2869, '0:4:4', '鱼沉雁渺', '\n【 yú　chén　yàn　miǎo 】\n			', '\n比喻书信不通，音信断绝。\n			', '\n清·魏秀仁《花月痕》第四十二回：“谡如蒿目时艰，空自拊髀，兼之宝山僻在海隅，文报不通，迢递并云，鱼沉雁渺，十分懊恼。”\n			', '\n暂无\n			'),
(2870, '0:4:4', '鱼沉雁杳', '\n【 yú　chén　yàn　yǎo 】\n			', '\n比喻书信不通，音信断绝。\n			', '\n唐·戴叔伦《相思曲》：“鱼沉雁杳天涯路，始信人间别离苦。”\n			', '\n源（刘源）出门年余，～。\n			'),
(2871, '0:4:4', '鱼肠雁足', '\n【 yú　cháng　yàn　zú 】\n			', '\n泛指书信。\n			', '\n唐·李绅《逾岭峤止荒陬抵高要》诗：“鱼肠雁足望缄封，地远三江岭万重。”\n			', '\n暂无\n			'),
(2872, '0:4:4', '鱼大水小', '\n【 yú　dà　shuǐ　xiǎo 】\n			', '\n比喻生产不够消费。也比喻机构臃肿，行动不灵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2873, '0:4:4', '雁断鱼沉', '\n【 yàn　duàn　yú　chén 】\n			', '\n比喻彼此音讯断绝。同“雁逝鱼沉”。\n			', '\n清·湘灵子《轩亭冤·哭墓》：“雁断鱼沉，久隔音尘，此后相思两地分。”\n			', '\n暂无\n			'),
(2874, '0:4:4', '鱼釜尘甑', '\n【 yú　fǔ　chén　zèng 】\n			', '\n指贫穷的无粮可炊。\n			', '\n《后汉书·独行传·范冉》：“（范冉）遭党人禁锢，遂推鹿车，载妻子，捃拾自资，或寓息客庐，或依宿树廕。如此十馀年，乃结草室而居焉。所止单陋，有时粮粒尽，穷居自若，言貌无改，闾里歌之曰：‘甑中生尘范史云，釜中生鱼范莱芜。’”\n			', '\n甘守着裙布钗荆，甘受尽～，不惭愧牛衣对影，也惟愿鹿车挽并。\n			'),
(2875, '0:4:4', '鱼封雁帖', '\n【 yú　fēng　yàn　tiē 】\n			', '\n泛指书信。\n			', '\n《吴骚·步步娇·闺怨》：“湘江竭，燕山截，断鱼封雁帖。”《南宫词纪·绛都春·四时怨别》：“伤秋宋玉悲何切，盼征鸿在天外行列，烦寄却鱼封雁帖。”\n			', '\n暂无\n			'),
(2876, '0:4:4', '鸢飞鱼跃', '\n【 yuān　fēi　yú　yuè 】\n			', '\n鸢：老鹰。鹰在天空飞翔，鱼在水中腾跃。形容万物各得其所。\n			', '\n《诗经·大雅·旱麓》：“鸢飞戾天，鱼跃于渊。”\n			', '\n清水池塘傍茅舍，～竹万竿。（陈毅《由北京到广州》诗）\n			'),
(2877, '0:4:4', '鱼贯而出', '\n【 yú　guàn　ér　chū 】\n			', '\n像游鱼那样连贯着出现。\n			', '\n蔡东藩、许廑父《民国通俗演义》第八回：“三人急不暇择，从窦中鱼贯而出，外面正是一条逼狭的胡同，还静悄悄的没人阻住。”\n			', '\n暂无\n			'),
(2878, '0:4:4', '鱼贯而入', '\n【 yú　guàn　ér　rù 】\n			', '\n象游鱼一样一个跟着一个地接连着走。形容一个接一个地依次序进入。\n			', '\n《三国志·魏志·邓艾传》：“将士皆攀木缘崖，鱼贯而进。”\n			', '\n众才女除卞、孟两家姊妹在后，其余都是按名～。（清·李汝珍《镜花缘》第六十七回）\n			'),
(2879, '0:4:4', '鱼贯而行', '\n【 yú　guàn　ér　xíng 】\n			', '\n象游鱼一样一个跟着一个地接连着走。形容一个跟一个单行前进。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2880, '0:4:4', '鱼贯雁比', '\n【 yú　guàn　yàn　bǐ 】\n			', '\n比喻连续而进，犹如鱼群相接，雁阵行进。\n			', '\n清·张岱《陶庵梦忆·扬州清明》：“余所见者，惟西湖春、秦淮夏、虎丘秋，差足比拟，然彼皆团簇一块，如画家横披，此独鱼贯雁比，舒长且三十里焉，则画家之手卷矣。”\n			', '\n暂无\n			'),
(2881, '0:4:4', '鱼贯雁行', '\n【 yú　guàn　yàn　xíng 】\n			', '\n比喻连续而进，犹如鱼群相接，雁阵行进。\n			', '\n清·马建忠《上李伯相复议何学士如璋奏设水师书》：“所隶之舰即可成队合操，水师之鱼贯雁行，即陆军之步伐止齐。”\n			', '\n暂无\n			'),
(2882, '0:4:4', '殃及池鱼', '\n【 yāng　jí　chí　yú 】\n			', '\n比喻无缘无故地遭受祸害。\n			', '\n《吕氏春秋·必己》：“宋桓司马有宝珠，抵罪出亡，王使人问珠之所在，曰：‘投之池中。’于是竭池而求之，无得，鱼死焉。此言祸福之相及也。”\n			', '\n暂无\n			'),
(2883, '0:4:4', '鱼惊鸟散', '\n【 yú　jīng　niǎo　sàn 】\n			', '\n指像鱼腐烂鸟溃散。比喻迅即崩溃，完全失败。\n			', '\n《陈书·高祖纪上》：“公以国盗边警，知无不为，恤是同盟，诛其丑类，莫不鱼惊鸟散，面缚头悬。”\n			', '\n暂无\n			'),
(2884, '0:4:4', '鱼笺雁书', '\n【 yú　jiān　yàn　shū 】\n			', '\n泛指书信。\n			', '\n明·史叔考《醉罗歌·题情》套曲：“泪痕一线罗裙绣裾，相思两字鱼笺雁书。”\n			', '\n暂无\n			'),
(2885, '0:4:4', '鱼溃鸟离', '\n【 yú　kuì　niǎo　lí 】\n			', '\n指像鱼腐烂鸟溃散。比喻迅即崩溃，完全失败。\n			', '\n《周书·武帝纪下》：“王威既振，鱼溃鸟离，破竹更难，见瓴非易。”后蜀·何光远《鉴诫录·知机对》：“一击而鱼溃鸟离，四合而豕分蛇断。”\n			', '\n暂无\n			'),
(2886, '0:4:4', '鱼溃鸟散', '\n【 yú　kuì　niǎo　sàn 】\n			', '\n比喻军队溃败。\n			', '\n《南史·宋武帝纪》：“番禺之功，俘级万数，左里之捷，鸟散鱼溃。”\n			', '\n暂无\n			'),
(2887, '0:4:4', '鱼龙百变', '\n【 yú　lóng　bǎi　biàn 】\n			', '\n像鱼龙那样变化多端。\n			', '\n北周·庾信《谢滕王集序启》：“譬其毫翰，则风雨争飞；论其文采，则鱼龙百变。”\n			', '\n昌黎（韩愈）文无不根据经典，而议论仍未尝袭前人陈言，故下笔如～。\n			'),
(2888, '0:4:4', '鱼龙变化', '\n【 yú　lóng　biàn　huà 】\n			', '\n指鱼变化为龙。比喻世事或人的根本性变化。\n			', '\n宋·刘克庄《水龙吟》词：“任蛙蟆胜负，鱼龙变化，侬方在、华胥国。”\n			', '\n社会现象……又好像长江、大河，滚滚而下，旁流齐汇，泥沙毕集，任你～也逃不出这河流域以外。\n			'),
(2889, '0:4:4', '鱼鲁帝虎', '\n【 yú　lǔ　dì　hǔ 】\n			', '\n指将鱼误写作鲁，帝误写作虎。泛指文字错讹。\n			', '\n清·金桌《〈南海百咏〉跋》：“余家向有钞本，承讹踵谬，不无鱼鲁帝虎之失，恨不能一一订正之。”\n			', '\n暂无\n			'),
(2890, '0:4:4', '鱼瞵鹗睨', '\n【 yú　lín　è　nì 】\n			', '\n像鱼和鹗那样瞪眼注视。比喻瞠目而视。\n			', '\n清·陈康祺《郎潜纪闻》卷八：“盖士大夫沉浮里椋?渲菩猩园兑煺撸?从胁皇沽魉兹擞泐?薯?咭病！\n			', '\n暂无\n			'),
(2891, '0:4:4', '鱼烂而亡', '\n【 yú　làn　ér　wáng 】\n			', '\n鱼腐烂从内脏起。比喻国家因内部祸乱而灭亡。\n			', '\n《公羊传·僖公十九年》：“梁亡。此未有伐者。其言梁亡何？自亡也。其自亡奈何？鱼烂而亡也。”\n			', '\n暂无\n			'),
(2892, '0:4:4', '鱼烂河决', '\n【 yú　làn　hé　jué 】\n			', '\n鱼肉腐烂，黄河溃决。比喻因自身原因溃败灭亡而不可挽救。\n			', '\n语出《史记·秦始皇本纪论》附录汉班固曰：“河决不可复壅，鱼烂不可复全。”\n			', '\n～，不可救药，君子每为之太息。\n			'),
(2893, '0:4:4', '鱼龙混杂', '\n【 yú　lóng　hùn　zá 】\n			', '\n比喻坏人和好人混在一起。\n			', '\n唐·张志和《和渔夫词》十三：“风搅长空浪搅风，鱼龙混杂一川中。”\n			', '\n现在人多手乱，鱼龙混杂，倒是这么着，他们也洗洗清。（清·曹雪芹《红楼梦》第九十四回）\n			'),
(2894, '0:4:4', '鱼龙曼羡', '\n【 yú　lóng　màn　xiàn 】\n			', '\n比喻世事变幻。\n			', '\n清·龚自珍《小游仙词》之六：“顽仙一觉浑瞒过，不在鱼龙曼羡中。”\n			', '\n暂无\n			'),
(2895, '0:4:4', '鱼龙曼衍', '\n【 yú　lóng　màn　yǎn 】\n			', '\n原指各种杂戏同时演出。后形容事物杂乱。也比喻变化很多（含贬义）。\n			', '\n《汉书·西域传赞》：“设酒池肉林以飨四夷之客，作巴俞都户、海中砀极、漫衍鱼龙、鱼抵之戏以观视之。”\n			', '\n暂无\n			'),
(2896, '0:4:4', '鱼龙曼延', '\n【 yú　lóng　màn　yán 】\n			', '\n①古代百戏杂耍名。由艺人执持制作的珍异动物模型表演，有幻化的情节。鱼龙即所谓猞猁之兽，曼延亦兽名。②喻虚假多变，玩弄权术。亦作“鱼龙漫衍”。亦作“鱼龙\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2897, '0:4:4', '鱼龙漫衍', '\n【 yú　lóng　màn　yǎn 】\n			', '\n古代百戏杂耍名。由艺人执持制作的珍异动物模型表演，有幻化的情节。鱼龙即所谓猞猁之兽，曼延亦兽名。后多比喻虚假多变，玩弄权术。漫，通“曼”。\n			', '\n《汉书·西域传赞》：“设酒池肉林以飨四夷之客，作巴俞都户、海中砀极、漫衍鱼龙、鱼抵之戏以观视之。”\n			', '\n暗尘浮动，正鱼龙曼衍，戏车交作。\n			'),
(2898, '0:4:4', '鱼烂取亡', '\n【 yú　làn　qǔ　wáng 】\n			', '\n鱼烂自内而发。比喻因内部腐败而自取灭亡。\n			', '\n梁启超《中国国债史》：“即微外国债主之干涉，而鱼烂取亡之气象，犹岌岌不可终日也。”\n			', '\n暂无\n			'),
(2899, '0:4:4', '鱼烂土崩', '\n【 yú　làn　tǔ　bēng 】\n			', '\n比喻国家内部发生动乱。\n			', '\n汉·荀悦《汉纪无侯传》：“百姓一乱，则鱼烂土崩，莫之匡救。”\n			', '\n暂无\n			'),
(2900, '0:4:4', '鱼烂瓦解', '\n【 yú　làn　wǎ　jiě 】\n			', '\n犹言鱼烂土崩。\n			', '\n宋·叶適《朝请大夫陈公墓志铭》：“余又告以鱼烂瓦解，其实未见，今外弱而形饥，非也。”\n			', '\n暂无\n			'),
(2901, '0:4:4', '鱼目混珠', '\n【 yú　mù　hùn　zhū 】\n			', '\n混：搀杂，冒充。拿鱼眼睛冒充珍珠。比喻用假的冒充真的。\n			', '\n汉·魏伯阳《参同契》卷上：“鱼目岂为珠？蓬蒿不成槚。”\n			', '\n可是这些卖国的老爷们不是也在～，也在自称为爱国忧民的志士吗？（杨沫《青春之歌》第二部第三十八章）\n			'),
(2902, '0:4:4', '鱼目混珍', '\n【 yú　mù　hùn　zhēn 】\n			', '\n比喻以假乱真。\n			', '\n《参同契》上：“鱼目岂为珠，蓬蒿不成槚。”唐·李白《鸣皋歌送岑徵君》：“蝘蜓嘲龙，鱼目混珍。”\n			', '\n暂无\n			'),
(2903, '0:4:4', '鱼目混珎', '\n【 yú　mù　hùn　zhū 】\n			', '\n比喻用假的冒充真的。同“鱼目混珠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2904, '0:4:4', '鱼目间珠', '\n【 yú　mù　jiān　zhū 】\n			', '\n比喻以假乱真。\n			', '\n《参同契》上：“鱼目岂为珠，蓬蒿不成槚。”宋·司马光《稷下赋》：“珷玞乱玉，鱼目间珠，泥沙涨者其泉混，莨莠茂者其谷芜。”\n			', '\n暂无\n			'),
(2905, '0:4:4', '缘木求鱼', '\n【 yuán　mù　qiú　yú 】\n			', '\n缘木：爬树。爬到树上去找鱼。比喻方向或办法不对头，不可能达到目的。\n			', '\n《孟子·梁惠王上》：“以若所为，求若所欲，犹缘木而求鱼也。”\n			', '\n若想善出此关，大王乃～，非徒无益，而又害之也。（明·许仲琳《封神演义》第三十三回）\n			'),
(2906, '0:4:4', '鱼米之地', '\n【 yú　mǐ　zhī　dì 】\n			', '\n盛产鱼类及稻米等的富庶地方。\n			', '\n元·柯丹邱《荆钗记·参相》：“江西是鱼米之地。”\n			', '\n暂无\n			'),
(2907, '0:4:4', '鱼米之乡', '\n【 yú　mǐ　zhī　xiāng 】\n			', '\n指盛产鱼和稻米的富饶地方。\n			', '\n唐·王睃《清移突厥降人于南中安置疏》：“谄以缯帛之利，示以麋鹿之饶，说其鱼米之乡，陈其畜牧之地。”\n			', '\n我知江州是个好地面，～，特地使钱买将那里去。（明·施耐庵《水浒全传》第三十六回）\n			'),
(2908, '0:4:4', '鱼馁肉败', '\n【 yú　něi　ròu　bài 】\n			', '\n馁：鱼臭烂；败：肉腐烂。鱼烂肉腐。泛指变质的食物。\n			', '\n《论语·乡党》：“食不厌精，脍不厌细。食饐而餲，鱼馁而肉败，不食。”\n			', '\n暂无\n			'),
(2909, '0:4:4', '以筌为鱼', '\n【 yǐ　quán　wéi　yú 】\n			', '\n筌：捕鱼的竹器。把捕鱼工具看作是鱼。比喻满足对事物表面肤浅认识，不去更深入了解事物本质。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2910, '0:4:4', '雁去鱼来', '\n【 yàn　qù　yú　lái 】\n			', '\n书信往来。雁、鱼均喻书信。\n			', '\n元·汤式《湘妃引·有所赠》曲：“莺煎燕聒惹相思，雁去鱼来传恨词。”\n			', '\n暂无\n			'),
(2911, '0:4:4', '鱼肉百姓', '\n【 yú　ròu　bǎi　xìng 】\n			', '\n鱼肉：指受宰割者。后比喻用暴力欺凌，任意残害无辜的人们。\n			', '\n《后汉书·仲长统传》：“于是骄逸自恣，志意无厌，鱼肉百姓，以盈其欲。”\n			', '\n所率部队，毫不训练，本不打算作战，故亦不能作战，只是用做搜刮地方，～的工具而已。\n			'),
(2912, '0:4:4', '鱼肉乡里', '\n【 yú　ròu　xiāng　lǐ 】\n			', '\n鱼肉：比喻受宰割；乡里：老百姓。把地方上的老百姓当作鱼、肉一样任意宰割。\n			', '\n南朝·宋·范晔《后汉书·仲长统传》：“鱼肉百姓，以盈其欲。”\n			', '\n暂无\n			'),
(2913, '0:4:4', '鱼水和谐', '\n【 yú　shuǐ　hé　xié 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n元·王子一《误人桃源》第四折：“今日也鱼水和谐，燕莺成对，琴瑟相调。”\n			', '\n记得当初花正开，遇乔才，在阳台，～呀鱼水和谐。\n			'),
(2914, '0:4:4', '鱼生空釜', '\n【 yú　shēng　kōng　fǔ 】\n			', '\n指贫穷得无粮可炊。\n			', '\n宋·陆游《独立》诗：“羊踏寒蔬新少梦，鱼生空釜久谙穷。”\n			', '\n暂无\n			'),
(2915, '0:4:4', '鱼升龙门', '\n【 yú　shēng　lóng　mén 】\n			', '\n比喻举业成功或地位高升。\n			', '\n语出《辛氏三秦记》：“河津一名龙门，禹凿山开门，阔一里馀，黄河自中流下，而岸不通车马。每逢春之际，有黄鲤鱼逆流而上，得过者便化为龙。”\n			', '\n暂无\n			'),
(2916, '0:4:4', '鱼水深情', '\n【 yú　shuǐ　shēn　qíng 】\n			', '\n象鱼儿离不开水那样，关系密切，感情深厚。\n			', '\n明·赵弼《蓬莱先生传》：“鱼水之情，极其娱乐。”\n			', '\n暂无\n			'),
(2917, '0:4:4', '鱼死网破', '\n【 yú　sǐ　wǎng　pò 】\n			', '\n不是鱼死，就是网破。指拼个你死我活。\n			', '\n《杜鹃山》第五场：“他就是张网捕鱼，我也拼他个鱼死网破。”\n			', '\n暂无\n			'),
(2918, '0:4:4', '鱼水相欢', '\n【 yú　shuǐ　xiāng　huān 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n明·沈仕《新水令·闺情》套曲：“着甚来由，晓夜无休，又不是鱼水相欢，胶漆相投。”\n			', '\n暂无\n			'),
(2919, '0:4:4', '鱼水相投', '\n【 yú　shuǐ　xiāng　tóu 】\n			', '\n形容夫妇关系和好谐调如鱼水。\n			', '\n明·袁凫公《八声甘州·代周非月赋别阿蝉》套曲：“冤家聚首，似漆胶相和，鱼水相投。”\n			', '\n暂无\n			'),
(2920, '0:4:4', '鱼书雁帛', '\n【 yú　shū　yàn　bó 】\n			', '\n泛指书信。\n			', '\n清·李渔《闲情偶寄·器玩·制度》：“则笺简二字中，便有无穷本义，鱼书雁帛而外，不有竹刺之式可为乎？”\n			', '\n暂无\n			'),
(2921, '0:4:4', '雁逝鱼沉', '\n【 yàn　shì　yú　chén 】\n			', '\n比喻彼此音讯断绝。亦作“雁断鱼沉”。\n			', '\n《旧五代史·唐书·李袭吉传》：“山高水阔，难追二国之欢；雁逝鱼沉，久绝八行之赐。”\n			', '\n暂无\n			'),
(2922, '0:4:4', '雁素鱼笺', '\n【 yàn　sù　yú　jiān 】\n			', '\n指书信。\n			', '\n明·邵璨《香囊记·途叙》：“雁素鱼笺，离愁满怀谁与传。”\n			', '\n暂无\n			'),
(2923, '0:4:4', '鱼书雁帖', '\n【 yú　shū　yàn　tiě 】\n			', '\n泛指书信。\n			', '\n明·高濂《绛都春序·题情》套曲：“空接，鱼书雁帖，反教人添哽咽。”明·王九思《绛都春序·四时闺怨》套曲：“盼征鸿在天外，行列，烦寄却鱼书雁帖。”\n			', '\n暂无\n			'),
(2924, '0:4:4', '鱼书雁信', '\n【 yú　shū　yàn　xìn 】\n			', '\n泛指书信。\n			', '\n《雍熙乐府·古调石榴花·闺思》：“总是伤情别离，则这鱼书雁信，冷清清杳无踪迹。”\n			', '\n暂无\n			'),
(2925, '0:4:4', '鱼网鸿离', '\n【 yú　wǎng　hóng　lí 】\n			', '\n鸿：鸿雁；离：遭受。张网捕鱼，捉到的是鸿雁。比喻得到的不是自己想要的。\n			', '\n《诗经·邶风·新台》：“鱼网之设，鸿则离之，燕婉之求，得此戚施。”\n			', '\n暂无\n			'),
(2926, '0:4:4', '鱼尾雁行', '\n【 yú　wěi　yàn　xíng 】\n			', '\n指兵轮行进之队列，一轮居中为首，其它轮船按人字形两旁依次排列，状如鱼尾，又如雁阵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2927, '0:4:4', '鱼县鸟窜', '\n【 yú　xiàn　niǎo　cuàn 】\n			', '\n鱼被钓，鸟逃窜。比喻或受制于人，或飘泊流离，处境十分险困。县，通“悬”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(2928, '0:4:4', '羊续悬鱼', '\n【 yáng　xù　xuán　yú 】\n			', '\n羊续，汉时官吏。羊续把生鱼悬于庭。形容为官清廉，拒受贿赂。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2929, '0:4:4', '渊鱼丛雀', '\n【 yuān　yú　cóng　què 】\n			', '\n把鱼赶进深潭，把雀赶到丛林。原比喻统治者施行暴政，百姓逃往别国。现也比喻把可以团结的人赶到敌方去。\n			', '\n《孟子·离娄上》：“为渊驱鱼者，獭也。为丛驱爵者，鹯也；为汤武驱民者，桀与纣也。”\n			', '\n暂无\n			'),
(2930, '0:4:4', '渊鱼丛爵', '\n【 yuān　yú　cóng　què 】\n			', '\n比喻为政不善，结果驱使人民投向敌方。爵，古同“雀”。\n			', '\n《孟子·离娄上》：“故为渊驱鱼者，獭也；为丛驱爵者，鹯也；为汤武驱民者，桀与纣也。”\n			', '\n～，楚材晋用，此固在上者驱迫使然，彼为士者独不可悟商务力量之大乎？\n			'),
(2931, '0:4:4', '鱼游沸鼎', '\n【 yú　yóu　fèi　dǐng 】\n			', '\n鱼在锅里游。比喻处境十分危险，有行将灭亡之虞。\n			', '\n唐·李商隐《行次昭应县道上》诗：“鱼游沸鼎知无日，鸟覆危巢岂待风。”\n			', '\n～中，烹燖化为汁。\n			'),
(2932, '0:4:4', '鱼游釜底', '\n【 yú　yóu　fǔ　dǐ 】\n			', '\n鱼在锅里游。比喻处境十分危险，有行将灭亡之虞。\n			', '\n清·秋瑾《普告同胞檄稿》：“夫鱼游釜底，燕处焚巢，旦夕偷生，不自知其频于外殆，我同胞其何以异是耶？”\n			', '\n～难持久。\n			'),
(2933, '0:4:4', '鱼游沸釜', '\n【 yú　yóu　fèi　fǔ 】\n			', '\n鱼在锅里游。比喻处境十分危险，有行将灭亡之虞。\n			', '\n清·南荃外史《叹老》：“傀儡儿一场热闹，依旧的鱼游沸釜，燕处危巢。”\n			', '\n暂无\n			'),
(2934, '0:4:4', '鱼游釜内', '\n【 yú　yóu　fǔ　nèi 】\n			', '\n鱼在锅里游。比喻处境十分危险，有行将灭亡之虞。\n			', '\n《魏书·中山王英传》：“缘江焚毁，靡使所遗。建业穷蹙，鱼游釜内。”\n			', '\n暂无\n			'),
(2935, '0:4:4', '鱼游釜中', '\n【 yú　yóu　fǔ　zhōng 】\n			', '\n釜：锅。鱼在锅里游。比喻处境危险，快要灭亡。\n			', '\n《后汉书·张纲传》：“若鱼游釜中，喘息须臾间耳。”\n			', '\n姜尚进山，似～，肉在几上。（明·许仲琳《封神演义》第九十一回）\n			'),
(2936, '0:4:4', '鱼游濠上', '\n【 yú　yóu　háo　shàng 】\n			', '\n表示纵情山水、逍遥遨游。\n			', '\n《庄子·秋水》：“庄子与惠子游于濠梁之上，庄子曰：‘儵鱼出游从容，是鱼之乐也。’惠子曰：‘子非鱼，安知鱼之乐？’庄子曰：‘子非我，安知我不知鱼之乐？’惠子曰：‘我非子，固不知子矣；子固非鱼也，子之不知鱼之乐全矣。’ [下续示例]\n			', '\n[上接出处]\n			'),
(2937, '0:4:4', '鱼跃龙门', '\n【 yú　yuè　lóng　mén 】\n			', '\n比喻举业成功或地位高升。\n			', '\n语出《辛氏三秦记》：“河津一名龙门，禹凿山开门，阔一里馀，黄河自中流下，而岸不通车马。每逢春之际，有黄鲤鱼逆流而上，得过者便化为龙。”唐·元弼有《鱼跃龙门赋》。\n			', '\n俗说～，过而为龙，唯鲤或然。\n			'),
(2938, '0:4:4', '以鱼驱蝇', '\n【 yǐ　yú　qū　yíng 】\n			', '\n鱼腥能招来苍蝇，用鱼驱赶苍蝇，苍蝇更多。比喻行为和目的自相矛盾，只能得到相反的结果。\n			', '\n《韩非子·外储说左下》：“以肉去蚁，蚁愈多；以鱼驱蝇，蝇愈至。”南朝·梁元帝《金楼子·立言下》：“以鱼驱蝇，蝇愈至。”\n			', '\n暂无\n			'),
(2939, '0:4:4', '以蚓投鱼', '\n【 yǐ　yǐn　tóu　yú 】\n			', '\n用蚯蚓做鱼饵钓鱼。比喻用较小的代价换得较大的收获。\n			', '\n《隋书·薛道衡传》：“陈使缚縡聘齐，以道衡兼主客郎接对之。縡赠诗五十韵，道衡和之，南北称美。魏收曰：‘傅縡所谓以蚓投鱼耳。’”\n			', '\n暂无\n			'),
(2940, '0:4:4', '鱼与熊掌', '\n【 yú　yǔ　xióng　zhǎng 】\n			', '\n比喻俱为所欲，难于取舍之物。\n			', '\n语本《孟子·告子上》：“鱼我所欲也，熊掌亦我所欲也；二者不可得兼，舍鱼而取熊掌者也。”\n			', '\n暂无\n			'),
(2941, '0:4:4', '雁杳鱼沉', '\n【 yàn　yǎo　yú　chén 】\n			', '\n比喻音信断绝。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2942, '0:4:4', '鱼跃鸢飞', '\n【 yú　yuè　yuān　fēi 】\n			', '\n指万物各得其所。\n			', '\n《诗·大雅·旱麓》：“鸢飞戾天，鱼跃于渊。”\n			', '\n暂无\n			'),
(2943, '0:4:4', '鱼鱼雅雅', '\n【 yú　yú　yǎ　yǎ 】\n			', '\n形容车驾前行威仪整肃的样子。\n			', '\n唐·韩愈《元和圣德诗》：“驾龙十二，鱼鱼雅雅。”\n			', '\n暂无\n			'),
(2944, '0:4:4', '鱼游燋釜', '\n【 yú　yóu　zhuó　fǔ 】\n			', '\n比喻处境危险，快要灭亡。燋，同“灼”，火烧。同“鱼游釜中”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2945, '0:4:4', '鱼质龙文', '\n【 yú　zhì　lóng　wén 】\n			', '\n鱼的实质，龙的外表。谓虚有其表。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2946, '0:4:4', '甑尘釜鱼', '\n【 zēng　chén　fǔ　yú 】\n			', '\n甑里积了灰尘，锅里生了蠹鱼。形容穷困断炊已久。也比喻官吏清廉自守。\n			', '\n《后汉书·范冉传》：“甑中生尘范史云，釜中生鱼范荚芜。”\n			', '\n若如古时范史云，曾官莱芜令，甘自受着～。（明·天然智叟《石头点·贪婪汉六院卖风流》）\n			'),
(2947, '0:4:4', '葬身鱼腹', '\n【 zàng　shēn　yū　fù 】\n			', '\n尸体为鱼所食。指淹死于水中。\n			', '\n战国·楚·屈原《渔父》：“宁赴湘流，葬于江鱼之腹中。安能以皓皓之白，而蒙世俗之尘埃乎？”\n			', '\n只要你舍得这辆汽车，我就奉陪三百回合，直到大雨把汽车冲进大河，咱俩一同～。（刘绍棠《十步芳草》）\n			'),
(2948, '0:4:4', '指天射鱼', '\n【 zhǐ　tiān　shè　yú 】\n			', '\n向着天空去射河里的鱼。比喻办事一定落空。\n			', '\n汉·刘向《说苑·尊贤》：“譬其若夏至之日而欲夜之长也，射鱼指天而欲发之当也。”\n			', '\n暂无\n			'),
(2949, '0:4:4', '自相鱼肉', '\n【 zì　xiāng　yú　ròu 】\n			', '\n鱼肉：当作鱼肉一般任意宰割。比喻内部自相残杀。\n			', '\n《晋书·刘元海载记》：“今司马氏父子兄弟自相鱼肉，此天厌晋，授之与我。”\n			', '\n暂无\n			'),
(2950, '0:4:5', '鹅湖之会', '\n【 é　hú　zhī　huì 】\n			', '\n比喻具有开创性的辩论会。\n			', '\n南宋淳熙二年（1175年）在信州（今江西上饶）鹅湖寺举行的一次著名的哲学辩论会。由吕祖谦邀集，意图调和朱熹和陆九渊两派争执。实质上是朱的客观唯心主义和陆的主观唯心主义的一场争论。它是中国哲学史上一次堪称典范的学术讨论会，首开书院会讲之先河。\n			', '\n暂无\n			'),
(2951, '0:4:5', '鹅毛大雪', '\n【 é　máo　dà　xuě 】\n			', '\n像鹅毛一样的雪花。形容雪下得大而猛。\n			', '\n唐·白居易《雪夜喜李郎中见访》：“可怜今夜鹅毛雪，引得高情鹤氅人。”\n			', '\n暂无\n			'),
(2952, '0:4:5', '鹅王择乳', '\n【 é　wáng　zé　rǔ 】\n			', '\n比喻择其上乘精华。\n			', '\n水乳同置一器，鹅王仅饮乳汁而留其水。事见《祖庭事苑》卷五。清·钱谦益《与素华禅师书》：“《宗镜》删订，非鹅王择乳不能具此心眼。”\n			', '\n鹅王为择乳，鸡粒莫相争。\n			'),
(2953, '0:4:5', '鹅行鸭步', '\n【 é　xíng　yā　bù 】\n			', '\n步：走。象鹅和鸭子那样的走路。比喻步行缓慢。\n			', '\n<span class="C999">暂无</span>\n			', '\n你两个闲常在镇里抬轿时，只是～，如今却怎地这等走得快？（明·施耐庵《水浒全传》第三十二回）\n			'),
(2954, '0:4:5', '鸡声鹅斗', '\n【 jī　shēng　é　dòu 】\n			', '\n比喻吵吵闹闹，彼此不和。\n			', '\n<span class="C999">暂无</span>\n			', '\n从今咱们两个撂开手，省得～，叫别人笑话。（清·曹雪芹《红楼梦》第二十一回）\n			'),
(2955, '0:4:5', '鸡争鹅斗', '\n【 jī　zhēng　é　dòu 】\n			', '\n比喻吵吵闹闹，彼此不和。\n			', '\n清·曹雪芹《红楼梦》第二十一回：“从今咱们两个丢开手，省得鸡争鹅斗，叫别人笑。”\n			', '\n暂无\n			'),
(2956, '0:4:5', '癞蛤蟆想吃天鹅肉', '\n【 lài　há　ma　xiǎng　chī　tiān　é　ròu 】\n			', '\n比喻人没有自知之明，一心想谋取不可能到手的东西。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2957, '0:4:5', '千里鹅毛', '\n【 qiān　lǐ　é　máo 】\n			', '\n比喻情深义重的微小礼品。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2958, '0:4:5', '千里寄鹅毛', '\n【 qiān　lǐ　jì　é　máo 】\n			', '\n比喻礼物虽然微薄，却含有深厚的情谊。同“千里送鹅毛”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2959, '0:4:5', '千里送鹅毛', '\n【 qiān　lǐ　sòng　é　máo 】\n			', '\n比喻礼物虽然微薄，却含有深厚的情谊。\n			', '\n宋·欧阳修《梅圣俞寄银杏》诗：“鹅毛赠千里，所重以其人。”\n			', '\n千里鹅毛意不轻，瘴衣腥腻北归客。（宋·黄庭坚《谢陈适用惠送吴南雄所赠纸》诗）\n			'),
(2960, '0:4:5', '水尽鹅飞', '\n【 shuǐ　jìn　é　fēi 】\n			', '\n比喻恩情断绝，各走各的路。也比喻精光，一点儿也不剩。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2961, '0:4:5', '水净鹅飞', '\n【 shuǐ　jìng　é　fēi 】\n			', '\n比喻人财两失，一无所有。亦比喻民穷财尽。\n			', '\n元·无名氏《云窗梦》第四折：“我则道地北天南，锦营花阵，偎红倚翠，今日个水净鹅飞。”\n			', '\n眼见的吹翻了这家，吹伤了那家，只吹的～罢！\n			'),
(2962, '0:4:5', '鸭步鹅行', '\n【 yā　bù　é　xíng 】\n			', '\n鸭和鹅行八字步，因用以形容人走路迟缓摇晃的样子。\n			', '\n元·秦简夫《东堂老》第二折：“我觑不得你（衤肖）宽也那褶下，肚叠胸高，鸭步鹅行。”\n			', '\n暂无\n			'),
(2963, '0:4:5', '摇鹅毛扇', '\n【 yáo　é　máo　shàn 】\n			', '\n传说诸葛亮常手执羽扇指挥作战，后世舞台上出现的一些军师也多执羽扇。以之比喻出谋画策。\n			', '\n丁玲《太阳照在桑干河上》一：“大家都说他是一个摇鹅毛扇的，是一个唱傀儡戏的提线的人。”\n			', '\n我倒是觉得敬轩的那位～子的军师，生得鹰鼻子鹞眼，不是个善良家伙。\n			'),
(2964, '0:4:5', '鸭行鹅步', '\n【 yā　xíng　é　bù 】\n			', '\n步：走。象鹅和鸭子那样的走路。比喻步行缓慢。\n			', '\n元·秦简夫《东堂老》第二折：“我觑不的你梢宽也那褶下，肚迭胸高，鸭步鹅行。”\n			', '\n暂无\n			'),
(2965, '0:4:6', '包罗万象', '\n【 bāo　luó　wàn　xiàng 】\n			', '\n包罗：包括；万象：宇宙间的一切景象，指各种事物。形容内容丰富，应有尽有。\n			', '\n《黄帝宅经》卷上：“所以包罗万象，举一千从。”\n			', '\n你怎言～，迟早飞升。（明·许仲琳《封神演义》第十三回）\n			'),
(2966, '0:4:6', '拔犀擢象', '\n【 bá　xī　zhuó　xiàng 】\n			', '\n擢：提升。比喻提拔才能出众的人。\n			', '\n宋·王洋《与丞相论郑武子状》：“敕局数人，其间固有拔犀擢象见称一时者，然而析理精微，旁通注意，鲜如克（郑武子）。”\n			', '\n既然要人任人唯亲，又怎能做到～呢？\n			'),
(2967, '0:4:6', '超然象外', '\n【 chāo　rán　xiàng　wài 】\n			', '\n以：用法等同“于”。超脱于物象以外。指诗文的意境雄浑、超脱。也比喻置身世外，脱离现实的空想。\n			', '\n唐·司空图《诗品·雄浑》：“超以象外，得其环中。”\n			', '\n人倘能够“～”，看看报章，倒也是一种清福。（鲁迅《华盖集续编·马上支日记》）\n			'),
(2968, '0:4:6', '超以象外', '\n【 chāo　yǐ　xiàng　wài 】\n			', '\n以：用法等同“于”。超脱于物象之外。形容诗文意境雄浑、超脱。也比喻置身世外，脱离现实的空想。\n			', '\n唐·司空图《诗品·雄浑》：“超以象外，得其环中。”\n			', '\n人倘能够“超然象外”，看看报章，倒也是一种清福。（鲁迅《华盖集续编·马上支日记》）\n			'),
(2969, '0:4:6', '得意忘象', '\n【 dé　yì　wàng　xiàng 】\n			', '\n指只取其精神而无视其形式。\n			', '\n唐·梁肃《止观统例议》：“非夫聪明深达，得意忘象，其孰能知乎？”\n			', '\n昔人深于画者～，其形模位置有不可以常法观者……。\n			'),
(2970, '0:4:6', '狗口里生不出象牙', '\n【 gǒu　kǒu　lǐ　shēng　bù　chū　xiàng　yá 】\n			', '\n比喻坏人说不出好话。同“狗口里吐不出象牙”。\n			', '\n茅盾《霜叶红似二月花续稿》第十五章：“还有些话，牵涉到老弟，咳，反正狗口不出象牙，不说也罢。”\n			', '\n暂无\n			'),
(2971, '0:4:6', '狗口里吐不出象牙', '\n【 gǒu　kǒu　lǐ　tǔ　bù　chū　xiàng　yá 】\n			', '\n比喻坏人说不出好话。\n			', '\n《元曲选·遇上皇》第一折：“父亲和这等东西，有什么好话，讲出什么公理来，狗口里吐不出象牙。”\n			', '\n暂无\n			'),
(2972, '0:4:6', '狗嘴里吐不出象牙', '【 gǒu　zuǐ　lǐ　tǔ　bù　chū　xiàng　yá 】', '比喻坏人嘴里说不出好话来。', '暂无 ', '父亲和这等东西有什么好话，讲出什么公理来，～。（《元曲选·遇上皇》第一折）'),
(2973, '0:4:6', '黄金铸象', '\n【 huáng　jīn　zhù　xiàng 】\n			', '\n铸：铸造。用黄金铸造人像。表示对某人的敬仰或纪念。\n			', '\n《国语·越语下》：“遂乘轻舟，以浮于五湖，莫知其所终极。王命金工以良金写范蠡之状，而朝礼之。”\n			', '\n伯国黄金闻铸象，王门白玉想为标。（元·陈基《垂虹桥》诗）\n			'),
(2974, '0:4:6', '合眼摸象', '\n【 hé　yǎn　mō　xiàng 】\n			', '\n闭着眼睛摸象。比喻盲目行事。\n			', '\n宋·胡仔《苕溪渔隐丛话前集·山谷上》：“山谷云：‘诗词高胜，要从学问中来。后来学诗者，虽时有妙句，譬如合眼摸象，随所触体得一处。’”\n			', '\n暂无\n			'),
(2975, '0:4:6', '盲人摸象', '\n【 máng　rén　mō　xiàng 】\n			', '\n比喻对事物只凭片面的了解或局部的经验，就乱加猜测，想做出全面的判断。\n			', '\n《大般涅槃经》三二：“其触牙者即言象形如芦菔根，其触耳者言象如箕，其触头者言象如石，其触鼻者言象如杵，其触脚者言象如木臼，其触脊者言象如床，其触腹者言象如甕，其触尾者言象如绳。”\n			', '\n暂无\n			'),
(2976, '0:4:6', '盲人说象', '\n【 máng　rén　shuō　xiàng 】\n			', '\n比喻看问题以偏概全。\n			', '\n元·黄溍《书袁通甫诗后》：“吾侪碌碌，从俗浮沉，与先生相去远甚，而欲强加评品，正如盲人说象。”\n			', '\n暂无\n			'),
(2977, '0:4:6', '气象万千', '\n【 qì　xiàng　wàn　qiān 】\n			', '\n气象：情景。形容景象或事物壮丽而多变化。\n			', '\n宋·范仲淹《岳阳楼记》：“朝晖夕阴，气象万千。”\n			', '\n这庄严秀丽、～的长江真是美极了。（刘白羽《长江三日》）\n			'),
(2978, '0:4:6', '人心不足蛇吞象', '\n【 rén　xīn　bù　zú　shé　tūn　xiàng 】\n			', '\n比喻人贪心不足，就象蛇想吞食大象一样。\n			', '\n《山海经·海内南经》：“巴蛇食象，三岁而出其骨。”战国楚·屈原《天问》：“一蛇吞象，厥大何如？”\n			', '\n罗洪宪诗：“～，世事到头螳捕蝉。”（清·翟灏《通俗编·禽鱼》）\n			'),
(2979, '0:4:6', '森罗万象', '\n【 sēn　luó　wàn　xiàng 】\n			', '\n森：众多；罗：罗列；万象：宇宙间各种事物和现象。指天地间纷纷罗列的各种各样的景象。形容包含的内容极为丰富。\n			', '\n南朝梁·陶弘景《茅山长沙馆碑》：“夫万象森罗，不离两仪所育；百法纷凑，无越三教之境。”\n			', '\n乾坤大地，日月星辰，～。（宋·释普济《五灯会元》卷十九）\n			'),
(2980, '0:4:6', '狮象搏兔，皆用全力', '\n【 shī　xiàng　bó　tù，jiē　yòng　quán　lì 】\n			', '\n比喻对小事情也拿出全部力量认真对付。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2981, '0:4:6', '蛇欲吞象', '\n【 shé　yù　tūn　xiàng 】\n			', '\n蛇想吞下大象。比喻贪欲极大。\n			', '\n《山海经·海内南经》：“巴蛇食象，三岁而出其骨。”战国楚·屈原《天问》：“一蛇吞象，厥大何如？”\n			', '\n暂无\n			'),
(2982, '0:4:6', '太平无象', '\n【 tài　píng　wú　xiàng 】\n			', '\n指太平盛世并无一定标志。后讽刺反动统治者粉饰升平。\n			', '\n《资治通鉴·唐文宗太和六年》：“会上御延英，谓宰相曰：‘天下何时当太平，卿等亦有意于此乎？’僧孺对曰：‘太平无象。今四夷不至交侵，百姓不至流散，虽非至理，亦谓小康。陛下若别求太平，非臣等所及。’”\n			', '\n暂无\n			'),
(2983, '0:4:6', '无可比象', '\n【 wú　kě　bǐ　xiàng 】\n			', '\n没有什么可与譬比。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2984, '0:4:6', '忘象得意', '\n【 wàng　xiàng　dé　yì 】\n			', '\n忘记物象，得到真谛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2985, '0:4:6', '万象更新', '\n【 wàn　xiàng　gēng　xīn 】\n			', '\n万象：宇宙间一切景象；更：变更。事物或景象改换了样子，出现了一番新气象。\n			', '\n清·曹雪芹《红楼梦》第七十回：“如今正是初春时节，万物更新，正该鼓舞另立起来才好。”\n			', '\n春回大地，～，农民又开始耕种了。\n			'),
(2986, '0:4:6', '万象森罗', '\n【 wàn　xiàng　sēn　luó 】\n			', '\n指天地间纷纷罗列的各种各样的景象。\n			', '\n《景德传灯录》：“森罗万象，总在遮一碗里。”\n			', '\n暂无\n			'),
(2987, '0:4:6', '象齿焚身', '\n【 xiàng　chǐ　fén　shēn 】\n			', '\n焚身：丧生。象因为有珍贵的牙齿而遭到捕杀。比喻人因为有钱财而招祸。\n			', '\n《左传·襄公二十四年》：“象有齿以焚其身，贿也。”\n			', '\n正是：山木自寇，～。恫哉李督！死不分明。（蔡东藩、许廑父《民国通俗演义》第一二一回）\n			'),
(2988, '0:4:6', '象耕鸟耘', '\n【 xiàng　gēng　niǎo　yún 】\n			', '\n传说舜死苍梧，象为之耕；禹葬会稽，鸟为之耘。后用以形容民俗古朴，有舜禹时代的遗风。\n			', '\n《文选·左思〈吴都赋〉》：“象耕鸟耘，此之自与。”李善注引《越绝书》：“舜死苍梧，象为之耕；禹葬会稽，鸟为之耘。”一说，耕者以象行为法，耘者如鸟之啄食。\n			', '\n恒水又东迳蓝莫塔，塔边有池……此中空荒无人，群象以鼻取水洒地，若苍梧、会稽～矣。\n			'),
(2989, '0:4:6', '象简乌纱', '\n【 xiàng　jiǎn　wū　shā 】\n			', '\n象简：象牙做的朝笏；乌纱：黑纱制成的官帽。手执象牙笏，头戴乌纱帽。指旧时大官的装束。\n			', '\n明·冯惟敏《商调集贤宾·舍弟乞休》：“把象简乌纱收拾起，打扮出村翁的风致，拜谢当今圣主赐臣归。”\n			', '\n暂无\n			'),
(2990, '0:4:6', '象煞有介事', '\n【 xiàng　shà　yǒu　jiè　shì 】\n			', '\n指装模作样，活象真有那么一回事似的。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2991, '0:4:6', '香象渡河', '\n【 xiāng　xiàng　dù　hé 】\n			', '\n佛教用语。比喻悟道精深。也形容评论文字精辟透彻。\n			', '\n《优婆塞戒经》卷一：“如恒河水，三兽俱渡，兔、马、香象。兔不至底，浮水而过；马或至底，或不至底；象则尽底。”\n			', '\n亦如～，截流而过，更无疑滞。（宋·释普济《五灯会元》卷三）\n			'),
(2992, '0:4:6', '险象环生', '\n【 xiǎn　xiàng　huán　shēng 】\n			', '\n危险的局面不断产生。\n			', '\n<span class="C999">暂无</span>\n			', '\n这次旅行真是险象环生、惊心动魄。\n			'),
(2993, '0:4:6', '香象绝流', '\n【 xiāng　xiàng　jué　liú 】\n			', '\n佛教用语。比喻悟道精深。也形容评论文字精辟透彻。同“香象渡河”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2994, '0:4:6', '象牙之塔', '\n【 xiàng　yá　zhī　tǎ 】\n			', '\n指主张“为艺术而艺术”的资产阶级文艺家脱离社会现实的个人幻想的艺术境界。也比喻脱离现实生活的知识分子的小天地。\n			', '\n<span class="C999">暂无</span>\n			', '\n但这些我都不管，因为我幸而还没有爬上“～”去。（鲁迅《朝花夕拾·二十四孝图》）\n			'),
(2995, '0:4:6', '瞎子摸象', '\n【 xiā　zǐ　mō　xiàng 】\n			', '\n比喻对事物一知半解，不对全局作判断。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(2996, '0:4:6', '象箸玉杯', '\n【 xiàng　zhù　yù　bēi 】\n			', '\n象箸：象牙筷子；玉杯：犀玉杯子。形容生活奢侈。\n			', '\n《韩非子·喻老》：“象箸玉杯，必不羹菽藿，则必旄象豹胎。”《史记·宋微子世家》：“纣始为象箸，箕子叹曰：‘彼为象箸，必为玉杯。’”\n			', '\n暂无\n			'),
(2997, '0:4:6', '遗风余象', '\n【 yí　fēng　yú　xiàng 】\n			', '\n前代遗留下来的风俗和法式。\n			', '\n宋·司马光《投壶新格》：“古者壶矢之制，揖让之容，今虽阙焉，然其遗风余象犹仿佛也。”\n			', '\n暂无\n			'),
(2998, '0:4:6', '众盲摸象', '\n【 zhòng　máng　mō　xiàng 】\n			', '\n许多瞎子摸象，摸到象腿的说象一根柱子，摸到象身子的说象一堵墙，摸到象尾的说象一条蛇，互相争论不休。比喻看问题以偏概全。\n			', '\n《大般涅槃经》三二：“其触牙者即言象形如芦菔根，其触耳者言象如箕，其触头者言象如石，其触鼻者言象如杵，其触脚者言象如木臼，其触脊者言象如床，其触腹者言象如甕，其触尾者言象如绳。”\n			', '\n少林冷坐，门人各说异端，大似～。\n			'),
(2999, '0:4:6', '拽象拖犀', '\n【 zhuài　xiàng　tuō　xī 】\n			', '\n能徒手拉住大象拖动犀牛。形容勇力过人。\n			', '\n元·无名氏《大战邳彤》第一折：“凭着我拽象拖犀胆气雄，更那堪武艺精，怕什么奸贼巨鹿狠邳彤。”元·无名氏《活拿萧天佑》第二折：“我可也杀人放火偏能惯，拽象拖犀气力高。”\n			', '\n暂无\n			'),
(3000, '0:4:7', '打鸭惊鸳鸯', '\n【 dǎ　yā　jīng　yuān　yāng 】\n			', '\n比喻打甲惊乙。也比喻株连无罪的人。\n			', '\n宋·梅尧臣《打鸭》诗：“莫打鸭，打鸭惊鸳鸯。”\n			', '\n暂无\n			'),
(3001, '0:4:7', '打鸭惊鸳', '\n【 dǎ　yā　jīng　yuān 】\n			', '\n比喻打甲惊乙。也比喻株连无罪的人。\n			', '\n明·梅鼎祚《昆化奴》第二折：“我不是要害你性命也，则怕打鸭惊鸳，打草惊蛇。”\n			', '\n焚琴煮鹤垂垂尽，～事事非。\n			'),
(3002, '0:4:7', '打鸭子上架', '\n【 dǎ　yā　zi　shàng　jià 】\n			', '\n比喻强迫去做能力做不到的事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3003, '0:4:7', '鹅行鸭步', '\n【 é　xíng　yā　bù 】\n			', '\n步：走。象鹅和鸭子那样的走路。比喻步行缓慢。\n			', '\n<span class="C999">暂无</span>\n			', '\n你两个闲常在镇里抬轿时，只是～，如今却怎地这等走得快？（明·施耐庵《水浒全传》第三十二回）\n			'),
(3004, '0:4:7', '赶鸭子上架', '\n【 gǎn　yā　zī　shàng　jià 】\n			', '\n比喻强迫去做能力达不到的事情。\n			', '\n<span class="C999">暂无</span>\n			', '\n那当然，这不是～的事。再说，我也识得轻重，你放心好了。（高阳《母子君臣》）\n			'),
(3005, '0:4:7', '水过鸭背', '\n【 shuǐ　guò　yā　bèi 】\n			', '\n比喻事过之后没有留下一点痕迹。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3006, '0:4:7', '鸭步鹅行', '\n【 yā　bù　é　xíng 】\n			', '\n鸭和鹅行八字步，因用以形容人走路迟缓摇晃的样子。\n			', '\n元·秦简夫《东堂老》第二折：“我觑不得你（衤肖）宽也那褶下，肚叠胸高，鸭步鹅行。”\n			', '\n暂无\n			'),
(3007, '0:4:7', '鸭行鹅步', '\n【 yā　xíng　é　bù 】\n			', '\n步：走。象鹅和鸭子那样的走路。比喻步行缓慢。\n			', '\n元·秦简夫《东堂老》第二折：“我觑不的你梢宽也那褶下，肚迭胸高，鸭步鹅行。”\n			', '\n暂无\n			'),
(3008, '0:4:8', '豹死留皮', '\n【 bào　sǐ　liú　pí 】\n			', '\n豹子死了，皮留在世间。比喻将好名声留传于后世。\n			', '\n《新五代史·王彦章传》：“豹死留皮，人死留名。”\n			', '\n则其人肉体虽死，精神永生。俗语说：‘人死留名，～’，也就是这个意思。（冯玉祥《我的生活》第三十八章）\n			'),
(3009, '0:4:8', '豹头环眼', '\n【 bào　tóu　huán　yǎn 】\n			', '\n形容人的面目威严凶狠。\n			', '\n元·无名氏《博望烧屯》第二折：“我也不信，我豹头环眼，倒拿不住一目的夏侯惇。”\n			', '\n暂无\n			'),
(3010, '0:4:8', '豺狼虎豹', '\n【 chái　láng　hǔ　bào 】\n			', '\n泛指危害人畜的各种猛兽。也比喻凶残的恶人。\n			', '\n清·刘鹗《老残游记》第八回：“实在可怕的是豺狼虎豹。天晚了，倘若出来个把，我们就坏了。”\n			', '\n暂无\n			'),
(3011, '0:4:8', '管中窥豹', '\n【 guǎn　zhōng　kuī　bào 】\n			', '\n从竹管的小孔里看豹，只看到豹身上的一块斑纹。比喻只看到事物的一部分，指所见不全面或略有所得。\n			', '\n南朝·宋·刘义庆《世说新语·方正》：“此郎亦管中窥豹，时见一斑。”\n			', '\n有的人孤陋寡闻，～，却喜欢夸夸其谈，炫耀自己。\n			'),
(3012, '0:4:8', '九关虎豹', '\n【 jiǔ　guān　hǔ　bào 】\n			', '\n比喻凶残的权臣。\n			', '\n语出《楚辞·招魂》：“虎豹九关，啄害下人些。”宋·赵癯斋《买陂塘（闻掀髯）》词：“功名事，不信朝鳞暮羽。九关虎豹如许。”\n			', '\n不见～虓且噬，浮云遮日孰为怯？\n			'),
(3013, '0:4:8', '九阍虎豹', '\n【 jiǔ　hūn　hǔ　bào 】\n			', '\n比喻凶残的权臣。同“九关虎豹”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3014, '0:4:8', '窥豹一斑', '\n【 kuī　bào　yī　bān 】\n			', '\n从竹管的小孔里看豹，只看到豹身上的一块斑纹。比喻只看到事物的一部分，指所见不全面或略有所得。\n			', '\n《世说新语·方正》：“此郎亦管中窥豹，时见一斑。”\n			', '\n有的人孤陋寡闻，～，却喜欢夸夸其谈，炫耀自己。\n			'),
(3015, '0:4:8', '狼虫虎豹', '\n【 láng　chóng　hǔ　bào 】\n			', '\n①泛指凶猛的动物。②比喻恶人歹徒。\n			', '\n明·贾仲名《对玉梳》第三折：“转过这山坡，一簇榆林，黑洞洞的，不知里面藏着什么狼虫虎豹。”\n			', '\n县长财主，～。\n			'),
(3016, '0:4:8', '龙肝豹胎', '\n【 lóng　gān　bào　tāi 】\n			', '\n比喻极难得的珍贵食品。\n			', '\n《晋书·潘尼传》：“厥肴伊何？龙肝豹胎。”\n			', '\n暂无\n			'),
(3017, '0:4:8', '龙眉豹颈', '\n【 lóng　méi　bào　jǐng 】\n			', '\n形容勇士的长相。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3018, '0:4:8', '龙腾豹变', '\n【 lóng　téng　bào　biàn 】\n			', '\n比喻议论风发，能言善辩。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3019, '0:4:8', '龙韬豹略', '\n【 lóng　tāo　bào　lüè 】\n			', '\n指兵法。\n			', '\n明·宋濂《走笔送金贤良》诗：“蛋雨蛮烟十年梦，龙韬豹略一生心。”\n			', '\n暂无\n			'),
(3020, '0:4:8', '龙骧豹变', '\n【 lóng　xiāng　bào　biàn 】\n			', '\n比喻书法气势壮盛而善于变化。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3021, '0:4:8', '熊韬豹略', '\n【 xióng　tāo　bào　lüè 】\n			', '\n比喻高妙的用兵谋略。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3022, '0:4:8', '熊心豹胆', '\n【 xióng　xīn　bào　dǎn 】\n			', '\n比喻非常胆大。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3023, '0:4:8', '一斑窥豹', '\n【 yī　bān　kuī　bào 】\n			', '\n从竹管的小孔里看豹，只看到豹身上的一块斑纹。比喻只看到事物的一部分，指所见不全面或略有所得。\n			', '\n南朝宋·刘义庆《世说新语·方正》：“此郎亦管中窥豹，时见一斑。”\n			', '\n暂无\n			'),
(3024, '0:4:8', '以管窥豹', '\n【 yǐ　guǎn　kuī　bào 】\n			', '\n用竹管看豹，只能见其身上的一斑。比喻目光狭隘，见识短浅。\n			', '\n语出南朝·宋·刘义庆《世说新语·方正》：“此郎亦管中窥豹，时见一斑。”\n			', '\n至于杨修小儿，目光不离其鼻，～，更不足以知此。\n			'),
(3025, '0:4:9', '博士买驴', '\n【 bó　shì　mǎi　lǘ 】\n			', '\n博士：古时官名。博士买了一头驴子，写了三纸契约，没有一个“驴”字。讥讽写文章长篇累牍而说不到点子上。\n			', '\n北齐·颜之推《颜氏家训·勉学》：“邺下谚曰：博士买驴，书券三纸，未有驴字。”\n			', '\n暂无\n			'),
(3026, '0:4:9', '非驴非马', '\n【 fēi　lǘ　fēi　mǎ 】\n			', '\n不是驴也不是马。比喻不伦不类，什么也不象。\n			', '\n《汉书·西域传下》：“驴非驴，马非马，若龟兹王，所谓骡也。”\n			', '\n屈以巡按使兼总司令，布告中外，～，惊骇万分。（蔡东藩、许厪父《民国通俗演义》第六九回）\n			'),
(3027, '0:4:9', '好心做了驴肝肺', '\n【 hǎo　xīn　zuò　le　lǘ　gān　fèi 】\n			', '\n俗语。指把好心当作坏意。\n			', '\n<span class="C999">暂无</span>\n			', '\n你看我～，你倒讪起我来，凭说我去罢。（明·兰陵笑笑生《金瓶梅词话》第二十八回）\n			'),
(3028, '0:4:9', '借坡下驴', '\n【 jiè　pō　xià　lǘ 】\n			', '\n凭借有利的地势下驴。比喻利用有利条件行事。\n			', '\n张笑天《死岛情仇》：“李英民咕嘟一声灌了一口汤，想找个台阶借坡下驴：‘好男不跟女斗。’”\n			', '\n暂无\n			'),
(3029, '0:4:9', '驴唇不对马嘴', '\n【 lǘ　chún　bù　duì　mǎ　zuǐ 】\n			', '\n比喻答非所问或两下不相合。\n			', '\n<span class="C999">暂无</span>\n			', '\n老师提出的问题他由于精神分散而没听清楚，回答得～。\n			'),
(3030, '0:4:9', '驴唇马觜', '\n【 lǘ　chún　mǎ　zī 】\n			', '\n指胡扯，瞎说。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3031, '0:4:9', '驴唇马嘴', '\n【 lǘ　chún　mǎ　zuǐ 】\n			', '\n比喻说话写文章，前言不搭后语，前后矛盾。\n			', '\n宋·释道原《景德传灯录·文偃禅师》：“若是一般掠虚汉，食人涎唾，记得一堆一担骨幢，到处逞驴唇马嘴。”\n			', '\n暂无\n			'),
(3032, '0:4:9', '驴鸣狗吠', '\n【 lǘ　míng　gǒu　fèi 】\n			', '\n形容文字言语拙劣。同“驴鸣犬吠”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3033, '0:4:9', '驴鸣犬吠', '\n【 lǘ　míng　quǎn　fèi 】\n			', '\n如同驴叫狗咬一般。形容文字言语拙劣。\n			', '\n唐·张鷟《朝野佥载》：“惟有韩陵山一片石堪共语，自余驴鸣狗吠，聒耳而已。”\n			', '\n暂无\n			'),
(3034, '0:4:9', '驴年马月', '\n【 lǘ　nián　mǎ　yuè 】\n			', '\n不可知的年月。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3035, '0:4:9', '驴前马后', '\n【 lǘ　qián　mǎ　hòu 】\n			', '\n比喻一切受人支配。\n			', '\n宋·释道元《景德传灯录》：“今时人例皆如此，只是认驴前马后，将为自己，佛法平沈此之是也。”\n			', '\n暂无\n			'),
(3036, '0:4:9', '驴头不对马嘴', '\n【 lǘ　tóu　bù　duì　mǎ　zuǐ 】\n			', '\n比喻答非所问或两下不相合。同“驴唇不对马嘴”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3037, '0:4:9', '驴心狗肺', '\n【 lǘ　xīn　gǒu　fèi 】\n			', '\n比喻人心凶狠恶毒。\n			', '\n明·凌濛初《二刻拍案惊奇》：“何故苦苦贪私，思量独吃自疴……不知驴心狗肺怎么生的。”\n			', '\n暂无\n			'),
(3038, '0:4:9', '骑驴倒堕', '\n【 qí　lǘ　dǎo　duò 】\n			', '\n形容太平之世。\n			', '\n典出宋·邵伯温《闻见前录》卷七：“华山隐士陈抟……常乘白骡，从恶少年数百，欲入汴州。中途闻艺祖登极，大笑坠骡曰：‘天下于是定矣。’遂入华山为道士。”\n			', '\n暂无\n			'),
(3039, '0:4:9', '骑驴风雪中', '\n【 qí　lǘ　fēng　xuě　zhōng 】\n			', '\n用为苦吟的典故。同“骑驴索句”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3040, '0:4:9', '黔驴技孤', '\n【 qián　lǘ　jì　gū 】\n			', '\n比喻有限的一点本领。同“黔驴之技”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3041, '0:4:9', '黔驴技穷', '\n【 qián　lǘ　jì　qióng 】\n			', '\n黔：今贵州省一带；技：技能；穷：尽。比喻有限的一点本领也已经用完了。\n			', '\n唐·柳宗元《三戒·黔之驴》\n			', '\n他们不过是～，想求个活命罢了。（陈立德《前驱》三十八）\n			'),
(3042, '0:4:9', '骑驴觅驴', '\n【 qí　lǘ　mì　lǘ 】\n			', '\n骑着驴去找别的驴。原比喻一面占着一个位置，一面去另找更称心的工作。现多比喻东西就在自己这里，还到处去找。\n			', '\n宋·释道原《景德传灯录》卷二十八：“诵经不不见有无义，真似骑驴更觅驴。”\n			', '\n～但可笑，非马喻马亦成痴。（宋·黄庭坚《寄黄龙清老》诗）\n			'),
(3043, '0:4:9', '骑驴索句', '\n【 qí　lǘ　suǒ　jù 】\n			', '\n后用为苦吟的典故。\n			', '\n宋·孙光宪《北梦琐言》卷七载：“唐相国郑綮虽有诗名，本无廊庙之望……或曰：‘相国近有新诗否？’对曰：‘诗思在灞桥雪中驴子上，此处何以得之？’盖言平生苦心也。”\n			', '\n暂无\n			'),
(3044, '0:4:9', '骑驴吟灞上', '\n【 qí　lǘ　yín　bà　shàng 】\n			', '\n用为苦吟的典故。同“骑驴索句”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3045, '0:4:9', '黔驴之计', '\n【 qián　lǘ　zhī　jì 】\n			', '\n比喻虚有其表，本领有限。\n			', '\n唐·柳宗元《三戒·黔之驴》\n			', '\n这些不法分子的～，早已被公安人员识破了。\n			'),
(3046, '0:4:9', '黔驴之技', '\n【 qián　lǘ　zhī　jì 】\n			', '\n比喻有限的一点本领。\n			', '\n唐·柳宗元《三戒·黔之驴》：“黔无驴，有好事者船载以入……放之山下。虎见之，庞然大物也，以为神……，驴一鸣，虎大骇……然往来视之，觉无异能者。……稍近益狎，荡倚冲冒，驴不胜怒，蹄之。虎因喜，计之曰：‘技止此耳！’因跳踉大啃，断其喉\n			', '\n柳宗元曾经描写的～，也是一个很好的教训。\n			'),
(3047, '0:4:9', '三纸无驴', '\n【 sān　zhǐ　wú　lǘ 】\n			', '\n形容写文章废话连篇，不得要领。\n			', '\n北齐·颜之推《颜氏家训·勉学》：“邺下谚曰：‘博士买驴，书券三纸，未有驴字。’”\n			', '\n暂无\n			'),
(3048, '0:4:9', '卸磨杀驴', '\n【 xiè　mò　shā　lǘ 】\n			', '\n磨完东西后，把拉磨的驴卸下来杀掉。比喻把曾经为自己出过力的人一脚踢开。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3049, '0:4:10', '白蚁争穴', '\n【 bái　yǐ　zhēng　xué 】\n			', '\n比喻竞逐名利。\n			', '\n元·马谦斋《沉醉东风·自悟》曲：“取富贵青蝇竞血，进功名白蚁争穴。”\n			', '\n暂无\n			'),
(3050, '0:4:10', '鸱张蚁聚', '\n【 chī　zhāng　yǐ　jù 】\n			', '\n喻指如鸱嚣张，如蚁聚集。\n			', '\n唐·权德舆《唐故光禄大夫检校尚书右仆射兼右卫将军南充郡王赠太子少保伊公神道碑铭》序：“晃之谋主苏涣、骑将王明悦，鸱张蚁聚，皆据厄害。”\n			', '\n暂无\n			'),
(3051, '0:4:10', '堤溃蚁孔', '\n【 dī　kuì　yǐ　kǒng 】\n			', '\n堤坝因蚂蚁洞而崩溃。比喻忽视小处会酿成大祸。\n			', '\n汉·陈宠《清盗源疏》：“臣闻轻者重之端，小者大之源，故堤溃蚁孔，气泄针芒，是以明者慎微，智者识几。”\n			', '\n暂无\n			'),
(3052, '0:4:10', '堤溃蚁穴', '\n【 dī　kuì　yǐ　xué 】\n			', '\n小小的蚂蚁窝，能够使堤岸溃决。比喻小事不注意，就会出大乱子。\n			', '\n三国魏·应璩《杂诗》：“细微可不慎，堤溃自蚁穴。”\n			', '\n暂无\n			'),
(3053, '0:4:10', '蜂攒蚁集', '\n【 fēng　cuán　yǐ　jí 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n明·冯梦龙《醒世恒言》第十八卷 ：“四方商贾来收买的，蜂攒蚁集，挨挤不开。”\n			', '\n暂无\n			'),
(3054, '0:4:10', '蜂攒蚁聚', '\n【 fēng　cuán　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n明·冯梦龙《东周列国志》第三十三回：“那跟随楚王人众，何止千人，一个个俱脱衣露甲，手执暗器，如蜂攒蚁聚，飞奔上坛。”\n			', '\n一到大街，～，身不由己。琬儿母女，各各惊慌。\n			'),
(3055, '0:4:10', '蜂房蚁穴', '\n【 fēng　fáng　yǐ　xué 】\n			', '\n比喻各自占据一方。\n			', '\n明·杨慎《丹铅续录·春秋·隐公元年》：“自共和以来，诸侯如蜂房蚁穴，不用天子之元年矣。”\n			', '\n暂无\n			'),
(3056, '0:4:10', '蜂合蚁聚', '\n【 fēng　hé　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n前蜀·杜光庭《中和周天醮词》：“蠢彼不庭，敢违天道……欲恃其蜂合蚁聚之势，仗锄耰白挺之徒，垂二十年不宾睿化。”\n			', '\n暂无\n			'),
(3057, '0:4:10', '蜂窠蚁穴', '\n【 fēng　kē　yǐ　xué 】\n			', '\n比喻占据的地方极为窄小，借以对偏安一隅的地方势力的蔑称。\n			', '\n宋·曾慥《类说·见闻录·胡讷》：“开宝八年，王师围金陵。朝廷殿试《桥梁渡长江赋》、《习水战诗》；江南亦试《王德惟亲赋》、《谈笑却秦诗》。太祖笑曰：‘江南畜文臣武将，迨同飞走，岂不知中原有真主耶？’赵普曰：‘蜂窠蚁穴不足挂圣虑。’”\n			', '\n暂无\n			'),
(3058, '0:4:10', '蜂趋蚁附', '\n【 fēng　qū　yǐ　fù 】\n			', '\n比喻很多人迎合投靠。\n			', '\n《三元里人民抗英斗争史料·联升社学和钟镛社学》：“果然蜂趋蚁附，攘攘熙熙，诚不出神灵所料者矣。”\n			', '\n暂无\n			'),
(3059, '0:4:10', '蜂扇蚁聚', '\n【 fēng　shān　yǐ　jù 】\n			', '\n蜂翅扇动，蚂蚁聚合。比喻人虽众多但起不了大作用。\n			', '\n《隋书·房彦谦传》：“况乎蕞尔一隅，蜂扇蚁聚，杨谅之愚鄙，群小之凶慝，而欲凭陵畿甸，觊幸非望者哉！”\n			', '\n暂无\n			'),
(3060, '0:4:10', '蜂屯蚁附', '\n【 fēng　tún　yǐ　fù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n宋·李纲《上道君太上皇帝札子》：“犬戎之众，蜂屯蚁附，渡壕临城，梯长如云，箭落如雨。”\n			', '\n暂无\n			'),
(3061, '0:4:10', '蜂屯蚁聚', '\n【 fēng　tún　yǐ　jù 】\n			', '\n形容成群的人聚集在一处。\n			', '\n唐·韩愈《送郑尚书序》：“蜂屯蚁杂，不可爬梳。”\n			', '\n这里雯青直到日落西山，才把那些～的亲朋支使出了门，坐了一肩小轿，向三茅阁巷褚爱林家而来。（清·曾朴《孽海花》第三回）\n			'),
(3062, '0:4:10', '蜂屯蚁杂', '\n【 fēng　tún　yǐ　zá 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n唐·韩愈《送郑尚书序》：“撞搪呼号以相和应；蜂屯蚁杂，不可爬梳。”\n			', '\n暂无\n			'),
(3063, '0:4:10', '蜂营蚁队', '\n【 fēng　yíng　yǐ　duì 】\n			', '\n比喻乌合之众。\n			', '\n明·宋濂《次刘经历韵诗》：“一朝闽寇掠乡部，蜂营蚁队来无涯。”\n			', '\n暂无\n			'),
(3064, '0:4:10', '蜂拥蚁聚', '\n【 fēng　yōng　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n罗振常《史可法别传》：“城下死者山积，攻者反藉叠尸以登，蜂拥蚁聚，城遂陷。”\n			', '\n暂无\n			'),
(3065, '0:4:10', '蜂拥蚁屯', '\n【 fēng　yōng　yǐ　tún 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n清·昭梿《啸亭杂录·缅甸归诚本末》：“帆樯衔接，倏然蜂拥蚁屯者数千人。”\n			', '\n暂无\n			'),
(3066, '0:4:10', '蝼蚁贪生', '\n【 lóu　yǐ　tān　shēng 】\n			', '\n蝼蚁：蝼蛄和蚂蚁。蝼蛄和蚂蚁那样的小虫也贪恋生命。旧指乞求活命的话，有时也用以劝人不可轻生自杀。\n			', '\n明·吴承恩《西游记》第七十六回：“万望大圣慈悲，可怜蝼蚁贪生之意，饶了我命，愿送你师父过山。”\n			', '\n暂无\n			'),
(3067, '0:4:10', '麋沸蚁动', '\n【 mí　fèi　yǐ　dòng 】\n			', '\n比喻社会秩序很乱。\n			', '\n《淮志子·兵略训》：“天下为之麋沸蚁动，云彻席卷。”\n			', '\n暂无\n			'),
(3068, '0:4:10', '蚂蚁缘槐', '\n【 mǎ　yǐ　yuán　huái 】\n			', '\n缘：沿，顺着。蚂蚁沿着槐树上下爬。比喻自以为了不起。\n			', '\n唐·李公佐《南柯太守传》载：一个名叫淳于棼的人梦见自己当了大槐安国的南柯太守，一时好不威风。醒来方知是一场大梦，所谓大槐安国不过是老槐树下的蚂蚁窝。\n			', '\n～夸大国，蚍蜉撼树谈何易。\n			'),
(3069, '0:4:10', '千里之堤，溃于蚁穴', '\n【 qiān　lǐ　zhī　dī，kuì　yú　yǐ　xuè 】\n			', '\n堤：堤坝；溃：崩溃；蚁穴：蚂蚁洞。一个小小的蚂蚁洞，可以使千里长堤溃决。比喻小事不慎将酿成大祸。\n			', '\n先秦·韩非《韩非子·喻老》：“千丈之堤，溃于蚁穴，以蝼蚁之穴溃；百尺之室，以突隙之烟焚。”\n			', '\n暂无\n			'),
(3070, '0:4:10', '千里之堤，毁于蚁穴', '\n【 qiān　lǐ　zhī　dī，huǐ　yú　yǐ　xué 】\n			', '\n一个小小的蚂蚁洞，可以使千里长堤溃决。比喻小事不注意会造成大乱子。\n			', '\n《韩非子·喻老》：“知丈之堤，以蝼蚁之穴溃；百尺之室，以突隙之炽焚。”\n			', '\n暂无\n			'),
(3071, '0:4:10', '群蚁附膻', '\n【 qún　yǐ　fù　shān 】\n			', '\n附：依附；膻：羊肉的气味。许多蚂蚁趋附羊肉。比喻许多臭味相投的人追求不好的事物。\n			', '\n《庄子·徐无鬼》：“羊肉不慕蚁，蚁慕羊肉，羊肉膻也。”\n			', '\n暂无\n			'),
(3072, '0:4:10', '群蚁溃堤', '\n【 qún　yǐ　kuì　dī 】\n			', '\n溃：溃决。细小的蚁洞可以溃决堤坝。比喻细小的漏洞可以酿成大错。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3073, '0:4:10', '热锅上蝼蚁', '\n【 rè　guō　shàng　lóu　yǐ 】\n			', '\n形容心里烦躁、焦急，坐立不安的样子。同“热锅上蚂蚁”。\n			', '\n《隋唐演义》第十九回：“这壁厢太子与杨素，是热锅上蝼蚁，盼不到一个消息。”\n			', '\n暂无\n			'),
(3074, '0:4:10', '热锅上蚂蚁', '\n【 rè　guō　shàng　mǎ　yǐ 】\n			', '\n比喻处境艰困、惶急不安的人。\n			', '\n清·李宝嘉《官场现形记》第十一回：“一霎时犹如热锅上蚂蚁一般，茶饭无心，坐立不定，好生难过，一直等到旁黑，跟班的又出去打听，不多一刻，只见垂头丧气而回。”\n			', '\n女人们还在越在越聚越多，像～，有些跑回了家又跑了出去，在田原里跑着，喃喃着。\n			'),
(3075, '0:4:10', '热锅上的蚂蚁', '\n【 rè　guō　shàng　de　mǎ　yǐ 】\n			', '\n形容心里烦躁、焦急，坐立不安的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3076, '0:4:10', '如蚁附膻', '\n【 rú　yǐ　fù　shān 】\n			', '\n附：趋附；膻：羊肉的气味。象蚂蚁趋附羊肉一般。比喻许多臭味相投的人追求不好的事物。也比喻许多人依附有钱有势的人。\n			', '\n《庄子·徐无鬼》上说：“蚁慕羊肉，羊肉膻也。”\n			', '\n暂无\n			'),
(3077, '0:4:10', '如蚁慕膻', '\n【 rú　yǐ　mù　shān 】\n			', '\n膻：羊肉的气味。象蚂蚁趋附羊肉一般。比喻许多臭味相投的人追求不好的事物。也比喻许多人依附有钱有势的人。\n			', '\n《庄子·徐无鬼》：“羊肉不慕蚁，蚁慕羊肉，羊肉膻也。”\n			', '\n士趋其门，～。\n			'),
(3078, '0:4:10', '先驱蝼蚁', '\n【 xiān　qū　lóu　yǐ 】\n			', '\n蝼蚁：蝼蛄和蚂蚁。自己先死埋葬地下，为别人驱除蝼蚁。比喻效命于人，不惜先死。\n			', '\n《战国策·楚策》：“臣入则编席，出则陪乘。大王万岁千秋之后，愿得以身试黄泉，蓐蝼蚁。”\n			', '\n人以寿为欢，老臣以寿为戚。既不能～，乃复频见此事。（明·李贽《初潭集·君臣二》）\n			'),
(3079, '0:4:10', '蝇攒蚁附', '\n【 yíng　cuán　yǐ　fù 】\n			', '\n犹蝇营蚁聚。比喻不顾谦耻，趋炎附势，到处钻营。\n			', '\n《醒世恒言·杜子春三入长安》：“那子春平时的一起宾客，闻得他自长安还后，带得好几万银子来，依旧做了财主，无不趋奉，似蝇攒蚁附一般，因而撺掇他重妆气象，再整风流。”\n			', '\n暂无\n			'),
(3080, '0:4:10', '蝇攒蚁聚', '\n【 yíng　cuán　yǐ　jù 】\n			', '\n比喻人众多杂沓，聚集一处。同“蝇飞蚁聚”。\n			', '\n《天雨花》第十五回：“今据尔等言明白，不过为此些些小事情，本来都是良百姓，只为着心坚奉佛神，要杀教主一个人，是以蝇攒蚁聚这般行。”\n			', '\n暂无\n			'),
(3081, '0:4:10', '蚁萃螽集', '\n【 yǐ　cuì　zhōng　jí 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n《宋书·袁淑传》：“羯寇遗丑，趋致畿甸，蚁萃螽集，闻以崩殪。”\n			', '\n暂无\n			'),
(3082, '0:4:10', '蚁斗蜗争', '\n【 yǐ　dòu　wō　zhēng 】\n			', '\n比喻微末的争斗。\n			', '\n宋·刘克庄《和仲弟》之四：“蚁斗蜗争求予没，老夫身世自难裁。”\n			', '\n暂无\n			'),
(3083, '0:4:10', '蚁附蜂屯', '\n【 yǐ　fù　fēng　tún 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n严复《原强》：“一旦有急，则蚁附蜂屯，授之以扞格不操之利器，曳兵而走，转以奉敌。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(3084, '0:4:10', '蚁封穴雨', '\n【 yǐ　fēng　xué　yǔ 】\n			', '\n蚂蚁聚土洞口，是要下大雨的征兆。\n			', '\n汉·焦延寿《易林》卷十三：“蚁封户穴，大雨将集。”\n			', '\n暂无\n			'),
(3085, '0:4:10', '蚁附蝇集', '\n【 yǐ　fù　yíng　jí 】\n			', '\n形容趋附者之多。\n			', '\n明·沈德符《野获编·兵部·武臣好文》：“山人辈作队趋之，随军转徙，无不称季馨词宗先生，蚁附蝇集，去而复来。”\n			', '\n暂无\n			'),
(3086, '0:4:10', '蝇飞蚁聚', '\n【 yíng　fēi　yǐ　jù 】\n			', '\n比喻人众多杂沓，聚集一处。\n			', '\n《隋书·高祖纪上》：“申部残贼，充斥一隅，蝇飞蚁聚，攻州略地。”\n			', '\n暂无\n			'),
(3087, '0:4:10', '以骨去蚁', '\n【 yǐ　gǔ　qù　yǐ 】\n			', '\n用肉驱赶蚂蚁，蚂蚁越多。比喻行为和目的自相矛盾，只能得到相反的结果。同“以肉去蚁”。\n			', '\n南朝·梁元帝《金楼子·立言下》：“以骨去蚁，蚁愈多；以鱼驱蝇，蝇愈至。”\n			', '\n暂无\n			'),
(3088, '0:4:10', '蚁集蜂攒', '\n【 yǐ　jí　fēng　cuán 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n明·宋濓《赠行军镇抚迈里古思平寇诗序》：“栝寇复兴，蚁集蜂攒，众号数万，遂陷婺之永康。”\n			', '\n暂无\n			'),
(3089, '0:4:10', '蚁聚蜂攒', '\n【 yǐ　jù　fēng　cuán 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n南朝·齐·孔稚珪《上和虏表》：“蚁聚蜂攒，穷诛不尽。马足毛群，难与竞逐。”\n			', '\n暂无\n			'),
(3090, '0:4:10', '蚁聚蜂屯', '\n【 yǐ　jù　fēng　tún 】\n			', '\n屯：聚集。像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n清·吴伟业《雁门尚书行》：“蚁聚蜂屯已入城，持矛瞋目呼狂贼。”\n			', '\n夫自东汉以迄于明，其间学士词人，～，不可计数。\n			'),
(3091, '0:4:10', '蝇集蚁附', '\n【 yíng　jí　yǐ　fù 】\n			', '\n犹蝇营蚁聚。比喻不顾谦耻，趋炎附势，到处钻营。\n			', '\n《明史·阉党传·崔呈秀》：“暮夜乞怜者，莫不缘呈秀以进，蝇集蚁附，其门如市。”\n			', '\n暂无\n			'),
(3092, '0:4:10', '蚁溃鼠骇', '\n【 yǐ　kuì　shǔ　hài 】\n			', '\n形容敌军惊骇溃逃。\n			', '\n唐·柳宗元《剑门铭序》：“左师出于剑门，大攘顽嚚，谕引劫胁，蚁溃鼠骇，险无以固，收夺利地，以须王师。”\n			', '\n暂无\n			'),
(3093, '0:4:10', '以肉去蚁', '\n【 yǐ　ròu　qù　yǐ 】\n			', '\n用肉驱赶蚂蚁，蚂蚁越多。比喻行为和目的自相矛盾，只能得到相反的结果。\n			', '\n《韩非子·外储说左下》：“以肉去蚁，蚁愈多；以鱼驱蝇，蝇愈至。”\n			', '\n暂无\n			'),
(3094, '0:4:10', '云屯蚁聚', '\n【 yún　tún　yǐ　jù 】\n			', '\n形容众多的人物聚集在一起。\n			', '\n元·柯丹邱《荆钗记·春科》：“天下英才，云屯蚁聚。”\n			', '\n暂无\n			'),
(3095, '0:4:10', '蚁穴坏堤', '\n【 yǐ　xué　huài　dī 】\n			', '\n比喻小事不注意，就会出大乱子。同“蚁穴溃堤”。\n			', '\n清·钱谦益《向言下》之五：“蛇螫断腕，蚁穴坏堤，史臣之所以俯仰三汉者也。”\n			', '\n暂无\n			'),
(3096, '0:4:10', '蚁穴溃堤', '\n【 yǐ　xué　kuì　dī 】\n			', '\n小小的蚂蚁窝，能够使堤岸溃决。比喻小事不注意，就会出大乱子。\n			', '\n三国魏·应璩《杂诗》：“细微可不慎，堤溃自蚁穴。”\n			', '\n暂无\n			'),
(3097, '0:4:10', '蚁穴自封', '\n【 yǐ　xué　zì　fēng 】\n			', '\n比喻以区区之地方自主独立。\n			', '\n清·照槤《啸亭杂录·缅甸归诚本末》：“且明置缅甸宣慰司，表内未称宣旧衔；又有蚁穴自封，夜郎天外之言。”\n			', '\n暂无\n			'),
(3098, '0:4:10', '蚁拥蜂攒', '\n【 yǐ　yōng　fēng　cuán 】\n			', '\n比喻集结者众多。同“蚁萃螽集”。\n			', '\n《三元里人民抗英斗争史料·广东军务记》：“乡民蚁拥蜂攒，布满山麓，约有十余万众。”\n			', '\n暂无\n			'),
(3099, '0:4:10', '蝇营蚁附', '\n【 yíng　yíng　yǐ　fù 】\n			', '\n比喻不顾谦耻，趋炎附势，到处钻营。同“蝇营蚁聚”。\n			', '\n清·顾炎武《与潘次耕札》之二：“吾以六十四之舅氏，主于其家，见彼蝇营蚁附之流，骇人耳闻。”\n			', '\n暂无\n			'),
(3100, '0:4:10', '蝇营蚁聚', '\n【 yíng　yíng　yǐ　jù 】\n			', '\n像苍蝇样往来飞逐，像蚂蚁般纷纷聚集。比喻不顾谦耻，趋炎附势，到处钻营。\n			', '\n明·梅鼎祚《玉合记·卜居》：“朝列，蝇营蚁聚还竞扰，这余膻怎污颊，算自有峰头玉版，鼎中金屑。”\n			', '\n暂无\n			'),
(3101, '0:4:11', '不待蓍龟', '\n【 bù　dài　shī　guī 】\n			', '\n蓍龟：古时卜筮，用蓍草和龟甲，以卜吉凶。不用占卜就能决定。比喻事情是明摆着的，非常清楚。\n			', '\n《周易·系辞上》：“探赜索隐，钩深致远，以定天下之吉凶，成天下之亹亹者，莫大乎蓍龟。”\n			', '\n暂无\n			'),
(3102, '0:4:11', '不龟手药', '\n【 bù　guī　shǒu　yào 】\n			', '\n①使手不冻裂的药。②比喻微才薄技。\n			', '\n《陆游诗集卷二十二·寓叹》：“人生各自有穷通，世事宁论拙与工。裹马革心空许国，不龟手药却成功。早朝玉勒千门雪，夜坐蓬窗万壑风。借得奇书且勤读，小儿能续地炉红。”\n			', '\n暂无\n			'),
(3103, '0:4:11', '蝉腹龟肠', '\n【 chán　fù　guī　cháng 】\n			', '\n古人认为蝉只须饮露，乌龟只要喝水。比喻饥饿之极。\n			', '\n《南史·檀珪传》：“珪诉虔求禄不得，与僧虔书曰：‘蝉腹龟蛇，为日已久’”\n			', '\n暂无\n			'),
(3104, '0:4:11', '传龟袭紫', '\n【 chuán　guī　xí　zǐ 】\n			', '\n指继承高爵显位。汉制，公侯皆佩紫绶龟纽金印。\n			', '\n《后汉书·阴识传赞》：“恂恂苗胤，传龟袭紫。”李贤注：“公侯紫绶金印龟纽。”\n			', '\n夫孝者，非以～为也，非以玉帛充牣为也。\n			'),
(3105, '0:4:11', '鼎玉龟符', '\n【 dǐng　yù　guī　fú 】\n			', '\n旧指传国之宝及受命之符箓。\n			', '\n清·叶廷琯《海录碎事·帝王上》：“干戈揖让取之也殊途，鼎玉龟符成之也一致。”\n			', '\n暂无\n			'),
(3106, '0:4:11', '诟龟呼天', '\n【 gòu　guī　hū　tiān 】\n			', '\n原意为占卜不吉，对占卜器具及天辱骂呼叫。引申为对不幸命运的呼号。\n			', '\n《浅论儒家的孝道·再兴国学》：“八十多年前，时人发愤于国之积弱，诟龟呼天。一批深受西学影响又急欲救亡图强的激进青年，以胡适、陈独秀为主将，发起了一场中国近代以来反孔非儒的高潮——‘五四新文化革命运动’”。\n			', '\n暂无\n			'),
(3107, '0:4:11', '龟鹤遐龄', '\n【 guī　hè　xiá　líng 】\n			', '\n遐：长久。遐龄：高寿。传说龟、鹤都能活一千年。比喻长寿。亦作“龟龄鹤算”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3108, '0:4:11', '龟鹤遐寿', '\n【 guī　hè　xiá　shòu 】\n			', '\n遐：长久。祝人长寿的颂辞。\n			', '\n《抱朴子·对俗》：“知龟鹤之遐寿，故效其道引以增年。”\n			', '\n暂无\n			'),
(3109, '0:4:11', '龟龄鹤算', '\n【 guī　líng　hè　suàn 】\n			', '\n比喻人之长寿。或用作祝寿之词。同“龟年鹤寿”。\n			', '\n宋·侯寘《水调歌头·为郑子礼提刑寿》词：“坐享龟龄鹤算，稳佩金鱼玉带，常近赭黄袍。”\n			', '\n表长年。傲～，永劫绵绵。\n			'),
(3110, '0:4:11', '龟龙鳞凤', '\n【 guī　lóng　lín　fèng 】\n			', '\n传统上用来象征高寿、尊贵、吉祥的四种动物。比喻身处高位德盖四海的人。\n			', '\n《汉书·翟方进传》：“太皇太后临政，有龟龙鳞凤之应。”\n			', '\n暂无\n			'),
(3111, '0:4:11', '龟龙麟凤', '\n【 guī　lóng　lín　fèng 】\n			', '\n传统上用来象征高寿、尊贵、吉祥的四种动物。比喻身处高位德盖四海的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3112, '0:4:11', '龟龙片甲', '\n【 guī　lóng　piàn　jiǎ 】\n			', '\n比喻无论巨细都搜罗进来的好东西。\n			', '\n唐·张怀瓘《书议》：“麟凤一毛，龟龙片甲，亦无所不录。”\n			', '\n暂无\n			'),
(3113, '0:4:11', '龟冷支床', '\n【 guī　lěng　zhī　chuáng 】\n			', '\n比喻壮志未酬，蛰居待时。\n			', '\n《史记·龟策列传褚少孙论》：“南方老人用龟支床足，行二十余岁，老人死，移床，龟尚生不死。”\n			', '\n暂无\n			'),
(3114, '0:4:11', '龟冷搘床', '\n【 guī　lěng　zhī　chuáng 】\n			', '\n比喻壮志未酬，蛰居待时。\n			', '\n西汉·司马迁《史记·龟策列传褚少孙论》：“南方老人用龟支床足，行二十余岁，老人死，移床，龟尚生不死。”\n			', '\n骥衰伏枥心千里，～寿百年。\n			'),
(3115, '0:4:11', '龟毛兔角', '\n【 guī　máo　tù　jiǎo 】\n			', '\n乌龟身上生毛，兔子头上长角。比喻不可能存在或有名无实的东西。\n			', '\n晋·干宝《搜神记》卷六：“商纣之时，大龟生毛兔生角，兵甲将兴之象也。”\n			', '\n～，岂是有邪？（宋·释普济《五灯会元》卷五）\n			'),
(3116, '0:4:11', '龟年鹤寿', '\n【 guī　nián　hè　shòu 】\n			', '\n相传龟、鹤寿有千百之数，而用于比喻人之长寿。或用作祝寿之词。\n			', '\n唐·李商隐《祭张书记文》：“神道甚微，天理难究，桂蠹兰败，龟年鹤寿。”\n			', '\n祝老爷爷～。\n			'),
(3117, '0:4:11', '龟年鹤算', '\n【 guī　nián　hè　suàn 】\n			', '\n比喻人之长寿。或用作祝寿之词。同“龟年鹤寿”。\n			', '\n宋·韦骧《醉蓬莱·廷评庆寿》词：“惟愿增高，龟年鹤算，鸿恩紫诏。”\n			', '\n暂无\n			'),
(3118, '0:4:11', '龟文鸟迹', '\n【 guī　wén　niǎo　jì 】\n			', '\n指古代的象形文字。\n			', '\n唐·张彦远《法书要录》第七卷：“颉首四目，通于神明，仰观奎星圆曲之势，俯察龟文鸟迹之象，博彩众美，合而为字，是曰古文。”\n			', '\n暂无\n			'),
(3119, '0:4:11', '龟厌不告', '\n【 guī　yàn　bù　gào 】\n			', '\n指屡加龟卜，致使龟灵厌恶，不再以吉凶告人。比喻很有效的东西，过度使用也会失灵。\n			', '\n《诗经·小雅·小旻》：“我龟既厌，不我告犹。”\n			', '\n暂无\n			'),
(3120, '0:4:11', '龟玉毁椟', '\n【 guī　yù　huǐ　dú 】\n			', '\n龟甲和宝玉在匣中被毁坏。比喻辅佐之臣失职而使国运毁败。\n			', '\n《论语·季氏》：“虎儿出於柙，龟玉毁于椟中，是谁之过与？”\n			', '\n暂无\n			'),
(3121, '0:4:11', '金龟换酒', '\n【 jīn　guī　huàn　jiǔ 】\n			', '\n解下金龟换美酒。形容为人豁达，恣情纵酒。\n			', '\n唐·李白《对酒忆贺监诗序》：“太子宾客贺公，于长安紫极宫一见余，呼余为‘谪仙人’，因解金龟，换酒为乐。”\n			', '\n暂无\n			'),
(3122, '0:4:11', '鸡胸龟背', '\n【 jī　xiōng　guī　bèi 】\n			', '\n凸胸驼背。\n			', '\n章炳麟《新方言·释形体》：“《说文》：‘奚，大腹也。’今人谓匈（胸）腹间大者为奚匈，呼如鸡匈，遂有‘鸡胸龟背’之语。”\n			', '\n暂无\n			'),
(3123, '0:4:11', '麟凤龟龙', '\n【 lín　fèng　guī　lóng 】\n			', '\n此四种神灵动物，象征吉兆。比喻稀有珍贵的东西。也比喻品格高尚、受人敬仰的人。\n			', '\n《礼记·礼运》：“麟凤龟龙，谓之四灵。”\n			', '\n暂无\n			'),
(3124, '0:4:11', '兔角龟毛', '\n【 tu　jiao　gui　mao 】\n			', '\n兔生角，龟长毛。都是没有的事。比喻有名无实。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3125, '0:4:11', '无待蓍龟', '\n【 wú　dài　shī　guī 】\n			', '\n待：等待；蓍龟：蓍草和龟甲，古人用以占卜。不等着用蓍草和龟甲占卜，而吉凶已经大白。表示事态发展显而易见。\n			', '\n《周易·系辞上》：“探赜索隐，钩深致远，以定天下吉凶，成天下之娓娓者，莫大乎蓍龟。”\n			', '\n夫以中华全力，受制潢池，而欲从江左一隅，兼支大国，胜负之数，～矣。\n			'),
(3126, '0:4:11', '犀顶龟文', '\n【 xī　dǐng　guī　wén 】\n			', '\n头顶骨隆起如犀角，脚掌上有龟背纹。旧时所谓贵人之相。\n			', '\n语出《后汉书·李固传》：“固貌状有奇表，鼎角匿犀，足履龟文。”\n			', '\n～何肯相，雷光泡影认眉须。\n			'),
(3127, '0:4:11', '悬龟系鱼', '\n【 xuán　guī?jì　yú 】\n			', '\n指任高官显宦。\n			', '\n《新唐书·车服志》：“高宗给五品以上随身鱼袋……天授二年，改佩鱼为?。其后三品以上龟袋饰以金，四品以银，五品以铜。中宗初，罢龟袋，复给以鱼。”\n			', '\n数世之后，将振振绳绳，～，秉钧当轴。\n			'),
(3128, '0:4:11', '援鳖失龟', '\n【 yuán　biē　shī　guī 】\n			', '\n比喻得不偿失。\n			', '\n《淮南子·说山训》：“杀戎马而求狐狸，援两鳖而失灵龟，断右臂而争一毛，折莫邪而争锥刀，用智如此，岂足高乎？”\n			', '\n暂无\n			'),
(3129, '0:4:11', '证龟成鳖', '\n【 zhèng　guī　chéng　biē 】\n			', '\n将乌龟说成甲鱼。比喻蓄意歪曲，颠倒是非。\n			', '\n宋苏轼《东坡志林·贾氏五不可》：“晋武帝欲为太子娶妇。卫瓘曰：‘贾氏有五不可：青、黑、短、妒而无子。’竟为群臣所誉娶之，竟以亡晋。……俚语曰‘证龟成鳖’，此未足怪也。以此观之、当云‘证龟成蛇’。……”\n			', '\n暂无\n			'),
(3130, '0:4:11', '凿龟数策', '\n【 záo　guī　shǔ　cè 】\n			', '\n凿龟：钻灼龟甲，看灼开的裂纹推测吉凶；数策：数蓍草的茎，从分组计数中判断吉凶。指古人用龟甲蓍草来卜筮吉凶。\n			', '\n《韩非子·饰邪》：“赵又尝凿龟数策而北伐燕，将劫燕以逆秦，兆曰大吉。”\n			', '\n暂无\n			'),
(3131, '0:4:12', '虫沙猿鹤', '\n【 chóng　shā　yuán　hè 】\n			', '\n旧时比喻战死的将士。也指死于战乱的人。\n			', '\n《太平御览》卷九一六引《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小从为虫为沙。”\n			', '\n穆昔南征军不归，～伏似飞。（唐·韩愈《送区弘南归诗》）\n			'),
(3132, '0:4:12', '蜂腰猿背', '\n【 fēng　yāo　yuán　bèi 】\n			', '\n细腰窄背。形容轻盈俊俏。\n			', '\n清·曹雪芹《红楼梦》第四十九回：“腰里紧紧束着一条蝴蝶结子长穗五色宫绦，脚下也穿着鹿皮小靴：越显得蜂腰猿背，鹤势螂形。”\n			', '\n暂无\n			'),
(3133, '0:4:12', '鹤唳猿声', '\n【 hè　lì　yuán　shēng 】\n			', '\n鹤鸣猿啼。形容凄清孤寂的景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3134, '0:4:12', '狐媚猿攀', '\n【 hú　mèi　yuán　pān 】\n			', '\n像狐狸那样善于迷惑人，像猿猴那样善于攀高。比喻不择手段地追求名利。\n			', '\n明·刘体乾《财用诎乏恳乞圣明节省疏》：“其间狐媚猿攀，途辙不一；蝇营狗窃，窠臼且多，臣不能悉奉。”\n			', '\n暂无\n			'),
(3135, '0:4:12', '鹤怨猿惊', '\n【 hè　yuàn　yuán　jīng 】\n			', '\n形容对官场厌倦，有意归隐的心情。\n			', '\n宋·辛弃疾《沁园春·带湖新居将成》词：“三径初成，鹤怨猿惊，稼轩未来。”\n			', '\n搔首倚薰风，一幅画图尘土中。～人去也，潜龙。谁绞香车起蛰松。\n			'),
(3136, '0:4:12', '惊猿脱兔', '\n【 jīng　yuán　tuō　tù 】\n			', '\n如受惊的猿猴、脱逃的兔子。形容迅速奔逃。\n			', '\n清·吴敬梓《儒林外史》第四十三回：“还亏得苗子的脚底板厚，不怕巉岩荆棘，就如惊猿脱兔，漫山越岭的逃散了。”\n			', '\n暂无\n			'),
(3137, '0:4:12', '笼鸟槛猿', '\n【 lóng　niǎo　jiàn　yuán 】\n			', '\n笼中鸟槛中猿。比喻受拘禁没有自由的人。\n			', '\n唐·白居易《山中与元九书因题书后》诗：“笼鸟槛猿俱未死，人间相见是何年！”\n			', '\n暂无\n			'),
(3138, '0:4:12', '鸟哭猿啼', '\n【 niǎo　kū　yuán　tí 】\n			', '\n泛指禽兽悲鸣。形容悲凉的情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3139, '0:4:12', '穷猿奔林', '\n【 qióng　yuán　bēn　lín 】\n			', '\n穷猿：被猎人紧追的猿猴。比喻在穷困中急于找一个栖身的地方。\n			', '\n南朝宋·刘义庆《世说新语·言语》：“北门之叹，久已上闻。穷猿奔林，岂暇择木。”\n			', '\n暂无\n			'),
(3140, '0:4:12', '穷猿投林', '\n【 qióng　yuán　tóu　lín 】\n			', '\n穷猿：被猎人紧追的猿猴。比喻在穷困中急于找一个栖身的地方。\n			', '\n《晋书·李充传》：“穷猿投林，岂睱择木。”\n			', '\n暂无\n			'),
(3141, '0:4:12', '亡猿祸木', '\n【 wáng　yuán　huò　mù 】\n			', '\n比喻欲损人反而害己的行为。\n			', '\n《渊鉴类函》卷四三二引《汀州志》：“唐大历中，有猴数百集古田杉林中，里人欲伐木杀之。中一老猴忽跃去近邻一家纵火焚屋。里人惧，亟走救火，于是群猴脱去。”\n			', '\n暂无\n			'),
(3142, '0:4:12', '亡猿灾木', '\n【 wáng　yuán　zāi　mù 】\n			', '\n比喻欲损人反而害己的行为。同“亡猿祸木”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3143, '0:4:12', '心猿意马', '\n【 xīn　yuán　yì　mǎ 】\n			', '\n心意好象猴子跳、马奔跑一样控制不住。形容心里东想西想，安静不下来。\n			', '\n汉·魏伯阳《参同契》注：“心猿不定，意马四驰。”唐·许浑《题杜居士》诗：“机尽心猿伏，神闲意马行。”\n			', '\n俺从今把～紧牢拴，将繁华不挂眼。（元·关汉卿《望江亭》第一折）\n			'),
(3144, '0:4:12', '猿悲鹤怨', '\n【 yuán　bēi　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n宋·朱熹《送籍溪胡丈赴馆供职》诗之二：“猿悲鹤怨因何事？只恐先生袖手归。”\n			', '\n暂无\n			'),
(3145, '0:4:12', '猿鹤虫沙', '\n【 yuán　hè　chóng　shā 】\n			', '\n旧时比喻战死的将士。也指死于战乱的人。\n			', '\n《太平御览》卷九六一引《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小人为虫为沙。”唐·韩愈《送区弘南归诗》：“穆昔南征军不归，虫沙猿鹤伏似飞。”\n			', '\n暂无\n			'),
(3146, '0:4:12', '猿猴取月', '\n【 yuán　hóu　qǔ　yuè 】\n			', '\n比喻愚昧无知。也比喻白费力气。\n			', '\n宋·黄庭坚《沁园春》词：“镜里拈花，水中捉月，觑着无由得近伊。”\n			', '\n暂无\n			'),
(3147, '0:4:12', '猿鹤沙虫', '\n【 yuán　hè　shā　chóng 】\n			', '\n指阵亡的将士或死于战乱的人民。\n			', '\n《艺文类聚》卷九十引晋葛洪《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小人为虫为沙。”按，今本《抱朴子·释滞》作：“山徙社移，三军之众，一朝尽化，君子为鹤，小人成沙。”\n			', '\n你看山川图画，人物衣冠，生聚年时久，忍下得咸阳一炬里变焦丘，～满地愁。\n			'),
(3148, '0:4:12', '猿惊鹤怨', '\n【 yuán　jīng　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n宋·王阮《秋日寄舍弟》诗：“猿惊鹤怨草三尺，楚尾吴头天一方。”\n			', '\n暂无\n			'),
(3149, '0:4:12', '意马心猿', '\n【 yì　mǎ　xīn　yuán 】\n			', '\n形容心思不定，好象猴子跳、马奔跑一样控制不住。\n			', '\n汉·魏伯阳《参同契》注：“心猿不定，意马四驰。”唐·许浑《题杜居士》诗：“机尽心猿伏，神闲意马行。”\n			', '\n～萦梦寐，河鱼天雁托音书。（清·吴趼人《二十年目睹之怪现状》第五回）\n			'),
(3150, '0:4:12', '猿啼鹤唳', '\n【 yuán　tí　hè　lì 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n明·施耐庵《水浒传》第五十三回：“两崖分虎踞龙盘，四面有猿啼鹤唳。”\n			', '\n暂无\n			'),
(3151, '0:4:12', '猿啼鹤怨', '\n【 yuán　tí　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n明·汤显祖《牡丹亭·御淮》：“听得猿啼鹤怨，泪湿征袍如汗。”\n			', '\n暂无\n			'),
(3152, '0:4:12', '猿穴坏山', '\n【 yuán　xué　huài　shān 】\n			', '\n比喻小事不注意，就会造成大灾祸。\n			', '\n汉·孔融《临终》诗：“河溃蚁孔端，山坏由猿穴。”\n			', '\n暂无\n			'),
(3153, '0:4:13', '扳龙附凤', '\n【 bān　lóng　fù　fèng 】\n			', '\n指依附龙凤而升空。\n			', '\n南朝·梁·沈约《宋书》志第十二乐四：“弹琴鼓瑟，聊以自娱。陵云登台，浮游太清。扳龙附凤，日望身轻。”\n			', '\n暂无\n			'),
(3154, '0:4:13', '百鸟朝凤', '\n【 bǎi　niǎo　cháo　fèng 】\n			', '\n朝：朝见；凤：凤凰，古代传说中的鸟王。旧时喻指君主圣明而天下依附，后也比喻德高望重者众望所归。\n			', '\n宋·李昉等《太平御览》九百一十五卷引《唐书》：“海州言凤见于城上，群鸟数百随之，东北飞向苍梧山。”\n			', '\n那些玉斝中的长春露酒也都由站在身边侍候的宫女接过去倾入一只绘着～的大瓷缸中。（姚雪垠《李自成》第二卷第三十一章）\n			'),
(3155, '0:4:13', '雏凤清声', '\n【 chú　fèng　qīng　shēng 】\n			', '\n雏凤：比喻优秀子弟；清声：清越的鸣声。比喻后代子孙更有才华。\n			', '\n唐·李商隐《寄韩冬郎兼长之员外》：“桐花万里丹山路，雏凤清于老凤声。”\n			', '\n暂无\n			'),
(3156, '0:4:13', '彩凤随鸦', '\n【 cǎi　fèng　suí　yā 】\n			', '\n比喻女子嫁给才貌配不上好的人。\n			', '\n《事文类聚》：“杜大中起于行伍，妾能词，有‘彩凤随鸦’之句。”\n			', '\n自从加克娶了姑娘，人人都道～，不免纷纷议论。（清·曾朴《孽海花》第十六回）\n			'),
(3157, '0:4:13', '采凤随鸦', '\n【 cǎi　fèng　suí　yā 】\n			', '\n比喻才貌出众的女子嫁给远不如自己的男人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3158, '0:4:13', '乘鸾跨凤', '\n【 chéng　luán　kuà　fèng 】\n			', '\n乘鸾：求得佳偶。比喻结成美好的佳偶。\n			', '\n<span class="C999">暂无</span>\n			', '\n……只留下伊行笔踪就不怕事成空，准备着～。（清·李渔《慎鸾交·债饵》）\n			'),
(3159, '0:4:13', '乘龙配凤', '\n【 chéng　lóng　pèi　fèng 】\n			', '\n比喻得佳偶，结良缘。\n			', '\n柳琴戏《状元打更》：“沈文素呀！沈文素！你蟾宫折桂，莫大还有乘龙配凤的好运么？”\n			', '\n暂无\n			'),
(3160, '0:4:13', '朝阳丹凤', '\n【 cháo　yáng　dān　fèng 】\n			', '\n比喻贤才逢明时。\n			', '\n《诗经·大雅·卷阿》：“凤凰鸣矣，于彼高冈。梧桐生矣，于彼朝阳。”\n			', '\n暂无\n			'),
(3161, '0:4:13', '丹凤朝阳', '\n【 dān　fèng　cháo　yáng 】\n			', '\n比喻贤才逢明时。\n			', '\n《诗经·大雅·卷阿》：“凤凰鸣矣，于彼高冈。梧桐生矣，于彼朝阳。”\n			', '\n前后同心八谏臣，朝阳丹凤一齐鸣。除奸反正扶明主，留得功勋耀古今。（明·王世贞《鸣凤记》第一出）\n			'),
(3162, '0:4:13', '倒凤颠鸾', '\n【 dǎo　fèng　diān　luán 】\n			', '\n比喻顺序失常。旧小说用来形容男女交欢。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3163, '0:4:13', '打凤捞龙', '\n【 dǎ　fèng　lāo　lóng 】\n			', '\n凤、龙：这里指人才。比喻搜索、物色难得的人才。\n			', '\n元·朱凯《昊天塔》第一折：“也不须打凤捞龙，别选元戎。”\n			', '\n暂无\n			'),
(3164, '0:4:13', '打凤牢龙', '\n【 dǎ　fèng　láo　lóng 】\n			', '\n比喻安排圈套使强有力的对手中计。\n			', '\n元·关汉卿《单刀会》第三折：“安排下打凤牢龙，准备着天罗地网，也不是待客筵席，则是个杀人、杀人的战场。”\n			', '\n暂无\n			'),
(3165, '0:4:13', '颠鸾倒凤', '\n【 diān　luán　dǎo　fèng 】\n			', '\n比喻顺序失常。旧小说用来形容男女交欢。\n			', '\n元·王实甫《西厢记》第四本第二折：“你绣帷里效绸缪，颠鸾倒凤百事有。”\n			', '\n暂无\n			'),
(3166, '0:4:13', '雕龙画凤', '\n【 diāo　lóng　huà　fèng 】\n			', '\n刻绘龙凤。\n			', '\n胡世香《巧取陈家寨》：“门上雕龙画凤，粉壁衬着红漆家具，分外耀眼。”\n			', '\n暂无\n			'),
(3167, '0:4:13', '凤泊鸾漂', '\n【 fèng　bó　luán　piāo 】\n			', '\n飘、泊：随流飘荡。原形容书法笔势潇洒飘逸，后比喻夫妻离散或文人失意。\n			', '\n唐·韩愈《峋嵝山》诗：“科斗拳身薤倒披，鸾飘凤泊拏虎螭。”\n			', '\n神清骨冷何由俗，～信可哀。\n			'),
(3168, '0:4:13', '凤泊鸾飘', '\n【 fèng　bó　luán　piāo 】\n			', '\n比喻有才之人不得志，飘泊无定。\n			', '\n清·全祖望《\n			', '\n～吾辈事，未须憔悴诉生平。\n			'),
(3169, '0:4:13', '凤表龙姿', '\n【 fèng　biǎo　lóng　zī 】\n			', '\n形容英俊的仪表。\n			', '\n明·张凤翼《红拂记·俊杰知时》：“瞥然一见，凤表龙姿自出群，雌雄胜负隐然分。”\n			', '\n暂无\n			'),
(3170, '0:4:13', '凤愁鸾怨', '\n【 fèng　chóu　luán　yuàn 】\n			', '\n比喻夫妻间因思念而生的愁怨。\n			', '\n明·王玉峰《梦香记·饯别》：“无奈分离一旦，你功名傥万全，也思恩爱有三年。苦只为鹗荐鹏骞，博得凤愁鸾怨。”\n			', '\n暂无\n			'),
(3171, '0:4:13', '凤采鸾章', '\n【 fèng　cǎi　luán　zhāng 】\n			', '\n形容诗文的文采华丽。\n			', '\n南朝·梁·沈约《谢齐竟陵王示永明乐歌启》：“凤采鸾章，霞鲜锦缛。”\n			', '\n暂无\n			'),
(3172, '0:4:13', '凤彩鸾章', '\n【 fèng　cǎi　luán　zhāng 】\n			', '\n形容诗文的文采华丽。\n			', '\n南朝·梁·沈约《谢齐竟陵王示永明乐歌启》：“凤彩鸾章，霞鲜锦缛。”\n			', '\n暂无\n			'),
(3173, '0:4:13', '凤雏麟子', '\n【 fèng　chú　lín　zǐ 】\n			', '\n比喻贵族子孙或称誉佳子弟。\n			', '\n唐·李咸用《轻薄怨》诗：“凤雏麟子皆至交，春风相逐垂杨桥。”\n			', '\n暂无\n			'),
(3174, '0:4:13', '分钗劈凤', '\n【 fēn　chāi　pī　fèng 】\n			', '\n比喻夫妻的离别。同“分钗断带”。\n			', '\n清·钱泳《履园丛话·杂记下·刘王氏》：“[县令]乃赋一诗刻诸墓上云：‘分钗劈凤已联年，就义何妨晚慨愆。’”\n			', '\n暂无\n			'),
(3175, '0:4:13', '凤附龙攀', '\n【 fèng　fù　lóng　pān 】\n			', '\n指依附帝王权贵建功立业。\n			', '\n汉·扬雄《法言·渊骞》：“攀龙鳞，附凤翼。”\n			', '\n我明载兴，公值其际，～，风飞雷厉。\n			'),
(3176, '0:4:13', '附凤攀龙', '\n【 fù　fèng　pān　lóng 】\n			', '\n指巴结投靠有权势的人以获取富贵。\n			', '\n汉·扬雄《法言·渊骞》：“攀龙鳞，附凤翼。”\n			', '\n暂无\n			'),
(3177, '0:4:13', '凤管鸾笙', '\n【 fèng　guǎn　luán　shēng 】\n			', '\n笙箫之乐的美称。\n			', '\n明·廷讷《狮吼记·访友》：“歌儿舞女朝朝醉，凤管鸾笙步步随。”\n			', '\n暂无\n			'),
(3178, '0:4:13', '凤歌鸾舞', '\n【 fèng　gē　luán　wǔ 】\n			', '\n神鸟歌舞。比喻美妙的歌舞。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3179, '0:4:13', '凤管鸾箫', '\n【 fèng　guǎn　luán　xiāo 】\n			', '\n笙箫之乐的美称。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第四十六回：“听一派凤管鸾箫，见一簇翠围珠绕。”\n			', '\n暂无\n			'),
(3180, '0:4:13', '凤骨龙姿', '\n【 fèng　gǔ　lóng　zī 】\n			', '\n形容超凡的体格和仪态。\n			', '\n《云笈七签》卷四：“今视子之质，实霄景高焕，圆精重照，凤骨龙姿，脑色宝曜。”\n			', '\n暂无\n			'),
(3181, '0:4:13', '凤冠霞帔', '\n【 fèng　guān　xiá　pèi 】\n			', '\n旧时富家女子出嫁时的装束，以示荣耀。也指官员夫人的礼服。\n			', '\n元·杨显之《潇湘雨》第四折：“解下了这金花八宝凤冠儿，解下了这云霞五彩帔肩儿，都送与张家小姐妆台次，我甘心倒做了梅香听使。”\n			', '\n择了吉日迎娶，一般的鼓乐彩舆，～，花烛拜堂，成了好事。（清·吴趼人《二十年目睹之怪现状》第五十八回）\n			'),
(3182, '0:4:13', '凤凰来仪', '\n【 fèng　huáng　lái　yí 】\n			', '\n仪：容仪。凤凰来舞，仪表非凡。古代指吉祥的征兆。\n			', '\n《尚书·益稷》：“《箫韶》九成，凤凰来仪。”\n			', '\n自魏即位以来，麒麟降生，～。（明·罗贯中《三国演义》第八十回）\n			'),
(3183, '0:4:13', '凤皇来仪', '\n【 fèng　huáng　lái　yí 】\n			', '\n凤凰来舞，仪表非凡。古代指吉祥的征兆。同“凤凰来仪”。\n			', '\n《书·益稷》：“《箫韶》九成，凤皇来仪。”\n			', '\n百兽率舞而捵悖???砸怼\n			'),
(3184, '0:4:13', '凤凰于飞', '\n【 fèng　huáng　yú　fēi 】\n			', '\n本指凤和凰相偕而飞。比喻夫妻和好恩爱。常用以祝人婚姻美满。\n			', '\n《诗经·大雅·卷阿》：“凤凰于飞，翙翙其羽。”\n			', '\n暂无\n			'),
(3185, '0:4:13', '凤皇于飞', '\n【 fèng　huáng　yú　fēi 】\n			', '\n比喻夫妻和好恩爱。常用以祝人婚姻美满。同“凤凰于飞”。\n			', '\n《诗经·大雅·卷阿》：“凤凰于飞，刿刿其羽。”\n			', '\n暂无\n			'),
(3186, '0:4:13', '凤皇于蜚', '\n【 fèng　huáng　yú　fēi 】\n			', '\n比喻夫妻和好恩爱。常用以祝人婚姻美满。同“凤凰于飞”。\n			', '\n《史记·田敬仲完世家》：“齐懿仲欲妻完，卜之，占曰：‘是谓凤凰于蜚，和鸣锵锵。’”\n			', '\n暂无\n			'),
(3187, '0:4:13', '凤凰在笯', '\n【 fèng　huáng　zài　nú 】\n			', '\n笯：鸟笼。凤凰被关在笼中。比喻有才能者不能施展报负。\n			', '\n战国·楚·屈原《九章·怀沙》：“凤凰在笯兮，鸡鹜翔舞。”\n			', '\n暂无\n			'),
(3188, '0:4:13', '凤狂龙躁', '\n【 fèng　kuáng　lóng　zào 】\n			', '\n形容心情烦躁，精神失常。\n			', '\n唐·韩偓《喜凉》诗：“炉炭烧人百疾生，凤狂龙躁减心情。”\n			', '\n海枯石烂愁仍在，～转多病。\n			'),
(3189, '0:4:13', '伏龙凤雏', '\n【 fú　lóng　fèng　chú 】\n			', '\n伏龙：（卧龙）诸葛孔明。凤雏：庞士元。两人都是汉末三国时期著名的谋略家，军事家。后指隐而未现的有较高学问和能耐的人。\n			', '\n《三国志·蜀志·诸葛亮传》裴松之注引《襄阳记》：“刘备访世事于司马德操。德操曰：‘儒生俗士，岂识时务？识时务者在乎俊杰。此间自有伏龙、凤雏。’备问为谁，曰：‘诸葛孔明、庞士元也。’\n			', '\n暂无\n			'),
(3190, '0:4:13', '凤楼龙阙', '\n【 fèng　lóu　lóng　què 】\n			', '\n形容华美的宫阙楼台。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3191, '0:4:13', '飞鸾翔凤', '\n【 fēi　luán　xiáng　fèng 】\n			', '\n指英俊才识之士。\n			', '\n明·许三阶《节侠记·侠晤》：“诸公飞鸾翔凤，望重时流。”\n			', '\n暂无\n			'),
(3192, '0:4:13', '凤鸣鹤唳', '\n【 fèng　míng　hè　lì 】\n			', '\n形容优美的声音。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3193, '0:4:13', '凤毛鸡胆', '\n【 fèng　máo　jī　dǎn 】\n			', '\n凤的羽毛，鸡的胆子。比喻外表英武而实际怯弱。\n			', '\n明·罗贯中《三国演义》第三十二回：“羊质虎皮功不就，凤毛鸡胆事难成。”\n			', '\n暂无\n			'),
(3194, '0:4:13', '凤毛济美', '\n【 fèng　máo　jì　měi 】\n			', '\n旧时比喻父亲做官，儿子能继承父业。\n			', '\n<span class="C999">暂无</span>\n			', '\n你不听见说他们世兄即日也要保道台？真正是～，可钦可敬。（清·李宝嘉《官场现形记》第三十四回）\n			'),
(3195, '0:4:13', '凤鸣麟出', '\n【 fèng　míng　lín　chū 】\n			', '\n凤凰鸣唱，麒麟出现。比喻贤人出现。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3196, '0:4:13', '凤靡鸾吪', '\n【 fèng　mǐ　luán　é 】\n			', '\n靡：指凤死；吪：指鸾死。比喻人死。旧时多作挽辞。\n			', '\n《禽经》：“凤靡鸾吪，百鸟瘗之。”\n			', '\n暂无\n			'),
(3197, '0:4:13', '凤毛麟角', '\n【 fèng　máo　lín　jiǎo 】\n			', '\n凤凰的羽毛，麒麟的角。比喻珍贵而稀少的人或物。\n			', '\n《南史·谢超宗传》：“超宗殊有凤毛。”《北史·文苑传序》：“学者如牛毛，成者如麟角。”\n			', '\n全县只考上你一个，无论如何是～。（梁斌《红旗谱》二十）\n			'),
(3198, '0:4:13', '凤毛龙甲', '\n【 fèng　máo　lóng　jiǎ 】\n			', '\n凤的羽毛，龙的鳞甲。比喻珍贵之物。\n			', '\n明·袁中道《石浦先生传》：“旧有传奇二种，置于笥中，为鼠子嚼坏，凤毛龙甲，竟不存于世。”\n			', '\n暂无\n			'),
(3199, '0:4:13', '凤鸣朝阳', '\n【 fèng　míng　zhāo　yáng 】\n			', '\n朝阳：早晨的太阳。凤凰在早晨的阳光中鸣叫。比喻有高才的人得到发挥的机会。\n			', '\n《诗经·大雅·卷阿》：“凤凰鸣矣，于彼高冈；梧桐生矣，于彼朝阳。”\n			', '\n暂无\n			'),
(3200, '0:4:13', '凤髓龙肝', '\n【 fèng　suǐ　lóng　gān 】\n			', '\n比喻珍奇美味。\n			', '\n明·孙仁孺《东郭记·吾将瞷良人之所也》：“他故人情蔼，消受他凤髓龙肝；我寸舌应嚼坏，愧没归遗两女子。”\n			', '\n老孙五百年前大闹天宫时，吃老君丹、玉皇酒，王母桃，及～——那样东西我不曾吃过？\n			'),
(3201, '0:4:13', '凤食鸾栖', '\n【 fèng　shí　luán　qī 】\n			', '\n鸾凤非竹实不食，非悟桐不栖。比喻高位或帝位。\n			', '\n明·张凤翼《红拂记·髯客海归》：“我想起那李公子呵，所事撑达，与他争甚么凤食鸾栖。我自向碧梧中别寻支节。”\n			', '\n暂无\n			'),
(3202, '0:4:13', '凤叹虎视', '\n【 fèng　tàn　hǔ　shì 】\n			', '\n形容谈吐文雅，器宇轩昂。\n			', '\n《文选·曹植〈与吴季重书〉》：“足下鹰扬其体，凤叹虎视，谓萧曹不足俦，卫霍不足侔也。”李善注：“凤以喻文也，虎以喻武也。叹犹歌也。取美壮之意。”\n			', '\n暂无\n			'),
(3203, '0:4:13', '凤舞龙飞', '\n【 fèng　wǔ　lóng　fēi 】\n			', '\n形容书法笔势有力，灵活舒展。\n			', '\n《儿女英雄传》第十回：“只这书法也写得这等凤舞龙飞，真令人拜服。”\n			', '\n暂无\n			'),
(3204, '0:4:13', '凤舞鸾歌', '\n【 fèng　wǔ　luán　gē 】\n			', '\n①形容美妙的歌舞。②仙舞的两支曲名。\n			', '\n唐·宋之问《太平公主山池赋》：“凤舞鸾歌兮俨欲飞，披烟弄月兮宵未归。”\n			', '\n暂无\n			'),
(3205, '0:4:13', '凤舞龙蟠', '\n【 fèng　wǔ　lóng　pán 】\n			', '\n凤凰飞舞，蛟龙盘曲。形容相配得当。\n			', '\n清·文康《儿女英雄传》第二十四回：“不想这一拜，恰恰的合成一个‘名花并蒂’，俨然是金厢玉琢，凤舞龙蟠！”\n			', '\n暂无\n			'),
(3206, '0:4:13', '凤箫龙管', '\n【 fèng　xiāo　lóng　guǎn 】\n			', '\n指笙箫一类管乐的吹奏声。\n			', '\n清·黄永《龙衣舟行》诗：“凤箫龙管穿云去，锦缆牙樯映日月。”\n			', '\n暂无\n			'),
(3207, '0:4:13', '凤箫鸾管', '\n【 fèng　xiāo　luán　guǎn 】\n			', '\n笙箫之类的吹奏乐。\n			', '\n明·谢谠《四喜记·大宋毕姻》：“歌动迎仙，声袅凤箫鸾管。”\n			', '\n暂无\n			'),
(3208, '0:4:13', '凤协鸾和', '\n【 fèng　xié　luán　hé 】\n			', '\n形容夫妻和睦，感情融洽。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3209, '0:4:13', '凤枭同巢', '\n【 fèng　xiāo　tóng　cháo 】\n			', '\n凤：凤凰，吉祥的象征；枭：恶鸟的象征。神鸟与恶鸟同在一个窝里。比喻好和坏混在一起不分。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3210, '0:4:13', '凤引九雏', '\n【 fèng　yǐn　jiǔ　chú 】\n			', '\n为天下太平、社会繁荣的吉兆。\n			', '\n《晋书·穆帝纪》：“（升平四年）二月，凤凰将九雏见于丰城。”\n			', '\n龙吟四泽欲兴雨，～警宿乌。\n			'),
(3211, '0:4:13', '凤吟鸾吹', '\n【 fèng　yín　luán　chuī 】\n			', '\n比喻极为美妙的歌声。\n			', '\n《警世通言·杜十娘怒沉百宝箱》：“忽听得歌声嘹亮，凤吟鸾吹，不足喻其美。”\n			', '\n暂无\n			'),
(3212, '0:4:13', '凤友鸾交', '\n【 fèng　yǒu　luán　jiāo 】\n			', '\n①比喻有情男女结成的夫妇。②比喻男女间情投意合。\n			', '\n元·汤式《集贤宾·友人爱姬为权豪所夺》套曲：“烘散燕子莺儿，拆散凤友鸾交。”\n			', '\n昨夜谁侍陛下寝来？可怎生般～。到日三竿犹不临朝？\n			'),
(3213, '0:4:13', '凤臆龙鬐', '\n【 fèng　yì　lóng　qí 】\n			', '\n凤凰的胸脯，龙的颈毛。比喻骏马的雄奇健美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3214, '0:4:13', '凤友鸾谐', '\n【 fèng　yǒu　luán　xié 】\n			', '\n比喻男女间情投意合。同“凤友鸾交”。\n			', '\n清·黄六鸿《福惠全书·刑名·强奸》：“曲榭幽廊，皆凤友鸾谐之所也。”\n			', '\n暂无\n			'),
(3215, '0:4:13', '凤仪兽舞', '\n【 fèng　yí　shòu　wǔ 】\n			', '\n表示圣贤教化的功效极大，能使神异的鸟兽奋然起舞。\n			', '\n《书·益稷》：“《箫韶》九成，凤皇来仪……击石拊石，百兽率舞。”\n			', '\n而国子之教，乐乃专精。乐之至者，能使～。\n			'),
(3216, '0:4:13', '凤只鸾孤', '\n【 fèng　zhī　luán　gū 】\n			', '\n只：单独。鸾：传说是凤凰一类的鸟。凤和鸾比喻夫妻。单只的凤，孤独的鸾。比喻夫妻离散。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3217, '0:4:13', '凤翥鸾回', '\n【 fèng　zhù　luán　huí 】\n			', '\n翥：高飞。比喻书法笔势飞动舒展。\n			', '\n晋·陆机《浮云赋》：“鸾翔凤翥，鸿惊鹤飞，鲸鲵溯波，鲛鳄冲道。”\n			', '\n今观圣迹，兼绝二王，～，实古今书圣。\n			'),
(3218, '0:4:13', '凤翥龙蟠', '\n【 fèng　zhù　lóng　pán 】\n			', '\n像凤凰飞舞，蛟龙盘曲。比喻体势的飞扬劲建，回旋多姿。\n			', '\n《晋书·王羲之传论》：“观其点曳之工，裁成之妙，烟霏露结，状若断而还连；凤翥龙蟠，势如斜而反直。”\n			', '\n～势作环，浮青不断太行山。\n			'),
(3219, '0:4:13', '凤子龙孙', '\n【 fèng　zǐ　lóng　sūn 】\n			', '\n帝王或贵族的后代。\n			', '\n《二刻拍案惊奇》卷七：“真个是凤子龙孙，遭着不幸，流落到这个地位。”\n			', '\n暂无\n			'),
(3220, '0:4:13', '凤翥龙骧', '\n【 fèng　zhù　lóng　xiāng 】\n			', '\n形容奋发有为。\n			', '\n明·孙柚《琴心记·牛酒交欢》：“新筑沙堤行宰相，喜今朝凤翥龙骧，燕友逢春，莺朋出谷。”\n			', '\n暂无\n			'),
(3221, '0:4:13', '凤翥龙翔', '\n【 fèng　zhù　lóng　xiáng 】\n			', '\n翥：鸟向上飞；翔：盘旋飞翔。龙飞凤舞，形容气势非凡。\n			', '\n明·张居正《陵寝纪》：“山趋水会，凤翥龙翔，信乾坤之……”\n			', '\n美彼之态度兮，～。\n			'),
(3222, '0:4:13', '凤翥鸾翔', '\n【 fèng　zhù　luán　xiáng 】\n			', '\n像凤凰高飞。比喻女子婚姻美满得意。\n			', '\n明·李东阳《祭孔氏女文》：“我女之嫁，凤翥鸾翔。我女之行，山遥水长。”\n			', '\n暂无\n			'),
(3223, '0:4:13', '凤翥鹏翔', '\n【 fèng　zhù　péng　xiáng 】\n			', '\n形容奋发有为。\n			', '\n清·陆陇其《与李枚吉婿书》：“吾婿英年有志，前程远大，苟发愤力学，将来凤翥鹏翔，何可限量。”\n			', '\n暂无\n			'),
(3224, '0:4:13', '高凤自秽', '\n【 gāo　fèng　zì　huì 】\n			', '\n东汉高凤，字文通，执志不仕，太守连召请，恐不得免，自言本巫家，不应为吏，又诈与寡嫂讼田，遂不仕。后用为自诬之典。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3225, '0:4:13', '龟龙鳞凤', '\n【 guī　lóng　lín　fèng 】\n			', '\n传统上用来象征高寿、尊贵、吉祥的四种动物。比喻身处高位德盖四海的人。\n			', '\n《汉书·翟方进传》：“太皇太后临政，有龟龙鳞凤之应。”\n			', '\n暂无\n			'),
(3226, '0:4:13', '龟龙麟凤', '\n【 guī　lóng　lín　fèng 】\n			', '\n传统上用来象征高寿、尊贵、吉祥的四种动物。比喻身处高位德盖四海的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3227, '0:4:13', '鳏鱼渴凤', '\n【 guān　yú　kě　fèng 】\n			', '\n比喻独身的男子急于求得配偶。\n			', '\n唐·李商隐《李夫人歌》之三：“清澄有馀幽素香，鳏鱼渴凤真珠房。”\n			', '\n～无如我，奈霎时中热，蓦地偷过。\n			'),
(3228, '0:4:13', '化鸱为凤', '\n【 huà　chī　wéi　fèng 】\n			', '\n比喻能以德化民，变恶为善。鸱，猫头鹰，古人以为凶鸟。\n			', '\n语出《后汉书·循吏传·仇览》：“时考城令河内王涣，政尚严猛，闻览以德化人，署为主簿。谓览曰：‘主簿闻陈元之过，不罪而化之，得少鹰鹯之志邪？’览曰：‘以为鹰鹯不若鸾凤。’”\n			', '\n但知私财不入，公事夙办，便函云我能治民，不知诚己刑物，执辔如组，反风灭火，～之术也。\n			'),
(3229, '0:4:13', '鸿鶱凤立', '\n【 hóng　xiān　fèng　lì 】\n			', '\n鸿鹄高飞，凤凰挺立。比喻超卓突出。\n			', '\n唐·李白《秋夜于安府送孟赞府兄还都序》：“鸿鶱凤立，不循常流。”\n			', '\n暂无\n			'),
(3230, '0:4:13', '鸿鶱凤逝', '\n【 hóng　xiān　fèng　shì 】\n			', '\n鸿鹄高飞，凤凰远逝。比喻毅然远行。\n			', '\n清·龚自珍《海门先啬陈君祠堂碑文》：“年十三，让产伯兄，鸿鶱凤逝，去之无迹。”\n			', '\n暂无\n			'),
(3231, '0:4:13', '鸿轩凤翥', '\n【 hóng　xuān　fèng　zhù 】\n			', '\n比喻举止高尚。\n			', '\n宋·范仲淹《滕公夫人刁氏墓志铭》：“而祠部君克承善志，鸿轩凤翥，有风采于朝廷。”\n			', '\n暂无\n			'),
(3232, '0:4:13', '鸿隐凤伏', '\n【 hóng　yǐn　fèng　fú 】\n			', '\n比喻贤才不遇。\n			', '\n清·蒲松龄《贺章丘县周素心入泮序》：“尽当鸿隐凤伏，斥鷃得而笑之，而不知一朝奋迹，阊阖可叫而开不难也。”\n			', '\n暂无\n			'),
(3233, '0:4:13', '鸡不及凤', '\n【 jī　bù　jí　fèng 】\n			', '\n鸡赶不上凤凰。比喻儿子不如父亲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3234, '0:4:13', '镜分鸾凤', '\n【 jìng　fēn　luán　fèng 】\n			', '\n比喻夫妻分离。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3235, '0:4:13', '吉光凤羽', '\n【 jí　guāng　fèng　yǔ 】\n			', '\n吉光与凤凰的毛羽。比喻艺术珍品。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3236, '0:4:13', '鸠集凤池', '\n【 jiū　jí　fèng　chí 】\n			', '\n比喻庸才居要位。\n			', '\n《资治通鉴·唐纪则天后圣历二年》：“内史王及善虽无学术，然清正难夺，有大臣之节。”胡三省注：“《朝野佥载》曰：‘王及善才行庸猥，风神钝浊，为内史时，人号为“鸠集凤池”。’”\n			', '\n暂无\n			'),
(3237, '0:4:13', '娇鸾雏凤', '\n【 jiāo　luán　chú　fèng 】\n			', '\n幼小的鸾凤。比喻青春年少的情侣。\n			', '\n元·王实甫《西厢记》第二本第五折：“他那里思不穷，我这里意已通，娇鸾雏凤失雌雄。”\n			', '\n暂无\n			'),
(3238, '0:4:13', '鸡栖凤巢', '\n【 jī　qī　fèng　cháo 】\n			', '\n栖：居住。鸡住在凤凰的窝里。比喻才德卑下的人占据高位。\n			', '\n宋·释道原《景德传灯录》卷十六：“鸡栖凤巢，非其同类出去。”\n			', '\n暂无\n			'),
(3239, '0:4:13', '景星凤皇', '\n【 jǐng　xīng　fèng　huáng 】\n			', '\n传说太平之世才能见到景星和凤凰。后用以比喻美好的事物或杰出的人才。\n			', '\n唐韩愈《与少室李拾遗书》：“朝廷之士，引颈东望，若景星凤皇之始见也，争先睹之为快。”\n			', '\n景星凤凰，以见为宠。\n			'),
(3240, '0:4:13', '景星凤凰', '\n【 jǐng　xīng　fèng　huáng 】\n			', '\n传说太平之世才能见到景星和凤凰。后用以比喻美好的事物或杰出的人才。同“景星凤皇”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3241, '0:4:13', '景星麟凤', '\n【 jǐng　xīng　lín　fèng 】\n			', '\n犹言景星凤凰。比喻杰出的人才。\n			', '\n《元史·同恕传》：“自京还，家居三年，缙绅望之若景星麟凤，乡里称为先生而不姓。”\n			', '\n暂无\n			'),
(3242, '0:4:13', '跨凤乘鸾', '\n【 kuà　fèng　chéng　luán 】\n			', '\n凤：凤凰；鸾：传中凤凰一类的鸟。夫妻骑着凤，乘着鸾。比喻飞黄腾达，意得志满。\n			', '\n元·杨景贤《刘行首》第三折：“暂时间且略别，三日后向城西传取长生块，管着你跨凤乘鸾。”\n			', '\n我如今博得个～客，到晚来卧看牵牛织女星。（明·崔时佩《西厢记·东阁邀赏》）\n			'),
(3243, '0:4:13', '跨凤乘龙', '\n【 kuà　fèng　chéng　lóng 】\n			', '\n比喻结成夫妻或成仙。\n			', '\n明·单本《蕉帕记·备聘》：“喜融融，好似萧郎秦女，跨凤乘龙。”\n			', '\n暂无\n			'),
(3244, '0:4:13', '鸾翱凤翥', '\n【 luán　áo　fèng　zhù 】\n			', '\n比喻字体飘逸，笔势飞动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3245, '0:4:13', '吕安题凤', '\n【 lǚ　ān　tí　fèng 】\n			', '\n比喻造访不遇。\n			', '\n南朝·宋·刘义庆《世说新语·简傲》：“嵇康与吕安善，每一相思，千里命驾。安后来，值康不在，喜出户延之，不入。题门上作‘凤’字而去。”\n			', '\n须知子猷访戴步翩跹，谁知～惜留连。\n			'),
(3246, '0:4:13', '鸾俦凤侣', '\n【 luán　chóu　fèng　lǚ 】\n			', '\n指男女欢爱如鸾凤般相谐作伴。\n			', '\n《好逑传》第16回：“何不与舍侄女竟成鸾俦凤侣，便完了一件百年的大事？”\n			', '\n暂无\n			'),
(3247, '0:4:13', '龙雏凤种', '\n【 lóng　chú　fèng　zhǒng 】\n			', '\n指帝王后裔。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3248, '0:4:13', '鸾颠凤倒', '\n【 luán　diān　fèng　dǎo 】\n			', '\n指男女欢合。\n			', '\n明·谢谠《四喜记·仁主赐婚》：“喜孜孜鸾颠凤倒，美津津露涩花娇。”\n			', '\n暂无\n			'),
(3249, '0:4:13', '龙雕凤咀', '\n【 lóng　diāo　fèng　jǔ 】\n			', '\n比喻辞藻之美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3250, '0:4:13', '龙凤呈祥', '\n【 lóng　fèng　chéng　xiáng 】\n			', '\n指吉庆之事。\n			', '\n《孔丛子·记问》：“天子布德，将致太平，则麟凤龟龙先为之呈祥。”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(3251, '0:4:13', '鸾凤分飞', '\n【 luán　fèng　fēn　fēi 】\n			', '\n比喻夫妻或情侣离散。\n			', '\n唐·房千里《寄妾赵氏》诗：“鸾凤分飞海树秋，忍听钟鼓越王楼。”\n			', '\n暂无\n			'),
(3252, '0:4:13', '鸾分凤离', '\n【 luán　fēn　fèng　lí 】\n			', '\n比喻夫妻或情侣离散。同“鸾凤分飞”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3253, '0:4:13', '龙飞凤舞', '\n【 lóng　fēi　fèng　wǔ 】\n			', '\n原形容山势的蜿蜒雄壮，后也形容书法笔势有力，灵活舒展。\n			', '\n宋·苏轼《表忠观碑》：“天目之山，苕水出焉，龙飞凤舞，萃于临安。”\n			', '\n抬头看见北墙上挂着四幅大屏，草书得～，出色惊人。（清·刘鹗《老残游记》第九回）\n			'),
(3254, '0:4:13', '鸾飞凤舞', '\n【 luán　fēi　fèng　wǔ 】\n			', '\n形容祥瑞和平的环境。\n			', '\n《山海经·海内经》：“有鸾鸟自歌，凤鸟自舞……见则天下和。”\n			', '\n况兰亭定武，更宣和书谱，老笔霜花艳吐，写得～。（清·吴梅《霜厓曲录·北越调斗鹌鹑·黄蔷薇》）\n			'),
(3255, '0:4:13', '龙飞凤翔', '\n【 lóng　fēi　fèng　xiáng 】\n			', '\n①指帝王的兴起。②比喻仕途得意，飞黄腾达。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3256, '0:4:13', '龙飞凤翥', '\n【 lóng　fēi　fèng　zhù 】\n			', '\n形容笔势雄奇飞动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3257, '0:4:13', '鸾飞凤翥', '\n【 luán　fēi　fèng　zhù 】\n			', '\n鸾凤飞举。比喻仕途得意。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3258, '0:4:13', '麟凤龟龙', '\n【 lín　fèng　guī　lóng 】\n			', '\n此四种神灵动物，象征吉兆。比喻稀有珍贵的东西。也比喻品格高尚、受人敬仰的人。\n			', '\n《礼记·礼运》：“麟凤龟龙，谓之四灵。”\n			', '\n暂无\n			'),
(3259, '0:4:13', '鸾凤和鸣', '\n【 luán　fèng　hé　míng 】\n			', '\n比喻夫妻相亲相爱。旧时常用于祝人新婚。\n			', '\n《左传·庄公二十二年》：“是谓凤凰于飞，和鸣锵锵。”\n			', '\n夜同寢，昼同行，恰似～。（元·白朴《梧桐雨》第一折）\n			'),
(3260, '0:4:13', '麟凤一毛', '\n【 lín　fèng　yī　máo 】\n			', '\n比喻好东西无论巨细都搜罗进来了。\n			', '\n唐·张怀谨《书议》：“麟凤一毛，龟龙片甲，亦无所不录。。”\n			', '\n暂无\n			'),
(3261, '0:4:13', '鸾歌凤吹', '\n【 luán　gē　fèng　chuí 】\n			', '\n指笙箫等乐曲声。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3262, '0:4:13', '鸾孤凤寡', '\n【 luán　gū　fèng　guǎ 】\n			', '\n比喻夫妻离散。也比喻人失偶孤居。同“鸾孤凤只”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3263, '0:4:13', '龙肝凤脑', '\n【 lóng　gān　fèng　nǎo 】\n			', '\n比喻极难得的珍贵食品。\n			', '\n明·罗贯中《三国演义》第三十六回：“玄德曰：‘备闻公将去，如失左右手。虽龙肝凤髓，亦不甘味。”\n			', '\n暂无\n			'),
(3264, '0:4:13', '龙肝凤髓', '\n【 lóng　gān　fèng　suǐ 】\n			', '\n比喻极难得的珍贵食品。\n			', '\n明·罗贯中《三国演义》第三十六回：“玄德曰：‘备闻公将去，如失左右手。虽龙肝凤髓，亦不甘味。”\n			', '\n暂无\n			'),
(3265, '0:4:13', '麟肝凤髓', '\n【 lín　gān　fèng　suǐ 】\n			', '\n麟之肝，凤之髓。极言美味佳肴。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3266, '0:4:13', '鸾歌凤舞', '\n【 luán　gē　fèng　wǔ 】\n			', '\n比喻美妙的歌舞。\n			', '\n《山海经·大荒南经》：“爰有歌舞之鸟，鸾鸟自歌，凤鸟自舞。”\n			', '\n暂无\n			'),
(3267, '0:4:13', '鸾孤凤只', '\n【 luán　gū　fèng　zhī 】\n			', '\n比喻夫妻离散。也比喻人失偶孤居。\n			', '\n宋·无名氏《张协状元》第二十九出：“从来我意，镇有心，便欲求伊姻契，谁知到此，情一似凤孤鸾只。”\n			', '\n吕温侯～，烦恼杀情分两处旧娇妻。（元·无名氏《连环计》第四折）\n			'),
(3268, '0:4:13', '龙翰凤雏', '\n【 lóng　hàn　fèng　chú 】\n			', '\n比喻杰出的人才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3269, '0:4:13', '龙翰凤翼', '\n【 lóng　hàn　fèng　yì 】\n			', '\n比喻杰出的人才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3270, '0:4:13', '鸾回凤翥', '\n【 luán　huí　fèng　zhù 】\n			', '\n形容舞姿优美。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3271, '0:4:13', '龙驹凤雏', '\n【 lóng　jū　fèng　chú 】\n			', '\n比喻英俊秀颖的少年。常作恭维语。\n			', '\n《晋书·陆云传》：“云字士龙，六岁能属文，性清正，有才理。少与兄机齐名，虽文章不及机，而持论过之，号曰‘二陆’。幼时吴尚书广陵闵鸿见而奇之，曰：‘此儿若非龙驹，当是凤雏。’”\n			', '\n令郎真乃～，非小王在世翁前唐突，将来“雏凤清于老凤声”，未可量也。（清·曹雪芹《红楼梦》第十五回）\n			'),
(3272, '0:4:13', '鸾交凤俦', '\n【 luán　jiāo　fèng　chóu 】\n			', '\n比喻优秀人物交友或才子佳人结为夫妻。同“鸾交凤友”。\n			', '\n清·李渔《慎鸾交·却媒》：“中宫位卸，便做鸾交凤俦；衾裯伴少，便做莺栖燕游。”\n			', '\n暂无\n			'),
(3273, '0:4:13', '麟角凤距', '\n【 lín　jiǎo　fèng　jù 】\n			', '\n距：鸟的脚爪。麒麟的角，凤凰的爪。比喻备而不必用的珍贵东西。\n			', '\n《抱朴子·自叙》：“晚又学七尺杖术，可以入白刃，取大戟。然亦是不急之末学；知之譬如麟角凤距，何必用之？”\n			', '\n暂无\n			'),
(3274, '0:4:13', '麟角凤毛', '\n【 lín　jiǎo　fèng　máo 】\n			', '\n麟的角，凤的毛。比喻稀有而又难得之人才或事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3275, '0:4:13', '鸾胶凤丝', '\n【 luán　jiāo　fèng　sī 】\n			', '\n指续娶的后妻。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3276, '0:4:13', '鸾交凤友', '\n【 luán　jiāo　fèng　yǒu 】\n			', '\n比喻优秀人物交友或才子佳人结为夫妻。\n			', '\n元·马致远《汉宫秋》第二折：“我不信你敢差排吕太后，枉以后龙争虎斗，都是俺鸾交凤友。”\n			', '\n暂无\n			'),
(3277, '0:4:13', '麟角凤觜', '\n【 lín　jiǎo　fèng　zuǐ 】\n			', '\n觜：鸟嘴。麒麟的角，凤凰的嘴。比喻稀罕名贵的东西。\n			', '\n汉·东方朔《海内十洲记》：“煮凤喙及麟角，合煎作膏，名之为续弦胶，或名连金泥。此胶能续弓驽已断之弦，刀剑断折之金。”\n			', '\n～世莫识，煎胶续弦奇自见。（唐·杜甫《病后遇王倚饮赠歌》诗）\n			'),
(3278, '0:4:13', '麟角凤嘴', '\n【 lín　jiǎo　fèng　zuǐ 】\n			', '\n觜：鸟嘴。麒麟的角，凤凰的嘴。比喻稀罕名贵的东西。\n			', '\n汉·东方朔《海内十洲记》：“煮凤喙及麟角，合煎作膏，名之为续弦胶，或名连金泥。此胶能续弓驽已断之弦，刀剑断折之金。”\n			', '\n暂无\n			'),
(3279, '0:4:13', '离鸾别凤', '\n【 lí　luán　bié　fèng 】\n			', '\n比喻夫妻离散。\n			', '\n唐·李贺《湘妃》诗：“离鸾别凤烟梧中。”\n			', '\n当日正女功，手挦着绣绒，画楼中忽闻听远院琴三弄，～恨匆匆，泪双垂，把不住乡心动。（元·无名氏《梧桐叶》第四折）\n			'),
(3280, '0:4:13', '龙楼凤城', '\n【 lóng　lóu　fèng　chéng 】\n			', '\n犹言龙楼凤池。指禁省，皇宫。\n			', '\n明·陈汝元《金莲记·偕计》：“论文章围棘堪驰骋，愿藏身龙楼凤城。”\n			', '\n暂无\n			'),
(3281, '0:4:13', '龙楼凤阁', '\n【 lóng　lóu　fèng　gé 】\n			', '\n①帝王的宫殿、楼阁。②喻指封建统治者的巢穴。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3282, '0:4:13', '龙楼凤阙', '\n【 lóng　lóu　fèng　què 】\n			', '\n指帝王宫阙。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3283, '0:4:13', '龙楼凤池', '\n【 lóng　lóu　fèng　shi 】\n			', '\n指禁省，皇宫。\n			', '\n明·梁辰鱼《浣纱记·送钱》：“念生长在香闰绣帏，念出入在龙楼凤池。”\n			', '\n暂无\n			'),
(3284, '0:4:13', '龙眉凤目', '\n【 lóng　méi　fèng　mù 】\n			', '\n形容贵人相貌不同寻常。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3285, '0:4:13', '鸾鸣凤奏', '\n【 luán　míng　fèng　zòu 】\n			', '\n弹奏演唱的美称。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3286, '0:4:13', '鸾飘凤泊', '\n【 luán　piāo　fèng　bó 】\n			', '\n原形容书法笔势潇洒飘逸，后比喻夫妻离散或文人失意。\n			', '\n唐·韩愈《峋嵝山》诗：“科斗拳身薤倒披，鸾飘凤泊拏虎螭。”\n			', '\n～蟠银钩。（宋·杨万里《东坡真迹》诗）\n			'),
(3287, '0:4:13', '鸾漂凤泊', '\n【 luán　piāo　fèng　bó 】\n			', '\n①形容书法的笔势神奇飘逸。②比喻夫妻或情侣离散，天各一方。亦泛指身世沦落，漂泊不定。亦作“凤泊鸾飘”、“飘鸾泊凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3288, '0:4:13', '龙攀凤附', '\n【 lóng　pān　fèng　fù 】\n			', '\n犹言攀龙附凤。指巴结投靠有权势的人以获取富贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3289, '0:4:13', '龙盘凤舞', '\n【 lóng　pán　fèng　wǔ 】\n			', '\n比喻山川雄踞蜿蜒，有王者气象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3290, '0:4:13', '龙蟠凤逸', '\n【 lóng　pán　fèng　yì 】\n			', '\n如龙盘曲，如凤深藏。比喻有才能而没有人赏识。\n			', '\n唐·李白《与韩刑州书》：“所以龙蟠凤逸之士，皆欲收名定价于君侯。”\n			', '\n暂无\n			'),
(3291, '0:4:13', '龙盘凤逸', '\n【 lóng　pán　fèng　yì 】\n			', '\n比喻怀才不遇。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3292, '0:4:13', '龙盘凤翥', '\n【 lóng　pán　fèng　zhù 】\n			', '\n比喻山势雄壮蜿蜒。指王者的气象。亦比喻书法笔势飞动。\n			', '\n后晋·沈昫《旧唐书·玄宗纪》：“初，上皇亲拜五陵，至桥陵，见金粟山有龙盘凤翥之势。”\n			', '\n诏二臣共作《艮岳百咏诗》以进……《草圣亭》：落笔纵横走电光，近臣时得赐云章。～皆天纵，渴骥惊蛇不足方。\n			'),
(3293, '0:4:13', '龙蟠凤翥', '\n【 lóng　pán　fèng　zhù 】\n			', '\n指贤者遁世归隐。\n			', '\n宋·苏轼《水龙吟》词：“古来云海茫茫，道山绛阙知何处？人间自有，赤城居士，龙蟠凤翥。清净无为，坐忘遗照，八篇奇语。”\n			', '\n暂无\n			'),
(3294, '0:4:13', '龙潜凤采', '\n【 lóng　qián　fèng　cǎi 】\n			', '\n比喻英俊之士才能未展现。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3295, '0:4:13', '龙腾凤集', '\n【 lóng　téng　fèng　jí 】\n			', '\n比喻王业兴盛，英雄会合。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3296, '0:4:13', '龙心凤肝', '\n【 lóng　xīn　fèng　gān 】\n			', '\n喻指极珍贵稀有的名菜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3297, '0:4:13', '鸾翔凤集', '\n【 luán　xiáng　fèng　jí 】\n			', '\n比喻优秀的人才汇聚到一起。\n			', '\n晋·傅咸《申怀赋》：“穆穆清禁，济济群英。鸾翔凤集，羽仪上亲。”\n			', '\n暂无\n			'),
(3298, '0:4:13', '龙骧凤矫', '\n【 lóng　xiāng　fèng　jiǎo 】\n			', '\n龙腾凤飞。喻指行动迅猛。\n			', '\n《宋书·武帝纪中》：“公龙骧凤矫咫尺八纮，括囊四海，折冲无外。”\n			', '\n暂无\n			'),
(3299, '0:4:13', '龙兴凤举', '\n【 lóng　xīng　fèng　jǔ 】\n			', '\n比喻王者兴起。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3300, '0:4:13', '龙血凤髓', '\n【 lóng　xuè　fèng　suǐ 】\n			', '\n比喻高贵的血统。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3301, '0:4:13', '龙翔凤舞', '\n【 lóng　xiáng　fèng　wǔ 】\n			', '\n犹言龙飞凤舞。原形容山势的蜿蜒雄壮，后也形容书法笔势有力，灵活舒展。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3302, '0:4:13', '龙翔凤跃', '\n【 lóng　xiáng　fèng　yuè 】\n			', '\n原形容山势的蜿蜒雄壮，后也形容书法笔势有力，灵活舒展。同“龙翔凤舞”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3303, '0:4:13', '鸾翔凤翥', '\n【 luán　xiáng　fèng　zhù 】\n			', '\n翔：盘旋而飞；翥：高飞。比喻书法笔势飞动舒展。\n			', '\n唐·韩愈《石鼓歌》：“鸾翔凤翥众仙下，珊瑚碧树交枝柯。”\n			', '\n暂无\n			'),
(3304, '0:4:13', '龙翔凤翥', '\n【 lóng　xiáng　fèng　zhù 】\n			', '\n①比喻瀑布飞泻奔腾。②比喻神采飞扬。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3305, '0:4:13', '鸾吟凤唱', '\n【 luán　yín　fèng　chàng 】\n			', '\n鸾凤鸣叫相和。比喻优美的乐曲。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3306, '0:4:13', '鸾舆凤驾', '\n【 luán　yú　fèng　jià 】\n			', '\n指华丽的宫廷车乘。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3307, '0:4:13', '龙跃凤鸣', '\n【 lóng　yuè　fèng　míng 】\n			', '\n象龙在腾跃，凤凰在高鸣。比喻才华出众。\n			', '\n南朝宋·刘义庆《世说新语·赏誉》：“君兄弟龙跃云津，顾彦先凤鸣朝阳，谓东南之宝已尽，不意复见褚生。”\n			', '\n暂无\n			'),
(3308, '0:4:13', '龙言凤语', '\n【 lóng　yán　fèng　yǔ 】\n			', '\n比喻轻松悠扬的音乐之声。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3309, '0:4:13', '龙颜凤姿', '\n【 lóng　yán　fèng　zī 】\n			', '\n指帝王之相。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3310, '0:4:13', '麟子凤雏', '\n【 lín　zǐ　fèng　chú 】\n			', '\n麒麟之子，凤凰之雏。比喻年轻的颖异俊秀之人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3311, '0:4:13', '龙章凤彩', '\n【 lóng　zhāng　fèng　cǎi 】\n			', '\n不凡的仪表风采。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3312, '0:4:13', '龙姿凤采', '\n【 lóng　zī　fèng　cǎi 】\n			', '\n形容姿态风采非凡。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3313, '0:4:13', '鸾只凤单', '\n【 luán　zhī　fèng　dān 】\n			', '\n孤独的鸾凤。比喻夫妻或情侣离散后的孤单情形。\n			', '\n明·高濂《玉簪记·合庆》：“恨当初鸾只凤单，喜今日夫荣妻显。”\n			', '\n暂无\n			'),
(3314, '0:4:13', '龙章凤函', '\n【 lóng　zhāng　fèng　hán 】\n			', '\n比喻文采炳焕。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3315, '0:4:13', '鸾姿凤态', '\n【 luán　zī　fèng　tài 】\n			', '\n比喻神仙的仪态。\n			', '\n《云笈七签》卷五：“弟子十八人，并皆殊秀，然鸾姿凤态，眇映云松者，有韦法昭、司马子微、郭崇真。”\n			', '\n暂无\n			'),
(3316, '0:4:13', '龙章凤姿', '\n【 lóng　zhāng　fèng　zī 】\n			', '\n章：文采。蛟龙的文采，凤凰的姿容。比喻风采出众。\n			', '\n南朝宋·刘义庆《世说新语·容止》刘孝标注：“康长七尺八寸，伟容色，土木形骸，不加饰厉，而龙章凤姿，天质自然。”\n			', '\n～士不见用；獐头鼠目乃欲求官耶？（清·袁枚《随园诗话》卷十四）\n			'),
(3317, '0:4:13', '鸣凤朝阳', '\n【 míng　fèng　zhāo　yáng 】\n			', '\n正直敢言的贤士。比喻贤臣遇明君。\n			', '\n《诗经·大雅·卷阿》：“凤皇鸣矣，于彼高冈。梧桐生矣，于彼朝阳。”《幼学琼林·卷一·文臣类》：“李善感直言不讳，竞称鸣凤朝阳。”\n			', '\n～尺五天，匆匆忽过白鸥边。\n			'),
(3318, '0:4:13', '描龙绣凤', '\n【 miáo　lóng　xiù　fèng 】\n			', '\n指精美的手工刺绣。泛指古代女红。亦作“描鸾刺凤”、“描龙刺凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3319, '0:4:13', '炮凤烹龙', '\n【 páo　fèng　pēng　lóng 】\n			', '\n烹：煮；炮：烧。形容菜肴极为丰盛、珍奇。\n			', '\n唐·李贺《将进酒》诗：“烹龙炮凤玉脂泣，罗屏绣幕围香风。”\n			', '\n暂无\n			'),
(3320, '0:4:13', '砲凤烹龙', '\n【 pào　fèng　pēng　lóng 】\n			', '\n①形容豪奢珍奇的肴馔。②指一种肴馔名。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3321, '0:4:13', '攀龙附凤', '\n【 pān　lóng　fù　fèng 】\n			', '\n指巴结投靠有权势的人以获取富贵。\n			', '\n汉·扬雄《法言·渊骞》：“攀龙鳞，附凤翼。”\n			', '\n～势莫当，天下尽化为侯王。（唐·杜甫《洗兵马》诗）\n			'),
(3322, '0:4:13', '烹龙炮凤', '\n【 pēng　lóng　páo　fèng 】\n			', '\n烹：煮；炮：烧。形容菜肴极为丰盛、珍奇。\n			', '\n唐·李贺《将进酒》诗：“烹龙炮凤玉脂泣，罗屏绣幕围香风。”\n			', '\n座上若无油木梳，～总成虚。（元·戴善夫《风光好》第一折）\n			'),
(3323, '0:4:13', '炮龙烹凤', '\n【 pào　lóng　pēng　fèng 】\n			', '\n形容豪奢珍奇的肴馔。\n			', '\n明·施耐庵《水浒传》第八十二回：“堂上堂下，皆列位次，大设筵宴，轮番把盏。厅前大吹大擂。虽无炮龙烹凤，端的是肉山酒海。”\n			', '\n暂无\n			'),
(3324, '0:4:13', '砲龙烹凤', '\n【 pào　lóng　pēng　fèng 】\n			', '\n形容豪奢珍奇的肴馔。也指一种肴馔名。同“砲凤烹龙”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3325, '0:4:13', '烹龙庖凤', '\n【 pēng　lóng　páo　fèng 】\n			', '\n比喻烹调珍奇菜肴。亦形容菜肴豪奢珍贵。同“烹龙炮凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3326, '0:4:13', '烹龙砲凤', '\n【 pēng　lóng　pào　fèng 】\n			', '\n①比喻烹调珍奇肴馔。亦形容菜肴豪奢珍贵。②比喻高超的艺术技艺。亦作“烹龙庖凤”。亦作“烹龙煮凤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3327, '0:4:13', '攀龙讬凤', '\n【 pān　lóng　xiù　fèng 】\n			', '\n犹言攀龙附凤。指巴结投靠有权势的人以获取富贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3328, '0:4:13', '烹龙煮凤', '\n【 pēng　lóng　zhǔ　fèng 】\n			', '\n比喻烹调珍奇菜肴。亦形容菜肴豪奢珍贵。\n			', '\n明·冯梦龙《喻世明言》第十一卷：“有《鹧鸪天》词为证：城中酒楼高入天，烹龙煮凤味肥鲜。公孙下马闻香醉，一饮不惜费万钱。”\n			', '\n暂无\n			'),
(3329, '0:4:13', '起凤腾蛟', '\n【 qǐ　fèng　téng　jiāo 】\n			', '\n宛如蛟龙腾跃、凤凰起舞。形容人很有文采。\n			', '\n唐·王勃《滕王阁序》：“腾蛟起凤，孟学士之词宗。”\n			', '\n暂无\n			'),
(3330, '0:4:13', '潜蛟困凤', '\n【 qián　jiāo　kùn　fèng 】\n			', '\n比喻被埋没的贤才。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3331, '0:4:13', '泣麟悲凤', '\n【 qǐ　lín　bēi　fèng 】\n			', '\n麟：麒麟；凤：凤凰。古代传说是吉祥的禽兽，只有在太平盛世才能见到。谓哀伤国家衰败。\n			', '\n孔子因乱世获麟而涕泣，又因凤鸟不至而伤。见《公羊传·哀公十四年》、《论语·子罕》。\n			', '\n又不是清夜闻钟，又不是黄鹤醉翁，又不是～。\n			'),
(3332, '0:4:13', '骑龙弄凤', '\n【 qí　lóng　nòng　fèng 】\n			', '\n①比喻成仙。②比喻腾达。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3333, '0:4:13', '认鸡作凤', '\n【 rèn　jī　zuò　fèng 】\n			', '\n佛教语。指认凡庸为珍贵。\n			', '\n《万善同归集》卷一：“如楚国愚人认鸡作凤，犹春池小果执石为珠。但任浅近之情，不探深密之旨。”\n			', '\n暂无\n			'),
(3334, '0:4:13', '托凤攀龙', '\n【 tuō　fèng　pān　lóng 】\n			', '\n犹言攀龙附凤。比喻依附帝王、权贵。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3335, '0:4:13', '腾蛟起凤', '\n【 téng　jiāo　qǐ　fèng 】\n			', '\n蛟：蛟龙；凤：凤凰。宛如蛟龙腾跃、凤凰起舞。形容人很有文采。\n			', '\n唐·王勃《滕王阁序》：“腾蛟起凤，孟学士之词宗。”\n			', '\n暂无\n			'),
(3336, '0:4:13', '舞凤飞龙', '\n【 wǔ　fèng　fēi　lóng 】\n			', '\n犹龙飞凤舞。气势奔放雄壮的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3337, '0:4:13', '威凤祥麟', '\n【 wēi　fèng　xiáng　lín 】\n			', '\n麒麟和凤凰，古代传说是吉祥的象征，只有在太平盛世才能见到。后比喻非常难得的人才。\n			', '\n《宋书·符瑞志中》：“元康四年，南郡获威风。”《宋史·乐志一》：“九年，岚州献祥麟。”\n			', '\n暂无\n			'),
(3338, '0:4:13', '威凤一羽', '\n【 wēi　fèng　yī　yǔ 】\n			', '\n指略见善政一斑之意。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3339, '0:4:13', '梧凤之鸣', '\n【 wú　fèng　zhī　míng 】\n			', '\n比喻政教和协、天下太平。\n			', '\n《诗·大雅·卷阿》：“凤皇鸣矣，于彼高冈。梧桐生矣，于彼朝阳。”毛传：“梧桐盛也，凤凰鸣也，臣竭其力，则地极其化；天下和洽，则凤凰乐德。”\n			', '\n暂无\n			'),
(3340, '0:4:13', '祥麟威凤', '\n【 xiáng　lín　wēi　fèng 】\n			', '\n麒麟和凤凰，古代传说是吉祥的禽兽，只有在太平盛世才能见到。后比喻非常难得的人才。\n			', '\n《宋史·符瑞志中》：“元康四年，南郡获威凤。”\n			', '\n暂无\n			'),
(3341, '0:4:13', '鸳俦凤侣', '\n【 yuān　chóu　fèng　lǚ 】\n			', '\n形容男女欢爱似鸳鸯、凤凰般相偕作伴。\n			', '\n明·王玉峰《焚香记·离间》：“谩说鸳俦凤侣，惹起蜂争蝶忌。”\n			', '\n暂无\n			'),
(3342, '0:4:13', '鸦巢生凤', '\n【 yā　cháo　shēng　fèng 】\n			', '\n乌鸦的窝里生出了凤凰。比喻贫苦人家培养出了才化的人物。\n			', '\n宋·释普济《五灯会元》：“僧问：‘如何是异类？’显端曰：‘鸦巢生凤。’”\n			', '\n暂无\n			'),
(3343, '0:4:13', '驭凤骖鹤', '\n【 yù　fèng　cān　hè 】\n			', '\n驾凤骑鹤。传说中仙人多驾鹤升天，故用以比喻仙人或得道之士。今常作为哀挽妇女用语。\n			', '\n唐·吴融《和皮博士赴上京观中修灵》诗：“鹤驭已从烟际下，凤膏还向月中焚。白云乡路看看到，好驻流年翊圣文。”\n			', '\n唐武宗嗣历改元会昌。爱～之仪。薄点黑降龙之教。乃下郡国毁庙塔令沙门复。\n			'),
(3344, '0:4:13', '有凤来仪', '\n【 yǒu　fèng　lái　yí 】\n			', '\n凤：凤凰，传说中的百鸟之王；仪：仪容。古时吉祥的征兆。\n			', '\n《尚书·益稷》：“箫韶九成，凤皇来仪。”\n			', '\n宝玉道：“这太板了。莫若‘～’四字。”（清·曹雪芹《红楼梦》第十七回）\n			'),
(3345, '0:4:13', '鬻鸡为凤', '\n【 yù　jī　wéi　fèng 】\n			', '\n指以次充好，混淆优劣。\n			', '\n唐·黄滔《谢试官》：“伏念鬻鸡为凤，有识咸惊，投砾参琼，良知足鄙。”\n			', '\n暂无\n			'),
(3346, '0:4:13', '翥凤翔鸾', '\n【 zhù　fèng　xiáng　luán 】\n			', '\n盘旋飞举的凤凰。常比喻美妙的舞姿。\n			', '\n明梁辰鱼《浣纱记·演舞》：“舞所以导人沉滞，故春风起于筵上，夜有聚于楼头，古有翥凤翔鸾，萦尘集羽，折腰翘袖，《激楚》《阳阿》，俱要俯仰应声，抑扬合节。”\n			', '\n暂无\n			'),
(3347, '0:4:13', '朝阳鸣凤', '\n【 zhāo　yáng　míng　fèng 】\n			', '\n比喻品德出众、正直敢谏之人。\n			', '\n语出《诗·大雅·卷阿》：“凤凰鸣矣，于彼高冈，梧桐生矣，于彼朝阳。”\n			', '\n庚子八月，君果以身殉国耻。噫嘻！可不谓～耶！\n			'),
(3348, '0:4:14', '百鸟朝凤', '\n【 bǎi　niǎo　cháo　fèng 】\n			', '\n朝：朝见；凤：凤凰，古代传说中的鸟王。旧时喻指君主圣明而天下依附，后也比喻德高望重者众望所归。\n			', '\n宋·李昉等《太平御览》九百一十五卷引《唐书》：“海州言凤见于城上，群鸟数百随之，东北飞向苍梧山。”\n			', '\n那些玉斝中的长春露酒也都由站在身边侍候的宫女接过去倾入一只绘着～的大瓷缸中。（姚雪垠《李自成》第二卷第三十一章）\n			'),
(3349, '0:4:14', '笨鸟先飞', '\n【 bèn　niǎo　xiān　fēi 】\n			', '\n比喻能力差的人怕落后，做事比别人先动手。\n			', '\n元·关汉卿《陈母教子》第一折：“我和你有个比喻：我似那灵禽在后，你这等坌（笨）鸟先飞。”\n			', '\n女儿刻苦、自觉、用功，全靠～保持了各门功课全班第一。（毕飞宇《九层电梯》）\n			'),
(3350, '0:4:14', '坌鸟先飞', '\n【 bèn　niǎo　xiān　fēi 】\n			', '\n比喻能力差的人做事时，怕赶不上别人，抢先动手。多用作谦词。同“笨鸟先飞”。\n			', '\n元·关汉卿《陈母教子》第一折：“[三末云]：二哥，你得了官也。我和你有个比喻，我似那灵禽在后，你这等坌鸟先飞。”\n			', '\n暂无\n			'),
(3351, '0:4:14', '蚕丛鸟道', '\n【 cán　cóng　niǎo　dào 】\n			', '\n指险绝的山路。\n			', '\n清·戴名世《纪红苗事》：“开其蚕丛鸟道，通其百工技艺。”\n			', '\n暂无\n			'),
(3352, '0:4:14', '长颈鸟喙', '\n【 cháng　jǐng　niǎo　huì 】\n			', '\n喙：鸟的嘴。长颈项，尖嘴巴。指阴险狠毒者的状貌。\n			', '\n《史记·越王勾践世家》：“范蠡遂去，自齐遗大夫种书曰：‘蜚鸟尽，良弓藏；狡兔死，走狗烹。越王为人长颈鸟喙，可与共患难，不可与共乐。子何不去？”\n			', '\n既已灭吴，以勾践为人，～，可与共患难，不可与同逸乐，浮海而去。（明·瞿佑《剪灯新话·龙堂灵会录》）\n			'),
(3353, '0:4:14', '池鱼笼鸟', '\n【 chí　yú　lóng　niǎo 】\n			', '\n池里的鱼，笼里的鸟。比喻受束缚而失去自由的人。\n			', '\n晋·潘岳《秋兴赋》：“譬犹池鱼笼鸟，有江湖山薮之思。”\n			', '\n暂无\n			'),
(3354, '0:4:14', '飞鸟惊蛇', '\n【 fēi　niǎo　jīng　shé 】\n			', '\n像飞鸟入林，受惊的蛇窜入草丛一样。形容草书自然流畅。\n			', '\n《法书苑》：“唐时一僧释亚楼善草书，曾自题一联：‘飞鸟入林，惊蛇入草。’”\n			', '\n暂无\n			'),
(3355, '0:4:14', '飞鸟依人', '\n【 fēi　niǎo　yī　rén 】\n			', '\n依：依恋。飞来的小鸟依偎在人的身边。比喻依附权贵。亦比喻小孩、少女娇小柔顺，可亲可受的情态。\n			', '\n宋·阙名《宋季三朝正要·二·理宗淳祐四年》：“今嵩之父死如路人，方经营内引，摇尾乞怜，作飞鸟依人之态。”\n			', '\n善画兰，亦工诗；丰姿绰约，如～。（清·冯仙湜《图绘宝鉴续篡·三·女史·叶文》）\n			'),
(3356, '0:4:14', '高鸟尽，良弓藏', '\n【 gāo　niǎo　jìn，liáng　gōng　cáng 】\n			', '\n比喻功成事定之后，出力的人反而见弃，没有好下场。\n			', '\n《文子·上德》：“狡兔得而猎犬烹，高鸟尽而良弓藏，名成功遂身退，天道然也。”\n			', '\n鄙语有之：‘～；狡兔殚，猎犬烹。’故文种诛于句践，韩白戮于秦汉。\n			'),
(3357, '0:4:14', '龟文鸟迹', '\n【 guī　wén　niǎo　jì 】\n			', '\n指古代的象形文字。\n			', '\n唐·张彦远《法书要录》第七卷：“颉首四目，通于神明，仰观奎星圆曲之势，俯察龟文鸟迹之象，博彩众美，合而为字，是曰古文。”\n			', '\n暂无\n			'),
(3358, '0:4:14', '寒蝉僵鸟', '\n【 hán　chán　jiāng　niǎo 】\n			', '\n寒天的蝉和冻僵的鸟。比喻默不作声的人。\n			', '\n清·李渔《慎鸾交·心归》：“诗朋同游胜景，怎做得寒蝉僵鸟，反舌无声！”\n			', '\n暂无\n			'),
(3359, '0:4:14', '鹄形鸟面', '\n【 hú　xíng　niǎo　miàn 】\n			', '\n指饥疲瘦削的样子。\n			', '\n明归有光《送宋知县序》：“岁复荐饥，侯加意抚恤，向之逃亡者，鹄形鸟面，争出供役。”\n			', '\n暂无\n			'),
(3360, '0:4:14', '花香鸟语', '\n【 huā　xiāng　niǎo　yǔ 】\n			', '\n鸟语：鸟鸣如同讲话一般。形容春天动人的景象。\n			', '\n清·李汝珍《镜花缘》第九十八回：“云雾渐淡，日色微明，四面也有人烟来往，各处花香鸟语，颇可盘桓。”\n			', '\n春天一到，公园里～，充满了生机。\n			'),
(3361, '0:4:14', '惊弓之鸟', '\n【 jīng　gōng　zhī　niǎo 】\n			', '\n被弓箭吓怕了的鸟不容易安定。比喻经过惊吓的人碰到一点动静就非常害怕。\n			', '\n《战国策·楚策四》；《晋书·王鉴传》：“黩武之众易动，惊弓之鸟难安。”\n			', '\n暂无\n			'),
(3362, '0:4:14', '倦鸟知还', '\n【 juàn　niǎo　zhī　huán 】\n			', '\n疲倦的鸟知道飞回自己的巢。比喻辞官后归隐田园；也比喻从旅居之地返回故乡。\n			', '\n晋·陶潜《归去来辞》：“云无心以出岫，鸟倦飞而知还。”\n			', '\n暂无\n			'),
(3363, '0:4:14', '惊弦之鸟', '\n【 jīng　xián　zhī　niǎo 】\n			', '\n比喻经过惊吓的人碰到一点动静就非常害怕。同“惊弓之鸟”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3364, '0:4:14', '卵覆鸟飞', '\n【 luán　fù　niǎo　fēi 】\n			', '\n鸟飞走了，卵也打破了。比喻两头空，一无所得。\n			', '\n清·蒲松龄《聊斋志异·阿霞》：“人之无良，舍其旧而新是谋，卒之卵覆而鸟亦飞，天之所报亦惨矣！”\n			', '\n暂无\n			'),
(3365, '0:4:14', '笼鸟槛猿', '\n【 lóng　niǎo　jiàn　yuán 】\n			', '\n笼中鸟槛中猿。比喻受拘禁没有自由的人。\n			', '\n唐·白居易《山中与元九书因题书后》诗：“笼鸟槛猿俱未死，人间相见是何年！”\n			', '\n暂无\n			'),
(3366, '0:4:14', '笼鸟池鱼', '\n【 lóng　niǎo　shi　yú 】\n			', '\n关在笼里的鸟，养在池中的鱼。比喻受困失去自由的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3367, '0:4:14', '笼中之鸟', '\n【 lóng　zhōng　zhī　niǎo 】\n			', '\n比喻受困而不自由的人，也比喻易于擒拿的敌人。\n			', '\n《鹖冠子·世兵》：“一目之罗，不可以得雀；笼中之鸟空窥不出。”\n			', '\n暂无\n			'),
(3368, '0:4:14', '木干鸟栖', '\n【 mù　gàn　niǎo　qī 】\n			', '\n指鸟栖树上，至树干枯也不离去。比喻行事坚定不移。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3369, '0:4:14', '鸟得弓藏', '\n【 niǎo　dé　gōng　cáng 】\n			', '\n比喻事情成功之后，把曾经出过力的人一脚踢开。同“鸟尽弓藏”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3370, '0:4:14', '鸟道羊肠', '\n【 niǎo　dào　yáng　cháng 】\n			', '\n狭险典折的山路。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3371, '0:4:14', '鸟伏兽穷', '\n【 niǎo　fú　shòu　qióng 】\n			', '\n如飞鸟栖伏，野兽奔走无路。形容势竭力穷，处境困难。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3372, '0:4:14', '鸟覆危巢', '\n【 niǎo　fù　wēi　cháo 】\n			', '\n鸟巢因建于弱枝而倾覆。比喻处境极端危险。\n			', '\n唐·李商隐《行次昭应县道上》诗：“鱼游沸鼎知无日，鸟覆危巢岂待风。”\n			', '\n暂无\n			'),
(3373, '0:4:14', '鸟焚鱼烂', '\n【 niǎo　fén　yú　làn 】\n			', '\n指因内乱而覆亡。\n			', '\n《易·旅》：“鸟焚其巢，旅人先笑后号咷。”《公羊传·僖公十九年》：“其言梁亡何？自亡也。其自亡奈何？鱼烂而亡也。”\n			', '\n初则狐假鸱张，自谓骁雄莫敌；旋则～，无非破败而终。\n			'),
(3374, '0:4:14', '鸟革翚飞', '\n【 niǎo　gé　huī　fēi 】\n			', '\n革：鸟张翅；翚：羽毛五彩的野鸡。如同鸟儿张开双翼，野鸡展翅飞翔一般。旧时形容宫室华丽。\n			', '\n《诗·小雅·斯干》：“如鸟斯革，如翚斯飞。”\n			', '\n暂无\n			'),
(3375, '0:4:14', '鸟骇鼠窜', '\n【 niǎo　hài　shǔ　cuàn 】\n			', '\n形容惊恐逃窜。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3376, '0:4:14', '鸟迹虫丝', '\n【 niǎo　jì　chóng　sī 】\n			', '\n比喻极易消失的事物。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3377, '0:4:14', '鸟尽弓藏', '\n【 niǎo　jìn　gōng　cáng 】\n			', '\n鸟没有了，弓也就藏起来不用了。比喻事情成功之后，把曾经出过力的人一脚踢开。\n			', '\n《史记·越王勾践世家》：“蜚（飞）鸟尽，良弓藏；狡兔死，走狗烹。”\n			', '\n小弟从征方腊回来，苦劝我东人隐逸。明知有“～”之祸。（清·陈忱《水浒后传》第二十二回）\n			'),
(3378, '0:4:14', '鸟集鳞萃', '\n【 niǎo　jí　lín　cuì 】\n			', '\n鳞：鱼；萃：聚集。象鸟类或鱼类那样聚集在一起。形容聚集得很多。\n			', '\n汉·张衡《西京赋》：“瓌货方至，鸟集鳞萃。”\n			', '\n暂无\n			'),
(3379, '0:4:14', '鸟惊鼠窜', '\n【 niǎo　jīng　shǔ　cuàn 】\n			', '\n形容惊恐逃窜。同“鸟骇鼠窜”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3380, '0:4:14', '鸟惊鱼骇', '\n【 niǎo　jīng　yú　hài 】\n			', '\n像鸟、鱼那种受惊的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3381, '0:4:14', '鸟惊鱼溃', '\n【 niǎo　jīng　yú　kuì 】\n			', '\n溃：溃散。象鸟惊飞，象鱼溃散而逃。形容军队因受惊扰而乱纷纷地四下溃散。\n			', '\n《隋书·杨玄感传论》：“民为凋尽，徭戍无期，率土之心，鸟惊鱼溃。”\n			', '\n暂无\n			'),
(3382, '0:4:14', '鸟惊鱼散', '\n【 niǎo　jīng　yú　sàn 】\n			', '\n形容军队因受惊扰而乱纷纷地四下溃散。同“鸟散鱼溃”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3383, '0:4:14', '鸟哭猿啼', '\n【 niǎo　kū　yuán　tí 】\n			', '\n泛指禽兽悲鸣。形容悲凉的情景。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3384, '0:4:14', '鸟面鹄形', '\n【 niǎo　miàn　hú　xíng 】\n			', '\n形容由于饥饿而身体软弱，面容枯瘦。\n			', '\n《资治通鉴·梁纪·简文帝大宝元年》：“死者蔽野，富室无食，皆鸟面鹄形。”\n			', '\n暂无\n			'),
(3385, '0:4:14', '鸟枪换炮', '\n【 niǎo　qiāng　huàn　pào 】\n			', '\n形容情况或条件有很大的好转。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3386, '0:4:14', '鸟枪换砲', '\n【 niǎo　qiāng　huàn　pào 】\n			', '\n比喻情况或条件有很大好转。砲，同“炮”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3387, '0:4:14', '鸟穷则啄', '\n【 niǎo　qióng　zé　zhuó 】\n			', '\n鸟陷于绝境就要反啄。比喻人走投无路就会冒险。\n			', '\n《荀子·哀公》：“鸟穷则啄，兽穷则攫。”\n			', '\n暂无\n			'),
(3388, '0:4:14', '鸟兽散', '\n【 niǎo　shòu　sàn 】\n			', '\n形容成群的人象鸟兽逃散一样纷乱地散去（多形容敌人溃逃）。\n			', '\n《汉书·李陵传》：“今无兵复战，天明坐受缚矣；各鸟兽散，犹有得脱报天子者。”\n			', '\n暂无\n			'),
(3389, '0:4:14', '鸟声兽心', '\n【 niǎo　shēng　shòu　xīn 】\n			', '\n比喻言辞动听而心怀阴毒。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3390, '0:4:14', '鸟散鱼溃', '\n【 niǎo　sàn　yú　kuì 】\n			', '\n溃：溃散。象鸟惊飞，象鱼溃散而逃。形容军队因受惊扰而乱纷纷地四下溃散。\n			', '\n《南史·宋武帝纪》：“番禺之功，俘级万数，左里之捷，鸟散鱼溃。”\n			', '\n暂无\n			'),
(3391, '0:4:14', '鸟啼花落', '\n【 niǎo　tí　huā　luò 】\n			', '\n形容凄凉的情景。\n			', '\n明·汪廷讷《种玉记·促晤》：“惜鸾帷，孤玉绦，几度凄凉。断肠的鸟啼花落，满目心伤。”\n			', '\n良缘自有三生约，好把心猿意马收。且听岭南莺弄舌，～不知愁。\n			'),
(3392, '0:4:14', '鸟啼花怨', '\n【 niǎo　tí　huā　yuàn 】\n			', '\n形容悲伤怨恨。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3393, '0:4:14', '鸟语花香', '\n【 niǎo　yǔ　huā　xiāng 】\n			', '\n鸟叫得好听，花开得喷香。形容春天的美好景象。\n			', '\n清·李汝珍《镜花缘》第九十八回：“云雾渐淡，日色微明，四面也有人烟来往，各处花香鸟语，颇可盘桓。”\n			', '\n春天一到，公园里～，充满了生机。\n			'),
(3394, '0:4:14', '穷鸟入怀', '\n【 qióng　niǎo　rù　huái 】\n			', '\n穷鸟：困窘的鸟；怀：投入怀抱。比喻处境困难而投靠别人。\n			', '\n《三国志·魏志·邴原传》：“政窘急，往投原。”裴松之注引《魏氏春秋》：“政投原曰：‘穷鸟入怀。’原曰：‘安知斯怀之可入邪？’”\n			', '\n～，仁人所悯，况死士归我，当弃之乎！（北齐·颜之推《颜氏家训·省事》）\n			'),
(3395, '0:4:14', '鸮鸟生翼', '\n【 qīng　niǎo　shēng　yì 】\n			', '\n旧传鸮鸟不孝，母哺翼成，啄母睛而去。比喻忘恩负义。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3396, '0:4:14', '青鸟殷勤', '\n【 qīng　niǎo　yīn　qín 】\n			', '\n青鸟：古代传说中传送信件的使者。比喻常通信息，传递消息。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3397, '0:4:14', '轻徙鸟举', '\n【 qīng　xǐ　niǎo　jǔ 】\n			', '\n轻于去留，像鸟飞那样容易。\n			', '\n清·梅曾亮《书李林孙事》：“河南路四通，轻徙鸟举不可制。”\n			', '\n暂无\n			'),
(3398, '0:4:14', '禽息鸟视', '\n【 qín　xī　niǎo　shì 】\n			', '\n比喻生活优裕而对社会不能做一点有益的事。\n			', '\n《三国志·魏书·陈思王植传》：“虚荷上位而忝重禄，禽息鸟视，终于白首。此徒圈牢之养物，非臣之所志也。”\n			', '\n暂无\n			'),
(3399, '0:4:14', '如鸟兽散', '\n【 rú　niǎo　shòu　sàn 】\n			', '\n象一群飞鸟走兽一样逃散。形容溃败逃散。也比喻集团或组织解散后，其成员各奔东西。\n			', '\n《汉书·李陵传》：“今无兵复战，天明坐受缚矣！各鸟兽散，犹有得脱归报天子者。”\n			', '\n粤兵素弱，见之即溃，～。（清·采蘅子《虫鸣漫录》）\n			'),
(3400, '0:4:14', '人为财死，鸟为食亡', '\n【 rén　wèi　cái　sǐ，niǎo　wèi　shí　wáng 】\n			', '\n旧时俗语。意思是为了追求金钱，连生命都可以不要。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3401, '0:4:14', '三寸鸟，七寸嘴', '\n【 sān　cùn　niǎo，qī　cùn　zuǐ 】\n			', '\n比喻能说会道（多用于讽刺）。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3402, '0:4:14', '伤弓之鸟', '\n【 shāng　gōng　zhī　niǎo 】\n			', '\n被弓箭吓怕了的鸟。比喻受过惊吓，遇到一点动静就怕的人。\n			', '\n《战国策·楚策四》；《晋书·苻生载记》：“伤弓之鸟，落于虚发。”\n			', '\n败了的，似～。（明·许仲琳《封神演义》第四十三回）\n			'),
(3403, '0:4:14', '兽迒鸟迹', '\n【 shòu　hàn　niǎo　jì 】\n			', '\n指鸟兽之迹。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3404, '0:4:14', '兽聚鸟散', '\n【 shòu　jù　niǎo　sàn 】\n			', '\n比喻聚散无常。也比喻乌合之众。\n			', '\n《史记·平津侯主父列传》：“无匈奴之性，兽聚而鸟散，从之如搏影。”\n			', '\n暂无\n			'),
(3405, '0:4:14', '乌鸟私情', '\n【 wū　niǎo　sī　qíng 】\n			', '\n乌鸟：古时传说，小乌能反哺老乌。比喻侍奉尊亲的孝心。\n			', '\n晋·李密《陈情表》：“乌鸟私情，愿乞终养。”\n			', '\n臣已离家日久，老母现在抱病垂危，望陛下赐臣还乡，少遂～。（清·钱彩《说岳全传》第四十五回）\n			'),
(3406, '0:4:14', '象耕鸟耘', '\n【 xiàng　gēng　niǎo　yún 】\n			', '\n传说舜死苍梧，象为之耕；禹葬会稽，鸟为之耘。后用以形容民俗古朴，有舜禹时代的遗风。\n			', '\n《文选·左思〈吴都赋〉》：“象耕鸟耘，此之自与。”李善注引《越绝书》：“舜死苍梧，象为之耕；禹葬会稽，鸟为之耘。”一说，耕者以象行为法，耘者如鸟之啄食。\n			', '\n恒水又东迳蓝莫塔，塔边有池……此中空荒无人，群象以鼻取水洒地，若苍梧、会稽～矣。\n			'),
(3407, '0:4:14', '熊经鸟申', '\n【 xióng　jīng　niǎo　shēn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3408, '0:4:14', '熊经鸟伸', '\n【 xióng　jīng　niǎo　shēn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3409, '0:4:14', '熊经鸟曳', '\n【 xióng　jīng　niǎo　yè 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3410, '0:4:14', '熊经鸟引', '\n【 xióng　jīng　niǎo　yǐn 】\n			', '\n古代一种导引养生之法。状如熊之攀枝，鸟之伸脚。同“熊经鸟申”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3411, '0:4:14', '小鸟依人', '\n【 xiǎo　niǎo　yī　rén 】\n			', '\n依：依恋。象小鸟那样依傍着人。形容少女或小孩娇小可爱的样子。\n			', '\n《旧唐书·长孙无忌传》：“禇遂良学问稍长，性亦坚正，既写忠诚，甚亲附于朕，譬如飞鸟依人，自加怜爱。”\n			', '\n暂无\n			'),
(3412, '0:4:14', '羊肠鸟道', '\n【 yáng　cháng　niǎo　dào 】\n			', '\n形容山路狭窄，曲折而险峻。\n			', '\n唐玄宗《早登太行山中言志》诗：“火龙明鸟道，铁骑绕羊肠。”\n			', '\n千崖万壑供野宿，～笑津迷。（陈毅《乐安宜黄道中闻捷》）\n			'),
(3413, '0:4:14', '鱼惊鸟散', '\n【 yú　jīng　niǎo　sàn 】\n			', '\n指像鱼腐烂鸟溃散。比喻迅即崩溃，完全失败。\n			', '\n《陈书·高祖纪上》：“公以国盗边警，知无不为，恤是同盟，诛其丑类，莫不鱼惊鸟散，面缚头悬。”\n			', '\n暂无\n			'),
(3414, '0:4:14', '鱼溃鸟离', '\n【 yú　kuì　niǎo　lí 】\n			', '\n指像鱼腐烂鸟溃散。比喻迅即崩溃，完全失败。\n			', '\n《周书·武帝纪下》：“王威既振，鱼溃鸟离，破竹更难，见瓴非易。”后蜀·何光远《鉴诫录·知机对》：“一击而鱼溃鸟离，四合而豕分蛇断。”\n			', '\n暂无\n			'),
(3415, '0:4:14', '鱼溃鸟散', '\n【 yú　kuì　niǎo　sàn 】\n			', '\n比喻军队溃败。\n			', '\n《南史·宋武帝纪》：“番禺之功，俘级万数，左里之捷，鸟散鱼溃。”\n			', '\n暂无\n			'),
(3416, '0:4:14', '越鸟南栖', '\n【 yuè　niǎo　nán　qī 】\n			', '\n从南方飞来的鸟，筑巢时一定在南边的树枝上。比喻难忘故乡情。\n			', '\n南朝·梁·萧统《古诗十九首》：“葫马依北风，越鸟巢南枝。”\n			', '\n但闻～，狐死首丘，万里亲戚坟墓，俱在南朝，早暮思想，食不甘味。\n			'),
(3417, '0:4:14', '一石二鸟', '\n【 yī　shí　èr　niǎo 】\n			', '\n扔一颗石子打到两只鸟。比喻做一件事情得到两样好处。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3418, '0:4:14', '云屯鸟散', '\n【 yún　tún　niǎo　sàn 】\n			', '\n如云聚集，如鸟飞散。形容众多的人忽聚忽散。\n			', '\n《后汉书·南匈奴传论》：“雠衅既深，互伺便隙，控弦抗戈，觇望风尘，云屯鸟散，更相驰突。”\n			', '\n暂无\n			'),
(3419, '0:4:14', '鱼县鸟窜', '\n【 yú　xiàn　niǎo　cuàn 】\n			', '\n鱼被钓，鸟逃窜。比喻或受制于人，或飘泊流离，处境十分险困。县，通“悬”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3420, '0:4:14', '鸷鸟将击，卑飞敛翼', '\n【 zhì　niǎo　jiāng　jī，bēi　fēi　liǎn　yì 】\n			', '\n比喻欲擒故纵，伺机而后发。\n			', '\n《六韬·发启》：“鸷鸟将击，卑飞敛翼；猛兽将搏，弭耳俯伏。”\n			', '\n贤弟，且不要使性气，～。\n			'),
(3421, '0:4:14', '鸷鸟累百，不如一鹗', '\n【 zhì　niǎo　lèi　bǎi，bù　rú　yī　è 】\n			', '\n犹言诸侯百人不如天子一人。\n			', '\n《汉书·邹阳传》:“臣闻鸷鸟累百，不如一鹗。”颜师古注引如淳曰：“鸷鸟比诸侯，鹗比天子。”《文选·孔融〈荐祢衡表〉》：“鸷鸟累百，不如一鹗，使衡立朝，必有可观。”李善注：“《史记》赵简子曰：鸷鸟累百，不如一鹗。”\n			', '\n暂无\n			'),
(3422, '0:4:15', '爱鹤失众', '\n【 ài　hè　shī　zhòng 】\n			', '\n比喻因小失大。\n			', '\n《左传·闵公二年》：“狄人伐魏，卫懿公好鹤，鹤有乘轩者。将战，国人受甲者皆曰：‘使鹤，鹤有禄位，余焉能战？’”\n			', '\n暂无\n			'),
(3423, '0:4:15', '别鹤孤鸾', '\n【 bié　hè　gū　luán 】\n			', '\n别：离别；鸾：凤凰一类的鸟。离别的鹤，孤单的鸾。比喻远离的夫妻。\n			', '\n三国魏·稽康《琴赋》：“王昭、楚妃，千里别鹤。”晋·陶潜《拟古》诗：“上弦惊别鹤，下弦操孤鸾。”\n			', '\n暂无\n			'),
(3424, '0:4:15', '别鹤离鸾', '\n【 bié　hè　lí　luán 】\n			', '\n比喻离散的夫妻。\n			', '\n清·纪昀《阅微草堂笔记·槐西杂志四》：“君百计营求，归吾妻子，恒耿耿不忘。今君别鹤离鸾，自合为君料理。”\n			', '\n暂无\n			'),
(3425, '0:4:15', '不舞之鹤', '\n【 bù　wǔ　zhī　hè 】\n			', '\n舞：舞蹈。不舞蹈的鹤。比喻名不副实的人。也用来讥讽人无能。\n			', '\n南朝宋·刘义庆《世说新语·排调》：“昔羊叔子有窑主善舞，尝向客称之。客试使驱来，氃氋而不肯舞。”\n			', '\n方宰淄时，松裁弱冠，过蒙器许，而驽钝不才，竟以～为羊公辱。（清蒲松龄《聊斋志异·折狱》）\n			'),
(3426, '0:4:15', '惭凫企鹤', '\n【 cán　fú　qǐ　hè 】\n			', '\n比喻惭愧自己的短处，羡慕别人的长处。\n			', '\n南朝梁·刘勰《文心雕龙·养气》：“若夫器分有限，智用无涯，或惭凫企鹤，沥辞镌思。”\n			', '\n暂无\n			'),
(3427, '0:4:15', '骖鸾驭鹤', '\n【 cān　luán　yù　hè 】\n			', '\n驾驭鸾凤仙鹤。比喻成仙。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(3428, '0:4:15', '虫沙猿鹤', '\n【 chóng　shā　yuán　hè 】\n			', '\n旧时比喻战死的将士。也指死于战乱的人。\n			', '\n《太平御览》卷九一六引《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小从为虫为沙。”\n			', '\n穆昔南征军不归，～伏似飞。（唐·韩愈《送区弘南归诗》）\n			'),
(3429, '0:4:15', '骀背鹤发', '\n【 dài　bèi　hè　fā 】\n			', '\n鲐背白发。形容年老高寿。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3430, '0:4:15', '独鹤鸡群', '\n【 dú　hè　jī　qún 】\n			', '\n一只鹤站在鸡群中。比喻一个人的才能或仪表超群出众。\n			', '\n晋·戴逵《竹林七贤论》：“嵇绍入洛，或谓王戎曰：‘昨于稠人中始见嵇绍，昂昂然若野鹤之在鸡群。’”南朝梁·刘义庆《世说新语·容止》：“嵇延祖卓卓如野鹤之在鸡群。”\n			', '\n～自寡俦，三间老屋日西头。（清·钱谦益《客途有怀吴中故人周吏部景文》）\n			'),
(3431, '0:4:15', '断鹤续凫', '\n【 duàn　hè　xù　fú 】\n			', '\n断：截断；续：接；凫：野鸭。截断鹤的长腿去接续野鸭的短腿。比喻行事违反自然规律。\n			', '\n《庄子·骈拇》：“长者不为有余，短者不为不足，。是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n～，娇作者妄；移花接木，创始者奇。（清·蒲松龄《聊斋志异·陆判》）\n			'),
(3432, '0:4:15', '断鹤继凫', '\n【 duan　he　xu　fu 】\n			', '\n截短鹤的长腿，接长野鸭的短腿。比喻违反自然规律，办不成的事。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3433, '0:4:15', '凫短鹤长', '\n【 fú　duǎn　hè　cháng 】\n			', '\n凫胫短鹤胫长。长短不齐。泛指馀缺不齐。\n			', '\n元·关汉卿《乔牌儿》套曲：“算到天明走到黑，赤紧的是衣食。凫短鹤长不能走。”\n			', '\n暂无\n			'),
(3434, '0:4:15', '凫鹤从方', '\n【 fú　hè　cóng　fāng 】\n			', '\n指野鸭和鹤各从其所属的品类。比喻顺其自然行事。\n			', '\n《宋书·孔觊传》：“伏愿天明照其心请，乞改今局，授以闲曹，则凫鹤从方，所忧去矣。”\n			', '\n暂无\n			'),
(3435, '0:4:15', '凫胫鹤膝', '\n【 fú　jìng　hè　xī 】\n			', '\n指事物各有长短。\n			', '\n《庄子·骈拇》：“是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n暂无\n			'),
(3436, '0:4:15', '凤鸣鹤唳', '\n【 fèng　míng　hè　lì 】\n			', '\n形容优美的声音。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3437, '0:4:15', '焚琴鬻鹤', '\n【 fén　qín　yù　hè 】\n			', '\n犹焚琴煮鹤。比喻糟蹋美好的事物。\n			', '\n况周颐《蕙风词话》卷二：“焚琴鬻鹤，伧父所为，不图出之改之。”\n			', '\n暂无\n			'),
(3438, '0:4:15', '焚琴煮鹤', '\n【 fén　qín　zhǔ　hè 】\n			', '\n把琴当柴烧，把鹤煮了吃。比喻糟蹋美好的事物。\n			', '\n宋·胡仔《苕溪渔隐丛前集》引《西清诗话》：“义山《杂纂》，品目数十，盖以文滑稽者。其一曰杀风景，谓清泉濯足，背山起楼，烧琴煮鹤。”\n			', '\n搞旅游，建宾馆，无可厚非；但绝不能～，任意破坏植被、水源和野外文物。\n			'),
(3439, '0:4:15', '风声鹤唳，草木皆兵', '\n【 fēng　shēng　hè　lì，cǎo　mù　jiē　bīng 】\n			', '\n唳：鸟鸣。听到风声和鹤叫声，都疑心是追兵。形容人在惊慌时疑神疑鬼。\n			', '\n《晋书·谢玄传》：“闻风声鹤唳，皆以为王师已至。”\n			', '\n狼狈逃窜的匪徒～，吓得魂不附体。\n			'),
(3440, '0:4:15', '风声鹤唳', '\n【 fēng　shēng　hè　lì 】\n			', '\n唳：鹤叫声。形容惊慌失措，或自相惊忧。\n			', '\n唐·房玄龄《晋书·谢玄传》：“闻风声鹤唳，皆以为王师已至。”\n			', '\n直到后来，听到了那些～的传说，见到了举室仓皇的不安状态。\n			'),
(3441, '0:4:15', '孤雌寡鹤', '\n【 gū　cí　guǎ　hè 】\n			', '\n丧失配偶的禽鸟。后亦用以比喻失偶之人。\n			', '\n汉·王褒《洞箫赋》：“孤雌寡鹤，娱优乎其下兮；春禽群嬉，翱翔乎其颠。”\n			', '\n暂无\n			'),
(3442, '0:4:15', '龟鹤遐龄', '\n【 guī　hè　xiá　líng 】\n			', '\n遐：长久。遐龄：高寿。传说龟、鹤都能活一千年。比喻长寿。亦作“龟龄鹤算”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3443, '0:4:15', '龟鹤遐寿', '\n【 guī　hè　xiá　shòu 】\n			', '\n遐：长久。祝人长寿的颂辞。\n			', '\n《抱朴子·对俗》：“知龟鹤之遐寿，故效其道引以增年。”\n			', '\n暂无\n			'),
(3444, '0:4:15', '龟龄鹤算', '\n【 guī　líng　hè　suàn 】\n			', '\n比喻人之长寿。或用作祝寿之词。同“龟年鹤寿”。\n			', '\n宋·侯寘《水调歌头·为郑子礼提刑寿》词：“坐享龟龄鹤算，稳佩金鱼玉带，常近赭黄袍。”\n			', '\n表长年。傲～，永劫绵绵。\n			'),
(3445, '0:4:15', '龟年鹤寿', '\n【 guī　nián　hè　shòu 】\n			', '\n相传龟、鹤寿有千百之数，而用于比喻人之长寿。或用作祝寿之词。\n			', '\n唐·李商隐《祭张书记文》：“神道甚微，天理难究，桂蠹兰败，龟年鹤寿。”\n			', '\n祝老爷爷～。\n			'),
(3446, '0:4:15', '龟年鹤算', '\n【 guī　nián　hè　suàn 】\n			', '\n比喻人之长寿。或用作祝寿之词。同“龟年鹤寿”。\n			', '\n宋·韦骧《醉蓬莱·廷评庆寿》词：“惟愿增高，龟年鹤算，鸿恩紫诏。”\n			', '\n暂无\n			'),
(3447, '0:4:15', '孤云野鹤', '\n【 gū　yún　yě　hè 】\n			', '\n旧指闲散自在，不求名利的人。\n			', '\n唐·刘方平《送方外上人》诗：“孤云将野鹤，岂向人间住。”\n			', '\n～，栖无定所，别后幸复顽健。（清·蒲松龄《聊斋志异·成仙》）\n			'),
(3448, '0:4:15', '鹤背扬州', '\n【 hè　bèi　yáng　zhōu 】\n			', '\n比喻利欲之心。\n			', '\n南朝·梁·殷芸《小说》卷六：“有客相从，各言所志：或原为扬州刺史，或原多赀财，或原骑鹤上升，其一人曰：‘腰缠十万贯，骑鹤上扬州。’欲兼三者。”\n			', '\n无愿何求，笑时人～。\n			'),
(3449, '0:4:15', '鹤长凫短', '\n【 hè　cháng　fú　duǎn 】\n			', '\n比喻事物各有特点。\n			', '\n《庄子·骈拇》：“凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n～不能齐，到头来不知谁是谁。\n			'),
(3450, '0:4:15', '鸿俦鹤侣', '\n【 hóng　chóu　hè　lǚ 】\n			', '\n鸿、鹤皆为群居高飞之鸟，因用以比喻高洁、杰出之辈。\n			', '\n唐·黎逢《贡举人见于含元殿赋》：“今则凝神注目，无非绣户金铺；接踵比肩，尽是鸿俦鹤侣。”\n			', '\n暂无\n			'),
(3451, '0:4:15', '鹤处鸡群', '\n【 hè　chǔ　jī　qún 】\n			', '\n比喻一个人的仪表或才能在周围一群人里显得很突出。同“鹤立鸡群”。\n			', '\n《敦煌变文集·维摩诘经讲经文》：“遥望而清风宛在，鹤处鸡群；近观而光彩射人，龙来洞口。”\n			', '\n鲲为鱼队潜鳞困，～病翅低。\n			'),
(3452, '0:4:15', '鹤短凫长', '\n【 hè　duǎn　fú　cháng 】\n			', '\n比喻颠倒是非，妄加评论。\n			', '\n《庄子·骈拇》：“凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n且齐之年世不可屈，而燕独可屈，～，妄分厚薄，又何理也？\n			'),
(3453, '0:4:15', '鹤发鸡皮', '\n【 hè　fà　jī　pí 】\n			', '\n鹤发：白发；鸡皮：形容皮肤有皱纹。皮肤发皱，头发苍白。形容老人年迈的相貌。\n			', '\n北周·庾信《竹杖赋》：“子老矣，鹤发鸡皮，蓬头历齿。”唐玄宗《傀儡吟》：“刻木牵丝作老翁，鸡皮鹤发与真同。”\n			', '\n暂无\n			'),
(3454, '0:4:15', '鹤发松姿', '\n【 hè　fà　sōng　zī 】\n			', '\n白色的头发，松树的姿态。形容人虽老犹健。\n			', '\n金·元好问《紫微刘丈山水为济川赋》诗：“千章古木散岩谷，鹤发松姿馀典刑。”\n			', '\n暂无\n			'),
(3455, '0:4:15', '鹤发童颜', '\n【 hè　fà　tóng　yán 】\n			', '\n仙鹤羽毛般雪白的头发，儿童般红润的面色。形容老年人气色好。\n			', '\n唐·田颖《梦游罗浮》：“自言非神亦非仙，鹤发童颜古无比。”\n			', '\n（华佗）童颜鹤发，飘然有出世之姿。（明·罗贯中《三国演义》第十五回）\n			'),
(3456, '0:4:15', '鹤归华表', '\n【 hè　guī　huá　biǎo 】\n			', '\n感叹人世的变迁。\n			', '\n晋·陶潜《搜神後记》卷一：“丁令威，本辽东人，学道于灵虚山。後化鹤归辽，集城门华表柱。时有少年，举弓欲射之。鹤乃飞，徘徊空中而言曰：‘有鸟有鸟丁令威，去家千年今始归。城郭如故人民非，何不学仙冢垒垒。’遂高上冲天。”\n			', '\n念亲恩主德总来难报，须教，枕戈汗马，努力塞云边草，儿时得功成大漠，～。\n			'),
(3457, '0:4:15', '鹤骨鸡肤', '\n【 hè　gǔ　jī　fū 】\n			', '\n伶仃瘦骨，多皱的皮肤。形容年老。\n			', '\n宋·王炎《病中书怀》诗：“鹤骨鸡肤不耐寒，那堪癣疥更斑烂。”\n			', '\n你看这位～，腰弯背驼，其貎不扬吧，那唱的可是正经的‘杨派’。\n			'),
(3458, '0:4:15', '鹤骨龙筋', '\n【 hè　gǔ　lóng　jīn 】\n			', '\n指瘦挺虬曲的样子。\n			', '\n宋·苏轼《孤山二咏·柏堂》：“道人手种几生前，鹤骨龙筋尚宛然。”\n			', '\n暂无\n			'),
(3459, '0:4:15', '鹤骨松筋', '\n【 hè　gǔ　sōng　jīn 】\n			', '\n指修道者的形貌气质。\n			', '\n前蜀·贯休《遇道者》诗：“鹤骨松筋风貎殊，不言名姓绝荣枯。”\n			', '\n暂无\n			'),
(3460, '0:4:15', '鹤骨霜髯', '\n【 hè　gǔ　shuāng　rán 】\n			', '\n瘦骨白须。形容年老。\n			', '\n宋·苏轼《赠岭老人》诗：“鹤骨霜髯心已灰，青松合抱手亲栽。”\n			', '\n暂无\n			'),
(3461, '0:4:15', '鹤骨松姿', '\n【 hè　gǔ　sōng　zī 】\n			', '\n清奇不凡的气质。多指修道者的形貌。\n			', '\n金·元好问《普照范炼师写真》诗之三：“鹤骨松姿又一奇，化身千亿更无疑。”\n			', '\n操请人。见其人～，形貌苍古。问之，乃京兆人也，隐居终南山。\n			'),
(3462, '0:4:15', '鹤困鸡群', '\n【 hè　kùn　jī　qún 】\n			', '\n比喻才能出众的人沦落于平庸之辈当中。\n			', '\n清·李渔《闲情偶寄·演习·教白》：“苟得其人，必破优伶之格以待之，不则鹤困鸡群，与侪众无异。”\n			', '\n暂无\n			'),
(3463, '0:4:15', '鹤唳风声', '\n【 hè　lì　fēng　shēng 】\n			', '\n唳：鸟鸣。听到风声和鹤叫声，都疑心是追兵。形容人在惊慌时疑神疑鬼。\n			', '\n《晋书·谢玄传》：“闻风声鹤唳，皆以为王师已至。”\n			', '\n忙追去，片甲莫教除，～，元兵胆碎。\n			'),
(3464, '0:4:15', '鹤唳华亭', '\n【 hè　lì　huá　tíng 】\n			', '\n表现思念、怀旧之意。亦为慨叹仕途险恶、人生无常之词。\n			', '\n南朝·宋·刘义庆《世说新语·尤悔》：“陆平原河桥败，为卢志所谗，被诛。临刑叹曰：‘欲闻华亭鹤唳，可复得乎！’”\n			', '\n暂无\n			'),
(3465, '0:4:15', '鹤立鸡群', '\n【 hè　lì　jī　qún 】\n			', '\n象鹤站在鸡群中一样。比喻一个人的仪表或才能在周围一群人里显得很突出。\n			', '\n晋·戴逵《竹林七贤论》：“嵇绍入洛，或谓王戎曰：‘昨于稠人中始见嵇绍，昂昂然若野鹤之在鸡群。’”南朝·宋·刘义庆《世说新语·容止》：“嵇延祖卓卓如野鹤之在鸡群。”\n			', '\n正在谈论，谁知女儿国王忽见林之洋杂在众人中，如～一般。（清·李汝珍《镜花缘》第三十九回）\n			'),
(3466, '0:4:15', '鹤唳猿声', '\n【 hè　lì　yuán　shēng 】\n			', '\n鹤鸣猿啼。形容凄清孤寂的景象。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3467, '0:4:15', '鹤鸣九皋', '\n【 hè　míng　jiǔ　gāo 】\n			', '\n九皋：深泽。鹤鸣于湖泽的深处，它的声音很远都能听见。比喻贤士身隐名著。\n			', '\n《诗经·小雅·鹤鸣》：“鹤鸣于九皋，声闻于野。”\n			', '\n～，犹载厥声。况乃海隅，播名上京。（晋·潘岳《为贾谧作赠陆机》诗）\n			'),
(3468, '0:4:15', '鹤鸣之士', '\n【 hè　míng　zhī　shì 】\n			', '\n指有才德声望的隐士。\n			', '\n《周易·中孚》：“鹤鸣在阴，其子和之；我有好爵，吾与尔靡之。”\n			', '\n惟陛下慎经典之诫，图变复之道。斥远佞巧之臣，速征～。（《后汉书·杨赐传》）\n			'),
(3469, '0:4:15', '鹤势螂形', '\n【 hè　shì　láng　xíng 】\n			', '\n指腰肢纤袅，体态轻盈。\n			', '\n《红楼梦》第四九回：“[湘云]腰里紧紧束着一条蝴蝶结子长穗五色宫绦，脚下也穿着鹿皮小靴：越显得蜂腰猿背，鹤势螂形。”\n			', '\n暂无\n			'),
(3470, '0:4:15', '华亭鹤唳', '\n【 huà　tíng　hè　lì 】\n			', '\n华亭谷的鹤叫声。表示对过去生活的留恋。\n			', '\n南朝·宋·刘义庆《世说新语·尤梅》：“ 临刑叹曰：‘欲闻华亭鹤唳，可复得呼？’”\n			', '\n暂无\n			'),
(3471, '0:4:15', '鹤膝蜂腰', '\n【 hè　xī　fēng　yāo 】\n			', '\n①这是指诗歌声律八病的两种。泛指诗歌声律上所犯的毛病。②书法中的两种病笔。\n			', '\n宋·魏庆之《诗人玉屑·诗病·诗病有八》：“三曰蜂腰，第二字不得与第五字同声……四曰鹤膝，第五字不得与第十五字同声。”\n			', '\n近来诗思殊无況，苦被时流不相放。云腾浪走势未衰，～岂能障。\n			'),
(3472, '0:4:15', '鹤行鸡群', '\n【 hè　xíng　jī　qún 】\n			', '\n比喻一个人的仪表或才能在周围一群人里显得很突出。同“鹤立鸡群”。\n			', '\n宋·苏辙《次韵子瞻感旧见寄》：“君才最高峙，鹤行鸡群中。”\n			', '\n暂无\n			'),
(3473, '0:4:15', '鹤怨猿惊', '\n【 hè　yuàn　yuán　jīng 】\n			', '\n形容对官场厌倦，有意归隐的心情。\n			', '\n宋·辛弃疾《沁园春·带湖新居将成》词：“三径初成，鹤怨猿惊，稼轩未来。”\n			', '\n搔首倚薰风，一幅画图尘土中。～人去也，潜龙。谁绞香车起蛰松。\n			'),
(3474, '0:4:15', '鹤子梅妻', '\n【 hè　zǐ　méi　qī 】\n			', '\n指宋隐士林逋以鹤为子、以梅为妻事。亦喻指妻子儿女。\n			', '\n清·董以宁《河满子·同程村闲话》词：“若比孤山林处士，但非鹤子梅妻。”\n			', '\n健儿拥护出京都，～又橘奴。\n			'),
(3475, '0:4:15', '鹤知夜半', '\n【 hè　zhī　yè　bàn 】\n			', '\n鹤夜半而鸣。比喻各有专长。也比喻偏知一隅。\n			', '\n《淮南子·说山训》：“鸡知将旦，鹤知夜半，而不免于鼎俎。”\n			', '\n适偶有所偏解，犹～，燕知戊己，而示必达于他事也。\n			'),
(3476, '0:4:15', '鸡肤鹤发', '\n【 jī　fū　hè　fā 】\n			', '\n皮肤发皱，头发苍白。指老人。同“鸡皮鹤发”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3477, '0:4:15', '驾鹤成仙', '\n【 jià　hè　chéng　xiān 】\n			', '\n指死的婉称。\n			', '\n杨大群《关东传奇》第54章：“老爹，你驾鹤成仙了，嘿嘿。”\n			', '\n暂无\n			'),
(3478, '0:4:15', '槛花笼鹤', '\n【 jiàn　huā　lóng　hè 】\n			', '\n栅栏中的花、笼中的鹤。比喻受到约束的人或物。\n			', '\n清·龚自珍《好事近·行箧中有像一幅以词为赞》：“倘然生小在侯家，天意转孤负。作了槛花笼鹤，怎笑狂如许！”\n			', '\n暂无\n			'),
(3479, '0:4:15', '截鹤续凫', '\n【 jié　hè　xù　fú 】\n			', '\n比喻事物勉强替代，失其本性。\n			', '\n《庄子·骈拇》：“长者不为有余，短者不为不足。是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n暂无\n			'),
(3480, '0:4:15', '驾鹤西游', '\n【 jià　hè　xī　yóu 】\n			', '\n死的婉称。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3481, '0:4:15', '鸡皮鹤发', '\n【 jī　pí　hè　fà 】\n			', '\n皮肤发皱，头发苍白。指老人。\n			', '\n北周·庾信《竹杖赋》：“子老矣，鹤发鸡皮，蓬头历齿。”\n			', '\n刻木牵丝作老翁，～与真同。（唐玄宗《傀儡吟》）\n			'),
(3482, '0:4:15', '枯鱼病鹤', '\n【 kū　yú　bìng　hè 】\n			', '\n比喻处境穷困之士。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3483, '0:4:15', '离鸾别鹤', '\n【 lí　luán　bié　hè 】\n			', '\n比喻夫妻离散。同“离鸾别凤”。\n			', '\n《乐府诗集·琴曲歌辞三·胡笳十八拍》：“唐刘商《胡笳曲序》曰：‘蔡文姬善琴，能为《离鸾别鹤之操》。’”\n			', '\n忽听梨园新乐府，～清如许。\n			'),
(3484, '0:4:15', '鸾音鹤信', '\n【 luán　yīn　hè　xìn 】\n			', '\n比喻仙界的音信。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3485, '0:4:15', '鸣鹤之应', '\n【 míng　hè　zhī　yīng 】\n			', '\n比喻诚笃之心相互应和。\n			', '\n《易·中孚》：“鹤鸣在阴，其子和之。”王弼注：“立诚笃至，虽在闇昧，物亦应焉。”孔颖达疏：“处于幽昧而行不失信，则声闻于外，为同类之所应焉。”\n			', '\n乃今穴居名彥，大夫垂访，诸君感～，邕邕焉，锵锵焉。夫亦行古之道也。\n			'),
(3486, '0:4:15', '梅妻鹤子', '\n【 méi　qī　hè　zǐ 】\n			', '\n以梅为妻，以鹤为子。比喻清高或隐居。宋·林逋隐居西湖孤山，植梅养鹤，终生不娶，人谓“梅妻鹤子”。\n			', '\n宋·沈括《梦溪笔谈·人事二》：“林逋隐居杭州孤山，常畜两鹤，纵之则飞入云霄，盘旋久之，復入笼中。逋常泛小艇，游西湖诸寺。有客至逋所居，则一童子出应门，延客坐，为开笼纵鹤。良久，逋必棹小船而归。盖尝以鹤飞为验也。”\n			', '\n兆熊说：‘像是像，不过，有最重要的一点不像。人家和靖居士是～，你却是妻儿成群。’★唐浩明《曾国藩第一部·血祭》第二章四\n			'),
(3487, '0:4:15', '庞眉鹤发', '\n【 páng　méi　hè　fā 】\n			', '\n形容老人相貌。同“庞眉皓发”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3488, '0:4:15', '强凫变鹤', '\n【 qiǎng　fú　biàn　hè 】\n			', '\n指硬把野鸭变作仙鹤。喻滥竽充数，徒多无益。\n			', '\n语出《庄子·骈拇》：“凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n暂无\n			'),
(3489, '0:4:15', '骑鹤上维扬', '\n【 qí　hè　shàng　wéi　yáng 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3490, '0:4:15', '骑鹤上扬', '\n【 qí　hè　shàng　yáng 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3491, '0:4:15', '骑鹤上扬州', '\n【 qí　hè　shàng　yáng　zhōu 】\n			', '\n后因以比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。\n			', '\n南朝梁·殷芸《小说》卷六：“有客相从，各言所志：或原为扬州刺史，或原多赀财，或原骑鹤上升，其一人曰：‘腰缠十万贯，骑鹤上扬州。’欲兼三者。”\n			', '\n暂无\n			'),
(3492, '0:4:15', '骑鹤望扬州', '\n【 qí　hè　wàng　yáng　zhōu 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3493, '0:4:15', '骑鹤维扬', '\n【 qí　hè　wéi　yáng 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3494, '0:4:15', '骑鹤扬州', '\n【 qí　hè　yáng　zhōu 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3495, '0:4:15', '妻梅子鹤', '\n【 qī　mén　zǐ　hè 】\n			', '\n以梅为妻，以鹤为子，表示清高或隐居。\n			', '\n清·徐釚《词苑丛谈》卷三：“林处士妻梅子鹤，可称千古高风矣。”\n			', '\n暂无\n			'),
(3496, '0:4:15', '千岁鹤归', '\n【 qiān　suì　hè　guī 】\n			', '\n指对故乡的眷恋之情。\n			', '\n晋·陶潜《搜神后记》卷一：“丁令威，本辽东人，学道于灵虚山。后化鹤归辽，集城门华表柱。时有少年，举弓欲射之。鹤乃飞，徘徊空中而言曰：‘有鸟有鸟丁令威，去家千年今始归，城郭如故人民非，何不学仙冢累累。’遂高上冲天。”\n			', '\n暂无\n			'),
(3497, '0:4:15', '骑上扬州鹤', '\n【 qí　shàng　yáng　zhōu　hè 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3498, '0:4:15', '骑扬州鹤', '\n【 qí　yáng　zhōu　hè 】\n			', '\n比喻欲集做官、发财、成仙于一身，或形容贪婪、妄想。同“骑鹤上扬州”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3499, '0:4:15', '烧琴煮鹤', '\n【 shāo　qín　zhǔ　hè 】\n			', '\n拿琴当柴烧，把鹤煮了吃。比喻糟蹋美好的事物。\n			', '\n宋胡仔《苕溪渔隐丛话前集·西昆体》：“《西清诗话》云：‘《义山杂纂》，品目数十，盖以文滑稽者。其一曰杀风景，谓清泉濯足，花上晒褌，背山起楼，烧琴煮鹤，对花啜茶，松下喝道。’”\n			', '\n也须把温语相商，又何用～，躏玉蹂香。\n			'),
(3500, '0:4:15', '松形鹤骨', '\n【 sōng　xíng　hè　gǔ 】\n			', '\n形容仪容清癯、轩昂。\n			', '\n明·罗贯中《三国演义》第三十五回：“玄德视其人，松形鹤骨，器宇不凡。”\n			', '\n暂无\n			'),
(3501, '0:4:15', '童颜鹤发', '\n【 tóng　yán　hè　fà 】\n			', '\n颜：脸色。仙鹤羽毛似雪白的头发，孩子似的红润的面色。形容老年人气色好。\n			', '\n唐·田颖《梦游罗浮》：“自言非神亦非仙，鹤发童颜古无比。”\n			', '\n（华佗）～，飘然有出世之姿。（明·罗贯中《三国演义》第十五回）\n			'),
(3502, '0:4:15', '续凫断鹤', '\n【 xù　fú　duàn　hè 】\n			', '\n比喻违失事物本性，欲益反损。\n			', '\n《庄子·骈拇》：“长者不为有余，短者不为不足。是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n～，截足以适履，犹以为工未至也，如是则宁复有诗哉？\n			'),
(3503, '0:4:15', '续凫截鹤', '\n【 xù　fú　jié　hè 】\n			', '\n比喻违失事物本性，欲益反损。\n			', '\n语出《庄子·骈拇》：“长者不为有余，短者不为不足。是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n若矫其肆任之性，以徇刑政之端，是～，亏其全矣。\n			'),
(3504, '0:4:15', '轩鹤冠猴', '\n【 xuān　hè　guàn　hóu 】\n			', '\n乘轩之鹤，戴帽之猴。比喻滥厕禄位、虚有其表的人。\n			', '\n明·刘基《驿传杭台消息石末公有诗见寄次韵奉和并寓悲感》之一：“池鱼幕燕依栖浅，轩鹤冠猴宠渥新。”\n			', '\n暂无\n			'),
(3505, '0:4:15', '续鹜短鹤', '\n【 xù　wù　duǎn　hè 】\n			', '\n比喻违失事物本性，欲益反损。\n			', '\n语出《庄子·骈拇》：“长者不为有余，短者不为不足。是故凫胫虽短，续之则忧；鹤胫虽长，断之则悲。”\n			', '\n小大相形，是～之论也。\n			'),
(3506, '0:4:15', '枭心鹤貌', '\n【 xiāo　xīn　hè　mào 】\n			', '\n比喻心恶貌善。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3507, '0:4:15', '闲云孤鹤', '\n【 xián　yún　gū　hè 】\n			', '\n漂浮的云，孤飞的鹤。比喻无拘无束、来去自如的人。\n			', '\n宋·文莹《续湘山野录》：“州亦难添，诗亦不改，然闲云野鹤何天而不可飞邪？”\n			', '\n暂无\n			'),
(3508, '0:4:15', '闲云野鹤', '\n【 xián　yún　yě　hè 】\n			', '\n闲：无拘束。飘浮的云，野生的鹤。旧指生活闲散、脱离世事的人。\n			', '\n宋·尤袤《全唐诗话》卷六：“州亦难添，诗亦难改，然闲云孤鹤，何天而不可飞。”\n			', '\n独有妙玉如～，无拘无束。（清·曹雪芹《红楼梦》第一百二十回）\n			'),
(3509, '0:4:15', '猿悲鹤怨', '\n【 yuán　bēi　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n宋·朱熹《送籍溪胡丈赴馆供职》诗之二：“猿悲鹤怨因何事？只恐先生袖手归。”\n			', '\n暂无\n			'),
(3510, '0:4:15', '驭凤骖鹤', '\n【 yù　fèng　cān　hè 】\n			', '\n驾凤骑鹤。传说中仙人多驾鹤升天，故用以比喻仙人或得道之士。今常作为哀挽妇女用语。\n			', '\n唐·吴融《和皮博士赴上京观中修灵》诗：“鹤驭已从烟际下，凤膏还向月中焚。白云乡路看看到，好驻流年翊圣文。”\n			', '\n唐武宗嗣历改元会昌。爱～之仪。薄点黑降龙之教。乃下郡国毁庙塔令沙门复。\n			'),
(3511, '0:4:15', '猿鹤虫沙', '\n【 yuán　hè　chóng　shā 】\n			', '\n旧时比喻战死的将士。也指死于战乱的人。\n			', '\n《太平御览》卷九六一引《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小人为虫为沙。”唐·韩愈《送区弘南归诗》：“穆昔南征军不归，虫沙猿鹤伏似飞。”\n			', '\n暂无\n			'),
(3512, '0:4:15', '野鹤孤云', '\n【 yě　hè　gū　yún 】\n			', '\n比喻无拘无束、来去自如的人。同“闲云孤鹤”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3513, '0:4:15', '猿鹤沙虫', '\n【 yuán　hè　shā　chóng 】\n			', '\n指阵亡的将士或死于战乱的人民。\n			', '\n《艺文类聚》卷九十引晋葛洪《抱朴子》：“周穆王南征，一军尽化，君子为猿为鹤，小人为虫为沙。”按，今本《抱朴子·释滞》作：“山徙社移，三军之众，一朝尽化，君子为鹤，小人成沙。”\n			', '\n你看山川图画，人物衣冠，生聚年时久，忍下得咸阳一炬里变焦丘，～满地愁。\n			'),
(3514, '0:4:15', '野鹤闲云', '\n【 yě　hè　xián　yún 】\n			', '\n闲：无拘束。飘浮的云，野生的鹤。旧指生活闲散、脱离世事的人。\n			', '\n宋·尤袤《全唐诗话》卷六：“州亦难添，诗亦难改，然闲云孤鹤，何天而不可飞。”\n			', '\n暂无\n			'),
(3515, '0:4:15', '延颈鹤望', '\n【 yán　jǐng　hè　wàng 】\n			', '\n像鹤一样伸长颈子盼望。比喻盼望心切。\n			', '\n《三国志·蜀书》：“今寇虏作害，民被荼毒，思汉之士，延颈鹤望。”\n			', '\n暂无\n			'),
(3516, '0:4:15', '猿惊鹤怨', '\n【 yuán　jīng　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n宋·王阮《秋日寄舍弟》诗：“猿惊鹤怨草三尺，楚尾吴头天一方。”\n			', '\n暂无\n			'),
(3517, '0:4:15', '一琴一鹤', '\n【 yī　qín　yī　hè 】\n			', '\n原指宋朝赵捜ニ拇ㄗ龉伲?嫔硇??亩?鹘鲇幸徽徘俸鸵恢缓住Ｐ稳菪凶凹蛏伲?脖扔魑?偾辶?\n			', '\n宋·沈括《梦溪笔谈》卷九：“赵阅道为成都转运史，出行部内，唯携一琴一鹤，坐则看鹤鼓琴。”《宋史·赵挻?罚骸暗墼唬骸?徘淦ヂ砣胧瘢?砸磺僖缓鬃运妫晃??蛞祝?喑剖呛酰　?\n			', '\n你把那行装整顿，无过是～紧随身。（元·无名氏《冯玉兰夜月泣江舟》第一折）\n			'),
(3518, '0:4:15', '杳如黄鹤', '\n【 yǎo　rú　huáng　hè 】\n			', '\n杳：无影无声；黄鹤：传说中仙人所乘的鹤。原指传说中仙人骑着黄鹤飞去，从此不再回来。现比喻无影无踪或下落不明。\n			', '\n南朝梁·任昉《述异记》：“荀瓌憩江夏黄鹤楼上，望西南有物飘然降自云汉，乃驾鹤之宾也。宾主欢对辞去，跨鹤腾空，眇然烟灭。”唐·崔灏《黄鹤楼》诗：“黄鹤一去不复返，白云千载空悠悠。”\n			', '\n“昨天局长到了没有？”“还是～。”（鲁迅《彷徨·弟兄》）\n			'),
(3519, '0:4:15', '猿啼鹤唳', '\n【 yuán　tí　hè　lì 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n明·施耐庵《水浒传》第五十三回：“两崖分虎踞龙盘，四面有猿啼鹤唳。”\n			', '\n暂无\n			'),
(3520, '0:4:15', '猿啼鹤怨', '\n【 yuán　tí　hè　yuàn 】\n			', '\n猿和鹤凄厉地啼叫。\n			', '\n明·汤显祖《牡丹亭·御淮》：“听得猿啼鹤怨，泪湿征袍如汗。”\n			', '\n暂无\n			'),
(3521, '0:4:15', '云心鹤眼', '\n【 yún　xīn　hè　yǎn 】\n			', '\n比喻高远的处世态度。\n			', '\n唐·白居易《酬杨八》诗：“君以旷怀宜静境，我因蹇步称闲官。闭门足病非高士，劳作云心鹤眼看。”\n			', '\n暂无\n			'),
(3522, '0:4:15', '云中白鹤', '\n【 yún　zhōng　bái　hè 】\n			', '\n象云彩中的白鹤一般。比喻志行高洁的人。\n			', '\n《三国志·魏志·邴原传》裴松之注引《原别传》：“邴君所谓云中白鹤，非鹑鷃之网所能罗矣。”\n			', '\n訏超超越俗，如半天朱霞；歊矫矫出尘，如～。（明·李贽《初潭集·兄弟上》）\n			'),
(3523, '0:4:15', '云中仙鹤', '\n【 yún　zhōng　xiān　hè 】\n			', '\n象云彩中的白鹤一般。比喻志行高洁的人。\n			', '\n清·龚自珍《定风波》词：“自古畸人多性癖，奇逸，云中仙鹤怎笼来？”\n			', '\n暂无\n			'),
(3524, '0:4:15', '煮鹤焚琴', '\n【 zhǔ　hè　fén　qín 】\n			', '\n把琴当柴烧，把鹤煮了吃。比喻糟蹋美好的事物。\n			', '\n宋·胡仔《苕溪渔隐丛篆集》引《西清诗话》：“义山《杂纂》，品目数十，盖以文滑稽者。其一曰杀风景，谓清泉濯足，花下晒晖，背山起楼，烧琴煮鹤。”\n			', '\n怜香惜玉无情绪，～惹是非。（明·施耐庵《水浒全传》第十八回）\n			'),
(3525, '0:4:15', '煮鹤烧琴', '\n【 zhǔ　hè　shāo　qín 】\n			', '\n比喻糟蹋美好事物因而大杀风景之事。\n			', '\n唐·韦鹏翼《戏题盱眙壁》诗：“自从煮鹤烧琴后，背却青山卧月明。”\n			', '\n赏心亭上雪初融，～宴钜公。\n			'),
(3526, '0:4:15', '朱颜鹤发', '\n【 zhū　yán　hè　fā 】\n			', '\n朱颜：红润的脸。红润的脸和像鹤羽毛一样白的头发。形容老年人精神焕发的样子。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3527, '0:4:16', '雏鹰展翅', '\n【 chú　yīng　zhǎn　chì 】\n			', '\n雏：幼鸟。幼鹰展开翅膀飞翔。比喻青年人开始独立生活、工作。\n			', '\n<span class="C999">暂无</span>\n			', '\n大学已经毕业了，这正是他～的时侯。\n			'),
(3528, '0:4:16', '雕心鹰爪', '\n【 diāo　xīn　yīng　zhǎo 】\n			', '\n比喻心肠残忍，手段毒辣。\n			', '\n元·无名氏《千里独行》第三折：“他待使些雕心鹰爪，安排下龙韬虎略。”\n			', '\n倚着他龙蟠虎踞江山霸，人强马壮诸侯怕，～窥天下。\n			'),
(3529, '0:4:16', '饿虎饥鹰', '\n【 è　hǔ　jī　yīng 】\n			', '\n比喻凶残贪婪。\n			', '\n《魏书·宗室晖传》：“侍中卢昶，亦蒙恩眄，故时人号曰：‘饿虎将军，饥鹰侍中。’”\n			', '\n衙门里的人，一个个是～，不叫他们敲诈百姓，敲诈哪个呢？（清·李宝嘉《活地狱·楔子》）\n			'),
(3530, '0:4:16', '飞鹰奔犬', '\n【 fēi　yīng　bēn　quǎn 】\n			', '\n放出鹰和狗去追捕野兽。指打猎。同“飞鹰走狗”。\n			', '\n唐·柳泽《上睿宗书》：“或打球击鼓，比周伎艺；或飞鹰奔犬，盘游薮泽。”\n			', '\n暂无\n			'),
(3531, '0:4:16', '飞鹰走狗', '\n【 fēi　yīng　zǒu　gǒu 】\n			', '\n放出鹰狗去追捕野兽。指打猎游荡的生活。\n			', '\n《后汉书·袁术传》：“少以侠气闻，数与诸公子飞鹰走狗。”\n			', '\n暂无\n			'),
(3532, '0:4:16', '飞鹰走马', '\n【 fēi　yīng　zǒu　mǎ 】\n			', '\n放鹰追捕和骑马追逐鸟兽。指打猎。\n			', '\n宋·欧阳修《乞奖用孙沔札子》：“沔今年虽七十，闻其心力不衰，飞鹰走马尚如平日。”\n			', '\n暂无\n			'),
(3533, '0:4:16', '放鹰逐犬', '\n【 fàng　yīng　zhú　quǎn 】\n			', '\n指打猎。\n			', '\n《明史·韩文传》“击球走马，放鹰逐犬，俳优杂剧，错陈于前。”\n			', '\n忽一日带了二三百家将，往乡村打围作乐，一路来到一个地方，名为孟家庄。一众人～。\n			'),
(3534, '0:4:16', '飞鹰走犬', '\n【 fēi　yīng　zǒu　quǎn 】\n			', '\n指打猎游荡的生活。同“飞鹰走狗”。\n			', '\n元·李直夫《虎头牌》第一折：“我如今欲待去消愁闷，则除是飞鹰走犬，逐逝追奔。”\n			', '\n却说曹爽正～之际，忽报城内有变，太傅有表。\n			'),
(3535, '0:4:16', '见兔放鹰', '\n【 jiàn　tù　fàng　yīng 】\n			', '\n看到野兔，立即放出猎鹰追捕。比喻行动及时，适合需要。\n			', '\n宋·释普济《五灯会元》：“布大教网，漉人天鱼，不如见兔放鹰，遇獐发箭。”\n			', '\n当今世情，何人不趋炎附势，～，谁肯结交穷秀才。（明·天然痴叟《石点头·侯官县烈女歼仇》）\n			'),
(3536, '0:4:16', '饥鹰饿虎', '\n【 jī　yīng　è　hǔ 】\n			', '\n比喻凶残贪婪。\n			', '\n《魏书·宗室晖传》：“侍中卢昶，亦蒙恩眄，故时人号曰：‘饿虎将军，饥鹰侍中。’”\n			', '\n暂无\n			'),
(3537, '0:4:16', '南鹞北鹰', '\n【 nán　yào　běi　yīng 】\n			', '\n鹞、鹰：两种猛禽。在南为鹞子，在北为老鹰。比喻性格严峻的人。\n			', '\n《晋书·崔洪传》：“丛生棘刺，来自博陵，在南为鹞，在北为鹰。”\n			', '\n暂无\n			'),
(3538, '0:4:16', '犬牙鹰爪', '\n【 quǎn　yá　yīng　zhǎo 】\n			', '\n比喻善攫取的手段。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3539, '0:4:16', '鹰鼻鹞眼', '\n【 yīng　bí　yào　yǎn 】\n			', '\n鹞：一种形体像鹰而比鹰小的凶猛的鸟，背灰褐色，以小鸟、小鸡为食。形容奸诈凶狠的相貌。\n			', '\n姚雪垠《李自成》第十九章：“我倒是觉得敬轩的那位摇鹅毛扇子的军师，生得鹰鼻子鹞眼，不是个善良家伙。”\n			', '\n暂无\n			'),
(3540, '0:4:16', '鹰撮霆击', '\n【 yīng　cuō　tíng　jī 】\n			', '\n像老鹰攫食，雷霆猛击。形容气势威猛。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3541, '0:4:16', '鹰击长空', '\n【 yīng　jī　cháng　kōng 】\n			', '\n指雄鹰振翅飞翔于辽阔的天空。亦比喻有雄心壮志的人在广阔的领域中施展自己的才能。\n			', '\n毛泽东《沁园春·长沙》词：“ 鹰击长空，鱼翔浅底，万类霜天竞自由。”\n			', '\n暂无\n			'),
(3542, '0:4:16', '鹰击毛挚', '\n【 yīng　jī　máo　zhì 】\n			', '\n击：搏击；挚：凶猛。鸷鸟扑击其他动物时，羽毛都张着。比喻严酷凶悍。\n			', '\n《史记·酷吏列传》：“而纵以鹰击毛挚为治。”\n			', '\n暂无\n			'),
(3543, '0:4:16', '鹰瞵鹗视', '\n【 yīng　lín　è　shì 】\n			', '\n鹰、鹗：两种猛禽；瞵：眼光闪闪地看。形容用凶狠的目光盯视着。\n			', '\n晋·左思《吴都赋》：“狂  犷狯，鹰瞵鹗视。”\n			', '\n暂无\n			'),
(3544, '0:4:16', '鹰瞵虎攫', '\n【 yīng　lín　hǔ　jué 】\n			', '\n形容心怀不善，伺机攫取。同“鹰瞵虎视”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3545, '0:4:16', '鹰瞵虎视', '\n【 yīng　lín　hǔ　shì 】\n			', '\n像鹰和虎一样凶狠贪婪地注视着。形容心怀不善，伺机攫取。\n			', '\n梁启超《论私德》二：“俄罗斯政府，以鹰瞵虎视之势，震慑五陆，而其人民称罪恶之府，黑暗无复天日，（日本人有《露西亚亡国论》，穷形尽相。）亦生计沈窘之影响也。”\n			', '\n暂无\n			'),
(3546, '0:4:16', '鹰拿燕雀', '\n【 yīng　ná　yàn　què 】\n			', '\n比喻捉拿毫不费力。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3547, '0:4:16', '鹰拿雁捉', '\n【 yīng　ná　yàn　zhuō 】\n			', '\n比喻缉捕时的快速凶猛。\n			', '\n《平山冷燕》第五回：“圣旨一下，早有锦衣卫官已将窦国一、宋信鹰拿雁捉的拖了出来。”\n			', '\n暂无\n			'),
(3548, '0:4:16', '鹰觑鹘望', '\n【 yīng　qù　hú　wàng 】\n			', '\n形容视觉敏锐。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3549, '0:4:16', '鹰犬塞途', '\n【 yīng　quǎn　sāi　tú 】\n			', '\n鹰犬：打猎时追捕禽兽的鹰和猎犬，比喻爪牙；塞：堵塞；途：道路。坏人的爪牙塞满道路。\n			', '\n<span class="C999">暂无</span>\n			', '\n这是后来和现在的话，当时可不然，～，干儿当道，魏忠贤不是活着就配享了孔庙么？（鲁迅《伪自由书·文章与题目》）\n			'),
(3550, '0:4:16', '鹰犬之才', '\n【 yīng　quǎn　zhī　cái 】\n			', '\n鹰犬：猎人驯养的鹰与猎狗，打猎时用于追捕猎物。用作鹰犬之才。比喻供驱使、能出力的人。\n			', '\n汉·陈琳《为袁绍传檄各州郡文》：“幕府董统鹰扬，埽夷凶逆，续遇董卓侵官暴国，于是提剑挥鼓，发命东夏，广罗英雄，弃瑕录用，故遂与操参咨策略，谓其鹰犬之才，爪牙可任。”\n			', '\n方今多士盈朝，当择贤者居其任，奈何以弦歌～侍侧，至令致此？乃陛下训导不足，岂太子之罪耶！\n			'),
(3551, '0:4:16', '鹰视虎步', '\n【 yīng　shì　hǔ　bù 】\n			', '\n象鹰那样看东西，象老虎那样走路。形容为人阴险狠毒。\n			', '\n汉·赵晔《吴越春秋·阖闾内传》：“吾观喜之为人鹰视虎步，专功杀之性，不可亲也。”\n			', '\n暂无\n			'),
(3552, '0:4:16', '鹰视狼步', '\n【 yīng　shì　láng　bù 】\n			', '\n象鹰那样看东西，象狼那样走路。形容为人阴险狠毒。\n			', '\n汉·赵晔《吴越春秋·勾践伐吴外传》：“夫越王为人，长颈鸟喙，鹰视狼步，可以共患难，而不可共处乐，可与履危，不可与安。”\n			', '\n暂无\n			'),
(3553, '0:4:16', '鹰视狼顾', '\n【 yīng　shì　láng　gù 】\n			', '\n形容目光锐利，为人狠戾。\n			', '\n明·罗贯中《三国演义》第九十一回：“司马懿鹰视狼顾，不可付以兵权；久必为国家大祸。”\n			', '\n袁世凯～，久蓄逆谋，故景月汀谓其为仲达第二。\n			'),
(3554, '0:4:16', '鹰睃狼顾', '\n【 yīng　suō　láng　gù 】\n			', '\n形容目光锐利，为人狠戾。同“鹰视狼顾”。\n			', '\n《天雨花》第二一回：“鹰睃狼顾为非善，柳黛蛾眉杀气横。”\n			', '\n暂无\n			'),
(3555, '0:4:16', '鹰头雀脑', '\n【 yīng　tóu　què　nǎo 】\n			', '\n形容相貌丑陋而神情狡猾。\n			', '\n元·杨暹《西游记》第四本第十三出：“见一人光纱帽，黑布衫，鹰头雀脑将身探。”\n			', '\n暂无\n			'),
(3556, '0:4:16', '鹰心雁爪', '\n【 yīng　xīn　yàn　zhǎo 】\n			', '\n比喻心灵手快。\n			', '\n元·李文蔚《燕青博鱼》第四折：“你待要使用金银，打通关节，救拔囚牢，则俺燕青呵！须不是鹰心雁爪，早跳出虎穴狼巢。”\n			', '\n暂无\n			'),
(3557, '0:4:16', '鹰扬虎视', '\n【 yīng　yáng　hǔ　shì 】\n			', '\n象鹰那样飞翔，如虎一般雄视。形容十分威武。\n			', '\n《诗经·大雅·大明》：“维师尚父，时维鹰扬。”《周易·颐》：“虎视耽耽，其欲逐逐。”三国魏·应璩《与侍郎曹长思书》：“王肃以宿德显授，何曾以后进见拔，皆鹰扬虎视，有万里之望。”\n			', '\n暂无\n			'),
(3558, '0:4:16', '鹰扬虎噬', '\n【 yīng　yáng　hǔ　shì 】\n			', '\n如鹰飞扬，似虎噬咬。形容耀武扬威，穷凶极恶。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3559, '0:4:16', '养鹰飏去', '\n【 yǎng　yīng　zǒu　qù 】\n			', '\n比喻怀有野心的人不易控制，当其得意之时就不再为主人所用。\n			', '\n语出《后汉书·吕布传》：“譬如养鹰，饥即为用，饱则飏去。”\n			', '\n暂无\n			'),
(3560, '0:4:16', '鹰挚狼食', '\n【 yīng　zhì　láng　shí 】\n			', '\n比喻凶狠地攫取和吞没。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3561, '0:4:16', '鹰嘴鹞目', '\n【 yīng　zuǐ　yào　mù 】\n			', '\n形容外貌奸诈凶狠。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3562, '0:4:17', '蝶粉蜂黄', '\n【 dié　fěn　fēng　huáng 】\n			', '\n指古代妇女粉面额黄，妆扮美容。\n			', '\n唐·李商隐《酬崔八早梅有赠兼示之作》：“何处拂胸资蝶粉，几时涂额藉蜂黄。”\n			', '\n～拌付与，浅颦深笑总难知，教人何处忏情痴。（清·徐钇《词苑丛谈·叶元礼〈浣溪沙〉》）\n			'),
(3563, '0:4:17', '蝶恋蜂狂', '\n【 dié　liàn　fēng　kuáng 】\n			', '\n指留恋繁花似锦的春光。\n			', '\n明·张凤翼《灌园记·太史赏花》：“知否，算蝶恋蜂狂，少不得为韶光一逗溜。”\n			', '\n暂无\n			'),
(3564, '0:4:17', '蜂出泉流', '\n【 fēng　chū　quán　liú 】\n			', '\n像群蜂倾巢，如泉水涌流。形容一时并作。\n			', '\n清·龚自珍《古史勾沉论二》：“孔子殁，七十子不见用，衰世著书之徒，蜂出泉流。”\n			', '\n暂无\n			'),
(3565, '0:4:17', '蜂虿有毒', '\n【 fēng　chài　yǒu　dú 】\n			', '\n虿：蝎子一类的毒虫。比喻有些人物，地位虽低，但能害人，不可轻视。\n			', '\n《左传·僖公二十二年》：“君其无谓邾小，蜂虿有毒，而况国乎？”\n			', '\n雯青到此真有些耐不得了，待要发作，又怕～，惹出祸来，只好纳着头，生生的咽了下来。（清·曾朴《孽海花》第二十四回）\n			'),
(3566, '0:4:17', '蜂攒蚁集', '\n【 fēng　cuán　yǐ　jí 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n明·冯梦龙《醒世恒言》第十八卷 ：“四方商贾来收买的，蜂攒蚁集，挨挤不开。”\n			', '\n暂无\n			'),
(3567, '0:4:17', '蜂攒蚁聚', '\n【 fēng　cuán　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n明·冯梦龙《东周列国志》第三十三回：“那跟随楚王人众，何止千人，一个个俱脱衣露甲，手执暗器，如蜂攒蚁聚，飞奔上坛。”\n			', '\n一到大街，～，身不由己。琬儿母女，各各惊慌。\n			'),
(3568, '0:4:17', '蜂虿作于怀袖', '\n【 fēng　chài　zuò　yú　huái　xiù 】\n			', '\n比喻出乎意外的惊吓。\n			', '\n《晋书·刘毅传》：“蜂虿作于怀袖，勇夫为之惊骇，出于意外故也。”\n			', '\n暂无\n			'),
(3569, '0:4:17', '蜂附云集', '\n【 fēng　fù　yún　jí 】\n			', '\n比喻人众从各处聚集。\n			', '\n明·归有光《昆山县倭寇始末书》：“夜则桅灯如列星，旦则吹螺举号，蜂附云集。”\n			', '\n暂无\n			'),
(3570, '0:4:17', '蜂房蚁穴', '\n【 fēng　fáng　yǐ　xué 】\n			', '\n比喻各自占据一方。\n			', '\n明·杨慎《丹铅续录·春秋·隐公元年》：“自共和以来，诸侯如蜂房蚁穴，不用天子之元年矣。”\n			', '\n暂无\n			'),
(3571, '0:4:17', '蜂合豕突', '\n【 fēng　hé　shǐ　tū 】\n			', '\n如群蜂聚集，似野猪奔突。比喻众人杂沓会合，横冲直撞。\n			', '\n明·刘基《春秋明经·公会齐侯楚人败徐于娄林》：“今不然矣，中国之虚实在楚人目中矣！于是荆户乘广之旅，蜂合豕突以败徐于娄林。”\n			', '\n暂无\n			'),
(3572, '0:4:17', '蜂合蚁聚', '\n【 fēng　hé　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n前蜀·杜光庭《中和周天醮词》：“蠢彼不庭，敢违天道……欲恃其蜂合蚁聚之势，仗锄耰白挺之徒，垂二十年不宾睿化。”\n			', '\n暂无\n			'),
(3573, '0:4:17', '蜂狂蝶乱', '\n【 fēng　kuáng　dié　luàn 】\n			', '\n旧指男女间行为放荡。\n			', '\n明·王玉峰《焚香记·允谐》：“那淫奔坞，多少蜂狂蝶乱，毕竟傍谁虚度。”\n			', '\n暂无\n			'),
(3574, '0:4:17', '蜂窠蚁穴', '\n【 fēng　kē　yǐ　xué 】\n			', '\n比喻占据的地方极为窄小，借以对偏安一隅的地方势力的蔑称。\n			', '\n宋·曾慥《类说·见闻录·胡讷》：“开宝八年，王师围金陵。朝廷殿试《桥梁渡长江赋》、《习水战诗》；江南亦试《王德惟亲赋》、《谈笑却秦诗》。太祖笑曰：‘江南畜文臣武将，迨同飞走，岂不知中原有真主耶？’赵普曰：‘蜂窠蚁穴不足挂圣虑。’”\n			', '\n暂无\n			'),
(3575, '0:4:17', '蜂目豺声', '\n【 fēng　mù　chái　shēng 】\n			', '\n眼睛象蜂，声音象豺。形容坏人的面貌声音。\n			', '\n《左传·文公元年》：“蜂目而豺声，忍人也。”\n			', '\n暂无\n			'),
(3576, '0:4:17', '蜂迷蝶猜', '\n【 fēng　mí　dié　cāi 】\n			', '\n比喻男子对女子的思慕。\n			', '\n明·高明《琵琶记·丞相教女》：“绛罗深护奇葩小，不许蜂迷蝶猜。”\n			', '\n暂无\n			'),
(3577, '0:4:17', '蜂迷蝶恋', '\n【 fēng　mí　dié　liàn 】\n			', '\n旧指男女间行为放荡。同“蜂狂蝶乱”。\n			', '\n《白雪遗音·岭儿调·草桥惊梦》：“说不尽梦儿里半推半就，蜂迷蝶恋花心动。”\n			', '\n暂无\n			'),
(3578, '0:4:17', '蜂媒蝶使', '\n【 fēng　méi　dié　shǐ 】\n			', '\n花间飞舞的蜂蝶。比喻为男女双方居间撮合或传递书信的人。\n			', '\n宋·周邦彦《六丑·蔷薇谢后作》词：“多情为谁追惜？但蜂媒蝶使，时叩窗槅。”元·吴昌龄《张天师》第三折：“偏是你瘦影疏枝，不受那蜂媒蝶使。”\n			', '\n也不用～，更何须燕侣莺俦，硬撞八凤窟鸾穴，只消我移宫换羽，便是我捎关打节。\n			'),
(3579, '0:4:17', '蜂趋蚁附', '\n【 fēng　qū　yǐ　fù 】\n			', '\n比喻很多人迎合投靠。\n			', '\n《三元里人民抗英斗争史料·联升社学和钟镛社学》：“果然蜂趋蚁附，攘攘熙熙，诚不出神灵所料者矣。”\n			', '\n暂无\n			'),
(3580, '0:4:17', '蜂起云涌', '\n【 fēng　qǐ　yún　yǒng 】\n			', '\n比喻许多事物相继兴起，声势很大。\n			', '\n鲁迅《二心集·我们要批评家》：“然而，大部分是因为市场的需要，社会科学的译著又蜂起云涌了。”\n			', '\n暂无\n			'),
(3581, '0:4:17', '蜂识莺猜', '\n【 fēng　shí　yīng　cāi 】\n			', '\n比喻男子对女子的思慕。同“蜂迷蝶猜”。\n			', '\n元本·高明《琵琶记·牛相教女》：“绛罗深护奇葩小，不许蜂识莺猜。”\n			', '\n暂无\n			'),
(3582, '0:4:17', '蜂扇蚁聚', '\n【 fēng　shān　yǐ　jù 】\n			', '\n蜂翅扇动，蚂蚁聚合。比喻人虽众多但起不了大作用。\n			', '\n《隋书·房彦谦传》：“况乎蕞尔一隅，蜂扇蚁聚，杨谅之愚鄙，群小之凶慝，而欲凭陵畿甸，觊幸非望者哉！”\n			', '\n暂无\n			');
INSERT INTO `chengyu_list` (`id`, `type`, `title`, `title_1`, `explain`, `made`, `examples`) VALUES 
(3583, '0:4:17', '蜂屯乌合', '\n【 fēng　tún　wū　hé 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n宋·王禹偁《贺圣驾还京表》：“蕞尔林胡，无名内侮，蜂屯乌合，鼠窃狗偷；必想边民夺挺以殴攘，亭长持绳而絷缚。”\n			', '\n暂无\n			'),
(3584, '0:4:17', '蜂屯蚁附', '\n【 fēng　tún　yǐ　fù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n宋·李纲《上道君太上皇帝札子》：“犬戎之众，蜂屯蚁附，渡壕临城，梯长如云，箭落如雨。”\n			', '\n暂无\n			'),
(3585, '0:4:17', '蜂屯蚁聚', '\n【 fēng　tún　yǐ　jù 】\n			', '\n形容成群的人聚集在一处。\n			', '\n唐·韩愈《送郑尚书序》：“蜂屯蚁杂，不可爬梳。”\n			', '\n这里雯青直到日落西山，才把那些～的亲朋支使出了门，坐了一肩小轿，向三茅阁巷褚爱林家而来。（清·曾朴《孽海花》第三回）\n			'),
(3586, '0:4:17', '蜂屯蚁杂', '\n【 fēng　tún　yǐ　zá 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n唐·韩愈《送郑尚书序》：“撞搪呼号以相和应；蜂屯蚁杂，不可爬梳。”\n			', '\n暂无\n			'),
(3587, '0:4:17', '蜂拥而来', '\n【 fēng　yōng　ér　lái 】\n			', '\n象蜂群似的拥挤着过来。形容许多人一起过来。\n			', '\n《史记·项羽本纪》：“陈涉首难，豪杰蜂起。”\n			', '\n又等了一会子，方见胡统领打着灯笼火把，一路～。（清·李宝嘉《官场现形记》第十二回）\n			'),
(3588, '0:4:17', '蜂拥而上', '\n【 fēng　yōng　ér　shàng 】\n			', '\n形容许多人一起涌上来。\n			', '\n清·曹雪芹《红楼梦》第九回：“墨雨遂掇起一根门闩，扫红、锄药手中都是马鞭子，蜂拥而上。”\n			', '\n暂无\n			'),
(3589, '0:4:17', '蜂拥而至', '\n【 fēng　yōng　ér　zhì 】\n			', '\n像一窝蜂似地一拥而来。形容很多人乱哄哄地朝一个地方聚拢。\n			', '\n清·李汝珍《镜花缘》第二十六回：“徐承志等他去远，刚要回船，前面尘头滚滚，喊声渐近，又来许多草寇。个个头戴浩然巾，手机器械，蜂拥而至。”\n			', '\n该处七哨匪徒，不下数十万人，每聚众时，用牛角一吹，无不～。\n			'),
(3590, '0:4:17', '蜂腰削背', '\n【 fēng　yāo　xuē　bèi 】\n			', '\n细腰窄背。形容轻盈俊俏。同“蜂腰猿背”。\n			', '\n清·曹雪芹《红楼梦》第四十六回：“蜂腰削背，鸭蛋脸，乌油头发，高高的鼻子，两边腮上微微的几点雀瘢。”\n			', '\n暂无\n			'),
(3591, '0:4:17', '蜂腰猿背', '\n【 fēng　yāo　yuán　bèi 】\n			', '\n细腰窄背。形容轻盈俊俏。\n			', '\n清·曹雪芹《红楼梦》第四十九回：“腰里紧紧束着一条蝴蝶结子长穗五色宫绦，脚下也穿着鹿皮小靴：越显得蜂腰猿背，鹤势螂形。”\n			', '\n暂无\n			'),
(3592, '0:4:17', '蜂营蚁队', '\n【 fēng　yíng　yǐ　duì 】\n			', '\n比喻乌合之众。\n			', '\n明·宋濂《次刘经历韵诗》：“一朝闽寇掠乡部，蜂营蚁队来无涯。”\n			', '\n暂无\n			'),
(3593, '0:4:17', '蜂拥蚁聚', '\n【 fēng　yōng　yǐ　jù 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n罗振常《史可法别传》：“城下死者山积，攻者反藉叠尸以登，蜂拥蚁聚，城遂陷。”\n			', '\n暂无\n			'),
(3594, '0:4:17', '蜂拥蚁屯', '\n【 fēng　yōng　yǐ　tún 】\n			', '\n形容人群蜂蚁般杂乱地聚集在一起。同“蜂屯蚁聚”。\n			', '\n清·昭梿《啸亭杂录·缅甸归诚本末》：“帆樯衔接，倏然蜂拥蚁屯者数千人。”\n			', '\n暂无\n			'),
(3595, '0:4:17', '鹤膝蜂腰', '\n【 hè　xī　fēng　yāo 】\n			', '\n①这是指诗歌声律八病的两种。泛指诗歌声律上所犯的毛病。②书法中的两种病笔。\n			', '\n宋·魏庆之《诗人玉屑·诗病·诗病有八》：“三曰蜂腰，第二字不得与第五字同声……四曰鹤膝，第五字不得与第十五字同声。”\n			', '\n近来诗思殊无況，苦被时流不相放。云腾浪走势未衰，～岂能障。\n			'),
(3596, '0:4:17', '稷蜂社鼠', '\n【 jì　fēng　shè　shǔ 】\n			', '\n谷神庙里的马蜂，土地庙里的老鼠。比喻倚势作恶手的人。\n			', '\n《韩诗外传》卷八：“稷蜂不攻而社鼠不熏，非以稷蜂社鼠之神，其所托者善。”\n			', '\n暂无\n			'),
(3597, '0:4:17', '狂蜂浪蝶', '\n【 kuáng　fēng　làng　dié 】\n			', '\n比喻轻薄放荡的男子。\n			', '\n明·凌濛初《初刻拍案惊奇》第11卷：“紫燕黄莺，绿柳丛中寻对偶；狂蜂浪蝶，夭桃队里觅相知。”\n			', '\n暂无\n			'),
(3598, '0:4:17', '浪蝶狂蜂', '\n【 làng　dié　kuáng　fēng 】\n			', '\n轻狂的蜂蝶。比喻轻狂的男子。\n			', '\n元·高明《琵琶记·牛小姐规劝侍俾》：“惊起娇莺语燕，打开浪蝶狂蜂。”\n			', '\n暂无\n			'),
(3599, '0:4:17', '浪蝶游蜂', '\n【 làng　dié　yóu　fēng 】\n			', '\n比喻态度轻佻好挑逗女子的男子。\n			', '\n明·高濂《玉簪记·姑阻》：“我若做浪蝶游蜂，老天呵，须教是裾马襟牛。”\n			', '\n暂无\n			'),
(3600, '0:4:17', '撩蜂吃螫', '\n【 liáo　fēng　chī　shì 】\n			', '\n犹言撩蜂剔蝎。比喻惹犯恶人，自取祸殃。\n			', '\n清·西周生《醒世姻缘传》第十一回：“那晁住娘子是刘六、刘七裹革出来的婆娘，他肯去撩蜂吃螫？说道：‘你不好问去？只是指使我！’”??\n			', '\n暂无\n			'),
(3601, '0:4:17', '撩蜂剔蝎', '\n【 liáo　fēng　tì　xiē 】\n			', '\n比喻招惹恶人，自讨苦吃。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3602, '0:4:17', '狼猛蜂毒', '\n【 láng　měng　fēng　dú 】\n			', '\n形容人凶狠毒辣。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3603, '0:4:17', '鼠窜蜂逝', '\n【 shǔ　cuàn　fēng　shì 】\n			', '\n形容纷纷跑散。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3604, '0:4:17', '蛇口蜂针', '\n【 shé　kǒu　fēng　zhēn 】\n			', '\n比喻恶毒的言词和手段。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3605, '0:4:17', '剔蝎撩蜂', '\n【 tī　xiē　liáo　fēng 】\n			', '\n比喻惹事生非。\n			', '\n元·纪君祥《赵氏孤儿》第二折：“偏你这罢职归田一老农，公然敢剔蝎撩蜂。”元·无名氏《小尉迟》第一折：“常是个争龙斗虎，剔蝎撩蜂。”\n			', '\n暂无\n			'),
(3606, '0:4:17', '戏蝶游蜂', '\n【 xì　dié　yóu　fēng 】\n			', '\n飞舞游戏的蝴蝶和蜜蜂。后用以比喻浪荡子弟。\n			', '\n唐·岑参《山房春事二首》：“风恬日暖荡春光，戏蝶游蜂乱人房。”\n			', '\n暂无\n			'),
(3607, '0:4:17', '蚁附蜂屯', '\n【 yǐ　fù　fēng　tún 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n严复《原强》：“一旦有急，则蚁附蜂屯，授之以扞格不操之利器，曳兵而走，转以奉敌。”\n			', '\n暂无\n			'),
(3608, '0:4:17', '游蜂浪蝶', '\n【 yóu　fēng　làng　dié 】\n			', '\n比喻态度轻佻好挑逗女子的人。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3609, '0:4:17', '游蜂戏蝶', '\n【 yóu　fēng　xì　dié 】\n			', '\n飞舞游戏的蝴蝶和蜜蜂。后用以比喻浪荡子弟。\n			', '\n唐·岑参《山房春事二首》：“风恬日暖荡春光，戏蝶游蜂乱人房。”\n			', '\n～空自忙，岂知美人在西厢。\n			'),
(3610, '0:4:17', '蚁集蜂攒', '\n【 yǐ　jí　fēng　cuán 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n明·宋濓《赠行军镇抚迈里古思平寇诗序》：“栝寇复兴，蚁集蜂攒，众号数万，遂陷婺之永康。”\n			', '\n暂无\n			'),
(3611, '0:4:17', '蚁聚蜂攒', '\n【 yǐ　jù　fēng　cuán 】\n			', '\n像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n南朝·齐·孔稚珪《上和虏表》：“蚁聚蜂攒，穷诛不尽。马足毛群，难与竞逐。”\n			', '\n暂无\n			'),
(3612, '0:4:17', '蚁聚蜂屯', '\n【 yǐ　jù　fēng　tún 】\n			', '\n屯：聚集。像蚂蚁、螽斯一般集聚。比喻集结者之众多。\n			', '\n清·吴伟业《雁门尚书行》：“蚁聚蜂屯已入城，持矛瞋目呼狂贼。”\n			', '\n夫自东汉以迄于明，其间学士词人，～，不可计数。\n			'),
(3613, '0:4:17', '一窝蜂', '\n【 yī　wō　fēng 】\n			', '\n一个蜂巢里的蜂一下子都飞出来了。形容许多人乱哄哄地同时说话或行动。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3614, '0:4:17', '蚁拥蜂攒', '\n【 yǐ　yōng　fēng　cuán 】\n			', '\n比喻集结者众多。同“蚁萃螽集”。\n			', '\n《三元里人民抗英斗争史料·广东军务记》：“乡民蚁拥蜂攒，布满山麓，约有十余万众。”\n			', '\n暂无\n			'),
(3615, '0:4:17', '招蜂惹蝶', '\n【 zhāo　fēng　rě　dié 】\n			', '\n犹招蜂引蝶。\n			', '\n《花城》1981年第3期：“她漂亮，美……在那穷乡僻壤之中，又焉能不招蜂惹蝶？”\n			', '\n暂无\n			'),
(3616, '0:4:17', '招蜂引蝶', '\n【 zhāo　fēng　yǐn　dié 】\n			', '\n招致蜜蜂，吸引蝴蝶。比喻吸引别人的注意。\n			', '\n叶文玲《独特的歌》：“没准是很爱卖弄俊俏，四送秋波的人呢，嘿，招蜂引蝶之流，对不起，本人向来深恶痛绝。”\n			', '\n暂无\n			'),
(3617, '0:5:0', '百不为多，一不为少', '\n【 bǎi　bù　wéi　duō，yī　bù　wéi　shǎo 】\n			', '\n指难得的好人或好东西。\n			', '\n《南史·任昉传》：“褚彦回尝谓遥曰：‘闻卿有令子，相为喜之。所谓百不为多，一不为少。’由是闻声藉甚。”\n			', '\n然不难得则不足为佳物，古人亦云‘～’者，谓此也。\n			'),
(3618, '0:5:0', '百不一贷', '\n【 bǎi　bù　yī　dài 】\n			', '\n犹言无一宽免。\n			', '\n《新唐书·酷吏传·来俊臣》：“后信之，诏于丽景门别置狱，敕俊臣等颛按事，百不一贷。”\n			', '\n暂无\n			'),
(3619, '0:5:0', '百不一遇', '\n【 bǎi　bù　yī　yù 】\n			', '\n一百次中遇不到一次。形容极其难得。\n			', '\n汉·荀悦《汉纪·哀帝纪下》：“言立策成，终无咎悔，若此之事，百不一遇，其知之所见，万不及一也。”\n			', '\n暂无\n			'),
(3620, '0:5:0', '百动不如一静', '\n【 bǎi　dòng　bù　rú　yī　jìng 】\n			', '\n指多动不如静待有效。\n			', '\n清·西周生《醒世姻缘传》第三十四回：“你去了，我又寻思，百动不如一静的。”\n			', '\n暂无\n			'),
(3621, '0:5:0', '百喙如一', '\n【 bǎi　huì　rú　yī 】\n			', '\n犹言众口一辞。许多人都说同样的话，看法或意见一致。\n			', '\n清·王夫之《孝烈传》：“唯习闻湘人之言，百喙如一者若此。”\n			', '\n暂无\n			'),
(3622, '0:5:0', '百喙一词', '\n【 bǎi　huì　yī　cí 】\n			', '\n犹言众口一辞。同“百喙如一”。\n			', '\n清·龚自珍《大誓答问第一》：“儒者百喙一词，言伏生《尚书》二十八篇。”\n			', '\n暂无\n			'),
(3623, '0:5:0', '百虑一致', '\n【 bǎi　lǜ　yī　zhì 】\n			', '\n指使各种不同的思想归于一致。\n			', '\n语出《易·系辞下》：“天下何思何虑，天下同归而殊涂，一致而百虑。”\n			', '\n及躬总大政，一日万机，十许年间，曾不暇给，殊涂同归，～。\n			'),
(3624, '0:5:0', '百密一疏', '\n【 bǎi　mì　yī　shū 】\n			', '\n在极周密的考虑中偶然出现了一点疏忽。\n			', '\n清·魏源《庸易通义》：“至道问学之有知无行，分温故为存心，知新为致知，而敦厚为存心，崇礼为致知，此皆百密一疏。”\n			', '\n深知杜竹斋为人的吴荪甫此时却～，竟没有看透竹斋的心曲。他一而再，再而三的，用鼓励，用反激。\n			'),
(3625, '0:5:0', '百密一疏', '\n【 bǎi　mì　yī　shū 】\n			', '\n在极周密的考虑中偶然出现了一点疏忽。\n			', '\n清·魏源《庸易通义》：“至道问学之有知无行，分温故为存心，知新为致知，而敦厚为存心，崇礼为致知，此皆百密一疏。”\n			', '\n深知杜竹斋为人的吴荪甫此时却～，竟没有看透竹斋的心曲。他一而再，再而三的，用鼓励，用反激。\n			'),
(3626, '0:5:0', '白首一节', '\n【 bái　shǒu　yī　jié 】\n			', '\n指年虽老而志节不衰。\n			', '\n《后汉书·吴良传》：“窃见臣府西曹掾齐国吴良资质敦固，公方廉恪，躬俭安贫，白首一节。”\n			', '\n暂无\n			'),
(3627, '0:5:0', '百世一人', '\n【 bǎi　shì　yī　rén 】\n			', '\n指极难得的人才。\n			', '\n宋·苏轼《祭司马君实文》：“百世一人，千载一时，惟时与人，鲜偶常奇。”\n			', '\n暂无\n			'),
(3628, '0:5:0', '百死一生', '\n【 bǎi　sǐ　yī　shēng 】\n			', '\n形容生命极其危险，处于死亡的边缘。\n			', '\n《北齐书·杜弼传》：“诸勋人身触锋刃，百死一生，纵其贪鄙，所取处大，不可同之循常例也。”\n			', '\n地无医巫，药石万里，病者有～之虑。\n			'),
(3629, '0:5:0', '百无一堪', '\n【 bǎi　wú　yī　kān 】\n			', '\n指百人中无一人能胜任。\n			', '\n《旧唐书·郭子仪传》：“盖以六军之兵，素非精练，皆市肆屠沽之人，务挂虚名，苟避征赋，及驱以就战，百无一堪。”\n			', '\n暂无\n			'),
(3630, '0:5:0', '冰心一片', '\n【 bīng　xīn　yī　piàn 】\n			', '\n冰心：清洁的心。形容性情淡泊，不求名利。\n			', '\n唐·王昌龄《芙蓉楼送辛渐》诗：“洛阳亲友如相问，一片冰心在玉壶。”\n			', '\n钓鱼钓晴还钓雪，～已忘机。\n			'),
(3631, '0:5:0', '参差不一', '\n【 cēn　cī　bù　yī 】\n			', '\n形容不整齐或不一致。同“参差不齐”。\n			', '\n《南齐书·礼志上》：“至于嗣位之君，参差不一，宜有定制。”《隋书·后妃传》：“周公定礼，内职始备列焉。秦、汉以下，代有沿革，品秩差次，前史载之详矣。齐、梁以降，历魏暨周，废置益损，参差不一。”\n			', '\n月梅便把一叠钞票交给紫旒，紫旒接过来一点，只见汇丰的、麦加利的、十元的、五元的、一元的，乱七八糟，～。\n			'),
(3632, '0:5:0', '存十一于千百', '\n【 cún　shí　yī　yú　qiān　bǎi 】\n			', '\n指亡多而存少。\n			', '\n语出晋·陆机《叹逝赋》：“顾旧要于遗存，得十一于千百。”\n			', '\n而今学者尚知宗孔氏、崇仁义、贵王贱霸而已，其大经大法皆亡灭而不救、坏烂而不收，所谓～，安在其能廓如也！\n			'),
(3633, '0:5:0', '纯一不杂', '\n【 chún　yī　bù　zá 】\n			', '\n纯：纯粹；一：单一；杂：驳杂，不纯洁。形容纯粹、单一，没有杂质。\n			', '\n鲁迅《“题未定”草》：“东林党也有小人，古今来无纯一不杂的君子群。”\n			', '\n暂无\n			'),
(3634, '0:5:0', '此一时彼一时', '\n【 cǐ　yī　shí　bǐ　yī　shí 】\n			', '\n指时间不同，情况亦异，不能相提并论。\n			', '\n语出《孟子·公孙丑下》：“彼一时，此一时也。五百年必有王者兴，其间必有名世者”。\n			', '\n那不是～，吗……谁又真心去捧老校长呢！\n			'),
(3635, '0:5:0', '重足一迹', '\n【 chóng　zú　yī　jì 】\n			', '\n叠足而立，不敢迈步。形容非常恐惧。\n			', '\n《汉书·佞幸传·石显》：“自是公聊以下畏显，重足一迹。”颜师古注：“言极恐惧，不敢自宽纵。”\n			', '\n［李沼］未几，按甲来觐，讽天子诛大臣，缙绅间～。\n			'),
(3636, '0:5:0', '多一事不如省一事', '\n【 duō　yī　shì　bù　rú　shěng　yī　shì 】\n			', '\n指不管闲事，事情越少越好。同“多一事不如少一事”。\n			', '\n《红楼梦》第四五回：“你说的也是，多一事不如省一事。”\n			', '\n暂无\n			'),
(3637, '0:5:0', '佛高一尺，魔高一丈', '\n【 fó　gāo　yī　chǐ　，mó　gāo　yī　zhàng 】\n			', '\n原为佛家告诫修行者，要警惕外界诱惑。佛，指佛法；魔，指魔法。后用以比喻一方势力（多指正义的）增长，与之对立的另一方势力（多指非正义的）则加倍增长。\n			', '\n明·李贽《与梅衡湘书》：“‘佛高一尺，魔高一丈。’昔人此言，只要人知有佛即有魔，如形之有影，声之有响，必然不相离者。”\n			', '\n暂无\n			'),
(3638, '0:5:0', '发昏章第十一', '\n【 fā　hūn　zhāng　dì　shí　yī 】\n			', '\n昏头昏脑的风趣话。仿《孝经》“某某章第几”的说法。\n			', '\n明·施耐庵《水浒传》第二十六回：“只见头在下，脚在上，倒撞落在当街心里去了，跌得个‘发昏章第十一’！”\n			', '\n暂无\n			'),
(3639, '0:5:0', '付诸一炬', '\n【 fù　zhū　yī　jù 】\n			', '\n炬：火把。一把火全部烧了。同“付之一炬”。\n			', '\n清·李宝嘉《文明小史》第四十六回：“在这许多名片里面，捡出一张，上写着颜轶回，……其余都付诸一炬。”\n			', '\n暂无\n			'),
(3640, '0:5:0', '付诸一笑', '\n【 fù　zhū　yī　xiào 】\n			', '\n用一笑来对待或回答。比喻不值得理会。同“付之一笑”。\n			', '\n清·韩邦庆《海上花列传》第六回：“仲英乃恍然大悟，付诸一笑，就在高椅上坐下，问雪香道：‘耐意思要我成日成夜陪仔耐坐来里，勿许到别场花去，阿是嗄？’”\n			', '\n把一切诞罔不经之事，～，那就不负我今日一番饶舌了。\n			'),
(3641, '0:5:0', '竿头一步', '\n【 gān　tóu　yī　bù 】\n			', '\n比喻更进一步。\n			', '\n梁启超《南海康先生传》：“勇猛精进，竿头一步。”\n			', '\n暂无\n			'),
(3642, '0:5:0', '画一之法', '\n【 huà　yī　zhī　fǎ 】\n			', '\n指全体遵行、无一例外的法令政策。\n			', '\n《后汉书·王充王符等传论》：“太叔致猛政之褒，国子流遗爱之娣，宣孟改冬日之和，平阳循画一之法。”\n			', '\n苟且之令行，～废，月增日长，雄唱雌和。\n			'),
(3643, '0:5:0', '慌作一团', '\n【 huāng　zuò　yī　tuán 】\n			', '\n形容极为慌张。\n			', '\n清·李宝嘉《官场现形记》第五十五回：“萧长贵正在自己兵船上睡觉，忽听得外面一派人声，接着又有洋枪、洋炮声音，拿他从睡梦中惊醒，直把他吓得索索的抖，在被窝里慌作一团。”\n			', '\n暂无\n			'),
(3644, '0:5:0', '慌做一团', '\n【 huāng　zuò　yī　tuán 】\n			', '\n形容极为慌张。同“慌作一团”。\n			', '\n清·西周生《醒世姻缘传》第十六回：“晁夫人知道儿子当真做了这事，又见他病将起来，只怕是报应得恁快，慌做一团，要与晁老说知，赔那两个的衣物。”\n			', '\n暂无\n			'),
(3645, '0:5:0', '旷古一人', '\n【 kuàng　gǔ　yī　rén 】\n			', '\n旷古：空前；从古到今。自古以来只此一人。形容绝无仅有。\n			', '\n五代·王定保《唐摭言·以其人不称才试而后惊》：“北面而师之者，可谓旷古一人而已！”\n			', '\n暂无\n			'),
(3646, '0:5:0', '略窥一斑', '\n【 lüè　kuī　yī　bān 】\n			', '\n比喻大致看到一些情况，但不够全面。同“略见一斑”。\n			', '\n明·张居正《答南列卿陈我度》：“孤虽不肖，其于人之贤否，略窥一斑，内不敢任爱憎之私，外不轻信誉之说。”\n			', '\n暂无\n			'),
(3647, '0:5:0', '良莠不一', '\n【 liáng　yǒu　bù　yī 】\n			', '\n莠：狗尾草，很象谷子，常混在禾苗中。比喻好人坏人都有，混杂在一起。难以区分。同“良莠不齐”。\n			', '\n《清史稿·觉罗满保传》：“闽、浙两省棚民，以种麻靛、造纸、烧灰为业，良莠不一。”\n			', '\n你对那巡长说，难民们～，要是发生了什么事，他这巡长担当得起吗？\n			'),
(3648, '0:5:0', '罗之一目', '\n【 luó　zhī　yī　mù 】\n			', '\n网之一孔。比喻局部在整体中才能起其作用；脱离了整体，局部便不起作用。\n			', '\n《淮南子·说山训》：“有鸟将来，张罗而待之，得鸟者罗之一目也。今非昔比为一目之罗，则无时得鸟矣。”\n			', '\n一目之罗，不能得鸟，得鸟者～耳。\n			'),
(3649, '0:5:0', '莫展一筹', '\n【 mò　zhǎn　yī　chóu 】\n			', '\n一点计策也施展不出，一点办法也想不出来。同“一筹莫展”。\n			', '\n明·张居正《与王鉴川计四事四要书》：“本兵错愕惶惑，莫展一筹。”\n			', '\n勒保经略半载，～。\n			'),
(3650, '0:5:0', '片言一字', '\n【 piàn　yán　yī　zì 】\n			', '\n犹片言只字。少量的文字。\n			', '\n唐·李邕《兖州曲阜县孔子庙碑》：“片言一字，劝善惩恶，诱进后人，启明先觉。”\n			', '\n暂无\n			'),
(3651, '0:5:0', '千锤打锣，一锤定音', '\n【 qiān　chuí　dǎ　luó，yī　chuí　dìng　yīn 】\n			', '\n比喻在众说纷纭的情况下发表决定性的意见。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3652, '0:5:0', '千棰打锣，一棰定声', '\n【 qiān　chuí　dǎ　luó，yī　chuí　dìng　shēng 】\n			', '\n比喻在众说纷纭的情况下发表决定性的意见。同“千锤打锣，一锤定音”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3653, '0:5:0', '千夫诺诺，不如一士谔谔', '\n【 qiān　fū　nuò　nuò，bù　rú　yī　shì　è　 】\n			', '\n指众多唯唯诺诺之人，不如一名诤谏之士可贵。同“千人诺诺，不如一士谔谔”。\n			', '\n宋·苏轼《讲田友直字序》：“韩城田益，字迁之。黄庭坚以谓不足以配名，更之曰友直……何独取诸此？某曰：夫直者，刚者之长也。千夫诺诺，不如一士之谔谔。”\n			', '\n暂无\n			'),
(3654, '0:5:0', '千军易得，一将难求', '\n【 qiān　jūn　yì　dé，yī　jiàng　nán　qiú 】\n			', '\n指将才难得。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3655, '0:5:0', '千金之裘，非一狐之腋', '\n【 qiān　jīn　zhī　qiú，fēi　yī　hú　zhī　yè 】\n			', '\n价值千金的皮衣，决非一只狐狸的腋皮所能做成。比喻积小才能成大，集合大家的力量才能做成事情。\n			', '\n《史记·刘敬叔孙通列传》：“太史公曰：语曰‘千金之裘，非一狐之腋也；台榭之榱，非一木之枝也；三代之际，非一代之智也。’”\n			', '\n～；绮罗之辈，非养蚕之人。\n			'),
(3656, '0:5:0', '千日打柴一日烧', '\n【 qiān　rì　dǎ　chái　yī　rì　shāo 】\n			', '\n比喻持久奋斗而一旦成功。也比喻平时积攒，一朝花费。同“千日斫柴一日烧”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3657, '0:5:0', '千日斫柴一日烧', '\n【 qiān　rì　zhuó　chái　yī　rì　shāo 】\n			', '\n①比喻持久奋斗而一旦成功。②比喻平时积攒，一朝花费。亦作“千日打柴一日烧”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3658, '0:5:0', '千闻不如一见', '\n【 qiān　wén　bù　rú　yī　jiàn 】\n			', '\n指听得再多还不如亲见更为可靠。\n			', '\n《陈书·萧摩诃传》：“安都谓摩诃曰：‘卿骁勇有名，千闻不如一见。’”\n			', '\n王氏想道：“‘～。’虽说丈夫已死，在几千里之外，不知端的。”\n			'),
(3659, '0:5:0', '缺一不可', '\n【 quē　yī　bù　kě 】\n			', '\n少一样也不行。\n			', '\n明·施耐庵《水浒传》第二十回：“林冲道：‘只今番克敌制胜，便见得先生妙法。正是鼎分三足，缺一不可，先生不必推却。’”\n			', '\n每个学生都要德智体全面发展，三者～。\n			'),
(3660, '0:5:0', '清一色', '\n【 qīng　yī　sè 】\n			', '\n原指打麻将时由一种花色组成的一副牌。后比喻全部由同一种成分构成。\n			', '\n清·李宝嘉《官场现形记》第二十九回：“而且他［佘小观］赌品甚高，输得越多心越定，脸上神色丝毫不动。又欢喜做‘清一色’。所以同赌的人更拿他当财神看待。”\n			', '\n至于经常的事务，她可以放心的由职员们代办，因为职员们都～的换上了她的娘家的人。\n			'),
(3661, '0:5:0', '千羊之皮，不如一狐之腋', '\n【 qiān　yáng　zhī　pí，bù　rú　yī　hú　zhī 】\n			', '\n比喻众愚不如一贤。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3662, '0:5:0', '千载一合', '\n【 qiān　zài　yī　hé 】\n			', '\n一千年才有这么一个时机。形容机会极其难得。同“千载一时”。\n			', '\n《汉书·王襃贾传》：“上下俱欲，欢然交欣，千载一合，论说无疑。”\n			', '\n暂无\n			'),
(3663, '0:5:0', '攘臂一呼', '\n【 rǎng　bì　yī　hū 】\n			', '\n攘：挥动。挥动手臂呼喊（多用在号召）。\n			', '\n汉·李陵《答苏武书》：“然陵振臂一呼，创病皆起。”\n			', '\n皆能～，聚众千百，杀掠吏民，死且不顾，重烦大兵剪灭而后已，是岂理所当然者哉。\n			'),
(3664, '0:5:0', '让礼一寸，得礼一尺', '\n【 ràng　lǐ　yī　cùn　，dé　lǐ　yī　chǐ 】\n			', '\n比喻以礼相让，事虽微而获益必大。\n			', '\n语出《太平御览》卷四二四引三国魏曹操《礼让令》：“里谚曰：‘让礼一寸，得礼一尺。’斯合经之要矣。”\n			', '\n暂无\n			'),
(3665, '0:5:0', '送君千里，终须一别', '\n【 sòng　jūn　qiān　lǐ，zhōng　xū　yī　bié 】\n			', '\n君：敬称对方；终：终究。送多远的路，终究要分别。\n			', '\n元·无名氏《马陵道》楔子：“哥哥，送君千里，终有一别，哥哥你回去。”\n			', '\n～，我也不往下送了。\n			'),
(3666, '0:5:0', '赏一劝众', '\n【 shǎng　yī　quàn　zhòng 】\n			', '\n奖励一个人的先进事迹而鼓励好多人。\n			', '\n周·吕尚《阴谋》：“杀一以惩万，赏一而劝众，此明君之威福也。”\n			', '\n暂无\n			'),
(3667, '0:5:0', '万口一词', '\n【 wàn　kǒu　yī　cí 】\n			', '\n比喻意见一致。同“万口一辞”。\n			', '\n范文澜、蔡美彪等《中国通史》第四编第三章第一节：“现在万口一词，愿立永康王，不可更改。”\n			', '\n暂无\n			'),
(3668, '0:5:0', '万世一时', '\n【 wàn　shì　yī　shí 】\n			', '\n万世才有这么一个机会。形容机会难得。\n			', '\n《史记·吴王濞列传》：“慧星出，蝗虫数起，此万世一时，而愁劳圣人之所起也。”\n			', '\n今陛下春秋鼎盛，天锡勇智，此～也。\n			'),
(3669, '0:5:0', '梧桐一叶落', '\n【 wú　tóng　yī　yè　luò 】\n			', '\n梧桐落叶最早，故以之表示秋天来临。后亦以比喻事物衰落的征兆。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3670, '0:5:0', '相与为一', '\n【 xiāng　yǔ　wéi　yī 】\n			', '\n相与：相互。相互结合成为一体。\n			', '\n汉·贾谊《过秦论》：“诸侯恐惧，同盟而谋弱秦，不爱珍器重宝肥饶之地，以致天下之士，合从缔交，相与为一。”汉·董仲舒《春秋繁露》卷第十：“谓之性情，性情相与为一瞑，情亦性也，谓性已善，奈其情何？”\n			', '\n崔胤本留卫兵，欲以制敕使也，今敕使、卫兵～，将若之何！\n			'),
(3671, '0:5:0', '咸阳一炬', '\n【 xián　yáng　yī　jǔ 】\n			', '\n咸阳：秦朝的都城；炬：火把，引申为火焚。咸阳的一把大火。指项羽率军到咸阳后将秦宫全部烧毁。泛指一把火烧光。\n			', '\n《史记·项羽本纪》：“项羽引兵西屠咸阳，杀秦降王子婴，烧秦宫室，火三月不灭。”\n			', '\n张钟山欲借～，了此业障。\n			'),
(3672, '0:5:0', '一波才动万波随', '\n【 yī　bō　cái　dòng　wàn　bō　suí 】\n			', '\n指一波方动，万波随之而起。比喻事情开端后的不断发展变化。\n			', '\n宋·惠洪《冷斋夜话·船子和尚偶》：“千尺丝纶直下垂，一波才动万波随。”\n			', '\n奇外无奇更出奇，～。只知诗到苏黄尽，沧海横流却是谁？\n			'),
(3673, '0:5:0', '一百二十行', '\n【 yī　bǎi　èr　shí　háng 】\n			', '\n犹三百六十行。指各种行业。\n			', '\n《宣和遗事》前集：“[微宗等]无日歌欢作乐，遂于宫中内列为市肆，令其宫女卖茶卖酒及一百二十行经纪买卖皆全。”\n			', '\n我想这～，门门都好着衣吃饭，偏俺这一门却是谁人制下的?\n			'),
(3674, '0:5:0', '养兵千日，用在一朝', '\n【 yǎng　bīng　qiān　rì，yòng　zài　yī　zhāo 】\n			', '\n指长期供养、训练军队，以备一旦用兵打仗。同“养军千日，用在一朝”。\n			', '\n明·施耐庵《水浒传》第六十一回：“卢俊义听了大怒道：‘养兵千日，用在一朝！我要你跟我去走一遭，你便有许多推故。’”\n			', '\n夏十道：‘国家～。别的不要讲，这两句话是人所共知的。’\n			'),
(3675, '0:5:0', '瑜百瑕一', '\n【 yú　bǎi　xiá　yī 】\n			', '\n比喻优点多而缺点少。瑜，玉的光采；瑕，玉的毛病。\n			', '\n清·陈康祺《郎潜纪闻》卷五：“观玩全书，瑜百瑕一，津逮来学，诚为有裨。”\n			', '\n暂无\n			'),
(3676, '0:5:0', '一鞭先著', '\n【 yī　biān　xiān　zhuó 】\n			', '\n后以为争先的典实。亦泛指先行。\n			', '\n晋刘琨少负志气，与祖逖为友，共以收复中原为志，曾与亲故书曰：“吾枕戈待旦，志枭逆虏，常恐祖生先吾著鞭。”见《晋书·刘琨传》。\n			', '\n得脱穹庐似脱围，～喜公归。\n			'),
(3677, '0:5:0', '一鞭一条痕', '\n【 yī　biān　yī　tiáo　hén 】\n			', '\n比喻做事着着落实或说话切中要害。同“一棒一条痕”\n			', '\n清·吴敬梓《儒林外史》第十一回：“八股文章若做的好，随你做甚么东西，要诗就诗，要赋就赋，都是一鞭一条痕，一掴一掌血。”\n			', '\n吾兄这几句话，真是～的几句好文章！\n			'),
(3678, '0:5:0', '一尺水翻腾做百丈波', '\n【 yī　chǐ　shuǐ　fān　téng　zuò　bǎi　zhàng 】\n			', '\n比喻说话夸大之极。同“一尺水翻腾做一丈波”。\n			', '\n元·王晔《桃花女》第二折：“你将那半句话搬调做十分事，一尺水翻腾做百丈波。”\n			', '\n暂无\n			'),
(3679, '0:5:0', '一尺水翻腾做一丈波', '\n【 yī　chǐ　shuǐ　fān　téng　zuò　yī　zhàng　 】\n			', '\n比喻说话夸大之极。\n			', '\n元·无名氏《争报恩》第三折：“那妮子一尺水翻腾做一丈波，怎当他只留支剌信口开合。”\n			', '\n暂无\n			'),
(3680, '0:5:0', '一吹一唱', '\n【 yī　chuī　yī　chàng 】\n			', '\n吹：吹嘘。唱：唱和。两个人说话，互相帮衬。\n			', '\n明·冯梦龙《醒世恒言》第三十五卷：“二人一吹一唱，说得颜氏心中哑口无言，心下也生疑惑，委决不下，把一天欢喜，又变为万般愁闷。”\n			', '\n暂无\n			'),
(3681, '0:5:0', '一重一掩', '\n【 yī　chóng　yī　yǎn 】\n			', '\n指山峦重迭稠密。\n			', '\n唐·杜甫《岳麓山道林二寺行》诗：“一重一掩吾肺腑，山鸟山花吾友于。”\n			', '\n暂无\n			'),
(3682, '0:5:0', '一代不如一代', '\n【 yī　dài　bù　rú　yī　dài 】\n			', '\n代：父子相继为一代。一代比一代差。\n			', '\n宋·王君玉《国老谈苑》卷二：“陶谷以翰林学士奉使吴越，忠懿王宴之。因食蝤蛑询其名类，忠懿命自蝤蛑至蟛蜞，凡罗列十余种以进。谷视之，笑谓忠懿曰：‘此谓一代不如一代也。’”\n			', '\n暂无\n			'),
(3683, '0:5:0', '一而二，二而三', '\n【 yī　ér　èr，èr　ér　sān 】\n			', '\n由一至二，由二至三。指由此及彼联想开去。\n			', '\n清·曹雪芹《红楼梦》第二十八回：“因此一而二，二而三，反复推求了去，真不知此时此际，欲为何等蠢物，杳无所知，逃大造，出尘网，便可解释这段悲伤。”\n			', '\n暂无\n			'),
(3684, '0:5:0', '一而二，二而一', '\n【 yī　ér　èr，èr　ér　yī 】\n			', '\n两件事看似不同，实际上却相同。\n			', '\n明·罗懋登《三宝太监西洋记通俗演义》第九回：“天子神仙，一而二，二而一，岂有三茅祖师之印，陛下用不得之理？”\n			', '\n纸，钱也，即古之所为寓钱也；以寓钱喻制钱，\n			'),
(3685, '0:5:0', '一而光', '\n【 yī　ér　guāng 】\n			', '\n比喻彻底清除。同“一扫而空”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3686, '0:5:0', '一佛出世，二佛升天', '\n【 yī　fó　chū　shì，èr　fó　shēng　tiān 】\n			', '\n死去活来之意。出世，生；生天，死。\n			', '\n明·冯梦龙《醒世恒言》第三十八卷：“［李清］直等到一佛出世，二佛升天，方才有个青衣童子开门出来。”\n			', '\n陈月波、马剑郎只好把气出在那两个卫兵的身上，骂得他们～。\n			'),
(3687, '0:5:0', '一佛出世，二佛生天', '\n【 yī　fó　chū　shì，èr　fó　shēng　tiān 】\n			', '\n死去活来之意。出世，生；生天，死。\n			', '\n明·凌濛初《二刻拍案惊奇》卷二十三：“合家见防御说得伤心，一齐号哭起来。直哭得一佛出世，二佛生天，连崔生也不知陪下了多少眼泪。”\n			', '\n暂无\n			'),
(3688, '0:5:0', '一饭三吐哺', '\n【 yī　fàn　sān　tǔ　bǔ 】\n			', '\n指一顿饭之间，三次停食，以接待宾客。比喻求贤殷切。\n			', '\n《史记·鲁周公世家》：“我文王之子，武王之弟，成王之叔父，我于天下亦不贱矣。然我一沐三握发，一饭三吐哺，起以待士，犹恐失天下之贤人。子之鲁，慎勿以国骄人。”\n			', '\n干王恩高量广，不以初交见嫌，不以触犯见罪，虽与周之姬旦，～，\n			'),
(3689, '0:5:0', '养军千日，用军一时', '\n【 yǎng　jūn　qiān　rì，yòng　jūn　yī　shí 】\n			', '\n指长期供养、训练军队，以备一旦用兵打仗。同“养军千日，用在一朝”。\n			', '\n元·马致远《汉宫秋》第二折：“我养军千日，用军一时。空有满朝文武，那一个与我退的番兵！都是些畏刀避箭的。”\n			', '\n尝言‘～’。俺们不替朝廷出力，竟是一伙禽兽了。\n			'),
(3690, '0:5:0', '养军千日，用在一朝', '\n【 yǎng　jūn　qiān　rì，yòng　zài　yī　zhāo 】\n			', '\n指长期供养、训练军队，以备一旦用兵打仗。\n			', '\n《秦并六国平话》卷上：“王贲启奏曰：‘告陛下，养军千日，用在一朝。’”元·高文秀《渑池会》第三折：“主公，可不道，养军千日，用在一朝。为臣子要尽忠报国也呵！”\n			', '\n自古～。臣等呵，无能灭虎狼，无能灭虎狼，空愧熊罴将。\n			'),
(3691, '0:5:0', '一决胜负', '\n【 yī　jué　shèng　fù 】\n			', '\n进行最后的较量以决定高下。\n			', '\n宋·司马光《与王介甫书》：“介甫之意，必欲力战天下之人，与之一决胜负，不复顾义理之是非，生民之忧乐，国家之安危。”\n			', '\n暂无\n			'),
(3692, '0:5:0', '赢金一经', '\n【 yíng　jīn　yī　jīng 】\n			', '\n指留下满筐的金银，不如传授一经。赢，通“籝”。\n			', '\n《汉书·韦贤传》：“贤四子；长子方山为高寝令，早终；次子弘，至东海太守；次子舜，留鲁守坟墓；少子玄成，复以明经历位至丞相。故邹鲁谚曰：‘遗子黄金满籝，不如一经。’”颜师古注：“今书本籝字或作盈，又是盈满之义。”\n			', '\n暂无\n			'),
(3693, '0:5:0', '一块石头落了地', '\n【 yī　kuài　shí　tou　luò　le　dì 】\n			', '\n比喻放下了心。\n			', '\n清·曹雪芹《红楼梦》第十九回：“次后忽然宝玉去了，他两个又是那个光景儿，母子二人心中更明白了，越发一块石头落了地，而且是意外之想，彼此放心，再无别意了。”\n			', '\n暂无\n			'),
(3694, '0:5:0', '一牛鸣', '\n【 yī　niú　míng 】\n			', '\n指牛鸣声可及之地。比喻距离较近。同“一牛吼地”。\n			', '\n唐·王维《与苏卢二员外游方丈寺》诗：“回看双凤阙，相去一牛鸣。”\n			', '\n四壁晚钟齐接应，分明不隔～。\n			'),
(3695, '0:5:0', '一掊土', '\n【 yī　póu　tǔ 】\n			', '\n抔：用手捧东西。一捧黄土。指坟墓。现多比喻不多的土地或没落、渺小的反动势力。\n			', '\n《史记·张释之列传》：“假令愚民取长陵一抔土，陛下何以加其法乎？”\n			', '\n顾自民国肇造，变乱纷乘，黄花冈上～，犹湮没于荒烟蔓草间。\n			'),
(3696, '0:5:0', '一人敌', '\n【 yī　rén　dí 】\n			', '\n指匹夫之勇，止足以敌一人。\n			', '\n语出《孟子·梁惠王下》：“夫抚 剑疾视，曰：‘彼恶敢当我哉！’此匹夫之勇，敌一人者也。”\n			', '\n剑，～，不足学；学万人敌。\n			'),
(3697, '0:5:0', '一人飞升，仙及鸡犬', '\n【 yī　rén　fēi　shēng，xiān　jí　jī　quǎn 】\n			', '\n用以比喻一人得势，与其有关者亦皆随之发迹。多含讽刺意。同“一人得道，鸡犬升天”。\n			', '\n语出汉·淮南王刘安举家升天的传说。清·蒲松龄《聊斋志异·促织》：“天将以酬长厚者，遂使抚臣、令尹、并受促织恩荫。闻之：‘一人飞升，仙及鸡犬。’信夫！”\n			', '\n暂无\n			'),
(3698, '0:5:0', '一人向隅，满坐不乐', '\n【 yī　rén　xiàng　yú，mǎn　zuò　bù　lè 】\n			', '\n指满堂之上，一人不乐，众皆为之不欢。\n			', '\n汉·刘向《说苑·贵德》：“故圣人之于天下也，譬犹一堂之上也。今有满堂饮酒者，有一人独索然向隅而泣，则一堂之人皆不乐矣。”\n			', '\n方见一少年，举杯瞻之曰：‘～，小人窃不自量，愿闻金玉之声。’\n			'),
(3699, '0:5:0', '一十八般兵器', '\n【 yī　shí　bā　bān　bīng　qì 】\n			', '\n泛指各种兵器。\n			', '\n元·关汉卿《哭存孝》第一折：“你放下一十八般兵器，你抡不动那鞭、简、挝、锤。”\n			', '\n暂无\n			'),
(3700, '0:5:0', '一十八般武艺', '\n【 yī　shí　bā　bān　wǔ　yì 】\n			', '\n泛指各种武术技艺。\n			', '\n元·白朴《梧桐雨》楔子：“臣左右开弓，一十八般武艺，无有不会。”\n			', '\n暂无\n			'),
(3701, '0:5:0', '一山不藏二虎', '\n【 yī　shān　bù　cáng　èr　hǔ 】\n			', '\n比喻两人不能相容。\n			', '\n欧阳山《三家巷》：“他跟展公有点一山不藏二虎的味道，这是他太狂妄。”\n			', '\n暂无\n			'),
(3702, '0:5:0', '一十八层地狱', '\n【 yī　shí　bā　céng　dì　yù 】\n			', '\n佛教指极恶众生死后赴受苦之所，包括刀山、火汤、寒冰等十八种。比喻灾难极其深重的境地。也比喻最低的等级。\n			', '\n明·吴承恩《西游记》第十一回：“判官道:‘此是阴山背后一十八层地狱。’”\n			', '\n皇帝的尊严真的要“升到三十三天堂，为玉皇大帝盖瓦”，臣民的自卑，也真的要“死到～，替阎王老爷挖煤。\n			'),
(3703, '0:5:0', '又生一秦', '\n【 yòu　shēng　yī　qín 】\n			', '\n指又造成一个强敌。\n			', '\n《史记·张耳陈馀列传》：“陈王相国房君谏曰：‘秦未亡而诛武臣等家，此又生一秦也。’”\n			', '\n自增仇敌曰～。\n			'),
(3704, '0:5:0', '一是一，二是二', '\n【 yī　shì　yī，èr　shì　èr 】\n			', '\n形容说话老老实实，毫不含糊。\n			', '\n清·俞万春《荡寇志》第80回：“遂把那杨腾蛟怎样写亲供，刘二怎样勒掯，小人等不依他，又恐怕被他连累，一是一，二是二的都说了。”\n			', '\n～，我问出口，你就得说，别犹豫。\n			'),
(3705, '0:5:0', '优昙一现', '\n【 yōu　tán　yī　xiàn 】\n			', '\n优昙钵花如莲花十二瓣，一开即敛。比喻事物或景象稍现即逝，难得见到。\n			', '\n语出《法华经·方便品》：“佛告舍利弗，如是妙法，诸佛如来时乃说之，如优昙钵花时一现耳。”\n			', '\n遂推为两京法主，三帝国师，仰佛日之再中，庆～。\n			'),
(3706, '0:5:0', '一文钱难倒英雄汉', '\n【 yī　wén　qián　nán　dǎo　yīng　xióng　hàn 】\n			', '\n比喻一个很小的困难却使一个很大的事情无法进行，无法完成。也指一个很有本事的人，面对一个小问题而束手无策。\n			', '\n<span class="C999">暂无</span>\n			', '\n天下事只怕没得银钱，便是俗语说得好：～。\n			'),
(3707, '0:5:0', '一无所求', '\n【 yī　wú　suǒ　qiú 】\n			', '\n指没有什么要求或需要。\n			', '\n清·文康《儿女英雄传》第16回：“要我给她遮掩个门户；此外一无所求。”\n			', '\n暂无\n			'),
(3708, '0:5:0', '一无所闻', '\n【 yī　wú　suǒ　wén 】\n			', '\n一点也没有听说，丝毫也不知道。\n			', '\n<span class="C999">暂无</span>\n			', '\n但此处却～，我看这事情大约已经过去了。\n			'),
(3709, '0:5:0', '一厢情愿', '\n【 yī　xiāng　qíng　yuàn 】\n			', '\n指单方面的愿望或不考虑客观实际情况的主观意愿。同“一相情愿”。\n			', '\n蒋子龙《乔厂长上任记》：“有人说：‘你这一厢情愿，石敢同意去吗？’”\n			', '\n暂无\n			'),
(3710, '0:5:0', '一薰一莸', '\n【 yī　xūn　yī　yóu 】\n			', '\n薰：香草，比喻善类；莸：臭草，比喻恶物。薰莸混在一起，只闻到臭闻不到香。比喻善常被恶所掩盖。\n			', '\n《左传·僖公四年》：“一薰一莸，十年尚犹有臭。”\n			', '\n～，十年尚犹有臭。今天好算的香臭会花粪宴了。（清·姬文《市声》第十七回）\n			'),
(3711, '0:5:0', '一言不发', '\n【 yī　yán　bù　fā 】\n			', '\n一句话也不说。\n			', '\n明·冯梦龙《喻世明言》卷一：“三巧儿听说丈夫把她休了，一言不发，啼哭起来。”\n			', '\n只见她～，回手拔出那把刀来。\n			'),
(3712, '0:5:0', '一渊不两蛟', '\n【 yī　yuān　bù　liǎng　jiāo 】\n			', '\n比喻两雄不能并立。\n			', '\n《文子·上德》：“一渊不两蛟，一雌不二雄，一即定，两即争。”《淮南子·说山训》：“一渊不两蛟，水定则清正。”\n			', '\n暂无\n			'),
(3713, '0:5:0', '有一搭没一搭', '\n【 yǒu　yī　dā　méi　yī　dā 】\n			', '\n表示故意找话说。也表示可有可无，无足轻重。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3714, '0:5:0', '有一得一', '\n【 yǒu　yī　dé　yī 】\n			', '\n不加也不减，有多少是多少。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			'),
(3715, '0:5:0', '一拥而入', '\n【 yī　yōng　ér　rù 】\n			', '\n拥：拥挤。一下子全都拥了进去，挤了进去。\n			', '\n明·冯梦龙《醒世恒言》卷十五：“众人一拥而入，迎头就把了缘拿住，押进里面搜捉，不曾走了一个。”\n			', '\n暂无\n			'),
(3716, '0:5:0', '一叶落知天下秋', '\n【 yī　yè　luò　zhī　tiān　xià　qiū 】\n			', '\n从一片树叶的凋落，知道秋天的到来。比喻通过个别的细微的迹象，可以看到整个形势的发展趋向与结果。\n			', '\n《淮南子·说山训》：“见一叶落而知岁之将暮。”宋·唐庚《文录》引唐人诗：“山僧不解数甲子，一叶落知天下秋。”\n			', '\n暂无\n			'),
(3717, '0:5:0', '一言堂', '\n【 yī　yán　táng 】\n			', '\n旧时商店表示不二价的匾。现比喻领导缺乏民主作风，独断专行，一个人说了算。\n			', '\n艾芜《漫谈科学和文学》：“要设法制止‘一言堂’，‘个人说了算’的不民主现象。”\n			', '\n暂无\n			'),
(3718, '0:5:0', '盈盈一水', '\n【 yíng　yíng　yī　shuǐ 】\n			', '\n比喻相隔不远。\n			', '\n《古诗十九首》之十：“盈盈一水间，脉脉不得语。”\n			', '\n暂无\n			'),
(3719, '0:5:0', '一叶障目', '\n【 yī　yè　zhàng　mù 】\n			', '\n眼睛被一片树叶挡住，指看不到事物的全貌。也作“一叶蔽目”。\n			', '\n毛泽东《论持久战》：“一叶障目，不见泰山，而自以为是。”\n			', '\n暂无\n			'),
(3720, '0:5:0', '一字褒贬', '\n【 yī　zì　bāo　biǎn 】\n			', '\n褒：赞扬，夸奖；贬：给予不好的评价。一个字的褒扬或贬斥。泛指记事论人，用字措辞严谨有分寸。\n			', '\n晋·杜预《左传序》：“春秋虽以一字为褒贬，然皆须数句以成言。”\n			', '\n暂无\n			'),
(3721, '0:5:0', '一支半节', '\n【 yī　zhī　bàn　jié 】\n			', '\n指一小部分。\n			', '\n梁启超《新民说》第八节：“人民之望仁政以得一支半节之权利者，实含有亡国民之根性，明也。”\n			', '\n暂无\n			'),
(3722, '0:5:0', '一知半见', '\n【 yī　zhī　bàn　jiàn 】\n			', '\n指不成熟的一点见解。\n			', '\n清·方以智《东西均·道艺》：“讵知后世之门庭张网者，偶窃一知半见，谓人悟门，便住门限上，登曲录床，此生不可复下。”\n			', '\n今任其～，指为妙悟，如照萤光，如窥隙日，以为诗之妙解尽在是。\n			'),
(3723, '0:5:0', '一肢半节', '\n【 yī　zhī　bàn　jié 】\n			', '\n比喻事物的一小部分。\n			', '\n明·袁宗道《读孟子》：“三代而下，市鲜中行，得乡愿之一肢半节，皆足以成世。”\n			', '\n暂无\n			'),
(3724, '0:5:0', '一着被蛇咬，三年怕井绳', '\n【 yī　zhāo　bèi　shé　yǎo，sān　nián　pà　j 】\n			', '\n比喻在某件事情上吃过苦头，以后一碰到类似的事情就害怕。\n			', '\n宋·释普济《五灯会元·龙门远禅师法嗣》：“问：‘狗子还有佛性也无。’赵州道：‘无意者如何？’师曰：‘一度著蛇咬，怕风了断井索。’”\n			', '\n南星摸着头上的大包，颇有点“～”的神气。\n			'),
(3725, '0:5:0', '一眨巴眼', '\n【 yī　zhǎ　bā　yǎn 】\n			', '\n方言。一眨眼。\n			', '\n老舍《小坡的生日》四：“可惜新年也和别的日子一样，一眨巴眼儿就过去了。”\n			', '\n可是这个匪徒突然～，大哭起来，狠狠照着自己的脸上打了响响的两个耳光子。\n			'),
(3726, '0:5:0', '一字长城', '\n【 yī　zì　cháng　chéng 】\n			', '\n排列成一长条的阵势。也指一言奏效，可比长城。\n			', '\n明·汤显祖《牡丹亭·折寇》：“仗恩台一字长城，借寒儒八面威风。”\n			', '\n暂无\n			'),
(3727, '0:5:0', '一子出家，九祖升天', '\n【 yī　zǐ　chū　jiā，jiǔ　zǔ　shēng　tiān 】\n			', '\n指子孙中有一人出家，祖宗都能升天。常用以借喻一人得势，全家沾光。\n			', '\n明·兰陵笑笑生《金瓶梅词话》第一百回：“常言：‘一子出家，九祖升天’，你那夫主冤愆解释，亦得超生去了。”\n			', '\n暂无\n			'),
(3728, '0:5:0', '一子出家，七祖升天', '\n【 yī　zǐ　chū　jiā，qī　zǔ　shēng　tiān 】\n			', '\n借喻一人得势，全家沾光。同“一子出家，九祖升天”。\n			', '\n清·曹雪芹《红楼梦》第一一七回：“我说的不是功名么？你们不知道‘一子出家，七祖升天呢’？”\n			', '\n暂无\n			'),
(3729, '0:5:0', '一子出家，七祖昇天', '\n【 yī　zǐ　chū　jiā，qī　zǔ　shēng　tiān 】\n			', '\n借喻一人得势，全家沾光。同“一子出家，九祖升天”。\n			', '\n<span class="C999">暂无</span>\n			', '\n暂无\n			');