toolbar = [
    {
        type: 'i',
        content: 'undo',
        onclick: function () {
            jexcel.current.undo();
        }
    },
    {
        type: 'i',
        content: 'redo',
        onclick: function () {
            jexcel.current.redo();
        }
    },
    {
        type: 'i',
        content: 'content_copy',
        onclick: function () {
            jexcel.current.copy(true);
        }
    },
    {
        type: 'i',
        content: 'content_paste',
        onclick: function () {
            if (jexcel.current.selectedCell) {
                navigator.clipboard.readText().then(function (text) {
                    if (text) {
                        jexcel.current.paste(jexcel.current.selectedCell[0], jexcel.current.selectedCell[1], text);
                    }
                });
            }
        }
    },
    {
        type: 'select',
        k: 'font-family',
        v: ['宋体', '楷体', '黑体', '隶书', 'Arial']
    },
    {
        type: 'select',
        k: 'font-size',
        v: ['9px', '10px', '11px', '12px', '13px', '14px', '15px', '16px', '17px', '18px', '19px', '20px']
    },
    {
        type: 'i',
        content: 'format_align_left',
        k: 'text-align',
        v: 'left'
    },
    {
        type: 'i',
        content: 'format_align_center',
        k: 'text-align',
        v: 'center'
    },
    {
        type: 'i',
        content: 'format_align_right',
        k: 'text-align',
        v: 'right'
    },
    {
        type: 'i',
        content: 'format_bold',
        k: 'font-weight',
        v: 'bold'
    },
    {
        type: 'color',
        content: 'format_color_text',
        k: 'color'
    },
    {
        type: 'color',
        content: 'format_color_fill',
        k: 'background-color'
    },
];

    contextMenu = function (obj, x, y, e) {
        var items = [];
    
        if (y == null) {
            // Rename column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: obj.options.text.renameThisColumn,
                    onclick: function () {
                        obj.setHeader(x);
                    }
                });
            }
            // Width column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '修改列宽度',
                    onclick: function () {
                        let width = prompt("列宽度：", obj.getWidth(x));
                        if (width)
                            obj.setWidth(x, width);
                    }
                });
            }
            // Type column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '修改列类型',
                    onclick: function () {
                        let type = prompt("列类型： text | number | hidden | dropdown | autocomplete | checkbox | radio | calendar | image | color | html ", JSON.stringify(obj.options.columns[x].type));
                        if (type)
                            obj.options.columns[x].type = type;
                    }
                });
            }
            // Source column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '修改下拉选项',
                    onclick: function () {
                        let source = prompt("下拉选项： [ 'A', 'B', 'C' ] | [ {'id':'1', 'name':'A'}, {'id':'2', 'name':'B'} ]", JSON.stringify(obj.options.columns[x].source));
                        if (source)
                            obj.options.columns[x].source = source;
                    }
                });
            }
            // Options column
            //if (obj.options.allowRenameColumn == true) {
            //    items.push({
            //        title: '修改日期格式',
            //        onclick: function () {
            //            let format = prompt("日期格式： YYYY-MM-DD", JSON.stringify(obj.options.columns[x].options.format));
            //            if (format)
            //                obj.options.columns[x].options.format = format;
            //        }
            //    });
            //}
            // stripHTML column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '是否允许空值',
                    onclick: function () {
                        let allowEmpty = prompt("是否允许空值： true | false", JSON.stringify(obj.options.columns[x].allowEmpty));
                        if (allowEmpty)
                            obj.options.columns[x].allowEmpty = allowEmpty;
                    }
                });
            }
            // stripHTML column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '去HTML代码',
                    onclick: function () {
                        let stripHTML = prompt("去HTML代码： true | false", JSON.stringify(obj.options.columns[x].stripHTML));
                        if (stripHTML)
                            obj.options.columns[x].stripHTML = stripHTML;
                    }
                });
            }
            // Clear column
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '清除列属性',
                    onclick: function () {
                        obj.options.columns[x] = {};
                    }
                });
            }
            // Freeze columns
            if (obj.options.allowRenameColumn == true) {
                items.push({
                    title: '冻结列数量',
                    onclick: function () {
                        let freezeColumns = prompt("冻结列数量： 0", JSON.stringify(obj.options.freezeColumns));
                        if (freezeColumns)
                            obj.options.freezeColumns = freezeColumns;
                    }
                })
            }
            // Line
            items.push({ type: 'line' });
    
    
            // Insert a new column
            if (obj.options.allowInsertColumn == true) {
                items.push({
                    title: obj.options.text.insertANewColumnBefore,
                    onclick: function () {
                        obj.insertColumn(1, parseInt(x), 1);
                    }
                });
            }
    
            if (obj.options.allowInsertColumn == true) {
                items.push({
                    title: obj.options.text.insertANewColumnAfter,
                    onclick: function () {
                        obj.insertColumn(1, parseInt(x), 0);
                    }
                });
            }
    
            // Delete a column
            if (obj.options.allowDeleteColumn == true) {
                items.push({
                    title: obj.options.text.deleteSelectedColumns,
                    onclick: function () {
                        obj.deleteColumn(obj.getSelectedColumns().length ? undefined : parseInt(x));
                    }
                });
            }
    
            // Sorting
            if (obj.options.columnSorting == true) {
                // Line
                items.push({ type: 'line' });
    
                items.push({
                    title: obj.options.text.orderAscending,
                    onclick: function () {
                        obj.orderBy(x, 0);
                    }
                });
                items.push({
                    title: obj.options.text.orderDescending,
                    onclick: function () {
                        obj.orderBy(x, 1);
                    }
                });
            }
        } else {
            // Height row
            if (obj.options.allowInsertRow == true) {
                items.push({
                    title: '修改行高度',
                    onclick: function () {
                        let height = prompt("行高度：", obj.getHeight(y));
                        if (height)
                            obj.setHeight(y, height);
                    }
                });
            }

            items.push({ type: 'line' });
            // Insert new row
            if (obj.options.allowInsertRow == true) {
                items.push({
                    title: obj.options.text.insertANewRowBefore,
                    onclick: function () {
                        obj.insertRow(1, parseInt(y), 1);
                    }
                });
    
                items.push({
                    title: obj.options.text.insertANewRowAfter,
                    onclick: function () {
                        obj.insertRow(1, parseInt(y));
                    }
                });
            }
    
            if (obj.options.allowDeleteRow == true) {
                items.push({
                    title: obj.options.text.deleteSelectedRows,
                    onclick: function () {
                        obj.deleteRow(obj.getSelectedRows().length ? undefined : parseInt(y));
                    }
                });
            }
    
            if (x) {
                items.push({ type: 'line' });

                // Merg cell
                if (obj.options.allowInsertRow == true) {
                    items.push({
                        title: '合并单元格',
                        onclick: function () {
                            let col = obj.getSelectedColumns(true).toString().split(',');
                            let row = obj.getSelectedRows(true).toString().split(',');
                            if (col.length > 1 || row.length > 1)
                                var cellId = jexcel.getColumnNameFromId([parseInt(col[0]), parseInt(row[0])])
                                obj.setMerge(cellId, col.length, row.length);
                        }
                    });
                }
                // Merg cell
                if (obj.options.allowInsertRow == true) {
                    items.push({
                        title: '取消合并单元格',
                        onclick: function () {
                            let col = obj.getSelectedColumns(true).toString().split(',');
                            let row = obj.getSelectedRows(true).toString().split(',');
                            let cellId = jexcel.getColumnNameFromId([parseInt(col[0]), parseInt(row[0])])
                            obj.removeMerge(cellId);
                        }
                    });
                }
                if (obj.options.allowComments == true) {


                    items.push({ type: 'line' });

                    var title = obj.records[y][x].getAttribute('title') || '';
    
                    items.push({
                        title: title ? obj.options.text.editComments : obj.options.text.addComments,
                        onclick: function () {
                            obj.setComments([x, y], prompt(obj.options.text.comments, title));
                        }
                    });
    
                    if (title) {
                        items.push({
                            title: obj.options.text.clearComments,
                            onclick: function () {
                                obj.setComments([x, y], '');
                            }
                        });
                    }
                }
            }
        }
    
        // Line
        items.push({ type: 'line' });
    
        // Save
        if (obj.options.allowExport) {
            items.push({
                title: obj.options.text.saveAs,
                shortcut: 'Ctrl + S',
                onclick: function () {
                    obj.download();
                }
            });
        }
    
        return items;
    };