﻿function toForm(data) {
    var form = '';
    var index = 0;
    if (data[0]) {
        form = data[0].replace(/(<td[^>]*?>)((?:{.*?})?(?:<br\/?>)?)(<\/td>)/ig, function ($0, $1, $2, $3) {
            var str = '';
            var value = data[1] && data[1][index] ? data[1][index] : '';
            var rule = /class="(\d*)"/.exec($1);
            var field = $2.replace(/<br\/?>/, '');
            if (!data[2] && !rule || data[2] && rule && data[2] == rule[1]) {
                switch (field) {
                    case '{}': str = '<textarea style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;">' + value + '</textarea>';
                        break;
                    case '{ }': str = '<textarea style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" required>' + value + '</textarea>';
                        break;
                    case '<br/>': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + value + '" />';
                        break;
                    case '{0}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + value + '" required />';
                        break;
                    case '{1}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="number" step="0.01" value="' + value + '" required />';
                        break;
                    case '{2}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="number" value="' + value + '" required int />';
                        break;
                    case '{3}':
                        if (!value) {
                            var date = new Date();
                            value = date.getFullYear() + '-' + (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-' + (date.getDate() < 10 ? '0' + date.getDate() : date.getDate());
                        }
                        str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="date" value="' + value + '" required />';
                        break;
                    case '{4}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="date" value="' + value + '" />';
                        break;
                    case '{5}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="datetime-local" value="' + value + '" required />';
                        break;
                    case '{6}': str = '<input type="hidden" value="' + (value == '' ? '{6}' : value) + '" />';
                        break;
                    case '{7}': var seal = data[3] ? '<img src="' + data[3] + '" style= "position:absolute; z-index:-1;" />' : '';
                        str = seal + '<input type="hidden" value="' + seal.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\'/g, '&#39;').replace(/\"/g, '&quot;') + '" />';
                        break;
                    case '{8}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + parent.window.userData.name + '" readonly />';
                        break;
                    case '{9}': str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" type="text" value="' + parent.window.userData.dept + '" readonly />';
                        break;
                    default:
                        var reg = /{(.*)}/.exec(field);
                        if (reg) {
                            var arr = reg[1].split(',');
                            if (arr.length > 1) {
                                str = '<select style="width:99%;border:1px dotted gray;background-color:transparent;">';
                                for (var i in arr)
                                    str += '<option value="' + arr[i] + '" ' + (value === arr[i] ? ' selected' : '') + '>' + arr[i] + '</option>';
                                str += '</select>';
                            }
                            else {
                                str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" value="' + (data[1] ? value : arr[0]) + '" type="text" required />';
                            }
                        }
                        else {
                            str = '<input style="width:99%;height:99%;border:1px dotted gray;background-color:transparent;" value="' + value + '" type="text" />';
                        }
                }
            }
            else {
                str = (field == '{7}' ? value : value.replace(/\r?\n/g, '<br/>').replace(/\s/g, '&nbsp;')) + '<input type="hidden" value="' + value.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\'/g, '&#39;').replace(/\"/g, '&quot;') + '" />';
            }
            index++;
            return $1 + str + $3;
        });
    }
    return form;
}
function doForm(id) {
    var fields = document.getElementById(id).querySelectorAll('input,textarea,select');
    var data = [];
    for (var i = 0; i < fields.length; i++) {
        data.push((fields[i]).value);
    }
    return data;
}
function toReport(template, data) {
    var strReport = template.replace(/(<td[^>]*?>)((?:{.*?})(?:<br\/?>)?)(<\/td>)/ig, function ($0, $1, $2, $3) {
        var index = /{(.*)}/.exec($2)[1];
        var value = data && data[index] ? data[index] : '';
        return $1 + (/<img src="data:image/.test(value) ? value : value.replace(/\r?\n/g, '<br/>').replace(/\s/g, '　')) + $3;
    });
    return strReport;
}
function fields(id) {
    return document.getElementById(id).querySelectorAll('input,textarea,select');
}
function tip(elem, msg, icon) {
    var offsetX = (self.scrollWidth || (document.documentElement && document.documentElement.scrollWidth) || document.body.scrollWidth) - pageX(elem) > 120 ? 0 : 100;
    var tip = document.createElement("div");
    tip.style.cssText = 'position: absolute;top: ' + (pageY(elem) + elem.offsetHeight + 7) + 'px;left:' + (pageX(elem) - offsetX) + 'px;min-width:105px;max-width:280px;z-index: 1100000;box-sizing:content-box;border:1px solid #A9B7C7;border-radius: 5px;padding: 10px;background-color: #FBFBFB;font-size: 14px;line-height:150%;';
    tip.innerHTML = '<span style="position: absolute;top:-10px;left:' + (offsetX + 10) + 'px;color: #A9B7C7;font-family:SimSun;font-size: 14px;"><b style="position: absolute;color:#A9B7C7;z-index: 1;">◆</b><b style="position: absolute;color:#FBFBFB;z-index: 2;top:1px;">◆</b></span>';
    if (icon)
        tip.innerHTML += '<div style="display: inline-block;background-color: #FAAB20;color: white;font-family:SimHei;font-size: 15px;font-weight: bold;width: 18px;height: 18px;border-radius: 2px;text-align: center;margin-right: 5px;">!</div>';
    tip.innerHTML += msg;
    var tm = setTimeout(function () {
        try {
            document.body.removeChild(tip);
        }
        catch (err) {
        }
    }, 5000);
    tip.onmouseover = function () { clearTimeout(tm); }
    tip.onmouseout = function () { document.body.removeChild(tip); }
    document.body.appendChild(tip);
}
function pageX(elem) {
    return elem.offsetParent ? (elem.offsetLeft + pageX(elem.offsetParent)) : elem.offsetLeft;
}
function pageY(elem) {
    return elem.offsetParent ? (elem.offsetTop + pageY(elem.offsetParent)) : elem.offsetTop;
}