/*
 * Copyright (c) 2007, www.jc001.cn! All rights reserved.
 *
 * web         : http://www.jc001.cn
 * author      : stcer (ab12cxyh@163.com)
 * version     : 0.1.0 
 */ 

var Class = Class || {
  create: function() {
    return function() {
      this.initialize.apply(this, arguments);
    }
  }
}

Object.extend = Object.extend || function(destination, source) {
  for (property in source) {
    destination[property] = source[property];
  }
  return destination;
}

Function.prototype.bind = Function.prototype.bind || function() {
	var __method = this, args = new Array();
	for(var __i = 0; __i < arguments.length; __i++){
		args.push(arguments[__i]);
	}
	var object = args.shift();
	return function() {
		return __method.apply(object, args);
	}
}

// Class SCategory
var MSelect = MSelect || Class.create();
MSelect.counter = 0;
MSelect.prototype = {
	initialize : function(name){
        this.counter = MSelect.counter++;
        
		this.map = {};
		this.cats = [];
		this.tree = [];
		this.ptree = {};
		this.dtree = {};
		this.deep = 0;
		this.pk_name = 'pid';
		this.nk_name = 'name';
		this.name = name;

		this.topcid = 0;
		this.req = false;

		this.tipbox = null;
		this.isShowLayer = false;

		this.init(); // for extends
		
		return this;
	},

	init : function(){},

	set_cats : function(cats){
		this.cats = cats;
		this.tree_build();
	},

	tree_build : function(){
		var tree = {};
		var pid;
		var cats = this.cats;
		for(var cid in cats){
			pid = cats[cid][this.pk_name];
			if(typeof(tree[pid]) != 'object'){
				tree[pid] = [];
			}
			tree[pid].push(cid);
			this.map[cid] = pid;
		}
		this.tree = tree;
	},

	get_deep : function(cid){
		if(typeof this.dtree[cid] == 'undefined'){
			this.dtree[cid] = this.get_pids(cid).length;
		}
		return this.dtree[cid];
	},

	get_pids : function(cid){
		var parents = [];
		var pid = this.map[cid];
		if(typeof(pid) != 'undefined'){
			parents = this.get_pids(pid);
			parents.push(pid);
		}
		return parents;
	},
	
	get_child_ids : function(cid){
		return this.tree[cid];
	},
	
	get_cat_name : function(cid){
		if(this.cats[cid])
			return this.cats[cid][this.nk_name];
		return '';
	},

// -------------------------------------------
// select element 
// -------------------------------------------

	setTopcid : function(cid){
		this.topcid = cid;
	},

	setReq : function(flag){
		this.req = flag;
	},
	
	// init select's container
	render : function(catid, size){
		this.initwrap(this.name);

		// set hidden element value
		this.valueHandle.value = typeof catid == 'undefined' ? '' : catid; 
		
		if(parseInt(size) > 0){
			this.size = parseInt(size);
		}

		// init select
		if(catid == 0 
		   	|| typeof(catid) == 'undefined' 
			|| typeof(this.cats[catid]) == 'undefined'
			|| catid == ''){
			
			this.select_build(this.topcid);
	
		}else if(pids = this.get_pids(catid)){
			pids.push(catid);
			var start = false;
			for(var i = 0; i < pids.length; i++){
				if(this.topcid == pids[i]){
					start = true;
				}
				if(start ==  true){
					this.select_build(pids[i], pids[i+1]);
				}
			}
		}
	},

	initwrap : function(name){
		this.size = 0;
		this.name_prefix  = '__category_';
		this.container_name = this.name_prefix + name + (this.counter);
		if(!this.gel(this.container_name)){
			document.write('<span id="' + this.container_name + '"></span>');
			document.write('<input id="__' + name  + this.counter + '" name="' + name + '" type="hidden" />');
		}
		this.container = this.gel(this.container_name);
		this.container.innerHTML = '';
		this.valueHandle = this.gel('__' + name + this.counter);
	},

	select_build : function(pid, selected_catid, changed){
		var child_ids = this.tree[pid];
		if(!child_ids){
			this.closeTipbox();
			return	
		}
		
		oSelect_added = true;
		deep = this.get_deep(pid);

		// create select
		oSelect_id =  this.get_select_id(deep); // select id
		var oSelect = this.gel(oSelect_id)
		if(!oSelect){
			oSelect = document.createElement('select');
			oSelect.id = oSelect_id;
			oSelect_added = false;
		}
		oSelect.options.length = 0;
		if(this.size > 0){
			oSelect.size = this.size;
		}
		
		// append options
		if(!this.req){
			oOption = document.createElement("OPTION");
			oOption.text = '-ѡ-';
			oOption.value = -1;
			oSelect.options.add(oOption);
		}
		
		for(var i = 0, j = 0, selectIndex = 0; i < child_ids.length; i++){
			oOption = document.createElement("OPTION");
			oOption.text = this.cats[child_ids[i]][this.nk_name];
			oOption.value = child_ids[i];
			oSelect.options.add(oOption);
			
			j++;
			if((child_ids[i] + '') == (selected_catid + '')){
				selectIndex = j;
			}
		}
		
		// set selected item
		oSelect.selectedIndex = selectIndex
		
		// set event for onchange
		oSelect.onchange = this.change.bind(this, oSelect);
		
		if(!oSelect_added){
			this.container.appendChild(oSelect);
		}
		
		this.setTipbox(oSelect, changed);
	},

	get_select_id : function(deep){
		var name_prefix = this.container_name +  '__';
		return 	name_prefix + deep;
	},
	
	get_deep_from_id : function(id){
		var name_prefix = this.container_name +  '__';
		return 	id.substr(name_prefix.length);
	},

	change : function(oSelect){
		var deep;
		var catid = oSelect.value;
		
		// remove selects
		var oSelects = this.container.getElementsByTagName('select');
		var top_deep = this.get_deep(this.topcid);
		deep = parseInt(this.get_deep_from_id(oSelect.id)) - top_deep;
		
		var oslen = oSelects.length;
		for(var i = deep + 1; i < oslen; i++){
			if(delSelect = this.gel(this.get_select_id(i + top_deep))){
				this.container.removeChild(delSelect);
			}
		}
		
		if(typeof this.cats[catid] == 'undefined'){
			deep = this.get_deep_from_id(oSelect.id);
			var p_deep = parseInt(deep) - 1;
			if(p_deep > -1){
				this.valueHandle.value = this.gel(this.get_select_id(p_deep)).value;
			}else{
				this.valueHandle.value = '';	
			}
            
			this.closeTipbox();
            
            if(typeof this.onchange == 'function'){
                this.onchange(this.valueHandle.value, deep);
            }
			return;	
		}
		
		// set hidden element value
		this.valueHandle.value = catid; 
        
        if(typeof this.onchange == 'function'){
            this.onchange(this.valueHandle.value, deep);
        }

		// init child select
		this.select_build(catid, -1, true);
	},

// -------------------------------------------
// tip box 
// -------------------------------------------

	showLayer : function(flag){
		this.isShowLayer = flag;
		if(this.isShowLayer && !this.tipbox){
			try{
				this.tipbox = new Tipbox();
			}catch(e){
				this.isShowLayer = false;
			}
		}
	},

	setTipbox : function(oSelect, showbox){
		if(this.isShowLayer && this.tipbox){
			oSelect.onclick = this.tip.bind(this, oSelect);
			if(showbox){
				this.tip(oSelect);
			}
		}
	},
	
	closeTipbox : function(){
		if(this.tipbox){
			try{ 
				this.tipbox.close();
			}catch(e){}
		}
	},

	tip : function(oSelect){
		var html = this._selectHtml(oSelect);
		if(html.length  == 0){
			this.tipbox.close();
		}
		
		this.tipbox.setHtml(html);
		// event

		var _this = this;
		var items = this.tipbox.cnter.getElementsByTagName('li');
		for(var i = 0; i < items.length; i++){
			items[i].onclick = function(){
				oSelect.selectedIndex = this.id.substr(3);
				_this.change(oSelect);
			}
		}
		this.tipbox.show(oSelect);
	},

	_selectHtml : function(oSelect){
		var classname, html = '';
		var ops = oSelect.options;
		if(ops.length < 1){
			return '';
		}
		
		// html
		for(var i = 0; i < ops.length; i++){
			classname = ops[i].selected ? ' class="sel"' : '';
			html += '<li' + classname + ' id="inx' + i + '">' + ops[i].text + '</li>';
		}
		html = '<ul>' + html + '</ul>';
		html += '<div style="clear:both;display:block"></div>';
		return html;
	},
	
// -------------------------------------------
// search box 
// -------------------------------------------
	
	searchInit : function(){
		if(!jQuery){
			return;	
		}
		
		var id = 'cat_search_' + this.name;
		document.write('<span id="' + id  +'">');
		document.write(' <a href="#none"></a>');
		document.write(' <input type="text" size="22" class="gsinput" style="display:none"/> ');
		document.write(' <i style="display:none">  </i>');
		document.write('</span>');
		
		var that = this;
		if(!this.acdata){
			var data = [];
			jQuery.each(this.cats, function(i, n){
				data.push({'id' : i, 'name' : n[that.nk_name]});
			});
			this.acdata = data;
		}
		
		var input = jQuery('#' + id +' input');
		var pids, gname, pid;
		input.autocomplete(this.acdata, {
			matchContains : true,
			max : 60,
			formatItem: function(row) {
				return row.name;
			}
		}).result(function(event, item) {
			that.render(item.id, that.size);
			if(typeof that.onchange == 'function'){
				that.onchange(item.id);
			}
		});
	
		jQuery('#' + id +' a').click(function(){
			if(input.css('display') == 'none'){
				input.show();
				input.next().show();
				input.focus();
			}else{
				input.hide();
				input.next().hide();
			}
		});
	},

	gel : function(element) {
		if(typeof(element) == 'object')
			return element;
		if(typeof(element) == 'string'){
			if(htmlObject = document.getElementById(element)){
				return 	htmlObject;
			}else{
				htmlObject = document.getElementsByName(element);
				if(htmlObject.length == 0){
					return null;
				}else{
					return 	htmlObject[0];
				}
			}
		}
	},
	
	usedTip : function(cids){
		if(!jQuery){
			return;	
		}
		var name, pids, html;

		html = "<div>";
		for(var i = 0, j = cids.length; i < j; i++){
			name = '';
			pids = this.get_pids(cids[i]);
			for(var m = 1, n = pids.length, _name = ''; m < n; m++){
				_name = this.get_cat_name(pids[m]);
				if(_name.length > 0){
					name += _name + " - ";
				}
			}

			name += this.get_cat_name(cids[i]);
			if(name.length > 0)
				html += '<a href="#none" rel="' + cids[i] + '">' + name + '</a>';
		}
		html += "</div>";
		
		var tipbox = $(html);
		tipbox.css({
			position:"absolute", 
			background : "#ffffee", 
			border : "1px solid #ccc", 
			padding : "8px",
			"line-height" : "160%",
			"text-decoration": 'none'
			});
		tipbox.hide();
		
        var id =  "usedTipHandle_"+ MSelect.counter;
        document.write("&nbsp;<a id=\"" + id + "\" href=\"#none\">ĳ</a>&nbsp;");
        
        $(function(){
            $("body").append(tipbox);
        })

		$('#' + id).click(function(){
			var thisRef = $(this);
            var thisOffset = $(this).offset();
			tipbox.show().css("left", (thisOffset.left + thisRef.outerWidth() + 8) + "px").css("top", (thisOffset.top) + "px");
		});
		
		var that = this;
		$("a", tipbox).click(function(){
			var cid = this.rel;
			that.render(cid, that.size);
			if(typeof that.onchange == 'function'){
				that.onchange(cid);
			}
			tipbox.hide();
		});
		$("a", tipbox).each(function(i, v){
			$(v).css("display", "block");							 
		});
	}
}
