var chkf = chkf || function(f){
    this.f = f;
    this.uname = $(f.uname);
    this.password = $(f.pwd);
    this.password_confirm= $(f.rpwd);
    this.email = $(f.email);
    this.company = $(f.company);
    this.linkname = $(f.linkname);
    this.phone = $(f.phone);
    this.mphone = $(f.mphone);
    this.vcode = $(f.vcode);
    this.isAgree = $(f.isAgree);

    this.message = {
        uname : {
            'require' : 'ûΪ',
            'def' : 'û6-20ĸֻ», ֧ĺַ@#$%ȣ',
            'is_num' : 'û֧ȫ',
            'exist' : 'ûѴ'
        },
        
        password : {
            'require' : '벻Ϊ',
            'def' : 'ĸֻ»',
            'len' : '볤Ϊ6-20ַ'
        },
        
        password_confirm : {
            'def' : 'Ҫһ'
        },
        
        email : {
            'def' : 'ȷemailʽ : username@domain.com',
            'exist' : 'ַѴ'
        },
        
        company : {
            'def' : 'ע޸, дӪҵִϵȫ, 徭Ӫдִϵ',
            'len' : '˾ȲС2ַ',
            'len_max' : '˾Ȳܳ50ַ'
        },
        
        linkname : {
            'def' : 'ϵС2ַ, 20ַ'
        },
        
        phone : {
            'def' : 'ϵ绰'
        },
        
        mphone : {
            'def' : 'Ҫȷֻʽ',
            'exist' : 'õ绰Ѿע'
        },
        
        vcode : {
            'def' : 'ȡ֤󣬰ʾ֤'
        },
        isAgree : {
            'def' : '빴ѡȷĶЭ'
        }
    },
    
    this.stylenames = {
        'normal' : 'regInfoNormal',
        'error' : 'regInfoFault',
        'ok' : 'regInfoRight',
        'init' : 'regFocus'
        };
        
    this.rchk_user = false;
    this.rchk_email = false;
    this.errorFocus = null;
}

chkf.url = null;
chkf.prototype = {
    init : function(){
        var _this = this;
        var items = [
            'uname', 'password', 'password_confirm', 'email', 
            'company', 'linkname', 'phone', 'mphone',
            'vcode', 'isAgree'
            ];
        
        $(items).each(function(i, item){
            _this[item].change(function(){
                if(this.value.length > 0){
                    if(_this['chk_' + item] && _this['chk_' + item]()){
                        _this.showMsg(_this[item], 'ok');
                    }
                }
            });
            
            _this[item].focus(function(){
				if(this !== _this.isAgree[0]) {
					this.className = 'inputTextFocus';
				}
                if(this.value.length == 0){
                    _this.showMsg(_this[item], 'init', _this.message[item].def);
                }else{
                    $(this).change();
                }
            });
            
            _this[item].blur(function(){
				if(this !== _this.isAgree[0]) {
					this.className = 'inputText'; 
				}
                if(this.value.length == 0){
                    _this.hideMsg(_this[item]);
                }
            });
        });
    },
    
    chkAll : function(){
        this.errorFocus = null;
         
        var flg = this.chk_uname();
        flg = this.chk_password() && flg;
        flg = this.chk_password_confirm() && flg;
        flg = this.chk_email() && flg;
        flg = this.chk_vcode() && flg;
        flg = this.chk_mphone() && flg;
        flg = this.chk_isAgree() && flg;
        
        if($('[name=stype]:checked', this.f).val() == 2){
            flg = this.chk_company() && flg;
            flg = this.chk_linkname() && flg;
            flg = this.chk_phone() && flg;
        }
        
        if(!flg || !this.rchk_user || !this.rchk_email){
            if(!this.rchk_user){
                this.uname.focus();
            }else if(!this.rchk_email){
                 this.email.focus();
            }
            
            if(this.errorFocus){
                this.errorFocus.focus();
            }
            
            return false;
        }
        
        return flg;
    },
        
    chk_uname : function(){
        var msg = '';
        var v = this.uname.val();
        if(v.length == 0){
            msg = this.message.uname.require;
        }else if(!v.match(/^[a-zA-Z0-9_]{6,20}$/)){
            msg = this.message.uname.def;
        }
        
        if(msg.length > 0){
            this.showMsg(this.uname, 'error', msg);
            return false;
        }
        
        var _this = this;
        var flag = true;
        if(true)
            $.post(
                chkf.url, 
                {'do' : 'chkname', value : this.uname.val()},
                function(rs){
                    if(rs == '0'){
                        _this.showMsg(_this.uname, 'error', _this.message.uname.require);
                        flag = false;
                    }else if(rs == '1'){
                        _this.showMsg(_this.uname, 'error', _this.message.uname.exist);
                        flag = false;
                    }else if(rs == '3'){
                        _this.showMsg(_this.uname, 'error', _this.message.uname.is_num);
                        flag = false;
                    }else if(rs == '2'){
                        _this.showMsg(_this.uname, 'ok');
                        flag = true;
                    }else{
                        flag = false;
                    }
                    _this.rchk_user = flag;
                }
            );
        
        return flag;
    },

    chk_password : function(){
        var msg = '';
        var v = this.password.val();
        
        if(v.length == 0){
            msg = this.message.password.require;
        }else if(!v.match(/^[a-zA-Z0-9_]+$/)){
            msg = this.message.password.def;
        }else if(v.length > 20 || v.length < 6){
            msg = this.message.password.len
        }
        
        if(msg.length > 0){
            this.showMsg(this.password, 'error', msg);
            return false;
        }
        
        return true;
    },
    
    chk_password_confirm : function(){
        var msg = '';
        if(this.password.val() != this.password_confirm.val()){
            msg = this.message.password_confirm.def;
        }
        if(msg.length > 0){
            this.showMsg(this.password_confirm, 'error', msg);
            return false;
        }
        return true;
    },
    
    chk_email : function(chk_remote){
        var msg = '';
        var v = this.email.val();
        if(!v.match(/^\w+([-+\.]\w+)*@\w+([-\.]\w+)*\.\w+([-\.]\w+)*$/)){
            msg = this.message.email.def;
        }
        
        if(msg.length > 0){
            this.showMsg(this.email, 'error', msg);
            return false;
        }
        
        // ajax chk
        var _this = this;
        var flag = true;
        
        if(true)
            $.post(
                chkf.url, 
                {'do' : 'chkemail',  value : this.email.val()},
                function(rs){
                    if(rs == '1'){
                        _this.showMsg(_this.email, 'error', _this.message.email.exist);
                        flag = false;
                    }else if(rs == '2'){
                        _this.showMsg(_this.email, 'ok');
                        flag = true;
                    }else{
                        flag = false;
                    }
                    _this.rchk_email = flag;
                }
            );
        
        return flag;
    },
    
    chk_vcode : function(){
        if(this.vcode.val().length != 4){
            this.showMsg(this.vcode, 'error', this.message.vcode.def);
            return false;
        }
        return true;
    },
    
    chk_company : function(){
        var msg = '';
        var v = this.company.val();
        if(v.length < 2){
            msg = this.message.company.len;
        }
        
        if(v.length > 50){
            msg = this.message.company.len_max;
        }
        
        if(msg.length > 0){
            this.showMsg(this.company, 'error', msg);
            return false;
        }
        
        return true;
    },
    
    chk_linkname : function(){
        var msg = '';
        var v = this.linkname.val();
        if(v.length < 2 || v.length > 20){
            msg = this.message.linkname.def;
        }
        
        if(msg.length > 0){
            this.showMsg(this.linkname, 'error', msg);
            return false;
        }
        
        return true;
    },
    
    chk_phone : function(){
        var msg = '';
        var v = this.phone.val();
        if(v.length < 7 || v.length > 20){
            msg = this.message.phone.def;
        }
        
        if(msg.length > 0){
            this.showMsg(this.phone, 'error', msg);
            return false;
        }

        return true;
    },
    
    chk_mphone : function(){
        var msg = '';
        var v = this.mphone.val();
        if(!v.match(/^\d{11}$/)){
            msg = this.message.mphone.def;
        } 
		if(msg.length > 0){
            this.showMsg(this.mphone, 'error', msg);
            return false;
        }

        var _this = this;
        var flag = true;
        if(true)
            $.post(
                chkf.url,
                {'do' : 'chkmphone', value : this.mphone.val()},
                function(rs){
                    if(rs == '1'){
                        _this.showMsg(_this.mphone, 'error', _this.message.mphone.exist);
                        flag = false;
                    }else if(rs == '2'){
                        _this.showMsg(_this.mphone, 'ok');
                        flag = true;
                    }else{
                        flag = false;
                    }
                    _this.rchk_user = flag;
                }
            );

        return flag;
    },
	chk_isAgree : function(){
        var msg = '';
        var v = this.isAgree[0].checked; 
        if(!v){
            msg = this.message.isAgree.def; 
        } 
		if(msg.length > 0){
            this.showMsg(this.isAgree, 'error', msg);
            return false;
        }
        
        return true;
    },
    
    showMsg : function(field, type, msg){
        var stylename = this.stylenames[type];
        if(!stylename){
            stylename = this.stylenames.normal;
        }
        
        var c = field.parent().next().children('div:first-child');
        if(c.size() == 0){
            field.parent().next().append('<div><span></span><div></div></div>');
            c = field.parent().next().children('div:first-child');
        }
        
        c.show();
        c.attr('class', stylename);
        if(type == 'ok'){
            msg = '';
            c.children('div').hide();
        }else{
            if(type == 'error' && !this.errorFocus){
                this.errorFocus = field;
            }
            
            c.children('div').show();
            c.children('div').html(msg);
        }
    },
    
    hideMsg : function(field){
        field.parent().next().children('div:first-child').hide();
    }
}