﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="SiteOption.aspx.cs" EnableEventValidation="false" Inherits="PowerEasy.Module.General.WebSite.Admin.Configuration.SiteOptionUI"
    Title="网站参数配置" ValidateRequest="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>网站参数配置</strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 45%">
                <strong>后台管理目录：</strong><br />
                为了安全，您可以在此修改后台管理目录名称，<br />
                为空时默认为Admin，实际文件夹名不需更改。<br />
                <span style="color: #FF0000">注意：目录名只能以字母、数字及下划线组成，<br />
                    目录名不能设置为常用值如Admin、PowerEasy等以免被猜出。</span>
            </td>
            <td>
                <asp:TextBox ID="TxtManageDir" Text="Admin" MaxLength="20" TextMode="singleLine"
                    runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="ValeManageDir" runat="server" ControlToValidate="TxtManageDir"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
                <asp:RequiredFieldValidator ID="ValrManageDir" runat="server" ErrorMessage="请输入后台管理目录名"
                    ControlToValidate="TxtManageDir"></asp:RequiredFieldValidator>
                <asp:HiddenField ID="HdnManageDir" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员身份验证票过期时间：</strong><br />
                管理员登录后台后，在不操作的情况下自动保持登录状态的时间设置。<br />
                <span style="color: #FF0000">注意：如果为0则在当前浏览器保持登录状态。<br />
                    修改管理员身份验证票过期时间，必须在下次登录后台才能生效。 </span>
            </td>
            <td>
                <asp:TextBox ID="TxtTicketTime" runat="server" MaxLength="6" Columns="5"></asp:TextBox>&nbsp;分钟<pe:RegexValidator
                    ValidateType="Number" ID="NumberValidator3" ControlToValidate="TxtTicketTime"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <%--<tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用后台管理认证码：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableSiteManageCode" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="True" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>--%>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>后台管理认证码：</strong><br />
                <asp:Label ID="LblNotes" runat="server" Text="该后台管理认证码还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label><br />
                <span style="color: #FF0000">注意：后台管理认证码不能设置为常用值如8888、9999等以免被猜出。</span>
            </td>
            <td>
                <asp:TextBox ID="TxtSiteManageCode" runat="server" MaxLength="20"></asp:TextBox>
                <asp:RequiredFieldValidator ID="ValrSiteManageCode" runat="server" ErrorMessage="请输入后台管理认证码"
                    ControlToValidate="TxtSiteManageCode"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>升级程序验证码：</strong><br />
                <asp:Label ID="LblUpdateCodeNotes" runat="server" Text="该升级程序验证码还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label>
            </td>
            <td>
                <asp:TextBox ID="TxtUpgradeIdentifyingCode" runat="server" MaxLength="20"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员密码哈希值：</strong><br />
                用于验证管理员密码数据的有效性，防止被非法方式修改。<br />
                <span style="color: #FF0000">注意：哈希值不能设置为常用值如Admin、PowerEasy等以免被猜出。</span>
            </td>
            <td>
                <asp:TextBox ID="TxtSiteHashCode" runat="server" MaxLength="20"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员登录后台是否同时将前台关联用户登录：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminIsLoginUser" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员退出后台是否同时将前台关联用户退出：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminIsLogoutUser" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <%--<tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用强密码策略：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminPwdStrongCheck" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>--%>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>验证码开启阈值：</strong><br />
                在管理员锁定阈值不为0情况下，验证码开启阈值必须少于或等于管理员锁定阈值,可用范围从0到999。
            </td>
            <td>
                <asp:TextBox ID="TextBoxValidCodeAppearThreshold" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" ControlToValidate="TextBoxValidCodeAppearThreshold"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员锁定时间：</strong><br />
                此安全设置确定锁定管理员在自动解锁之前保持锁定的分钟数。可用范围从 0 到 99,999 分钟。如果将管理员锁定时间设置为 0，该帐户将一直被锁定直到管理员明确解除对它的锁定。如果定义了管理员锁定阈值，则管理员锁定时间必须大于或等于重置时间。
            </td>
            <td>
                <asp:TextBox ID="TextBoxAdministratorLockoutDuration" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator5" runat="server" ControlToValidate="TextBoxAdministratorLockoutDuration"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
                <asp:RangeValidator ID="RangeValidator2" runat="server"
                    ErrorMessage="管理员锁定时间不在规定范围内！" ControlToValidate="TextBoxAdministratorLockoutDuration" MaximumValue="99999"
                    MinimumValue="0" Type="Integer"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员锁定阈值：</strong><br />
                此安全设置确定导致管理员帐户被锁定的登录尝试失败的次数。在重置锁定帐户或帐户锁定时间期满之前，无法使用该锁定帐户。可以将登录尝试失败次数设置为介于 0 和 999 之间的值。如果将值设置为 0，则永远不会锁定帐户。
            </td>
            <td>
                <asp:TextBox ID="TextBoxAdministratorLockoutThreshold" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator6" runat="server" ControlToValidate="TextBoxAdministratorLockoutThreshold"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
                <asp:RangeValidator ID="RangeValidator1" runat="server"
                    ErrorMessage="管理员锁定阈值不在规定范围内！" ControlToValidate="TextBoxAdministratorLockoutThreshold" MaximumValue="999"
                    MinimumValue="0" Type="Integer"></asp:RangeValidator>

            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>重置管理员锁定计数器：</strong><br />
                在管理员锁定阈值不为零情况下才有效，此重置管理员锁定计数器必须小于或等于管理员锁定时间。管理员一旦超过该时间后登录则错误次数清零。可用范围从 1 到 99,999 分钟。
            </td>
            <td>
                <asp:TextBox ID="TextBoxResetAdministratorLockoutDuration" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator7" runat="server" ControlToValidate="TextBoxResetAdministratorLockoutDuration"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
                <asp:RangeValidator ID="RangeValidator3" runat="server"
                    ErrorMessage="重置管理员锁定计数器不在规定范围内！" ControlToValidate="TextBoxResetAdministratorLockoutDuration" MaximumValue="99999"
                    MinimumValue="1" Type="Integer"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 45%">
                <strong>选择前台语言种类</strong>
            </td>
            <td>
                <asp:CheckBoxList ID="CblCultureName" runat="server" RepeatDirection="Horizontal"
                    onclick="SetDropCultureName(this)">
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台默认语言：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropCultureName" runat="server" onChange="SetHdnCultureName(this);">
                </asp:DropDownList>
                <span id="CultureName" style="display: none">中文(中国) [zh-CN] (默认)</span>
                <asp:HiddenField ID="HdnCultureName" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否使用软键盘输入密码：</strong><br />
                若选择是，则管理员登录后台时使用软键盘输入密码，适合网吧等场所上网使用。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableSoftKey" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站根域名：</strong><br />
                在启用子域名单点登录的情况下，必须要设置此值。
            </td>
            <td>
                <asp:TextBox ID="TxtMainDomain" runat="server" Width="150px"></asp:TextBox>
                <br />
                例如：如果你的网址是http://www.powereasy.net，那么这里就要填写 <span style="color: #FF0000"><strong>powereasy.net</strong></span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启动移动设备检测：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableMobile" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否对数据库连接字符串加密：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlConnProtecte" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" id="EnablePointMoneyExp" runat="server">
            <td class="tdbgleft">
                <strong>是否启用点券、金额、积分、有效期功能：</strong><br />
                <span style="color: #FF0000">注意：此功能仅限于 “CMS模块”</span>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnablePointMoneyExp" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true" Selected="True">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站广告目录：</strong><br />
                为了不让广告拦截软件拦截网站的广告，<br />
                您可以修改广告JS的存放目录（默认为IAA），改过以后，需要再设置此处
            </td>
            <td>
                <asp:TextBox ID="TxtADDir" Text="IAA" MaxLength="20" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrADDir" runat="server" ControlToValidate="TxtADDir" ErrorMessage="请输入网站广告目录"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TxtADDir"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站生成目录：</strong><br />
                <span style="color: #FF0000">注意：如果生成在根目录下，请保留为空！</span>
            </td>
            <td>
                <asp:TextBox ID="TxtCreateHtmlPath" Text="html" MaxLength="20" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="TxtCreateHtmlPath"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9/]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>内嵌代码生成路径：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtIncludeFilePath" Text="Include" MaxLength="20" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtIncludeFilePath" ErrorMessage="请输入内嵌代码生成路径"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator4" runat="server" ControlToValidate="TxtIncludeFilePath"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站模板目录：</strong><br />
                为防止他人猜测到模板存放地址，请修改此处配置并手动修改模板所在目录的目录名与之对应。<br />
                为了方便管理，请把网站模板目录放在~/Template/下面（即必须以~/Template/开头）<br />
                <asp:Label ID="LblTemplateNotes" runat="server" Text="该网站模板目录还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label>
            </td>
            <td>
                <asp:TextBox ID="TxtTemplateDir" Text="#Template" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrTemplateDir" runat="server" ControlToValidate="TxtTemplateDir" ErrorMessage="请输入网站模板目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>布局模板目录：</strong><br />
                为了方便管理，请把布局模板目录放在~/Template/下面（即必须以~/Template/开头）<br />
            </td>
            <td>
                <asp:TextBox ID="TxtLayoutDir" Text="Layout" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrLayoutDir" runat="server" ControlToValidate="TxtLayoutDir" ErrorMessage="请输入布局模板目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>标签库目录：</strong><br />
                标签库目录必须配置成上面模板根目录下的目录。如“标签库”<br />
                为了方便管理，请把标签库目录放在~/Template/下面（即必须以~/Template/开头）<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtLabelDirConfig" Text="标签库" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrLabelDirConfig" runat="server" ControlToValidate="TxtLabelDirConfig" ErrorMessage="请输入标签库目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>分页标签库目录：</strong><br />
                为了方便管理，请把分页标签库目录放在~/Template/下面（即必须以~/Template/开头）<br />
                分页标签库目录必须配置成上面模板根目录下的目录。如“分页标签库”<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtPagerLabelDirConfig" Text="分页标签库" Columns="40" MaxLength="40"
                    runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrPagerLabelDirConfig" runat="server" ControlToValidate="TxtPagerLabelDirConfig" ErrorMessage="请输入分页标签库目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>代码片断库目录：</strong><br />
                为了方便管理，请把代码片断库目录放在~/Template/下面（即必须以~/Template/开头）<br />
                代码片断库目录必须配置成上面模板根目录下的目录。如“代码片断库”<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtCodeSnippetDirConfig" Text="代码片断库" Columns="40" MaxLength="40"
                    runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrCodeSnippetDirConfig" runat="server" ControlToValidate="TxtCodeSnippetDirConfig" ErrorMessage="请输入代码片断库目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台模板风格目录：</strong><br />
                为了方便管理，请把前台模板风格目录放在~/Template/下面（即必须以~/Template/开头）<br />
                前台模板风格目录对应网站根目录下的Skin目录下的文件夹。<br />
                在模板中使用<span style="color: Blue">{PE.SiteConfig.SkinPath/}</span>来表示。
            </td>
            <td>
                <asp:TextBox ID="TxtSkinDirConfig" Text="Default" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrSkinDirConfig" runat="server" ControlToValidate="TxtPagerLabelDirConfig" ErrorMessage="请输入前台模板风格目录"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用内容自动签收：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlIsAutoSignin" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>自动签收内容时间：</strong><br />
                单位：秒。启用自动签收后，此设置才起作用。
            </td>
            <td>
                <asp:TextBox ID="TxtAutoSigninTime" Text="10" MaxLength="20" runat="server"></asp:TextBox><pe:RegexValidator
                    ValidateType="Number" ID="NumValTxtAutoSigninTime" ControlToValidate="TxtAutoSigninTime"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>防刷新队列长度：</strong><br />
                队列长度越长，防止用户恶意刷新提交重复表单越有效。
            </td>
            <td>
                <asp:TextBox ID="TxtRefreshQueueSize" Text="10" MaxLength="20" runat="server"></asp:TextBox><pe:RegexValidator
                    ValidateType="Number" ID="NumValTxtRefreshQueueSize" ControlToValidate="TxtRefreshQueueSize"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>采集休眠时间：</strong><br />
                每采集5篇信息服务器强制休眠指定秒数，不休眠可以填写0。
            </td>
            <td>
                <asp:TextBox ID="TxtCollectionSleep" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="ValgCollectionSleep" runat="server" ControlToValidate="TxtCollectionSleep"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用防恶意刷新点击数功能：</strong><br />
                启用此功能后同一用户每刷新一次并不会增加点击数，只有重新打开浏览器才会被统计到。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableRefreshHits" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否记录新增的搜索关键字：</strong><br />
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableAddNewKeyword" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台搜索关键字过滤规则：</strong><br />
                多个关键字请用“|”隔开，包含任意关键字的搜索都不会记录新增，以免出现记录无用关键字的情况
            </td>
            <td>
                <asp:TextBox ID="TxtUserKeywordFilter" runat="server" Width="400px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否提示版本升级通知：</strong><br />
                启用此功能，有新版本发布时，后台将会弹出版本升级通知。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlIsCheckNewVersion" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站当前状态：</strong><br />
                维护期间可设置关闭状态
            </td>
            <td>
                <asp:RadioButtonList ID="RadSiteStatus" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">打开</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">关闭</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>邮件确认模板管理：</strong><br />
                标签含义：<br />
                {$ConfirmSubscribeEmail}：订阅
            </td>
            <td>
                <pe:UEditor ID="TxtConfirmSubscribeEmail" runat="server" Toolbar="Basic" Width="80%"
                    Height="200px">
                </pe:UEditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>邮件退订模板管理：</strong><br />
                标签含义：<br />
                {$UnsubscribeEmail}：退订
            </td>
            <td>
                <pe:UEditor ID="TxtUnsubscribeEmail" runat="server" Toolbar="Basic" Width="80%"
                    Height="200px">
                </pe:UEditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>维护说明：</strong><br />
                在网站关闭状态下显示，支持html语法
            </td>
            <td>
                <asp:TextBox ID="TxtSiteMaintainDescription" TextMode="MultiLine" runat="server"
                    Height="80px" Width="400px"></asp:TextBox>
            </td>
        </tr>
        <asp:Panel ID="PanGov" runat="server" Visible="false">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否启用信息录入责任勾选提示：</strong><br />
                    勾选后在内容信息、信息公开录入页面需勾选责任提示才可以保存信息
                </td>
                <td>
                    <asp:RadioButtonList ID="RadlEnableEditorDuty" runat="server" RepeatDirection="Horizontal"
                        RepeatLayout="Flow">
                        <asp:ListItem Value="true">启用</asp:ListItem>
                        <asp:ListItem Selected="True" Value="false">不启用</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>信息录入责任勾选提示内容：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtEditorDutyInfo" runat="server" Width="400px"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtEditorDutyInfo" ErrorMessage="信息录入责任勾选提示内容"></pe:RequiredFieldValidator>
                </td>
            </tr>
        </asp:Panel>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站服务器前端的防护设备的回源IP清单：</strong><br />
                请填写放置在网站服务器的前端的Nginx、负载均衡、WAF、云防护等设备的回源IP清单（回源IP的定义请自行百度）。一行填写一个IP地址，支持IP地址最后一段使用“*”号配置整个网段，如“192.168.1.1 - 192.168.1.255”可配置为：“192.168.1.*”。请将所有的回源IP都填写在这里，不要遗漏，否则可能会得不到访问者的真实IP，并影响CC攻击防护等模块的防护效果，造成误判。
            </td>
            <td>
                <asp:TextBox ID="TxtProtectiveEquipmentSourceIpList" TextMode="MultiLine" runat="server"
                    Height="80px" Width="400px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存设置" OnClick="BtnSubmit_Click" OnClientClick="return doValidate();" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        var url = "<%=BasePath %><%=PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir %>/Configuration/SiteOption.aspx";
        function doValidate() {
            //验证码开启阈值：
            //在管理员锁定阈值不为0情况下，验证码开启阈值必须少于或等于管理员锁定阈值。
            var validCodeAppearThreshold = parseInt(document.getElementById('<%=TextBoxValidCodeAppearThreshold.ClientID %>').value);
            //管理员锁定时间：
            //此安全设置确定锁定管理员在自动解锁之前保持锁定的分钟数。可用范围从 0 到 99,999 分钟。如果将管理员锁定时间设置为 0，该帐户将一直被锁定直到管理员明确解除对它的锁定。如果定义了管理员锁定阈值，则管理员锁定时间必须大于或等于重置时间。
            var administratorLockoutDuration = parseInt(document.getElementById('<%=TextBoxAdministratorLockoutDuration.ClientID %>').value);
            //管理员锁定阈值：
            //此安全设置确定导致管理员帐户被锁定的登录尝试失败的次数。在重置锁定帐户或帐户锁定时间期满之前，无法使用该锁定帐户。可以将登录尝试失败次数设置为介于 0 和 999 之间的值。如果将值设置为 0，则永远不会锁定帐户。
            var administratorLockoutThreshold = parseInt(document.getElementById('<%=TextBoxAdministratorLockoutThreshold.ClientID %>').value);
            //重置管理员锁定计数器：
            //在管理员锁定阈值不为零情况下才有效，此重置管理员锁定计数器必须小于或等于管理员锁定时间。管理员一旦超过该时间后登录则错误次数清零。
            var resetAdministratorLockoutDuration = parseInt(document.getElementById('<%=TextBoxResetAdministratorLockoutDuration.ClientID %>').value);
            var res = true;
            if (administratorLockoutThreshold > 0) {
                if (validCodeAppearThreshold > administratorLockoutThreshold) {
                    res = false;
                    alert("在管理员锁定阈值不为0情况下，验证码开启阈值必须少于或等于管理员锁定阈值。");
                }
            }
            if (administratorLockoutThreshold > 0) {
                if (administratorLockoutDuration < resetAdministratorLockoutDuration) {
                    res = false;
                    alert("管理员锁定时间必须大于或等于重置时间。");
                }
            }
            if (!ValidatePopular("ManageDir")) {
                document.getElementById('<%=TxtManageDir.ClientID %>').focus()
                return false;
            }
            else if (!ValidatePopular("SiteManageCode")) {
                document.getElementById('<%=TxtSiteManageCode.ClientID %>').focus()
                return false;
            }
            else if (!ValidatePopular("SiteHashCode")) {
                document.getElementById('<%=TxtSiteHashCode.ClientID %>').focus()
                    return false;
                }
        return res;
    }

    function SetDropCultureName(object) {
        var tDropDownList = document.getElementById('<%=DropCultureName.ClientID %>');
        var chkInput = object.getElementsByTagName("INPUT");
        var chkLable = object.getElementsByTagName("Label");
        for (var i = 0; i < chkInput.length; i++) {
            if (chkInput[i].checked) {
                var content = chkLable[i].innerHTML;
                var isIn = false;
                for (var j = 0; j < tDropDownList.options.length; j++) {
                    if (content == tDropDownList.options[j].text) {
                        isIn = true;
                        break;
                    }
                }
                if (!isIn) {
                    var opt = document.createElement("option");
                    opt.value = content;
                    opt.text = content;
                    tDropDownList.options.add(opt);
                }
            }
            else {
                var content = chkLable[i].innerHTML;
                for (var j = 0; j < tDropDownList.options.length; j++) {
                    if (content == tDropDownList.options[j].text) {
                        tDropDownList.options[j] = null;
                        break;
                    }
                }
            }
        }
        SetHdnCultureName(tDropDownList)
    }

    function SetHdnCultureName(object) {
        if (object.selectedIndex == 0) {
            var hdnCultureName = document.getElementById(object.id).options[object.selectedIndex].text + ",";
            for (var j = 0; j < object.options.length; j++) {
                if (hdnCultureName.indexOf(object.options[j].text) < 0) {
                    hdnCultureName += object.options[j].text + ",";
                }
            }
            document.getElementById('<%=HdnCultureName.ClientID %>').value = hdnCultureName.substr(0, hdnCultureName.length - 1);
            }
            IsShowCultureName(object);
        }

        function IsShowCultureName(object) {
            if (object.selectedIndex < 0) {
                document.getElementById('<%=DropCultureName.ClientID %>').style.display = "none";
                document.getElementById("CultureName").style.display = "block";
            }
            else {
                document.getElementById('<%=DropCultureName.ClientID %>').style.display = "block";
                document.getElementById("CultureName").style.display = "none";
            }
        }
        IsShowCultureName(document.getElementById('<%=DropCultureName.ClientID %>'));

        function ValidatePopular(type) {
            var value = "";
            if (type == "ManageDir") {
                value = document.getElementById('<%=TxtManageDir.ClientID %>').value;
            }
            else if (type == "SiteManageCode") {
                value = document.getElementById('<%=TxtSiteManageCode.ClientID %>').value;
            }
            else if (type == "SiteHashCode") {
                value = document.getElementById('<%=TxtSiteHashCode.ClientID %>').value;
            }
    var status = "err";
    $.ajax({
        type: "POST",
        async: false,
        dataType: "xml",
        url: url,
        data: "AsyncAction=Validate" + type + "&Value=" + value,
        success: function (xml) {
            status = jQuery(xml).find("status").text();
            var msg = jQuery(xml).find("msg").text();
            if (status != "ok") {
                alert(msg);
            }
        }
    });

    if (status == "ok") {
        return true;
    }
    else {
        return false;
    }
}
    </script>
</asp:Content>
