﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="ContentImport.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.ContentImport"
    ValidateRequest="false" Title="导入信息" %>
    
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <div style="padding-top: 5px;">
        <asp:Wizard ID="WzdProductImport" Font-Names="Verdana" Font-Size="0.8em" runat="server"
            DisplaySideBar="False" Width="100%" ActiveStepIndex="0" OnFinishButtonClick="WzdContentImport_FinishButtonClick"
            OnNextButtonClick="WzdContentImport_NextButtonClick" FinishCompleteButtonText=" 完 成 "
            CancelButtonText=" 取 消 ">
            <WizardSteps>
                <asp:WizardStep ID="WizardStep1" runat="server" Title="Step 1">
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                        <tr align="center">
                            <td colspan="2" class="title" style="height: 19px">
                                <b>信息批量导入（Excel文件选择）</b>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 30%">
                                <strong>所属节点&nbsp;：&nbsp;</strong>
                            </td>
                            <td>
                                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                                    <ContentTemplate>
                                        <asp:DropDownList ID="DropContentNodeList" runat="server" DataTextField="NodeName"
                                            DataValueField="NodeId" AutoPostBack="True" OnSelectedIndexChanged="DropContentNodeList_SelectedIndexChanged">
                                        </asp:DropDownList>
                                        &nbsp;<strong> 所属模型&nbsp;：&nbsp;</strong><asp:DropDownList ID="DropModelList" runat="server"
                                            DataTextField="ModelName" DataValueField="ModelId">
                                        </asp:DropDownList>
                                        <pe:RequiredFieldValidator ID="ValrNodeList" ControlToValidate="DropContentNodeList"
                                            runat="server" ErrorMessage="所属栏目不能为空" RequiredText="" Display="Dynamic"></pe:RequiredFieldValidator>
                                        <pe:RequiredFieldValidator ID="ValrModelName" ControlToValidate="DropModelList" runat="server"
                                            ErrorMessage="所属模型不能为空" RequiredText="" Display="Dynamic"></pe:RequiredFieldValidator>
                                    </ContentTemplate>
                                </asp:UpdatePanel>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 30%">
                                <strong>所属专题&nbsp;：&nbsp;</strong>
                            </td>
                            <td>
                                <pec:SpecialType ID="SpecialType1" FieldAlias="所属专题" runat="server" />
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" style="width: 30%;" class="tdbgleft">
                                <b>选择要导入的数据文件&nbsp;：&nbsp;</b>
                            </td>
                            <td>
                                <asp:FileUpload ID="UpExcellFile" runat="server" Width="400px" />
                                <pe:RequiredFieldValidator ID="ValrExcellFile" ControlToValidate="UpExcellFile" runat="server"
                                    ErrorMessage="请选择你要上传的文件！" RequiredText="" Display="Dynamic"></pe:RequiredFieldValidator>
                            </td>
                        </tr>
                    </table>
                </asp:WizardStep>
                <asp:WizardStep ID="WizardStep2" runat="server" Title="Step 2">
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                        <tr align="center">
                            <td colspan="2" class="title">
                                <b>信息批量导入（选择导入项）</b>
                            </td>
                        </tr>
                        <asp:Repeater ID="RepeaterExcelFields" runat="server" OnItemDataBound="RepeaterExcelFields_ItemDataBound">
                            <ItemTemplate>
                                <tr id="Tr1" class="tdbg" runat="server">
                                    <td align="right" style="width: 50%;" class="tdbgleft">
                                        <asp:DropDownList ID="DropExcelFields" runat="server">
                                        </asp:DropDownList>
                                        &nbsp;&nbsp;==>&nbsp;&nbsp;
                                    </td>
                                    <td>
                                        &nbsp;&nbsp;&nbsp;<pe:ExtendedLiteral HtmlEncode="false" ID="LiteralTableField" runat="server"></pe:ExtendedLiteral>
                                        <pe:ExtendedLiteral HtmlEncode="false" ID="LiteralShowNotes" runat="server"></pe:ExtendedLiteral>
                                        <asp:HiddenField ID="HdnFieldName" runat="server" />
                                        <asp:HiddenField ID="HdnFieldType" runat="server" />
                                        <asp:HiddenField ID="HdnFieldLevel" runat="server" />
                                        <asp:HiddenField ID="HdnEnableNull" runat="server" />
                                        <asp:HiddenField ID="HdnFieldTemp" runat="server" />
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                </asp:WizardStep>
            </WizardSteps>
            <StartNavigationTemplate>
                <center>
                    <br />
                    <asp:Button ID="StartNextButton" runat="server" CommandName="MoveNext" Text="下一步" /></center>
            </StartNavigationTemplate>
            <FinishNavigationTemplate>
                <center>
                    <br />
                    <asp:Button ID="StartPreButton" runat="server" CommandName="MovePrevious" Text="上一步" />
                    <asp:Button ID="FinishButton" runat="server" CommandName="MoveComplete" Text="导入" /></center>
            </FinishNavigationTemplate>
        </asp:Wizard>
        <div id="prompt-note">
	        <dl>
	        <dt class="prompt-note-tit">
	        <span>温馨提醒</span>
	        </dt>
	        <dd class="prompt-note-con">
		        <li>导入前先<a style="color: Blue; text-decoration: underline;" href="../../Admin/Contents/Contents.xls">点此下载模板文件</a>。</li>
                <li>模板文件中的红色字体为必填项，并注意字段上的批注！</li>
                <li>由于批量导入操作比较占用资源，请不要上传过大的文件，建议在服务器访问人数少时进行！</li>
	        </dd>  
	        </dl>
        </div>
    </div>
</asp:Content>
