﻿<%@ Page Title="会员浏览统计" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="UserHitStatistics.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.UserHitStatistics" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td>
                <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
            </td>
            <td align="right">
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SmContent" runat="server" ScriptMode="Release" EnablePartialRendering="true">
    </asp:ScriptManager>
    <link href="<%=BasePath %>JS/FixedHeaderTable/DefaultTheme.css" rel="stylesheet" media="screen" />
    <style type="text/css">
        #DivUser table tr td {
            text-align: left;
            padding-left: 50px;
        }

        .item-user {
            width: 120px;
            float: left;
        }
        
    </style>
    <style type="text/css">
        .fancyTable {
            width: auto;
        }

        .myTableWrapper {
            width: 800px;
            height: 500px;
        }

        .div-statistics {
            /* height: 500px;*/
            overflow-x: auto;
            overflow-y: auto;
        }

        .fancyTable td, .fancyTable th {
            /* appearance */
            border: 1px solid #778899;
            /* size */
            padding: 5px;
        }
        .fancyTable th {
            white-space: nowrap;
        }

        .fancyTable td .user-hits {
            cursor: pointer;
        }

    </style>
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
            <tr align="center">
                <td colspan="2" class="spacingtitle">会员浏览统计
                </td>
            </tr>

            <tr class="tdbgbottom">
                <td colspan="2">
                    <div id="DivUserGroup">
                    </div>
                    <div id="DivUser">
                    </div>

                </td>
            </tr>
        <tr class="tdbg">
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft" align="right" style="width: 30%">
                    <strong>指定文章ID：</strong>
                </td>
                <td class="tdbg" align="left">
                    <asp:TextBox ID="TxtGeneralIds" runat="server" Width="200px" Height="50px" TextMode="MultiLine"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbgbottom">
                <td colspan="2">
                    <input type="button" class="inputbutton" id="BtnStatistics" onclick="Statistics()" value="查询统计" />
                </td>
            </tr>
        </table>
        <asp:HiddenField runat="server" ID="HdnUserGroup" />
        <asp:HiddenField runat="server" ID="HdnUser" />
        <div id="DivResult" class="div-statistics">
        </div>
        <script type="text/javascript" src="<%=BasePath %>JS/jquery.peex.js"></script>
        <script type="text/javascript" src="<%=BasePath %>JS/FixedHeaderTable/jquery.fixedheadertable.js"></script>
        <script type="text/javascript">
            //处理用户列表--Start

            function InitUserGroup() {
                var userGroupList = jQuery.pe.stringToJSON($("#<%=HdnUserGroup.ClientID%>").val());
                var html = '<table width="100%" border="0" cellpadding="2" cellspacing="0" class="border">';
                html += '<tbody>';
                html += '<tr class="title" >';
                html += '<td align="left"><span><a href="javascript:void(0)" groupId=\"0\">全部用户</a> </span>';
                for (var i = 0; i < userGroupList.length; i++) {
                    if (userGroupList[i].GroupId > 0) {
                        html += '<span>| <a href="javascript:void(0)" groupId="' + userGroupList[i].GroupId + '">' + userGroupList[i].GroupName + '</a> </span>';
                    }
                }
                html += "</td></tr>";
                html += '</tbody>';
                html += "</table>";
                $("#DivUserGroup").html(html);
            }

            var userList = jQuery.pe.stringToJSON($("#<%=HdnUser.ClientID%>").val());
            var dicUser = [];//用户信息字典
            for (var i = 0; i < userList.length; i++) {
                var key = userList[i].UserId.toString();
                dicUser[key] = userList[i];
            }

            function RenderUserList(groupId) {
                var count = 0;
                var html = '<table width="100%" border="0" cellspacing="1" cellpadding="1" class="border">';
                html += '<tbody>';
                html += '<tr><td>';
                for (var i = 0; i < userList.length; i++) {
                    if (groupId == 0 || userList[i].GroupId == groupId) {
                        html += '<span class="item-user">';
                        html += '<input type="checkbox" id="User_' + userList[i].UserId + '" value="' + userList[i].UserId + '" groupId="' + userList[i].GroupId + '" ' + (userList[i].Checked == "true" ? "checked" : "") + '>';
                        html += '<label for="User_' + userList[i].UserId + '">' + userList[i].UserName + '</label>';
                        html += "</span>";
                        count++;
                    }
                }
                html += "</td></tr>";
                html += '</tbody>';
                html += "</table>";
                html += '<div><a href="javascript:void(0)" id="BtnCheckAll" groupId="' + groupId + '"><strong>选中以上所有用户</strong></a>&nbsp;<a href="javascript:void(0)" id="BtnUnCheckAll" groupId="' + groupId + '"><strong>取消以上所有用户</strong></a></div>';

                if (count == 0) {
                    html = '<div> 未找到任何用户！</div>';
                }

                var $DivUser = $("#DivUser");
                $DivUser.html(html);

                $DivUser.find(".item-user :checkbox").click(function () {
                    var $this = $(this);
                    var status = $this.is(":checked") ? "true" : "false";
                    SetUserStaus($this.val(), status);
                });
                $("#BtnCheckAll").click(function () {
                    $DivUser.find(".item-user :checkbox").not(":checked").each(function () {
                        var $this = $(this);
                        SetUserStaus($this.val(), "true");
                        $this.prop("checked", true);
                    });
                });
                $("#BtnUnCheckAll").click(function () {
                    $DivUser.find(".item-user :checkbox:checked").each(function () {
                        var $this = $(this);
                        SetUserStaus($this.val(), "false");
                        $this.prop("checked", false);
                    });
                });

            }

            function FindUserInfo(userId) {
                //for (var i = 0; i < userList.length; i++) {
                //    if (userList[i].UserId == userId) {
                //        return userList[i];
                //    }
                //}
                //return null;
                return dicUser[userId.toString()];
            }

            function SetUserStaus(userId, checked) {
                var userInfo = FindUserInfo(userId);
                if (userInfo != null) {
                    userInfo.Checked = checked;
                }
            }

            function GetCheckedUser() {
                var userNames = "";
                for (var i = 0; i < userList.length; i++) {
                    if (userList[i].Checked == "true") {
                        if (userNames != "") {
                            userNames += ",";
                        }
                        userNames += userList[i].UserName;
                    }
                }
                return userNames;
            }

            $(document).ready(function () {
                InitUserGroup();

                //绑定会员组点击事件
                var $userGroup = $("#DivUserGroup span a");
                $userGroup.click(function () {
                    var $this = $(this);
                    $("#DivUserGroup span a").attr("style", "");
                    $this.attr("style", "color:#ff6600;font-weight:bolder;");
                    RenderUserList(parseInt($this.attr("groupId")));
                });
                //if ($userGroup.length > 1) {
                //    $userGroup.eq(1).click();
                //} else {
                //    $userGroup.eq(0).click();
                //}
                $userGroup.eq(0).click();

            });

            //处理用户列表--End


            var currentClassName = '';
            function MouseOver(me, mouseOverCssClass) {
                currentClassName = me.className;
                me.className = mouseOverCssClass;
            }

            function MouseOut(me) {
                me.className = currentClassName;
            }

            function Statistics() {
                var generalIds = $("#<%=TxtGeneralIds.ClientID%>").val();
                var userNames = GetCheckedUser();
                if (userNames == "") {
                    alert("请选择用户！");
                    return;
                }
                var xmlData = "<?xml version='1.0' encoding='utf-8'?><root><type>getuserhitstatistics</type><usernames>" + userNames + "</usernames><generalIds>" + generalIds + "</generalIds></root>";
                jQuery.post("<%=BasePath %>ajax.aspx?HandlerName=UserHitStatisticsAjaxHandler", xmlData, function (data) {
                    var status = jQuery(data).find("status").text();
                    if (status == "ok") {
                        var headList = jQuery.pe.stringToJSON(jQuery(data).find("headList").text());
                        var rowList = jQuery.pe.stringToJSON(jQuery(data).find("rowList").text());
                        var dataList = jQuery.pe.stringToJSON(jQuery(data).find("dataList").text());

                        var html = "<table class=\"border fancyTable\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\" id=\"\" >";
                        //标题行
                        html += "<thead>";
                        html += '<tr class="gridtitle" align="center" style="height:25px;">';
                        html += '<th><span style="width: 200px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;标题&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></th>';
                        for (var i = 0; i < headList.length; i++) {
                            html += "<th>";
                            html += headList[i];
                            html += "</th>";
                        }
                        html += "</tr>";
                        html += "</thead>";
                        //数据行
                        html += "<tbody>";
                        for (var i = 0; i < rowList.length; i++) {
                            html += '<tr class="tdbg" align="center" onmouseover="MouseOver(this,&quot;tdbgmouseover&quot;)" onmouseout="MouseOut(this)">';
                            html += "<td>" + rowList[i].Title + "</td>";
                            for (var j = 0; j < headList.length; j++) {
                                html += "<td>";
                                var hitHistoryInfo = FindHitHistory(dataList, rowList[i].GeneralId, headList[j]);
                                if (hitHistoryInfo == null) {
                                    html += "0";
                                } else {
                                    html += '<span class="user-hits" title="上次浏览时间：' + hitHistoryInfo.LastHitTime + '">' + hitHistoryInfo.Hits + '</span>';
                                }

                                html += "</td>";
                            }
                            html += "</tr>";
                        }
                        html += "</tbody>";
                        html += "</table>";

                        var $DivResult = $("#DivResult");
                        $DivResult.html(html);

                        //计算统计结果表高度，最大不超过500，必须在冻结表格前设置
                        var divResultHeight = rowList.length * 30 + 50;
                        if (divResultHeight > 500) {
                            divResultHeight = 500;
                        }
                        $DivResult.height(divResultHeight);

                        //冻结表头和首列
                        $DivResult.find("table").fixedHeaderTable({ altClass: '', footer: true, fixedColumns: 1 });
                        $DivResult.find(".fht-fixed-column .fht-table tr").addClass("tdbg");//给冻结列追加样式

                    }
                });
            }

            function FindHitHistory(list, generalId, userName) {
                for (var i = 0; i < list.length; i++) {
                    if (list[i].GeneralID == generalId && list[i].UserName == userName) {
                        return list[i];
                    }
                }
                return null;
            }


        </script>
</asp:Content>

