﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="LiaisonInformation.ascx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Controls.Crm.LiaisonInformation" %>
<tr class="tdbg">
    <td style="width: 15%" rowspan="2" align="right" class="tdbgleft">
        <asp:Localize ID="Localize1" Text="通讯地址："
            runat="server" />
    </td>
    <td colspan="3" style="height: 23px" align="left">
        <pec:Region ID="Region1" runat="server" />
    </td>
</tr>
<tr class="tdbg">
    <td colspan="3">
        <table border="0" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;">
            <tr class="tdbg">
                <td style="width: 16%" align="right" class="tdbgleft">
                    <asp:Localize ID="Localize2" Text="联系地址："
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtAddress" Width="300px" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" class="tdbgleft">
                    <asp:Localize ID="Localize3" Text="邮政编码："
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtZipCode" runat="server"></asp:TextBox>
                    <pe:RegexValidator ValidateType="ZipCode" ID="VziptZipCode" ControlToValidate="TxtZipCode" SetFocusOnError="true"
                        Display="dynamic" runat="server"></pe:RegexValidator>
                </td>
            </tr>
        </table>
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize4" Text="办公电话："
            runat="server" />
    </td>
    <td style="width: 38%">
        <asp:TextBox ID="TxtOfficePhone" runat="server"></asp:TextBox>
        <asp:CustomValidator ID="VHaveLiaison" runat="server" ControlToValidate="TxtOfficePhone" Display="dynamic" 
            ClientValidationFunction="varLiaison" ErrorMessage="办公电话、移动电话、QQ、邮箱、MSN不能全为空！">
        </asp:CustomValidator>
        <pe:RegexValidator ValidateType="Mobile" ID="VtelOfficePhone" ControlToValidate="TxtOfficePhone" SetFocusOnError="true" 
            Display="dynamic" runat="server" ErrorMessage="填写的办公电话号码格式不正确"></pe:RegexValidator>
                 <asp:CustomValidator ID="VOfficePhone" runat="server" ControlToValidate="TxtOfficePhone" ClientValidationFunction="VarAjaxFun" ErrorMessage="办公电话已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>       
    </td>
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize6" Text="住宅电话："
            runat="server" />
    </td>
    <td style="width: 38%">
        <asp:TextBox ID="TxtHomePhone" runat="server"></asp:TextBox>
        <pe:RegexValidator ValidateType="Mobile" ID="VtelHomePhone" ErrorMessage="填写的住宅电话号码格式不正确" ControlToValidate="TxtHomePhone" SetFocusOnError="true"
            Display="dynamic" runat="server"></pe:RegexValidator>
         <asp:CustomValidator ID="VHomePhone" runat="server" ControlToValidate="TxtHomePhone" ClientValidationFunction="VarAjaxFun" ErrorMessage="住宅电话已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>    
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize8" Text="移动电话："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtMobile" runat="server"></asp:TextBox>
        <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ErrorMessage="填写的移动电话号码格式不正确" ControlToValidate="TxtMobile" SetFocusOnError="true"
            Display="dynamic" runat="server"></pe:RegexValidator>
         <asp:CustomValidator ID="VMobile" runat="server" ControlToValidate="TxtMobile" ClientValidationFunction="VarAjaxFun" ErrorMessage="移动电话已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>
    </td>
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize10" Text="传真号码："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtFax" runat="server"></asp:TextBox>
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize11" Text="小灵通："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtPHS" runat="server"></asp:TextBox>
    </td>
    <td class="tdbgleft" align="right">
    </td>
    <td>
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize12" Text="个人主页："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtHomepage" runat="server"></asp:TextBox>
        <%--                <asp:RegularExpressionValidator ID="regPersonHomePage" runat="server" ControlToValidate="TxtHomepage" Display="Dynamic" 
                                ErrorMessage="填写的URL地址格式不正确！" 
                                ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&amp;=]*)?"></asp:RegularExpressionValidator>--%>
                          <asp:CustomValidator ID="VHomepage" runat="server" ControlToValidate="TxtHomepage" ClientValidationFunction="VarAjaxFun" ErrorMessage="主页已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>          
    </td>
    <td class="tdbgleft" align="right">
        <asp:Localize ID="Localize14" Text=" Email地址："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtEmail" runat="server"></asp:TextBox>
        <pe:RegexValidator ValidateType="Email" ID="VmailEmail" ControlToValidate="TxtEmail" SetFocusOnError="true"
            Display="dynamic" runat="server"></pe:RegexValidator>
     <asp:CustomValidator ID="VEmail" runat="server" ControlToValidate="TxtEmail" ClientValidationFunction="VarAjaxFun" ErrorMessage="Email地址已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>  
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize15" Text="QQ号码："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtQQ" runat="server"></asp:TextBox>
                <pe:RegexValidator ValidateType="QQ" ID="VQQ" ControlToValidate="TxtQQ" SetFocusOnError="true"
                Display="dynamic" runat="server" ErrorMessage="填写的QQ号码格式不正确！"></pe:RegexValidator>
        <asp:CustomValidator ID="VxQQ" runat="server" ControlToValidate="TxtQQ" ClientValidationFunction="VarAjaxFun" ErrorMessage="QQ号码已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>  
    </td>
    <td class="tdbgleft" align="right">
        <asp:Localize ID="Localize17" Text="MSN帐号："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtMSN" runat="server"></asp:TextBox>
        <asp:CustomValidator ID="VMSN" runat="server" ControlToValidate="TxtMSN" ClientValidationFunction="VarAjaxFun" ErrorMessage="Msn号码已经存在，请勿重复添加！" SetFocusOnError="true">
         </asp:CustomValidator>                    
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize19" Text="ICQ号码："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtICQ" runat="server"></asp:TextBox>
    </td>
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize20" Text="雅虎通帐号："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtYahoo" runat="server"></asp:TextBox>
    </td>
</tr>
<tr class="tdbg">
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize21" Text="UC帐号："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtUC" runat="server"></asp:TextBox>
    </td>
    <td style="width: 15%" align="right" class="tdbgleft">
        <asp:Localize ID="Localize22" Text="Aim帐号："
            runat="server" />
    </td>
    <td>
        <asp:TextBox ID="TxtAim" runat="server"></asp:TextBox>
        <asp:HiddenField ID="HdnQQ" runat="server" />
        <asp:HiddenField ID="HdnEmail" runat="server" />
        <asp:HiddenField ID="HdnMsn" runat="server" />
        <asp:HiddenField ID="HdnHomepage" runat="server" />
        <asp:HiddenField ID="HdnMobile" runat="server" />
        <asp:HiddenField ID="HdnHomephone" runat="server" />
        <asp:HiddenField ID="HdnOfficePhone" runat="server" />
    </td>
</tr>

<script type="text/javascript">
    var validArray = [false, false, false, false, false, false, false];
    var haveliaison;
    $("#<%=TxtMobile.ClientID %>").blur(function () { CallbackToServer("$MP" + this.value); CheckLiaison(); });
    $("#<%=TxtQQ.ClientID %>").blur(function () { CallbackToServer("$QQ" + this.value); CheckLiaison(); });
    $("#<%=TxtEmail.ClientID %>").blur(function () { CallbackToServer("$Email" + this.value); CheckLiaison(); });
    $("#<%=TxtMSN.ClientID %>").blur(function () { CallbackToServer("$Msn" + this.value); CheckLiaison(); });
    $("#<%=TxtOfficePhone.ClientID %>").blur(function () { CallbackToServer("$OP" + this.value); CheckLiaison(); });
    $("#<%=TxtHomePhone.ClientID %>").blur(function() { CallbackToServer("$HP" + this.value); });
    $("#<%=TxtHomepage.ClientID %>").blur(function() { CallbackToServer("$Page" + this.value); });
    function CheckLiaison() {
        haveliaison = $("#<%=TxtMobile.ClientID %>").val() + $("#<%=TxtQQ.ClientID %>").val() + $("#<%=TxtEmail.ClientID %>").val() + $("#<%=TxtMSN.ClientID %>").val() + $("#<%=TxtOfficePhone.ClientID %>").val();
        if (haveliaison == "") {
            $("#<%=VHaveLiaison.ClientID %>").show().css("visibility", "visible");
            return false;
        }
        else {
            $("#<%=VHaveLiaison.ClientID %>").hide().css("visibility", "hidden");
            return true;
        }
    }
    function varLiaison(source, arguments) {
        Page_IsValid = false;
    }
    function VarAjaxFun(source, arguments) {
        var vid = source.id.substr(source.id.lastIndexOf('_') + 1);
        switch (vid) {
            case "VMobile":
                CallbackToServer("$MP" + this.value);
                arguments.IsValid = getValid(4);
                break;
            case "VxQQ":
                CallbackToServer("$QQ" + this.value);
                arguments.IsValid = getValid(0);
                break;
            case "VEmail":
                CallbackToServer("$Email" + this.value);
                arguments.IsValid = getValid(6);
                break;
            case "VMSN":
                CallbackToServer("$Msn" + this.value);
                arguments.IsValid = getValid(1);
                break;
            case "VOfficePhone":
                CallbackToServer("$OP" + this.value);
                arguments.IsValid = getValid(2);
                break;
            case "VHomePhone":
                CallbackToServer("$HP" + this.value);
                arguments.IsValid = getValid(3);
                break;
            case "VHomepage":
                CallbackToServer("$Page" + this.value);
                arguments.IsValid = getValid(5);
                break;

        }
    }

    function getValid(i) {
        return !validArray[i];
    } 
     
    function CallbackEventReference(arg, context) {
        var result = eval("(" + arg + ")");
        switch (result.name) {
            case "QQ":
                validArray[0] = result.value;
                if (result.value) {
                    $("#<%=VxQQ.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VxQQ.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "Msn":
                validArray[1] = result.value;
                if (result.value) {
                    $("#<%=VMSN.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VMSN.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "OP":
                validArray[2] = result.value;
                if (result.value) {
                    $("#<%=VOfficePhone.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VOfficePhone.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "HP":
                validArray[3] = result.value;
                if (result.value) {
                    $("#<%=VHomePhone.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VHomePhone.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "MP":
                validArray[4] = result.value;
                if (result.value) {
                    $("#<%=VMobile.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VMobile.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "Page":
                validArray[5] = result.value;
                if (result.value) {
                    $("#<%=VHomepage.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VHomepage.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            case "Email":
                validArray[6] = result.value;
                if (result.value) {
                    $("#<%=VEmail.ClientID %>").show().css("visibility", "visible");
                }
                else {
                    $("#<%=VEmail.ClientID %>").hide().css("visibility", "hidden");
                }
                break;
            default:
                break;
        }
    }

</script>

