﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CustomFormManage.aspx.cs"
    MasterPageFile="~/Admin/MasterPage.master" Title="自定义表单管理" Inherits="PowerEasy.Module.General.WebSite.Admin.CustomForm.CustomFormManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvModel" runat="server" AutoGenerateColumns="False" DataKeyNames="ModelID"
        DataSourceID="OdsModel" ItemName="表单" ItemUnit="个" SerialText="" OnRowCommand="EgvModel_RowCommand"
        RowDblclickBoundField="ModelID" RowDblclickUrl="CustomForm.aspx?Action=Modify&amp;ModelID={$Field}">
        <Columns>
            <pe:BoundField DataField="ModelID" HeaderText="ID">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu">
                        <pe:LinkMenuItem runat="server" IsChecked="true" ID="EahModelModify" Text="修改" OperateCode="CustomForm"
                            SkinID="Edit" NavigateUrl='<%# Eval("ModelId",BasePath + PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir + "/CustomForm/CustomForm.aspx?Action=Modify&ModelID={0}") %>'>
                        </pe:LinkMenuItem>
                        <pe:LinkMenuItem runat="server" IsChecked="true" ID="EahModelDelete" Text="删除" OperateCode="CustomForm"
                            onclick="return confirm('是否删除该模型？');" SkinID="Delete" NavigateUrl='<%#  AppendSecurityCode(BasePath + PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir +"/CustomForm/CustomFormManage.aspx?Action=Delete&ModelID=" + Eval("ModelID"))%>'>
                        </pe:LinkMenuItem>
                        <pe:LinkMenuItem runat="server" IsChecked="true" ID="EahFieldManage" Text="字段列表"
                            OperateCode="CustomForm" NavigateUrl='<%# BasePath + PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir + "/CommonModel/FieldManage.aspx?ModelType=7&ModelID=" + Eval("ModelID")+"&ModelName="+Server.UrlEncode(Eval("ModelName").ToString())%>'>
                        </pe:LinkMenuItem>
                        <pe:ButtonMenuItem ID="LnkCreateTemplate" runat="server" CommandName="CreateTemplate"
                            Text="生成表单布局模板" CommandArgument='<%#Eval("ModelID")%>'>
                        </pe:ButtonMenuItem>
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="图标">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <asp:Image ID="ImgItemIcon" runat="server" ImageUrl='<%#"~/Images/ModelIcon/" + (string.IsNullOrEmpty(Eval("ItemIcon").ToString())?"Default.gif":Eval("ItemIcon").ToString()) %>' />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="表单名称">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <a href='CustomForm.aspx?Action=Modify&ModelID=<%#Eval("ModelID") %>'>
                        <%# PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("ModelName").ToString()).Length <= 10 ? PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("ModelName")) : 
                                PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("ModelName").ToString()).Substring(0, 10) + ".."%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="表单描述">
                <ItemTemplate>
                    <%# PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("Description").ToString())%>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="项目名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# Eval("ItemName").ToString().Length <= 10 ? Eval("ItemName") : Eval("ItemName").ToString().Substring(0, 10) + ".."%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="TableName" HeaderText="表名" SortExpression="TableName">
                <HeaderStyle Width="10%" />
                <ItemStyle HorizontalAlign="Left" />
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <asp:ObjectDataSource ID="OdsModel" runat="server" SelectMethod="CustomFormModelList"
        TypeName="PowerEasy.Module.General.BusinessLogic.CommonModel.ModelManager" EnablePaging="False">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="showType" Type="int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        </dt>
        <dd class="prompt-note-con">说明：进行了添加字段、删除字段、进行显示设置时，需要对表单布局模板进行手动修改或重新生成表单布局模板，前台表单提交页面才有相应的变化。</dd>  
        </dl>
    </div>
</asp:Content>
