﻿<%@ Page Title="插件管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="PlugInManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.PlugIn.PlugInManage" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
   <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<script language="javascript">
    function Reboot()
    {
        $.ajax({
            type: 'Get',
            cache: false,
            url: 'PluginInstall.aspx?IsAjax=true&IsReboot=true',
            error: function(msg) { alert('Ajax请求出错！错误信息为：' + msg); },
            success: function(xml) {
            if ($('iserror', xml).text() == 'True') {
                alert('应用程序池重启失败！错误信息：' + $('msg', xml).text());         
                } else {
                alert('应用程序池重启成功！');
                }
            }
        });
    }
</script>
    <pe:ExtendedGridView ID="EgvPlugin" runat="server" AllowPaging="True" 
        AutoGenerateColumns="False" IsHoldState="True" SerialText="" 
        OnRowDataBound="EgvPlugin_OnRowDataBound"  OnRowCommand="EgvPlugin_RowCommand">
        <Columns>
            <asp:TemplateField HeaderText="插件名称">
                <ItemTemplate>   
                    <a href='<%# Eval("PluginUrl") %>' target="_blank"><%# Eval("PluginName") %></a>
                </ItemTemplate>
                <HeaderStyle Width="20%" />
            </asp:TemplateField>
            <pe:BoundField DataField="Version" HeaderText="插件版本">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="Description" HeaderText="插件描述">
                <HeaderStyle Width="35%" />
            </pe:BoundField>
            <pe:BoundField DataField="Author" HeaderText="插件作者">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="状态">
                <ItemTemplate>
                <pe:ExtendedLabel ID="LbIsActivity" runat="server" Text="未安装" HtmlEncode="false"></pe:ExtendedLabel>
                </ItemTemplate>
            <HeaderStyle Width="6%" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <asp:LinkButton ID="LbInstall" runat="server" CommandArgument='<%#Eval("PluginPath") %>' CommandName="Install">安装</asp:LinkButton>
                    <asp:LinkButton ID="LbUninstall" runat="server" CommandArgument='<%#Eval("PluginPath") %>' CommandName="Uninstall" OnClientClick="return confirm('此操作会将插件相关数据删除，确定要卸载吗？');">卸载</asp:LinkButton>
                    <asp:LinkButton ID="LbUpgrade" runat="server" CommandArgument='<%#Eval("PluginPath") %>' CommandName="Upgrade">升级</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <asp:Button ID="Button1" runat="server" Text="重启应用程序池" OnClientClick="Reboot()" />
    <div id="prompt-note">
	    <dl>
	    <dt class="prompt-note-tit">
	    <span>提示说明</span>
	    </dt>
	    <dd class="prompt-note-con">
	    <span style="COLOR: blue"><strong>注意：</strong></span>
	    <br />
	    当新安装服务类型插件时，可以点击 “重启应用程序池” 操作进行加载插件。卸载插件出错时或删除插件自带DLL文件出错时，也可以点击 “重启应用程序池” 操作后再重新操作。
	    <br />
	    当状态中出现 “版本不对应” 提示时，请下载对应版本的插件进行安装或升级操作。
	    </dd>  
	    </dl>
    </div>
</asp:Content>
