﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="AccountManage.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.AccountManage"
    Title="推广会员管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvUserAccount" runat="server" AutoGenerateColumns="False"
        ItemName="推广会员" ItemUnit="个" CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsUserAccount"
        IsHoldState="True" SerialText="" AllowPaging="True" AutoGenerateCheckBoxColumn="True"
        DataKeyNames="Id" OnRowCommand="EgvKUserAccount_RowCommand">
        <Columns>
            <pe:TemplateField HeaderText="用户名" SortExpression="UserName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='<%#string.Format("../User/UserShow.aspx?UserName={0}",Server.UrlEncode(Convert.ToString(Eval("UserName")))) %>'>
                        <%#Eval("UserName")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="HolderName" HeaderText="户名" SortExpression="HolderName" />
            <asp:BoundField DataField="Bank" HeaderText="银行" SortExpression="Bank" />
            <asp:BoundField DataField="Account" HeaderText="银行账号" SortExpression="Account" />
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ModifyOwn" runat="server" href='<%#string.Format("Account.aspx?Action=Modify&Id={0}&UserName={1}",Eval("ID"),Eval("UserName")) %>'
                        IsChecked="false">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" CausesValidation="false" CommandArgument='<%# Eval("ID") %>'
                        CommandName="Del" IsChecked="false" OnClientClick="return confirm('确定要删除选中的项目吗？');">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsUserAccount" runat="server" SelectMethod="GetUserAccountInfoList"
        TypeName="PowerEasy.Module.Promotion.BusinessLogic.UserAccount" SelectCountMethod="GetTotalOfUserAccount"
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="keyType" QueryStringField="keyType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyWords" QueryStringField="keyWords"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table border="0" cellpadding="0" cellspacing="1" style="width: 100%; height: 100%;">
        <tr>
            <td>
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />选中本页显示的所有用户
                &nbsp;&nbsp;
                <asp:Button ID="EBtnBatchDelete" Text="批量删除" Width="115" OnClientClick="return batchconfirm('确定要删除选中的项目吗？');"
                    OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
            </td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span><a>删除操作</a> <span class="right-line"></span>
            </dt>
            <dd class="prompt-note-con">
                <p>
                    <li>删除推广用户信息前台推广用户帐户信息变为空白！</li>
                </p>
            </dd>
        </dl>
    </div>
</asp:Content>
