﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="CommissionDetail.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.CommissionDetail"
    Title="佣金明细管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
   <tr>
      <td id="AdminTabs">
         <ul>
            <!-- CSS Tabs -->
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrAll" />>
                <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有状态</span></asp:LinkButton>
            </li>
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrGathered" />> 
                <asp:LinkButton ID="LinkGathered" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>已提现</span></asp:LinkButton>
            </li>
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnGather" />>   
                <asp:LinkButton ID="LinkUnGather" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>未提现</span></asp:LinkButton> 
            </li>
        </ul>
        </td>
    </tr>
</table>
<pe:ExtendedGridView ID="GdvCommissionDetail" runat="server" AutoGenerateColumns="False"
    DataSourceID="OdsCommission" DataKeyNames="OrderId" OnRowDataBound="GdvCommissionDetail_RowDataBound"
    AllowPaging="True" OnDataBound="GdvCommissionDetail_DataBound" ItemName="佣金明细"
    ItemUnit="条" EmptyDataText="没有任何符合条件的佣金明细！" AutoGenerateCheckBoxColumn="False"
    ShowFooter="True" CheckBoxFieldHeaderWidth="3%" SerialText="" >
    <Columns>
        <pe:TemplateField HeaderText="推广人" SortExpression="UserName">
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <a href='<%#string.Format("../User/UserShow.aspx?UserName={0}",Server.UrlEncode(Convert.ToString(Eval("UserName")))) %>'>
                    <%#Eval("UserName")%>
                </a>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="商品名称" SortExpression="OrderNum">
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle Width="15%" />
            <ItemTemplate>
                <asp:HyperLink ID="LnkProductName" runat="server"></asp:HyperLink>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="商品单价" SortExpression="MoneyTotal">
            <ItemStyle HorizontalAlign="Center" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" ID="LblPrice" runat="server" />
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="商品数量" SortExpression="Amount">
            <ItemStyle HorizontalAlign="Center" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" ID="LblAmount" runat="server" />
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="佣金类型" SortExpression="CommissionType">
            <ItemStyle HorizontalAlign="center" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel ID="LblCommissionType" runat="server" Text="" />
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="佣金设置" SortExpression="Commission">
            <ItemStyle HorizontalAlign="center" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel ID="LblRate" runat="server" Text="" />
            </ItemTemplate>
        </pe:TemplateField>   
        <pe:TemplateField HeaderText="获得佣金">
            <ItemStyle HorizontalAlign="Right" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" ID="LblCommission" runat="server" />
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="交易时间">
            <ItemStyle HorizontalAlign="Center" />
            <HeaderStyle Width="15%" />
            <ItemTemplate>
                <%# Eval("CreateTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="佣金状态">
            <ItemStyle HorizontalAlign="Center" />
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" ID="LblStatus" runat="server" />
            </ItemTemplate>
        </pe:TemplateField>
    </Columns>
    <FooterStyle CssClass="tdbg" />
</pe:ExtendedGridView>
<asp:HiddenField ID="HdnCommissionStatus" runat="server" Value="0" />
<asp:ObjectDataSource ID="OdsCommission" runat="server" SelectCountMethod="GetTotalOfCommission"
    SelectMethod="GetCommissionInfoList" TypeName="PowerEasy.Module.Promotion.BusinessLogic.CommissionDetailManage"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
    <SelectParameters>
        <asp:ControlParameter ControlID="HdnCommissionStatus" Type="Int32" Name="commissionStatus"
            PropertyName="Value" />
        <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="ListType"
            Type="String" />
        <asp:QueryStringParameter DefaultValue="" Name="keyWord" QueryStringField="KeyWord"
            Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
</asp:Content>