﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    ValidateRequest="false" CodeBehind="RedirectUrl.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.RedirectUrl.RedirectUrlUI"
    Title="链接操作管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td colspan="2" align="center" class="spacingtitle">
                <asp:Label ID="LabUrl" Text="添加转向链接" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>所属类别：</strong>
            </td>
            <td align="left">
                <asp:DropDownList ID="DdlCategoryID" runat="server" DataTextField="CategoryName"
                    DataValueField="CategoryID" SkinID="CategoryID">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td width="173px" class="tdbgleft">
                <strong>链接ID：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtUrlID" runat="server" Width="255px" MaxLength="255"></asp:TextBox>
                <pe:RequiredFieldValidator ID="RfvUrlID" runat="server" ControlToValidate="TxtUrlID"
                    Display="Dynamic" ErrorMessage="链接ID不能为空！"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="EvUrlID" runat="server" ControlToValidate="TxtUrlID"
                    Display="Dynamic" ErrorMessage="链接ID只能为数字！" ValidationExpression="^[1-9]\d*\.?[0]*$"></asp:RegularExpressionValidator>
                <asp:RangeValidator ID="RvUrlID" ControlToValidate="TxtUrlID" runat="server" Type="Integer" MaximumValue="2147483647" MinimumValue="1" Display="Dynamic" ErrorMessage="链接ID只能在1到2147483647之间"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>链接名称：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtUrlName" runat="server" Width="255px" MaxLength="255"></asp:TextBox>
                <pe:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtUrlName"
                    Display="Dynamic" ErrorMessage="链接名称不能为空！"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>链接URL：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtUrlValue" runat="server" Width="255px" MaxLength="255">http://</asp:TextBox>
                <pe:RequiredFieldValidator ID="RfvUrlValue" runat="server" ControlToValidate="TxtUrlValue"
                    ErrorMessage="链接URL不能为空！" Display="Dynamic"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="RevUrlValue" runat="server" ControlToValidate="TxtUrlValue"
                    Display="Dynamic" ErrorMessage="链接URL不符合！" ValidationExpression="^((https|http|ftp|rtsp|mms)?://)?(([0-9a-zA-Z_!~*'().&=+$%-]+: )?[0-9a-zA-Z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-zA-Z_!~*'()-]+\.)*([0-9a-zA-Z][0-9a-z-]{0,61})?[0-9a-zA-Z]\.[a-zA-Z]{2,6}|([0-9a-zA-Z-]{0,61}))(:[0-9]{1,4})?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>链接描述：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtUrlDescription" runat="server" Height="90px" TextMode="MultiLine"
                    Width="297px"></asp:TextBox>
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td style="height: 30px;" colspan="2">
                <asp:Button ID="BtnConfirm" runat="server" Text="确定" OnClick="BtnConfirm_Click" />&nbsp;&nbsp;
                <asp:Button ID="BtnReturn" runat="server" Text="返回" OnClick="BtnReturn_Click" CausesValidation="False" />
            </td>
        </tr>
        <asp:HiddenField ID="HdnUrlID" runat="server" />
    </table>
</asp:Content>
