﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.User.PointLog"
    MasterPageFile="~/Admin/MasterPage.master" Title="点券管理" Codebehind="PointLog.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul> 
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="-1" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitIn" />>    
                       <asp:LinkButton ID="LinkIn" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>收入</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitOut" />>    
                       <asp:LinkButton ID="LinkOut" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>支出</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvUserPoint" runat="server" AllowPaging="True" AutoGenerateColumns="False"
    DataKeyNames="LogId" DataSourceID="OdsUserPoint" ShowFooter="True" ItemName="记录"
    ItemUnit="条" OnRowDataBound="EgvUserPoint_RowDataBound" OnDataBound="EgvUserPoint_DataBound">
    <Columns>
        <pe:BoundField DataField="LogTime" HeaderText="消费时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
            SortExpression="LogTime" HtmlEncode="False">
            <HeaderStyle Width="17%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="用户名" SortExpression="IncomePayOut">
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <asp:HyperLink runat="server" ID="HypUserName"></asp:HyperLink>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="IP" HeaderText="IP地址" SortExpression="IP">
            <HeaderStyle Width="13%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="点券数" SortExpression="IncomePayOut">
            <HeaderStyle Width="6%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblIncomePayOut">
                </pe:ExtendedLabel>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="Times" HeaderText="重复次数" SortExpression="Times">
            <HeaderStyle Width="8%" />
        </pe:BoundField>
        <pe:BoundField DataField="Inputer" HeaderText="操作员" SortExpression="Inputer" >
            <HeaderStyle Width="10%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="备注/说明">
            <ItemStyle HorizontalAlign="Left" />
            <ItemTemplate>
                <%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Remark").ToString(), 30, "...")%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="操作" HeaderStyle-Width="5%" Visible="true">
            <ItemTemplate>
                <a href='<%#string.Format("PointLogDetail.aspx?LogID={0}",Eval("LogId"))%>'>查看</a>
            </ItemTemplate>
        </pe:TemplateField>
    </Columns>
</pe:ExtendedGridView>
<asp:HiddenField ID="HdnSearchType" runat="server" />
<asp:HiddenField ID="HdnField" runat="server" />
<asp:HiddenField ID="HdnKeyword" runat="server" />
<asp:HiddenField ID="HdnType" runat="server" />
<asp:ObjectDataSource ID="OdsUserPoint" runat="server" SelectMethod="GetPointList"
    SelectCountMethod="GetNumberOfPointList" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserPointLog"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:ControlParameter ControlID="HdnSearchType" DefaultValue="-1" Name="scopesType"
            Type="Int32" />
        <asp:ControlParameter ControlID="HdnField" DefaultValue="0" Name="field" Type="Int32" />
        <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" Type="String" />
        <asp:ControlParameter ControlID="HdnType" DefaultValue="-1" Name="type" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>

    <br />
    <table width="100%" cellpadding="5" cellspacing="0" class="border">
        <tr class="tdbg">
            <td align="right" style="width: 10%;">
                时间范围：</td>
            <td align="left" style="width: 55%;">
                <asp:RadioButtonList ID="RadlDatepartType" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    <asp:ListItem Value="0" Selected="True">10天前</asp:ListItem>
                    <asp:ListItem Value="1">1个月前</asp:ListItem>
                    <asp:ListItem Value="2">2个月前</asp:ListItem>
                    <asp:ListItem Value="3">3个月前</asp:ListItem>
                    <asp:ListItem Value="4">6个月前</asp:ListItem>
                    <asp:ListItem Value="5">1年前</asp:ListItem>
                </asp:RadioButtonList>
                <span>&nbsp;<asp:CheckBox runat="server" ID="cbIsDelConsumeLog" Text="删除消费记录" /></span>
            </td>
            <td align="left">
                <asp:Button ID="BtnDelete" runat="server" OnClientClick="return confirm('确实要删除有关记录吗？一旦删除这些记录，会出现会员查看原来已经付过费的收费信息时重复收费等问题。请慎重！')"
                    Text="删除" OnClick="BtnDelete_Click" CausesValidation="False" /></td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        </dt>
            <dd class="prompt-note-con">
              如果<pe:ShowPointName ID="ShowPointName" runat="server" />明细记录太多，影响了系统性能，可以删除一定时间段前的记录以加快速度。但可能会带来会员在查看以前收过费的信息时重复收费（这样会引发众多消费纠纷问题），无法通过<pe:ShowPointName ID="ShowPointName1" runat="server" />明细记录来真实分析会员的消费习惯等问题。
            </dd>  
        </dl>
    </div>
</asp:Content>
