﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="RoleManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.RoleManage"
    Title="角色管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="Egv" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        OnRowCommand="EgvUserRole_RowCommand" DataKeyNames="RoleId" CheckBoxFieldHeaderWidth="3%"
        DataSourceID="ObjectDataSource1" SerialText="" OnRowDataBound="Egv_RowDataBound"
        RowDblclickBoundField="RoleId" RowDblclickUrl="Role.aspx?Action=Modify&amp;RoleId={$Field}">
        <Columns>
            <pe:BoundField DataField="RoleId" HeaderText="ID" HeaderStyle-Width="4%" />
            <pe:BoundField DataField="RoleName" HeaderText="角色名" HeaderStyle-Width="15%" />
            <pe:TemplateField HeaderText="成员个数">
                <ItemStyle HorizontalAlign="center" />
                <ItemTemplate>
                    <%#GetAdminInfoCount(Convert.ToInt32(Eval("RoleId")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="描述">
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Description").ToString(), 53, "...")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="管理操作">
                <HeaderStyle Width="16%" />
                <ItemTemplate>
                    <a href="RoleMember.aspx?RoleId=<%# Eval("RoleId")%>&RoleName=<%#Server.UrlEncode(Eval("RoleName").ToString())%>">
                        成员管理</a>
                    <asp:LinkButton ID="LnkModify" CommandName="ModifyRole" CommandArgument='<%# Eval("RoleId")%>'
                        runat="server">修改</asp:LinkButton>
                    <asp:LinkButton ID="LnkDelete" CommandName="DeleteRole" OnClientClick="if(!this.disabled) return confirm('确实要删除此角色吗？');"
                        CommandArgument='<%# Eval("RoleId")%>' runat="server">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="权限设置">
                <HeaderStyle Width="22%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LnkModifyCommonPermissions" CommandName="CommonPermissions" CommandArgument='<%# Eval("RoleId")%>'
                        runat="server">常规权限</asp:LinkButton>
                    <asp:LinkButton ID="LnkModifyFieldPermissions" CommandName="FieldPermissions" CommandArgument='<%# Eval("RoleId")%>'
                        runat="server">字段权限</asp:LinkButton>
                    <asp:HyperLink ID="HypScopePermissions" runat="server" Text="操作范围"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetRoleList" SelectCountMethod="GetTotalOfRoles"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows"
        TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserRole">
    </asp:ObjectDataSource>
    <pe:FloatDivDialog ID="FDScopeSetting" runat="server" EnableViewState="false" Width="700"
        Height="400" IsGetContainerID="true">
    </pe:FloatDivDialog>
    <script type="text/javascript">
        function ShowOperateSetting(roleId){
            var title="标题：操作范围设置";
            var link = "RoleScopePermissions.aspx?Type=All&RoleId=" + roleId;
            jQuery('.title').html(title);
            jQuery('#<%=FDScopeSetting.ClientID %>' + '__HdnLoadUrl').prop('value', link);
            jQuery('#<%=FDScopeSetting.ClientID %>' + '__LitID').click();
        }
    </script>
</asp:Content>
