﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Vote.VoteManage" Title="投票管理" CodeBehind="VoteManage.aspx.cs" %>
    
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server"> 
    <script language="javascript" src="<%=BasePath%>JS/jquery.pack.js" type="text/javascript"></script> 
    <asp:ScriptManager ID="ScriptManager1" EnablePartialRendering="true" runat="server">
    </asp:ScriptManager> 
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
   <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
      <tr>
        <td id="AdminTabs">
            <ul>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteAllSale" />>
                    <asp:LinkButton ID="LinkAllSale" runat="server"   CommandArgument="99"
                        onclick="ShowBookmarks"><span>所有投票</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteDisSale" />> 
                    <asp:LinkButton ID="LinkRunSale" runat="server"  CommandArgument="0"
                        onclick="ShowBookmarks"><span>未启用的投票</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteRunSale" />>    
                    <asp:LinkButton ID="LinkDisSale" runat="server" CommandArgument="1"
                        onclick="ShowBookmarks"><span>已启用的投票</span></asp:LinkButton> 
                </li>
            </ul>
          </td>
          <td align="right">
          </td>
      </tr>
    </table>
     <pe:ExtendedGridView ID="EgvVote" runat="server" AutoGenerateCheckBoxColumn="True"
        ItemName="投票" ItemUnit="个" AutoGenerateColumns="False"
        DataKeyNames="Id" AllowPaging="True" DataSourceID="OdsVote" RowDblclickBoundField="Id"
        RowDblclickUrl="Vote.aspx?Action=Modify&amp;Id={$Field}" CheckBoxFieldHeaderWidth="3%"
        IsHoldState="True" SerialText="" OnRowDataBound="EgvVote_RowDataBound">
        <Columns>
             <pe:TemplateField HeaderText="操作">
                <ItemTemplate>     
                    <pe:DropdownMenu runat="server" ID="ddmenu">
                        <pe:LinkMenuItem ID="EahModify" runat="server" Text="修改" />
                        <pe:LinkMenuItem ID="EahDisabled" runat="server" Text="禁用" />
                        <pe:LinkMenuItem ID="EahEnabled" runat="server" Text="启用" />
                        <pe:LinkMenuItem ID="EahDelete" SkinID="Delete" runat="server" OnClientClick="return confirm('是否删除该投票？');"/>
                        <pe:LinkMenuItem ID="EahShow" runat="server" Text="查看投票" />
                    </pe:DropdownMenu>
                </ItemTemplate>
                <HeaderStyle Width="3%" />
            </pe:TemplateField>
            <asp:BoundField DataField="Id" HeaderText="ID" SortExpression="ShortedForm">
                <HeaderStyle Width="3%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="投票主题">
                <ItemTemplate>
                    <a id="VoteShow" href='VoteShow.aspx?ID=<%# Eval("Id") %>' ><%#Eval("Title")%></a>
                </ItemTemplate>
                <HeaderStyle Width="16%" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="投票限制">
                <ItemTemplate>
                    <pe:ExtendedLabel ID="LblVoteLimit" HtmlEncode="false" runat="server" Text=""></pe:ExtendedLabel>
                </ItemTemplate>
                <HeaderStyle Width="8%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="截止日期">
                <ItemTemplate>
                    <%#string.Format("{0:yyyy-MM-dd}", Eval("EndTime"))%>
                </ItemTemplate>
                <HeaderStyle Width="5%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="状态">
                <ItemTemplate>
                   <%# (int)Eval("State") == 1 ? "<b><span style='color:Green'>已启用</b></span>" : "<b><span style='color:red'>已禁用</span></b>"%>
                </ItemTemplate>
                <HeaderStyle Width="5%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="调用标签">
                <ItemTemplate>
                    <textarea rows='1' cols='20' readonly='readonly' class='inputtext' onclick="setCopy(this,<%# Eval("Id") %>)"  style='height:18px;width:98%;'>{PE.Label id="投票表单" VoteId="<%# Eval("Id") %>" /}</textarea>
                </ItemTemplate>
                <HeaderStyle Width="19%" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnStatus" runat="server" Value ="99" />
    <asp:ObjectDataSource ID="OdsVote" runat="server" SelectCountMethod="GetTotalOfVote"
        SelectMethod="GetVoteList" TypeName="PowerEasy.Module.General.BusinessLogic.Vote.Vote"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>         
            <asp:ControlParameter Name="state" ControlID="HdnStatus" Type="Int32"  PropertyName="Value" />
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
        for="ChkAll">选中本页显示的所有投票</label>
    &nbsp;&nbsp;
    <pe:ExtendedButton ID="BtnDelete" IsChecked="false" runat="server" OperateCode="Vote"
        OnClientClick="return batchconfirm('是否要删除选中的记录？')" Text="删除选中的投票" OnClick="BtnDelete_Click" />       
    &nbsp;&nbsp;
    <pe:ExtendedButton ID="BtnRunVote" IsChecked="false" runat="server" OperateCode="Vote" Text="启用选中的投票" OnClick="BtnRunVote_Click" />
    &nbsp;&nbsp;
    <pe:ExtendedButton ID="BtnDisVote" IsChecked="false" runat="server" OperateCode="Vote" Text="禁用选中的投票" OnClick="BtnDisVote_Click" />
        <br />
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span></dt>
            <dd class="prompt-note-con">
                <p>
                    说明：您可以点击“调用标签”文本框系统将投票调用代码复制到Windows剪贴板中，然后在模板中想要调用的位置直接粘贴即可插入相应的投票表单。
                </p>
            </dd>
            <div class="clearbox">
            </div>
        </dl>
    </div>
    <script language="javascript" type="text/javascript">
        function setCopy(voteItem,id) {
          voteItem.select();
          var txt = "{PE.Label id=\"投票表单\" VoteId=\"" + id + "\" /}";
          var isok = false;
          if (window.clipboardData) {
              window.clipboardData.clearData();
              window.clipboardData.setData("Text", txt);
              isok = true;
          } else if (navigator.userAgent.indexOf("Opera") != -1) {
              window.location = txt;
              isok = true;
          } else if (window.netscape) {
              try {
                  netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
              } catch (e) {
                  alert("被浏览器拒绝！\n请在浏览器地址栏输入'about:config'并回车\n然后将'signed.applets.codebase_principal_support'设置为'true'");
              }
              var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
              if (!clip)
                  return;
              var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
              if (!trans)
                  return;
              trans.addDataFlavor('text/unicode');
              var str = new Object();
              var len = new Object();
              var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
              var copytext = txt;
              str.data = copytext;
              trans.setTransferData("text/unicode", str, copytext.length * 2);
              var clipid = Components.interfaces.nsIClipboard;
              if (!clip)
                  return false;
              clip.setData(trans, null, clipid.kGlobalClipboard);
              isok = true;
          }
          if (isok) {
              alert("复制标签成功！")
          }
       }
    </script>
</asp:Content>

